/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class WindowsGraphicsUtilsPort {
    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n) {
        FontMetrics fontMetrics = JideSwingUtilities.getFontMetrics(abstractButton, graphics);
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (SystemInfo.isMnemonicHidden()) {
            n2 = -1;
        }
        WindowsGraphicsUtilsPort.paintClassicText(abstractButton, graphics, rectangle.x + n, rectangle.y + fontMetrics.getAscent() + n, string, n2);
    }

    static void paintClassicText(AbstractButton abstractButton, Graphics graphics, int n, int n2, String string, int n3) {
        ButtonModel buttonModel = abstractButton.getModel();
        Color color = abstractButton.getForeground();
        if (buttonModel.isEnabled()) {
            if (!(abstractButton instanceof JMenuItem && buttonModel.isArmed() || abstractButton instanceof JMenu && (buttonModel.isSelected() || buttonModel.isRollover()))) {
                graphics.setColor(abstractButton.getForeground());
            }
            JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n, n2);
        } else {
            color = WindowsGraphicsUtilsPort.getDisabledTextColor(abstractButton);
            if (color == null) {
                color = UIManager.getColor("Button.shadow");
            }
            Color color2 = UIManager.getColor("Button.disabledShadow");
            if (buttonModel.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (color2 == null) {
                    color2 = abstractButton.getBackground().darker();
                }
                graphics.setColor(color2);
                JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n + 1, n2 + 1);
            }
            if (color == null) {
                color = abstractButton.getBackground().brighter();
            }
            graphics.setColor(color);
            JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n, n2);
        }
    }

    private static Color getDisabledTextColor(AbstractButton abstractButton) {
        if (abstractButton instanceof JCheckBox) {
            return UIManager.getColor("CheckBox.disabledText");
        }
        if (abstractButton instanceof JRadioButton) {
            return UIManager.getColor("RadioButton.disabledText");
        }
        if (abstractButton instanceof JToggleButton) {
            return UIManager.getColor("ToggleButton.disabledText");
        }
        if (abstractButton instanceof JButton) {
            return UIManager.getColor("Button.disabledText");
        }
        return null;
    }
}

