﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/simspaceweaver/SimSpaceWeaver_EXPORTS.h>
#include <aws/simspaceweaver/SimSpaceWeaverRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Http
{
    class URI;
} //namespace Http
namespace SimSpaceWeaver
{
namespace Model
{

  /**
   */
  class ListAppsRequest : public SimSpaceWeaverRequest
  {
  public:
    AWS_SIMSPACEWEAVER_API ListAppsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "ListApps"; }

    AWS_SIMSPACEWEAVER_API Aws::String SerializePayload() const override;

    AWS_SIMSPACEWEAVER_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;


    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline const Aws::String& GetDomain() const{ return m_domain; }

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline bool DomainHasBeenSet() const { return m_domainHasBeenSet; }

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline void SetDomain(const Aws::String& value) { m_domainHasBeenSet = true; m_domain = value; }

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline void SetDomain(Aws::String&& value) { m_domainHasBeenSet = true; m_domain = std::move(value); }

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline void SetDomain(const char* value) { m_domainHasBeenSet = true; m_domain.assign(value); }

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithDomain(const Aws::String& value) { SetDomain(value); return *this;}

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithDomain(Aws::String&& value) { SetDomain(std::move(value)); return *this;}

    /**
     * <p>The name of the domain that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithDomain(const char* value) { SetDomain(value); return *this;}


    /**
     * <p>The maximum number of apps to list.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }

    /**
     * <p>The maximum number of apps to list.</p>
     */
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }

    /**
     * <p>The maximum number of apps to list.</p>
     */
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }

    /**
     * <p>The maximum number of apps to list.</p>
     */
    inline ListAppsRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}


    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline ListAppsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline ListAppsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>If SimSpace Weaver returns <code>nextToken</code>, then there are more
     * results available. The value of <code>nextToken</code> is a unique pagination
     * token for each page. To retrieve the next page, call the operation again using
     * the returned token. Keep all other arguments unchanged. If no results remain,
     * then <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an <i>HTTP 400 ValidationException</i> error.</p>
     */
    inline ListAppsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline const Aws::String& GetSimulation() const{ return m_simulation; }

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline bool SimulationHasBeenSet() const { return m_simulationHasBeenSet; }

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline void SetSimulation(const Aws::String& value) { m_simulationHasBeenSet = true; m_simulation = value; }

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline void SetSimulation(Aws::String&& value) { m_simulationHasBeenSet = true; m_simulation = std::move(value); }

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline void SetSimulation(const char* value) { m_simulationHasBeenSet = true; m_simulation.assign(value); }

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithSimulation(const Aws::String& value) { SetSimulation(value); return *this;}

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithSimulation(Aws::String&& value) { SetSimulation(std::move(value)); return *this;}

    /**
     * <p>The name of the simulation that you want to list apps for.</p>
     */
    inline ListAppsRequest& WithSimulation(const char* value) { SetSimulation(value); return *this;}

  private:

    Aws::String m_domain;
    bool m_domainHasBeenSet = false;

    int m_maxResults;
    bool m_maxResultsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_simulation;
    bool m_simulationHasBeenSet = false;
  };

} // namespace Model
} // namespace SimSpaceWeaver
} // namespace Aws
