﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeguru-security/CodeGuruSecurity_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodeGuruSecurity
{
namespace Model
{

  /**
   * <p>Information about a scan with open findings.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ScanNameWithFindingNum">AWS
   * API Reference</a></p>
   */
  class ScanNameWithFindingNum
  {
  public:
    AWS_CODEGURUSECURITY_API ScanNameWithFindingNum();
    AWS_CODEGURUSECURITY_API ScanNameWithFindingNum(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API ScanNameWithFindingNum& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The number of open findings generated by a scan.</p>
     */
    inline int GetFindingNumber() const{ return m_findingNumber; }

    /**
     * <p>The number of open findings generated by a scan.</p>
     */
    inline bool FindingNumberHasBeenSet() const { return m_findingNumberHasBeenSet; }

    /**
     * <p>The number of open findings generated by a scan.</p>
     */
    inline void SetFindingNumber(int value) { m_findingNumberHasBeenSet = true; m_findingNumber = value; }

    /**
     * <p>The number of open findings generated by a scan.</p>
     */
    inline ScanNameWithFindingNum& WithFindingNumber(int value) { SetFindingNumber(value); return *this;}


    /**
     * <p>The name of the scan.</p>
     */
    inline const Aws::String& GetScanName() const{ return m_scanName; }

    /**
     * <p>The name of the scan.</p>
     */
    inline bool ScanNameHasBeenSet() const { return m_scanNameHasBeenSet; }

    /**
     * <p>The name of the scan.</p>
     */
    inline void SetScanName(const Aws::String& value) { m_scanNameHasBeenSet = true; m_scanName = value; }

    /**
     * <p>The name of the scan.</p>
     */
    inline void SetScanName(Aws::String&& value) { m_scanNameHasBeenSet = true; m_scanName = std::move(value); }

    /**
     * <p>The name of the scan.</p>
     */
    inline void SetScanName(const char* value) { m_scanNameHasBeenSet = true; m_scanName.assign(value); }

    /**
     * <p>The name of the scan.</p>
     */
    inline ScanNameWithFindingNum& WithScanName(const Aws::String& value) { SetScanName(value); return *this;}

    /**
     * <p>The name of the scan.</p>
     */
    inline ScanNameWithFindingNum& WithScanName(Aws::String&& value) { SetScanName(std::move(value)); return *this;}

    /**
     * <p>The name of the scan.</p>
     */
    inline ScanNameWithFindingNum& WithScanName(const char* value) { SetScanName(value); return *this;}

  private:

    int m_findingNumber;
    bool m_findingNumberHasBeenSet = false;

    Aws::String m_scanName;
    bool m_scanNameHasBeenSet = false;
  };

} // namespace Model
} // namespace CodeGuruSecurity
} // namespace Aws
