/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPlaybackDirection.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PlaybackDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("normal"),
        MAKE_STATIC_STRING_IMPL("reverse"),
        MAKE_STATIC_STRING_IMPL("alternate"),
        MAKE_STATIC_STRING_IMPL("alternate-reverse"),
    };
    static_assert(static_cast<size_t>(PlaybackDirection::Normal) == 0, "PlaybackDirection::Normal is not 0 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::Reverse) == 1, "PlaybackDirection::Reverse is not 1 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::Alternate) == 2, "PlaybackDirection::Alternate is not 2 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::AlternateReverse) == 3, "PlaybackDirection::AlternateReverse is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, PlaybackDirection enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<PlaybackDirection> parseEnumerationFromString<PlaybackDirection>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, PlaybackDirection> mappings[] = {
        { "alternate", PlaybackDirection::Alternate },
        { "alternate-reverse", PlaybackDirection::AlternateReverse },
        { "normal", PlaybackDirection::Normal },
        { "reverse", PlaybackDirection::Reverse },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<PlaybackDirection> parseEnumeration<PlaybackDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<PlaybackDirection>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<PlaybackDirection>()
{
    return "\"normal\", \"reverse\", \"alternate\", \"alternate-reverse\"";
}

} // namespace WebCore
