/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUExtent3DDict.h"
#include "JSGPUTextureDimension.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPUTextureDescriptor convertDictionary<GPUTextureDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUTextureDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dimensionValue;
    if (isNullOrUndefined)
        dimensionValue = jsUndefined();
    else {
        dimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dimension"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dimensionValue.isUndefined()) {
        result.dimension = convert<IDLEnumeration<GPUTextureDimension>>(lexicalGlobalObject, dimensionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dimension = GPUTextureDimension::_2d;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUTextureDescriptor", "GPUTextureFormat");
        return { };
    }
    JSValue mipLevelCountValue;
    if (isNullOrUndefined)
        mipLevelCountValue = jsUndefined();
    else {
        mipLevelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipLevelCountValue.isUndefined()) {
        result.mipLevelCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipLevelCount = 1;
    JSValue sampleCountValue;
    if (isNullOrUndefined)
        sampleCountValue = jsUndefined();
    else {
        sampleCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleCountValue.isUndefined()) {
        result.sampleCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleCount = 1;
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sizeValue.isUndefined()) {
        result.size = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUExtent3DDict>>>(lexicalGlobalObject, sizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "size", "GPUTextureDescriptor", "(sequence or GPUExtent3DDict)");
        return { };
    }
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usageValue.isUndefined()) {
        result.usage = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, usageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "usage", "GPUTextureDescriptor", "unsigned long");
        return { };
    }
    JSValue viewFormatsValue;
    if (isNullOrUndefined)
        viewFormatsValue = jsUndefined();
    else {
        viewFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewFormatsValue.isUndefined()) {
        result.viewFormats = convert<IDLSequence<IDLEnumeration<GPUTextureFormat>>>(lexicalGlobalObject, viewFormatsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.viewFormats = Converter<IDLSequence<IDLEnumeration<GPUTextureFormat>>>::ReturnType{ };
    return result;
}

} // namespace WebCore
