/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBlendComponent.h"

#include "JSDOMConvertEnumeration.h"
#include "JSGPUBlendFactor.h"
#include "JSGPUBlendOperation.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUBlendComponent convertDictionary<GPUBlendComponent>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBlendComponent result;
    JSValue dstFactorValue;
    if (isNullOrUndefined)
        dstFactorValue = jsUndefined();
    else {
        dstFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dstFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dstFactorValue.isUndefined()) {
        result.dstFactor = convert<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, dstFactorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dstFactor = GPUBlendFactor::Zero;
    JSValue operationValue;
    if (isNullOrUndefined)
        operationValue = jsUndefined();
    else {
        operationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "operation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!operationValue.isUndefined()) {
        result.operation = convert<IDLEnumeration<GPUBlendOperation>>(lexicalGlobalObject, operationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.operation = GPUBlendOperation::Add;
    JSValue srcFactorValue;
    if (isNullOrUndefined)
        srcFactorValue = jsUndefined();
    else {
        srcFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "srcFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!srcFactorValue.isUndefined()) {
        result.srcFactor = convert<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, srcFactorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.srcFactor = GPUBlendFactor::One;
    return result;
}

} // namespace WebCore
