/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestDestination.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequestDestination enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("audio"),
        MAKE_STATIC_STRING_IMPL("audioworklet"),
        MAKE_STATIC_STRING_IMPL("document"),
        MAKE_STATIC_STRING_IMPL("embed"),
        MAKE_STATIC_STRING_IMPL("font"),
        MAKE_STATIC_STRING_IMPL("image"),
        MAKE_STATIC_STRING_IMPL("iframe"),
        MAKE_STATIC_STRING_IMPL("manifest"),
        MAKE_STATIC_STRING_IMPL("model"),
        MAKE_STATIC_STRING_IMPL("object"),
        MAKE_STATIC_STRING_IMPL("paintworklet"),
        MAKE_STATIC_STRING_IMPL("report"),
        MAKE_STATIC_STRING_IMPL("script"),
        MAKE_STATIC_STRING_IMPL("serviceworker"),
        MAKE_STATIC_STRING_IMPL("sharedworker"),
        MAKE_STATIC_STRING_IMPL("style"),
        MAKE_STATIC_STRING_IMPL("track"),
        MAKE_STATIC_STRING_IMPL("video"),
        MAKE_STATIC_STRING_IMPL("worker"),
        MAKE_STATIC_STRING_IMPL("xslt"),
    };
    static_assert(static_cast<size_t>(FetchRequestDestination::EmptyString) == 0, "FetchRequestDestination::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Audio) == 1, "FetchRequestDestination::Audio is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Audioworklet) == 2, "FetchRequestDestination::Audioworklet is not 2 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Document) == 3, "FetchRequestDestination::Document is not 3 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Embed) == 4, "FetchRequestDestination::Embed is not 4 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Font) == 5, "FetchRequestDestination::Font is not 5 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Image) == 6, "FetchRequestDestination::Image is not 6 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Iframe) == 7, "FetchRequestDestination::Iframe is not 7 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Manifest) == 8, "FetchRequestDestination::Manifest is not 8 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Model) == 9, "FetchRequestDestination::Model is not 9 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Object) == 10, "FetchRequestDestination::Object is not 10 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Paintworklet) == 11, "FetchRequestDestination::Paintworklet is not 11 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Report) == 12, "FetchRequestDestination::Report is not 12 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Script) == 13, "FetchRequestDestination::Script is not 13 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Serviceworker) == 14, "FetchRequestDestination::Serviceworker is not 14 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Sharedworker) == 15, "FetchRequestDestination::Sharedworker is not 15 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Style) == 16, "FetchRequestDestination::Style is not 16 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Track) == 17, "FetchRequestDestination::Track is not 17 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Video) == 18, "FetchRequestDestination::Video is not 18 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Worker) == 19, "FetchRequestDestination::Worker is not 19 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Xslt) == 20, "FetchRequestDestination::Xslt is not 20 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FetchRequestDestination enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FetchRequestDestination> parseEnumerationFromString<FetchRequestDestination>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return FetchRequestDestination::EmptyString;
    static constexpr std::pair<ComparableASCIILiteral, FetchRequestDestination> mappings[] = {
        { "audio", FetchRequestDestination::Audio },
        { "audioworklet", FetchRequestDestination::Audioworklet },
        { "document", FetchRequestDestination::Document },
        { "embed", FetchRequestDestination::Embed },
        { "font", FetchRequestDestination::Font },
        { "iframe", FetchRequestDestination::Iframe },
        { "image", FetchRequestDestination::Image },
        { "manifest", FetchRequestDestination::Manifest },
        { "model", FetchRequestDestination::Model },
        { "object", FetchRequestDestination::Object },
        { "paintworklet", FetchRequestDestination::Paintworklet },
        { "report", FetchRequestDestination::Report },
        { "script", FetchRequestDestination::Script },
        { "serviceworker", FetchRequestDestination::Serviceworker },
        { "sharedworker", FetchRequestDestination::Sharedworker },
        { "style", FetchRequestDestination::Style },
        { "track", FetchRequestDestination::Track },
        { "video", FetchRequestDestination::Video },
        { "worker", FetchRequestDestination::Worker },
        { "xslt", FetchRequestDestination::Xslt },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FetchRequestDestination> parseEnumeration<FetchRequestDestination>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FetchRequestDestination>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<FetchRequestDestination>()
{
    return "\"\", \"audio\", \"audioworklet\", \"document\", \"embed\", \"font\", \"image\", \"iframe\", \"manifest\", \"model\", \"object\", \"paintworklet\", \"report\", \"script\", \"serviceworker\", \"sharedworker\", \"style\", \"track\", \"video\", \"worker\", \"xslt\"";
}

} // namespace WebCore
