/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCookieStoreDeleteOptions.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> CookieStoreDeleteOptions convertDictionary<CookieStoreDeleteOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CookieStoreDeleteOptions result;
    JSValue domainValue;
    if (isNullOrUndefined)
        domainValue = jsUndefined();
    else {
        domainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "domain"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!domainValue.isUndefined()) {
        result.domain = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, domainValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.domain = String();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLUSVString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "CookieStoreDeleteOptions", "USVString");
        return { };
    }
    JSValue pathValue;
    if (isNullOrUndefined)
        pathValue = jsUndefined();
    else {
        pathValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "path"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pathValue.isUndefined()) {
        result.path = convert<IDLUSVString>(lexicalGlobalObject, pathValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.path = "/"_s;
    return result;
}

} // namespace WebCore
