/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.feature.LockableFeatureMap;
import com.hankcs.hanlp.model.perceptron.model.AveragedPerceptron;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class PerceptronClassifier {
    LinearModel model;

    public PerceptronClassifier() {
    }

    public PerceptronClassifier(LinearModel model) {
        if (model != null && model.taskType() != TaskType.CLASSIFICATION) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u6a21\u578b\u5e76\u975e\u5206\u7c7b\u6a21\u578b");
        }
        this.model = model;
    }

    public PerceptronClassifier(String modelPath) throws IOException {
        this(new LinearModel(modelPath));
    }

    private static LinearModel trainNaivePerceptron(Instance[] instanceList, FeatureMap featureMap, int maxIteration) {
        LinearModel model = new LinearModel(featureMap, new float[featureMap.size()]);
        for (int it = 0; it < maxIteration; ++it) {
            Utility.shuffleArray(instanceList);
            for (Instance instance : instanceList) {
                int y = model.decode(instance.x);
                if (y == instance.y) continue;
                model.update(instance.x, instance.y);
            }
        }
        return model;
    }

    private static LinearModel trainAveragedPerceptron(Instance[] instanceList, FeatureMap featureMap, int maxIteration) {
        float[] parameter = new float[featureMap.size()];
        double[] sum = new double[featureMap.size()];
        int[] time = new int[featureMap.size()];
        AveragedPerceptron model = new AveragedPerceptron(featureMap, parameter);
        int t = 0;
        for (int it = 0; it < maxIteration; ++it) {
            Utility.shuffleArray(instanceList);
            for (Instance instance : instanceList) {
                ++t;
                int y = model.decode(instance.x);
                if (y == instance.y) continue;
                model.update(instance.x, (float)instance.y, sum, time, t);
            }
        }
        model.average(sum, time, t);
        return model;
    }

    public BinaryClassificationFMeasure train(String corpus, int maxIteration) {
        return this.train(corpus, maxIteration, true);
    }

    public BinaryClassificationFMeasure train(String corpus, int maxIteration, boolean averagePerceptron) {
        LockableFeatureMap featureMap = new LockableFeatureMap(new TagSet(TaskType.CLASSIFICATION));
        featureMap.mutable = true;
        Instance[] instanceList = this.readInstance(corpus, featureMap);
        this.model = averagePerceptron ? PerceptronClassifier.trainAveragedPerceptron(instanceList, featureMap, maxIteration) : PerceptronClassifier.trainNaivePerceptron(instanceList, featureMap, maxIteration);
        featureMap.mutable = false;
        return this.evaluate(instanceList);
    }

    public String predict(String text) {
        int y = this.model.decode(this.extractFeature(text, this.model.featureMap));
        if (y == -1) {
            y = 0;
        }
        return this.model.tagSet().stringOf(y);
    }

    public BinaryClassificationFMeasure evaluate(String corpus) {
        Instance[] instanceList = this.readInstance(corpus, this.model.featureMap);
        return this.evaluate(instanceList);
    }

    public BinaryClassificationFMeasure evaluate(Instance[] instanceList) {
        int TP = 0;
        int FP = 0;
        int FN = 0;
        for (Instance instance : instanceList) {
            int y = this.model.decode(instance.x);
            if (y == 1) {
                if (instance.y == 1) {
                    ++TP;
                    continue;
                }
                ++FP;
                continue;
            }
            if (instance.y != 1) continue;
            ++FN;
        }
        float p = (float)TP / (float)(TP + FP) * 100.0f;
        float r = (float)TP / (float)(TP + FN) * 100.0f;
        return new BinaryClassificationFMeasure(p, r, 2.0f * p * r / (p + r));
    }

    private Instance[] readInstance(String corpus, FeatureMap featureMap) {
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(corpus);
        LinkedList<Instance> instanceList = new LinkedList<Instance>();
        for (String line : lineIterator) {
            String[] cells = line.split(",");
            String text = cells[0];
            String label = cells[1];
            List<Integer> x = this.extractFeature(text, featureMap);
            int y = featureMap.tagSet.add(label);
            if (y == 0) {
                y = -1;
            } else if (y > 1) {
                throw new IllegalArgumentException("\u7c7b\u522b\u6570\u5927\u4e8e2\uff0c\u76ee\u524d\u53ea\u652f\u6301\u4e8c\u5206\u7c7b\u3002");
            }
            instanceList.add(new Instance(x, y));
        }
        return instanceList.toArray(new Instance[0]);
    }

    protected abstract List<Integer> extractFeature(String var1, FeatureMap var2);

    protected static void addFeature(String feature, FeatureMap featureMap, List<Integer> featureList) {
        int featureId = featureMap.idOf(feature);
        if (featureId != -1) {
            featureList.add(featureId);
        }
    }

    public LinearModel getModel() {
        return this.model;
    }

    static class BinaryClassificationFMeasure {
        float P;
        float R;
        float F1;

        public BinaryClassificationFMeasure(float p, float r, float f1) {
            this.P = p;
            this.R = r;
            this.F1 = f1;
        }

        public String toString() {
            return String.format("P=%.2f R=%.2f F1=%.2f", Float.valueOf(this.P), Float.valueOf(this.R), Float.valueOf(this.F1));
        }
    }

    static class Instance {
        List<Integer> x;
        int y;

        public Instance(List<Integer> x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

