/*
 * Copyright (c) 2020, Andreas Kling <kling@serenityos.org>
 *
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <AK/StringView.h>
#include <LibWeb/HTML/Parser/Entities.h>

namespace Web {
namespace HTML {

Optional<EntityMatch> code_points_from_entity(StringView entity)
{
    constexpr struct {
        StringView entity;
        u32 code_point;
    } single_code_point_entities[] = {
        { "AElig;"sv, 0x000C6 },
        { "AElig"sv, 0x000C6 },
        { "AMP;"sv, 0x00026 },
        { "AMP"sv, 0x00026 },
        { "Aacute;"sv, 0x000C1 },
        { "Aacute"sv, 0x000C1 },
        { "Abreve;"sv, 0x00102 },
        { "Acirc;"sv, 0x000C2 },
        { "Acirc"sv, 0x000C2 },
        { "Acy;"sv, 0x00410 },
        { "Afr;"sv, 0x1D504 },
        { "Agrave;"sv, 0x000C0 },
        { "Agrave"sv, 0x000C0 },
        { "Alpha;"sv, 0x00391 },
        { "Amacr;"sv, 0x00100 },
        { "And;"sv, 0x02A53 },
        { "Aogon;"sv, 0x00104 },
        { "Aopf;"sv, 0x1D538 },
        { "ApplyFunction;"sv, 0x02061 },
        { "Aring;"sv, 0x000C5 },
        { "Aring"sv, 0x000C5 },
        { "Ascr;"sv, 0x1D49C },
        { "Assign;"sv, 0x02254 },
        { "Atilde;"sv, 0x000C3 },
        { "Atilde"sv, 0x000C3 },
        { "Auml;"sv, 0x000C4 },
        { "Auml"sv, 0x000C4 },
        { "Backslash;"sv, 0x02216 },
        { "Barv;"sv, 0x02AE7 },
        { "Barwed;"sv, 0x02306 },
        { "Bcy;"sv, 0x00411 },
        { "Because;"sv, 0x02235 },
        { "Bernoullis;"sv, 0x0212C },
        { "Beta;"sv, 0x00392 },
        { "Bfr;"sv, 0x1D505 },
        { "Bopf;"sv, 0x1D539 },
        { "Breve;"sv, 0x002D8 },
        { "Bscr;"sv, 0x0212C },
        { "Bumpeq;"sv, 0x0224E },
        { "CHcy;"sv, 0x00427 },
        { "COPY;"sv, 0x000A9 },
        { "COPY"sv, 0x000A9 },
        { "Cacute;"sv, 0x00106 },
        { "Cap;"sv, 0x022D2 },
        { "CapitalDifferentialD;"sv, 0x02145 },
        { "Cayleys;"sv, 0x0212D },
        { "Ccaron;"sv, 0x0010C },
        { "Ccedil;"sv, 0x000C7 },
        { "Ccedil"sv, 0x000C7 },
        { "Ccirc;"sv, 0x00108 },
        { "Cconint;"sv, 0x02230 },
        { "Cdot;"sv, 0x0010A },
        { "Cedilla;"sv, 0x000B8 },
        { "CenterDot;"sv, 0x000B7 },
        { "Cfr;"sv, 0x0212D },
        { "Chi;"sv, 0x003A7 },
        { "CircleDot;"sv, 0x02299 },
        { "CircleMinus;"sv, 0x02296 },
        { "CirclePlus;"sv, 0x02295 },
        { "CircleTimes;"sv, 0x02297 },
        { "ClockwiseContourIntegral;"sv, 0x02232 },
        { "CloseCurlyDoubleQuote;"sv, 0x0201D },
        { "CloseCurlyQuote;"sv, 0x02019 },
        { "Colon;"sv, 0x02237 },
        { "Colone;"sv, 0x02A74 },
        { "Congruent;"sv, 0x02261 },
        { "Conint;"sv, 0x0222F },
        { "ContourIntegral;"sv, 0x0222E },
        { "Copf;"sv, 0x02102 },
        { "Coproduct;"sv, 0x02210 },
        { "CounterClockwiseContourIntegral;"sv, 0x02233 },
        { "Cross;"sv, 0x02A2F },
        { "Cscr;"sv, 0x1D49E },
        { "Cup;"sv, 0x022D3 },
        { "CupCap;"sv, 0x0224D },
        { "DD;"sv, 0x02145 },
        { "DDotrahd;"sv, 0x02911 },
        { "DJcy;"sv, 0x00402 },
        { "DScy;"sv, 0x00405 },
        { "DZcy;"sv, 0x0040F },
        { "Dagger;"sv, 0x02021 },
        { "Darr;"sv, 0x021A1 },
        { "Dashv;"sv, 0x02AE4 },
        { "Dcaron;"sv, 0x0010E },
        { "Dcy;"sv, 0x00414 },
        { "Del;"sv, 0x02207 },
        { "Delta;"sv, 0x00394 },
        { "Dfr;"sv, 0x1D507 },
        { "DiacriticalAcute;"sv, 0x000B4 },
        { "DiacriticalDot;"sv, 0x002D9 },
        { "DiacriticalDoubleAcute;"sv, 0x002DD },
        { "DiacriticalGrave;"sv, 0x00060 },
        { "DiacriticalTilde;"sv, 0x002DC },
        { "Diamond;"sv, 0x022C4 },
        { "DifferentialD;"sv, 0x02146 },
        { "Dopf;"sv, 0x1D53B },
        { "Dot;"sv, 0x000A8 },
        { "DotDot;"sv, 0x020DC },
        { "DotEqual;"sv, 0x02250 },
        { "DoubleContourIntegral;"sv, 0x0222F },
        { "DoubleDot;"sv, 0x000A8 },
        { "DoubleDownArrow;"sv, 0x021D3 },
        { "DoubleLeftArrow;"sv, 0x021D0 },
        { "DoubleLeftRightArrow;"sv, 0x021D4 },
        { "DoubleLeftTee;"sv, 0x02AE4 },
        { "DoubleLongLeftArrow;"sv, 0x027F8 },
        { "DoubleLongLeftRightArrow;"sv, 0x027FA },
        { "DoubleLongRightArrow;"sv, 0x027F9 },
        { "DoubleRightArrow;"sv, 0x021D2 },
        { "DoubleRightTee;"sv, 0x022A8 },
        { "DoubleUpArrow;"sv, 0x021D1 },
        { "DoubleUpDownArrow;"sv, 0x021D5 },
        { "DoubleVerticalBar;"sv, 0x02225 },
        { "DownArrow;"sv, 0x02193 },
        { "DownArrowBar;"sv, 0x02913 },
        { "DownArrowUpArrow;"sv, 0x021F5 },
        { "DownBreve;"sv, 0x00311 },
        { "DownLeftRightVector;"sv, 0x02950 },
        { "DownLeftTeeVector;"sv, 0x0295E },
        { "DownLeftVector;"sv, 0x021BD },
        { "DownLeftVectorBar;"sv, 0x02956 },
        { "DownRightTeeVector;"sv, 0x0295F },
        { "DownRightVector;"sv, 0x021C1 },
        { "DownRightVectorBar;"sv, 0x02957 },
        { "DownTee;"sv, 0x022A4 },
        { "DownTeeArrow;"sv, 0x021A7 },
        { "Downarrow;"sv, 0x021D3 },
        { "Dscr;"sv, 0x1D49F },
        { "Dstrok;"sv, 0x00110 },
        { "ENG;"sv, 0x0014A },
        { "ETH;"sv, 0x000D0 },
        { "ETH"sv, 0x000D0 },
        { "Eacute;"sv, 0x000C9 },
        { "Eacute"sv, 0x000C9 },
        { "Ecaron;"sv, 0x0011A },
        { "Ecirc;"sv, 0x000CA },
        { "Ecirc"sv, 0x000CA },
        { "Ecy;"sv, 0x0042D },
        { "Edot;"sv, 0x00116 },
        { "Efr;"sv, 0x1D508 },
        { "Egrave;"sv, 0x000C8 },
        { "Egrave"sv, 0x000C8 },
        { "Element;"sv, 0x02208 },
        { "Emacr;"sv, 0x00112 },
        { "EmptySmallSquare;"sv, 0x025FB },
        { "EmptyVerySmallSquare;"sv, 0x025AB },
        { "Eogon;"sv, 0x00118 },
        { "Eopf;"sv, 0x1D53C },
        { "Epsilon;"sv, 0x00395 },
        { "Equal;"sv, 0x02A75 },
        { "EqualTilde;"sv, 0x02242 },
        { "Equilibrium;"sv, 0x021CC },
        { "Escr;"sv, 0x02130 },
        { "Esim;"sv, 0x02A73 },
        { "Eta;"sv, 0x00397 },
        { "Euml;"sv, 0x000CB },
        { "Euml"sv, 0x000CB },
        { "Exists;"sv, 0x02203 },
        { "ExponentialE;"sv, 0x02147 },
        { "Fcy;"sv, 0x00424 },
        { "Ffr;"sv, 0x1D509 },
        { "FilledSmallSquare;"sv, 0x025FC },
        { "FilledVerySmallSquare;"sv, 0x025AA },
        { "Fopf;"sv, 0x1D53D },
        { "ForAll;"sv, 0x02200 },
        { "Fouriertrf;"sv, 0x02131 },
        { "Fscr;"sv, 0x02131 },
        { "GJcy;"sv, 0x00403 },
        { "GT;"sv, 0x0003E },
        { "GT"sv, 0x0003E },
        { "Gamma;"sv, 0x00393 },
        { "Gammad;"sv, 0x003DC },
        { "Gbreve;"sv, 0x0011E },
        { "Gcedil;"sv, 0x00122 },
        { "Gcirc;"sv, 0x0011C },
        { "Gcy;"sv, 0x00413 },
        { "Gdot;"sv, 0x00120 },
        { "Gfr;"sv, 0x1D50A },
        { "Gg;"sv, 0x022D9 },
        { "Gopf;"sv, 0x1D53E },
        { "GreaterEqual;"sv, 0x02265 },
        { "GreaterEqualLess;"sv, 0x022DB },
        { "GreaterFullEqual;"sv, 0x02267 },
        { "GreaterGreater;"sv, 0x02AA2 },
        { "GreaterLess;"sv, 0x02277 },
        { "GreaterSlantEqual;"sv, 0x02A7E },
        { "GreaterTilde;"sv, 0x02273 },
        { "Gscr;"sv, 0x1D4A2 },
        { "Gt;"sv, 0x0226B },
        { "HARDcy;"sv, 0x0042A },
        { "Hacek;"sv, 0x002C7 },
        { "Hat;"sv, 0x0005E },
        { "Hcirc;"sv, 0x00124 },
        { "Hfr;"sv, 0x0210C },
        { "HilbertSpace;"sv, 0x0210B },
        { "Hopf;"sv, 0x0210D },
        { "HorizontalLine;"sv, 0x02500 },
        { "Hscr;"sv, 0x0210B },
        { "Hstrok;"sv, 0x00126 },
        { "HumpDownHump;"sv, 0x0224E },
        { "HumpEqual;"sv, 0x0224F },
        { "IEcy;"sv, 0x00415 },
        { "IJlig;"sv, 0x00132 },
        { "IOcy;"sv, 0x00401 },
        { "Iacute;"sv, 0x000CD },
        { "Iacute"sv, 0x000CD },
        { "Icirc;"sv, 0x000CE },
        { "Icirc"sv, 0x000CE },
        { "Icy;"sv, 0x00418 },
        { "Idot;"sv, 0x00130 },
        { "Ifr;"sv, 0x02111 },
        { "Igrave;"sv, 0x000CC },
        { "Igrave"sv, 0x000CC },
        { "Im;"sv, 0x02111 },
        { "Imacr;"sv, 0x0012A },
        { "ImaginaryI;"sv, 0x02148 },
        { "Implies;"sv, 0x021D2 },
        { "Int;"sv, 0x0222C },
        { "Integral;"sv, 0x0222B },
        { "Intersection;"sv, 0x022C2 },
        { "InvisibleComma;"sv, 0x02063 },
        { "InvisibleTimes;"sv, 0x02062 },
        { "Iogon;"sv, 0x0012E },
        { "Iopf;"sv, 0x1D540 },
        { "Iota;"sv, 0x00399 },
        { "Iscr;"sv, 0x02110 },
        { "Itilde;"sv, 0x00128 },
        { "Iukcy;"sv, 0x00406 },
        { "Iuml;"sv, 0x000CF },
        { "Iuml"sv, 0x000CF },
        { "Jcirc;"sv, 0x00134 },
        { "Jcy;"sv, 0x00419 },
        { "Jfr;"sv, 0x1D50D },
        { "Jopf;"sv, 0x1D541 },
        { "Jscr;"sv, 0x1D4A5 },
        { "Jsercy;"sv, 0x00408 },
        { "Jukcy;"sv, 0x00404 },
        { "KHcy;"sv, 0x00425 },
        { "KJcy;"sv, 0x0040C },
        { "Kappa;"sv, 0x0039A },
        { "Kcedil;"sv, 0x00136 },
        { "Kcy;"sv, 0x0041A },
        { "Kfr;"sv, 0x1D50E },
        { "Kopf;"sv, 0x1D542 },
        { "Kscr;"sv, 0x1D4A6 },
        { "LJcy;"sv, 0x00409 },
        { "LT;"sv, 0x0003C },
        { "LT"sv, 0x0003C },
        { "Lacute;"sv, 0x00139 },
        { "Lambda;"sv, 0x0039B },
        { "Lang;"sv, 0x027EA },
        { "Laplacetrf;"sv, 0x02112 },
        { "Larr;"sv, 0x0219E },
        { "Lcaron;"sv, 0x0013D },
        { "Lcedil;"sv, 0x0013B },
        { "Lcy;"sv, 0x0041B },
        { "LeftAngleBracket;"sv, 0x027E8 },
        { "LeftArrow;"sv, 0x02190 },
        { "LeftArrowBar;"sv, 0x021E4 },
        { "LeftArrowRightArrow;"sv, 0x021C6 },
        { "LeftCeiling;"sv, 0x02308 },
        { "LeftDoubleBracket;"sv, 0x027E6 },
        { "LeftDownTeeVector;"sv, 0x02961 },
        { "LeftDownVector;"sv, 0x021C3 },
        { "LeftDownVectorBar;"sv, 0x02959 },
        { "LeftFloor;"sv, 0x0230A },
        { "LeftRightArrow;"sv, 0x02194 },
        { "LeftRightVector;"sv, 0x0294E },
        { "LeftTee;"sv, 0x022A3 },
        { "LeftTeeArrow;"sv, 0x021A4 },
        { "LeftTeeVector;"sv, 0x0295A },
        { "LeftTriangle;"sv, 0x022B2 },
        { "LeftTriangleBar;"sv, 0x029CF },
        { "LeftTriangleEqual;"sv, 0x022B4 },
        { "LeftUpDownVector;"sv, 0x02951 },
        { "LeftUpTeeVector;"sv, 0x02960 },
        { "LeftUpVector;"sv, 0x021BF },
        { "LeftUpVectorBar;"sv, 0x02958 },
        { "LeftVector;"sv, 0x021BC },
        { "LeftVectorBar;"sv, 0x02952 },
        { "Leftarrow;"sv, 0x021D0 },
        { "Leftrightarrow;"sv, 0x021D4 },
        { "LessEqualGreater;"sv, 0x022DA },
        { "LessFullEqual;"sv, 0x02266 },
        { "LessGreater;"sv, 0x02276 },
        { "LessLess;"sv, 0x02AA1 },
        { "LessSlantEqual;"sv, 0x02A7D },
        { "LessTilde;"sv, 0x02272 },
        { "Lfr;"sv, 0x1D50F },
        { "Ll;"sv, 0x022D8 },
        { "Lleftarrow;"sv, 0x021DA },
        { "Lmidot;"sv, 0x0013F },
        { "LongLeftArrow;"sv, 0x027F5 },
        { "LongLeftRightArrow;"sv, 0x027F7 },
        { "LongRightArrow;"sv, 0x027F6 },
        { "Longleftarrow;"sv, 0x027F8 },
        { "Longleftrightarrow;"sv, 0x027FA },
        { "Longrightarrow;"sv, 0x027F9 },
        { "Lopf;"sv, 0x1D543 },
        { "LowerLeftArrow;"sv, 0x02199 },
        { "LowerRightArrow;"sv, 0x02198 },
        { "Lscr;"sv, 0x02112 },
        { "Lsh;"sv, 0x021B0 },
        { "Lstrok;"sv, 0x00141 },
        { "Lt;"sv, 0x0226A },
        { "Map;"sv, 0x02905 },
        { "Mcy;"sv, 0x0041C },
        { "MediumSpace;"sv, 0x0205F },
        { "Mellintrf;"sv, 0x02133 },
        { "Mfr;"sv, 0x1D510 },
        { "MinusPlus;"sv, 0x02213 },
        { "Mopf;"sv, 0x1D544 },
        { "Mscr;"sv, 0x02133 },
        { "Mu;"sv, 0x0039C },
        { "NJcy;"sv, 0x0040A },
        { "Nacute;"sv, 0x00143 },
        { "Ncaron;"sv, 0x00147 },
        { "Ncedil;"sv, 0x00145 },
        { "Ncy;"sv, 0x0041D },
        { "NegativeMediumSpace;"sv, 0x0200B },
        { "NegativeThickSpace;"sv, 0x0200B },
        { "NegativeThinSpace;"sv, 0x0200B },
        { "NegativeVeryThinSpace;"sv, 0x0200B },
        { "NestedGreaterGreater;"sv, 0x0226B },
        { "NestedLessLess;"sv, 0x0226A },
        { "NewLine;"sv, 0x0000A },
        { "Nfr;"sv, 0x1D511 },
        { "NoBreak;"sv, 0x02060 },
        { "NonBreakingSpace;"sv, 0x000A0 },
        { "Nopf;"sv, 0x02115 },
        { "Not;"sv, 0x02AEC },
        { "NotCongruent;"sv, 0x02262 },
        { "NotCupCap;"sv, 0x0226D },
        { "NotDoubleVerticalBar;"sv, 0x02226 },
        { "NotElement;"sv, 0x02209 },
        { "NotEqual;"sv, 0x02260 },
        { "NotExists;"sv, 0x02204 },
        { "NotGreater;"sv, 0x0226F },
        { "NotGreaterEqual;"sv, 0x02271 },
        { "NotGreaterLess;"sv, 0x02279 },
        { "NotGreaterTilde;"sv, 0x02275 },
        { "NotLeftTriangle;"sv, 0x022EA },
        { "NotLeftTriangleEqual;"sv, 0x022EC },
        { "NotLess;"sv, 0x0226E },
        { "NotLessEqual;"sv, 0x02270 },
        { "NotLessGreater;"sv, 0x02278 },
        { "NotLessTilde;"sv, 0x02274 },
        { "NotPrecedes;"sv, 0x02280 },
        { "NotPrecedesSlantEqual;"sv, 0x022E0 },
        { "NotReverseElement;"sv, 0x0220C },
        { "NotRightTriangle;"sv, 0x022EB },
        { "NotRightTriangleEqual;"sv, 0x022ED },
        { "NotSquareSubsetEqual;"sv, 0x022E2 },
        { "NotSquareSupersetEqual;"sv, 0x022E3 },
        { "NotSubsetEqual;"sv, 0x02288 },
        { "NotSucceeds;"sv, 0x02281 },
        { "NotSucceedsSlantEqual;"sv, 0x022E1 },
        { "NotSupersetEqual;"sv, 0x02289 },
        { "NotTilde;"sv, 0x02241 },
        { "NotTildeEqual;"sv, 0x02244 },
        { "NotTildeFullEqual;"sv, 0x02247 },
        { "NotTildeTilde;"sv, 0x02249 },
        { "NotVerticalBar;"sv, 0x02224 },
        { "Nscr;"sv, 0x1D4A9 },
        { "Ntilde;"sv, 0x000D1 },
        { "Ntilde"sv, 0x000D1 },
        { "Nu;"sv, 0x0039D },
        { "OElig;"sv, 0x00152 },
        { "Oacute;"sv, 0x000D3 },
        { "Oacute"sv, 0x000D3 },
        { "Ocirc;"sv, 0x000D4 },
        { "Ocirc"sv, 0x000D4 },
        { "Ocy;"sv, 0x0041E },
        { "Odblac;"sv, 0x00150 },
        { "Ofr;"sv, 0x1D512 },
        { "Ograve;"sv, 0x000D2 },
        { "Ograve"sv, 0x000D2 },
        { "Omacr;"sv, 0x0014C },
        { "Omega;"sv, 0x003A9 },
        { "Omicron;"sv, 0x0039F },
        { "Oopf;"sv, 0x1D546 },
        { "OpenCurlyDoubleQuote;"sv, 0x0201C },
        { "OpenCurlyQuote;"sv, 0x02018 },
        { "Or;"sv, 0x02A54 },
        { "Oscr;"sv, 0x1D4AA },
        { "Oslash;"sv, 0x000D8 },
        { "Oslash"sv, 0x000D8 },
        { "Otilde;"sv, 0x000D5 },
        { "Otilde"sv, 0x000D5 },
        { "Otimes;"sv, 0x02A37 },
        { "Ouml;"sv, 0x000D6 },
        { "Ouml"sv, 0x000D6 },
        { "OverBar;"sv, 0x0203E },
        { "OverBrace;"sv, 0x023DE },
        { "OverBracket;"sv, 0x023B4 },
        { "OverParenthesis;"sv, 0x023DC },
        { "PartialD;"sv, 0x02202 },
        { "Pcy;"sv, 0x0041F },
        { "Pfr;"sv, 0x1D513 },
        { "Phi;"sv, 0x003A6 },
        { "Pi;"sv, 0x003A0 },
        { "PlusMinus;"sv, 0x000B1 },
        { "Poincareplane;"sv, 0x0210C },
        { "Popf;"sv, 0x02119 },
        { "Pr;"sv, 0x02ABB },
        { "Precedes;"sv, 0x0227A },
        { "PrecedesEqual;"sv, 0x02AAF },
        { "PrecedesSlantEqual;"sv, 0x0227C },
        { "PrecedesTilde;"sv, 0x0227E },
        { "Prime;"sv, 0x02033 },
        { "Product;"sv, 0x0220F },
        { "Proportion;"sv, 0x02237 },
        { "Proportional;"sv, 0x0221D },
        { "Pscr;"sv, 0x1D4AB },
        { "Psi;"sv, 0x003A8 },
        { "QUOT;"sv, 0x00022 },
        { "QUOT"sv, 0x00022 },
        { "Qfr;"sv, 0x1D514 },
        { "Qopf;"sv, 0x0211A },
        { "Qscr;"sv, 0x1D4AC },
        { "RBarr;"sv, 0x02910 },
        { "REG;"sv, 0x000AE },
        { "REG"sv, 0x000AE },
        { "Racute;"sv, 0x00154 },
        { "Rang;"sv, 0x027EB },
        { "Rarr;"sv, 0x021A0 },
        { "Rarrtl;"sv, 0x02916 },
        { "Rcaron;"sv, 0x00158 },
        { "Rcedil;"sv, 0x00156 },
        { "Rcy;"sv, 0x00420 },
        { "Re;"sv, 0x0211C },
        { "ReverseElement;"sv, 0x0220B },
        { "ReverseEquilibrium;"sv, 0x021CB },
        { "ReverseUpEquilibrium;"sv, 0x0296F },
        { "Rfr;"sv, 0x0211C },
        { "Rho;"sv, 0x003A1 },
        { "RightAngleBracket;"sv, 0x027E9 },
        { "RightArrow;"sv, 0x02192 },
        { "RightArrowBar;"sv, 0x021E5 },
        { "RightArrowLeftArrow;"sv, 0x021C4 },
        { "RightCeiling;"sv, 0x02309 },
        { "RightDoubleBracket;"sv, 0x027E7 },
        { "RightDownTeeVector;"sv, 0x0295D },
        { "RightDownVector;"sv, 0x021C2 },
        { "RightDownVectorBar;"sv, 0x02955 },
        { "RightFloor;"sv, 0x0230B },
        { "RightTee;"sv, 0x022A2 },
        { "RightTeeArrow;"sv, 0x021A6 },
        { "RightTeeVector;"sv, 0x0295B },
        { "RightTriangle;"sv, 0x022B3 },
        { "RightTriangleBar;"sv, 0x029D0 },
        { "RightTriangleEqual;"sv, 0x022B5 },
        { "RightUpDownVector;"sv, 0x0294F },
        { "RightUpTeeVector;"sv, 0x0295C },
        { "RightUpVector;"sv, 0x021BE },
        { "RightUpVectorBar;"sv, 0x02954 },
        { "RightVector;"sv, 0x021C0 },
        { "RightVectorBar;"sv, 0x02953 },
        { "Rightarrow;"sv, 0x021D2 },
        { "Ropf;"sv, 0x0211D },
        { "RoundImplies;"sv, 0x02970 },
        { "Rrightarrow;"sv, 0x021DB },
        { "Rscr;"sv, 0x0211B },
        { "Rsh;"sv, 0x021B1 },
        { "RuleDelayed;"sv, 0x029F4 },
        { "SHCHcy;"sv, 0x00429 },
        { "SHcy;"sv, 0x00428 },
        { "SOFTcy;"sv, 0x0042C },
        { "Sacute;"sv, 0x0015A },
        { "Sc;"sv, 0x02ABC },
        { "Scaron;"sv, 0x00160 },
        { "Scedil;"sv, 0x0015E },
        { "Scirc;"sv, 0x0015C },
        { "Scy;"sv, 0x00421 },
        { "Sfr;"sv, 0x1D516 },
        { "ShortDownArrow;"sv, 0x02193 },
        { "ShortLeftArrow;"sv, 0x02190 },
        { "ShortRightArrow;"sv, 0x02192 },
        { "ShortUpArrow;"sv, 0x02191 },
        { "Sigma;"sv, 0x003A3 },
        { "SmallCircle;"sv, 0x02218 },
        { "Sopf;"sv, 0x1D54A },
        { "Sqrt;"sv, 0x0221A },
        { "Square;"sv, 0x025A1 },
        { "SquareIntersection;"sv, 0x02293 },
        { "SquareSubset;"sv, 0x0228F },
        { "SquareSubsetEqual;"sv, 0x02291 },
        { "SquareSuperset;"sv, 0x02290 },
        { "SquareSupersetEqual;"sv, 0x02292 },
        { "SquareUnion;"sv, 0x02294 },
        { "Sscr;"sv, 0x1D4AE },
        { "Star;"sv, 0x022C6 },
        { "Sub;"sv, 0x022D0 },
        { "Subset;"sv, 0x022D0 },
        { "SubsetEqual;"sv, 0x02286 },
        { "Succeeds;"sv, 0x0227B },
        { "SucceedsEqual;"sv, 0x02AB0 },
        { "SucceedsSlantEqual;"sv, 0x0227D },
        { "SucceedsTilde;"sv, 0x0227F },
        { "SuchThat;"sv, 0x0220B },
        { "Sum;"sv, 0x02211 },
        { "Sup;"sv, 0x022D1 },
        { "Superset;"sv, 0x02283 },
        { "SupersetEqual;"sv, 0x02287 },
        { "Supset;"sv, 0x022D1 },
        { "THORN;"sv, 0x000DE },
        { "THORN"sv, 0x000DE },
        { "TRADE;"sv, 0x02122 },
        { "TSHcy;"sv, 0x0040B },
        { "TScy;"sv, 0x00426 },
        { "Tab;"sv, 0x00009 },
        { "Tau;"sv, 0x003A4 },
        { "Tcaron;"sv, 0x00164 },
        { "Tcedil;"sv, 0x00162 },
        { "Tcy;"sv, 0x00422 },
        { "Tfr;"sv, 0x1D517 },
        { "Therefore;"sv, 0x02234 },
        { "Theta;"sv, 0x00398 },
        { "ThinSpace;"sv, 0x02009 },
        { "Tilde;"sv, 0x0223C },
        { "TildeEqual;"sv, 0x02243 },
        { "TildeFullEqual;"sv, 0x02245 },
        { "TildeTilde;"sv, 0x02248 },
        { "Topf;"sv, 0x1D54B },
        { "TripleDot;"sv, 0x020DB },
        { "Tscr;"sv, 0x1D4AF },
        { "Tstrok;"sv, 0x00166 },
        { "Uacute;"sv, 0x000DA },
        { "Uacute"sv, 0x000DA },
        { "Uarr;"sv, 0x0219F },
        { "Uarrocir;"sv, 0x02949 },
        { "Ubrcy;"sv, 0x0040E },
        { "Ubreve;"sv, 0x0016C },
        { "Ucirc;"sv, 0x000DB },
        { "Ucirc"sv, 0x000DB },
        { "Ucy;"sv, 0x00423 },
        { "Udblac;"sv, 0x00170 },
        { "Ufr;"sv, 0x1D518 },
        { "Ugrave;"sv, 0x000D9 },
        { "Ugrave"sv, 0x000D9 },
        { "Umacr;"sv, 0x0016A },
        { "UnderBar;"sv, 0x0005F },
        { "UnderBrace;"sv, 0x023DF },
        { "UnderBracket;"sv, 0x023B5 },
        { "UnderParenthesis;"sv, 0x023DD },
        { "Union;"sv, 0x022C3 },
        { "UnionPlus;"sv, 0x0228E },
        { "Uogon;"sv, 0x00172 },
        { "Uopf;"sv, 0x1D54C },
        { "UpArrow;"sv, 0x02191 },
        { "UpArrowBar;"sv, 0x02912 },
        { "UpArrowDownArrow;"sv, 0x021C5 },
        { "UpDownArrow;"sv, 0x02195 },
        { "UpEquilibrium;"sv, 0x0296E },
        { "UpTee;"sv, 0x022A5 },
        { "UpTeeArrow;"sv, 0x021A5 },
        { "Uparrow;"sv, 0x021D1 },
        { "Updownarrow;"sv, 0x021D5 },
        { "UpperLeftArrow;"sv, 0x02196 },
        { "UpperRightArrow;"sv, 0x02197 },
        { "Upsi;"sv, 0x003D2 },
        { "Upsilon;"sv, 0x003A5 },
        { "Uring;"sv, 0x0016E },
        { "Uscr;"sv, 0x1D4B0 },
        { "Utilde;"sv, 0x00168 },
        { "Uuml;"sv, 0x000DC },
        { "Uuml"sv, 0x000DC },
        { "VDash;"sv, 0x022AB },
        { "Vbar;"sv, 0x02AEB },
        { "Vcy;"sv, 0x00412 },
        { "Vdash;"sv, 0x022A9 },
        { "Vdashl;"sv, 0x02AE6 },
        { "Vee;"sv, 0x022C1 },
        { "Verbar;"sv, 0x02016 },
        { "Vert;"sv, 0x02016 },
        { "VerticalBar;"sv, 0x02223 },
        { "VerticalLine;"sv, 0x0007C },
        { "VerticalSeparator;"sv, 0x02758 },
        { "VerticalTilde;"sv, 0x02240 },
        { "VeryThinSpace;"sv, 0x0200A },
        { "Vfr;"sv, 0x1D519 },
        { "Vopf;"sv, 0x1D54D },
        { "Vscr;"sv, 0x1D4B1 },
        { "Vvdash;"sv, 0x022AA },
        { "Wcirc;"sv, 0x00174 },
        { "Wedge;"sv, 0x022C0 },
        { "Wfr;"sv, 0x1D51A },
        { "Wopf;"sv, 0x1D54E },
        { "Wscr;"sv, 0x1D4B2 },
        { "Xfr;"sv, 0x1D51B },
        { "Xi;"sv, 0x0039E },
        { "Xopf;"sv, 0x1D54F },
        { "Xscr;"sv, 0x1D4B3 },
        { "YAcy;"sv, 0x0042F },
        { "YIcy;"sv, 0x00407 },
        { "YUcy;"sv, 0x0042E },
        { "Yacute;"sv, 0x000DD },
        { "Yacute"sv, 0x000DD },
        { "Ycirc;"sv, 0x00176 },
        { "Ycy;"sv, 0x0042B },
        { "Yfr;"sv, 0x1D51C },
        { "Yopf;"sv, 0x1D550 },
        { "Yscr;"sv, 0x1D4B4 },
        { "Yuml;"sv, 0x00178 },
        { "ZHcy;"sv, 0x00416 },
        { "Zacute;"sv, 0x00179 },
        { "Zcaron;"sv, 0x0017D },
        { "Zcy;"sv, 0x00417 },
        { "Zdot;"sv, 0x0017B },
        { "ZeroWidthSpace;"sv, 0x0200B },
        { "Zeta;"sv, 0x00396 },
        { "Zfr;"sv, 0x02128 },
        { "Zopf;"sv, 0x02124 },
        { "Zscr;"sv, 0x1D4B5 },
        { "aacute;"sv, 0x000E1 },
        { "aacute"sv, 0x000E1 },
        { "abreve;"sv, 0x00103 },
        { "ac;"sv, 0x0223E },
        { "acd;"sv, 0x0223F },
        { "acirc;"sv, 0x000E2 },
        { "acirc"sv, 0x000E2 },
        { "acute;"sv, 0x000B4 },
        { "acute"sv, 0x000B4 },
        { "acy;"sv, 0x00430 },
        { "aelig;"sv, 0x000E6 },
        { "aelig"sv, 0x000E6 },
        { "af;"sv, 0x02061 },
        { "afr;"sv, 0x1D51E },
        { "agrave;"sv, 0x000E0 },
        { "agrave"sv, 0x000E0 },
        { "alefsym;"sv, 0x02135 },
        { "aleph;"sv, 0x02135 },
        { "alpha;"sv, 0x003B1 },
        { "amacr;"sv, 0x00101 },
        { "amalg;"sv, 0x02A3F },
        { "amp;"sv, 0x00026 },
        { "amp"sv, 0x00026 },
        { "and;"sv, 0x02227 },
        { "andand;"sv, 0x02A55 },
        { "andd;"sv, 0x02A5C },
        { "andslope;"sv, 0x02A58 },
        { "andv;"sv, 0x02A5A },
        { "ang;"sv, 0x02220 },
        { "ange;"sv, 0x029A4 },
        { "angle;"sv, 0x02220 },
        { "angmsd;"sv, 0x02221 },
        { "angmsdaa;"sv, 0x029A8 },
        { "angmsdab;"sv, 0x029A9 },
        { "angmsdac;"sv, 0x029AA },
        { "angmsdad;"sv, 0x029AB },
        { "angmsdae;"sv, 0x029AC },
        { "angmsdaf;"sv, 0x029AD },
        { "angmsdag;"sv, 0x029AE },
        { "angmsdah;"sv, 0x029AF },
        { "angrt;"sv, 0x0221F },
        { "angrtvb;"sv, 0x022BE },
        { "angrtvbd;"sv, 0x0299D },
        { "angsph;"sv, 0x02222 },
        { "angst;"sv, 0x000C5 },
        { "angzarr;"sv, 0x0237C },
        { "aogon;"sv, 0x00105 },
        { "aopf;"sv, 0x1D552 },
        { "ap;"sv, 0x02248 },
        { "apE;"sv, 0x02A70 },
        { "apacir;"sv, 0x02A6F },
        { "ape;"sv, 0x0224A },
        { "apid;"sv, 0x0224B },
        { "apos;"sv, 0x00027 },
        { "approx;"sv, 0x02248 },
        { "approxeq;"sv, 0x0224A },
        { "aring;"sv, 0x000E5 },
        { "aring"sv, 0x000E5 },
        { "ascr;"sv, 0x1D4B6 },
        { "ast;"sv, 0x0002A },
        { "asymp;"sv, 0x02248 },
        { "asympeq;"sv, 0x0224D },
        { "atilde;"sv, 0x000E3 },
        { "atilde"sv, 0x000E3 },
        { "auml;"sv, 0x000E4 },
        { "auml"sv, 0x000E4 },
        { "awconint;"sv, 0x02233 },
        { "awint;"sv, 0x02A11 },
        { "bNot;"sv, 0x02AED },
        { "backcong;"sv, 0x0224C },
        { "backepsilon;"sv, 0x003F6 },
        { "backprime;"sv, 0x02035 },
        { "backsim;"sv, 0x0223D },
        { "backsimeq;"sv, 0x022CD },
        { "barvee;"sv, 0x022BD },
        { "barwed;"sv, 0x02305 },
        { "barwedge;"sv, 0x02305 },
        { "bbrk;"sv, 0x023B5 },
        { "bbrktbrk;"sv, 0x023B6 },
        { "bcong;"sv, 0x0224C },
        { "bcy;"sv, 0x00431 },
        { "bdquo;"sv, 0x0201E },
        { "becaus;"sv, 0x02235 },
        { "because;"sv, 0x02235 },
        { "bemptyv;"sv, 0x029B0 },
        { "bepsi;"sv, 0x003F6 },
        { "bernou;"sv, 0x0212C },
        { "beta;"sv, 0x003B2 },
        { "beth;"sv, 0x02136 },
        { "between;"sv, 0x0226C },
        { "bfr;"sv, 0x1D51F },
        { "bigcap;"sv, 0x022C2 },
        { "bigcirc;"sv, 0x025EF },
        { "bigcup;"sv, 0x022C3 },
        { "bigodot;"sv, 0x02A00 },
        { "bigoplus;"sv, 0x02A01 },
        { "bigotimes;"sv, 0x02A02 },
        { "bigsqcup;"sv, 0x02A06 },
        { "bigstar;"sv, 0x02605 },
        { "bigtriangledown;"sv, 0x025BD },
        { "bigtriangleup;"sv, 0x025B3 },
        { "biguplus;"sv, 0x02A04 },
        { "bigvee;"sv, 0x022C1 },
        { "bigwedge;"sv, 0x022C0 },
        { "bkarow;"sv, 0x0290D },
        { "blacklozenge;"sv, 0x029EB },
        { "blacksquare;"sv, 0x025AA },
        { "blacktriangle;"sv, 0x025B4 },
        { "blacktriangledown;"sv, 0x025BE },
        { "blacktriangleleft;"sv, 0x025C2 },
        { "blacktriangleright;"sv, 0x025B8 },
        { "blank;"sv, 0x02423 },
        { "blk12;"sv, 0x02592 },
        { "blk14;"sv, 0x02591 },
        { "blk34;"sv, 0x02593 },
        { "block;"sv, 0x02588 },
        { "bnot;"sv, 0x02310 },
        { "bopf;"sv, 0x1D553 },
        { "bot;"sv, 0x022A5 },
        { "bottom;"sv, 0x022A5 },
        { "bowtie;"sv, 0x022C8 },
        { "boxDL;"sv, 0x02557 },
        { "boxDR;"sv, 0x02554 },
        { "boxDl;"sv, 0x02556 },
        { "boxDr;"sv, 0x02553 },
        { "boxH;"sv, 0x02550 },
        { "boxHD;"sv, 0x02566 },
        { "boxHU;"sv, 0x02569 },
        { "boxHd;"sv, 0x02564 },
        { "boxHu;"sv, 0x02567 },
        { "boxUL;"sv, 0x0255D },
        { "boxUR;"sv, 0x0255A },
        { "boxUl;"sv, 0x0255C },
        { "boxUr;"sv, 0x02559 },
        { "boxV;"sv, 0x02551 },
        { "boxVH;"sv, 0x0256C },
        { "boxVL;"sv, 0x02563 },
        { "boxVR;"sv, 0x02560 },
        { "boxVh;"sv, 0x0256B },
        { "boxVl;"sv, 0x02562 },
        { "boxVr;"sv, 0x0255F },
        { "boxbox;"sv, 0x029C9 },
        { "boxdL;"sv, 0x02555 },
        { "boxdR;"sv, 0x02552 },
        { "boxdl;"sv, 0x02510 },
        { "boxdr;"sv, 0x0250C },
        { "boxh;"sv, 0x02500 },
        { "boxhD;"sv, 0x02565 },
        { "boxhU;"sv, 0x02568 },
        { "boxhd;"sv, 0x0252C },
        { "boxhu;"sv, 0x02534 },
        { "boxminus;"sv, 0x0229F },
        { "boxplus;"sv, 0x0229E },
        { "boxtimes;"sv, 0x022A0 },
        { "boxuL;"sv, 0x0255B },
        { "boxuR;"sv, 0x02558 },
        { "boxul;"sv, 0x02518 },
        { "boxur;"sv, 0x02514 },
        { "boxv;"sv, 0x02502 },
        { "boxvH;"sv, 0x0256A },
        { "boxvL;"sv, 0x02561 },
        { "boxvR;"sv, 0x0255E },
        { "boxvh;"sv, 0x0253C },
        { "boxvl;"sv, 0x02524 },
        { "boxvr;"sv, 0x0251C },
        { "bprime;"sv, 0x02035 },
        { "breve;"sv, 0x002D8 },
        { "brvbar;"sv, 0x000A6 },
        { "brvbar"sv, 0x000A6 },
        { "bscr;"sv, 0x1D4B7 },
        { "bsemi;"sv, 0x0204F },
        { "bsim;"sv, 0x0223D },
        { "bsime;"sv, 0x022CD },
        { "bsol;"sv, 0x0005C },
        { "bsolb;"sv, 0x029C5 },
        { "bsolhsub;"sv, 0x027C8 },
        { "bull;"sv, 0x02022 },
        { "bullet;"sv, 0x02022 },
        { "bump;"sv, 0x0224E },
        { "bumpE;"sv, 0x02AAE },
        { "bumpe;"sv, 0x0224F },
        { "bumpeq;"sv, 0x0224F },
        { "cacute;"sv, 0x00107 },
        { "cap;"sv, 0x02229 },
        { "capand;"sv, 0x02A44 },
        { "capbrcup;"sv, 0x02A49 },
        { "capcap;"sv, 0x02A4B },
        { "capcup;"sv, 0x02A47 },
        { "capdot;"sv, 0x02A40 },
        { "caret;"sv, 0x02041 },
        { "caron;"sv, 0x002C7 },
        { "ccaps;"sv, 0x02A4D },
        { "ccaron;"sv, 0x0010D },
        { "ccedil;"sv, 0x000E7 },
        { "ccedil"sv, 0x000E7 },
        { "ccirc;"sv, 0x00109 },
        { "ccups;"sv, 0x02A4C },
        { "ccupssm;"sv, 0x02A50 },
        { "cdot;"sv, 0x0010B },
        { "cedil;"sv, 0x000B8 },
        { "cedil"sv, 0x000B8 },
        { "cemptyv;"sv, 0x029B2 },
        { "cent;"sv, 0x000A2 },
        { "cent"sv, 0x000A2 },
        { "centerdot;"sv, 0x000B7 },
        { "cfr;"sv, 0x1D520 },
        { "chcy;"sv, 0x00447 },
        { "check;"sv, 0x02713 },
        { "checkmark;"sv, 0x02713 },
        { "chi;"sv, 0x003C7 },
        { "cir;"sv, 0x025CB },
        { "cirE;"sv, 0x029C3 },
        { "circ;"sv, 0x002C6 },
        { "circeq;"sv, 0x02257 },
        { "circlearrowleft;"sv, 0x021BA },
        { "circlearrowright;"sv, 0x021BB },
        { "circledR;"sv, 0x000AE },
        { "circledS;"sv, 0x024C8 },
        { "circledast;"sv, 0x0229B },
        { "circledcirc;"sv, 0x0229A },
        { "circleddash;"sv, 0x0229D },
        { "cire;"sv, 0x02257 },
        { "cirfnint;"sv, 0x02A10 },
        { "cirmid;"sv, 0x02AEF },
        { "cirscir;"sv, 0x029C2 },
        { "clubs;"sv, 0x02663 },
        { "clubsuit;"sv, 0x02663 },
        { "colon;"sv, 0x0003A },
        { "colone;"sv, 0x02254 },
        { "coloneq;"sv, 0x02254 },
        { "comma;"sv, 0x0002C },
        { "commat;"sv, 0x00040 },
        { "comp;"sv, 0x02201 },
        { "compfn;"sv, 0x02218 },
        { "complement;"sv, 0x02201 },
        { "complexes;"sv, 0x02102 },
        { "cong;"sv, 0x02245 },
        { "congdot;"sv, 0x02A6D },
        { "conint;"sv, 0x0222E },
        { "copf;"sv, 0x1D554 },
        { "coprod;"sv, 0x02210 },
        { "copy;"sv, 0x000A9 },
        { "copy"sv, 0x000A9 },
        { "copysr;"sv, 0x02117 },
        { "crarr;"sv, 0x021B5 },
        { "cross;"sv, 0x02717 },
        { "cscr;"sv, 0x1D4B8 },
        { "csub;"sv, 0x02ACF },
        { "csube;"sv, 0x02AD1 },
        { "csup;"sv, 0x02AD0 },
        { "csupe;"sv, 0x02AD2 },
        { "ctdot;"sv, 0x022EF },
        { "cudarrl;"sv, 0x02938 },
        { "cudarrr;"sv, 0x02935 },
        { "cuepr;"sv, 0x022DE },
        { "cuesc;"sv, 0x022DF },
        { "cularr;"sv, 0x021B6 },
        { "cularrp;"sv, 0x0293D },
        { "cup;"sv, 0x0222A },
        { "cupbrcap;"sv, 0x02A48 },
        { "cupcap;"sv, 0x02A46 },
        { "cupcup;"sv, 0x02A4A },
        { "cupdot;"sv, 0x0228D },
        { "cupor;"sv, 0x02A45 },
        { "curarr;"sv, 0x021B7 },
        { "curarrm;"sv, 0x0293C },
        { "curlyeqprec;"sv, 0x022DE },
        { "curlyeqsucc;"sv, 0x022DF },
        { "curlyvee;"sv, 0x022CE },
        { "curlywedge;"sv, 0x022CF },
        { "curren;"sv, 0x000A4 },
        { "curren"sv, 0x000A4 },
        { "curvearrowleft;"sv, 0x021B6 },
        { "curvearrowright;"sv, 0x021B7 },
        { "cuvee;"sv, 0x022CE },
        { "cuwed;"sv, 0x022CF },
        { "cwconint;"sv, 0x02232 },
        { "cwint;"sv, 0x02231 },
        { "cylcty;"sv, 0x0232D },
        { "dArr;"sv, 0x021D3 },
        { "dHar;"sv, 0x02965 },
        { "dagger;"sv, 0x02020 },
        { "daleth;"sv, 0x02138 },
        { "darr;"sv, 0x02193 },
        { "dash;"sv, 0x02010 },
        { "dashv;"sv, 0x022A3 },
        { "dbkarow;"sv, 0x0290F },
        { "dblac;"sv, 0x002DD },
        { "dcaron;"sv, 0x0010F },
        { "dcy;"sv, 0x00434 },
        { "dd;"sv, 0x02146 },
        { "ddagger;"sv, 0x02021 },
        { "ddarr;"sv, 0x021CA },
        { "ddotseq;"sv, 0x02A77 },
        { "deg;"sv, 0x000B0 },
        { "deg"sv, 0x000B0 },
        { "delta;"sv, 0x003B4 },
        { "demptyv;"sv, 0x029B1 },
        { "dfisht;"sv, 0x0297F },
        { "dfr;"sv, 0x1D521 },
        { "dharl;"sv, 0x021C3 },
        { "dharr;"sv, 0x021C2 },
        { "diam;"sv, 0x022C4 },
        { "diamond;"sv, 0x022C4 },
        { "diamondsuit;"sv, 0x02666 },
        { "diams;"sv, 0x02666 },
        { "die;"sv, 0x000A8 },
        { "digamma;"sv, 0x003DD },
        { "disin;"sv, 0x022F2 },
        { "div;"sv, 0x000F7 },
        { "divide;"sv, 0x000F7 },
        { "divide"sv, 0x000F7 },
        { "divideontimes;"sv, 0x022C7 },
        { "divonx;"sv, 0x022C7 },
        { "djcy;"sv, 0x00452 },
        { "dlcorn;"sv, 0x0231E },
        { "dlcrop;"sv, 0x0230D },
        { "dollar;"sv, 0x00024 },
        { "dopf;"sv, 0x1D555 },
        { "dot;"sv, 0x002D9 },
        { "doteq;"sv, 0x02250 },
        { "doteqdot;"sv, 0x02251 },
        { "dotminus;"sv, 0x02238 },
        { "dotplus;"sv, 0x02214 },
        { "dotsquare;"sv, 0x022A1 },
        { "doublebarwedge;"sv, 0x02306 },
        { "downarrow;"sv, 0x02193 },
        { "downdownarrows;"sv, 0x021CA },
        { "downharpoonleft;"sv, 0x021C3 },
        { "downharpoonright;"sv, 0x021C2 },
        { "drbkarow;"sv, 0x02910 },
        { "drcorn;"sv, 0x0231F },
        { "drcrop;"sv, 0x0230C },
        { "dscr;"sv, 0x1D4B9 },
        { "dscy;"sv, 0x00455 },
        { "dsol;"sv, 0x029F6 },
        { "dstrok;"sv, 0x00111 },
        { "dtdot;"sv, 0x022F1 },
        { "dtri;"sv, 0x025BF },
        { "dtrif;"sv, 0x025BE },
        { "duarr;"sv, 0x021F5 },
        { "duhar;"sv, 0x0296F },
        { "dwangle;"sv, 0x029A6 },
        { "dzcy;"sv, 0x0045F },
        { "dzigrarr;"sv, 0x027FF },
        { "eDDot;"sv, 0x02A77 },
        { "eDot;"sv, 0x02251 },
        { "eacute;"sv, 0x000E9 },
        { "eacute"sv, 0x000E9 },
        { "easter;"sv, 0x02A6E },
        { "ecaron;"sv, 0x0011B },
        { "ecir;"sv, 0x02256 },
        { "ecirc;"sv, 0x000EA },
        { "ecirc"sv, 0x000EA },
        { "ecolon;"sv, 0x02255 },
        { "ecy;"sv, 0x0044D },
        { "edot;"sv, 0x00117 },
        { "ee;"sv, 0x02147 },
        { "efDot;"sv, 0x02252 },
        { "efr;"sv, 0x1D522 },
        { "eg;"sv, 0x02A9A },
        { "egrave;"sv, 0x000E8 },
        { "egrave"sv, 0x000E8 },
        { "egs;"sv, 0x02A96 },
        { "egsdot;"sv, 0x02A98 },
        { "el;"sv, 0x02A99 },
        { "elinters;"sv, 0x023E7 },
        { "ell;"sv, 0x02113 },
        { "els;"sv, 0x02A95 },
        { "elsdot;"sv, 0x02A97 },
        { "emacr;"sv, 0x00113 },
        { "empty;"sv, 0x02205 },
        { "emptyset;"sv, 0x02205 },
        { "emptyv;"sv, 0x02205 },
        { "emsp13;"sv, 0x02004 },
        { "emsp14;"sv, 0x02005 },
        { "emsp;"sv, 0x02003 },
        { "eng;"sv, 0x0014B },
        { "ensp;"sv, 0x02002 },
        { "eogon;"sv, 0x00119 },
        { "eopf;"sv, 0x1D556 },
        { "epar;"sv, 0x022D5 },
        { "eparsl;"sv, 0x029E3 },
        { "eplus;"sv, 0x02A71 },
        { "epsi;"sv, 0x003B5 },
        { "epsilon;"sv, 0x003B5 },
        { "epsiv;"sv, 0x003F5 },
        { "eqcirc;"sv, 0x02256 },
        { "eqcolon;"sv, 0x02255 },
        { "eqsim;"sv, 0x02242 },
        { "eqslantgtr;"sv, 0x02A96 },
        { "eqslantless;"sv, 0x02A95 },
        { "equals;"sv, 0x0003D },
        { "equest;"sv, 0x0225F },
        { "equiv;"sv, 0x02261 },
        { "equivDD;"sv, 0x02A78 },
        { "eqvparsl;"sv, 0x029E5 },
        { "erDot;"sv, 0x02253 },
        { "erarr;"sv, 0x02971 },
        { "escr;"sv, 0x0212F },
        { "esdot;"sv, 0x02250 },
        { "esim;"sv, 0x02242 },
        { "eta;"sv, 0x003B7 },
        { "eth;"sv, 0x000F0 },
        { "eth"sv, 0x000F0 },
        { "euml;"sv, 0x000EB },
        { "euml"sv, 0x000EB },
        { "euro;"sv, 0x020AC },
        { "excl;"sv, 0x00021 },
        { "exist;"sv, 0x02203 },
        { "expectation;"sv, 0x02130 },
        { "exponentiale;"sv, 0x02147 },
        { "fallingdotseq;"sv, 0x02252 },
        { "fcy;"sv, 0x00444 },
        { "female;"sv, 0x02640 },
        { "ffilig;"sv, 0x0FB03 },
        { "fflig;"sv, 0x0FB00 },
        { "ffllig;"sv, 0x0FB04 },
        { "ffr;"sv, 0x1D523 },
        { "filig;"sv, 0x0FB01 },
        { "flat;"sv, 0x0266D },
        { "fllig;"sv, 0x0FB02 },
        { "fltns;"sv, 0x025B1 },
        { "fnof;"sv, 0x00192 },
        { "fopf;"sv, 0x1D557 },
        { "forall;"sv, 0x02200 },
        { "fork;"sv, 0x022D4 },
        { "forkv;"sv, 0x02AD9 },
        { "fpartint;"sv, 0x02A0D },
        { "frac12;"sv, 0x000BD },
        { "frac12"sv, 0x000BD },
        { "frac13;"sv, 0x02153 },
        { "frac14;"sv, 0x000BC },
        { "frac14"sv, 0x000BC },
        { "frac15;"sv, 0x02155 },
        { "frac16;"sv, 0x02159 },
        { "frac18;"sv, 0x0215B },
        { "frac23;"sv, 0x02154 },
        { "frac25;"sv, 0x02156 },
        { "frac34;"sv, 0x000BE },
        { "frac34"sv, 0x000BE },
        { "frac35;"sv, 0x02157 },
        { "frac38;"sv, 0x0215C },
        { "frac45;"sv, 0x02158 },
        { "frac56;"sv, 0x0215A },
        { "frac58;"sv, 0x0215D },
        { "frac78;"sv, 0x0215E },
        { "frasl;"sv, 0x02044 },
        { "frown;"sv, 0x02322 },
        { "fscr;"sv, 0x1D4BB },
        { "gE;"sv, 0x02267 },
        { "gEl;"sv, 0x02A8C },
        { "gacute;"sv, 0x001F5 },
        { "gamma;"sv, 0x003B3 },
        { "gammad;"sv, 0x003DD },
        { "gap;"sv, 0x02A86 },
        { "gbreve;"sv, 0x0011F },
        { "gcirc;"sv, 0x0011D },
        { "gcy;"sv, 0x00433 },
        { "gdot;"sv, 0x00121 },
        { "ge;"sv, 0x02265 },
        { "gel;"sv, 0x022DB },
        { "geq;"sv, 0x02265 },
        { "geqq;"sv, 0x02267 },
        { "geqslant;"sv, 0x02A7E },
        { "ges;"sv, 0x02A7E },
        { "gescc;"sv, 0x02AA9 },
        { "gesdot;"sv, 0x02A80 },
        { "gesdoto;"sv, 0x02A82 },
        { "gesdotol;"sv, 0x02A84 },
        { "gesles;"sv, 0x02A94 },
        { "gfr;"sv, 0x1D524 },
        { "gg;"sv, 0x0226B },
        { "ggg;"sv, 0x022D9 },
        { "gimel;"sv, 0x02137 },
        { "gjcy;"sv, 0x00453 },
        { "gl;"sv, 0x02277 },
        { "glE;"sv, 0x02A92 },
        { "gla;"sv, 0x02AA5 },
        { "glj;"sv, 0x02AA4 },
        { "gnE;"sv, 0x02269 },
        { "gnap;"sv, 0x02A8A },
        { "gnapprox;"sv, 0x02A8A },
        { "gne;"sv, 0x02A88 },
        { "gneq;"sv, 0x02A88 },
        { "gneqq;"sv, 0x02269 },
        { "gnsim;"sv, 0x022E7 },
        { "gopf;"sv, 0x1D558 },
        { "grave;"sv, 0x00060 },
        { "gscr;"sv, 0x0210A },
        { "gsim;"sv, 0x02273 },
        { "gsime;"sv, 0x02A8E },
        { "gsiml;"sv, 0x02A90 },
        { "gt;"sv, 0x0003E },
        { "gt"sv, 0x0003E },
        { "gtcc;"sv, 0x02AA7 },
        { "gtcir;"sv, 0x02A7A },
        { "gtdot;"sv, 0x022D7 },
        { "gtlPar;"sv, 0x02995 },
        { "gtquest;"sv, 0x02A7C },
        { "gtrapprox;"sv, 0x02A86 },
        { "gtrarr;"sv, 0x02978 },
        { "gtrdot;"sv, 0x022D7 },
        { "gtreqless;"sv, 0x022DB },
        { "gtreqqless;"sv, 0x02A8C },
        { "gtrless;"sv, 0x02277 },
        { "gtrsim;"sv, 0x02273 },
        { "hArr;"sv, 0x021D4 },
        { "hairsp;"sv, 0x0200A },
        { "half;"sv, 0x000BD },
        { "hamilt;"sv, 0x0210B },
        { "hardcy;"sv, 0x0044A },
        { "harr;"sv, 0x02194 },
        { "harrcir;"sv, 0x02948 },
        { "harrw;"sv, 0x021AD },
        { "hbar;"sv, 0x0210F },
        { "hcirc;"sv, 0x00125 },
        { "hearts;"sv, 0x02665 },
        { "heartsuit;"sv, 0x02665 },
        { "hellip;"sv, 0x02026 },
        { "hercon;"sv, 0x022B9 },
        { "hfr;"sv, 0x1D525 },
        { "hksearow;"sv, 0x02925 },
        { "hkswarow;"sv, 0x02926 },
        { "hoarr;"sv, 0x021FF },
        { "homtht;"sv, 0x0223B },
        { "hookleftarrow;"sv, 0x021A9 },
        { "hookrightarrow;"sv, 0x021AA },
        { "hopf;"sv, 0x1D559 },
        { "horbar;"sv, 0x02015 },
        { "hscr;"sv, 0x1D4BD },
        { "hslash;"sv, 0x0210F },
        { "hstrok;"sv, 0x00127 },
        { "hybull;"sv, 0x02043 },
        { "hyphen;"sv, 0x02010 },
        { "iacute;"sv, 0x000ED },
        { "iacute"sv, 0x000ED },
        { "ic;"sv, 0x02063 },
        { "icirc;"sv, 0x000EE },
        { "icirc"sv, 0x000EE },
        { "icy;"sv, 0x00438 },
        { "iecy;"sv, 0x00435 },
        { "iexcl;"sv, 0x000A1 },
        { "iexcl"sv, 0x000A1 },
        { "iff;"sv, 0x021D4 },
        { "ifr;"sv, 0x1D526 },
        { "igrave;"sv, 0x000EC },
        { "igrave"sv, 0x000EC },
        { "ii;"sv, 0x02148 },
        { "iiiint;"sv, 0x02A0C },
        { "iiint;"sv, 0x0222D },
        { "iinfin;"sv, 0x029DC },
        { "iiota;"sv, 0x02129 },
        { "ijlig;"sv, 0x00133 },
        { "imacr;"sv, 0x0012B },
        { "image;"sv, 0x02111 },
        { "imagline;"sv, 0x02110 },
        { "imagpart;"sv, 0x02111 },
        { "imath;"sv, 0x00131 },
        { "imof;"sv, 0x022B7 },
        { "imped;"sv, 0x001B5 },
        { "in;"sv, 0x02208 },
        { "incare;"sv, 0x02105 },
        { "infin;"sv, 0x0221E },
        { "infintie;"sv, 0x029DD },
        { "inodot;"sv, 0x00131 },
        { "int;"sv, 0x0222B },
        { "intcal;"sv, 0x022BA },
        { "integers;"sv, 0x02124 },
        { "intercal;"sv, 0x022BA },
        { "intlarhk;"sv, 0x02A17 },
        { "intprod;"sv, 0x02A3C },
        { "iocy;"sv, 0x00451 },
        { "iogon;"sv, 0x0012F },
        { "iopf;"sv, 0x1D55A },
        { "iota;"sv, 0x003B9 },
        { "iprod;"sv, 0x02A3C },
        { "iquest;"sv, 0x000BF },
        { "iquest"sv, 0x000BF },
        { "iscr;"sv, 0x1D4BE },
        { "isin;"sv, 0x02208 },
        { "isinE;"sv, 0x022F9 },
        { "isindot;"sv, 0x022F5 },
        { "isins;"sv, 0x022F4 },
        { "isinsv;"sv, 0x022F3 },
        { "isinv;"sv, 0x02208 },
        { "it;"sv, 0x02062 },
        { "itilde;"sv, 0x00129 },
        { "iukcy;"sv, 0x00456 },
        { "iuml;"sv, 0x000EF },
        { "iuml"sv, 0x000EF },
        { "jcirc;"sv, 0x00135 },
        { "jcy;"sv, 0x00439 },
        { "jfr;"sv, 0x1D527 },
        { "jmath;"sv, 0x00237 },
        { "jopf;"sv, 0x1D55B },
        { "jscr;"sv, 0x1D4BF },
        { "jsercy;"sv, 0x00458 },
        { "jukcy;"sv, 0x00454 },
        { "kappa;"sv, 0x003BA },
        { "kappav;"sv, 0x003F0 },
        { "kcedil;"sv, 0x00137 },
        { "kcy;"sv, 0x0043A },
        { "kfr;"sv, 0x1D528 },
        { "kgreen;"sv, 0x00138 },
        { "khcy;"sv, 0x00445 },
        { "kjcy;"sv, 0x0045C },
        { "kopf;"sv, 0x1D55C },
        { "kscr;"sv, 0x1D4C0 },
        { "lAarr;"sv, 0x021DA },
        { "lArr;"sv, 0x021D0 },
        { "lAtail;"sv, 0x0291B },
        { "lBarr;"sv, 0x0290E },
        { "lE;"sv, 0x02266 },
        { "lEg;"sv, 0x02A8B },
        { "lHar;"sv, 0x02962 },
        { "lacute;"sv, 0x0013A },
        { "laemptyv;"sv, 0x029B4 },
        { "lagran;"sv, 0x02112 },
        { "lambda;"sv, 0x003BB },
        { "lang;"sv, 0x027E8 },
        { "langd;"sv, 0x02991 },
        { "langle;"sv, 0x027E8 },
        { "lap;"sv, 0x02A85 },
        { "laquo;"sv, 0x000AB },
        { "laquo"sv, 0x000AB },
        { "larr;"sv, 0x02190 },
        { "larrb;"sv, 0x021E4 },
        { "larrbfs;"sv, 0x0291F },
        { "larrfs;"sv, 0x0291D },
        { "larrhk;"sv, 0x021A9 },
        { "larrlp;"sv, 0x021AB },
        { "larrpl;"sv, 0x02939 },
        { "larrsim;"sv, 0x02973 },
        { "larrtl;"sv, 0x021A2 },
        { "lat;"sv, 0x02AAB },
        { "latail;"sv, 0x02919 },
        { "late;"sv, 0x02AAD },
        { "lbarr;"sv, 0x0290C },
        { "lbbrk;"sv, 0x02772 },
        { "lbrace;"sv, 0x0007B },
        { "lbrack;"sv, 0x0005B },
        { "lbrke;"sv, 0x0298B },
        { "lbrksld;"sv, 0x0298F },
        { "lbrkslu;"sv, 0x0298D },
        { "lcaron;"sv, 0x0013E },
        { "lcedil;"sv, 0x0013C },
        { "lceil;"sv, 0x02308 },
        { "lcub;"sv, 0x0007B },
        { "lcy;"sv, 0x0043B },
        { "ldca;"sv, 0x02936 },
        { "ldquo;"sv, 0x0201C },
        { "ldquor;"sv, 0x0201E },
        { "ldrdhar;"sv, 0x02967 },
        { "ldrushar;"sv, 0x0294B },
        { "ldsh;"sv, 0x021B2 },
        { "le;"sv, 0x02264 },
        { "leftarrow;"sv, 0x02190 },
        { "leftarrowtail;"sv, 0x021A2 },
        { "leftharpoondown;"sv, 0x021BD },
        { "leftharpoonup;"sv, 0x021BC },
        { "leftleftarrows;"sv, 0x021C7 },
        { "leftrightarrow;"sv, 0x02194 },
        { "leftrightarrows;"sv, 0x021C6 },
        { "leftrightharpoons;"sv, 0x021CB },
        { "leftrightsquigarrow;"sv, 0x021AD },
        { "leftthreetimes;"sv, 0x022CB },
        { "leg;"sv, 0x022DA },
        { "leq;"sv, 0x02264 },
        { "leqq;"sv, 0x02266 },
        { "leqslant;"sv, 0x02A7D },
        { "les;"sv, 0x02A7D },
        { "lescc;"sv, 0x02AA8 },
        { "lesdot;"sv, 0x02A7F },
        { "lesdoto;"sv, 0x02A81 },
        { "lesdotor;"sv, 0x02A83 },
        { "lesges;"sv, 0x02A93 },
        { "lessapprox;"sv, 0x02A85 },
        { "lessdot;"sv, 0x022D6 },
        { "lesseqgtr;"sv, 0x022DA },
        { "lesseqqgtr;"sv, 0x02A8B },
        { "lessgtr;"sv, 0x02276 },
        { "lesssim;"sv, 0x02272 },
        { "lfisht;"sv, 0x0297C },
        { "lfloor;"sv, 0x0230A },
        { "lfr;"sv, 0x1D529 },
        { "lg;"sv, 0x02276 },
        { "lgE;"sv, 0x02A91 },
        { "lhard;"sv, 0x021BD },
        { "lharu;"sv, 0x021BC },
        { "lharul;"sv, 0x0296A },
        { "lhblk;"sv, 0x02584 },
        { "ljcy;"sv, 0x00459 },
        { "ll;"sv, 0x0226A },
        { "llarr;"sv, 0x021C7 },
        { "llcorner;"sv, 0x0231E },
        { "llhard;"sv, 0x0296B },
        { "lltri;"sv, 0x025FA },
        { "lmidot;"sv, 0x00140 },
        { "lmoust;"sv, 0x023B0 },
        { "lmoustache;"sv, 0x023B0 },
        { "lnE;"sv, 0x02268 },
        { "lnap;"sv, 0x02A89 },
        { "lnapprox;"sv, 0x02A89 },
        { "lne;"sv, 0x02A87 },
        { "lneq;"sv, 0x02A87 },
        { "lneqq;"sv, 0x02268 },
        { "lnsim;"sv, 0x022E6 },
        { "loang;"sv, 0x027EC },
        { "loarr;"sv, 0x021FD },
        { "lobrk;"sv, 0x027E6 },
        { "longleftarrow;"sv, 0x027F5 },
        { "longleftrightarrow;"sv, 0x027F7 },
        { "longmapsto;"sv, 0x027FC },
        { "longrightarrow;"sv, 0x027F6 },
        { "looparrowleft;"sv, 0x021AB },
        { "looparrowright;"sv, 0x021AC },
        { "lopar;"sv, 0x02985 },
        { "lopf;"sv, 0x1D55D },
        { "loplus;"sv, 0x02A2D },
        { "lotimes;"sv, 0x02A34 },
        { "lowast;"sv, 0x02217 },
        { "lowbar;"sv, 0x0005F },
        { "loz;"sv, 0x025CA },
        { "lozenge;"sv, 0x025CA },
        { "lozf;"sv, 0x029EB },
        { "lpar;"sv, 0x00028 },
        { "lparlt;"sv, 0x02993 },
        { "lrarr;"sv, 0x021C6 },
        { "lrcorner;"sv, 0x0231F },
        { "lrhar;"sv, 0x021CB },
        { "lrhard;"sv, 0x0296D },
        { "lrm;"sv, 0x0200E },
        { "lrtri;"sv, 0x022BF },
        { "lsaquo;"sv, 0x02039 },
        { "lscr;"sv, 0x1D4C1 },
        { "lsh;"sv, 0x021B0 },
        { "lsim;"sv, 0x02272 },
        { "lsime;"sv, 0x02A8D },
        { "lsimg;"sv, 0x02A8F },
        { "lsqb;"sv, 0x0005B },
        { "lsquo;"sv, 0x02018 },
        { "lsquor;"sv, 0x0201A },
        { "lstrok;"sv, 0x00142 },
        { "lt;"sv, 0x0003C },
        { "lt"sv, 0x0003C },
        { "ltcc;"sv, 0x02AA6 },
        { "ltcir;"sv, 0x02A79 },
        { "ltdot;"sv, 0x022D6 },
        { "lthree;"sv, 0x022CB },
        { "ltimes;"sv, 0x022C9 },
        { "ltlarr;"sv, 0x02976 },
        { "ltquest;"sv, 0x02A7B },
        { "ltrPar;"sv, 0x02996 },
        { "ltri;"sv, 0x025C3 },
        { "ltrie;"sv, 0x022B4 },
        { "ltrif;"sv, 0x025C2 },
        { "lurdshar;"sv, 0x0294A },
        { "luruhar;"sv, 0x02966 },
        { "mDDot;"sv, 0x0223A },
        { "macr;"sv, 0x000AF },
        { "macr"sv, 0x000AF },
        { "male;"sv, 0x02642 },
        { "malt;"sv, 0x02720 },
        { "maltese;"sv, 0x02720 },
        { "map;"sv, 0x021A6 },
        { "mapsto;"sv, 0x021A6 },
        { "mapstodown;"sv, 0x021A7 },
        { "mapstoleft;"sv, 0x021A4 },
        { "mapstoup;"sv, 0x021A5 },
        { "marker;"sv, 0x025AE },
        { "mcomma;"sv, 0x02A29 },
        { "mcy;"sv, 0x0043C },
        { "mdash;"sv, 0x02014 },
        { "measuredangle;"sv, 0x02221 },
        { "mfr;"sv, 0x1D52A },
        { "mho;"sv, 0x02127 },
        { "micro;"sv, 0x000B5 },
        { "micro"sv, 0x000B5 },
        { "mid;"sv, 0x02223 },
        { "midast;"sv, 0x0002A },
        { "midcir;"sv, 0x02AF0 },
        { "middot;"sv, 0x000B7 },
        { "middot"sv, 0x000B7 },
        { "minus;"sv, 0x02212 },
        { "minusb;"sv, 0x0229F },
        { "minusd;"sv, 0x02238 },
        { "minusdu;"sv, 0x02A2A },
        { "mlcp;"sv, 0x02ADB },
        { "mldr;"sv, 0x02026 },
        { "mnplus;"sv, 0x02213 },
        { "models;"sv, 0x022A7 },
        { "mopf;"sv, 0x1D55E },
        { "mp;"sv, 0x02213 },
        { "mscr;"sv, 0x1D4C2 },
        { "mstpos;"sv, 0x0223E },
        { "mu;"sv, 0x003BC },
        { "multimap;"sv, 0x022B8 },
        { "mumap;"sv, 0x022B8 },
        { "nLeftarrow;"sv, 0x021CD },
        { "nLeftrightarrow;"sv, 0x021CE },
        { "nRightarrow;"sv, 0x021CF },
        { "nVDash;"sv, 0x022AF },
        { "nVdash;"sv, 0x022AE },
        { "nabla;"sv, 0x02207 },
        { "nacute;"sv, 0x00144 },
        { "nap;"sv, 0x02249 },
        { "napos;"sv, 0x00149 },
        { "napprox;"sv, 0x02249 },
        { "natur;"sv, 0x0266E },
        { "natural;"sv, 0x0266E },
        { "naturals;"sv, 0x02115 },
        { "nbsp;"sv, 0x000A0 },
        { "nbsp"sv, 0x000A0 },
        { "ncap;"sv, 0x02A43 },
        { "ncaron;"sv, 0x00148 },
        { "ncedil;"sv, 0x00146 },
        { "ncong;"sv, 0x02247 },
        { "ncup;"sv, 0x02A42 },
        { "ncy;"sv, 0x0043D },
        { "ndash;"sv, 0x02013 },
        { "ne;"sv, 0x02260 },
        { "neArr;"sv, 0x021D7 },
        { "nearhk;"sv, 0x02924 },
        { "nearr;"sv, 0x02197 },
        { "nearrow;"sv, 0x02197 },
        { "nequiv;"sv, 0x02262 },
        { "nesear;"sv, 0x02928 },
        { "nexist;"sv, 0x02204 },
        { "nexists;"sv, 0x02204 },
        { "nfr;"sv, 0x1D52B },
        { "nge;"sv, 0x02271 },
        { "ngeq;"sv, 0x02271 },
        { "ngsim;"sv, 0x02275 },
        { "ngt;"sv, 0x0226F },
        { "ngtr;"sv, 0x0226F },
        { "nhArr;"sv, 0x021CE },
        { "nharr;"sv, 0x021AE },
        { "nhpar;"sv, 0x02AF2 },
        { "ni;"sv, 0x0220B },
        { "nis;"sv, 0x022FC },
        { "nisd;"sv, 0x022FA },
        { "niv;"sv, 0x0220B },
        { "njcy;"sv, 0x0045A },
        { "nlArr;"sv, 0x021CD },
        { "nlarr;"sv, 0x0219A },
        { "nldr;"sv, 0x02025 },
        { "nle;"sv, 0x02270 },
        { "nleftarrow;"sv, 0x0219A },
        { "nleftrightarrow;"sv, 0x021AE },
        { "nleq;"sv, 0x02270 },
        { "nless;"sv, 0x0226E },
        { "nlsim;"sv, 0x02274 },
        { "nlt;"sv, 0x0226E },
        { "nltri;"sv, 0x022EA },
        { "nltrie;"sv, 0x022EC },
        { "nmid;"sv, 0x02224 },
        { "nopf;"sv, 0x1D55F },
        { "not;"sv, 0x000AC },
        { "not"sv, 0x000AC },
        { "notin;"sv, 0x02209 },
        { "notinva;"sv, 0x02209 },
        { "notinvb;"sv, 0x022F7 },
        { "notinvc;"sv, 0x022F6 },
        { "notni;"sv, 0x0220C },
        { "notniva;"sv, 0x0220C },
        { "notnivb;"sv, 0x022FE },
        { "notnivc;"sv, 0x022FD },
        { "npar;"sv, 0x02226 },
        { "nparallel;"sv, 0x02226 },
        { "npolint;"sv, 0x02A14 },
        { "npr;"sv, 0x02280 },
        { "nprcue;"sv, 0x022E0 },
        { "nprec;"sv, 0x02280 },
        { "nrArr;"sv, 0x021CF },
        { "nrarr;"sv, 0x0219B },
        { "nrightarrow;"sv, 0x0219B },
        { "nrtri;"sv, 0x022EB },
        { "nrtrie;"sv, 0x022ED },
        { "nsc;"sv, 0x02281 },
        { "nsccue;"sv, 0x022E1 },
        { "nscr;"sv, 0x1D4C3 },
        { "nshortmid;"sv, 0x02224 },
        { "nshortparallel;"sv, 0x02226 },
        { "nsim;"sv, 0x02241 },
        { "nsime;"sv, 0x02244 },
        { "nsimeq;"sv, 0x02244 },
        { "nsmid;"sv, 0x02224 },
        { "nspar;"sv, 0x02226 },
        { "nsqsube;"sv, 0x022E2 },
        { "nsqsupe;"sv, 0x022E3 },
        { "nsub;"sv, 0x02284 },
        { "nsube;"sv, 0x02288 },
        { "nsubseteq;"sv, 0x02288 },
        { "nsucc;"sv, 0x02281 },
        { "nsup;"sv, 0x02285 },
        { "nsupe;"sv, 0x02289 },
        { "nsupseteq;"sv, 0x02289 },
        { "ntgl;"sv, 0x02279 },
        { "ntilde;"sv, 0x000F1 },
        { "ntilde"sv, 0x000F1 },
        { "ntlg;"sv, 0x02278 },
        { "ntriangleleft;"sv, 0x022EA },
        { "ntrianglelefteq;"sv, 0x022EC },
        { "ntriangleright;"sv, 0x022EB },
        { "ntrianglerighteq;"sv, 0x022ED },
        { "nu;"sv, 0x003BD },
        { "num;"sv, 0x00023 },
        { "numero;"sv, 0x02116 },
        { "numsp;"sv, 0x02007 },
        { "nvDash;"sv, 0x022AD },
        { "nvHarr;"sv, 0x02904 },
        { "nvdash;"sv, 0x022AC },
        { "nvinfin;"sv, 0x029DE },
        { "nvlArr;"sv, 0x02902 },
        { "nvrArr;"sv, 0x02903 },
        { "nwArr;"sv, 0x021D6 },
        { "nwarhk;"sv, 0x02923 },
        { "nwarr;"sv, 0x02196 },
        { "nwarrow;"sv, 0x02196 },
        { "nwnear;"sv, 0x02927 },
        { "oS;"sv, 0x024C8 },
        { "oacute;"sv, 0x000F3 },
        { "oacute"sv, 0x000F3 },
        { "oast;"sv, 0x0229B },
        { "ocir;"sv, 0x0229A },
        { "ocirc;"sv, 0x000F4 },
        { "ocirc"sv, 0x000F4 },
        { "ocy;"sv, 0x0043E },
        { "odash;"sv, 0x0229D },
        { "odblac;"sv, 0x00151 },
        { "odiv;"sv, 0x02A38 },
        { "odot;"sv, 0x02299 },
        { "odsold;"sv, 0x029BC },
        { "oelig;"sv, 0x00153 },
        { "ofcir;"sv, 0x029BF },
        { "ofr;"sv, 0x1D52C },
        { "ogon;"sv, 0x002DB },
        { "ograve;"sv, 0x000F2 },
        { "ograve"sv, 0x000F2 },
        { "ogt;"sv, 0x029C1 },
        { "ohbar;"sv, 0x029B5 },
        { "ohm;"sv, 0x003A9 },
        { "oint;"sv, 0x0222E },
        { "olarr;"sv, 0x021BA },
        { "olcir;"sv, 0x029BE },
        { "olcross;"sv, 0x029BB },
        { "oline;"sv, 0x0203E },
        { "olt;"sv, 0x029C0 },
        { "omacr;"sv, 0x0014D },
        { "omega;"sv, 0x003C9 },
        { "omicron;"sv, 0x003BF },
        { "omid;"sv, 0x029B6 },
        { "ominus;"sv, 0x02296 },
        { "oopf;"sv, 0x1D560 },
        { "opar;"sv, 0x029B7 },
        { "operp;"sv, 0x029B9 },
        { "oplus;"sv, 0x02295 },
        { "or;"sv, 0x02228 },
        { "orarr;"sv, 0x021BB },
        { "ord;"sv, 0x02A5D },
        { "order;"sv, 0x02134 },
        { "orderof;"sv, 0x02134 },
        { "ordf;"sv, 0x000AA },
        { "ordf"sv, 0x000AA },
        { "ordm;"sv, 0x000BA },
        { "ordm"sv, 0x000BA },
        { "origof;"sv, 0x022B6 },
        { "oror;"sv, 0x02A56 },
        { "orslope;"sv, 0x02A57 },
        { "orv;"sv, 0x02A5B },
        { "oscr;"sv, 0x02134 },
        { "oslash;"sv, 0x000F8 },
        { "oslash"sv, 0x000F8 },
        { "osol;"sv, 0x02298 },
        { "otilde;"sv, 0x000F5 },
        { "otilde"sv, 0x000F5 },
        { "otimes;"sv, 0x02297 },
        { "otimesas;"sv, 0x02A36 },
        { "ouml;"sv, 0x000F6 },
        { "ouml"sv, 0x000F6 },
        { "ovbar;"sv, 0x0233D },
        { "par;"sv, 0x02225 },
        { "para;"sv, 0x000B6 },
        { "para"sv, 0x000B6 },
        { "parallel;"sv, 0x02225 },
        { "parsim;"sv, 0x02AF3 },
        { "parsl;"sv, 0x02AFD },
        { "part;"sv, 0x02202 },
        { "pcy;"sv, 0x0043F },
        { "percnt;"sv, 0x00025 },
        { "period;"sv, 0x0002E },
        { "permil;"sv, 0x02030 },
        { "perp;"sv, 0x022A5 },
        { "pertenk;"sv, 0x02031 },
        { "pfr;"sv, 0x1D52D },
        { "phi;"sv, 0x003C6 },
        { "phiv;"sv, 0x003D5 },
        { "phmmat;"sv, 0x02133 },
        { "phone;"sv, 0x0260E },
        { "pi;"sv, 0x003C0 },
        { "pitchfork;"sv, 0x022D4 },
        { "piv;"sv, 0x003D6 },
        { "planck;"sv, 0x0210F },
        { "planckh;"sv, 0x0210E },
        { "plankv;"sv, 0x0210F },
        { "plus;"sv, 0x0002B },
        { "plusacir;"sv, 0x02A23 },
        { "plusb;"sv, 0x0229E },
        { "pluscir;"sv, 0x02A22 },
        { "plusdo;"sv, 0x02214 },
        { "plusdu;"sv, 0x02A25 },
        { "pluse;"sv, 0x02A72 },
        { "plusmn;"sv, 0x000B1 },
        { "plusmn"sv, 0x000B1 },
        { "plussim;"sv, 0x02A26 },
        { "plustwo;"sv, 0x02A27 },
        { "pm;"sv, 0x000B1 },
        { "pointint;"sv, 0x02A15 },
        { "popf;"sv, 0x1D561 },
        { "pound;"sv, 0x000A3 },
        { "pound"sv, 0x000A3 },
        { "pr;"sv, 0x0227A },
        { "prE;"sv, 0x02AB3 },
        { "prap;"sv, 0x02AB7 },
        { "prcue;"sv, 0x0227C },
        { "pre;"sv, 0x02AAF },
        { "prec;"sv, 0x0227A },
        { "precapprox;"sv, 0x02AB7 },
        { "preccurlyeq;"sv, 0x0227C },
        { "preceq;"sv, 0x02AAF },
        { "precnapprox;"sv, 0x02AB9 },
        { "precneqq;"sv, 0x02AB5 },
        { "precnsim;"sv, 0x022E8 },
        { "precsim;"sv, 0x0227E },
        { "prime;"sv, 0x02032 },
        { "primes;"sv, 0x02119 },
        { "prnE;"sv, 0x02AB5 },
        { "prnap;"sv, 0x02AB9 },
        { "prnsim;"sv, 0x022E8 },
        { "prod;"sv, 0x0220F },
        { "profalar;"sv, 0x0232E },
        { "profline;"sv, 0x02312 },
        { "profsurf;"sv, 0x02313 },
        { "prop;"sv, 0x0221D },
        { "propto;"sv, 0x0221D },
        { "prsim;"sv, 0x0227E },
        { "prurel;"sv, 0x022B0 },
        { "pscr;"sv, 0x1D4C5 },
        { "psi;"sv, 0x003C8 },
        { "puncsp;"sv, 0x02008 },
        { "qfr;"sv, 0x1D52E },
        { "qint;"sv, 0x02A0C },
        { "qopf;"sv, 0x1D562 },
        { "qprime;"sv, 0x02057 },
        { "qscr;"sv, 0x1D4C6 },
        { "quaternions;"sv, 0x0210D },
        { "quatint;"sv, 0x02A16 },
        { "quest;"sv, 0x0003F },
        { "questeq;"sv, 0x0225F },
        { "quot;"sv, 0x00022 },
        { "quot"sv, 0x00022 },
        { "rAarr;"sv, 0x021DB },
        { "rArr;"sv, 0x021D2 },
        { "rAtail;"sv, 0x0291C },
        { "rBarr;"sv, 0x0290F },
        { "rHar;"sv, 0x02964 },
        { "racute;"sv, 0x00155 },
        { "radic;"sv, 0x0221A },
        { "raemptyv;"sv, 0x029B3 },
        { "rang;"sv, 0x027E9 },
        { "rangd;"sv, 0x02992 },
        { "range;"sv, 0x029A5 },
        { "rangle;"sv, 0x027E9 },
        { "raquo;"sv, 0x000BB },
        { "raquo"sv, 0x000BB },
        { "rarr;"sv, 0x02192 },
        { "rarrap;"sv, 0x02975 },
        { "rarrb;"sv, 0x021E5 },
        { "rarrbfs;"sv, 0x02920 },
        { "rarrc;"sv, 0x02933 },
        { "rarrfs;"sv, 0x0291E },
        { "rarrhk;"sv, 0x021AA },
        { "rarrlp;"sv, 0x021AC },
        { "rarrpl;"sv, 0x02945 },
        { "rarrsim;"sv, 0x02974 },
        { "rarrtl;"sv, 0x021A3 },
        { "rarrw;"sv, 0x0219D },
        { "ratail;"sv, 0x0291A },
        { "ratio;"sv, 0x02236 },
        { "rationals;"sv, 0x0211A },
        { "rbarr;"sv, 0x0290D },
        { "rbbrk;"sv, 0x02773 },
        { "rbrace;"sv, 0x0007D },
        { "rbrack;"sv, 0x0005D },
        { "rbrke;"sv, 0x0298C },
        { "rbrksld;"sv, 0x0298E },
        { "rbrkslu;"sv, 0x02990 },
        { "rcaron;"sv, 0x00159 },
        { "rcedil;"sv, 0x00157 },
        { "rceil;"sv, 0x02309 },
        { "rcub;"sv, 0x0007D },
        { "rcy;"sv, 0x00440 },
        { "rdca;"sv, 0x02937 },
        { "rdldhar;"sv, 0x02969 },
        { "rdquo;"sv, 0x0201D },
        { "rdquor;"sv, 0x0201D },
        { "rdsh;"sv, 0x021B3 },
        { "real;"sv, 0x0211C },
        { "realine;"sv, 0x0211B },
        { "realpart;"sv, 0x0211C },
        { "reals;"sv, 0x0211D },
        { "rect;"sv, 0x025AD },
        { "reg;"sv, 0x000AE },
        { "reg"sv, 0x000AE },
        { "rfisht;"sv, 0x0297D },
        { "rfloor;"sv, 0x0230B },
        { "rfr;"sv, 0x1D52F },
        { "rhard;"sv, 0x021C1 },
        { "rharu;"sv, 0x021C0 },
        { "rharul;"sv, 0x0296C },
        { "rho;"sv, 0x003C1 },
        { "rhov;"sv, 0x003F1 },
        { "rightarrow;"sv, 0x02192 },
        { "rightarrowtail;"sv, 0x021A3 },
        { "rightharpoondown;"sv, 0x021C1 },
        { "rightharpoonup;"sv, 0x021C0 },
        { "rightleftarrows;"sv, 0x021C4 },
        { "rightleftharpoons;"sv, 0x021CC },
        { "rightrightarrows;"sv, 0x021C9 },
        { "rightsquigarrow;"sv, 0x0219D },
        { "rightthreetimes;"sv, 0x022CC },
        { "ring;"sv, 0x002DA },
        { "risingdotseq;"sv, 0x02253 },
        { "rlarr;"sv, 0x021C4 },
        { "rlhar;"sv, 0x021CC },
        { "rlm;"sv, 0x0200F },
        { "rmoust;"sv, 0x023B1 },
        { "rmoustache;"sv, 0x023B1 },
        { "rnmid;"sv, 0x02AEE },
        { "roang;"sv, 0x027ED },
        { "roarr;"sv, 0x021FE },
        { "robrk;"sv, 0x027E7 },
        { "ropar;"sv, 0x02986 },
        { "ropf;"sv, 0x1D563 },
        { "roplus;"sv, 0x02A2E },
        { "rotimes;"sv, 0x02A35 },
        { "rpar;"sv, 0x00029 },
        { "rpargt;"sv, 0x02994 },
        { "rppolint;"sv, 0x02A12 },
        { "rrarr;"sv, 0x021C9 },
        { "rsaquo;"sv, 0x0203A },
        { "rscr;"sv, 0x1D4C7 },
        { "rsh;"sv, 0x021B1 },
        { "rsqb;"sv, 0x0005D },
        { "rsquo;"sv, 0x02019 },
        { "rsquor;"sv, 0x02019 },
        { "rthree;"sv, 0x022CC },
        { "rtimes;"sv, 0x022CA },
        { "rtri;"sv, 0x025B9 },
        { "rtrie;"sv, 0x022B5 },
        { "rtrif;"sv, 0x025B8 },
        { "rtriltri;"sv, 0x029CE },
        { "ruluhar;"sv, 0x02968 },
        { "rx;"sv, 0x0211E },
        { "sacute;"sv, 0x0015B },
        { "sbquo;"sv, 0x0201A },
        { "sc;"sv, 0x0227B },
        { "scE;"sv, 0x02AB4 },
        { "scap;"sv, 0x02AB8 },
        { "scaron;"sv, 0x00161 },
        { "sccue;"sv, 0x0227D },
        { "sce;"sv, 0x02AB0 },
        { "scedil;"sv, 0x0015F },
        { "scirc;"sv, 0x0015D },
        { "scnE;"sv, 0x02AB6 },
        { "scnap;"sv, 0x02ABA },
        { "scnsim;"sv, 0x022E9 },
        { "scpolint;"sv, 0x02A13 },
        { "scsim;"sv, 0x0227F },
        { "scy;"sv, 0x00441 },
        { "sdot;"sv, 0x022C5 },
        { "sdotb;"sv, 0x022A1 },
        { "sdote;"sv, 0x02A66 },
        { "seArr;"sv, 0x021D8 },
        { "searhk;"sv, 0x02925 },
        { "searr;"sv, 0x02198 },
        { "searrow;"sv, 0x02198 },
        { "sect;"sv, 0x000A7 },
        { "sect"sv, 0x000A7 },
        { "semi;"sv, 0x0003B },
        { "seswar;"sv, 0x02929 },
        { "setminus;"sv, 0x02216 },
        { "setmn;"sv, 0x02216 },
        { "sext;"sv, 0x02736 },
        { "sfr;"sv, 0x1D530 },
        { "sfrown;"sv, 0x02322 },
        { "sharp;"sv, 0x0266F },
        { "shchcy;"sv, 0x00449 },
        { "shcy;"sv, 0x00448 },
        { "shortmid;"sv, 0x02223 },
        { "shortparallel;"sv, 0x02225 },
        { "shy;"sv, 0x000AD },
        { "shy"sv, 0x000AD },
        { "sigma;"sv, 0x003C3 },
        { "sigmaf;"sv, 0x003C2 },
        { "sigmav;"sv, 0x003C2 },
        { "sim;"sv, 0x0223C },
        { "simdot;"sv, 0x02A6A },
        { "sime;"sv, 0x02243 },
        { "simeq;"sv, 0x02243 },
        { "simg;"sv, 0x02A9E },
        { "simgE;"sv, 0x02AA0 },
        { "siml;"sv, 0x02A9D },
        { "simlE;"sv, 0x02A9F },
        { "simne;"sv, 0x02246 },
        { "simplus;"sv, 0x02A24 },
        { "simrarr;"sv, 0x02972 },
        { "slarr;"sv, 0x02190 },
        { "smallsetminus;"sv, 0x02216 },
        { "smashp;"sv, 0x02A33 },
        { "smeparsl;"sv, 0x029E4 },
        { "smid;"sv, 0x02223 },
        { "smile;"sv, 0x02323 },
        { "smt;"sv, 0x02AAA },
        { "smte;"sv, 0x02AAC },
        { "softcy;"sv, 0x0044C },
        { "sol;"sv, 0x0002F },
        { "solb;"sv, 0x029C4 },
        { "solbar;"sv, 0x0233F },
        { "sopf;"sv, 0x1D564 },
        { "spades;"sv, 0x02660 },
        { "spadesuit;"sv, 0x02660 },
        { "spar;"sv, 0x02225 },
        { "sqcap;"sv, 0x02293 },
        { "sqcup;"sv, 0x02294 },
        { "sqsub;"sv, 0x0228F },
        { "sqsube;"sv, 0x02291 },
        { "sqsubset;"sv, 0x0228F },
        { "sqsubseteq;"sv, 0x02291 },
        { "sqsup;"sv, 0x02290 },
        { "sqsupe;"sv, 0x02292 },
        { "sqsupset;"sv, 0x02290 },
        { "sqsupseteq;"sv, 0x02292 },
        { "squ;"sv, 0x025A1 },
        { "square;"sv, 0x025A1 },
        { "squarf;"sv, 0x025AA },
        { "squf;"sv, 0x025AA },
        { "srarr;"sv, 0x02192 },
        { "sscr;"sv, 0x1D4C8 },
        { "ssetmn;"sv, 0x02216 },
        { "ssmile;"sv, 0x02323 },
        { "sstarf;"sv, 0x022C6 },
        { "star;"sv, 0x02606 },
        { "starf;"sv, 0x02605 },
        { "straightepsilon;"sv, 0x003F5 },
        { "straightphi;"sv, 0x003D5 },
        { "strns;"sv, 0x000AF },
        { "sub;"sv, 0x02282 },
        { "subE;"sv, 0x02AC5 },
        { "subdot;"sv, 0x02ABD },
        { "sube;"sv, 0x02286 },
        { "subedot;"sv, 0x02AC3 },
        { "submult;"sv, 0x02AC1 },
        { "subnE;"sv, 0x02ACB },
        { "subne;"sv, 0x0228A },
        { "subplus;"sv, 0x02ABF },
        { "subrarr;"sv, 0x02979 },
        { "subset;"sv, 0x02282 },
        { "subseteq;"sv, 0x02286 },
        { "subseteqq;"sv, 0x02AC5 },
        { "subsetneq;"sv, 0x0228A },
        { "subsetneqq;"sv, 0x02ACB },
        { "subsim;"sv, 0x02AC7 },
        { "subsub;"sv, 0x02AD5 },
        { "subsup;"sv, 0x02AD3 },
        { "succ;"sv, 0x0227B },
        { "succapprox;"sv, 0x02AB8 },
        { "succcurlyeq;"sv, 0x0227D },
        { "succeq;"sv, 0x02AB0 },
        { "succnapprox;"sv, 0x02ABA },
        { "succneqq;"sv, 0x02AB6 },
        { "succnsim;"sv, 0x022E9 },
        { "succsim;"sv, 0x0227F },
        { "sum;"sv, 0x02211 },
        { "sung;"sv, 0x0266A },
        { "sup1;"sv, 0x000B9 },
        { "sup1"sv, 0x000B9 },
        { "sup2;"sv, 0x000B2 },
        { "sup2"sv, 0x000B2 },
        { "sup3;"sv, 0x000B3 },
        { "sup3"sv, 0x000B3 },
        { "sup;"sv, 0x02283 },
        { "supE;"sv, 0x02AC6 },
        { "supdot;"sv, 0x02ABE },
        { "supdsub;"sv, 0x02AD8 },
        { "supe;"sv, 0x02287 },
        { "supedot;"sv, 0x02AC4 },
        { "suphsol;"sv, 0x027C9 },
        { "suphsub;"sv, 0x02AD7 },
        { "suplarr;"sv, 0x0297B },
        { "supmult;"sv, 0x02AC2 },
        { "supnE;"sv, 0x02ACC },
        { "supne;"sv, 0x0228B },
        { "supplus;"sv, 0x02AC0 },
        { "supset;"sv, 0x02283 },
        { "supseteq;"sv, 0x02287 },
        { "supseteqq;"sv, 0x02AC6 },
        { "supsetneq;"sv, 0x0228B },
        { "supsetneqq;"sv, 0x02ACC },
        { "supsim;"sv, 0x02AC8 },
        { "supsub;"sv, 0x02AD4 },
        { "supsup;"sv, 0x02AD6 },
        { "swArr;"sv, 0x021D9 },
        { "swarhk;"sv, 0x02926 },
        { "swarr;"sv, 0x02199 },
        { "swarrow;"sv, 0x02199 },
        { "swnwar;"sv, 0x0292A },
        { "szlig;"sv, 0x000DF },
        { "szlig"sv, 0x000DF },
        { "target;"sv, 0x02316 },
        { "tau;"sv, 0x003C4 },
        { "tbrk;"sv, 0x023B4 },
        { "tcaron;"sv, 0x00165 },
        { "tcedil;"sv, 0x00163 },
        { "tcy;"sv, 0x00442 },
        { "tdot;"sv, 0x020DB },
        { "telrec;"sv, 0x02315 },
        { "tfr;"sv, 0x1D531 },
        { "there4;"sv, 0x02234 },
        { "therefore;"sv, 0x02234 },
        { "theta;"sv, 0x003B8 },
        { "thetasym;"sv, 0x003D1 },
        { "thetav;"sv, 0x003D1 },
        { "thickapprox;"sv, 0x02248 },
        { "thicksim;"sv, 0x0223C },
        { "thinsp;"sv, 0x02009 },
        { "thkap;"sv, 0x02248 },
        { "thksim;"sv, 0x0223C },
        { "thorn;"sv, 0x000FE },
        { "thorn"sv, 0x000FE },
        { "tilde;"sv, 0x002DC },
        { "times;"sv, 0x000D7 },
        { "times"sv, 0x000D7 },
        { "timesb;"sv, 0x022A0 },
        { "timesbar;"sv, 0x02A31 },
        { "timesd;"sv, 0x02A30 },
        { "tint;"sv, 0x0222D },
        { "toea;"sv, 0x02928 },
        { "top;"sv, 0x022A4 },
        { "topbot;"sv, 0x02336 },
        { "topcir;"sv, 0x02AF1 },
        { "topf;"sv, 0x1D565 },
        { "topfork;"sv, 0x02ADA },
        { "tosa;"sv, 0x02929 },
        { "tprime;"sv, 0x02034 },
        { "trade;"sv, 0x02122 },
        { "triangle;"sv, 0x025B5 },
        { "triangledown;"sv, 0x025BF },
        { "triangleleft;"sv, 0x025C3 },
        { "trianglelefteq;"sv, 0x022B4 },
        { "triangleq;"sv, 0x0225C },
        { "triangleright;"sv, 0x025B9 },
        { "trianglerighteq;"sv, 0x022B5 },
        { "tridot;"sv, 0x025EC },
        { "trie;"sv, 0x0225C },
        { "triminus;"sv, 0x02A3A },
        { "triplus;"sv, 0x02A39 },
        { "trisb;"sv, 0x029CD },
        { "tritime;"sv, 0x02A3B },
        { "trpezium;"sv, 0x023E2 },
        { "tscr;"sv, 0x1D4C9 },
        { "tscy;"sv, 0x00446 },
        { "tshcy;"sv, 0x0045B },
        { "tstrok;"sv, 0x00167 },
        { "twixt;"sv, 0x0226C },
        { "twoheadleftarrow;"sv, 0x0219E },
        { "twoheadrightarrow;"sv, 0x021A0 },
        { "uArr;"sv, 0x021D1 },
        { "uHar;"sv, 0x02963 },
        { "uacute;"sv, 0x000FA },
        { "uacute"sv, 0x000FA },
        { "uarr;"sv, 0x02191 },
        { "ubrcy;"sv, 0x0045E },
        { "ubreve;"sv, 0x0016D },
        { "ucirc;"sv, 0x000FB },
        { "ucirc"sv, 0x000FB },
        { "ucy;"sv, 0x00443 },
        { "udarr;"sv, 0x021C5 },
        { "udblac;"sv, 0x00171 },
        { "udhar;"sv, 0x0296E },
        { "ufisht;"sv, 0x0297E },
        { "ufr;"sv, 0x1D532 },
        { "ugrave;"sv, 0x000F9 },
        { "ugrave"sv, 0x000F9 },
        { "uharl;"sv, 0x021BF },
        { "uharr;"sv, 0x021BE },
        { "uhblk;"sv, 0x02580 },
        { "ulcorn;"sv, 0x0231C },
        { "ulcorner;"sv, 0x0231C },
        { "ulcrop;"sv, 0x0230F },
        { "ultri;"sv, 0x025F8 },
        { "umacr;"sv, 0x0016B },
        { "uml;"sv, 0x000A8 },
        { "uml"sv, 0x000A8 },
        { "uogon;"sv, 0x00173 },
        { "uopf;"sv, 0x1D566 },
        { "uparrow;"sv, 0x02191 },
        { "updownarrow;"sv, 0x02195 },
        { "upharpoonleft;"sv, 0x021BF },
        { "upharpoonright;"sv, 0x021BE },
        { "uplus;"sv, 0x0228E },
        { "upsi;"sv, 0x003C5 },
        { "upsih;"sv, 0x003D2 },
        { "upsilon;"sv, 0x003C5 },
        { "upuparrows;"sv, 0x021C8 },
        { "urcorn;"sv, 0x0231D },
        { "urcorner;"sv, 0x0231D },
        { "urcrop;"sv, 0x0230E },
        { "uring;"sv, 0x0016F },
        { "urtri;"sv, 0x025F9 },
        { "uscr;"sv, 0x1D4CA },
        { "utdot;"sv, 0x022F0 },
        { "utilde;"sv, 0x00169 },
        { "utri;"sv, 0x025B5 },
        { "utrif;"sv, 0x025B4 },
        { "uuarr;"sv, 0x021C8 },
        { "uuml;"sv, 0x000FC },
        { "uuml"sv, 0x000FC },
        { "uwangle;"sv, 0x029A7 },
        { "vArr;"sv, 0x021D5 },
        { "vBar;"sv, 0x02AE8 },
        { "vBarv;"sv, 0x02AE9 },
        { "vDash;"sv, 0x022A8 },
        { "vangrt;"sv, 0x0299C },
        { "varepsilon;"sv, 0x003F5 },
        { "varkappa;"sv, 0x003F0 },
        { "varnothing;"sv, 0x02205 },
        { "varphi;"sv, 0x003D5 },
        { "varpi;"sv, 0x003D6 },
        { "varpropto;"sv, 0x0221D },
        { "varr;"sv, 0x02195 },
        { "varrho;"sv, 0x003F1 },
        { "varsigma;"sv, 0x003C2 },
        { "vartheta;"sv, 0x003D1 },
        { "vartriangleleft;"sv, 0x022B2 },
        { "vartriangleright;"sv, 0x022B3 },
        { "vcy;"sv, 0x00432 },
        { "vdash;"sv, 0x022A2 },
        { "vee;"sv, 0x02228 },
        { "veebar;"sv, 0x022BB },
        { "veeeq;"sv, 0x0225A },
        { "vellip;"sv, 0x022EE },
        { "verbar;"sv, 0x0007C },
        { "vert;"sv, 0x0007C },
        { "vfr;"sv, 0x1D533 },
        { "vltri;"sv, 0x022B2 },
        { "vopf;"sv, 0x1D567 },
        { "vprop;"sv, 0x0221D },
        { "vrtri;"sv, 0x022B3 },
        { "vscr;"sv, 0x1D4CB },
        { "vzigzag;"sv, 0x0299A },
        { "wcirc;"sv, 0x00175 },
        { "wedbar;"sv, 0x02A5F },
        { "wedge;"sv, 0x02227 },
        { "wedgeq;"sv, 0x02259 },
        { "weierp;"sv, 0x02118 },
        { "wfr;"sv, 0x1D534 },
        { "wopf;"sv, 0x1D568 },
        { "wp;"sv, 0x02118 },
        { "wr;"sv, 0x02240 },
        { "wreath;"sv, 0x02240 },
        { "wscr;"sv, 0x1D4CC },
        { "xcap;"sv, 0x022C2 },
        { "xcirc;"sv, 0x025EF },
        { "xcup;"sv, 0x022C3 },
        { "xdtri;"sv, 0x025BD },
        { "xfr;"sv, 0x1D535 },
        { "xhArr;"sv, 0x027FA },
        { "xharr;"sv, 0x027F7 },
        { "xi;"sv, 0x003BE },
        { "xlArr;"sv, 0x027F8 },
        { "xlarr;"sv, 0x027F5 },
        { "xmap;"sv, 0x027FC },
        { "xnis;"sv, 0x022FB },
        { "xodot;"sv, 0x02A00 },
        { "xopf;"sv, 0x1D569 },
        { "xoplus;"sv, 0x02A01 },
        { "xotime;"sv, 0x02A02 },
        { "xrArr;"sv, 0x027F9 },
        { "xrarr;"sv, 0x027F6 },
        { "xscr;"sv, 0x1D4CD },
        { "xsqcup;"sv, 0x02A06 },
        { "xuplus;"sv, 0x02A04 },
        { "xutri;"sv, 0x025B3 },
        { "xvee;"sv, 0x022C1 },
        { "xwedge;"sv, 0x022C0 },
        { "yacute;"sv, 0x000FD },
        { "yacute"sv, 0x000FD },
        { "yacy;"sv, 0x0044F },
        { "ycirc;"sv, 0x00177 },
        { "ycy;"sv, 0x0044B },
        { "yen;"sv, 0x000A5 },
        { "yen"sv, 0x000A5 },
        { "yfr;"sv, 0x1D536 },
        { "yicy;"sv, 0x00457 },
        { "yopf;"sv, 0x1D56A },
        { "yscr;"sv, 0x1D4CE },
        { "yucy;"sv, 0x0044E },
        { "yuml;"sv, 0x000FF },
        { "yuml"sv, 0x000FF },
        { "zacute;"sv, 0x0017A },
        { "zcaron;"sv, 0x0017E },
        { "zcy;"sv, 0x00437 },
        { "zdot;"sv, 0x0017C },
        { "zeetrf;"sv, 0x02128 },
        { "zeta;"sv, 0x003B6 },
        { "zfr;"sv, 0x1D537 },
        { "zhcy;"sv, 0x00436 },
        { "zigrarr;"sv, 0x021DD },
        { "zopf;"sv, 0x1D56B },
        { "zscr;"sv, 0x1D4CF },
        { "zwj;"sv, 0x0200D },
        { "zwnj;"sv, 0x0200C }
    };

    constexpr struct {
        StringView entity;
        u32 code_point1;
        u32 code_point2;
    } double_code_point_entities[] = {
        { "NotEqualTilde;"sv, 0x02242, 0x00338 },
        { "NotGreaterFullEqual;"sv, 0x02267, 0x00338 },
        { "NotGreaterGreater;"sv, 0x0226B, 0x00338 },
        { "NotGreaterSlantEqual;"sv, 0x02A7E, 0x00338 },
        { "NotHumpDownHump;"sv, 0x0224E, 0x00338 },
        { "NotHumpEqual;"sv, 0x0224F, 0x00338 },
        { "NotLeftTriangleBar;"sv, 0x029CF, 0x00338 },
        { "NotLessLess;"sv, 0x0226A, 0x00338 },
        { "NotLessSlantEqual;"sv, 0x02A7D, 0x00338 },
        { "NotNestedGreaterGreater;"sv, 0x02AA2, 0x00338 },
        { "NotNestedLessLess;"sv, 0x02AA1, 0x00338 },
        { "NotPrecedesEqual;"sv, 0x02AAF, 0x00338 },
        { "NotRightTriangleBar;"sv, 0x029D0, 0x00338 },
        { "NotSquareSubset;"sv, 0x0228F, 0x00338 },
        { "NotSquareSuperset;"sv, 0x02290, 0x00338 },
        { "NotSubset;"sv, 0x02282, 0x020D2 },
        { "NotSucceedsEqual;"sv, 0x02AB0, 0x00338 },
        { "NotSucceedsTilde;"sv, 0x0227F, 0x00338 },
        { "NotSuperset;"sv, 0x02283, 0x020D2 },
        { "ThickSpace;"sv, 0x0205F, 0x0200A },
        { "acE;"sv, 0x0223E, 0x00333 },
        { "bne;"sv, 0x0003D, 0x020E5 },
        { "bnequiv;"sv, 0x02261, 0x020E5 },
        { "caps;"sv, 0x02229, 0x0FE00 },
        { "cups;"sv, 0x0222A, 0x0FE00 },
        { "fjlig;"sv, 0x00066, 0x0006A },
        { "gesl;"sv, 0x022DB, 0x0FE00 },
        { "gvertneqq;"sv, 0x02269, 0x0FE00 },
        { "gvnE;"sv, 0x02269, 0x0FE00 },
        { "lates;"sv, 0x02AAD, 0x0FE00 },
        { "lesg;"sv, 0x022DA, 0x0FE00 },
        { "lvertneqq;"sv, 0x02268, 0x0FE00 },
        { "lvnE;"sv, 0x02268, 0x0FE00 },
        { "nGg;"sv, 0x022D9, 0x00338 },
        { "nGt;"sv, 0x0226B, 0x020D2 },
        { "nGtv;"sv, 0x0226B, 0x00338 },
        { "nLl;"sv, 0x022D8, 0x00338 },
        { "nLt;"sv, 0x0226A, 0x020D2 },
        { "nLtv;"sv, 0x0226A, 0x00338 },
        { "nang;"sv, 0x02220, 0x020D2 },
        { "napE;"sv, 0x02A70, 0x00338 },
        { "napid;"sv, 0x0224B, 0x00338 },
        { "nbump;"sv, 0x0224E, 0x00338 },
        { "nbumpe;"sv, 0x0224F, 0x00338 },
        { "ncongdot;"sv, 0x02A6D, 0x00338 },
        { "nedot;"sv, 0x02250, 0x00338 },
        { "nesim;"sv, 0x02242, 0x00338 },
        { "ngE;"sv, 0x02267, 0x00338 },
        { "ngeqq;"sv, 0x02267, 0x00338 },
        { "ngeqslant;"sv, 0x02A7E, 0x00338 },
        { "nges;"sv, 0x02A7E, 0x00338 },
        { "nlE;"sv, 0x02266, 0x00338 },
        { "nleqq;"sv, 0x02266, 0x00338 },
        { "nleqslant;"sv, 0x02A7D, 0x00338 },
        { "nles;"sv, 0x02A7D, 0x00338 },
        { "notinE;"sv, 0x022F9, 0x00338 },
        { "notindot;"sv, 0x022F5, 0x00338 },
        { "nparsl;"sv, 0x02AFD, 0x020E5 },
        { "npart;"sv, 0x02202, 0x00338 },
        { "npre;"sv, 0x02AAF, 0x00338 },
        { "npreceq;"sv, 0x02AAF, 0x00338 },
        { "nrarrc;"sv, 0x02933, 0x00338 },
        { "nrarrw;"sv, 0x0219D, 0x00338 },
        { "nsce;"sv, 0x02AB0, 0x00338 },
        { "nsubE;"sv, 0x02AC5, 0x00338 },
        { "nsubset;"sv, 0x02282, 0x020D2 },
        { "nsubseteqq;"sv, 0x02AC5, 0x00338 },
        { "nsucceq;"sv, 0x02AB0, 0x00338 },
        { "nsupE;"sv, 0x02AC6, 0x00338 },
        { "nsupset;"sv, 0x02283, 0x020D2 },
        { "nsupseteqq;"sv, 0x02AC6, 0x00338 },
        { "nvap;"sv, 0x0224D, 0x020D2 },
        { "nvge;"sv, 0x02265, 0x020D2 },
        { "nvgt;"sv, 0x0003E, 0x020D2 },
        { "nvle;"sv, 0x02264, 0x020D2 },
        { "nvlt;"sv, 0x0003C, 0x020D2 },
        { "nvltrie;"sv, 0x022B4, 0x020D2 },
        { "nvrtrie;"sv, 0x022B5, 0x020D2 },
        { "nvsim;"sv, 0x0223C, 0x020D2 },
        { "race;"sv, 0x0223D, 0x00331 },
        { "smtes;"sv, 0x02AAC, 0x0FE00 },
        { "sqcaps;"sv, 0x02293, 0x0FE00 },
        { "sqcups;"sv, 0x02294, 0x0FE00 },
        { "varsubsetneq;"sv, 0x0228A, 0x0FE00 },
        { "varsubsetneqq;"sv, 0x02ACB, 0x0FE00 },
        { "varsupsetneq;"sv, 0x0228B, 0x0FE00 },
        { "varsupsetneqq;"sv, 0x02ACC, 0x0FE00 },
        { "vnsub;"sv, 0x02282, 0x020D2 },
        { "vnsup;"sv, 0x02283, 0x020D2 },
        { "vsubnE;"sv, 0x02ACB, 0x0FE00 },
        { "vsubne;"sv, 0x0228A, 0x0FE00 },
        { "vsupnE;"sv, 0x02ACC, 0x0FE00 },
        { "vsupne;"sv, 0x0228B, 0x0FE00 },
    };

    EntityMatch match;

    for (auto& single_code_point_entity : single_code_point_entities) {
        if (entity.starts_with(single_code_point_entity.entity)) {
            if (match.entity.is_null() || single_code_point_entity.entity.length() > match.entity.length())
                match = { { single_code_point_entity.code_point }, single_code_point_entity.entity };
        }
    }

    for (auto& double_code_point_entity : double_code_point_entities) {
        if (entity.starts_with(double_code_point_entity.entity)) {
            if (match.entity.is_null() || double_code_point_entity.entity.length() > match.entity.length())
                match = EntityMatch { { double_code_point_entity.code_point1, double_code_point_entity.code_point2 }, StringView(double_code_point_entity.entity) };
        }
    }

    if (match.entity.is_empty())
        return {};
    return match;
}

}
}
