test("test harness test", () => {
    expect(parseWebAssemblyModule).not.toBeUndefined();
    expect(readBinaryWasmFile).not.toBeUndefined();
    expect(compareTypedArrays).not.toBeUndefined();
});

test("parsing can pass", () => {
    // prettier-ignore
    let binary = new Uint8Array([
        0x00, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00, 0x01, 0x86, 0x80, 0x80, 0x80, 0x00, 0x01, 0x60,
        0x01, 0x7f, 0x01, 0x7f, 0x02, 0xba, 0x80, 0x80, 0x80, 0x00, 0x02, 0x03, 0x65, 0x6e, 0x76, 0x0f,
        0x5f, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x02,
        0x00, 0x00, 0x03, 0x65, 0x6e, 0x76, 0x19, 0x5f, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x72, 0x65, 0x63,
        0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
        0x01, 0x70, 0x00, 0x00, 0x03, 0x82, 0x80, 0x80, 0x80, 0x00, 0x01, 0x00, 0x0a, 0xcd, 0x80, 0x80,
        0x80, 0x00, 0x01, 0x4b, 0x01, 0x03, 0x7f, 0x41, 0x00, 0x21, 0x01, 0x02, 0x40, 0x02, 0x40, 0x20,
        0x00, 0x41, 0x02, 0x4e, 0x0d, 0x00, 0x20, 0x00, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x41, 0x00, 0x21,
        0x01, 0x03, 0x40, 0x20, 0x00, 0x41, 0x7f, 0x6a, 0x10, 0x80, 0x80, 0x80, 0x80, 0x00, 0x20, 0x01,
        0x6a, 0x21, 0x01, 0x20, 0x00, 0x41, 0x03, 0x4a, 0x21, 0x03, 0x20, 0x00, 0x41, 0x7e, 0x6a, 0x22,
        0x02, 0x21, 0x00, 0x20, 0x03, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x02, 0x20, 0x01, 0x6a, 0x0b, 0x00,
        0x97, 0x80, 0x80, 0x80, 0x00, 0x07, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x02, 0x08, 0x88,
        0x80, 0x80, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x66, 0x69, 0x62, 0x00, 0x90, 0x80, 0x80,
        0x80, 0x00, 0x0a, 0x72, 0x65, 0x6c, 0x6f, 0x63, 0x2e, 0x43, 0x4f, 0x44, 0x45, 0x03, 0x01, 0x00,
        0x27, 0x00, 0x00, 0xa6, 0x80, 0x80, 0x80, 0x00, 0x09, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
        0x72, 0x73, 0x01, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x2d, 0x62, 0x79,
        0x01, 0x05, 0x63, 0x6c, 0x61, 0x6e, 0x67, 0x06, 0x31, 0x31, 0x2e, 0x31, 0x2e, 0x30,
    ]);
    // This just checks that the function actually works
    expect(() => parseWebAssemblyModule(binary)).toThrowWithMessage(TypeError, "Link failed");
});

test("parsing can fail", () => {
    let binary = new Uint8Array([0, 0x32, 0x73, 0x6d]);
    expect(() => parseWebAssemblyModule(binary)).toThrow(
        SyntaxError,
        "Incorrect module magic (did not match \\0asm)"
    );
});

test("file reading can pass", () => {
    // prettier-ignore
    let referenceContents = new Uint8Array([
        0x00, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00, 0x05, 0x03, 0x01, 0x00,
        0x00, 0x07, 0x0a, 0x01, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x02,
        0x00, 0x00, 0x17, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61,
        0x70, 0x70, 0x69, 0x6e, 0x67, 0x55, 0x52, 0x4c, 0x05, 0x66, 0x61, 0x6c,
        0x73, 0x65
    ]);

    let contents = readBinaryWasmFile("Fixtures/Modules/empty-module.wasm");
    expect(compareTypedArrays(contents, referenceContents)).toBe(true);
});

test("file reading can fail", () => {
    expect(() => readBinaryWasmFile("Fixtures/this-file-must-not-exist.wasm")).toThrow(
        TypeError,
        "No such file or directory"
    );
});
