#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
#
# Ansible module to manage Check Point Firewall (c) 2019
#
# Ansible is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ansible is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <http://www.gnu.org/licenses/>.
#

from __future__ import (absolute_import, division, print_function)

__metaclass__ = type

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ['preview'],
                    'supported_by': 'community'}

DOCUMENTATION = """
---
module: cp_mgmt_global_assignment
short_description: Manages global-assignment objects on Check Point over Web Services API
description:
  - Manages global-assignment objects on Check Point devices including creating, updating and removing objects.
  - All operations are performed over Web Services API.
version_added: "2.9"
author: "Or Soffer (@chkp-orso)"
options:
  dependent_domain:
    description:
      - N/A
    type: str
  global_access_policy:
    description:
      - Global domain access policy that is assigned to a dependent domain.
    type: str
  global_domain:
    description:
      - N/A
    type: str
  global_threat_prevention_policy:
    description:
      - Global domain threat prevention policy that is assigned to a dependent domain.
    type: str
  manage_protection_actions:
    description:
      - N/A
    type: bool
  details_level:
    description:
      - The level of detail for some of the fields in the response can vary from showing only the UID value of the object to a fully detailed
        representation of the object.
    type: str
    choices: ['uid', 'standard', 'full']
  ignore_warnings:
    description:
      - Apply changes ignoring warnings.
    type: bool
  ignore_errors:
    description:
      - Apply changes ignoring errors. You won't be able to publish such a changes. If ignore-warnings flag was omitted - warnings will also be ignored.
    type: bool
extends_documentation_fragment: check_point.mgmt.checkpoint_objects
"""

EXAMPLES = """
- name: add-global-assignment
  cp_mgmt_global_assignment:
    dependent_domain: domain2
    global_access_policy: standard
    global_domain: Global
    global_threat_prevention_policy: standard
    manage_protection_actions: true
    state: present

- name: set-global-assignment
  cp_mgmt_global_assignment:
    dependent_domain: domain1
    global_domain: Global2
    global_threat_prevention_policy: ''
    manage_protection_actions: false
    state: present

- name: delete-global-assignment
  cp_mgmt_global_assignment:
    dependent_domain: domain1
    global_domain: Global2
    state: absent
"""

RETURN = """
cp_mgmt_global_assignment:
  description: The checkpoint object created or updated.
  returned: always, except when deleting the object.
  type: dict
"""

from ansible.module_utils.basic import AnsibleModule
from ansible_collections.check_point.mgmt.plugins.module_utils.checkpoint import checkpoint_argument_spec_for_objects, api_call


def main():
    argument_spec = dict(
        dependent_domain=dict(type='str'),
        global_access_policy=dict(type='str'),
        global_domain=dict(type='str'),
        global_threat_prevention_policy=dict(type='str'),
        manage_protection_actions=dict(type='bool'),
        details_level=dict(type='str', choices=['uid', 'standard', 'full']),
        ignore_warnings=dict(type='bool'),
        ignore_errors=dict(type='bool')
    )
    argument_spec.update(checkpoint_argument_spec_for_objects)

    module = AnsibleModule(argument_spec=argument_spec, supports_check_mode=True)
    api_call_object = 'global-assignment'

    result = api_call(module, api_call_object)
    module.exit_json(**result)


if __name__ == '__main__':
    main()
