#!/usr/local/bin/bash

# Checks if netdata is running in a kubernetes pod and fetches that pod's labels

if [ -z "${KUBERNETES_SERVICE_HOST}" ] || [ -z "${KUBERNETES_PORT_443_TCP_PORT}" ] || [ -z "${MY_POD_NAMESPACE}" ] || [ -z "${MY_POD_NAME}" ]; then
  exit 0
fi

if ! command -v jq > /dev/null 2>&1; then
  echo "jq command not available. Please install jq to get host labels for kubernetes pods."
  exit 1
fi

TOKEN="$(< /var/run/secrets/kubernetes.io/serviceaccount/token)"
HEADER="Authorization: Bearer $TOKEN"
HOST="$KUBERNETES_SERVICE_HOST:$KUBERNETES_PORT_443_TCP_PORT"

URL="https://$HOST/api/v1/namespaces/$MY_POD_NAMESPACE/pods/$MY_POD_NAME"
if ! POD_DATA=$(curl -sSk -H "$HEADER" "$URL" 2>&1); then
  echo "error on curl '${URL}': ${POD_DATA}."
  exit 1
fi

URL="https://$HOST/api/v1/namespaces/kube-system"
if ! KUBE_SYSTEM_NS_DATA=$(curl -sSk -H "$HEADER" "$URL" 2>&1); then
  echo "error on curl '${URL}': ${KUBE_SYSTEM_NS_DATA}."
  exit 1
fi

if ! POD_LABELS=$(jq -r '.metadata.labels' <<< "$POD_DATA" | grep ':' | tr -d '," ' 2>&1); then
  echo "error on 'jq' parse pod data: ${POD_LABELS}."
  exit 1
fi

if ! KUBE_SYSTEM_NS_UID=$(jq -r '.metadata.uid' <<< "$KUBE_SYSTEM_NS_DATA" 2>&1); then
  echo "error on 'jq' parse kube_system_ns: ${KUBE_SYSTEM_NS_UID}."
  exit 1
fi

echo -e "$POD_LABELS\nk8s_cluster_id:$KUBE_SYSTEM_NS_UID"
exit 0
