require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PMAP_H_)) {
    eval 'sub _MACHINE_PMAP_H_ () {1;}' unless defined(&_MACHINE_PMAP_H_);
    eval 'sub PG_V () {0x1;}' unless defined(&PG_V);
    eval 'sub PG_RW () {0x2;}' unless defined(&PG_RW);
    eval 'sub PG_U () {0x4;}' unless defined(&PG_U);
    eval 'sub PG_NC_PWT () {0x8;}' unless defined(&PG_NC_PWT);
    eval 'sub PG_NC_PCD () {0x10;}' unless defined(&PG_NC_PCD);
    eval 'sub PG_A () {0x20;}' unless defined(&PG_A);
    eval 'sub PG_M () {0x40;}' unless defined(&PG_M);
    eval 'sub PG_PS () {0x80;}' unless defined(&PG_PS);
    eval 'sub PG_PTE_PAT () {0x80;}' unless defined(&PG_PTE_PAT);
    eval 'sub PG_G () {0x100;}' unless defined(&PG_G);
    eval 'sub PG_AVAIL1 () {0x200;}' unless defined(&PG_AVAIL1);
    eval 'sub PG_AVAIL2 () {0x400;}' unless defined(&PG_AVAIL2);
    eval 'sub PG_AVAIL3 () {0x800;}' unless defined(&PG_AVAIL3);
    eval 'sub PG_PDE_PAT () {0x1000;}' unless defined(&PG_PDE_PAT);
    if(defined(&PAE) || defined(&PAE_TABLES)) {
	eval 'sub PG_NX () {(1<<63);}' unless defined(&PG_NX);
    }
    eval 'sub PG_W () { &PG_AVAIL1;}' unless defined(&PG_W);
    eval 'sub PG_MANAGED () { &PG_AVAIL2;}' unless defined(&PG_MANAGED);
    eval 'sub PG_PROMOTED () { &PG_AVAIL3;}' unless defined(&PG_PROMOTED);
    if(defined(&PAE) || defined(&PAE_TABLES)) {
	eval 'sub PG_FRAME () {(0xffffffffff000);}' unless defined(&PG_FRAME);
	eval 'sub PG_PS_FRAME () {(0xfffffffe00000);}' unless defined(&PG_PS_FRAME);
    } else {
	eval 'sub PG_FRAME () {(~ &PAGE_MASK);}' unless defined(&PG_FRAME);
	eval 'sub PG_PS_FRAME () {(0xffc00000);}' unless defined(&PG_PS_FRAME);
    }
    eval 'sub PG_PROT () {( &PG_RW| &PG_U);}' unless defined(&PG_PROT);
    eval 'sub PG_N () {( &PG_NC_PWT| &PG_NC_PCD);}' unless defined(&PG_N);
    eval 'sub PG_PDE_CACHE () {( &PG_PDE_PAT |  &PG_NC_PWT |  &PG_NC_PCD);}' unless defined(&PG_PDE_CACHE);
    eval 'sub PG_PTE_CACHE () {( &PG_PTE_PAT |  &PG_NC_PWT |  &PG_NC_PCD);}' unless defined(&PG_PTE_CACHE);
    eval 'sub PG_PTE_PROMOTE () {( &PG_MANAGED |  &PG_W |  &PG_G |  &PG_PTE_PAT |  &PG_M |  &PG_A |  &PG_NC_PCD |  &PG_NC_PWT |  &PG_U |  &PG_RW |  &PG_V);}' unless defined(&PG_PTE_PROMOTE);
    eval 'sub PGEX_P () {0x1;}' unless defined(&PGEX_P);
    eval 'sub PGEX_W () {0x2;}' unless defined(&PGEX_W);
    eval 'sub PGEX_U () {0x4;}' unless defined(&PGEX_U);
    eval 'sub PGEX_RSV () {0x8;}' unless defined(&PGEX_RSV);
    eval 'sub PGEX_I () {0x10;}' unless defined(&PGEX_I);
    unless(defined(&KVA_PAGES)) {
	if(defined(&PAE) || defined(&PAE_TABLES)) {
	    eval 'sub KVA_PAGES () {512;}' unless defined(&KVA_PAGES);
	} else {
	    eval 'sub KVA_PAGES () {256;}' unless defined(&KVA_PAGES);
	}
    }
    eval 'sub VADDR {
        my($pdi, $pti) = @_;
	    eval q((( &vm_offset_t)((($pdi)<< &PDRSHIFT)|(($pti)<< &PAGE_SHIFT))));
    }' unless defined(&VADDR);
    unless(defined(&NKPT)) {
	if(defined(&PAE)) {
	    eval 'sub NKPT () {240;}' unless defined(&NKPT);
	}
 elsif(defined(&PAE_TABLES)) {
	    eval 'sub NKPT () {60;}' unless defined(&NKPT);
	} else {
	    eval 'sub NKPT () {30;}' unless defined(&NKPT);
	}
    }
    unless(defined(&NKPDE)) {
	eval 'sub NKPDE () {( &KVA_PAGES);}' unless defined(&NKPDE);
    }
    eval 'sub KPTDI () {( &NPDEPTD- &NKPDE);}' unless defined(&KPTDI);
    eval 'sub PTDPTDI () {( &KPTDI- &NPGPTD);}' unless defined(&PTDPTDI);
    eval 'sub ISA_HOLE_START () {0xa0000;}' unless defined(&ISA_HOLE_START);
    eval 'sub ISA_HOLE_LENGTH () {(0x100000- &ISA_HOLE_START);}' unless defined(&ISA_HOLE_LENGTH);
    unless(defined(&LOCORE)) {
	require 'sys/queue.ph';
	require 'sys/_cpuset.ph';
	require 'sys/_lock.ph';
	require 'sys/_mutex.ph';
	require 'vm/_vm_radix.ph';
	if(defined(&PAE) || defined(&PAE_TABLES)) {
	    eval 'sub PTESHIFT () {(3);}' unless defined(&PTESHIFT);
	    eval 'sub PDESHIFT () {(3);}' unless defined(&PDESHIFT);
	} else {
	    eval 'sub PTESHIFT () {(2);}' unless defined(&PTESHIFT);
	    eval 'sub PDESHIFT () {(2);}' unless defined(&PDESHIFT);
	}
	if(defined(&_KERNEL)) {
	    if(defined(&PAE) || defined(&PAE_TABLES)) {
	    }
	    eval 'sub vtopte {
	        my($va) = @_;
    		eval q(( &PTmap +  &i386_btop($va)));
	    }' unless defined(&vtopte);
	    eval 'sub vtophys {
	        my($va) = @_;
    		eval q( &pmap_kextract(( &vm_offset_t)($va)));
	    }' unless defined(&vtophys);
	    if((defined(&PAE) || defined(&PAE_TABLES))) {
		eval 'sub pde_cmpset {
		    my($pdep, $old, $new) = @_;
    		    eval q( &atomic_cmpset_64_i586($pdep, $old, $new));
		}' unless defined(&pde_cmpset);
		eval 'sub pte_load_store {
		    my($ptep, $pte) = @_;
    		    eval q( &atomic_swap_64_i586($ptep, $pte));
		}' unless defined(&pte_load_store);
		eval 'sub pte_load_clear {
		    my($ptep) = @_;
    		    eval q( &atomic_swap_64_i586($ptep, 0));
		}' unless defined(&pte_load_clear);
		eval 'sub pte_store {
		    my($ptep, $pte) = @_;
    		    eval q( &atomic_store_rel_64_i586($ptep, $pte));
		}' unless defined(&pte_store);
	    } else {
		eval 'sub pde_cmpset {
		    my($pdep, $old, $new) = @_;
    		    eval q( &atomic_cmpset_int($pdep, $old, $new));
		}' unless defined(&pde_cmpset);
		eval 'sub pte_load_store {
		    my($ptep, $pte) = @_;
    		    eval q( &atomic_swap_int($ptep, $pte));
		}' unless defined(&pte_load_store);
		eval 'sub pte_load_clear {
		    my($ptep) = @_;
    		    eval q( &atomic_swap_int($ptep, 0));
		}' unless defined(&pte_load_clear);
		eval 'sub pte_store {
		    my($ptep, $pte) = @_;
    		    eval q( &do { * = ($pte); }  &while (0));
		}' unless defined(&pte_store);
	    }
	    eval 'sub pte_clear {
	        my($ptep) = @_;
    		eval q( &pte_store($ptep, 0));
	    }' unless defined(&pte_clear);
	    eval 'sub pde_store {
	        my($pdep, $pde) = @_;
    		eval q( &pte_store($pdep, $pde));
	    }' unless defined(&pde_store);
	}
	if(defined(&PAE) || defined(&PAE_TABLES)) {
	}
	if(defined(&_KERNEL)) {
	    eval 'sub kernel_pmap () {( &kernel_pmap_store);}' unless defined(&kernel_pmap);
	    eval 'sub PMAP_LOCK {
	        my($pmap) = @_;
    		eval q( &mtx_lock(($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_LOCK);
	    eval 'sub PMAP_LOCK_ASSERT {
	        my($pmap, $type) = @_;
    		eval q( &mtx_assert(($pmap)-> &pm_mtx, ($type)));
	    }' unless defined(&PMAP_LOCK_ASSERT);
	    eval 'sub PMAP_LOCK_DESTROY {
	        my($pmap) = @_;
    		eval q( &mtx_destroy(($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_LOCK_DESTROY);
	    eval 'sub PMAP_LOCK_INIT {
	        my($pmap) = @_;
    		eval q( &mtx_init(($pmap)-> &pm_mtx, \\"pmap\\",  &NULL,  &MTX_DEF |  &MTX_DUPOK));
	    }' unless defined(&PMAP_LOCK_INIT);
	    eval 'sub PMAP_LOCKED {
	        my($pmap) = @_;
    		eval q( &mtx_owned(($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_LOCKED);
	    eval 'sub PMAP_MTX {
	        my($pmap) = @_;
    		eval q((($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_MTX);
	    eval 'sub PMAP_TRYLOCK {
	        my($pmap) = @_;
    		eval q( &mtx_trylock(($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_TRYLOCK);
	    eval 'sub PMAP_UNLOCK {
	        my($pmap) = @_;
    		eval q( &mtx_unlock(($pmap)-> &pm_mtx));
	    }' unless defined(&PMAP_UNLOCK);
	}
	eval 'sub _NPCM () {11;}' unless defined(&_NPCM);
	eval 'sub _NPCPV () {336;}' unless defined(&_NPCPV);
	if(defined(&_KERNEL)) {
	    eval 'sub pmap_page_get_memattr {
	        my($m) = @_;
    		eval q((( &vm_memattr_t)($m)-> ($md->{pat_mode})));
	    }' unless defined(&pmap_page_get_memattr);
	    eval 'sub pmap_page_is_write_mapped {
	        my($m) = @_;
    		eval q(((($m)-> &aflags &  &PGA_WRITEABLE) != 0));
	    }' unless defined(&pmap_page_is_write_mapped);
	    eval 'sub pmap_unmapbios {
	        my($va, $sz) = @_;
    		eval q( &pmap_unmapdev(($va), ($sz)));
	    }' unless defined(&pmap_unmapbios);
	}
    }
}
1;
