#!/bin/sh

if [ -r /etc/defaults/periodic.conf ]
then
    . /etc/defaults/periodic.conf
    source_periodic_confs
fi

PATH=$PATH:/usr/local/bin:/usr/local/sbin
export PATH

case "$weekly_acme_client_enable" in
    [Yy][Ee][Ss])
	echo
	echo "Checking Let's Encrypt certificate status:"

	if [ -x "$weekly_acme_client_renewscript" ] ; then
		$weekly_acme_client_renewscript
	else
		: ${weekly_acme_client_args:="-b"}
		if [ -z "$weekly_acme_client_domains" ] ; then
			weekly_acme_client_domains=$(hostname -f)
			echo "Using hostname: $weekly_acme_client_domains"
		fi
		if [ -n "$weekly_acme_client_challengedir" ] ; then
			weekly_acme_client_args="$weekly_acme_client_args -C $weekly_acme_client_challengedir"
		fi
		/usr/local/bin/acme-client $weekly_acme_client_args $weekly_acme_client_domains
	fi

	if [ -n "$weekly_acme_client_deployscript" ] ; then
		if [ -x "$weekly_acme_client_deployscript" ] ; then
			echo "Deploying Let's Encrypt certificates:"
			$weekly_acme_client_deployscript
		else
			echo 'Skipped, deploy script does not exist or is not executable'
		fi
	fi
        ;;
    *)
        ;;
esac
