'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 18 January 2007 at 10:50:25 am'!
Object subclass: #PrintJob
	instanceVariableNames: 'sessionBits sessionIndex pageRect'
	classVariableNames: 'Registry'
	poolDictionaries: ''
	category: 'Graphics-Text'!

!PrintJob commentStamp: 'JMM 2/9/2002 00:47' prior: 0!
A simple print interface by johnmci@smalltalkconsulting.com
Originally written for macintosh carbon applications.

Usually you invoke a utility method to print a set of forms, or postscript objects.
Basically you invoke
primPrintSetup to setup printing for a set of pages.
printPreProcessing: totalPages to setup printing, which later must exit by 
calling printPostProcessing
then you invoke pagePreProcessing to setup to print a page, which later must exit by
calling pagePostProcessing
Then you invoke setForm: or setPostscript: to image a form or postscript as many 
times as needed, then as mentioned pagePostProcessing to close the page, and 
finaly printPostProcessing to close the print job, with printCleanup to release all 
the resources. !


!PrintJob methodsFor: 'accessors' stamp: 'JMM 2/9/2002 13:50'!
session
	sessionIndex isNil ifTrue:[^nil].
	(Smalltalk externalObjects at: sessionIndex ifAbsent: [^nil]) == sessionBits 
		ifTrue: [^sessionBits]
		ifFalse: [^nil].
! !

!PrintJob methodsFor: 'initialize-release' stamp: 'pe 12/16/2006 16:52'!
initialize
	pageRect := Rectangle origin: 0@0 corner: 0@0.
	paperRect := Rectangle origin: 0@0 corner: 0@0.
	dpi := (300@300).
	sessionBits _ self primPrintSetup.
	sessionBits notNil ifTrue: 
		[sessionIndex _ Smalltalk registerExternalObject: sessionBits.
		self register]
	! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/8/2002 00:13'!
pagePostProcessing
	^self primPagePostProcessing: self session ! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/8/2002 00:14'!
pagePreProcessing
	^self primPagePreProcessing: self session ! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/9/2002 01:32'!
printCleanup
	[self primPrintCleanup: self session] ensure: [self finalize]! !

!PrintJob methodsFor: 'logic' stamp: 'pe 12/16/2006 16:55'!
printFullPageForm: aForm
	| status statusPostProcessing |
	self session isNil ifTrue: [self beep. ^-1].
	[status _ self printPreProcessing: 1 dpi: dpi.

	"printPreProcessing: dpi: returns these values:
	Transcript show: 'pageRect: ', pageRect; cr.
	Transcript show: 'paperRect: ', paperRect; cr.
	Transcript show: 'dpi: ', dpi; cr.	"
	
	self pagePreProcessing.
	status ~= 0 ifTrue: [^status].
	self setFullPageForm: aForm]
		ensure: 
			[
			self pagePostProcessing.
			statusPostProcessing _ self printPostProcessing.
			self printCleanup].
	status ~= 0 ifTrue: [^status].
	^statusPostProcessing.! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/9/2002 12:28'!
printGetFirstPageNumber
	^self primGetFirstPageNumber: self session ! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/9/2002 12:28'!
printGetLastPageNumber
	^self primGetLastPageNumber: self session ! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/7/2002 18:32'!
printPostProcessing
	^self primPrintPostProcessing: self session ! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/7/2002 18:32'!
printPreProcessing: aNumber
	^self primPrintPreProcessing: self session pages: aNumber! !

!PrintJob methodsFor: 'logic' stamp: 'pe 12/16/2006 16:55'!
printPreProcessing: aNumber dpi: dpiPoint
	^self primPrintPreProcessing: self session pages: aNumber pageRectangle: pageRect paperRectangle: paperRect dpi: dpi! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/8/2002 21:07'!
setForm: aForm 
	^self setForm: aForm scaleHeight: 1.0 scaleWidth: 1.0 
! !

!PrintJob methodsFor: 'logic' stamp: 'pe 12/12/2006 09:44'!
setForm: aForm at: aSymbol

	"this is not yet generally working, for Plopp I needed just the #topCenter case. pe 12/12/2006 09:44"

	| formRatio printRatio printExtent inRect aPoint |
	formRatio := aForm width asFloat / aForm height asFloat.
	printRatio := pageRect width asFloat / pageRect height asFloat.
	printRatio <= formRatio
	ifTrue: [
		printExtent := pageRect width @ (pageRect width asFloat / formRatio)]
	ifFalse: [
		printExtent := (pageRect height * formRatio) @ pageRect height].

	inRect := Rectangle origin: (0@0) extent: printExtent truncated.
	aPoint := (pageRect perform: aSymbol).
	inRect := inRect perform: (aSymbol, ':')asSymbol with: aPoint.
	inRect := Rectangle origin: inRect origin extent: printExtent truncated.
	

	^self setForm: aForm in: inRect.! !

!PrintJob methodsFor: 'logic' stamp: 'pe 12/8/2006 20:02'!
setForm: aForm in: inRect

	aForm unhibernate.
	^self primPageSetForm: self session bits: aForm bits bitmapHeight: aForm height truncated bitmapWidth: aForm width truncated bitmapDepth: aForm depth truncated printHeight: inRect height truncated printWidth: inRect width truncated offsetH: inRect top truncated offsetW: inRect left truncated.! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/20/2002 11:56'!
setForm: aForm scaleHeight: sh scaleWidth: sw 
	^self setForm: aForm scaleHeight: sh scaleWidth: sw offsetHeight: 0 offsetWidth: 0! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/20/2002 10:25'!
setForm: aForm scaleHeight: sh scaleWidth: sw offsetHeight: oh offsetWidth: ow
	aForm unhibernate.
	^self primPageSetForm: self session bits: aForm bits height: aForm height width: aForm width  depth: aForm depth scaleH: sh scaleW: sw offsetH: oh offsetW: ow
! !

!PrintJob methodsFor: 'logic' stamp: 'pe 12/16/2006 16:56'!
setFullPageForm: aForm 
	
	| formRatio printRatio printExtent inRect |

	formRatio := aForm width asFloat / aForm height asFloat.
	printRatio := pageRect width asFloat / pageRect height asFloat.
	printRatio <= formRatio
	ifTrue: [
		printExtent := pageRect width @ (pageRect width asFloat / formRatio)]
	ifFalse: [
		printExtent := (pageRect height * formRatio) @ pageRect height].

	inRect := (Rectangle center: pageRect center extent: printExtent truncated).

	^self setForm: aForm in: inRect.
! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/8/2002 01:20'!
setPostscript: aText
	^self primPageSetPostscript: self session postscript: aText! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/9/2002 13:49'!
startJob: objects
	| status statusPostProcessing |
	self session isNil ifTrue: [^-1].
	[status _ self printPreProcessing: objects size.
	status ~= 0 ifTrue: [^status].
	self printGetFirstPageNumber to: self printGetLastPageNumber do: 
		[:index | 
		status _ self startPage: (objects at: index)]]
		ensure: 
			[statusPostProcessing _ self printPostProcessing.
			self printCleanup].
	status ~= 0 ifTrue: [^status].
	^statusPostProcessing
! !

!PrintJob methodsFor: 'logic' stamp: 'JMM 2/8/2002 22:48'!
startPage: aObject
	| status |
	[status _ self pagePreProcessing.
	status ~= 0 ifTrue: [^status].
	aObject isForm 
		ifTrue: [status _ self setForm: aObject]
		ifFalse: [status _ self setPostscript: aObject].
	status ~= 0 ifTrue: [^status]]
		ensure: 
		[status _ self pagePostProcessing].
	^status
! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 12:27'!
primGetFirstPageNumber: aSession
	"get first page number"
	<primitive: 'primitivePrintGetFirstPageNumber' module: 'PrintJobPlugin'>
	^0! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 12:27'!
primGetLastPageNumber: aSession
	"get last page number"
	<primitive: 'primitivePrintGetLastPageNumber' module: 'PrintJobPlugin'>
	^0! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/8/2002 00:41'!
primPagePostProcessing: aSession 
	"Page post processing"
	<primitive: 'primitivePagePostProcessing' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/8/2002 00:13'!
primPagePreProcessing: aSession 
	"Page preprocessing"
	<primitive: 'primitivePagePreProcessing' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'pe 12/8/2006 19:57'!
primPageSetForm: aSessionHandle bits: aBitMap bitmapHeight: bh bitmapWidth: bw bitmapDepth: bd printHeight: ph printWidth: pw offsetH: oh offsetW: ow
	"setup form "
	<primitive: 'primitivePageSetFormPrint' module: 'PrintJobPlugin'>
	^nil.
	"self primitiveFailed"! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/20/2002 10:22'!
primPageSetForm: aSessionHandle bits: aBitMap height: h width: w depth: d scaleH: sh scaleW: sw offsetH: oh offsetW: ow
	"setup form "
	<primitive: 'primitivePageSetForm' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/8/2002 00:11'!
primPageSetPostscript: aSessionHandle postscript: aText
	"setup postscript "
	<primitive: 'primitivePageSetPostscript' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 01:52'!
primPrintCleanup: aSession
	"Print cleanup processing"
	<primitive: 'primitivePrintCleanup' module: 'PrintJobPlugin'>
! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 01:27'!
primPrintPostProcessing: aSession
	"Print post processing"
	<primitive: 'primitivePrintPostProcessing' module: 'PrintJobPlugin'>
! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/7/2002 18:32'!
primPrintPreProcessing: aSession pages: aNumber
	"Printing preprocessing"
	<primitive: 'primitivePrintPreProcessing' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'pe 12/16/2006 16:53'!
primPrintPreProcessing: aSession pages: aNumber pageRectangle: pageRectangle paperRectangle: paperRectangle dpi: dpiPoint
	"Printing preprocessing"
	<primitive: 'primitivePrintPreProcessingPageRectanglePaperRectangleDpi' module: 'PrintJobPlugin'>
	self primitiveFailed! !

!PrintJob methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 13:25'!
primPrintSetup
	"Setup printing"
	<primitive: 'primitivePrintSetup' module: 'PrintJobPlugin'>
	^nil! !

!PrintJob methodsFor: 'system primitives' stamp: 'pe 12/16/2006 16:54'!
primPrintSetupPage: pageRectangle paper: paperRectangle dpi: dpiPoint
	"Setup printing"
	<primitive: 'primitivePrintSetupPageRectanglePaperRectangleDpi' module: 'PrintJobPlugin'>

	self halt.	

	^nil. "If the user pressed cancel, we don't want a primitive failed. We do the checks using session bits"! !

!PrintJob methodsFor: 'system primitives' stamp: 'pe 12/8/2006 18:53'!
primPrintSetupRect: aRectangle
	"Setup printing"
	<primitive: 'primitivePrintSetupOnRectangle' module: 'PrintJobPlugin'>
	
	^nil. "If the user pressed cancel, we don't want a primitive failed. We do the checks using session bits"! !

!PrintJob methodsFor: 'utility' stamp: 'JMM 2/8/2002 21:28'!
printForms: aCollectionOfForms
	^self startJob: aCollectionOfForms
	
! !

!PrintJob methodsFor: 'utility' stamp: 'JMM 2/8/2002 21:10'!
printForm: aForm
	^self printForms: (Array with: aForm)
! !

!PrintJob methodsFor: 'utility' stamp: 'JMM 2/8/2002 21:30'!
printPostscriptObjects: aCollection
	^self startJob: aCollection

! !

!PrintJob methodsFor: 'utility' stamp: 'JMM 2/8/2002 22:49'!
printPostscript: aText
	^self printPostscriptObjects: (Array with: aText)
! !

!PrintJob methodsFor: 'private' stamp: 'JMM 2/9/2002 01:58'!
finalize
	self session notNil ifTrue: [self primPrintCleanup: self session].
	self session = sessionBits ifTrue: [Smalltalk unregisterExternalObject: sessionIndex].
	self unregister.
	sessionBits _ nil.	
	sessionIndex _ 0.! !

!PrintJob methodsFor: 'private' stamp: 'JMM 2/9/2002 01:29'!
register
	^self class register: self! !

!PrintJob methodsFor: 'private' stamp: 'JMM 2/9/2002 01:29'!
unregister
	^self class unregister: self! !


!PrintJob class methodsFor: 'utility' stamp: 'JMM 2/9/2002 00:19'!
printForms: forms
	^super new initialize printForms: forms! !

!PrintJob class methodsFor: 'utility' stamp: 'JMM 2/9/2002 00:12'!
printForm: aForm
	^self printForms: (Array with: aForm)! !

!PrintJob class methodsFor: 'utility' stamp: 'JMM 2/9/2002 00:48'!
printPostscriptObjects: aCollection
	^super new initialize printPostscriptObjects: aCollection! !

!PrintJob class methodsFor: 'utility' stamp: 'JMM 2/9/2002 00:49'!
printPostscript: aString
	^self printPostscriptObjects: (Array with: aString)! !

!PrintJob class methodsFor: 'registery' stamp: 'JMM 2/9/2002 01:21'!
register: anObject
	WeakArray isFinalizationSupported ifFalse:[^anObject].
	self registry add: anObject! !

!PrintJob class methodsFor: 'registery' stamp: 'JMM 2/9/2002 01:21'!
registry
	WeakArray isFinalizationSupported ifFalse:[^nil].
	^Registry isNil
		ifTrue:[Registry := WeakRegistry new]
		ifFalse:[Registry].! !

!PrintJob class methodsFor: 'registery' stamp: 'JMM 2/9/2002 01:21'!
unregister: anObject
	WeakArray isFinalizationSupported ifFalse:[^anObject].
	self registry remove: anObject ifAbsent:[]! !

PrintJob class removeSelector: #new!
