'From Croquet1.0beta of 6 April 2006 [latest update: #0] on 8 April 2006 at 6:57:56 pm'!

!Float methodsFor: 'fdlibm' stamp: 'ar 4/8/2006 18:44'!
copysign: y
	"/*
	 * ====================================================
	 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
	 *
	 * Developed at SunSoft, a Sun Microsystems, Inc. business.
	 * Permission to use, copy, modify, and distribute this
	 * software is freely granted, provided that this notice 
	 * is preserved.
	 * ====================================================
	 */

	/*
	 * copysign(double x, double y)
	 * copysign(x,y) returns a value with the magnitude of x and
	 * with the sign bit of y.
	 */
	"
	| r |
	r := self clone.
	r at: 1 put: (((r basicAt: 1) bitAnd: 16r7FFFFFFF) bitOr: ((y basicAt: 1) bitAnd: 16r80000000)).
	^r! !

!Float methodsFor: 'fdlibm' stamp: 'ar 4/8/2006 18:52'!
ieee754arcCos
	"/*
	 * ====================================================
	 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
	 *
	 * Developed at SunSoft, a Sun Microsystems, Inc. business.
	 * Permission to use, copy, modify, and distribute this
	 * software is freely granted, provided that this notice 
	 * is preserved.
	 * ====================================================
	 */

	/* __ieee754_acos(x)
	 * Method :                  
	 *	acos(x)  = pi/2 - asin(x)
	 *	acos(-x) = pi/2 + asin(x)
	 * For |x|<=0.5
	 *	acos(x) = pi/2 - (x + x*x^2*R(x^2))	(see asin.c)
	 * For x>0.5
	 * 	acos(x) = pi/2 - (pi/2 - 2asin(sqrt((1-x)/2)))
	 *		= 2asin(sqrt((1-x)/2))  
	 *		= 2s + 2s*z*R(z) 	...z=(1-x)/2, s=sqrt(z)
	 *		= 2f + (2c + 2s*z*R(z))
	 *     where f=hi part of s, and c = (z-f*f)/(s+f) is the correction term
	 *     for f so that f+c ~ sqrt(z).
	 * For x<-0.5
	 *	acos(x) = pi - 2asin(sqrt((1-|x|)/2))
	 *		= pi - 0.5*(s+s*z*R(z)), where z=(1-|x|)/2,s=sqrt(z)
	 *
	 * Special cases:
	 *	if x is NaN, return x itself;
	 *	if |x|>1, return NaN with invalid signal.
	 *
	 * Function needed: sqrt
	 */"
	| one pi pio2xhi pio2xlo pS0 pS1 pS2 pS3 pS4 pS5 qS1 qS2 qS3 qS4 x ix z p q r s w df c |
	one 	:= " 1.00000000000000000000e+00" 	Float with: 16r3FF00000 with: 16r00000000.
	pi 		:= " 3.14159265358979311600e+00" 	Float with: 16r400921FB with: 16r54442D18.
	pio2xhi 	:= " 1.57079632679489655800e+00" 	Float with: 16r3FF921FB with: 16r54442D18.
	pio2xlo 	:= " 6.12323399573676603587e-17" 	Float with: 16r3C91A626 with: 16r33145C07.
	pS0 	:= " 1.66666666666666657415e-01" 	Float with: 16r3FC55555 with: 16r55555555.
	pS1 	:= "-3.25565818622400915405e-01" 	Float with: 16rBFD4D612 with: 16r03EB6F7D.
	pS2 	:= " 2.01212532134862925881e-01" 	Float with: 16r3FC9C155 with: 16r0E884455.
	pS3 	:= "-4.00555345006794114027e-02" 	Float with: 16rBFA48228 with: 16rB5688F3B.
	pS4 	:= " 7.91534994289814532176e-04" 	Float with: 16r3F49EFE0 with: 16r7501B288.
	pS5 	:= " 3.47933107596021167570e-05" 	Float with: 16r3F023DE1 with: 16r0DFDF709.
	qS1 	:= "-2.40339491173441421878e+00" 	Float with: 16rC0033A27 with: 16r1C8A2D4B.
	qS2 	:= " 2.02094576023350569471e+00" 	Float with: 16r40002AE5 with: 16r9C598AC8.
	qS3 	:= "-6.88283971605453293030e-01" 	Float with: 16rBFE6066C with: 16r1B8D0159.
	qS4 	:= " 7.70381505559019352791e-02" 	Float with: 16r3FB3B8C5 with: 16rB12E9282.

	x := self.
	ix := (x basicAt: 1) bitAnd: 16r7FFFFFFF.
	(ix >= 16r3FF00000) ifTrue:[	" |x| >= 1 "
		(((ix - 16r3FF00000) bitOr: (x basicAt: 2))==0) ifTrue:[ " |x|==1 "
			(x > 0.0) 
				ifTrue:[^0.0]	"acos(1) = 0 "
				ifFalse:[^pi + (2.0*pio2xlo)]	" acos(-1)= pi "
		].
		^Float nan "(x-x)/(x-x)"	" acos(|x|>1) is NaN "
	].

	(ix < 16r3FE00000) ifTrue:[	" |x| < 0.5 "
		(ix <= 16r3C600000) ifTrue:[^pio2xhi + pio2xlo]. " if|x|<2**-57 "
		z := x*x.
		p := z*(pS0+(z*(pS1+(z*(pS2+(z*(pS3+(z*(pS4+(z*pS5)))))))))).
		q := one+(z*(qS1+(z*(qS2+(z*(qS3+(z*qS4))))))).
		r := p/q.
		^pio2xhi - (x - (pio2xlo-(x*r)))
	].
	(x < 0.0) ifTrue:[  " x < -0.5 "
		z := (one + x) * 0.5.
		p := z*(pS0+(z*(pS1+(z*(pS2+(z*(pS3+(z*(pS4+(z*pS5)))))))))).
		q := one+(z*(qS1+(z*(qS2+(z*(qS3+(z*qS4))))))).
		s := z sqrt.
		r := p / q.
		w := r * s - pio2xlo.
		^pi - (2.0*(s+w))
	] ifFalse:[ " x > 0.5 "
		z := (one - x) * 0.5.
		s := z sqrt.
		df := s clone.
		df basicAt: 2 put: 0. "__LO(df) = 0; "
		c := (z - (df * df)) / (s + df).
		p := z*(pS0+(z*(pS1+(z*(pS2+(z*(pS3+(z*(pS4+(z*pS5)))))))))).
		q := one+(z*(qS1+(z*(qS2+(z*(qS3+(z*qS4))))))).
		r := p / q.
		w := r * (s + c).
	    ^2.0 * (df + w).
	].! !

!Float methodsFor: 'fdlibm' stamp: 'ar 4/8/2006 18:52'!
ieee754arcSin
	"/*
	 * ====================================================
	 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
	 *
	 * Developed at SunSoft, a Sun Microsystems, Inc. business.
	 * Permission to use, copy, modify, and distribute this
	 * software is freely granted, provided that this notice 
	 * is preserved.
	 * ====================================================
	 */

	/* __ieee754_asin(x)
	 * Method :                  
	 *	Since  asin(x) = x + x^3/6 + x^5*3/40 + x^7*15/336 + ...
	 *	we approximate asin(x) on [0,0.5] by
	 *		asin(x) = x + x*x^2*R(x^2)
	 *	where
	 *		R(x^2) is a rational approximation of (asin(x)-x)/x^3 
	 *	and its remez error is bounded by
	 *		|(asin(x)-x)/x^3 - R(x^2)| < 2^(-58.75)
	 *
	 *	For x in [0.5,1]
	 *		asin(x) = pi/2-2*asin(sqrt((1-x)/2))
	 *	Let y = (1-x), z = y/2, s := sqrt(z), and pio2_hi+pio2_lo=pi/2;
	 *	then for x>0.98
	 *		asin(x) = pi/2 - 2*(s+s*z*R(z))
	 *			= pio2_hi - (2*(s+s*z*R(z)) - pio2_lo)
	 *	For x<=0.98, let pio4_hi = pio2_hi/2, then
	 *		f = hi part of s;
	 *		c = sqrt(z) - f = (z-f*f)/(s+f) 	...f+c=sqrt(z)
	 *	and
	 *		asin(x) = pi/2 - 2*(s+s*z*R(z))
	 *			= pio4_hi+(pio4-2s)-(2s*z*R(z)-pio2_lo)
	 *			= pio4_hi+(pio4-2f)-(2s*z*R(z)-(pio2_lo+2c))
	 *
	 * Special cases:
	 *	if x is NaN, return x itself;
	 *	if |x|>1, return NaN with invalid signal.
	 *
	 */"
	| one huge pio2xhi pio2xlo pio4xhi pS0 pS1 pS2 pS3 pS4 pS5 qS1 qS2 qS3 qS4 x ix t p q w s c r |
	one 	:= " 1.00000000000000000000e+00" Float with: 16r3FF00000 with: 16r00000000.
	huge 	:=  1.0e300.
	pio2xhi 	:= " 1.57079632679489655800e+00" Float with: 16r3FF921FB with: 16r54442D18.
	pio2xlo 	:= " 6.12323399573676603587e-17" Float with: 16r3C91A626 with: 16r33145C07.
	pio4xhi 	:= " 7.85398163397448278999e-01" Float with: 16r3FE921FB with: 16r54442D18.
		"coefficient for R(x^2)"
	pS0 	:= " 1.66666666666666657415e-01" Float with: 16r3FC55555 with: 16r55555555.
	pS1 	:= "-3.25565818622400915405e-01" Float with: 16rBFD4D612 with: 16r03EB6F7D.
	pS2 	:= " 2.01212532134862925881e-01" Float with: 16r3FC9C155 with: 16r0E884455.
	pS3 	:= "-4.00555345006794114027e-02" Float with: 16rBFA48228 with: 16rB5688F3B.
	pS4 	:= " 7.91534994289814532176e-04" Float with: 16r3F49EFE0 with: 16r7501B288.
	pS5 	:= " 3.47933107596021167570e-05" Float with: 16r3F023DE1 with: 16r0DFDF709.
	qS1 	:= "-2.40339491173441421878e+00" Float with: 16rC0033A27 with: 16r1C8A2D4B.
	qS2 	:= " 2.02094576023350569471e+00" Float with: 16r40002AE5 with: 16r9C598AC8.
	qS3 	:= "-6.88283971605453293030e-01" Float with: 16rBFE6066C with: 16r1B8D0159.
	qS4 	:= " 7.70381505559019352791e-02" Float with: 16r3FB3B8C5 with: 16rB12E9282.

	x := self.
	ix := (x basicAt: 1) bitAnd: 16r7FFFFFFF.
	(ix >= 16r3FF00000) ifTrue:[" |x|>= 1 "
		(((ix - 16r3FF00000) bitOr: (x basicAt: 2)) = 0) ifTrue:[
			"asin(1)=+-pi/2 with inexact"
			^(x*pio2xhi) + (x*pio2xlo)
		].
	    ^Float nan "(x-x) / (x-x)"	 "asin(|x|>1) is NaN"
	].
	(ix < 16r3FE00000) ifTrue:[ " |x| < 0.5 "
		(ix < 16r3E400000) ifTrue:[ " if |x| < 2**-27 "
			(huge + x > one) ifTrue:[^x].  "return x with inexact if x!!=0"
		] ifFalse:[
			t := x*x.
		].
		p := t*(pS0+(t*(pS1+(t*(pS2+(t*(pS3+(t*(pS4+(t*pS5)))))))))).
		q := one + (t*(qS1+(t*(qS2+(t*(qS3+(t*qS4))))))).
		w := p / q.
		^x+(x*w)
	].
	"1> |x|>= 0.5"
	w := one - x abs.
	t := w * 0.5.
	p := t*(pS0+(t*(pS1+(t*(pS2+(t*(pS3+(t*(pS4+(t*pS5)))))))))).
	q := one+(t*(qS1+(t*(qS2+(t*(qS3+(t*qS4))))))).
	s := t sqrt.
	(ix >= 16r3FEF3333) ifTrue:[ " if |x| > 0.975 "
		w := p/q.
		t := pio2xhi - ((2.0 * (s + (s * w))) - pio2xlo).
	] ifFalse:[
		w := s.
		w basicAt: 2 put: 0.
		c := (t - (w * w)) / (s+w).
		r := p / q.
		p := 2.0 * s * r - (pio2xlo - (2.0*c)).
		q := pio4xhi - (2.0 * w).
		t := pio4xhi - (p - q).
	].
	^(x > 0.0) ifTrue:[t] ifFalse:[0.0 - t]
! !

!Float methodsFor: 'fdlibm' stamp: 'ar 4/8/2006 18:45'!
scalbn: n
	"/*
	 * ====================================================
	 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
	 *
	 * Developed at SunSoft, a Sun Microsystems, Inc. business.
	 * Permission to use, copy, modify, and distribute this
	 * software is freely granted, provided that this notice 
	 * is preserved.
	 * ====================================================
	 */

	/* 
	 * scalbn (double x, int n)
	 * scalbn(x,n) returns x* 2**n  computed by  exponent  
	 * manipulation rather than by actually performing an 
	 * exponentiation or a multiplication.
	 */
	"

	| two54 twom54 huge tiny hx lx k x r |
	two54 	:= "1.80143985094819840000e16."	Float with: 16r43500000 with: 16r00000000.
	twom54 	:= "5.55111512312578270212e-17." 	Float with: 16r3C900000 with: 16r00000000.
	huge 	:= 1.0e300.
	tiny 	:= 1.0e-300.

	x := self.
	hx := x basicAt: 1.
	lx := x basicAt: 2.
	k := (hx bitAnd: 16r7FF00000) bitShift: -20.	"extract exponent"
	(k = 0) ifTrue:[	"0 or subnormal x"
		( lx bitOr: (hx bitAnd: 16r7FFFFFFF) ) = 0 ifTrue:[^x]. "+-0"
		x := x * two54.
		hx := x basicAt: 1.
		k := ((hx bitAnd: 16r7FF00000) bitShift: -20) - 54.
		(n < -50000) ifTrue:[^tiny*x].	"underflow"
	].
	(k = 16r7FF) ifTrue:[^x+x].	"NaN or Inf"
	k := k+n.
	(k > 16r7FE) ifTrue:[^huge * (huge copysign: x)]. "overflow"
	(k > 0) ifTrue:[	"normal result"
		r := x clone.
		r basicAt: 1 put: ((hx bitAnd: 16r800FFFFF) bitOr: (k  bitShift: 20)).
		^r
	].
	(k <= -54) ifTrue:[^tiny * (tiny copysign: x)].	"underflow"
 	k := k + 54.	"subnormal result"
	r := x clone.
	r basicAt: 1 put: ((hx bitAnd: 16r800FFFFF) bitOr: (k bitShift: 20)).
	^x * twom54! !


!Float class methodsFor: 'fdlibm' stamp: 'ar 4/8/2006 18:55'!
with: hiWord with: loWord
	"Construct a double from two words directly"
	| float |
	float := 0.0 clone.
	float basicAt: 1 put: hiWord.
	float basicAt: 2 put: loWord.
	^float! !

