;;;; This software is part of the SBCL system. See the README file for
;;;; more information.
;;;;
;;;; While most of SBCL is derived from the CMU CL system, the test
;;;; files (like this one) were written from scratch after the fork
;;;; from CMU CL.
;;;;
;;;; This software is in the public domain and is provided with
;;;; absolutely no warranty. See the COPYING and CREDITS files for
;;;; more information.

(defparameter test-case
  #x7304B903E707E5686C03CD03A7029310850CA8049801B601A7028C6D028302D002D801D9018707880AC0059C06847805AF6D018C04D802C005F401D405DB7103DF03FD03BC2D01D402C303C078018102A602A106E509EB1F018208F307AE315104E801CD5A2501F03C02F703AF01AD079B0AD303F903AB7501A50FFD7313D70CC000002D0186664C720503AC61018A01886607C40C0C051C01C90EB20C8101F301F002830C0829054708260505AF03A901B57202D004D86672706E6068028A700198667060727801CE6001D868028203E875436420058470079102856802B86805F272018401C003A4130C2205550C2205028C0C0509B36601FA07E702F1018201F405B60D1F02BD6108160C0C084C038655400E0E1402AF2A3B02CB018003F50D0194131301E96401D05E028A01F949350194018209576331130505C002851313130C165C02F102C201F97301F50394566A7302EA0E0190411201860F1F1140532D02A301D301CB6A101010100916018801D15001FA2B4E69441005D801B41D0502A201C50504CA6E413801B96F0E0E0E36039203C31969018201FC307C0C610E0E2701D9)

(with-test (:name :bignum-unpacker-no-consing :skipped-on :interpreter)
  (flet ((try ()
           (let ((result 0)
                 (b test-case))
             (sb-int:do-packed-varints (int b)
               (setq result (logxor result int)))
             result)))
    (ctu:assert-no-consing (try))))
