/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.core.ui.options.filetypes;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

/** Panel for entering a new extension.
 *
 * @author Jiri Skrivanek
 */
final class NewExtensionPanel extends javax.swing.JPanel {

    private FileAssociationsModel model;
    
    /** Creates new form NewExtensionPanel */
    public NewExtensionPanel() {
        super();
        initComponents();
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewExtensionPanel.class, "NewExtensionPanel.AD"));
    }

    void setModel(FileAssociationsModel model) {
        this.model = model;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblExtension = new javax.swing.JLabel();
        tfExtension = new javax.swing.JTextField();

        lblExtension.setLabelFor(tfExtension);
        org.openide.awt.Mnemonics.setLocalizedText(lblExtension, org.openide.util.NbBundle.getMessage(NewExtensionPanel.class, "NewExtensionPanel.lblExtension.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblExtension)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tfExtension, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblExtension)
                    .addComponent(tfExtension, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        lblExtension.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NewExtensionPanel.class, "NewExtensionPanel.lblExtension.AN")); // NOI18N
        lblExtension.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewExtensionPanel.class, "NewExtensionPanel.lblExtension.AD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblExtension;
    private javax.swing.JTextField tfExtension;
    // End of variables declaration//GEN-END:variables

    String getExtension() {
        return tfExtension.getText();
    }
    
    /** Returns true if extension does not exist in model. */
    private boolean isExtensionValid() {
        String extension = tfExtension.getText();
        return extension != null && extension.length() != 0 && extension.indexOf(".") == -1 && !model.containsExtension(extension);  //NOI18N
    }
    
    void addExtensionListener(final DialogDescriptor dd) {
        dd.setValid(isExtensionValid());
        tfExtension.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                dd.setValid(isExtensionValid());
            }

            public void removeUpdate(DocumentEvent e) {
                dd.setValid(isExtensionValid());
            }

            public void changedUpdate(DocumentEvent e) {
                dd.setValid(isExtensionValid());
            }
        });
    }
}
