# JCov plugin for the coverage reports
##### *Eric L. McCorkle and Alexey Fedorchenko, March 2018, version 1.0*

This is a plugin to JCov report generation process that adds capability to produce Cobertura XML report. 
With this plugin, JCov users can generate Cobertura XML report that can be used as an input for Jenkins 
Cobertura plugin.

### Folder layout

The output of this folder is as follows:

```
 coberturaXML
   |-src (plugin sources)
   |-build (build files are stored here)
   |-tests (the directory for the tests that verify plugin functionality)
   |-plugin (generated directory by the build.xml with the plugin binaries)
   |-plugin-tests (generated directory by the tests.xml with tests' results for the plugin)
```

### Building the plugin

To build the plugin, you need to have Apache Ant. The plugin can be built by running `ant -f build/build.xml` from the 
current directory. The properties used during the build are specified at `build/build.properties`:

* You might need to specify path to JCov binaries that are used during the plugin build with the property `jcov.path`

* The `plugin` directory with the plugin binaries will be generated by the command. The property `result.dir` is used 
to specify the path to the result directory.

### Testing the plugin

To run tests on the plugin, you need to execute `ant -f tests/tests.xml` command. This command will invoke 
all `test.xml` files in the `tests` subdirectories. To add a new test you can create new subdirectory with 
the `test.xml` file. The common test properties are described in `tests/tests.properties`

### Using the plugin
To produce Cobertura XML report in `cobertura.xml` file from the JCov `result.xml` file you need to specify 
JCov property `jcov.customreport.spi` and add the plugin classes to classpath:
```
java -Djcov.customreport.spi=openjdk.codetools.jcov.plugin.coberturaxml.CoberturaReportGeneratorSPI 
     -cp jcov.jar:coberturaXML.jar com.sun.tdk.jcov.RepGen -format cobertura -o cobertura.xml result.xml
```


### Dealing with bugs

Please forward plugin bugs and patches to `jcov-dev@openjdk.java.net`.