/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 * Specifies whether to hint font metrics; hinting font metrics means quantizing
 * them so that they are integer values in device space. Doing this improves the
 * consistency of letter and line spacing, however it also means that text will
 * be laid out differently at different zoom factors.
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.HintMetrics</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class HintMetrics extends Enum {

    static final private int _DEFAULT = 0;

    /**
     * Hint metrics in the default manner for the font backend and target device
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintMetrics DEFAULT = new HintMetrics(_DEFAULT);

    static final private int _OFF = 1;

    /**
     * Do not hint font metrics
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintMetrics OFF = new HintMetrics(_OFF);

    static final private int _ON = 2;

    /**
     * Hint font metrics
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public HintMetrics ON = new HintMetrics(_ON);

    static final private HintMetrics[] theInterned = new HintMetrics[] {
            DEFAULT, OFF, ON };

    static private java.util.Hashtable theInternedExtras;

    static final private HintMetrics theSacrificialOne = new HintMetrics(0);

    static public HintMetrics intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        HintMetrics already = (HintMetrics) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new HintMetrics(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private HintMetrics(int value) {
        value_ = value;
    }

    public boolean test(HintMetrics other) {
        return (value_ & other.value_) == other.value_;
    }

}
