/* GTK+ Blueprint Engine
 * Copyright (C) 2003 Sun Microsystems, inc
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Erwann Chenede <erwann.chenede@sun.com> 
 * based on code by Owen Taylor <otaylor@redhat.com>
 * and Carsten Haitzler <raster@rasterman.com>
 */

#include <gtk/gtkrc.h>

typedef struct _BlueprintRcStyle BlueprintRcStyle;
typedef struct _BlueprintRcStyleClass BlueprintRcStyleClass;

extern GType blueprint_type_rc_style;

#define BLUEPRINT_TYPE_RC_STYLE              blueprint_type_rc_style
#define BLUEPRINT_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), BLUEPRINT_TYPE_RC_STYLE, BlueprintRcStyle))
#define BLUEPRINT_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), BLUEPRINT_TYPE_RC_STYLE, BlueprintRcStyleClass))
#define BLUEPRINT_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), BLUEPRINT_TYPE_RC_STYLE))
#define BLUEPRINT_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUEPRINT_TYPE_RC_STYLE))
#define BLUEPRINT_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUEPRINT_TYPE_RC_STYLE, BlueprintRcStyleClass))

struct _BlueprintRcStyle
{
  GtkRcStyle parent_instance;
  
  GList	    *img_list;
  gboolean   icon_colorize;
  GdkColor   colorize_color;
  GSList    *icon_ancestor_type_list;
    
};

struct _BlueprintRcStyleClass
{
  GtkRcStyleClass parent_class;
};

void blueprint_rc_style_register_type (GTypeModule *module);
