/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ChangeTypeAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ChangeTypeAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public ChangeTypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ChangeTypeAction_label);
        this.setToolTipText(RefactoringMessages.ChangeTypeAction_tooltipText);
        this.setDescription(RefactoringMessages.ChangeTypeAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.change_type_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember member = ChangeTypeAction.getMember(selection);
            if (member == null || !ActionUtil.isEditable(this.getShell(), (IJavaElement)member)) {
                return;
            }
            ISourceRange range = member.getNameRange();
            RefactoringExecutionStarter.startChangeTypeRefactoring(member.getCompilationUnit(), this.getShell(), range.getOffset(), range.getLength());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }

    private static IMember getMember(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IMember)) {
            return null;
        }
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            String returnType = method.getReturnType();
            if (PrimitiveType.toCode((String)Signature.toString((String)returnType)) != null) {
                return null;
            }
            return method;
        }
        if (element instanceof IField && !JdtFlags.isEnum((IMember)element)) {
            return (IField)element;
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startChangeTypeRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), this.getShell(), selection.getOffset(), selection.getLength());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }
}

