/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingProblem;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public abstract class SpellingEngine
implements ISpellingEngine {
    public static final String SPELLING_PROBLEMS_THRESHOLD = "spelling_problems_threshold";

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellCheckEngine spellingEngine;
        ISpellChecker checker;
        if (collector != null && (checker = (spellingEngine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
            this.check(document, regions, checker, collector, monitor);
        }
    }

    protected abstract void check(IDocument var1, IRegion[] var2, ISpellChecker var3, ISpellingProblemCollector var4, IProgressMonitor var5);

    protected static class SpellEventListener
    implements ISpellEventListener {
        private ISpellingProblemCollector fCollector;
        private IDocument fDocument;
        private int fProblemsThreshold;
        private int fProblemCount;

        public SpellEventListener(ISpellingProblemCollector collector, IDocument document) {
            this.fCollector = collector;
            this.fDocument = document;
            this.fProblemsThreshold = PreferenceConstants.getPreferenceStore().getInt(SpellingEngine.SPELLING_PROBLEMS_THRESHOLD);
        }

        public void handle(ISpellEvent event) {
            if (this.isProblemsThresholdReached()) {
                return;
            }
            ++this.fProblemCount;
            this.fCollector.accept((SpellingProblem)new JavaSpellingProblem(event, this.fDocument));
        }

        boolean isProblemsThresholdReached() {
            return this.fProblemCount >= this.fProblemsThreshold;
        }
    }
}

