/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.internal.GUtil;

public class ArchivePublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private File file;
    private AbstractArchiveTask archiveTask;

    @Inject
    public ArchivePublishArtifact(TaskDependencyFactory taskDependencyFactory, AbstractArchiveTask archiveTask) {
        super(taskDependencyFactory, archiveTask);
        this.archiveTask = archiveTask;
    }

    @Override
    public ArchivePublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String baseName = (String)this.archiveTask.getArchiveBaseName().getOrNull();
        if (baseName != null) {
            return this.withAppendix(baseName);
        }
        return (String)this.archiveTask.getArchiveAppendix().getOrNull();
    }

    private String withAppendix(String baseName) {
        String appendix = (String)this.archiveTask.getArchiveAppendix().getOrNull();
        return baseName + (GUtil.isTrue((Object)appendix) ? "-" + appendix : "");
    }

    public String getExtension() {
        return (String)GUtil.getOrDefault((Object)this.extension, () -> (String)this.archiveTask.getArchiveExtension().getOrNull());
    }

    public String getType() {
        return (String)GUtil.getOrDefault((Object)this.type, () -> (String)this.archiveTask.getArchiveExtension().getOrNull());
    }

    public String getClassifier() {
        return (String)GUtil.getOrDefault((Object)this.classifier, () -> (String)this.archiveTask.getArchiveClassifier().getOrNull());
    }

    public File getFile() {
        return (File)GUtil.getOrDefault((Object)this.file, () -> ((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile());
    }

    public Date getDate() {
        return (Date)GUtil.getOrDefault((Object)this.date, () -> new Date(((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile().lastModified()));
    }

    public AbstractArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean shouldBePublished() {
        return this.archiveTask.isEnabled();
    }
}

