/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import groovy.lang.GroovyObject;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.vmplugin.v8.CacheableCallSite;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.InstrumentedClosuresHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;
import org.gradle.internal.classpath.intercept.AbstractCallInterceptor;
import org.gradle.internal.classpath.intercept.AbstractInvocation;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptorResolver;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;
import org.gradle.internal.classpath.intercept.CompositeCallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;

@NonNullApi
public class DefaultCallSiteDecorator
implements CallSiteDecorator,
CallInterceptorResolver {
    private final Map<InterceptScope, CallInterceptor> interceptors = new HashMap<InterceptScope, CallInterceptor>();
    private final Set<String> interceptedCallSiteNames = new HashSet<String>();
    private final CallInterceptor dispatchingConstructorInterceptor = new AbstractCallInterceptor(new InterceptScope[0]){

        @Override
        public Object intercept(Invocation invocation, String consumer) throws Throwable {
            CallInterceptor realConstructorInterceptor;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof Class && (realConstructorInterceptor = (CallInterceptor)DefaultCallSiteDecorator.this.interceptors.get(InterceptScope.constructorsOf((Class)receiver))) != null) {
                return realConstructorInterceptor.intercept(invocation, consumer);
            }
            return invocation.callOriginal();
        }
    };

    public DefaultCallSiteDecorator(List<CallInterceptor> callInterceptors) {
        callInterceptors.forEach(this::addInterceptor);
    }

    private void addInterceptor(CallInterceptor interceptor) {
        for (InterceptScope scope : interceptor.getInterceptScopes()) {
            this.interceptors.compute(scope, (__, previous) -> previous == null ? interceptor : new CompositeCallInterceptor((CallInterceptor)previous, interceptor));
            this.interceptedCallSiteNames.add(scope.getCallSiteName());
        }
    }

    @Override
    public CallSite maybeDecorateIndyCallSite(CallSite originalCallSite, MethodHandles.Lookup caller, String callType, String name, int flags) {
        CacheableCallSite ccs = DefaultCallSiteDecorator.toGroovyCacheableCallSite(originalCallSite);
        switch (callType) {
            case "invoke": {
                DefaultCallSiteDecorator.maybeApplyInterceptor(ccs, caller, flags, this.interceptors.get(InterceptScope.methodsNamed(name)));
                break;
            }
            case "getProperty": {
                DefaultCallSiteDecorator.maybeApplyInterceptor(ccs, caller, flags, this.interceptors.get(InterceptScope.readsOfPropertiesNamed(name)));
                break;
            }
            case "init": {
                DefaultCallSiteDecorator.maybeApplyInterceptor(ccs, caller, flags, this.dispatchingConstructorInterceptor);
            }
        }
        return ccs;
    }

    private static void maybeApplyInterceptor(CacheableCallSite cs, MethodHandles.Lookup caller, int flags, @Nullable CallInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        MethodHandle defaultTarget = interceptor.decorateMethodHandle(cs.getDefaultTarget(), caller, flags);
        cs.setTarget(defaultTarget);
        cs.setDefaultTarget(defaultTarget);
        cs.setFallbackTarget(interceptor.decorateMethodHandle(cs.getFallbackTarget(), caller, flags));
    }

    private static CacheableCallSite toGroovyCacheableCallSite(CallSite cs) {
        if (!(cs instanceof CacheableCallSite)) {
            throw new GradleException("Groovy produced unrecognized call site type of " + cs.getClass());
        }
        return (CacheableCallSite)cs;
    }

    @Override
    public org.codehaus.groovy.runtime.callsite.CallSite maybeDecorateGroovyCallSite(org.codehaus.groovy.runtime.callsite.CallSite originalCallSite) {
        if (this.shouldDecorate(originalCallSite)) {
            return new DecoratingCallSite(originalCallSite);
        }
        return originalCallSite;
    }

    private boolean shouldDecorate(org.codehaus.groovy.runtime.callsite.CallSite callSite) {
        return this.interceptedCallSiteNames.contains(callSite.getName());
    }

    @Override
    @Nullable
    public CallInterceptor resolveCallInterceptor(InterceptScope scope) {
        return this.interceptors.get(scope);
    }

    @Override
    public boolean isAwareOfCallSiteName(String name) {
        return this.interceptedCallSiteNames.contains(name);
    }

    @NonNullApi
    static enum CallStrategy {
        CALL_CURRENT,
        CALL_GROOVY_OBJECT_GET_PROPERTY;

    }

    private class DecoratingCallSite
    extends AbstractCallSite {
        @Nullable
        private org.codehaus.groovy.runtime.callsite.CallSite groovyDefaultCallSite;

        public DecoratingCallSite(org.codehaus.groovy.runtime.callsite.CallSite prev) {
            super(prev);
            this.groovyDefaultCallSite = null;
        }

        public Object call(Object receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.methodsNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.intercept(new AbstractInvocation<Object>(receiver, args){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.call(this.receiver, this.args);
                    }
                }, this.callSiteOwnerClassName());
            }
            return super.call(receiver, args);
        }

        public Object callGetProperty(Object receiver) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.readsOfPropertiesNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.intercept(new AbstractInvocation<Object>(receiver, new Object[0]){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.callGetProperty(this.receiver);
                    }
                }, this.array.owner.getName());
            }
            return super.callGetProperty(receiver);
        }

        public Object callStatic(Class receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.methodsNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.intercept(new AbstractInvocation<Class<?>>(receiver, args){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.callStatic((Class)this.receiver, this.args);
                    }
                }, this.callSiteOwnerClassName());
            }
            return super.callStatic(receiver, args);
        }

        public Object callConstructor(Object receiver, Object[] args) throws Throwable {
            return DefaultCallSiteDecorator.this.dispatchingConstructorInterceptor.intercept(new AbstractInvocation<Object>(receiver, args){

                @Override
                public Object callOriginal() throws Throwable {
                    return DecoratingCallSite.super.callConstructor(this.receiver, this.args);
                }
            }, this.callSiteOwnerClassName());
        }

        @Nullable
        private Object maybeInstrumentedDynamicCall(CallStrategy callStrategy, Object receiver, @Nullable Object[] args) throws Throwable {
            if (DefaultCallSiteDecorator.this.interceptedCallSiteNames.contains(this.getName())) {
                InstrumentedGroovyCallsTracker.CallKind kind = callStrategy == CallStrategy.CALL_CURRENT ? InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD : InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY;
                InstrumentedClosuresHelper.INSTANCE.hitInstrumentedDynamicCall();
                return InstrumentedGroovyCallsHelper.withEntryPoint(this.callSiteOwnerClassName(), this.getName(), kind, () -> this.invokeDefaultGroovyCallSiteImplementation(receiver, args, callStrategy));
            }
            if (callStrategy == CallStrategy.CALL_CURRENT) {
                return super.callCurrent((GroovyObject)receiver, args);
            }
            return super.callGroovyObjectGetProperty(receiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invokeDefaultGroovyCallSiteImplementation(Object receiver, @Nullable Object[] args, CallStrategy callStrategy) throws Throwable {
            assert (this.groovyDefaultCallSite != this);
            switch (callStrategy) {
                case CALL_CURRENT: {
                    if (this.groovyDefaultCallSite != null) {
                        return this.groovyDefaultCallSite.callCurrent((GroovyObject)receiver, args);
                    }
                    try {
                        Object object = super.callCurrent((GroovyObject)receiver, args);
                        return object;
                    }
                    finally {
                        this.restoreCallSiteArrayEntry();
                    }
                }
                case CALL_GROOVY_OBJECT_GET_PROPERTY: {
                    if (this.groovyDefaultCallSite != null) {
                        return this.groovyDefaultCallSite.callGroovyObjectGetProperty(receiver);
                    }
                    try {
                        Object object = super.callGroovyObjectGetProperty(receiver);
                        return object;
                    }
                    finally {
                        this.restoreCallSiteArrayEntry();
                    }
                }
            }
            throw new IllegalArgumentException("Unexpected callStrategy " + (Object)((Object)callStrategy));
        }

        private void restoreCallSiteArrayEntry() {
            org.codehaus.groovy.runtime.callsite.CallSite callSiteInArrayAfterCall = this.array.array[this.index];
            if (callSiteInArrayAfterCall != this) {
                this.groovyDefaultCallSite = callSiteInArrayAfterCall;
            }
            this.array.array[this.index] = this;
        }

        @Nullable
        public Object callGroovyObjectGetProperty(Object receiver) throws Throwable {
            return this.maybeInstrumentedDynamicCall(CallStrategy.CALL_GROOVY_OBJECT_GET_PROPERTY, receiver, null);
        }

        @Nullable
        public Object callCurrent(GroovyObject receiver, Object[] args) throws Throwable {
            return this.maybeInstrumentedDynamicCall(CallStrategy.CALL_CURRENT, receiver, args);
        }

        private String callSiteOwnerClassName() {
            return this.array.owner.getName();
        }
    }
}

