/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.component.ResolutionFailureHandler;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class GraphVariantSelector {
    private final ResolutionFailureHandler failureProcessor;

    public GraphVariantSelector(ResolutionFailureHandler failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public ResolutionFailureHandler getFailureProcessor() {
        return this.failureProcessor;
    }

    public VariantGraphResolveState selectByAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        VariantGraphResolveState result = this.selectByAttributeMatchingLenient(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts);
        if (result == null) {
            ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
            AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
            GraphSelectionCandidates candidates = targetComponentState.getCandidatesForGraphVariantSelection();
            throw this.failureProcessor.noMatchingGraphVariantFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, targetComponent, candidates);
        }
        return result;
    }

    @Nullable
    public VariantGraphResolveState selectByAttributeMatchingLenient(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        GraphSelectionCandidates candidates = targetComponentState.getCandidatesForGraphVariantSelection();
        assert (candidates.isUseVariants());
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
        List<? extends VariantGraphResolveState> allConsumableVariants = candidates.getVariants();
        ImmutableList<VariantGraphResolveState> variantsProvidingRequestedCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, allConsumableVariants, true);
        if (variantsProvidingRequestedCapabilities.isEmpty()) {
            throw this.failureProcessor.noMatchingCapabilitiesFailure(consumerSchema, attributeMatcher, consumerAttributes, targetComponent, explicitRequestedCapabilities, allConsumableVariants);
        }
        List<VariantGraphResolveState> matches = attributeMatcher.matches(variantsProvidingRequestedCapabilities, (AttributeContainerInternal)consumerAttributes, AttributeMatchingExplanationBuilder.logging());
        if (matches.size() > 1) {
            List<VariantGraphResolveState> sameClassifier;
            String classifier;
            Object strictlyMatchingCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, matches, false);
            if (strictlyMatchingCapabilities.size() == 1) {
                return GraphVariantSelector.singleVariant(strictlyMatchingCapabilities);
            }
            if (strictlyMatchingCapabilities.size() > 1 && (strictlyMatchingCapabilities = attributeMatcher.matches(strictlyMatchingCapabilities, (AttributeContainerInternal)consumerAttributes, AttributeMatchingExplanationBuilder.logging())).size() == 1) {
                return GraphVariantSelector.singleVariant((List<VariantGraphResolveState>)strictlyMatchingCapabilities);
            }
            if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = this.findVariantsProvidingExactlySameClassifier(matches, classifier)) != null && sameClassifier.size() == 1) {
                return GraphVariantSelector.singleVariant(sameClassifier);
            }
        }
        if (matches.size() == 1) {
            return GraphVariantSelector.singleVariant(matches);
        }
        if (!matches.isEmpty()) {
            throw this.failureProcessor.ambiguousGraphVariantsFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, matches, targetComponent);
        }
        return null;
    }

    public VariantGraphResolveState selectLegacyConfiguration(ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema) {
        VariantGraphResolveState conf = targetComponentState.getCandidatesForGraphVariantSelection().getLegacyVariant();
        if (conf == null) {
            throw this.failureProcessor.configurationNotFoundFailure(targetComponentState.getId(), "default");
        }
        this.validateVariantAttributes(conf, consumerAttributes, targetComponentState, consumerSchema);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(conf);
        return conf;
    }

    public VariantGraphResolveState selectConfigurationByName(String name, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema) {
        VariantGraphResolveState conf = targetComponentState.getCandidatesForGraphVariantSelection().getVariantByConfigurationName(name);
        if (conf == null) {
            throw this.failureProcessor.configurationNotFoundFailure(targetComponentState.getId(), name);
        }
        this.validateVariantAttributes(conf, consumerAttributes, targetComponentState, consumerSchema);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(conf);
        return conf;
    }

    private void validateVariantAttributes(VariantGraphResolveState conf, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema) {
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
        if (!(consumerAttributes.isEmpty() || conf.getAttributes().isEmpty() || attributeMatcher.isMatching((AttributeContainerInternal)conf.getAttributes(), (AttributeContainerInternal)consumerAttributes))) {
            throw this.failureProcessor.incompatibleRequestedConfigurationFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, targetComponent, conf);
        }
    }

    @Nullable
    private List<VariantGraphResolveState> findVariantsProvidingExactlySameClassifier(List<VariantGraphResolveState> matches, String classifier) {
        ArrayList sameClassifier = null;
        for (VariantGraphResolveState match : matches) {
            ComponentArtifactMetadata componentArtifactMetadata;
            List<? extends ComponentArtifactMetadata> artifacts = match.resolveArtifacts().getArtifacts();
            if (artifacts.size() != 1 || !((componentArtifactMetadata = artifacts.get(0)) instanceof ModuleComponentArtifactMetadata) || !classifier.equals(componentArtifactMetadata.getName().getClassifier())) continue;
            if (sameClassifier == null) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private static VariantGraphResolveState singleVariant(List<VariantGraphResolveState> matches) {
        assert (matches.size() == 1);
        VariantGraphResolveState match = matches.get(0);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(match);
        return match;
    }

    private static void maybeEmitConsumptionDeprecation(VariantGraphResolveState targetVariant) {
        if (targetVariant.getMetadata().isDeprecated()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration((String)targetVariant.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
    }

    private ImmutableList<VariantGraphResolveState> filterVariantsByRequestedCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, Collection<? extends VariantGraphResolveState> consumableVariants, boolean lenient) {
        if (consumableVariants.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableVariants.size());
        boolean explicitlyRequested = !explicitRequestedCapabilities.isEmpty();
        ModuleIdentifier moduleId = targetComponent.getModuleVersionId().getModule();
        for (VariantGraphResolveState variantGraphResolveState : consumableVariants) {
            ImmutableCapabilities capabilities = variantGraphResolveState.getCapabilities();
            MatchResult result = explicitlyRequested ? this.providesAllCapabilities(targetComponent, explicitRequestedCapabilities, capabilities) : this.containsImplicitCapability(capabilities, moduleId.getGroup(), moduleId.getName());
            if (!result.matches || !lenient && result != MatchResult.EXACT_MATCH) continue;
            builder.add((Object)variantGraphResolveState);
        }
        return builder.build();
    }

    private MatchResult providesAllCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, ImmutableCapabilities providerCapabilities) {
        ImmutableSet<ImmutableCapability> providerCapabilitiesSet = providerCapabilities.asSet();
        if (providerCapabilitiesSet.isEmpty() && explicitRequestedCapabilities.size() == 1) {
            Capability requested = explicitRequestedCapabilities.iterator().next();
            ModuleVersionIdentifier moduleVersionIdentifier = targetComponent.getModuleVersionId();
            if (requested.getGroup().equals(moduleVersionIdentifier.getGroup()) && requested.getName().equals(moduleVersionIdentifier.getName())) {
                return MatchResult.EXACT_MATCH;
            }
        }
        for (Capability capability : explicitRequestedCapabilities) {
            String requestedGroup = capability.getGroup();
            String requestedName = capability.getName();
            boolean found = false;
            for (Capability provided : providerCapabilitiesSet) {
                if (!provided.getGroup().equals(requestedGroup) || !provided.getName().equals(requestedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        boolean exactMatch = explicitRequestedCapabilities.size() == providerCapabilitiesSet.size();
        return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
    }

    private MatchResult containsImplicitCapability(ImmutableCapabilities capabilities, String group, String name) {
        ImmutableSet<ImmutableCapability> capabilitiesSet = capabilities.asSet();
        if (GraphVariantSelector.fastContainsImplicitCapability(capabilitiesSet)) {
            return MatchResult.EXACT_MATCH;
        }
        for (Capability capability : capabilitiesSet) {
            if (!group.equals((capability = this.unwrap(capability)).getGroup()) || !name.equals(capability.getName())) continue;
            boolean exactMatch = capabilitiesSet.size() == 1;
            return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
        }
        return MatchResult.NO_MATCH;
    }

    private static boolean fastContainsImplicitCapability(ImmutableSet<ImmutableCapability> capabilities) {
        if (capabilities.isEmpty()) {
            return true;
        }
        return capabilities.size() == 1 && capabilities.iterator().next() instanceof ShadowedCapability;
    }

    private Capability unwrap(Capability capability) {
        if (capability instanceof ShadowedCapability) {
            return ((ShadowedCapability)capability).getShadowedCapability();
        }
        return capability;
    }

    private static enum MatchResult {
        NO_MATCH(false),
        MATCHES_ALL(true),
        EXACT_MATCH(true);

        private final boolean matches;

        private MatchResult(boolean match) {
            this.matches = match;
        }
    }
}

