/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.userinput.AbstractUserInputHandler;
import org.gradle.api.internal.tasks.userinput.Choice;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.internal.logging.events.BooleanQuestionPromptEvent;
import org.gradle.internal.logging.events.IntQuestionPromptEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.SelectOptionPromptEvent;
import org.gradle.internal.logging.events.TextQuestionPromptEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.logging.events.YesNoQuestionPromptEvent;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.TextUtil;

public class DefaultUserInputHandler
extends AbstractUserInputHandler {
    private final OutputEventListener outputEventBroadcaster;
    private final Clock clock;
    private final UserInputReader userInputReader;
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public DefaultUserInputHandler(OutputEventListener outputEventBroadcaster, Clock clock, UserInputReader userInputReader) {
        this.outputEventBroadcaster = outputEventBroadcaster;
        this.clock = clock;
        this.userInputReader = userInputReader;
    }

    @Override
    protected AbstractUserInputHandler.UserInteraction newInteraction() {
        return new InteractiveUserQuestions();
    }

    @Override
    public boolean interrupted() {
        return this.interrupted.get();
    }

    private String sanitizeInput(String input) {
        return CharMatcher.javaIsoControl().removeFrom((CharSequence)StringUtils.trim((String)input));
    }

    private static class InteractiveChoiceBuilder<T>
    implements Choice<T> {
        private final InteractiveUserQuestions owner;
        private final Collection<T> options;
        private final String question;
        private T defaultOption;
        private Function<T, String> renderer = Object::toString;

        public InteractiveChoiceBuilder(InteractiveUserQuestions owner, Collection<T> options, String question) {
            this.owner = owner;
            this.options = options;
            this.question = question;
            this.defaultOption = options.iterator().next();
        }

        @Override
        public Choice<T> renderUsing(Function<T, String> renderer) {
            this.renderer = renderer;
            return this;
        }

        @Override
        public Choice<T> defaultOption(T defaultOption) {
            this.defaultOption = defaultOption;
            return this;
        }

        @Override
        public Choice<T> whenNotConnected(T defaultOption) {
            return this;
        }

        @Override
        public T ask() {
            return (T)this.owner.selectOption(this.question, this.options, this.defaultOption, this.renderer);
        }
    }

    private class InteractiveUserQuestions
    implements AbstractUserInputHandler.UserInteraction {
        private boolean hasPrompted;

        private InteractiveUserQuestions() {
        }

        @Override
        public Boolean askYesNoQuestion(String question) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" [");
            builder.append(StringUtils.join((Collection)YesNoQuestionPromptEvent.YES_NO_CHOICES, (String)", "));
            builder.append("] ");
            YesNoQuestionPromptEvent prompt = new YesNoQuestionPromptEvent(DefaultUserInputHandler.this.clock.getCurrentTime(), builder.toString());
            return (Boolean)this.prompt((PromptOutputEvent)prompt, BooleanUtils::toBoolean);
        }

        @Override
        public boolean askBooleanQuestion(String question, boolean defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (default: ");
            String defaultString = defaultValue ? "yes" : "no";
            builder.append(defaultString);
            builder.append(") [");
            builder.append(StringUtils.join((Collection)YesNoQuestionPromptEvent.YES_NO_CHOICES, (String)", "));
            builder.append("] ");
            BooleanQuestionPromptEvent prompt = new BooleanQuestionPromptEvent(DefaultUserInputHandler.this.clock.getCurrentTime(), builder.toString(), defaultValue, defaultString);
            return this.prompt((PromptOutputEvent)prompt, defaultValue, BooleanUtils::toBoolean);
        }

        @Override
        public <T> T selectOption(String question, Collection<T> options, T defaultOption) {
            return this.choice(question, options).defaultOption(defaultOption).ask();
        }

        @Override
        public <T> Choice<T> choice(String question, Collection<T> options) {
            if (options.isEmpty()) {
                throw new IllegalArgumentException("No options provided.");
            }
            return new InteractiveChoiceBuilder<T>(this, options, question);
        }

        @Override
        public int askIntQuestion(String question, int minValue, int defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (min: ");
            builder.append(minValue);
            builder.append(", default: ");
            builder.append(defaultValue);
            builder.append("): ");
            IntQuestionPromptEvent prompt = new IntQuestionPromptEvent(DefaultUserInputHandler.this.clock.getCurrentTime(), builder.toString(), minValue, defaultValue);
            return this.prompt((PromptOutputEvent)prompt, defaultValue, Integer::parseInt);
        }

        @Override
        public String askQuestion(String question, String defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (default: ");
            builder.append(defaultValue);
            builder.append("): ");
            TextQuestionPromptEvent prompt = new TextQuestionPromptEvent(DefaultUserInputHandler.this.clock.getCurrentTime(), builder.toString());
            return this.prompt((PromptOutputEvent)prompt, defaultValue, sanitizedValue -> sanitizedValue);
        }

        private <T> T prompt(PromptOutputEvent prompt, T defaultValue, Transformer<T, String> parser) {
            T result = this.prompt(prompt, sanitizedInput -> {
                if (sanitizedInput.isEmpty()) {
                    return defaultValue;
                }
                return parser.transform(sanitizedInput);
            });
            if (result == null) {
                return defaultValue;
            }
            return result;
        }

        @Nullable
        private <T> T prompt(PromptOutputEvent prompt, Transformer<T, String> parser) {
            UserInputReader.UserInput input;
            String sanitizedInput;
            Object result;
            if (DefaultUserInputHandler.this.interrupted.get()) {
                return null;
            }
            if (!this.hasPrompted) {
                DefaultUserInputHandler.this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputRequestEvent());
                this.hasPrompted = true;
            }
            DefaultUserInputHandler.this.outputEventBroadcaster.onOutput((OutputEvent)prompt);
            do {
                if ((input = DefaultUserInputHandler.this.userInputReader.readInput()) != UserInputReader.END_OF_INPUT) continue;
                DefaultUserInputHandler.this.interrupted.set(true);
                return null;
            } while ((result = parser.transform((Object)(sanitizedInput = DefaultUserInputHandler.this.sanitizeInput(input.getText())))) == null);
            return (T)result;
        }

        private <T> T selectOption(String question, Collection<T> options, T defaultOption, Function<T, String> renderer) {
            if (!options.contains(defaultOption)) {
                throw new IllegalArgumentException("Default value is not one of the provided options.");
            }
            if (options.size() == 1) {
                return defaultOption;
            }
            ArrayList values = new ArrayList(options);
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(":");
            builder.append(TextUtil.getPlatformLineSeparator());
            for (int i = 0; i < options.size(); ++i) {
                Object option = values.get(i);
                builder.append("  ");
                builder.append(i + 1);
                builder.append(": ");
                builder.append(renderer.apply(option));
                builder.append(TextUtil.getPlatformLineSeparator());
            }
            builder.append("Enter selection (default: ");
            builder.append(renderer.apply(defaultOption));
            builder.append(") [1..");
            builder.append(options.size());
            builder.append("] ");
            SelectOptionPromptEvent prompt = new SelectOptionPromptEvent(DefaultUserInputHandler.this.clock.getCurrentTime(), builder.toString(), values.size(), values.indexOf(defaultOption) + 1);
            return this.prompt((PromptOutputEvent)prompt, defaultOption, sanitizedInput -> {
                int value = Integer.parseInt(sanitizedInput);
                return values.get(value - 1);
            });
        }

        @Override
        public void finish() {
            if (this.hasPrompted) {
                DefaultUserInputHandler.this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputResumeEvent(DefaultUserInputHandler.this.clock.getCurrentTime()));
            }
        }
    }
}

