/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;

public class StringBackedTextResource
implements TextResourceInternal {
    private final TemporaryFileProvider tempFileProvider;
    private final String string;

    public StringBackedTextResource(TemporaryFileProvider tempFileProvider, String string) {
        this.tempFileProvider = tempFileProvider;
        this.string = string;
    }

    @Override
    public String getDisplayName() {
        return "text resource";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String asString() {
        return this.string;
    }

    public Reader asReader() {
        return new StringReader(this.string);
    }

    public File asFile(String charset) {
        File file = this.tempFileProvider.createTemporaryFile("string", ".txt", new String[]{"resource"});
        try {
            Files.asCharSink((File)file, (Charset)Charset.forName(charset), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.string);
        }
        catch (IOException e) {
            throw new ResourceException("Could not write " + this.getDisplayName() + " content to " + file + ".", (Throwable)e);
        }
        return file;
    }

    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    public Object getInputProperties() {
        return this.string;
    }

    public FileCollection getInputFiles() {
        return null;
    }
}

