/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.CachedStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.DefaultBinaryStore;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.Store;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class ResolutionResultsStoreFactory
implements Closeable {
    private static final Logger LOG = Logging.getLogger(ResolutionResultsStoreFactory.class);
    private static final int DEFAULT_MAX_SIZE = 2000000000;
    private final TemporaryFileProvider temp;
    private final int maxSize;
    private CachedStoreFactory<TransientConfigurationResults> oldModelCache;
    private CachedStoreFactory<ResolvedComponentResultInternal> newModelCache;
    private final AtomicInteger storeSetBaseId = new AtomicInteger();
    private final Map<String, DefaultBinaryStore> stores = new HashMap<String, DefaultBinaryStore>();
    private final CompositeStoppable cleanUpLater = new CompositeStoppable();

    public ResolutionResultsStoreFactory(TemporaryFileProvider temp) {
        this(temp, 2000000000);
    }

    ResolutionResultsStoreFactory(TemporaryFileProvider temp, int maxSize) {
        this.temp = temp;
        this.maxSize = maxSize;
    }

    private synchronized DefaultBinaryStore createBinaryStore(String storeKey) {
        DefaultBinaryStore store = this.stores.get(storeKey);
        if (store == null || this.isFull(store) || store.isInUse()) {
            File storeFile = this.temp.createTemporaryFile("gradle", ".bin", new String[0]);
            storeFile.deleteOnExit();
            store = new DefaultBinaryStore(storeFile);
            this.stores.put(storeKey, store);
            this.cleanUpLater.add((Object)store);
        }
        return store;
    }

    private synchronized CachedStoreFactory<TransientConfigurationResults> getOldModelCache() {
        if (this.oldModelCache == null) {
            this.oldModelCache = new CachedStoreFactory("Resolution result");
            this.cleanUpLater.add(this.oldModelCache);
        }
        return this.oldModelCache;
    }

    private synchronized CachedStoreFactory<ResolvedComponentResultInternal> getNewModelCache() {
        if (this.newModelCache == null) {
            this.newModelCache = new CachedStoreFactory("Resolution result");
            this.cleanUpLater.add(this.newModelCache);
        }
        return this.newModelCache;
    }

    public StoreSet createStoreSet() {
        return new StoreSet(){
            final int storeSetId;
            int binaryStoreId;
            {
                this.storeSetId = ResolutionResultsStoreFactory.this.storeSetBaseId.getAndIncrement();
            }

            @Override
            public DefaultBinaryStore nextBinaryStore() {
                String storeKey = Thread.currentThread().getId() + "-" + this.binaryStoreId++;
                return ResolutionResultsStoreFactory.this.createBinaryStore(storeKey);
            }

            @Override
            public Store<ResolvedComponentResultInternal> newModelCache() {
                return ResolutionResultsStoreFactory.this.getNewModelCache().createCachedStore(this.storeSetId);
            }

            @Override
            public Store<TransientConfigurationResults> oldModelCache() {
                return ResolutionResultsStoreFactory.this.getOldModelCache().createCachedStore(this.storeSetId);
            }
        };
    }

    private boolean isFull(DefaultBinaryStore store) {
        return store.getSize() > (long)this.maxSize;
    }

    @Override
    public void close() {
        try {
            Timer clock = Time.startTimer();
            this.cleanUpLater.stop();
            LOG.debug("Deleted {} resolution results binary files in {}", (Object)this.stores.size(), (Object)clock.getElapsed());
        }
        finally {
            this.oldModelCache = null;
            this.newModelCache = null;
            this.stores.clear();
        }
    }
}

