/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.services;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileSystems;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.PosixFiles;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.terminal.Terminals;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.NativeCapabilities;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.FallbackConsoleDetector;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.TestOverrideConsoleDetector;
import org.gradle.internal.nativeintegration.console.WindowsConsoleDetector;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FileSystemServices;
import org.gradle.internal.nativeintegration.filesystem.services.JdkFallbackHelper;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.jansi.JansiBootPathConfigurer;
import org.gradle.internal.nativeintegration.jna.UnsupportedEnvironment;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.nativeintegration.processenvironment.NativePlatformBackedProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.util.internal.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeServices
implements ServiceRegistrationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeServices.class);
    private static final NativeServices INSTANCE = new NativeServices();
    public static final String NATIVE_SERVICES_OPTION = "org.gradle.native";
    public static final String NATIVE_DIR_OVERRIDE = "org.gradle.native.dir";
    private boolean initialized;
    private boolean useNativeIntegrations;
    private File userHomeDir;
    private File nativeBaseDir;
    private final EnumSet<NativeFeatures> initializedFeatures = EnumSet.noneOf(NativeFeatures.class);
    private final EnumSet<NativeFeatures> enabledFeatures = EnumSet.noneOf(NativeFeatures.class);
    private final ServiceRegistry services = ServiceRegistryBuilder.builder().displayName("native services").provider((ServiceRegistrationProvider)new FileSystemServices()).provider((ServiceRegistrationProvider)this).provider(new ServiceRegistrationProvider(){

        public void configure(ServiceRegistration registration) {
            registration.add(GradleUserHomeTemporaryFileProvider.class);
        }
    }).build();

    public static void initializeOnDaemon(File userHomeDir, NativeServicesMode mode) {
        INSTANCE.initialize(userHomeDir, EnumSet.allOf(NativeFeatures.class), mode);
    }

    public static void initializeOnClient(File userHomeDir, NativeServicesMode mode) {
        INSTANCE.initialize(userHomeDir, EnumSet.of(NativeFeatures.JANSI), mode);
    }

    public static void initializeOnWorker(File userHomeDir, NativeServicesMode mode) {
        INSTANCE.initialize(userHomeDir, EnumSet.noneOf(NativeFeatures.class), mode);
    }

    public static void logFileSystemWatchingUnavailable(net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File system watching is not available", (Throwable)ex);
        } else {
            LOGGER.info("File system watching is not available: {}", (Object)ex.getMessage());
        }
    }

    private void initialize(File userHomeDir, EnumSet<NativeFeatures> requestedFeatures, NativeServicesMode mode) {
        NativeServices.checkNativeServicesMode(mode);
        if (!this.initialized) {
            try {
                this.initializeNativeIntegrations(userHomeDir, mode);
                this.initialized = true;
                this.initializeFeatures(requestedFeatures);
            }
            catch (RuntimeException e) {
                throw new ServiceCreationException("Could not initialize native services.", (Throwable)e);
            }
        }
    }

    private static void checkNativeServicesMode(NativeServicesMode mode) {
        if (mode != NativeServicesMode.ENABLED && mode != NativeServicesMode.DISABLED) {
            throw new IllegalArgumentException("Only explicit ENABLED or DISABLED mode is allowed for the NativeServices initialization, but was: " + (Object)((Object)mode));
        }
    }

    private void initializeNativeIntegrations(File userHomeDir, NativeServicesMode nativeServicesMode) {
        this.userHomeDir = userHomeDir;
        this.useNativeIntegrations = NativeServices.shouldUseNativeIntegration(nativeServicesMode);
        this.nativeBaseDir = NativeServices.getNativeServicesDir(userHomeDir).getAbsoluteFile();
        if (this.useNativeIntegrations) {
            try {
                Native.init((File)this.nativeBaseDir);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform is not available.", (Throwable)ex);
                this.useNativeIntegrations = false;
            }
            catch (NativeException ex) {
                if (ex.getCause() instanceof UnsatisfiedLinkError && ex.getCause().getMessage().toLowerCase(Locale.ROOT).contains("already loaded in another classloader")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    this.useNativeIntegrations = false;
                }
                if (ex.getMessage().equals("Could not extract native JNI library.") && ex.getCause().getMessage().contains("native-platform.dll (The process cannot access the file because it is being used by another process)")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    this.useNativeIntegrations = false;
                }
                throw ex;
            }
            LOGGER.info("Initialized native services in: {}", (Object)this.nativeBaseDir);
        }
    }

    private static boolean shouldUseNativeIntegration(NativeServicesMode nativeServicesMode) {
        if (!nativeServicesMode.isEnabled()) {
            return false;
        }
        if (NativeServices.isLinuxWithMusl()) {
            LOGGER.debug("Native-platform is not available on Linux with musl libc.");
            return false;
        }
        return true;
    }

    private static boolean isLinuxWithMusl() {
        if (!OperatingSystem.current().isLinux()) {
            return false;
        }
        try {
            File mapFilesDir = new File("/proc/self/map_files");
            if (!mapFilesDir.isDirectory()) {
                return false;
            }
            File[] files = mapFilesDir.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                if (!file.getCanonicalFile().getName().contains("-musl-")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void initializeFeatures(EnumSet<NativeFeatures> requestedFeatures) {
        if (this.useNativeIntegrations) {
            for (NativeFeatures requestedFeature : requestedFeatures) {
                if (!this.initializedFeatures.add(requestedFeature) || !requestedFeature.initialize(this.nativeBaseDir, this.useNativeIntegrations)) continue;
                this.enabledFeatures.add(requestedFeature);
            }
        }
    }

    private boolean isFeatureEnabled(NativeFeatures feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    private static File getNativeServicesDir(File userHomeDir) {
        String overrideProperty = NativeServices.getNativeDirOverride();
        if (overrideProperty == null) {
            return new File(userHomeDir, "native");
        }
        return new File(overrideProperty);
    }

    @Nullable
    private static String getNativeDirOverride() {
        return System.getProperty(NATIVE_DIR_OVERRIDE, System.getenv(NATIVE_DIR_OVERRIDE));
    }

    public static synchronized ServiceRegistry getInstance() {
        if (!NativeServices.INSTANCE.initialized) {
            throw new IllegalStateException("Cannot get an instance of NativeServices without first calling initialize().");
        }
        return NativeServices.INSTANCE.services;
    }

    private NativeServices() {
    }

    @Provides
    protected GradleUserHomeDirProvider createGradleUserHomeDirProvider() {
        return new GradleUserHomeDirProvider(){

            public File getGradleUserHomeDirectory() {
                return NativeServices.this.userHomeDir;
            }
        };
    }

    @Provides
    protected OperatingSystem createOperatingSystem() {
        return OperatingSystem.current();
    }

    @Provides
    protected Jvm createJvm() {
        return Jvm.current();
    }

    @Provides
    protected ProcessEnvironment createProcessEnvironment(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Process process = (Process)Native.get(Process.class);
                return new NativePlatformBackedProcessEnvironment(process);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform process integration is not available. Continuing with fallback.");
            }
        }
        return new UnsupportedEnvironment();
    }

    @Provides
    protected ConsoleDetector createConsoleDetector(OperatingSystem operatingSystem) {
        return new TestOverrideConsoleDetector(this.backingConsoleDetector(operatingSystem));
    }

    private ConsoleDetector backingConsoleDetector(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Terminals terminals = (Terminals)Native.get(Terminals.class);
                return new NativePlatformConsoleDetector(terminals);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform terminal integration is not available. Continuing with fallback.");
            }
            catch (NativeException ex) {
                LOGGER.debug("Unable to load from native-platform backed ConsoleDetector. Continuing with fallback. Failure: {}", (Object)NativeServices.format(ex));
            }
            try {
                if (operatingSystem.isWindows()) {
                    return new WindowsConsoleDetector();
                }
            }
            catch (LinkageError e) {
                LOGGER.debug("Unable to load native library. Continuing with fallback. Failure: {}", (Object)NativeServices.format(e));
            }
        }
        return new FallbackConsoleDetector();
    }

    @Provides
    protected WindowsRegistry createWindowsRegistry(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations && operatingSystem.isWindows()) {
            return (WindowsRegistry)Native.get(WindowsRegistry.class);
        }
        return this.notAvailable(WindowsRegistry.class, operatingSystem);
    }

    @Provides
    public SystemInfo createSystemInfo(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (SystemInfo)Native.get(SystemInfo.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform system info is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(SystemInfo.class, operatingSystem);
    }

    @Provides
    protected Memory createMemory(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (Memory)Native.get(Memory.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform memory integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(Memory.class, operatingSystem);
    }

    @Provides
    protected PosixFiles createPosixFiles(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (PosixFiles)Native.get(PosixFiles.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(UnavailablePosixFiles.class, operatingSystem);
    }

    @Provides
    protected HostnameLookup createHostnameLookup() {
        String hostname;
        if (this.useNativeIntegrations) {
            try {
                String hostname2 = ((SystemInfo)Native.get(SystemInfo.class)).getHostname();
                return new FixedHostname(hostname2);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return new FixedHostname(hostname);
    }

    @Provides
    protected FileMetadataAccessor createFileMetadataAccessor(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return new NativePlatformBackedFileMetadataAccessor((Files)Native.get(Files.class));
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform files integration is not available. Continuing with fallback.");
            }
        }
        if (JavaVersion.current().isJava7Compatible()) {
            return JdkFallbackHelper.newInstanceOrFallback("org.gradle.internal.file.nio.NioFileMetadataAccessor", NativeServices.class.getClassLoader(), FallbackFileMetadataAccessor.class);
        }
        return new FallbackFileMetadataAccessor();
    }

    @Provides
    public NativeCapabilities createNativeCapabilities() {
        return new NativeCapabilities(){

            @Override
            public boolean useNativeIntegrations() {
                return NativeServices.this.useNativeIntegrations;
            }

            @Override
            public boolean useFileSystemWatching() {
                String version;
                OperatingSystem operatingSystem = OperatingSystem.current();
                if (operatingSystem.isMacOsX() && VersionNumber.parse((String)(version = operatingSystem.getVersion())).getMajor() < 12) {
                    LOGGER.info("Disabling file system watching on macOS {}, as it is only supported for macOS 12+", (Object)version);
                    return false;
                }
                return NativeServices.this.isFeatureEnabled(NativeFeatures.FILE_SYSTEM_WATCHING);
            }
        };
    }

    @Provides
    protected FileSystems createFileSystems(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (FileSystems)Native.get(FileSystems.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform file systems information is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(FileSystems.class, operatingSystem);
    }

    private <T> T notAvailable(Class<T> type, OperatingSystem operatingSystem) {
        return (T)Cast.uncheckedNonnullCast((Object)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BrokenService(type.getSimpleName(), this.useNativeIntegrations, operatingSystem)));
    }

    private static String format(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable);
        for (Throwable current = throwable.getCause(); current != null; current = current.getCause()) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
            builder.append("caused by: ");
            builder.append(current);
        }
        return builder.toString();
    }

    private static class FixedHostname
    implements HostnameLookup {
        private final String hostname;

        public FixedHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }
    }

    private static class BrokenService
    implements InvocationHandler {
        private final String type;
        private final boolean useNativeIntegrations;
        private final OperatingSystem operatingSystem;

        private BrokenService(String type, boolean useNativeIntegrations, OperatingSystem operatingSystem) {
            this.type = type;
            this.useNativeIntegrations = useNativeIntegrations;
            this.operatingSystem = operatingSystem;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new NativeIntegrationUnavailableException(String.format("Service '%s' is not available (os=%s, enabled=%s).", this.type, this.operatingSystem, this.useNativeIntegrations));
        }
    }

    public static enum NativeServicesMode {
        ENABLED{

            @Override
            public boolean isEnabled() {
                return true;
            }
        }
        ,
        DISABLED{

            @Override
            public boolean isEnabled() {
                return false;
            }
        }
        ,
        NOT_SET{

            @Override
            public boolean isEnabled() {
                throw new UnsupportedOperationException("Cannot determine if native services are enabled or not for " + (Object)((Object)this) + " mode.");
            }
        };


        public abstract boolean isEnabled();

        public static NativeServicesMode from(boolean isEnabled) {
            return isEnabled ? ENABLED : DISABLED;
        }

        public static NativeServicesMode fromSystemProperties() {
            return NativeServicesMode.fromString(System.getProperty(NativeServices.NATIVE_SERVICES_OPTION));
        }

        public static NativeServicesMode fromProperties(Map<String, String> properties) {
            return NativeServicesMode.fromString(properties.get(NativeServices.NATIVE_SERVICES_OPTION));
        }

        public static NativeServicesMode fromString(@Nullable String value) {
            value = (value == null ? "true" : value).trim();
            return NativeServicesMode.from(!"false".equalsIgnoreCase(value));
        }
    }

    public static enum NativeFeatures {
        FILE_SYSTEM_WATCHING{

            @Override
            public boolean initialize(File nativeBaseDir, boolean useNativeIntegrations) {
                if (useNativeIntegrations) {
                    try {
                        FileEvents.init((File)nativeBaseDir);
                        LOGGER.info("Initialized file system watching services in: {}", (Object)nativeBaseDir);
                        return true;
                    }
                    catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                        NativeServices.logFileSystemWatchingUnavailable(ex);
                        return false;
                    }
                }
                return false;
            }
        }
        ,
        JANSI{

            @Override
            public boolean initialize(File nativeBaseDir, boolean canUseNativeIntegrations) {
                JANSI_BOOT_PATH_CONFIGURER.configure(nativeBaseDir);
                LOGGER.info("Initialized jansi services in: {}", (Object)nativeBaseDir);
                return true;
            }
        };

        private static final JansiBootPathConfigurer JANSI_BOOT_PATH_CONFIGURER;

        public abstract boolean initialize(File var1, boolean var2);

        static {
            JANSI_BOOT_PATH_CONFIGURER = new JansiBootPathConfigurer();
        }
    }
}

