/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultReportContainer<T extends Report>
extends DefaultNamedDomainObjectSet<T>
implements ReportContainer<T> {
    private final NamedDomainObjectSet<T> enabled;

    public static <T extends Report> DefaultReportContainer<T> create(ObjectFactory objectFactory, Class<? extends T> type, ReportGenerator<T> reportGenerator) {
        return (DefaultReportContainer)objectFactory.newInstance(DefaultReportContainer.class, new Object[]{type, reportGenerator});
    }

    @Inject
    public DefaultReportContainer(Class<? extends T> type, ReportGenerator<T> reportGenerator, InstantiatorFactory instantiatorFactory, ServiceRegistry servicesToInject, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(type, (Instantiator)instantiatorFactory.decorateLenient((ServiceLookup)servicesToInject), Report.NAMER, callbackActionDecorator);
        this.addAll(reportGenerator.generateReports(new DefaultReportFactory(this.getInstantiator())));
        this.beforeCollectionChanges(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)arg -> {
            throw new ReportContainer.ImmutableViolationException();
        }));
        this.enabled = this.matching(SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)element -> (Boolean)element.getRequired().get()));
    }

    @Override
    public NamedDomainObjectSet<T> getEnabled() {
        return this.enabled;
    }

    @Override
    public Map<String, T> getEnabledReports() {
        return this.getEnabled().getAsMap();
    }

    public ReportContainer<T> configure(Closure cl) {
        ConfigureUtil.configureSelf((Closure)cl, (Object)this);
        return this;
    }

    static class DefaultReportFactory<T extends Report>
    implements ReportFactory<T> {
        private final Instantiator instantiator;

        public DefaultReportFactory(Instantiator instantiator) {
            this.instantiator = instantiator;
        }

        @Override
        public <N extends T> N instantiateReport(Class<N> clazz, Object ... constructionArgs) {
            Report report = (Report)this.instantiator.newInstance(clazz, constructionArgs);
            String name = report.getName();
            if (name.equals("enabled")) {
                throw new InvalidUserDataException("Reports that are part of a ReportContainer cannot be named 'enabled'");
            }
            return (N)report;
        }
    }

    public static interface ReportFactory<T extends Report> {
        public <N extends T> N instantiateReport(Class<N> var1, Object ... var2);
    }

    public static interface ReportGenerator<T extends Report> {
        public Collection<T> generateReports(ReportFactory<T> var1);
    }
}

