/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ArtifactSelectionException;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactsFailure;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousArtifactsFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousArtifactsFailure> {
    private static final String AMBIGUOUS_VARIANTS_PREFIX = "Ambiguity errors are explained in more detail at ";
    private static final String AMBIGUOUS_VARIANTS_SECTION = "sub:variant-ambiguity";

    public ArtifactSelectionException describeFailure(AmbiguousArtifactsFailure failure, Optional<AttributesSchemaInternal> schema) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), schema.orElseThrow(IllegalArgumentException::new));
        String message = this.buildFailureMsg(failure, describer);
        List<String> resolutions = this.buildResolutions(this.suggestSpecificDocumentation(AMBIGUOUS_VARIANTS_PREFIX, AMBIGUOUS_VARIANTS_SECTION), this.suggestReviewAlgorithm());
        return new ArtifactSelectionException(message, failure, resolutions);
    }

    private String buildFailureMsg(AmbiguousArtifactsFailure failure, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("More than one variant of " + failure.describeRequestTarget() + " matches the consumer attributes");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap()) + ". However we cannot choose between the following variants of " + failure.describeRequestTarget());
        }
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : failure.getCandidates()) {
            String candidateName = assessedCandidate.getDisplayName();
            formatter.node(candidateName);
            this.formatAttributeMatchesForAmbiguity(assessedCandidate, formatter, describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

