; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple arm64-apple-ios -mattr +cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-CMPBR
; RUN: llc -mtriple arm64-apple-ios -mattr -cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-NO-CMPBR

; slt, sle, sgt, sge, ult, ule, ugt, uge, eq, ne

define void @slt_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: slt_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    tbnz w0, #31, LBB0_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: slt_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    tbnz w0, #31, LBB0_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @slt_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: slt_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-2 ; =0xfffffffe
; CHECK-CMPBR-NEXT:    cbge w8, w0, LBB1_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: slt_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #2
; CHECK-NO-CMPBR-NEXT:    b.le LBB1_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @slt_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: slt_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt w0, #63, LBB2_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: slt_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #62
; CHECK-NO-CMPBR-NEXT:    b.le LBB2_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @slt_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: slt_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #63 ; =0x3f
; CHECK-CMPBR-NEXT:    cbge w8, w0, LBB3_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: slt_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.le LBB3_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sle_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sle_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt w0, #1, LBB4_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sle_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #0
; CHECK-NO-CMPBR-NEXT:    b.le LBB4_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sle_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sle_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    tbnz w0, #31, LBB5_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sle_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    tbnz w0, #31, LBB5_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sle_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sle_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #63 ; =0x3f
; CHECK-CMPBR-NEXT:    cbge w8, w0, LBB6_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sle_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.le LBB6_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sle_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sle_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbge w8, w0, LBB7_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sle_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.le LBB7_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sgt_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sgt_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w0, #0, LBB8_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sgt_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #1
; CHECK-NO-CMPBR-NEXT:    b.ge LBB8_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sgt_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sgt_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    tbz w0, #31, LBB9_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sgt_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    tbz w0, #31, LBB9_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sgt_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sgt_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB10_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sgt_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.ge LBB10_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sgt_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sgt_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #65 ; =0x41
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB11_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sgt_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #65
; CHECK-NO-CMPBR-NEXT:    b.ge LBB11_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sge_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sge_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    tbz w0, #31, LBB12_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sge_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    tbz w0, #31, LBB12_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sge_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sge_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-1 ; =0xffffffff
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB13_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sge_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #1
; CHECK-NO-CMPBR-NEXT:    b.ge LBB13_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sge_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sge_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w0, #62, LBB14_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sge_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.ge LBB14_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sge_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: sge_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB15_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sge_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.ge LBB15_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ult_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ult_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi wzr, w0, LBB16_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ult_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #0
; CHECK-NO-CMPBR-NEXT:    b.lo LBB16_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ult_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ult_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo w0, #63, LBB17_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ult_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #62
; CHECK-NO-CMPBR-NEXT:    b.ls LBB17_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ult_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ult_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #63 ; =0x3f
; CHECK-CMPBR-NEXT:    cbhs w8, w0, LBB18_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ult_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.ls LBB18_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ule_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ule_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbz w0, LBB19_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ule_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cbz w0, LBB19_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ule_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ule_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #63 ; =0x3f
; CHECK-CMPBR-NEXT:    cbhs w8, w0, LBB20_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB20_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ule_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.ls LBB20_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB20_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ule_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ule_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbhs w8, w0, LBB21_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB21_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ule_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.ls LBB21_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB21_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ugt_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ugt_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbnz w0, LBB22_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB22_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ugt_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cbnz w0, LBB22_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB22_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ugt_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ugt_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbhs w0, w8, LBB23_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB23_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ugt_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.hs LBB23_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB23_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ugt_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ugt_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #65 ; =0x41
; CHECK-CMPBR-NEXT:    cbhs w0, w8, LBB24_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB24_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ugt_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #65
; CHECK-NO-CMPBR-NEXT:    b.hs LBB24_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB24_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @uge_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: uge_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhs w0, wzr, LBB25_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB25_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: uge_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #0
; CHECK-NO-CMPBR-NEXT:    b.hs LBB25_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB25_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @uge_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: uge_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi w0, #62, LBB26_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB26_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: uge_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.hs LBB26_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB26_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @uge_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: uge_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbhs w0, w8, LBB27_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB27_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: uge_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.hs LBB27_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB27_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @eq_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: eq_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbz w0, LBB28_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB28_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: eq_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cbz w0, LBB28_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB28_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @eq_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: eq_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-1 ; =0xffffffff
; CHECK-CMPBR-NEXT:    cbeq w0, w8, LBB29_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB29_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: eq_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #1
; CHECK-NO-CMPBR-NEXT:    b.eq LBB29_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB29_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @eq_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: eq_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbeq w0, #63, LBB30_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB30_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: eq_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.eq LBB30_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB30_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @eq_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: eq_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbeq w0, w8, LBB31_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB31_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: eq_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.eq LBB31_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB31_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ne_0_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ne_0_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbnz w0, LBB32_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB32_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ne_0_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cbnz w0, LBB32_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB32_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ne_m1_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ne_m1_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-1 ; =0xffffffff
; CHECK-CMPBR-NEXT:    cbne w0, w8, LBB33_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB33_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ne_m1_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #1
; CHECK-NO-CMPBR-NEXT:    b.ne LBB33_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB33_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ne_63_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ne_63_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne w0, #63, LBB34_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB34_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ne_63_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #63
; CHECK-NO-CMPBR-NEXT:    b.ne LBB34_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB34_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ne_64_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: ne_64_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbne w0, w8, LBB35_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB35_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ne_64_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #64
; CHECK-NO-CMPBR-NEXT:    b.ne LBB35_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB35_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_out_of_upper_bound_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbge_out_of_upper_bound_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #71 ; =0x47
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB36_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB36_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_out_of_upper_bound_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #71
; CHECK-NO-CMPBR-NEXT:    b.ge LBB36_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB36_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, 70
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_out_of_lower_bound_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbge_out_of_lower_bound_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-10 ; =0xfffffff6
; CHECK-CMPBR-NEXT:    cbge w0, w8, LBB37_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB37_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_out_of_lower_bound_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #10
; CHECK-NO-CMPBR-NEXT:    b.ge LBB37_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB37_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, -10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

; This should trigger a register swap.
define void @cble_out_of_lower_bound_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cble_out_of_lower_bound_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #-10 ; =0xfffffff6
; CHECK-CMPBR-NEXT:    cbhs w8, w0, LBB38_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB38_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cble_out_of_lower_bound_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn w0, #10
; CHECK-NO-CMPBR-NEXT:    b.ls LBB38_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB38_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, -10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @slt_m1_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: slt_m1_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov x8, #-2 ; =0xfffffffffffffffe
; CHECK-CMPBR-NEXT:    cbge x8, x0, LBB39_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB39_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: slt_m1_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn x0, #2
; CHECK-NO-CMPBR-NEXT:    b.le LBB39_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB39_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i64 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @sle_64_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: sle_64_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbge x8, x0, LBB40_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB40_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: sle_64_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #64
; CHECK-NO-CMPBR-NEXT:    b.le LBB40_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB40_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i64 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ult_63_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: ult_63_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo x0, #63, LBB41_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB41_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ult_63_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #62
; CHECK-NO-CMPBR-NEXT:    b.ls LBB41_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB41_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i64 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @uge_64_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: uge_64_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov w8, #64 ; =0x40
; CHECK-CMPBR-NEXT:    cbhs x0, x8, LBB42_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB42_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: uge_64_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #64
; CHECK-NO-CMPBR-NEXT:    b.hs LBB42_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB42_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i64 %a, 64
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @eq_m1_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: eq_m1_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    mov x8, #-1 ; =0xffffffffffffffff
; CHECK-CMPBR-NEXT:    cbeq x0, x8, LBB43_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB43_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: eq_m1_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmn x0, #1
; CHECK-NO-CMPBR-NEXT:    b.eq LBB43_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB43_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i64 %a, -1
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @ne_63_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: ne_63_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne x0, #63, LBB44_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB44_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: ne_63_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #63
; CHECK-NO-CMPBR-NEXT:    b.ne LBB44_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB44_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i64 %a, 63
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}
