macro(VSDpiAware_check tgt dpiaware_match_expect)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(HAVE_DPIAWARE_MATCH 0)
  set(IN_MANIFEST_SETTINGS 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<Manifest>")
      set(IN_MANIFEST_SETTINGS 1)
    elseif(line MATCHES "^ *</Manifest>")
      set(IN_MANIFEST_SETTINGS 0)
    elseif(IN_MANIFEST_SETTINGS AND (line MATCHES "^ *<EnableDpiAwareness>([^<>]+)</EnableDpiAwareness>"))
      set(dpiaware_match_actual "${CMAKE_MATCH_1}")
      if(NOT "${dpiaware_match_actual}" STREQUAL "${dpiaware_match_expect}")
        set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has <EnableDpiAwareness> '${dpiaware_match_actual}', not '${dpiaware_match_expect}'.")
        return()
      endif()
      set(HAVE_DPIAWARE_MATCH 1)
      break()
    endif()
  endforeach()

  if(NOT HAVE_DPIAWARE_MATCH AND NOT "${dpiaware_match_expect}" STREQUAL "")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <EnableDpiAwareness> property group.")
    return()
  endif()
endmacro()

VSDpiAware_check(DPIAWARE-default-C "")
VSDpiAware_check(DPIAWARE-default-CXX "")
VSDpiAware_check(DPIAWARE-TGT-PERMONITOR-C "PerMonitorHighDPIAware")
VSDpiAware_check(DPIAWARE-TGT-PERMONITOR-CXX "PerMonitorHighDPIAware")
VSDpiAware_check(DPIAWARE-TGT-ON-C "true")
VSDpiAware_check(DPIAWARE-TGT-ON-CXX "true")
VSDpiAware_check(DPIAWARE-TGT-OFF-C "false")
VSDpiAware_check(DPIAWARE-TGT-OFF-CXX "false")
