-- mod-version:3
local syntax = require 'core.syntax'

syntax.add {
	name = "Umka",
	files = { "%.um$" },
	comment = "//",
	block_comment = { "/*", "*/" },
	patterns = {
		{ pattern = "//.-\n",                          type = "comment"  },
		{ pattern = { "/%*", "%*/" },                  type = "comment"  },
		{ pattern = "0x%x+",                           type = "number"   },
		{ pattern = "%d+%.?%d*[Ee]%-?%d+",             type = "number"   },
		{ pattern = "%d+%.?%d*",                       type = "number"   },
		{ pattern = {'"', '"', '\\'},                  type = "string"   },
		{ pattern = {"'", "'", '\\'},                  type = "string"   },

		{ pattern = ":=",                              type = "operator" },
		{ pattern = "%.%.",                            type = "operator" },
		{ pattern = "[%^%+%-%*/%%&|~<>!=]",            type = "operator" },
		{ pattern = "[%a_][%w_]*()%*?()%s*%f[%(]",     type = {"function", "operator", "normal"} },
		{ pattern = "%u[%w_]*",                        type = "literal"  },
		{ pattern = "[%a_][%w_]*",                     type = "symbol"   },
	},
	symbols = {
		["break"]     = "keyword",
		["case"]      = "keyword",
		["const"]     = "keyword",
		["continue"]  = "keyword",
		["default"]   = "keyword",
		["else"]      = "keyword",
		["for"]       = "keyword",
		["fn"]        = "keyword",
		["import"]    = "keyword",
		["interface"] = "keyword",
		["if"]        = "keyword",
		["in"]        = "keyword",
		["map"]       = "keyword",
		["return"]    = "keyword",
		["str"]       = "keyword",
		["struct"]    = "keyword",
		["switch"]    = "keyword",
		["type"]      = "keyword",
		["var"]       = "keyword",
		["weak"]      = "keyword",

		-- types
		["void"]   = "keyword2",
		["int8"]   = "keyword2",
		["int16"]  = "keyword2",
		["int32"]  = "keyword2",
		["int"]    = "keyword2",
		["uint8"]  = "keyword2",
		["uint16"] = "keyword2",
		["uint32"] = "keyword2",
		["uint"]   = "keyword2",
		["real32"] = "keyword2",
		["real"]   = "keyword2",
		["bool"]   = "keyword2",
		["true"]   = "literal",
		["false"]  = "literal",
		["char"]   = "keyword2",
		["fiber"]  = "keyword2",
		["any"]    = "keyword2",
		["null"]   = "literal",
	},
}
