# tar

> Утиліта архівування.
> Часто поєднується з методом стиснення, таким як `gzip` або `bzip2`.
> Більше інформації: <https://www.gnu.org/software/tar/manual/tar.html>.

- Створити ([c]reate) архів і записати його у файл ([f]ile):

`tar cf {{шлях/до/цілі.tar}} {{шлях/до/file1 шлях/до/file2 ...}}`

- Створити ([c]reate) g[z]ipped архів і записати його у файл ([f]ile):

`tar czf {{шлях/до/цілі.tar.gz}} {{шлях/до/file1 шлях/до/file2 ...}}`

- Створити ([c]reate) g[z]ipped архів з каталогу, використовуючи відносні шляхи:

`tar czf {{шлях/до/цілі.tar.gz}} {{[-C|--directory]}} {{шлях/до/каталогу}} .`

- Розпакувати (e[x]tract) стиснутий файл ([f]ile) архіву у поточний каталог детально ([v]erbosely):

`tar xvf {{шлях/до/джерела.tar[.gz|.bz2|.xz]}}`

- Розпакувати (e[x]tract) стиснутий файл ([f]ile) архіву у певний каталог:

`tar xf {{шлях/до/джерела.tar[.gz|.bz2|.xz]}} {{[-C|--directory]}} {{шлях/до/каталогу}}`

- Створити ([c]reate) стиснутий архів і записати його у файл ([f]ile), використовуючи розширення файлу для автоматичного визначення програми стиснення:

`tar caf {{шлях/до/цілі.tar.xz}} {{шлях/до/file1 шлях/до/file2 ...}}`

- Вивести ([l]ist) перелік вмісту tar файлу ([f]ile) детально ([v]erbosely):

`tar tvf {{шлях/до/джерела.tar}}`

- Розпакувати (e[x]tract) файли, що відповідають шаблону, з файлу ([f]ile) архіву:

`tar xf {{шлях/до/джерела.tar}} --wildcards "{{*.html}}"`
