# docker

> Управление контейнерами и образами Docker.
> Некоторые подкоманды, такие как `run`, имеют собственную документацию по использованию.
> Больше информации: <https://docs.docker.com/reference/cli/docker/>.

- Список всех контейнеров Docker (запущенных и остановленных):

`docker ps {{[-a|--all]}}`

- Запустить контейнера из образа с заданным именем:

`docker run --name {{имя_контейнера}} {{имя_образа}}`

- Запустить или остановить существующий контейнер:

`docker {{start|stop}} {{имя_контейнера}}`

- Загрузить образ из репозитория Docker:

`docker pull {{имя_образа}}`

- Показать список уже загруженных образов:

`docker images`

- Запустить интерактивный ([i]) телетайп ([t]) с командной оболочкой Bourne shell (sh) внутри запущенного контейнера:

`docker exec {{[-it|--interactive --tty]}} {{имя_контейнера}} {{sh}}`

- Удалить остановленный контейнер:

`docker rm {{имя_контейнера}}`

- Получить и следить за логами контейнера:

`docker logs {{[-f|--follow]}} {{имя_контейнера}}`
