# git grep

> 저장소의 히스토리에서 파일 내의 문자열을 찾습니다.
> 일반 `grep`과 같은 많은 플래그를 수용합니다.
> 더 많은 정보: <https://git-scm.com/docs/git-grep>.

- 추적된 파일에서 문자열 검색:

`git grep {{검색_문자열}}`

- 추적된 파일 중 일치하는 패턴의 파일에서 문자열 검색:

`git grep {{검색_문자열}} -- {{파일_글로브_패턴}}`

- 서브모듈을 포함하여 추적된 파일에서 문자열 검색:

`git grep --recurse-submodules {{검색_문자열}}`

- 특정 히스토리 지점에서 문자열 검색:

`git grep {{검색_문자열}} {{HEAD~2}}`

- 모든 브랜치에서 문자열 검색:

`git grep {{검색_문자열}} $(git rev-list --all)`
