#include "asm/x86/init.hpp"

#include "LIEF/asm/x86/opcodes.hpp"

namespace LIEF::assembly::x86::py {
template<>
void create<LIEF::assembly::x86::OPCODE>(nb::module_& m) {
  nb::enum_<LIEF::assembly::x86::OPCODE> opcodes(m, "OPCODE");
  opcodes.value("PHI", LIEF::assembly::x86::OPCODE::PHI)
  .value("INLINEASM", LIEF::assembly::x86::OPCODE::INLINEASM)
  .value("INLINEASM_BR", LIEF::assembly::x86::OPCODE::INLINEASM_BR)
  .value("CFI_INSTRUCTION", LIEF::assembly::x86::OPCODE::CFI_INSTRUCTION)
  .value("EH_LABEL", LIEF::assembly::x86::OPCODE::EH_LABEL)
  .value("GC_LABEL", LIEF::assembly::x86::OPCODE::GC_LABEL)
  .value("ANNOTATION_LABEL", LIEF::assembly::x86::OPCODE::ANNOTATION_LABEL)
  .value("KILL", LIEF::assembly::x86::OPCODE::KILL)
  .value("EXTRACT_SUBREG", LIEF::assembly::x86::OPCODE::EXTRACT_SUBREG)
  .value("INSERT_SUBREG", LIEF::assembly::x86::OPCODE::INSERT_SUBREG)
  .value("IMPLICIT_DEF", LIEF::assembly::x86::OPCODE::IMPLICIT_DEF)
  .value("INIT_UNDEF", LIEF::assembly::x86::OPCODE::INIT_UNDEF)
  .value("SUBREG_TO_REG", LIEF::assembly::x86::OPCODE::SUBREG_TO_REG)
  .value("COPY_TO_REGCLASS", LIEF::assembly::x86::OPCODE::COPY_TO_REGCLASS)
  .value("DBG_VALUE", LIEF::assembly::x86::OPCODE::DBG_VALUE)
  .value("DBG_VALUE_LIST", LIEF::assembly::x86::OPCODE::DBG_VALUE_LIST)
  .value("DBG_INSTR_REF", LIEF::assembly::x86::OPCODE::DBG_INSTR_REF)
  .value("DBG_PHI", LIEF::assembly::x86::OPCODE::DBG_PHI)
  .value("DBG_LABEL", LIEF::assembly::x86::OPCODE::DBG_LABEL)
  .value("REG_SEQUENCE", LIEF::assembly::x86::OPCODE::REG_SEQUENCE)
  .value("COPY", LIEF::assembly::x86::OPCODE::COPY)
  .value("BUNDLE", LIEF::assembly::x86::OPCODE::BUNDLE)
  .value("LIFETIME_START", LIEF::assembly::x86::OPCODE::LIFETIME_START)
  .value("LIFETIME_END", LIEF::assembly::x86::OPCODE::LIFETIME_END)
  .value("PSEUDO_PROBE", LIEF::assembly::x86::OPCODE::PSEUDO_PROBE)
  .value("ARITH_FENCE", LIEF::assembly::x86::OPCODE::ARITH_FENCE)
  .value("STACKMAP", LIEF::assembly::x86::OPCODE::STACKMAP)
  .value("FENTRY_CALL", LIEF::assembly::x86::OPCODE::FENTRY_CALL)
  .value("PATCHPOINT", LIEF::assembly::x86::OPCODE::PATCHPOINT)
  .value("LOAD_STACK_GUARD", LIEF::assembly::x86::OPCODE::LOAD_STACK_GUARD)
  .value("PREALLOCATED_SETUP", LIEF::assembly::x86::OPCODE::PREALLOCATED_SETUP)
  .value("PREALLOCATED_ARG", LIEF::assembly::x86::OPCODE::PREALLOCATED_ARG)
  .value("STATEPOINT", LIEF::assembly::x86::OPCODE::STATEPOINT)
  .value("LOCAL_ESCAPE", LIEF::assembly::x86::OPCODE::LOCAL_ESCAPE)
  .value("FAULTING_OP", LIEF::assembly::x86::OPCODE::FAULTING_OP)
  .value("PATCHABLE_OP", LIEF::assembly::x86::OPCODE::PATCHABLE_OP)
  .value("PATCHABLE_FUNCTION_ENTER", LIEF::assembly::x86::OPCODE::PATCHABLE_FUNCTION_ENTER)
  .value("PATCHABLE_RET", LIEF::assembly::x86::OPCODE::PATCHABLE_RET)
  .value("PATCHABLE_FUNCTION_EXIT", LIEF::assembly::x86::OPCODE::PATCHABLE_FUNCTION_EXIT)
  .value("PATCHABLE_TAIL_CALL", LIEF::assembly::x86::OPCODE::PATCHABLE_TAIL_CALL)
  .value("PATCHABLE_EVENT_CALL", LIEF::assembly::x86::OPCODE::PATCHABLE_EVENT_CALL)
  .value("PATCHABLE_TYPED_EVENT_CALL", LIEF::assembly::x86::OPCODE::PATCHABLE_TYPED_EVENT_CALL)
  .value("ICALL_BRANCH_FUNNEL", LIEF::assembly::x86::OPCODE::ICALL_BRANCH_FUNNEL)
  .value("FAKE_USE", LIEF::assembly::x86::OPCODE::FAKE_USE)
  .value("MEMBARRIER", LIEF::assembly::x86::OPCODE::MEMBARRIER)
  .value("JUMP_TABLE_DEBUG_INFO", LIEF::assembly::x86::OPCODE::JUMP_TABLE_DEBUG_INFO)
  .value("CONVERGENCECTRL_ENTRY", LIEF::assembly::x86::OPCODE::CONVERGENCECTRL_ENTRY)
  .value("CONVERGENCECTRL_ANCHOR", LIEF::assembly::x86::OPCODE::CONVERGENCECTRL_ANCHOR)
  .value("CONVERGENCECTRL_LOOP", LIEF::assembly::x86::OPCODE::CONVERGENCECTRL_LOOP)
  .value("CONVERGENCECTRL_GLUE", LIEF::assembly::x86::OPCODE::CONVERGENCECTRL_GLUE)
  .value("G_ASSERT_SEXT", LIEF::assembly::x86::OPCODE::G_ASSERT_SEXT)
  .value("G_ASSERT_ZEXT", LIEF::assembly::x86::OPCODE::G_ASSERT_ZEXT)
  .value("G_ASSERT_ALIGN", LIEF::assembly::x86::OPCODE::G_ASSERT_ALIGN)
  .value("G_ADD", LIEF::assembly::x86::OPCODE::G_ADD)
  .value("G_SUB", LIEF::assembly::x86::OPCODE::G_SUB)
  .value("G_MUL", LIEF::assembly::x86::OPCODE::G_MUL)
  .value("G_SDIV", LIEF::assembly::x86::OPCODE::G_SDIV)
  .value("G_UDIV", LIEF::assembly::x86::OPCODE::G_UDIV)
  .value("G_SREM", LIEF::assembly::x86::OPCODE::G_SREM)
  .value("G_UREM", LIEF::assembly::x86::OPCODE::G_UREM)
  .value("G_SDIVREM", LIEF::assembly::x86::OPCODE::G_SDIVREM)
  .value("G_UDIVREM", LIEF::assembly::x86::OPCODE::G_UDIVREM)
  .value("G_AND", LIEF::assembly::x86::OPCODE::G_AND)
  .value("G_OR", LIEF::assembly::x86::OPCODE::G_OR)
  .value("G_XOR", LIEF::assembly::x86::OPCODE::G_XOR)
  .value("G_ABDS", LIEF::assembly::x86::OPCODE::G_ABDS)
  .value("G_ABDU", LIEF::assembly::x86::OPCODE::G_ABDU)
  .value("G_IMPLICIT_DEF", LIEF::assembly::x86::OPCODE::G_IMPLICIT_DEF)
  .value("G_PHI", LIEF::assembly::x86::OPCODE::G_PHI)
  .value("G_FRAME_INDEX", LIEF::assembly::x86::OPCODE::G_FRAME_INDEX)
  .value("G_GLOBAL_VALUE", LIEF::assembly::x86::OPCODE::G_GLOBAL_VALUE)
  .value("G_PTRAUTH_GLOBAL_VALUE", LIEF::assembly::x86::OPCODE::G_PTRAUTH_GLOBAL_VALUE)
  .value("G_CONSTANT_POOL", LIEF::assembly::x86::OPCODE::G_CONSTANT_POOL)
  .value("G_EXTRACT", LIEF::assembly::x86::OPCODE::G_EXTRACT)
  .value("G_UNMERGE_VALUES", LIEF::assembly::x86::OPCODE::G_UNMERGE_VALUES)
  .value("G_INSERT", LIEF::assembly::x86::OPCODE::G_INSERT)
  .value("G_MERGE_VALUES", LIEF::assembly::x86::OPCODE::G_MERGE_VALUES)
  .value("G_BUILD_VECTOR", LIEF::assembly::x86::OPCODE::G_BUILD_VECTOR)
  .value("G_BUILD_VECTOR_TRUNC", LIEF::assembly::x86::OPCODE::G_BUILD_VECTOR_TRUNC)
  .value("G_CONCAT_VECTORS", LIEF::assembly::x86::OPCODE::G_CONCAT_VECTORS)
  .value("G_PTRTOINT", LIEF::assembly::x86::OPCODE::G_PTRTOINT)
  .value("G_INTTOPTR", LIEF::assembly::x86::OPCODE::G_INTTOPTR)
  .value("G_BITCAST", LIEF::assembly::x86::OPCODE::G_BITCAST)
  .value("G_FREEZE", LIEF::assembly::x86::OPCODE::G_FREEZE)
  .value("G_CONSTANT_FOLD_BARRIER", LIEF::assembly::x86::OPCODE::G_CONSTANT_FOLD_BARRIER)
  .value("G_INTRINSIC_FPTRUNC_ROUND", LIEF::assembly::x86::OPCODE::G_INTRINSIC_FPTRUNC_ROUND)
  .value("G_INTRINSIC_TRUNC", LIEF::assembly::x86::OPCODE::G_INTRINSIC_TRUNC)
  .value("G_INTRINSIC_ROUND", LIEF::assembly::x86::OPCODE::G_INTRINSIC_ROUND)
  .value("G_INTRINSIC_LRINT", LIEF::assembly::x86::OPCODE::G_INTRINSIC_LRINT)
  .value("G_INTRINSIC_LLRINT", LIEF::assembly::x86::OPCODE::G_INTRINSIC_LLRINT)
  .value("G_INTRINSIC_ROUNDEVEN", LIEF::assembly::x86::OPCODE::G_INTRINSIC_ROUNDEVEN)
  .value("G_READCYCLECOUNTER", LIEF::assembly::x86::OPCODE::G_READCYCLECOUNTER)
  .value("G_READSTEADYCOUNTER", LIEF::assembly::x86::OPCODE::G_READSTEADYCOUNTER)
  .value("G_LOAD", LIEF::assembly::x86::OPCODE::G_LOAD)
  .value("G_SEXTLOAD", LIEF::assembly::x86::OPCODE::G_SEXTLOAD)
  .value("G_ZEXTLOAD", LIEF::assembly::x86::OPCODE::G_ZEXTLOAD)
  .value("G_INDEXED_LOAD", LIEF::assembly::x86::OPCODE::G_INDEXED_LOAD)
  .value("G_INDEXED_SEXTLOAD", LIEF::assembly::x86::OPCODE::G_INDEXED_SEXTLOAD)
  .value("G_INDEXED_ZEXTLOAD", LIEF::assembly::x86::OPCODE::G_INDEXED_ZEXTLOAD)
  .value("G_STORE", LIEF::assembly::x86::OPCODE::G_STORE)
  .value("G_INDEXED_STORE", LIEF::assembly::x86::OPCODE::G_INDEXED_STORE)
  .value("G_ATOMIC_CMPXCHG_WITH_SUCCESS", LIEF::assembly::x86::OPCODE::G_ATOMIC_CMPXCHG_WITH_SUCCESS)
  .value("G_ATOMIC_CMPXCHG", LIEF::assembly::x86::OPCODE::G_ATOMIC_CMPXCHG)
  .value("G_ATOMICRMW_XCHG", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_XCHG)
  .value("G_ATOMICRMW_ADD", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_ADD)
  .value("G_ATOMICRMW_SUB", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_SUB)
  .value("G_ATOMICRMW_AND", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_AND)
  .value("G_ATOMICRMW_NAND", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_NAND)
  .value("G_ATOMICRMW_OR", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_OR)
  .value("G_ATOMICRMW_XOR", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_XOR)
  .value("G_ATOMICRMW_MAX", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_MAX)
  .value("G_ATOMICRMW_MIN", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_MIN)
  .value("G_ATOMICRMW_UMAX", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_UMAX)
  .value("G_ATOMICRMW_UMIN", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_UMIN)
  .value("G_ATOMICRMW_FADD", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FADD)
  .value("G_ATOMICRMW_FSUB", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FSUB)
  .value("G_ATOMICRMW_FMAX", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FMAX)
  .value("G_ATOMICRMW_FMIN", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FMIN)
  .value("G_ATOMICRMW_FMAXIMUM", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FMAXIMUM)
  .value("G_ATOMICRMW_FMINIMUM", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_FMINIMUM)
  .value("G_ATOMICRMW_UINC_WRAP", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_UINC_WRAP)
  .value("G_ATOMICRMW_UDEC_WRAP", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_UDEC_WRAP)
  .value("G_ATOMICRMW_USUB_COND", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_USUB_COND)
  .value("G_ATOMICRMW_USUB_SAT", LIEF::assembly::x86::OPCODE::G_ATOMICRMW_USUB_SAT)
  .value("G_FENCE", LIEF::assembly::x86::OPCODE::G_FENCE)
  .value("G_PREFETCH", LIEF::assembly::x86::OPCODE::G_PREFETCH)
  .value("G_BRCOND", LIEF::assembly::x86::OPCODE::G_BRCOND)
  .value("G_BRINDIRECT", LIEF::assembly::x86::OPCODE::G_BRINDIRECT)
  .value("G_INVOKE_REGION_START", LIEF::assembly::x86::OPCODE::G_INVOKE_REGION_START)
  .value("G_INTRINSIC", LIEF::assembly::x86::OPCODE::G_INTRINSIC)
  .value("G_INTRINSIC_W_SIDE_EFFECTS", LIEF::assembly::x86::OPCODE::G_INTRINSIC_W_SIDE_EFFECTS)
  .value("G_INTRINSIC_CONVERGENT", LIEF::assembly::x86::OPCODE::G_INTRINSIC_CONVERGENT)
  .value("G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS", LIEF::assembly::x86::OPCODE::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS)
  .value("G_ANYEXT", LIEF::assembly::x86::OPCODE::G_ANYEXT)
  .value("G_TRUNC", LIEF::assembly::x86::OPCODE::G_TRUNC)
  .value("G_TRUNC_SSAT_S", LIEF::assembly::x86::OPCODE::G_TRUNC_SSAT_S)
  .value("G_TRUNC_SSAT_U", LIEF::assembly::x86::OPCODE::G_TRUNC_SSAT_U)
  .value("G_TRUNC_USAT_U", LIEF::assembly::x86::OPCODE::G_TRUNC_USAT_U)
  .value("G_CONSTANT", LIEF::assembly::x86::OPCODE::G_CONSTANT)
  .value("G_FCONSTANT", LIEF::assembly::x86::OPCODE::G_FCONSTANT)
  .value("G_VASTART", LIEF::assembly::x86::OPCODE::G_VASTART)
  .value("G_VAARG", LIEF::assembly::x86::OPCODE::G_VAARG)
  .value("G_SEXT", LIEF::assembly::x86::OPCODE::G_SEXT)
  .value("G_SEXT_INREG", LIEF::assembly::x86::OPCODE::G_SEXT_INREG)
  .value("G_ZEXT", LIEF::assembly::x86::OPCODE::G_ZEXT)
  .value("G_SHL", LIEF::assembly::x86::OPCODE::G_SHL)
  .value("G_LSHR", LIEF::assembly::x86::OPCODE::G_LSHR)
  .value("G_ASHR", LIEF::assembly::x86::OPCODE::G_ASHR)
  .value("G_FSHL", LIEF::assembly::x86::OPCODE::G_FSHL)
  .value("G_FSHR", LIEF::assembly::x86::OPCODE::G_FSHR)
  .value("G_ROTR", LIEF::assembly::x86::OPCODE::G_ROTR)
  .value("G_ROTL", LIEF::assembly::x86::OPCODE::G_ROTL)
  .value("G_ICMP", LIEF::assembly::x86::OPCODE::G_ICMP)
  .value("G_FCMP", LIEF::assembly::x86::OPCODE::G_FCMP)
  .value("G_SCMP", LIEF::assembly::x86::OPCODE::G_SCMP)
  .value("G_UCMP", LIEF::assembly::x86::OPCODE::G_UCMP)
  .value("G_SELECT", LIEF::assembly::x86::OPCODE::G_SELECT)
  .value("G_UADDO", LIEF::assembly::x86::OPCODE::G_UADDO)
  .value("G_UADDE", LIEF::assembly::x86::OPCODE::G_UADDE)
  .value("G_USUBO", LIEF::assembly::x86::OPCODE::G_USUBO)
  .value("G_USUBE", LIEF::assembly::x86::OPCODE::G_USUBE)
  .value("G_SADDO", LIEF::assembly::x86::OPCODE::G_SADDO)
  .value("G_SADDE", LIEF::assembly::x86::OPCODE::G_SADDE)
  .value("G_SSUBO", LIEF::assembly::x86::OPCODE::G_SSUBO)
  .value("G_SSUBE", LIEF::assembly::x86::OPCODE::G_SSUBE)
  .value("G_UMULO", LIEF::assembly::x86::OPCODE::G_UMULO)
  .value("G_SMULO", LIEF::assembly::x86::OPCODE::G_SMULO)
  .value("G_UMULH", LIEF::assembly::x86::OPCODE::G_UMULH)
  .value("G_SMULH", LIEF::assembly::x86::OPCODE::G_SMULH)
  .value("G_UADDSAT", LIEF::assembly::x86::OPCODE::G_UADDSAT)
  .value("G_SADDSAT", LIEF::assembly::x86::OPCODE::G_SADDSAT)
  .value("G_USUBSAT", LIEF::assembly::x86::OPCODE::G_USUBSAT)
  .value("G_SSUBSAT", LIEF::assembly::x86::OPCODE::G_SSUBSAT)
  .value("G_USHLSAT", LIEF::assembly::x86::OPCODE::G_USHLSAT)
  .value("G_SSHLSAT", LIEF::assembly::x86::OPCODE::G_SSHLSAT)
  .value("G_SMULFIX", LIEF::assembly::x86::OPCODE::G_SMULFIX)
  .value("G_UMULFIX", LIEF::assembly::x86::OPCODE::G_UMULFIX)
  .value("G_SMULFIXSAT", LIEF::assembly::x86::OPCODE::G_SMULFIXSAT)
  .value("G_UMULFIXSAT", LIEF::assembly::x86::OPCODE::G_UMULFIXSAT)
  .value("G_SDIVFIX", LIEF::assembly::x86::OPCODE::G_SDIVFIX)
  .value("G_UDIVFIX", LIEF::assembly::x86::OPCODE::G_UDIVFIX)
  .value("G_SDIVFIXSAT", LIEF::assembly::x86::OPCODE::G_SDIVFIXSAT)
  .value("G_UDIVFIXSAT", LIEF::assembly::x86::OPCODE::G_UDIVFIXSAT)
  .value("G_FADD", LIEF::assembly::x86::OPCODE::G_FADD)
  .value("G_FSUB", LIEF::assembly::x86::OPCODE::G_FSUB)
  .value("G_FMUL", LIEF::assembly::x86::OPCODE::G_FMUL)
  .value("G_FMA", LIEF::assembly::x86::OPCODE::G_FMA)
  .value("G_FMAD", LIEF::assembly::x86::OPCODE::G_FMAD)
  .value("G_FDIV", LIEF::assembly::x86::OPCODE::G_FDIV)
  .value("G_FREM", LIEF::assembly::x86::OPCODE::G_FREM)
  .value("G_FPOW", LIEF::assembly::x86::OPCODE::G_FPOW)
  .value("G_FPOWI", LIEF::assembly::x86::OPCODE::G_FPOWI)
  .value("G_FEXP", LIEF::assembly::x86::OPCODE::G_FEXP)
  .value("G_FEXP2", LIEF::assembly::x86::OPCODE::G_FEXP2)
  .value("G_FEXP10", LIEF::assembly::x86::OPCODE::G_FEXP10)
  .value("G_FLOG", LIEF::assembly::x86::OPCODE::G_FLOG)
  .value("G_FLOG2", LIEF::assembly::x86::OPCODE::G_FLOG2)
  .value("G_FLOG10", LIEF::assembly::x86::OPCODE::G_FLOG10)
  .value("G_FLDEXP", LIEF::assembly::x86::OPCODE::G_FLDEXP)
  .value("G_FFREXP", LIEF::assembly::x86::OPCODE::G_FFREXP)
  .value("G_FNEG", LIEF::assembly::x86::OPCODE::G_FNEG)
  .value("G_FPEXT", LIEF::assembly::x86::OPCODE::G_FPEXT)
  .value("G_FPTRUNC", LIEF::assembly::x86::OPCODE::G_FPTRUNC)
  .value("G_FPTOSI", LIEF::assembly::x86::OPCODE::G_FPTOSI)
  .value("G_FPTOUI", LIEF::assembly::x86::OPCODE::G_FPTOUI)
  .value("G_SITOFP", LIEF::assembly::x86::OPCODE::G_SITOFP)
  .value("G_UITOFP", LIEF::assembly::x86::OPCODE::G_UITOFP)
  .value("G_FPTOSI_SAT", LIEF::assembly::x86::OPCODE::G_FPTOSI_SAT)
  .value("G_FPTOUI_SAT", LIEF::assembly::x86::OPCODE::G_FPTOUI_SAT)
  .value("G_FABS", LIEF::assembly::x86::OPCODE::G_FABS)
  .value("G_FCOPYSIGN", LIEF::assembly::x86::OPCODE::G_FCOPYSIGN)
  .value("G_IS_FPCLASS", LIEF::assembly::x86::OPCODE::G_IS_FPCLASS)
  .value("G_FCANONICALIZE", LIEF::assembly::x86::OPCODE::G_FCANONICALIZE)
  .value("G_FMINNUM", LIEF::assembly::x86::OPCODE::G_FMINNUM)
  .value("G_FMAXNUM", LIEF::assembly::x86::OPCODE::G_FMAXNUM)
  .value("G_FMINNUM_IEEE", LIEF::assembly::x86::OPCODE::G_FMINNUM_IEEE)
  .value("G_FMAXNUM_IEEE", LIEF::assembly::x86::OPCODE::G_FMAXNUM_IEEE)
  .value("G_FMINIMUM", LIEF::assembly::x86::OPCODE::G_FMINIMUM)
  .value("G_FMAXIMUM", LIEF::assembly::x86::OPCODE::G_FMAXIMUM)
  .value("G_FMINIMUMNUM", LIEF::assembly::x86::OPCODE::G_FMINIMUMNUM)
  .value("G_FMAXIMUMNUM", LIEF::assembly::x86::OPCODE::G_FMAXIMUMNUM)
  .value("G_GET_FPENV", LIEF::assembly::x86::OPCODE::G_GET_FPENV)
  .value("G_SET_FPENV", LIEF::assembly::x86::OPCODE::G_SET_FPENV)
  .value("G_RESET_FPENV", LIEF::assembly::x86::OPCODE::G_RESET_FPENV)
  .value("G_GET_FPMODE", LIEF::assembly::x86::OPCODE::G_GET_FPMODE)
  .value("G_SET_FPMODE", LIEF::assembly::x86::OPCODE::G_SET_FPMODE)
  .value("G_RESET_FPMODE", LIEF::assembly::x86::OPCODE::G_RESET_FPMODE)
  .value("G_GET_ROUNDING", LIEF::assembly::x86::OPCODE::G_GET_ROUNDING)
  .value("G_PTR_ADD", LIEF::assembly::x86::OPCODE::G_PTR_ADD)
  .value("G_PTRMASK", LIEF::assembly::x86::OPCODE::G_PTRMASK)
  .value("G_SMIN", LIEF::assembly::x86::OPCODE::G_SMIN)
  .value("G_SMAX", LIEF::assembly::x86::OPCODE::G_SMAX)
  .value("G_UMIN", LIEF::assembly::x86::OPCODE::G_UMIN)
  .value("G_UMAX", LIEF::assembly::x86::OPCODE::G_UMAX)
  .value("G_ABS", LIEF::assembly::x86::OPCODE::G_ABS)
  .value("G_LROUND", LIEF::assembly::x86::OPCODE::G_LROUND)
  .value("G_LLROUND", LIEF::assembly::x86::OPCODE::G_LLROUND)
  .value("G_BR", LIEF::assembly::x86::OPCODE::G_BR)
  .value("G_BRJT", LIEF::assembly::x86::OPCODE::G_BRJT)
  .value("G_VSCALE", LIEF::assembly::x86::OPCODE::G_VSCALE)
  .value("G_INSERT_SUBVECTOR", LIEF::assembly::x86::OPCODE::G_INSERT_SUBVECTOR)
  .value("G_EXTRACT_SUBVECTOR", LIEF::assembly::x86::OPCODE::G_EXTRACT_SUBVECTOR)
  .value("G_INSERT_VECTOR_ELT", LIEF::assembly::x86::OPCODE::G_INSERT_VECTOR_ELT)
  .value("G_EXTRACT_VECTOR_ELT", LIEF::assembly::x86::OPCODE::G_EXTRACT_VECTOR_ELT)
  .value("G_SHUFFLE_VECTOR", LIEF::assembly::x86::OPCODE::G_SHUFFLE_VECTOR)
  .value("G_SPLAT_VECTOR", LIEF::assembly::x86::OPCODE::G_SPLAT_VECTOR)
  .value("G_STEP_VECTOR", LIEF::assembly::x86::OPCODE::G_STEP_VECTOR)
  .value("G_VECTOR_COMPRESS", LIEF::assembly::x86::OPCODE::G_VECTOR_COMPRESS)
  .value("G_CTTZ", LIEF::assembly::x86::OPCODE::G_CTTZ)
  .value("G_CTTZ_ZERO_UNDEF", LIEF::assembly::x86::OPCODE::G_CTTZ_ZERO_UNDEF)
  .value("G_CTLZ", LIEF::assembly::x86::OPCODE::G_CTLZ)
  .value("G_CTLZ_ZERO_UNDEF", LIEF::assembly::x86::OPCODE::G_CTLZ_ZERO_UNDEF)
  .value("G_CTPOP", LIEF::assembly::x86::OPCODE::G_CTPOP)
  .value("G_BSWAP", LIEF::assembly::x86::OPCODE::G_BSWAP)
  .value("G_BITREVERSE", LIEF::assembly::x86::OPCODE::G_BITREVERSE)
  .value("G_FCEIL", LIEF::assembly::x86::OPCODE::G_FCEIL)
  .value("G_FCOS", LIEF::assembly::x86::OPCODE::G_FCOS)
  .value("G_FSIN", LIEF::assembly::x86::OPCODE::G_FSIN)
  .value("G_FSINCOS", LIEF::assembly::x86::OPCODE::G_FSINCOS)
  .value("G_FTAN", LIEF::assembly::x86::OPCODE::G_FTAN)
  .value("G_FACOS", LIEF::assembly::x86::OPCODE::G_FACOS)
  .value("G_FASIN", LIEF::assembly::x86::OPCODE::G_FASIN)
  .value("G_FATAN", LIEF::assembly::x86::OPCODE::G_FATAN)
  .value("G_FATAN2", LIEF::assembly::x86::OPCODE::G_FATAN2)
  .value("G_FCOSH", LIEF::assembly::x86::OPCODE::G_FCOSH)
  .value("G_FSINH", LIEF::assembly::x86::OPCODE::G_FSINH)
  .value("G_FTANH", LIEF::assembly::x86::OPCODE::G_FTANH)
  .value("G_FSQRT", LIEF::assembly::x86::OPCODE::G_FSQRT)
  .value("G_FFLOOR", LIEF::assembly::x86::OPCODE::G_FFLOOR)
  .value("G_FRINT", LIEF::assembly::x86::OPCODE::G_FRINT)
  .value("G_FNEARBYINT", LIEF::assembly::x86::OPCODE::G_FNEARBYINT)
  .value("G_ADDRSPACE_CAST", LIEF::assembly::x86::OPCODE::G_ADDRSPACE_CAST)
  .value("G_BLOCK_ADDR", LIEF::assembly::x86::OPCODE::G_BLOCK_ADDR)
  .value("G_JUMP_TABLE", LIEF::assembly::x86::OPCODE::G_JUMP_TABLE)
  .value("G_DYN_STACKALLOC", LIEF::assembly::x86::OPCODE::G_DYN_STACKALLOC)
  .value("G_STACKSAVE", LIEF::assembly::x86::OPCODE::G_STACKSAVE)
  .value("G_STACKRESTORE", LIEF::assembly::x86::OPCODE::G_STACKRESTORE)
  .value("G_STRICT_FADD", LIEF::assembly::x86::OPCODE::G_STRICT_FADD)
  .value("G_STRICT_FSUB", LIEF::assembly::x86::OPCODE::G_STRICT_FSUB)
  .value("G_STRICT_FMUL", LIEF::assembly::x86::OPCODE::G_STRICT_FMUL)
  .value("G_STRICT_FDIV", LIEF::assembly::x86::OPCODE::G_STRICT_FDIV)
  .value("G_STRICT_FREM", LIEF::assembly::x86::OPCODE::G_STRICT_FREM)
  .value("G_STRICT_FMA", LIEF::assembly::x86::OPCODE::G_STRICT_FMA)
  .value("G_STRICT_FSQRT", LIEF::assembly::x86::OPCODE::G_STRICT_FSQRT)
  .value("G_STRICT_FLDEXP", LIEF::assembly::x86::OPCODE::G_STRICT_FLDEXP)
  .value("G_READ_REGISTER", LIEF::assembly::x86::OPCODE::G_READ_REGISTER)
  .value("G_WRITE_REGISTER", LIEF::assembly::x86::OPCODE::G_WRITE_REGISTER)
  .value("G_MEMCPY", LIEF::assembly::x86::OPCODE::G_MEMCPY)
  .value("G_MEMCPY_INLINE", LIEF::assembly::x86::OPCODE::G_MEMCPY_INLINE)
  .value("G_MEMMOVE", LIEF::assembly::x86::OPCODE::G_MEMMOVE)
  .value("G_MEMSET", LIEF::assembly::x86::OPCODE::G_MEMSET)
  .value("G_BZERO", LIEF::assembly::x86::OPCODE::G_BZERO)
  .value("G_TRAP", LIEF::assembly::x86::OPCODE::G_TRAP)
  .value("G_DEBUGTRAP", LIEF::assembly::x86::OPCODE::G_DEBUGTRAP)
  .value("G_UBSANTRAP", LIEF::assembly::x86::OPCODE::G_UBSANTRAP)
  .value("G_VECREDUCE_SEQ_FADD", LIEF::assembly::x86::OPCODE::G_VECREDUCE_SEQ_FADD)
  .value("G_VECREDUCE_SEQ_FMUL", LIEF::assembly::x86::OPCODE::G_VECREDUCE_SEQ_FMUL)
  .value("G_VECREDUCE_FADD", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FADD)
  .value("G_VECREDUCE_FMUL", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FMUL)
  .value("G_VECREDUCE_FMAX", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FMAX);
  opcodes.value("G_VECREDUCE_FMIN", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FMIN)
  .value("G_VECREDUCE_FMAXIMUM", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FMAXIMUM)
  .value("G_VECREDUCE_FMINIMUM", LIEF::assembly::x86::OPCODE::G_VECREDUCE_FMINIMUM)
  .value("G_VECREDUCE_ADD", LIEF::assembly::x86::OPCODE::G_VECREDUCE_ADD)
  .value("G_VECREDUCE_MUL", LIEF::assembly::x86::OPCODE::G_VECREDUCE_MUL)
  .value("G_VECREDUCE_AND", LIEF::assembly::x86::OPCODE::G_VECREDUCE_AND)
  .value("G_VECREDUCE_OR", LIEF::assembly::x86::OPCODE::G_VECREDUCE_OR)
  .value("G_VECREDUCE_XOR", LIEF::assembly::x86::OPCODE::G_VECREDUCE_XOR)
  .value("G_VECREDUCE_SMAX", LIEF::assembly::x86::OPCODE::G_VECREDUCE_SMAX)
  .value("G_VECREDUCE_SMIN", LIEF::assembly::x86::OPCODE::G_VECREDUCE_SMIN)
  .value("G_VECREDUCE_UMAX", LIEF::assembly::x86::OPCODE::G_VECREDUCE_UMAX)
  .value("G_VECREDUCE_UMIN", LIEF::assembly::x86::OPCODE::G_VECREDUCE_UMIN)
  .value("G_SBFX", LIEF::assembly::x86::OPCODE::G_SBFX)
  .value("G_UBFX", LIEF::assembly::x86::OPCODE::G_UBFX)
  .value("ADD16ri_DB", LIEF::assembly::x86::OPCODE::ADD16ri_DB)
  .value("ADD16rr_DB", LIEF::assembly::x86::OPCODE::ADD16rr_DB)
  .value("ADD32ri_DB", LIEF::assembly::x86::OPCODE::ADD32ri_DB)
  .value("ADD32rr_DB", LIEF::assembly::x86::OPCODE::ADD32rr_DB)
  .value("ADD64ri32_DB", LIEF::assembly::x86::OPCODE::ADD64ri32_DB)
  .value("ADD64rr_DB", LIEF::assembly::x86::OPCODE::ADD64rr_DB)
  .value("ADD8ri_DB", LIEF::assembly::x86::OPCODE::ADD8ri_DB)
  .value("ADD8rr_DB", LIEF::assembly::x86::OPCODE::ADD8rr_DB)
  .value("AVX1_SETALLONES", LIEF::assembly::x86::OPCODE::AVX1_SETALLONES)
  .value("AVX2_SETALLONES", LIEF::assembly::x86::OPCODE::AVX2_SETALLONES)
  .value("AVX512_128_SET0", LIEF::assembly::x86::OPCODE::AVX512_128_SET0)
  .value("AVX512_256_SET0", LIEF::assembly::x86::OPCODE::AVX512_256_SET0)
  .value("AVX512_512_SET0", LIEF::assembly::x86::OPCODE::AVX512_512_SET0)
  .value("AVX512_512_SETALLONES", LIEF::assembly::x86::OPCODE::AVX512_512_SETALLONES)
  .value("AVX512_512_SEXT_MASK_32", LIEF::assembly::x86::OPCODE::AVX512_512_SEXT_MASK_32)
  .value("AVX512_512_SEXT_MASK_64", LIEF::assembly::x86::OPCODE::AVX512_512_SEXT_MASK_64)
  .value("AVX512_FsFLD0F128", LIEF::assembly::x86::OPCODE::AVX512_FsFLD0F128)
  .value("AVX512_FsFLD0SD", LIEF::assembly::x86::OPCODE::AVX512_FsFLD0SD)
  .value("AVX512_FsFLD0SH", LIEF::assembly::x86::OPCODE::AVX512_FsFLD0SH)
  .value("AVX512_FsFLD0SS", LIEF::assembly::x86::OPCODE::AVX512_FsFLD0SS)
  .value("AVX_SET0", LIEF::assembly::x86::OPCODE::AVX_SET0)
  .value("CALL64m_RVMARKER", LIEF::assembly::x86::OPCODE::CALL64m_RVMARKER)
  .value("CALL64pcrel32_RVMARKER", LIEF::assembly::x86::OPCODE::CALL64pcrel32_RVMARKER)
  .value("CALL64r_ImpCall", LIEF::assembly::x86::OPCODE::CALL64r_ImpCall)
  .value("CALL64r_RVMARKER", LIEF::assembly::x86::OPCODE::CALL64r_RVMARKER)
  .value("FsFLD0F128", LIEF::assembly::x86::OPCODE::FsFLD0F128)
  .value("FsFLD0SD", LIEF::assembly::x86::OPCODE::FsFLD0SD)
  .value("FsFLD0SH", LIEF::assembly::x86::OPCODE::FsFLD0SH)
  .value("FsFLD0SS", LIEF::assembly::x86::OPCODE::FsFLD0SS)
  .value("G_FILD", LIEF::assembly::x86::OPCODE::G_FILD)
  .value("G_FIST", LIEF::assembly::x86::OPCODE::G_FIST)
  .value("G_FNSTCW16", LIEF::assembly::x86::OPCODE::G_FNSTCW16)
  .value("INDIRECT_THUNK_CALL32", LIEF::assembly::x86::OPCODE::INDIRECT_THUNK_CALL32)
  .value("INDIRECT_THUNK_CALL64", LIEF::assembly::x86::OPCODE::INDIRECT_THUNK_CALL64)
  .value("INDIRECT_THUNK_TCRETURN32", LIEF::assembly::x86::OPCODE::INDIRECT_THUNK_TCRETURN32)
  .value("INDIRECT_THUNK_TCRETURN64", LIEF::assembly::x86::OPCODE::INDIRECT_THUNK_TCRETURN64)
  .value("KSET0D", LIEF::assembly::x86::OPCODE::KSET0D)
  .value("KSET0Q", LIEF::assembly::x86::OPCODE::KSET0Q)
  .value("KSET0W", LIEF::assembly::x86::OPCODE::KSET0W)
  .value("KSET1D", LIEF::assembly::x86::OPCODE::KSET1D)
  .value("KSET1Q", LIEF::assembly::x86::OPCODE::KSET1Q)
  .value("KSET1W", LIEF::assembly::x86::OPCODE::KSET1W)
  .value("LCMPXCHG16B_NO_RBX", LIEF::assembly::x86::OPCODE::LCMPXCHG16B_NO_RBX)
  .value("LCMPXCHG16B_SAVE_RBX", LIEF::assembly::x86::OPCODE::LCMPXCHG16B_SAVE_RBX)
  .value("MMX_SET0", LIEF::assembly::x86::OPCODE::MMX_SET0)
  .value("MORESTACK_RET", LIEF::assembly::x86::OPCODE::MORESTACK_RET)
  .value("MORESTACK_RET_RESTORE_R10", LIEF::assembly::x86::OPCODE::MORESTACK_RET_RESTORE_R10)
  .value("MOV32ImmSExti8", LIEF::assembly::x86::OPCODE::MOV32ImmSExti8)
  .value("MOV32r0", LIEF::assembly::x86::OPCODE::MOV32r0)
  .value("MOV32r1", LIEF::assembly::x86::OPCODE::MOV32r1)
  .value("MOV32r_1", LIEF::assembly::x86::OPCODE::MOV32r_1)
  .value("MOV32ri64", LIEF::assembly::x86::OPCODE::MOV32ri64)
  .value("MOV64ImmSExti8", LIEF::assembly::x86::OPCODE::MOV64ImmSExti8)
  .value("MWAITX", LIEF::assembly::x86::OPCODE::MWAITX)
  .value("MWAITX_SAVE_RBX", LIEF::assembly::x86::OPCODE::MWAITX_SAVE_RBX)
  .value("PLDTILECFGV", LIEF::assembly::x86::OPCODE::PLDTILECFGV)
  .value("PLEA32r", LIEF::assembly::x86::OPCODE::PLEA32r)
  .value("PLEA64r", LIEF::assembly::x86::OPCODE::PLEA64r)
  .value("PT2RPNTLVWZ0RST1V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0RST1V)
  .value("PT2RPNTLVWZ0RSV", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0RSV)
  .value("PT2RPNTLVWZ0T1V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0T1V)
  .value("PT2RPNTLVWZ0V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0V)
  .value("PT2RPNTLVWZ1RST1V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1RST1V)
  .value("PT2RPNTLVWZ1RSV", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1RSV)
  .value("PT2RPNTLVWZ1T1V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1T1V)
  .value("PT2RPNTLVWZ1V", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1V)
  .value("PTDPBF16PSV", LIEF::assembly::x86::OPCODE::PTDPBF16PSV)
  .value("PTDPBSSDV", LIEF::assembly::x86::OPCODE::PTDPBSSDV)
  .value("PTDPBSUDV", LIEF::assembly::x86::OPCODE::PTDPBSUDV)
  .value("PTDPBUSDV", LIEF::assembly::x86::OPCODE::PTDPBUSDV)
  .value("PTDPBUUDV", LIEF::assembly::x86::OPCODE::PTDPBUUDV)
  .value("PTDPFP16PSV", LIEF::assembly::x86::OPCODE::PTDPFP16PSV)
  .value("PTILELOADDRST1V", LIEF::assembly::x86::OPCODE::PTILELOADDRST1V)
  .value("PTILELOADDRSV", LIEF::assembly::x86::OPCODE::PTILELOADDRSV)
  .value("PTILELOADDT1V", LIEF::assembly::x86::OPCODE::PTILELOADDT1V)
  .value("PTILELOADDV", LIEF::assembly::x86::OPCODE::PTILELOADDV)
  .value("PTILEPAIRLOAD", LIEF::assembly::x86::OPCODE::PTILEPAIRLOAD)
  .value("PTILEPAIRSTORE", LIEF::assembly::x86::OPCODE::PTILEPAIRSTORE)
  .value("PTILESTOREDV", LIEF::assembly::x86::OPCODE::PTILESTOREDV)
  .value("PTILEZEROV", LIEF::assembly::x86::OPCODE::PTILEZEROV)
  .value("RDFLAGS32", LIEF::assembly::x86::OPCODE::RDFLAGS32)
  .value("RDFLAGS64", LIEF::assembly::x86::OPCODE::RDFLAGS64)
  .value("SEH_BeginEpilogue", LIEF::assembly::x86::OPCODE::SEH_BeginEpilogue)
  .value("SEH_EndEpilogue", LIEF::assembly::x86::OPCODE::SEH_EndEpilogue)
  .value("SEH_EndPrologue", LIEF::assembly::x86::OPCODE::SEH_EndPrologue)
  .value("SEH_PushFrame", LIEF::assembly::x86::OPCODE::SEH_PushFrame)
  .value("SEH_PushReg", LIEF::assembly::x86::OPCODE::SEH_PushReg)
  .value("SEH_SaveReg", LIEF::assembly::x86::OPCODE::SEH_SaveReg)
  .value("SEH_SaveXMM", LIEF::assembly::x86::OPCODE::SEH_SaveXMM)
  .value("SEH_SetFrame", LIEF::assembly::x86::OPCODE::SEH_SetFrame)
  .value("SEH_StackAlign", LIEF::assembly::x86::OPCODE::SEH_StackAlign)
  .value("SEH_StackAlloc", LIEF::assembly::x86::OPCODE::SEH_StackAlloc)
  .value("SEH_UnwindV2Start", LIEF::assembly::x86::OPCODE::SEH_UnwindV2Start)
  .value("SEH_UnwindVersion", LIEF::assembly::x86::OPCODE::SEH_UnwindVersion)
  .value("SETB_C32r", LIEF::assembly::x86::OPCODE::SETB_C32r)
  .value("SETB_C64r", LIEF::assembly::x86::OPCODE::SETB_C64r)
  .value("SHLDROT32ri", LIEF::assembly::x86::OPCODE::SHLDROT32ri)
  .value("SHLDROT64ri", LIEF::assembly::x86::OPCODE::SHLDROT64ri)
  .value("SHRDROT32ri", LIEF::assembly::x86::OPCODE::SHRDROT32ri)
  .value("SHRDROT64ri", LIEF::assembly::x86::OPCODE::SHRDROT64ri)
  .value("VMOVAPSZ128mr_NOVLX", LIEF::assembly::x86::OPCODE::VMOVAPSZ128mr_NOVLX)
  .value("VMOVAPSZ128rm_NOVLX", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rm_NOVLX)
  .value("VMOVAPSZ256mr_NOVLX", LIEF::assembly::x86::OPCODE::VMOVAPSZ256mr_NOVLX)
  .value("VMOVAPSZ256rm_NOVLX", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rm_NOVLX)
  .value("VMOVUPSZ128mr_NOVLX", LIEF::assembly::x86::OPCODE::VMOVUPSZ128mr_NOVLX)
  .value("VMOVUPSZ128rm_NOVLX", LIEF::assembly::x86::OPCODE::VMOVUPSZ128rm_NOVLX)
  .value("VMOVUPSZ256mr_NOVLX", LIEF::assembly::x86::OPCODE::VMOVUPSZ256mr_NOVLX)
  .value("VMOVUPSZ256rm_NOVLX", LIEF::assembly::x86::OPCODE::VMOVUPSZ256rm_NOVLX)
  .value("V_SET0", LIEF::assembly::x86::OPCODE::V_SET0)
  .value("V_SETALLONES", LIEF::assembly::x86::OPCODE::V_SETALLONES)
  .value("WRFLAGS32", LIEF::assembly::x86::OPCODE::WRFLAGS32)
  .value("WRFLAGS64", LIEF::assembly::x86::OPCODE::WRFLAGS64)
  .value("XABORT_DEF", LIEF::assembly::x86::OPCODE::XABORT_DEF)
  .value("XOR32_FP", LIEF::assembly::x86::OPCODE::XOR32_FP)
  .value("XOR64_FP", LIEF::assembly::x86::OPCODE::XOR64_FP)
  .value("AAA", LIEF::assembly::x86::OPCODE::AAA)
  .value("AAD8i8", LIEF::assembly::x86::OPCODE::AAD8i8)
  .value("AADD32mr", LIEF::assembly::x86::OPCODE::AADD32mr)
  .value("AADD32mr_EVEX", LIEF::assembly::x86::OPCODE::AADD32mr_EVEX)
  .value("AADD64mr", LIEF::assembly::x86::OPCODE::AADD64mr)
  .value("AADD64mr_EVEX", LIEF::assembly::x86::OPCODE::AADD64mr_EVEX)
  .value("AAM8i8", LIEF::assembly::x86::OPCODE::AAM8i8)
  .value("AAND32mr", LIEF::assembly::x86::OPCODE::AAND32mr)
  .value("AAND32mr_EVEX", LIEF::assembly::x86::OPCODE::AAND32mr_EVEX)
  .value("AAND64mr", LIEF::assembly::x86::OPCODE::AAND64mr)
  .value("AAND64mr_EVEX", LIEF::assembly::x86::OPCODE::AAND64mr_EVEX)
  .value("AAS", LIEF::assembly::x86::OPCODE::AAS)
  .value("ABS_F", LIEF::assembly::x86::OPCODE::ABS_F)
  .value("ABS_Fp32", LIEF::assembly::x86::OPCODE::ABS_Fp32)
  .value("ABS_Fp64", LIEF::assembly::x86::OPCODE::ABS_Fp64)
  .value("ABS_Fp80", LIEF::assembly::x86::OPCODE::ABS_Fp80)
  .value("ADC16i16", LIEF::assembly::x86::OPCODE::ADC16i16)
  .value("ADC16mi", LIEF::assembly::x86::OPCODE::ADC16mi)
  .value("ADC16mi8", LIEF::assembly::x86::OPCODE::ADC16mi8)
  .value("ADC16mi8_EVEX", LIEF::assembly::x86::OPCODE::ADC16mi8_EVEX)
  .value("ADC16mi8_ND", LIEF::assembly::x86::OPCODE::ADC16mi8_ND)
  .value("ADC16mi_EVEX", LIEF::assembly::x86::OPCODE::ADC16mi_EVEX)
  .value("ADC16mi_ND", LIEF::assembly::x86::OPCODE::ADC16mi_ND)
  .value("ADC16mr", LIEF::assembly::x86::OPCODE::ADC16mr)
  .value("ADC16mr_EVEX", LIEF::assembly::x86::OPCODE::ADC16mr_EVEX)
  .value("ADC16mr_ND", LIEF::assembly::x86::OPCODE::ADC16mr_ND)
  .value("ADC16ri", LIEF::assembly::x86::OPCODE::ADC16ri)
  .value("ADC16ri8", LIEF::assembly::x86::OPCODE::ADC16ri8)
  .value("ADC16ri8_EVEX", LIEF::assembly::x86::OPCODE::ADC16ri8_EVEX)
  .value("ADC16ri8_ND", LIEF::assembly::x86::OPCODE::ADC16ri8_ND)
  .value("ADC16ri_EVEX", LIEF::assembly::x86::OPCODE::ADC16ri_EVEX)
  .value("ADC16ri_ND", LIEF::assembly::x86::OPCODE::ADC16ri_ND)
  .value("ADC16rm", LIEF::assembly::x86::OPCODE::ADC16rm)
  .value("ADC16rm_EVEX", LIEF::assembly::x86::OPCODE::ADC16rm_EVEX)
  .value("ADC16rm_ND", LIEF::assembly::x86::OPCODE::ADC16rm_ND)
  .value("ADC16rr", LIEF::assembly::x86::OPCODE::ADC16rr)
  .value("ADC16rr_EVEX", LIEF::assembly::x86::OPCODE::ADC16rr_EVEX)
  .value("ADC16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADC16rr_EVEX_REV)
  .value("ADC16rr_ND", LIEF::assembly::x86::OPCODE::ADC16rr_ND)
  .value("ADC16rr_ND_REV", LIEF::assembly::x86::OPCODE::ADC16rr_ND_REV)
  .value("ADC16rr_REV", LIEF::assembly::x86::OPCODE::ADC16rr_REV)
  .value("ADC32i32", LIEF::assembly::x86::OPCODE::ADC32i32)
  .value("ADC32mi", LIEF::assembly::x86::OPCODE::ADC32mi)
  .value("ADC32mi8", LIEF::assembly::x86::OPCODE::ADC32mi8)
  .value("ADC32mi8_EVEX", LIEF::assembly::x86::OPCODE::ADC32mi8_EVEX)
  .value("ADC32mi8_ND", LIEF::assembly::x86::OPCODE::ADC32mi8_ND)
  .value("ADC32mi_EVEX", LIEF::assembly::x86::OPCODE::ADC32mi_EVEX)
  .value("ADC32mi_ND", LIEF::assembly::x86::OPCODE::ADC32mi_ND)
  .value("ADC32mr", LIEF::assembly::x86::OPCODE::ADC32mr)
  .value("ADC32mr_EVEX", LIEF::assembly::x86::OPCODE::ADC32mr_EVEX)
  .value("ADC32mr_ND", LIEF::assembly::x86::OPCODE::ADC32mr_ND)
  .value("ADC32ri", LIEF::assembly::x86::OPCODE::ADC32ri)
  .value("ADC32ri8", LIEF::assembly::x86::OPCODE::ADC32ri8)
  .value("ADC32ri8_EVEX", LIEF::assembly::x86::OPCODE::ADC32ri8_EVEX)
  .value("ADC32ri8_ND", LIEF::assembly::x86::OPCODE::ADC32ri8_ND)
  .value("ADC32ri_EVEX", LIEF::assembly::x86::OPCODE::ADC32ri_EVEX)
  .value("ADC32ri_ND", LIEF::assembly::x86::OPCODE::ADC32ri_ND)
  .value("ADC32rm", LIEF::assembly::x86::OPCODE::ADC32rm)
  .value("ADC32rm_EVEX", LIEF::assembly::x86::OPCODE::ADC32rm_EVEX)
  .value("ADC32rm_ND", LIEF::assembly::x86::OPCODE::ADC32rm_ND)
  .value("ADC32rr", LIEF::assembly::x86::OPCODE::ADC32rr)
  .value("ADC32rr_EVEX", LIEF::assembly::x86::OPCODE::ADC32rr_EVEX)
  .value("ADC32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADC32rr_EVEX_REV)
  .value("ADC32rr_ND", LIEF::assembly::x86::OPCODE::ADC32rr_ND)
  .value("ADC32rr_ND_REV", LIEF::assembly::x86::OPCODE::ADC32rr_ND_REV)
  .value("ADC32rr_REV", LIEF::assembly::x86::OPCODE::ADC32rr_REV)
  .value("ADC64i32", LIEF::assembly::x86::OPCODE::ADC64i32)
  .value("ADC64mi32", LIEF::assembly::x86::OPCODE::ADC64mi32)
  .value("ADC64mi32_EVEX", LIEF::assembly::x86::OPCODE::ADC64mi32_EVEX)
  .value("ADC64mi32_ND", LIEF::assembly::x86::OPCODE::ADC64mi32_ND)
  .value("ADC64mi8", LIEF::assembly::x86::OPCODE::ADC64mi8)
  .value("ADC64mi8_EVEX", LIEF::assembly::x86::OPCODE::ADC64mi8_EVEX)
  .value("ADC64mi8_ND", LIEF::assembly::x86::OPCODE::ADC64mi8_ND)
  .value("ADC64mr", LIEF::assembly::x86::OPCODE::ADC64mr)
  .value("ADC64mr_EVEX", LIEF::assembly::x86::OPCODE::ADC64mr_EVEX)
  .value("ADC64mr_ND", LIEF::assembly::x86::OPCODE::ADC64mr_ND)
  .value("ADC64ri32", LIEF::assembly::x86::OPCODE::ADC64ri32)
  .value("ADC64ri32_EVEX", LIEF::assembly::x86::OPCODE::ADC64ri32_EVEX)
  .value("ADC64ri32_ND", LIEF::assembly::x86::OPCODE::ADC64ri32_ND)
  .value("ADC64ri8", LIEF::assembly::x86::OPCODE::ADC64ri8)
  .value("ADC64ri8_EVEX", LIEF::assembly::x86::OPCODE::ADC64ri8_EVEX)
  .value("ADC64ri8_ND", LIEF::assembly::x86::OPCODE::ADC64ri8_ND)
  .value("ADC64rm", LIEF::assembly::x86::OPCODE::ADC64rm)
  .value("ADC64rm_EVEX", LIEF::assembly::x86::OPCODE::ADC64rm_EVEX)
  .value("ADC64rm_ND", LIEF::assembly::x86::OPCODE::ADC64rm_ND)
  .value("ADC64rr", LIEF::assembly::x86::OPCODE::ADC64rr)
  .value("ADC64rr_EVEX", LIEF::assembly::x86::OPCODE::ADC64rr_EVEX)
  .value("ADC64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADC64rr_EVEX_REV)
  .value("ADC64rr_ND", LIEF::assembly::x86::OPCODE::ADC64rr_ND)
  .value("ADC64rr_ND_REV", LIEF::assembly::x86::OPCODE::ADC64rr_ND_REV)
  .value("ADC64rr_REV", LIEF::assembly::x86::OPCODE::ADC64rr_REV)
  .value("ADC8i8", LIEF::assembly::x86::OPCODE::ADC8i8)
  .value("ADC8mi", LIEF::assembly::x86::OPCODE::ADC8mi)
  .value("ADC8mi8", LIEF::assembly::x86::OPCODE::ADC8mi8)
  .value("ADC8mi_EVEX", LIEF::assembly::x86::OPCODE::ADC8mi_EVEX)
  .value("ADC8mi_ND", LIEF::assembly::x86::OPCODE::ADC8mi_ND)
  .value("ADC8mr", LIEF::assembly::x86::OPCODE::ADC8mr)
  .value("ADC8mr_EVEX", LIEF::assembly::x86::OPCODE::ADC8mr_EVEX)
  .value("ADC8mr_ND", LIEF::assembly::x86::OPCODE::ADC8mr_ND)
  .value("ADC8ri", LIEF::assembly::x86::OPCODE::ADC8ri)
  .value("ADC8ri8", LIEF::assembly::x86::OPCODE::ADC8ri8)
  .value("ADC8ri_EVEX", LIEF::assembly::x86::OPCODE::ADC8ri_EVEX)
  .value("ADC8ri_ND", LIEF::assembly::x86::OPCODE::ADC8ri_ND)
  .value("ADC8rm", LIEF::assembly::x86::OPCODE::ADC8rm)
  .value("ADC8rm_EVEX", LIEF::assembly::x86::OPCODE::ADC8rm_EVEX)
  .value("ADC8rm_ND", LIEF::assembly::x86::OPCODE::ADC8rm_ND)
  .value("ADC8rr", LIEF::assembly::x86::OPCODE::ADC8rr)
  .value("ADC8rr_EVEX", LIEF::assembly::x86::OPCODE::ADC8rr_EVEX)
  .value("ADC8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADC8rr_EVEX_REV)
  .value("ADC8rr_ND", LIEF::assembly::x86::OPCODE::ADC8rr_ND)
  .value("ADC8rr_ND_REV", LIEF::assembly::x86::OPCODE::ADC8rr_ND_REV)
  .value("ADC8rr_REV", LIEF::assembly::x86::OPCODE::ADC8rr_REV)
  .value("ADCX32rm", LIEF::assembly::x86::OPCODE::ADCX32rm)
  .value("ADCX32rm_EVEX", LIEF::assembly::x86::OPCODE::ADCX32rm_EVEX)
  .value("ADCX32rm_ND", LIEF::assembly::x86::OPCODE::ADCX32rm_ND)
  .value("ADCX32rr", LIEF::assembly::x86::OPCODE::ADCX32rr)
  .value("ADCX32rr_EVEX", LIEF::assembly::x86::OPCODE::ADCX32rr_EVEX)
  .value("ADCX32rr_ND", LIEF::assembly::x86::OPCODE::ADCX32rr_ND)
  .value("ADCX64rm", LIEF::assembly::x86::OPCODE::ADCX64rm)
  .value("ADCX64rm_EVEX", LIEF::assembly::x86::OPCODE::ADCX64rm_EVEX)
  .value("ADCX64rm_ND", LIEF::assembly::x86::OPCODE::ADCX64rm_ND)
  .value("ADCX64rr", LIEF::assembly::x86::OPCODE::ADCX64rr)
  .value("ADCX64rr_EVEX", LIEF::assembly::x86::OPCODE::ADCX64rr_EVEX)
  .value("ADCX64rr_ND", LIEF::assembly::x86::OPCODE::ADCX64rr_ND)
  .value("ADD16i16", LIEF::assembly::x86::OPCODE::ADD16i16)
  .value("ADD16mi", LIEF::assembly::x86::OPCODE::ADD16mi)
  .value("ADD16mi8", LIEF::assembly::x86::OPCODE::ADD16mi8)
  .value("ADD16mi8_EVEX", LIEF::assembly::x86::OPCODE::ADD16mi8_EVEX)
  .value("ADD16mi8_ND", LIEF::assembly::x86::OPCODE::ADD16mi8_ND)
  .value("ADD16mi8_NF", LIEF::assembly::x86::OPCODE::ADD16mi8_NF)
  .value("ADD16mi8_NF_ND", LIEF::assembly::x86::OPCODE::ADD16mi8_NF_ND)
  .value("ADD16mi_EVEX", LIEF::assembly::x86::OPCODE::ADD16mi_EVEX)
  .value("ADD16mi_ND", LIEF::assembly::x86::OPCODE::ADD16mi_ND)
  .value("ADD16mi_NF", LIEF::assembly::x86::OPCODE::ADD16mi_NF)
  .value("ADD16mi_NF_ND", LIEF::assembly::x86::OPCODE::ADD16mi_NF_ND)
  .value("ADD16mr", LIEF::assembly::x86::OPCODE::ADD16mr)
  .value("ADD16mr_EVEX", LIEF::assembly::x86::OPCODE::ADD16mr_EVEX)
  .value("ADD16mr_ND", LIEF::assembly::x86::OPCODE::ADD16mr_ND)
  .value("ADD16mr_NF", LIEF::assembly::x86::OPCODE::ADD16mr_NF)
  .value("ADD16mr_NF_ND", LIEF::assembly::x86::OPCODE::ADD16mr_NF_ND)
  .value("ADD16ri", LIEF::assembly::x86::OPCODE::ADD16ri)
  .value("ADD16ri8", LIEF::assembly::x86::OPCODE::ADD16ri8)
  .value("ADD16ri8_EVEX", LIEF::assembly::x86::OPCODE::ADD16ri8_EVEX)
  .value("ADD16ri8_ND", LIEF::assembly::x86::OPCODE::ADD16ri8_ND)
  .value("ADD16ri8_NF", LIEF::assembly::x86::OPCODE::ADD16ri8_NF)
  .value("ADD16ri8_NF_ND", LIEF::assembly::x86::OPCODE::ADD16ri8_NF_ND)
  .value("ADD16ri_EVEX", LIEF::assembly::x86::OPCODE::ADD16ri_EVEX)
  .value("ADD16ri_ND", LIEF::assembly::x86::OPCODE::ADD16ri_ND)
  .value("ADD16ri_NF", LIEF::assembly::x86::OPCODE::ADD16ri_NF)
  .value("ADD16ri_NF_ND", LIEF::assembly::x86::OPCODE::ADD16ri_NF_ND)
  .value("ADD16rm", LIEF::assembly::x86::OPCODE::ADD16rm)
  .value("ADD16rm_EVEX", LIEF::assembly::x86::OPCODE::ADD16rm_EVEX)
  .value("ADD16rm_ND", LIEF::assembly::x86::OPCODE::ADD16rm_ND)
  .value("ADD16rm_NF", LIEF::assembly::x86::OPCODE::ADD16rm_NF)
  .value("ADD16rm_NF_ND", LIEF::assembly::x86::OPCODE::ADD16rm_NF_ND)
  .value("ADD16rr", LIEF::assembly::x86::OPCODE::ADD16rr)
  .value("ADD16rr_EVEX", LIEF::assembly::x86::OPCODE::ADD16rr_EVEX)
  .value("ADD16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADD16rr_EVEX_REV)
  .value("ADD16rr_ND", LIEF::assembly::x86::OPCODE::ADD16rr_ND)
  .value("ADD16rr_ND_REV", LIEF::assembly::x86::OPCODE::ADD16rr_ND_REV)
  .value("ADD16rr_NF", LIEF::assembly::x86::OPCODE::ADD16rr_NF)
  .value("ADD16rr_NF_ND", LIEF::assembly::x86::OPCODE::ADD16rr_NF_ND)
  .value("ADD16rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::ADD16rr_NF_ND_REV)
  .value("ADD16rr_NF_REV", LIEF::assembly::x86::OPCODE::ADD16rr_NF_REV)
  .value("ADD16rr_REV", LIEF::assembly::x86::OPCODE::ADD16rr_REV)
  .value("ADD32i32", LIEF::assembly::x86::OPCODE::ADD32i32)
  .value("ADD32mi", LIEF::assembly::x86::OPCODE::ADD32mi)
  .value("ADD32mi8", LIEF::assembly::x86::OPCODE::ADD32mi8)
  .value("ADD32mi8_EVEX", LIEF::assembly::x86::OPCODE::ADD32mi8_EVEX)
  .value("ADD32mi8_ND", LIEF::assembly::x86::OPCODE::ADD32mi8_ND)
  .value("ADD32mi8_NF", LIEF::assembly::x86::OPCODE::ADD32mi8_NF);
  opcodes.value("ADD32mi8_NF_ND", LIEF::assembly::x86::OPCODE::ADD32mi8_NF_ND)
  .value("ADD32mi_EVEX", LIEF::assembly::x86::OPCODE::ADD32mi_EVEX)
  .value("ADD32mi_ND", LIEF::assembly::x86::OPCODE::ADD32mi_ND)
  .value("ADD32mi_NF", LIEF::assembly::x86::OPCODE::ADD32mi_NF)
  .value("ADD32mi_NF_ND", LIEF::assembly::x86::OPCODE::ADD32mi_NF_ND)
  .value("ADD32mr", LIEF::assembly::x86::OPCODE::ADD32mr)
  .value("ADD32mr_EVEX", LIEF::assembly::x86::OPCODE::ADD32mr_EVEX)
  .value("ADD32mr_ND", LIEF::assembly::x86::OPCODE::ADD32mr_ND)
  .value("ADD32mr_NF", LIEF::assembly::x86::OPCODE::ADD32mr_NF)
  .value("ADD32mr_NF_ND", LIEF::assembly::x86::OPCODE::ADD32mr_NF_ND)
  .value("ADD32ri", LIEF::assembly::x86::OPCODE::ADD32ri)
  .value("ADD32ri8", LIEF::assembly::x86::OPCODE::ADD32ri8)
  .value("ADD32ri8_EVEX", LIEF::assembly::x86::OPCODE::ADD32ri8_EVEX)
  .value("ADD32ri8_ND", LIEF::assembly::x86::OPCODE::ADD32ri8_ND)
  .value("ADD32ri8_NF", LIEF::assembly::x86::OPCODE::ADD32ri8_NF)
  .value("ADD32ri8_NF_ND", LIEF::assembly::x86::OPCODE::ADD32ri8_NF_ND)
  .value("ADD32ri_EVEX", LIEF::assembly::x86::OPCODE::ADD32ri_EVEX)
  .value("ADD32ri_ND", LIEF::assembly::x86::OPCODE::ADD32ri_ND)
  .value("ADD32ri_NF", LIEF::assembly::x86::OPCODE::ADD32ri_NF)
  .value("ADD32ri_NF_ND", LIEF::assembly::x86::OPCODE::ADD32ri_NF_ND)
  .value("ADD32rm", LIEF::assembly::x86::OPCODE::ADD32rm)
  .value("ADD32rm_EVEX", LIEF::assembly::x86::OPCODE::ADD32rm_EVEX)
  .value("ADD32rm_ND", LIEF::assembly::x86::OPCODE::ADD32rm_ND)
  .value("ADD32rm_NF", LIEF::assembly::x86::OPCODE::ADD32rm_NF)
  .value("ADD32rm_NF_ND", LIEF::assembly::x86::OPCODE::ADD32rm_NF_ND)
  .value("ADD32rr", LIEF::assembly::x86::OPCODE::ADD32rr)
  .value("ADD32rr_EVEX", LIEF::assembly::x86::OPCODE::ADD32rr_EVEX)
  .value("ADD32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADD32rr_EVEX_REV)
  .value("ADD32rr_ND", LIEF::assembly::x86::OPCODE::ADD32rr_ND)
  .value("ADD32rr_ND_REV", LIEF::assembly::x86::OPCODE::ADD32rr_ND_REV)
  .value("ADD32rr_NF", LIEF::assembly::x86::OPCODE::ADD32rr_NF)
  .value("ADD32rr_NF_ND", LIEF::assembly::x86::OPCODE::ADD32rr_NF_ND)
  .value("ADD32rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::ADD32rr_NF_ND_REV)
  .value("ADD32rr_NF_REV", LIEF::assembly::x86::OPCODE::ADD32rr_NF_REV)
  .value("ADD32rr_REV", LIEF::assembly::x86::OPCODE::ADD32rr_REV)
  .value("ADD64i32", LIEF::assembly::x86::OPCODE::ADD64i32)
  .value("ADD64mi32", LIEF::assembly::x86::OPCODE::ADD64mi32)
  .value("ADD64mi32_EVEX", LIEF::assembly::x86::OPCODE::ADD64mi32_EVEX)
  .value("ADD64mi32_ND", LIEF::assembly::x86::OPCODE::ADD64mi32_ND)
  .value("ADD64mi32_NF", LIEF::assembly::x86::OPCODE::ADD64mi32_NF)
  .value("ADD64mi32_NF_ND", LIEF::assembly::x86::OPCODE::ADD64mi32_NF_ND)
  .value("ADD64mi8", LIEF::assembly::x86::OPCODE::ADD64mi8)
  .value("ADD64mi8_EVEX", LIEF::assembly::x86::OPCODE::ADD64mi8_EVEX)
  .value("ADD64mi8_ND", LIEF::assembly::x86::OPCODE::ADD64mi8_ND)
  .value("ADD64mi8_NF", LIEF::assembly::x86::OPCODE::ADD64mi8_NF)
  .value("ADD64mi8_NF_ND", LIEF::assembly::x86::OPCODE::ADD64mi8_NF_ND)
  .value("ADD64mr", LIEF::assembly::x86::OPCODE::ADD64mr)
  .value("ADD64mr_EVEX", LIEF::assembly::x86::OPCODE::ADD64mr_EVEX)
  .value("ADD64mr_ND", LIEF::assembly::x86::OPCODE::ADD64mr_ND)
  .value("ADD64mr_NF", LIEF::assembly::x86::OPCODE::ADD64mr_NF)
  .value("ADD64mr_NF_ND", LIEF::assembly::x86::OPCODE::ADD64mr_NF_ND)
  .value("ADD64ri32", LIEF::assembly::x86::OPCODE::ADD64ri32)
  .value("ADD64ri32_EVEX", LIEF::assembly::x86::OPCODE::ADD64ri32_EVEX)
  .value("ADD64ri32_ND", LIEF::assembly::x86::OPCODE::ADD64ri32_ND)
  .value("ADD64ri32_NF", LIEF::assembly::x86::OPCODE::ADD64ri32_NF)
  .value("ADD64ri32_NF_ND", LIEF::assembly::x86::OPCODE::ADD64ri32_NF_ND)
  .value("ADD64ri8", LIEF::assembly::x86::OPCODE::ADD64ri8)
  .value("ADD64ri8_EVEX", LIEF::assembly::x86::OPCODE::ADD64ri8_EVEX)
  .value("ADD64ri8_ND", LIEF::assembly::x86::OPCODE::ADD64ri8_ND)
  .value("ADD64ri8_NF", LIEF::assembly::x86::OPCODE::ADD64ri8_NF)
  .value("ADD64ri8_NF_ND", LIEF::assembly::x86::OPCODE::ADD64ri8_NF_ND)
  .value("ADD64rm", LIEF::assembly::x86::OPCODE::ADD64rm)
  .value("ADD64rm_EVEX", LIEF::assembly::x86::OPCODE::ADD64rm_EVEX)
  .value("ADD64rm_ND", LIEF::assembly::x86::OPCODE::ADD64rm_ND)
  .value("ADD64rm_NF", LIEF::assembly::x86::OPCODE::ADD64rm_NF)
  .value("ADD64rm_NF_ND", LIEF::assembly::x86::OPCODE::ADD64rm_NF_ND)
  .value("ADD64rr", LIEF::assembly::x86::OPCODE::ADD64rr)
  .value("ADD64rr_EVEX", LIEF::assembly::x86::OPCODE::ADD64rr_EVEX)
  .value("ADD64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADD64rr_EVEX_REV)
  .value("ADD64rr_ND", LIEF::assembly::x86::OPCODE::ADD64rr_ND)
  .value("ADD64rr_ND_REV", LIEF::assembly::x86::OPCODE::ADD64rr_ND_REV)
  .value("ADD64rr_NF", LIEF::assembly::x86::OPCODE::ADD64rr_NF)
  .value("ADD64rr_NF_ND", LIEF::assembly::x86::OPCODE::ADD64rr_NF_ND)
  .value("ADD64rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::ADD64rr_NF_ND_REV)
  .value("ADD64rr_NF_REV", LIEF::assembly::x86::OPCODE::ADD64rr_NF_REV)
  .value("ADD64rr_REV", LIEF::assembly::x86::OPCODE::ADD64rr_REV)
  .value("ADD8i8", LIEF::assembly::x86::OPCODE::ADD8i8)
  .value("ADD8mi", LIEF::assembly::x86::OPCODE::ADD8mi)
  .value("ADD8mi8", LIEF::assembly::x86::OPCODE::ADD8mi8)
  .value("ADD8mi_EVEX", LIEF::assembly::x86::OPCODE::ADD8mi_EVEX)
  .value("ADD8mi_ND", LIEF::assembly::x86::OPCODE::ADD8mi_ND)
  .value("ADD8mi_NF", LIEF::assembly::x86::OPCODE::ADD8mi_NF)
  .value("ADD8mi_NF_ND", LIEF::assembly::x86::OPCODE::ADD8mi_NF_ND)
  .value("ADD8mr", LIEF::assembly::x86::OPCODE::ADD8mr)
  .value("ADD8mr_EVEX", LIEF::assembly::x86::OPCODE::ADD8mr_EVEX)
  .value("ADD8mr_ND", LIEF::assembly::x86::OPCODE::ADD8mr_ND)
  .value("ADD8mr_NF", LIEF::assembly::x86::OPCODE::ADD8mr_NF)
  .value("ADD8mr_NF_ND", LIEF::assembly::x86::OPCODE::ADD8mr_NF_ND)
  .value("ADD8ri", LIEF::assembly::x86::OPCODE::ADD8ri)
  .value("ADD8ri8", LIEF::assembly::x86::OPCODE::ADD8ri8)
  .value("ADD8ri_EVEX", LIEF::assembly::x86::OPCODE::ADD8ri_EVEX)
  .value("ADD8ri_ND", LIEF::assembly::x86::OPCODE::ADD8ri_ND)
  .value("ADD8ri_NF", LIEF::assembly::x86::OPCODE::ADD8ri_NF)
  .value("ADD8ri_NF_ND", LIEF::assembly::x86::OPCODE::ADD8ri_NF_ND)
  .value("ADD8rm", LIEF::assembly::x86::OPCODE::ADD8rm)
  .value("ADD8rm_EVEX", LIEF::assembly::x86::OPCODE::ADD8rm_EVEX)
  .value("ADD8rm_ND", LIEF::assembly::x86::OPCODE::ADD8rm_ND)
  .value("ADD8rm_NF", LIEF::assembly::x86::OPCODE::ADD8rm_NF)
  .value("ADD8rm_NF_ND", LIEF::assembly::x86::OPCODE::ADD8rm_NF_ND)
  .value("ADD8rr", LIEF::assembly::x86::OPCODE::ADD8rr)
  .value("ADD8rr_EVEX", LIEF::assembly::x86::OPCODE::ADD8rr_EVEX)
  .value("ADD8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::ADD8rr_EVEX_REV)
  .value("ADD8rr_ND", LIEF::assembly::x86::OPCODE::ADD8rr_ND)
  .value("ADD8rr_ND_REV", LIEF::assembly::x86::OPCODE::ADD8rr_ND_REV)
  .value("ADD8rr_NF", LIEF::assembly::x86::OPCODE::ADD8rr_NF)
  .value("ADD8rr_NF_ND", LIEF::assembly::x86::OPCODE::ADD8rr_NF_ND)
  .value("ADD8rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::ADD8rr_NF_ND_REV)
  .value("ADD8rr_NF_REV", LIEF::assembly::x86::OPCODE::ADD8rr_NF_REV)
  .value("ADD8rr_REV", LIEF::assembly::x86::OPCODE::ADD8rr_REV)
  .value("ADDPDrm", LIEF::assembly::x86::OPCODE::ADDPDrm)
  .value("ADDPDrr", LIEF::assembly::x86::OPCODE::ADDPDrr)
  .value("ADDPSrm", LIEF::assembly::x86::OPCODE::ADDPSrm)
  .value("ADDPSrr", LIEF::assembly::x86::OPCODE::ADDPSrr)
  .value("ADDR16_PREFIX", LIEF::assembly::x86::OPCODE::ADDR16_PREFIX)
  .value("ADDR32_PREFIX", LIEF::assembly::x86::OPCODE::ADDR32_PREFIX)
  .value("ADDSDrm", LIEF::assembly::x86::OPCODE::ADDSDrm)
  .value("ADDSDrm_Int", LIEF::assembly::x86::OPCODE::ADDSDrm_Int)
  .value("ADDSDrr", LIEF::assembly::x86::OPCODE::ADDSDrr)
  .value("ADDSDrr_Int", LIEF::assembly::x86::OPCODE::ADDSDrr_Int)
  .value("ADDSSrm", LIEF::assembly::x86::OPCODE::ADDSSrm)
  .value("ADDSSrm_Int", LIEF::assembly::x86::OPCODE::ADDSSrm_Int)
  .value("ADDSSrr", LIEF::assembly::x86::OPCODE::ADDSSrr)
  .value("ADDSSrr_Int", LIEF::assembly::x86::OPCODE::ADDSSrr_Int)
  .value("ADDSUBPDrm", LIEF::assembly::x86::OPCODE::ADDSUBPDrm)
  .value("ADDSUBPDrr", LIEF::assembly::x86::OPCODE::ADDSUBPDrr)
  .value("ADDSUBPSrm", LIEF::assembly::x86::OPCODE::ADDSUBPSrm)
  .value("ADDSUBPSrr", LIEF::assembly::x86::OPCODE::ADDSUBPSrr)
  .value("ADD_F32m", LIEF::assembly::x86::OPCODE::ADD_F32m)
  .value("ADD_F64m", LIEF::assembly::x86::OPCODE::ADD_F64m)
  .value("ADD_FI16m", LIEF::assembly::x86::OPCODE::ADD_FI16m)
  .value("ADD_FI32m", LIEF::assembly::x86::OPCODE::ADD_FI32m)
  .value("ADD_FPrST0", LIEF::assembly::x86::OPCODE::ADD_FPrST0)
  .value("ADD_FST0r", LIEF::assembly::x86::OPCODE::ADD_FST0r)
  .value("ADD_Fp32", LIEF::assembly::x86::OPCODE::ADD_Fp32)
  .value("ADD_Fp32m", LIEF::assembly::x86::OPCODE::ADD_Fp32m)
  .value("ADD_Fp64", LIEF::assembly::x86::OPCODE::ADD_Fp64)
  .value("ADD_Fp64m", LIEF::assembly::x86::OPCODE::ADD_Fp64m)
  .value("ADD_Fp64m32", LIEF::assembly::x86::OPCODE::ADD_Fp64m32)
  .value("ADD_Fp80", LIEF::assembly::x86::OPCODE::ADD_Fp80)
  .value("ADD_Fp80m32", LIEF::assembly::x86::OPCODE::ADD_Fp80m32)
  .value("ADD_Fp80m64", LIEF::assembly::x86::OPCODE::ADD_Fp80m64)
  .value("ADD_FpI16m32", LIEF::assembly::x86::OPCODE::ADD_FpI16m32)
  .value("ADD_FpI16m64", LIEF::assembly::x86::OPCODE::ADD_FpI16m64)
  .value("ADD_FpI16m80", LIEF::assembly::x86::OPCODE::ADD_FpI16m80)
  .value("ADD_FpI32m32", LIEF::assembly::x86::OPCODE::ADD_FpI32m32)
  .value("ADD_FpI32m64", LIEF::assembly::x86::OPCODE::ADD_FpI32m64)
  .value("ADD_FpI32m80", LIEF::assembly::x86::OPCODE::ADD_FpI32m80)
  .value("ADD_FrST0", LIEF::assembly::x86::OPCODE::ADD_FrST0)
  .value("ADJCALLSTACKDOWN32", LIEF::assembly::x86::OPCODE::ADJCALLSTACKDOWN32)
  .value("ADJCALLSTACKDOWN64", LIEF::assembly::x86::OPCODE::ADJCALLSTACKDOWN64)
  .value("ADJCALLSTACKUP32", LIEF::assembly::x86::OPCODE::ADJCALLSTACKUP32)
  .value("ADJCALLSTACKUP64", LIEF::assembly::x86::OPCODE::ADJCALLSTACKUP64)
  .value("ADOX32rm", LIEF::assembly::x86::OPCODE::ADOX32rm)
  .value("ADOX32rm_EVEX", LIEF::assembly::x86::OPCODE::ADOX32rm_EVEX)
  .value("ADOX32rm_ND", LIEF::assembly::x86::OPCODE::ADOX32rm_ND)
  .value("ADOX32rr", LIEF::assembly::x86::OPCODE::ADOX32rr)
  .value("ADOX32rr_EVEX", LIEF::assembly::x86::OPCODE::ADOX32rr_EVEX)
  .value("ADOX32rr_ND", LIEF::assembly::x86::OPCODE::ADOX32rr_ND)
  .value("ADOX64rm", LIEF::assembly::x86::OPCODE::ADOX64rm)
  .value("ADOX64rm_EVEX", LIEF::assembly::x86::OPCODE::ADOX64rm_EVEX)
  .value("ADOX64rm_ND", LIEF::assembly::x86::OPCODE::ADOX64rm_ND)
  .value("ADOX64rr", LIEF::assembly::x86::OPCODE::ADOX64rr)
  .value("ADOX64rr_EVEX", LIEF::assembly::x86::OPCODE::ADOX64rr_EVEX)
  .value("ADOX64rr_ND", LIEF::assembly::x86::OPCODE::ADOX64rr_ND)
  .value("AESDEC128KL", LIEF::assembly::x86::OPCODE::AESDEC128KL)
  .value("AESDEC256KL", LIEF::assembly::x86::OPCODE::AESDEC256KL)
  .value("AESDECLASTrm", LIEF::assembly::x86::OPCODE::AESDECLASTrm)
  .value("AESDECLASTrr", LIEF::assembly::x86::OPCODE::AESDECLASTrr)
  .value("AESDECWIDE128KL", LIEF::assembly::x86::OPCODE::AESDECWIDE128KL)
  .value("AESDECWIDE256KL", LIEF::assembly::x86::OPCODE::AESDECWIDE256KL)
  .value("AESDECrm", LIEF::assembly::x86::OPCODE::AESDECrm)
  .value("AESDECrr", LIEF::assembly::x86::OPCODE::AESDECrr)
  .value("AESENC128KL", LIEF::assembly::x86::OPCODE::AESENC128KL)
  .value("AESENC256KL", LIEF::assembly::x86::OPCODE::AESENC256KL)
  .value("AESENCLASTrm", LIEF::assembly::x86::OPCODE::AESENCLASTrm)
  .value("AESENCLASTrr", LIEF::assembly::x86::OPCODE::AESENCLASTrr)
  .value("AESENCWIDE128KL", LIEF::assembly::x86::OPCODE::AESENCWIDE128KL)
  .value("AESENCWIDE256KL", LIEF::assembly::x86::OPCODE::AESENCWIDE256KL)
  .value("AESENCrm", LIEF::assembly::x86::OPCODE::AESENCrm)
  .value("AESENCrr", LIEF::assembly::x86::OPCODE::AESENCrr)
  .value("AESIMCrm", LIEF::assembly::x86::OPCODE::AESIMCrm)
  .value("AESIMCrr", LIEF::assembly::x86::OPCODE::AESIMCrr)
  .value("AESKEYGENASSIST128rm", LIEF::assembly::x86::OPCODE::AESKEYGENASSIST128rm)
  .value("AESKEYGENASSIST128rr", LIEF::assembly::x86::OPCODE::AESKEYGENASSIST128rr)
  .value("AND16i16", LIEF::assembly::x86::OPCODE::AND16i16)
  .value("AND16mi", LIEF::assembly::x86::OPCODE::AND16mi)
  .value("AND16mi8", LIEF::assembly::x86::OPCODE::AND16mi8)
  .value("AND16mi8_EVEX", LIEF::assembly::x86::OPCODE::AND16mi8_EVEX)
  .value("AND16mi8_ND", LIEF::assembly::x86::OPCODE::AND16mi8_ND)
  .value("AND16mi8_NF", LIEF::assembly::x86::OPCODE::AND16mi8_NF)
  .value("AND16mi8_NF_ND", LIEF::assembly::x86::OPCODE::AND16mi8_NF_ND)
  .value("AND16mi_EVEX", LIEF::assembly::x86::OPCODE::AND16mi_EVEX)
  .value("AND16mi_ND", LIEF::assembly::x86::OPCODE::AND16mi_ND)
  .value("AND16mi_NF", LIEF::assembly::x86::OPCODE::AND16mi_NF)
  .value("AND16mi_NF_ND", LIEF::assembly::x86::OPCODE::AND16mi_NF_ND)
  .value("AND16mr", LIEF::assembly::x86::OPCODE::AND16mr)
  .value("AND16mr_EVEX", LIEF::assembly::x86::OPCODE::AND16mr_EVEX)
  .value("AND16mr_ND", LIEF::assembly::x86::OPCODE::AND16mr_ND)
  .value("AND16mr_NF", LIEF::assembly::x86::OPCODE::AND16mr_NF)
  .value("AND16mr_NF_ND", LIEF::assembly::x86::OPCODE::AND16mr_NF_ND)
  .value("AND16ri", LIEF::assembly::x86::OPCODE::AND16ri)
  .value("AND16ri8", LIEF::assembly::x86::OPCODE::AND16ri8)
  .value("AND16ri8_EVEX", LIEF::assembly::x86::OPCODE::AND16ri8_EVEX)
  .value("AND16ri8_ND", LIEF::assembly::x86::OPCODE::AND16ri8_ND)
  .value("AND16ri8_NF", LIEF::assembly::x86::OPCODE::AND16ri8_NF)
  .value("AND16ri8_NF_ND", LIEF::assembly::x86::OPCODE::AND16ri8_NF_ND)
  .value("AND16ri_EVEX", LIEF::assembly::x86::OPCODE::AND16ri_EVEX)
  .value("AND16ri_ND", LIEF::assembly::x86::OPCODE::AND16ri_ND)
  .value("AND16ri_NF", LIEF::assembly::x86::OPCODE::AND16ri_NF)
  .value("AND16ri_NF_ND", LIEF::assembly::x86::OPCODE::AND16ri_NF_ND)
  .value("AND16rm", LIEF::assembly::x86::OPCODE::AND16rm)
  .value("AND16rm_EVEX", LIEF::assembly::x86::OPCODE::AND16rm_EVEX)
  .value("AND16rm_ND", LIEF::assembly::x86::OPCODE::AND16rm_ND)
  .value("AND16rm_NF", LIEF::assembly::x86::OPCODE::AND16rm_NF)
  .value("AND16rm_NF_ND", LIEF::assembly::x86::OPCODE::AND16rm_NF_ND)
  .value("AND16rr", LIEF::assembly::x86::OPCODE::AND16rr)
  .value("AND16rr_EVEX", LIEF::assembly::x86::OPCODE::AND16rr_EVEX)
  .value("AND16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::AND16rr_EVEX_REV)
  .value("AND16rr_ND", LIEF::assembly::x86::OPCODE::AND16rr_ND)
  .value("AND16rr_ND_REV", LIEF::assembly::x86::OPCODE::AND16rr_ND_REV)
  .value("AND16rr_NF", LIEF::assembly::x86::OPCODE::AND16rr_NF)
  .value("AND16rr_NF_ND", LIEF::assembly::x86::OPCODE::AND16rr_NF_ND)
  .value("AND16rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::AND16rr_NF_ND_REV)
  .value("AND16rr_NF_REV", LIEF::assembly::x86::OPCODE::AND16rr_NF_REV)
  .value("AND16rr_REV", LIEF::assembly::x86::OPCODE::AND16rr_REV)
  .value("AND32i32", LIEF::assembly::x86::OPCODE::AND32i32)
  .value("AND32mi", LIEF::assembly::x86::OPCODE::AND32mi)
  .value("AND32mi8", LIEF::assembly::x86::OPCODE::AND32mi8)
  .value("AND32mi8_EVEX", LIEF::assembly::x86::OPCODE::AND32mi8_EVEX)
  .value("AND32mi8_ND", LIEF::assembly::x86::OPCODE::AND32mi8_ND)
  .value("AND32mi8_NF", LIEF::assembly::x86::OPCODE::AND32mi8_NF)
  .value("AND32mi8_NF_ND", LIEF::assembly::x86::OPCODE::AND32mi8_NF_ND)
  .value("AND32mi_EVEX", LIEF::assembly::x86::OPCODE::AND32mi_EVEX)
  .value("AND32mi_ND", LIEF::assembly::x86::OPCODE::AND32mi_ND)
  .value("AND32mi_NF", LIEF::assembly::x86::OPCODE::AND32mi_NF)
  .value("AND32mi_NF_ND", LIEF::assembly::x86::OPCODE::AND32mi_NF_ND)
  .value("AND32mr", LIEF::assembly::x86::OPCODE::AND32mr)
  .value("AND32mr_EVEX", LIEF::assembly::x86::OPCODE::AND32mr_EVEX)
  .value("AND32mr_ND", LIEF::assembly::x86::OPCODE::AND32mr_ND)
  .value("AND32mr_NF", LIEF::assembly::x86::OPCODE::AND32mr_NF)
  .value("AND32mr_NF_ND", LIEF::assembly::x86::OPCODE::AND32mr_NF_ND)
  .value("AND32ri", LIEF::assembly::x86::OPCODE::AND32ri)
  .value("AND32ri8", LIEF::assembly::x86::OPCODE::AND32ri8)
  .value("AND32ri8_EVEX", LIEF::assembly::x86::OPCODE::AND32ri8_EVEX)
  .value("AND32ri8_ND", LIEF::assembly::x86::OPCODE::AND32ri8_ND)
  .value("AND32ri8_NF", LIEF::assembly::x86::OPCODE::AND32ri8_NF)
  .value("AND32ri8_NF_ND", LIEF::assembly::x86::OPCODE::AND32ri8_NF_ND)
  .value("AND32ri_EVEX", LIEF::assembly::x86::OPCODE::AND32ri_EVEX)
  .value("AND32ri_ND", LIEF::assembly::x86::OPCODE::AND32ri_ND)
  .value("AND32ri_NF", LIEF::assembly::x86::OPCODE::AND32ri_NF)
  .value("AND32ri_NF_ND", LIEF::assembly::x86::OPCODE::AND32ri_NF_ND)
  .value("AND32rm", LIEF::assembly::x86::OPCODE::AND32rm)
  .value("AND32rm_EVEX", LIEF::assembly::x86::OPCODE::AND32rm_EVEX)
  .value("AND32rm_ND", LIEF::assembly::x86::OPCODE::AND32rm_ND)
  .value("AND32rm_NF", LIEF::assembly::x86::OPCODE::AND32rm_NF)
  .value("AND32rm_NF_ND", LIEF::assembly::x86::OPCODE::AND32rm_NF_ND)
  .value("AND32rr", LIEF::assembly::x86::OPCODE::AND32rr)
  .value("AND32rr_EVEX", LIEF::assembly::x86::OPCODE::AND32rr_EVEX)
  .value("AND32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::AND32rr_EVEX_REV)
  .value("AND32rr_ND", LIEF::assembly::x86::OPCODE::AND32rr_ND)
  .value("AND32rr_ND_REV", LIEF::assembly::x86::OPCODE::AND32rr_ND_REV)
  .value("AND32rr_NF", LIEF::assembly::x86::OPCODE::AND32rr_NF)
  .value("AND32rr_NF_ND", LIEF::assembly::x86::OPCODE::AND32rr_NF_ND)
  .value("AND32rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::AND32rr_NF_ND_REV)
  .value("AND32rr_NF_REV", LIEF::assembly::x86::OPCODE::AND32rr_NF_REV)
  .value("AND32rr_REV", LIEF::assembly::x86::OPCODE::AND32rr_REV)
  .value("AND64i32", LIEF::assembly::x86::OPCODE::AND64i32)
  .value("AND64mi32", LIEF::assembly::x86::OPCODE::AND64mi32)
  .value("AND64mi32_EVEX", LIEF::assembly::x86::OPCODE::AND64mi32_EVEX)
  .value("AND64mi32_ND", LIEF::assembly::x86::OPCODE::AND64mi32_ND)
  .value("AND64mi32_NF", LIEF::assembly::x86::OPCODE::AND64mi32_NF)
  .value("AND64mi32_NF_ND", LIEF::assembly::x86::OPCODE::AND64mi32_NF_ND)
  .value("AND64mi8", LIEF::assembly::x86::OPCODE::AND64mi8)
  .value("AND64mi8_EVEX", LIEF::assembly::x86::OPCODE::AND64mi8_EVEX)
  .value("AND64mi8_ND", LIEF::assembly::x86::OPCODE::AND64mi8_ND)
  .value("AND64mi8_NF", LIEF::assembly::x86::OPCODE::AND64mi8_NF)
  .value("AND64mi8_NF_ND", LIEF::assembly::x86::OPCODE::AND64mi8_NF_ND)
  .value("AND64mr", LIEF::assembly::x86::OPCODE::AND64mr)
  .value("AND64mr_EVEX", LIEF::assembly::x86::OPCODE::AND64mr_EVEX)
  .value("AND64mr_ND", LIEF::assembly::x86::OPCODE::AND64mr_ND)
  .value("AND64mr_NF", LIEF::assembly::x86::OPCODE::AND64mr_NF)
  .value("AND64mr_NF_ND", LIEF::assembly::x86::OPCODE::AND64mr_NF_ND)
  .value("AND64ri32", LIEF::assembly::x86::OPCODE::AND64ri32)
  .value("AND64ri32_EVEX", LIEF::assembly::x86::OPCODE::AND64ri32_EVEX)
  .value("AND64ri32_ND", LIEF::assembly::x86::OPCODE::AND64ri32_ND)
  .value("AND64ri32_NF", LIEF::assembly::x86::OPCODE::AND64ri32_NF)
  .value("AND64ri32_NF_ND", LIEF::assembly::x86::OPCODE::AND64ri32_NF_ND)
  .value("AND64ri8", LIEF::assembly::x86::OPCODE::AND64ri8)
  .value("AND64ri8_EVEX", LIEF::assembly::x86::OPCODE::AND64ri8_EVEX)
  .value("AND64ri8_ND", LIEF::assembly::x86::OPCODE::AND64ri8_ND)
  .value("AND64ri8_NF", LIEF::assembly::x86::OPCODE::AND64ri8_NF)
  .value("AND64ri8_NF_ND", LIEF::assembly::x86::OPCODE::AND64ri8_NF_ND)
  .value("AND64rm", LIEF::assembly::x86::OPCODE::AND64rm)
  .value("AND64rm_EVEX", LIEF::assembly::x86::OPCODE::AND64rm_EVEX)
  .value("AND64rm_ND", LIEF::assembly::x86::OPCODE::AND64rm_ND)
  .value("AND64rm_NF", LIEF::assembly::x86::OPCODE::AND64rm_NF)
  .value("AND64rm_NF_ND", LIEF::assembly::x86::OPCODE::AND64rm_NF_ND)
  .value("AND64rr", LIEF::assembly::x86::OPCODE::AND64rr)
  .value("AND64rr_EVEX", LIEF::assembly::x86::OPCODE::AND64rr_EVEX)
  .value("AND64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::AND64rr_EVEX_REV);
  opcodes.value("AND64rr_ND", LIEF::assembly::x86::OPCODE::AND64rr_ND)
  .value("AND64rr_ND_REV", LIEF::assembly::x86::OPCODE::AND64rr_ND_REV)
  .value("AND64rr_NF", LIEF::assembly::x86::OPCODE::AND64rr_NF)
  .value("AND64rr_NF_ND", LIEF::assembly::x86::OPCODE::AND64rr_NF_ND)
  .value("AND64rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::AND64rr_NF_ND_REV)
  .value("AND64rr_NF_REV", LIEF::assembly::x86::OPCODE::AND64rr_NF_REV)
  .value("AND64rr_REV", LIEF::assembly::x86::OPCODE::AND64rr_REV)
  .value("AND8i8", LIEF::assembly::x86::OPCODE::AND8i8)
  .value("AND8mi", LIEF::assembly::x86::OPCODE::AND8mi)
  .value("AND8mi8", LIEF::assembly::x86::OPCODE::AND8mi8)
  .value("AND8mi_EVEX", LIEF::assembly::x86::OPCODE::AND8mi_EVEX)
  .value("AND8mi_ND", LIEF::assembly::x86::OPCODE::AND8mi_ND)
  .value("AND8mi_NF", LIEF::assembly::x86::OPCODE::AND8mi_NF)
  .value("AND8mi_NF_ND", LIEF::assembly::x86::OPCODE::AND8mi_NF_ND)
  .value("AND8mr", LIEF::assembly::x86::OPCODE::AND8mr)
  .value("AND8mr_EVEX", LIEF::assembly::x86::OPCODE::AND8mr_EVEX)
  .value("AND8mr_ND", LIEF::assembly::x86::OPCODE::AND8mr_ND)
  .value("AND8mr_NF", LIEF::assembly::x86::OPCODE::AND8mr_NF)
  .value("AND8mr_NF_ND", LIEF::assembly::x86::OPCODE::AND8mr_NF_ND)
  .value("AND8ri", LIEF::assembly::x86::OPCODE::AND8ri)
  .value("AND8ri8", LIEF::assembly::x86::OPCODE::AND8ri8)
  .value("AND8ri_EVEX", LIEF::assembly::x86::OPCODE::AND8ri_EVEX)
  .value("AND8ri_ND", LIEF::assembly::x86::OPCODE::AND8ri_ND)
  .value("AND8ri_NF", LIEF::assembly::x86::OPCODE::AND8ri_NF)
  .value("AND8ri_NF_ND", LIEF::assembly::x86::OPCODE::AND8ri_NF_ND)
  .value("AND8rm", LIEF::assembly::x86::OPCODE::AND8rm)
  .value("AND8rm_EVEX", LIEF::assembly::x86::OPCODE::AND8rm_EVEX)
  .value("AND8rm_ND", LIEF::assembly::x86::OPCODE::AND8rm_ND)
  .value("AND8rm_NF", LIEF::assembly::x86::OPCODE::AND8rm_NF)
  .value("AND8rm_NF_ND", LIEF::assembly::x86::OPCODE::AND8rm_NF_ND)
  .value("AND8rr", LIEF::assembly::x86::OPCODE::AND8rr)
  .value("AND8rr_EVEX", LIEF::assembly::x86::OPCODE::AND8rr_EVEX)
  .value("AND8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::AND8rr_EVEX_REV)
  .value("AND8rr_ND", LIEF::assembly::x86::OPCODE::AND8rr_ND)
  .value("AND8rr_ND_REV", LIEF::assembly::x86::OPCODE::AND8rr_ND_REV)
  .value("AND8rr_NF", LIEF::assembly::x86::OPCODE::AND8rr_NF)
  .value("AND8rr_NF_ND", LIEF::assembly::x86::OPCODE::AND8rr_NF_ND)
  .value("AND8rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::AND8rr_NF_ND_REV)
  .value("AND8rr_NF_REV", LIEF::assembly::x86::OPCODE::AND8rr_NF_REV)
  .value("AND8rr_REV", LIEF::assembly::x86::OPCODE::AND8rr_REV)
  .value("ANDN32rm", LIEF::assembly::x86::OPCODE::ANDN32rm)
  .value("ANDN32rm_EVEX", LIEF::assembly::x86::OPCODE::ANDN32rm_EVEX)
  .value("ANDN32rm_NF", LIEF::assembly::x86::OPCODE::ANDN32rm_NF)
  .value("ANDN32rr", LIEF::assembly::x86::OPCODE::ANDN32rr)
  .value("ANDN32rr_EVEX", LIEF::assembly::x86::OPCODE::ANDN32rr_EVEX)
  .value("ANDN32rr_NF", LIEF::assembly::x86::OPCODE::ANDN32rr_NF)
  .value("ANDN64rm", LIEF::assembly::x86::OPCODE::ANDN64rm)
  .value("ANDN64rm_EVEX", LIEF::assembly::x86::OPCODE::ANDN64rm_EVEX)
  .value("ANDN64rm_NF", LIEF::assembly::x86::OPCODE::ANDN64rm_NF)
  .value("ANDN64rr", LIEF::assembly::x86::OPCODE::ANDN64rr)
  .value("ANDN64rr_EVEX", LIEF::assembly::x86::OPCODE::ANDN64rr_EVEX)
  .value("ANDN64rr_NF", LIEF::assembly::x86::OPCODE::ANDN64rr_NF)
  .value("ANDNPDrm", LIEF::assembly::x86::OPCODE::ANDNPDrm)
  .value("ANDNPDrr", LIEF::assembly::x86::OPCODE::ANDNPDrr)
  .value("ANDNPSrm", LIEF::assembly::x86::OPCODE::ANDNPSrm)
  .value("ANDNPSrr", LIEF::assembly::x86::OPCODE::ANDNPSrr)
  .value("ANDPDrm", LIEF::assembly::x86::OPCODE::ANDPDrm)
  .value("ANDPDrr", LIEF::assembly::x86::OPCODE::ANDPDrr)
  .value("ANDPSrm", LIEF::assembly::x86::OPCODE::ANDPSrm)
  .value("ANDPSrr", LIEF::assembly::x86::OPCODE::ANDPSrr)
  .value("AOR32mr", LIEF::assembly::x86::OPCODE::AOR32mr)
  .value("AOR32mr_EVEX", LIEF::assembly::x86::OPCODE::AOR32mr_EVEX)
  .value("AOR64mr", LIEF::assembly::x86::OPCODE::AOR64mr)
  .value("AOR64mr_EVEX", LIEF::assembly::x86::OPCODE::AOR64mr_EVEX)
  .value("ARPL16mr", LIEF::assembly::x86::OPCODE::ARPL16mr)
  .value("ARPL16rr", LIEF::assembly::x86::OPCODE::ARPL16rr)
  .value("ASAN_CHECK_MEMACCESS", LIEF::assembly::x86::OPCODE::ASAN_CHECK_MEMACCESS)
  .value("AXOR32mr", LIEF::assembly::x86::OPCODE::AXOR32mr)
  .value("AXOR32mr_EVEX", LIEF::assembly::x86::OPCODE::AXOR32mr_EVEX)
  .value("AXOR64mr", LIEF::assembly::x86::OPCODE::AXOR64mr)
  .value("AXOR64mr_EVEX", LIEF::assembly::x86::OPCODE::AXOR64mr_EVEX)
  .value("BEXTR32rm", LIEF::assembly::x86::OPCODE::BEXTR32rm)
  .value("BEXTR32rm_EVEX", LIEF::assembly::x86::OPCODE::BEXTR32rm_EVEX)
  .value("BEXTR32rm_NF", LIEF::assembly::x86::OPCODE::BEXTR32rm_NF)
  .value("BEXTR32rr", LIEF::assembly::x86::OPCODE::BEXTR32rr)
  .value("BEXTR32rr_EVEX", LIEF::assembly::x86::OPCODE::BEXTR32rr_EVEX)
  .value("BEXTR32rr_NF", LIEF::assembly::x86::OPCODE::BEXTR32rr_NF)
  .value("BEXTR64rm", LIEF::assembly::x86::OPCODE::BEXTR64rm)
  .value("BEXTR64rm_EVEX", LIEF::assembly::x86::OPCODE::BEXTR64rm_EVEX)
  .value("BEXTR64rm_NF", LIEF::assembly::x86::OPCODE::BEXTR64rm_NF)
  .value("BEXTR64rr", LIEF::assembly::x86::OPCODE::BEXTR64rr)
  .value("BEXTR64rr_EVEX", LIEF::assembly::x86::OPCODE::BEXTR64rr_EVEX)
  .value("BEXTR64rr_NF", LIEF::assembly::x86::OPCODE::BEXTR64rr_NF)
  .value("BEXTRI32mi", LIEF::assembly::x86::OPCODE::BEXTRI32mi)
  .value("BEXTRI32ri", LIEF::assembly::x86::OPCODE::BEXTRI32ri)
  .value("BEXTRI64mi", LIEF::assembly::x86::OPCODE::BEXTRI64mi)
  .value("BEXTRI64ri", LIEF::assembly::x86::OPCODE::BEXTRI64ri)
  .value("BLCFILL32rm", LIEF::assembly::x86::OPCODE::BLCFILL32rm)
  .value("BLCFILL32rr", LIEF::assembly::x86::OPCODE::BLCFILL32rr)
  .value("BLCFILL64rm", LIEF::assembly::x86::OPCODE::BLCFILL64rm)
  .value("BLCFILL64rr", LIEF::assembly::x86::OPCODE::BLCFILL64rr)
  .value("BLCI32rm", LIEF::assembly::x86::OPCODE::BLCI32rm)
  .value("BLCI32rr", LIEF::assembly::x86::OPCODE::BLCI32rr)
  .value("BLCI64rm", LIEF::assembly::x86::OPCODE::BLCI64rm)
  .value("BLCI64rr", LIEF::assembly::x86::OPCODE::BLCI64rr)
  .value("BLCIC32rm", LIEF::assembly::x86::OPCODE::BLCIC32rm)
  .value("BLCIC32rr", LIEF::assembly::x86::OPCODE::BLCIC32rr)
  .value("BLCIC64rm", LIEF::assembly::x86::OPCODE::BLCIC64rm)
  .value("BLCIC64rr", LIEF::assembly::x86::OPCODE::BLCIC64rr)
  .value("BLCMSK32rm", LIEF::assembly::x86::OPCODE::BLCMSK32rm)
  .value("BLCMSK32rr", LIEF::assembly::x86::OPCODE::BLCMSK32rr)
  .value("BLCMSK64rm", LIEF::assembly::x86::OPCODE::BLCMSK64rm)
  .value("BLCMSK64rr", LIEF::assembly::x86::OPCODE::BLCMSK64rr)
  .value("BLCS32rm", LIEF::assembly::x86::OPCODE::BLCS32rm)
  .value("BLCS32rr", LIEF::assembly::x86::OPCODE::BLCS32rr)
  .value("BLCS64rm", LIEF::assembly::x86::OPCODE::BLCS64rm)
  .value("BLCS64rr", LIEF::assembly::x86::OPCODE::BLCS64rr)
  .value("BLENDPDrmi", LIEF::assembly::x86::OPCODE::BLENDPDrmi)
  .value("BLENDPDrri", LIEF::assembly::x86::OPCODE::BLENDPDrri)
  .value("BLENDPSrmi", LIEF::assembly::x86::OPCODE::BLENDPSrmi)
  .value("BLENDPSrri", LIEF::assembly::x86::OPCODE::BLENDPSrri)
  .value("BLENDVPDrm0", LIEF::assembly::x86::OPCODE::BLENDVPDrm0)
  .value("BLENDVPDrr0", LIEF::assembly::x86::OPCODE::BLENDVPDrr0)
  .value("BLENDVPSrm0", LIEF::assembly::x86::OPCODE::BLENDVPSrm0)
  .value("BLENDVPSrr0", LIEF::assembly::x86::OPCODE::BLENDVPSrr0)
  .value("BLSFILL32rm", LIEF::assembly::x86::OPCODE::BLSFILL32rm)
  .value("BLSFILL32rr", LIEF::assembly::x86::OPCODE::BLSFILL32rr)
  .value("BLSFILL64rm", LIEF::assembly::x86::OPCODE::BLSFILL64rm)
  .value("BLSFILL64rr", LIEF::assembly::x86::OPCODE::BLSFILL64rr)
  .value("BLSI32rm", LIEF::assembly::x86::OPCODE::BLSI32rm)
  .value("BLSI32rm_EVEX", LIEF::assembly::x86::OPCODE::BLSI32rm_EVEX)
  .value("BLSI32rm_NF", LIEF::assembly::x86::OPCODE::BLSI32rm_NF)
  .value("BLSI32rr", LIEF::assembly::x86::OPCODE::BLSI32rr)
  .value("BLSI32rr_EVEX", LIEF::assembly::x86::OPCODE::BLSI32rr_EVEX)
  .value("BLSI32rr_NF", LIEF::assembly::x86::OPCODE::BLSI32rr_NF)
  .value("BLSI64rm", LIEF::assembly::x86::OPCODE::BLSI64rm)
  .value("BLSI64rm_EVEX", LIEF::assembly::x86::OPCODE::BLSI64rm_EVEX)
  .value("BLSI64rm_NF", LIEF::assembly::x86::OPCODE::BLSI64rm_NF)
  .value("BLSI64rr", LIEF::assembly::x86::OPCODE::BLSI64rr)
  .value("BLSI64rr_EVEX", LIEF::assembly::x86::OPCODE::BLSI64rr_EVEX)
  .value("BLSI64rr_NF", LIEF::assembly::x86::OPCODE::BLSI64rr_NF)
  .value("BLSIC32rm", LIEF::assembly::x86::OPCODE::BLSIC32rm)
  .value("BLSIC32rr", LIEF::assembly::x86::OPCODE::BLSIC32rr)
  .value("BLSIC64rm", LIEF::assembly::x86::OPCODE::BLSIC64rm)
  .value("BLSIC64rr", LIEF::assembly::x86::OPCODE::BLSIC64rr)
  .value("BLSMSK32rm", LIEF::assembly::x86::OPCODE::BLSMSK32rm)
  .value("BLSMSK32rm_EVEX", LIEF::assembly::x86::OPCODE::BLSMSK32rm_EVEX)
  .value("BLSMSK32rm_NF", LIEF::assembly::x86::OPCODE::BLSMSK32rm_NF)
  .value("BLSMSK32rr", LIEF::assembly::x86::OPCODE::BLSMSK32rr)
  .value("BLSMSK32rr_EVEX", LIEF::assembly::x86::OPCODE::BLSMSK32rr_EVEX)
  .value("BLSMSK32rr_NF", LIEF::assembly::x86::OPCODE::BLSMSK32rr_NF)
  .value("BLSMSK64rm", LIEF::assembly::x86::OPCODE::BLSMSK64rm)
  .value("BLSMSK64rm_EVEX", LIEF::assembly::x86::OPCODE::BLSMSK64rm_EVEX)
  .value("BLSMSK64rm_NF", LIEF::assembly::x86::OPCODE::BLSMSK64rm_NF)
  .value("BLSMSK64rr", LIEF::assembly::x86::OPCODE::BLSMSK64rr)
  .value("BLSMSK64rr_EVEX", LIEF::assembly::x86::OPCODE::BLSMSK64rr_EVEX)
  .value("BLSMSK64rr_NF", LIEF::assembly::x86::OPCODE::BLSMSK64rr_NF)
  .value("BLSR32rm", LIEF::assembly::x86::OPCODE::BLSR32rm)
  .value("BLSR32rm_EVEX", LIEF::assembly::x86::OPCODE::BLSR32rm_EVEX)
  .value("BLSR32rm_NF", LIEF::assembly::x86::OPCODE::BLSR32rm_NF)
  .value("BLSR32rr", LIEF::assembly::x86::OPCODE::BLSR32rr)
  .value("BLSR32rr_EVEX", LIEF::assembly::x86::OPCODE::BLSR32rr_EVEX)
  .value("BLSR32rr_NF", LIEF::assembly::x86::OPCODE::BLSR32rr_NF)
  .value("BLSR64rm", LIEF::assembly::x86::OPCODE::BLSR64rm)
  .value("BLSR64rm_EVEX", LIEF::assembly::x86::OPCODE::BLSR64rm_EVEX)
  .value("BLSR64rm_NF", LIEF::assembly::x86::OPCODE::BLSR64rm_NF)
  .value("BLSR64rr", LIEF::assembly::x86::OPCODE::BLSR64rr)
  .value("BLSR64rr_EVEX", LIEF::assembly::x86::OPCODE::BLSR64rr_EVEX)
  .value("BLSR64rr_NF", LIEF::assembly::x86::OPCODE::BLSR64rr_NF)
  .value("BOUNDS16rm", LIEF::assembly::x86::OPCODE::BOUNDS16rm)
  .value("BOUNDS32rm", LIEF::assembly::x86::OPCODE::BOUNDS32rm)
  .value("BSF16rm", LIEF::assembly::x86::OPCODE::BSF16rm)
  .value("BSF16rr", LIEF::assembly::x86::OPCODE::BSF16rr)
  .value("BSF32rm", LIEF::assembly::x86::OPCODE::BSF32rm)
  .value("BSF32rr", LIEF::assembly::x86::OPCODE::BSF32rr)
  .value("BSF64rm", LIEF::assembly::x86::OPCODE::BSF64rm)
  .value("BSF64rr", LIEF::assembly::x86::OPCODE::BSF64rr)
  .value("BSR16rm", LIEF::assembly::x86::OPCODE::BSR16rm)
  .value("BSR16rr", LIEF::assembly::x86::OPCODE::BSR16rr)
  .value("BSR32rm", LIEF::assembly::x86::OPCODE::BSR32rm)
  .value("BSR32rr", LIEF::assembly::x86::OPCODE::BSR32rr)
  .value("BSR64rm", LIEF::assembly::x86::OPCODE::BSR64rm)
  .value("BSR64rr", LIEF::assembly::x86::OPCODE::BSR64rr)
  .value("BSWAP16r_BAD", LIEF::assembly::x86::OPCODE::BSWAP16r_BAD)
  .value("BSWAP32r", LIEF::assembly::x86::OPCODE::BSWAP32r)
  .value("BSWAP64r", LIEF::assembly::x86::OPCODE::BSWAP64r)
  .value("BT16mi8", LIEF::assembly::x86::OPCODE::BT16mi8)
  .value("BT16mr", LIEF::assembly::x86::OPCODE::BT16mr)
  .value("BT16ri8", LIEF::assembly::x86::OPCODE::BT16ri8)
  .value("BT16rr", LIEF::assembly::x86::OPCODE::BT16rr)
  .value("BT32mi8", LIEF::assembly::x86::OPCODE::BT32mi8)
  .value("BT32mr", LIEF::assembly::x86::OPCODE::BT32mr)
  .value("BT32ri8", LIEF::assembly::x86::OPCODE::BT32ri8)
  .value("BT32rr", LIEF::assembly::x86::OPCODE::BT32rr)
  .value("BT64mi8", LIEF::assembly::x86::OPCODE::BT64mi8)
  .value("BT64mr", LIEF::assembly::x86::OPCODE::BT64mr)
  .value("BT64ri8", LIEF::assembly::x86::OPCODE::BT64ri8)
  .value("BT64rr", LIEF::assembly::x86::OPCODE::BT64rr)
  .value("BTC16mi8", LIEF::assembly::x86::OPCODE::BTC16mi8)
  .value("BTC16mr", LIEF::assembly::x86::OPCODE::BTC16mr)
  .value("BTC16ri8", LIEF::assembly::x86::OPCODE::BTC16ri8)
  .value("BTC16rr", LIEF::assembly::x86::OPCODE::BTC16rr)
  .value("BTC32mi8", LIEF::assembly::x86::OPCODE::BTC32mi8)
  .value("BTC32mr", LIEF::assembly::x86::OPCODE::BTC32mr)
  .value("BTC32ri8", LIEF::assembly::x86::OPCODE::BTC32ri8)
  .value("BTC32rr", LIEF::assembly::x86::OPCODE::BTC32rr)
  .value("BTC64mi8", LIEF::assembly::x86::OPCODE::BTC64mi8)
  .value("BTC64mr", LIEF::assembly::x86::OPCODE::BTC64mr)
  .value("BTC64ri8", LIEF::assembly::x86::OPCODE::BTC64ri8)
  .value("BTC64rr", LIEF::assembly::x86::OPCODE::BTC64rr)
  .value("BTR16mi8", LIEF::assembly::x86::OPCODE::BTR16mi8)
  .value("BTR16mr", LIEF::assembly::x86::OPCODE::BTR16mr)
  .value("BTR16ri8", LIEF::assembly::x86::OPCODE::BTR16ri8)
  .value("BTR16rr", LIEF::assembly::x86::OPCODE::BTR16rr)
  .value("BTR32mi8", LIEF::assembly::x86::OPCODE::BTR32mi8)
  .value("BTR32mr", LIEF::assembly::x86::OPCODE::BTR32mr)
  .value("BTR32ri8", LIEF::assembly::x86::OPCODE::BTR32ri8)
  .value("BTR32rr", LIEF::assembly::x86::OPCODE::BTR32rr)
  .value("BTR64mi8", LIEF::assembly::x86::OPCODE::BTR64mi8)
  .value("BTR64mr", LIEF::assembly::x86::OPCODE::BTR64mr)
  .value("BTR64ri8", LIEF::assembly::x86::OPCODE::BTR64ri8)
  .value("BTR64rr", LIEF::assembly::x86::OPCODE::BTR64rr)
  .value("BTS16mi8", LIEF::assembly::x86::OPCODE::BTS16mi8)
  .value("BTS16mr", LIEF::assembly::x86::OPCODE::BTS16mr)
  .value("BTS16ri8", LIEF::assembly::x86::OPCODE::BTS16ri8)
  .value("BTS16rr", LIEF::assembly::x86::OPCODE::BTS16rr)
  .value("BTS32mi8", LIEF::assembly::x86::OPCODE::BTS32mi8)
  .value("BTS32mr", LIEF::assembly::x86::OPCODE::BTS32mr)
  .value("BTS32ri8", LIEF::assembly::x86::OPCODE::BTS32ri8)
  .value("BTS32rr", LIEF::assembly::x86::OPCODE::BTS32rr)
  .value("BTS64mi8", LIEF::assembly::x86::OPCODE::BTS64mi8)
  .value("BTS64mr", LIEF::assembly::x86::OPCODE::BTS64mr)
  .value("BTS64ri8", LIEF::assembly::x86::OPCODE::BTS64ri8)
  .value("BTS64rr", LIEF::assembly::x86::OPCODE::BTS64rr)
  .value("BZHI32rm", LIEF::assembly::x86::OPCODE::BZHI32rm)
  .value("BZHI32rm_EVEX", LIEF::assembly::x86::OPCODE::BZHI32rm_EVEX)
  .value("BZHI32rm_NF", LIEF::assembly::x86::OPCODE::BZHI32rm_NF)
  .value("BZHI32rr", LIEF::assembly::x86::OPCODE::BZHI32rr)
  .value("BZHI32rr_EVEX", LIEF::assembly::x86::OPCODE::BZHI32rr_EVEX)
  .value("BZHI32rr_NF", LIEF::assembly::x86::OPCODE::BZHI32rr_NF)
  .value("BZHI64rm", LIEF::assembly::x86::OPCODE::BZHI64rm)
  .value("BZHI64rm_EVEX", LIEF::assembly::x86::OPCODE::BZHI64rm_EVEX)
  .value("BZHI64rm_NF", LIEF::assembly::x86::OPCODE::BZHI64rm_NF)
  .value("BZHI64rr", LIEF::assembly::x86::OPCODE::BZHI64rr)
  .value("BZHI64rr_EVEX", LIEF::assembly::x86::OPCODE::BZHI64rr_EVEX)
  .value("BZHI64rr_NF", LIEF::assembly::x86::OPCODE::BZHI64rr_NF)
  .value("CALL16m", LIEF::assembly::x86::OPCODE::CALL16m)
  .value("CALL16m_NT", LIEF::assembly::x86::OPCODE::CALL16m_NT)
  .value("CALL16r", LIEF::assembly::x86::OPCODE::CALL16r)
  .value("CALL16r_NT", LIEF::assembly::x86::OPCODE::CALL16r_NT)
  .value("CALL32m", LIEF::assembly::x86::OPCODE::CALL32m)
  .value("CALL32m_NT", LIEF::assembly::x86::OPCODE::CALL32m_NT)
  .value("CALL32r", LIEF::assembly::x86::OPCODE::CALL32r)
  .value("CALL32r_NT", LIEF::assembly::x86::OPCODE::CALL32r_NT)
  .value("CALL64m", LIEF::assembly::x86::OPCODE::CALL64m)
  .value("CALL64m_NT", LIEF::assembly::x86::OPCODE::CALL64m_NT)
  .value("CALL64pcrel32", LIEF::assembly::x86::OPCODE::CALL64pcrel32)
  .value("CALL64r", LIEF::assembly::x86::OPCODE::CALL64r)
  .value("CALL64r_NT", LIEF::assembly::x86::OPCODE::CALL64r_NT)
  .value("CALLpcrel16", LIEF::assembly::x86::OPCODE::CALLpcrel16)
  .value("CALLpcrel32", LIEF::assembly::x86::OPCODE::CALLpcrel32)
  .value("CATCHRET", LIEF::assembly::x86::OPCODE::CATCHRET)
  .value("CBW", LIEF::assembly::x86::OPCODE::CBW)
  .value("CCMP16mi", LIEF::assembly::x86::OPCODE::CCMP16mi)
  .value("CCMP16mi8", LIEF::assembly::x86::OPCODE::CCMP16mi8)
  .value("CCMP16mr", LIEF::assembly::x86::OPCODE::CCMP16mr)
  .value("CCMP16ri", LIEF::assembly::x86::OPCODE::CCMP16ri)
  .value("CCMP16ri8", LIEF::assembly::x86::OPCODE::CCMP16ri8)
  .value("CCMP16rm", LIEF::assembly::x86::OPCODE::CCMP16rm)
  .value("CCMP16rr", LIEF::assembly::x86::OPCODE::CCMP16rr)
  .value("CCMP16rr_REV", LIEF::assembly::x86::OPCODE::CCMP16rr_REV)
  .value("CCMP32mi", LIEF::assembly::x86::OPCODE::CCMP32mi)
  .value("CCMP32mi8", LIEF::assembly::x86::OPCODE::CCMP32mi8)
  .value("CCMP32mr", LIEF::assembly::x86::OPCODE::CCMP32mr)
  .value("CCMP32ri", LIEF::assembly::x86::OPCODE::CCMP32ri)
  .value("CCMP32ri8", LIEF::assembly::x86::OPCODE::CCMP32ri8)
  .value("CCMP32rm", LIEF::assembly::x86::OPCODE::CCMP32rm)
  .value("CCMP32rr", LIEF::assembly::x86::OPCODE::CCMP32rr)
  .value("CCMP32rr_REV", LIEF::assembly::x86::OPCODE::CCMP32rr_REV)
  .value("CCMP64mi32", LIEF::assembly::x86::OPCODE::CCMP64mi32)
  .value("CCMP64mi8", LIEF::assembly::x86::OPCODE::CCMP64mi8)
  .value("CCMP64mr", LIEF::assembly::x86::OPCODE::CCMP64mr)
  .value("CCMP64ri32", LIEF::assembly::x86::OPCODE::CCMP64ri32)
  .value("CCMP64ri8", LIEF::assembly::x86::OPCODE::CCMP64ri8)
  .value("CCMP64rm", LIEF::assembly::x86::OPCODE::CCMP64rm)
  .value("CCMP64rr", LIEF::assembly::x86::OPCODE::CCMP64rr)
  .value("CCMP64rr_REV", LIEF::assembly::x86::OPCODE::CCMP64rr_REV)
  .value("CCMP8mi", LIEF::assembly::x86::OPCODE::CCMP8mi)
  .value("CCMP8mr", LIEF::assembly::x86::OPCODE::CCMP8mr)
  .value("CCMP8ri", LIEF::assembly::x86::OPCODE::CCMP8ri)
  .value("CCMP8rm", LIEF::assembly::x86::OPCODE::CCMP8rm)
  .value("CCMP8rr", LIEF::assembly::x86::OPCODE::CCMP8rr)
  .value("CCMP8rr_REV", LIEF::assembly::x86::OPCODE::CCMP8rr_REV)
  .value("CDQ", LIEF::assembly::x86::OPCODE::CDQ)
  .value("CDQE", LIEF::assembly::x86::OPCODE::CDQE)
  .value("CFCMOV16mr", LIEF::assembly::x86::OPCODE::CFCMOV16mr)
  .value("CFCMOV16rm", LIEF::assembly::x86::OPCODE::CFCMOV16rm)
  .value("CFCMOV16rm_ND", LIEF::assembly::x86::OPCODE::CFCMOV16rm_ND)
  .value("CFCMOV16rr", LIEF::assembly::x86::OPCODE::CFCMOV16rr)
  .value("CFCMOV16rr_ND", LIEF::assembly::x86::OPCODE::CFCMOV16rr_ND)
  .value("CFCMOV16rr_REV", LIEF::assembly::x86::OPCODE::CFCMOV16rr_REV)
  .value("CFCMOV32mr", LIEF::assembly::x86::OPCODE::CFCMOV32mr)
  .value("CFCMOV32rm", LIEF::assembly::x86::OPCODE::CFCMOV32rm)
  .value("CFCMOV32rm_ND", LIEF::assembly::x86::OPCODE::CFCMOV32rm_ND)
  .value("CFCMOV32rr", LIEF::assembly::x86::OPCODE::CFCMOV32rr)
  .value("CFCMOV32rr_ND", LIEF::assembly::x86::OPCODE::CFCMOV32rr_ND)
  .value("CFCMOV32rr_REV", LIEF::assembly::x86::OPCODE::CFCMOV32rr_REV)
  .value("CFCMOV64mr", LIEF::assembly::x86::OPCODE::CFCMOV64mr)
  .value("CFCMOV64rm", LIEF::assembly::x86::OPCODE::CFCMOV64rm)
  .value("CFCMOV64rm_ND", LIEF::assembly::x86::OPCODE::CFCMOV64rm_ND);
  opcodes.value("CFCMOV64rr", LIEF::assembly::x86::OPCODE::CFCMOV64rr)
  .value("CFCMOV64rr_ND", LIEF::assembly::x86::OPCODE::CFCMOV64rr_ND)
  .value("CFCMOV64rr_REV", LIEF::assembly::x86::OPCODE::CFCMOV64rr_REV)
  .value("CHS_F", LIEF::assembly::x86::OPCODE::CHS_F)
  .value("CHS_Fp32", LIEF::assembly::x86::OPCODE::CHS_Fp32)
  .value("CHS_Fp64", LIEF::assembly::x86::OPCODE::CHS_Fp64)
  .value("CHS_Fp80", LIEF::assembly::x86::OPCODE::CHS_Fp80)
  .value("CLAC", LIEF::assembly::x86::OPCODE::CLAC)
  .value("CLC", LIEF::assembly::x86::OPCODE::CLC)
  .value("CLD", LIEF::assembly::x86::OPCODE::CLD)
  .value("CLDEMOTE", LIEF::assembly::x86::OPCODE::CLDEMOTE)
  .value("CLEANUPRET", LIEF::assembly::x86::OPCODE::CLEANUPRET)
  .value("CLFLUSH", LIEF::assembly::x86::OPCODE::CLFLUSH)
  .value("CLFLUSHOPT", LIEF::assembly::x86::OPCODE::CLFLUSHOPT)
  .value("CLGI", LIEF::assembly::x86::OPCODE::CLGI)
  .value("CLI", LIEF::assembly::x86::OPCODE::CLI)
  .value("CLRSSBSY", LIEF::assembly::x86::OPCODE::CLRSSBSY)
  .value("CLTS", LIEF::assembly::x86::OPCODE::CLTS)
  .value("CLUI", LIEF::assembly::x86::OPCODE::CLUI)
  .value("CLWB", LIEF::assembly::x86::OPCODE::CLWB)
  .value("CLZERO32r", LIEF::assembly::x86::OPCODE::CLZERO32r)
  .value("CLZERO64r", LIEF::assembly::x86::OPCODE::CLZERO64r)
  .value("CMC", LIEF::assembly::x86::OPCODE::CMC)
  .value("CMOV16rm", LIEF::assembly::x86::OPCODE::CMOV16rm)
  .value("CMOV16rm_ND", LIEF::assembly::x86::OPCODE::CMOV16rm_ND)
  .value("CMOV16rr", LIEF::assembly::x86::OPCODE::CMOV16rr)
  .value("CMOV16rr_ND", LIEF::assembly::x86::OPCODE::CMOV16rr_ND)
  .value("CMOV32rm", LIEF::assembly::x86::OPCODE::CMOV32rm)
  .value("CMOV32rm_ND", LIEF::assembly::x86::OPCODE::CMOV32rm_ND)
  .value("CMOV32rr", LIEF::assembly::x86::OPCODE::CMOV32rr)
  .value("CMOV32rr_ND", LIEF::assembly::x86::OPCODE::CMOV32rr_ND)
  .value("CMOV64rm", LIEF::assembly::x86::OPCODE::CMOV64rm)
  .value("CMOV64rm_ND", LIEF::assembly::x86::OPCODE::CMOV64rm_ND)
  .value("CMOV64rr", LIEF::assembly::x86::OPCODE::CMOV64rr)
  .value("CMOV64rr_ND", LIEF::assembly::x86::OPCODE::CMOV64rr_ND)
  .value("CMOVBE_F", LIEF::assembly::x86::OPCODE::CMOVBE_F)
  .value("CMOVBE_Fp32", LIEF::assembly::x86::OPCODE::CMOVBE_Fp32)
  .value("CMOVBE_Fp64", LIEF::assembly::x86::OPCODE::CMOVBE_Fp64)
  .value("CMOVBE_Fp80", LIEF::assembly::x86::OPCODE::CMOVBE_Fp80)
  .value("CMOVB_F", LIEF::assembly::x86::OPCODE::CMOVB_F)
  .value("CMOVB_Fp32", LIEF::assembly::x86::OPCODE::CMOVB_Fp32)
  .value("CMOVB_Fp64", LIEF::assembly::x86::OPCODE::CMOVB_Fp64)
  .value("CMOVB_Fp80", LIEF::assembly::x86::OPCODE::CMOVB_Fp80)
  .value("CMOVE_F", LIEF::assembly::x86::OPCODE::CMOVE_F)
  .value("CMOVE_Fp32", LIEF::assembly::x86::OPCODE::CMOVE_Fp32)
  .value("CMOVE_Fp64", LIEF::assembly::x86::OPCODE::CMOVE_Fp64)
  .value("CMOVE_Fp80", LIEF::assembly::x86::OPCODE::CMOVE_Fp80)
  .value("CMOVNBE_F", LIEF::assembly::x86::OPCODE::CMOVNBE_F)
  .value("CMOVNBE_Fp32", LIEF::assembly::x86::OPCODE::CMOVNBE_Fp32)
  .value("CMOVNBE_Fp64", LIEF::assembly::x86::OPCODE::CMOVNBE_Fp64)
  .value("CMOVNBE_Fp80", LIEF::assembly::x86::OPCODE::CMOVNBE_Fp80)
  .value("CMOVNB_F", LIEF::assembly::x86::OPCODE::CMOVNB_F)
  .value("CMOVNB_Fp32", LIEF::assembly::x86::OPCODE::CMOVNB_Fp32)
  .value("CMOVNB_Fp64", LIEF::assembly::x86::OPCODE::CMOVNB_Fp64)
  .value("CMOVNB_Fp80", LIEF::assembly::x86::OPCODE::CMOVNB_Fp80)
  .value("CMOVNE_F", LIEF::assembly::x86::OPCODE::CMOVNE_F)
  .value("CMOVNE_Fp32", LIEF::assembly::x86::OPCODE::CMOVNE_Fp32)
  .value("CMOVNE_Fp64", LIEF::assembly::x86::OPCODE::CMOVNE_Fp64)
  .value("CMOVNE_Fp80", LIEF::assembly::x86::OPCODE::CMOVNE_Fp80)
  .value("CMOVNP_F", LIEF::assembly::x86::OPCODE::CMOVNP_F)
  .value("CMOVNP_Fp32", LIEF::assembly::x86::OPCODE::CMOVNP_Fp32)
  .value("CMOVNP_Fp64", LIEF::assembly::x86::OPCODE::CMOVNP_Fp64)
  .value("CMOVNP_Fp80", LIEF::assembly::x86::OPCODE::CMOVNP_Fp80)
  .value("CMOVP_F", LIEF::assembly::x86::OPCODE::CMOVP_F)
  .value("CMOVP_Fp32", LIEF::assembly::x86::OPCODE::CMOVP_Fp32)
  .value("CMOVP_Fp64", LIEF::assembly::x86::OPCODE::CMOVP_Fp64)
  .value("CMOVP_Fp80", LIEF::assembly::x86::OPCODE::CMOVP_Fp80)
  .value("CMOV_FR16", LIEF::assembly::x86::OPCODE::CMOV_FR16)
  .value("CMOV_FR16X", LIEF::assembly::x86::OPCODE::CMOV_FR16X)
  .value("CMOV_FR32", LIEF::assembly::x86::OPCODE::CMOV_FR32)
  .value("CMOV_FR32X", LIEF::assembly::x86::OPCODE::CMOV_FR32X)
  .value("CMOV_FR64", LIEF::assembly::x86::OPCODE::CMOV_FR64)
  .value("CMOV_FR64X", LIEF::assembly::x86::OPCODE::CMOV_FR64X)
  .value("CMOV_GR16", LIEF::assembly::x86::OPCODE::CMOV_GR16)
  .value("CMOV_GR32", LIEF::assembly::x86::OPCODE::CMOV_GR32)
  .value("CMOV_GR8", LIEF::assembly::x86::OPCODE::CMOV_GR8)
  .value("CMOV_RFP32", LIEF::assembly::x86::OPCODE::CMOV_RFP32)
  .value("CMOV_RFP64", LIEF::assembly::x86::OPCODE::CMOV_RFP64)
  .value("CMOV_RFP80", LIEF::assembly::x86::OPCODE::CMOV_RFP80)
  .value("CMOV_VK1", LIEF::assembly::x86::OPCODE::CMOV_VK1)
  .value("CMOV_VK16", LIEF::assembly::x86::OPCODE::CMOV_VK16)
  .value("CMOV_VK2", LIEF::assembly::x86::OPCODE::CMOV_VK2)
  .value("CMOV_VK32", LIEF::assembly::x86::OPCODE::CMOV_VK32)
  .value("CMOV_VK4", LIEF::assembly::x86::OPCODE::CMOV_VK4)
  .value("CMOV_VK64", LIEF::assembly::x86::OPCODE::CMOV_VK64)
  .value("CMOV_VK8", LIEF::assembly::x86::OPCODE::CMOV_VK8)
  .value("CMOV_VR128", LIEF::assembly::x86::OPCODE::CMOV_VR128)
  .value("CMOV_VR128X", LIEF::assembly::x86::OPCODE::CMOV_VR128X)
  .value("CMOV_VR256", LIEF::assembly::x86::OPCODE::CMOV_VR256)
  .value("CMOV_VR256X", LIEF::assembly::x86::OPCODE::CMOV_VR256X)
  .value("CMOV_VR512", LIEF::assembly::x86::OPCODE::CMOV_VR512)
  .value("CMOV_VR64", LIEF::assembly::x86::OPCODE::CMOV_VR64)
  .value("CMP16i16", LIEF::assembly::x86::OPCODE::CMP16i16)
  .value("CMP16mi", LIEF::assembly::x86::OPCODE::CMP16mi)
  .value("CMP16mi8", LIEF::assembly::x86::OPCODE::CMP16mi8)
  .value("CMP16mr", LIEF::assembly::x86::OPCODE::CMP16mr)
  .value("CMP16ri", LIEF::assembly::x86::OPCODE::CMP16ri)
  .value("CMP16ri8", LIEF::assembly::x86::OPCODE::CMP16ri8)
  .value("CMP16rm", LIEF::assembly::x86::OPCODE::CMP16rm)
  .value("CMP16rr", LIEF::assembly::x86::OPCODE::CMP16rr)
  .value("CMP16rr_REV", LIEF::assembly::x86::OPCODE::CMP16rr_REV)
  .value("CMP32i32", LIEF::assembly::x86::OPCODE::CMP32i32)
  .value("CMP32mi", LIEF::assembly::x86::OPCODE::CMP32mi)
  .value("CMP32mi8", LIEF::assembly::x86::OPCODE::CMP32mi8)
  .value("CMP32mr", LIEF::assembly::x86::OPCODE::CMP32mr)
  .value("CMP32ri", LIEF::assembly::x86::OPCODE::CMP32ri)
  .value("CMP32ri8", LIEF::assembly::x86::OPCODE::CMP32ri8)
  .value("CMP32rm", LIEF::assembly::x86::OPCODE::CMP32rm)
  .value("CMP32rr", LIEF::assembly::x86::OPCODE::CMP32rr)
  .value("CMP32rr_REV", LIEF::assembly::x86::OPCODE::CMP32rr_REV)
  .value("CMP64i32", LIEF::assembly::x86::OPCODE::CMP64i32)
  .value("CMP64mi32", LIEF::assembly::x86::OPCODE::CMP64mi32)
  .value("CMP64mi8", LIEF::assembly::x86::OPCODE::CMP64mi8)
  .value("CMP64mr", LIEF::assembly::x86::OPCODE::CMP64mr)
  .value("CMP64ri32", LIEF::assembly::x86::OPCODE::CMP64ri32)
  .value("CMP64ri8", LIEF::assembly::x86::OPCODE::CMP64ri8)
  .value("CMP64rm", LIEF::assembly::x86::OPCODE::CMP64rm)
  .value("CMP64rr", LIEF::assembly::x86::OPCODE::CMP64rr)
  .value("CMP64rr_REV", LIEF::assembly::x86::OPCODE::CMP64rr_REV)
  .value("CMP8i8", LIEF::assembly::x86::OPCODE::CMP8i8)
  .value("CMP8mi", LIEF::assembly::x86::OPCODE::CMP8mi)
  .value("CMP8mi8", LIEF::assembly::x86::OPCODE::CMP8mi8)
  .value("CMP8mr", LIEF::assembly::x86::OPCODE::CMP8mr)
  .value("CMP8ri", LIEF::assembly::x86::OPCODE::CMP8ri)
  .value("CMP8ri8", LIEF::assembly::x86::OPCODE::CMP8ri8)
  .value("CMP8rm", LIEF::assembly::x86::OPCODE::CMP8rm)
  .value("CMP8rr", LIEF::assembly::x86::OPCODE::CMP8rr)
  .value("CMP8rr_REV", LIEF::assembly::x86::OPCODE::CMP8rr_REV)
  .value("CMPCCXADDmr32", LIEF::assembly::x86::OPCODE::CMPCCXADDmr32)
  .value("CMPCCXADDmr32_EVEX", LIEF::assembly::x86::OPCODE::CMPCCXADDmr32_EVEX)
  .value("CMPCCXADDmr64", LIEF::assembly::x86::OPCODE::CMPCCXADDmr64)
  .value("CMPCCXADDmr64_EVEX", LIEF::assembly::x86::OPCODE::CMPCCXADDmr64_EVEX)
  .value("CMPPDrmi", LIEF::assembly::x86::OPCODE::CMPPDrmi)
  .value("CMPPDrri", LIEF::assembly::x86::OPCODE::CMPPDrri)
  .value("CMPPSrmi", LIEF::assembly::x86::OPCODE::CMPPSrmi)
  .value("CMPPSrri", LIEF::assembly::x86::OPCODE::CMPPSrri)
  .value("CMPSB", LIEF::assembly::x86::OPCODE::CMPSB)
  .value("CMPSDrmi", LIEF::assembly::x86::OPCODE::CMPSDrmi)
  .value("CMPSDrmi_Int", LIEF::assembly::x86::OPCODE::CMPSDrmi_Int)
  .value("CMPSDrri", LIEF::assembly::x86::OPCODE::CMPSDrri)
  .value("CMPSDrri_Int", LIEF::assembly::x86::OPCODE::CMPSDrri_Int)
  .value("CMPSL", LIEF::assembly::x86::OPCODE::CMPSL)
  .value("CMPSQ", LIEF::assembly::x86::OPCODE::CMPSQ)
  .value("CMPSSrmi", LIEF::assembly::x86::OPCODE::CMPSSrmi)
  .value("CMPSSrmi_Int", LIEF::assembly::x86::OPCODE::CMPSSrmi_Int)
  .value("CMPSSrri", LIEF::assembly::x86::OPCODE::CMPSSrri)
  .value("CMPSSrri_Int", LIEF::assembly::x86::OPCODE::CMPSSrri_Int)
  .value("CMPSW", LIEF::assembly::x86::OPCODE::CMPSW)
  .value("CMPXCHG16B", LIEF::assembly::x86::OPCODE::CMPXCHG16B)
  .value("CMPXCHG16rm", LIEF::assembly::x86::OPCODE::CMPXCHG16rm)
  .value("CMPXCHG16rr", LIEF::assembly::x86::OPCODE::CMPXCHG16rr)
  .value("CMPXCHG32rm", LIEF::assembly::x86::OPCODE::CMPXCHG32rm)
  .value("CMPXCHG32rr", LIEF::assembly::x86::OPCODE::CMPXCHG32rr)
  .value("CMPXCHG64rm", LIEF::assembly::x86::OPCODE::CMPXCHG64rm)
  .value("CMPXCHG64rr", LIEF::assembly::x86::OPCODE::CMPXCHG64rr)
  .value("CMPXCHG8B", LIEF::assembly::x86::OPCODE::CMPXCHG8B)
  .value("CMPXCHG8rm", LIEF::assembly::x86::OPCODE::CMPXCHG8rm)
  .value("CMPXCHG8rr", LIEF::assembly::x86::OPCODE::CMPXCHG8rr)
  .value("COMISDrm", LIEF::assembly::x86::OPCODE::COMISDrm)
  .value("COMISDrm_Int", LIEF::assembly::x86::OPCODE::COMISDrm_Int)
  .value("COMISDrr", LIEF::assembly::x86::OPCODE::COMISDrr)
  .value("COMISDrr_Int", LIEF::assembly::x86::OPCODE::COMISDrr_Int)
  .value("COMISSrm", LIEF::assembly::x86::OPCODE::COMISSrm)
  .value("COMISSrm_Int", LIEF::assembly::x86::OPCODE::COMISSrm_Int)
  .value("COMISSrr", LIEF::assembly::x86::OPCODE::COMISSrr)
  .value("COMISSrr_Int", LIEF::assembly::x86::OPCODE::COMISSrr_Int)
  .value("COMP_FST0r", LIEF::assembly::x86::OPCODE::COMP_FST0r)
  .value("COM_FIPr", LIEF::assembly::x86::OPCODE::COM_FIPr)
  .value("COM_FIr", LIEF::assembly::x86::OPCODE::COM_FIr)
  .value("COM_FST0r", LIEF::assembly::x86::OPCODE::COM_FST0r)
  .value("COM_FpIr32", LIEF::assembly::x86::OPCODE::COM_FpIr32)
  .value("COM_FpIr64", LIEF::assembly::x86::OPCODE::COM_FpIr64)
  .value("COM_FpIr80", LIEF::assembly::x86::OPCODE::COM_FpIr80)
  .value("COM_Fpr32", LIEF::assembly::x86::OPCODE::COM_Fpr32)
  .value("COM_Fpr64", LIEF::assembly::x86::OPCODE::COM_Fpr64)
  .value("COM_Fpr80", LIEF::assembly::x86::OPCODE::COM_Fpr80)
  .value("CPUID", LIEF::assembly::x86::OPCODE::CPUID)
  .value("CQO", LIEF::assembly::x86::OPCODE::CQO)
  .value("CRC32r32m16", LIEF::assembly::x86::OPCODE::CRC32r32m16)
  .value("CRC32r32m16_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32m16_EVEX)
  .value("CRC32r32m32", LIEF::assembly::x86::OPCODE::CRC32r32m32)
  .value("CRC32r32m32_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32m32_EVEX)
  .value("CRC32r32m8", LIEF::assembly::x86::OPCODE::CRC32r32m8)
  .value("CRC32r32m8_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32m8_EVEX)
  .value("CRC32r32r16", LIEF::assembly::x86::OPCODE::CRC32r32r16)
  .value("CRC32r32r16_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32r16_EVEX)
  .value("CRC32r32r32", LIEF::assembly::x86::OPCODE::CRC32r32r32)
  .value("CRC32r32r32_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32r32_EVEX)
  .value("CRC32r32r8", LIEF::assembly::x86::OPCODE::CRC32r32r8)
  .value("CRC32r32r8_EVEX", LIEF::assembly::x86::OPCODE::CRC32r32r8_EVEX)
  .value("CRC32r64m64", LIEF::assembly::x86::OPCODE::CRC32r64m64)
  .value("CRC32r64m64_EVEX", LIEF::assembly::x86::OPCODE::CRC32r64m64_EVEX)
  .value("CRC32r64m8", LIEF::assembly::x86::OPCODE::CRC32r64m8)
  .value("CRC32r64m8_EVEX", LIEF::assembly::x86::OPCODE::CRC32r64m8_EVEX)
  .value("CRC32r64r64", LIEF::assembly::x86::OPCODE::CRC32r64r64)
  .value("CRC32r64r64_EVEX", LIEF::assembly::x86::OPCODE::CRC32r64r64_EVEX)
  .value("CRC32r64r8", LIEF::assembly::x86::OPCODE::CRC32r64r8)
  .value("CRC32r64r8_EVEX", LIEF::assembly::x86::OPCODE::CRC32r64r8_EVEX)
  .value("CS_PREFIX", LIEF::assembly::x86::OPCODE::CS_PREFIX)
  .value("CTEST16mi", LIEF::assembly::x86::OPCODE::CTEST16mi)
  .value("CTEST16mr", LIEF::assembly::x86::OPCODE::CTEST16mr)
  .value("CTEST16ri", LIEF::assembly::x86::OPCODE::CTEST16ri)
  .value("CTEST16rr", LIEF::assembly::x86::OPCODE::CTEST16rr)
  .value("CTEST32mi", LIEF::assembly::x86::OPCODE::CTEST32mi)
  .value("CTEST32mr", LIEF::assembly::x86::OPCODE::CTEST32mr)
  .value("CTEST32ri", LIEF::assembly::x86::OPCODE::CTEST32ri)
  .value("CTEST32rr", LIEF::assembly::x86::OPCODE::CTEST32rr)
  .value("CTEST64mi32", LIEF::assembly::x86::OPCODE::CTEST64mi32)
  .value("CTEST64mr", LIEF::assembly::x86::OPCODE::CTEST64mr)
  .value("CTEST64ri32", LIEF::assembly::x86::OPCODE::CTEST64ri32)
  .value("CTEST64rr", LIEF::assembly::x86::OPCODE::CTEST64rr)
  .value("CTEST8mi", LIEF::assembly::x86::OPCODE::CTEST8mi)
  .value("CTEST8mr", LIEF::assembly::x86::OPCODE::CTEST8mr)
  .value("CTEST8ri", LIEF::assembly::x86::OPCODE::CTEST8ri)
  .value("CTEST8rr", LIEF::assembly::x86::OPCODE::CTEST8rr)
  .value("CVTDQ2PDrm", LIEF::assembly::x86::OPCODE::CVTDQ2PDrm)
  .value("CVTDQ2PDrr", LIEF::assembly::x86::OPCODE::CVTDQ2PDrr)
  .value("CVTDQ2PSrm", LIEF::assembly::x86::OPCODE::CVTDQ2PSrm)
  .value("CVTDQ2PSrr", LIEF::assembly::x86::OPCODE::CVTDQ2PSrr)
  .value("CVTPD2DQrm", LIEF::assembly::x86::OPCODE::CVTPD2DQrm)
  .value("CVTPD2DQrr", LIEF::assembly::x86::OPCODE::CVTPD2DQrr)
  .value("CVTPD2PSrm", LIEF::assembly::x86::OPCODE::CVTPD2PSrm)
  .value("CVTPD2PSrr", LIEF::assembly::x86::OPCODE::CVTPD2PSrr)
  .value("CVTPS2DQrm", LIEF::assembly::x86::OPCODE::CVTPS2DQrm)
  .value("CVTPS2DQrr", LIEF::assembly::x86::OPCODE::CVTPS2DQrr)
  .value("CVTPS2PDrm", LIEF::assembly::x86::OPCODE::CVTPS2PDrm)
  .value("CVTPS2PDrr", LIEF::assembly::x86::OPCODE::CVTPS2PDrr)
  .value("CVTSD2SI64rm", LIEF::assembly::x86::OPCODE::CVTSD2SI64rm)
  .value("CVTSD2SI64rm_Int", LIEF::assembly::x86::OPCODE::CVTSD2SI64rm_Int)
  .value("CVTSD2SI64rr", LIEF::assembly::x86::OPCODE::CVTSD2SI64rr)
  .value("CVTSD2SI64rr_Int", LIEF::assembly::x86::OPCODE::CVTSD2SI64rr_Int)
  .value("CVTSD2SIrm", LIEF::assembly::x86::OPCODE::CVTSD2SIrm)
  .value("CVTSD2SIrm_Int", LIEF::assembly::x86::OPCODE::CVTSD2SIrm_Int)
  .value("CVTSD2SIrr", LIEF::assembly::x86::OPCODE::CVTSD2SIrr)
  .value("CVTSD2SIrr_Int", LIEF::assembly::x86::OPCODE::CVTSD2SIrr_Int)
  .value("CVTSD2SSrm", LIEF::assembly::x86::OPCODE::CVTSD2SSrm)
  .value("CVTSD2SSrm_Int", LIEF::assembly::x86::OPCODE::CVTSD2SSrm_Int)
  .value("CVTSD2SSrr", LIEF::assembly::x86::OPCODE::CVTSD2SSrr)
  .value("CVTSD2SSrr_Int", LIEF::assembly::x86::OPCODE::CVTSD2SSrr_Int)
  .value("CVTSI2SDrm", LIEF::assembly::x86::OPCODE::CVTSI2SDrm)
  .value("CVTSI2SDrm_Int", LIEF::assembly::x86::OPCODE::CVTSI2SDrm_Int)
  .value("CVTSI2SDrr", LIEF::assembly::x86::OPCODE::CVTSI2SDrr)
  .value("CVTSI2SDrr_Int", LIEF::assembly::x86::OPCODE::CVTSI2SDrr_Int)
  .value("CVTSI2SSrm", LIEF::assembly::x86::OPCODE::CVTSI2SSrm)
  .value("CVTSI2SSrm_Int", LIEF::assembly::x86::OPCODE::CVTSI2SSrm_Int)
  .value("CVTSI2SSrr", LIEF::assembly::x86::OPCODE::CVTSI2SSrr)
  .value("CVTSI2SSrr_Int", LIEF::assembly::x86::OPCODE::CVTSI2SSrr_Int)
  .value("CVTSI642SDrm", LIEF::assembly::x86::OPCODE::CVTSI642SDrm)
  .value("CVTSI642SDrm_Int", LIEF::assembly::x86::OPCODE::CVTSI642SDrm_Int)
  .value("CVTSI642SDrr", LIEF::assembly::x86::OPCODE::CVTSI642SDrr)
  .value("CVTSI642SDrr_Int", LIEF::assembly::x86::OPCODE::CVTSI642SDrr_Int)
  .value("CVTSI642SSrm", LIEF::assembly::x86::OPCODE::CVTSI642SSrm)
  .value("CVTSI642SSrm_Int", LIEF::assembly::x86::OPCODE::CVTSI642SSrm_Int)
  .value("CVTSI642SSrr", LIEF::assembly::x86::OPCODE::CVTSI642SSrr)
  .value("CVTSI642SSrr_Int", LIEF::assembly::x86::OPCODE::CVTSI642SSrr_Int)
  .value("CVTSS2SDrm", LIEF::assembly::x86::OPCODE::CVTSS2SDrm)
  .value("CVTSS2SDrm_Int", LIEF::assembly::x86::OPCODE::CVTSS2SDrm_Int)
  .value("CVTSS2SDrr", LIEF::assembly::x86::OPCODE::CVTSS2SDrr)
  .value("CVTSS2SDrr_Int", LIEF::assembly::x86::OPCODE::CVTSS2SDrr_Int)
  .value("CVTSS2SI64rm", LIEF::assembly::x86::OPCODE::CVTSS2SI64rm)
  .value("CVTSS2SI64rm_Int", LIEF::assembly::x86::OPCODE::CVTSS2SI64rm_Int)
  .value("CVTSS2SI64rr", LIEF::assembly::x86::OPCODE::CVTSS2SI64rr)
  .value("CVTSS2SI64rr_Int", LIEF::assembly::x86::OPCODE::CVTSS2SI64rr_Int)
  .value("CVTSS2SIrm", LIEF::assembly::x86::OPCODE::CVTSS2SIrm)
  .value("CVTSS2SIrm_Int", LIEF::assembly::x86::OPCODE::CVTSS2SIrm_Int)
  .value("CVTSS2SIrr", LIEF::assembly::x86::OPCODE::CVTSS2SIrr)
  .value("CVTSS2SIrr_Int", LIEF::assembly::x86::OPCODE::CVTSS2SIrr_Int)
  .value("CVTTPD2DQrm", LIEF::assembly::x86::OPCODE::CVTTPD2DQrm)
  .value("CVTTPD2DQrr", LIEF::assembly::x86::OPCODE::CVTTPD2DQrr)
  .value("CVTTPS2DQrm", LIEF::assembly::x86::OPCODE::CVTTPS2DQrm)
  .value("CVTTPS2DQrr", LIEF::assembly::x86::OPCODE::CVTTPS2DQrr)
  .value("CVTTSD2SI64rm", LIEF::assembly::x86::OPCODE::CVTTSD2SI64rm)
  .value("CVTTSD2SI64rm_Int", LIEF::assembly::x86::OPCODE::CVTTSD2SI64rm_Int)
  .value("CVTTSD2SI64rr", LIEF::assembly::x86::OPCODE::CVTTSD2SI64rr)
  .value("CVTTSD2SI64rr_Int", LIEF::assembly::x86::OPCODE::CVTTSD2SI64rr_Int)
  .value("CVTTSD2SIrm", LIEF::assembly::x86::OPCODE::CVTTSD2SIrm)
  .value("CVTTSD2SIrm_Int", LIEF::assembly::x86::OPCODE::CVTTSD2SIrm_Int)
  .value("CVTTSD2SIrr", LIEF::assembly::x86::OPCODE::CVTTSD2SIrr)
  .value("CVTTSD2SIrr_Int", LIEF::assembly::x86::OPCODE::CVTTSD2SIrr_Int)
  .value("CVTTSS2SI64rm", LIEF::assembly::x86::OPCODE::CVTTSS2SI64rm)
  .value("CVTTSS2SI64rm_Int", LIEF::assembly::x86::OPCODE::CVTTSS2SI64rm_Int)
  .value("CVTTSS2SI64rr", LIEF::assembly::x86::OPCODE::CVTTSS2SI64rr)
  .value("CVTTSS2SI64rr_Int", LIEF::assembly::x86::OPCODE::CVTTSS2SI64rr_Int)
  .value("CVTTSS2SIrm", LIEF::assembly::x86::OPCODE::CVTTSS2SIrm)
  .value("CVTTSS2SIrm_Int", LIEF::assembly::x86::OPCODE::CVTTSS2SIrm_Int)
  .value("CVTTSS2SIrr", LIEF::assembly::x86::OPCODE::CVTTSS2SIrr)
  .value("CVTTSS2SIrr_Int", LIEF::assembly::x86::OPCODE::CVTTSS2SIrr_Int)
  .value("CWD", LIEF::assembly::x86::OPCODE::CWD)
  .value("CWDE", LIEF::assembly::x86::OPCODE::CWDE)
  .value("DAA", LIEF::assembly::x86::OPCODE::DAA)
  .value("DAS", LIEF::assembly::x86::OPCODE::DAS)
  .value("DATA16_PREFIX", LIEF::assembly::x86::OPCODE::DATA16_PREFIX)
  .value("DEC16m", LIEF::assembly::x86::OPCODE::DEC16m)
  .value("DEC16m_EVEX", LIEF::assembly::x86::OPCODE::DEC16m_EVEX)
  .value("DEC16m_ND", LIEF::assembly::x86::OPCODE::DEC16m_ND)
  .value("DEC16m_NF", LIEF::assembly::x86::OPCODE::DEC16m_NF)
  .value("DEC16m_NF_ND", LIEF::assembly::x86::OPCODE::DEC16m_NF_ND)
  .value("DEC16r", LIEF::assembly::x86::OPCODE::DEC16r)
  .value("DEC16r_EVEX", LIEF::assembly::x86::OPCODE::DEC16r_EVEX)
  .value("DEC16r_ND", LIEF::assembly::x86::OPCODE::DEC16r_ND);
  opcodes.value("DEC16r_NF", LIEF::assembly::x86::OPCODE::DEC16r_NF)
  .value("DEC16r_NF_ND", LIEF::assembly::x86::OPCODE::DEC16r_NF_ND)
  .value("DEC16r_alt", LIEF::assembly::x86::OPCODE::DEC16r_alt)
  .value("DEC32m", LIEF::assembly::x86::OPCODE::DEC32m)
  .value("DEC32m_EVEX", LIEF::assembly::x86::OPCODE::DEC32m_EVEX)
  .value("DEC32m_ND", LIEF::assembly::x86::OPCODE::DEC32m_ND)
  .value("DEC32m_NF", LIEF::assembly::x86::OPCODE::DEC32m_NF)
  .value("DEC32m_NF_ND", LIEF::assembly::x86::OPCODE::DEC32m_NF_ND)
  .value("DEC32r", LIEF::assembly::x86::OPCODE::DEC32r)
  .value("DEC32r_EVEX", LIEF::assembly::x86::OPCODE::DEC32r_EVEX)
  .value("DEC32r_ND", LIEF::assembly::x86::OPCODE::DEC32r_ND)
  .value("DEC32r_NF", LIEF::assembly::x86::OPCODE::DEC32r_NF)
  .value("DEC32r_NF_ND", LIEF::assembly::x86::OPCODE::DEC32r_NF_ND)
  .value("DEC32r_alt", LIEF::assembly::x86::OPCODE::DEC32r_alt)
  .value("DEC64m", LIEF::assembly::x86::OPCODE::DEC64m)
  .value("DEC64m_EVEX", LIEF::assembly::x86::OPCODE::DEC64m_EVEX)
  .value("DEC64m_ND", LIEF::assembly::x86::OPCODE::DEC64m_ND)
  .value("DEC64m_NF", LIEF::assembly::x86::OPCODE::DEC64m_NF)
  .value("DEC64m_NF_ND", LIEF::assembly::x86::OPCODE::DEC64m_NF_ND)
  .value("DEC64r", LIEF::assembly::x86::OPCODE::DEC64r)
  .value("DEC64r_EVEX", LIEF::assembly::x86::OPCODE::DEC64r_EVEX)
  .value("DEC64r_ND", LIEF::assembly::x86::OPCODE::DEC64r_ND)
  .value("DEC64r_NF", LIEF::assembly::x86::OPCODE::DEC64r_NF)
  .value("DEC64r_NF_ND", LIEF::assembly::x86::OPCODE::DEC64r_NF_ND)
  .value("DEC8m", LIEF::assembly::x86::OPCODE::DEC8m)
  .value("DEC8m_EVEX", LIEF::assembly::x86::OPCODE::DEC8m_EVEX)
  .value("DEC8m_ND", LIEF::assembly::x86::OPCODE::DEC8m_ND)
  .value("DEC8m_NF", LIEF::assembly::x86::OPCODE::DEC8m_NF)
  .value("DEC8m_NF_ND", LIEF::assembly::x86::OPCODE::DEC8m_NF_ND)
  .value("DEC8r", LIEF::assembly::x86::OPCODE::DEC8r)
  .value("DEC8r_EVEX", LIEF::assembly::x86::OPCODE::DEC8r_EVEX)
  .value("DEC8r_ND", LIEF::assembly::x86::OPCODE::DEC8r_ND)
  .value("DEC8r_NF", LIEF::assembly::x86::OPCODE::DEC8r_NF)
  .value("DEC8r_NF_ND", LIEF::assembly::x86::OPCODE::DEC8r_NF_ND)
  .value("DIV16m", LIEF::assembly::x86::OPCODE::DIV16m)
  .value("DIV16m_EVEX", LIEF::assembly::x86::OPCODE::DIV16m_EVEX)
  .value("DIV16m_NF", LIEF::assembly::x86::OPCODE::DIV16m_NF)
  .value("DIV16r", LIEF::assembly::x86::OPCODE::DIV16r)
  .value("DIV16r_EVEX", LIEF::assembly::x86::OPCODE::DIV16r_EVEX)
  .value("DIV16r_NF", LIEF::assembly::x86::OPCODE::DIV16r_NF)
  .value("DIV32m", LIEF::assembly::x86::OPCODE::DIV32m)
  .value("DIV32m_EVEX", LIEF::assembly::x86::OPCODE::DIV32m_EVEX)
  .value("DIV32m_NF", LIEF::assembly::x86::OPCODE::DIV32m_NF)
  .value("DIV32r", LIEF::assembly::x86::OPCODE::DIV32r)
  .value("DIV32r_EVEX", LIEF::assembly::x86::OPCODE::DIV32r_EVEX)
  .value("DIV32r_NF", LIEF::assembly::x86::OPCODE::DIV32r_NF)
  .value("DIV64m", LIEF::assembly::x86::OPCODE::DIV64m)
  .value("DIV64m_EVEX", LIEF::assembly::x86::OPCODE::DIV64m_EVEX)
  .value("DIV64m_NF", LIEF::assembly::x86::OPCODE::DIV64m_NF)
  .value("DIV64r", LIEF::assembly::x86::OPCODE::DIV64r)
  .value("DIV64r_EVEX", LIEF::assembly::x86::OPCODE::DIV64r_EVEX)
  .value("DIV64r_NF", LIEF::assembly::x86::OPCODE::DIV64r_NF)
  .value("DIV8m", LIEF::assembly::x86::OPCODE::DIV8m)
  .value("DIV8m_EVEX", LIEF::assembly::x86::OPCODE::DIV8m_EVEX)
  .value("DIV8m_NF", LIEF::assembly::x86::OPCODE::DIV8m_NF)
  .value("DIV8r", LIEF::assembly::x86::OPCODE::DIV8r)
  .value("DIV8r_EVEX", LIEF::assembly::x86::OPCODE::DIV8r_EVEX)
  .value("DIV8r_NF", LIEF::assembly::x86::OPCODE::DIV8r_NF)
  .value("DIVPDrm", LIEF::assembly::x86::OPCODE::DIVPDrm)
  .value("DIVPDrr", LIEF::assembly::x86::OPCODE::DIVPDrr)
  .value("DIVPSrm", LIEF::assembly::x86::OPCODE::DIVPSrm)
  .value("DIVPSrr", LIEF::assembly::x86::OPCODE::DIVPSrr)
  .value("DIVR_F32m", LIEF::assembly::x86::OPCODE::DIVR_F32m)
  .value("DIVR_F64m", LIEF::assembly::x86::OPCODE::DIVR_F64m)
  .value("DIVR_FI16m", LIEF::assembly::x86::OPCODE::DIVR_FI16m)
  .value("DIVR_FI32m", LIEF::assembly::x86::OPCODE::DIVR_FI32m)
  .value("DIVR_FPrST0", LIEF::assembly::x86::OPCODE::DIVR_FPrST0)
  .value("DIVR_FST0r", LIEF::assembly::x86::OPCODE::DIVR_FST0r)
  .value("DIVR_Fp32m", LIEF::assembly::x86::OPCODE::DIVR_Fp32m)
  .value("DIVR_Fp64m", LIEF::assembly::x86::OPCODE::DIVR_Fp64m)
  .value("DIVR_Fp64m32", LIEF::assembly::x86::OPCODE::DIVR_Fp64m32)
  .value("DIVR_Fp80m32", LIEF::assembly::x86::OPCODE::DIVR_Fp80m32)
  .value("DIVR_Fp80m64", LIEF::assembly::x86::OPCODE::DIVR_Fp80m64)
  .value("DIVR_FpI16m32", LIEF::assembly::x86::OPCODE::DIVR_FpI16m32)
  .value("DIVR_FpI16m64", LIEF::assembly::x86::OPCODE::DIVR_FpI16m64)
  .value("DIVR_FpI16m80", LIEF::assembly::x86::OPCODE::DIVR_FpI16m80)
  .value("DIVR_FpI32m32", LIEF::assembly::x86::OPCODE::DIVR_FpI32m32)
  .value("DIVR_FpI32m64", LIEF::assembly::x86::OPCODE::DIVR_FpI32m64)
  .value("DIVR_FpI32m80", LIEF::assembly::x86::OPCODE::DIVR_FpI32m80)
  .value("DIVR_FrST0", LIEF::assembly::x86::OPCODE::DIVR_FrST0)
  .value("DIVSDrm", LIEF::assembly::x86::OPCODE::DIVSDrm)
  .value("DIVSDrm_Int", LIEF::assembly::x86::OPCODE::DIVSDrm_Int)
  .value("DIVSDrr", LIEF::assembly::x86::OPCODE::DIVSDrr)
  .value("DIVSDrr_Int", LIEF::assembly::x86::OPCODE::DIVSDrr_Int)
  .value("DIVSSrm", LIEF::assembly::x86::OPCODE::DIVSSrm)
  .value("DIVSSrm_Int", LIEF::assembly::x86::OPCODE::DIVSSrm_Int)
  .value("DIVSSrr", LIEF::assembly::x86::OPCODE::DIVSSrr)
  .value("DIVSSrr_Int", LIEF::assembly::x86::OPCODE::DIVSSrr_Int)
  .value("DIV_F32m", LIEF::assembly::x86::OPCODE::DIV_F32m)
  .value("DIV_F64m", LIEF::assembly::x86::OPCODE::DIV_F64m)
  .value("DIV_FI16m", LIEF::assembly::x86::OPCODE::DIV_FI16m)
  .value("DIV_FI32m", LIEF::assembly::x86::OPCODE::DIV_FI32m)
  .value("DIV_FPrST0", LIEF::assembly::x86::OPCODE::DIV_FPrST0)
  .value("DIV_FST0r", LIEF::assembly::x86::OPCODE::DIV_FST0r)
  .value("DIV_Fp32", LIEF::assembly::x86::OPCODE::DIV_Fp32)
  .value("DIV_Fp32m", LIEF::assembly::x86::OPCODE::DIV_Fp32m)
  .value("DIV_Fp64", LIEF::assembly::x86::OPCODE::DIV_Fp64)
  .value("DIV_Fp64m", LIEF::assembly::x86::OPCODE::DIV_Fp64m)
  .value("DIV_Fp64m32", LIEF::assembly::x86::OPCODE::DIV_Fp64m32)
  .value("DIV_Fp80", LIEF::assembly::x86::OPCODE::DIV_Fp80)
  .value("DIV_Fp80m32", LIEF::assembly::x86::OPCODE::DIV_Fp80m32)
  .value("DIV_Fp80m64", LIEF::assembly::x86::OPCODE::DIV_Fp80m64)
  .value("DIV_FpI16m32", LIEF::assembly::x86::OPCODE::DIV_FpI16m32)
  .value("DIV_FpI16m64", LIEF::assembly::x86::OPCODE::DIV_FpI16m64)
  .value("DIV_FpI16m80", LIEF::assembly::x86::OPCODE::DIV_FpI16m80)
  .value("DIV_FpI32m32", LIEF::assembly::x86::OPCODE::DIV_FpI32m32)
  .value("DIV_FpI32m64", LIEF::assembly::x86::OPCODE::DIV_FpI32m64)
  .value("DIV_FpI32m80", LIEF::assembly::x86::OPCODE::DIV_FpI32m80)
  .value("DIV_FrST0", LIEF::assembly::x86::OPCODE::DIV_FrST0)
  .value("DPPDrmi", LIEF::assembly::x86::OPCODE::DPPDrmi)
  .value("DPPDrri", LIEF::assembly::x86::OPCODE::DPPDrri)
  .value("DPPSrmi", LIEF::assembly::x86::OPCODE::DPPSrmi)
  .value("DPPSrri", LIEF::assembly::x86::OPCODE::DPPSrri)
  .value("DS_PREFIX", LIEF::assembly::x86::OPCODE::DS_PREFIX)
  .value("DYN_ALLOCA_32", LIEF::assembly::x86::OPCODE::DYN_ALLOCA_32)
  .value("DYN_ALLOCA_64", LIEF::assembly::x86::OPCODE::DYN_ALLOCA_64)
  .value("EH_RETURN", LIEF::assembly::x86::OPCODE::EH_RETURN)
  .value("EH_RETURN64", LIEF::assembly::x86::OPCODE::EH_RETURN64)
  .value("EH_SjLj_LongJmp32", LIEF::assembly::x86::OPCODE::EH_SjLj_LongJmp32)
  .value("EH_SjLj_LongJmp64", LIEF::assembly::x86::OPCODE::EH_SjLj_LongJmp64)
  .value("EH_SjLj_SetJmp32", LIEF::assembly::x86::OPCODE::EH_SjLj_SetJmp32)
  .value("EH_SjLj_SetJmp64", LIEF::assembly::x86::OPCODE::EH_SjLj_SetJmp64)
  .value("EH_SjLj_Setup", LIEF::assembly::x86::OPCODE::EH_SjLj_Setup)
  .value("ENCLS", LIEF::assembly::x86::OPCODE::ENCLS)
  .value("ENCLU", LIEF::assembly::x86::OPCODE::ENCLU)
  .value("ENCLV", LIEF::assembly::x86::OPCODE::ENCLV)
  .value("ENCODEKEY128", LIEF::assembly::x86::OPCODE::ENCODEKEY128)
  .value("ENCODEKEY256", LIEF::assembly::x86::OPCODE::ENCODEKEY256)
  .value("ENDBR32", LIEF::assembly::x86::OPCODE::ENDBR32)
  .value("ENDBR64", LIEF::assembly::x86::OPCODE::ENDBR64)
  .value("ENQCMD16", LIEF::assembly::x86::OPCODE::ENQCMD16)
  .value("ENQCMD32", LIEF::assembly::x86::OPCODE::ENQCMD32)
  .value("ENQCMD32_EVEX", LIEF::assembly::x86::OPCODE::ENQCMD32_EVEX)
  .value("ENQCMD64", LIEF::assembly::x86::OPCODE::ENQCMD64)
  .value("ENQCMD64_EVEX", LIEF::assembly::x86::OPCODE::ENQCMD64_EVEX)
  .value("ENQCMDS16", LIEF::assembly::x86::OPCODE::ENQCMDS16)
  .value("ENQCMDS32", LIEF::assembly::x86::OPCODE::ENQCMDS32)
  .value("ENQCMDS32_EVEX", LIEF::assembly::x86::OPCODE::ENQCMDS32_EVEX)
  .value("ENQCMDS64", LIEF::assembly::x86::OPCODE::ENQCMDS64)
  .value("ENQCMDS64_EVEX", LIEF::assembly::x86::OPCODE::ENQCMDS64_EVEX)
  .value("ENTER", LIEF::assembly::x86::OPCODE::ENTER)
  .value("ERETS", LIEF::assembly::x86::OPCODE::ERETS)
  .value("ERETU", LIEF::assembly::x86::OPCODE::ERETU)
  .value("ES_PREFIX", LIEF::assembly::x86::OPCODE::ES_PREFIX)
  .value("EXTRACTPSmri", LIEF::assembly::x86::OPCODE::EXTRACTPSmri)
  .value("EXTRACTPSrri", LIEF::assembly::x86::OPCODE::EXTRACTPSrri)
  .value("EXTRQ", LIEF::assembly::x86::OPCODE::EXTRQ)
  .value("EXTRQI", LIEF::assembly::x86::OPCODE::EXTRQI)
  .value("F2XM1", LIEF::assembly::x86::OPCODE::F2XM1)
  .value("FARCALL16i", LIEF::assembly::x86::OPCODE::FARCALL16i)
  .value("FARCALL16m", LIEF::assembly::x86::OPCODE::FARCALL16m)
  .value("FARCALL32i", LIEF::assembly::x86::OPCODE::FARCALL32i)
  .value("FARCALL32m", LIEF::assembly::x86::OPCODE::FARCALL32m)
  .value("FARCALL64m", LIEF::assembly::x86::OPCODE::FARCALL64m)
  .value("FARJMP16i", LIEF::assembly::x86::OPCODE::FARJMP16i)
  .value("FARJMP16m", LIEF::assembly::x86::OPCODE::FARJMP16m)
  .value("FARJMP32i", LIEF::assembly::x86::OPCODE::FARJMP32i)
  .value("FARJMP32m", LIEF::assembly::x86::OPCODE::FARJMP32m)
  .value("FARJMP64m", LIEF::assembly::x86::OPCODE::FARJMP64m)
  .value("FBLDm", LIEF::assembly::x86::OPCODE::FBLDm)
  .value("FBSTPm", LIEF::assembly::x86::OPCODE::FBSTPm)
  .value("FCOM32m", LIEF::assembly::x86::OPCODE::FCOM32m)
  .value("FCOM64m", LIEF::assembly::x86::OPCODE::FCOM64m)
  .value("FCOMP32m", LIEF::assembly::x86::OPCODE::FCOMP32m)
  .value("FCOMP64m", LIEF::assembly::x86::OPCODE::FCOMP64m)
  .value("FCOMPP", LIEF::assembly::x86::OPCODE::FCOMPP)
  .value("FCOS", LIEF::assembly::x86::OPCODE::FCOS)
  .value("FDECSTP", LIEF::assembly::x86::OPCODE::FDECSTP)
  .value("FEMMS", LIEF::assembly::x86::OPCODE::FEMMS)
  .value("FFREE", LIEF::assembly::x86::OPCODE::FFREE)
  .value("FFREEP", LIEF::assembly::x86::OPCODE::FFREEP)
  .value("FICOM16m", LIEF::assembly::x86::OPCODE::FICOM16m)
  .value("FICOM32m", LIEF::assembly::x86::OPCODE::FICOM32m)
  .value("FICOMP16m", LIEF::assembly::x86::OPCODE::FICOMP16m)
  .value("FICOMP32m", LIEF::assembly::x86::OPCODE::FICOMP32m)
  .value("FINCSTP", LIEF::assembly::x86::OPCODE::FINCSTP)
  .value("FLDCW16m", LIEF::assembly::x86::OPCODE::FLDCW16m)
  .value("FLDENVm", LIEF::assembly::x86::OPCODE::FLDENVm)
  .value("FLDL2E", LIEF::assembly::x86::OPCODE::FLDL2E)
  .value("FLDL2T", LIEF::assembly::x86::OPCODE::FLDL2T)
  .value("FLDLG2", LIEF::assembly::x86::OPCODE::FLDLG2)
  .value("FLDLN2", LIEF::assembly::x86::OPCODE::FLDLN2)
  .value("FLDPI", LIEF::assembly::x86::OPCODE::FLDPI)
  .value("FNCLEX", LIEF::assembly::x86::OPCODE::FNCLEX)
  .value("FNINIT", LIEF::assembly::x86::OPCODE::FNINIT)
  .value("FNOP", LIEF::assembly::x86::OPCODE::FNOP)
  .value("FNSTCW16m", LIEF::assembly::x86::OPCODE::FNSTCW16m)
  .value("FNSTSW16r", LIEF::assembly::x86::OPCODE::FNSTSW16r)
  .value("FNSTSWm", LIEF::assembly::x86::OPCODE::FNSTSWm)
  .value("FP32_TO_INT16_IN_MEM", LIEF::assembly::x86::OPCODE::FP32_TO_INT16_IN_MEM)
  .value("FP32_TO_INT32_IN_MEM", LIEF::assembly::x86::OPCODE::FP32_TO_INT32_IN_MEM)
  .value("FP32_TO_INT64_IN_MEM", LIEF::assembly::x86::OPCODE::FP32_TO_INT64_IN_MEM)
  .value("FP64_TO_INT16_IN_MEM", LIEF::assembly::x86::OPCODE::FP64_TO_INT16_IN_MEM)
  .value("FP64_TO_INT32_IN_MEM", LIEF::assembly::x86::OPCODE::FP64_TO_INT32_IN_MEM)
  .value("FP64_TO_INT64_IN_MEM", LIEF::assembly::x86::OPCODE::FP64_TO_INT64_IN_MEM)
  .value("FP80_ADDm32", LIEF::assembly::x86::OPCODE::FP80_ADDm32)
  .value("FP80_ADDr", LIEF::assembly::x86::OPCODE::FP80_ADDr)
  .value("FP80_TO_INT16_IN_MEM", LIEF::assembly::x86::OPCODE::FP80_TO_INT16_IN_MEM)
  .value("FP80_TO_INT32_IN_MEM", LIEF::assembly::x86::OPCODE::FP80_TO_INT32_IN_MEM)
  .value("FP80_TO_INT64_IN_MEM", LIEF::assembly::x86::OPCODE::FP80_TO_INT64_IN_MEM)
  .value("FPATAN", LIEF::assembly::x86::OPCODE::FPATAN)
  .value("FPREM", LIEF::assembly::x86::OPCODE::FPREM)
  .value("FPREM1", LIEF::assembly::x86::OPCODE::FPREM1)
  .value("FPTAN", LIEF::assembly::x86::OPCODE::FPTAN)
  .value("FRNDINT", LIEF::assembly::x86::OPCODE::FRNDINT)
  .value("FRSTORm", LIEF::assembly::x86::OPCODE::FRSTORm)
  .value("FSAVEm", LIEF::assembly::x86::OPCODE::FSAVEm)
  .value("FSCALE", LIEF::assembly::x86::OPCODE::FSCALE)
  .value("FSIN", LIEF::assembly::x86::OPCODE::FSIN)
  .value("FSINCOS", LIEF::assembly::x86::OPCODE::FSINCOS)
  .value("FSTENVm", LIEF::assembly::x86::OPCODE::FSTENVm)
  .value("FS_PREFIX", LIEF::assembly::x86::OPCODE::FS_PREFIX)
  .value("FXRSTOR", LIEF::assembly::x86::OPCODE::FXRSTOR)
  .value("FXRSTOR64", LIEF::assembly::x86::OPCODE::FXRSTOR64)
  .value("FXSAVE", LIEF::assembly::x86::OPCODE::FXSAVE)
  .value("FXSAVE64", LIEF::assembly::x86::OPCODE::FXSAVE64)
  .value("FXTRACT", LIEF::assembly::x86::OPCODE::FXTRACT)
  .value("FYL2X", LIEF::assembly::x86::OPCODE::FYL2X)
  .value("FYL2XP1", LIEF::assembly::x86::OPCODE::FYL2XP1)
  .value("GETSEC", LIEF::assembly::x86::OPCODE::GETSEC)
  .value("GF2P8AFFINEINVQBrmi", LIEF::assembly::x86::OPCODE::GF2P8AFFINEINVQBrmi)
  .value("GF2P8AFFINEINVQBrri", LIEF::assembly::x86::OPCODE::GF2P8AFFINEINVQBrri)
  .value("GF2P8AFFINEQBrmi", LIEF::assembly::x86::OPCODE::GF2P8AFFINEQBrmi)
  .value("GF2P8AFFINEQBrri", LIEF::assembly::x86::OPCODE::GF2P8AFFINEQBrri)
  .value("GF2P8MULBrm", LIEF::assembly::x86::OPCODE::GF2P8MULBrm)
  .value("GF2P8MULBrr", LIEF::assembly::x86::OPCODE::GF2P8MULBrr)
  .value("GS_PREFIX", LIEF::assembly::x86::OPCODE::GS_PREFIX)
  .value("HADDPDrm", LIEF::assembly::x86::OPCODE::HADDPDrm)
  .value("HADDPDrr", LIEF::assembly::x86::OPCODE::HADDPDrr)
  .value("HADDPSrm", LIEF::assembly::x86::OPCODE::HADDPSrm)
  .value("HADDPSrr", LIEF::assembly::x86::OPCODE::HADDPSrr)
  .value("HLT", LIEF::assembly::x86::OPCODE::HLT)
  .value("HRESET", LIEF::assembly::x86::OPCODE::HRESET)
  .value("HSUBPDrm", LIEF::assembly::x86::OPCODE::HSUBPDrm)
  .value("HSUBPDrr", LIEF::assembly::x86::OPCODE::HSUBPDrr)
  .value("HSUBPSrm", LIEF::assembly::x86::OPCODE::HSUBPSrm)
  .value("HSUBPSrr", LIEF::assembly::x86::OPCODE::HSUBPSrr)
  .value("IDIV16m", LIEF::assembly::x86::OPCODE::IDIV16m)
  .value("IDIV16m_EVEX", LIEF::assembly::x86::OPCODE::IDIV16m_EVEX)
  .value("IDIV16m_NF", LIEF::assembly::x86::OPCODE::IDIV16m_NF)
  .value("IDIV16r", LIEF::assembly::x86::OPCODE::IDIV16r)
  .value("IDIV16r_EVEX", LIEF::assembly::x86::OPCODE::IDIV16r_EVEX)
  .value("IDIV16r_NF", LIEF::assembly::x86::OPCODE::IDIV16r_NF)
  .value("IDIV32m", LIEF::assembly::x86::OPCODE::IDIV32m)
  .value("IDIV32m_EVEX", LIEF::assembly::x86::OPCODE::IDIV32m_EVEX)
  .value("IDIV32m_NF", LIEF::assembly::x86::OPCODE::IDIV32m_NF)
  .value("IDIV32r", LIEF::assembly::x86::OPCODE::IDIV32r)
  .value("IDIV32r_EVEX", LIEF::assembly::x86::OPCODE::IDIV32r_EVEX)
  .value("IDIV32r_NF", LIEF::assembly::x86::OPCODE::IDIV32r_NF)
  .value("IDIV64m", LIEF::assembly::x86::OPCODE::IDIV64m)
  .value("IDIV64m_EVEX", LIEF::assembly::x86::OPCODE::IDIV64m_EVEX)
  .value("IDIV64m_NF", LIEF::assembly::x86::OPCODE::IDIV64m_NF)
  .value("IDIV64r", LIEF::assembly::x86::OPCODE::IDIV64r)
  .value("IDIV64r_EVEX", LIEF::assembly::x86::OPCODE::IDIV64r_EVEX)
  .value("IDIV64r_NF", LIEF::assembly::x86::OPCODE::IDIV64r_NF)
  .value("IDIV8m", LIEF::assembly::x86::OPCODE::IDIV8m)
  .value("IDIV8m_EVEX", LIEF::assembly::x86::OPCODE::IDIV8m_EVEX)
  .value("IDIV8m_NF", LIEF::assembly::x86::OPCODE::IDIV8m_NF)
  .value("IDIV8r", LIEF::assembly::x86::OPCODE::IDIV8r)
  .value("IDIV8r_EVEX", LIEF::assembly::x86::OPCODE::IDIV8r_EVEX)
  .value("IDIV8r_NF", LIEF::assembly::x86::OPCODE::IDIV8r_NF)
  .value("ILD_F16m", LIEF::assembly::x86::OPCODE::ILD_F16m)
  .value("ILD_F32m", LIEF::assembly::x86::OPCODE::ILD_F32m)
  .value("ILD_F64m", LIEF::assembly::x86::OPCODE::ILD_F64m)
  .value("ILD_Fp16m32", LIEF::assembly::x86::OPCODE::ILD_Fp16m32)
  .value("ILD_Fp16m64", LIEF::assembly::x86::OPCODE::ILD_Fp16m64)
  .value("ILD_Fp16m80", LIEF::assembly::x86::OPCODE::ILD_Fp16m80)
  .value("ILD_Fp32m32", LIEF::assembly::x86::OPCODE::ILD_Fp32m32)
  .value("ILD_Fp32m64", LIEF::assembly::x86::OPCODE::ILD_Fp32m64)
  .value("ILD_Fp32m80", LIEF::assembly::x86::OPCODE::ILD_Fp32m80)
  .value("ILD_Fp64m32", LIEF::assembly::x86::OPCODE::ILD_Fp64m32)
  .value("ILD_Fp64m64", LIEF::assembly::x86::OPCODE::ILD_Fp64m64)
  .value("ILD_Fp64m80", LIEF::assembly::x86::OPCODE::ILD_Fp64m80)
  .value("IMUL16m", LIEF::assembly::x86::OPCODE::IMUL16m)
  .value("IMUL16m_EVEX", LIEF::assembly::x86::OPCODE::IMUL16m_EVEX)
  .value("IMUL16m_NF", LIEF::assembly::x86::OPCODE::IMUL16m_NF)
  .value("IMUL16r", LIEF::assembly::x86::OPCODE::IMUL16r)
  .value("IMUL16r_EVEX", LIEF::assembly::x86::OPCODE::IMUL16r_EVEX)
  .value("IMUL16r_NF", LIEF::assembly::x86::OPCODE::IMUL16r_NF)
  .value("IMUL16rm", LIEF::assembly::x86::OPCODE::IMUL16rm)
  .value("IMUL16rm_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rm_EVEX)
  .value("IMUL16rm_ND", LIEF::assembly::x86::OPCODE::IMUL16rm_ND)
  .value("IMUL16rm_NF", LIEF::assembly::x86::OPCODE::IMUL16rm_NF)
  .value("IMUL16rm_NF_ND", LIEF::assembly::x86::OPCODE::IMUL16rm_NF_ND)
  .value("IMUL16rmi", LIEF::assembly::x86::OPCODE::IMUL16rmi)
  .value("IMUL16rmi8", LIEF::assembly::x86::OPCODE::IMUL16rmi8)
  .value("IMUL16rmi8_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rmi8_EVEX)
  .value("IMUL16rmi8_NF", LIEF::assembly::x86::OPCODE::IMUL16rmi8_NF)
  .value("IMUL16rmi_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rmi_EVEX)
  .value("IMUL16rmi_NF", LIEF::assembly::x86::OPCODE::IMUL16rmi_NF)
  .value("IMUL16rr", LIEF::assembly::x86::OPCODE::IMUL16rr)
  .value("IMUL16rr_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rr_EVEX)
  .value("IMUL16rr_ND", LIEF::assembly::x86::OPCODE::IMUL16rr_ND)
  .value("IMUL16rr_NF", LIEF::assembly::x86::OPCODE::IMUL16rr_NF)
  .value("IMUL16rr_NF_ND", LIEF::assembly::x86::OPCODE::IMUL16rr_NF_ND)
  .value("IMUL16rri", LIEF::assembly::x86::OPCODE::IMUL16rri)
  .value("IMUL16rri8", LIEF::assembly::x86::OPCODE::IMUL16rri8)
  .value("IMUL16rri8_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rri8_EVEX)
  .value("IMUL16rri8_NF", LIEF::assembly::x86::OPCODE::IMUL16rri8_NF)
  .value("IMUL16rri_EVEX", LIEF::assembly::x86::OPCODE::IMUL16rri_EVEX);
  opcodes.value("IMUL16rri_NF", LIEF::assembly::x86::OPCODE::IMUL16rri_NF)
  .value("IMUL32m", LIEF::assembly::x86::OPCODE::IMUL32m)
  .value("IMUL32m_EVEX", LIEF::assembly::x86::OPCODE::IMUL32m_EVEX)
  .value("IMUL32m_NF", LIEF::assembly::x86::OPCODE::IMUL32m_NF)
  .value("IMUL32r", LIEF::assembly::x86::OPCODE::IMUL32r)
  .value("IMUL32r_EVEX", LIEF::assembly::x86::OPCODE::IMUL32r_EVEX)
  .value("IMUL32r_NF", LIEF::assembly::x86::OPCODE::IMUL32r_NF)
  .value("IMUL32rm", LIEF::assembly::x86::OPCODE::IMUL32rm)
  .value("IMUL32rm_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rm_EVEX)
  .value("IMUL32rm_ND", LIEF::assembly::x86::OPCODE::IMUL32rm_ND)
  .value("IMUL32rm_NF", LIEF::assembly::x86::OPCODE::IMUL32rm_NF)
  .value("IMUL32rm_NF_ND", LIEF::assembly::x86::OPCODE::IMUL32rm_NF_ND)
  .value("IMUL32rmi", LIEF::assembly::x86::OPCODE::IMUL32rmi)
  .value("IMUL32rmi8", LIEF::assembly::x86::OPCODE::IMUL32rmi8)
  .value("IMUL32rmi8_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rmi8_EVEX)
  .value("IMUL32rmi8_NF", LIEF::assembly::x86::OPCODE::IMUL32rmi8_NF)
  .value("IMUL32rmi_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rmi_EVEX)
  .value("IMUL32rmi_NF", LIEF::assembly::x86::OPCODE::IMUL32rmi_NF)
  .value("IMUL32rr", LIEF::assembly::x86::OPCODE::IMUL32rr)
  .value("IMUL32rr_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rr_EVEX)
  .value("IMUL32rr_ND", LIEF::assembly::x86::OPCODE::IMUL32rr_ND)
  .value("IMUL32rr_NF", LIEF::assembly::x86::OPCODE::IMUL32rr_NF)
  .value("IMUL32rr_NF_ND", LIEF::assembly::x86::OPCODE::IMUL32rr_NF_ND)
  .value("IMUL32rri", LIEF::assembly::x86::OPCODE::IMUL32rri)
  .value("IMUL32rri8", LIEF::assembly::x86::OPCODE::IMUL32rri8)
  .value("IMUL32rri8_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rri8_EVEX)
  .value("IMUL32rri8_NF", LIEF::assembly::x86::OPCODE::IMUL32rri8_NF)
  .value("IMUL32rri_EVEX", LIEF::assembly::x86::OPCODE::IMUL32rri_EVEX)
  .value("IMUL32rri_NF", LIEF::assembly::x86::OPCODE::IMUL32rri_NF)
  .value("IMUL64m", LIEF::assembly::x86::OPCODE::IMUL64m)
  .value("IMUL64m_EVEX", LIEF::assembly::x86::OPCODE::IMUL64m_EVEX)
  .value("IMUL64m_NF", LIEF::assembly::x86::OPCODE::IMUL64m_NF)
  .value("IMUL64r", LIEF::assembly::x86::OPCODE::IMUL64r)
  .value("IMUL64r_EVEX", LIEF::assembly::x86::OPCODE::IMUL64r_EVEX)
  .value("IMUL64r_NF", LIEF::assembly::x86::OPCODE::IMUL64r_NF)
  .value("IMUL64rm", LIEF::assembly::x86::OPCODE::IMUL64rm)
  .value("IMUL64rm_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rm_EVEX)
  .value("IMUL64rm_ND", LIEF::assembly::x86::OPCODE::IMUL64rm_ND)
  .value("IMUL64rm_NF", LIEF::assembly::x86::OPCODE::IMUL64rm_NF)
  .value("IMUL64rm_NF_ND", LIEF::assembly::x86::OPCODE::IMUL64rm_NF_ND)
  .value("IMUL64rmi32", LIEF::assembly::x86::OPCODE::IMUL64rmi32)
  .value("IMUL64rmi32_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rmi32_EVEX)
  .value("IMUL64rmi32_NF", LIEF::assembly::x86::OPCODE::IMUL64rmi32_NF)
  .value("IMUL64rmi8", LIEF::assembly::x86::OPCODE::IMUL64rmi8)
  .value("IMUL64rmi8_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rmi8_EVEX)
  .value("IMUL64rmi8_NF", LIEF::assembly::x86::OPCODE::IMUL64rmi8_NF)
  .value("IMUL64rr", LIEF::assembly::x86::OPCODE::IMUL64rr)
  .value("IMUL64rr_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rr_EVEX)
  .value("IMUL64rr_ND", LIEF::assembly::x86::OPCODE::IMUL64rr_ND)
  .value("IMUL64rr_NF", LIEF::assembly::x86::OPCODE::IMUL64rr_NF)
  .value("IMUL64rr_NF_ND", LIEF::assembly::x86::OPCODE::IMUL64rr_NF_ND)
  .value("IMUL64rri32", LIEF::assembly::x86::OPCODE::IMUL64rri32)
  .value("IMUL64rri32_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rri32_EVEX)
  .value("IMUL64rri32_NF", LIEF::assembly::x86::OPCODE::IMUL64rri32_NF)
  .value("IMUL64rri8", LIEF::assembly::x86::OPCODE::IMUL64rri8)
  .value("IMUL64rri8_EVEX", LIEF::assembly::x86::OPCODE::IMUL64rri8_EVEX)
  .value("IMUL64rri8_NF", LIEF::assembly::x86::OPCODE::IMUL64rri8_NF)
  .value("IMUL8m", LIEF::assembly::x86::OPCODE::IMUL8m)
  .value("IMUL8m_EVEX", LIEF::assembly::x86::OPCODE::IMUL8m_EVEX)
  .value("IMUL8m_NF", LIEF::assembly::x86::OPCODE::IMUL8m_NF)
  .value("IMUL8r", LIEF::assembly::x86::OPCODE::IMUL8r)
  .value("IMUL8r_EVEX", LIEF::assembly::x86::OPCODE::IMUL8r_EVEX)
  .value("IMUL8r_NF", LIEF::assembly::x86::OPCODE::IMUL8r_NF)
  .value("IMULZU16rmi", LIEF::assembly::x86::OPCODE::IMULZU16rmi)
  .value("IMULZU16rmi8", LIEF::assembly::x86::OPCODE::IMULZU16rmi8)
  .value("IMULZU16rri", LIEF::assembly::x86::OPCODE::IMULZU16rri)
  .value("IMULZU16rri8", LIEF::assembly::x86::OPCODE::IMULZU16rri8)
  .value("IMULZU32rmi", LIEF::assembly::x86::OPCODE::IMULZU32rmi)
  .value("IMULZU32rmi8", LIEF::assembly::x86::OPCODE::IMULZU32rmi8)
  .value("IMULZU32rri", LIEF::assembly::x86::OPCODE::IMULZU32rri)
  .value("IMULZU32rri8", LIEF::assembly::x86::OPCODE::IMULZU32rri8)
  .value("IMULZU64rmi32", LIEF::assembly::x86::OPCODE::IMULZU64rmi32)
  .value("IMULZU64rmi8", LIEF::assembly::x86::OPCODE::IMULZU64rmi8)
  .value("IMULZU64rri32", LIEF::assembly::x86::OPCODE::IMULZU64rri32)
  .value("IMULZU64rri8", LIEF::assembly::x86::OPCODE::IMULZU64rri8)
  .value("IN16ri", LIEF::assembly::x86::OPCODE::IN16ri)
  .value("IN16rr", LIEF::assembly::x86::OPCODE::IN16rr)
  .value("IN32ri", LIEF::assembly::x86::OPCODE::IN32ri)
  .value("IN32rr", LIEF::assembly::x86::OPCODE::IN32rr)
  .value("IN8ri", LIEF::assembly::x86::OPCODE::IN8ri)
  .value("IN8rr", LIEF::assembly::x86::OPCODE::IN8rr)
  .value("INC16m", LIEF::assembly::x86::OPCODE::INC16m)
  .value("INC16m_EVEX", LIEF::assembly::x86::OPCODE::INC16m_EVEX)
  .value("INC16m_ND", LIEF::assembly::x86::OPCODE::INC16m_ND)
  .value("INC16m_NF", LIEF::assembly::x86::OPCODE::INC16m_NF)
  .value("INC16m_NF_ND", LIEF::assembly::x86::OPCODE::INC16m_NF_ND)
  .value("INC16r", LIEF::assembly::x86::OPCODE::INC16r)
  .value("INC16r_EVEX", LIEF::assembly::x86::OPCODE::INC16r_EVEX)
  .value("INC16r_ND", LIEF::assembly::x86::OPCODE::INC16r_ND)
  .value("INC16r_NF", LIEF::assembly::x86::OPCODE::INC16r_NF)
  .value("INC16r_NF_ND", LIEF::assembly::x86::OPCODE::INC16r_NF_ND)
  .value("INC16r_alt", LIEF::assembly::x86::OPCODE::INC16r_alt)
  .value("INC32m", LIEF::assembly::x86::OPCODE::INC32m)
  .value("INC32m_EVEX", LIEF::assembly::x86::OPCODE::INC32m_EVEX)
  .value("INC32m_ND", LIEF::assembly::x86::OPCODE::INC32m_ND)
  .value("INC32m_NF", LIEF::assembly::x86::OPCODE::INC32m_NF)
  .value("INC32m_NF_ND", LIEF::assembly::x86::OPCODE::INC32m_NF_ND)
  .value("INC32r", LIEF::assembly::x86::OPCODE::INC32r)
  .value("INC32r_EVEX", LIEF::assembly::x86::OPCODE::INC32r_EVEX)
  .value("INC32r_ND", LIEF::assembly::x86::OPCODE::INC32r_ND)
  .value("INC32r_NF", LIEF::assembly::x86::OPCODE::INC32r_NF)
  .value("INC32r_NF_ND", LIEF::assembly::x86::OPCODE::INC32r_NF_ND)
  .value("INC32r_alt", LIEF::assembly::x86::OPCODE::INC32r_alt)
  .value("INC64m", LIEF::assembly::x86::OPCODE::INC64m)
  .value("INC64m_EVEX", LIEF::assembly::x86::OPCODE::INC64m_EVEX)
  .value("INC64m_ND", LIEF::assembly::x86::OPCODE::INC64m_ND)
  .value("INC64m_NF", LIEF::assembly::x86::OPCODE::INC64m_NF)
  .value("INC64m_NF_ND", LIEF::assembly::x86::OPCODE::INC64m_NF_ND)
  .value("INC64r", LIEF::assembly::x86::OPCODE::INC64r)
  .value("INC64r_EVEX", LIEF::assembly::x86::OPCODE::INC64r_EVEX)
  .value("INC64r_ND", LIEF::assembly::x86::OPCODE::INC64r_ND)
  .value("INC64r_NF", LIEF::assembly::x86::OPCODE::INC64r_NF)
  .value("INC64r_NF_ND", LIEF::assembly::x86::OPCODE::INC64r_NF_ND)
  .value("INC8m", LIEF::assembly::x86::OPCODE::INC8m)
  .value("INC8m_EVEX", LIEF::assembly::x86::OPCODE::INC8m_EVEX)
  .value("INC8m_ND", LIEF::assembly::x86::OPCODE::INC8m_ND)
  .value("INC8m_NF", LIEF::assembly::x86::OPCODE::INC8m_NF)
  .value("INC8m_NF_ND", LIEF::assembly::x86::OPCODE::INC8m_NF_ND)
  .value("INC8r", LIEF::assembly::x86::OPCODE::INC8r)
  .value("INC8r_EVEX", LIEF::assembly::x86::OPCODE::INC8r_EVEX)
  .value("INC8r_ND", LIEF::assembly::x86::OPCODE::INC8r_ND)
  .value("INC8r_NF", LIEF::assembly::x86::OPCODE::INC8r_NF)
  .value("INC8r_NF_ND", LIEF::assembly::x86::OPCODE::INC8r_NF_ND)
  .value("INCSSPD", LIEF::assembly::x86::OPCODE::INCSSPD)
  .value("INCSSPQ", LIEF::assembly::x86::OPCODE::INCSSPQ)
  .value("INSB", LIEF::assembly::x86::OPCODE::INSB)
  .value("INSERTPSrmi", LIEF::assembly::x86::OPCODE::INSERTPSrmi)
  .value("INSERTPSrri", LIEF::assembly::x86::OPCODE::INSERTPSrri)
  .value("INSERTQ", LIEF::assembly::x86::OPCODE::INSERTQ)
  .value("INSERTQI", LIEF::assembly::x86::OPCODE::INSERTQI)
  .value("INSL", LIEF::assembly::x86::OPCODE::INSL)
  .value("INSW", LIEF::assembly::x86::OPCODE::INSW)
  .value("INT", LIEF::assembly::x86::OPCODE::INT)
  .value("INT3", LIEF::assembly::x86::OPCODE::INT3)
  .value("INTO", LIEF::assembly::x86::OPCODE::INTO)
  .value("INVD", LIEF::assembly::x86::OPCODE::INVD)
  .value("INVEPT32", LIEF::assembly::x86::OPCODE::INVEPT32)
  .value("INVEPT64", LIEF::assembly::x86::OPCODE::INVEPT64)
  .value("INVEPT64_EVEX", LIEF::assembly::x86::OPCODE::INVEPT64_EVEX)
  .value("INVLPG", LIEF::assembly::x86::OPCODE::INVLPG)
  .value("INVLPGA32", LIEF::assembly::x86::OPCODE::INVLPGA32)
  .value("INVLPGA64", LIEF::assembly::x86::OPCODE::INVLPGA64)
  .value("INVLPGB32", LIEF::assembly::x86::OPCODE::INVLPGB32)
  .value("INVLPGB64", LIEF::assembly::x86::OPCODE::INVLPGB64)
  .value("INVPCID32", LIEF::assembly::x86::OPCODE::INVPCID32)
  .value("INVPCID64", LIEF::assembly::x86::OPCODE::INVPCID64)
  .value("INVPCID64_EVEX", LIEF::assembly::x86::OPCODE::INVPCID64_EVEX)
  .value("INVVPID32", LIEF::assembly::x86::OPCODE::INVVPID32)
  .value("INVVPID64", LIEF::assembly::x86::OPCODE::INVVPID64)
  .value("INVVPID64_EVEX", LIEF::assembly::x86::OPCODE::INVVPID64_EVEX)
  .value("IRET", LIEF::assembly::x86::OPCODE::IRET)
  .value("IRET16", LIEF::assembly::x86::OPCODE::IRET16)
  .value("IRET32", LIEF::assembly::x86::OPCODE::IRET32)
  .value("IRET64", LIEF::assembly::x86::OPCODE::IRET64)
  .value("ISTT_FP16m", LIEF::assembly::x86::OPCODE::ISTT_FP16m)
  .value("ISTT_FP32m", LIEF::assembly::x86::OPCODE::ISTT_FP32m)
  .value("ISTT_FP64m", LIEF::assembly::x86::OPCODE::ISTT_FP64m)
  .value("ISTT_Fp16m32", LIEF::assembly::x86::OPCODE::ISTT_Fp16m32)
  .value("ISTT_Fp16m64", LIEF::assembly::x86::OPCODE::ISTT_Fp16m64)
  .value("ISTT_Fp16m80", LIEF::assembly::x86::OPCODE::ISTT_Fp16m80)
  .value("ISTT_Fp32m32", LIEF::assembly::x86::OPCODE::ISTT_Fp32m32)
  .value("ISTT_Fp32m64", LIEF::assembly::x86::OPCODE::ISTT_Fp32m64)
  .value("ISTT_Fp32m80", LIEF::assembly::x86::OPCODE::ISTT_Fp32m80)
  .value("ISTT_Fp64m32", LIEF::assembly::x86::OPCODE::ISTT_Fp64m32)
  .value("ISTT_Fp64m64", LIEF::assembly::x86::OPCODE::ISTT_Fp64m64)
  .value("ISTT_Fp64m80", LIEF::assembly::x86::OPCODE::ISTT_Fp64m80)
  .value("IST_F16m", LIEF::assembly::x86::OPCODE::IST_F16m)
  .value("IST_F32m", LIEF::assembly::x86::OPCODE::IST_F32m)
  .value("IST_FP16m", LIEF::assembly::x86::OPCODE::IST_FP16m)
  .value("IST_FP32m", LIEF::assembly::x86::OPCODE::IST_FP32m)
  .value("IST_FP64m", LIEF::assembly::x86::OPCODE::IST_FP64m)
  .value("IST_Fp16m32", LIEF::assembly::x86::OPCODE::IST_Fp16m32)
  .value("IST_Fp16m64", LIEF::assembly::x86::OPCODE::IST_Fp16m64)
  .value("IST_Fp16m80", LIEF::assembly::x86::OPCODE::IST_Fp16m80)
  .value("IST_Fp32m32", LIEF::assembly::x86::OPCODE::IST_Fp32m32)
  .value("IST_Fp32m64", LIEF::assembly::x86::OPCODE::IST_Fp32m64)
  .value("IST_Fp32m80", LIEF::assembly::x86::OPCODE::IST_Fp32m80)
  .value("IST_Fp64m32", LIEF::assembly::x86::OPCODE::IST_Fp64m32)
  .value("IST_Fp64m64", LIEF::assembly::x86::OPCODE::IST_Fp64m64)
  .value("IST_Fp64m80", LIEF::assembly::x86::OPCODE::IST_Fp64m80)
  .value("Int_eh_sjlj_setup_dispatch", LIEF::assembly::x86::OPCODE::Int_eh_sjlj_setup_dispatch)
  .value("JCC_1", LIEF::assembly::x86::OPCODE::JCC_1)
  .value("JCC_2", LIEF::assembly::x86::OPCODE::JCC_2)
  .value("JCC_4", LIEF::assembly::x86::OPCODE::JCC_4)
  .value("JCXZ", LIEF::assembly::x86::OPCODE::JCXZ)
  .value("JECXZ", LIEF::assembly::x86::OPCODE::JECXZ)
  .value("JMP16m", LIEF::assembly::x86::OPCODE::JMP16m)
  .value("JMP16m_NT", LIEF::assembly::x86::OPCODE::JMP16m_NT)
  .value("JMP16r", LIEF::assembly::x86::OPCODE::JMP16r)
  .value("JMP16r_NT", LIEF::assembly::x86::OPCODE::JMP16r_NT)
  .value("JMP32m", LIEF::assembly::x86::OPCODE::JMP32m)
  .value("JMP32m_NT", LIEF::assembly::x86::OPCODE::JMP32m_NT)
  .value("JMP32r", LIEF::assembly::x86::OPCODE::JMP32r)
  .value("JMP32r_NT", LIEF::assembly::x86::OPCODE::JMP32r_NT)
  .value("JMP64m", LIEF::assembly::x86::OPCODE::JMP64m)
  .value("JMP64m_NT", LIEF::assembly::x86::OPCODE::JMP64m_NT)
  .value("JMP64m_REX", LIEF::assembly::x86::OPCODE::JMP64m_REX)
  .value("JMP64r", LIEF::assembly::x86::OPCODE::JMP64r)
  .value("JMP64r_NT", LIEF::assembly::x86::OPCODE::JMP64r_NT)
  .value("JMP64r_REX", LIEF::assembly::x86::OPCODE::JMP64r_REX)
  .value("JMPABS64i", LIEF::assembly::x86::OPCODE::JMPABS64i)
  .value("JMP_1", LIEF::assembly::x86::OPCODE::JMP_1)
  .value("JMP_2", LIEF::assembly::x86::OPCODE::JMP_2)
  .value("JMP_4", LIEF::assembly::x86::OPCODE::JMP_4)
  .value("JRCXZ", LIEF::assembly::x86::OPCODE::JRCXZ)
  .value("KADDBkk", LIEF::assembly::x86::OPCODE::KADDBkk)
  .value("KADDDkk", LIEF::assembly::x86::OPCODE::KADDDkk)
  .value("KADDQkk", LIEF::assembly::x86::OPCODE::KADDQkk)
  .value("KADDWkk", LIEF::assembly::x86::OPCODE::KADDWkk)
  .value("KANDBkk", LIEF::assembly::x86::OPCODE::KANDBkk)
  .value("KANDDkk", LIEF::assembly::x86::OPCODE::KANDDkk)
  .value("KANDNBkk", LIEF::assembly::x86::OPCODE::KANDNBkk)
  .value("KANDNDkk", LIEF::assembly::x86::OPCODE::KANDNDkk)
  .value("KANDNQkk", LIEF::assembly::x86::OPCODE::KANDNQkk)
  .value("KANDNWkk", LIEF::assembly::x86::OPCODE::KANDNWkk)
  .value("KANDQkk", LIEF::assembly::x86::OPCODE::KANDQkk)
  .value("KANDWkk", LIEF::assembly::x86::OPCODE::KANDWkk)
  .value("KCFI_CHECK", LIEF::assembly::x86::OPCODE::KCFI_CHECK)
  .value("KMOVBkk", LIEF::assembly::x86::OPCODE::KMOVBkk)
  .value("KMOVBkk_EVEX", LIEF::assembly::x86::OPCODE::KMOVBkk_EVEX)
  .value("KMOVBkm", LIEF::assembly::x86::OPCODE::KMOVBkm)
  .value("KMOVBkm_EVEX", LIEF::assembly::x86::OPCODE::KMOVBkm_EVEX)
  .value("KMOVBkr", LIEF::assembly::x86::OPCODE::KMOVBkr)
  .value("KMOVBkr_EVEX", LIEF::assembly::x86::OPCODE::KMOVBkr_EVEX)
  .value("KMOVBmk", LIEF::assembly::x86::OPCODE::KMOVBmk)
  .value("KMOVBmk_EVEX", LIEF::assembly::x86::OPCODE::KMOVBmk_EVEX)
  .value("KMOVBrk", LIEF::assembly::x86::OPCODE::KMOVBrk)
  .value("KMOVBrk_EVEX", LIEF::assembly::x86::OPCODE::KMOVBrk_EVEX)
  .value("KMOVDkk", LIEF::assembly::x86::OPCODE::KMOVDkk)
  .value("KMOVDkk_EVEX", LIEF::assembly::x86::OPCODE::KMOVDkk_EVEX)
  .value("KMOVDkm", LIEF::assembly::x86::OPCODE::KMOVDkm)
  .value("KMOVDkm_EVEX", LIEF::assembly::x86::OPCODE::KMOVDkm_EVEX)
  .value("KMOVDkr", LIEF::assembly::x86::OPCODE::KMOVDkr)
  .value("KMOVDkr_EVEX", LIEF::assembly::x86::OPCODE::KMOVDkr_EVEX)
  .value("KMOVDmk", LIEF::assembly::x86::OPCODE::KMOVDmk)
  .value("KMOVDmk_EVEX", LIEF::assembly::x86::OPCODE::KMOVDmk_EVEX)
  .value("KMOVDrk", LIEF::assembly::x86::OPCODE::KMOVDrk)
  .value("KMOVDrk_EVEX", LIEF::assembly::x86::OPCODE::KMOVDrk_EVEX)
  .value("KMOVQkk", LIEF::assembly::x86::OPCODE::KMOVQkk)
  .value("KMOVQkk_EVEX", LIEF::assembly::x86::OPCODE::KMOVQkk_EVEX)
  .value("KMOVQkm", LIEF::assembly::x86::OPCODE::KMOVQkm)
  .value("KMOVQkm_EVEX", LIEF::assembly::x86::OPCODE::KMOVQkm_EVEX)
  .value("KMOVQkr", LIEF::assembly::x86::OPCODE::KMOVQkr)
  .value("KMOVQkr_EVEX", LIEF::assembly::x86::OPCODE::KMOVQkr_EVEX)
  .value("KMOVQmk", LIEF::assembly::x86::OPCODE::KMOVQmk)
  .value("KMOVQmk_EVEX", LIEF::assembly::x86::OPCODE::KMOVQmk_EVEX)
  .value("KMOVQrk", LIEF::assembly::x86::OPCODE::KMOVQrk)
  .value("KMOVQrk_EVEX", LIEF::assembly::x86::OPCODE::KMOVQrk_EVEX)
  .value("KMOVWkk", LIEF::assembly::x86::OPCODE::KMOVWkk)
  .value("KMOVWkk_EVEX", LIEF::assembly::x86::OPCODE::KMOVWkk_EVEX)
  .value("KMOVWkm", LIEF::assembly::x86::OPCODE::KMOVWkm)
  .value("KMOVWkm_EVEX", LIEF::assembly::x86::OPCODE::KMOVWkm_EVEX)
  .value("KMOVWkr", LIEF::assembly::x86::OPCODE::KMOVWkr)
  .value("KMOVWkr_EVEX", LIEF::assembly::x86::OPCODE::KMOVWkr_EVEX)
  .value("KMOVWmk", LIEF::assembly::x86::OPCODE::KMOVWmk)
  .value("KMOVWmk_EVEX", LIEF::assembly::x86::OPCODE::KMOVWmk_EVEX)
  .value("KMOVWrk", LIEF::assembly::x86::OPCODE::KMOVWrk)
  .value("KMOVWrk_EVEX", LIEF::assembly::x86::OPCODE::KMOVWrk_EVEX)
  .value("KNOTBkk", LIEF::assembly::x86::OPCODE::KNOTBkk)
  .value("KNOTDkk", LIEF::assembly::x86::OPCODE::KNOTDkk)
  .value("KNOTQkk", LIEF::assembly::x86::OPCODE::KNOTQkk)
  .value("KNOTWkk", LIEF::assembly::x86::OPCODE::KNOTWkk)
  .value("KORBkk", LIEF::assembly::x86::OPCODE::KORBkk)
  .value("KORDkk", LIEF::assembly::x86::OPCODE::KORDkk)
  .value("KORQkk", LIEF::assembly::x86::OPCODE::KORQkk)
  .value("KORTESTBkk", LIEF::assembly::x86::OPCODE::KORTESTBkk)
  .value("KORTESTDkk", LIEF::assembly::x86::OPCODE::KORTESTDkk)
  .value("KORTESTQkk", LIEF::assembly::x86::OPCODE::KORTESTQkk)
  .value("KORTESTWkk", LIEF::assembly::x86::OPCODE::KORTESTWkk)
  .value("KORWkk", LIEF::assembly::x86::OPCODE::KORWkk)
  .value("KSHIFTLBki", LIEF::assembly::x86::OPCODE::KSHIFTLBki)
  .value("KSHIFTLDki", LIEF::assembly::x86::OPCODE::KSHIFTLDki)
  .value("KSHIFTLQki", LIEF::assembly::x86::OPCODE::KSHIFTLQki)
  .value("KSHIFTLWki", LIEF::assembly::x86::OPCODE::KSHIFTLWki)
  .value("KSHIFTRBki", LIEF::assembly::x86::OPCODE::KSHIFTRBki)
  .value("KSHIFTRDki", LIEF::assembly::x86::OPCODE::KSHIFTRDki)
  .value("KSHIFTRQki", LIEF::assembly::x86::OPCODE::KSHIFTRQki)
  .value("KSHIFTRWki", LIEF::assembly::x86::OPCODE::KSHIFTRWki)
  .value("KTESTBkk", LIEF::assembly::x86::OPCODE::KTESTBkk)
  .value("KTESTDkk", LIEF::assembly::x86::OPCODE::KTESTDkk)
  .value("KTESTQkk", LIEF::assembly::x86::OPCODE::KTESTQkk)
  .value("KTESTWkk", LIEF::assembly::x86::OPCODE::KTESTWkk)
  .value("KUNPCKBWkk", LIEF::assembly::x86::OPCODE::KUNPCKBWkk)
  .value("KUNPCKDQkk", LIEF::assembly::x86::OPCODE::KUNPCKDQkk)
  .value("KUNPCKWDkk", LIEF::assembly::x86::OPCODE::KUNPCKWDkk)
  .value("KXNORBkk", LIEF::assembly::x86::OPCODE::KXNORBkk)
  .value("KXNORDkk", LIEF::assembly::x86::OPCODE::KXNORDkk)
  .value("KXNORQkk", LIEF::assembly::x86::OPCODE::KXNORQkk)
  .value("KXNORWkk", LIEF::assembly::x86::OPCODE::KXNORWkk)
  .value("KXORBkk", LIEF::assembly::x86::OPCODE::KXORBkk)
  .value("KXORDkk", LIEF::assembly::x86::OPCODE::KXORDkk)
  .value("KXORQkk", LIEF::assembly::x86::OPCODE::KXORQkk)
  .value("KXORWkk", LIEF::assembly::x86::OPCODE::KXORWkk)
  .value("LAHF", LIEF::assembly::x86::OPCODE::LAHF)
  .value("LAR16rm", LIEF::assembly::x86::OPCODE::LAR16rm)
  .value("LAR16rr", LIEF::assembly::x86::OPCODE::LAR16rr)
  .value("LAR32rm", LIEF::assembly::x86::OPCODE::LAR32rm)
  .value("LAR32rr", LIEF::assembly::x86::OPCODE::LAR32rr)
  .value("LAR64rm", LIEF::assembly::x86::OPCODE::LAR64rm)
  .value("LAR64rr", LIEF::assembly::x86::OPCODE::LAR64rr);
  opcodes.value("LCMPXCHG16", LIEF::assembly::x86::OPCODE::LCMPXCHG16)
  .value("LCMPXCHG16B", LIEF::assembly::x86::OPCODE::LCMPXCHG16B)
  .value("LCMPXCHG32", LIEF::assembly::x86::OPCODE::LCMPXCHG32)
  .value("LCMPXCHG64", LIEF::assembly::x86::OPCODE::LCMPXCHG64)
  .value("LCMPXCHG8", LIEF::assembly::x86::OPCODE::LCMPXCHG8)
  .value("LCMPXCHG8B", LIEF::assembly::x86::OPCODE::LCMPXCHG8B)
  .value("LDDQUrm", LIEF::assembly::x86::OPCODE::LDDQUrm)
  .value("LDMXCSR", LIEF::assembly::x86::OPCODE::LDMXCSR)
  .value("LDS16rm", LIEF::assembly::x86::OPCODE::LDS16rm)
  .value("LDS32rm", LIEF::assembly::x86::OPCODE::LDS32rm)
  .value("LDTILECFG", LIEF::assembly::x86::OPCODE::LDTILECFG)
  .value("LDTILECFG_EVEX", LIEF::assembly::x86::OPCODE::LDTILECFG_EVEX)
  .value("LD_F0", LIEF::assembly::x86::OPCODE::LD_F0)
  .value("LD_F1", LIEF::assembly::x86::OPCODE::LD_F1)
  .value("LD_F32m", LIEF::assembly::x86::OPCODE::LD_F32m)
  .value("LD_F64m", LIEF::assembly::x86::OPCODE::LD_F64m)
  .value("LD_F80m", LIEF::assembly::x86::OPCODE::LD_F80m)
  .value("LD_Fp032", LIEF::assembly::x86::OPCODE::LD_Fp032)
  .value("LD_Fp064", LIEF::assembly::x86::OPCODE::LD_Fp064)
  .value("LD_Fp080", LIEF::assembly::x86::OPCODE::LD_Fp080)
  .value("LD_Fp132", LIEF::assembly::x86::OPCODE::LD_Fp132)
  .value("LD_Fp164", LIEF::assembly::x86::OPCODE::LD_Fp164)
  .value("LD_Fp180", LIEF::assembly::x86::OPCODE::LD_Fp180)
  .value("LD_Fp32m", LIEF::assembly::x86::OPCODE::LD_Fp32m)
  .value("LD_Fp32m64", LIEF::assembly::x86::OPCODE::LD_Fp32m64)
  .value("LD_Fp32m80", LIEF::assembly::x86::OPCODE::LD_Fp32m80)
  .value("LD_Fp64m", LIEF::assembly::x86::OPCODE::LD_Fp64m)
  .value("LD_Fp64m80", LIEF::assembly::x86::OPCODE::LD_Fp64m80)
  .value("LD_Fp80m", LIEF::assembly::x86::OPCODE::LD_Fp80m)
  .value("LD_Frr", LIEF::assembly::x86::OPCODE::LD_Frr)
  .value("LEA16r", LIEF::assembly::x86::OPCODE::LEA16r)
  .value("LEA32r", LIEF::assembly::x86::OPCODE::LEA32r)
  .value("LEA64_16r", LIEF::assembly::x86::OPCODE::LEA64_16r)
  .value("LEA64_32r", LIEF::assembly::x86::OPCODE::LEA64_32r)
  .value("LEA64_8r", LIEF::assembly::x86::OPCODE::LEA64_8r)
  .value("LEA64r", LIEF::assembly::x86::OPCODE::LEA64r)
  .value("LEAVE", LIEF::assembly::x86::OPCODE::LEAVE)
  .value("LEAVE64", LIEF::assembly::x86::OPCODE::LEAVE64)
  .value("LES16rm", LIEF::assembly::x86::OPCODE::LES16rm)
  .value("LES32rm", LIEF::assembly::x86::OPCODE::LES32rm)
  .value("LFENCE", LIEF::assembly::x86::OPCODE::LFENCE)
  .value("LFS16rm", LIEF::assembly::x86::OPCODE::LFS16rm)
  .value("LFS32rm", LIEF::assembly::x86::OPCODE::LFS32rm)
  .value("LFS64rm", LIEF::assembly::x86::OPCODE::LFS64rm)
  .value("LGDT16m", LIEF::assembly::x86::OPCODE::LGDT16m)
  .value("LGDT32m", LIEF::assembly::x86::OPCODE::LGDT32m)
  .value("LGDT64m", LIEF::assembly::x86::OPCODE::LGDT64m)
  .value("LGS16rm", LIEF::assembly::x86::OPCODE::LGS16rm)
  .value("LGS32rm", LIEF::assembly::x86::OPCODE::LGS32rm)
  .value("LGS64rm", LIEF::assembly::x86::OPCODE::LGS64rm)
  .value("LIDT16m", LIEF::assembly::x86::OPCODE::LIDT16m)
  .value("LIDT32m", LIEF::assembly::x86::OPCODE::LIDT32m)
  .value("LIDT64m", LIEF::assembly::x86::OPCODE::LIDT64m)
  .value("LKGS16m", LIEF::assembly::x86::OPCODE::LKGS16m)
  .value("LKGS16r", LIEF::assembly::x86::OPCODE::LKGS16r)
  .value("LLDT16m", LIEF::assembly::x86::OPCODE::LLDT16m)
  .value("LLDT16r", LIEF::assembly::x86::OPCODE::LLDT16r)
  .value("LLWPCB", LIEF::assembly::x86::OPCODE::LLWPCB)
  .value("LLWPCB64", LIEF::assembly::x86::OPCODE::LLWPCB64)
  .value("LMSW16m", LIEF::assembly::x86::OPCODE::LMSW16m)
  .value("LMSW16r", LIEF::assembly::x86::OPCODE::LMSW16r)
  .value("LOADIWKEY", LIEF::assembly::x86::OPCODE::LOADIWKEY)
  .value("LOCK_ADD16mi", LIEF::assembly::x86::OPCODE::LOCK_ADD16mi)
  .value("LOCK_ADD16mi8", LIEF::assembly::x86::OPCODE::LOCK_ADD16mi8)
  .value("LOCK_ADD16mr", LIEF::assembly::x86::OPCODE::LOCK_ADD16mr)
  .value("LOCK_ADD32mi", LIEF::assembly::x86::OPCODE::LOCK_ADD32mi)
  .value("LOCK_ADD32mi8", LIEF::assembly::x86::OPCODE::LOCK_ADD32mi8)
  .value("LOCK_ADD32mr", LIEF::assembly::x86::OPCODE::LOCK_ADD32mr)
  .value("LOCK_ADD64mi32", LIEF::assembly::x86::OPCODE::LOCK_ADD64mi32)
  .value("LOCK_ADD64mi8", LIEF::assembly::x86::OPCODE::LOCK_ADD64mi8)
  .value("LOCK_ADD64mr", LIEF::assembly::x86::OPCODE::LOCK_ADD64mr)
  .value("LOCK_ADD8mi", LIEF::assembly::x86::OPCODE::LOCK_ADD8mi)
  .value("LOCK_ADD8mr", LIEF::assembly::x86::OPCODE::LOCK_ADD8mr)
  .value("LOCK_AND16mi", LIEF::assembly::x86::OPCODE::LOCK_AND16mi)
  .value("LOCK_AND16mi8", LIEF::assembly::x86::OPCODE::LOCK_AND16mi8)
  .value("LOCK_AND16mr", LIEF::assembly::x86::OPCODE::LOCK_AND16mr)
  .value("LOCK_AND32mi", LIEF::assembly::x86::OPCODE::LOCK_AND32mi)
  .value("LOCK_AND32mi8", LIEF::assembly::x86::OPCODE::LOCK_AND32mi8)
  .value("LOCK_AND32mr", LIEF::assembly::x86::OPCODE::LOCK_AND32mr)
  .value("LOCK_AND64mi32", LIEF::assembly::x86::OPCODE::LOCK_AND64mi32)
  .value("LOCK_AND64mi8", LIEF::assembly::x86::OPCODE::LOCK_AND64mi8)
  .value("LOCK_AND64mr", LIEF::assembly::x86::OPCODE::LOCK_AND64mr)
  .value("LOCK_AND8mi", LIEF::assembly::x86::OPCODE::LOCK_AND8mi)
  .value("LOCK_AND8mr", LIEF::assembly::x86::OPCODE::LOCK_AND8mr)
  .value("LOCK_BTC16m", LIEF::assembly::x86::OPCODE::LOCK_BTC16m)
  .value("LOCK_BTC32m", LIEF::assembly::x86::OPCODE::LOCK_BTC32m)
  .value("LOCK_BTC64m", LIEF::assembly::x86::OPCODE::LOCK_BTC64m)
  .value("LOCK_BTC_RM16rm", LIEF::assembly::x86::OPCODE::LOCK_BTC_RM16rm)
  .value("LOCK_BTC_RM32rm", LIEF::assembly::x86::OPCODE::LOCK_BTC_RM32rm)
  .value("LOCK_BTC_RM64rm", LIEF::assembly::x86::OPCODE::LOCK_BTC_RM64rm)
  .value("LOCK_BTR16m", LIEF::assembly::x86::OPCODE::LOCK_BTR16m)
  .value("LOCK_BTR32m", LIEF::assembly::x86::OPCODE::LOCK_BTR32m)
  .value("LOCK_BTR64m", LIEF::assembly::x86::OPCODE::LOCK_BTR64m)
  .value("LOCK_BTR_RM16rm", LIEF::assembly::x86::OPCODE::LOCK_BTR_RM16rm)
  .value("LOCK_BTR_RM32rm", LIEF::assembly::x86::OPCODE::LOCK_BTR_RM32rm)
  .value("LOCK_BTR_RM64rm", LIEF::assembly::x86::OPCODE::LOCK_BTR_RM64rm)
  .value("LOCK_BTS16m", LIEF::assembly::x86::OPCODE::LOCK_BTS16m)
  .value("LOCK_BTS32m", LIEF::assembly::x86::OPCODE::LOCK_BTS32m)
  .value("LOCK_BTS64m", LIEF::assembly::x86::OPCODE::LOCK_BTS64m)
  .value("LOCK_BTS_RM16rm", LIEF::assembly::x86::OPCODE::LOCK_BTS_RM16rm)
  .value("LOCK_BTS_RM32rm", LIEF::assembly::x86::OPCODE::LOCK_BTS_RM32rm)
  .value("LOCK_BTS_RM64rm", LIEF::assembly::x86::OPCODE::LOCK_BTS_RM64rm)
  .value("LOCK_DEC16m", LIEF::assembly::x86::OPCODE::LOCK_DEC16m)
  .value("LOCK_DEC32m", LIEF::assembly::x86::OPCODE::LOCK_DEC32m)
  .value("LOCK_DEC64m", LIEF::assembly::x86::OPCODE::LOCK_DEC64m)
  .value("LOCK_DEC8m", LIEF::assembly::x86::OPCODE::LOCK_DEC8m)
  .value("LOCK_INC16m", LIEF::assembly::x86::OPCODE::LOCK_INC16m)
  .value("LOCK_INC32m", LIEF::assembly::x86::OPCODE::LOCK_INC32m)
  .value("LOCK_INC64m", LIEF::assembly::x86::OPCODE::LOCK_INC64m)
  .value("LOCK_INC8m", LIEF::assembly::x86::OPCODE::LOCK_INC8m)
  .value("LOCK_OR16mi", LIEF::assembly::x86::OPCODE::LOCK_OR16mi)
  .value("LOCK_OR16mi8", LIEF::assembly::x86::OPCODE::LOCK_OR16mi8)
  .value("LOCK_OR16mr", LIEF::assembly::x86::OPCODE::LOCK_OR16mr)
  .value("LOCK_OR32mi", LIEF::assembly::x86::OPCODE::LOCK_OR32mi)
  .value("LOCK_OR32mi8", LIEF::assembly::x86::OPCODE::LOCK_OR32mi8)
  .value("LOCK_OR32mr", LIEF::assembly::x86::OPCODE::LOCK_OR32mr)
  .value("LOCK_OR64mi32", LIEF::assembly::x86::OPCODE::LOCK_OR64mi32)
  .value("LOCK_OR64mi8", LIEF::assembly::x86::OPCODE::LOCK_OR64mi8)
  .value("LOCK_OR64mr", LIEF::assembly::x86::OPCODE::LOCK_OR64mr)
  .value("LOCK_OR8mi", LIEF::assembly::x86::OPCODE::LOCK_OR8mi)
  .value("LOCK_OR8mr", LIEF::assembly::x86::OPCODE::LOCK_OR8mr)
  .value("LOCK_PREFIX", LIEF::assembly::x86::OPCODE::LOCK_PREFIX)
  .value("LOCK_SUB16mi", LIEF::assembly::x86::OPCODE::LOCK_SUB16mi)
  .value("LOCK_SUB16mi8", LIEF::assembly::x86::OPCODE::LOCK_SUB16mi8)
  .value("LOCK_SUB16mr", LIEF::assembly::x86::OPCODE::LOCK_SUB16mr)
  .value("LOCK_SUB32mi", LIEF::assembly::x86::OPCODE::LOCK_SUB32mi)
  .value("LOCK_SUB32mi8", LIEF::assembly::x86::OPCODE::LOCK_SUB32mi8)
  .value("LOCK_SUB32mr", LIEF::assembly::x86::OPCODE::LOCK_SUB32mr)
  .value("LOCK_SUB64mi32", LIEF::assembly::x86::OPCODE::LOCK_SUB64mi32)
  .value("LOCK_SUB64mi8", LIEF::assembly::x86::OPCODE::LOCK_SUB64mi8)
  .value("LOCK_SUB64mr", LIEF::assembly::x86::OPCODE::LOCK_SUB64mr)
  .value("LOCK_SUB8mi", LIEF::assembly::x86::OPCODE::LOCK_SUB8mi)
  .value("LOCK_SUB8mr", LIEF::assembly::x86::OPCODE::LOCK_SUB8mr)
  .value("LOCK_XOR16mi", LIEF::assembly::x86::OPCODE::LOCK_XOR16mi)
  .value("LOCK_XOR16mi8", LIEF::assembly::x86::OPCODE::LOCK_XOR16mi8)
  .value("LOCK_XOR16mr", LIEF::assembly::x86::OPCODE::LOCK_XOR16mr)
  .value("LOCK_XOR32mi", LIEF::assembly::x86::OPCODE::LOCK_XOR32mi)
  .value("LOCK_XOR32mi8", LIEF::assembly::x86::OPCODE::LOCK_XOR32mi8)
  .value("LOCK_XOR32mr", LIEF::assembly::x86::OPCODE::LOCK_XOR32mr)
  .value("LOCK_XOR64mi32", LIEF::assembly::x86::OPCODE::LOCK_XOR64mi32)
  .value("LOCK_XOR64mi8", LIEF::assembly::x86::OPCODE::LOCK_XOR64mi8)
  .value("LOCK_XOR64mr", LIEF::assembly::x86::OPCODE::LOCK_XOR64mr)
  .value("LOCK_XOR8mi", LIEF::assembly::x86::OPCODE::LOCK_XOR8mi)
  .value("LOCK_XOR8mr", LIEF::assembly::x86::OPCODE::LOCK_XOR8mr)
  .value("LODSB", LIEF::assembly::x86::OPCODE::LODSB)
  .value("LODSL", LIEF::assembly::x86::OPCODE::LODSL)
  .value("LODSQ", LIEF::assembly::x86::OPCODE::LODSQ)
  .value("LODSW", LIEF::assembly::x86::OPCODE::LODSW)
  .value("LOOP", LIEF::assembly::x86::OPCODE::LOOP)
  .value("LOOPE", LIEF::assembly::x86::OPCODE::LOOPE)
  .value("LOOPNE", LIEF::assembly::x86::OPCODE::LOOPNE)
  .value("LRET16", LIEF::assembly::x86::OPCODE::LRET16)
  .value("LRET32", LIEF::assembly::x86::OPCODE::LRET32)
  .value("LRET64", LIEF::assembly::x86::OPCODE::LRET64)
  .value("LRETI16", LIEF::assembly::x86::OPCODE::LRETI16)
  .value("LRETI32", LIEF::assembly::x86::OPCODE::LRETI32)
  .value("LRETI64", LIEF::assembly::x86::OPCODE::LRETI64)
  .value("LSL16rm", LIEF::assembly::x86::OPCODE::LSL16rm)
  .value("LSL16rr", LIEF::assembly::x86::OPCODE::LSL16rr)
  .value("LSL32rm", LIEF::assembly::x86::OPCODE::LSL32rm)
  .value("LSL32rr", LIEF::assembly::x86::OPCODE::LSL32rr)
  .value("LSL64rm", LIEF::assembly::x86::OPCODE::LSL64rm)
  .value("LSL64rr", LIEF::assembly::x86::OPCODE::LSL64rr)
  .value("LSS16rm", LIEF::assembly::x86::OPCODE::LSS16rm)
  .value("LSS32rm", LIEF::assembly::x86::OPCODE::LSS32rm)
  .value("LSS64rm", LIEF::assembly::x86::OPCODE::LSS64rm)
  .value("LTRm", LIEF::assembly::x86::OPCODE::LTRm)
  .value("LTRr", LIEF::assembly::x86::OPCODE::LTRr)
  .value("LWPINS32rmi", LIEF::assembly::x86::OPCODE::LWPINS32rmi)
  .value("LWPINS32rri", LIEF::assembly::x86::OPCODE::LWPINS32rri)
  .value("LWPINS64rmi", LIEF::assembly::x86::OPCODE::LWPINS64rmi)
  .value("LWPINS64rri", LIEF::assembly::x86::OPCODE::LWPINS64rri)
  .value("LWPVAL32rmi", LIEF::assembly::x86::OPCODE::LWPVAL32rmi)
  .value("LWPVAL32rri", LIEF::assembly::x86::OPCODE::LWPVAL32rri)
  .value("LWPVAL64rmi", LIEF::assembly::x86::OPCODE::LWPVAL64rmi)
  .value("LWPVAL64rri", LIEF::assembly::x86::OPCODE::LWPVAL64rri)
  .value("LXADD16", LIEF::assembly::x86::OPCODE::LXADD16)
  .value("LXADD32", LIEF::assembly::x86::OPCODE::LXADD32)
  .value("LXADD64", LIEF::assembly::x86::OPCODE::LXADD64)
  .value("LXADD8", LIEF::assembly::x86::OPCODE::LXADD8)
  .value("LZCNT16rm", LIEF::assembly::x86::OPCODE::LZCNT16rm)
  .value("LZCNT16rm_EVEX", LIEF::assembly::x86::OPCODE::LZCNT16rm_EVEX)
  .value("LZCNT16rm_NF", LIEF::assembly::x86::OPCODE::LZCNT16rm_NF)
  .value("LZCNT16rr", LIEF::assembly::x86::OPCODE::LZCNT16rr)
  .value("LZCNT16rr_EVEX", LIEF::assembly::x86::OPCODE::LZCNT16rr_EVEX)
  .value("LZCNT16rr_NF", LIEF::assembly::x86::OPCODE::LZCNT16rr_NF)
  .value("LZCNT32rm", LIEF::assembly::x86::OPCODE::LZCNT32rm)
  .value("LZCNT32rm_EVEX", LIEF::assembly::x86::OPCODE::LZCNT32rm_EVEX)
  .value("LZCNT32rm_NF", LIEF::assembly::x86::OPCODE::LZCNT32rm_NF)
  .value("LZCNT32rr", LIEF::assembly::x86::OPCODE::LZCNT32rr)
  .value("LZCNT32rr_EVEX", LIEF::assembly::x86::OPCODE::LZCNT32rr_EVEX)
  .value("LZCNT32rr_NF", LIEF::assembly::x86::OPCODE::LZCNT32rr_NF)
  .value("LZCNT64rm", LIEF::assembly::x86::OPCODE::LZCNT64rm)
  .value("LZCNT64rm_EVEX", LIEF::assembly::x86::OPCODE::LZCNT64rm_EVEX)
  .value("LZCNT64rm_NF", LIEF::assembly::x86::OPCODE::LZCNT64rm_NF)
  .value("LZCNT64rr", LIEF::assembly::x86::OPCODE::LZCNT64rr)
  .value("LZCNT64rr_EVEX", LIEF::assembly::x86::OPCODE::LZCNT64rr_EVEX)
  .value("LZCNT64rr_NF", LIEF::assembly::x86::OPCODE::LZCNT64rr_NF)
  .value("MASKMOVDQU", LIEF::assembly::x86::OPCODE::MASKMOVDQU)
  .value("MASKMOVDQU64", LIEF::assembly::x86::OPCODE::MASKMOVDQU64)
  .value("MASKPAIR16LOAD", LIEF::assembly::x86::OPCODE::MASKPAIR16LOAD)
  .value("MASKPAIR16STORE", LIEF::assembly::x86::OPCODE::MASKPAIR16STORE)
  .value("MAXCPDrm", LIEF::assembly::x86::OPCODE::MAXCPDrm)
  .value("MAXCPDrr", LIEF::assembly::x86::OPCODE::MAXCPDrr)
  .value("MAXCPSrm", LIEF::assembly::x86::OPCODE::MAXCPSrm)
  .value("MAXCPSrr", LIEF::assembly::x86::OPCODE::MAXCPSrr)
  .value("MAXCSDrm", LIEF::assembly::x86::OPCODE::MAXCSDrm)
  .value("MAXCSDrr", LIEF::assembly::x86::OPCODE::MAXCSDrr)
  .value("MAXCSSrm", LIEF::assembly::x86::OPCODE::MAXCSSrm)
  .value("MAXCSSrr", LIEF::assembly::x86::OPCODE::MAXCSSrr)
  .value("MAXPDrm", LIEF::assembly::x86::OPCODE::MAXPDrm)
  .value("MAXPDrr", LIEF::assembly::x86::OPCODE::MAXPDrr)
  .value("MAXPSrm", LIEF::assembly::x86::OPCODE::MAXPSrm)
  .value("MAXPSrr", LIEF::assembly::x86::OPCODE::MAXPSrr)
  .value("MAXSDrm", LIEF::assembly::x86::OPCODE::MAXSDrm)
  .value("MAXSDrm_Int", LIEF::assembly::x86::OPCODE::MAXSDrm_Int)
  .value("MAXSDrr", LIEF::assembly::x86::OPCODE::MAXSDrr)
  .value("MAXSDrr_Int", LIEF::assembly::x86::OPCODE::MAXSDrr_Int)
  .value("MAXSSrm", LIEF::assembly::x86::OPCODE::MAXSSrm)
  .value("MAXSSrm_Int", LIEF::assembly::x86::OPCODE::MAXSSrm_Int)
  .value("MAXSSrr", LIEF::assembly::x86::OPCODE::MAXSSrr)
  .value("MAXSSrr_Int", LIEF::assembly::x86::OPCODE::MAXSSrr_Int)
  .value("MFENCE", LIEF::assembly::x86::OPCODE::MFENCE)
  .value("MINCPDrm", LIEF::assembly::x86::OPCODE::MINCPDrm)
  .value("MINCPDrr", LIEF::assembly::x86::OPCODE::MINCPDrr)
  .value("MINCPSrm", LIEF::assembly::x86::OPCODE::MINCPSrm)
  .value("MINCPSrr", LIEF::assembly::x86::OPCODE::MINCPSrr)
  .value("MINCSDrm", LIEF::assembly::x86::OPCODE::MINCSDrm)
  .value("MINCSDrr", LIEF::assembly::x86::OPCODE::MINCSDrr)
  .value("MINCSSrm", LIEF::assembly::x86::OPCODE::MINCSSrm)
  .value("MINCSSrr", LIEF::assembly::x86::OPCODE::MINCSSrr)
  .value("MINPDrm", LIEF::assembly::x86::OPCODE::MINPDrm)
  .value("MINPDrr", LIEF::assembly::x86::OPCODE::MINPDrr)
  .value("MINPSrm", LIEF::assembly::x86::OPCODE::MINPSrm)
  .value("MINPSrr", LIEF::assembly::x86::OPCODE::MINPSrr)
  .value("MINSDrm", LIEF::assembly::x86::OPCODE::MINSDrm)
  .value("MINSDrm_Int", LIEF::assembly::x86::OPCODE::MINSDrm_Int)
  .value("MINSDrr", LIEF::assembly::x86::OPCODE::MINSDrr)
  .value("MINSDrr_Int", LIEF::assembly::x86::OPCODE::MINSDrr_Int)
  .value("MINSSrm", LIEF::assembly::x86::OPCODE::MINSSrm)
  .value("MINSSrm_Int", LIEF::assembly::x86::OPCODE::MINSSrm_Int)
  .value("MINSSrr", LIEF::assembly::x86::OPCODE::MINSSrr)
  .value("MINSSrr_Int", LIEF::assembly::x86::OPCODE::MINSSrr_Int)
  .value("MMX_CVTPD2PIrm", LIEF::assembly::x86::OPCODE::MMX_CVTPD2PIrm)
  .value("MMX_CVTPD2PIrr", LIEF::assembly::x86::OPCODE::MMX_CVTPD2PIrr)
  .value("MMX_CVTPI2PDrm", LIEF::assembly::x86::OPCODE::MMX_CVTPI2PDrm)
  .value("MMX_CVTPI2PDrr", LIEF::assembly::x86::OPCODE::MMX_CVTPI2PDrr)
  .value("MMX_CVTPI2PSrm", LIEF::assembly::x86::OPCODE::MMX_CVTPI2PSrm)
  .value("MMX_CVTPI2PSrr", LIEF::assembly::x86::OPCODE::MMX_CVTPI2PSrr)
  .value("MMX_CVTPS2PIrm", LIEF::assembly::x86::OPCODE::MMX_CVTPS2PIrm)
  .value("MMX_CVTPS2PIrr", LIEF::assembly::x86::OPCODE::MMX_CVTPS2PIrr)
  .value("MMX_CVTTPD2PIrm", LIEF::assembly::x86::OPCODE::MMX_CVTTPD2PIrm)
  .value("MMX_CVTTPD2PIrr", LIEF::assembly::x86::OPCODE::MMX_CVTTPD2PIrr)
  .value("MMX_CVTTPS2PIrm", LIEF::assembly::x86::OPCODE::MMX_CVTTPS2PIrm)
  .value("MMX_CVTTPS2PIrr", LIEF::assembly::x86::OPCODE::MMX_CVTTPS2PIrr)
  .value("MMX_EMMS", LIEF::assembly::x86::OPCODE::MMX_EMMS)
  .value("MMX_MASKMOVQ", LIEF::assembly::x86::OPCODE::MMX_MASKMOVQ)
  .value("MMX_MASKMOVQ64", LIEF::assembly::x86::OPCODE::MMX_MASKMOVQ64)
  .value("MMX_MOVD64from64mr", LIEF::assembly::x86::OPCODE::MMX_MOVD64from64mr)
  .value("MMX_MOVD64from64rr", LIEF::assembly::x86::OPCODE::MMX_MOVD64from64rr)
  .value("MMX_MOVD64grr", LIEF::assembly::x86::OPCODE::MMX_MOVD64grr)
  .value("MMX_MOVD64mr", LIEF::assembly::x86::OPCODE::MMX_MOVD64mr)
  .value("MMX_MOVD64rm", LIEF::assembly::x86::OPCODE::MMX_MOVD64rm)
  .value("MMX_MOVD64rr", LIEF::assembly::x86::OPCODE::MMX_MOVD64rr)
  .value("MMX_MOVD64to64rm", LIEF::assembly::x86::OPCODE::MMX_MOVD64to64rm)
  .value("MMX_MOVD64to64rr", LIEF::assembly::x86::OPCODE::MMX_MOVD64to64rr)
  .value("MMX_MOVDQ2Qrr", LIEF::assembly::x86::OPCODE::MMX_MOVDQ2Qrr)
  .value("MMX_MOVFR642Qrr", LIEF::assembly::x86::OPCODE::MMX_MOVFR642Qrr)
  .value("MMX_MOVNTQmr", LIEF::assembly::x86::OPCODE::MMX_MOVNTQmr)
  .value("MMX_MOVQ2DQrr", LIEF::assembly::x86::OPCODE::MMX_MOVQ2DQrr)
  .value("MMX_MOVQ2FR64rr", LIEF::assembly::x86::OPCODE::MMX_MOVQ2FR64rr)
  .value("MMX_MOVQ64mr", LIEF::assembly::x86::OPCODE::MMX_MOVQ64mr)
  .value("MMX_MOVQ64rm", LIEF::assembly::x86::OPCODE::MMX_MOVQ64rm)
  .value("MMX_MOVQ64rr", LIEF::assembly::x86::OPCODE::MMX_MOVQ64rr)
  .value("MMX_MOVQ64rr_REV", LIEF::assembly::x86::OPCODE::MMX_MOVQ64rr_REV)
  .value("MMX_PABSBrm", LIEF::assembly::x86::OPCODE::MMX_PABSBrm)
  .value("MMX_PABSBrr", LIEF::assembly::x86::OPCODE::MMX_PABSBrr)
  .value("MMX_PABSDrm", LIEF::assembly::x86::OPCODE::MMX_PABSDrm)
  .value("MMX_PABSDrr", LIEF::assembly::x86::OPCODE::MMX_PABSDrr)
  .value("MMX_PABSWrm", LIEF::assembly::x86::OPCODE::MMX_PABSWrm)
  .value("MMX_PABSWrr", LIEF::assembly::x86::OPCODE::MMX_PABSWrr)
  .value("MMX_PACKSSDWrm", LIEF::assembly::x86::OPCODE::MMX_PACKSSDWrm)
  .value("MMX_PACKSSDWrr", LIEF::assembly::x86::OPCODE::MMX_PACKSSDWrr)
  .value("MMX_PACKSSWBrm", LIEF::assembly::x86::OPCODE::MMX_PACKSSWBrm)
  .value("MMX_PACKSSWBrr", LIEF::assembly::x86::OPCODE::MMX_PACKSSWBrr)
  .value("MMX_PACKUSWBrm", LIEF::assembly::x86::OPCODE::MMX_PACKUSWBrm)
  .value("MMX_PACKUSWBrr", LIEF::assembly::x86::OPCODE::MMX_PACKUSWBrr)
  .value("MMX_PADDBrm", LIEF::assembly::x86::OPCODE::MMX_PADDBrm)
  .value("MMX_PADDBrr", LIEF::assembly::x86::OPCODE::MMX_PADDBrr)
  .value("MMX_PADDDrm", LIEF::assembly::x86::OPCODE::MMX_PADDDrm)
  .value("MMX_PADDDrr", LIEF::assembly::x86::OPCODE::MMX_PADDDrr)
  .value("MMX_PADDQrm", LIEF::assembly::x86::OPCODE::MMX_PADDQrm)
  .value("MMX_PADDQrr", LIEF::assembly::x86::OPCODE::MMX_PADDQrr)
  .value("MMX_PADDSBrm", LIEF::assembly::x86::OPCODE::MMX_PADDSBrm)
  .value("MMX_PADDSBrr", LIEF::assembly::x86::OPCODE::MMX_PADDSBrr)
  .value("MMX_PADDSWrm", LIEF::assembly::x86::OPCODE::MMX_PADDSWrm)
  .value("MMX_PADDSWrr", LIEF::assembly::x86::OPCODE::MMX_PADDSWrr)
  .value("MMX_PADDUSBrm", LIEF::assembly::x86::OPCODE::MMX_PADDUSBrm)
  .value("MMX_PADDUSBrr", LIEF::assembly::x86::OPCODE::MMX_PADDUSBrr)
  .value("MMX_PADDUSWrm", LIEF::assembly::x86::OPCODE::MMX_PADDUSWrm);
  opcodes.value("MMX_PADDUSWrr", LIEF::assembly::x86::OPCODE::MMX_PADDUSWrr)
  .value("MMX_PADDWrm", LIEF::assembly::x86::OPCODE::MMX_PADDWrm)
  .value("MMX_PADDWrr", LIEF::assembly::x86::OPCODE::MMX_PADDWrr)
  .value("MMX_PALIGNRrmi", LIEF::assembly::x86::OPCODE::MMX_PALIGNRrmi)
  .value("MMX_PALIGNRrri", LIEF::assembly::x86::OPCODE::MMX_PALIGNRrri)
  .value("MMX_PANDNrm", LIEF::assembly::x86::OPCODE::MMX_PANDNrm)
  .value("MMX_PANDNrr", LIEF::assembly::x86::OPCODE::MMX_PANDNrr)
  .value("MMX_PANDrm", LIEF::assembly::x86::OPCODE::MMX_PANDrm)
  .value("MMX_PANDrr", LIEF::assembly::x86::OPCODE::MMX_PANDrr)
  .value("MMX_PAVGBrm", LIEF::assembly::x86::OPCODE::MMX_PAVGBrm)
  .value("MMX_PAVGBrr", LIEF::assembly::x86::OPCODE::MMX_PAVGBrr)
  .value("MMX_PAVGWrm", LIEF::assembly::x86::OPCODE::MMX_PAVGWrm)
  .value("MMX_PAVGWrr", LIEF::assembly::x86::OPCODE::MMX_PAVGWrr)
  .value("MMX_PCMPEQBrm", LIEF::assembly::x86::OPCODE::MMX_PCMPEQBrm)
  .value("MMX_PCMPEQBrr", LIEF::assembly::x86::OPCODE::MMX_PCMPEQBrr)
  .value("MMX_PCMPEQDrm", LIEF::assembly::x86::OPCODE::MMX_PCMPEQDrm)
  .value("MMX_PCMPEQDrr", LIEF::assembly::x86::OPCODE::MMX_PCMPEQDrr)
  .value("MMX_PCMPEQWrm", LIEF::assembly::x86::OPCODE::MMX_PCMPEQWrm)
  .value("MMX_PCMPEQWrr", LIEF::assembly::x86::OPCODE::MMX_PCMPEQWrr)
  .value("MMX_PCMPGTBrm", LIEF::assembly::x86::OPCODE::MMX_PCMPGTBrm)
  .value("MMX_PCMPGTBrr", LIEF::assembly::x86::OPCODE::MMX_PCMPGTBrr)
  .value("MMX_PCMPGTDrm", LIEF::assembly::x86::OPCODE::MMX_PCMPGTDrm)
  .value("MMX_PCMPGTDrr", LIEF::assembly::x86::OPCODE::MMX_PCMPGTDrr)
  .value("MMX_PCMPGTWrm", LIEF::assembly::x86::OPCODE::MMX_PCMPGTWrm)
  .value("MMX_PCMPGTWrr", LIEF::assembly::x86::OPCODE::MMX_PCMPGTWrr)
  .value("MMX_PEXTRWrri", LIEF::assembly::x86::OPCODE::MMX_PEXTRWrri)
  .value("MMX_PHADDDrm", LIEF::assembly::x86::OPCODE::MMX_PHADDDrm)
  .value("MMX_PHADDDrr", LIEF::assembly::x86::OPCODE::MMX_PHADDDrr)
  .value("MMX_PHADDSWrm", LIEF::assembly::x86::OPCODE::MMX_PHADDSWrm)
  .value("MMX_PHADDSWrr", LIEF::assembly::x86::OPCODE::MMX_PHADDSWrr)
  .value("MMX_PHADDWrm", LIEF::assembly::x86::OPCODE::MMX_PHADDWrm)
  .value("MMX_PHADDWrr", LIEF::assembly::x86::OPCODE::MMX_PHADDWrr)
  .value("MMX_PHSUBDrm", LIEF::assembly::x86::OPCODE::MMX_PHSUBDrm)
  .value("MMX_PHSUBDrr", LIEF::assembly::x86::OPCODE::MMX_PHSUBDrr)
  .value("MMX_PHSUBSWrm", LIEF::assembly::x86::OPCODE::MMX_PHSUBSWrm)
  .value("MMX_PHSUBSWrr", LIEF::assembly::x86::OPCODE::MMX_PHSUBSWrr)
  .value("MMX_PHSUBWrm", LIEF::assembly::x86::OPCODE::MMX_PHSUBWrm)
  .value("MMX_PHSUBWrr", LIEF::assembly::x86::OPCODE::MMX_PHSUBWrr)
  .value("MMX_PINSRWrmi", LIEF::assembly::x86::OPCODE::MMX_PINSRWrmi)
  .value("MMX_PINSRWrri", LIEF::assembly::x86::OPCODE::MMX_PINSRWrri)
  .value("MMX_PMADDUBSWrm", LIEF::assembly::x86::OPCODE::MMX_PMADDUBSWrm)
  .value("MMX_PMADDUBSWrr", LIEF::assembly::x86::OPCODE::MMX_PMADDUBSWrr)
  .value("MMX_PMADDWDrm", LIEF::assembly::x86::OPCODE::MMX_PMADDWDrm)
  .value("MMX_PMADDWDrr", LIEF::assembly::x86::OPCODE::MMX_PMADDWDrr)
  .value("MMX_PMAXSWrm", LIEF::assembly::x86::OPCODE::MMX_PMAXSWrm)
  .value("MMX_PMAXSWrr", LIEF::assembly::x86::OPCODE::MMX_PMAXSWrr)
  .value("MMX_PMAXUBrm", LIEF::assembly::x86::OPCODE::MMX_PMAXUBrm)
  .value("MMX_PMAXUBrr", LIEF::assembly::x86::OPCODE::MMX_PMAXUBrr)
  .value("MMX_PMINSWrm", LIEF::assembly::x86::OPCODE::MMX_PMINSWrm)
  .value("MMX_PMINSWrr", LIEF::assembly::x86::OPCODE::MMX_PMINSWrr)
  .value("MMX_PMINUBrm", LIEF::assembly::x86::OPCODE::MMX_PMINUBrm)
  .value("MMX_PMINUBrr", LIEF::assembly::x86::OPCODE::MMX_PMINUBrr)
  .value("MMX_PMOVMSKBrr", LIEF::assembly::x86::OPCODE::MMX_PMOVMSKBrr)
  .value("MMX_PMULHRSWrm", LIEF::assembly::x86::OPCODE::MMX_PMULHRSWrm)
  .value("MMX_PMULHRSWrr", LIEF::assembly::x86::OPCODE::MMX_PMULHRSWrr)
  .value("MMX_PMULHUWrm", LIEF::assembly::x86::OPCODE::MMX_PMULHUWrm)
  .value("MMX_PMULHUWrr", LIEF::assembly::x86::OPCODE::MMX_PMULHUWrr)
  .value("MMX_PMULHWrm", LIEF::assembly::x86::OPCODE::MMX_PMULHWrm)
  .value("MMX_PMULHWrr", LIEF::assembly::x86::OPCODE::MMX_PMULHWrr)
  .value("MMX_PMULLWrm", LIEF::assembly::x86::OPCODE::MMX_PMULLWrm)
  .value("MMX_PMULLWrr", LIEF::assembly::x86::OPCODE::MMX_PMULLWrr)
  .value("MMX_PMULUDQrm", LIEF::assembly::x86::OPCODE::MMX_PMULUDQrm)
  .value("MMX_PMULUDQrr", LIEF::assembly::x86::OPCODE::MMX_PMULUDQrr)
  .value("MMX_PORrm", LIEF::assembly::x86::OPCODE::MMX_PORrm)
  .value("MMX_PORrr", LIEF::assembly::x86::OPCODE::MMX_PORrr)
  .value("MMX_PSADBWrm", LIEF::assembly::x86::OPCODE::MMX_PSADBWrm)
  .value("MMX_PSADBWrr", LIEF::assembly::x86::OPCODE::MMX_PSADBWrr)
  .value("MMX_PSHUFBrm", LIEF::assembly::x86::OPCODE::MMX_PSHUFBrm)
  .value("MMX_PSHUFBrr", LIEF::assembly::x86::OPCODE::MMX_PSHUFBrr)
  .value("MMX_PSHUFWmi", LIEF::assembly::x86::OPCODE::MMX_PSHUFWmi)
  .value("MMX_PSHUFWri", LIEF::assembly::x86::OPCODE::MMX_PSHUFWri)
  .value("MMX_PSIGNBrm", LIEF::assembly::x86::OPCODE::MMX_PSIGNBrm)
  .value("MMX_PSIGNBrr", LIEF::assembly::x86::OPCODE::MMX_PSIGNBrr)
  .value("MMX_PSIGNDrm", LIEF::assembly::x86::OPCODE::MMX_PSIGNDrm)
  .value("MMX_PSIGNDrr", LIEF::assembly::x86::OPCODE::MMX_PSIGNDrr)
  .value("MMX_PSIGNWrm", LIEF::assembly::x86::OPCODE::MMX_PSIGNWrm)
  .value("MMX_PSIGNWrr", LIEF::assembly::x86::OPCODE::MMX_PSIGNWrr)
  .value("MMX_PSLLDri", LIEF::assembly::x86::OPCODE::MMX_PSLLDri)
  .value("MMX_PSLLDrm", LIEF::assembly::x86::OPCODE::MMX_PSLLDrm)
  .value("MMX_PSLLDrr", LIEF::assembly::x86::OPCODE::MMX_PSLLDrr)
  .value("MMX_PSLLQri", LIEF::assembly::x86::OPCODE::MMX_PSLLQri)
  .value("MMX_PSLLQrm", LIEF::assembly::x86::OPCODE::MMX_PSLLQrm)
  .value("MMX_PSLLQrr", LIEF::assembly::x86::OPCODE::MMX_PSLLQrr)
  .value("MMX_PSLLWri", LIEF::assembly::x86::OPCODE::MMX_PSLLWri)
  .value("MMX_PSLLWrm", LIEF::assembly::x86::OPCODE::MMX_PSLLWrm)
  .value("MMX_PSLLWrr", LIEF::assembly::x86::OPCODE::MMX_PSLLWrr)
  .value("MMX_PSRADri", LIEF::assembly::x86::OPCODE::MMX_PSRADri)
  .value("MMX_PSRADrm", LIEF::assembly::x86::OPCODE::MMX_PSRADrm)
  .value("MMX_PSRADrr", LIEF::assembly::x86::OPCODE::MMX_PSRADrr)
  .value("MMX_PSRAWri", LIEF::assembly::x86::OPCODE::MMX_PSRAWri)
  .value("MMX_PSRAWrm", LIEF::assembly::x86::OPCODE::MMX_PSRAWrm)
  .value("MMX_PSRAWrr", LIEF::assembly::x86::OPCODE::MMX_PSRAWrr)
  .value("MMX_PSRLDri", LIEF::assembly::x86::OPCODE::MMX_PSRLDri)
  .value("MMX_PSRLDrm", LIEF::assembly::x86::OPCODE::MMX_PSRLDrm)
  .value("MMX_PSRLDrr", LIEF::assembly::x86::OPCODE::MMX_PSRLDrr)
  .value("MMX_PSRLQri", LIEF::assembly::x86::OPCODE::MMX_PSRLQri)
  .value("MMX_PSRLQrm", LIEF::assembly::x86::OPCODE::MMX_PSRLQrm)
  .value("MMX_PSRLQrr", LIEF::assembly::x86::OPCODE::MMX_PSRLQrr)
  .value("MMX_PSRLWri", LIEF::assembly::x86::OPCODE::MMX_PSRLWri)
  .value("MMX_PSRLWrm", LIEF::assembly::x86::OPCODE::MMX_PSRLWrm)
  .value("MMX_PSRLWrr", LIEF::assembly::x86::OPCODE::MMX_PSRLWrr)
  .value("MMX_PSUBBrm", LIEF::assembly::x86::OPCODE::MMX_PSUBBrm)
  .value("MMX_PSUBBrr", LIEF::assembly::x86::OPCODE::MMX_PSUBBrr)
  .value("MMX_PSUBDrm", LIEF::assembly::x86::OPCODE::MMX_PSUBDrm)
  .value("MMX_PSUBDrr", LIEF::assembly::x86::OPCODE::MMX_PSUBDrr)
  .value("MMX_PSUBQrm", LIEF::assembly::x86::OPCODE::MMX_PSUBQrm)
  .value("MMX_PSUBQrr", LIEF::assembly::x86::OPCODE::MMX_PSUBQrr)
  .value("MMX_PSUBSBrm", LIEF::assembly::x86::OPCODE::MMX_PSUBSBrm)
  .value("MMX_PSUBSBrr", LIEF::assembly::x86::OPCODE::MMX_PSUBSBrr)
  .value("MMX_PSUBSWrm", LIEF::assembly::x86::OPCODE::MMX_PSUBSWrm)
  .value("MMX_PSUBSWrr", LIEF::assembly::x86::OPCODE::MMX_PSUBSWrr)
  .value("MMX_PSUBUSBrm", LIEF::assembly::x86::OPCODE::MMX_PSUBUSBrm)
  .value("MMX_PSUBUSBrr", LIEF::assembly::x86::OPCODE::MMX_PSUBUSBrr)
  .value("MMX_PSUBUSWrm", LIEF::assembly::x86::OPCODE::MMX_PSUBUSWrm)
  .value("MMX_PSUBUSWrr", LIEF::assembly::x86::OPCODE::MMX_PSUBUSWrr)
  .value("MMX_PSUBWrm", LIEF::assembly::x86::OPCODE::MMX_PSUBWrm)
  .value("MMX_PSUBWrr", LIEF::assembly::x86::OPCODE::MMX_PSUBWrr)
  .value("MMX_PUNPCKHBWrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHBWrm)
  .value("MMX_PUNPCKHBWrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHBWrr)
  .value("MMX_PUNPCKHDQrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHDQrm)
  .value("MMX_PUNPCKHDQrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHDQrr)
  .value("MMX_PUNPCKHWDrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHWDrm)
  .value("MMX_PUNPCKHWDrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKHWDrr)
  .value("MMX_PUNPCKLBWrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLBWrm)
  .value("MMX_PUNPCKLBWrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLBWrr)
  .value("MMX_PUNPCKLDQrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLDQrm)
  .value("MMX_PUNPCKLDQrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLDQrr)
  .value("MMX_PUNPCKLWDrm", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLWDrm)
  .value("MMX_PUNPCKLWDrr", LIEF::assembly::x86::OPCODE::MMX_PUNPCKLWDrr)
  .value("MMX_PXORrm", LIEF::assembly::x86::OPCODE::MMX_PXORrm)
  .value("MMX_PXORrr", LIEF::assembly::x86::OPCODE::MMX_PXORrr)
  .value("MONITOR32rrr", LIEF::assembly::x86::OPCODE::MONITOR32rrr)
  .value("MONITOR64rrr", LIEF::assembly::x86::OPCODE::MONITOR64rrr)
  .value("MONITORX32rrr", LIEF::assembly::x86::OPCODE::MONITORX32rrr)
  .value("MONITORX64rrr", LIEF::assembly::x86::OPCODE::MONITORX64rrr)
  .value("MONTMUL", LIEF::assembly::x86::OPCODE::MONTMUL)
  .value("MOV16ao16", LIEF::assembly::x86::OPCODE::MOV16ao16)
  .value("MOV16ao32", LIEF::assembly::x86::OPCODE::MOV16ao32)
  .value("MOV16ao64", LIEF::assembly::x86::OPCODE::MOV16ao64)
  .value("MOV16mi", LIEF::assembly::x86::OPCODE::MOV16mi)
  .value("MOV16mr", LIEF::assembly::x86::OPCODE::MOV16mr)
  .value("MOV16ms", LIEF::assembly::x86::OPCODE::MOV16ms)
  .value("MOV16o16a", LIEF::assembly::x86::OPCODE::MOV16o16a)
  .value("MOV16o32a", LIEF::assembly::x86::OPCODE::MOV16o32a)
  .value("MOV16o64a", LIEF::assembly::x86::OPCODE::MOV16o64a)
  .value("MOV16ri", LIEF::assembly::x86::OPCODE::MOV16ri)
  .value("MOV16ri_alt", LIEF::assembly::x86::OPCODE::MOV16ri_alt)
  .value("MOV16rm", LIEF::assembly::x86::OPCODE::MOV16rm)
  .value("MOV16rr", LIEF::assembly::x86::OPCODE::MOV16rr)
  .value("MOV16rr_REV", LIEF::assembly::x86::OPCODE::MOV16rr_REV)
  .value("MOV16rs", LIEF::assembly::x86::OPCODE::MOV16rs)
  .value("MOV16sm", LIEF::assembly::x86::OPCODE::MOV16sm)
  .value("MOV16sr", LIEF::assembly::x86::OPCODE::MOV16sr)
  .value("MOV32ao16", LIEF::assembly::x86::OPCODE::MOV32ao16)
  .value("MOV32ao32", LIEF::assembly::x86::OPCODE::MOV32ao32)
  .value("MOV32ao64", LIEF::assembly::x86::OPCODE::MOV32ao64)
  .value("MOV32cr", LIEF::assembly::x86::OPCODE::MOV32cr)
  .value("MOV32dr", LIEF::assembly::x86::OPCODE::MOV32dr)
  .value("MOV32mi", LIEF::assembly::x86::OPCODE::MOV32mi)
  .value("MOV32mr", LIEF::assembly::x86::OPCODE::MOV32mr)
  .value("MOV32o16a", LIEF::assembly::x86::OPCODE::MOV32o16a)
  .value("MOV32o32a", LIEF::assembly::x86::OPCODE::MOV32o32a)
  .value("MOV32o64a", LIEF::assembly::x86::OPCODE::MOV32o64a)
  .value("MOV32rc", LIEF::assembly::x86::OPCODE::MOV32rc)
  .value("MOV32rd", LIEF::assembly::x86::OPCODE::MOV32rd)
  .value("MOV32ri", LIEF::assembly::x86::OPCODE::MOV32ri)
  .value("MOV32ri_alt", LIEF::assembly::x86::OPCODE::MOV32ri_alt)
  .value("MOV32rm", LIEF::assembly::x86::OPCODE::MOV32rm)
  .value("MOV32rr", LIEF::assembly::x86::OPCODE::MOV32rr)
  .value("MOV32rr_REV", LIEF::assembly::x86::OPCODE::MOV32rr_REV)
  .value("MOV32rs", LIEF::assembly::x86::OPCODE::MOV32rs)
  .value("MOV32sr", LIEF::assembly::x86::OPCODE::MOV32sr)
  .value("MOV64ao32", LIEF::assembly::x86::OPCODE::MOV64ao32)
  .value("MOV64ao64", LIEF::assembly::x86::OPCODE::MOV64ao64)
  .value("MOV64cr", LIEF::assembly::x86::OPCODE::MOV64cr)
  .value("MOV64dr", LIEF::assembly::x86::OPCODE::MOV64dr)
  .value("MOV64mi32", LIEF::assembly::x86::OPCODE::MOV64mi32)
  .value("MOV64mr", LIEF::assembly::x86::OPCODE::MOV64mr)
  .value("MOV64o32a", LIEF::assembly::x86::OPCODE::MOV64o32a)
  .value("MOV64o64a", LIEF::assembly::x86::OPCODE::MOV64o64a)
  .value("MOV64rc", LIEF::assembly::x86::OPCODE::MOV64rc)
  .value("MOV64rd", LIEF::assembly::x86::OPCODE::MOV64rd)
  .value("MOV64ri", LIEF::assembly::x86::OPCODE::MOV64ri)
  .value("MOV64ri32", LIEF::assembly::x86::OPCODE::MOV64ri32)
  .value("MOV64rm", LIEF::assembly::x86::OPCODE::MOV64rm)
  .value("MOV64rr", LIEF::assembly::x86::OPCODE::MOV64rr)
  .value("MOV64rr_REV", LIEF::assembly::x86::OPCODE::MOV64rr_REV)
  .value("MOV64rs", LIEF::assembly::x86::OPCODE::MOV64rs)
  .value("MOV64sr", LIEF::assembly::x86::OPCODE::MOV64sr)
  .value("MOV64toPQIrm", LIEF::assembly::x86::OPCODE::MOV64toPQIrm)
  .value("MOV64toPQIrr", LIEF::assembly::x86::OPCODE::MOV64toPQIrr)
  .value("MOV64toSDrr", LIEF::assembly::x86::OPCODE::MOV64toSDrr)
  .value("MOV8ao16", LIEF::assembly::x86::OPCODE::MOV8ao16)
  .value("MOV8ao32", LIEF::assembly::x86::OPCODE::MOV8ao32)
  .value("MOV8ao64", LIEF::assembly::x86::OPCODE::MOV8ao64)
  .value("MOV8mi", LIEF::assembly::x86::OPCODE::MOV8mi)
  .value("MOV8mr", LIEF::assembly::x86::OPCODE::MOV8mr)
  .value("MOV8mr_NOREX", LIEF::assembly::x86::OPCODE::MOV8mr_NOREX)
  .value("MOV8o16a", LIEF::assembly::x86::OPCODE::MOV8o16a)
  .value("MOV8o32a", LIEF::assembly::x86::OPCODE::MOV8o32a)
  .value("MOV8o64a", LIEF::assembly::x86::OPCODE::MOV8o64a)
  .value("MOV8ri", LIEF::assembly::x86::OPCODE::MOV8ri)
  .value("MOV8ri_alt", LIEF::assembly::x86::OPCODE::MOV8ri_alt)
  .value("MOV8rm", LIEF::assembly::x86::OPCODE::MOV8rm)
  .value("MOV8rm_NOREX", LIEF::assembly::x86::OPCODE::MOV8rm_NOREX)
  .value("MOV8rr", LIEF::assembly::x86::OPCODE::MOV8rr)
  .value("MOV8rr_NOREX", LIEF::assembly::x86::OPCODE::MOV8rr_NOREX)
  .value("MOV8rr_REV", LIEF::assembly::x86::OPCODE::MOV8rr_REV)
  .value("MOVAPDmr", LIEF::assembly::x86::OPCODE::MOVAPDmr)
  .value("MOVAPDrm", LIEF::assembly::x86::OPCODE::MOVAPDrm)
  .value("MOVAPDrr", LIEF::assembly::x86::OPCODE::MOVAPDrr)
  .value("MOVAPDrr_REV", LIEF::assembly::x86::OPCODE::MOVAPDrr_REV)
  .value("MOVAPSmr", LIEF::assembly::x86::OPCODE::MOVAPSmr)
  .value("MOVAPSrm", LIEF::assembly::x86::OPCODE::MOVAPSrm)
  .value("MOVAPSrr", LIEF::assembly::x86::OPCODE::MOVAPSrr)
  .value("MOVAPSrr_REV", LIEF::assembly::x86::OPCODE::MOVAPSrr_REV)
  .value("MOVBE16mr", LIEF::assembly::x86::OPCODE::MOVBE16mr)
  .value("MOVBE16mr_EVEX", LIEF::assembly::x86::OPCODE::MOVBE16mr_EVEX)
  .value("MOVBE16rm", LIEF::assembly::x86::OPCODE::MOVBE16rm)
  .value("MOVBE16rm_EVEX", LIEF::assembly::x86::OPCODE::MOVBE16rm_EVEX)
  .value("MOVBE16rr", LIEF::assembly::x86::OPCODE::MOVBE16rr)
  .value("MOVBE16rr_REV", LIEF::assembly::x86::OPCODE::MOVBE16rr_REV)
  .value("MOVBE32mr", LIEF::assembly::x86::OPCODE::MOVBE32mr)
  .value("MOVBE32mr_EVEX", LIEF::assembly::x86::OPCODE::MOVBE32mr_EVEX)
  .value("MOVBE32rm", LIEF::assembly::x86::OPCODE::MOVBE32rm)
  .value("MOVBE32rm_EVEX", LIEF::assembly::x86::OPCODE::MOVBE32rm_EVEX)
  .value("MOVBE32rr", LIEF::assembly::x86::OPCODE::MOVBE32rr)
  .value("MOVBE32rr_REV", LIEF::assembly::x86::OPCODE::MOVBE32rr_REV)
  .value("MOVBE64mr", LIEF::assembly::x86::OPCODE::MOVBE64mr)
  .value("MOVBE64mr_EVEX", LIEF::assembly::x86::OPCODE::MOVBE64mr_EVEX)
  .value("MOVBE64rm", LIEF::assembly::x86::OPCODE::MOVBE64rm)
  .value("MOVBE64rm_EVEX", LIEF::assembly::x86::OPCODE::MOVBE64rm_EVEX)
  .value("MOVBE64rr", LIEF::assembly::x86::OPCODE::MOVBE64rr)
  .value("MOVBE64rr_REV", LIEF::assembly::x86::OPCODE::MOVBE64rr_REV)
  .value("MOVDDUPrm", LIEF::assembly::x86::OPCODE::MOVDDUPrm)
  .value("MOVDDUPrr", LIEF::assembly::x86::OPCODE::MOVDDUPrr)
  .value("MOVDI2PDIrm", LIEF::assembly::x86::OPCODE::MOVDI2PDIrm)
  .value("MOVDI2PDIrr", LIEF::assembly::x86::OPCODE::MOVDI2PDIrr)
  .value("MOVDI2SSrr", LIEF::assembly::x86::OPCODE::MOVDI2SSrr)
  .value("MOVDIR64B16", LIEF::assembly::x86::OPCODE::MOVDIR64B16)
  .value("MOVDIR64B32", LIEF::assembly::x86::OPCODE::MOVDIR64B32)
  .value("MOVDIR64B32_EVEX", LIEF::assembly::x86::OPCODE::MOVDIR64B32_EVEX)
  .value("MOVDIR64B64", LIEF::assembly::x86::OPCODE::MOVDIR64B64)
  .value("MOVDIR64B64_EVEX", LIEF::assembly::x86::OPCODE::MOVDIR64B64_EVEX)
  .value("MOVDIRI32", LIEF::assembly::x86::OPCODE::MOVDIRI32)
  .value("MOVDIRI32_EVEX", LIEF::assembly::x86::OPCODE::MOVDIRI32_EVEX)
  .value("MOVDIRI64", LIEF::assembly::x86::OPCODE::MOVDIRI64)
  .value("MOVDIRI64_EVEX", LIEF::assembly::x86::OPCODE::MOVDIRI64_EVEX)
  .value("MOVDQAmr", LIEF::assembly::x86::OPCODE::MOVDQAmr)
  .value("MOVDQArm", LIEF::assembly::x86::OPCODE::MOVDQArm)
  .value("MOVDQArr", LIEF::assembly::x86::OPCODE::MOVDQArr)
  .value("MOVDQArr_REV", LIEF::assembly::x86::OPCODE::MOVDQArr_REV)
  .value("MOVDQUmr", LIEF::assembly::x86::OPCODE::MOVDQUmr)
  .value("MOVDQUrm", LIEF::assembly::x86::OPCODE::MOVDQUrm)
  .value("MOVDQUrr", LIEF::assembly::x86::OPCODE::MOVDQUrr)
  .value("MOVDQUrr_REV", LIEF::assembly::x86::OPCODE::MOVDQUrr_REV)
  .value("MOVHLPSrr", LIEF::assembly::x86::OPCODE::MOVHLPSrr)
  .value("MOVHPDmr", LIEF::assembly::x86::OPCODE::MOVHPDmr)
  .value("MOVHPDrm", LIEF::assembly::x86::OPCODE::MOVHPDrm)
  .value("MOVHPSmr", LIEF::assembly::x86::OPCODE::MOVHPSmr)
  .value("MOVHPSrm", LIEF::assembly::x86::OPCODE::MOVHPSrm)
  .value("MOVLHPSrr", LIEF::assembly::x86::OPCODE::MOVLHPSrr)
  .value("MOVLPDmr", LIEF::assembly::x86::OPCODE::MOVLPDmr)
  .value("MOVLPDrm", LIEF::assembly::x86::OPCODE::MOVLPDrm)
  .value("MOVLPSmr", LIEF::assembly::x86::OPCODE::MOVLPSmr)
  .value("MOVLPSrm", LIEF::assembly::x86::OPCODE::MOVLPSrm)
  .value("MOVMSKPDrr", LIEF::assembly::x86::OPCODE::MOVMSKPDrr)
  .value("MOVMSKPSrr", LIEF::assembly::x86::OPCODE::MOVMSKPSrr)
  .value("MOVNTDQArm", LIEF::assembly::x86::OPCODE::MOVNTDQArm)
  .value("MOVNTDQmr", LIEF::assembly::x86::OPCODE::MOVNTDQmr)
  .value("MOVNTI_64mr", LIEF::assembly::x86::OPCODE::MOVNTI_64mr)
  .value("MOVNTImr", LIEF::assembly::x86::OPCODE::MOVNTImr)
  .value("MOVNTPDmr", LIEF::assembly::x86::OPCODE::MOVNTPDmr)
  .value("MOVNTPSmr", LIEF::assembly::x86::OPCODE::MOVNTPSmr)
  .value("MOVNTSD", LIEF::assembly::x86::OPCODE::MOVNTSD)
  .value("MOVNTSS", LIEF::assembly::x86::OPCODE::MOVNTSS)
  .value("MOVPC32r", LIEF::assembly::x86::OPCODE::MOVPC32r)
  .value("MOVPDI2DImr", LIEF::assembly::x86::OPCODE::MOVPDI2DImr)
  .value("MOVPDI2DIrr", LIEF::assembly::x86::OPCODE::MOVPDI2DIrr)
  .value("MOVPQI2QImr", LIEF::assembly::x86::OPCODE::MOVPQI2QImr)
  .value("MOVPQI2QIrr", LIEF::assembly::x86::OPCODE::MOVPQI2QIrr)
  .value("MOVPQIto64mr", LIEF::assembly::x86::OPCODE::MOVPQIto64mr)
  .value("MOVPQIto64rr", LIEF::assembly::x86::OPCODE::MOVPQIto64rr)
  .value("MOVQI2PQIrm", LIEF::assembly::x86::OPCODE::MOVQI2PQIrm)
  .value("MOVRS16rm", LIEF::assembly::x86::OPCODE::MOVRS16rm)
  .value("MOVRS16rm_EVEX", LIEF::assembly::x86::OPCODE::MOVRS16rm_EVEX)
  .value("MOVRS32rm", LIEF::assembly::x86::OPCODE::MOVRS32rm)
  .value("MOVRS32rm_EVEX", LIEF::assembly::x86::OPCODE::MOVRS32rm_EVEX)
  .value("MOVRS64rm", LIEF::assembly::x86::OPCODE::MOVRS64rm)
  .value("MOVRS64rm_EVEX", LIEF::assembly::x86::OPCODE::MOVRS64rm_EVEX)
  .value("MOVRS8rm", LIEF::assembly::x86::OPCODE::MOVRS8rm)
  .value("MOVRS8rm_EVEX", LIEF::assembly::x86::OPCODE::MOVRS8rm_EVEX)
  .value("MOVSB", LIEF::assembly::x86::OPCODE::MOVSB)
  .value("MOVSDmr", LIEF::assembly::x86::OPCODE::MOVSDmr)
  .value("MOVSDrm", LIEF::assembly::x86::OPCODE::MOVSDrm)
  .value("MOVSDrm_alt", LIEF::assembly::x86::OPCODE::MOVSDrm_alt)
  .value("MOVSDrr", LIEF::assembly::x86::OPCODE::MOVSDrr)
  .value("MOVSDrr_REV", LIEF::assembly::x86::OPCODE::MOVSDrr_REV)
  .value("MOVSDto64rr", LIEF::assembly::x86::OPCODE::MOVSDto64rr)
  .value("MOVSHDUPrm", LIEF::assembly::x86::OPCODE::MOVSHDUPrm);
  opcodes.value("MOVSHDUPrr", LIEF::assembly::x86::OPCODE::MOVSHDUPrr)
  .value("MOVSL", LIEF::assembly::x86::OPCODE::MOVSL)
  .value("MOVSLDUPrm", LIEF::assembly::x86::OPCODE::MOVSLDUPrm)
  .value("MOVSLDUPrr", LIEF::assembly::x86::OPCODE::MOVSLDUPrr)
  .value("MOVSQ", LIEF::assembly::x86::OPCODE::MOVSQ)
  .value("MOVSS2DIrr", LIEF::assembly::x86::OPCODE::MOVSS2DIrr)
  .value("MOVSSmr", LIEF::assembly::x86::OPCODE::MOVSSmr)
  .value("MOVSSrm", LIEF::assembly::x86::OPCODE::MOVSSrm)
  .value("MOVSSrm_alt", LIEF::assembly::x86::OPCODE::MOVSSrm_alt)
  .value("MOVSSrr", LIEF::assembly::x86::OPCODE::MOVSSrr)
  .value("MOVSSrr_REV", LIEF::assembly::x86::OPCODE::MOVSSrr_REV)
  .value("MOVSW", LIEF::assembly::x86::OPCODE::MOVSW)
  .value("MOVSX16rm16", LIEF::assembly::x86::OPCODE::MOVSX16rm16)
  .value("MOVSX16rm32", LIEF::assembly::x86::OPCODE::MOVSX16rm32)
  .value("MOVSX16rm8", LIEF::assembly::x86::OPCODE::MOVSX16rm8)
  .value("MOVSX16rr16", LIEF::assembly::x86::OPCODE::MOVSX16rr16)
  .value("MOVSX16rr32", LIEF::assembly::x86::OPCODE::MOVSX16rr32)
  .value("MOVSX16rr8", LIEF::assembly::x86::OPCODE::MOVSX16rr8)
  .value("MOVSX32rm16", LIEF::assembly::x86::OPCODE::MOVSX32rm16)
  .value("MOVSX32rm32", LIEF::assembly::x86::OPCODE::MOVSX32rm32)
  .value("MOVSX32rm8", LIEF::assembly::x86::OPCODE::MOVSX32rm8)
  .value("MOVSX32rm8_NOREX", LIEF::assembly::x86::OPCODE::MOVSX32rm8_NOREX)
  .value("MOVSX32rr16", LIEF::assembly::x86::OPCODE::MOVSX32rr16)
  .value("MOVSX32rr32", LIEF::assembly::x86::OPCODE::MOVSX32rr32)
  .value("MOVSX32rr8", LIEF::assembly::x86::OPCODE::MOVSX32rr8)
  .value("MOVSX32rr8_NOREX", LIEF::assembly::x86::OPCODE::MOVSX32rr8_NOREX)
  .value("MOVSX64rm16", LIEF::assembly::x86::OPCODE::MOVSX64rm16)
  .value("MOVSX64rm32", LIEF::assembly::x86::OPCODE::MOVSX64rm32)
  .value("MOVSX64rm8", LIEF::assembly::x86::OPCODE::MOVSX64rm8)
  .value("MOVSX64rr16", LIEF::assembly::x86::OPCODE::MOVSX64rr16)
  .value("MOVSX64rr32", LIEF::assembly::x86::OPCODE::MOVSX64rr32)
  .value("MOVSX64rr8", LIEF::assembly::x86::OPCODE::MOVSX64rr8)
  .value("MOVUPDmr", LIEF::assembly::x86::OPCODE::MOVUPDmr)
  .value("MOVUPDrm", LIEF::assembly::x86::OPCODE::MOVUPDrm)
  .value("MOVUPDrr", LIEF::assembly::x86::OPCODE::MOVUPDrr)
  .value("MOVUPDrr_REV", LIEF::assembly::x86::OPCODE::MOVUPDrr_REV)
  .value("MOVUPSmr", LIEF::assembly::x86::OPCODE::MOVUPSmr)
  .value("MOVUPSrm", LIEF::assembly::x86::OPCODE::MOVUPSrm)
  .value("MOVUPSrr", LIEF::assembly::x86::OPCODE::MOVUPSrr)
  .value("MOVUPSrr_REV", LIEF::assembly::x86::OPCODE::MOVUPSrr_REV)
  .value("MOVZPQILo2PQIrr", LIEF::assembly::x86::OPCODE::MOVZPQILo2PQIrr)
  .value("MOVZX16rm16", LIEF::assembly::x86::OPCODE::MOVZX16rm16)
  .value("MOVZX16rm8", LIEF::assembly::x86::OPCODE::MOVZX16rm8)
  .value("MOVZX16rr16", LIEF::assembly::x86::OPCODE::MOVZX16rr16)
  .value("MOVZX16rr8", LIEF::assembly::x86::OPCODE::MOVZX16rr8)
  .value("MOVZX32rm16", LIEF::assembly::x86::OPCODE::MOVZX32rm16)
  .value("MOVZX32rm8", LIEF::assembly::x86::OPCODE::MOVZX32rm8)
  .value("MOVZX32rm8_NOREX", LIEF::assembly::x86::OPCODE::MOVZX32rm8_NOREX)
  .value("MOVZX32rr16", LIEF::assembly::x86::OPCODE::MOVZX32rr16)
  .value("MOVZX32rr8", LIEF::assembly::x86::OPCODE::MOVZX32rr8)
  .value("MOVZX32rr8_NOREX", LIEF::assembly::x86::OPCODE::MOVZX32rr8_NOREX)
  .value("MOVZX64rm16", LIEF::assembly::x86::OPCODE::MOVZX64rm16)
  .value("MOVZX64rm8", LIEF::assembly::x86::OPCODE::MOVZX64rm8)
  .value("MOVZX64rr16", LIEF::assembly::x86::OPCODE::MOVZX64rr16)
  .value("MOVZX64rr8", LIEF::assembly::x86::OPCODE::MOVZX64rr8)
  .value("MPSADBWrmi", LIEF::assembly::x86::OPCODE::MPSADBWrmi)
  .value("MPSADBWrri", LIEF::assembly::x86::OPCODE::MPSADBWrri)
  .value("MUL16m", LIEF::assembly::x86::OPCODE::MUL16m)
  .value("MUL16m_EVEX", LIEF::assembly::x86::OPCODE::MUL16m_EVEX)
  .value("MUL16m_NF", LIEF::assembly::x86::OPCODE::MUL16m_NF)
  .value("MUL16r", LIEF::assembly::x86::OPCODE::MUL16r)
  .value("MUL16r_EVEX", LIEF::assembly::x86::OPCODE::MUL16r_EVEX)
  .value("MUL16r_NF", LIEF::assembly::x86::OPCODE::MUL16r_NF)
  .value("MUL32m", LIEF::assembly::x86::OPCODE::MUL32m)
  .value("MUL32m_EVEX", LIEF::assembly::x86::OPCODE::MUL32m_EVEX)
  .value("MUL32m_NF", LIEF::assembly::x86::OPCODE::MUL32m_NF)
  .value("MUL32r", LIEF::assembly::x86::OPCODE::MUL32r)
  .value("MUL32r_EVEX", LIEF::assembly::x86::OPCODE::MUL32r_EVEX)
  .value("MUL32r_NF", LIEF::assembly::x86::OPCODE::MUL32r_NF)
  .value("MUL64m", LIEF::assembly::x86::OPCODE::MUL64m)
  .value("MUL64m_EVEX", LIEF::assembly::x86::OPCODE::MUL64m_EVEX)
  .value("MUL64m_NF", LIEF::assembly::x86::OPCODE::MUL64m_NF)
  .value("MUL64r", LIEF::assembly::x86::OPCODE::MUL64r)
  .value("MUL64r_EVEX", LIEF::assembly::x86::OPCODE::MUL64r_EVEX)
  .value("MUL64r_NF", LIEF::assembly::x86::OPCODE::MUL64r_NF)
  .value("MUL8m", LIEF::assembly::x86::OPCODE::MUL8m)
  .value("MUL8m_EVEX", LIEF::assembly::x86::OPCODE::MUL8m_EVEX)
  .value("MUL8m_NF", LIEF::assembly::x86::OPCODE::MUL8m_NF)
  .value("MUL8r", LIEF::assembly::x86::OPCODE::MUL8r)
  .value("MUL8r_EVEX", LIEF::assembly::x86::OPCODE::MUL8r_EVEX)
  .value("MUL8r_NF", LIEF::assembly::x86::OPCODE::MUL8r_NF)
  .value("MULPDrm", LIEF::assembly::x86::OPCODE::MULPDrm)
  .value("MULPDrr", LIEF::assembly::x86::OPCODE::MULPDrr)
  .value("MULPSrm", LIEF::assembly::x86::OPCODE::MULPSrm)
  .value("MULPSrr", LIEF::assembly::x86::OPCODE::MULPSrr)
  .value("MULSDrm", LIEF::assembly::x86::OPCODE::MULSDrm)
  .value("MULSDrm_Int", LIEF::assembly::x86::OPCODE::MULSDrm_Int)
  .value("MULSDrr", LIEF::assembly::x86::OPCODE::MULSDrr)
  .value("MULSDrr_Int", LIEF::assembly::x86::OPCODE::MULSDrr_Int)
  .value("MULSSrm", LIEF::assembly::x86::OPCODE::MULSSrm)
  .value("MULSSrm_Int", LIEF::assembly::x86::OPCODE::MULSSrm_Int)
  .value("MULSSrr", LIEF::assembly::x86::OPCODE::MULSSrr)
  .value("MULSSrr_Int", LIEF::assembly::x86::OPCODE::MULSSrr_Int)
  .value("MULX32Hrm", LIEF::assembly::x86::OPCODE::MULX32Hrm)
  .value("MULX32Hrr", LIEF::assembly::x86::OPCODE::MULX32Hrr)
  .value("MULX32rm", LIEF::assembly::x86::OPCODE::MULX32rm)
  .value("MULX32rm_EVEX", LIEF::assembly::x86::OPCODE::MULX32rm_EVEX)
  .value("MULX32rr", LIEF::assembly::x86::OPCODE::MULX32rr)
  .value("MULX32rr_EVEX", LIEF::assembly::x86::OPCODE::MULX32rr_EVEX)
  .value("MULX64Hrm", LIEF::assembly::x86::OPCODE::MULX64Hrm)
  .value("MULX64Hrr", LIEF::assembly::x86::OPCODE::MULX64Hrr)
  .value("MULX64rm", LIEF::assembly::x86::OPCODE::MULX64rm)
  .value("MULX64rm_EVEX", LIEF::assembly::x86::OPCODE::MULX64rm_EVEX)
  .value("MULX64rr", LIEF::assembly::x86::OPCODE::MULX64rr)
  .value("MULX64rr_EVEX", LIEF::assembly::x86::OPCODE::MULX64rr_EVEX)
  .value("MUL_F32m", LIEF::assembly::x86::OPCODE::MUL_F32m)
  .value("MUL_F64m", LIEF::assembly::x86::OPCODE::MUL_F64m)
  .value("MUL_FI16m", LIEF::assembly::x86::OPCODE::MUL_FI16m)
  .value("MUL_FI32m", LIEF::assembly::x86::OPCODE::MUL_FI32m)
  .value("MUL_FPrST0", LIEF::assembly::x86::OPCODE::MUL_FPrST0)
  .value("MUL_FST0r", LIEF::assembly::x86::OPCODE::MUL_FST0r)
  .value("MUL_Fp32", LIEF::assembly::x86::OPCODE::MUL_Fp32)
  .value("MUL_Fp32m", LIEF::assembly::x86::OPCODE::MUL_Fp32m)
  .value("MUL_Fp64", LIEF::assembly::x86::OPCODE::MUL_Fp64)
  .value("MUL_Fp64m", LIEF::assembly::x86::OPCODE::MUL_Fp64m)
  .value("MUL_Fp64m32", LIEF::assembly::x86::OPCODE::MUL_Fp64m32)
  .value("MUL_Fp80", LIEF::assembly::x86::OPCODE::MUL_Fp80)
  .value("MUL_Fp80m32", LIEF::assembly::x86::OPCODE::MUL_Fp80m32)
  .value("MUL_Fp80m64", LIEF::assembly::x86::OPCODE::MUL_Fp80m64)
  .value("MUL_FpI16m32", LIEF::assembly::x86::OPCODE::MUL_FpI16m32)
  .value("MUL_FpI16m64", LIEF::assembly::x86::OPCODE::MUL_FpI16m64)
  .value("MUL_FpI16m80", LIEF::assembly::x86::OPCODE::MUL_FpI16m80)
  .value("MUL_FpI32m32", LIEF::assembly::x86::OPCODE::MUL_FpI32m32)
  .value("MUL_FpI32m64", LIEF::assembly::x86::OPCODE::MUL_FpI32m64)
  .value("MUL_FpI32m80", LIEF::assembly::x86::OPCODE::MUL_FpI32m80)
  .value("MUL_FrST0", LIEF::assembly::x86::OPCODE::MUL_FrST0)
  .value("MWAITXrrr", LIEF::assembly::x86::OPCODE::MWAITXrrr)
  .value("MWAITrr", LIEF::assembly::x86::OPCODE::MWAITrr)
  .value("NEG16m", LIEF::assembly::x86::OPCODE::NEG16m)
  .value("NEG16m_EVEX", LIEF::assembly::x86::OPCODE::NEG16m_EVEX)
  .value("NEG16m_ND", LIEF::assembly::x86::OPCODE::NEG16m_ND)
  .value("NEG16m_NF", LIEF::assembly::x86::OPCODE::NEG16m_NF)
  .value("NEG16m_NF_ND", LIEF::assembly::x86::OPCODE::NEG16m_NF_ND)
  .value("NEG16r", LIEF::assembly::x86::OPCODE::NEG16r)
  .value("NEG16r_EVEX", LIEF::assembly::x86::OPCODE::NEG16r_EVEX)
  .value("NEG16r_ND", LIEF::assembly::x86::OPCODE::NEG16r_ND)
  .value("NEG16r_NF", LIEF::assembly::x86::OPCODE::NEG16r_NF)
  .value("NEG16r_NF_ND", LIEF::assembly::x86::OPCODE::NEG16r_NF_ND)
  .value("NEG32m", LIEF::assembly::x86::OPCODE::NEG32m)
  .value("NEG32m_EVEX", LIEF::assembly::x86::OPCODE::NEG32m_EVEX)
  .value("NEG32m_ND", LIEF::assembly::x86::OPCODE::NEG32m_ND)
  .value("NEG32m_NF", LIEF::assembly::x86::OPCODE::NEG32m_NF)
  .value("NEG32m_NF_ND", LIEF::assembly::x86::OPCODE::NEG32m_NF_ND)
  .value("NEG32r", LIEF::assembly::x86::OPCODE::NEG32r)
  .value("NEG32r_EVEX", LIEF::assembly::x86::OPCODE::NEG32r_EVEX)
  .value("NEG32r_ND", LIEF::assembly::x86::OPCODE::NEG32r_ND)
  .value("NEG32r_NF", LIEF::assembly::x86::OPCODE::NEG32r_NF)
  .value("NEG32r_NF_ND", LIEF::assembly::x86::OPCODE::NEG32r_NF_ND)
  .value("NEG64m", LIEF::assembly::x86::OPCODE::NEG64m)
  .value("NEG64m_EVEX", LIEF::assembly::x86::OPCODE::NEG64m_EVEX)
  .value("NEG64m_ND", LIEF::assembly::x86::OPCODE::NEG64m_ND)
  .value("NEG64m_NF", LIEF::assembly::x86::OPCODE::NEG64m_NF)
  .value("NEG64m_NF_ND", LIEF::assembly::x86::OPCODE::NEG64m_NF_ND)
  .value("NEG64r", LIEF::assembly::x86::OPCODE::NEG64r)
  .value("NEG64r_EVEX", LIEF::assembly::x86::OPCODE::NEG64r_EVEX)
  .value("NEG64r_ND", LIEF::assembly::x86::OPCODE::NEG64r_ND)
  .value("NEG64r_NF", LIEF::assembly::x86::OPCODE::NEG64r_NF)
  .value("NEG64r_NF_ND", LIEF::assembly::x86::OPCODE::NEG64r_NF_ND)
  .value("NEG8m", LIEF::assembly::x86::OPCODE::NEG8m)
  .value("NEG8m_EVEX", LIEF::assembly::x86::OPCODE::NEG8m_EVEX)
  .value("NEG8m_ND", LIEF::assembly::x86::OPCODE::NEG8m_ND)
  .value("NEG8m_NF", LIEF::assembly::x86::OPCODE::NEG8m_NF)
  .value("NEG8m_NF_ND", LIEF::assembly::x86::OPCODE::NEG8m_NF_ND)
  .value("NEG8r", LIEF::assembly::x86::OPCODE::NEG8r)
  .value("NEG8r_EVEX", LIEF::assembly::x86::OPCODE::NEG8r_EVEX)
  .value("NEG8r_ND", LIEF::assembly::x86::OPCODE::NEG8r_ND)
  .value("NEG8r_NF", LIEF::assembly::x86::OPCODE::NEG8r_NF)
  .value("NEG8r_NF_ND", LIEF::assembly::x86::OPCODE::NEG8r_NF_ND)
  .value("NOOP", LIEF::assembly::x86::OPCODE::NOOP)
  .value("NOOPL", LIEF::assembly::x86::OPCODE::NOOPL)
  .value("NOOPLr", LIEF::assembly::x86::OPCODE::NOOPLr)
  .value("NOOPQ", LIEF::assembly::x86::OPCODE::NOOPQ)
  .value("NOOPQr", LIEF::assembly::x86::OPCODE::NOOPQr)
  .value("NOOPW", LIEF::assembly::x86::OPCODE::NOOPW)
  .value("NOOPWr", LIEF::assembly::x86::OPCODE::NOOPWr)
  .value("NOT16m", LIEF::assembly::x86::OPCODE::NOT16m)
  .value("NOT16m_EVEX", LIEF::assembly::x86::OPCODE::NOT16m_EVEX)
  .value("NOT16m_ND", LIEF::assembly::x86::OPCODE::NOT16m_ND)
  .value("NOT16r", LIEF::assembly::x86::OPCODE::NOT16r)
  .value("NOT16r_EVEX", LIEF::assembly::x86::OPCODE::NOT16r_EVEX)
  .value("NOT16r_ND", LIEF::assembly::x86::OPCODE::NOT16r_ND)
  .value("NOT32m", LIEF::assembly::x86::OPCODE::NOT32m)
  .value("NOT32m_EVEX", LIEF::assembly::x86::OPCODE::NOT32m_EVEX)
  .value("NOT32m_ND", LIEF::assembly::x86::OPCODE::NOT32m_ND)
  .value("NOT32r", LIEF::assembly::x86::OPCODE::NOT32r)
  .value("NOT32r_EVEX", LIEF::assembly::x86::OPCODE::NOT32r_EVEX)
  .value("NOT32r_ND", LIEF::assembly::x86::OPCODE::NOT32r_ND)
  .value("NOT64m", LIEF::assembly::x86::OPCODE::NOT64m)
  .value("NOT64m_EVEX", LIEF::assembly::x86::OPCODE::NOT64m_EVEX)
  .value("NOT64m_ND", LIEF::assembly::x86::OPCODE::NOT64m_ND)
  .value("NOT64r", LIEF::assembly::x86::OPCODE::NOT64r)
  .value("NOT64r_EVEX", LIEF::assembly::x86::OPCODE::NOT64r_EVEX)
  .value("NOT64r_ND", LIEF::assembly::x86::OPCODE::NOT64r_ND)
  .value("NOT8m", LIEF::assembly::x86::OPCODE::NOT8m)
  .value("NOT8m_EVEX", LIEF::assembly::x86::OPCODE::NOT8m_EVEX)
  .value("NOT8m_ND", LIEF::assembly::x86::OPCODE::NOT8m_ND)
  .value("NOT8r", LIEF::assembly::x86::OPCODE::NOT8r)
  .value("NOT8r_EVEX", LIEF::assembly::x86::OPCODE::NOT8r_EVEX)
  .value("NOT8r_ND", LIEF::assembly::x86::OPCODE::NOT8r_ND)
  .value("OR16i16", LIEF::assembly::x86::OPCODE::OR16i16)
  .value("OR16mi", LIEF::assembly::x86::OPCODE::OR16mi)
  .value("OR16mi8", LIEF::assembly::x86::OPCODE::OR16mi8)
  .value("OR16mi8_EVEX", LIEF::assembly::x86::OPCODE::OR16mi8_EVEX)
  .value("OR16mi8_ND", LIEF::assembly::x86::OPCODE::OR16mi8_ND)
  .value("OR16mi8_NF", LIEF::assembly::x86::OPCODE::OR16mi8_NF)
  .value("OR16mi8_NF_ND", LIEF::assembly::x86::OPCODE::OR16mi8_NF_ND)
  .value("OR16mi_EVEX", LIEF::assembly::x86::OPCODE::OR16mi_EVEX)
  .value("OR16mi_ND", LIEF::assembly::x86::OPCODE::OR16mi_ND)
  .value("OR16mi_NF", LIEF::assembly::x86::OPCODE::OR16mi_NF)
  .value("OR16mi_NF_ND", LIEF::assembly::x86::OPCODE::OR16mi_NF_ND)
  .value("OR16mr", LIEF::assembly::x86::OPCODE::OR16mr)
  .value("OR16mr_EVEX", LIEF::assembly::x86::OPCODE::OR16mr_EVEX)
  .value("OR16mr_ND", LIEF::assembly::x86::OPCODE::OR16mr_ND)
  .value("OR16mr_NF", LIEF::assembly::x86::OPCODE::OR16mr_NF)
  .value("OR16mr_NF_ND", LIEF::assembly::x86::OPCODE::OR16mr_NF_ND)
  .value("OR16ri", LIEF::assembly::x86::OPCODE::OR16ri)
  .value("OR16ri8", LIEF::assembly::x86::OPCODE::OR16ri8)
  .value("OR16ri8_EVEX", LIEF::assembly::x86::OPCODE::OR16ri8_EVEX)
  .value("OR16ri8_ND", LIEF::assembly::x86::OPCODE::OR16ri8_ND)
  .value("OR16ri8_NF", LIEF::assembly::x86::OPCODE::OR16ri8_NF)
  .value("OR16ri8_NF_ND", LIEF::assembly::x86::OPCODE::OR16ri8_NF_ND)
  .value("OR16ri_EVEX", LIEF::assembly::x86::OPCODE::OR16ri_EVEX)
  .value("OR16ri_ND", LIEF::assembly::x86::OPCODE::OR16ri_ND)
  .value("OR16ri_NF", LIEF::assembly::x86::OPCODE::OR16ri_NF)
  .value("OR16ri_NF_ND", LIEF::assembly::x86::OPCODE::OR16ri_NF_ND)
  .value("OR16rm", LIEF::assembly::x86::OPCODE::OR16rm)
  .value("OR16rm_EVEX", LIEF::assembly::x86::OPCODE::OR16rm_EVEX)
  .value("OR16rm_ND", LIEF::assembly::x86::OPCODE::OR16rm_ND)
  .value("OR16rm_NF", LIEF::assembly::x86::OPCODE::OR16rm_NF)
  .value("OR16rm_NF_ND", LIEF::assembly::x86::OPCODE::OR16rm_NF_ND)
  .value("OR16rr", LIEF::assembly::x86::OPCODE::OR16rr)
  .value("OR16rr_EVEX", LIEF::assembly::x86::OPCODE::OR16rr_EVEX)
  .value("OR16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::OR16rr_EVEX_REV)
  .value("OR16rr_ND", LIEF::assembly::x86::OPCODE::OR16rr_ND)
  .value("OR16rr_ND_REV", LIEF::assembly::x86::OPCODE::OR16rr_ND_REV)
  .value("OR16rr_NF", LIEF::assembly::x86::OPCODE::OR16rr_NF)
  .value("OR16rr_NF_ND", LIEF::assembly::x86::OPCODE::OR16rr_NF_ND)
  .value("OR16rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::OR16rr_NF_ND_REV)
  .value("OR16rr_NF_REV", LIEF::assembly::x86::OPCODE::OR16rr_NF_REV)
  .value("OR16rr_REV", LIEF::assembly::x86::OPCODE::OR16rr_REV)
  .value("OR32i32", LIEF::assembly::x86::OPCODE::OR32i32)
  .value("OR32mi", LIEF::assembly::x86::OPCODE::OR32mi)
  .value("OR32mi8", LIEF::assembly::x86::OPCODE::OR32mi8)
  .value("OR32mi8Locked", LIEF::assembly::x86::OPCODE::OR32mi8Locked)
  .value("OR32mi8_EVEX", LIEF::assembly::x86::OPCODE::OR32mi8_EVEX)
  .value("OR32mi8_ND", LIEF::assembly::x86::OPCODE::OR32mi8_ND)
  .value("OR32mi8_NF", LIEF::assembly::x86::OPCODE::OR32mi8_NF)
  .value("OR32mi8_NF_ND", LIEF::assembly::x86::OPCODE::OR32mi8_NF_ND)
  .value("OR32mi_EVEX", LIEF::assembly::x86::OPCODE::OR32mi_EVEX)
  .value("OR32mi_ND", LIEF::assembly::x86::OPCODE::OR32mi_ND)
  .value("OR32mi_NF", LIEF::assembly::x86::OPCODE::OR32mi_NF)
  .value("OR32mi_NF_ND", LIEF::assembly::x86::OPCODE::OR32mi_NF_ND)
  .value("OR32mr", LIEF::assembly::x86::OPCODE::OR32mr)
  .value("OR32mr_EVEX", LIEF::assembly::x86::OPCODE::OR32mr_EVEX)
  .value("OR32mr_ND", LIEF::assembly::x86::OPCODE::OR32mr_ND)
  .value("OR32mr_NF", LIEF::assembly::x86::OPCODE::OR32mr_NF)
  .value("OR32mr_NF_ND", LIEF::assembly::x86::OPCODE::OR32mr_NF_ND)
  .value("OR32ri", LIEF::assembly::x86::OPCODE::OR32ri)
  .value("OR32ri8", LIEF::assembly::x86::OPCODE::OR32ri8)
  .value("OR32ri8_EVEX", LIEF::assembly::x86::OPCODE::OR32ri8_EVEX)
  .value("OR32ri8_ND", LIEF::assembly::x86::OPCODE::OR32ri8_ND)
  .value("OR32ri8_NF", LIEF::assembly::x86::OPCODE::OR32ri8_NF)
  .value("OR32ri8_NF_ND", LIEF::assembly::x86::OPCODE::OR32ri8_NF_ND)
  .value("OR32ri_EVEX", LIEF::assembly::x86::OPCODE::OR32ri_EVEX)
  .value("OR32ri_ND", LIEF::assembly::x86::OPCODE::OR32ri_ND)
  .value("OR32ri_NF", LIEF::assembly::x86::OPCODE::OR32ri_NF)
  .value("OR32ri_NF_ND", LIEF::assembly::x86::OPCODE::OR32ri_NF_ND)
  .value("OR32rm", LIEF::assembly::x86::OPCODE::OR32rm)
  .value("OR32rm_EVEX", LIEF::assembly::x86::OPCODE::OR32rm_EVEX)
  .value("OR32rm_ND", LIEF::assembly::x86::OPCODE::OR32rm_ND)
  .value("OR32rm_NF", LIEF::assembly::x86::OPCODE::OR32rm_NF)
  .value("OR32rm_NF_ND", LIEF::assembly::x86::OPCODE::OR32rm_NF_ND)
  .value("OR32rr", LIEF::assembly::x86::OPCODE::OR32rr)
  .value("OR32rr_EVEX", LIEF::assembly::x86::OPCODE::OR32rr_EVEX)
  .value("OR32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::OR32rr_EVEX_REV)
  .value("OR32rr_ND", LIEF::assembly::x86::OPCODE::OR32rr_ND)
  .value("OR32rr_ND_REV", LIEF::assembly::x86::OPCODE::OR32rr_ND_REV)
  .value("OR32rr_NF", LIEF::assembly::x86::OPCODE::OR32rr_NF)
  .value("OR32rr_NF_ND", LIEF::assembly::x86::OPCODE::OR32rr_NF_ND)
  .value("OR32rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::OR32rr_NF_ND_REV)
  .value("OR32rr_NF_REV", LIEF::assembly::x86::OPCODE::OR32rr_NF_REV)
  .value("OR32rr_REV", LIEF::assembly::x86::OPCODE::OR32rr_REV)
  .value("OR64i32", LIEF::assembly::x86::OPCODE::OR64i32)
  .value("OR64mi32", LIEF::assembly::x86::OPCODE::OR64mi32)
  .value("OR64mi32_EVEX", LIEF::assembly::x86::OPCODE::OR64mi32_EVEX)
  .value("OR64mi32_ND", LIEF::assembly::x86::OPCODE::OR64mi32_ND)
  .value("OR64mi32_NF", LIEF::assembly::x86::OPCODE::OR64mi32_NF)
  .value("OR64mi32_NF_ND", LIEF::assembly::x86::OPCODE::OR64mi32_NF_ND)
  .value("OR64mi8", LIEF::assembly::x86::OPCODE::OR64mi8)
  .value("OR64mi8_EVEX", LIEF::assembly::x86::OPCODE::OR64mi8_EVEX)
  .value("OR64mi8_ND", LIEF::assembly::x86::OPCODE::OR64mi8_ND)
  .value("OR64mi8_NF", LIEF::assembly::x86::OPCODE::OR64mi8_NF)
  .value("OR64mi8_NF_ND", LIEF::assembly::x86::OPCODE::OR64mi8_NF_ND)
  .value("OR64mr", LIEF::assembly::x86::OPCODE::OR64mr)
  .value("OR64mr_EVEX", LIEF::assembly::x86::OPCODE::OR64mr_EVEX)
  .value("OR64mr_ND", LIEF::assembly::x86::OPCODE::OR64mr_ND)
  .value("OR64mr_NF", LIEF::assembly::x86::OPCODE::OR64mr_NF)
  .value("OR64mr_NF_ND", LIEF::assembly::x86::OPCODE::OR64mr_NF_ND)
  .value("OR64ri32", LIEF::assembly::x86::OPCODE::OR64ri32)
  .value("OR64ri32_EVEX", LIEF::assembly::x86::OPCODE::OR64ri32_EVEX);
  opcodes.value("OR64ri32_ND", LIEF::assembly::x86::OPCODE::OR64ri32_ND)
  .value("OR64ri32_NF", LIEF::assembly::x86::OPCODE::OR64ri32_NF)
  .value("OR64ri32_NF_ND", LIEF::assembly::x86::OPCODE::OR64ri32_NF_ND)
  .value("OR64ri8", LIEF::assembly::x86::OPCODE::OR64ri8)
  .value("OR64ri8_EVEX", LIEF::assembly::x86::OPCODE::OR64ri8_EVEX)
  .value("OR64ri8_ND", LIEF::assembly::x86::OPCODE::OR64ri8_ND)
  .value("OR64ri8_NF", LIEF::assembly::x86::OPCODE::OR64ri8_NF)
  .value("OR64ri8_NF_ND", LIEF::assembly::x86::OPCODE::OR64ri8_NF_ND)
  .value("OR64rm", LIEF::assembly::x86::OPCODE::OR64rm)
  .value("OR64rm_EVEX", LIEF::assembly::x86::OPCODE::OR64rm_EVEX)
  .value("OR64rm_ND", LIEF::assembly::x86::OPCODE::OR64rm_ND)
  .value("OR64rm_NF", LIEF::assembly::x86::OPCODE::OR64rm_NF)
  .value("OR64rm_NF_ND", LIEF::assembly::x86::OPCODE::OR64rm_NF_ND)
  .value("OR64rr", LIEF::assembly::x86::OPCODE::OR64rr)
  .value("OR64rr_EVEX", LIEF::assembly::x86::OPCODE::OR64rr_EVEX)
  .value("OR64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::OR64rr_EVEX_REV)
  .value("OR64rr_ND", LIEF::assembly::x86::OPCODE::OR64rr_ND)
  .value("OR64rr_ND_REV", LIEF::assembly::x86::OPCODE::OR64rr_ND_REV)
  .value("OR64rr_NF", LIEF::assembly::x86::OPCODE::OR64rr_NF)
  .value("OR64rr_NF_ND", LIEF::assembly::x86::OPCODE::OR64rr_NF_ND)
  .value("OR64rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::OR64rr_NF_ND_REV)
  .value("OR64rr_NF_REV", LIEF::assembly::x86::OPCODE::OR64rr_NF_REV)
  .value("OR64rr_REV", LIEF::assembly::x86::OPCODE::OR64rr_REV)
  .value("OR8i8", LIEF::assembly::x86::OPCODE::OR8i8)
  .value("OR8mi", LIEF::assembly::x86::OPCODE::OR8mi)
  .value("OR8mi8", LIEF::assembly::x86::OPCODE::OR8mi8)
  .value("OR8mi_EVEX", LIEF::assembly::x86::OPCODE::OR8mi_EVEX)
  .value("OR8mi_ND", LIEF::assembly::x86::OPCODE::OR8mi_ND)
  .value("OR8mi_NF", LIEF::assembly::x86::OPCODE::OR8mi_NF)
  .value("OR8mi_NF_ND", LIEF::assembly::x86::OPCODE::OR8mi_NF_ND)
  .value("OR8mr", LIEF::assembly::x86::OPCODE::OR8mr)
  .value("OR8mr_EVEX", LIEF::assembly::x86::OPCODE::OR8mr_EVEX)
  .value("OR8mr_ND", LIEF::assembly::x86::OPCODE::OR8mr_ND)
  .value("OR8mr_NF", LIEF::assembly::x86::OPCODE::OR8mr_NF)
  .value("OR8mr_NF_ND", LIEF::assembly::x86::OPCODE::OR8mr_NF_ND)
  .value("OR8ri", LIEF::assembly::x86::OPCODE::OR8ri)
  .value("OR8ri8", LIEF::assembly::x86::OPCODE::OR8ri8)
  .value("OR8ri_EVEX", LIEF::assembly::x86::OPCODE::OR8ri_EVEX)
  .value("OR8ri_ND", LIEF::assembly::x86::OPCODE::OR8ri_ND)
  .value("OR8ri_NF", LIEF::assembly::x86::OPCODE::OR8ri_NF)
  .value("OR8ri_NF_ND", LIEF::assembly::x86::OPCODE::OR8ri_NF_ND)
  .value("OR8rm", LIEF::assembly::x86::OPCODE::OR8rm)
  .value("OR8rm_EVEX", LIEF::assembly::x86::OPCODE::OR8rm_EVEX)
  .value("OR8rm_ND", LIEF::assembly::x86::OPCODE::OR8rm_ND)
  .value("OR8rm_NF", LIEF::assembly::x86::OPCODE::OR8rm_NF)
  .value("OR8rm_NF_ND", LIEF::assembly::x86::OPCODE::OR8rm_NF_ND)
  .value("OR8rr", LIEF::assembly::x86::OPCODE::OR8rr)
  .value("OR8rr_EVEX", LIEF::assembly::x86::OPCODE::OR8rr_EVEX)
  .value("OR8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::OR8rr_EVEX_REV)
  .value("OR8rr_ND", LIEF::assembly::x86::OPCODE::OR8rr_ND)
  .value("OR8rr_ND_REV", LIEF::assembly::x86::OPCODE::OR8rr_ND_REV)
  .value("OR8rr_NF", LIEF::assembly::x86::OPCODE::OR8rr_NF)
  .value("OR8rr_NF_ND", LIEF::assembly::x86::OPCODE::OR8rr_NF_ND)
  .value("OR8rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::OR8rr_NF_ND_REV)
  .value("OR8rr_NF_REV", LIEF::assembly::x86::OPCODE::OR8rr_NF_REV)
  .value("OR8rr_REV", LIEF::assembly::x86::OPCODE::OR8rr_REV)
  .value("ORPDrm", LIEF::assembly::x86::OPCODE::ORPDrm)
  .value("ORPDrr", LIEF::assembly::x86::OPCODE::ORPDrr)
  .value("ORPSrm", LIEF::assembly::x86::OPCODE::ORPSrm)
  .value("ORPSrr", LIEF::assembly::x86::OPCODE::ORPSrr)
  .value("OUT16ir", LIEF::assembly::x86::OPCODE::OUT16ir)
  .value("OUT16rr", LIEF::assembly::x86::OPCODE::OUT16rr)
  .value("OUT32ir", LIEF::assembly::x86::OPCODE::OUT32ir)
  .value("OUT32rr", LIEF::assembly::x86::OPCODE::OUT32rr)
  .value("OUT8ir", LIEF::assembly::x86::OPCODE::OUT8ir)
  .value("OUT8rr", LIEF::assembly::x86::OPCODE::OUT8rr)
  .value("OUTSB", LIEF::assembly::x86::OPCODE::OUTSB)
  .value("OUTSL", LIEF::assembly::x86::OPCODE::OUTSL)
  .value("OUTSW", LIEF::assembly::x86::OPCODE::OUTSW)
  .value("PABSBrm", LIEF::assembly::x86::OPCODE::PABSBrm)
  .value("PABSBrr", LIEF::assembly::x86::OPCODE::PABSBrr)
  .value("PABSDrm", LIEF::assembly::x86::OPCODE::PABSDrm)
  .value("PABSDrr", LIEF::assembly::x86::OPCODE::PABSDrr)
  .value("PABSWrm", LIEF::assembly::x86::OPCODE::PABSWrm)
  .value("PABSWrr", LIEF::assembly::x86::OPCODE::PABSWrr)
  .value("PACKSSDWrm", LIEF::assembly::x86::OPCODE::PACKSSDWrm)
  .value("PACKSSDWrr", LIEF::assembly::x86::OPCODE::PACKSSDWrr)
  .value("PACKSSWBrm", LIEF::assembly::x86::OPCODE::PACKSSWBrm)
  .value("PACKSSWBrr", LIEF::assembly::x86::OPCODE::PACKSSWBrr)
  .value("PACKUSDWrm", LIEF::assembly::x86::OPCODE::PACKUSDWrm)
  .value("PACKUSDWrr", LIEF::assembly::x86::OPCODE::PACKUSDWrr)
  .value("PACKUSWBrm", LIEF::assembly::x86::OPCODE::PACKUSWBrm)
  .value("PACKUSWBrr", LIEF::assembly::x86::OPCODE::PACKUSWBrr)
  .value("PADDBrm", LIEF::assembly::x86::OPCODE::PADDBrm)
  .value("PADDBrr", LIEF::assembly::x86::OPCODE::PADDBrr)
  .value("PADDDrm", LIEF::assembly::x86::OPCODE::PADDDrm)
  .value("PADDDrr", LIEF::assembly::x86::OPCODE::PADDDrr)
  .value("PADDQrm", LIEF::assembly::x86::OPCODE::PADDQrm)
  .value("PADDQrr", LIEF::assembly::x86::OPCODE::PADDQrr)
  .value("PADDSBrm", LIEF::assembly::x86::OPCODE::PADDSBrm)
  .value("PADDSBrr", LIEF::assembly::x86::OPCODE::PADDSBrr)
  .value("PADDSWrm", LIEF::assembly::x86::OPCODE::PADDSWrm)
  .value("PADDSWrr", LIEF::assembly::x86::OPCODE::PADDSWrr)
  .value("PADDUSBrm", LIEF::assembly::x86::OPCODE::PADDUSBrm)
  .value("PADDUSBrr", LIEF::assembly::x86::OPCODE::PADDUSBrr)
  .value("PADDUSWrm", LIEF::assembly::x86::OPCODE::PADDUSWrm)
  .value("PADDUSWrr", LIEF::assembly::x86::OPCODE::PADDUSWrr)
  .value("PADDWrm", LIEF::assembly::x86::OPCODE::PADDWrm)
  .value("PADDWrr", LIEF::assembly::x86::OPCODE::PADDWrr)
  .value("PALIGNRrmi", LIEF::assembly::x86::OPCODE::PALIGNRrmi)
  .value("PALIGNRrri", LIEF::assembly::x86::OPCODE::PALIGNRrri)
  .value("PANDNrm", LIEF::assembly::x86::OPCODE::PANDNrm)
  .value("PANDNrr", LIEF::assembly::x86::OPCODE::PANDNrr)
  .value("PANDrm", LIEF::assembly::x86::OPCODE::PANDrm)
  .value("PANDrr", LIEF::assembly::x86::OPCODE::PANDrr)
  .value("PAUSE", LIEF::assembly::x86::OPCODE::PAUSE)
  .value("PAVGBrm", LIEF::assembly::x86::OPCODE::PAVGBrm)
  .value("PAVGBrr", LIEF::assembly::x86::OPCODE::PAVGBrr)
  .value("PAVGUSBrm", LIEF::assembly::x86::OPCODE::PAVGUSBrm)
  .value("PAVGUSBrr", LIEF::assembly::x86::OPCODE::PAVGUSBrr)
  .value("PAVGWrm", LIEF::assembly::x86::OPCODE::PAVGWrm)
  .value("PAVGWrr", LIEF::assembly::x86::OPCODE::PAVGWrr)
  .value("PBLENDVBrm0", LIEF::assembly::x86::OPCODE::PBLENDVBrm0)
  .value("PBLENDVBrr0", LIEF::assembly::x86::OPCODE::PBLENDVBrr0)
  .value("PBLENDWrmi", LIEF::assembly::x86::OPCODE::PBLENDWrmi)
  .value("PBLENDWrri", LIEF::assembly::x86::OPCODE::PBLENDWrri)
  .value("PBNDKB", LIEF::assembly::x86::OPCODE::PBNDKB)
  .value("PCLMULQDQrmi", LIEF::assembly::x86::OPCODE::PCLMULQDQrmi)
  .value("PCLMULQDQrri", LIEF::assembly::x86::OPCODE::PCLMULQDQrri)
  .value("PCMPEQBrm", LIEF::assembly::x86::OPCODE::PCMPEQBrm)
  .value("PCMPEQBrr", LIEF::assembly::x86::OPCODE::PCMPEQBrr)
  .value("PCMPEQDrm", LIEF::assembly::x86::OPCODE::PCMPEQDrm)
  .value("PCMPEQDrr", LIEF::assembly::x86::OPCODE::PCMPEQDrr)
  .value("PCMPEQQrm", LIEF::assembly::x86::OPCODE::PCMPEQQrm)
  .value("PCMPEQQrr", LIEF::assembly::x86::OPCODE::PCMPEQQrr)
  .value("PCMPEQWrm", LIEF::assembly::x86::OPCODE::PCMPEQWrm)
  .value("PCMPEQWrr", LIEF::assembly::x86::OPCODE::PCMPEQWrr)
  .value("PCMPESTRIrmi", LIEF::assembly::x86::OPCODE::PCMPESTRIrmi)
  .value("PCMPESTRIrri", LIEF::assembly::x86::OPCODE::PCMPESTRIrri)
  .value("PCMPESTRMrmi", LIEF::assembly::x86::OPCODE::PCMPESTRMrmi)
  .value("PCMPESTRMrri", LIEF::assembly::x86::OPCODE::PCMPESTRMrri)
  .value("PCMPGTBrm", LIEF::assembly::x86::OPCODE::PCMPGTBrm)
  .value("PCMPGTBrr", LIEF::assembly::x86::OPCODE::PCMPGTBrr)
  .value("PCMPGTDrm", LIEF::assembly::x86::OPCODE::PCMPGTDrm)
  .value("PCMPGTDrr", LIEF::assembly::x86::OPCODE::PCMPGTDrr)
  .value("PCMPGTQrm", LIEF::assembly::x86::OPCODE::PCMPGTQrm)
  .value("PCMPGTQrr", LIEF::assembly::x86::OPCODE::PCMPGTQrr)
  .value("PCMPGTWrm", LIEF::assembly::x86::OPCODE::PCMPGTWrm)
  .value("PCMPGTWrr", LIEF::assembly::x86::OPCODE::PCMPGTWrr)
  .value("PCMPISTRIrmi", LIEF::assembly::x86::OPCODE::PCMPISTRIrmi)
  .value("PCMPISTRIrri", LIEF::assembly::x86::OPCODE::PCMPISTRIrri)
  .value("PCMPISTRMrmi", LIEF::assembly::x86::OPCODE::PCMPISTRMrmi)
  .value("PCMPISTRMrri", LIEF::assembly::x86::OPCODE::PCMPISTRMrri)
  .value("PCONFIG", LIEF::assembly::x86::OPCODE::PCONFIG)
  .value("PDEP32rm", LIEF::assembly::x86::OPCODE::PDEP32rm)
  .value("PDEP32rm_EVEX", LIEF::assembly::x86::OPCODE::PDEP32rm_EVEX)
  .value("PDEP32rr", LIEF::assembly::x86::OPCODE::PDEP32rr)
  .value("PDEP32rr_EVEX", LIEF::assembly::x86::OPCODE::PDEP32rr_EVEX)
  .value("PDEP64rm", LIEF::assembly::x86::OPCODE::PDEP64rm)
  .value("PDEP64rm_EVEX", LIEF::assembly::x86::OPCODE::PDEP64rm_EVEX)
  .value("PDEP64rr", LIEF::assembly::x86::OPCODE::PDEP64rr)
  .value("PDEP64rr_EVEX", LIEF::assembly::x86::OPCODE::PDEP64rr_EVEX)
  .value("PEXT32rm", LIEF::assembly::x86::OPCODE::PEXT32rm)
  .value("PEXT32rm_EVEX", LIEF::assembly::x86::OPCODE::PEXT32rm_EVEX)
  .value("PEXT32rr", LIEF::assembly::x86::OPCODE::PEXT32rr)
  .value("PEXT32rr_EVEX", LIEF::assembly::x86::OPCODE::PEXT32rr_EVEX)
  .value("PEXT64rm", LIEF::assembly::x86::OPCODE::PEXT64rm)
  .value("PEXT64rm_EVEX", LIEF::assembly::x86::OPCODE::PEXT64rm_EVEX)
  .value("PEXT64rr", LIEF::assembly::x86::OPCODE::PEXT64rr)
  .value("PEXT64rr_EVEX", LIEF::assembly::x86::OPCODE::PEXT64rr_EVEX)
  .value("PEXTRBmri", LIEF::assembly::x86::OPCODE::PEXTRBmri)
  .value("PEXTRBrri", LIEF::assembly::x86::OPCODE::PEXTRBrri)
  .value("PEXTRDmri", LIEF::assembly::x86::OPCODE::PEXTRDmri)
  .value("PEXTRDrri", LIEF::assembly::x86::OPCODE::PEXTRDrri)
  .value("PEXTRQmri", LIEF::assembly::x86::OPCODE::PEXTRQmri)
  .value("PEXTRQrri", LIEF::assembly::x86::OPCODE::PEXTRQrri)
  .value("PEXTRWmri", LIEF::assembly::x86::OPCODE::PEXTRWmri)
  .value("PEXTRWrri", LIEF::assembly::x86::OPCODE::PEXTRWrri)
  .value("PEXTRWrri_REV", LIEF::assembly::x86::OPCODE::PEXTRWrri_REV)
  .value("PF2IDrm", LIEF::assembly::x86::OPCODE::PF2IDrm)
  .value("PF2IDrr", LIEF::assembly::x86::OPCODE::PF2IDrr)
  .value("PF2IWrm", LIEF::assembly::x86::OPCODE::PF2IWrm)
  .value("PF2IWrr", LIEF::assembly::x86::OPCODE::PF2IWrr)
  .value("PFACCrm", LIEF::assembly::x86::OPCODE::PFACCrm)
  .value("PFACCrr", LIEF::assembly::x86::OPCODE::PFACCrr)
  .value("PFADDrm", LIEF::assembly::x86::OPCODE::PFADDrm)
  .value("PFADDrr", LIEF::assembly::x86::OPCODE::PFADDrr)
  .value("PFCMPEQrm", LIEF::assembly::x86::OPCODE::PFCMPEQrm)
  .value("PFCMPEQrr", LIEF::assembly::x86::OPCODE::PFCMPEQrr)
  .value("PFCMPGErm", LIEF::assembly::x86::OPCODE::PFCMPGErm)
  .value("PFCMPGErr", LIEF::assembly::x86::OPCODE::PFCMPGErr)
  .value("PFCMPGTrm", LIEF::assembly::x86::OPCODE::PFCMPGTrm)
  .value("PFCMPGTrr", LIEF::assembly::x86::OPCODE::PFCMPGTrr)
  .value("PFMAXrm", LIEF::assembly::x86::OPCODE::PFMAXrm)
  .value("PFMAXrr", LIEF::assembly::x86::OPCODE::PFMAXrr)
  .value("PFMINrm", LIEF::assembly::x86::OPCODE::PFMINrm)
  .value("PFMINrr", LIEF::assembly::x86::OPCODE::PFMINrr)
  .value("PFMULrm", LIEF::assembly::x86::OPCODE::PFMULrm)
  .value("PFMULrr", LIEF::assembly::x86::OPCODE::PFMULrr)
  .value("PFNACCrm", LIEF::assembly::x86::OPCODE::PFNACCrm)
  .value("PFNACCrr", LIEF::assembly::x86::OPCODE::PFNACCrr)
  .value("PFPNACCrm", LIEF::assembly::x86::OPCODE::PFPNACCrm)
  .value("PFPNACCrr", LIEF::assembly::x86::OPCODE::PFPNACCrr)
  .value("PFRCPIT1rm", LIEF::assembly::x86::OPCODE::PFRCPIT1rm)
  .value("PFRCPIT1rr", LIEF::assembly::x86::OPCODE::PFRCPIT1rr)
  .value("PFRCPIT2rm", LIEF::assembly::x86::OPCODE::PFRCPIT2rm)
  .value("PFRCPIT2rr", LIEF::assembly::x86::OPCODE::PFRCPIT2rr)
  .value("PFRCPrm", LIEF::assembly::x86::OPCODE::PFRCPrm)
  .value("PFRCPrr", LIEF::assembly::x86::OPCODE::PFRCPrr)
  .value("PFRSQIT1rm", LIEF::assembly::x86::OPCODE::PFRSQIT1rm)
  .value("PFRSQIT1rr", LIEF::assembly::x86::OPCODE::PFRSQIT1rr)
  .value("PFRSQRTrm", LIEF::assembly::x86::OPCODE::PFRSQRTrm)
  .value("PFRSQRTrr", LIEF::assembly::x86::OPCODE::PFRSQRTrr)
  .value("PFSUBRrm", LIEF::assembly::x86::OPCODE::PFSUBRrm)
  .value("PFSUBRrr", LIEF::assembly::x86::OPCODE::PFSUBRrr)
  .value("PFSUBrm", LIEF::assembly::x86::OPCODE::PFSUBrm)
  .value("PFSUBrr", LIEF::assembly::x86::OPCODE::PFSUBrr)
  .value("PHADDDrm", LIEF::assembly::x86::OPCODE::PHADDDrm)
  .value("PHADDDrr", LIEF::assembly::x86::OPCODE::PHADDDrr)
  .value("PHADDSWrm", LIEF::assembly::x86::OPCODE::PHADDSWrm)
  .value("PHADDSWrr", LIEF::assembly::x86::OPCODE::PHADDSWrr)
  .value("PHADDWrm", LIEF::assembly::x86::OPCODE::PHADDWrm)
  .value("PHADDWrr", LIEF::assembly::x86::OPCODE::PHADDWrr)
  .value("PHMINPOSUWrm", LIEF::assembly::x86::OPCODE::PHMINPOSUWrm)
  .value("PHMINPOSUWrr", LIEF::assembly::x86::OPCODE::PHMINPOSUWrr)
  .value("PHSUBDrm", LIEF::assembly::x86::OPCODE::PHSUBDrm)
  .value("PHSUBDrr", LIEF::assembly::x86::OPCODE::PHSUBDrr)
  .value("PHSUBSWrm", LIEF::assembly::x86::OPCODE::PHSUBSWrm)
  .value("PHSUBSWrr", LIEF::assembly::x86::OPCODE::PHSUBSWrr)
  .value("PHSUBWrm", LIEF::assembly::x86::OPCODE::PHSUBWrm)
  .value("PHSUBWrr", LIEF::assembly::x86::OPCODE::PHSUBWrr)
  .value("PI2FDrm", LIEF::assembly::x86::OPCODE::PI2FDrm)
  .value("PI2FDrr", LIEF::assembly::x86::OPCODE::PI2FDrr)
  .value("PI2FWrm", LIEF::assembly::x86::OPCODE::PI2FWrm)
  .value("PI2FWrr", LIEF::assembly::x86::OPCODE::PI2FWrr)
  .value("PINSRBrmi", LIEF::assembly::x86::OPCODE::PINSRBrmi)
  .value("PINSRBrri", LIEF::assembly::x86::OPCODE::PINSRBrri)
  .value("PINSRDrmi", LIEF::assembly::x86::OPCODE::PINSRDrmi)
  .value("PINSRDrri", LIEF::assembly::x86::OPCODE::PINSRDrri)
  .value("PINSRQrmi", LIEF::assembly::x86::OPCODE::PINSRQrmi)
  .value("PINSRQrri", LIEF::assembly::x86::OPCODE::PINSRQrri)
  .value("PINSRWrmi", LIEF::assembly::x86::OPCODE::PINSRWrmi)
  .value("PINSRWrri", LIEF::assembly::x86::OPCODE::PINSRWrri)
  .value("PMADDUBSWrm", LIEF::assembly::x86::OPCODE::PMADDUBSWrm)
  .value("PMADDUBSWrr", LIEF::assembly::x86::OPCODE::PMADDUBSWrr)
  .value("PMADDWDrm", LIEF::assembly::x86::OPCODE::PMADDWDrm)
  .value("PMADDWDrr", LIEF::assembly::x86::OPCODE::PMADDWDrr)
  .value("PMAXSBrm", LIEF::assembly::x86::OPCODE::PMAXSBrm)
  .value("PMAXSBrr", LIEF::assembly::x86::OPCODE::PMAXSBrr)
  .value("PMAXSDrm", LIEF::assembly::x86::OPCODE::PMAXSDrm)
  .value("PMAXSDrr", LIEF::assembly::x86::OPCODE::PMAXSDrr)
  .value("PMAXSWrm", LIEF::assembly::x86::OPCODE::PMAXSWrm)
  .value("PMAXSWrr", LIEF::assembly::x86::OPCODE::PMAXSWrr)
  .value("PMAXUBrm", LIEF::assembly::x86::OPCODE::PMAXUBrm)
  .value("PMAXUBrr", LIEF::assembly::x86::OPCODE::PMAXUBrr)
  .value("PMAXUDrm", LIEF::assembly::x86::OPCODE::PMAXUDrm)
  .value("PMAXUDrr", LIEF::assembly::x86::OPCODE::PMAXUDrr)
  .value("PMAXUWrm", LIEF::assembly::x86::OPCODE::PMAXUWrm)
  .value("PMAXUWrr", LIEF::assembly::x86::OPCODE::PMAXUWrr)
  .value("PMINSBrm", LIEF::assembly::x86::OPCODE::PMINSBrm)
  .value("PMINSBrr", LIEF::assembly::x86::OPCODE::PMINSBrr)
  .value("PMINSDrm", LIEF::assembly::x86::OPCODE::PMINSDrm)
  .value("PMINSDrr", LIEF::assembly::x86::OPCODE::PMINSDrr)
  .value("PMINSWrm", LIEF::assembly::x86::OPCODE::PMINSWrm)
  .value("PMINSWrr", LIEF::assembly::x86::OPCODE::PMINSWrr)
  .value("PMINUBrm", LIEF::assembly::x86::OPCODE::PMINUBrm)
  .value("PMINUBrr", LIEF::assembly::x86::OPCODE::PMINUBrr)
  .value("PMINUDrm", LIEF::assembly::x86::OPCODE::PMINUDrm)
  .value("PMINUDrr", LIEF::assembly::x86::OPCODE::PMINUDrr)
  .value("PMINUWrm", LIEF::assembly::x86::OPCODE::PMINUWrm)
  .value("PMINUWrr", LIEF::assembly::x86::OPCODE::PMINUWrr)
  .value("PMOVMSKBrr", LIEF::assembly::x86::OPCODE::PMOVMSKBrr)
  .value("PMOVSXBDrm", LIEF::assembly::x86::OPCODE::PMOVSXBDrm)
  .value("PMOVSXBDrr", LIEF::assembly::x86::OPCODE::PMOVSXBDrr)
  .value("PMOVSXBQrm", LIEF::assembly::x86::OPCODE::PMOVSXBQrm)
  .value("PMOVSXBQrr", LIEF::assembly::x86::OPCODE::PMOVSXBQrr)
  .value("PMOVSXBWrm", LIEF::assembly::x86::OPCODE::PMOVSXBWrm)
  .value("PMOVSXBWrr", LIEF::assembly::x86::OPCODE::PMOVSXBWrr)
  .value("PMOVSXDQrm", LIEF::assembly::x86::OPCODE::PMOVSXDQrm)
  .value("PMOVSXDQrr", LIEF::assembly::x86::OPCODE::PMOVSXDQrr)
  .value("PMOVSXWDrm", LIEF::assembly::x86::OPCODE::PMOVSXWDrm)
  .value("PMOVSXWDrr", LIEF::assembly::x86::OPCODE::PMOVSXWDrr)
  .value("PMOVSXWQrm", LIEF::assembly::x86::OPCODE::PMOVSXWQrm)
  .value("PMOVSXWQrr", LIEF::assembly::x86::OPCODE::PMOVSXWQrr)
  .value("PMOVZXBDrm", LIEF::assembly::x86::OPCODE::PMOVZXBDrm)
  .value("PMOVZXBDrr", LIEF::assembly::x86::OPCODE::PMOVZXBDrr)
  .value("PMOVZXBQrm", LIEF::assembly::x86::OPCODE::PMOVZXBQrm)
  .value("PMOVZXBQrr", LIEF::assembly::x86::OPCODE::PMOVZXBQrr)
  .value("PMOVZXBWrm", LIEF::assembly::x86::OPCODE::PMOVZXBWrm)
  .value("PMOVZXBWrr", LIEF::assembly::x86::OPCODE::PMOVZXBWrr)
  .value("PMOVZXDQrm", LIEF::assembly::x86::OPCODE::PMOVZXDQrm)
  .value("PMOVZXDQrr", LIEF::assembly::x86::OPCODE::PMOVZXDQrr)
  .value("PMOVZXWDrm", LIEF::assembly::x86::OPCODE::PMOVZXWDrm)
  .value("PMOVZXWDrr", LIEF::assembly::x86::OPCODE::PMOVZXWDrr)
  .value("PMOVZXWQrm", LIEF::assembly::x86::OPCODE::PMOVZXWQrm)
  .value("PMOVZXWQrr", LIEF::assembly::x86::OPCODE::PMOVZXWQrr)
  .value("PMULDQrm", LIEF::assembly::x86::OPCODE::PMULDQrm)
  .value("PMULDQrr", LIEF::assembly::x86::OPCODE::PMULDQrr)
  .value("PMULHRSWrm", LIEF::assembly::x86::OPCODE::PMULHRSWrm)
  .value("PMULHRSWrr", LIEF::assembly::x86::OPCODE::PMULHRSWrr)
  .value("PMULHRWrm", LIEF::assembly::x86::OPCODE::PMULHRWrm)
  .value("PMULHRWrr", LIEF::assembly::x86::OPCODE::PMULHRWrr)
  .value("PMULHUWrm", LIEF::assembly::x86::OPCODE::PMULHUWrm)
  .value("PMULHUWrr", LIEF::assembly::x86::OPCODE::PMULHUWrr)
  .value("PMULHWrm", LIEF::assembly::x86::OPCODE::PMULHWrm)
  .value("PMULHWrr", LIEF::assembly::x86::OPCODE::PMULHWrr)
  .value("PMULLDrm", LIEF::assembly::x86::OPCODE::PMULLDrm)
  .value("PMULLDrr", LIEF::assembly::x86::OPCODE::PMULLDrr)
  .value("PMULLWrm", LIEF::assembly::x86::OPCODE::PMULLWrm)
  .value("PMULLWrr", LIEF::assembly::x86::OPCODE::PMULLWrr);
  opcodes.value("PMULUDQrm", LIEF::assembly::x86::OPCODE::PMULUDQrm)
  .value("PMULUDQrr", LIEF::assembly::x86::OPCODE::PMULUDQrr)
  .value("POP16r", LIEF::assembly::x86::OPCODE::POP16r)
  .value("POP16rmm", LIEF::assembly::x86::OPCODE::POP16rmm)
  .value("POP16rmr", LIEF::assembly::x86::OPCODE::POP16rmr)
  .value("POP2", LIEF::assembly::x86::OPCODE::POP2)
  .value("POP2P", LIEF::assembly::x86::OPCODE::POP2P)
  .value("POP32r", LIEF::assembly::x86::OPCODE::POP32r)
  .value("POP32rmm", LIEF::assembly::x86::OPCODE::POP32rmm)
  .value("POP32rmr", LIEF::assembly::x86::OPCODE::POP32rmr)
  .value("POP64r", LIEF::assembly::x86::OPCODE::POP64r)
  .value("POP64rmm", LIEF::assembly::x86::OPCODE::POP64rmm)
  .value("POP64rmr", LIEF::assembly::x86::OPCODE::POP64rmr)
  .value("POPA16", LIEF::assembly::x86::OPCODE::POPA16)
  .value("POPA32", LIEF::assembly::x86::OPCODE::POPA32)
  .value("POPCNT16rm", LIEF::assembly::x86::OPCODE::POPCNT16rm)
  .value("POPCNT16rm_EVEX", LIEF::assembly::x86::OPCODE::POPCNT16rm_EVEX)
  .value("POPCNT16rm_NF", LIEF::assembly::x86::OPCODE::POPCNT16rm_NF)
  .value("POPCNT16rr", LIEF::assembly::x86::OPCODE::POPCNT16rr)
  .value("POPCNT16rr_EVEX", LIEF::assembly::x86::OPCODE::POPCNT16rr_EVEX)
  .value("POPCNT16rr_NF", LIEF::assembly::x86::OPCODE::POPCNT16rr_NF)
  .value("POPCNT32rm", LIEF::assembly::x86::OPCODE::POPCNT32rm)
  .value("POPCNT32rm_EVEX", LIEF::assembly::x86::OPCODE::POPCNT32rm_EVEX)
  .value("POPCNT32rm_NF", LIEF::assembly::x86::OPCODE::POPCNT32rm_NF)
  .value("POPCNT32rr", LIEF::assembly::x86::OPCODE::POPCNT32rr)
  .value("POPCNT32rr_EVEX", LIEF::assembly::x86::OPCODE::POPCNT32rr_EVEX)
  .value("POPCNT32rr_NF", LIEF::assembly::x86::OPCODE::POPCNT32rr_NF)
  .value("POPCNT64rm", LIEF::assembly::x86::OPCODE::POPCNT64rm)
  .value("POPCNT64rm_EVEX", LIEF::assembly::x86::OPCODE::POPCNT64rm_EVEX)
  .value("POPCNT64rm_NF", LIEF::assembly::x86::OPCODE::POPCNT64rm_NF)
  .value("POPCNT64rr", LIEF::assembly::x86::OPCODE::POPCNT64rr)
  .value("POPCNT64rr_EVEX", LIEF::assembly::x86::OPCODE::POPCNT64rr_EVEX)
  .value("POPCNT64rr_NF", LIEF::assembly::x86::OPCODE::POPCNT64rr_NF)
  .value("POPDS16", LIEF::assembly::x86::OPCODE::POPDS16)
  .value("POPDS32", LIEF::assembly::x86::OPCODE::POPDS32)
  .value("POPES16", LIEF::assembly::x86::OPCODE::POPES16)
  .value("POPES32", LIEF::assembly::x86::OPCODE::POPES32)
  .value("POPF16", LIEF::assembly::x86::OPCODE::POPF16)
  .value("POPF32", LIEF::assembly::x86::OPCODE::POPF32)
  .value("POPF64", LIEF::assembly::x86::OPCODE::POPF64)
  .value("POPFS16", LIEF::assembly::x86::OPCODE::POPFS16)
  .value("POPFS32", LIEF::assembly::x86::OPCODE::POPFS32)
  .value("POPFS64", LIEF::assembly::x86::OPCODE::POPFS64)
  .value("POPGS16", LIEF::assembly::x86::OPCODE::POPGS16)
  .value("POPGS32", LIEF::assembly::x86::OPCODE::POPGS32)
  .value("POPGS64", LIEF::assembly::x86::OPCODE::POPGS64)
  .value("POPP64r", LIEF::assembly::x86::OPCODE::POPP64r)
  .value("POPSS16", LIEF::assembly::x86::OPCODE::POPSS16)
  .value("POPSS32", LIEF::assembly::x86::OPCODE::POPSS32)
  .value("PORrm", LIEF::assembly::x86::OPCODE::PORrm)
  .value("PORrr", LIEF::assembly::x86::OPCODE::PORrr)
  .value("PREFETCH", LIEF::assembly::x86::OPCODE::PREFETCH)
  .value("PREFETCHIT0", LIEF::assembly::x86::OPCODE::PREFETCHIT0)
  .value("PREFETCHIT1", LIEF::assembly::x86::OPCODE::PREFETCHIT1)
  .value("PREFETCHNTA", LIEF::assembly::x86::OPCODE::PREFETCHNTA)
  .value("PREFETCHRST2", LIEF::assembly::x86::OPCODE::PREFETCHRST2)
  .value("PREFETCHT0", LIEF::assembly::x86::OPCODE::PREFETCHT0)
  .value("PREFETCHT1", LIEF::assembly::x86::OPCODE::PREFETCHT1)
  .value("PREFETCHT2", LIEF::assembly::x86::OPCODE::PREFETCHT2)
  .value("PREFETCHW", LIEF::assembly::x86::OPCODE::PREFETCHW)
  .value("PREFETCHWT1", LIEF::assembly::x86::OPCODE::PREFETCHWT1)
  .value("PROBED_ALLOCA_32", LIEF::assembly::x86::OPCODE::PROBED_ALLOCA_32)
  .value("PROBED_ALLOCA_64", LIEF::assembly::x86::OPCODE::PROBED_ALLOCA_64)
  .value("PSADBWrm", LIEF::assembly::x86::OPCODE::PSADBWrm)
  .value("PSADBWrr", LIEF::assembly::x86::OPCODE::PSADBWrr)
  .value("PSHUFBrm", LIEF::assembly::x86::OPCODE::PSHUFBrm)
  .value("PSHUFBrr", LIEF::assembly::x86::OPCODE::PSHUFBrr)
  .value("PSHUFDmi", LIEF::assembly::x86::OPCODE::PSHUFDmi)
  .value("PSHUFDri", LIEF::assembly::x86::OPCODE::PSHUFDri)
  .value("PSHUFHWmi", LIEF::assembly::x86::OPCODE::PSHUFHWmi)
  .value("PSHUFHWri", LIEF::assembly::x86::OPCODE::PSHUFHWri)
  .value("PSHUFLWmi", LIEF::assembly::x86::OPCODE::PSHUFLWmi)
  .value("PSHUFLWri", LIEF::assembly::x86::OPCODE::PSHUFLWri)
  .value("PSIGNBrm", LIEF::assembly::x86::OPCODE::PSIGNBrm)
  .value("PSIGNBrr", LIEF::assembly::x86::OPCODE::PSIGNBrr)
  .value("PSIGNDrm", LIEF::assembly::x86::OPCODE::PSIGNDrm)
  .value("PSIGNDrr", LIEF::assembly::x86::OPCODE::PSIGNDrr)
  .value("PSIGNWrm", LIEF::assembly::x86::OPCODE::PSIGNWrm)
  .value("PSIGNWrr", LIEF::assembly::x86::OPCODE::PSIGNWrr)
  .value("PSLLDQri", LIEF::assembly::x86::OPCODE::PSLLDQri)
  .value("PSLLDri", LIEF::assembly::x86::OPCODE::PSLLDri)
  .value("PSLLDrm", LIEF::assembly::x86::OPCODE::PSLLDrm)
  .value("PSLLDrr", LIEF::assembly::x86::OPCODE::PSLLDrr)
  .value("PSLLQri", LIEF::assembly::x86::OPCODE::PSLLQri)
  .value("PSLLQrm", LIEF::assembly::x86::OPCODE::PSLLQrm)
  .value("PSLLQrr", LIEF::assembly::x86::OPCODE::PSLLQrr)
  .value("PSLLWri", LIEF::assembly::x86::OPCODE::PSLLWri)
  .value("PSLLWrm", LIEF::assembly::x86::OPCODE::PSLLWrm)
  .value("PSLLWrr", LIEF::assembly::x86::OPCODE::PSLLWrr)
  .value("PSMASH", LIEF::assembly::x86::OPCODE::PSMASH)
  .value("PSRADri", LIEF::assembly::x86::OPCODE::PSRADri)
  .value("PSRADrm", LIEF::assembly::x86::OPCODE::PSRADrm)
  .value("PSRADrr", LIEF::assembly::x86::OPCODE::PSRADrr)
  .value("PSRAWri", LIEF::assembly::x86::OPCODE::PSRAWri)
  .value("PSRAWrm", LIEF::assembly::x86::OPCODE::PSRAWrm)
  .value("PSRAWrr", LIEF::assembly::x86::OPCODE::PSRAWrr)
  .value("PSRLDQri", LIEF::assembly::x86::OPCODE::PSRLDQri)
  .value("PSRLDri", LIEF::assembly::x86::OPCODE::PSRLDri)
  .value("PSRLDrm", LIEF::assembly::x86::OPCODE::PSRLDrm)
  .value("PSRLDrr", LIEF::assembly::x86::OPCODE::PSRLDrr)
  .value("PSRLQri", LIEF::assembly::x86::OPCODE::PSRLQri)
  .value("PSRLQrm", LIEF::assembly::x86::OPCODE::PSRLQrm)
  .value("PSRLQrr", LIEF::assembly::x86::OPCODE::PSRLQrr)
  .value("PSRLWri", LIEF::assembly::x86::OPCODE::PSRLWri)
  .value("PSRLWrm", LIEF::assembly::x86::OPCODE::PSRLWrm)
  .value("PSRLWrr", LIEF::assembly::x86::OPCODE::PSRLWrr)
  .value("PSUBBrm", LIEF::assembly::x86::OPCODE::PSUBBrm)
  .value("PSUBBrr", LIEF::assembly::x86::OPCODE::PSUBBrr)
  .value("PSUBDrm", LIEF::assembly::x86::OPCODE::PSUBDrm)
  .value("PSUBDrr", LIEF::assembly::x86::OPCODE::PSUBDrr)
  .value("PSUBQrm", LIEF::assembly::x86::OPCODE::PSUBQrm)
  .value("PSUBQrr", LIEF::assembly::x86::OPCODE::PSUBQrr)
  .value("PSUBSBrm", LIEF::assembly::x86::OPCODE::PSUBSBrm)
  .value("PSUBSBrr", LIEF::assembly::x86::OPCODE::PSUBSBrr)
  .value("PSUBSWrm", LIEF::assembly::x86::OPCODE::PSUBSWrm)
  .value("PSUBSWrr", LIEF::assembly::x86::OPCODE::PSUBSWrr)
  .value("PSUBUSBrm", LIEF::assembly::x86::OPCODE::PSUBUSBrm)
  .value("PSUBUSBrr", LIEF::assembly::x86::OPCODE::PSUBUSBrr)
  .value("PSUBUSWrm", LIEF::assembly::x86::OPCODE::PSUBUSWrm)
  .value("PSUBUSWrr", LIEF::assembly::x86::OPCODE::PSUBUSWrr)
  .value("PSUBWrm", LIEF::assembly::x86::OPCODE::PSUBWrm)
  .value("PSUBWrr", LIEF::assembly::x86::OPCODE::PSUBWrr)
  .value("PSWAPDrm", LIEF::assembly::x86::OPCODE::PSWAPDrm)
  .value("PSWAPDrr", LIEF::assembly::x86::OPCODE::PSWAPDrr)
  .value("PT2RPNTLVWZ0", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0)
  .value("PT2RPNTLVWZ0RS", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0RS)
  .value("PT2RPNTLVWZ0RST1", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0RST1)
  .value("PT2RPNTLVWZ0T1", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ0T1)
  .value("PT2RPNTLVWZ1", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1)
  .value("PT2RPNTLVWZ1RS", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1RS)
  .value("PT2RPNTLVWZ1RST1", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1RST1)
  .value("PT2RPNTLVWZ1T1", LIEF::assembly::x86::OPCODE::PT2RPNTLVWZ1T1)
  .value("PTCMMIMFP16PS", LIEF::assembly::x86::OPCODE::PTCMMIMFP16PS)
  .value("PTCMMIMFP16PSV", LIEF::assembly::x86::OPCODE::PTCMMIMFP16PSV)
  .value("PTCMMRLFP16PS", LIEF::assembly::x86::OPCODE::PTCMMRLFP16PS)
  .value("PTCMMRLFP16PSV", LIEF::assembly::x86::OPCODE::PTCMMRLFP16PSV)
  .value("PTCONJTCMMIMFP16PS", LIEF::assembly::x86::OPCODE::PTCONJTCMMIMFP16PS)
  .value("PTCONJTCMMIMFP16PSV", LIEF::assembly::x86::OPCODE::PTCONJTCMMIMFP16PSV)
  .value("PTCONJTFP16", LIEF::assembly::x86::OPCODE::PTCONJTFP16)
  .value("PTCONJTFP16V", LIEF::assembly::x86::OPCODE::PTCONJTFP16V)
  .value("PTCVTROWD2PSrre", LIEF::assembly::x86::OPCODE::PTCVTROWD2PSrre)
  .value("PTCVTROWD2PSrreV", LIEF::assembly::x86::OPCODE::PTCVTROWD2PSrreV)
  .value("PTCVTROWD2PSrri", LIEF::assembly::x86::OPCODE::PTCVTROWD2PSrri)
  .value("PTCVTROWD2PSrriV", LIEF::assembly::x86::OPCODE::PTCVTROWD2PSrriV)
  .value("PTCVTROWPS2BF16Hrre", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16Hrre)
  .value("PTCVTROWPS2BF16HrreV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16HrreV)
  .value("PTCVTROWPS2BF16Hrri", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16Hrri)
  .value("PTCVTROWPS2BF16HrriV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16HrriV)
  .value("PTCVTROWPS2BF16Lrre", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16Lrre)
  .value("PTCVTROWPS2BF16LrreV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16LrreV)
  .value("PTCVTROWPS2BF16Lrri", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16Lrri)
  .value("PTCVTROWPS2BF16LrriV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2BF16LrriV)
  .value("PTCVTROWPS2PHHrre", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHHrre)
  .value("PTCVTROWPS2PHHrreV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHHrreV)
  .value("PTCVTROWPS2PHHrri", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHHrri)
  .value("PTCVTROWPS2PHHrriV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHHrriV)
  .value("PTCVTROWPS2PHLrre", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHLrre)
  .value("PTCVTROWPS2PHLrreV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHLrreV)
  .value("PTCVTROWPS2PHLrri", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHLrri)
  .value("PTCVTROWPS2PHLrriV", LIEF::assembly::x86::OPCODE::PTCVTROWPS2PHLrriV)
  .value("PTDPBF16PS", LIEF::assembly::x86::OPCODE::PTDPBF16PS)
  .value("PTDPBF8PS", LIEF::assembly::x86::OPCODE::PTDPBF8PS)
  .value("PTDPBF8PSV", LIEF::assembly::x86::OPCODE::PTDPBF8PSV)
  .value("PTDPBHF8PS", LIEF::assembly::x86::OPCODE::PTDPBHF8PS)
  .value("PTDPBHF8PSV", LIEF::assembly::x86::OPCODE::PTDPBHF8PSV)
  .value("PTDPBSSD", LIEF::assembly::x86::OPCODE::PTDPBSSD)
  .value("PTDPBSUD", LIEF::assembly::x86::OPCODE::PTDPBSUD)
  .value("PTDPBUSD", LIEF::assembly::x86::OPCODE::PTDPBUSD)
  .value("PTDPBUUD", LIEF::assembly::x86::OPCODE::PTDPBUUD)
  .value("PTDPFP16PS", LIEF::assembly::x86::OPCODE::PTDPFP16PS)
  .value("PTDPHBF8PS", LIEF::assembly::x86::OPCODE::PTDPHBF8PS)
  .value("PTDPHBF8PSV", LIEF::assembly::x86::OPCODE::PTDPHBF8PSV)
  .value("PTDPHF8PS", LIEF::assembly::x86::OPCODE::PTDPHF8PS)
  .value("PTDPHF8PSV", LIEF::assembly::x86::OPCODE::PTDPHF8PSV)
  .value("PTESTrm", LIEF::assembly::x86::OPCODE::PTESTrm)
  .value("PTESTrr", LIEF::assembly::x86::OPCODE::PTESTrr)
  .value("PTILELOADD", LIEF::assembly::x86::OPCODE::PTILELOADD)
  .value("PTILELOADDRS", LIEF::assembly::x86::OPCODE::PTILELOADDRS)
  .value("PTILELOADDRST1", LIEF::assembly::x86::OPCODE::PTILELOADDRST1)
  .value("PTILELOADDT1", LIEF::assembly::x86::OPCODE::PTILELOADDT1)
  .value("PTILEMOVROWrre", LIEF::assembly::x86::OPCODE::PTILEMOVROWrre)
  .value("PTILEMOVROWrreV", LIEF::assembly::x86::OPCODE::PTILEMOVROWrreV)
  .value("PTILEMOVROWrri", LIEF::assembly::x86::OPCODE::PTILEMOVROWrri)
  .value("PTILEMOVROWrriV", LIEF::assembly::x86::OPCODE::PTILEMOVROWrriV)
  .value("PTILESTORED", LIEF::assembly::x86::OPCODE::PTILESTORED)
  .value("PTILEZERO", LIEF::assembly::x86::OPCODE::PTILEZERO)
  .value("PTMMULTF32PS", LIEF::assembly::x86::OPCODE::PTMMULTF32PS)
  .value("PTMMULTF32PSV", LIEF::assembly::x86::OPCODE::PTMMULTF32PSV)
  .value("PTTCMMIMFP16PS", LIEF::assembly::x86::OPCODE::PTTCMMIMFP16PS)
  .value("PTTCMMIMFP16PSV", LIEF::assembly::x86::OPCODE::PTTCMMIMFP16PSV)
  .value("PTTCMMRLFP16PS", LIEF::assembly::x86::OPCODE::PTTCMMRLFP16PS)
  .value("PTTCMMRLFP16PSV", LIEF::assembly::x86::OPCODE::PTTCMMRLFP16PSV)
  .value("PTTDPBF16PS", LIEF::assembly::x86::OPCODE::PTTDPBF16PS)
  .value("PTTDPBF16PSV", LIEF::assembly::x86::OPCODE::PTTDPBF16PSV)
  .value("PTTDPFP16PS", LIEF::assembly::x86::OPCODE::PTTDPFP16PS)
  .value("PTTDPFP16PSV", LIEF::assembly::x86::OPCODE::PTTDPFP16PSV)
  .value("PTTMMULTF32PS", LIEF::assembly::x86::OPCODE::PTTMMULTF32PS)
  .value("PTTMMULTF32PSV", LIEF::assembly::x86::OPCODE::PTTMMULTF32PSV)
  .value("PTTRANSPOSED", LIEF::assembly::x86::OPCODE::PTTRANSPOSED)
  .value("PTTRANSPOSEDV", LIEF::assembly::x86::OPCODE::PTTRANSPOSEDV)
  .value("PTWRITE64m", LIEF::assembly::x86::OPCODE::PTWRITE64m)
  .value("PTWRITE64r", LIEF::assembly::x86::OPCODE::PTWRITE64r)
  .value("PTWRITEm", LIEF::assembly::x86::OPCODE::PTWRITEm)
  .value("PTWRITEr", LIEF::assembly::x86::OPCODE::PTWRITEr)
  .value("PUNPCKHBWrm", LIEF::assembly::x86::OPCODE::PUNPCKHBWrm)
  .value("PUNPCKHBWrr", LIEF::assembly::x86::OPCODE::PUNPCKHBWrr)
  .value("PUNPCKHDQrm", LIEF::assembly::x86::OPCODE::PUNPCKHDQrm)
  .value("PUNPCKHDQrr", LIEF::assembly::x86::OPCODE::PUNPCKHDQrr)
  .value("PUNPCKHQDQrm", LIEF::assembly::x86::OPCODE::PUNPCKHQDQrm)
  .value("PUNPCKHQDQrr", LIEF::assembly::x86::OPCODE::PUNPCKHQDQrr)
  .value("PUNPCKHWDrm", LIEF::assembly::x86::OPCODE::PUNPCKHWDrm)
  .value("PUNPCKHWDrr", LIEF::assembly::x86::OPCODE::PUNPCKHWDrr)
  .value("PUNPCKLBWrm", LIEF::assembly::x86::OPCODE::PUNPCKLBWrm)
  .value("PUNPCKLBWrr", LIEF::assembly::x86::OPCODE::PUNPCKLBWrr)
  .value("PUNPCKLDQrm", LIEF::assembly::x86::OPCODE::PUNPCKLDQrm)
  .value("PUNPCKLDQrr", LIEF::assembly::x86::OPCODE::PUNPCKLDQrr)
  .value("PUNPCKLQDQrm", LIEF::assembly::x86::OPCODE::PUNPCKLQDQrm)
  .value("PUNPCKLQDQrr", LIEF::assembly::x86::OPCODE::PUNPCKLQDQrr)
  .value("PUNPCKLWDrm", LIEF::assembly::x86::OPCODE::PUNPCKLWDrm)
  .value("PUNPCKLWDrr", LIEF::assembly::x86::OPCODE::PUNPCKLWDrr)
  .value("PUSH16i", LIEF::assembly::x86::OPCODE::PUSH16i)
  .value("PUSH16i8", LIEF::assembly::x86::OPCODE::PUSH16i8)
  .value("PUSH16r", LIEF::assembly::x86::OPCODE::PUSH16r)
  .value("PUSH16rmm", LIEF::assembly::x86::OPCODE::PUSH16rmm)
  .value("PUSH16rmr", LIEF::assembly::x86::OPCODE::PUSH16rmr)
  .value("PUSH2", LIEF::assembly::x86::OPCODE::PUSH2)
  .value("PUSH2P", LIEF::assembly::x86::OPCODE::PUSH2P)
  .value("PUSH32i", LIEF::assembly::x86::OPCODE::PUSH32i)
  .value("PUSH32i8", LIEF::assembly::x86::OPCODE::PUSH32i8)
  .value("PUSH32r", LIEF::assembly::x86::OPCODE::PUSH32r)
  .value("PUSH32rmm", LIEF::assembly::x86::OPCODE::PUSH32rmm)
  .value("PUSH32rmr", LIEF::assembly::x86::OPCODE::PUSH32rmr)
  .value("PUSH64i32", LIEF::assembly::x86::OPCODE::PUSH64i32)
  .value("PUSH64i8", LIEF::assembly::x86::OPCODE::PUSH64i8)
  .value("PUSH64r", LIEF::assembly::x86::OPCODE::PUSH64r)
  .value("PUSH64rmm", LIEF::assembly::x86::OPCODE::PUSH64rmm)
  .value("PUSH64rmr", LIEF::assembly::x86::OPCODE::PUSH64rmr)
  .value("PUSHA16", LIEF::assembly::x86::OPCODE::PUSHA16)
  .value("PUSHA32", LIEF::assembly::x86::OPCODE::PUSHA32)
  .value("PUSHCS16", LIEF::assembly::x86::OPCODE::PUSHCS16)
  .value("PUSHCS32", LIEF::assembly::x86::OPCODE::PUSHCS32)
  .value("PUSHDS16", LIEF::assembly::x86::OPCODE::PUSHDS16)
  .value("PUSHDS32", LIEF::assembly::x86::OPCODE::PUSHDS32)
  .value("PUSHES16", LIEF::assembly::x86::OPCODE::PUSHES16)
  .value("PUSHES32", LIEF::assembly::x86::OPCODE::PUSHES32)
  .value("PUSHF16", LIEF::assembly::x86::OPCODE::PUSHF16)
  .value("PUSHF32", LIEF::assembly::x86::OPCODE::PUSHF32)
  .value("PUSHF64", LIEF::assembly::x86::OPCODE::PUSHF64)
  .value("PUSHFS16", LIEF::assembly::x86::OPCODE::PUSHFS16)
  .value("PUSHFS32", LIEF::assembly::x86::OPCODE::PUSHFS32)
  .value("PUSHFS64", LIEF::assembly::x86::OPCODE::PUSHFS64)
  .value("PUSHGS16", LIEF::assembly::x86::OPCODE::PUSHGS16)
  .value("PUSHGS32", LIEF::assembly::x86::OPCODE::PUSHGS32)
  .value("PUSHGS64", LIEF::assembly::x86::OPCODE::PUSHGS64)
  .value("PUSHP64r", LIEF::assembly::x86::OPCODE::PUSHP64r)
  .value("PUSHSS16", LIEF::assembly::x86::OPCODE::PUSHSS16)
  .value("PUSHSS32", LIEF::assembly::x86::OPCODE::PUSHSS32)
  .value("PVALIDATE32", LIEF::assembly::x86::OPCODE::PVALIDATE32)
  .value("PVALIDATE64", LIEF::assembly::x86::OPCODE::PVALIDATE64)
  .value("PXORrm", LIEF::assembly::x86::OPCODE::PXORrm)
  .value("PXORrr", LIEF::assembly::x86::OPCODE::PXORrr)
  .value("RCL16m1", LIEF::assembly::x86::OPCODE::RCL16m1)
  .value("RCL16m1_EVEX", LIEF::assembly::x86::OPCODE::RCL16m1_EVEX)
  .value("RCL16m1_ND", LIEF::assembly::x86::OPCODE::RCL16m1_ND)
  .value("RCL16mCL", LIEF::assembly::x86::OPCODE::RCL16mCL)
  .value("RCL16mCL_EVEX", LIEF::assembly::x86::OPCODE::RCL16mCL_EVEX)
  .value("RCL16mCL_ND", LIEF::assembly::x86::OPCODE::RCL16mCL_ND)
  .value("RCL16mi", LIEF::assembly::x86::OPCODE::RCL16mi)
  .value("RCL16mi_EVEX", LIEF::assembly::x86::OPCODE::RCL16mi_EVEX)
  .value("RCL16mi_ND", LIEF::assembly::x86::OPCODE::RCL16mi_ND)
  .value("RCL16r1", LIEF::assembly::x86::OPCODE::RCL16r1)
  .value("RCL16r1_EVEX", LIEF::assembly::x86::OPCODE::RCL16r1_EVEX)
  .value("RCL16r1_ND", LIEF::assembly::x86::OPCODE::RCL16r1_ND)
  .value("RCL16rCL", LIEF::assembly::x86::OPCODE::RCL16rCL)
  .value("RCL16rCL_EVEX", LIEF::assembly::x86::OPCODE::RCL16rCL_EVEX)
  .value("RCL16rCL_ND", LIEF::assembly::x86::OPCODE::RCL16rCL_ND)
  .value("RCL16ri", LIEF::assembly::x86::OPCODE::RCL16ri)
  .value("RCL16ri_EVEX", LIEF::assembly::x86::OPCODE::RCL16ri_EVEX)
  .value("RCL16ri_ND", LIEF::assembly::x86::OPCODE::RCL16ri_ND)
  .value("RCL32m1", LIEF::assembly::x86::OPCODE::RCL32m1)
  .value("RCL32m1_EVEX", LIEF::assembly::x86::OPCODE::RCL32m1_EVEX)
  .value("RCL32m1_ND", LIEF::assembly::x86::OPCODE::RCL32m1_ND)
  .value("RCL32mCL", LIEF::assembly::x86::OPCODE::RCL32mCL)
  .value("RCL32mCL_EVEX", LIEF::assembly::x86::OPCODE::RCL32mCL_EVEX)
  .value("RCL32mCL_ND", LIEF::assembly::x86::OPCODE::RCL32mCL_ND)
  .value("RCL32mi", LIEF::assembly::x86::OPCODE::RCL32mi)
  .value("RCL32mi_EVEX", LIEF::assembly::x86::OPCODE::RCL32mi_EVEX)
  .value("RCL32mi_ND", LIEF::assembly::x86::OPCODE::RCL32mi_ND)
  .value("RCL32r1", LIEF::assembly::x86::OPCODE::RCL32r1)
  .value("RCL32r1_EVEX", LIEF::assembly::x86::OPCODE::RCL32r1_EVEX)
  .value("RCL32r1_ND", LIEF::assembly::x86::OPCODE::RCL32r1_ND)
  .value("RCL32rCL", LIEF::assembly::x86::OPCODE::RCL32rCL)
  .value("RCL32rCL_EVEX", LIEF::assembly::x86::OPCODE::RCL32rCL_EVEX)
  .value("RCL32rCL_ND", LIEF::assembly::x86::OPCODE::RCL32rCL_ND)
  .value("RCL32ri", LIEF::assembly::x86::OPCODE::RCL32ri)
  .value("RCL32ri_EVEX", LIEF::assembly::x86::OPCODE::RCL32ri_EVEX)
  .value("RCL32ri_ND", LIEF::assembly::x86::OPCODE::RCL32ri_ND)
  .value("RCL64m1", LIEF::assembly::x86::OPCODE::RCL64m1)
  .value("RCL64m1_EVEX", LIEF::assembly::x86::OPCODE::RCL64m1_EVEX)
  .value("RCL64m1_ND", LIEF::assembly::x86::OPCODE::RCL64m1_ND);
  opcodes.value("RCL64mCL", LIEF::assembly::x86::OPCODE::RCL64mCL)
  .value("RCL64mCL_EVEX", LIEF::assembly::x86::OPCODE::RCL64mCL_EVEX)
  .value("RCL64mCL_ND", LIEF::assembly::x86::OPCODE::RCL64mCL_ND)
  .value("RCL64mi", LIEF::assembly::x86::OPCODE::RCL64mi)
  .value("RCL64mi_EVEX", LIEF::assembly::x86::OPCODE::RCL64mi_EVEX)
  .value("RCL64mi_ND", LIEF::assembly::x86::OPCODE::RCL64mi_ND)
  .value("RCL64r1", LIEF::assembly::x86::OPCODE::RCL64r1)
  .value("RCL64r1_EVEX", LIEF::assembly::x86::OPCODE::RCL64r1_EVEX)
  .value("RCL64r1_ND", LIEF::assembly::x86::OPCODE::RCL64r1_ND)
  .value("RCL64rCL", LIEF::assembly::x86::OPCODE::RCL64rCL)
  .value("RCL64rCL_EVEX", LIEF::assembly::x86::OPCODE::RCL64rCL_EVEX)
  .value("RCL64rCL_ND", LIEF::assembly::x86::OPCODE::RCL64rCL_ND)
  .value("RCL64ri", LIEF::assembly::x86::OPCODE::RCL64ri)
  .value("RCL64ri_EVEX", LIEF::assembly::x86::OPCODE::RCL64ri_EVEX)
  .value("RCL64ri_ND", LIEF::assembly::x86::OPCODE::RCL64ri_ND)
  .value("RCL8m1", LIEF::assembly::x86::OPCODE::RCL8m1)
  .value("RCL8m1_EVEX", LIEF::assembly::x86::OPCODE::RCL8m1_EVEX)
  .value("RCL8m1_ND", LIEF::assembly::x86::OPCODE::RCL8m1_ND)
  .value("RCL8mCL", LIEF::assembly::x86::OPCODE::RCL8mCL)
  .value("RCL8mCL_EVEX", LIEF::assembly::x86::OPCODE::RCL8mCL_EVEX)
  .value("RCL8mCL_ND", LIEF::assembly::x86::OPCODE::RCL8mCL_ND)
  .value("RCL8mi", LIEF::assembly::x86::OPCODE::RCL8mi)
  .value("RCL8mi_EVEX", LIEF::assembly::x86::OPCODE::RCL8mi_EVEX)
  .value("RCL8mi_ND", LIEF::assembly::x86::OPCODE::RCL8mi_ND)
  .value("RCL8r1", LIEF::assembly::x86::OPCODE::RCL8r1)
  .value("RCL8r1_EVEX", LIEF::assembly::x86::OPCODE::RCL8r1_EVEX)
  .value("RCL8r1_ND", LIEF::assembly::x86::OPCODE::RCL8r1_ND)
  .value("RCL8rCL", LIEF::assembly::x86::OPCODE::RCL8rCL)
  .value("RCL8rCL_EVEX", LIEF::assembly::x86::OPCODE::RCL8rCL_EVEX)
  .value("RCL8rCL_ND", LIEF::assembly::x86::OPCODE::RCL8rCL_ND)
  .value("RCL8ri", LIEF::assembly::x86::OPCODE::RCL8ri)
  .value("RCL8ri_EVEX", LIEF::assembly::x86::OPCODE::RCL8ri_EVEX)
  .value("RCL8ri_ND", LIEF::assembly::x86::OPCODE::RCL8ri_ND)
  .value("RCPPSm", LIEF::assembly::x86::OPCODE::RCPPSm)
  .value("RCPPSr", LIEF::assembly::x86::OPCODE::RCPPSr)
  .value("RCPSSm", LIEF::assembly::x86::OPCODE::RCPSSm)
  .value("RCPSSm_Int", LIEF::assembly::x86::OPCODE::RCPSSm_Int)
  .value("RCPSSr", LIEF::assembly::x86::OPCODE::RCPSSr)
  .value("RCPSSr_Int", LIEF::assembly::x86::OPCODE::RCPSSr_Int)
  .value("RCR16m1", LIEF::assembly::x86::OPCODE::RCR16m1)
  .value("RCR16m1_EVEX", LIEF::assembly::x86::OPCODE::RCR16m1_EVEX)
  .value("RCR16m1_ND", LIEF::assembly::x86::OPCODE::RCR16m1_ND)
  .value("RCR16mCL", LIEF::assembly::x86::OPCODE::RCR16mCL)
  .value("RCR16mCL_EVEX", LIEF::assembly::x86::OPCODE::RCR16mCL_EVEX)
  .value("RCR16mCL_ND", LIEF::assembly::x86::OPCODE::RCR16mCL_ND)
  .value("RCR16mi", LIEF::assembly::x86::OPCODE::RCR16mi)
  .value("RCR16mi_EVEX", LIEF::assembly::x86::OPCODE::RCR16mi_EVEX)
  .value("RCR16mi_ND", LIEF::assembly::x86::OPCODE::RCR16mi_ND)
  .value("RCR16r1", LIEF::assembly::x86::OPCODE::RCR16r1)
  .value("RCR16r1_EVEX", LIEF::assembly::x86::OPCODE::RCR16r1_EVEX)
  .value("RCR16r1_ND", LIEF::assembly::x86::OPCODE::RCR16r1_ND)
  .value("RCR16rCL", LIEF::assembly::x86::OPCODE::RCR16rCL)
  .value("RCR16rCL_EVEX", LIEF::assembly::x86::OPCODE::RCR16rCL_EVEX)
  .value("RCR16rCL_ND", LIEF::assembly::x86::OPCODE::RCR16rCL_ND)
  .value("RCR16ri", LIEF::assembly::x86::OPCODE::RCR16ri)
  .value("RCR16ri_EVEX", LIEF::assembly::x86::OPCODE::RCR16ri_EVEX)
  .value("RCR16ri_ND", LIEF::assembly::x86::OPCODE::RCR16ri_ND)
  .value("RCR32m1", LIEF::assembly::x86::OPCODE::RCR32m1)
  .value("RCR32m1_EVEX", LIEF::assembly::x86::OPCODE::RCR32m1_EVEX)
  .value("RCR32m1_ND", LIEF::assembly::x86::OPCODE::RCR32m1_ND)
  .value("RCR32mCL", LIEF::assembly::x86::OPCODE::RCR32mCL)
  .value("RCR32mCL_EVEX", LIEF::assembly::x86::OPCODE::RCR32mCL_EVEX)
  .value("RCR32mCL_ND", LIEF::assembly::x86::OPCODE::RCR32mCL_ND)
  .value("RCR32mi", LIEF::assembly::x86::OPCODE::RCR32mi)
  .value("RCR32mi_EVEX", LIEF::assembly::x86::OPCODE::RCR32mi_EVEX)
  .value("RCR32mi_ND", LIEF::assembly::x86::OPCODE::RCR32mi_ND)
  .value("RCR32r1", LIEF::assembly::x86::OPCODE::RCR32r1)
  .value("RCR32r1_EVEX", LIEF::assembly::x86::OPCODE::RCR32r1_EVEX)
  .value("RCR32r1_ND", LIEF::assembly::x86::OPCODE::RCR32r1_ND)
  .value("RCR32rCL", LIEF::assembly::x86::OPCODE::RCR32rCL)
  .value("RCR32rCL_EVEX", LIEF::assembly::x86::OPCODE::RCR32rCL_EVEX)
  .value("RCR32rCL_ND", LIEF::assembly::x86::OPCODE::RCR32rCL_ND)
  .value("RCR32ri", LIEF::assembly::x86::OPCODE::RCR32ri)
  .value("RCR32ri_EVEX", LIEF::assembly::x86::OPCODE::RCR32ri_EVEX)
  .value("RCR32ri_ND", LIEF::assembly::x86::OPCODE::RCR32ri_ND)
  .value("RCR64m1", LIEF::assembly::x86::OPCODE::RCR64m1)
  .value("RCR64m1_EVEX", LIEF::assembly::x86::OPCODE::RCR64m1_EVEX)
  .value("RCR64m1_ND", LIEF::assembly::x86::OPCODE::RCR64m1_ND)
  .value("RCR64mCL", LIEF::assembly::x86::OPCODE::RCR64mCL)
  .value("RCR64mCL_EVEX", LIEF::assembly::x86::OPCODE::RCR64mCL_EVEX)
  .value("RCR64mCL_ND", LIEF::assembly::x86::OPCODE::RCR64mCL_ND)
  .value("RCR64mi", LIEF::assembly::x86::OPCODE::RCR64mi)
  .value("RCR64mi_EVEX", LIEF::assembly::x86::OPCODE::RCR64mi_EVEX)
  .value("RCR64mi_ND", LIEF::assembly::x86::OPCODE::RCR64mi_ND)
  .value("RCR64r1", LIEF::assembly::x86::OPCODE::RCR64r1)
  .value("RCR64r1_EVEX", LIEF::assembly::x86::OPCODE::RCR64r1_EVEX)
  .value("RCR64r1_ND", LIEF::assembly::x86::OPCODE::RCR64r1_ND)
  .value("RCR64rCL", LIEF::assembly::x86::OPCODE::RCR64rCL)
  .value("RCR64rCL_EVEX", LIEF::assembly::x86::OPCODE::RCR64rCL_EVEX)
  .value("RCR64rCL_ND", LIEF::assembly::x86::OPCODE::RCR64rCL_ND)
  .value("RCR64ri", LIEF::assembly::x86::OPCODE::RCR64ri)
  .value("RCR64ri_EVEX", LIEF::assembly::x86::OPCODE::RCR64ri_EVEX)
  .value("RCR64ri_ND", LIEF::assembly::x86::OPCODE::RCR64ri_ND)
  .value("RCR8m1", LIEF::assembly::x86::OPCODE::RCR8m1)
  .value("RCR8m1_EVEX", LIEF::assembly::x86::OPCODE::RCR8m1_EVEX)
  .value("RCR8m1_ND", LIEF::assembly::x86::OPCODE::RCR8m1_ND)
  .value("RCR8mCL", LIEF::assembly::x86::OPCODE::RCR8mCL)
  .value("RCR8mCL_EVEX", LIEF::assembly::x86::OPCODE::RCR8mCL_EVEX)
  .value("RCR8mCL_ND", LIEF::assembly::x86::OPCODE::RCR8mCL_ND)
  .value("RCR8mi", LIEF::assembly::x86::OPCODE::RCR8mi)
  .value("RCR8mi_EVEX", LIEF::assembly::x86::OPCODE::RCR8mi_EVEX)
  .value("RCR8mi_ND", LIEF::assembly::x86::OPCODE::RCR8mi_ND)
  .value("RCR8r1", LIEF::assembly::x86::OPCODE::RCR8r1)
  .value("RCR8r1_EVEX", LIEF::assembly::x86::OPCODE::RCR8r1_EVEX)
  .value("RCR8r1_ND", LIEF::assembly::x86::OPCODE::RCR8r1_ND)
  .value("RCR8rCL", LIEF::assembly::x86::OPCODE::RCR8rCL)
  .value("RCR8rCL_EVEX", LIEF::assembly::x86::OPCODE::RCR8rCL_EVEX)
  .value("RCR8rCL_ND", LIEF::assembly::x86::OPCODE::RCR8rCL_ND)
  .value("RCR8ri", LIEF::assembly::x86::OPCODE::RCR8ri)
  .value("RCR8ri_EVEX", LIEF::assembly::x86::OPCODE::RCR8ri_EVEX)
  .value("RCR8ri_ND", LIEF::assembly::x86::OPCODE::RCR8ri_ND)
  .value("RDFSBASE", LIEF::assembly::x86::OPCODE::RDFSBASE)
  .value("RDFSBASE64", LIEF::assembly::x86::OPCODE::RDFSBASE64)
  .value("RDGSBASE", LIEF::assembly::x86::OPCODE::RDGSBASE)
  .value("RDGSBASE64", LIEF::assembly::x86::OPCODE::RDGSBASE64)
  .value("RDMSR", LIEF::assembly::x86::OPCODE::RDMSR)
  .value("RDMSRLIST", LIEF::assembly::x86::OPCODE::RDMSRLIST)
  .value("RDMSRri", LIEF::assembly::x86::OPCODE::RDMSRri)
  .value("RDMSRri_EVEX", LIEF::assembly::x86::OPCODE::RDMSRri_EVEX)
  .value("RDPID32", LIEF::assembly::x86::OPCODE::RDPID32)
  .value("RDPID64", LIEF::assembly::x86::OPCODE::RDPID64)
  .value("RDPKRUr", LIEF::assembly::x86::OPCODE::RDPKRUr)
  .value("RDPMC", LIEF::assembly::x86::OPCODE::RDPMC)
  .value("RDPRU", LIEF::assembly::x86::OPCODE::RDPRU)
  .value("RDRAND16r", LIEF::assembly::x86::OPCODE::RDRAND16r)
  .value("RDRAND32r", LIEF::assembly::x86::OPCODE::RDRAND32r)
  .value("RDRAND64r", LIEF::assembly::x86::OPCODE::RDRAND64r)
  .value("RDSEED16r", LIEF::assembly::x86::OPCODE::RDSEED16r)
  .value("RDSEED32r", LIEF::assembly::x86::OPCODE::RDSEED32r)
  .value("RDSEED64r", LIEF::assembly::x86::OPCODE::RDSEED64r)
  .value("RDSSPD", LIEF::assembly::x86::OPCODE::RDSSPD)
  .value("RDSSPQ", LIEF::assembly::x86::OPCODE::RDSSPQ)
  .value("RDTSC", LIEF::assembly::x86::OPCODE::RDTSC)
  .value("RDTSCP", LIEF::assembly::x86::OPCODE::RDTSCP)
  .value("REPNE_PREFIX", LIEF::assembly::x86::OPCODE::REPNE_PREFIX)
  .value("REP_MOVSB_32", LIEF::assembly::x86::OPCODE::REP_MOVSB_32)
  .value("REP_MOVSB_64", LIEF::assembly::x86::OPCODE::REP_MOVSB_64)
  .value("REP_MOVSD_32", LIEF::assembly::x86::OPCODE::REP_MOVSD_32)
  .value("REP_MOVSD_64", LIEF::assembly::x86::OPCODE::REP_MOVSD_64)
  .value("REP_MOVSQ_32", LIEF::assembly::x86::OPCODE::REP_MOVSQ_32)
  .value("REP_MOVSQ_64", LIEF::assembly::x86::OPCODE::REP_MOVSQ_64)
  .value("REP_MOVSW_32", LIEF::assembly::x86::OPCODE::REP_MOVSW_32)
  .value("REP_MOVSW_64", LIEF::assembly::x86::OPCODE::REP_MOVSW_64)
  .value("REP_PREFIX", LIEF::assembly::x86::OPCODE::REP_PREFIX)
  .value("REP_STOSB_32", LIEF::assembly::x86::OPCODE::REP_STOSB_32)
  .value("REP_STOSB_64", LIEF::assembly::x86::OPCODE::REP_STOSB_64)
  .value("REP_STOSD_32", LIEF::assembly::x86::OPCODE::REP_STOSD_32)
  .value("REP_STOSD_64", LIEF::assembly::x86::OPCODE::REP_STOSD_64)
  .value("REP_STOSQ_32", LIEF::assembly::x86::OPCODE::REP_STOSQ_32)
  .value("REP_STOSQ_64", LIEF::assembly::x86::OPCODE::REP_STOSQ_64)
  .value("REP_STOSW_32", LIEF::assembly::x86::OPCODE::REP_STOSW_32)
  .value("REP_STOSW_64", LIEF::assembly::x86::OPCODE::REP_STOSW_64)
  .value("RET", LIEF::assembly::x86::OPCODE::RET)
  .value("RET16", LIEF::assembly::x86::OPCODE::RET16)
  .value("RET32", LIEF::assembly::x86::OPCODE::RET32)
  .value("RET64", LIEF::assembly::x86::OPCODE::RET64)
  .value("RETI16", LIEF::assembly::x86::OPCODE::RETI16)
  .value("RETI32", LIEF::assembly::x86::OPCODE::RETI32)
  .value("RETI64", LIEF::assembly::x86::OPCODE::RETI64)
  .value("REX64_PREFIX", LIEF::assembly::x86::OPCODE::REX64_PREFIX)
  .value("RMPADJUST", LIEF::assembly::x86::OPCODE::RMPADJUST)
  .value("RMPQUERY", LIEF::assembly::x86::OPCODE::RMPQUERY)
  .value("RMPUPDATE", LIEF::assembly::x86::OPCODE::RMPUPDATE)
  .value("ROL16m1", LIEF::assembly::x86::OPCODE::ROL16m1)
  .value("ROL16m1_EVEX", LIEF::assembly::x86::OPCODE::ROL16m1_EVEX)
  .value("ROL16m1_ND", LIEF::assembly::x86::OPCODE::ROL16m1_ND)
  .value("ROL16m1_NF", LIEF::assembly::x86::OPCODE::ROL16m1_NF)
  .value("ROL16m1_NF_ND", LIEF::assembly::x86::OPCODE::ROL16m1_NF_ND)
  .value("ROL16mCL", LIEF::assembly::x86::OPCODE::ROL16mCL)
  .value("ROL16mCL_EVEX", LIEF::assembly::x86::OPCODE::ROL16mCL_EVEX)
  .value("ROL16mCL_ND", LIEF::assembly::x86::OPCODE::ROL16mCL_ND)
  .value("ROL16mCL_NF", LIEF::assembly::x86::OPCODE::ROL16mCL_NF)
  .value("ROL16mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL16mCL_NF_ND)
  .value("ROL16mi", LIEF::assembly::x86::OPCODE::ROL16mi)
  .value("ROL16mi_EVEX", LIEF::assembly::x86::OPCODE::ROL16mi_EVEX)
  .value("ROL16mi_ND", LIEF::assembly::x86::OPCODE::ROL16mi_ND)
  .value("ROL16mi_NF", LIEF::assembly::x86::OPCODE::ROL16mi_NF)
  .value("ROL16mi_NF_ND", LIEF::assembly::x86::OPCODE::ROL16mi_NF_ND)
  .value("ROL16r1", LIEF::assembly::x86::OPCODE::ROL16r1)
  .value("ROL16r1_EVEX", LIEF::assembly::x86::OPCODE::ROL16r1_EVEX)
  .value("ROL16r1_ND", LIEF::assembly::x86::OPCODE::ROL16r1_ND)
  .value("ROL16r1_NF", LIEF::assembly::x86::OPCODE::ROL16r1_NF)
  .value("ROL16r1_NF_ND", LIEF::assembly::x86::OPCODE::ROL16r1_NF_ND)
  .value("ROL16rCL", LIEF::assembly::x86::OPCODE::ROL16rCL)
  .value("ROL16rCL_EVEX", LIEF::assembly::x86::OPCODE::ROL16rCL_EVEX)
  .value("ROL16rCL_ND", LIEF::assembly::x86::OPCODE::ROL16rCL_ND)
  .value("ROL16rCL_NF", LIEF::assembly::x86::OPCODE::ROL16rCL_NF)
  .value("ROL16rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL16rCL_NF_ND)
  .value("ROL16ri", LIEF::assembly::x86::OPCODE::ROL16ri)
  .value("ROL16ri_EVEX", LIEF::assembly::x86::OPCODE::ROL16ri_EVEX)
  .value("ROL16ri_ND", LIEF::assembly::x86::OPCODE::ROL16ri_ND)
  .value("ROL16ri_NF", LIEF::assembly::x86::OPCODE::ROL16ri_NF)
  .value("ROL16ri_NF_ND", LIEF::assembly::x86::OPCODE::ROL16ri_NF_ND)
  .value("ROL32m1", LIEF::assembly::x86::OPCODE::ROL32m1)
  .value("ROL32m1_EVEX", LIEF::assembly::x86::OPCODE::ROL32m1_EVEX)
  .value("ROL32m1_ND", LIEF::assembly::x86::OPCODE::ROL32m1_ND)
  .value("ROL32m1_NF", LIEF::assembly::x86::OPCODE::ROL32m1_NF)
  .value("ROL32m1_NF_ND", LIEF::assembly::x86::OPCODE::ROL32m1_NF_ND)
  .value("ROL32mCL", LIEF::assembly::x86::OPCODE::ROL32mCL)
  .value("ROL32mCL_EVEX", LIEF::assembly::x86::OPCODE::ROL32mCL_EVEX)
  .value("ROL32mCL_ND", LIEF::assembly::x86::OPCODE::ROL32mCL_ND)
  .value("ROL32mCL_NF", LIEF::assembly::x86::OPCODE::ROL32mCL_NF)
  .value("ROL32mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL32mCL_NF_ND)
  .value("ROL32mi", LIEF::assembly::x86::OPCODE::ROL32mi)
  .value("ROL32mi_EVEX", LIEF::assembly::x86::OPCODE::ROL32mi_EVEX)
  .value("ROL32mi_ND", LIEF::assembly::x86::OPCODE::ROL32mi_ND)
  .value("ROL32mi_NF", LIEF::assembly::x86::OPCODE::ROL32mi_NF)
  .value("ROL32mi_NF_ND", LIEF::assembly::x86::OPCODE::ROL32mi_NF_ND)
  .value("ROL32r1", LIEF::assembly::x86::OPCODE::ROL32r1)
  .value("ROL32r1_EVEX", LIEF::assembly::x86::OPCODE::ROL32r1_EVEX)
  .value("ROL32r1_ND", LIEF::assembly::x86::OPCODE::ROL32r1_ND)
  .value("ROL32r1_NF", LIEF::assembly::x86::OPCODE::ROL32r1_NF)
  .value("ROL32r1_NF_ND", LIEF::assembly::x86::OPCODE::ROL32r1_NF_ND)
  .value("ROL32rCL", LIEF::assembly::x86::OPCODE::ROL32rCL)
  .value("ROL32rCL_EVEX", LIEF::assembly::x86::OPCODE::ROL32rCL_EVEX)
  .value("ROL32rCL_ND", LIEF::assembly::x86::OPCODE::ROL32rCL_ND)
  .value("ROL32rCL_NF", LIEF::assembly::x86::OPCODE::ROL32rCL_NF)
  .value("ROL32rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL32rCL_NF_ND)
  .value("ROL32ri", LIEF::assembly::x86::OPCODE::ROL32ri)
  .value("ROL32ri_EVEX", LIEF::assembly::x86::OPCODE::ROL32ri_EVEX)
  .value("ROL32ri_ND", LIEF::assembly::x86::OPCODE::ROL32ri_ND)
  .value("ROL32ri_NF", LIEF::assembly::x86::OPCODE::ROL32ri_NF)
  .value("ROL32ri_NF_ND", LIEF::assembly::x86::OPCODE::ROL32ri_NF_ND)
  .value("ROL64m1", LIEF::assembly::x86::OPCODE::ROL64m1)
  .value("ROL64m1_EVEX", LIEF::assembly::x86::OPCODE::ROL64m1_EVEX)
  .value("ROL64m1_ND", LIEF::assembly::x86::OPCODE::ROL64m1_ND)
  .value("ROL64m1_NF", LIEF::assembly::x86::OPCODE::ROL64m1_NF)
  .value("ROL64m1_NF_ND", LIEF::assembly::x86::OPCODE::ROL64m1_NF_ND)
  .value("ROL64mCL", LIEF::assembly::x86::OPCODE::ROL64mCL)
  .value("ROL64mCL_EVEX", LIEF::assembly::x86::OPCODE::ROL64mCL_EVEX)
  .value("ROL64mCL_ND", LIEF::assembly::x86::OPCODE::ROL64mCL_ND)
  .value("ROL64mCL_NF", LIEF::assembly::x86::OPCODE::ROL64mCL_NF)
  .value("ROL64mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL64mCL_NF_ND)
  .value("ROL64mi", LIEF::assembly::x86::OPCODE::ROL64mi)
  .value("ROL64mi_EVEX", LIEF::assembly::x86::OPCODE::ROL64mi_EVEX)
  .value("ROL64mi_ND", LIEF::assembly::x86::OPCODE::ROL64mi_ND)
  .value("ROL64mi_NF", LIEF::assembly::x86::OPCODE::ROL64mi_NF)
  .value("ROL64mi_NF_ND", LIEF::assembly::x86::OPCODE::ROL64mi_NF_ND)
  .value("ROL64r1", LIEF::assembly::x86::OPCODE::ROL64r1)
  .value("ROL64r1_EVEX", LIEF::assembly::x86::OPCODE::ROL64r1_EVEX)
  .value("ROL64r1_ND", LIEF::assembly::x86::OPCODE::ROL64r1_ND)
  .value("ROL64r1_NF", LIEF::assembly::x86::OPCODE::ROL64r1_NF)
  .value("ROL64r1_NF_ND", LIEF::assembly::x86::OPCODE::ROL64r1_NF_ND)
  .value("ROL64rCL", LIEF::assembly::x86::OPCODE::ROL64rCL)
  .value("ROL64rCL_EVEX", LIEF::assembly::x86::OPCODE::ROL64rCL_EVEX)
  .value("ROL64rCL_ND", LIEF::assembly::x86::OPCODE::ROL64rCL_ND)
  .value("ROL64rCL_NF", LIEF::assembly::x86::OPCODE::ROL64rCL_NF)
  .value("ROL64rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL64rCL_NF_ND)
  .value("ROL64ri", LIEF::assembly::x86::OPCODE::ROL64ri)
  .value("ROL64ri_EVEX", LIEF::assembly::x86::OPCODE::ROL64ri_EVEX)
  .value("ROL64ri_ND", LIEF::assembly::x86::OPCODE::ROL64ri_ND)
  .value("ROL64ri_NF", LIEF::assembly::x86::OPCODE::ROL64ri_NF)
  .value("ROL64ri_NF_ND", LIEF::assembly::x86::OPCODE::ROL64ri_NF_ND)
  .value("ROL8m1", LIEF::assembly::x86::OPCODE::ROL8m1)
  .value("ROL8m1_EVEX", LIEF::assembly::x86::OPCODE::ROL8m1_EVEX)
  .value("ROL8m1_ND", LIEF::assembly::x86::OPCODE::ROL8m1_ND)
  .value("ROL8m1_NF", LIEF::assembly::x86::OPCODE::ROL8m1_NF)
  .value("ROL8m1_NF_ND", LIEF::assembly::x86::OPCODE::ROL8m1_NF_ND)
  .value("ROL8mCL", LIEF::assembly::x86::OPCODE::ROL8mCL)
  .value("ROL8mCL_EVEX", LIEF::assembly::x86::OPCODE::ROL8mCL_EVEX)
  .value("ROL8mCL_ND", LIEF::assembly::x86::OPCODE::ROL8mCL_ND)
  .value("ROL8mCL_NF", LIEF::assembly::x86::OPCODE::ROL8mCL_NF)
  .value("ROL8mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL8mCL_NF_ND)
  .value("ROL8mi", LIEF::assembly::x86::OPCODE::ROL8mi)
  .value("ROL8mi_EVEX", LIEF::assembly::x86::OPCODE::ROL8mi_EVEX)
  .value("ROL8mi_ND", LIEF::assembly::x86::OPCODE::ROL8mi_ND)
  .value("ROL8mi_NF", LIEF::assembly::x86::OPCODE::ROL8mi_NF)
  .value("ROL8mi_NF_ND", LIEF::assembly::x86::OPCODE::ROL8mi_NF_ND)
  .value("ROL8r1", LIEF::assembly::x86::OPCODE::ROL8r1)
  .value("ROL8r1_EVEX", LIEF::assembly::x86::OPCODE::ROL8r1_EVEX)
  .value("ROL8r1_ND", LIEF::assembly::x86::OPCODE::ROL8r1_ND)
  .value("ROL8r1_NF", LIEF::assembly::x86::OPCODE::ROL8r1_NF)
  .value("ROL8r1_NF_ND", LIEF::assembly::x86::OPCODE::ROL8r1_NF_ND)
  .value("ROL8rCL", LIEF::assembly::x86::OPCODE::ROL8rCL)
  .value("ROL8rCL_EVEX", LIEF::assembly::x86::OPCODE::ROL8rCL_EVEX)
  .value("ROL8rCL_ND", LIEF::assembly::x86::OPCODE::ROL8rCL_ND)
  .value("ROL8rCL_NF", LIEF::assembly::x86::OPCODE::ROL8rCL_NF)
  .value("ROL8rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROL8rCL_NF_ND)
  .value("ROL8ri", LIEF::assembly::x86::OPCODE::ROL8ri)
  .value("ROL8ri_EVEX", LIEF::assembly::x86::OPCODE::ROL8ri_EVEX)
  .value("ROL8ri_ND", LIEF::assembly::x86::OPCODE::ROL8ri_ND)
  .value("ROL8ri_NF", LIEF::assembly::x86::OPCODE::ROL8ri_NF)
  .value("ROL8ri_NF_ND", LIEF::assembly::x86::OPCODE::ROL8ri_NF_ND)
  .value("ROR16m1", LIEF::assembly::x86::OPCODE::ROR16m1)
  .value("ROR16m1_EVEX", LIEF::assembly::x86::OPCODE::ROR16m1_EVEX)
  .value("ROR16m1_ND", LIEF::assembly::x86::OPCODE::ROR16m1_ND)
  .value("ROR16m1_NF", LIEF::assembly::x86::OPCODE::ROR16m1_NF)
  .value("ROR16m1_NF_ND", LIEF::assembly::x86::OPCODE::ROR16m1_NF_ND)
  .value("ROR16mCL", LIEF::assembly::x86::OPCODE::ROR16mCL)
  .value("ROR16mCL_EVEX", LIEF::assembly::x86::OPCODE::ROR16mCL_EVEX)
  .value("ROR16mCL_ND", LIEF::assembly::x86::OPCODE::ROR16mCL_ND)
  .value("ROR16mCL_NF", LIEF::assembly::x86::OPCODE::ROR16mCL_NF)
  .value("ROR16mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR16mCL_NF_ND)
  .value("ROR16mi", LIEF::assembly::x86::OPCODE::ROR16mi)
  .value("ROR16mi_EVEX", LIEF::assembly::x86::OPCODE::ROR16mi_EVEX)
  .value("ROR16mi_ND", LIEF::assembly::x86::OPCODE::ROR16mi_ND)
  .value("ROR16mi_NF", LIEF::assembly::x86::OPCODE::ROR16mi_NF)
  .value("ROR16mi_NF_ND", LIEF::assembly::x86::OPCODE::ROR16mi_NF_ND)
  .value("ROR16r1", LIEF::assembly::x86::OPCODE::ROR16r1)
  .value("ROR16r1_EVEX", LIEF::assembly::x86::OPCODE::ROR16r1_EVEX);
  opcodes.value("ROR16r1_ND", LIEF::assembly::x86::OPCODE::ROR16r1_ND)
  .value("ROR16r1_NF", LIEF::assembly::x86::OPCODE::ROR16r1_NF)
  .value("ROR16r1_NF_ND", LIEF::assembly::x86::OPCODE::ROR16r1_NF_ND)
  .value("ROR16rCL", LIEF::assembly::x86::OPCODE::ROR16rCL)
  .value("ROR16rCL_EVEX", LIEF::assembly::x86::OPCODE::ROR16rCL_EVEX)
  .value("ROR16rCL_ND", LIEF::assembly::x86::OPCODE::ROR16rCL_ND)
  .value("ROR16rCL_NF", LIEF::assembly::x86::OPCODE::ROR16rCL_NF)
  .value("ROR16rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR16rCL_NF_ND)
  .value("ROR16ri", LIEF::assembly::x86::OPCODE::ROR16ri)
  .value("ROR16ri_EVEX", LIEF::assembly::x86::OPCODE::ROR16ri_EVEX)
  .value("ROR16ri_ND", LIEF::assembly::x86::OPCODE::ROR16ri_ND)
  .value("ROR16ri_NF", LIEF::assembly::x86::OPCODE::ROR16ri_NF)
  .value("ROR16ri_NF_ND", LIEF::assembly::x86::OPCODE::ROR16ri_NF_ND)
  .value("ROR32m1", LIEF::assembly::x86::OPCODE::ROR32m1)
  .value("ROR32m1_EVEX", LIEF::assembly::x86::OPCODE::ROR32m1_EVEX)
  .value("ROR32m1_ND", LIEF::assembly::x86::OPCODE::ROR32m1_ND)
  .value("ROR32m1_NF", LIEF::assembly::x86::OPCODE::ROR32m1_NF)
  .value("ROR32m1_NF_ND", LIEF::assembly::x86::OPCODE::ROR32m1_NF_ND)
  .value("ROR32mCL", LIEF::assembly::x86::OPCODE::ROR32mCL)
  .value("ROR32mCL_EVEX", LIEF::assembly::x86::OPCODE::ROR32mCL_EVEX)
  .value("ROR32mCL_ND", LIEF::assembly::x86::OPCODE::ROR32mCL_ND)
  .value("ROR32mCL_NF", LIEF::assembly::x86::OPCODE::ROR32mCL_NF)
  .value("ROR32mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR32mCL_NF_ND)
  .value("ROR32mi", LIEF::assembly::x86::OPCODE::ROR32mi)
  .value("ROR32mi_EVEX", LIEF::assembly::x86::OPCODE::ROR32mi_EVEX)
  .value("ROR32mi_ND", LIEF::assembly::x86::OPCODE::ROR32mi_ND)
  .value("ROR32mi_NF", LIEF::assembly::x86::OPCODE::ROR32mi_NF)
  .value("ROR32mi_NF_ND", LIEF::assembly::x86::OPCODE::ROR32mi_NF_ND)
  .value("ROR32r1", LIEF::assembly::x86::OPCODE::ROR32r1)
  .value("ROR32r1_EVEX", LIEF::assembly::x86::OPCODE::ROR32r1_EVEX)
  .value("ROR32r1_ND", LIEF::assembly::x86::OPCODE::ROR32r1_ND)
  .value("ROR32r1_NF", LIEF::assembly::x86::OPCODE::ROR32r1_NF)
  .value("ROR32r1_NF_ND", LIEF::assembly::x86::OPCODE::ROR32r1_NF_ND)
  .value("ROR32rCL", LIEF::assembly::x86::OPCODE::ROR32rCL)
  .value("ROR32rCL_EVEX", LIEF::assembly::x86::OPCODE::ROR32rCL_EVEX)
  .value("ROR32rCL_ND", LIEF::assembly::x86::OPCODE::ROR32rCL_ND)
  .value("ROR32rCL_NF", LIEF::assembly::x86::OPCODE::ROR32rCL_NF)
  .value("ROR32rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR32rCL_NF_ND)
  .value("ROR32ri", LIEF::assembly::x86::OPCODE::ROR32ri)
  .value("ROR32ri_EVEX", LIEF::assembly::x86::OPCODE::ROR32ri_EVEX)
  .value("ROR32ri_ND", LIEF::assembly::x86::OPCODE::ROR32ri_ND)
  .value("ROR32ri_NF", LIEF::assembly::x86::OPCODE::ROR32ri_NF)
  .value("ROR32ri_NF_ND", LIEF::assembly::x86::OPCODE::ROR32ri_NF_ND)
  .value("ROR64m1", LIEF::assembly::x86::OPCODE::ROR64m1)
  .value("ROR64m1_EVEX", LIEF::assembly::x86::OPCODE::ROR64m1_EVEX)
  .value("ROR64m1_ND", LIEF::assembly::x86::OPCODE::ROR64m1_ND)
  .value("ROR64m1_NF", LIEF::assembly::x86::OPCODE::ROR64m1_NF)
  .value("ROR64m1_NF_ND", LIEF::assembly::x86::OPCODE::ROR64m1_NF_ND)
  .value("ROR64mCL", LIEF::assembly::x86::OPCODE::ROR64mCL)
  .value("ROR64mCL_EVEX", LIEF::assembly::x86::OPCODE::ROR64mCL_EVEX)
  .value("ROR64mCL_ND", LIEF::assembly::x86::OPCODE::ROR64mCL_ND)
  .value("ROR64mCL_NF", LIEF::assembly::x86::OPCODE::ROR64mCL_NF)
  .value("ROR64mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR64mCL_NF_ND)
  .value("ROR64mi", LIEF::assembly::x86::OPCODE::ROR64mi)
  .value("ROR64mi_EVEX", LIEF::assembly::x86::OPCODE::ROR64mi_EVEX)
  .value("ROR64mi_ND", LIEF::assembly::x86::OPCODE::ROR64mi_ND)
  .value("ROR64mi_NF", LIEF::assembly::x86::OPCODE::ROR64mi_NF)
  .value("ROR64mi_NF_ND", LIEF::assembly::x86::OPCODE::ROR64mi_NF_ND)
  .value("ROR64r1", LIEF::assembly::x86::OPCODE::ROR64r1)
  .value("ROR64r1_EVEX", LIEF::assembly::x86::OPCODE::ROR64r1_EVEX)
  .value("ROR64r1_ND", LIEF::assembly::x86::OPCODE::ROR64r1_ND)
  .value("ROR64r1_NF", LIEF::assembly::x86::OPCODE::ROR64r1_NF)
  .value("ROR64r1_NF_ND", LIEF::assembly::x86::OPCODE::ROR64r1_NF_ND)
  .value("ROR64rCL", LIEF::assembly::x86::OPCODE::ROR64rCL)
  .value("ROR64rCL_EVEX", LIEF::assembly::x86::OPCODE::ROR64rCL_EVEX)
  .value("ROR64rCL_ND", LIEF::assembly::x86::OPCODE::ROR64rCL_ND)
  .value("ROR64rCL_NF", LIEF::assembly::x86::OPCODE::ROR64rCL_NF)
  .value("ROR64rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR64rCL_NF_ND)
  .value("ROR64ri", LIEF::assembly::x86::OPCODE::ROR64ri)
  .value("ROR64ri_EVEX", LIEF::assembly::x86::OPCODE::ROR64ri_EVEX)
  .value("ROR64ri_ND", LIEF::assembly::x86::OPCODE::ROR64ri_ND)
  .value("ROR64ri_NF", LIEF::assembly::x86::OPCODE::ROR64ri_NF)
  .value("ROR64ri_NF_ND", LIEF::assembly::x86::OPCODE::ROR64ri_NF_ND)
  .value("ROR8m1", LIEF::assembly::x86::OPCODE::ROR8m1)
  .value("ROR8m1_EVEX", LIEF::assembly::x86::OPCODE::ROR8m1_EVEX)
  .value("ROR8m1_ND", LIEF::assembly::x86::OPCODE::ROR8m1_ND)
  .value("ROR8m1_NF", LIEF::assembly::x86::OPCODE::ROR8m1_NF)
  .value("ROR8m1_NF_ND", LIEF::assembly::x86::OPCODE::ROR8m1_NF_ND)
  .value("ROR8mCL", LIEF::assembly::x86::OPCODE::ROR8mCL)
  .value("ROR8mCL_EVEX", LIEF::assembly::x86::OPCODE::ROR8mCL_EVEX)
  .value("ROR8mCL_ND", LIEF::assembly::x86::OPCODE::ROR8mCL_ND)
  .value("ROR8mCL_NF", LIEF::assembly::x86::OPCODE::ROR8mCL_NF)
  .value("ROR8mCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR8mCL_NF_ND)
  .value("ROR8mi", LIEF::assembly::x86::OPCODE::ROR8mi)
  .value("ROR8mi_EVEX", LIEF::assembly::x86::OPCODE::ROR8mi_EVEX)
  .value("ROR8mi_ND", LIEF::assembly::x86::OPCODE::ROR8mi_ND)
  .value("ROR8mi_NF", LIEF::assembly::x86::OPCODE::ROR8mi_NF)
  .value("ROR8mi_NF_ND", LIEF::assembly::x86::OPCODE::ROR8mi_NF_ND)
  .value("ROR8r1", LIEF::assembly::x86::OPCODE::ROR8r1)
  .value("ROR8r1_EVEX", LIEF::assembly::x86::OPCODE::ROR8r1_EVEX)
  .value("ROR8r1_ND", LIEF::assembly::x86::OPCODE::ROR8r1_ND)
  .value("ROR8r1_NF", LIEF::assembly::x86::OPCODE::ROR8r1_NF)
  .value("ROR8r1_NF_ND", LIEF::assembly::x86::OPCODE::ROR8r1_NF_ND)
  .value("ROR8rCL", LIEF::assembly::x86::OPCODE::ROR8rCL)
  .value("ROR8rCL_EVEX", LIEF::assembly::x86::OPCODE::ROR8rCL_EVEX)
  .value("ROR8rCL_ND", LIEF::assembly::x86::OPCODE::ROR8rCL_ND)
  .value("ROR8rCL_NF", LIEF::assembly::x86::OPCODE::ROR8rCL_NF)
  .value("ROR8rCL_NF_ND", LIEF::assembly::x86::OPCODE::ROR8rCL_NF_ND)
  .value("ROR8ri", LIEF::assembly::x86::OPCODE::ROR8ri)
  .value("ROR8ri_EVEX", LIEF::assembly::x86::OPCODE::ROR8ri_EVEX)
  .value("ROR8ri_ND", LIEF::assembly::x86::OPCODE::ROR8ri_ND)
  .value("ROR8ri_NF", LIEF::assembly::x86::OPCODE::ROR8ri_NF)
  .value("ROR8ri_NF_ND", LIEF::assembly::x86::OPCODE::ROR8ri_NF_ND)
  .value("RORX32mi", LIEF::assembly::x86::OPCODE::RORX32mi)
  .value("RORX32mi_EVEX", LIEF::assembly::x86::OPCODE::RORX32mi_EVEX)
  .value("RORX32ri", LIEF::assembly::x86::OPCODE::RORX32ri)
  .value("RORX32ri_EVEX", LIEF::assembly::x86::OPCODE::RORX32ri_EVEX)
  .value("RORX64mi", LIEF::assembly::x86::OPCODE::RORX64mi)
  .value("RORX64mi_EVEX", LIEF::assembly::x86::OPCODE::RORX64mi_EVEX)
  .value("RORX64ri", LIEF::assembly::x86::OPCODE::RORX64ri)
  .value("RORX64ri_EVEX", LIEF::assembly::x86::OPCODE::RORX64ri_EVEX)
  .value("ROUNDPDmi", LIEF::assembly::x86::OPCODE::ROUNDPDmi)
  .value("ROUNDPDri", LIEF::assembly::x86::OPCODE::ROUNDPDri)
  .value("ROUNDPSmi", LIEF::assembly::x86::OPCODE::ROUNDPSmi)
  .value("ROUNDPSri", LIEF::assembly::x86::OPCODE::ROUNDPSri)
  .value("ROUNDSDmi", LIEF::assembly::x86::OPCODE::ROUNDSDmi)
  .value("ROUNDSDmi_Int", LIEF::assembly::x86::OPCODE::ROUNDSDmi_Int)
  .value("ROUNDSDri", LIEF::assembly::x86::OPCODE::ROUNDSDri)
  .value("ROUNDSDri_Int", LIEF::assembly::x86::OPCODE::ROUNDSDri_Int)
  .value("ROUNDSSmi", LIEF::assembly::x86::OPCODE::ROUNDSSmi)
  .value("ROUNDSSmi_Int", LIEF::assembly::x86::OPCODE::ROUNDSSmi_Int)
  .value("ROUNDSSri", LIEF::assembly::x86::OPCODE::ROUNDSSri)
  .value("ROUNDSSri_Int", LIEF::assembly::x86::OPCODE::ROUNDSSri_Int)
  .value("RSM", LIEF::assembly::x86::OPCODE::RSM)
  .value("RSQRTPSm", LIEF::assembly::x86::OPCODE::RSQRTPSm)
  .value("RSQRTPSr", LIEF::assembly::x86::OPCODE::RSQRTPSr)
  .value("RSQRTSSm", LIEF::assembly::x86::OPCODE::RSQRTSSm)
  .value("RSQRTSSm_Int", LIEF::assembly::x86::OPCODE::RSQRTSSm_Int)
  .value("RSQRTSSr", LIEF::assembly::x86::OPCODE::RSQRTSSr)
  .value("RSQRTSSr_Int", LIEF::assembly::x86::OPCODE::RSQRTSSr_Int)
  .value("RSTORSSP", LIEF::assembly::x86::OPCODE::RSTORSSP)
  .value("SAHF", LIEF::assembly::x86::OPCODE::SAHF)
  .value("SALC", LIEF::assembly::x86::OPCODE::SALC)
  .value("SAR16m1", LIEF::assembly::x86::OPCODE::SAR16m1)
  .value("SAR16m1_EVEX", LIEF::assembly::x86::OPCODE::SAR16m1_EVEX)
  .value("SAR16m1_ND", LIEF::assembly::x86::OPCODE::SAR16m1_ND)
  .value("SAR16m1_NF", LIEF::assembly::x86::OPCODE::SAR16m1_NF)
  .value("SAR16m1_NF_ND", LIEF::assembly::x86::OPCODE::SAR16m1_NF_ND)
  .value("SAR16mCL", LIEF::assembly::x86::OPCODE::SAR16mCL)
  .value("SAR16mCL_EVEX", LIEF::assembly::x86::OPCODE::SAR16mCL_EVEX)
  .value("SAR16mCL_ND", LIEF::assembly::x86::OPCODE::SAR16mCL_ND)
  .value("SAR16mCL_NF", LIEF::assembly::x86::OPCODE::SAR16mCL_NF)
  .value("SAR16mCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR16mCL_NF_ND)
  .value("SAR16mi", LIEF::assembly::x86::OPCODE::SAR16mi)
  .value("SAR16mi_EVEX", LIEF::assembly::x86::OPCODE::SAR16mi_EVEX)
  .value("SAR16mi_ND", LIEF::assembly::x86::OPCODE::SAR16mi_ND)
  .value("SAR16mi_NF", LIEF::assembly::x86::OPCODE::SAR16mi_NF)
  .value("SAR16mi_NF_ND", LIEF::assembly::x86::OPCODE::SAR16mi_NF_ND)
  .value("SAR16r1", LIEF::assembly::x86::OPCODE::SAR16r1)
  .value("SAR16r1_EVEX", LIEF::assembly::x86::OPCODE::SAR16r1_EVEX)
  .value("SAR16r1_ND", LIEF::assembly::x86::OPCODE::SAR16r1_ND)
  .value("SAR16r1_NF", LIEF::assembly::x86::OPCODE::SAR16r1_NF)
  .value("SAR16r1_NF_ND", LIEF::assembly::x86::OPCODE::SAR16r1_NF_ND)
  .value("SAR16rCL", LIEF::assembly::x86::OPCODE::SAR16rCL)
  .value("SAR16rCL_EVEX", LIEF::assembly::x86::OPCODE::SAR16rCL_EVEX)
  .value("SAR16rCL_ND", LIEF::assembly::x86::OPCODE::SAR16rCL_ND)
  .value("SAR16rCL_NF", LIEF::assembly::x86::OPCODE::SAR16rCL_NF)
  .value("SAR16rCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR16rCL_NF_ND)
  .value("SAR16ri", LIEF::assembly::x86::OPCODE::SAR16ri)
  .value("SAR16ri_EVEX", LIEF::assembly::x86::OPCODE::SAR16ri_EVEX)
  .value("SAR16ri_ND", LIEF::assembly::x86::OPCODE::SAR16ri_ND)
  .value("SAR16ri_NF", LIEF::assembly::x86::OPCODE::SAR16ri_NF)
  .value("SAR16ri_NF_ND", LIEF::assembly::x86::OPCODE::SAR16ri_NF_ND)
  .value("SAR32m1", LIEF::assembly::x86::OPCODE::SAR32m1)
  .value("SAR32m1_EVEX", LIEF::assembly::x86::OPCODE::SAR32m1_EVEX)
  .value("SAR32m1_ND", LIEF::assembly::x86::OPCODE::SAR32m1_ND)
  .value("SAR32m1_NF", LIEF::assembly::x86::OPCODE::SAR32m1_NF)
  .value("SAR32m1_NF_ND", LIEF::assembly::x86::OPCODE::SAR32m1_NF_ND)
  .value("SAR32mCL", LIEF::assembly::x86::OPCODE::SAR32mCL)
  .value("SAR32mCL_EVEX", LIEF::assembly::x86::OPCODE::SAR32mCL_EVEX)
  .value("SAR32mCL_ND", LIEF::assembly::x86::OPCODE::SAR32mCL_ND)
  .value("SAR32mCL_NF", LIEF::assembly::x86::OPCODE::SAR32mCL_NF)
  .value("SAR32mCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR32mCL_NF_ND)
  .value("SAR32mi", LIEF::assembly::x86::OPCODE::SAR32mi)
  .value("SAR32mi_EVEX", LIEF::assembly::x86::OPCODE::SAR32mi_EVEX)
  .value("SAR32mi_ND", LIEF::assembly::x86::OPCODE::SAR32mi_ND)
  .value("SAR32mi_NF", LIEF::assembly::x86::OPCODE::SAR32mi_NF)
  .value("SAR32mi_NF_ND", LIEF::assembly::x86::OPCODE::SAR32mi_NF_ND)
  .value("SAR32r1", LIEF::assembly::x86::OPCODE::SAR32r1)
  .value("SAR32r1_EVEX", LIEF::assembly::x86::OPCODE::SAR32r1_EVEX)
  .value("SAR32r1_ND", LIEF::assembly::x86::OPCODE::SAR32r1_ND)
  .value("SAR32r1_NF", LIEF::assembly::x86::OPCODE::SAR32r1_NF)
  .value("SAR32r1_NF_ND", LIEF::assembly::x86::OPCODE::SAR32r1_NF_ND)
  .value("SAR32rCL", LIEF::assembly::x86::OPCODE::SAR32rCL)
  .value("SAR32rCL_EVEX", LIEF::assembly::x86::OPCODE::SAR32rCL_EVEX)
  .value("SAR32rCL_ND", LIEF::assembly::x86::OPCODE::SAR32rCL_ND)
  .value("SAR32rCL_NF", LIEF::assembly::x86::OPCODE::SAR32rCL_NF)
  .value("SAR32rCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR32rCL_NF_ND)
  .value("SAR32ri", LIEF::assembly::x86::OPCODE::SAR32ri)
  .value("SAR32ri_EVEX", LIEF::assembly::x86::OPCODE::SAR32ri_EVEX)
  .value("SAR32ri_ND", LIEF::assembly::x86::OPCODE::SAR32ri_ND)
  .value("SAR32ri_NF", LIEF::assembly::x86::OPCODE::SAR32ri_NF)
  .value("SAR32ri_NF_ND", LIEF::assembly::x86::OPCODE::SAR32ri_NF_ND)
  .value("SAR64m1", LIEF::assembly::x86::OPCODE::SAR64m1)
  .value("SAR64m1_EVEX", LIEF::assembly::x86::OPCODE::SAR64m1_EVEX)
  .value("SAR64m1_ND", LIEF::assembly::x86::OPCODE::SAR64m1_ND)
  .value("SAR64m1_NF", LIEF::assembly::x86::OPCODE::SAR64m1_NF)
  .value("SAR64m1_NF_ND", LIEF::assembly::x86::OPCODE::SAR64m1_NF_ND)
  .value("SAR64mCL", LIEF::assembly::x86::OPCODE::SAR64mCL)
  .value("SAR64mCL_EVEX", LIEF::assembly::x86::OPCODE::SAR64mCL_EVEX)
  .value("SAR64mCL_ND", LIEF::assembly::x86::OPCODE::SAR64mCL_ND)
  .value("SAR64mCL_NF", LIEF::assembly::x86::OPCODE::SAR64mCL_NF)
  .value("SAR64mCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR64mCL_NF_ND)
  .value("SAR64mi", LIEF::assembly::x86::OPCODE::SAR64mi)
  .value("SAR64mi_EVEX", LIEF::assembly::x86::OPCODE::SAR64mi_EVEX)
  .value("SAR64mi_ND", LIEF::assembly::x86::OPCODE::SAR64mi_ND)
  .value("SAR64mi_NF", LIEF::assembly::x86::OPCODE::SAR64mi_NF)
  .value("SAR64mi_NF_ND", LIEF::assembly::x86::OPCODE::SAR64mi_NF_ND)
  .value("SAR64r1", LIEF::assembly::x86::OPCODE::SAR64r1)
  .value("SAR64r1_EVEX", LIEF::assembly::x86::OPCODE::SAR64r1_EVEX)
  .value("SAR64r1_ND", LIEF::assembly::x86::OPCODE::SAR64r1_ND)
  .value("SAR64r1_NF", LIEF::assembly::x86::OPCODE::SAR64r1_NF)
  .value("SAR64r1_NF_ND", LIEF::assembly::x86::OPCODE::SAR64r1_NF_ND)
  .value("SAR64rCL", LIEF::assembly::x86::OPCODE::SAR64rCL)
  .value("SAR64rCL_EVEX", LIEF::assembly::x86::OPCODE::SAR64rCL_EVEX)
  .value("SAR64rCL_ND", LIEF::assembly::x86::OPCODE::SAR64rCL_ND)
  .value("SAR64rCL_NF", LIEF::assembly::x86::OPCODE::SAR64rCL_NF)
  .value("SAR64rCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR64rCL_NF_ND)
  .value("SAR64ri", LIEF::assembly::x86::OPCODE::SAR64ri)
  .value("SAR64ri_EVEX", LIEF::assembly::x86::OPCODE::SAR64ri_EVEX)
  .value("SAR64ri_ND", LIEF::assembly::x86::OPCODE::SAR64ri_ND)
  .value("SAR64ri_NF", LIEF::assembly::x86::OPCODE::SAR64ri_NF)
  .value("SAR64ri_NF_ND", LIEF::assembly::x86::OPCODE::SAR64ri_NF_ND)
  .value("SAR8m1", LIEF::assembly::x86::OPCODE::SAR8m1)
  .value("SAR8m1_EVEX", LIEF::assembly::x86::OPCODE::SAR8m1_EVEX)
  .value("SAR8m1_ND", LIEF::assembly::x86::OPCODE::SAR8m1_ND)
  .value("SAR8m1_NF", LIEF::assembly::x86::OPCODE::SAR8m1_NF)
  .value("SAR8m1_NF_ND", LIEF::assembly::x86::OPCODE::SAR8m1_NF_ND)
  .value("SAR8mCL", LIEF::assembly::x86::OPCODE::SAR8mCL)
  .value("SAR8mCL_EVEX", LIEF::assembly::x86::OPCODE::SAR8mCL_EVEX)
  .value("SAR8mCL_ND", LIEF::assembly::x86::OPCODE::SAR8mCL_ND)
  .value("SAR8mCL_NF", LIEF::assembly::x86::OPCODE::SAR8mCL_NF)
  .value("SAR8mCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR8mCL_NF_ND)
  .value("SAR8mi", LIEF::assembly::x86::OPCODE::SAR8mi)
  .value("SAR8mi_EVEX", LIEF::assembly::x86::OPCODE::SAR8mi_EVEX)
  .value("SAR8mi_ND", LIEF::assembly::x86::OPCODE::SAR8mi_ND)
  .value("SAR8mi_NF", LIEF::assembly::x86::OPCODE::SAR8mi_NF)
  .value("SAR8mi_NF_ND", LIEF::assembly::x86::OPCODE::SAR8mi_NF_ND)
  .value("SAR8r1", LIEF::assembly::x86::OPCODE::SAR8r1)
  .value("SAR8r1_EVEX", LIEF::assembly::x86::OPCODE::SAR8r1_EVEX)
  .value("SAR8r1_ND", LIEF::assembly::x86::OPCODE::SAR8r1_ND)
  .value("SAR8r1_NF", LIEF::assembly::x86::OPCODE::SAR8r1_NF)
  .value("SAR8r1_NF_ND", LIEF::assembly::x86::OPCODE::SAR8r1_NF_ND)
  .value("SAR8rCL", LIEF::assembly::x86::OPCODE::SAR8rCL)
  .value("SAR8rCL_EVEX", LIEF::assembly::x86::OPCODE::SAR8rCL_EVEX)
  .value("SAR8rCL_ND", LIEF::assembly::x86::OPCODE::SAR8rCL_ND)
  .value("SAR8rCL_NF", LIEF::assembly::x86::OPCODE::SAR8rCL_NF)
  .value("SAR8rCL_NF_ND", LIEF::assembly::x86::OPCODE::SAR8rCL_NF_ND)
  .value("SAR8ri", LIEF::assembly::x86::OPCODE::SAR8ri)
  .value("SAR8ri_EVEX", LIEF::assembly::x86::OPCODE::SAR8ri_EVEX)
  .value("SAR8ri_ND", LIEF::assembly::x86::OPCODE::SAR8ri_ND)
  .value("SAR8ri_NF", LIEF::assembly::x86::OPCODE::SAR8ri_NF)
  .value("SAR8ri_NF_ND", LIEF::assembly::x86::OPCODE::SAR8ri_NF_ND)
  .value("SARX32rm", LIEF::assembly::x86::OPCODE::SARX32rm)
  .value("SARX32rm_EVEX", LIEF::assembly::x86::OPCODE::SARX32rm_EVEX)
  .value("SARX32rr", LIEF::assembly::x86::OPCODE::SARX32rr)
  .value("SARX32rr_EVEX", LIEF::assembly::x86::OPCODE::SARX32rr_EVEX)
  .value("SARX64rm", LIEF::assembly::x86::OPCODE::SARX64rm)
  .value("SARX64rm_EVEX", LIEF::assembly::x86::OPCODE::SARX64rm_EVEX)
  .value("SARX64rr", LIEF::assembly::x86::OPCODE::SARX64rr)
  .value("SARX64rr_EVEX", LIEF::assembly::x86::OPCODE::SARX64rr_EVEX)
  .value("SAVEPREVSSP", LIEF::assembly::x86::OPCODE::SAVEPREVSSP)
  .value("SBB16i16", LIEF::assembly::x86::OPCODE::SBB16i16)
  .value("SBB16mi", LIEF::assembly::x86::OPCODE::SBB16mi)
  .value("SBB16mi8", LIEF::assembly::x86::OPCODE::SBB16mi8)
  .value("SBB16mi8_EVEX", LIEF::assembly::x86::OPCODE::SBB16mi8_EVEX)
  .value("SBB16mi8_ND", LIEF::assembly::x86::OPCODE::SBB16mi8_ND)
  .value("SBB16mi_EVEX", LIEF::assembly::x86::OPCODE::SBB16mi_EVEX)
  .value("SBB16mi_ND", LIEF::assembly::x86::OPCODE::SBB16mi_ND)
  .value("SBB16mr", LIEF::assembly::x86::OPCODE::SBB16mr)
  .value("SBB16mr_EVEX", LIEF::assembly::x86::OPCODE::SBB16mr_EVEX)
  .value("SBB16mr_ND", LIEF::assembly::x86::OPCODE::SBB16mr_ND)
  .value("SBB16ri", LIEF::assembly::x86::OPCODE::SBB16ri)
  .value("SBB16ri8", LIEF::assembly::x86::OPCODE::SBB16ri8)
  .value("SBB16ri8_EVEX", LIEF::assembly::x86::OPCODE::SBB16ri8_EVEX)
  .value("SBB16ri8_ND", LIEF::assembly::x86::OPCODE::SBB16ri8_ND)
  .value("SBB16ri_EVEX", LIEF::assembly::x86::OPCODE::SBB16ri_EVEX)
  .value("SBB16ri_ND", LIEF::assembly::x86::OPCODE::SBB16ri_ND)
  .value("SBB16rm", LIEF::assembly::x86::OPCODE::SBB16rm)
  .value("SBB16rm_EVEX", LIEF::assembly::x86::OPCODE::SBB16rm_EVEX)
  .value("SBB16rm_ND", LIEF::assembly::x86::OPCODE::SBB16rm_ND)
  .value("SBB16rr", LIEF::assembly::x86::OPCODE::SBB16rr)
  .value("SBB16rr_EVEX", LIEF::assembly::x86::OPCODE::SBB16rr_EVEX)
  .value("SBB16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SBB16rr_EVEX_REV)
  .value("SBB16rr_ND", LIEF::assembly::x86::OPCODE::SBB16rr_ND)
  .value("SBB16rr_ND_REV", LIEF::assembly::x86::OPCODE::SBB16rr_ND_REV)
  .value("SBB16rr_REV", LIEF::assembly::x86::OPCODE::SBB16rr_REV)
  .value("SBB32i32", LIEF::assembly::x86::OPCODE::SBB32i32)
  .value("SBB32mi", LIEF::assembly::x86::OPCODE::SBB32mi)
  .value("SBB32mi8", LIEF::assembly::x86::OPCODE::SBB32mi8)
  .value("SBB32mi8_EVEX", LIEF::assembly::x86::OPCODE::SBB32mi8_EVEX)
  .value("SBB32mi8_ND", LIEF::assembly::x86::OPCODE::SBB32mi8_ND)
  .value("SBB32mi_EVEX", LIEF::assembly::x86::OPCODE::SBB32mi_EVEX)
  .value("SBB32mi_ND", LIEF::assembly::x86::OPCODE::SBB32mi_ND)
  .value("SBB32mr", LIEF::assembly::x86::OPCODE::SBB32mr)
  .value("SBB32mr_EVEX", LIEF::assembly::x86::OPCODE::SBB32mr_EVEX)
  .value("SBB32mr_ND", LIEF::assembly::x86::OPCODE::SBB32mr_ND)
  .value("SBB32ri", LIEF::assembly::x86::OPCODE::SBB32ri)
  .value("SBB32ri8", LIEF::assembly::x86::OPCODE::SBB32ri8)
  .value("SBB32ri8_EVEX", LIEF::assembly::x86::OPCODE::SBB32ri8_EVEX);
  opcodes.value("SBB32ri8_ND", LIEF::assembly::x86::OPCODE::SBB32ri8_ND)
  .value("SBB32ri_EVEX", LIEF::assembly::x86::OPCODE::SBB32ri_EVEX)
  .value("SBB32ri_ND", LIEF::assembly::x86::OPCODE::SBB32ri_ND)
  .value("SBB32rm", LIEF::assembly::x86::OPCODE::SBB32rm)
  .value("SBB32rm_EVEX", LIEF::assembly::x86::OPCODE::SBB32rm_EVEX)
  .value("SBB32rm_ND", LIEF::assembly::x86::OPCODE::SBB32rm_ND)
  .value("SBB32rr", LIEF::assembly::x86::OPCODE::SBB32rr)
  .value("SBB32rr_EVEX", LIEF::assembly::x86::OPCODE::SBB32rr_EVEX)
  .value("SBB32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SBB32rr_EVEX_REV)
  .value("SBB32rr_ND", LIEF::assembly::x86::OPCODE::SBB32rr_ND)
  .value("SBB32rr_ND_REV", LIEF::assembly::x86::OPCODE::SBB32rr_ND_REV)
  .value("SBB32rr_REV", LIEF::assembly::x86::OPCODE::SBB32rr_REV)
  .value("SBB64i32", LIEF::assembly::x86::OPCODE::SBB64i32)
  .value("SBB64mi32", LIEF::assembly::x86::OPCODE::SBB64mi32)
  .value("SBB64mi32_EVEX", LIEF::assembly::x86::OPCODE::SBB64mi32_EVEX)
  .value("SBB64mi32_ND", LIEF::assembly::x86::OPCODE::SBB64mi32_ND)
  .value("SBB64mi8", LIEF::assembly::x86::OPCODE::SBB64mi8)
  .value("SBB64mi8_EVEX", LIEF::assembly::x86::OPCODE::SBB64mi8_EVEX)
  .value("SBB64mi8_ND", LIEF::assembly::x86::OPCODE::SBB64mi8_ND)
  .value("SBB64mr", LIEF::assembly::x86::OPCODE::SBB64mr)
  .value("SBB64mr_EVEX", LIEF::assembly::x86::OPCODE::SBB64mr_EVEX)
  .value("SBB64mr_ND", LIEF::assembly::x86::OPCODE::SBB64mr_ND)
  .value("SBB64ri32", LIEF::assembly::x86::OPCODE::SBB64ri32)
  .value("SBB64ri32_EVEX", LIEF::assembly::x86::OPCODE::SBB64ri32_EVEX)
  .value("SBB64ri32_ND", LIEF::assembly::x86::OPCODE::SBB64ri32_ND)
  .value("SBB64ri8", LIEF::assembly::x86::OPCODE::SBB64ri8)
  .value("SBB64ri8_EVEX", LIEF::assembly::x86::OPCODE::SBB64ri8_EVEX)
  .value("SBB64ri8_ND", LIEF::assembly::x86::OPCODE::SBB64ri8_ND)
  .value("SBB64rm", LIEF::assembly::x86::OPCODE::SBB64rm)
  .value("SBB64rm_EVEX", LIEF::assembly::x86::OPCODE::SBB64rm_EVEX)
  .value("SBB64rm_ND", LIEF::assembly::x86::OPCODE::SBB64rm_ND)
  .value("SBB64rr", LIEF::assembly::x86::OPCODE::SBB64rr)
  .value("SBB64rr_EVEX", LIEF::assembly::x86::OPCODE::SBB64rr_EVEX)
  .value("SBB64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SBB64rr_EVEX_REV)
  .value("SBB64rr_ND", LIEF::assembly::x86::OPCODE::SBB64rr_ND)
  .value("SBB64rr_ND_REV", LIEF::assembly::x86::OPCODE::SBB64rr_ND_REV)
  .value("SBB64rr_REV", LIEF::assembly::x86::OPCODE::SBB64rr_REV)
  .value("SBB8i8", LIEF::assembly::x86::OPCODE::SBB8i8)
  .value("SBB8mi", LIEF::assembly::x86::OPCODE::SBB8mi)
  .value("SBB8mi8", LIEF::assembly::x86::OPCODE::SBB8mi8)
  .value("SBB8mi_EVEX", LIEF::assembly::x86::OPCODE::SBB8mi_EVEX)
  .value("SBB8mi_ND", LIEF::assembly::x86::OPCODE::SBB8mi_ND)
  .value("SBB8mr", LIEF::assembly::x86::OPCODE::SBB8mr)
  .value("SBB8mr_EVEX", LIEF::assembly::x86::OPCODE::SBB8mr_EVEX)
  .value("SBB8mr_ND", LIEF::assembly::x86::OPCODE::SBB8mr_ND)
  .value("SBB8ri", LIEF::assembly::x86::OPCODE::SBB8ri)
  .value("SBB8ri8", LIEF::assembly::x86::OPCODE::SBB8ri8)
  .value("SBB8ri_EVEX", LIEF::assembly::x86::OPCODE::SBB8ri_EVEX)
  .value("SBB8ri_ND", LIEF::assembly::x86::OPCODE::SBB8ri_ND)
  .value("SBB8rm", LIEF::assembly::x86::OPCODE::SBB8rm)
  .value("SBB8rm_EVEX", LIEF::assembly::x86::OPCODE::SBB8rm_EVEX)
  .value("SBB8rm_ND", LIEF::assembly::x86::OPCODE::SBB8rm_ND)
  .value("SBB8rr", LIEF::assembly::x86::OPCODE::SBB8rr)
  .value("SBB8rr_EVEX", LIEF::assembly::x86::OPCODE::SBB8rr_EVEX)
  .value("SBB8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SBB8rr_EVEX_REV)
  .value("SBB8rr_ND", LIEF::assembly::x86::OPCODE::SBB8rr_ND)
  .value("SBB8rr_ND_REV", LIEF::assembly::x86::OPCODE::SBB8rr_ND_REV)
  .value("SBB8rr_REV", LIEF::assembly::x86::OPCODE::SBB8rr_REV)
  .value("SCASB", LIEF::assembly::x86::OPCODE::SCASB)
  .value("SCASL", LIEF::assembly::x86::OPCODE::SCASL)
  .value("SCASQ", LIEF::assembly::x86::OPCODE::SCASQ)
  .value("SCASW", LIEF::assembly::x86::OPCODE::SCASW)
  .value("SEAMCALL", LIEF::assembly::x86::OPCODE::SEAMCALL)
  .value("SEAMOPS", LIEF::assembly::x86::OPCODE::SEAMOPS)
  .value("SEAMRET", LIEF::assembly::x86::OPCODE::SEAMRET)
  .value("SEG_ALLOCA_32", LIEF::assembly::x86::OPCODE::SEG_ALLOCA_32)
  .value("SEG_ALLOCA_64", LIEF::assembly::x86::OPCODE::SEG_ALLOCA_64)
  .value("SENDUIPI", LIEF::assembly::x86::OPCODE::SENDUIPI)
  .value("SERIALIZE", LIEF::assembly::x86::OPCODE::SERIALIZE)
  .value("SETCCm", LIEF::assembly::x86::OPCODE::SETCCm)
  .value("SETCCm_EVEX", LIEF::assembly::x86::OPCODE::SETCCm_EVEX)
  .value("SETCCr", LIEF::assembly::x86::OPCODE::SETCCr)
  .value("SETCCr_EVEX", LIEF::assembly::x86::OPCODE::SETCCr_EVEX)
  .value("SETSSBSY", LIEF::assembly::x86::OPCODE::SETSSBSY)
  .value("SETZUCCm", LIEF::assembly::x86::OPCODE::SETZUCCm)
  .value("SETZUCCr", LIEF::assembly::x86::OPCODE::SETZUCCr)
  .value("SFENCE", LIEF::assembly::x86::OPCODE::SFENCE)
  .value("SGDT16m", LIEF::assembly::x86::OPCODE::SGDT16m)
  .value("SGDT32m", LIEF::assembly::x86::OPCODE::SGDT32m)
  .value("SGDT64m", LIEF::assembly::x86::OPCODE::SGDT64m)
  .value("SHA1MSG1rm", LIEF::assembly::x86::OPCODE::SHA1MSG1rm)
  .value("SHA1MSG1rr", LIEF::assembly::x86::OPCODE::SHA1MSG1rr)
  .value("SHA1MSG2rm", LIEF::assembly::x86::OPCODE::SHA1MSG2rm)
  .value("SHA1MSG2rr", LIEF::assembly::x86::OPCODE::SHA1MSG2rr)
  .value("SHA1NEXTErm", LIEF::assembly::x86::OPCODE::SHA1NEXTErm)
  .value("SHA1NEXTErr", LIEF::assembly::x86::OPCODE::SHA1NEXTErr)
  .value("SHA1RNDS4rmi", LIEF::assembly::x86::OPCODE::SHA1RNDS4rmi)
  .value("SHA1RNDS4rri", LIEF::assembly::x86::OPCODE::SHA1RNDS4rri)
  .value("SHA256MSG1rm", LIEF::assembly::x86::OPCODE::SHA256MSG1rm)
  .value("SHA256MSG1rr", LIEF::assembly::x86::OPCODE::SHA256MSG1rr)
  .value("SHA256MSG2rm", LIEF::assembly::x86::OPCODE::SHA256MSG2rm)
  .value("SHA256MSG2rr", LIEF::assembly::x86::OPCODE::SHA256MSG2rr)
  .value("SHA256RNDS2rm", LIEF::assembly::x86::OPCODE::SHA256RNDS2rm)
  .value("SHA256RNDS2rr", LIEF::assembly::x86::OPCODE::SHA256RNDS2rr)
  .value("SHL16m1", LIEF::assembly::x86::OPCODE::SHL16m1)
  .value("SHL16m1_EVEX", LIEF::assembly::x86::OPCODE::SHL16m1_EVEX)
  .value("SHL16m1_ND", LIEF::assembly::x86::OPCODE::SHL16m1_ND)
  .value("SHL16m1_NF", LIEF::assembly::x86::OPCODE::SHL16m1_NF)
  .value("SHL16m1_NF_ND", LIEF::assembly::x86::OPCODE::SHL16m1_NF_ND)
  .value("SHL16mCL", LIEF::assembly::x86::OPCODE::SHL16mCL)
  .value("SHL16mCL_EVEX", LIEF::assembly::x86::OPCODE::SHL16mCL_EVEX)
  .value("SHL16mCL_ND", LIEF::assembly::x86::OPCODE::SHL16mCL_ND)
  .value("SHL16mCL_NF", LIEF::assembly::x86::OPCODE::SHL16mCL_NF)
  .value("SHL16mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL16mCL_NF_ND)
  .value("SHL16mi", LIEF::assembly::x86::OPCODE::SHL16mi)
  .value("SHL16mi_EVEX", LIEF::assembly::x86::OPCODE::SHL16mi_EVEX)
  .value("SHL16mi_ND", LIEF::assembly::x86::OPCODE::SHL16mi_ND)
  .value("SHL16mi_NF", LIEF::assembly::x86::OPCODE::SHL16mi_NF)
  .value("SHL16mi_NF_ND", LIEF::assembly::x86::OPCODE::SHL16mi_NF_ND)
  .value("SHL16r1", LIEF::assembly::x86::OPCODE::SHL16r1)
  .value("SHL16r1_EVEX", LIEF::assembly::x86::OPCODE::SHL16r1_EVEX)
  .value("SHL16r1_ND", LIEF::assembly::x86::OPCODE::SHL16r1_ND)
  .value("SHL16r1_NF", LIEF::assembly::x86::OPCODE::SHL16r1_NF)
  .value("SHL16r1_NF_ND", LIEF::assembly::x86::OPCODE::SHL16r1_NF_ND)
  .value("SHL16rCL", LIEF::assembly::x86::OPCODE::SHL16rCL)
  .value("SHL16rCL_EVEX", LIEF::assembly::x86::OPCODE::SHL16rCL_EVEX)
  .value("SHL16rCL_ND", LIEF::assembly::x86::OPCODE::SHL16rCL_ND)
  .value("SHL16rCL_NF", LIEF::assembly::x86::OPCODE::SHL16rCL_NF)
  .value("SHL16rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL16rCL_NF_ND)
  .value("SHL16ri", LIEF::assembly::x86::OPCODE::SHL16ri)
  .value("SHL16ri_EVEX", LIEF::assembly::x86::OPCODE::SHL16ri_EVEX)
  .value("SHL16ri_ND", LIEF::assembly::x86::OPCODE::SHL16ri_ND)
  .value("SHL16ri_NF", LIEF::assembly::x86::OPCODE::SHL16ri_NF)
  .value("SHL16ri_NF_ND", LIEF::assembly::x86::OPCODE::SHL16ri_NF_ND)
  .value("SHL32m1", LIEF::assembly::x86::OPCODE::SHL32m1)
  .value("SHL32m1_EVEX", LIEF::assembly::x86::OPCODE::SHL32m1_EVEX)
  .value("SHL32m1_ND", LIEF::assembly::x86::OPCODE::SHL32m1_ND)
  .value("SHL32m1_NF", LIEF::assembly::x86::OPCODE::SHL32m1_NF)
  .value("SHL32m1_NF_ND", LIEF::assembly::x86::OPCODE::SHL32m1_NF_ND)
  .value("SHL32mCL", LIEF::assembly::x86::OPCODE::SHL32mCL)
  .value("SHL32mCL_EVEX", LIEF::assembly::x86::OPCODE::SHL32mCL_EVEX)
  .value("SHL32mCL_ND", LIEF::assembly::x86::OPCODE::SHL32mCL_ND)
  .value("SHL32mCL_NF", LIEF::assembly::x86::OPCODE::SHL32mCL_NF)
  .value("SHL32mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL32mCL_NF_ND)
  .value("SHL32mi", LIEF::assembly::x86::OPCODE::SHL32mi)
  .value("SHL32mi_EVEX", LIEF::assembly::x86::OPCODE::SHL32mi_EVEX)
  .value("SHL32mi_ND", LIEF::assembly::x86::OPCODE::SHL32mi_ND)
  .value("SHL32mi_NF", LIEF::assembly::x86::OPCODE::SHL32mi_NF)
  .value("SHL32mi_NF_ND", LIEF::assembly::x86::OPCODE::SHL32mi_NF_ND)
  .value("SHL32r1", LIEF::assembly::x86::OPCODE::SHL32r1)
  .value("SHL32r1_EVEX", LIEF::assembly::x86::OPCODE::SHL32r1_EVEX)
  .value("SHL32r1_ND", LIEF::assembly::x86::OPCODE::SHL32r1_ND)
  .value("SHL32r1_NF", LIEF::assembly::x86::OPCODE::SHL32r1_NF)
  .value("SHL32r1_NF_ND", LIEF::assembly::x86::OPCODE::SHL32r1_NF_ND)
  .value("SHL32rCL", LIEF::assembly::x86::OPCODE::SHL32rCL)
  .value("SHL32rCL_EVEX", LIEF::assembly::x86::OPCODE::SHL32rCL_EVEX)
  .value("SHL32rCL_ND", LIEF::assembly::x86::OPCODE::SHL32rCL_ND)
  .value("SHL32rCL_NF", LIEF::assembly::x86::OPCODE::SHL32rCL_NF)
  .value("SHL32rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL32rCL_NF_ND)
  .value("SHL32ri", LIEF::assembly::x86::OPCODE::SHL32ri)
  .value("SHL32ri_EVEX", LIEF::assembly::x86::OPCODE::SHL32ri_EVEX)
  .value("SHL32ri_ND", LIEF::assembly::x86::OPCODE::SHL32ri_ND)
  .value("SHL32ri_NF", LIEF::assembly::x86::OPCODE::SHL32ri_NF)
  .value("SHL32ri_NF_ND", LIEF::assembly::x86::OPCODE::SHL32ri_NF_ND)
  .value("SHL64m1", LIEF::assembly::x86::OPCODE::SHL64m1)
  .value("SHL64m1_EVEX", LIEF::assembly::x86::OPCODE::SHL64m1_EVEX)
  .value("SHL64m1_ND", LIEF::assembly::x86::OPCODE::SHL64m1_ND)
  .value("SHL64m1_NF", LIEF::assembly::x86::OPCODE::SHL64m1_NF)
  .value("SHL64m1_NF_ND", LIEF::assembly::x86::OPCODE::SHL64m1_NF_ND)
  .value("SHL64mCL", LIEF::assembly::x86::OPCODE::SHL64mCL)
  .value("SHL64mCL_EVEX", LIEF::assembly::x86::OPCODE::SHL64mCL_EVEX)
  .value("SHL64mCL_ND", LIEF::assembly::x86::OPCODE::SHL64mCL_ND)
  .value("SHL64mCL_NF", LIEF::assembly::x86::OPCODE::SHL64mCL_NF)
  .value("SHL64mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL64mCL_NF_ND)
  .value("SHL64mi", LIEF::assembly::x86::OPCODE::SHL64mi)
  .value("SHL64mi_EVEX", LIEF::assembly::x86::OPCODE::SHL64mi_EVEX)
  .value("SHL64mi_ND", LIEF::assembly::x86::OPCODE::SHL64mi_ND)
  .value("SHL64mi_NF", LIEF::assembly::x86::OPCODE::SHL64mi_NF)
  .value("SHL64mi_NF_ND", LIEF::assembly::x86::OPCODE::SHL64mi_NF_ND)
  .value("SHL64r1", LIEF::assembly::x86::OPCODE::SHL64r1)
  .value("SHL64r1_EVEX", LIEF::assembly::x86::OPCODE::SHL64r1_EVEX)
  .value("SHL64r1_ND", LIEF::assembly::x86::OPCODE::SHL64r1_ND)
  .value("SHL64r1_NF", LIEF::assembly::x86::OPCODE::SHL64r1_NF)
  .value("SHL64r1_NF_ND", LIEF::assembly::x86::OPCODE::SHL64r1_NF_ND)
  .value("SHL64rCL", LIEF::assembly::x86::OPCODE::SHL64rCL)
  .value("SHL64rCL_EVEX", LIEF::assembly::x86::OPCODE::SHL64rCL_EVEX)
  .value("SHL64rCL_ND", LIEF::assembly::x86::OPCODE::SHL64rCL_ND)
  .value("SHL64rCL_NF", LIEF::assembly::x86::OPCODE::SHL64rCL_NF)
  .value("SHL64rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL64rCL_NF_ND)
  .value("SHL64ri", LIEF::assembly::x86::OPCODE::SHL64ri)
  .value("SHL64ri_EVEX", LIEF::assembly::x86::OPCODE::SHL64ri_EVEX)
  .value("SHL64ri_ND", LIEF::assembly::x86::OPCODE::SHL64ri_ND)
  .value("SHL64ri_NF", LIEF::assembly::x86::OPCODE::SHL64ri_NF)
  .value("SHL64ri_NF_ND", LIEF::assembly::x86::OPCODE::SHL64ri_NF_ND)
  .value("SHL8m1", LIEF::assembly::x86::OPCODE::SHL8m1)
  .value("SHL8m1_EVEX", LIEF::assembly::x86::OPCODE::SHL8m1_EVEX)
  .value("SHL8m1_ND", LIEF::assembly::x86::OPCODE::SHL8m1_ND)
  .value("SHL8m1_NF", LIEF::assembly::x86::OPCODE::SHL8m1_NF)
  .value("SHL8m1_NF_ND", LIEF::assembly::x86::OPCODE::SHL8m1_NF_ND)
  .value("SHL8mCL", LIEF::assembly::x86::OPCODE::SHL8mCL)
  .value("SHL8mCL_EVEX", LIEF::assembly::x86::OPCODE::SHL8mCL_EVEX)
  .value("SHL8mCL_ND", LIEF::assembly::x86::OPCODE::SHL8mCL_ND)
  .value("SHL8mCL_NF", LIEF::assembly::x86::OPCODE::SHL8mCL_NF)
  .value("SHL8mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL8mCL_NF_ND)
  .value("SHL8mi", LIEF::assembly::x86::OPCODE::SHL8mi)
  .value("SHL8mi_EVEX", LIEF::assembly::x86::OPCODE::SHL8mi_EVEX)
  .value("SHL8mi_ND", LIEF::assembly::x86::OPCODE::SHL8mi_ND)
  .value("SHL8mi_NF", LIEF::assembly::x86::OPCODE::SHL8mi_NF)
  .value("SHL8mi_NF_ND", LIEF::assembly::x86::OPCODE::SHL8mi_NF_ND)
  .value("SHL8r1", LIEF::assembly::x86::OPCODE::SHL8r1)
  .value("SHL8r1_EVEX", LIEF::assembly::x86::OPCODE::SHL8r1_EVEX)
  .value("SHL8r1_ND", LIEF::assembly::x86::OPCODE::SHL8r1_ND)
  .value("SHL8r1_NF", LIEF::assembly::x86::OPCODE::SHL8r1_NF)
  .value("SHL8r1_NF_ND", LIEF::assembly::x86::OPCODE::SHL8r1_NF_ND)
  .value("SHL8rCL", LIEF::assembly::x86::OPCODE::SHL8rCL)
  .value("SHL8rCL_EVEX", LIEF::assembly::x86::OPCODE::SHL8rCL_EVEX)
  .value("SHL8rCL_ND", LIEF::assembly::x86::OPCODE::SHL8rCL_ND)
  .value("SHL8rCL_NF", LIEF::assembly::x86::OPCODE::SHL8rCL_NF)
  .value("SHL8rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHL8rCL_NF_ND)
  .value("SHL8ri", LIEF::assembly::x86::OPCODE::SHL8ri)
  .value("SHL8ri_EVEX", LIEF::assembly::x86::OPCODE::SHL8ri_EVEX)
  .value("SHL8ri_ND", LIEF::assembly::x86::OPCODE::SHL8ri_ND)
  .value("SHL8ri_NF", LIEF::assembly::x86::OPCODE::SHL8ri_NF)
  .value("SHL8ri_NF_ND", LIEF::assembly::x86::OPCODE::SHL8ri_NF_ND)
  .value("SHLD16mrCL", LIEF::assembly::x86::OPCODE::SHLD16mrCL)
  .value("SHLD16mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD16mrCL_EVEX)
  .value("SHLD16mrCL_ND", LIEF::assembly::x86::OPCODE::SHLD16mrCL_ND)
  .value("SHLD16mrCL_NF", LIEF::assembly::x86::OPCODE::SHLD16mrCL_NF)
  .value("SHLD16mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD16mrCL_NF_ND)
  .value("SHLD16mri8", LIEF::assembly::x86::OPCODE::SHLD16mri8)
  .value("SHLD16mri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD16mri8_EVEX)
  .value("SHLD16mri8_ND", LIEF::assembly::x86::OPCODE::SHLD16mri8_ND)
  .value("SHLD16mri8_NF", LIEF::assembly::x86::OPCODE::SHLD16mri8_NF)
  .value("SHLD16mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD16mri8_NF_ND)
  .value("SHLD16rrCL", LIEF::assembly::x86::OPCODE::SHLD16rrCL)
  .value("SHLD16rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD16rrCL_EVEX)
  .value("SHLD16rrCL_ND", LIEF::assembly::x86::OPCODE::SHLD16rrCL_ND)
  .value("SHLD16rrCL_NF", LIEF::assembly::x86::OPCODE::SHLD16rrCL_NF)
  .value("SHLD16rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD16rrCL_NF_ND)
  .value("SHLD16rri8", LIEF::assembly::x86::OPCODE::SHLD16rri8)
  .value("SHLD16rri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD16rri8_EVEX)
  .value("SHLD16rri8_ND", LIEF::assembly::x86::OPCODE::SHLD16rri8_ND)
  .value("SHLD16rri8_NF", LIEF::assembly::x86::OPCODE::SHLD16rri8_NF)
  .value("SHLD16rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD16rri8_NF_ND)
  .value("SHLD32mrCL", LIEF::assembly::x86::OPCODE::SHLD32mrCL)
  .value("SHLD32mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD32mrCL_EVEX)
  .value("SHLD32mrCL_ND", LIEF::assembly::x86::OPCODE::SHLD32mrCL_ND)
  .value("SHLD32mrCL_NF", LIEF::assembly::x86::OPCODE::SHLD32mrCL_NF)
  .value("SHLD32mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD32mrCL_NF_ND)
  .value("SHLD32mri8", LIEF::assembly::x86::OPCODE::SHLD32mri8)
  .value("SHLD32mri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD32mri8_EVEX)
  .value("SHLD32mri8_ND", LIEF::assembly::x86::OPCODE::SHLD32mri8_ND)
  .value("SHLD32mri8_NF", LIEF::assembly::x86::OPCODE::SHLD32mri8_NF)
  .value("SHLD32mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD32mri8_NF_ND)
  .value("SHLD32rrCL", LIEF::assembly::x86::OPCODE::SHLD32rrCL)
  .value("SHLD32rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD32rrCL_EVEX)
  .value("SHLD32rrCL_ND", LIEF::assembly::x86::OPCODE::SHLD32rrCL_ND)
  .value("SHLD32rrCL_NF", LIEF::assembly::x86::OPCODE::SHLD32rrCL_NF)
  .value("SHLD32rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD32rrCL_NF_ND)
  .value("SHLD32rri8", LIEF::assembly::x86::OPCODE::SHLD32rri8)
  .value("SHLD32rri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD32rri8_EVEX)
  .value("SHLD32rri8_ND", LIEF::assembly::x86::OPCODE::SHLD32rri8_ND)
  .value("SHLD32rri8_NF", LIEF::assembly::x86::OPCODE::SHLD32rri8_NF)
  .value("SHLD32rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD32rri8_NF_ND)
  .value("SHLD64mrCL", LIEF::assembly::x86::OPCODE::SHLD64mrCL)
  .value("SHLD64mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD64mrCL_EVEX)
  .value("SHLD64mrCL_ND", LIEF::assembly::x86::OPCODE::SHLD64mrCL_ND)
  .value("SHLD64mrCL_NF", LIEF::assembly::x86::OPCODE::SHLD64mrCL_NF)
  .value("SHLD64mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD64mrCL_NF_ND)
  .value("SHLD64mri8", LIEF::assembly::x86::OPCODE::SHLD64mri8)
  .value("SHLD64mri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD64mri8_EVEX)
  .value("SHLD64mri8_ND", LIEF::assembly::x86::OPCODE::SHLD64mri8_ND)
  .value("SHLD64mri8_NF", LIEF::assembly::x86::OPCODE::SHLD64mri8_NF)
  .value("SHLD64mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD64mri8_NF_ND)
  .value("SHLD64rrCL", LIEF::assembly::x86::OPCODE::SHLD64rrCL)
  .value("SHLD64rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHLD64rrCL_EVEX)
  .value("SHLD64rrCL_ND", LIEF::assembly::x86::OPCODE::SHLD64rrCL_ND)
  .value("SHLD64rrCL_NF", LIEF::assembly::x86::OPCODE::SHLD64rrCL_NF)
  .value("SHLD64rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHLD64rrCL_NF_ND)
  .value("SHLD64rri8", LIEF::assembly::x86::OPCODE::SHLD64rri8)
  .value("SHLD64rri8_EVEX", LIEF::assembly::x86::OPCODE::SHLD64rri8_EVEX)
  .value("SHLD64rri8_ND", LIEF::assembly::x86::OPCODE::SHLD64rri8_ND)
  .value("SHLD64rri8_NF", LIEF::assembly::x86::OPCODE::SHLD64rri8_NF)
  .value("SHLD64rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHLD64rri8_NF_ND)
  .value("SHLX32rm", LIEF::assembly::x86::OPCODE::SHLX32rm)
  .value("SHLX32rm_EVEX", LIEF::assembly::x86::OPCODE::SHLX32rm_EVEX)
  .value("SHLX32rr", LIEF::assembly::x86::OPCODE::SHLX32rr)
  .value("SHLX32rr_EVEX", LIEF::assembly::x86::OPCODE::SHLX32rr_EVEX)
  .value("SHLX64rm", LIEF::assembly::x86::OPCODE::SHLX64rm)
  .value("SHLX64rm_EVEX", LIEF::assembly::x86::OPCODE::SHLX64rm_EVEX)
  .value("SHLX64rr", LIEF::assembly::x86::OPCODE::SHLX64rr)
  .value("SHLX64rr_EVEX", LIEF::assembly::x86::OPCODE::SHLX64rr_EVEX)
  .value("SHR16m1", LIEF::assembly::x86::OPCODE::SHR16m1)
  .value("SHR16m1_EVEX", LIEF::assembly::x86::OPCODE::SHR16m1_EVEX)
  .value("SHR16m1_ND", LIEF::assembly::x86::OPCODE::SHR16m1_ND)
  .value("SHR16m1_NF", LIEF::assembly::x86::OPCODE::SHR16m1_NF)
  .value("SHR16m1_NF_ND", LIEF::assembly::x86::OPCODE::SHR16m1_NF_ND)
  .value("SHR16mCL", LIEF::assembly::x86::OPCODE::SHR16mCL)
  .value("SHR16mCL_EVEX", LIEF::assembly::x86::OPCODE::SHR16mCL_EVEX)
  .value("SHR16mCL_ND", LIEF::assembly::x86::OPCODE::SHR16mCL_ND)
  .value("SHR16mCL_NF", LIEF::assembly::x86::OPCODE::SHR16mCL_NF)
  .value("SHR16mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR16mCL_NF_ND)
  .value("SHR16mi", LIEF::assembly::x86::OPCODE::SHR16mi)
  .value("SHR16mi_EVEX", LIEF::assembly::x86::OPCODE::SHR16mi_EVEX)
  .value("SHR16mi_ND", LIEF::assembly::x86::OPCODE::SHR16mi_ND)
  .value("SHR16mi_NF", LIEF::assembly::x86::OPCODE::SHR16mi_NF)
  .value("SHR16mi_NF_ND", LIEF::assembly::x86::OPCODE::SHR16mi_NF_ND)
  .value("SHR16r1", LIEF::assembly::x86::OPCODE::SHR16r1)
  .value("SHR16r1_EVEX", LIEF::assembly::x86::OPCODE::SHR16r1_EVEX)
  .value("SHR16r1_ND", LIEF::assembly::x86::OPCODE::SHR16r1_ND);
  opcodes.value("SHR16r1_NF", LIEF::assembly::x86::OPCODE::SHR16r1_NF)
  .value("SHR16r1_NF_ND", LIEF::assembly::x86::OPCODE::SHR16r1_NF_ND)
  .value("SHR16rCL", LIEF::assembly::x86::OPCODE::SHR16rCL)
  .value("SHR16rCL_EVEX", LIEF::assembly::x86::OPCODE::SHR16rCL_EVEX)
  .value("SHR16rCL_ND", LIEF::assembly::x86::OPCODE::SHR16rCL_ND)
  .value("SHR16rCL_NF", LIEF::assembly::x86::OPCODE::SHR16rCL_NF)
  .value("SHR16rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR16rCL_NF_ND)
  .value("SHR16ri", LIEF::assembly::x86::OPCODE::SHR16ri)
  .value("SHR16ri_EVEX", LIEF::assembly::x86::OPCODE::SHR16ri_EVEX)
  .value("SHR16ri_ND", LIEF::assembly::x86::OPCODE::SHR16ri_ND)
  .value("SHR16ri_NF", LIEF::assembly::x86::OPCODE::SHR16ri_NF)
  .value("SHR16ri_NF_ND", LIEF::assembly::x86::OPCODE::SHR16ri_NF_ND)
  .value("SHR32m1", LIEF::assembly::x86::OPCODE::SHR32m1)
  .value("SHR32m1_EVEX", LIEF::assembly::x86::OPCODE::SHR32m1_EVEX)
  .value("SHR32m1_ND", LIEF::assembly::x86::OPCODE::SHR32m1_ND)
  .value("SHR32m1_NF", LIEF::assembly::x86::OPCODE::SHR32m1_NF)
  .value("SHR32m1_NF_ND", LIEF::assembly::x86::OPCODE::SHR32m1_NF_ND)
  .value("SHR32mCL", LIEF::assembly::x86::OPCODE::SHR32mCL)
  .value("SHR32mCL_EVEX", LIEF::assembly::x86::OPCODE::SHR32mCL_EVEX)
  .value("SHR32mCL_ND", LIEF::assembly::x86::OPCODE::SHR32mCL_ND)
  .value("SHR32mCL_NF", LIEF::assembly::x86::OPCODE::SHR32mCL_NF)
  .value("SHR32mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR32mCL_NF_ND)
  .value("SHR32mi", LIEF::assembly::x86::OPCODE::SHR32mi)
  .value("SHR32mi_EVEX", LIEF::assembly::x86::OPCODE::SHR32mi_EVEX)
  .value("SHR32mi_ND", LIEF::assembly::x86::OPCODE::SHR32mi_ND)
  .value("SHR32mi_NF", LIEF::assembly::x86::OPCODE::SHR32mi_NF)
  .value("SHR32mi_NF_ND", LIEF::assembly::x86::OPCODE::SHR32mi_NF_ND)
  .value("SHR32r1", LIEF::assembly::x86::OPCODE::SHR32r1)
  .value("SHR32r1_EVEX", LIEF::assembly::x86::OPCODE::SHR32r1_EVEX)
  .value("SHR32r1_ND", LIEF::assembly::x86::OPCODE::SHR32r1_ND)
  .value("SHR32r1_NF", LIEF::assembly::x86::OPCODE::SHR32r1_NF)
  .value("SHR32r1_NF_ND", LIEF::assembly::x86::OPCODE::SHR32r1_NF_ND)
  .value("SHR32rCL", LIEF::assembly::x86::OPCODE::SHR32rCL)
  .value("SHR32rCL_EVEX", LIEF::assembly::x86::OPCODE::SHR32rCL_EVEX)
  .value("SHR32rCL_ND", LIEF::assembly::x86::OPCODE::SHR32rCL_ND)
  .value("SHR32rCL_NF", LIEF::assembly::x86::OPCODE::SHR32rCL_NF)
  .value("SHR32rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR32rCL_NF_ND)
  .value("SHR32ri", LIEF::assembly::x86::OPCODE::SHR32ri)
  .value("SHR32ri_EVEX", LIEF::assembly::x86::OPCODE::SHR32ri_EVEX)
  .value("SHR32ri_ND", LIEF::assembly::x86::OPCODE::SHR32ri_ND)
  .value("SHR32ri_NF", LIEF::assembly::x86::OPCODE::SHR32ri_NF)
  .value("SHR32ri_NF_ND", LIEF::assembly::x86::OPCODE::SHR32ri_NF_ND)
  .value("SHR64m1", LIEF::assembly::x86::OPCODE::SHR64m1)
  .value("SHR64m1_EVEX", LIEF::assembly::x86::OPCODE::SHR64m1_EVEX)
  .value("SHR64m1_ND", LIEF::assembly::x86::OPCODE::SHR64m1_ND)
  .value("SHR64m1_NF", LIEF::assembly::x86::OPCODE::SHR64m1_NF)
  .value("SHR64m1_NF_ND", LIEF::assembly::x86::OPCODE::SHR64m1_NF_ND)
  .value("SHR64mCL", LIEF::assembly::x86::OPCODE::SHR64mCL)
  .value("SHR64mCL_EVEX", LIEF::assembly::x86::OPCODE::SHR64mCL_EVEX)
  .value("SHR64mCL_ND", LIEF::assembly::x86::OPCODE::SHR64mCL_ND)
  .value("SHR64mCL_NF", LIEF::assembly::x86::OPCODE::SHR64mCL_NF)
  .value("SHR64mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR64mCL_NF_ND)
  .value("SHR64mi", LIEF::assembly::x86::OPCODE::SHR64mi)
  .value("SHR64mi_EVEX", LIEF::assembly::x86::OPCODE::SHR64mi_EVEX)
  .value("SHR64mi_ND", LIEF::assembly::x86::OPCODE::SHR64mi_ND)
  .value("SHR64mi_NF", LIEF::assembly::x86::OPCODE::SHR64mi_NF)
  .value("SHR64mi_NF_ND", LIEF::assembly::x86::OPCODE::SHR64mi_NF_ND)
  .value("SHR64r1", LIEF::assembly::x86::OPCODE::SHR64r1)
  .value("SHR64r1_EVEX", LIEF::assembly::x86::OPCODE::SHR64r1_EVEX)
  .value("SHR64r1_ND", LIEF::assembly::x86::OPCODE::SHR64r1_ND)
  .value("SHR64r1_NF", LIEF::assembly::x86::OPCODE::SHR64r1_NF)
  .value("SHR64r1_NF_ND", LIEF::assembly::x86::OPCODE::SHR64r1_NF_ND)
  .value("SHR64rCL", LIEF::assembly::x86::OPCODE::SHR64rCL)
  .value("SHR64rCL_EVEX", LIEF::assembly::x86::OPCODE::SHR64rCL_EVEX)
  .value("SHR64rCL_ND", LIEF::assembly::x86::OPCODE::SHR64rCL_ND)
  .value("SHR64rCL_NF", LIEF::assembly::x86::OPCODE::SHR64rCL_NF)
  .value("SHR64rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR64rCL_NF_ND)
  .value("SHR64ri", LIEF::assembly::x86::OPCODE::SHR64ri)
  .value("SHR64ri_EVEX", LIEF::assembly::x86::OPCODE::SHR64ri_EVEX)
  .value("SHR64ri_ND", LIEF::assembly::x86::OPCODE::SHR64ri_ND)
  .value("SHR64ri_NF", LIEF::assembly::x86::OPCODE::SHR64ri_NF)
  .value("SHR64ri_NF_ND", LIEF::assembly::x86::OPCODE::SHR64ri_NF_ND)
  .value("SHR8m1", LIEF::assembly::x86::OPCODE::SHR8m1)
  .value("SHR8m1_EVEX", LIEF::assembly::x86::OPCODE::SHR8m1_EVEX)
  .value("SHR8m1_ND", LIEF::assembly::x86::OPCODE::SHR8m1_ND)
  .value("SHR8m1_NF", LIEF::assembly::x86::OPCODE::SHR8m1_NF)
  .value("SHR8m1_NF_ND", LIEF::assembly::x86::OPCODE::SHR8m1_NF_ND)
  .value("SHR8mCL", LIEF::assembly::x86::OPCODE::SHR8mCL)
  .value("SHR8mCL_EVEX", LIEF::assembly::x86::OPCODE::SHR8mCL_EVEX)
  .value("SHR8mCL_ND", LIEF::assembly::x86::OPCODE::SHR8mCL_ND)
  .value("SHR8mCL_NF", LIEF::assembly::x86::OPCODE::SHR8mCL_NF)
  .value("SHR8mCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR8mCL_NF_ND)
  .value("SHR8mi", LIEF::assembly::x86::OPCODE::SHR8mi)
  .value("SHR8mi_EVEX", LIEF::assembly::x86::OPCODE::SHR8mi_EVEX)
  .value("SHR8mi_ND", LIEF::assembly::x86::OPCODE::SHR8mi_ND)
  .value("SHR8mi_NF", LIEF::assembly::x86::OPCODE::SHR8mi_NF)
  .value("SHR8mi_NF_ND", LIEF::assembly::x86::OPCODE::SHR8mi_NF_ND)
  .value("SHR8r1", LIEF::assembly::x86::OPCODE::SHR8r1)
  .value("SHR8r1_EVEX", LIEF::assembly::x86::OPCODE::SHR8r1_EVEX)
  .value("SHR8r1_ND", LIEF::assembly::x86::OPCODE::SHR8r1_ND)
  .value("SHR8r1_NF", LIEF::assembly::x86::OPCODE::SHR8r1_NF)
  .value("SHR8r1_NF_ND", LIEF::assembly::x86::OPCODE::SHR8r1_NF_ND)
  .value("SHR8rCL", LIEF::assembly::x86::OPCODE::SHR8rCL)
  .value("SHR8rCL_EVEX", LIEF::assembly::x86::OPCODE::SHR8rCL_EVEX)
  .value("SHR8rCL_ND", LIEF::assembly::x86::OPCODE::SHR8rCL_ND)
  .value("SHR8rCL_NF", LIEF::assembly::x86::OPCODE::SHR8rCL_NF)
  .value("SHR8rCL_NF_ND", LIEF::assembly::x86::OPCODE::SHR8rCL_NF_ND)
  .value("SHR8ri", LIEF::assembly::x86::OPCODE::SHR8ri)
  .value("SHR8ri_EVEX", LIEF::assembly::x86::OPCODE::SHR8ri_EVEX)
  .value("SHR8ri_ND", LIEF::assembly::x86::OPCODE::SHR8ri_ND)
  .value("SHR8ri_NF", LIEF::assembly::x86::OPCODE::SHR8ri_NF)
  .value("SHR8ri_NF_ND", LIEF::assembly::x86::OPCODE::SHR8ri_NF_ND)
  .value("SHRD16mrCL", LIEF::assembly::x86::OPCODE::SHRD16mrCL)
  .value("SHRD16mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD16mrCL_EVEX)
  .value("SHRD16mrCL_ND", LIEF::assembly::x86::OPCODE::SHRD16mrCL_ND)
  .value("SHRD16mrCL_NF", LIEF::assembly::x86::OPCODE::SHRD16mrCL_NF)
  .value("SHRD16mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD16mrCL_NF_ND)
  .value("SHRD16mri8", LIEF::assembly::x86::OPCODE::SHRD16mri8)
  .value("SHRD16mri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD16mri8_EVEX)
  .value("SHRD16mri8_ND", LIEF::assembly::x86::OPCODE::SHRD16mri8_ND)
  .value("SHRD16mri8_NF", LIEF::assembly::x86::OPCODE::SHRD16mri8_NF)
  .value("SHRD16mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD16mri8_NF_ND)
  .value("SHRD16rrCL", LIEF::assembly::x86::OPCODE::SHRD16rrCL)
  .value("SHRD16rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD16rrCL_EVEX)
  .value("SHRD16rrCL_ND", LIEF::assembly::x86::OPCODE::SHRD16rrCL_ND)
  .value("SHRD16rrCL_NF", LIEF::assembly::x86::OPCODE::SHRD16rrCL_NF)
  .value("SHRD16rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD16rrCL_NF_ND)
  .value("SHRD16rri8", LIEF::assembly::x86::OPCODE::SHRD16rri8)
  .value("SHRD16rri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD16rri8_EVEX)
  .value("SHRD16rri8_ND", LIEF::assembly::x86::OPCODE::SHRD16rri8_ND)
  .value("SHRD16rri8_NF", LIEF::assembly::x86::OPCODE::SHRD16rri8_NF)
  .value("SHRD16rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD16rri8_NF_ND)
  .value("SHRD32mrCL", LIEF::assembly::x86::OPCODE::SHRD32mrCL)
  .value("SHRD32mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD32mrCL_EVEX)
  .value("SHRD32mrCL_ND", LIEF::assembly::x86::OPCODE::SHRD32mrCL_ND)
  .value("SHRD32mrCL_NF", LIEF::assembly::x86::OPCODE::SHRD32mrCL_NF)
  .value("SHRD32mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD32mrCL_NF_ND)
  .value("SHRD32mri8", LIEF::assembly::x86::OPCODE::SHRD32mri8)
  .value("SHRD32mri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD32mri8_EVEX)
  .value("SHRD32mri8_ND", LIEF::assembly::x86::OPCODE::SHRD32mri8_ND)
  .value("SHRD32mri8_NF", LIEF::assembly::x86::OPCODE::SHRD32mri8_NF)
  .value("SHRD32mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD32mri8_NF_ND)
  .value("SHRD32rrCL", LIEF::assembly::x86::OPCODE::SHRD32rrCL)
  .value("SHRD32rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD32rrCL_EVEX)
  .value("SHRD32rrCL_ND", LIEF::assembly::x86::OPCODE::SHRD32rrCL_ND)
  .value("SHRD32rrCL_NF", LIEF::assembly::x86::OPCODE::SHRD32rrCL_NF)
  .value("SHRD32rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD32rrCL_NF_ND)
  .value("SHRD32rri8", LIEF::assembly::x86::OPCODE::SHRD32rri8)
  .value("SHRD32rri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD32rri8_EVEX)
  .value("SHRD32rri8_ND", LIEF::assembly::x86::OPCODE::SHRD32rri8_ND)
  .value("SHRD32rri8_NF", LIEF::assembly::x86::OPCODE::SHRD32rri8_NF)
  .value("SHRD32rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD32rri8_NF_ND)
  .value("SHRD64mrCL", LIEF::assembly::x86::OPCODE::SHRD64mrCL)
  .value("SHRD64mrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD64mrCL_EVEX)
  .value("SHRD64mrCL_ND", LIEF::assembly::x86::OPCODE::SHRD64mrCL_ND)
  .value("SHRD64mrCL_NF", LIEF::assembly::x86::OPCODE::SHRD64mrCL_NF)
  .value("SHRD64mrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD64mrCL_NF_ND)
  .value("SHRD64mri8", LIEF::assembly::x86::OPCODE::SHRD64mri8)
  .value("SHRD64mri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD64mri8_EVEX)
  .value("SHRD64mri8_ND", LIEF::assembly::x86::OPCODE::SHRD64mri8_ND)
  .value("SHRD64mri8_NF", LIEF::assembly::x86::OPCODE::SHRD64mri8_NF)
  .value("SHRD64mri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD64mri8_NF_ND)
  .value("SHRD64rrCL", LIEF::assembly::x86::OPCODE::SHRD64rrCL)
  .value("SHRD64rrCL_EVEX", LIEF::assembly::x86::OPCODE::SHRD64rrCL_EVEX)
  .value("SHRD64rrCL_ND", LIEF::assembly::x86::OPCODE::SHRD64rrCL_ND)
  .value("SHRD64rrCL_NF", LIEF::assembly::x86::OPCODE::SHRD64rrCL_NF)
  .value("SHRD64rrCL_NF_ND", LIEF::assembly::x86::OPCODE::SHRD64rrCL_NF_ND)
  .value("SHRD64rri8", LIEF::assembly::x86::OPCODE::SHRD64rri8)
  .value("SHRD64rri8_EVEX", LIEF::assembly::x86::OPCODE::SHRD64rri8_EVEX)
  .value("SHRD64rri8_ND", LIEF::assembly::x86::OPCODE::SHRD64rri8_ND)
  .value("SHRD64rri8_NF", LIEF::assembly::x86::OPCODE::SHRD64rri8_NF)
  .value("SHRD64rri8_NF_ND", LIEF::assembly::x86::OPCODE::SHRD64rri8_NF_ND)
  .value("SHRX32rm", LIEF::assembly::x86::OPCODE::SHRX32rm)
  .value("SHRX32rm_EVEX", LIEF::assembly::x86::OPCODE::SHRX32rm_EVEX)
  .value("SHRX32rr", LIEF::assembly::x86::OPCODE::SHRX32rr)
  .value("SHRX32rr_EVEX", LIEF::assembly::x86::OPCODE::SHRX32rr_EVEX)
  .value("SHRX64rm", LIEF::assembly::x86::OPCODE::SHRX64rm)
  .value("SHRX64rm_EVEX", LIEF::assembly::x86::OPCODE::SHRX64rm_EVEX)
  .value("SHRX64rr", LIEF::assembly::x86::OPCODE::SHRX64rr)
  .value("SHRX64rr_EVEX", LIEF::assembly::x86::OPCODE::SHRX64rr_EVEX)
  .value("SHUFPDrmi", LIEF::assembly::x86::OPCODE::SHUFPDrmi)
  .value("SHUFPDrri", LIEF::assembly::x86::OPCODE::SHUFPDrri)
  .value("SHUFPSrmi", LIEF::assembly::x86::OPCODE::SHUFPSrmi)
  .value("SHUFPSrri", LIEF::assembly::x86::OPCODE::SHUFPSrri)
  .value("SIDT16m", LIEF::assembly::x86::OPCODE::SIDT16m)
  .value("SIDT32m", LIEF::assembly::x86::OPCODE::SIDT32m)
  .value("SIDT64m", LIEF::assembly::x86::OPCODE::SIDT64m)
  .value("SKINIT", LIEF::assembly::x86::OPCODE::SKINIT)
  .value("SLDT16m", LIEF::assembly::x86::OPCODE::SLDT16m)
  .value("SLDT16r", LIEF::assembly::x86::OPCODE::SLDT16r)
  .value("SLDT32r", LIEF::assembly::x86::OPCODE::SLDT32r)
  .value("SLDT64r", LIEF::assembly::x86::OPCODE::SLDT64r)
  .value("SLWPCB", LIEF::assembly::x86::OPCODE::SLWPCB)
  .value("SLWPCB64", LIEF::assembly::x86::OPCODE::SLWPCB64)
  .value("SMSW16m", LIEF::assembly::x86::OPCODE::SMSW16m)
  .value("SMSW16r", LIEF::assembly::x86::OPCODE::SMSW16r)
  .value("SMSW32r", LIEF::assembly::x86::OPCODE::SMSW32r)
  .value("SMSW64r", LIEF::assembly::x86::OPCODE::SMSW64r)
  .value("SQRTPDm", LIEF::assembly::x86::OPCODE::SQRTPDm)
  .value("SQRTPDr", LIEF::assembly::x86::OPCODE::SQRTPDr)
  .value("SQRTPSm", LIEF::assembly::x86::OPCODE::SQRTPSm)
  .value("SQRTPSr", LIEF::assembly::x86::OPCODE::SQRTPSr)
  .value("SQRTSDm", LIEF::assembly::x86::OPCODE::SQRTSDm)
  .value("SQRTSDm_Int", LIEF::assembly::x86::OPCODE::SQRTSDm_Int)
  .value("SQRTSDr", LIEF::assembly::x86::OPCODE::SQRTSDr)
  .value("SQRTSDr_Int", LIEF::assembly::x86::OPCODE::SQRTSDr_Int)
  .value("SQRTSSm", LIEF::assembly::x86::OPCODE::SQRTSSm)
  .value("SQRTSSm_Int", LIEF::assembly::x86::OPCODE::SQRTSSm_Int)
  .value("SQRTSSr", LIEF::assembly::x86::OPCODE::SQRTSSr)
  .value("SQRTSSr_Int", LIEF::assembly::x86::OPCODE::SQRTSSr_Int)
  .value("SQRT_F", LIEF::assembly::x86::OPCODE::SQRT_F)
  .value("SQRT_Fp32", LIEF::assembly::x86::OPCODE::SQRT_Fp32)
  .value("SQRT_Fp64", LIEF::assembly::x86::OPCODE::SQRT_Fp64)
  .value("SQRT_Fp80", LIEF::assembly::x86::OPCODE::SQRT_Fp80)
  .value("SS_PREFIX", LIEF::assembly::x86::OPCODE::SS_PREFIX)
  .value("STAC", LIEF::assembly::x86::OPCODE::STAC)
  .value("STACKALLOC_W_PROBING", LIEF::assembly::x86::OPCODE::STACKALLOC_W_PROBING)
  .value("STC", LIEF::assembly::x86::OPCODE::STC)
  .value("STD", LIEF::assembly::x86::OPCODE::STD)
  .value("STGI", LIEF::assembly::x86::OPCODE::STGI)
  .value("STI", LIEF::assembly::x86::OPCODE::STI)
  .value("STMXCSR", LIEF::assembly::x86::OPCODE::STMXCSR)
  .value("STOSB", LIEF::assembly::x86::OPCODE::STOSB)
  .value("STOSL", LIEF::assembly::x86::OPCODE::STOSL)
  .value("STOSQ", LIEF::assembly::x86::OPCODE::STOSQ)
  .value("STOSW", LIEF::assembly::x86::OPCODE::STOSW)
  .value("STR16r", LIEF::assembly::x86::OPCODE::STR16r)
  .value("STR32r", LIEF::assembly::x86::OPCODE::STR32r)
  .value("STR64r", LIEF::assembly::x86::OPCODE::STR64r)
  .value("STRm", LIEF::assembly::x86::OPCODE::STRm)
  .value("STTILECFG", LIEF::assembly::x86::OPCODE::STTILECFG)
  .value("STTILECFG_EVEX", LIEF::assembly::x86::OPCODE::STTILECFG_EVEX)
  .value("STUI", LIEF::assembly::x86::OPCODE::STUI)
  .value("ST_F32m", LIEF::assembly::x86::OPCODE::ST_F32m)
  .value("ST_F64m", LIEF::assembly::x86::OPCODE::ST_F64m)
  .value("ST_FP32m", LIEF::assembly::x86::OPCODE::ST_FP32m)
  .value("ST_FP64m", LIEF::assembly::x86::OPCODE::ST_FP64m)
  .value("ST_FP80m", LIEF::assembly::x86::OPCODE::ST_FP80m)
  .value("ST_FPrr", LIEF::assembly::x86::OPCODE::ST_FPrr)
  .value("ST_Fp32m", LIEF::assembly::x86::OPCODE::ST_Fp32m)
  .value("ST_Fp64m", LIEF::assembly::x86::OPCODE::ST_Fp64m)
  .value("ST_Fp64m32", LIEF::assembly::x86::OPCODE::ST_Fp64m32)
  .value("ST_Fp80m32", LIEF::assembly::x86::OPCODE::ST_Fp80m32)
  .value("ST_Fp80m64", LIEF::assembly::x86::OPCODE::ST_Fp80m64)
  .value("ST_FpP32m", LIEF::assembly::x86::OPCODE::ST_FpP32m)
  .value("ST_FpP64m", LIEF::assembly::x86::OPCODE::ST_FpP64m)
  .value("ST_FpP64m32", LIEF::assembly::x86::OPCODE::ST_FpP64m32)
  .value("ST_FpP80m", LIEF::assembly::x86::OPCODE::ST_FpP80m)
  .value("ST_FpP80m32", LIEF::assembly::x86::OPCODE::ST_FpP80m32)
  .value("ST_FpP80m64", LIEF::assembly::x86::OPCODE::ST_FpP80m64)
  .value("ST_Frr", LIEF::assembly::x86::OPCODE::ST_Frr)
  .value("SUB16i16", LIEF::assembly::x86::OPCODE::SUB16i16)
  .value("SUB16mi", LIEF::assembly::x86::OPCODE::SUB16mi)
  .value("SUB16mi8", LIEF::assembly::x86::OPCODE::SUB16mi8)
  .value("SUB16mi8_EVEX", LIEF::assembly::x86::OPCODE::SUB16mi8_EVEX)
  .value("SUB16mi8_ND", LIEF::assembly::x86::OPCODE::SUB16mi8_ND)
  .value("SUB16mi8_NF", LIEF::assembly::x86::OPCODE::SUB16mi8_NF)
  .value("SUB16mi8_NF_ND", LIEF::assembly::x86::OPCODE::SUB16mi8_NF_ND)
  .value("SUB16mi_EVEX", LIEF::assembly::x86::OPCODE::SUB16mi_EVEX)
  .value("SUB16mi_ND", LIEF::assembly::x86::OPCODE::SUB16mi_ND)
  .value("SUB16mi_NF", LIEF::assembly::x86::OPCODE::SUB16mi_NF)
  .value("SUB16mi_NF_ND", LIEF::assembly::x86::OPCODE::SUB16mi_NF_ND)
  .value("SUB16mr", LIEF::assembly::x86::OPCODE::SUB16mr)
  .value("SUB16mr_EVEX", LIEF::assembly::x86::OPCODE::SUB16mr_EVEX)
  .value("SUB16mr_ND", LIEF::assembly::x86::OPCODE::SUB16mr_ND)
  .value("SUB16mr_NF", LIEF::assembly::x86::OPCODE::SUB16mr_NF)
  .value("SUB16mr_NF_ND", LIEF::assembly::x86::OPCODE::SUB16mr_NF_ND)
  .value("SUB16ri", LIEF::assembly::x86::OPCODE::SUB16ri)
  .value("SUB16ri8", LIEF::assembly::x86::OPCODE::SUB16ri8)
  .value("SUB16ri8_EVEX", LIEF::assembly::x86::OPCODE::SUB16ri8_EVEX)
  .value("SUB16ri8_ND", LIEF::assembly::x86::OPCODE::SUB16ri8_ND)
  .value("SUB16ri8_NF", LIEF::assembly::x86::OPCODE::SUB16ri8_NF)
  .value("SUB16ri8_NF_ND", LIEF::assembly::x86::OPCODE::SUB16ri8_NF_ND)
  .value("SUB16ri_EVEX", LIEF::assembly::x86::OPCODE::SUB16ri_EVEX)
  .value("SUB16ri_ND", LIEF::assembly::x86::OPCODE::SUB16ri_ND)
  .value("SUB16ri_NF", LIEF::assembly::x86::OPCODE::SUB16ri_NF)
  .value("SUB16ri_NF_ND", LIEF::assembly::x86::OPCODE::SUB16ri_NF_ND)
  .value("SUB16rm", LIEF::assembly::x86::OPCODE::SUB16rm)
  .value("SUB16rm_EVEX", LIEF::assembly::x86::OPCODE::SUB16rm_EVEX)
  .value("SUB16rm_ND", LIEF::assembly::x86::OPCODE::SUB16rm_ND)
  .value("SUB16rm_NF", LIEF::assembly::x86::OPCODE::SUB16rm_NF)
  .value("SUB16rm_NF_ND", LIEF::assembly::x86::OPCODE::SUB16rm_NF_ND)
  .value("SUB16rr", LIEF::assembly::x86::OPCODE::SUB16rr)
  .value("SUB16rr_EVEX", LIEF::assembly::x86::OPCODE::SUB16rr_EVEX)
  .value("SUB16rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SUB16rr_EVEX_REV)
  .value("SUB16rr_ND", LIEF::assembly::x86::OPCODE::SUB16rr_ND)
  .value("SUB16rr_ND_REV", LIEF::assembly::x86::OPCODE::SUB16rr_ND_REV)
  .value("SUB16rr_NF", LIEF::assembly::x86::OPCODE::SUB16rr_NF)
  .value("SUB16rr_NF_ND", LIEF::assembly::x86::OPCODE::SUB16rr_NF_ND)
  .value("SUB16rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::SUB16rr_NF_ND_REV)
  .value("SUB16rr_NF_REV", LIEF::assembly::x86::OPCODE::SUB16rr_NF_REV)
  .value("SUB16rr_REV", LIEF::assembly::x86::OPCODE::SUB16rr_REV)
  .value("SUB32i32", LIEF::assembly::x86::OPCODE::SUB32i32)
  .value("SUB32mi", LIEF::assembly::x86::OPCODE::SUB32mi)
  .value("SUB32mi8", LIEF::assembly::x86::OPCODE::SUB32mi8)
  .value("SUB32mi8_EVEX", LIEF::assembly::x86::OPCODE::SUB32mi8_EVEX)
  .value("SUB32mi8_ND", LIEF::assembly::x86::OPCODE::SUB32mi8_ND)
  .value("SUB32mi8_NF", LIEF::assembly::x86::OPCODE::SUB32mi8_NF)
  .value("SUB32mi8_NF_ND", LIEF::assembly::x86::OPCODE::SUB32mi8_NF_ND)
  .value("SUB32mi_EVEX", LIEF::assembly::x86::OPCODE::SUB32mi_EVEX)
  .value("SUB32mi_ND", LIEF::assembly::x86::OPCODE::SUB32mi_ND)
  .value("SUB32mi_NF", LIEF::assembly::x86::OPCODE::SUB32mi_NF)
  .value("SUB32mi_NF_ND", LIEF::assembly::x86::OPCODE::SUB32mi_NF_ND)
  .value("SUB32mr", LIEF::assembly::x86::OPCODE::SUB32mr)
  .value("SUB32mr_EVEX", LIEF::assembly::x86::OPCODE::SUB32mr_EVEX)
  .value("SUB32mr_ND", LIEF::assembly::x86::OPCODE::SUB32mr_ND)
  .value("SUB32mr_NF", LIEF::assembly::x86::OPCODE::SUB32mr_NF)
  .value("SUB32mr_NF_ND", LIEF::assembly::x86::OPCODE::SUB32mr_NF_ND)
  .value("SUB32ri", LIEF::assembly::x86::OPCODE::SUB32ri)
  .value("SUB32ri8", LIEF::assembly::x86::OPCODE::SUB32ri8);
  opcodes.value("SUB32ri8_EVEX", LIEF::assembly::x86::OPCODE::SUB32ri8_EVEX)
  .value("SUB32ri8_ND", LIEF::assembly::x86::OPCODE::SUB32ri8_ND)
  .value("SUB32ri8_NF", LIEF::assembly::x86::OPCODE::SUB32ri8_NF)
  .value("SUB32ri8_NF_ND", LIEF::assembly::x86::OPCODE::SUB32ri8_NF_ND)
  .value("SUB32ri_EVEX", LIEF::assembly::x86::OPCODE::SUB32ri_EVEX)
  .value("SUB32ri_ND", LIEF::assembly::x86::OPCODE::SUB32ri_ND)
  .value("SUB32ri_NF", LIEF::assembly::x86::OPCODE::SUB32ri_NF)
  .value("SUB32ri_NF_ND", LIEF::assembly::x86::OPCODE::SUB32ri_NF_ND)
  .value("SUB32rm", LIEF::assembly::x86::OPCODE::SUB32rm)
  .value("SUB32rm_EVEX", LIEF::assembly::x86::OPCODE::SUB32rm_EVEX)
  .value("SUB32rm_ND", LIEF::assembly::x86::OPCODE::SUB32rm_ND)
  .value("SUB32rm_NF", LIEF::assembly::x86::OPCODE::SUB32rm_NF)
  .value("SUB32rm_NF_ND", LIEF::assembly::x86::OPCODE::SUB32rm_NF_ND)
  .value("SUB32rr", LIEF::assembly::x86::OPCODE::SUB32rr)
  .value("SUB32rr_EVEX", LIEF::assembly::x86::OPCODE::SUB32rr_EVEX)
  .value("SUB32rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SUB32rr_EVEX_REV)
  .value("SUB32rr_ND", LIEF::assembly::x86::OPCODE::SUB32rr_ND)
  .value("SUB32rr_ND_REV", LIEF::assembly::x86::OPCODE::SUB32rr_ND_REV)
  .value("SUB32rr_NF", LIEF::assembly::x86::OPCODE::SUB32rr_NF)
  .value("SUB32rr_NF_ND", LIEF::assembly::x86::OPCODE::SUB32rr_NF_ND)
  .value("SUB32rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::SUB32rr_NF_ND_REV)
  .value("SUB32rr_NF_REV", LIEF::assembly::x86::OPCODE::SUB32rr_NF_REV)
  .value("SUB32rr_REV", LIEF::assembly::x86::OPCODE::SUB32rr_REV)
  .value("SUB64i32", LIEF::assembly::x86::OPCODE::SUB64i32)
  .value("SUB64mi32", LIEF::assembly::x86::OPCODE::SUB64mi32)
  .value("SUB64mi32_EVEX", LIEF::assembly::x86::OPCODE::SUB64mi32_EVEX)
  .value("SUB64mi32_ND", LIEF::assembly::x86::OPCODE::SUB64mi32_ND)
  .value("SUB64mi32_NF", LIEF::assembly::x86::OPCODE::SUB64mi32_NF)
  .value("SUB64mi32_NF_ND", LIEF::assembly::x86::OPCODE::SUB64mi32_NF_ND)
  .value("SUB64mi8", LIEF::assembly::x86::OPCODE::SUB64mi8)
  .value("SUB64mi8_EVEX", LIEF::assembly::x86::OPCODE::SUB64mi8_EVEX)
  .value("SUB64mi8_ND", LIEF::assembly::x86::OPCODE::SUB64mi8_ND)
  .value("SUB64mi8_NF", LIEF::assembly::x86::OPCODE::SUB64mi8_NF)
  .value("SUB64mi8_NF_ND", LIEF::assembly::x86::OPCODE::SUB64mi8_NF_ND)
  .value("SUB64mr", LIEF::assembly::x86::OPCODE::SUB64mr)
  .value("SUB64mr_EVEX", LIEF::assembly::x86::OPCODE::SUB64mr_EVEX)
  .value("SUB64mr_ND", LIEF::assembly::x86::OPCODE::SUB64mr_ND)
  .value("SUB64mr_NF", LIEF::assembly::x86::OPCODE::SUB64mr_NF)
  .value("SUB64mr_NF_ND", LIEF::assembly::x86::OPCODE::SUB64mr_NF_ND)
  .value("SUB64ri32", LIEF::assembly::x86::OPCODE::SUB64ri32)
  .value("SUB64ri32_EVEX", LIEF::assembly::x86::OPCODE::SUB64ri32_EVEX)
  .value("SUB64ri32_ND", LIEF::assembly::x86::OPCODE::SUB64ri32_ND)
  .value("SUB64ri32_NF", LIEF::assembly::x86::OPCODE::SUB64ri32_NF)
  .value("SUB64ri32_NF_ND", LIEF::assembly::x86::OPCODE::SUB64ri32_NF_ND)
  .value("SUB64ri8", LIEF::assembly::x86::OPCODE::SUB64ri8)
  .value("SUB64ri8_EVEX", LIEF::assembly::x86::OPCODE::SUB64ri8_EVEX)
  .value("SUB64ri8_ND", LIEF::assembly::x86::OPCODE::SUB64ri8_ND)
  .value("SUB64ri8_NF", LIEF::assembly::x86::OPCODE::SUB64ri8_NF)
  .value("SUB64ri8_NF_ND", LIEF::assembly::x86::OPCODE::SUB64ri8_NF_ND)
  .value("SUB64rm", LIEF::assembly::x86::OPCODE::SUB64rm)
  .value("SUB64rm_EVEX", LIEF::assembly::x86::OPCODE::SUB64rm_EVEX)
  .value("SUB64rm_ND", LIEF::assembly::x86::OPCODE::SUB64rm_ND)
  .value("SUB64rm_NF", LIEF::assembly::x86::OPCODE::SUB64rm_NF)
  .value("SUB64rm_NF_ND", LIEF::assembly::x86::OPCODE::SUB64rm_NF_ND)
  .value("SUB64rr", LIEF::assembly::x86::OPCODE::SUB64rr)
  .value("SUB64rr_EVEX", LIEF::assembly::x86::OPCODE::SUB64rr_EVEX)
  .value("SUB64rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SUB64rr_EVEX_REV)
  .value("SUB64rr_ND", LIEF::assembly::x86::OPCODE::SUB64rr_ND)
  .value("SUB64rr_ND_REV", LIEF::assembly::x86::OPCODE::SUB64rr_ND_REV)
  .value("SUB64rr_NF", LIEF::assembly::x86::OPCODE::SUB64rr_NF)
  .value("SUB64rr_NF_ND", LIEF::assembly::x86::OPCODE::SUB64rr_NF_ND)
  .value("SUB64rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::SUB64rr_NF_ND_REV)
  .value("SUB64rr_NF_REV", LIEF::assembly::x86::OPCODE::SUB64rr_NF_REV)
  .value("SUB64rr_REV", LIEF::assembly::x86::OPCODE::SUB64rr_REV)
  .value("SUB8i8", LIEF::assembly::x86::OPCODE::SUB8i8)
  .value("SUB8mi", LIEF::assembly::x86::OPCODE::SUB8mi)
  .value("SUB8mi8", LIEF::assembly::x86::OPCODE::SUB8mi8)
  .value("SUB8mi_EVEX", LIEF::assembly::x86::OPCODE::SUB8mi_EVEX)
  .value("SUB8mi_ND", LIEF::assembly::x86::OPCODE::SUB8mi_ND)
  .value("SUB8mi_NF", LIEF::assembly::x86::OPCODE::SUB8mi_NF)
  .value("SUB8mi_NF_ND", LIEF::assembly::x86::OPCODE::SUB8mi_NF_ND)
  .value("SUB8mr", LIEF::assembly::x86::OPCODE::SUB8mr)
  .value("SUB8mr_EVEX", LIEF::assembly::x86::OPCODE::SUB8mr_EVEX)
  .value("SUB8mr_ND", LIEF::assembly::x86::OPCODE::SUB8mr_ND)
  .value("SUB8mr_NF", LIEF::assembly::x86::OPCODE::SUB8mr_NF)
  .value("SUB8mr_NF_ND", LIEF::assembly::x86::OPCODE::SUB8mr_NF_ND)
  .value("SUB8ri", LIEF::assembly::x86::OPCODE::SUB8ri)
  .value("SUB8ri8", LIEF::assembly::x86::OPCODE::SUB8ri8)
  .value("SUB8ri_EVEX", LIEF::assembly::x86::OPCODE::SUB8ri_EVEX)
  .value("SUB8ri_ND", LIEF::assembly::x86::OPCODE::SUB8ri_ND)
  .value("SUB8ri_NF", LIEF::assembly::x86::OPCODE::SUB8ri_NF)
  .value("SUB8ri_NF_ND", LIEF::assembly::x86::OPCODE::SUB8ri_NF_ND)
  .value("SUB8rm", LIEF::assembly::x86::OPCODE::SUB8rm)
  .value("SUB8rm_EVEX", LIEF::assembly::x86::OPCODE::SUB8rm_EVEX)
  .value("SUB8rm_ND", LIEF::assembly::x86::OPCODE::SUB8rm_ND)
  .value("SUB8rm_NF", LIEF::assembly::x86::OPCODE::SUB8rm_NF)
  .value("SUB8rm_NF_ND", LIEF::assembly::x86::OPCODE::SUB8rm_NF_ND)
  .value("SUB8rr", LIEF::assembly::x86::OPCODE::SUB8rr)
  .value("SUB8rr_EVEX", LIEF::assembly::x86::OPCODE::SUB8rr_EVEX)
  .value("SUB8rr_EVEX_REV", LIEF::assembly::x86::OPCODE::SUB8rr_EVEX_REV)
  .value("SUB8rr_ND", LIEF::assembly::x86::OPCODE::SUB8rr_ND)
  .value("SUB8rr_ND_REV", LIEF::assembly::x86::OPCODE::SUB8rr_ND_REV)
  .value("SUB8rr_NF", LIEF::assembly::x86::OPCODE::SUB8rr_NF)
  .value("SUB8rr_NF_ND", LIEF::assembly::x86::OPCODE::SUB8rr_NF_ND)
  .value("SUB8rr_NF_ND_REV", LIEF::assembly::x86::OPCODE::SUB8rr_NF_ND_REV)
  .value("SUB8rr_NF_REV", LIEF::assembly::x86::OPCODE::SUB8rr_NF_REV)
  .value("SUB8rr_REV", LIEF::assembly::x86::OPCODE::SUB8rr_REV)
  .value("SUBPDrm", LIEF::assembly::x86::OPCODE::SUBPDrm)
  .value("SUBPDrr", LIEF::assembly::x86::OPCODE::SUBPDrr)
  .value("SUBPSrm", LIEF::assembly::x86::OPCODE::SUBPSrm)
  .value("SUBPSrr", LIEF::assembly::x86::OPCODE::SUBPSrr)
  .value("SUBR_F32m", LIEF::assembly::x86::OPCODE::SUBR_F32m)
  .value("SUBR_F64m", LIEF::assembly::x86::OPCODE::SUBR_F64m)
  .value("SUBR_FI16m", LIEF::assembly::x86::OPCODE::SUBR_FI16m)
  .value("SUBR_FI32m", LIEF::assembly::x86::OPCODE::SUBR_FI32m)
  .value("SUBR_FPrST0", LIEF::assembly::x86::OPCODE::SUBR_FPrST0)
  .value("SUBR_FST0r", LIEF::assembly::x86::OPCODE::SUBR_FST0r)
  .value("SUBR_Fp32m", LIEF::assembly::x86::OPCODE::SUBR_Fp32m)
  .value("SUBR_Fp64m", LIEF::assembly::x86::OPCODE::SUBR_Fp64m)
  .value("SUBR_Fp64m32", LIEF::assembly::x86::OPCODE::SUBR_Fp64m32)
  .value("SUBR_Fp80m32", LIEF::assembly::x86::OPCODE::SUBR_Fp80m32)
  .value("SUBR_Fp80m64", LIEF::assembly::x86::OPCODE::SUBR_Fp80m64)
  .value("SUBR_FpI16m32", LIEF::assembly::x86::OPCODE::SUBR_FpI16m32)
  .value("SUBR_FpI16m64", LIEF::assembly::x86::OPCODE::SUBR_FpI16m64)
  .value("SUBR_FpI16m80", LIEF::assembly::x86::OPCODE::SUBR_FpI16m80)
  .value("SUBR_FpI32m32", LIEF::assembly::x86::OPCODE::SUBR_FpI32m32)
  .value("SUBR_FpI32m64", LIEF::assembly::x86::OPCODE::SUBR_FpI32m64)
  .value("SUBR_FpI32m80", LIEF::assembly::x86::OPCODE::SUBR_FpI32m80)
  .value("SUBR_FrST0", LIEF::assembly::x86::OPCODE::SUBR_FrST0)
  .value("SUBSDrm", LIEF::assembly::x86::OPCODE::SUBSDrm)
  .value("SUBSDrm_Int", LIEF::assembly::x86::OPCODE::SUBSDrm_Int)
  .value("SUBSDrr", LIEF::assembly::x86::OPCODE::SUBSDrr)
  .value("SUBSDrr_Int", LIEF::assembly::x86::OPCODE::SUBSDrr_Int)
  .value("SUBSSrm", LIEF::assembly::x86::OPCODE::SUBSSrm)
  .value("SUBSSrm_Int", LIEF::assembly::x86::OPCODE::SUBSSrm_Int)
  .value("SUBSSrr", LIEF::assembly::x86::OPCODE::SUBSSrr)
  .value("SUBSSrr_Int", LIEF::assembly::x86::OPCODE::SUBSSrr_Int)
  .value("SUB_F32m", LIEF::assembly::x86::OPCODE::SUB_F32m)
  .value("SUB_F64m", LIEF::assembly::x86::OPCODE::SUB_F64m)
  .value("SUB_FI16m", LIEF::assembly::x86::OPCODE::SUB_FI16m)
  .value("SUB_FI32m", LIEF::assembly::x86::OPCODE::SUB_FI32m)
  .value("SUB_FPrST0", LIEF::assembly::x86::OPCODE::SUB_FPrST0)
  .value("SUB_FST0r", LIEF::assembly::x86::OPCODE::SUB_FST0r)
  .value("SUB_Fp32", LIEF::assembly::x86::OPCODE::SUB_Fp32)
  .value("SUB_Fp32m", LIEF::assembly::x86::OPCODE::SUB_Fp32m)
  .value("SUB_Fp64", LIEF::assembly::x86::OPCODE::SUB_Fp64)
  .value("SUB_Fp64m", LIEF::assembly::x86::OPCODE::SUB_Fp64m)
  .value("SUB_Fp64m32", LIEF::assembly::x86::OPCODE::SUB_Fp64m32)
  .value("SUB_Fp80", LIEF::assembly::x86::OPCODE::SUB_Fp80)
  .value("SUB_Fp80m32", LIEF::assembly::x86::OPCODE::SUB_Fp80m32)
  .value("SUB_Fp80m64", LIEF::assembly::x86::OPCODE::SUB_Fp80m64)
  .value("SUB_FpI16m32", LIEF::assembly::x86::OPCODE::SUB_FpI16m32)
  .value("SUB_FpI16m64", LIEF::assembly::x86::OPCODE::SUB_FpI16m64)
  .value("SUB_FpI16m80", LIEF::assembly::x86::OPCODE::SUB_FpI16m80)
  .value("SUB_FpI32m32", LIEF::assembly::x86::OPCODE::SUB_FpI32m32)
  .value("SUB_FpI32m64", LIEF::assembly::x86::OPCODE::SUB_FpI32m64)
  .value("SUB_FpI32m80", LIEF::assembly::x86::OPCODE::SUB_FpI32m80)
  .value("SUB_FrST0", LIEF::assembly::x86::OPCODE::SUB_FrST0)
  .value("SWAPGS", LIEF::assembly::x86::OPCODE::SWAPGS)
  .value("SYSCALL", LIEF::assembly::x86::OPCODE::SYSCALL)
  .value("SYSENTER", LIEF::assembly::x86::OPCODE::SYSENTER)
  .value("SYSEXIT", LIEF::assembly::x86::OPCODE::SYSEXIT)
  .value("SYSEXIT64", LIEF::assembly::x86::OPCODE::SYSEXIT64)
  .value("SYSRET", LIEF::assembly::x86::OPCODE::SYSRET)
  .value("SYSRET64", LIEF::assembly::x86::OPCODE::SYSRET64)
  .value("T1MSKC32rm", LIEF::assembly::x86::OPCODE::T1MSKC32rm)
  .value("T1MSKC32rr", LIEF::assembly::x86::OPCODE::T1MSKC32rr)
  .value("T1MSKC64rm", LIEF::assembly::x86::OPCODE::T1MSKC64rm)
  .value("T1MSKC64rr", LIEF::assembly::x86::OPCODE::T1MSKC64rr)
  .value("T2RPNTLVWZ0", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0)
  .value("T2RPNTLVWZ0RS", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0RS)
  .value("T2RPNTLVWZ0RST1", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0RST1)
  .value("T2RPNTLVWZ0RST1_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0RST1_EVEX)
  .value("T2RPNTLVWZ0RS_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0RS_EVEX)
  .value("T2RPNTLVWZ0T1", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0T1)
  .value("T2RPNTLVWZ0T1_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0T1_EVEX)
  .value("T2RPNTLVWZ0_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ0_EVEX)
  .value("T2RPNTLVWZ1", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1)
  .value("T2RPNTLVWZ1RS", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1RS)
  .value("T2RPNTLVWZ1RST1", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1RST1)
  .value("T2RPNTLVWZ1RST1_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1RST1_EVEX)
  .value("T2RPNTLVWZ1RS_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1RS_EVEX)
  .value("T2RPNTLVWZ1T1", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1T1)
  .value("T2RPNTLVWZ1T1_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1T1_EVEX)
  .value("T2RPNTLVWZ1_EVEX", LIEF::assembly::x86::OPCODE::T2RPNTLVWZ1_EVEX)
  .value("TAILJMPd", LIEF::assembly::x86::OPCODE::TAILJMPd)
  .value("TAILJMPd64", LIEF::assembly::x86::OPCODE::TAILJMPd64)
  .value("TAILJMPd64_CC", LIEF::assembly::x86::OPCODE::TAILJMPd64_CC)
  .value("TAILJMPd_CC", LIEF::assembly::x86::OPCODE::TAILJMPd_CC)
  .value("TAILJMPm", LIEF::assembly::x86::OPCODE::TAILJMPm)
  .value("TAILJMPm64", LIEF::assembly::x86::OPCODE::TAILJMPm64)
  .value("TAILJMPm64_REX", LIEF::assembly::x86::OPCODE::TAILJMPm64_REX)
  .value("TAILJMPr", LIEF::assembly::x86::OPCODE::TAILJMPr)
  .value("TAILJMPr64", LIEF::assembly::x86::OPCODE::TAILJMPr64)
  .value("TAILJMPr64_REX", LIEF::assembly::x86::OPCODE::TAILJMPr64_REX)
  .value("TCMMIMFP16PS", LIEF::assembly::x86::OPCODE::TCMMIMFP16PS)
  .value("TCMMRLFP16PS", LIEF::assembly::x86::OPCODE::TCMMRLFP16PS)
  .value("TCONJTCMMIMFP16PS", LIEF::assembly::x86::OPCODE::TCONJTCMMIMFP16PS)
  .value("TCONJTFP16", LIEF::assembly::x86::OPCODE::TCONJTFP16)
  .value("TCRETURNdi", LIEF::assembly::x86::OPCODE::TCRETURNdi)
  .value("TCRETURNdi64", LIEF::assembly::x86::OPCODE::TCRETURNdi64)
  .value("TCRETURNdi64cc", LIEF::assembly::x86::OPCODE::TCRETURNdi64cc)
  .value("TCRETURNdicc", LIEF::assembly::x86::OPCODE::TCRETURNdicc)
  .value("TCRETURNmi", LIEF::assembly::x86::OPCODE::TCRETURNmi)
  .value("TCRETURNmi64", LIEF::assembly::x86::OPCODE::TCRETURNmi64)
  .value("TCRETURNri", LIEF::assembly::x86::OPCODE::TCRETURNri)
  .value("TCRETURNri64", LIEF::assembly::x86::OPCODE::TCRETURNri64)
  .value("TCRETURNri64_ImpCall", LIEF::assembly::x86::OPCODE::TCRETURNri64_ImpCall)
  .value("TCVTROWD2PSrre", LIEF::assembly::x86::OPCODE::TCVTROWD2PSrre)
  .value("TCVTROWD2PSrri", LIEF::assembly::x86::OPCODE::TCVTROWD2PSrri)
  .value("TCVTROWPS2BF16Hrre", LIEF::assembly::x86::OPCODE::TCVTROWPS2BF16Hrre)
  .value("TCVTROWPS2BF16Hrri", LIEF::assembly::x86::OPCODE::TCVTROWPS2BF16Hrri)
  .value("TCVTROWPS2BF16Lrre", LIEF::assembly::x86::OPCODE::TCVTROWPS2BF16Lrre)
  .value("TCVTROWPS2BF16Lrri", LIEF::assembly::x86::OPCODE::TCVTROWPS2BF16Lrri)
  .value("TCVTROWPS2PHHrre", LIEF::assembly::x86::OPCODE::TCVTROWPS2PHHrre)
  .value("TCVTROWPS2PHHrri", LIEF::assembly::x86::OPCODE::TCVTROWPS2PHHrri)
  .value("TCVTROWPS2PHLrre", LIEF::assembly::x86::OPCODE::TCVTROWPS2PHLrre)
  .value("TCVTROWPS2PHLrri", LIEF::assembly::x86::OPCODE::TCVTROWPS2PHLrri)
  .value("TDCALL", LIEF::assembly::x86::OPCODE::TDCALL)
  .value("TDPBF16PS", LIEF::assembly::x86::OPCODE::TDPBF16PS)
  .value("TDPBF8PS", LIEF::assembly::x86::OPCODE::TDPBF8PS)
  .value("TDPBHF8PS", LIEF::assembly::x86::OPCODE::TDPBHF8PS)
  .value("TDPBSSD", LIEF::assembly::x86::OPCODE::TDPBSSD)
  .value("TDPBSUD", LIEF::assembly::x86::OPCODE::TDPBSUD)
  .value("TDPBUSD", LIEF::assembly::x86::OPCODE::TDPBUSD)
  .value("TDPBUUD", LIEF::assembly::x86::OPCODE::TDPBUUD)
  .value("TDPFP16PS", LIEF::assembly::x86::OPCODE::TDPFP16PS)
  .value("TDPHBF8PS", LIEF::assembly::x86::OPCODE::TDPHBF8PS)
  .value("TDPHF8PS", LIEF::assembly::x86::OPCODE::TDPHF8PS)
  .value("TEST16i16", LIEF::assembly::x86::OPCODE::TEST16i16)
  .value("TEST16mi", LIEF::assembly::x86::OPCODE::TEST16mi)
  .value("TEST16mr", LIEF::assembly::x86::OPCODE::TEST16mr)
  .value("TEST16ri", LIEF::assembly::x86::OPCODE::TEST16ri)
  .value("TEST16rr", LIEF::assembly::x86::OPCODE::TEST16rr)
  .value("TEST32i32", LIEF::assembly::x86::OPCODE::TEST32i32)
  .value("TEST32mi", LIEF::assembly::x86::OPCODE::TEST32mi)
  .value("TEST32mr", LIEF::assembly::x86::OPCODE::TEST32mr)
  .value("TEST32ri", LIEF::assembly::x86::OPCODE::TEST32ri)
  .value("TEST32rr", LIEF::assembly::x86::OPCODE::TEST32rr)
  .value("TEST64i32", LIEF::assembly::x86::OPCODE::TEST64i32)
  .value("TEST64mi32", LIEF::assembly::x86::OPCODE::TEST64mi32)
  .value("TEST64mr", LIEF::assembly::x86::OPCODE::TEST64mr)
  .value("TEST64ri32", LIEF::assembly::x86::OPCODE::TEST64ri32)
  .value("TEST64rr", LIEF::assembly::x86::OPCODE::TEST64rr)
  .value("TEST8i8", LIEF::assembly::x86::OPCODE::TEST8i8)
  .value("TEST8mi", LIEF::assembly::x86::OPCODE::TEST8mi)
  .value("TEST8mr", LIEF::assembly::x86::OPCODE::TEST8mr)
  .value("TEST8ri", LIEF::assembly::x86::OPCODE::TEST8ri)
  .value("TEST8rr", LIEF::assembly::x86::OPCODE::TEST8rr)
  .value("TESTUI", LIEF::assembly::x86::OPCODE::TESTUI)
  .value("TILELOADD", LIEF::assembly::x86::OPCODE::TILELOADD)
  .value("TILELOADDRS", LIEF::assembly::x86::OPCODE::TILELOADDRS)
  .value("TILELOADDRST1", LIEF::assembly::x86::OPCODE::TILELOADDRST1)
  .value("TILELOADDRST1_EVEX", LIEF::assembly::x86::OPCODE::TILELOADDRST1_EVEX)
  .value("TILELOADDRS_EVEX", LIEF::assembly::x86::OPCODE::TILELOADDRS_EVEX)
  .value("TILELOADDT1", LIEF::assembly::x86::OPCODE::TILELOADDT1)
  .value("TILELOADDT1_EVEX", LIEF::assembly::x86::OPCODE::TILELOADDT1_EVEX)
  .value("TILELOADD_EVEX", LIEF::assembly::x86::OPCODE::TILELOADD_EVEX)
  .value("TILEMOVROWrre", LIEF::assembly::x86::OPCODE::TILEMOVROWrre)
  .value("TILEMOVROWrri", LIEF::assembly::x86::OPCODE::TILEMOVROWrri)
  .value("TILERELEASE", LIEF::assembly::x86::OPCODE::TILERELEASE)
  .value("TILESTORED", LIEF::assembly::x86::OPCODE::TILESTORED)
  .value("TILESTORED_EVEX", LIEF::assembly::x86::OPCODE::TILESTORED_EVEX)
  .value("TILEZERO", LIEF::assembly::x86::OPCODE::TILEZERO)
  .value("TLBSYNC", LIEF::assembly::x86::OPCODE::TLBSYNC)
  .value("TLSCall_32", LIEF::assembly::x86::OPCODE::TLSCall_32)
  .value("TLSCall_64", LIEF::assembly::x86::OPCODE::TLSCall_64)
  .value("TLS_addr32", LIEF::assembly::x86::OPCODE::TLS_addr32)
  .value("TLS_addr64", LIEF::assembly::x86::OPCODE::TLS_addr64)
  .value("TLS_addrX32", LIEF::assembly::x86::OPCODE::TLS_addrX32)
  .value("TLS_base_addr32", LIEF::assembly::x86::OPCODE::TLS_base_addr32)
  .value("TLS_base_addr64", LIEF::assembly::x86::OPCODE::TLS_base_addr64)
  .value("TLS_base_addrX32", LIEF::assembly::x86::OPCODE::TLS_base_addrX32)
  .value("TLS_desc32", LIEF::assembly::x86::OPCODE::TLS_desc32)
  .value("TLS_desc64", LIEF::assembly::x86::OPCODE::TLS_desc64)
  .value("TMMULTF32PS", LIEF::assembly::x86::OPCODE::TMMULTF32PS)
  .value("TPAUSE", LIEF::assembly::x86::OPCODE::TPAUSE)
  .value("TRAP", LIEF::assembly::x86::OPCODE::TRAP)
  .value("TST_F", LIEF::assembly::x86::OPCODE::TST_F)
  .value("TST_Fp32", LIEF::assembly::x86::OPCODE::TST_Fp32)
  .value("TST_Fp64", LIEF::assembly::x86::OPCODE::TST_Fp64)
  .value("TST_Fp80", LIEF::assembly::x86::OPCODE::TST_Fp80)
  .value("TTCMMIMFP16PS", LIEF::assembly::x86::OPCODE::TTCMMIMFP16PS)
  .value("TTCMMRLFP16PS", LIEF::assembly::x86::OPCODE::TTCMMRLFP16PS)
  .value("TTDPBF16PS", LIEF::assembly::x86::OPCODE::TTDPBF16PS)
  .value("TTDPFP16PS", LIEF::assembly::x86::OPCODE::TTDPFP16PS)
  .value("TTMMULTF32PS", LIEF::assembly::x86::OPCODE::TTMMULTF32PS)
  .value("TTRANSPOSED", LIEF::assembly::x86::OPCODE::TTRANSPOSED)
  .value("TZCNT16rm", LIEF::assembly::x86::OPCODE::TZCNT16rm)
  .value("TZCNT16rm_EVEX", LIEF::assembly::x86::OPCODE::TZCNT16rm_EVEX)
  .value("TZCNT16rm_NF", LIEF::assembly::x86::OPCODE::TZCNT16rm_NF)
  .value("TZCNT16rr", LIEF::assembly::x86::OPCODE::TZCNT16rr)
  .value("TZCNT16rr_EVEX", LIEF::assembly::x86::OPCODE::TZCNT16rr_EVEX)
  .value("TZCNT16rr_NF", LIEF::assembly::x86::OPCODE::TZCNT16rr_NF)
  .value("TZCNT32rm", LIEF::assembly::x86::OPCODE::TZCNT32rm)
  .value("TZCNT32rm_EVEX", LIEF::assembly::x86::OPCODE::TZCNT32rm_EVEX)
  .value("TZCNT32rm_NF", LIEF::assembly::x86::OPCODE::TZCNT32rm_NF)
  .value("TZCNT32rr", LIEF::assembly::x86::OPCODE::TZCNT32rr)
  .value("TZCNT32rr_EVEX", LIEF::assembly::x86::OPCODE::TZCNT32rr_EVEX)
  .value("TZCNT32rr_NF", LIEF::assembly::x86::OPCODE::TZCNT32rr_NF)
  .value("TZCNT64rm", LIEF::assembly::x86::OPCODE::TZCNT64rm)
  .value("TZCNT64rm_EVEX", LIEF::assembly::x86::OPCODE::TZCNT64rm_EVEX)
  .value("TZCNT64rm_NF", LIEF::assembly::x86::OPCODE::TZCNT64rm_NF)
  .value("TZCNT64rr", LIEF::assembly::x86::OPCODE::TZCNT64rr)
  .value("TZCNT64rr_EVEX", LIEF::assembly::x86::OPCODE::TZCNT64rr_EVEX)
  .value("TZCNT64rr_NF", LIEF::assembly::x86::OPCODE::TZCNT64rr_NF)
  .value("TZMSK32rm", LIEF::assembly::x86::OPCODE::TZMSK32rm)
  .value("TZMSK32rr", LIEF::assembly::x86::OPCODE::TZMSK32rr)
  .value("TZMSK64rm", LIEF::assembly::x86::OPCODE::TZMSK64rm)
  .value("TZMSK64rr", LIEF::assembly::x86::OPCODE::TZMSK64rr);
  opcodes.value("UBSAN_UD1", LIEF::assembly::x86::OPCODE::UBSAN_UD1)
  .value("UCOMISDrm", LIEF::assembly::x86::OPCODE::UCOMISDrm)
  .value("UCOMISDrm_Int", LIEF::assembly::x86::OPCODE::UCOMISDrm_Int)
  .value("UCOMISDrr", LIEF::assembly::x86::OPCODE::UCOMISDrr)
  .value("UCOMISDrr_Int", LIEF::assembly::x86::OPCODE::UCOMISDrr_Int)
  .value("UCOMISSrm", LIEF::assembly::x86::OPCODE::UCOMISSrm)
  .value("UCOMISSrm_Int", LIEF::assembly::x86::OPCODE::UCOMISSrm_Int)
  .value("UCOMISSrr", LIEF::assembly::x86::OPCODE::UCOMISSrr)
  .value("UCOMISSrr_Int", LIEF::assembly::x86::OPCODE::UCOMISSrr_Int)
  .value("UCOM_FIPr", LIEF::assembly::x86::OPCODE::UCOM_FIPr)
  .value("UCOM_FIr", LIEF::assembly::x86::OPCODE::UCOM_FIr)
  .value("UCOM_FPPr", LIEF::assembly::x86::OPCODE::UCOM_FPPr)
  .value("UCOM_FPr", LIEF::assembly::x86::OPCODE::UCOM_FPr)
  .value("UCOM_FpIr32", LIEF::assembly::x86::OPCODE::UCOM_FpIr32)
  .value("UCOM_FpIr64", LIEF::assembly::x86::OPCODE::UCOM_FpIr64)
  .value("UCOM_FpIr80", LIEF::assembly::x86::OPCODE::UCOM_FpIr80)
  .value("UCOM_Fpr32", LIEF::assembly::x86::OPCODE::UCOM_Fpr32)
  .value("UCOM_Fpr64", LIEF::assembly::x86::OPCODE::UCOM_Fpr64)
  .value("UCOM_Fpr80", LIEF::assembly::x86::OPCODE::UCOM_Fpr80)
  .value("UCOM_Fr", LIEF::assembly::x86::OPCODE::UCOM_Fr)
  .value("UD1Lm", LIEF::assembly::x86::OPCODE::UD1Lm)
  .value("UD1Lr", LIEF::assembly::x86::OPCODE::UD1Lr)
  .value("UD1Qm", LIEF::assembly::x86::OPCODE::UD1Qm)
  .value("UD1Qr", LIEF::assembly::x86::OPCODE::UD1Qr)
  .value("UD1Wm", LIEF::assembly::x86::OPCODE::UD1Wm)
  .value("UD1Wr", LIEF::assembly::x86::OPCODE::UD1Wr)
  .value("UIRET", LIEF::assembly::x86::OPCODE::UIRET)
  .value("UMONITOR16", LIEF::assembly::x86::OPCODE::UMONITOR16)
  .value("UMONITOR32", LIEF::assembly::x86::OPCODE::UMONITOR32)
  .value("UMONITOR64", LIEF::assembly::x86::OPCODE::UMONITOR64)
  .value("UMWAIT", LIEF::assembly::x86::OPCODE::UMWAIT)
  .value("UNPCKHPDrm", LIEF::assembly::x86::OPCODE::UNPCKHPDrm)
  .value("UNPCKHPDrr", LIEF::assembly::x86::OPCODE::UNPCKHPDrr)
  .value("UNPCKHPSrm", LIEF::assembly::x86::OPCODE::UNPCKHPSrm)
  .value("UNPCKHPSrr", LIEF::assembly::x86::OPCODE::UNPCKHPSrr)
  .value("UNPCKLPDrm", LIEF::assembly::x86::OPCODE::UNPCKLPDrm)
  .value("UNPCKLPDrr", LIEF::assembly::x86::OPCODE::UNPCKLPDrr)
  .value("UNPCKLPSrm", LIEF::assembly::x86::OPCODE::UNPCKLPSrm)
  .value("UNPCKLPSrr", LIEF::assembly::x86::OPCODE::UNPCKLPSrr)
  .value("URDMSRri", LIEF::assembly::x86::OPCODE::URDMSRri)
  .value("URDMSRri_EVEX", LIEF::assembly::x86::OPCODE::URDMSRri_EVEX)
  .value("URDMSRrr", LIEF::assembly::x86::OPCODE::URDMSRrr)
  .value("URDMSRrr_EVEX", LIEF::assembly::x86::OPCODE::URDMSRrr_EVEX)
  .value("UWRMSRir", LIEF::assembly::x86::OPCODE::UWRMSRir)
  .value("UWRMSRir_EVEX", LIEF::assembly::x86::OPCODE::UWRMSRir_EVEX)
  .value("UWRMSRrr", LIEF::assembly::x86::OPCODE::UWRMSRrr)
  .value("UWRMSRrr_EVEX", LIEF::assembly::x86::OPCODE::UWRMSRrr_EVEX)
  .value("V4FMADDPSrm", LIEF::assembly::x86::OPCODE::V4FMADDPSrm)
  .value("V4FMADDPSrmk", LIEF::assembly::x86::OPCODE::V4FMADDPSrmk)
  .value("V4FMADDPSrmkz", LIEF::assembly::x86::OPCODE::V4FMADDPSrmkz)
  .value("V4FMADDSSrm", LIEF::assembly::x86::OPCODE::V4FMADDSSrm)
  .value("V4FMADDSSrmk", LIEF::assembly::x86::OPCODE::V4FMADDSSrmk)
  .value("V4FMADDSSrmkz", LIEF::assembly::x86::OPCODE::V4FMADDSSrmkz)
  .value("V4FNMADDPSrm", LIEF::assembly::x86::OPCODE::V4FNMADDPSrm)
  .value("V4FNMADDPSrmk", LIEF::assembly::x86::OPCODE::V4FNMADDPSrmk)
  .value("V4FNMADDPSrmkz", LIEF::assembly::x86::OPCODE::V4FNMADDPSrmkz)
  .value("V4FNMADDSSrm", LIEF::assembly::x86::OPCODE::V4FNMADDSSrm)
  .value("V4FNMADDSSrmk", LIEF::assembly::x86::OPCODE::V4FNMADDSSrmk)
  .value("V4FNMADDSSrmkz", LIEF::assembly::x86::OPCODE::V4FNMADDSSrmkz)
  .value("VAARG_64", LIEF::assembly::x86::OPCODE::VAARG_64)
  .value("VAARG_X32", LIEF::assembly::x86::OPCODE::VAARG_X32)
  .value("VADDBF16Z128rm", LIEF::assembly::x86::OPCODE::VADDBF16Z128rm)
  .value("VADDBF16Z128rmb", LIEF::assembly::x86::OPCODE::VADDBF16Z128rmb)
  .value("VADDBF16Z128rmbk", LIEF::assembly::x86::OPCODE::VADDBF16Z128rmbk)
  .value("VADDBF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VADDBF16Z128rmbkz)
  .value("VADDBF16Z128rmk", LIEF::assembly::x86::OPCODE::VADDBF16Z128rmk)
  .value("VADDBF16Z128rmkz", LIEF::assembly::x86::OPCODE::VADDBF16Z128rmkz)
  .value("VADDBF16Z128rr", LIEF::assembly::x86::OPCODE::VADDBF16Z128rr)
  .value("VADDBF16Z128rrk", LIEF::assembly::x86::OPCODE::VADDBF16Z128rrk)
  .value("VADDBF16Z128rrkz", LIEF::assembly::x86::OPCODE::VADDBF16Z128rrkz)
  .value("VADDBF16Z256rm", LIEF::assembly::x86::OPCODE::VADDBF16Z256rm)
  .value("VADDBF16Z256rmb", LIEF::assembly::x86::OPCODE::VADDBF16Z256rmb)
  .value("VADDBF16Z256rmbk", LIEF::assembly::x86::OPCODE::VADDBF16Z256rmbk)
  .value("VADDBF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VADDBF16Z256rmbkz)
  .value("VADDBF16Z256rmk", LIEF::assembly::x86::OPCODE::VADDBF16Z256rmk)
  .value("VADDBF16Z256rmkz", LIEF::assembly::x86::OPCODE::VADDBF16Z256rmkz)
  .value("VADDBF16Z256rr", LIEF::assembly::x86::OPCODE::VADDBF16Z256rr)
  .value("VADDBF16Z256rrk", LIEF::assembly::x86::OPCODE::VADDBF16Z256rrk)
  .value("VADDBF16Z256rrkz", LIEF::assembly::x86::OPCODE::VADDBF16Z256rrkz)
  .value("VADDBF16Zrm", LIEF::assembly::x86::OPCODE::VADDBF16Zrm)
  .value("VADDBF16Zrmb", LIEF::assembly::x86::OPCODE::VADDBF16Zrmb)
  .value("VADDBF16Zrmbk", LIEF::assembly::x86::OPCODE::VADDBF16Zrmbk)
  .value("VADDBF16Zrmbkz", LIEF::assembly::x86::OPCODE::VADDBF16Zrmbkz)
  .value("VADDBF16Zrmk", LIEF::assembly::x86::OPCODE::VADDBF16Zrmk)
  .value("VADDBF16Zrmkz", LIEF::assembly::x86::OPCODE::VADDBF16Zrmkz)
  .value("VADDBF16Zrr", LIEF::assembly::x86::OPCODE::VADDBF16Zrr)
  .value("VADDBF16Zrrk", LIEF::assembly::x86::OPCODE::VADDBF16Zrrk)
  .value("VADDBF16Zrrkz", LIEF::assembly::x86::OPCODE::VADDBF16Zrrkz)
  .value("VADDPDYrm", LIEF::assembly::x86::OPCODE::VADDPDYrm)
  .value("VADDPDYrr", LIEF::assembly::x86::OPCODE::VADDPDYrr)
  .value("VADDPDZ128rm", LIEF::assembly::x86::OPCODE::VADDPDZ128rm)
  .value("VADDPDZ128rmb", LIEF::assembly::x86::OPCODE::VADDPDZ128rmb)
  .value("VADDPDZ128rmbk", LIEF::assembly::x86::OPCODE::VADDPDZ128rmbk)
  .value("VADDPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VADDPDZ128rmbkz)
  .value("VADDPDZ128rmk", LIEF::assembly::x86::OPCODE::VADDPDZ128rmk)
  .value("VADDPDZ128rmkz", LIEF::assembly::x86::OPCODE::VADDPDZ128rmkz)
  .value("VADDPDZ128rr", LIEF::assembly::x86::OPCODE::VADDPDZ128rr)
  .value("VADDPDZ128rrk", LIEF::assembly::x86::OPCODE::VADDPDZ128rrk)
  .value("VADDPDZ128rrkz", LIEF::assembly::x86::OPCODE::VADDPDZ128rrkz)
  .value("VADDPDZ256rm", LIEF::assembly::x86::OPCODE::VADDPDZ256rm)
  .value("VADDPDZ256rmb", LIEF::assembly::x86::OPCODE::VADDPDZ256rmb)
  .value("VADDPDZ256rmbk", LIEF::assembly::x86::OPCODE::VADDPDZ256rmbk)
  .value("VADDPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VADDPDZ256rmbkz)
  .value("VADDPDZ256rmk", LIEF::assembly::x86::OPCODE::VADDPDZ256rmk)
  .value("VADDPDZ256rmkz", LIEF::assembly::x86::OPCODE::VADDPDZ256rmkz)
  .value("VADDPDZ256rr", LIEF::assembly::x86::OPCODE::VADDPDZ256rr)
  .value("VADDPDZ256rrk", LIEF::assembly::x86::OPCODE::VADDPDZ256rrk)
  .value("VADDPDZ256rrkz", LIEF::assembly::x86::OPCODE::VADDPDZ256rrkz)
  .value("VADDPDZrm", LIEF::assembly::x86::OPCODE::VADDPDZrm)
  .value("VADDPDZrmb", LIEF::assembly::x86::OPCODE::VADDPDZrmb)
  .value("VADDPDZrmbk", LIEF::assembly::x86::OPCODE::VADDPDZrmbk)
  .value("VADDPDZrmbkz", LIEF::assembly::x86::OPCODE::VADDPDZrmbkz)
  .value("VADDPDZrmk", LIEF::assembly::x86::OPCODE::VADDPDZrmk)
  .value("VADDPDZrmkz", LIEF::assembly::x86::OPCODE::VADDPDZrmkz)
  .value("VADDPDZrr", LIEF::assembly::x86::OPCODE::VADDPDZrr)
  .value("VADDPDZrrb", LIEF::assembly::x86::OPCODE::VADDPDZrrb)
  .value("VADDPDZrrbk", LIEF::assembly::x86::OPCODE::VADDPDZrrbk)
  .value("VADDPDZrrbkz", LIEF::assembly::x86::OPCODE::VADDPDZrrbkz)
  .value("VADDPDZrrk", LIEF::assembly::x86::OPCODE::VADDPDZrrk)
  .value("VADDPDZrrkz", LIEF::assembly::x86::OPCODE::VADDPDZrrkz)
  .value("VADDPDrm", LIEF::assembly::x86::OPCODE::VADDPDrm)
  .value("VADDPDrr", LIEF::assembly::x86::OPCODE::VADDPDrr)
  .value("VADDPHZ128rm", LIEF::assembly::x86::OPCODE::VADDPHZ128rm)
  .value("VADDPHZ128rmb", LIEF::assembly::x86::OPCODE::VADDPHZ128rmb)
  .value("VADDPHZ128rmbk", LIEF::assembly::x86::OPCODE::VADDPHZ128rmbk)
  .value("VADDPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VADDPHZ128rmbkz)
  .value("VADDPHZ128rmk", LIEF::assembly::x86::OPCODE::VADDPHZ128rmk)
  .value("VADDPHZ128rmkz", LIEF::assembly::x86::OPCODE::VADDPHZ128rmkz)
  .value("VADDPHZ128rr", LIEF::assembly::x86::OPCODE::VADDPHZ128rr)
  .value("VADDPHZ128rrk", LIEF::assembly::x86::OPCODE::VADDPHZ128rrk)
  .value("VADDPHZ128rrkz", LIEF::assembly::x86::OPCODE::VADDPHZ128rrkz)
  .value("VADDPHZ256rm", LIEF::assembly::x86::OPCODE::VADDPHZ256rm)
  .value("VADDPHZ256rmb", LIEF::assembly::x86::OPCODE::VADDPHZ256rmb)
  .value("VADDPHZ256rmbk", LIEF::assembly::x86::OPCODE::VADDPHZ256rmbk)
  .value("VADDPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VADDPHZ256rmbkz)
  .value("VADDPHZ256rmk", LIEF::assembly::x86::OPCODE::VADDPHZ256rmk)
  .value("VADDPHZ256rmkz", LIEF::assembly::x86::OPCODE::VADDPHZ256rmkz)
  .value("VADDPHZ256rr", LIEF::assembly::x86::OPCODE::VADDPHZ256rr)
  .value("VADDPHZ256rrk", LIEF::assembly::x86::OPCODE::VADDPHZ256rrk)
  .value("VADDPHZ256rrkz", LIEF::assembly::x86::OPCODE::VADDPHZ256rrkz)
  .value("VADDPHZrm", LIEF::assembly::x86::OPCODE::VADDPHZrm)
  .value("VADDPHZrmb", LIEF::assembly::x86::OPCODE::VADDPHZrmb)
  .value("VADDPHZrmbk", LIEF::assembly::x86::OPCODE::VADDPHZrmbk)
  .value("VADDPHZrmbkz", LIEF::assembly::x86::OPCODE::VADDPHZrmbkz)
  .value("VADDPHZrmk", LIEF::assembly::x86::OPCODE::VADDPHZrmk)
  .value("VADDPHZrmkz", LIEF::assembly::x86::OPCODE::VADDPHZrmkz)
  .value("VADDPHZrr", LIEF::assembly::x86::OPCODE::VADDPHZrr)
  .value("VADDPHZrrb", LIEF::assembly::x86::OPCODE::VADDPHZrrb)
  .value("VADDPHZrrbk", LIEF::assembly::x86::OPCODE::VADDPHZrrbk)
  .value("VADDPHZrrbkz", LIEF::assembly::x86::OPCODE::VADDPHZrrbkz)
  .value("VADDPHZrrk", LIEF::assembly::x86::OPCODE::VADDPHZrrk)
  .value("VADDPHZrrkz", LIEF::assembly::x86::OPCODE::VADDPHZrrkz)
  .value("VADDPSYrm", LIEF::assembly::x86::OPCODE::VADDPSYrm)
  .value("VADDPSYrr", LIEF::assembly::x86::OPCODE::VADDPSYrr)
  .value("VADDPSZ128rm", LIEF::assembly::x86::OPCODE::VADDPSZ128rm)
  .value("VADDPSZ128rmb", LIEF::assembly::x86::OPCODE::VADDPSZ128rmb)
  .value("VADDPSZ128rmbk", LIEF::assembly::x86::OPCODE::VADDPSZ128rmbk)
  .value("VADDPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VADDPSZ128rmbkz)
  .value("VADDPSZ128rmk", LIEF::assembly::x86::OPCODE::VADDPSZ128rmk)
  .value("VADDPSZ128rmkz", LIEF::assembly::x86::OPCODE::VADDPSZ128rmkz)
  .value("VADDPSZ128rr", LIEF::assembly::x86::OPCODE::VADDPSZ128rr)
  .value("VADDPSZ128rrk", LIEF::assembly::x86::OPCODE::VADDPSZ128rrk)
  .value("VADDPSZ128rrkz", LIEF::assembly::x86::OPCODE::VADDPSZ128rrkz)
  .value("VADDPSZ256rm", LIEF::assembly::x86::OPCODE::VADDPSZ256rm)
  .value("VADDPSZ256rmb", LIEF::assembly::x86::OPCODE::VADDPSZ256rmb)
  .value("VADDPSZ256rmbk", LIEF::assembly::x86::OPCODE::VADDPSZ256rmbk)
  .value("VADDPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VADDPSZ256rmbkz)
  .value("VADDPSZ256rmk", LIEF::assembly::x86::OPCODE::VADDPSZ256rmk)
  .value("VADDPSZ256rmkz", LIEF::assembly::x86::OPCODE::VADDPSZ256rmkz)
  .value("VADDPSZ256rr", LIEF::assembly::x86::OPCODE::VADDPSZ256rr)
  .value("VADDPSZ256rrk", LIEF::assembly::x86::OPCODE::VADDPSZ256rrk)
  .value("VADDPSZ256rrkz", LIEF::assembly::x86::OPCODE::VADDPSZ256rrkz)
  .value("VADDPSZrm", LIEF::assembly::x86::OPCODE::VADDPSZrm)
  .value("VADDPSZrmb", LIEF::assembly::x86::OPCODE::VADDPSZrmb)
  .value("VADDPSZrmbk", LIEF::assembly::x86::OPCODE::VADDPSZrmbk)
  .value("VADDPSZrmbkz", LIEF::assembly::x86::OPCODE::VADDPSZrmbkz)
  .value("VADDPSZrmk", LIEF::assembly::x86::OPCODE::VADDPSZrmk)
  .value("VADDPSZrmkz", LIEF::assembly::x86::OPCODE::VADDPSZrmkz)
  .value("VADDPSZrr", LIEF::assembly::x86::OPCODE::VADDPSZrr)
  .value("VADDPSZrrb", LIEF::assembly::x86::OPCODE::VADDPSZrrb)
  .value("VADDPSZrrbk", LIEF::assembly::x86::OPCODE::VADDPSZrrbk)
  .value("VADDPSZrrbkz", LIEF::assembly::x86::OPCODE::VADDPSZrrbkz)
  .value("VADDPSZrrk", LIEF::assembly::x86::OPCODE::VADDPSZrrk)
  .value("VADDPSZrrkz", LIEF::assembly::x86::OPCODE::VADDPSZrrkz)
  .value("VADDPSrm", LIEF::assembly::x86::OPCODE::VADDPSrm)
  .value("VADDPSrr", LIEF::assembly::x86::OPCODE::VADDPSrr)
  .value("VADDSDZrm", LIEF::assembly::x86::OPCODE::VADDSDZrm)
  .value("VADDSDZrm_Int", LIEF::assembly::x86::OPCODE::VADDSDZrm_Int)
  .value("VADDSDZrmk_Int", LIEF::assembly::x86::OPCODE::VADDSDZrmk_Int)
  .value("VADDSDZrmkz_Int", LIEF::assembly::x86::OPCODE::VADDSDZrmkz_Int)
  .value("VADDSDZrr", LIEF::assembly::x86::OPCODE::VADDSDZrr)
  .value("VADDSDZrr_Int", LIEF::assembly::x86::OPCODE::VADDSDZrr_Int)
  .value("VADDSDZrrb_Int", LIEF::assembly::x86::OPCODE::VADDSDZrrb_Int)
  .value("VADDSDZrrbk_Int", LIEF::assembly::x86::OPCODE::VADDSDZrrbk_Int)
  .value("VADDSDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VADDSDZrrbkz_Int)
  .value("VADDSDZrrk_Int", LIEF::assembly::x86::OPCODE::VADDSDZrrk_Int)
  .value("VADDSDZrrkz_Int", LIEF::assembly::x86::OPCODE::VADDSDZrrkz_Int)
  .value("VADDSDrm", LIEF::assembly::x86::OPCODE::VADDSDrm)
  .value("VADDSDrm_Int", LIEF::assembly::x86::OPCODE::VADDSDrm_Int)
  .value("VADDSDrr", LIEF::assembly::x86::OPCODE::VADDSDrr)
  .value("VADDSDrr_Int", LIEF::assembly::x86::OPCODE::VADDSDrr_Int)
  .value("VADDSHZrm", LIEF::assembly::x86::OPCODE::VADDSHZrm)
  .value("VADDSHZrm_Int", LIEF::assembly::x86::OPCODE::VADDSHZrm_Int)
  .value("VADDSHZrmk_Int", LIEF::assembly::x86::OPCODE::VADDSHZrmk_Int)
  .value("VADDSHZrmkz_Int", LIEF::assembly::x86::OPCODE::VADDSHZrmkz_Int)
  .value("VADDSHZrr", LIEF::assembly::x86::OPCODE::VADDSHZrr)
  .value("VADDSHZrr_Int", LIEF::assembly::x86::OPCODE::VADDSHZrr_Int)
  .value("VADDSHZrrb_Int", LIEF::assembly::x86::OPCODE::VADDSHZrrb_Int)
  .value("VADDSHZrrbk_Int", LIEF::assembly::x86::OPCODE::VADDSHZrrbk_Int)
  .value("VADDSHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VADDSHZrrbkz_Int)
  .value("VADDSHZrrk_Int", LIEF::assembly::x86::OPCODE::VADDSHZrrk_Int)
  .value("VADDSHZrrkz_Int", LIEF::assembly::x86::OPCODE::VADDSHZrrkz_Int)
  .value("VADDSSZrm", LIEF::assembly::x86::OPCODE::VADDSSZrm)
  .value("VADDSSZrm_Int", LIEF::assembly::x86::OPCODE::VADDSSZrm_Int)
  .value("VADDSSZrmk_Int", LIEF::assembly::x86::OPCODE::VADDSSZrmk_Int)
  .value("VADDSSZrmkz_Int", LIEF::assembly::x86::OPCODE::VADDSSZrmkz_Int)
  .value("VADDSSZrr", LIEF::assembly::x86::OPCODE::VADDSSZrr)
  .value("VADDSSZrr_Int", LIEF::assembly::x86::OPCODE::VADDSSZrr_Int)
  .value("VADDSSZrrb_Int", LIEF::assembly::x86::OPCODE::VADDSSZrrb_Int)
  .value("VADDSSZrrbk_Int", LIEF::assembly::x86::OPCODE::VADDSSZrrbk_Int)
  .value("VADDSSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VADDSSZrrbkz_Int)
  .value("VADDSSZrrk_Int", LIEF::assembly::x86::OPCODE::VADDSSZrrk_Int)
  .value("VADDSSZrrkz_Int", LIEF::assembly::x86::OPCODE::VADDSSZrrkz_Int)
  .value("VADDSSrm", LIEF::assembly::x86::OPCODE::VADDSSrm)
  .value("VADDSSrm_Int", LIEF::assembly::x86::OPCODE::VADDSSrm_Int)
  .value("VADDSSrr", LIEF::assembly::x86::OPCODE::VADDSSrr)
  .value("VADDSSrr_Int", LIEF::assembly::x86::OPCODE::VADDSSrr_Int)
  .value("VADDSUBPDYrm", LIEF::assembly::x86::OPCODE::VADDSUBPDYrm)
  .value("VADDSUBPDYrr", LIEF::assembly::x86::OPCODE::VADDSUBPDYrr)
  .value("VADDSUBPDrm", LIEF::assembly::x86::OPCODE::VADDSUBPDrm)
  .value("VADDSUBPDrr", LIEF::assembly::x86::OPCODE::VADDSUBPDrr)
  .value("VADDSUBPSYrm", LIEF::assembly::x86::OPCODE::VADDSUBPSYrm)
  .value("VADDSUBPSYrr", LIEF::assembly::x86::OPCODE::VADDSUBPSYrr)
  .value("VADDSUBPSrm", LIEF::assembly::x86::OPCODE::VADDSUBPSrm)
  .value("VADDSUBPSrr", LIEF::assembly::x86::OPCODE::VADDSUBPSrr)
  .value("VAESDECLASTYrm", LIEF::assembly::x86::OPCODE::VAESDECLASTYrm)
  .value("VAESDECLASTYrr", LIEF::assembly::x86::OPCODE::VAESDECLASTYrr)
  .value("VAESDECLASTZ128rm", LIEF::assembly::x86::OPCODE::VAESDECLASTZ128rm)
  .value("VAESDECLASTZ128rr", LIEF::assembly::x86::OPCODE::VAESDECLASTZ128rr)
  .value("VAESDECLASTZ256rm", LIEF::assembly::x86::OPCODE::VAESDECLASTZ256rm)
  .value("VAESDECLASTZ256rr", LIEF::assembly::x86::OPCODE::VAESDECLASTZ256rr)
  .value("VAESDECLASTZrm", LIEF::assembly::x86::OPCODE::VAESDECLASTZrm)
  .value("VAESDECLASTZrr", LIEF::assembly::x86::OPCODE::VAESDECLASTZrr)
  .value("VAESDECLASTrm", LIEF::assembly::x86::OPCODE::VAESDECLASTrm)
  .value("VAESDECLASTrr", LIEF::assembly::x86::OPCODE::VAESDECLASTrr)
  .value("VAESDECYrm", LIEF::assembly::x86::OPCODE::VAESDECYrm)
  .value("VAESDECYrr", LIEF::assembly::x86::OPCODE::VAESDECYrr)
  .value("VAESDECZ128rm", LIEF::assembly::x86::OPCODE::VAESDECZ128rm)
  .value("VAESDECZ128rr", LIEF::assembly::x86::OPCODE::VAESDECZ128rr)
  .value("VAESDECZ256rm", LIEF::assembly::x86::OPCODE::VAESDECZ256rm)
  .value("VAESDECZ256rr", LIEF::assembly::x86::OPCODE::VAESDECZ256rr)
  .value("VAESDECZrm", LIEF::assembly::x86::OPCODE::VAESDECZrm)
  .value("VAESDECZrr", LIEF::assembly::x86::OPCODE::VAESDECZrr)
  .value("VAESDECrm", LIEF::assembly::x86::OPCODE::VAESDECrm)
  .value("VAESDECrr", LIEF::assembly::x86::OPCODE::VAESDECrr)
  .value("VAESENCLASTYrm", LIEF::assembly::x86::OPCODE::VAESENCLASTYrm)
  .value("VAESENCLASTYrr", LIEF::assembly::x86::OPCODE::VAESENCLASTYrr)
  .value("VAESENCLASTZ128rm", LIEF::assembly::x86::OPCODE::VAESENCLASTZ128rm)
  .value("VAESENCLASTZ128rr", LIEF::assembly::x86::OPCODE::VAESENCLASTZ128rr)
  .value("VAESENCLASTZ256rm", LIEF::assembly::x86::OPCODE::VAESENCLASTZ256rm)
  .value("VAESENCLASTZ256rr", LIEF::assembly::x86::OPCODE::VAESENCLASTZ256rr)
  .value("VAESENCLASTZrm", LIEF::assembly::x86::OPCODE::VAESENCLASTZrm)
  .value("VAESENCLASTZrr", LIEF::assembly::x86::OPCODE::VAESENCLASTZrr)
  .value("VAESENCLASTrm", LIEF::assembly::x86::OPCODE::VAESENCLASTrm)
  .value("VAESENCLASTrr", LIEF::assembly::x86::OPCODE::VAESENCLASTrr)
  .value("VAESENCYrm", LIEF::assembly::x86::OPCODE::VAESENCYrm)
  .value("VAESENCYrr", LIEF::assembly::x86::OPCODE::VAESENCYrr)
  .value("VAESENCZ128rm", LIEF::assembly::x86::OPCODE::VAESENCZ128rm)
  .value("VAESENCZ128rr", LIEF::assembly::x86::OPCODE::VAESENCZ128rr)
  .value("VAESENCZ256rm", LIEF::assembly::x86::OPCODE::VAESENCZ256rm)
  .value("VAESENCZ256rr", LIEF::assembly::x86::OPCODE::VAESENCZ256rr)
  .value("VAESENCZrm", LIEF::assembly::x86::OPCODE::VAESENCZrm)
  .value("VAESENCZrr", LIEF::assembly::x86::OPCODE::VAESENCZrr)
  .value("VAESENCrm", LIEF::assembly::x86::OPCODE::VAESENCrm)
  .value("VAESENCrr", LIEF::assembly::x86::OPCODE::VAESENCrr)
  .value("VAESIMCrm", LIEF::assembly::x86::OPCODE::VAESIMCrm)
  .value("VAESIMCrr", LIEF::assembly::x86::OPCODE::VAESIMCrr)
  .value("VAESKEYGENASSIST128rm", LIEF::assembly::x86::OPCODE::VAESKEYGENASSIST128rm)
  .value("VAESKEYGENASSIST128rr", LIEF::assembly::x86::OPCODE::VAESKEYGENASSIST128rr)
  .value("VALIGNDZ128rmbi", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmbi)
  .value("VALIGNDZ128rmbik", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmbik)
  .value("VALIGNDZ128rmbikz", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmbikz)
  .value("VALIGNDZ128rmi", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmi)
  .value("VALIGNDZ128rmik", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmik)
  .value("VALIGNDZ128rmikz", LIEF::assembly::x86::OPCODE::VALIGNDZ128rmikz)
  .value("VALIGNDZ128rri", LIEF::assembly::x86::OPCODE::VALIGNDZ128rri)
  .value("VALIGNDZ128rrik", LIEF::assembly::x86::OPCODE::VALIGNDZ128rrik)
  .value("VALIGNDZ128rrikz", LIEF::assembly::x86::OPCODE::VALIGNDZ128rrikz)
  .value("VALIGNDZ256rmbi", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmbi)
  .value("VALIGNDZ256rmbik", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmbik)
  .value("VALIGNDZ256rmbikz", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmbikz)
  .value("VALIGNDZ256rmi", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmi)
  .value("VALIGNDZ256rmik", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmik)
  .value("VALIGNDZ256rmikz", LIEF::assembly::x86::OPCODE::VALIGNDZ256rmikz)
  .value("VALIGNDZ256rri", LIEF::assembly::x86::OPCODE::VALIGNDZ256rri)
  .value("VALIGNDZ256rrik", LIEF::assembly::x86::OPCODE::VALIGNDZ256rrik)
  .value("VALIGNDZ256rrikz", LIEF::assembly::x86::OPCODE::VALIGNDZ256rrikz)
  .value("VALIGNDZrmbi", LIEF::assembly::x86::OPCODE::VALIGNDZrmbi)
  .value("VALIGNDZrmbik", LIEF::assembly::x86::OPCODE::VALIGNDZrmbik)
  .value("VALIGNDZrmbikz", LIEF::assembly::x86::OPCODE::VALIGNDZrmbikz);
  opcodes.value("VALIGNDZrmi", LIEF::assembly::x86::OPCODE::VALIGNDZrmi)
  .value("VALIGNDZrmik", LIEF::assembly::x86::OPCODE::VALIGNDZrmik)
  .value("VALIGNDZrmikz", LIEF::assembly::x86::OPCODE::VALIGNDZrmikz)
  .value("VALIGNDZrri", LIEF::assembly::x86::OPCODE::VALIGNDZrri)
  .value("VALIGNDZrrik", LIEF::assembly::x86::OPCODE::VALIGNDZrrik)
  .value("VALIGNDZrrikz", LIEF::assembly::x86::OPCODE::VALIGNDZrrikz)
  .value("VALIGNQZ128rmbi", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmbi)
  .value("VALIGNQZ128rmbik", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmbik)
  .value("VALIGNQZ128rmbikz", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmbikz)
  .value("VALIGNQZ128rmi", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmi)
  .value("VALIGNQZ128rmik", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmik)
  .value("VALIGNQZ128rmikz", LIEF::assembly::x86::OPCODE::VALIGNQZ128rmikz)
  .value("VALIGNQZ128rri", LIEF::assembly::x86::OPCODE::VALIGNQZ128rri)
  .value("VALIGNQZ128rrik", LIEF::assembly::x86::OPCODE::VALIGNQZ128rrik)
  .value("VALIGNQZ128rrikz", LIEF::assembly::x86::OPCODE::VALIGNQZ128rrikz)
  .value("VALIGNQZ256rmbi", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmbi)
  .value("VALIGNQZ256rmbik", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmbik)
  .value("VALIGNQZ256rmbikz", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmbikz)
  .value("VALIGNQZ256rmi", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmi)
  .value("VALIGNQZ256rmik", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmik)
  .value("VALIGNQZ256rmikz", LIEF::assembly::x86::OPCODE::VALIGNQZ256rmikz)
  .value("VALIGNQZ256rri", LIEF::assembly::x86::OPCODE::VALIGNQZ256rri)
  .value("VALIGNQZ256rrik", LIEF::assembly::x86::OPCODE::VALIGNQZ256rrik)
  .value("VALIGNQZ256rrikz", LIEF::assembly::x86::OPCODE::VALIGNQZ256rrikz)
  .value("VALIGNQZrmbi", LIEF::assembly::x86::OPCODE::VALIGNQZrmbi)
  .value("VALIGNQZrmbik", LIEF::assembly::x86::OPCODE::VALIGNQZrmbik)
  .value("VALIGNQZrmbikz", LIEF::assembly::x86::OPCODE::VALIGNQZrmbikz)
  .value("VALIGNQZrmi", LIEF::assembly::x86::OPCODE::VALIGNQZrmi)
  .value("VALIGNQZrmik", LIEF::assembly::x86::OPCODE::VALIGNQZrmik)
  .value("VALIGNQZrmikz", LIEF::assembly::x86::OPCODE::VALIGNQZrmikz)
  .value("VALIGNQZrri", LIEF::assembly::x86::OPCODE::VALIGNQZrri)
  .value("VALIGNQZrrik", LIEF::assembly::x86::OPCODE::VALIGNQZrrik)
  .value("VALIGNQZrrikz", LIEF::assembly::x86::OPCODE::VALIGNQZrrikz)
  .value("VANDNPDYrm", LIEF::assembly::x86::OPCODE::VANDNPDYrm)
  .value("VANDNPDYrr", LIEF::assembly::x86::OPCODE::VANDNPDYrr)
  .value("VANDNPDZ128rm", LIEF::assembly::x86::OPCODE::VANDNPDZ128rm)
  .value("VANDNPDZ128rmb", LIEF::assembly::x86::OPCODE::VANDNPDZ128rmb)
  .value("VANDNPDZ128rmbk", LIEF::assembly::x86::OPCODE::VANDNPDZ128rmbk)
  .value("VANDNPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VANDNPDZ128rmbkz)
  .value("VANDNPDZ128rmk", LIEF::assembly::x86::OPCODE::VANDNPDZ128rmk)
  .value("VANDNPDZ128rmkz", LIEF::assembly::x86::OPCODE::VANDNPDZ128rmkz)
  .value("VANDNPDZ128rr", LIEF::assembly::x86::OPCODE::VANDNPDZ128rr)
  .value("VANDNPDZ128rrk", LIEF::assembly::x86::OPCODE::VANDNPDZ128rrk)
  .value("VANDNPDZ128rrkz", LIEF::assembly::x86::OPCODE::VANDNPDZ128rrkz)
  .value("VANDNPDZ256rm", LIEF::assembly::x86::OPCODE::VANDNPDZ256rm)
  .value("VANDNPDZ256rmb", LIEF::assembly::x86::OPCODE::VANDNPDZ256rmb)
  .value("VANDNPDZ256rmbk", LIEF::assembly::x86::OPCODE::VANDNPDZ256rmbk)
  .value("VANDNPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VANDNPDZ256rmbkz)
  .value("VANDNPDZ256rmk", LIEF::assembly::x86::OPCODE::VANDNPDZ256rmk)
  .value("VANDNPDZ256rmkz", LIEF::assembly::x86::OPCODE::VANDNPDZ256rmkz)
  .value("VANDNPDZ256rr", LIEF::assembly::x86::OPCODE::VANDNPDZ256rr)
  .value("VANDNPDZ256rrk", LIEF::assembly::x86::OPCODE::VANDNPDZ256rrk)
  .value("VANDNPDZ256rrkz", LIEF::assembly::x86::OPCODE::VANDNPDZ256rrkz)
  .value("VANDNPDZrm", LIEF::assembly::x86::OPCODE::VANDNPDZrm)
  .value("VANDNPDZrmb", LIEF::assembly::x86::OPCODE::VANDNPDZrmb)
  .value("VANDNPDZrmbk", LIEF::assembly::x86::OPCODE::VANDNPDZrmbk)
  .value("VANDNPDZrmbkz", LIEF::assembly::x86::OPCODE::VANDNPDZrmbkz)
  .value("VANDNPDZrmk", LIEF::assembly::x86::OPCODE::VANDNPDZrmk)
  .value("VANDNPDZrmkz", LIEF::assembly::x86::OPCODE::VANDNPDZrmkz)
  .value("VANDNPDZrr", LIEF::assembly::x86::OPCODE::VANDNPDZrr)
  .value("VANDNPDZrrk", LIEF::assembly::x86::OPCODE::VANDNPDZrrk)
  .value("VANDNPDZrrkz", LIEF::assembly::x86::OPCODE::VANDNPDZrrkz)
  .value("VANDNPDrm", LIEF::assembly::x86::OPCODE::VANDNPDrm)
  .value("VANDNPDrr", LIEF::assembly::x86::OPCODE::VANDNPDrr)
  .value("VANDNPSYrm", LIEF::assembly::x86::OPCODE::VANDNPSYrm)
  .value("VANDNPSYrr", LIEF::assembly::x86::OPCODE::VANDNPSYrr)
  .value("VANDNPSZ128rm", LIEF::assembly::x86::OPCODE::VANDNPSZ128rm)
  .value("VANDNPSZ128rmb", LIEF::assembly::x86::OPCODE::VANDNPSZ128rmb)
  .value("VANDNPSZ128rmbk", LIEF::assembly::x86::OPCODE::VANDNPSZ128rmbk)
  .value("VANDNPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VANDNPSZ128rmbkz)
  .value("VANDNPSZ128rmk", LIEF::assembly::x86::OPCODE::VANDNPSZ128rmk)
  .value("VANDNPSZ128rmkz", LIEF::assembly::x86::OPCODE::VANDNPSZ128rmkz)
  .value("VANDNPSZ128rr", LIEF::assembly::x86::OPCODE::VANDNPSZ128rr)
  .value("VANDNPSZ128rrk", LIEF::assembly::x86::OPCODE::VANDNPSZ128rrk)
  .value("VANDNPSZ128rrkz", LIEF::assembly::x86::OPCODE::VANDNPSZ128rrkz)
  .value("VANDNPSZ256rm", LIEF::assembly::x86::OPCODE::VANDNPSZ256rm)
  .value("VANDNPSZ256rmb", LIEF::assembly::x86::OPCODE::VANDNPSZ256rmb)
  .value("VANDNPSZ256rmbk", LIEF::assembly::x86::OPCODE::VANDNPSZ256rmbk)
  .value("VANDNPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VANDNPSZ256rmbkz)
  .value("VANDNPSZ256rmk", LIEF::assembly::x86::OPCODE::VANDNPSZ256rmk)
  .value("VANDNPSZ256rmkz", LIEF::assembly::x86::OPCODE::VANDNPSZ256rmkz)
  .value("VANDNPSZ256rr", LIEF::assembly::x86::OPCODE::VANDNPSZ256rr)
  .value("VANDNPSZ256rrk", LIEF::assembly::x86::OPCODE::VANDNPSZ256rrk)
  .value("VANDNPSZ256rrkz", LIEF::assembly::x86::OPCODE::VANDNPSZ256rrkz)
  .value("VANDNPSZrm", LIEF::assembly::x86::OPCODE::VANDNPSZrm)
  .value("VANDNPSZrmb", LIEF::assembly::x86::OPCODE::VANDNPSZrmb)
  .value("VANDNPSZrmbk", LIEF::assembly::x86::OPCODE::VANDNPSZrmbk)
  .value("VANDNPSZrmbkz", LIEF::assembly::x86::OPCODE::VANDNPSZrmbkz)
  .value("VANDNPSZrmk", LIEF::assembly::x86::OPCODE::VANDNPSZrmk)
  .value("VANDNPSZrmkz", LIEF::assembly::x86::OPCODE::VANDNPSZrmkz)
  .value("VANDNPSZrr", LIEF::assembly::x86::OPCODE::VANDNPSZrr)
  .value("VANDNPSZrrk", LIEF::assembly::x86::OPCODE::VANDNPSZrrk)
  .value("VANDNPSZrrkz", LIEF::assembly::x86::OPCODE::VANDNPSZrrkz)
  .value("VANDNPSrm", LIEF::assembly::x86::OPCODE::VANDNPSrm)
  .value("VANDNPSrr", LIEF::assembly::x86::OPCODE::VANDNPSrr)
  .value("VANDPDYrm", LIEF::assembly::x86::OPCODE::VANDPDYrm)
  .value("VANDPDYrr", LIEF::assembly::x86::OPCODE::VANDPDYrr)
  .value("VANDPDZ128rm", LIEF::assembly::x86::OPCODE::VANDPDZ128rm)
  .value("VANDPDZ128rmb", LIEF::assembly::x86::OPCODE::VANDPDZ128rmb)
  .value("VANDPDZ128rmbk", LIEF::assembly::x86::OPCODE::VANDPDZ128rmbk)
  .value("VANDPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VANDPDZ128rmbkz)
  .value("VANDPDZ128rmk", LIEF::assembly::x86::OPCODE::VANDPDZ128rmk)
  .value("VANDPDZ128rmkz", LIEF::assembly::x86::OPCODE::VANDPDZ128rmkz)
  .value("VANDPDZ128rr", LIEF::assembly::x86::OPCODE::VANDPDZ128rr)
  .value("VANDPDZ128rrk", LIEF::assembly::x86::OPCODE::VANDPDZ128rrk)
  .value("VANDPDZ128rrkz", LIEF::assembly::x86::OPCODE::VANDPDZ128rrkz)
  .value("VANDPDZ256rm", LIEF::assembly::x86::OPCODE::VANDPDZ256rm)
  .value("VANDPDZ256rmb", LIEF::assembly::x86::OPCODE::VANDPDZ256rmb)
  .value("VANDPDZ256rmbk", LIEF::assembly::x86::OPCODE::VANDPDZ256rmbk)
  .value("VANDPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VANDPDZ256rmbkz)
  .value("VANDPDZ256rmk", LIEF::assembly::x86::OPCODE::VANDPDZ256rmk)
  .value("VANDPDZ256rmkz", LIEF::assembly::x86::OPCODE::VANDPDZ256rmkz)
  .value("VANDPDZ256rr", LIEF::assembly::x86::OPCODE::VANDPDZ256rr)
  .value("VANDPDZ256rrk", LIEF::assembly::x86::OPCODE::VANDPDZ256rrk)
  .value("VANDPDZ256rrkz", LIEF::assembly::x86::OPCODE::VANDPDZ256rrkz)
  .value("VANDPDZrm", LIEF::assembly::x86::OPCODE::VANDPDZrm)
  .value("VANDPDZrmb", LIEF::assembly::x86::OPCODE::VANDPDZrmb)
  .value("VANDPDZrmbk", LIEF::assembly::x86::OPCODE::VANDPDZrmbk)
  .value("VANDPDZrmbkz", LIEF::assembly::x86::OPCODE::VANDPDZrmbkz)
  .value("VANDPDZrmk", LIEF::assembly::x86::OPCODE::VANDPDZrmk)
  .value("VANDPDZrmkz", LIEF::assembly::x86::OPCODE::VANDPDZrmkz)
  .value("VANDPDZrr", LIEF::assembly::x86::OPCODE::VANDPDZrr)
  .value("VANDPDZrrk", LIEF::assembly::x86::OPCODE::VANDPDZrrk)
  .value("VANDPDZrrkz", LIEF::assembly::x86::OPCODE::VANDPDZrrkz)
  .value("VANDPDrm", LIEF::assembly::x86::OPCODE::VANDPDrm)
  .value("VANDPDrr", LIEF::assembly::x86::OPCODE::VANDPDrr)
  .value("VANDPSYrm", LIEF::assembly::x86::OPCODE::VANDPSYrm)
  .value("VANDPSYrr", LIEF::assembly::x86::OPCODE::VANDPSYrr)
  .value("VANDPSZ128rm", LIEF::assembly::x86::OPCODE::VANDPSZ128rm)
  .value("VANDPSZ128rmb", LIEF::assembly::x86::OPCODE::VANDPSZ128rmb)
  .value("VANDPSZ128rmbk", LIEF::assembly::x86::OPCODE::VANDPSZ128rmbk)
  .value("VANDPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VANDPSZ128rmbkz)
  .value("VANDPSZ128rmk", LIEF::assembly::x86::OPCODE::VANDPSZ128rmk)
  .value("VANDPSZ128rmkz", LIEF::assembly::x86::OPCODE::VANDPSZ128rmkz)
  .value("VANDPSZ128rr", LIEF::assembly::x86::OPCODE::VANDPSZ128rr)
  .value("VANDPSZ128rrk", LIEF::assembly::x86::OPCODE::VANDPSZ128rrk)
  .value("VANDPSZ128rrkz", LIEF::assembly::x86::OPCODE::VANDPSZ128rrkz)
  .value("VANDPSZ256rm", LIEF::assembly::x86::OPCODE::VANDPSZ256rm)
  .value("VANDPSZ256rmb", LIEF::assembly::x86::OPCODE::VANDPSZ256rmb)
  .value("VANDPSZ256rmbk", LIEF::assembly::x86::OPCODE::VANDPSZ256rmbk)
  .value("VANDPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VANDPSZ256rmbkz)
  .value("VANDPSZ256rmk", LIEF::assembly::x86::OPCODE::VANDPSZ256rmk)
  .value("VANDPSZ256rmkz", LIEF::assembly::x86::OPCODE::VANDPSZ256rmkz)
  .value("VANDPSZ256rr", LIEF::assembly::x86::OPCODE::VANDPSZ256rr)
  .value("VANDPSZ256rrk", LIEF::assembly::x86::OPCODE::VANDPSZ256rrk)
  .value("VANDPSZ256rrkz", LIEF::assembly::x86::OPCODE::VANDPSZ256rrkz)
  .value("VANDPSZrm", LIEF::assembly::x86::OPCODE::VANDPSZrm)
  .value("VANDPSZrmb", LIEF::assembly::x86::OPCODE::VANDPSZrmb)
  .value("VANDPSZrmbk", LIEF::assembly::x86::OPCODE::VANDPSZrmbk)
  .value("VANDPSZrmbkz", LIEF::assembly::x86::OPCODE::VANDPSZrmbkz)
  .value("VANDPSZrmk", LIEF::assembly::x86::OPCODE::VANDPSZrmk)
  .value("VANDPSZrmkz", LIEF::assembly::x86::OPCODE::VANDPSZrmkz)
  .value("VANDPSZrr", LIEF::assembly::x86::OPCODE::VANDPSZrr)
  .value("VANDPSZrrk", LIEF::assembly::x86::OPCODE::VANDPSZrrk)
  .value("VANDPSZrrkz", LIEF::assembly::x86::OPCODE::VANDPSZrrkz)
  .value("VANDPSrm", LIEF::assembly::x86::OPCODE::VANDPSrm)
  .value("VANDPSrr", LIEF::assembly::x86::OPCODE::VANDPSrr)
  .value("VASTART_SAVE_XMM_REGS", LIEF::assembly::x86::OPCODE::VASTART_SAVE_XMM_REGS)
  .value("VBCSTNEBF162PSYrm", LIEF::assembly::x86::OPCODE::VBCSTNEBF162PSYrm)
  .value("VBCSTNEBF162PSrm", LIEF::assembly::x86::OPCODE::VBCSTNEBF162PSrm)
  .value("VBCSTNESH2PSYrm", LIEF::assembly::x86::OPCODE::VBCSTNESH2PSYrm)
  .value("VBCSTNESH2PSrm", LIEF::assembly::x86::OPCODE::VBCSTNESH2PSrm)
  .value("VBLENDMPDZ128rm", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rm)
  .value("VBLENDMPDZ128rmb", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rmb)
  .value("VBLENDMPDZ128rmbk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rmbk)
  .value("VBLENDMPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rmbkz)
  .value("VBLENDMPDZ128rmk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rmk)
  .value("VBLENDMPDZ128rmkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rmkz)
  .value("VBLENDMPDZ128rr", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rr)
  .value("VBLENDMPDZ128rrk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rrk)
  .value("VBLENDMPDZ128rrkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ128rrkz)
  .value("VBLENDMPDZ256rm", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rm)
  .value("VBLENDMPDZ256rmb", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rmb)
  .value("VBLENDMPDZ256rmbk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rmbk)
  .value("VBLENDMPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rmbkz)
  .value("VBLENDMPDZ256rmk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rmk)
  .value("VBLENDMPDZ256rmkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rmkz)
  .value("VBLENDMPDZ256rr", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rr)
  .value("VBLENDMPDZ256rrk", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rrk)
  .value("VBLENDMPDZ256rrkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZ256rrkz)
  .value("VBLENDMPDZrm", LIEF::assembly::x86::OPCODE::VBLENDMPDZrm)
  .value("VBLENDMPDZrmb", LIEF::assembly::x86::OPCODE::VBLENDMPDZrmb)
  .value("VBLENDMPDZrmbk", LIEF::assembly::x86::OPCODE::VBLENDMPDZrmbk)
  .value("VBLENDMPDZrmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZrmbkz)
  .value("VBLENDMPDZrmk", LIEF::assembly::x86::OPCODE::VBLENDMPDZrmk)
  .value("VBLENDMPDZrmkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZrmkz)
  .value("VBLENDMPDZrr", LIEF::assembly::x86::OPCODE::VBLENDMPDZrr)
  .value("VBLENDMPDZrrk", LIEF::assembly::x86::OPCODE::VBLENDMPDZrrk)
  .value("VBLENDMPDZrrkz", LIEF::assembly::x86::OPCODE::VBLENDMPDZrrkz)
  .value("VBLENDMPSZ128rm", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rm)
  .value("VBLENDMPSZ128rmb", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rmb)
  .value("VBLENDMPSZ128rmbk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rmbk)
  .value("VBLENDMPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rmbkz)
  .value("VBLENDMPSZ128rmk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rmk)
  .value("VBLENDMPSZ128rmkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rmkz)
  .value("VBLENDMPSZ128rr", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rr)
  .value("VBLENDMPSZ128rrk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rrk)
  .value("VBLENDMPSZ128rrkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ128rrkz)
  .value("VBLENDMPSZ256rm", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rm)
  .value("VBLENDMPSZ256rmb", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rmb)
  .value("VBLENDMPSZ256rmbk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rmbk)
  .value("VBLENDMPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rmbkz)
  .value("VBLENDMPSZ256rmk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rmk)
  .value("VBLENDMPSZ256rmkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rmkz)
  .value("VBLENDMPSZ256rr", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rr)
  .value("VBLENDMPSZ256rrk", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rrk)
  .value("VBLENDMPSZ256rrkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZ256rrkz)
  .value("VBLENDMPSZrm", LIEF::assembly::x86::OPCODE::VBLENDMPSZrm)
  .value("VBLENDMPSZrmb", LIEF::assembly::x86::OPCODE::VBLENDMPSZrmb)
  .value("VBLENDMPSZrmbk", LIEF::assembly::x86::OPCODE::VBLENDMPSZrmbk)
  .value("VBLENDMPSZrmbkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZrmbkz)
  .value("VBLENDMPSZrmk", LIEF::assembly::x86::OPCODE::VBLENDMPSZrmk)
  .value("VBLENDMPSZrmkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZrmkz)
  .value("VBLENDMPSZrr", LIEF::assembly::x86::OPCODE::VBLENDMPSZrr)
  .value("VBLENDMPSZrrk", LIEF::assembly::x86::OPCODE::VBLENDMPSZrrk)
  .value("VBLENDMPSZrrkz", LIEF::assembly::x86::OPCODE::VBLENDMPSZrrkz)
  .value("VBLENDPDYrmi", LIEF::assembly::x86::OPCODE::VBLENDPDYrmi)
  .value("VBLENDPDYrri", LIEF::assembly::x86::OPCODE::VBLENDPDYrri)
  .value("VBLENDPDrmi", LIEF::assembly::x86::OPCODE::VBLENDPDrmi)
  .value("VBLENDPDrri", LIEF::assembly::x86::OPCODE::VBLENDPDrri)
  .value("VBLENDPSYrmi", LIEF::assembly::x86::OPCODE::VBLENDPSYrmi)
  .value("VBLENDPSYrri", LIEF::assembly::x86::OPCODE::VBLENDPSYrri)
  .value("VBLENDPSrmi", LIEF::assembly::x86::OPCODE::VBLENDPSrmi)
  .value("VBLENDPSrri", LIEF::assembly::x86::OPCODE::VBLENDPSrri)
  .value("VBLENDVPDYrmr", LIEF::assembly::x86::OPCODE::VBLENDVPDYrmr)
  .value("VBLENDVPDYrrr", LIEF::assembly::x86::OPCODE::VBLENDVPDYrrr)
  .value("VBLENDVPDrmr", LIEF::assembly::x86::OPCODE::VBLENDVPDrmr)
  .value("VBLENDVPDrrr", LIEF::assembly::x86::OPCODE::VBLENDVPDrrr)
  .value("VBLENDVPSYrmr", LIEF::assembly::x86::OPCODE::VBLENDVPSYrmr)
  .value("VBLENDVPSYrrr", LIEF::assembly::x86::OPCODE::VBLENDVPSYrrr)
  .value("VBLENDVPSrmr", LIEF::assembly::x86::OPCODE::VBLENDVPSrmr)
  .value("VBLENDVPSrrr", LIEF::assembly::x86::OPCODE::VBLENDVPSrrr)
  .value("VBROADCASTF128rm", LIEF::assembly::x86::OPCODE::VBROADCASTF128rm)
  .value("VBROADCASTF32X2Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rm)
  .value("VBROADCASTF32X2Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rmk)
  .value("VBROADCASTF32X2Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rmkz)
  .value("VBROADCASTF32X2Z256rr", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rr)
  .value("VBROADCASTF32X2Z256rrk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rrk)
  .value("VBROADCASTF32X2Z256rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Z256rrkz)
  .value("VBROADCASTF32X2Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrm)
  .value("VBROADCASTF32X2Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrmk)
  .value("VBROADCASTF32X2Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrmkz)
  .value("VBROADCASTF32X2Zrr", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrr)
  .value("VBROADCASTF32X2Zrrk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrrk)
  .value("VBROADCASTF32X2Zrrkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X2Zrrkz)
  .value("VBROADCASTF32X4Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Z256rm)
  .value("VBROADCASTF32X4Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Z256rmk)
  .value("VBROADCASTF32X4Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Z256rmkz)
  .value("VBROADCASTF32X4Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Zrm)
  .value("VBROADCASTF32X4Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Zrmk)
  .value("VBROADCASTF32X4Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X4Zrmkz)
  .value("VBROADCASTF32X8Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTF32X8Zrm)
  .value("VBROADCASTF32X8Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTF32X8Zrmk)
  .value("VBROADCASTF32X8Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF32X8Zrmkz)
  .value("VBROADCASTF64X2Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Z256rm)
  .value("VBROADCASTF64X2Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Z256rmk)
  .value("VBROADCASTF64X2Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Z256rmkz)
  .value("VBROADCASTF64X2Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Zrm)
  .value("VBROADCASTF64X2Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Zrmk)
  .value("VBROADCASTF64X2Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF64X2Zrmkz)
  .value("VBROADCASTF64X4Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTF64X4Zrm)
  .value("VBROADCASTF64X4Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTF64X4Zrmk)
  .value("VBROADCASTF64X4Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTF64X4Zrmkz)
  .value("VBROADCASTI128rm", LIEF::assembly::x86::OPCODE::VBROADCASTI128rm)
  .value("VBROADCASTI32X2Z128rm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rm)
  .value("VBROADCASTI32X2Z128rmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rmk)
  .value("VBROADCASTI32X2Z128rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rmkz)
  .value("VBROADCASTI32X2Z128rr", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rr)
  .value("VBROADCASTI32X2Z128rrk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rrk)
  .value("VBROADCASTI32X2Z128rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z128rrkz)
  .value("VBROADCASTI32X2Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rm)
  .value("VBROADCASTI32X2Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rmk)
  .value("VBROADCASTI32X2Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rmkz)
  .value("VBROADCASTI32X2Z256rr", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rr)
  .value("VBROADCASTI32X2Z256rrk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rrk)
  .value("VBROADCASTI32X2Z256rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Z256rrkz)
  .value("VBROADCASTI32X2Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrm)
  .value("VBROADCASTI32X2Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrmk)
  .value("VBROADCASTI32X2Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrmkz)
  .value("VBROADCASTI32X2Zrr", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrr)
  .value("VBROADCASTI32X2Zrrk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrrk)
  .value("VBROADCASTI32X2Zrrkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X2Zrrkz)
  .value("VBROADCASTI32X4Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Z256rm)
  .value("VBROADCASTI32X4Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Z256rmk)
  .value("VBROADCASTI32X4Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Z256rmkz)
  .value("VBROADCASTI32X4Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Zrm)
  .value("VBROADCASTI32X4Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Zrmk)
  .value("VBROADCASTI32X4Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X4Zrmkz)
  .value("VBROADCASTI32X8Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTI32X8Zrm)
  .value("VBROADCASTI32X8Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTI32X8Zrmk)
  .value("VBROADCASTI32X8Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI32X8Zrmkz)
  .value("VBROADCASTI64X2Z256rm", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Z256rm)
  .value("VBROADCASTI64X2Z256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Z256rmk)
  .value("VBROADCASTI64X2Z256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Z256rmkz)
  .value("VBROADCASTI64X2Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Zrm)
  .value("VBROADCASTI64X2Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Zrmk)
  .value("VBROADCASTI64X2Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI64X2Zrmkz)
  .value("VBROADCASTI64X4Zrm", LIEF::assembly::x86::OPCODE::VBROADCASTI64X4Zrm)
  .value("VBROADCASTI64X4Zrmk", LIEF::assembly::x86::OPCODE::VBROADCASTI64X4Zrmk)
  .value("VBROADCASTI64X4Zrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTI64X4Zrmkz);
  opcodes.value("VBROADCASTSDYrm", LIEF::assembly::x86::OPCODE::VBROADCASTSDYrm)
  .value("VBROADCASTSDYrr", LIEF::assembly::x86::OPCODE::VBROADCASTSDYrr)
  .value("VBROADCASTSDZ256rm", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rm)
  .value("VBROADCASTSDZ256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rmk)
  .value("VBROADCASTSDZ256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rmkz)
  .value("VBROADCASTSDZ256rr", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rr)
  .value("VBROADCASTSDZ256rrk", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rrk)
  .value("VBROADCASTSDZ256rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTSDZ256rrkz)
  .value("VBROADCASTSDZrm", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrm)
  .value("VBROADCASTSDZrmk", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrmk)
  .value("VBROADCASTSDZrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrmkz)
  .value("VBROADCASTSDZrr", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrr)
  .value("VBROADCASTSDZrrk", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrrk)
  .value("VBROADCASTSDZrrkz", LIEF::assembly::x86::OPCODE::VBROADCASTSDZrrkz)
  .value("VBROADCASTSSYrm", LIEF::assembly::x86::OPCODE::VBROADCASTSSYrm)
  .value("VBROADCASTSSYrr", LIEF::assembly::x86::OPCODE::VBROADCASTSSYrr)
  .value("VBROADCASTSSZ128rm", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rm)
  .value("VBROADCASTSSZ128rmk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rmk)
  .value("VBROADCASTSSZ128rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rmkz)
  .value("VBROADCASTSSZ128rr", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rr)
  .value("VBROADCASTSSZ128rrk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rrk)
  .value("VBROADCASTSSZ128rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ128rrkz)
  .value("VBROADCASTSSZ256rm", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rm)
  .value("VBROADCASTSSZ256rmk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rmk)
  .value("VBROADCASTSSZ256rmkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rmkz)
  .value("VBROADCASTSSZ256rr", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rr)
  .value("VBROADCASTSSZ256rrk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rrk)
  .value("VBROADCASTSSZ256rrkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZ256rrkz)
  .value("VBROADCASTSSZrm", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrm)
  .value("VBROADCASTSSZrmk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrmk)
  .value("VBROADCASTSSZrmkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrmkz)
  .value("VBROADCASTSSZrr", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrr)
  .value("VBROADCASTSSZrrk", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrrk)
  .value("VBROADCASTSSZrrkz", LIEF::assembly::x86::OPCODE::VBROADCASTSSZrrkz)
  .value("VBROADCASTSSrm", LIEF::assembly::x86::OPCODE::VBROADCASTSSrm)
  .value("VBROADCASTSSrr", LIEF::assembly::x86::OPCODE::VBROADCASTSSrr)
  .value("VCMPBF16Z128rmbi", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rmbi)
  .value("VCMPBF16Z128rmbik", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rmbik)
  .value("VCMPBF16Z128rmi", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rmi)
  .value("VCMPBF16Z128rmik", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rmik)
  .value("VCMPBF16Z128rri", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rri)
  .value("VCMPBF16Z128rrik", LIEF::assembly::x86::OPCODE::VCMPBF16Z128rrik)
  .value("VCMPBF16Z256rmbi", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rmbi)
  .value("VCMPBF16Z256rmbik", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rmbik)
  .value("VCMPBF16Z256rmi", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rmi)
  .value("VCMPBF16Z256rmik", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rmik)
  .value("VCMPBF16Z256rri", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rri)
  .value("VCMPBF16Z256rrik", LIEF::assembly::x86::OPCODE::VCMPBF16Z256rrik)
  .value("VCMPBF16Zrmbi", LIEF::assembly::x86::OPCODE::VCMPBF16Zrmbi)
  .value("VCMPBF16Zrmbik", LIEF::assembly::x86::OPCODE::VCMPBF16Zrmbik)
  .value("VCMPBF16Zrmi", LIEF::assembly::x86::OPCODE::VCMPBF16Zrmi)
  .value("VCMPBF16Zrmik", LIEF::assembly::x86::OPCODE::VCMPBF16Zrmik)
  .value("VCMPBF16Zrri", LIEF::assembly::x86::OPCODE::VCMPBF16Zrri)
  .value("VCMPBF16Zrrik", LIEF::assembly::x86::OPCODE::VCMPBF16Zrrik)
  .value("VCMPPDYrmi", LIEF::assembly::x86::OPCODE::VCMPPDYrmi)
  .value("VCMPPDYrri", LIEF::assembly::x86::OPCODE::VCMPPDYrri)
  .value("VCMPPDZ128rmbi", LIEF::assembly::x86::OPCODE::VCMPPDZ128rmbi)
  .value("VCMPPDZ128rmbik", LIEF::assembly::x86::OPCODE::VCMPPDZ128rmbik)
  .value("VCMPPDZ128rmi", LIEF::assembly::x86::OPCODE::VCMPPDZ128rmi)
  .value("VCMPPDZ128rmik", LIEF::assembly::x86::OPCODE::VCMPPDZ128rmik)
  .value("VCMPPDZ128rri", LIEF::assembly::x86::OPCODE::VCMPPDZ128rri)
  .value("VCMPPDZ128rrik", LIEF::assembly::x86::OPCODE::VCMPPDZ128rrik)
  .value("VCMPPDZ256rmbi", LIEF::assembly::x86::OPCODE::VCMPPDZ256rmbi)
  .value("VCMPPDZ256rmbik", LIEF::assembly::x86::OPCODE::VCMPPDZ256rmbik)
  .value("VCMPPDZ256rmi", LIEF::assembly::x86::OPCODE::VCMPPDZ256rmi)
  .value("VCMPPDZ256rmik", LIEF::assembly::x86::OPCODE::VCMPPDZ256rmik)
  .value("VCMPPDZ256rri", LIEF::assembly::x86::OPCODE::VCMPPDZ256rri)
  .value("VCMPPDZ256rrik", LIEF::assembly::x86::OPCODE::VCMPPDZ256rrik)
  .value("VCMPPDZrmbi", LIEF::assembly::x86::OPCODE::VCMPPDZrmbi)
  .value("VCMPPDZrmbik", LIEF::assembly::x86::OPCODE::VCMPPDZrmbik)
  .value("VCMPPDZrmi", LIEF::assembly::x86::OPCODE::VCMPPDZrmi)
  .value("VCMPPDZrmik", LIEF::assembly::x86::OPCODE::VCMPPDZrmik)
  .value("VCMPPDZrri", LIEF::assembly::x86::OPCODE::VCMPPDZrri)
  .value("VCMPPDZrrib", LIEF::assembly::x86::OPCODE::VCMPPDZrrib)
  .value("VCMPPDZrribk", LIEF::assembly::x86::OPCODE::VCMPPDZrribk)
  .value("VCMPPDZrrik", LIEF::assembly::x86::OPCODE::VCMPPDZrrik)
  .value("VCMPPDrmi", LIEF::assembly::x86::OPCODE::VCMPPDrmi)
  .value("VCMPPDrri", LIEF::assembly::x86::OPCODE::VCMPPDrri)
  .value("VCMPPHZ128rmbi", LIEF::assembly::x86::OPCODE::VCMPPHZ128rmbi)
  .value("VCMPPHZ128rmbik", LIEF::assembly::x86::OPCODE::VCMPPHZ128rmbik)
  .value("VCMPPHZ128rmi", LIEF::assembly::x86::OPCODE::VCMPPHZ128rmi)
  .value("VCMPPHZ128rmik", LIEF::assembly::x86::OPCODE::VCMPPHZ128rmik)
  .value("VCMPPHZ128rri", LIEF::assembly::x86::OPCODE::VCMPPHZ128rri)
  .value("VCMPPHZ128rrik", LIEF::assembly::x86::OPCODE::VCMPPHZ128rrik)
  .value("VCMPPHZ256rmbi", LIEF::assembly::x86::OPCODE::VCMPPHZ256rmbi)
  .value("VCMPPHZ256rmbik", LIEF::assembly::x86::OPCODE::VCMPPHZ256rmbik)
  .value("VCMPPHZ256rmi", LIEF::assembly::x86::OPCODE::VCMPPHZ256rmi)
  .value("VCMPPHZ256rmik", LIEF::assembly::x86::OPCODE::VCMPPHZ256rmik)
  .value("VCMPPHZ256rri", LIEF::assembly::x86::OPCODE::VCMPPHZ256rri)
  .value("VCMPPHZ256rrik", LIEF::assembly::x86::OPCODE::VCMPPHZ256rrik)
  .value("VCMPPHZrmbi", LIEF::assembly::x86::OPCODE::VCMPPHZrmbi)
  .value("VCMPPHZrmbik", LIEF::assembly::x86::OPCODE::VCMPPHZrmbik)
  .value("VCMPPHZrmi", LIEF::assembly::x86::OPCODE::VCMPPHZrmi)
  .value("VCMPPHZrmik", LIEF::assembly::x86::OPCODE::VCMPPHZrmik)
  .value("VCMPPHZrri", LIEF::assembly::x86::OPCODE::VCMPPHZrri)
  .value("VCMPPHZrrib", LIEF::assembly::x86::OPCODE::VCMPPHZrrib)
  .value("VCMPPHZrribk", LIEF::assembly::x86::OPCODE::VCMPPHZrribk)
  .value("VCMPPHZrrik", LIEF::assembly::x86::OPCODE::VCMPPHZrrik)
  .value("VCMPPSYrmi", LIEF::assembly::x86::OPCODE::VCMPPSYrmi)
  .value("VCMPPSYrri", LIEF::assembly::x86::OPCODE::VCMPPSYrri)
  .value("VCMPPSZ128rmbi", LIEF::assembly::x86::OPCODE::VCMPPSZ128rmbi)
  .value("VCMPPSZ128rmbik", LIEF::assembly::x86::OPCODE::VCMPPSZ128rmbik)
  .value("VCMPPSZ128rmi", LIEF::assembly::x86::OPCODE::VCMPPSZ128rmi)
  .value("VCMPPSZ128rmik", LIEF::assembly::x86::OPCODE::VCMPPSZ128rmik)
  .value("VCMPPSZ128rri", LIEF::assembly::x86::OPCODE::VCMPPSZ128rri)
  .value("VCMPPSZ128rrik", LIEF::assembly::x86::OPCODE::VCMPPSZ128rrik)
  .value("VCMPPSZ256rmbi", LIEF::assembly::x86::OPCODE::VCMPPSZ256rmbi)
  .value("VCMPPSZ256rmbik", LIEF::assembly::x86::OPCODE::VCMPPSZ256rmbik)
  .value("VCMPPSZ256rmi", LIEF::assembly::x86::OPCODE::VCMPPSZ256rmi)
  .value("VCMPPSZ256rmik", LIEF::assembly::x86::OPCODE::VCMPPSZ256rmik)
  .value("VCMPPSZ256rri", LIEF::assembly::x86::OPCODE::VCMPPSZ256rri)
  .value("VCMPPSZ256rrik", LIEF::assembly::x86::OPCODE::VCMPPSZ256rrik)
  .value("VCMPPSZrmbi", LIEF::assembly::x86::OPCODE::VCMPPSZrmbi)
  .value("VCMPPSZrmbik", LIEF::assembly::x86::OPCODE::VCMPPSZrmbik)
  .value("VCMPPSZrmi", LIEF::assembly::x86::OPCODE::VCMPPSZrmi)
  .value("VCMPPSZrmik", LIEF::assembly::x86::OPCODE::VCMPPSZrmik)
  .value("VCMPPSZrri", LIEF::assembly::x86::OPCODE::VCMPPSZrri)
  .value("VCMPPSZrrib", LIEF::assembly::x86::OPCODE::VCMPPSZrrib)
  .value("VCMPPSZrribk", LIEF::assembly::x86::OPCODE::VCMPPSZrribk)
  .value("VCMPPSZrrik", LIEF::assembly::x86::OPCODE::VCMPPSZrrik)
  .value("VCMPPSrmi", LIEF::assembly::x86::OPCODE::VCMPPSrmi)
  .value("VCMPPSrri", LIEF::assembly::x86::OPCODE::VCMPPSrri)
  .value("VCMPSDZrmi", LIEF::assembly::x86::OPCODE::VCMPSDZrmi)
  .value("VCMPSDZrmi_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrmi_Int)
  .value("VCMPSDZrmik_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrmik_Int)
  .value("VCMPSDZrri", LIEF::assembly::x86::OPCODE::VCMPSDZrri)
  .value("VCMPSDZrri_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrri_Int)
  .value("VCMPSDZrrib_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrrib_Int)
  .value("VCMPSDZrribk_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrribk_Int)
  .value("VCMPSDZrrik_Int", LIEF::assembly::x86::OPCODE::VCMPSDZrrik_Int)
  .value("VCMPSDrmi", LIEF::assembly::x86::OPCODE::VCMPSDrmi)
  .value("VCMPSDrmi_Int", LIEF::assembly::x86::OPCODE::VCMPSDrmi_Int)
  .value("VCMPSDrri", LIEF::assembly::x86::OPCODE::VCMPSDrri)
  .value("VCMPSDrri_Int", LIEF::assembly::x86::OPCODE::VCMPSDrri_Int)
  .value("VCMPSHZrmi", LIEF::assembly::x86::OPCODE::VCMPSHZrmi)
  .value("VCMPSHZrmi_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrmi_Int)
  .value("VCMPSHZrmik_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrmik_Int)
  .value("VCMPSHZrri", LIEF::assembly::x86::OPCODE::VCMPSHZrri)
  .value("VCMPSHZrri_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrri_Int)
  .value("VCMPSHZrrib_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrrib_Int)
  .value("VCMPSHZrribk_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrribk_Int)
  .value("VCMPSHZrrik_Int", LIEF::assembly::x86::OPCODE::VCMPSHZrrik_Int)
  .value("VCMPSSZrmi", LIEF::assembly::x86::OPCODE::VCMPSSZrmi)
  .value("VCMPSSZrmi_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrmi_Int)
  .value("VCMPSSZrmik_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrmik_Int)
  .value("VCMPSSZrri", LIEF::assembly::x86::OPCODE::VCMPSSZrri)
  .value("VCMPSSZrri_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrri_Int)
  .value("VCMPSSZrrib_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrrib_Int)
  .value("VCMPSSZrribk_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrribk_Int)
  .value("VCMPSSZrrik_Int", LIEF::assembly::x86::OPCODE::VCMPSSZrrik_Int)
  .value("VCMPSSrmi", LIEF::assembly::x86::OPCODE::VCMPSSrmi)
  .value("VCMPSSrmi_Int", LIEF::assembly::x86::OPCODE::VCMPSSrmi_Int)
  .value("VCMPSSrri", LIEF::assembly::x86::OPCODE::VCMPSSrri)
  .value("VCMPSSrri_Int", LIEF::assembly::x86::OPCODE::VCMPSSrri_Int)
  .value("VCOMISBF16Zrm", LIEF::assembly::x86::OPCODE::VCOMISBF16Zrm)
  .value("VCOMISBF16Zrm_Int", LIEF::assembly::x86::OPCODE::VCOMISBF16Zrm_Int)
  .value("VCOMISBF16Zrr", LIEF::assembly::x86::OPCODE::VCOMISBF16Zrr)
  .value("VCOMISBF16Zrr_Int", LIEF::assembly::x86::OPCODE::VCOMISBF16Zrr_Int)
  .value("VCOMISDZrm", LIEF::assembly::x86::OPCODE::VCOMISDZrm)
  .value("VCOMISDZrm_Int", LIEF::assembly::x86::OPCODE::VCOMISDZrm_Int)
  .value("VCOMISDZrr", LIEF::assembly::x86::OPCODE::VCOMISDZrr)
  .value("VCOMISDZrr_Int", LIEF::assembly::x86::OPCODE::VCOMISDZrr_Int)
  .value("VCOMISDZrrb", LIEF::assembly::x86::OPCODE::VCOMISDZrrb)
  .value("VCOMISDrm", LIEF::assembly::x86::OPCODE::VCOMISDrm)
  .value("VCOMISDrm_Int", LIEF::assembly::x86::OPCODE::VCOMISDrm_Int)
  .value("VCOMISDrr", LIEF::assembly::x86::OPCODE::VCOMISDrr)
  .value("VCOMISDrr_Int", LIEF::assembly::x86::OPCODE::VCOMISDrr_Int)
  .value("VCOMISHZrm", LIEF::assembly::x86::OPCODE::VCOMISHZrm)
  .value("VCOMISHZrm_Int", LIEF::assembly::x86::OPCODE::VCOMISHZrm_Int)
  .value("VCOMISHZrr", LIEF::assembly::x86::OPCODE::VCOMISHZrr)
  .value("VCOMISHZrr_Int", LIEF::assembly::x86::OPCODE::VCOMISHZrr_Int)
  .value("VCOMISHZrrb", LIEF::assembly::x86::OPCODE::VCOMISHZrrb)
  .value("VCOMISSZrm", LIEF::assembly::x86::OPCODE::VCOMISSZrm)
  .value("VCOMISSZrm_Int", LIEF::assembly::x86::OPCODE::VCOMISSZrm_Int)
  .value("VCOMISSZrr", LIEF::assembly::x86::OPCODE::VCOMISSZrr)
  .value("VCOMISSZrr_Int", LIEF::assembly::x86::OPCODE::VCOMISSZrr_Int)
  .value("VCOMISSZrrb", LIEF::assembly::x86::OPCODE::VCOMISSZrrb)
  .value("VCOMISSrm", LIEF::assembly::x86::OPCODE::VCOMISSrm)
  .value("VCOMISSrm_Int", LIEF::assembly::x86::OPCODE::VCOMISSrm_Int)
  .value("VCOMISSrr", LIEF::assembly::x86::OPCODE::VCOMISSrr)
  .value("VCOMISSrr_Int", LIEF::assembly::x86::OPCODE::VCOMISSrr_Int)
  .value("VCOMPRESSPDZ128mr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ128mr)
  .value("VCOMPRESSPDZ128mrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ128mrk)
  .value("VCOMPRESSPDZ128rr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ128rr)
  .value("VCOMPRESSPDZ128rrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ128rrk)
  .value("VCOMPRESSPDZ128rrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ128rrkz)
  .value("VCOMPRESSPDZ256mr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ256mr)
  .value("VCOMPRESSPDZ256mrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ256mrk)
  .value("VCOMPRESSPDZ256rr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ256rr)
  .value("VCOMPRESSPDZ256rrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ256rrk)
  .value("VCOMPRESSPDZ256rrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZ256rrkz)
  .value("VCOMPRESSPDZmr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZmr)
  .value("VCOMPRESSPDZmrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZmrk)
  .value("VCOMPRESSPDZrr", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZrr)
  .value("VCOMPRESSPDZrrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZrrk)
  .value("VCOMPRESSPDZrrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPDZrrkz)
  .value("VCOMPRESSPSZ128mr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ128mr)
  .value("VCOMPRESSPSZ128mrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ128mrk)
  .value("VCOMPRESSPSZ128rr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ128rr)
  .value("VCOMPRESSPSZ128rrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ128rrk)
  .value("VCOMPRESSPSZ128rrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ128rrkz)
  .value("VCOMPRESSPSZ256mr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ256mr)
  .value("VCOMPRESSPSZ256mrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ256mrk)
  .value("VCOMPRESSPSZ256rr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ256rr)
  .value("VCOMPRESSPSZ256rrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ256rrk)
  .value("VCOMPRESSPSZ256rrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZ256rrkz)
  .value("VCOMPRESSPSZmr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZmr)
  .value("VCOMPRESSPSZmrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZmrk)
  .value("VCOMPRESSPSZrr", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZrr)
  .value("VCOMPRESSPSZrrk", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZrrk)
  .value("VCOMPRESSPSZrrkz", LIEF::assembly::x86::OPCODE::VCOMPRESSPSZrrkz)
  .value("VCOMXSDZrm_Int", LIEF::assembly::x86::OPCODE::VCOMXSDZrm_Int)
  .value("VCOMXSDZrr_Int", LIEF::assembly::x86::OPCODE::VCOMXSDZrr_Int)
  .value("VCOMXSDZrrb_Int", LIEF::assembly::x86::OPCODE::VCOMXSDZrrb_Int)
  .value("VCOMXSHZrm_Int", LIEF::assembly::x86::OPCODE::VCOMXSHZrm_Int)
  .value("VCOMXSHZrr_Int", LIEF::assembly::x86::OPCODE::VCOMXSHZrr_Int)
  .value("VCOMXSHZrrb_Int", LIEF::assembly::x86::OPCODE::VCOMXSHZrrb_Int)
  .value("VCOMXSSZrm_Int", LIEF::assembly::x86::OPCODE::VCOMXSSZrm_Int)
  .value("VCOMXSSZrr_Int", LIEF::assembly::x86::OPCODE::VCOMXSSZrr_Int)
  .value("VCOMXSSZrrb_Int", LIEF::assembly::x86::OPCODE::VCOMXSSZrrb_Int)
  .value("VCVT2PH2BF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rm)
  .value("VCVT2PH2BF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rmb)
  .value("VCVT2PH2BF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rmbk)
  .value("VCVT2PH2BF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rmbkz)
  .value("VCVT2PH2BF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rmk)
  .value("VCVT2PH2BF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rmkz)
  .value("VCVT2PH2BF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rr)
  .value("VCVT2PH2BF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rrk)
  .value("VCVT2PH2BF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ128rrkz)
  .value("VCVT2PH2BF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rm)
  .value("VCVT2PH2BF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rmb)
  .value("VCVT2PH2BF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rmbk)
  .value("VCVT2PH2BF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rmbkz)
  .value("VCVT2PH2BF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rmk)
  .value("VCVT2PH2BF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rmkz)
  .value("VCVT2PH2BF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rr)
  .value("VCVT2PH2BF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rrk)
  .value("VCVT2PH2BF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZ256rrkz)
  .value("VCVT2PH2BF8SZrm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrm)
  .value("VCVT2PH2BF8SZrmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrmb)
  .value("VCVT2PH2BF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrmbk)
  .value("VCVT2PH2BF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrmbkz)
  .value("VCVT2PH2BF8SZrmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrmk)
  .value("VCVT2PH2BF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrmkz)
  .value("VCVT2PH2BF8SZrr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrr)
  .value("VCVT2PH2BF8SZrrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrrk)
  .value("VCVT2PH2BF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8SZrrkz)
  .value("VCVT2PH2BF8Z128rm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rm)
  .value("VCVT2PH2BF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rmb)
  .value("VCVT2PH2BF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rmbk)
  .value("VCVT2PH2BF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rmbkz)
  .value("VCVT2PH2BF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rmk)
  .value("VCVT2PH2BF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rmkz)
  .value("VCVT2PH2BF8Z128rr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rr)
  .value("VCVT2PH2BF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rrk)
  .value("VCVT2PH2BF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z128rrkz)
  .value("VCVT2PH2BF8Z256rm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rm)
  .value("VCVT2PH2BF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rmb)
  .value("VCVT2PH2BF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rmbk)
  .value("VCVT2PH2BF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rmbkz)
  .value("VCVT2PH2BF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rmk)
  .value("VCVT2PH2BF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rmkz)
  .value("VCVT2PH2BF8Z256rr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rr)
  .value("VCVT2PH2BF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rrk)
  .value("VCVT2PH2BF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Z256rrkz)
  .value("VCVT2PH2BF8Zrm", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrm)
  .value("VCVT2PH2BF8Zrmb", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrmb)
  .value("VCVT2PH2BF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrmbk)
  .value("VCVT2PH2BF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrmbkz)
  .value("VCVT2PH2BF8Zrmk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrmk)
  .value("VCVT2PH2BF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrmkz)
  .value("VCVT2PH2BF8Zrr", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrr)
  .value("VCVT2PH2BF8Zrrk", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrrk)
  .value("VCVT2PH2BF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2BF8Zrrkz)
  .value("VCVT2PH2HF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rm)
  .value("VCVT2PH2HF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rmb)
  .value("VCVT2PH2HF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rmbk)
  .value("VCVT2PH2HF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rmbkz)
  .value("VCVT2PH2HF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rmk)
  .value("VCVT2PH2HF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rmkz)
  .value("VCVT2PH2HF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rr)
  .value("VCVT2PH2HF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rrk)
  .value("VCVT2PH2HF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ128rrkz)
  .value("VCVT2PH2HF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rm)
  .value("VCVT2PH2HF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rmb)
  .value("VCVT2PH2HF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rmbk)
  .value("VCVT2PH2HF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rmbkz)
  .value("VCVT2PH2HF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rmk)
  .value("VCVT2PH2HF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rmkz)
  .value("VCVT2PH2HF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rr)
  .value("VCVT2PH2HF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rrk)
  .value("VCVT2PH2HF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZ256rrkz)
  .value("VCVT2PH2HF8SZrm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrm)
  .value("VCVT2PH2HF8SZrmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrmb)
  .value("VCVT2PH2HF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrmbk)
  .value("VCVT2PH2HF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrmbkz)
  .value("VCVT2PH2HF8SZrmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrmk)
  .value("VCVT2PH2HF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrmkz)
  .value("VCVT2PH2HF8SZrr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrr)
  .value("VCVT2PH2HF8SZrrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrrk);
  opcodes.value("VCVT2PH2HF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8SZrrkz)
  .value("VCVT2PH2HF8Z128rm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rm)
  .value("VCVT2PH2HF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rmb)
  .value("VCVT2PH2HF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rmbk)
  .value("VCVT2PH2HF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rmbkz)
  .value("VCVT2PH2HF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rmk)
  .value("VCVT2PH2HF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rmkz)
  .value("VCVT2PH2HF8Z128rr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rr)
  .value("VCVT2PH2HF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rrk)
  .value("VCVT2PH2HF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z128rrkz)
  .value("VCVT2PH2HF8Z256rm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rm)
  .value("VCVT2PH2HF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rmb)
  .value("VCVT2PH2HF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rmbk)
  .value("VCVT2PH2HF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rmbkz)
  .value("VCVT2PH2HF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rmk)
  .value("VCVT2PH2HF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rmkz)
  .value("VCVT2PH2HF8Z256rr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rr)
  .value("VCVT2PH2HF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rrk)
  .value("VCVT2PH2HF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Z256rrkz)
  .value("VCVT2PH2HF8Zrm", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrm)
  .value("VCVT2PH2HF8Zrmb", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrmb)
  .value("VCVT2PH2HF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrmbk)
  .value("VCVT2PH2HF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrmbkz)
  .value("VCVT2PH2HF8Zrmk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrmk)
  .value("VCVT2PH2HF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrmkz)
  .value("VCVT2PH2HF8Zrr", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrr)
  .value("VCVT2PH2HF8Zrrk", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrrk)
  .value("VCVT2PH2HF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVT2PH2HF8Zrrkz)
  .value("VCVT2PS2PHXZ128rm", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rm)
  .value("VCVT2PS2PHXZ128rmb", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rmb)
  .value("VCVT2PS2PHXZ128rmbk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rmbk)
  .value("VCVT2PS2PHXZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rmbkz)
  .value("VCVT2PS2PHXZ128rmk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rmk)
  .value("VCVT2PS2PHXZ128rmkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rmkz)
  .value("VCVT2PS2PHXZ128rr", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rr)
  .value("VCVT2PS2PHXZ128rrk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rrk)
  .value("VCVT2PS2PHXZ128rrkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ128rrkz)
  .value("VCVT2PS2PHXZ256rm", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rm)
  .value("VCVT2PS2PHXZ256rmb", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rmb)
  .value("VCVT2PS2PHXZ256rmbk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rmbk)
  .value("VCVT2PS2PHXZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rmbkz)
  .value("VCVT2PS2PHXZ256rmk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rmk)
  .value("VCVT2PS2PHXZ256rmkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rmkz)
  .value("VCVT2PS2PHXZ256rr", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rr)
  .value("VCVT2PS2PHXZ256rrk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rrk)
  .value("VCVT2PS2PHXZ256rrkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZ256rrkz)
  .value("VCVT2PS2PHXZrm", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrm)
  .value("VCVT2PS2PHXZrmb", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrmb)
  .value("VCVT2PS2PHXZrmbk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrmbk)
  .value("VCVT2PS2PHXZrmbkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrmbkz)
  .value("VCVT2PS2PHXZrmk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrmk)
  .value("VCVT2PS2PHXZrmkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrmkz)
  .value("VCVT2PS2PHXZrr", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrr)
  .value("VCVT2PS2PHXZrrb", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrrb)
  .value("VCVT2PS2PHXZrrbk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrrbk)
  .value("VCVT2PS2PHXZrrbkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrrbkz)
  .value("VCVT2PS2PHXZrrk", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrrk)
  .value("VCVT2PS2PHXZrrkz", LIEF::assembly::x86::OPCODE::VCVT2PS2PHXZrrkz)
  .value("VCVTBF162IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rm)
  .value("VCVTBF162IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rmb)
  .value("VCVTBF162IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rmbk)
  .value("VCVTBF162IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rmbkz)
  .value("VCVTBF162IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rmk)
  .value("VCVTBF162IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rmkz)
  .value("VCVTBF162IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rr)
  .value("VCVTBF162IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rrk)
  .value("VCVTBF162IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ128rrkz)
  .value("VCVTBF162IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rm)
  .value("VCVTBF162IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rmb)
  .value("VCVTBF162IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rmbk)
  .value("VCVTBF162IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rmbkz)
  .value("VCVTBF162IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rmk)
  .value("VCVTBF162IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rmkz)
  .value("VCVTBF162IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rr)
  .value("VCVTBF162IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rrk)
  .value("VCVTBF162IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZ256rrkz)
  .value("VCVTBF162IBSZrm", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrm)
  .value("VCVTBF162IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrmb)
  .value("VCVTBF162IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrmbk)
  .value("VCVTBF162IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrmbkz)
  .value("VCVTBF162IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrmk)
  .value("VCVTBF162IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrmkz)
  .value("VCVTBF162IBSZrr", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrr)
  .value("VCVTBF162IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrrk)
  .value("VCVTBF162IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IBSZrrkz)
  .value("VCVTBF162IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rm)
  .value("VCVTBF162IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rmb)
  .value("VCVTBF162IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rmbk)
  .value("VCVTBF162IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rmbkz)
  .value("VCVTBF162IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rmk)
  .value("VCVTBF162IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rmkz)
  .value("VCVTBF162IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rr)
  .value("VCVTBF162IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rrk)
  .value("VCVTBF162IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ128rrkz)
  .value("VCVTBF162IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rm)
  .value("VCVTBF162IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rmb)
  .value("VCVTBF162IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rmbk)
  .value("VCVTBF162IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rmbkz)
  .value("VCVTBF162IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rmk)
  .value("VCVTBF162IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rmkz)
  .value("VCVTBF162IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rr)
  .value("VCVTBF162IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rrk)
  .value("VCVTBF162IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZ256rrkz)
  .value("VCVTBF162IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrm)
  .value("VCVTBF162IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrmb)
  .value("VCVTBF162IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrmbk)
  .value("VCVTBF162IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrmbkz)
  .value("VCVTBF162IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrmk)
  .value("VCVTBF162IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrmkz)
  .value("VCVTBF162IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrr)
  .value("VCVTBF162IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrrk)
  .value("VCVTBF162IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTBF162IUBSZrrkz)
  .value("VCVTBIASPH2BF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rm)
  .value("VCVTBIASPH2BF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rmb)
  .value("VCVTBIASPH2BF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rmbk)
  .value("VCVTBIASPH2BF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rmbkz)
  .value("VCVTBIASPH2BF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rmk)
  .value("VCVTBIASPH2BF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rmkz)
  .value("VCVTBIASPH2BF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rr)
  .value("VCVTBIASPH2BF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rrk)
  .value("VCVTBIASPH2BF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ128rrkz)
  .value("VCVTBIASPH2BF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rm)
  .value("VCVTBIASPH2BF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rmb)
  .value("VCVTBIASPH2BF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rmbk)
  .value("VCVTBIASPH2BF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rmbkz)
  .value("VCVTBIASPH2BF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rmk)
  .value("VCVTBIASPH2BF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rmkz)
  .value("VCVTBIASPH2BF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rr)
  .value("VCVTBIASPH2BF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rrk)
  .value("VCVTBIASPH2BF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZ256rrkz)
  .value("VCVTBIASPH2BF8SZrm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrm)
  .value("VCVTBIASPH2BF8SZrmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrmb)
  .value("VCVTBIASPH2BF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrmbk)
  .value("VCVTBIASPH2BF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrmbkz)
  .value("VCVTBIASPH2BF8SZrmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrmk)
  .value("VCVTBIASPH2BF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrmkz)
  .value("VCVTBIASPH2BF8SZrr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrr)
  .value("VCVTBIASPH2BF8SZrrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrrk)
  .value("VCVTBIASPH2BF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8SZrrkz)
  .value("VCVTBIASPH2BF8Z128rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rm)
  .value("VCVTBIASPH2BF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rmb)
  .value("VCVTBIASPH2BF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rmbk)
  .value("VCVTBIASPH2BF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rmbkz)
  .value("VCVTBIASPH2BF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rmk)
  .value("VCVTBIASPH2BF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rmkz)
  .value("VCVTBIASPH2BF8Z128rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rr)
  .value("VCVTBIASPH2BF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rrk)
  .value("VCVTBIASPH2BF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z128rrkz)
  .value("VCVTBIASPH2BF8Z256rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rm)
  .value("VCVTBIASPH2BF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rmb)
  .value("VCVTBIASPH2BF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rmbk)
  .value("VCVTBIASPH2BF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rmbkz)
  .value("VCVTBIASPH2BF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rmk)
  .value("VCVTBIASPH2BF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rmkz)
  .value("VCVTBIASPH2BF8Z256rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rr)
  .value("VCVTBIASPH2BF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rrk)
  .value("VCVTBIASPH2BF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Z256rrkz)
  .value("VCVTBIASPH2BF8Zrm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrm)
  .value("VCVTBIASPH2BF8Zrmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrmb)
  .value("VCVTBIASPH2BF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrmbk)
  .value("VCVTBIASPH2BF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrmbkz)
  .value("VCVTBIASPH2BF8Zrmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrmk)
  .value("VCVTBIASPH2BF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrmkz)
  .value("VCVTBIASPH2BF8Zrr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrr)
  .value("VCVTBIASPH2BF8Zrrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrrk)
  .value("VCVTBIASPH2BF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2BF8Zrrkz)
  .value("VCVTBIASPH2HF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rm)
  .value("VCVTBIASPH2HF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rmb)
  .value("VCVTBIASPH2HF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rmbk)
  .value("VCVTBIASPH2HF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rmbkz)
  .value("VCVTBIASPH2HF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rmk)
  .value("VCVTBIASPH2HF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rmkz)
  .value("VCVTBIASPH2HF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rr)
  .value("VCVTBIASPH2HF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rrk)
  .value("VCVTBIASPH2HF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ128rrkz)
  .value("VCVTBIASPH2HF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rm)
  .value("VCVTBIASPH2HF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rmb)
  .value("VCVTBIASPH2HF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rmbk)
  .value("VCVTBIASPH2HF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rmbkz)
  .value("VCVTBIASPH2HF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rmk)
  .value("VCVTBIASPH2HF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rmkz)
  .value("VCVTBIASPH2HF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rr)
  .value("VCVTBIASPH2HF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rrk)
  .value("VCVTBIASPH2HF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZ256rrkz)
  .value("VCVTBIASPH2HF8SZrm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrm)
  .value("VCVTBIASPH2HF8SZrmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrmb)
  .value("VCVTBIASPH2HF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrmbk)
  .value("VCVTBIASPH2HF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrmbkz)
  .value("VCVTBIASPH2HF8SZrmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrmk)
  .value("VCVTBIASPH2HF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrmkz)
  .value("VCVTBIASPH2HF8SZrr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrr)
  .value("VCVTBIASPH2HF8SZrrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrrk)
  .value("VCVTBIASPH2HF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8SZrrkz)
  .value("VCVTBIASPH2HF8Z128rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rm)
  .value("VCVTBIASPH2HF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rmb)
  .value("VCVTBIASPH2HF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rmbk)
  .value("VCVTBIASPH2HF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rmbkz)
  .value("VCVTBIASPH2HF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rmk)
  .value("VCVTBIASPH2HF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rmkz)
  .value("VCVTBIASPH2HF8Z128rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rr)
  .value("VCVTBIASPH2HF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rrk)
  .value("VCVTBIASPH2HF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z128rrkz)
  .value("VCVTBIASPH2HF8Z256rm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rm)
  .value("VCVTBIASPH2HF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rmb)
  .value("VCVTBIASPH2HF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rmbk)
  .value("VCVTBIASPH2HF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rmbkz)
  .value("VCVTBIASPH2HF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rmk)
  .value("VCVTBIASPH2HF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rmkz)
  .value("VCVTBIASPH2HF8Z256rr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rr)
  .value("VCVTBIASPH2HF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rrk)
  .value("VCVTBIASPH2HF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Z256rrkz)
  .value("VCVTBIASPH2HF8Zrm", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrm)
  .value("VCVTBIASPH2HF8Zrmb", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrmb)
  .value("VCVTBIASPH2HF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrmbk)
  .value("VCVTBIASPH2HF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrmbkz)
  .value("VCVTBIASPH2HF8Zrmk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrmk)
  .value("VCVTBIASPH2HF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrmkz)
  .value("VCVTBIASPH2HF8Zrr", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrr)
  .value("VCVTBIASPH2HF8Zrrk", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrrk)
  .value("VCVTBIASPH2HF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVTBIASPH2HF8Zrrkz)
  .value("VCVTDQ2PDYrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PDYrm)
  .value("VCVTDQ2PDYrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PDYrr)
  .value("VCVTDQ2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rm)
  .value("VCVTDQ2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rmb)
  .value("VCVTDQ2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rmbk)
  .value("VCVTDQ2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rmbkz)
  .value("VCVTDQ2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rmk)
  .value("VCVTDQ2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rmkz)
  .value("VCVTDQ2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rr)
  .value("VCVTDQ2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rrk)
  .value("VCVTDQ2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ128rrkz)
  .value("VCVTDQ2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rm)
  .value("VCVTDQ2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rmb)
  .value("VCVTDQ2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rmbk)
  .value("VCVTDQ2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rmbkz)
  .value("VCVTDQ2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rmk)
  .value("VCVTDQ2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rmkz)
  .value("VCVTDQ2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rr)
  .value("VCVTDQ2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rrk)
  .value("VCVTDQ2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZ256rrkz)
  .value("VCVTDQ2PDZrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrm)
  .value("VCVTDQ2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrmb)
  .value("VCVTDQ2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrmbk)
  .value("VCVTDQ2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrmbkz)
  .value("VCVTDQ2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrmk)
  .value("VCVTDQ2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrmkz)
  .value("VCVTDQ2PDZrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrr)
  .value("VCVTDQ2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrrk)
  .value("VCVTDQ2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PDZrrkz)
  .value("VCVTDQ2PDrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PDrm)
  .value("VCVTDQ2PDrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PDrr)
  .value("VCVTDQ2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rm)
  .value("VCVTDQ2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rmb)
  .value("VCVTDQ2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rmbk)
  .value("VCVTDQ2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rmbkz)
  .value("VCVTDQ2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rmk)
  .value("VCVTDQ2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rmkz)
  .value("VCVTDQ2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rr)
  .value("VCVTDQ2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rrk)
  .value("VCVTDQ2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ128rrkz)
  .value("VCVTDQ2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rm)
  .value("VCVTDQ2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rmb)
  .value("VCVTDQ2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rmbk)
  .value("VCVTDQ2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rmbkz)
  .value("VCVTDQ2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rmk)
  .value("VCVTDQ2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rmkz)
  .value("VCVTDQ2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rr)
  .value("VCVTDQ2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rrk)
  .value("VCVTDQ2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZ256rrkz)
  .value("VCVTDQ2PHZrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrm)
  .value("VCVTDQ2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrmb)
  .value("VCVTDQ2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrmbk)
  .value("VCVTDQ2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrmbkz)
  .value("VCVTDQ2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrmk)
  .value("VCVTDQ2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrmkz)
  .value("VCVTDQ2PHZrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrr)
  .value("VCVTDQ2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrrb)
  .value("VCVTDQ2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrrbk)
  .value("VCVTDQ2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrrbkz)
  .value("VCVTDQ2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrrk)
  .value("VCVTDQ2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PHZrrkz)
  .value("VCVTDQ2PSYrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PSYrm)
  .value("VCVTDQ2PSYrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PSYrr)
  .value("VCVTDQ2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rm)
  .value("VCVTDQ2PSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rmb)
  .value("VCVTDQ2PSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rmbk)
  .value("VCVTDQ2PSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rmbkz)
  .value("VCVTDQ2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rmk)
  .value("VCVTDQ2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rmkz)
  .value("VCVTDQ2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rr)
  .value("VCVTDQ2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rrk)
  .value("VCVTDQ2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ128rrkz)
  .value("VCVTDQ2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rm)
  .value("VCVTDQ2PSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rmb)
  .value("VCVTDQ2PSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rmbk)
  .value("VCVTDQ2PSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rmbkz)
  .value("VCVTDQ2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rmk)
  .value("VCVTDQ2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rmkz)
  .value("VCVTDQ2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rr)
  .value("VCVTDQ2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rrk);
  opcodes.value("VCVTDQ2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZ256rrkz)
  .value("VCVTDQ2PSZrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrm)
  .value("VCVTDQ2PSZrmb", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrmb)
  .value("VCVTDQ2PSZrmbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrmbk)
  .value("VCVTDQ2PSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrmbkz)
  .value("VCVTDQ2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrmk)
  .value("VCVTDQ2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrmkz)
  .value("VCVTDQ2PSZrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrr)
  .value("VCVTDQ2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrrb)
  .value("VCVTDQ2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrrbk)
  .value("VCVTDQ2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrrbkz)
  .value("VCVTDQ2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrrk)
  .value("VCVTDQ2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTDQ2PSZrrkz)
  .value("VCVTDQ2PSrm", LIEF::assembly::x86::OPCODE::VCVTDQ2PSrm)
  .value("VCVTDQ2PSrr", LIEF::assembly::x86::OPCODE::VCVTDQ2PSrr)
  .value("VCVTHF82PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rm)
  .value("VCVTHF82PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rmk)
  .value("VCVTHF82PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rmkz)
  .value("VCVTHF82PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rr)
  .value("VCVTHF82PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rrk)
  .value("VCVTHF82PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ128rrkz)
  .value("VCVTHF82PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rm)
  .value("VCVTHF82PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rmk)
  .value("VCVTHF82PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rmkz)
  .value("VCVTHF82PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rr)
  .value("VCVTHF82PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rrk)
  .value("VCVTHF82PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZ256rrkz)
  .value("VCVTHF82PHZrm", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrm)
  .value("VCVTHF82PHZrmk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrmk)
  .value("VCVTHF82PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrmkz)
  .value("VCVTHF82PHZrr", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrr)
  .value("VCVTHF82PHZrrk", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrrk)
  .value("VCVTHF82PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTHF82PHZrrkz)
  .value("VCVTNE2PS2BF16Z128rm", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rm)
  .value("VCVTNE2PS2BF16Z128rmb", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rmb)
  .value("VCVTNE2PS2BF16Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rmbk)
  .value("VCVTNE2PS2BF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rmbkz)
  .value("VCVTNE2PS2BF16Z128rmk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rmk)
  .value("VCVTNE2PS2BF16Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rmkz)
  .value("VCVTNE2PS2BF16Z128rr", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rr)
  .value("VCVTNE2PS2BF16Z128rrk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rrk)
  .value("VCVTNE2PS2BF16Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z128rrkz)
  .value("VCVTNE2PS2BF16Z256rm", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rm)
  .value("VCVTNE2PS2BF16Z256rmb", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rmb)
  .value("VCVTNE2PS2BF16Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rmbk)
  .value("VCVTNE2PS2BF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rmbkz)
  .value("VCVTNE2PS2BF16Z256rmk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rmk)
  .value("VCVTNE2PS2BF16Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rmkz)
  .value("VCVTNE2PS2BF16Z256rr", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rr)
  .value("VCVTNE2PS2BF16Z256rrk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rrk)
  .value("VCVTNE2PS2BF16Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Z256rrkz)
  .value("VCVTNE2PS2BF16Zrm", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrm)
  .value("VCVTNE2PS2BF16Zrmb", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrmb)
  .value("VCVTNE2PS2BF16Zrmbk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrmbk)
  .value("VCVTNE2PS2BF16Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrmbkz)
  .value("VCVTNE2PS2BF16Zrmk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrmk)
  .value("VCVTNE2PS2BF16Zrmkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrmkz)
  .value("VCVTNE2PS2BF16Zrr", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrr)
  .value("VCVTNE2PS2BF16Zrrk", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrrk)
  .value("VCVTNE2PS2BF16Zrrkz", LIEF::assembly::x86::OPCODE::VCVTNE2PS2BF16Zrrkz)
  .value("VCVTNEEBF162PSYrm", LIEF::assembly::x86::OPCODE::VCVTNEEBF162PSYrm)
  .value("VCVTNEEBF162PSrm", LIEF::assembly::x86::OPCODE::VCVTNEEBF162PSrm)
  .value("VCVTNEEPH2PSYrm", LIEF::assembly::x86::OPCODE::VCVTNEEPH2PSYrm)
  .value("VCVTNEEPH2PSrm", LIEF::assembly::x86::OPCODE::VCVTNEEPH2PSrm)
  .value("VCVTNEOBF162PSYrm", LIEF::assembly::x86::OPCODE::VCVTNEOBF162PSYrm)
  .value("VCVTNEOBF162PSrm", LIEF::assembly::x86::OPCODE::VCVTNEOBF162PSrm)
  .value("VCVTNEOPH2PSYrm", LIEF::assembly::x86::OPCODE::VCVTNEOPH2PSYrm)
  .value("VCVTNEOPH2PSrm", LIEF::assembly::x86::OPCODE::VCVTNEOPH2PSrm)
  .value("VCVTNEPS2BF16Yrm", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Yrm)
  .value("VCVTNEPS2BF16Yrr", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Yrr)
  .value("VCVTNEPS2BF16Z128rm", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rm)
  .value("VCVTNEPS2BF16Z128rmb", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rmb)
  .value("VCVTNEPS2BF16Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rmbk)
  .value("VCVTNEPS2BF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rmbkz)
  .value("VCVTNEPS2BF16Z128rmk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rmk)
  .value("VCVTNEPS2BF16Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rmkz)
  .value("VCVTNEPS2BF16Z128rr", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rr)
  .value("VCVTNEPS2BF16Z128rrk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rrk)
  .value("VCVTNEPS2BF16Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z128rrkz)
  .value("VCVTNEPS2BF16Z256rm", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rm)
  .value("VCVTNEPS2BF16Z256rmb", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rmb)
  .value("VCVTNEPS2BF16Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rmbk)
  .value("VCVTNEPS2BF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rmbkz)
  .value("VCVTNEPS2BF16Z256rmk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rmk)
  .value("VCVTNEPS2BF16Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rmkz)
  .value("VCVTNEPS2BF16Z256rr", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rr)
  .value("VCVTNEPS2BF16Z256rrk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rrk)
  .value("VCVTNEPS2BF16Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Z256rrkz)
  .value("VCVTNEPS2BF16Zrm", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrm)
  .value("VCVTNEPS2BF16Zrmb", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrmb)
  .value("VCVTNEPS2BF16Zrmbk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrmbk)
  .value("VCVTNEPS2BF16Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrmbkz)
  .value("VCVTNEPS2BF16Zrmk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrmk)
  .value("VCVTNEPS2BF16Zrmkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrmkz)
  .value("VCVTNEPS2BF16Zrr", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrr)
  .value("VCVTNEPS2BF16Zrrk", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrrk)
  .value("VCVTNEPS2BF16Zrrkz", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16Zrrkz)
  .value("VCVTNEPS2BF16rm", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16rm)
  .value("VCVTNEPS2BF16rr", LIEF::assembly::x86::OPCODE::VCVTNEPS2BF16rr)
  .value("VCVTPD2DQYrm", LIEF::assembly::x86::OPCODE::VCVTPD2DQYrm)
  .value("VCVTPD2DQYrr", LIEF::assembly::x86::OPCODE::VCVTPD2DQYrr)
  .value("VCVTPD2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rm)
  .value("VCVTPD2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rmb)
  .value("VCVTPD2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rmbk)
  .value("VCVTPD2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rmbkz)
  .value("VCVTPD2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rmk)
  .value("VCVTPD2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rmkz)
  .value("VCVTPD2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rr)
  .value("VCVTPD2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rrk)
  .value("VCVTPD2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ128rrkz)
  .value("VCVTPD2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rm)
  .value("VCVTPD2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rmb)
  .value("VCVTPD2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rmbk)
  .value("VCVTPD2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rmbkz)
  .value("VCVTPD2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rmk)
  .value("VCVTPD2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rmkz)
  .value("VCVTPD2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rr)
  .value("VCVTPD2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rrk)
  .value("VCVTPD2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZ256rrkz)
  .value("VCVTPD2DQZrm", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrm)
  .value("VCVTPD2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrmb)
  .value("VCVTPD2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrmbk)
  .value("VCVTPD2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrmbkz)
  .value("VCVTPD2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrmk)
  .value("VCVTPD2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrmkz)
  .value("VCVTPD2DQZrr", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrr)
  .value("VCVTPD2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrrb)
  .value("VCVTPD2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrrbk)
  .value("VCVTPD2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrrbkz)
  .value("VCVTPD2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrrk)
  .value("VCVTPD2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2DQZrrkz)
  .value("VCVTPD2DQrm", LIEF::assembly::x86::OPCODE::VCVTPD2DQrm)
  .value("VCVTPD2DQrr", LIEF::assembly::x86::OPCODE::VCVTPD2DQrr)
  .value("VCVTPD2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rm)
  .value("VCVTPD2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rmb)
  .value("VCVTPD2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rmbk)
  .value("VCVTPD2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rmbkz)
  .value("VCVTPD2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rmk)
  .value("VCVTPD2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rmkz)
  .value("VCVTPD2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rr)
  .value("VCVTPD2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rrk)
  .value("VCVTPD2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ128rrkz)
  .value("VCVTPD2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rm)
  .value("VCVTPD2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rmb)
  .value("VCVTPD2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rmbk)
  .value("VCVTPD2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rmbkz)
  .value("VCVTPD2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rmk)
  .value("VCVTPD2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rmkz)
  .value("VCVTPD2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rr)
  .value("VCVTPD2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rrk)
  .value("VCVTPD2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZ256rrkz)
  .value("VCVTPD2PHZrm", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrm)
  .value("VCVTPD2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrmb)
  .value("VCVTPD2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrmbk)
  .value("VCVTPD2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrmbkz)
  .value("VCVTPD2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrmk)
  .value("VCVTPD2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrmkz)
  .value("VCVTPD2PHZrr", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrr)
  .value("VCVTPD2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrrb)
  .value("VCVTPD2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrrbk)
  .value("VCVTPD2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrrbkz)
  .value("VCVTPD2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrrk)
  .value("VCVTPD2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PHZrrkz)
  .value("VCVTPD2PSYrm", LIEF::assembly::x86::OPCODE::VCVTPD2PSYrm)
  .value("VCVTPD2PSYrr", LIEF::assembly::x86::OPCODE::VCVTPD2PSYrr)
  .value("VCVTPD2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rm)
  .value("VCVTPD2PSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rmb)
  .value("VCVTPD2PSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rmbk)
  .value("VCVTPD2PSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rmbkz)
  .value("VCVTPD2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rmk)
  .value("VCVTPD2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rmkz)
  .value("VCVTPD2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rr)
  .value("VCVTPD2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rrk)
  .value("VCVTPD2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ128rrkz)
  .value("VCVTPD2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rm)
  .value("VCVTPD2PSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rmb)
  .value("VCVTPD2PSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rmbk)
  .value("VCVTPD2PSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rmbkz)
  .value("VCVTPD2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rmk)
  .value("VCVTPD2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rmkz)
  .value("VCVTPD2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rr)
  .value("VCVTPD2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rrk)
  .value("VCVTPD2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZ256rrkz)
  .value("VCVTPD2PSZrm", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrm)
  .value("VCVTPD2PSZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrmb)
  .value("VCVTPD2PSZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrmbk)
  .value("VCVTPD2PSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrmbkz)
  .value("VCVTPD2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrmk)
  .value("VCVTPD2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrmkz)
  .value("VCVTPD2PSZrr", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrr)
  .value("VCVTPD2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrrb)
  .value("VCVTPD2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrrbk)
  .value("VCVTPD2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrrbkz)
  .value("VCVTPD2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrrk)
  .value("VCVTPD2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2PSZrrkz)
  .value("VCVTPD2PSrm", LIEF::assembly::x86::OPCODE::VCVTPD2PSrm)
  .value("VCVTPD2PSrr", LIEF::assembly::x86::OPCODE::VCVTPD2PSrr)
  .value("VCVTPD2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rm)
  .value("VCVTPD2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rmb)
  .value("VCVTPD2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rmbk)
  .value("VCVTPD2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rmbkz)
  .value("VCVTPD2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rmk)
  .value("VCVTPD2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rmkz)
  .value("VCVTPD2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rr)
  .value("VCVTPD2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rrk)
  .value("VCVTPD2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ128rrkz)
  .value("VCVTPD2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rm)
  .value("VCVTPD2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rmb)
  .value("VCVTPD2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rmbk)
  .value("VCVTPD2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rmbkz)
  .value("VCVTPD2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rmk)
  .value("VCVTPD2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rmkz)
  .value("VCVTPD2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rr)
  .value("VCVTPD2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rrk)
  .value("VCVTPD2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZ256rrkz)
  .value("VCVTPD2QQZrm", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrm)
  .value("VCVTPD2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrmb)
  .value("VCVTPD2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrmbk)
  .value("VCVTPD2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrmbkz)
  .value("VCVTPD2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrmk)
  .value("VCVTPD2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrmkz)
  .value("VCVTPD2QQZrr", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrr)
  .value("VCVTPD2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrrb)
  .value("VCVTPD2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrrbk)
  .value("VCVTPD2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrrbkz)
  .value("VCVTPD2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrrk)
  .value("VCVTPD2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2QQZrrkz)
  .value("VCVTPD2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rm)
  .value("VCVTPD2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rmb)
  .value("VCVTPD2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rmbk)
  .value("VCVTPD2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rmbkz)
  .value("VCVTPD2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rmk)
  .value("VCVTPD2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rmkz)
  .value("VCVTPD2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rr)
  .value("VCVTPD2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rrk)
  .value("VCVTPD2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ128rrkz)
  .value("VCVTPD2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rm)
  .value("VCVTPD2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rmb)
  .value("VCVTPD2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rmbk)
  .value("VCVTPD2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rmbkz)
  .value("VCVTPD2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rmk)
  .value("VCVTPD2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rmkz)
  .value("VCVTPD2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rr)
  .value("VCVTPD2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rrk)
  .value("VCVTPD2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZ256rrkz)
  .value("VCVTPD2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrm)
  .value("VCVTPD2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrmb)
  .value("VCVTPD2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrmbk)
  .value("VCVTPD2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrmbkz)
  .value("VCVTPD2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrmk)
  .value("VCVTPD2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrmkz)
  .value("VCVTPD2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrr)
  .value("VCVTPD2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrrb)
  .value("VCVTPD2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrrbk)
  .value("VCVTPD2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrrbkz)
  .value("VCVTPD2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrrk)
  .value("VCVTPD2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UDQZrrkz)
  .value("VCVTPD2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rm)
  .value("VCVTPD2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rmb)
  .value("VCVTPD2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rmbk)
  .value("VCVTPD2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rmbkz)
  .value("VCVTPD2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rmk)
  .value("VCVTPD2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rmkz)
  .value("VCVTPD2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rr)
  .value("VCVTPD2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rrk)
  .value("VCVTPD2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ128rrkz)
  .value("VCVTPD2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rm)
  .value("VCVTPD2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rmb)
  .value("VCVTPD2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rmbk)
  .value("VCVTPD2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rmbkz)
  .value("VCVTPD2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rmk)
  .value("VCVTPD2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rmkz)
  .value("VCVTPD2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rr)
  .value("VCVTPD2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rrk)
  .value("VCVTPD2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZ256rrkz)
  .value("VCVTPD2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrm)
  .value("VCVTPD2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrmb)
  .value("VCVTPD2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrmbk)
  .value("VCVTPD2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrmbkz)
  .value("VCVTPD2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrmk)
  .value("VCVTPD2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrmkz)
  .value("VCVTPD2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrr)
  .value("VCVTPD2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrrb)
  .value("VCVTPD2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrrbk)
  .value("VCVTPD2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrrbkz)
  .value("VCVTPD2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrrk)
  .value("VCVTPD2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPD2UQQZrrkz)
  .value("VCVTPH2BF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rm)
  .value("VCVTPH2BF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rmb)
  .value("VCVTPH2BF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rmbk)
  .value("VCVTPH2BF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rmbkz)
  .value("VCVTPH2BF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rmk)
  .value("VCVTPH2BF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rmkz)
  .value("VCVTPH2BF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rr)
  .value("VCVTPH2BF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rrk)
  .value("VCVTPH2BF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ128rrkz)
  .value("VCVTPH2BF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rm)
  .value("VCVTPH2BF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rmb)
  .value("VCVTPH2BF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rmbk)
  .value("VCVTPH2BF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rmbkz);
  opcodes.value("VCVTPH2BF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rmk)
  .value("VCVTPH2BF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rmkz)
  .value("VCVTPH2BF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rr)
  .value("VCVTPH2BF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rrk)
  .value("VCVTPH2BF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZ256rrkz)
  .value("VCVTPH2BF8SZrm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrm)
  .value("VCVTPH2BF8SZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrmb)
  .value("VCVTPH2BF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrmbk)
  .value("VCVTPH2BF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrmbkz)
  .value("VCVTPH2BF8SZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrmk)
  .value("VCVTPH2BF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrmkz)
  .value("VCVTPH2BF8SZrr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrr)
  .value("VCVTPH2BF8SZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrrk)
  .value("VCVTPH2BF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8SZrrkz)
  .value("VCVTPH2BF8Z128rm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rm)
  .value("VCVTPH2BF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rmb)
  .value("VCVTPH2BF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rmbk)
  .value("VCVTPH2BF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rmbkz)
  .value("VCVTPH2BF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rmk)
  .value("VCVTPH2BF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rmkz)
  .value("VCVTPH2BF8Z128rr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rr)
  .value("VCVTPH2BF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rrk)
  .value("VCVTPH2BF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z128rrkz)
  .value("VCVTPH2BF8Z256rm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rm)
  .value("VCVTPH2BF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rmb)
  .value("VCVTPH2BF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rmbk)
  .value("VCVTPH2BF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rmbkz)
  .value("VCVTPH2BF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rmk)
  .value("VCVTPH2BF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rmkz)
  .value("VCVTPH2BF8Z256rr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rr)
  .value("VCVTPH2BF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rrk)
  .value("VCVTPH2BF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Z256rrkz)
  .value("VCVTPH2BF8Zrm", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrm)
  .value("VCVTPH2BF8Zrmb", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrmb)
  .value("VCVTPH2BF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrmbk)
  .value("VCVTPH2BF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrmbkz)
  .value("VCVTPH2BF8Zrmk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrmk)
  .value("VCVTPH2BF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrmkz)
  .value("VCVTPH2BF8Zrr", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrr)
  .value("VCVTPH2BF8Zrrk", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrrk)
  .value("VCVTPH2BF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2BF8Zrrkz)
  .value("VCVTPH2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rm)
  .value("VCVTPH2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rmb)
  .value("VCVTPH2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rmbk)
  .value("VCVTPH2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rmbkz)
  .value("VCVTPH2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rmk)
  .value("VCVTPH2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rmkz)
  .value("VCVTPH2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rr)
  .value("VCVTPH2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rrk)
  .value("VCVTPH2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ128rrkz)
  .value("VCVTPH2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rm)
  .value("VCVTPH2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rmb)
  .value("VCVTPH2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rmbk)
  .value("VCVTPH2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rmbkz)
  .value("VCVTPH2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rmk)
  .value("VCVTPH2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rmkz)
  .value("VCVTPH2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rr)
  .value("VCVTPH2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rrk)
  .value("VCVTPH2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZ256rrkz)
  .value("VCVTPH2DQZrm", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrm)
  .value("VCVTPH2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrmb)
  .value("VCVTPH2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrmbk)
  .value("VCVTPH2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrmbkz)
  .value("VCVTPH2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrmk)
  .value("VCVTPH2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrmkz)
  .value("VCVTPH2DQZrr", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrr)
  .value("VCVTPH2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrrb)
  .value("VCVTPH2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrrbk)
  .value("VCVTPH2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrrbkz)
  .value("VCVTPH2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrrk)
  .value("VCVTPH2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2DQZrrkz)
  .value("VCVTPH2HF8SZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rm)
  .value("VCVTPH2HF8SZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rmb)
  .value("VCVTPH2HF8SZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rmbk)
  .value("VCVTPH2HF8SZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rmbkz)
  .value("VCVTPH2HF8SZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rmk)
  .value("VCVTPH2HF8SZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rmkz)
  .value("VCVTPH2HF8SZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rr)
  .value("VCVTPH2HF8SZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rrk)
  .value("VCVTPH2HF8SZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ128rrkz)
  .value("VCVTPH2HF8SZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rm)
  .value("VCVTPH2HF8SZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rmb)
  .value("VCVTPH2HF8SZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rmbk)
  .value("VCVTPH2HF8SZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rmbkz)
  .value("VCVTPH2HF8SZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rmk)
  .value("VCVTPH2HF8SZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rmkz)
  .value("VCVTPH2HF8SZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rr)
  .value("VCVTPH2HF8SZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rrk)
  .value("VCVTPH2HF8SZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZ256rrkz)
  .value("VCVTPH2HF8SZrm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrm)
  .value("VCVTPH2HF8SZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrmb)
  .value("VCVTPH2HF8SZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrmbk)
  .value("VCVTPH2HF8SZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrmbkz)
  .value("VCVTPH2HF8SZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrmk)
  .value("VCVTPH2HF8SZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrmkz)
  .value("VCVTPH2HF8SZrr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrr)
  .value("VCVTPH2HF8SZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrrk)
  .value("VCVTPH2HF8SZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8SZrrkz)
  .value("VCVTPH2HF8Z128rm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rm)
  .value("VCVTPH2HF8Z128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rmb)
  .value("VCVTPH2HF8Z128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rmbk)
  .value("VCVTPH2HF8Z128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rmbkz)
  .value("VCVTPH2HF8Z128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rmk)
  .value("VCVTPH2HF8Z128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rmkz)
  .value("VCVTPH2HF8Z128rr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rr)
  .value("VCVTPH2HF8Z128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rrk)
  .value("VCVTPH2HF8Z128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z128rrkz)
  .value("VCVTPH2HF8Z256rm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rm)
  .value("VCVTPH2HF8Z256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rmb)
  .value("VCVTPH2HF8Z256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rmbk)
  .value("VCVTPH2HF8Z256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rmbkz)
  .value("VCVTPH2HF8Z256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rmk)
  .value("VCVTPH2HF8Z256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rmkz)
  .value("VCVTPH2HF8Z256rr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rr)
  .value("VCVTPH2HF8Z256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rrk)
  .value("VCVTPH2HF8Z256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Z256rrkz)
  .value("VCVTPH2HF8Zrm", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrm)
  .value("VCVTPH2HF8Zrmb", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrmb)
  .value("VCVTPH2HF8Zrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrmbk)
  .value("VCVTPH2HF8Zrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrmbkz)
  .value("VCVTPH2HF8Zrmk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrmk)
  .value("VCVTPH2HF8Zrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrmkz)
  .value("VCVTPH2HF8Zrr", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrr)
  .value("VCVTPH2HF8Zrrk", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrrk)
  .value("VCVTPH2HF8Zrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2HF8Zrrkz)
  .value("VCVTPH2IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rm)
  .value("VCVTPH2IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rmb)
  .value("VCVTPH2IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rmbk)
  .value("VCVTPH2IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rmbkz)
  .value("VCVTPH2IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rmk)
  .value("VCVTPH2IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rmkz)
  .value("VCVTPH2IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rr)
  .value("VCVTPH2IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rrk)
  .value("VCVTPH2IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ128rrkz)
  .value("VCVTPH2IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rm)
  .value("VCVTPH2IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rmb)
  .value("VCVTPH2IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rmbk)
  .value("VCVTPH2IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rmbkz)
  .value("VCVTPH2IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rmk)
  .value("VCVTPH2IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rmkz)
  .value("VCVTPH2IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rr)
  .value("VCVTPH2IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rrk)
  .value("VCVTPH2IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZ256rrkz)
  .value("VCVTPH2IBSZrm", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrm)
  .value("VCVTPH2IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrmb)
  .value("VCVTPH2IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrmbk)
  .value("VCVTPH2IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrmbkz)
  .value("VCVTPH2IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrmk)
  .value("VCVTPH2IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrmkz)
  .value("VCVTPH2IBSZrr", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrr)
  .value("VCVTPH2IBSZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrrb)
  .value("VCVTPH2IBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrrbk)
  .value("VCVTPH2IBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrrbkz)
  .value("VCVTPH2IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrrk)
  .value("VCVTPH2IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IBSZrrkz)
  .value("VCVTPH2IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rm)
  .value("VCVTPH2IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rmb)
  .value("VCVTPH2IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rmbk)
  .value("VCVTPH2IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rmbkz)
  .value("VCVTPH2IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rmk)
  .value("VCVTPH2IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rmkz)
  .value("VCVTPH2IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rr)
  .value("VCVTPH2IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rrk)
  .value("VCVTPH2IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ128rrkz)
  .value("VCVTPH2IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rm)
  .value("VCVTPH2IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rmb)
  .value("VCVTPH2IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rmbk)
  .value("VCVTPH2IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rmbkz)
  .value("VCVTPH2IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rmk)
  .value("VCVTPH2IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rmkz)
  .value("VCVTPH2IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rr)
  .value("VCVTPH2IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rrk)
  .value("VCVTPH2IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZ256rrkz)
  .value("VCVTPH2IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrm)
  .value("VCVTPH2IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrmb)
  .value("VCVTPH2IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrmbk)
  .value("VCVTPH2IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrmbkz)
  .value("VCVTPH2IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrmk)
  .value("VCVTPH2IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrmkz)
  .value("VCVTPH2IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrr)
  .value("VCVTPH2IUBSZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrrb)
  .value("VCVTPH2IUBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrrbk)
  .value("VCVTPH2IUBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrrbkz)
  .value("VCVTPH2IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrrk)
  .value("VCVTPH2IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2IUBSZrrkz)
  .value("VCVTPH2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rm)
  .value("VCVTPH2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rmb)
  .value("VCVTPH2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rmbk)
  .value("VCVTPH2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rmbkz)
  .value("VCVTPH2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rmk)
  .value("VCVTPH2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rmkz)
  .value("VCVTPH2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rr)
  .value("VCVTPH2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rrk)
  .value("VCVTPH2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ128rrkz)
  .value("VCVTPH2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rm)
  .value("VCVTPH2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rmb)
  .value("VCVTPH2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rmbk)
  .value("VCVTPH2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rmbkz)
  .value("VCVTPH2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rmk)
  .value("VCVTPH2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rmkz)
  .value("VCVTPH2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rr)
  .value("VCVTPH2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rrk)
  .value("VCVTPH2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZ256rrkz)
  .value("VCVTPH2PDZrm", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrm)
  .value("VCVTPH2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrmb)
  .value("VCVTPH2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrmbk)
  .value("VCVTPH2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrmbkz)
  .value("VCVTPH2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrmk)
  .value("VCVTPH2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrmkz)
  .value("VCVTPH2PDZrr", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrr)
  .value("VCVTPH2PDZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrrb)
  .value("VCVTPH2PDZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrrbk)
  .value("VCVTPH2PDZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrrbkz)
  .value("VCVTPH2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrrk)
  .value("VCVTPH2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PDZrrkz)
  .value("VCVTPH2PSXZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rm)
  .value("VCVTPH2PSXZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rmb)
  .value("VCVTPH2PSXZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rmbk)
  .value("VCVTPH2PSXZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rmbkz)
  .value("VCVTPH2PSXZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rmk)
  .value("VCVTPH2PSXZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rmkz)
  .value("VCVTPH2PSXZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rr)
  .value("VCVTPH2PSXZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rrk)
  .value("VCVTPH2PSXZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ128rrkz)
  .value("VCVTPH2PSXZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rm)
  .value("VCVTPH2PSXZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rmb)
  .value("VCVTPH2PSXZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rmbk)
  .value("VCVTPH2PSXZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rmbkz)
  .value("VCVTPH2PSXZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rmk)
  .value("VCVTPH2PSXZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rmkz)
  .value("VCVTPH2PSXZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rr)
  .value("VCVTPH2PSXZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rrk)
  .value("VCVTPH2PSXZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZ256rrkz)
  .value("VCVTPH2PSXZrm", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrm)
  .value("VCVTPH2PSXZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrmb)
  .value("VCVTPH2PSXZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrmbk)
  .value("VCVTPH2PSXZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrmbkz)
  .value("VCVTPH2PSXZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrmk)
  .value("VCVTPH2PSXZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrmkz)
  .value("VCVTPH2PSXZrr", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrr)
  .value("VCVTPH2PSXZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrrb)
  .value("VCVTPH2PSXZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrrbk)
  .value("VCVTPH2PSXZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrrbkz)
  .value("VCVTPH2PSXZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrrk)
  .value("VCVTPH2PSXZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSXZrrkz)
  .value("VCVTPH2PSYrm", LIEF::assembly::x86::OPCODE::VCVTPH2PSYrm)
  .value("VCVTPH2PSYrr", LIEF::assembly::x86::OPCODE::VCVTPH2PSYrr)
  .value("VCVTPH2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rm)
  .value("VCVTPH2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rmk)
  .value("VCVTPH2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rmkz)
  .value("VCVTPH2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rr)
  .value("VCVTPH2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rrk)
  .value("VCVTPH2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ128rrkz)
  .value("VCVTPH2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rm)
  .value("VCVTPH2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rmk)
  .value("VCVTPH2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rmkz)
  .value("VCVTPH2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rr)
  .value("VCVTPH2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rrk)
  .value("VCVTPH2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZ256rrkz)
  .value("VCVTPH2PSZrm", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrm)
  .value("VCVTPH2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrmk)
  .value("VCVTPH2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrmkz)
  .value("VCVTPH2PSZrr", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrr)
  .value("VCVTPH2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrrb)
  .value("VCVTPH2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrrbk)
  .value("VCVTPH2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrrbkz)
  .value("VCVTPH2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrrk)
  .value("VCVTPH2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2PSZrrkz)
  .value("VCVTPH2PSrm", LIEF::assembly::x86::OPCODE::VCVTPH2PSrm)
  .value("VCVTPH2PSrr", LIEF::assembly::x86::OPCODE::VCVTPH2PSrr)
  .value("VCVTPH2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rm)
  .value("VCVTPH2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rmb)
  .value("VCVTPH2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rmbk)
  .value("VCVTPH2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rmbkz)
  .value("VCVTPH2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rmk)
  .value("VCVTPH2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rmkz)
  .value("VCVTPH2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rr)
  .value("VCVTPH2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rrk)
  .value("VCVTPH2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ128rrkz)
  .value("VCVTPH2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rm)
  .value("VCVTPH2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rmb)
  .value("VCVTPH2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rmbk)
  .value("VCVTPH2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rmbkz)
  .value("VCVTPH2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rmk)
  .value("VCVTPH2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rmkz)
  .value("VCVTPH2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rr)
  .value("VCVTPH2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rrk)
  .value("VCVTPH2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZ256rrkz)
  .value("VCVTPH2QQZrm", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrm)
  .value("VCVTPH2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrmb)
  .value("VCVTPH2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrmbk)
  .value("VCVTPH2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrmbkz)
  .value("VCVTPH2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrmk)
  .value("VCVTPH2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrmkz)
  .value("VCVTPH2QQZrr", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrr)
  .value("VCVTPH2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrrb)
  .value("VCVTPH2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrrbk)
  .value("VCVTPH2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrrbkz)
  .value("VCVTPH2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrrk)
  .value("VCVTPH2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2QQZrrkz);
  opcodes.value("VCVTPH2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rm)
  .value("VCVTPH2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rmb)
  .value("VCVTPH2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rmbk)
  .value("VCVTPH2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rmbkz)
  .value("VCVTPH2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rmk)
  .value("VCVTPH2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rmkz)
  .value("VCVTPH2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rr)
  .value("VCVTPH2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rrk)
  .value("VCVTPH2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ128rrkz)
  .value("VCVTPH2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rm)
  .value("VCVTPH2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rmb)
  .value("VCVTPH2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rmbk)
  .value("VCVTPH2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rmbkz)
  .value("VCVTPH2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rmk)
  .value("VCVTPH2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rmkz)
  .value("VCVTPH2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rr)
  .value("VCVTPH2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rrk)
  .value("VCVTPH2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZ256rrkz)
  .value("VCVTPH2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrm)
  .value("VCVTPH2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrmb)
  .value("VCVTPH2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrmbk)
  .value("VCVTPH2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrmbkz)
  .value("VCVTPH2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrmk)
  .value("VCVTPH2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrmkz)
  .value("VCVTPH2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrr)
  .value("VCVTPH2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrrb)
  .value("VCVTPH2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrrbk)
  .value("VCVTPH2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrrbkz)
  .value("VCVTPH2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrrk)
  .value("VCVTPH2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UDQZrrkz)
  .value("VCVTPH2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rm)
  .value("VCVTPH2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rmb)
  .value("VCVTPH2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rmbk)
  .value("VCVTPH2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rmbkz)
  .value("VCVTPH2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rmk)
  .value("VCVTPH2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rmkz)
  .value("VCVTPH2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rr)
  .value("VCVTPH2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rrk)
  .value("VCVTPH2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ128rrkz)
  .value("VCVTPH2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rm)
  .value("VCVTPH2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rmb)
  .value("VCVTPH2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rmbk)
  .value("VCVTPH2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rmbkz)
  .value("VCVTPH2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rmk)
  .value("VCVTPH2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rmkz)
  .value("VCVTPH2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rr)
  .value("VCVTPH2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rrk)
  .value("VCVTPH2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZ256rrkz)
  .value("VCVTPH2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrm)
  .value("VCVTPH2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrmb)
  .value("VCVTPH2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrmbk)
  .value("VCVTPH2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrmbkz)
  .value("VCVTPH2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrmk)
  .value("VCVTPH2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrmkz)
  .value("VCVTPH2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrr)
  .value("VCVTPH2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrrb)
  .value("VCVTPH2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrrbk)
  .value("VCVTPH2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrrbkz)
  .value("VCVTPH2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrrk)
  .value("VCVTPH2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UQQZrrkz)
  .value("VCVTPH2UWZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rm)
  .value("VCVTPH2UWZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rmb)
  .value("VCVTPH2UWZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rmbk)
  .value("VCVTPH2UWZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rmbkz)
  .value("VCVTPH2UWZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rmk)
  .value("VCVTPH2UWZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rmkz)
  .value("VCVTPH2UWZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rr)
  .value("VCVTPH2UWZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rrk)
  .value("VCVTPH2UWZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ128rrkz)
  .value("VCVTPH2UWZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rm)
  .value("VCVTPH2UWZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rmb)
  .value("VCVTPH2UWZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rmbk)
  .value("VCVTPH2UWZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rmbkz)
  .value("VCVTPH2UWZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rmk)
  .value("VCVTPH2UWZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rmkz)
  .value("VCVTPH2UWZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rr)
  .value("VCVTPH2UWZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rrk)
  .value("VCVTPH2UWZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZ256rrkz)
  .value("VCVTPH2UWZrm", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrm)
  .value("VCVTPH2UWZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrmb)
  .value("VCVTPH2UWZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrmbk)
  .value("VCVTPH2UWZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrmbkz)
  .value("VCVTPH2UWZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrmk)
  .value("VCVTPH2UWZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrmkz)
  .value("VCVTPH2UWZrr", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrr)
  .value("VCVTPH2UWZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrrb)
  .value("VCVTPH2UWZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrrbk)
  .value("VCVTPH2UWZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrrbkz)
  .value("VCVTPH2UWZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrrk)
  .value("VCVTPH2UWZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2UWZrrkz)
  .value("VCVTPH2WZ128rm", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rm)
  .value("VCVTPH2WZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rmb)
  .value("VCVTPH2WZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rmbk)
  .value("VCVTPH2WZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rmbkz)
  .value("VCVTPH2WZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rmk)
  .value("VCVTPH2WZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rmkz)
  .value("VCVTPH2WZ128rr", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rr)
  .value("VCVTPH2WZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rrk)
  .value("VCVTPH2WZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ128rrkz)
  .value("VCVTPH2WZ256rm", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rm)
  .value("VCVTPH2WZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rmb)
  .value("VCVTPH2WZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rmbk)
  .value("VCVTPH2WZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rmbkz)
  .value("VCVTPH2WZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rmk)
  .value("VCVTPH2WZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rmkz)
  .value("VCVTPH2WZ256rr", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rr)
  .value("VCVTPH2WZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rrk)
  .value("VCVTPH2WZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZ256rrkz)
  .value("VCVTPH2WZrm", LIEF::assembly::x86::OPCODE::VCVTPH2WZrm)
  .value("VCVTPH2WZrmb", LIEF::assembly::x86::OPCODE::VCVTPH2WZrmb)
  .value("VCVTPH2WZrmbk", LIEF::assembly::x86::OPCODE::VCVTPH2WZrmbk)
  .value("VCVTPH2WZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZrmbkz)
  .value("VCVTPH2WZrmk", LIEF::assembly::x86::OPCODE::VCVTPH2WZrmk)
  .value("VCVTPH2WZrmkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZrmkz)
  .value("VCVTPH2WZrr", LIEF::assembly::x86::OPCODE::VCVTPH2WZrr)
  .value("VCVTPH2WZrrb", LIEF::assembly::x86::OPCODE::VCVTPH2WZrrb)
  .value("VCVTPH2WZrrbk", LIEF::assembly::x86::OPCODE::VCVTPH2WZrrbk)
  .value("VCVTPH2WZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZrrbkz)
  .value("VCVTPH2WZrrk", LIEF::assembly::x86::OPCODE::VCVTPH2WZrrk)
  .value("VCVTPH2WZrrkz", LIEF::assembly::x86::OPCODE::VCVTPH2WZrrkz)
  .value("VCVTPS2DQYrm", LIEF::assembly::x86::OPCODE::VCVTPS2DQYrm)
  .value("VCVTPS2DQYrr", LIEF::assembly::x86::OPCODE::VCVTPS2DQYrr)
  .value("VCVTPS2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rm)
  .value("VCVTPS2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rmb)
  .value("VCVTPS2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rmbk)
  .value("VCVTPS2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rmbkz)
  .value("VCVTPS2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rmk)
  .value("VCVTPS2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rmkz)
  .value("VCVTPS2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rr)
  .value("VCVTPS2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rrk)
  .value("VCVTPS2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ128rrkz)
  .value("VCVTPS2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rm)
  .value("VCVTPS2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rmb)
  .value("VCVTPS2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rmbk)
  .value("VCVTPS2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rmbkz)
  .value("VCVTPS2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rmk)
  .value("VCVTPS2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rmkz)
  .value("VCVTPS2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rr)
  .value("VCVTPS2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rrk)
  .value("VCVTPS2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZ256rrkz)
  .value("VCVTPS2DQZrm", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrm)
  .value("VCVTPS2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrmb)
  .value("VCVTPS2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrmbk)
  .value("VCVTPS2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrmbkz)
  .value("VCVTPS2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrmk)
  .value("VCVTPS2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrmkz)
  .value("VCVTPS2DQZrr", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrr)
  .value("VCVTPS2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrrb)
  .value("VCVTPS2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrrbk)
  .value("VCVTPS2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrrbkz)
  .value("VCVTPS2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrrk)
  .value("VCVTPS2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2DQZrrkz)
  .value("VCVTPS2DQrm", LIEF::assembly::x86::OPCODE::VCVTPS2DQrm)
  .value("VCVTPS2DQrr", LIEF::assembly::x86::OPCODE::VCVTPS2DQrr)
  .value("VCVTPS2IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rm)
  .value("VCVTPS2IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rmb)
  .value("VCVTPS2IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rmbk)
  .value("VCVTPS2IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rmbkz)
  .value("VCVTPS2IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rmk)
  .value("VCVTPS2IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rmkz)
  .value("VCVTPS2IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rr)
  .value("VCVTPS2IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rrk)
  .value("VCVTPS2IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ128rrkz)
  .value("VCVTPS2IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rm)
  .value("VCVTPS2IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rmb)
  .value("VCVTPS2IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rmbk)
  .value("VCVTPS2IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rmbkz)
  .value("VCVTPS2IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rmk)
  .value("VCVTPS2IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rmkz)
  .value("VCVTPS2IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rr)
  .value("VCVTPS2IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rrk)
  .value("VCVTPS2IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZ256rrkz)
  .value("VCVTPS2IBSZrm", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrm)
  .value("VCVTPS2IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrmb)
  .value("VCVTPS2IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrmbk)
  .value("VCVTPS2IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrmbkz)
  .value("VCVTPS2IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrmk)
  .value("VCVTPS2IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrmkz)
  .value("VCVTPS2IBSZrr", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrr)
  .value("VCVTPS2IBSZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrrb)
  .value("VCVTPS2IBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrrbk)
  .value("VCVTPS2IBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrrbkz)
  .value("VCVTPS2IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrrk)
  .value("VCVTPS2IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IBSZrrkz)
  .value("VCVTPS2IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rm)
  .value("VCVTPS2IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rmb)
  .value("VCVTPS2IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rmbk)
  .value("VCVTPS2IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rmbkz)
  .value("VCVTPS2IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rmk)
  .value("VCVTPS2IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rmkz)
  .value("VCVTPS2IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rr)
  .value("VCVTPS2IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rrk)
  .value("VCVTPS2IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ128rrkz)
  .value("VCVTPS2IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rm)
  .value("VCVTPS2IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rmb)
  .value("VCVTPS2IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rmbk)
  .value("VCVTPS2IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rmbkz)
  .value("VCVTPS2IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rmk)
  .value("VCVTPS2IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rmkz)
  .value("VCVTPS2IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rr)
  .value("VCVTPS2IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rrk)
  .value("VCVTPS2IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZ256rrkz)
  .value("VCVTPS2IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrm)
  .value("VCVTPS2IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrmb)
  .value("VCVTPS2IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrmbk)
  .value("VCVTPS2IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrmbkz)
  .value("VCVTPS2IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrmk)
  .value("VCVTPS2IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrmkz)
  .value("VCVTPS2IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrr)
  .value("VCVTPS2IUBSZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrrb)
  .value("VCVTPS2IUBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrrbk)
  .value("VCVTPS2IUBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrrbkz)
  .value("VCVTPS2IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrrk)
  .value("VCVTPS2IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2IUBSZrrkz)
  .value("VCVTPS2PDYrm", LIEF::assembly::x86::OPCODE::VCVTPS2PDYrm)
  .value("VCVTPS2PDYrr", LIEF::assembly::x86::OPCODE::VCVTPS2PDYrr)
  .value("VCVTPS2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rm)
  .value("VCVTPS2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rmb)
  .value("VCVTPS2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rmbk)
  .value("VCVTPS2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rmbkz)
  .value("VCVTPS2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rmk)
  .value("VCVTPS2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rmkz)
  .value("VCVTPS2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rr)
  .value("VCVTPS2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rrk)
  .value("VCVTPS2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ128rrkz)
  .value("VCVTPS2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rm)
  .value("VCVTPS2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rmb)
  .value("VCVTPS2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rmbk)
  .value("VCVTPS2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rmbkz)
  .value("VCVTPS2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rmk)
  .value("VCVTPS2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rmkz)
  .value("VCVTPS2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rr)
  .value("VCVTPS2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rrk)
  .value("VCVTPS2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZ256rrkz)
  .value("VCVTPS2PDZrm", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrm)
  .value("VCVTPS2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrmb)
  .value("VCVTPS2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrmbk)
  .value("VCVTPS2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrmbkz)
  .value("VCVTPS2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrmk)
  .value("VCVTPS2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrmkz)
  .value("VCVTPS2PDZrr", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrr)
  .value("VCVTPS2PDZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrrb)
  .value("VCVTPS2PDZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrrbk)
  .value("VCVTPS2PDZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrrbkz)
  .value("VCVTPS2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrrk)
  .value("VCVTPS2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PDZrrkz)
  .value("VCVTPS2PDrm", LIEF::assembly::x86::OPCODE::VCVTPS2PDrm)
  .value("VCVTPS2PDrr", LIEF::assembly::x86::OPCODE::VCVTPS2PDrr)
  .value("VCVTPS2PHXZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rm)
  .value("VCVTPS2PHXZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rmb)
  .value("VCVTPS2PHXZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rmbk)
  .value("VCVTPS2PHXZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rmbkz)
  .value("VCVTPS2PHXZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rmk)
  .value("VCVTPS2PHXZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rmkz)
  .value("VCVTPS2PHXZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rr)
  .value("VCVTPS2PHXZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rrk)
  .value("VCVTPS2PHXZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ128rrkz)
  .value("VCVTPS2PHXZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rm)
  .value("VCVTPS2PHXZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rmb)
  .value("VCVTPS2PHXZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rmbk)
  .value("VCVTPS2PHXZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rmbkz)
  .value("VCVTPS2PHXZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rmk)
  .value("VCVTPS2PHXZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rmkz)
  .value("VCVTPS2PHXZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rr)
  .value("VCVTPS2PHXZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rrk)
  .value("VCVTPS2PHXZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZ256rrkz)
  .value("VCVTPS2PHXZrm", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrm)
  .value("VCVTPS2PHXZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrmb)
  .value("VCVTPS2PHXZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrmbk)
  .value("VCVTPS2PHXZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrmbkz)
  .value("VCVTPS2PHXZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrmk)
  .value("VCVTPS2PHXZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrmkz)
  .value("VCVTPS2PHXZrr", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrr)
  .value("VCVTPS2PHXZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrrb)
  .value("VCVTPS2PHXZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrrbk)
  .value("VCVTPS2PHXZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrrbkz)
  .value("VCVTPS2PHXZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrrk)
  .value("VCVTPS2PHXZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHXZrrkz)
  .value("VCVTPS2PHYmr", LIEF::assembly::x86::OPCODE::VCVTPS2PHYmr)
  .value("VCVTPS2PHYrr", LIEF::assembly::x86::OPCODE::VCVTPS2PHYrr)
  .value("VCVTPS2PHZ128mr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ128mr)
  .value("VCVTPS2PHZ128mrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ128mrk)
  .value("VCVTPS2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ128rr)
  .value("VCVTPS2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ128rrk)
  .value("VCVTPS2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ128rrkz)
  .value("VCVTPS2PHZ256mr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ256mr)
  .value("VCVTPS2PHZ256mrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ256mrk)
  .value("VCVTPS2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ256rr)
  .value("VCVTPS2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ256rrk)
  .value("VCVTPS2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHZ256rrkz)
  .value("VCVTPS2PHZmr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZmr)
  .value("VCVTPS2PHZmrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZmrk)
  .value("VCVTPS2PHZrr", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrr)
  .value("VCVTPS2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrrb)
  .value("VCVTPS2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrrbk)
  .value("VCVTPS2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrrbkz)
  .value("VCVTPS2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrrk)
  .value("VCVTPS2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2PHZrrkz)
  .value("VCVTPS2PHmr", LIEF::assembly::x86::OPCODE::VCVTPS2PHmr)
  .value("VCVTPS2PHrr", LIEF::assembly::x86::OPCODE::VCVTPS2PHrr);
  opcodes.value("VCVTPS2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rm)
  .value("VCVTPS2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rmb)
  .value("VCVTPS2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rmbk)
  .value("VCVTPS2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rmbkz)
  .value("VCVTPS2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rmk)
  .value("VCVTPS2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rmkz)
  .value("VCVTPS2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rr)
  .value("VCVTPS2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rrk)
  .value("VCVTPS2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ128rrkz)
  .value("VCVTPS2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rm)
  .value("VCVTPS2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rmb)
  .value("VCVTPS2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rmbk)
  .value("VCVTPS2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rmbkz)
  .value("VCVTPS2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rmk)
  .value("VCVTPS2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rmkz)
  .value("VCVTPS2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rr)
  .value("VCVTPS2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rrk)
  .value("VCVTPS2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZ256rrkz)
  .value("VCVTPS2QQZrm", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrm)
  .value("VCVTPS2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrmb)
  .value("VCVTPS2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrmbk)
  .value("VCVTPS2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrmbkz)
  .value("VCVTPS2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrmk)
  .value("VCVTPS2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrmkz)
  .value("VCVTPS2QQZrr", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrr)
  .value("VCVTPS2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrrb)
  .value("VCVTPS2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrrbk)
  .value("VCVTPS2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrrbkz)
  .value("VCVTPS2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrrk)
  .value("VCVTPS2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2QQZrrkz)
  .value("VCVTPS2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rm)
  .value("VCVTPS2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rmb)
  .value("VCVTPS2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rmbk)
  .value("VCVTPS2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rmbkz)
  .value("VCVTPS2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rmk)
  .value("VCVTPS2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rmkz)
  .value("VCVTPS2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rr)
  .value("VCVTPS2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rrk)
  .value("VCVTPS2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ128rrkz)
  .value("VCVTPS2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rm)
  .value("VCVTPS2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rmb)
  .value("VCVTPS2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rmbk)
  .value("VCVTPS2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rmbkz)
  .value("VCVTPS2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rmk)
  .value("VCVTPS2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rmkz)
  .value("VCVTPS2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rr)
  .value("VCVTPS2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rrk)
  .value("VCVTPS2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZ256rrkz)
  .value("VCVTPS2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrm)
  .value("VCVTPS2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrmb)
  .value("VCVTPS2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrmbk)
  .value("VCVTPS2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrmbkz)
  .value("VCVTPS2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrmk)
  .value("VCVTPS2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrmkz)
  .value("VCVTPS2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrr)
  .value("VCVTPS2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrrb)
  .value("VCVTPS2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrrbk)
  .value("VCVTPS2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrrbkz)
  .value("VCVTPS2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrrk)
  .value("VCVTPS2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UDQZrrkz)
  .value("VCVTPS2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rm)
  .value("VCVTPS2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rmb)
  .value("VCVTPS2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rmbk)
  .value("VCVTPS2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rmbkz)
  .value("VCVTPS2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rmk)
  .value("VCVTPS2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rmkz)
  .value("VCVTPS2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rr)
  .value("VCVTPS2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rrk)
  .value("VCVTPS2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ128rrkz)
  .value("VCVTPS2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rm)
  .value("VCVTPS2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rmb)
  .value("VCVTPS2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rmbk)
  .value("VCVTPS2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rmbkz)
  .value("VCVTPS2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rmk)
  .value("VCVTPS2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rmkz)
  .value("VCVTPS2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rr)
  .value("VCVTPS2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rrk)
  .value("VCVTPS2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZ256rrkz)
  .value("VCVTPS2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrm)
  .value("VCVTPS2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrmb)
  .value("VCVTPS2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrmbk)
  .value("VCVTPS2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrmbkz)
  .value("VCVTPS2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrmk)
  .value("VCVTPS2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrmkz)
  .value("VCVTPS2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrr)
  .value("VCVTPS2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrrb)
  .value("VCVTPS2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrrbk)
  .value("VCVTPS2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrrbkz)
  .value("VCVTPS2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrrk)
  .value("VCVTPS2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTPS2UQQZrrkz)
  .value("VCVTQQ2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rm)
  .value("VCVTQQ2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rmb)
  .value("VCVTQQ2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rmbk)
  .value("VCVTQQ2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rmbkz)
  .value("VCVTQQ2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rmk)
  .value("VCVTQQ2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rmkz)
  .value("VCVTQQ2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rr)
  .value("VCVTQQ2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rrk)
  .value("VCVTQQ2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ128rrkz)
  .value("VCVTQQ2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rm)
  .value("VCVTQQ2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rmb)
  .value("VCVTQQ2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rmbk)
  .value("VCVTQQ2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rmbkz)
  .value("VCVTQQ2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rmk)
  .value("VCVTQQ2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rmkz)
  .value("VCVTQQ2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rr)
  .value("VCVTQQ2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rrk)
  .value("VCVTQQ2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZ256rrkz)
  .value("VCVTQQ2PDZrm", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrm)
  .value("VCVTQQ2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrmb)
  .value("VCVTQQ2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrmbk)
  .value("VCVTQQ2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrmbkz)
  .value("VCVTQQ2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrmk)
  .value("VCVTQQ2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrmkz)
  .value("VCVTQQ2PDZrr", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrr)
  .value("VCVTQQ2PDZrrb", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrrb)
  .value("VCVTQQ2PDZrrbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrrbk)
  .value("VCVTQQ2PDZrrbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrrbkz)
  .value("VCVTQQ2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrrk)
  .value("VCVTQQ2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PDZrrkz)
  .value("VCVTQQ2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rm)
  .value("VCVTQQ2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rmb)
  .value("VCVTQQ2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rmbk)
  .value("VCVTQQ2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rmbkz)
  .value("VCVTQQ2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rmk)
  .value("VCVTQQ2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rmkz)
  .value("VCVTQQ2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rr)
  .value("VCVTQQ2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rrk)
  .value("VCVTQQ2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ128rrkz)
  .value("VCVTQQ2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rm)
  .value("VCVTQQ2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rmb)
  .value("VCVTQQ2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rmbk)
  .value("VCVTQQ2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rmbkz)
  .value("VCVTQQ2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rmk)
  .value("VCVTQQ2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rmkz)
  .value("VCVTQQ2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rr)
  .value("VCVTQQ2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rrk)
  .value("VCVTQQ2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZ256rrkz)
  .value("VCVTQQ2PHZrm", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrm)
  .value("VCVTQQ2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrmb)
  .value("VCVTQQ2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrmbk)
  .value("VCVTQQ2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrmbkz)
  .value("VCVTQQ2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrmk)
  .value("VCVTQQ2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrmkz)
  .value("VCVTQQ2PHZrr", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrr)
  .value("VCVTQQ2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrrb)
  .value("VCVTQQ2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrrbk)
  .value("VCVTQQ2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrrbkz)
  .value("VCVTQQ2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrrk)
  .value("VCVTQQ2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PHZrrkz)
  .value("VCVTQQ2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rm)
  .value("VCVTQQ2PSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rmb)
  .value("VCVTQQ2PSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rmbk)
  .value("VCVTQQ2PSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rmbkz)
  .value("VCVTQQ2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rmk)
  .value("VCVTQQ2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rmkz)
  .value("VCVTQQ2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rr)
  .value("VCVTQQ2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rrk)
  .value("VCVTQQ2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ128rrkz)
  .value("VCVTQQ2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rm)
  .value("VCVTQQ2PSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rmb)
  .value("VCVTQQ2PSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rmbk)
  .value("VCVTQQ2PSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rmbkz)
  .value("VCVTQQ2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rmk)
  .value("VCVTQQ2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rmkz)
  .value("VCVTQQ2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rr)
  .value("VCVTQQ2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rrk)
  .value("VCVTQQ2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZ256rrkz)
  .value("VCVTQQ2PSZrm", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrm)
  .value("VCVTQQ2PSZrmb", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrmb)
  .value("VCVTQQ2PSZrmbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrmbk)
  .value("VCVTQQ2PSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrmbkz)
  .value("VCVTQQ2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrmk)
  .value("VCVTQQ2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrmkz)
  .value("VCVTQQ2PSZrr", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrr)
  .value("VCVTQQ2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrrb)
  .value("VCVTQQ2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrrbk)
  .value("VCVTQQ2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrrbkz)
  .value("VCVTQQ2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrrk)
  .value("VCVTQQ2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTQQ2PSZrrkz)
  .value("VCVTSD2SHZrm", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrm)
  .value("VCVTSD2SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrm_Int)
  .value("VCVTSD2SHZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrmk_Int)
  .value("VCVTSD2SHZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrmkz_Int)
  .value("VCVTSD2SHZrr", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrr)
  .value("VCVTSD2SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrr_Int)
  .value("VCVTSD2SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrrb_Int)
  .value("VCVTSD2SHZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrrbk_Int)
  .value("VCVTSD2SHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrrbkz_Int)
  .value("VCVTSD2SHZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrrk_Int)
  .value("VCVTSD2SHZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SHZrrkz_Int)
  .value("VCVTSD2SI64Zrm", LIEF::assembly::x86::OPCODE::VCVTSD2SI64Zrm)
  .value("VCVTSD2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SI64Zrm_Int)
  .value("VCVTSD2SI64Zrr", LIEF::assembly::x86::OPCODE::VCVTSD2SI64Zrr)
  .value("VCVTSD2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SI64Zrr_Int)
  .value("VCVTSD2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SI64Zrrb_Int)
  .value("VCVTSD2SI64rm", LIEF::assembly::x86::OPCODE::VCVTSD2SI64rm)
  .value("VCVTSD2SI64rm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SI64rm_Int)
  .value("VCVTSD2SI64rr", LIEF::assembly::x86::OPCODE::VCVTSD2SI64rr)
  .value("VCVTSD2SI64rr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SI64rr_Int)
  .value("VCVTSD2SIZrm", LIEF::assembly::x86::OPCODE::VCVTSD2SIZrm)
  .value("VCVTSD2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SIZrm_Int)
  .value("VCVTSD2SIZrr", LIEF::assembly::x86::OPCODE::VCVTSD2SIZrr)
  .value("VCVTSD2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SIZrr_Int)
  .value("VCVTSD2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SIZrrb_Int)
  .value("VCVTSD2SIrm", LIEF::assembly::x86::OPCODE::VCVTSD2SIrm)
  .value("VCVTSD2SIrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SIrm_Int)
  .value("VCVTSD2SIrr", LIEF::assembly::x86::OPCODE::VCVTSD2SIrr)
  .value("VCVTSD2SIrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SIrr_Int)
  .value("VCVTSD2SSZrm", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrm)
  .value("VCVTSD2SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrm_Int)
  .value("VCVTSD2SSZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrmk_Int)
  .value("VCVTSD2SSZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrmkz_Int)
  .value("VCVTSD2SSZrr", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrr)
  .value("VCVTSD2SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrr_Int)
  .value("VCVTSD2SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrrb_Int)
  .value("VCVTSD2SSZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrrbk_Int)
  .value("VCVTSD2SSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrrbkz_Int)
  .value("VCVTSD2SSZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrrk_Int)
  .value("VCVTSD2SSZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSZrrkz_Int)
  .value("VCVTSD2SSrm", LIEF::assembly::x86::OPCODE::VCVTSD2SSrm)
  .value("VCVTSD2SSrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSrm_Int)
  .value("VCVTSD2SSrr", LIEF::assembly::x86::OPCODE::VCVTSD2SSrr)
  .value("VCVTSD2SSrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2SSrr_Int)
  .value("VCVTSD2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USI64Zrm_Int)
  .value("VCVTSD2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USI64Zrr_Int)
  .value("VCVTSD2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USI64Zrrb_Int)
  .value("VCVTSD2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USIZrm_Int)
  .value("VCVTSD2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USIZrr_Int)
  .value("VCVTSD2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSD2USIZrrb_Int)
  .value("VCVTSH2SDZrm", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrm)
  .value("VCVTSH2SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrm_Int)
  .value("VCVTSH2SDZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrmk_Int)
  .value("VCVTSH2SDZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrmkz_Int)
  .value("VCVTSH2SDZrr", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrr)
  .value("VCVTSH2SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrr_Int)
  .value("VCVTSH2SDZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrrb_Int)
  .value("VCVTSH2SDZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrrbk_Int)
  .value("VCVTSH2SDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrrbkz_Int)
  .value("VCVTSH2SDZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrrk_Int)
  .value("VCVTSH2SDZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SDZrrkz_Int)
  .value("VCVTSH2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SI64Zrm_Int)
  .value("VCVTSH2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SI64Zrr_Int)
  .value("VCVTSH2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SI64Zrrb_Int)
  .value("VCVTSH2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SIZrm_Int)
  .value("VCVTSH2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SIZrr_Int)
  .value("VCVTSH2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SIZrrb_Int)
  .value("VCVTSH2SSZrm", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrm)
  .value("VCVTSH2SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrm_Int)
  .value("VCVTSH2SSZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrmk_Int)
  .value("VCVTSH2SSZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrmkz_Int)
  .value("VCVTSH2SSZrr", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrr)
  .value("VCVTSH2SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrr_Int)
  .value("VCVTSH2SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrrb_Int)
  .value("VCVTSH2SSZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrrbk_Int)
  .value("VCVTSH2SSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrrbkz_Int)
  .value("VCVTSH2SSZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrrk_Int)
  .value("VCVTSH2SSZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSH2SSZrrkz_Int)
  .value("VCVTSH2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USI64Zrm_Int)
  .value("VCVTSH2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USI64Zrr_Int)
  .value("VCVTSH2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USI64Zrrb_Int)
  .value("VCVTSH2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USIZrm_Int)
  .value("VCVTSH2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USIZrr_Int)
  .value("VCVTSH2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSH2USIZrrb_Int)
  .value("VCVTSI2SDZrm", LIEF::assembly::x86::OPCODE::VCVTSI2SDZrm)
  .value("VCVTSI2SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SDZrm_Int)
  .value("VCVTSI2SDZrr", LIEF::assembly::x86::OPCODE::VCVTSI2SDZrr)
  .value("VCVTSI2SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SDZrr_Int)
  .value("VCVTSI2SDrm", LIEF::assembly::x86::OPCODE::VCVTSI2SDrm)
  .value("VCVTSI2SDrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SDrm_Int)
  .value("VCVTSI2SDrr", LIEF::assembly::x86::OPCODE::VCVTSI2SDrr)
  .value("VCVTSI2SDrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SDrr_Int)
  .value("VCVTSI2SHZrm", LIEF::assembly::x86::OPCODE::VCVTSI2SHZrm)
  .value("VCVTSI2SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SHZrm_Int)
  .value("VCVTSI2SHZrr", LIEF::assembly::x86::OPCODE::VCVTSI2SHZrr)
  .value("VCVTSI2SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SHZrr_Int)
  .value("VCVTSI2SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SHZrrb_Int)
  .value("VCVTSI2SSZrm", LIEF::assembly::x86::OPCODE::VCVTSI2SSZrm)
  .value("VCVTSI2SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SSZrm_Int)
  .value("VCVTSI2SSZrr", LIEF::assembly::x86::OPCODE::VCVTSI2SSZrr)
  .value("VCVTSI2SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SSZrr_Int)
  .value("VCVTSI2SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SSZrrb_Int)
  .value("VCVTSI2SSrm", LIEF::assembly::x86::OPCODE::VCVTSI2SSrm)
  .value("VCVTSI2SSrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SSrm_Int)
  .value("VCVTSI2SSrr", LIEF::assembly::x86::OPCODE::VCVTSI2SSrr)
  .value("VCVTSI2SSrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI2SSrr_Int)
  .value("VCVTSI642SDZrm", LIEF::assembly::x86::OPCODE::VCVTSI642SDZrm)
  .value("VCVTSI642SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SDZrm_Int)
  .value("VCVTSI642SDZrr", LIEF::assembly::x86::OPCODE::VCVTSI642SDZrr)
  .value("VCVTSI642SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SDZrr_Int)
  .value("VCVTSI642SDZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SDZrrb_Int)
  .value("VCVTSI642SDrm", LIEF::assembly::x86::OPCODE::VCVTSI642SDrm)
  .value("VCVTSI642SDrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SDrm_Int)
  .value("VCVTSI642SDrr", LIEF::assembly::x86::OPCODE::VCVTSI642SDrr)
  .value("VCVTSI642SDrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SDrr_Int)
  .value("VCVTSI642SHZrm", LIEF::assembly::x86::OPCODE::VCVTSI642SHZrm)
  .value("VCVTSI642SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SHZrm_Int)
  .value("VCVTSI642SHZrr", LIEF::assembly::x86::OPCODE::VCVTSI642SHZrr)
  .value("VCVTSI642SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SHZrr_Int)
  .value("VCVTSI642SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SHZrrb_Int);
  opcodes.value("VCVTSI642SSZrm", LIEF::assembly::x86::OPCODE::VCVTSI642SSZrm)
  .value("VCVTSI642SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SSZrm_Int)
  .value("VCVTSI642SSZrr", LIEF::assembly::x86::OPCODE::VCVTSI642SSZrr)
  .value("VCVTSI642SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SSZrr_Int)
  .value("VCVTSI642SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SSZrrb_Int)
  .value("VCVTSI642SSrm", LIEF::assembly::x86::OPCODE::VCVTSI642SSrm)
  .value("VCVTSI642SSrm_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SSrm_Int)
  .value("VCVTSI642SSrr", LIEF::assembly::x86::OPCODE::VCVTSI642SSrr)
  .value("VCVTSI642SSrr_Int", LIEF::assembly::x86::OPCODE::VCVTSI642SSrr_Int)
  .value("VCVTSS2SDZrm", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrm)
  .value("VCVTSS2SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrm_Int)
  .value("VCVTSS2SDZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrmk_Int)
  .value("VCVTSS2SDZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrmkz_Int)
  .value("VCVTSS2SDZrr", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrr)
  .value("VCVTSS2SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrr_Int)
  .value("VCVTSS2SDZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrrb_Int)
  .value("VCVTSS2SDZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrrbk_Int)
  .value("VCVTSS2SDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrrbkz_Int)
  .value("VCVTSS2SDZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrrk_Int)
  .value("VCVTSS2SDZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDZrrkz_Int)
  .value("VCVTSS2SDrm", LIEF::assembly::x86::OPCODE::VCVTSS2SDrm)
  .value("VCVTSS2SDrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDrm_Int)
  .value("VCVTSS2SDrr", LIEF::assembly::x86::OPCODE::VCVTSS2SDrr)
  .value("VCVTSS2SDrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SDrr_Int)
  .value("VCVTSS2SHZrm", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrm)
  .value("VCVTSS2SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrm_Int)
  .value("VCVTSS2SHZrmk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrmk_Int)
  .value("VCVTSS2SHZrmkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrmkz_Int)
  .value("VCVTSS2SHZrr", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrr)
  .value("VCVTSS2SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrr_Int)
  .value("VCVTSS2SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrrb_Int)
  .value("VCVTSS2SHZrrbk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrrbk_Int)
  .value("VCVTSS2SHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrrbkz_Int)
  .value("VCVTSS2SHZrrk_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrrk_Int)
  .value("VCVTSS2SHZrrkz_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SHZrrkz_Int)
  .value("VCVTSS2SI64Zrm", LIEF::assembly::x86::OPCODE::VCVTSS2SI64Zrm)
  .value("VCVTSS2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SI64Zrm_Int)
  .value("VCVTSS2SI64Zrr", LIEF::assembly::x86::OPCODE::VCVTSS2SI64Zrr)
  .value("VCVTSS2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SI64Zrr_Int)
  .value("VCVTSS2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SI64Zrrb_Int)
  .value("VCVTSS2SI64rm", LIEF::assembly::x86::OPCODE::VCVTSS2SI64rm)
  .value("VCVTSS2SI64rm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SI64rm_Int)
  .value("VCVTSS2SI64rr", LIEF::assembly::x86::OPCODE::VCVTSS2SI64rr)
  .value("VCVTSS2SI64rr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SI64rr_Int)
  .value("VCVTSS2SIZrm", LIEF::assembly::x86::OPCODE::VCVTSS2SIZrm)
  .value("VCVTSS2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SIZrm_Int)
  .value("VCVTSS2SIZrr", LIEF::assembly::x86::OPCODE::VCVTSS2SIZrr)
  .value("VCVTSS2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SIZrr_Int)
  .value("VCVTSS2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SIZrrb_Int)
  .value("VCVTSS2SIrm", LIEF::assembly::x86::OPCODE::VCVTSS2SIrm)
  .value("VCVTSS2SIrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SIrm_Int)
  .value("VCVTSS2SIrr", LIEF::assembly::x86::OPCODE::VCVTSS2SIrr)
  .value("VCVTSS2SIrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2SIrr_Int)
  .value("VCVTSS2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USI64Zrm_Int)
  .value("VCVTSS2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USI64Zrr_Int)
  .value("VCVTSS2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USI64Zrrb_Int)
  .value("VCVTSS2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USIZrm_Int)
  .value("VCVTSS2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USIZrr_Int)
  .value("VCVTSS2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTSS2USIZrrb_Int)
  .value("VCVTTBF162IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rm)
  .value("VCVTTBF162IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rmb)
  .value("VCVTTBF162IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rmbk)
  .value("VCVTTBF162IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rmbkz)
  .value("VCVTTBF162IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rmk)
  .value("VCVTTBF162IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rmkz)
  .value("VCVTTBF162IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rr)
  .value("VCVTTBF162IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rrk)
  .value("VCVTTBF162IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ128rrkz)
  .value("VCVTTBF162IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rm)
  .value("VCVTTBF162IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rmb)
  .value("VCVTTBF162IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rmbk)
  .value("VCVTTBF162IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rmbkz)
  .value("VCVTTBF162IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rmk)
  .value("VCVTTBF162IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rmkz)
  .value("VCVTTBF162IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rr)
  .value("VCVTTBF162IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rrk)
  .value("VCVTTBF162IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZ256rrkz)
  .value("VCVTTBF162IBSZrm", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrm)
  .value("VCVTTBF162IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrmb)
  .value("VCVTTBF162IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrmbk)
  .value("VCVTTBF162IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrmbkz)
  .value("VCVTTBF162IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrmk)
  .value("VCVTTBF162IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrmkz)
  .value("VCVTTBF162IBSZrr", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrr)
  .value("VCVTTBF162IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrrk)
  .value("VCVTTBF162IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IBSZrrkz)
  .value("VCVTTBF162IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rm)
  .value("VCVTTBF162IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rmb)
  .value("VCVTTBF162IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rmbk)
  .value("VCVTTBF162IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rmbkz)
  .value("VCVTTBF162IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rmk)
  .value("VCVTTBF162IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rmkz)
  .value("VCVTTBF162IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rr)
  .value("VCVTTBF162IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rrk)
  .value("VCVTTBF162IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ128rrkz)
  .value("VCVTTBF162IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rm)
  .value("VCVTTBF162IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rmb)
  .value("VCVTTBF162IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rmbk)
  .value("VCVTTBF162IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rmbkz)
  .value("VCVTTBF162IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rmk)
  .value("VCVTTBF162IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rmkz)
  .value("VCVTTBF162IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rr)
  .value("VCVTTBF162IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rrk)
  .value("VCVTTBF162IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZ256rrkz)
  .value("VCVTTBF162IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrm)
  .value("VCVTTBF162IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrmb)
  .value("VCVTTBF162IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrmbk)
  .value("VCVTTBF162IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrmbkz)
  .value("VCVTTBF162IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrmk)
  .value("VCVTTBF162IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrmkz)
  .value("VCVTTBF162IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrr)
  .value("VCVTTBF162IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrrk)
  .value("VCVTTBF162IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTBF162IUBSZrrkz)
  .value("VCVTTPD2DQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rm)
  .value("VCVTTPD2DQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rmb)
  .value("VCVTTPD2DQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rmbk)
  .value("VCVTTPD2DQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rmbkz)
  .value("VCVTTPD2DQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rmk)
  .value("VCVTTPD2DQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rmkz)
  .value("VCVTTPD2DQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rr)
  .value("VCVTTPD2DQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rrk)
  .value("VCVTTPD2DQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ128rrkz)
  .value("VCVTTPD2DQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rm)
  .value("VCVTTPD2DQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rmb)
  .value("VCVTTPD2DQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rmbk)
  .value("VCVTTPD2DQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rmbkz)
  .value("VCVTTPD2DQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rmk)
  .value("VCVTTPD2DQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rmkz)
  .value("VCVTTPD2DQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rr)
  .value("VCVTTPD2DQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rrb)
  .value("VCVTTPD2DQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rrbk)
  .value("VCVTTPD2DQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rrbkz)
  .value("VCVTTPD2DQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rrk)
  .value("VCVTTPD2DQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZ256rrkz)
  .value("VCVTTPD2DQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrm)
  .value("VCVTTPD2DQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrmb)
  .value("VCVTTPD2DQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrmbk)
  .value("VCVTTPD2DQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrmbkz)
  .value("VCVTTPD2DQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrmk)
  .value("VCVTTPD2DQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrmkz)
  .value("VCVTTPD2DQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrr)
  .value("VCVTTPD2DQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrrb)
  .value("VCVTTPD2DQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrrbk)
  .value("VCVTTPD2DQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrrbkz)
  .value("VCVTTPD2DQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrrk)
  .value("VCVTTPD2DQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQSZrrkz)
  .value("VCVTTPD2DQYrm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQYrm)
  .value("VCVTTPD2DQYrr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQYrr)
  .value("VCVTTPD2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rm)
  .value("VCVTTPD2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rmb)
  .value("VCVTTPD2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rmbk)
  .value("VCVTTPD2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rmbkz)
  .value("VCVTTPD2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rmk)
  .value("VCVTTPD2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rmkz)
  .value("VCVTTPD2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rr)
  .value("VCVTTPD2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rrk)
  .value("VCVTTPD2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ128rrkz)
  .value("VCVTTPD2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rm)
  .value("VCVTTPD2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rmb)
  .value("VCVTTPD2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rmbk)
  .value("VCVTTPD2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rmbkz)
  .value("VCVTTPD2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rmk)
  .value("VCVTTPD2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rmkz)
  .value("VCVTTPD2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rr)
  .value("VCVTTPD2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rrk)
  .value("VCVTTPD2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZ256rrkz)
  .value("VCVTTPD2DQZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrm)
  .value("VCVTTPD2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrmb)
  .value("VCVTTPD2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrmbk)
  .value("VCVTTPD2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrmbkz)
  .value("VCVTTPD2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrmk)
  .value("VCVTTPD2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrmkz)
  .value("VCVTTPD2DQZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrr)
  .value("VCVTTPD2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrrb)
  .value("VCVTTPD2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrrbk)
  .value("VCVTTPD2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrrbkz)
  .value("VCVTTPD2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrrk)
  .value("VCVTTPD2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2DQZrrkz)
  .value("VCVTTPD2DQrm", LIEF::assembly::x86::OPCODE::VCVTTPD2DQrm)
  .value("VCVTTPD2DQrr", LIEF::assembly::x86::OPCODE::VCVTTPD2DQrr)
  .value("VCVTTPD2QQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rm)
  .value("VCVTTPD2QQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rmb)
  .value("VCVTTPD2QQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rmbk)
  .value("VCVTTPD2QQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rmbkz)
  .value("VCVTTPD2QQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rmk)
  .value("VCVTTPD2QQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rmkz)
  .value("VCVTTPD2QQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rr)
  .value("VCVTTPD2QQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rrk)
  .value("VCVTTPD2QQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ128rrkz)
  .value("VCVTTPD2QQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rm)
  .value("VCVTTPD2QQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rmb)
  .value("VCVTTPD2QQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rmbk)
  .value("VCVTTPD2QQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rmbkz)
  .value("VCVTTPD2QQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rmk)
  .value("VCVTTPD2QQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rmkz)
  .value("VCVTTPD2QQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rr)
  .value("VCVTTPD2QQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rrb)
  .value("VCVTTPD2QQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rrbk)
  .value("VCVTTPD2QQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rrbkz)
  .value("VCVTTPD2QQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rrk)
  .value("VCVTTPD2QQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZ256rrkz)
  .value("VCVTTPD2QQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrm)
  .value("VCVTTPD2QQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrmb)
  .value("VCVTTPD2QQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrmbk)
  .value("VCVTTPD2QQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrmbkz)
  .value("VCVTTPD2QQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrmk)
  .value("VCVTTPD2QQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrmkz)
  .value("VCVTTPD2QQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrr)
  .value("VCVTTPD2QQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrrb)
  .value("VCVTTPD2QQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrrbk)
  .value("VCVTTPD2QQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrrbkz)
  .value("VCVTTPD2QQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrrk)
  .value("VCVTTPD2QQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQSZrrkz)
  .value("VCVTTPD2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rm)
  .value("VCVTTPD2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rmb)
  .value("VCVTTPD2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rmbk)
  .value("VCVTTPD2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rmbkz)
  .value("VCVTTPD2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rmk)
  .value("VCVTTPD2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rmkz)
  .value("VCVTTPD2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rr)
  .value("VCVTTPD2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rrk)
  .value("VCVTTPD2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ128rrkz)
  .value("VCVTTPD2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rm)
  .value("VCVTTPD2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rmb)
  .value("VCVTTPD2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rmbk)
  .value("VCVTTPD2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rmbkz)
  .value("VCVTTPD2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rmk)
  .value("VCVTTPD2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rmkz)
  .value("VCVTTPD2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rr)
  .value("VCVTTPD2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rrk)
  .value("VCVTTPD2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZ256rrkz)
  .value("VCVTTPD2QQZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrm)
  .value("VCVTTPD2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrmb)
  .value("VCVTTPD2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrmbk)
  .value("VCVTTPD2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrmbkz)
  .value("VCVTTPD2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrmk)
  .value("VCVTTPD2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrmkz)
  .value("VCVTTPD2QQZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrr)
  .value("VCVTTPD2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrrb)
  .value("VCVTTPD2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrrbk)
  .value("VCVTTPD2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrrbkz)
  .value("VCVTTPD2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrrk)
  .value("VCVTTPD2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2QQZrrkz)
  .value("VCVTTPD2UDQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rm)
  .value("VCVTTPD2UDQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rmb)
  .value("VCVTTPD2UDQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rmbk)
  .value("VCVTTPD2UDQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rmbkz)
  .value("VCVTTPD2UDQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rmk)
  .value("VCVTTPD2UDQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rmkz)
  .value("VCVTTPD2UDQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rr)
  .value("VCVTTPD2UDQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rrk)
  .value("VCVTTPD2UDQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ128rrkz)
  .value("VCVTTPD2UDQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rm)
  .value("VCVTTPD2UDQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rmb)
  .value("VCVTTPD2UDQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rmbk)
  .value("VCVTTPD2UDQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rmbkz)
  .value("VCVTTPD2UDQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rmk)
  .value("VCVTTPD2UDQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rmkz)
  .value("VCVTTPD2UDQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rr)
  .value("VCVTTPD2UDQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rrb)
  .value("VCVTTPD2UDQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rrbk)
  .value("VCVTTPD2UDQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rrbkz)
  .value("VCVTTPD2UDQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rrk)
  .value("VCVTTPD2UDQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZ256rrkz)
  .value("VCVTTPD2UDQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrm)
  .value("VCVTTPD2UDQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrmb)
  .value("VCVTTPD2UDQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrmbk)
  .value("VCVTTPD2UDQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrmbkz)
  .value("VCVTTPD2UDQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrmk)
  .value("VCVTTPD2UDQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrmkz)
  .value("VCVTTPD2UDQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrr)
  .value("VCVTTPD2UDQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrrb)
  .value("VCVTTPD2UDQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrrbk)
  .value("VCVTTPD2UDQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrrbkz)
  .value("VCVTTPD2UDQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrrk)
  .value("VCVTTPD2UDQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQSZrrkz)
  .value("VCVTTPD2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rm)
  .value("VCVTTPD2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rmb)
  .value("VCVTTPD2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rmbk)
  .value("VCVTTPD2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rmbkz)
  .value("VCVTTPD2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rmk)
  .value("VCVTTPD2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rmkz)
  .value("VCVTTPD2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rr)
  .value("VCVTTPD2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rrk)
  .value("VCVTTPD2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ128rrkz)
  .value("VCVTTPD2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rm)
  .value("VCVTTPD2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rmb)
  .value("VCVTTPD2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rmbk)
  .value("VCVTTPD2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rmbkz)
  .value("VCVTTPD2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rmk)
  .value("VCVTTPD2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rmkz)
  .value("VCVTTPD2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rr)
  .value("VCVTTPD2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rrk)
  .value("VCVTTPD2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZ256rrkz)
  .value("VCVTTPD2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrm)
  .value("VCVTTPD2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrmb)
  .value("VCVTTPD2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrmbk)
  .value("VCVTTPD2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrmbkz)
  .value("VCVTTPD2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrmk)
  .value("VCVTTPD2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrmkz);
  opcodes.value("VCVTTPD2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrr)
  .value("VCVTTPD2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrrb)
  .value("VCVTTPD2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrrbk)
  .value("VCVTTPD2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrrbkz)
  .value("VCVTTPD2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrrk)
  .value("VCVTTPD2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UDQZrrkz)
  .value("VCVTTPD2UQQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rm)
  .value("VCVTTPD2UQQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rmb)
  .value("VCVTTPD2UQQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rmbk)
  .value("VCVTTPD2UQQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rmbkz)
  .value("VCVTTPD2UQQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rmk)
  .value("VCVTTPD2UQQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rmkz)
  .value("VCVTTPD2UQQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rr)
  .value("VCVTTPD2UQQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rrk)
  .value("VCVTTPD2UQQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ128rrkz)
  .value("VCVTTPD2UQQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rm)
  .value("VCVTTPD2UQQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rmb)
  .value("VCVTTPD2UQQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rmbk)
  .value("VCVTTPD2UQQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rmbkz)
  .value("VCVTTPD2UQQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rmk)
  .value("VCVTTPD2UQQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rmkz)
  .value("VCVTTPD2UQQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rr)
  .value("VCVTTPD2UQQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rrb)
  .value("VCVTTPD2UQQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rrbk)
  .value("VCVTTPD2UQQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rrbkz)
  .value("VCVTTPD2UQQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rrk)
  .value("VCVTTPD2UQQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZ256rrkz)
  .value("VCVTTPD2UQQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrm)
  .value("VCVTTPD2UQQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrmb)
  .value("VCVTTPD2UQQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrmbk)
  .value("VCVTTPD2UQQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrmbkz)
  .value("VCVTTPD2UQQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrmk)
  .value("VCVTTPD2UQQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrmkz)
  .value("VCVTTPD2UQQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrr)
  .value("VCVTTPD2UQQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrrb)
  .value("VCVTTPD2UQQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrrbk)
  .value("VCVTTPD2UQQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrrbkz)
  .value("VCVTTPD2UQQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrrk)
  .value("VCVTTPD2UQQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQSZrrkz)
  .value("VCVTTPD2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rm)
  .value("VCVTTPD2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rmb)
  .value("VCVTTPD2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rmbk)
  .value("VCVTTPD2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rmbkz)
  .value("VCVTTPD2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rmk)
  .value("VCVTTPD2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rmkz)
  .value("VCVTTPD2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rr)
  .value("VCVTTPD2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rrk)
  .value("VCVTTPD2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ128rrkz)
  .value("VCVTTPD2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rm)
  .value("VCVTTPD2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rmb)
  .value("VCVTTPD2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rmbk)
  .value("VCVTTPD2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rmbkz)
  .value("VCVTTPD2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rmk)
  .value("VCVTTPD2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rmkz)
  .value("VCVTTPD2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rr)
  .value("VCVTTPD2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rrk)
  .value("VCVTTPD2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZ256rrkz)
  .value("VCVTTPD2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrm)
  .value("VCVTTPD2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrmb)
  .value("VCVTTPD2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrmbk)
  .value("VCVTTPD2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrmbkz)
  .value("VCVTTPD2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrmk)
  .value("VCVTTPD2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrmkz)
  .value("VCVTTPD2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrr)
  .value("VCVTTPD2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrrb)
  .value("VCVTTPD2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrrbk)
  .value("VCVTTPD2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrrbkz)
  .value("VCVTTPD2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrrk)
  .value("VCVTTPD2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPD2UQQZrrkz)
  .value("VCVTTPH2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rm)
  .value("VCVTTPH2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rmb)
  .value("VCVTTPH2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rmbk)
  .value("VCVTTPH2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rmbkz)
  .value("VCVTTPH2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rmk)
  .value("VCVTTPH2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rmkz)
  .value("VCVTTPH2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rr)
  .value("VCVTTPH2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rrk)
  .value("VCVTTPH2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ128rrkz)
  .value("VCVTTPH2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rm)
  .value("VCVTTPH2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rmb)
  .value("VCVTTPH2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rmbk)
  .value("VCVTTPH2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rmbkz)
  .value("VCVTTPH2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rmk)
  .value("VCVTTPH2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rmkz)
  .value("VCVTTPH2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rr)
  .value("VCVTTPH2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rrk)
  .value("VCVTTPH2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZ256rrkz)
  .value("VCVTTPH2DQZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrm)
  .value("VCVTTPH2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrmb)
  .value("VCVTTPH2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrmbk)
  .value("VCVTTPH2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrmbkz)
  .value("VCVTTPH2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrmk)
  .value("VCVTTPH2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrmkz)
  .value("VCVTTPH2DQZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrr)
  .value("VCVTTPH2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrrb)
  .value("VCVTTPH2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrrbk)
  .value("VCVTTPH2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrrbkz)
  .value("VCVTTPH2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrrk)
  .value("VCVTTPH2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2DQZrrkz)
  .value("VCVTTPH2IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rm)
  .value("VCVTTPH2IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rmb)
  .value("VCVTTPH2IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rmbk)
  .value("VCVTTPH2IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rmbkz)
  .value("VCVTTPH2IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rmk)
  .value("VCVTTPH2IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rmkz)
  .value("VCVTTPH2IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rr)
  .value("VCVTTPH2IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rrk)
  .value("VCVTTPH2IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ128rrkz)
  .value("VCVTTPH2IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rm)
  .value("VCVTTPH2IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rmb)
  .value("VCVTTPH2IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rmbk)
  .value("VCVTTPH2IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rmbkz)
  .value("VCVTTPH2IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rmk)
  .value("VCVTTPH2IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rmkz)
  .value("VCVTTPH2IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rr)
  .value("VCVTTPH2IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rrk)
  .value("VCVTTPH2IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZ256rrkz)
  .value("VCVTTPH2IBSZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrm)
  .value("VCVTTPH2IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrmb)
  .value("VCVTTPH2IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrmbk)
  .value("VCVTTPH2IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrmbkz)
  .value("VCVTTPH2IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrmk)
  .value("VCVTTPH2IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrmkz)
  .value("VCVTTPH2IBSZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrr)
  .value("VCVTTPH2IBSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrrb)
  .value("VCVTTPH2IBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrrbk)
  .value("VCVTTPH2IBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrrbkz)
  .value("VCVTTPH2IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrrk)
  .value("VCVTTPH2IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IBSZrrkz)
  .value("VCVTTPH2IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rm)
  .value("VCVTTPH2IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rmb)
  .value("VCVTTPH2IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rmbk)
  .value("VCVTTPH2IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rmbkz)
  .value("VCVTTPH2IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rmk)
  .value("VCVTTPH2IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rmkz)
  .value("VCVTTPH2IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rr)
  .value("VCVTTPH2IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rrk)
  .value("VCVTTPH2IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ128rrkz)
  .value("VCVTTPH2IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rm)
  .value("VCVTTPH2IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rmb)
  .value("VCVTTPH2IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rmbk)
  .value("VCVTTPH2IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rmbkz)
  .value("VCVTTPH2IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rmk)
  .value("VCVTTPH2IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rmkz)
  .value("VCVTTPH2IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rr)
  .value("VCVTTPH2IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rrk)
  .value("VCVTTPH2IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZ256rrkz)
  .value("VCVTTPH2IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrm)
  .value("VCVTTPH2IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrmb)
  .value("VCVTTPH2IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrmbk)
  .value("VCVTTPH2IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrmbkz)
  .value("VCVTTPH2IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrmk)
  .value("VCVTTPH2IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrmkz)
  .value("VCVTTPH2IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrr)
  .value("VCVTTPH2IUBSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrrb)
  .value("VCVTTPH2IUBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrrbk)
  .value("VCVTTPH2IUBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrrbkz)
  .value("VCVTTPH2IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrrk)
  .value("VCVTTPH2IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2IUBSZrrkz)
  .value("VCVTTPH2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rm)
  .value("VCVTTPH2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rmb)
  .value("VCVTTPH2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rmbk)
  .value("VCVTTPH2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rmbkz)
  .value("VCVTTPH2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rmk)
  .value("VCVTTPH2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rmkz)
  .value("VCVTTPH2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rr)
  .value("VCVTTPH2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rrk)
  .value("VCVTTPH2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ128rrkz)
  .value("VCVTTPH2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rm)
  .value("VCVTTPH2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rmb)
  .value("VCVTTPH2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rmbk)
  .value("VCVTTPH2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rmbkz)
  .value("VCVTTPH2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rmk)
  .value("VCVTTPH2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rmkz)
  .value("VCVTTPH2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rr)
  .value("VCVTTPH2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rrk)
  .value("VCVTTPH2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZ256rrkz)
  .value("VCVTTPH2QQZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrm)
  .value("VCVTTPH2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrmb)
  .value("VCVTTPH2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrmbk)
  .value("VCVTTPH2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrmbkz)
  .value("VCVTTPH2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrmk)
  .value("VCVTTPH2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrmkz)
  .value("VCVTTPH2QQZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrr)
  .value("VCVTTPH2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrrb)
  .value("VCVTTPH2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrrbk)
  .value("VCVTTPH2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrrbkz)
  .value("VCVTTPH2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrrk)
  .value("VCVTTPH2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2QQZrrkz)
  .value("VCVTTPH2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rm)
  .value("VCVTTPH2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rmb)
  .value("VCVTTPH2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rmbk)
  .value("VCVTTPH2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rmbkz)
  .value("VCVTTPH2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rmk)
  .value("VCVTTPH2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rmkz)
  .value("VCVTTPH2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rr)
  .value("VCVTTPH2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rrk)
  .value("VCVTTPH2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ128rrkz)
  .value("VCVTTPH2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rm)
  .value("VCVTTPH2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rmb)
  .value("VCVTTPH2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rmbk)
  .value("VCVTTPH2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rmbkz)
  .value("VCVTTPH2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rmk)
  .value("VCVTTPH2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rmkz)
  .value("VCVTTPH2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rr)
  .value("VCVTTPH2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rrk)
  .value("VCVTTPH2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZ256rrkz)
  .value("VCVTTPH2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrm)
  .value("VCVTTPH2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrmb)
  .value("VCVTTPH2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrmbk)
  .value("VCVTTPH2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrmbkz)
  .value("VCVTTPH2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrmk)
  .value("VCVTTPH2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrmkz)
  .value("VCVTTPH2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrr)
  .value("VCVTTPH2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrrb)
  .value("VCVTTPH2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrrbk)
  .value("VCVTTPH2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrrbkz)
  .value("VCVTTPH2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrrk)
  .value("VCVTTPH2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UDQZrrkz)
  .value("VCVTTPH2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rm)
  .value("VCVTTPH2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rmb)
  .value("VCVTTPH2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rmbk)
  .value("VCVTTPH2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rmbkz)
  .value("VCVTTPH2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rmk)
  .value("VCVTTPH2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rmkz)
  .value("VCVTTPH2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rr)
  .value("VCVTTPH2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rrk)
  .value("VCVTTPH2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ128rrkz)
  .value("VCVTTPH2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rm)
  .value("VCVTTPH2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rmb)
  .value("VCVTTPH2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rmbk)
  .value("VCVTTPH2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rmbkz)
  .value("VCVTTPH2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rmk)
  .value("VCVTTPH2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rmkz)
  .value("VCVTTPH2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rr)
  .value("VCVTTPH2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rrk)
  .value("VCVTTPH2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZ256rrkz)
  .value("VCVTTPH2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrm)
  .value("VCVTTPH2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrmb)
  .value("VCVTTPH2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrmbk)
  .value("VCVTTPH2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrmbkz)
  .value("VCVTTPH2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrmk)
  .value("VCVTTPH2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrmkz)
  .value("VCVTTPH2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrr)
  .value("VCVTTPH2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrrb)
  .value("VCVTTPH2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrrbk)
  .value("VCVTTPH2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrrbkz)
  .value("VCVTTPH2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrrk)
  .value("VCVTTPH2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UQQZrrkz)
  .value("VCVTTPH2UWZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rm)
  .value("VCVTTPH2UWZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rmb)
  .value("VCVTTPH2UWZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rmbk)
  .value("VCVTTPH2UWZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rmbkz)
  .value("VCVTTPH2UWZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rmk)
  .value("VCVTTPH2UWZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rmkz)
  .value("VCVTTPH2UWZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rr)
  .value("VCVTTPH2UWZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rrk)
  .value("VCVTTPH2UWZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ128rrkz)
  .value("VCVTTPH2UWZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rm)
  .value("VCVTTPH2UWZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rmb)
  .value("VCVTTPH2UWZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rmbk)
  .value("VCVTTPH2UWZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rmbkz)
  .value("VCVTTPH2UWZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rmk)
  .value("VCVTTPH2UWZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rmkz)
  .value("VCVTTPH2UWZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rr)
  .value("VCVTTPH2UWZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rrk)
  .value("VCVTTPH2UWZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZ256rrkz)
  .value("VCVTTPH2UWZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrm)
  .value("VCVTTPH2UWZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrmb)
  .value("VCVTTPH2UWZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrmbk)
  .value("VCVTTPH2UWZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrmbkz)
  .value("VCVTTPH2UWZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrmk)
  .value("VCVTTPH2UWZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrmkz)
  .value("VCVTTPH2UWZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrr)
  .value("VCVTTPH2UWZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrrb)
  .value("VCVTTPH2UWZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrrbk)
  .value("VCVTTPH2UWZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrrbkz)
  .value("VCVTTPH2UWZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrrk)
  .value("VCVTTPH2UWZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2UWZrrkz)
  .value("VCVTTPH2WZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rm)
  .value("VCVTTPH2WZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rmb)
  .value("VCVTTPH2WZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rmbk)
  .value("VCVTTPH2WZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rmbkz)
  .value("VCVTTPH2WZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rmk)
  .value("VCVTTPH2WZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rmkz)
  .value("VCVTTPH2WZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rr)
  .value("VCVTTPH2WZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rrk)
  .value("VCVTTPH2WZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ128rrkz)
  .value("VCVTTPH2WZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rm)
  .value("VCVTTPH2WZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rmb)
  .value("VCVTTPH2WZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rmbk)
  .value("VCVTTPH2WZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rmbkz)
  .value("VCVTTPH2WZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rmk)
  .value("VCVTTPH2WZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rmkz)
  .value("VCVTTPH2WZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rr)
  .value("VCVTTPH2WZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rrk)
  .value("VCVTTPH2WZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZ256rrkz)
  .value("VCVTTPH2WZrm", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrm)
  .value("VCVTTPH2WZrmb", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrmb)
  .value("VCVTTPH2WZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrmbk);
  opcodes.value("VCVTTPH2WZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrmbkz)
  .value("VCVTTPH2WZrmk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrmk)
  .value("VCVTTPH2WZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrmkz)
  .value("VCVTTPH2WZrr", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrr)
  .value("VCVTTPH2WZrrb", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrrb)
  .value("VCVTTPH2WZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrrbk)
  .value("VCVTTPH2WZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrrbkz)
  .value("VCVTTPH2WZrrk", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrrk)
  .value("VCVTTPH2WZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPH2WZrrkz)
  .value("VCVTTPS2DQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rm)
  .value("VCVTTPS2DQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rmb)
  .value("VCVTTPS2DQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rmbk)
  .value("VCVTTPS2DQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rmbkz)
  .value("VCVTTPS2DQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rmk)
  .value("VCVTTPS2DQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rmkz)
  .value("VCVTTPS2DQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rr)
  .value("VCVTTPS2DQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rrk)
  .value("VCVTTPS2DQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ128rrkz)
  .value("VCVTTPS2DQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rm)
  .value("VCVTTPS2DQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rmb)
  .value("VCVTTPS2DQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rmbk)
  .value("VCVTTPS2DQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rmbkz)
  .value("VCVTTPS2DQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rmk)
  .value("VCVTTPS2DQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rmkz)
  .value("VCVTTPS2DQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rr)
  .value("VCVTTPS2DQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rrk)
  .value("VCVTTPS2DQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZ256rrkz)
  .value("VCVTTPS2DQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrm)
  .value("VCVTTPS2DQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrmb)
  .value("VCVTTPS2DQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrmbk)
  .value("VCVTTPS2DQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrmbkz)
  .value("VCVTTPS2DQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrmk)
  .value("VCVTTPS2DQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrmkz)
  .value("VCVTTPS2DQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrr)
  .value("VCVTTPS2DQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrrb)
  .value("VCVTTPS2DQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrrbk)
  .value("VCVTTPS2DQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrrbkz)
  .value("VCVTTPS2DQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrrk)
  .value("VCVTTPS2DQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQSZrrkz)
  .value("VCVTTPS2DQYrm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQYrm)
  .value("VCVTTPS2DQYrr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQYrr)
  .value("VCVTTPS2DQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rm)
  .value("VCVTTPS2DQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rmb)
  .value("VCVTTPS2DQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rmbk)
  .value("VCVTTPS2DQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rmbkz)
  .value("VCVTTPS2DQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rmk)
  .value("VCVTTPS2DQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rmkz)
  .value("VCVTTPS2DQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rr)
  .value("VCVTTPS2DQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rrk)
  .value("VCVTTPS2DQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ128rrkz)
  .value("VCVTTPS2DQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rm)
  .value("VCVTTPS2DQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rmb)
  .value("VCVTTPS2DQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rmbk)
  .value("VCVTTPS2DQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rmbkz)
  .value("VCVTTPS2DQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rmk)
  .value("VCVTTPS2DQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rmkz)
  .value("VCVTTPS2DQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rr)
  .value("VCVTTPS2DQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rrk)
  .value("VCVTTPS2DQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZ256rrkz)
  .value("VCVTTPS2DQZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrm)
  .value("VCVTTPS2DQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrmb)
  .value("VCVTTPS2DQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrmbk)
  .value("VCVTTPS2DQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrmbkz)
  .value("VCVTTPS2DQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrmk)
  .value("VCVTTPS2DQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrmkz)
  .value("VCVTTPS2DQZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrr)
  .value("VCVTTPS2DQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrrb)
  .value("VCVTTPS2DQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrrbk)
  .value("VCVTTPS2DQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrrbkz)
  .value("VCVTTPS2DQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrrk)
  .value("VCVTTPS2DQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2DQZrrkz)
  .value("VCVTTPS2DQrm", LIEF::assembly::x86::OPCODE::VCVTTPS2DQrm)
  .value("VCVTTPS2DQrr", LIEF::assembly::x86::OPCODE::VCVTTPS2DQrr)
  .value("VCVTTPS2IBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rm)
  .value("VCVTTPS2IBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rmb)
  .value("VCVTTPS2IBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rmbk)
  .value("VCVTTPS2IBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rmbkz)
  .value("VCVTTPS2IBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rmk)
  .value("VCVTTPS2IBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rmkz)
  .value("VCVTTPS2IBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rr)
  .value("VCVTTPS2IBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rrk)
  .value("VCVTTPS2IBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ128rrkz)
  .value("VCVTTPS2IBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rm)
  .value("VCVTTPS2IBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rmb)
  .value("VCVTTPS2IBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rmbk)
  .value("VCVTTPS2IBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rmbkz)
  .value("VCVTTPS2IBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rmk)
  .value("VCVTTPS2IBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rmkz)
  .value("VCVTTPS2IBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rr)
  .value("VCVTTPS2IBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rrk)
  .value("VCVTTPS2IBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZ256rrkz)
  .value("VCVTTPS2IBSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrm)
  .value("VCVTTPS2IBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrmb)
  .value("VCVTTPS2IBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrmbk)
  .value("VCVTTPS2IBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrmbkz)
  .value("VCVTTPS2IBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrmk)
  .value("VCVTTPS2IBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrmkz)
  .value("VCVTTPS2IBSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrr)
  .value("VCVTTPS2IBSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrrb)
  .value("VCVTTPS2IBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrrbk)
  .value("VCVTTPS2IBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrrbkz)
  .value("VCVTTPS2IBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrrk)
  .value("VCVTTPS2IBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IBSZrrkz)
  .value("VCVTTPS2IUBSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rm)
  .value("VCVTTPS2IUBSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rmb)
  .value("VCVTTPS2IUBSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rmbk)
  .value("VCVTTPS2IUBSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rmbkz)
  .value("VCVTTPS2IUBSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rmk)
  .value("VCVTTPS2IUBSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rmkz)
  .value("VCVTTPS2IUBSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rr)
  .value("VCVTTPS2IUBSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rrk)
  .value("VCVTTPS2IUBSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ128rrkz)
  .value("VCVTTPS2IUBSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rm)
  .value("VCVTTPS2IUBSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rmb)
  .value("VCVTTPS2IUBSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rmbk)
  .value("VCVTTPS2IUBSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rmbkz)
  .value("VCVTTPS2IUBSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rmk)
  .value("VCVTTPS2IUBSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rmkz)
  .value("VCVTTPS2IUBSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rr)
  .value("VCVTTPS2IUBSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rrk)
  .value("VCVTTPS2IUBSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZ256rrkz)
  .value("VCVTTPS2IUBSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrm)
  .value("VCVTTPS2IUBSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrmb)
  .value("VCVTTPS2IUBSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrmbk)
  .value("VCVTTPS2IUBSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrmbkz)
  .value("VCVTTPS2IUBSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrmk)
  .value("VCVTTPS2IUBSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrmkz)
  .value("VCVTTPS2IUBSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrr)
  .value("VCVTTPS2IUBSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrrb)
  .value("VCVTTPS2IUBSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrrbk)
  .value("VCVTTPS2IUBSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrrbkz)
  .value("VCVTTPS2IUBSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrrk)
  .value("VCVTTPS2IUBSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2IUBSZrrkz)
  .value("VCVTTPS2QQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rm)
  .value("VCVTTPS2QQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rmb)
  .value("VCVTTPS2QQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rmbk)
  .value("VCVTTPS2QQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rmbkz)
  .value("VCVTTPS2QQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rmk)
  .value("VCVTTPS2QQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rmkz)
  .value("VCVTTPS2QQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rr)
  .value("VCVTTPS2QQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rrk)
  .value("VCVTTPS2QQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ128rrkz)
  .value("VCVTTPS2QQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rm)
  .value("VCVTTPS2QQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rmb)
  .value("VCVTTPS2QQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rmbk)
  .value("VCVTTPS2QQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rmbkz)
  .value("VCVTTPS2QQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rmk)
  .value("VCVTTPS2QQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rmkz)
  .value("VCVTTPS2QQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rr)
  .value("VCVTTPS2QQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rrb)
  .value("VCVTTPS2QQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rrbk)
  .value("VCVTTPS2QQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rrbkz)
  .value("VCVTTPS2QQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rrk)
  .value("VCVTTPS2QQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZ256rrkz)
  .value("VCVTTPS2QQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrm)
  .value("VCVTTPS2QQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrmb)
  .value("VCVTTPS2QQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrmbk)
  .value("VCVTTPS2QQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrmbkz)
  .value("VCVTTPS2QQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrmk)
  .value("VCVTTPS2QQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrmkz)
  .value("VCVTTPS2QQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrr)
  .value("VCVTTPS2QQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrrb)
  .value("VCVTTPS2QQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrrbk)
  .value("VCVTTPS2QQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrrbkz)
  .value("VCVTTPS2QQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrrk)
  .value("VCVTTPS2QQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQSZrrkz)
  .value("VCVTTPS2QQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rm)
  .value("VCVTTPS2QQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rmb)
  .value("VCVTTPS2QQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rmbk)
  .value("VCVTTPS2QQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rmbkz)
  .value("VCVTTPS2QQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rmk)
  .value("VCVTTPS2QQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rmkz)
  .value("VCVTTPS2QQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rr)
  .value("VCVTTPS2QQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rrk)
  .value("VCVTTPS2QQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ128rrkz)
  .value("VCVTTPS2QQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rm)
  .value("VCVTTPS2QQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rmb)
  .value("VCVTTPS2QQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rmbk)
  .value("VCVTTPS2QQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rmbkz)
  .value("VCVTTPS2QQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rmk)
  .value("VCVTTPS2QQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rmkz)
  .value("VCVTTPS2QQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rr)
  .value("VCVTTPS2QQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rrk)
  .value("VCVTTPS2QQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZ256rrkz)
  .value("VCVTTPS2QQZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrm)
  .value("VCVTTPS2QQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrmb)
  .value("VCVTTPS2QQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrmbk)
  .value("VCVTTPS2QQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrmbkz)
  .value("VCVTTPS2QQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrmk)
  .value("VCVTTPS2QQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrmkz)
  .value("VCVTTPS2QQZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrr)
  .value("VCVTTPS2QQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrrb)
  .value("VCVTTPS2QQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrrbk)
  .value("VCVTTPS2QQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrrbkz)
  .value("VCVTTPS2QQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrrk)
  .value("VCVTTPS2QQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2QQZrrkz)
  .value("VCVTTPS2UDQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rm)
  .value("VCVTTPS2UDQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rmb)
  .value("VCVTTPS2UDQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rmbk)
  .value("VCVTTPS2UDQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rmbkz)
  .value("VCVTTPS2UDQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rmk)
  .value("VCVTTPS2UDQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rmkz)
  .value("VCVTTPS2UDQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rr)
  .value("VCVTTPS2UDQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rrk)
  .value("VCVTTPS2UDQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ128rrkz)
  .value("VCVTTPS2UDQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rm)
  .value("VCVTTPS2UDQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rmb)
  .value("VCVTTPS2UDQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rmbk)
  .value("VCVTTPS2UDQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rmbkz)
  .value("VCVTTPS2UDQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rmk)
  .value("VCVTTPS2UDQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rmkz)
  .value("VCVTTPS2UDQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rr)
  .value("VCVTTPS2UDQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rrk)
  .value("VCVTTPS2UDQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZ256rrkz)
  .value("VCVTTPS2UDQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrm)
  .value("VCVTTPS2UDQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrmb)
  .value("VCVTTPS2UDQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrmbk)
  .value("VCVTTPS2UDQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrmbkz)
  .value("VCVTTPS2UDQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrmk)
  .value("VCVTTPS2UDQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrmkz)
  .value("VCVTTPS2UDQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrr)
  .value("VCVTTPS2UDQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrrb)
  .value("VCVTTPS2UDQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrrbk)
  .value("VCVTTPS2UDQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrrbkz)
  .value("VCVTTPS2UDQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrrk)
  .value("VCVTTPS2UDQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQSZrrkz)
  .value("VCVTTPS2UDQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rm)
  .value("VCVTTPS2UDQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rmb)
  .value("VCVTTPS2UDQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rmbk)
  .value("VCVTTPS2UDQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rmbkz)
  .value("VCVTTPS2UDQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rmk)
  .value("VCVTTPS2UDQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rmkz)
  .value("VCVTTPS2UDQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rr)
  .value("VCVTTPS2UDQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rrk)
  .value("VCVTTPS2UDQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ128rrkz)
  .value("VCVTTPS2UDQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rm)
  .value("VCVTTPS2UDQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rmb)
  .value("VCVTTPS2UDQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rmbk)
  .value("VCVTTPS2UDQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rmbkz)
  .value("VCVTTPS2UDQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rmk)
  .value("VCVTTPS2UDQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rmkz)
  .value("VCVTTPS2UDQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rr)
  .value("VCVTTPS2UDQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rrk)
  .value("VCVTTPS2UDQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZ256rrkz)
  .value("VCVTTPS2UDQZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrm)
  .value("VCVTTPS2UDQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrmb)
  .value("VCVTTPS2UDQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrmbk)
  .value("VCVTTPS2UDQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrmbkz)
  .value("VCVTTPS2UDQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrmk)
  .value("VCVTTPS2UDQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrmkz)
  .value("VCVTTPS2UDQZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrr)
  .value("VCVTTPS2UDQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrrb)
  .value("VCVTTPS2UDQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrrbk)
  .value("VCVTTPS2UDQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrrbkz)
  .value("VCVTTPS2UDQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrrk)
  .value("VCVTTPS2UDQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UDQZrrkz)
  .value("VCVTTPS2UQQSZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rm)
  .value("VCVTTPS2UQQSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rmb)
  .value("VCVTTPS2UQQSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rmbk)
  .value("VCVTTPS2UQQSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rmbkz)
  .value("VCVTTPS2UQQSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rmk)
  .value("VCVTTPS2UQQSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rmkz)
  .value("VCVTTPS2UQQSZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rr)
  .value("VCVTTPS2UQQSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rrk)
  .value("VCVTTPS2UQQSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ128rrkz)
  .value("VCVTTPS2UQQSZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rm)
  .value("VCVTTPS2UQQSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rmb)
  .value("VCVTTPS2UQQSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rmbk)
  .value("VCVTTPS2UQQSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rmbkz)
  .value("VCVTTPS2UQQSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rmk)
  .value("VCVTTPS2UQQSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rmkz)
  .value("VCVTTPS2UQQSZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rr)
  .value("VCVTTPS2UQQSZ256rrb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rrb)
  .value("VCVTTPS2UQQSZ256rrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rrbk)
  .value("VCVTTPS2UQQSZ256rrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rrbkz)
  .value("VCVTTPS2UQQSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rrk)
  .value("VCVTTPS2UQQSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZ256rrkz)
  .value("VCVTTPS2UQQSZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrm)
  .value("VCVTTPS2UQQSZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrmb)
  .value("VCVTTPS2UQQSZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrmbk)
  .value("VCVTTPS2UQQSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrmbkz)
  .value("VCVTTPS2UQQSZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrmk)
  .value("VCVTTPS2UQQSZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrmkz)
  .value("VCVTTPS2UQQSZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrr)
  .value("VCVTTPS2UQQSZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrrb)
  .value("VCVTTPS2UQQSZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrrbk)
  .value("VCVTTPS2UQQSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrrbkz)
  .value("VCVTTPS2UQQSZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrrk)
  .value("VCVTTPS2UQQSZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQSZrrkz)
  .value("VCVTTPS2UQQZ128rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rm)
  .value("VCVTTPS2UQQZ128rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rmb)
  .value("VCVTTPS2UQQZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rmbk)
  .value("VCVTTPS2UQQZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rmbkz)
  .value("VCVTTPS2UQQZ128rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rmk)
  .value("VCVTTPS2UQQZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rmkz)
  .value("VCVTTPS2UQQZ128rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rr)
  .value("VCVTTPS2UQQZ128rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rrk)
  .value("VCVTTPS2UQQZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ128rrkz)
  .value("VCVTTPS2UQQZ256rm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rm)
  .value("VCVTTPS2UQQZ256rmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rmb);
  opcodes.value("VCVTTPS2UQQZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rmbk)
  .value("VCVTTPS2UQQZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rmbkz)
  .value("VCVTTPS2UQQZ256rmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rmk)
  .value("VCVTTPS2UQQZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rmkz)
  .value("VCVTTPS2UQQZ256rr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rr)
  .value("VCVTTPS2UQQZ256rrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rrk)
  .value("VCVTTPS2UQQZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZ256rrkz)
  .value("VCVTTPS2UQQZrm", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrm)
  .value("VCVTTPS2UQQZrmb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrmb)
  .value("VCVTTPS2UQQZrmbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrmbk)
  .value("VCVTTPS2UQQZrmbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrmbkz)
  .value("VCVTTPS2UQQZrmk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrmk)
  .value("VCVTTPS2UQQZrmkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrmkz)
  .value("VCVTTPS2UQQZrr", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrr)
  .value("VCVTTPS2UQQZrrb", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrrb)
  .value("VCVTTPS2UQQZrrbk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrrbk)
  .value("VCVTTPS2UQQZrrbkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrrbkz)
  .value("VCVTTPS2UQQZrrk", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrrk)
  .value("VCVTTPS2UQQZrrkz", LIEF::assembly::x86::OPCODE::VCVTTPS2UQQZrrkz)
  .value("VCVTTSD2SI64Srm", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Srm)
  .value("VCVTTSD2SI64Srm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Srm_Int)
  .value("VCVTTSD2SI64Srr", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Srr)
  .value("VCVTTSD2SI64Srr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Srr_Int)
  .value("VCVTTSD2SI64Srrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Srrb_Int)
  .value("VCVTTSD2SI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Zrm)
  .value("VCVTTSD2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Zrm_Int)
  .value("VCVTTSD2SI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Zrr)
  .value("VCVTTSD2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Zrr_Int)
  .value("VCVTTSD2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64Zrrb_Int)
  .value("VCVTTSD2SI64rm", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64rm)
  .value("VCVTTSD2SI64rm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64rm_Int)
  .value("VCVTTSD2SI64rr", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64rr)
  .value("VCVTTSD2SI64rr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SI64rr_Int)
  .value("VCVTTSD2SISrm", LIEF::assembly::x86::OPCODE::VCVTTSD2SISrm)
  .value("VCVTTSD2SISrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SISrm_Int)
  .value("VCVTTSD2SISrr", LIEF::assembly::x86::OPCODE::VCVTTSD2SISrr)
  .value("VCVTTSD2SISrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SISrr_Int)
  .value("VCVTTSD2SISrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SISrrb_Int)
  .value("VCVTTSD2SIZrm", LIEF::assembly::x86::OPCODE::VCVTTSD2SIZrm)
  .value("VCVTTSD2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SIZrm_Int)
  .value("VCVTTSD2SIZrr", LIEF::assembly::x86::OPCODE::VCVTTSD2SIZrr)
  .value("VCVTTSD2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SIZrr_Int)
  .value("VCVTTSD2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SIZrrb_Int)
  .value("VCVTTSD2SIrm", LIEF::assembly::x86::OPCODE::VCVTTSD2SIrm)
  .value("VCVTTSD2SIrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SIrm_Int)
  .value("VCVTTSD2SIrr", LIEF::assembly::x86::OPCODE::VCVTTSD2SIrr)
  .value("VCVTTSD2SIrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2SIrr_Int)
  .value("VCVTTSD2USI64Srm", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Srm)
  .value("VCVTTSD2USI64Srm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Srm_Int)
  .value("VCVTTSD2USI64Srr", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Srr)
  .value("VCVTTSD2USI64Srr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Srr_Int)
  .value("VCVTTSD2USI64Srrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Srrb_Int)
  .value("VCVTTSD2USI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Zrm)
  .value("VCVTTSD2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Zrm_Int)
  .value("VCVTTSD2USI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Zrr)
  .value("VCVTTSD2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Zrr_Int)
  .value("VCVTTSD2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USI64Zrrb_Int)
  .value("VCVTTSD2USISrm", LIEF::assembly::x86::OPCODE::VCVTTSD2USISrm)
  .value("VCVTTSD2USISrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USISrm_Int)
  .value("VCVTTSD2USISrr", LIEF::assembly::x86::OPCODE::VCVTTSD2USISrr)
  .value("VCVTTSD2USISrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USISrr_Int)
  .value("VCVTTSD2USISrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USISrrb_Int)
  .value("VCVTTSD2USIZrm", LIEF::assembly::x86::OPCODE::VCVTTSD2USIZrm)
  .value("VCVTTSD2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USIZrm_Int)
  .value("VCVTTSD2USIZrr", LIEF::assembly::x86::OPCODE::VCVTTSD2USIZrr)
  .value("VCVTTSD2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USIZrr_Int)
  .value("VCVTTSD2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSD2USIZrrb_Int)
  .value("VCVTTSH2SI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSH2SI64Zrm)
  .value("VCVTTSH2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SI64Zrm_Int)
  .value("VCVTTSH2SI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSH2SI64Zrr)
  .value("VCVTTSH2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SI64Zrr_Int)
  .value("VCVTTSH2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SI64Zrrb_Int)
  .value("VCVTTSH2SIZrm", LIEF::assembly::x86::OPCODE::VCVTTSH2SIZrm)
  .value("VCVTTSH2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SIZrm_Int)
  .value("VCVTTSH2SIZrr", LIEF::assembly::x86::OPCODE::VCVTTSH2SIZrr)
  .value("VCVTTSH2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SIZrr_Int)
  .value("VCVTTSH2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2SIZrrb_Int)
  .value("VCVTTSH2USI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSH2USI64Zrm)
  .value("VCVTTSH2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USI64Zrm_Int)
  .value("VCVTTSH2USI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSH2USI64Zrr)
  .value("VCVTTSH2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USI64Zrr_Int)
  .value("VCVTTSH2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USI64Zrrb_Int)
  .value("VCVTTSH2USIZrm", LIEF::assembly::x86::OPCODE::VCVTTSH2USIZrm)
  .value("VCVTTSH2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USIZrm_Int)
  .value("VCVTTSH2USIZrr", LIEF::assembly::x86::OPCODE::VCVTTSH2USIZrr)
  .value("VCVTTSH2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USIZrr_Int)
  .value("VCVTTSH2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSH2USIZrrb_Int)
  .value("VCVTTSS2SI64Srm", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Srm)
  .value("VCVTTSS2SI64Srm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Srm_Int)
  .value("VCVTTSS2SI64Srr", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Srr)
  .value("VCVTTSS2SI64Srr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Srr_Int)
  .value("VCVTTSS2SI64Srrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Srrb_Int)
  .value("VCVTTSS2SI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Zrm)
  .value("VCVTTSS2SI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Zrm_Int)
  .value("VCVTTSS2SI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Zrr)
  .value("VCVTTSS2SI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Zrr_Int)
  .value("VCVTTSS2SI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64Zrrb_Int)
  .value("VCVTTSS2SI64rm", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64rm)
  .value("VCVTTSS2SI64rm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64rm_Int)
  .value("VCVTTSS2SI64rr", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64rr)
  .value("VCVTTSS2SI64rr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SI64rr_Int)
  .value("VCVTTSS2SISrm", LIEF::assembly::x86::OPCODE::VCVTTSS2SISrm)
  .value("VCVTTSS2SISrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SISrm_Int)
  .value("VCVTTSS2SISrr", LIEF::assembly::x86::OPCODE::VCVTTSS2SISrr)
  .value("VCVTTSS2SISrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SISrr_Int)
  .value("VCVTTSS2SISrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SISrrb_Int)
  .value("VCVTTSS2SIZrm", LIEF::assembly::x86::OPCODE::VCVTTSS2SIZrm)
  .value("VCVTTSS2SIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SIZrm_Int)
  .value("VCVTTSS2SIZrr", LIEF::assembly::x86::OPCODE::VCVTTSS2SIZrr)
  .value("VCVTTSS2SIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SIZrr_Int)
  .value("VCVTTSS2SIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SIZrrb_Int)
  .value("VCVTTSS2SIrm", LIEF::assembly::x86::OPCODE::VCVTTSS2SIrm)
  .value("VCVTTSS2SIrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SIrm_Int)
  .value("VCVTTSS2SIrr", LIEF::assembly::x86::OPCODE::VCVTTSS2SIrr)
  .value("VCVTTSS2SIrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2SIrr_Int)
  .value("VCVTTSS2USI64Srm", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Srm)
  .value("VCVTTSS2USI64Srm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Srm_Int)
  .value("VCVTTSS2USI64Srr", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Srr)
  .value("VCVTTSS2USI64Srr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Srr_Int)
  .value("VCVTTSS2USI64Srrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Srrb_Int)
  .value("VCVTTSS2USI64Zrm", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Zrm)
  .value("VCVTTSS2USI64Zrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Zrm_Int)
  .value("VCVTTSS2USI64Zrr", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Zrr)
  .value("VCVTTSS2USI64Zrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Zrr_Int)
  .value("VCVTTSS2USI64Zrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USI64Zrrb_Int)
  .value("VCVTTSS2USISrm", LIEF::assembly::x86::OPCODE::VCVTTSS2USISrm)
  .value("VCVTTSS2USISrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USISrm_Int)
  .value("VCVTTSS2USISrr", LIEF::assembly::x86::OPCODE::VCVTTSS2USISrr)
  .value("VCVTTSS2USISrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USISrr_Int)
  .value("VCVTTSS2USISrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USISrrb_Int)
  .value("VCVTTSS2USIZrm", LIEF::assembly::x86::OPCODE::VCVTTSS2USIZrm)
  .value("VCVTTSS2USIZrm_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USIZrm_Int)
  .value("VCVTTSS2USIZrr", LIEF::assembly::x86::OPCODE::VCVTTSS2USIZrr)
  .value("VCVTTSS2USIZrr_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USIZrr_Int)
  .value("VCVTTSS2USIZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTTSS2USIZrrb_Int)
  .value("VCVTUDQ2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rm)
  .value("VCVTUDQ2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rmb)
  .value("VCVTUDQ2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rmbk)
  .value("VCVTUDQ2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rmbkz)
  .value("VCVTUDQ2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rmk)
  .value("VCVTUDQ2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rmkz)
  .value("VCVTUDQ2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rr)
  .value("VCVTUDQ2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rrk)
  .value("VCVTUDQ2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ128rrkz)
  .value("VCVTUDQ2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rm)
  .value("VCVTUDQ2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rmb)
  .value("VCVTUDQ2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rmbk)
  .value("VCVTUDQ2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rmbkz)
  .value("VCVTUDQ2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rmk)
  .value("VCVTUDQ2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rmkz)
  .value("VCVTUDQ2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rr)
  .value("VCVTUDQ2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rrk)
  .value("VCVTUDQ2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZ256rrkz)
  .value("VCVTUDQ2PDZrm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrm)
  .value("VCVTUDQ2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrmb)
  .value("VCVTUDQ2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrmbk)
  .value("VCVTUDQ2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrmbkz)
  .value("VCVTUDQ2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrmk)
  .value("VCVTUDQ2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrmkz)
  .value("VCVTUDQ2PDZrr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrr)
  .value("VCVTUDQ2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrrk)
  .value("VCVTUDQ2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PDZrrkz)
  .value("VCVTUDQ2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rm)
  .value("VCVTUDQ2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rmb)
  .value("VCVTUDQ2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rmbk)
  .value("VCVTUDQ2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rmbkz)
  .value("VCVTUDQ2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rmk)
  .value("VCVTUDQ2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rmkz)
  .value("VCVTUDQ2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rr)
  .value("VCVTUDQ2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rrk)
  .value("VCVTUDQ2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ128rrkz)
  .value("VCVTUDQ2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rm)
  .value("VCVTUDQ2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rmb)
  .value("VCVTUDQ2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rmbk)
  .value("VCVTUDQ2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rmbkz)
  .value("VCVTUDQ2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rmk)
  .value("VCVTUDQ2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rmkz)
  .value("VCVTUDQ2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rr)
  .value("VCVTUDQ2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rrk)
  .value("VCVTUDQ2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZ256rrkz)
  .value("VCVTUDQ2PHZrm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrm)
  .value("VCVTUDQ2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrmb)
  .value("VCVTUDQ2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrmbk)
  .value("VCVTUDQ2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrmbkz)
  .value("VCVTUDQ2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrmk)
  .value("VCVTUDQ2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrmkz)
  .value("VCVTUDQ2PHZrr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrr)
  .value("VCVTUDQ2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrrb)
  .value("VCVTUDQ2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrrbk)
  .value("VCVTUDQ2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrrbkz)
  .value("VCVTUDQ2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrrk)
  .value("VCVTUDQ2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PHZrrkz)
  .value("VCVTUDQ2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rm)
  .value("VCVTUDQ2PSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rmb)
  .value("VCVTUDQ2PSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rmbk)
  .value("VCVTUDQ2PSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rmbkz)
  .value("VCVTUDQ2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rmk)
  .value("VCVTUDQ2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rmkz)
  .value("VCVTUDQ2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rr)
  .value("VCVTUDQ2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rrk)
  .value("VCVTUDQ2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ128rrkz)
  .value("VCVTUDQ2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rm)
  .value("VCVTUDQ2PSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rmb)
  .value("VCVTUDQ2PSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rmbk)
  .value("VCVTUDQ2PSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rmbkz)
  .value("VCVTUDQ2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rmk)
  .value("VCVTUDQ2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rmkz)
  .value("VCVTUDQ2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rr)
  .value("VCVTUDQ2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rrk)
  .value("VCVTUDQ2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZ256rrkz)
  .value("VCVTUDQ2PSZrm", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrm)
  .value("VCVTUDQ2PSZrmb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrmb)
  .value("VCVTUDQ2PSZrmbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrmbk)
  .value("VCVTUDQ2PSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrmbkz)
  .value("VCVTUDQ2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrmk)
  .value("VCVTUDQ2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrmkz)
  .value("VCVTUDQ2PSZrr", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrr)
  .value("VCVTUDQ2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrrb)
  .value("VCVTUDQ2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrrbk)
  .value("VCVTUDQ2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrrbkz)
  .value("VCVTUDQ2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrrk)
  .value("VCVTUDQ2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTUDQ2PSZrrkz)
  .value("VCVTUQQ2PDZ128rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rm)
  .value("VCVTUQQ2PDZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rmb)
  .value("VCVTUQQ2PDZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rmbk)
  .value("VCVTUQQ2PDZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rmbkz)
  .value("VCVTUQQ2PDZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rmk)
  .value("VCVTUQQ2PDZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rmkz)
  .value("VCVTUQQ2PDZ128rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rr)
  .value("VCVTUQQ2PDZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rrk)
  .value("VCVTUQQ2PDZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ128rrkz)
  .value("VCVTUQQ2PDZ256rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rm)
  .value("VCVTUQQ2PDZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rmb)
  .value("VCVTUQQ2PDZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rmbk)
  .value("VCVTUQQ2PDZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rmbkz)
  .value("VCVTUQQ2PDZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rmk)
  .value("VCVTUQQ2PDZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rmkz)
  .value("VCVTUQQ2PDZ256rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rr)
  .value("VCVTUQQ2PDZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rrk)
  .value("VCVTUQQ2PDZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZ256rrkz)
  .value("VCVTUQQ2PDZrm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrm)
  .value("VCVTUQQ2PDZrmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrmb)
  .value("VCVTUQQ2PDZrmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrmbk)
  .value("VCVTUQQ2PDZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrmbkz)
  .value("VCVTUQQ2PDZrmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrmk)
  .value("VCVTUQQ2PDZrmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrmkz)
  .value("VCVTUQQ2PDZrr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrr)
  .value("VCVTUQQ2PDZrrb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrrb)
  .value("VCVTUQQ2PDZrrbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrrbk)
  .value("VCVTUQQ2PDZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrrbkz)
  .value("VCVTUQQ2PDZrrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrrk)
  .value("VCVTUQQ2PDZrrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PDZrrkz)
  .value("VCVTUQQ2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rm)
  .value("VCVTUQQ2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rmb)
  .value("VCVTUQQ2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rmbk)
  .value("VCVTUQQ2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rmbkz)
  .value("VCVTUQQ2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rmk)
  .value("VCVTUQQ2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rmkz)
  .value("VCVTUQQ2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rr)
  .value("VCVTUQQ2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rrk)
  .value("VCVTUQQ2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ128rrkz)
  .value("VCVTUQQ2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rm)
  .value("VCVTUQQ2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rmb)
  .value("VCVTUQQ2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rmbk)
  .value("VCVTUQQ2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rmbkz)
  .value("VCVTUQQ2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rmk)
  .value("VCVTUQQ2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rmkz)
  .value("VCVTUQQ2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rr)
  .value("VCVTUQQ2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rrk)
  .value("VCVTUQQ2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZ256rrkz)
  .value("VCVTUQQ2PHZrm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrm)
  .value("VCVTUQQ2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrmb)
  .value("VCVTUQQ2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrmbk)
  .value("VCVTUQQ2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrmbkz)
  .value("VCVTUQQ2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrmk)
  .value("VCVTUQQ2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrmkz)
  .value("VCVTUQQ2PHZrr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrr)
  .value("VCVTUQQ2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrrb)
  .value("VCVTUQQ2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrrbk)
  .value("VCVTUQQ2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrrbkz)
  .value("VCVTUQQ2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrrk)
  .value("VCVTUQQ2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PHZrrkz)
  .value("VCVTUQQ2PSZ128rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rm)
  .value("VCVTUQQ2PSZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rmb)
  .value("VCVTUQQ2PSZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rmbk)
  .value("VCVTUQQ2PSZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rmbkz)
  .value("VCVTUQQ2PSZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rmk)
  .value("VCVTUQQ2PSZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rmkz)
  .value("VCVTUQQ2PSZ128rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rr)
  .value("VCVTUQQ2PSZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rrk)
  .value("VCVTUQQ2PSZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ128rrkz)
  .value("VCVTUQQ2PSZ256rm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rm)
  .value("VCVTUQQ2PSZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rmb)
  .value("VCVTUQQ2PSZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rmbk)
  .value("VCVTUQQ2PSZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rmbkz)
  .value("VCVTUQQ2PSZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rmk)
  .value("VCVTUQQ2PSZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rmkz)
  .value("VCVTUQQ2PSZ256rr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rr)
  .value("VCVTUQQ2PSZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rrk)
  .value("VCVTUQQ2PSZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZ256rrkz);
  opcodes.value("VCVTUQQ2PSZrm", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrm)
  .value("VCVTUQQ2PSZrmb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrmb)
  .value("VCVTUQQ2PSZrmbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrmbk)
  .value("VCVTUQQ2PSZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrmbkz)
  .value("VCVTUQQ2PSZrmk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrmk)
  .value("VCVTUQQ2PSZrmkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrmkz)
  .value("VCVTUQQ2PSZrr", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrr)
  .value("VCVTUQQ2PSZrrb", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrrb)
  .value("VCVTUQQ2PSZrrbk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrrbk)
  .value("VCVTUQQ2PSZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrrbkz)
  .value("VCVTUQQ2PSZrrk", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrrk)
  .value("VCVTUQQ2PSZrrkz", LIEF::assembly::x86::OPCODE::VCVTUQQ2PSZrrkz)
  .value("VCVTUSI2SDZrm", LIEF::assembly::x86::OPCODE::VCVTUSI2SDZrm)
  .value("VCVTUSI2SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SDZrm_Int)
  .value("VCVTUSI2SDZrr", LIEF::assembly::x86::OPCODE::VCVTUSI2SDZrr)
  .value("VCVTUSI2SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SDZrr_Int)
  .value("VCVTUSI2SHZrm", LIEF::assembly::x86::OPCODE::VCVTUSI2SHZrm)
  .value("VCVTUSI2SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SHZrm_Int)
  .value("VCVTUSI2SHZrr", LIEF::assembly::x86::OPCODE::VCVTUSI2SHZrr)
  .value("VCVTUSI2SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SHZrr_Int)
  .value("VCVTUSI2SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SHZrrb_Int)
  .value("VCVTUSI2SSZrm", LIEF::assembly::x86::OPCODE::VCVTUSI2SSZrm)
  .value("VCVTUSI2SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SSZrm_Int)
  .value("VCVTUSI2SSZrr", LIEF::assembly::x86::OPCODE::VCVTUSI2SSZrr)
  .value("VCVTUSI2SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SSZrr_Int)
  .value("VCVTUSI2SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTUSI2SSZrrb_Int)
  .value("VCVTUSI642SDZrm", LIEF::assembly::x86::OPCODE::VCVTUSI642SDZrm)
  .value("VCVTUSI642SDZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SDZrm_Int)
  .value("VCVTUSI642SDZrr", LIEF::assembly::x86::OPCODE::VCVTUSI642SDZrr)
  .value("VCVTUSI642SDZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SDZrr_Int)
  .value("VCVTUSI642SDZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SDZrrb_Int)
  .value("VCVTUSI642SHZrm", LIEF::assembly::x86::OPCODE::VCVTUSI642SHZrm)
  .value("VCVTUSI642SHZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SHZrm_Int)
  .value("VCVTUSI642SHZrr", LIEF::assembly::x86::OPCODE::VCVTUSI642SHZrr)
  .value("VCVTUSI642SHZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SHZrr_Int)
  .value("VCVTUSI642SHZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SHZrrb_Int)
  .value("VCVTUSI642SSZrm", LIEF::assembly::x86::OPCODE::VCVTUSI642SSZrm)
  .value("VCVTUSI642SSZrm_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SSZrm_Int)
  .value("VCVTUSI642SSZrr", LIEF::assembly::x86::OPCODE::VCVTUSI642SSZrr)
  .value("VCVTUSI642SSZrr_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SSZrr_Int)
  .value("VCVTUSI642SSZrrb_Int", LIEF::assembly::x86::OPCODE::VCVTUSI642SSZrrb_Int)
  .value("VCVTUW2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rm)
  .value("VCVTUW2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rmb)
  .value("VCVTUW2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rmbk)
  .value("VCVTUW2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rmbkz)
  .value("VCVTUW2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rmk)
  .value("VCVTUW2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rmkz)
  .value("VCVTUW2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rr)
  .value("VCVTUW2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rrk)
  .value("VCVTUW2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ128rrkz)
  .value("VCVTUW2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rm)
  .value("VCVTUW2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rmb)
  .value("VCVTUW2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rmbk)
  .value("VCVTUW2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rmbkz)
  .value("VCVTUW2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rmk)
  .value("VCVTUW2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rmkz)
  .value("VCVTUW2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rr)
  .value("VCVTUW2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rrk)
  .value("VCVTUW2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZ256rrkz)
  .value("VCVTUW2PHZrm", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrm)
  .value("VCVTUW2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrmb)
  .value("VCVTUW2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrmbk)
  .value("VCVTUW2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrmbkz)
  .value("VCVTUW2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrmk)
  .value("VCVTUW2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrmkz)
  .value("VCVTUW2PHZrr", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrr)
  .value("VCVTUW2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrrb)
  .value("VCVTUW2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrrbk)
  .value("VCVTUW2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrrbkz)
  .value("VCVTUW2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrrk)
  .value("VCVTUW2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTUW2PHZrrkz)
  .value("VCVTW2PHZ128rm", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rm)
  .value("VCVTW2PHZ128rmb", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rmb)
  .value("VCVTW2PHZ128rmbk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rmbk)
  .value("VCVTW2PHZ128rmbkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rmbkz)
  .value("VCVTW2PHZ128rmk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rmk)
  .value("VCVTW2PHZ128rmkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rmkz)
  .value("VCVTW2PHZ128rr", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rr)
  .value("VCVTW2PHZ128rrk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rrk)
  .value("VCVTW2PHZ128rrkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ128rrkz)
  .value("VCVTW2PHZ256rm", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rm)
  .value("VCVTW2PHZ256rmb", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rmb)
  .value("VCVTW2PHZ256rmbk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rmbk)
  .value("VCVTW2PHZ256rmbkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rmbkz)
  .value("VCVTW2PHZ256rmk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rmk)
  .value("VCVTW2PHZ256rmkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rmkz)
  .value("VCVTW2PHZ256rr", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rr)
  .value("VCVTW2PHZ256rrk", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rrk)
  .value("VCVTW2PHZ256rrkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZ256rrkz)
  .value("VCVTW2PHZrm", LIEF::assembly::x86::OPCODE::VCVTW2PHZrm)
  .value("VCVTW2PHZrmb", LIEF::assembly::x86::OPCODE::VCVTW2PHZrmb)
  .value("VCVTW2PHZrmbk", LIEF::assembly::x86::OPCODE::VCVTW2PHZrmbk)
  .value("VCVTW2PHZrmbkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZrmbkz)
  .value("VCVTW2PHZrmk", LIEF::assembly::x86::OPCODE::VCVTW2PHZrmk)
  .value("VCVTW2PHZrmkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZrmkz)
  .value("VCVTW2PHZrr", LIEF::assembly::x86::OPCODE::VCVTW2PHZrr)
  .value("VCVTW2PHZrrb", LIEF::assembly::x86::OPCODE::VCVTW2PHZrrb)
  .value("VCVTW2PHZrrbk", LIEF::assembly::x86::OPCODE::VCVTW2PHZrrbk)
  .value("VCVTW2PHZrrbkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZrrbkz)
  .value("VCVTW2PHZrrk", LIEF::assembly::x86::OPCODE::VCVTW2PHZrrk)
  .value("VCVTW2PHZrrkz", LIEF::assembly::x86::OPCODE::VCVTW2PHZrrkz)
  .value("VDBPSADBWZ128rmi", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rmi)
  .value("VDBPSADBWZ128rmik", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rmik)
  .value("VDBPSADBWZ128rmikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rmikz)
  .value("VDBPSADBWZ128rri", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rri)
  .value("VDBPSADBWZ128rrik", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rrik)
  .value("VDBPSADBWZ128rrikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZ128rrikz)
  .value("VDBPSADBWZ256rmi", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rmi)
  .value("VDBPSADBWZ256rmik", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rmik)
  .value("VDBPSADBWZ256rmikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rmikz)
  .value("VDBPSADBWZ256rri", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rri)
  .value("VDBPSADBWZ256rrik", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rrik)
  .value("VDBPSADBWZ256rrikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZ256rrikz)
  .value("VDBPSADBWZrmi", LIEF::assembly::x86::OPCODE::VDBPSADBWZrmi)
  .value("VDBPSADBWZrmik", LIEF::assembly::x86::OPCODE::VDBPSADBWZrmik)
  .value("VDBPSADBWZrmikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZrmikz)
  .value("VDBPSADBWZrri", LIEF::assembly::x86::OPCODE::VDBPSADBWZrri)
  .value("VDBPSADBWZrrik", LIEF::assembly::x86::OPCODE::VDBPSADBWZrrik)
  .value("VDBPSADBWZrrikz", LIEF::assembly::x86::OPCODE::VDBPSADBWZrrikz)
  .value("VDIVBF16Z128rm", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rm)
  .value("VDIVBF16Z128rmb", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rmb)
  .value("VDIVBF16Z128rmbk", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rmbk)
  .value("VDIVBF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rmbkz)
  .value("VDIVBF16Z128rmk", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rmk)
  .value("VDIVBF16Z128rmkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rmkz)
  .value("VDIVBF16Z128rr", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rr)
  .value("VDIVBF16Z128rrk", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rrk)
  .value("VDIVBF16Z128rrkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z128rrkz)
  .value("VDIVBF16Z256rm", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rm)
  .value("VDIVBF16Z256rmb", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rmb)
  .value("VDIVBF16Z256rmbk", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rmbk)
  .value("VDIVBF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rmbkz)
  .value("VDIVBF16Z256rmk", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rmk)
  .value("VDIVBF16Z256rmkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rmkz)
  .value("VDIVBF16Z256rr", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rr)
  .value("VDIVBF16Z256rrk", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rrk)
  .value("VDIVBF16Z256rrkz", LIEF::assembly::x86::OPCODE::VDIVBF16Z256rrkz)
  .value("VDIVBF16Zrm", LIEF::assembly::x86::OPCODE::VDIVBF16Zrm)
  .value("VDIVBF16Zrmb", LIEF::assembly::x86::OPCODE::VDIVBF16Zrmb)
  .value("VDIVBF16Zrmbk", LIEF::assembly::x86::OPCODE::VDIVBF16Zrmbk)
  .value("VDIVBF16Zrmbkz", LIEF::assembly::x86::OPCODE::VDIVBF16Zrmbkz)
  .value("VDIVBF16Zrmk", LIEF::assembly::x86::OPCODE::VDIVBF16Zrmk)
  .value("VDIVBF16Zrmkz", LIEF::assembly::x86::OPCODE::VDIVBF16Zrmkz)
  .value("VDIVBF16Zrr", LIEF::assembly::x86::OPCODE::VDIVBF16Zrr)
  .value("VDIVBF16Zrrk", LIEF::assembly::x86::OPCODE::VDIVBF16Zrrk)
  .value("VDIVBF16Zrrkz", LIEF::assembly::x86::OPCODE::VDIVBF16Zrrkz)
  .value("VDIVPDYrm", LIEF::assembly::x86::OPCODE::VDIVPDYrm)
  .value("VDIVPDYrr", LIEF::assembly::x86::OPCODE::VDIVPDYrr)
  .value("VDIVPDZ128rm", LIEF::assembly::x86::OPCODE::VDIVPDZ128rm)
  .value("VDIVPDZ128rmb", LIEF::assembly::x86::OPCODE::VDIVPDZ128rmb)
  .value("VDIVPDZ128rmbk", LIEF::assembly::x86::OPCODE::VDIVPDZ128rmbk)
  .value("VDIVPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VDIVPDZ128rmbkz)
  .value("VDIVPDZ128rmk", LIEF::assembly::x86::OPCODE::VDIVPDZ128rmk)
  .value("VDIVPDZ128rmkz", LIEF::assembly::x86::OPCODE::VDIVPDZ128rmkz)
  .value("VDIVPDZ128rr", LIEF::assembly::x86::OPCODE::VDIVPDZ128rr)
  .value("VDIVPDZ128rrk", LIEF::assembly::x86::OPCODE::VDIVPDZ128rrk)
  .value("VDIVPDZ128rrkz", LIEF::assembly::x86::OPCODE::VDIVPDZ128rrkz)
  .value("VDIVPDZ256rm", LIEF::assembly::x86::OPCODE::VDIVPDZ256rm)
  .value("VDIVPDZ256rmb", LIEF::assembly::x86::OPCODE::VDIVPDZ256rmb)
  .value("VDIVPDZ256rmbk", LIEF::assembly::x86::OPCODE::VDIVPDZ256rmbk)
  .value("VDIVPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VDIVPDZ256rmbkz)
  .value("VDIVPDZ256rmk", LIEF::assembly::x86::OPCODE::VDIVPDZ256rmk)
  .value("VDIVPDZ256rmkz", LIEF::assembly::x86::OPCODE::VDIVPDZ256rmkz)
  .value("VDIVPDZ256rr", LIEF::assembly::x86::OPCODE::VDIVPDZ256rr)
  .value("VDIVPDZ256rrk", LIEF::assembly::x86::OPCODE::VDIVPDZ256rrk)
  .value("VDIVPDZ256rrkz", LIEF::assembly::x86::OPCODE::VDIVPDZ256rrkz)
  .value("VDIVPDZrm", LIEF::assembly::x86::OPCODE::VDIVPDZrm)
  .value("VDIVPDZrmb", LIEF::assembly::x86::OPCODE::VDIVPDZrmb)
  .value("VDIVPDZrmbk", LIEF::assembly::x86::OPCODE::VDIVPDZrmbk)
  .value("VDIVPDZrmbkz", LIEF::assembly::x86::OPCODE::VDIVPDZrmbkz)
  .value("VDIVPDZrmk", LIEF::assembly::x86::OPCODE::VDIVPDZrmk)
  .value("VDIVPDZrmkz", LIEF::assembly::x86::OPCODE::VDIVPDZrmkz)
  .value("VDIVPDZrr", LIEF::assembly::x86::OPCODE::VDIVPDZrr)
  .value("VDIVPDZrrb", LIEF::assembly::x86::OPCODE::VDIVPDZrrb)
  .value("VDIVPDZrrbk", LIEF::assembly::x86::OPCODE::VDIVPDZrrbk)
  .value("VDIVPDZrrbkz", LIEF::assembly::x86::OPCODE::VDIVPDZrrbkz)
  .value("VDIVPDZrrk", LIEF::assembly::x86::OPCODE::VDIVPDZrrk)
  .value("VDIVPDZrrkz", LIEF::assembly::x86::OPCODE::VDIVPDZrrkz)
  .value("VDIVPDrm", LIEF::assembly::x86::OPCODE::VDIVPDrm)
  .value("VDIVPDrr", LIEF::assembly::x86::OPCODE::VDIVPDrr)
  .value("VDIVPHZ128rm", LIEF::assembly::x86::OPCODE::VDIVPHZ128rm)
  .value("VDIVPHZ128rmb", LIEF::assembly::x86::OPCODE::VDIVPHZ128rmb)
  .value("VDIVPHZ128rmbk", LIEF::assembly::x86::OPCODE::VDIVPHZ128rmbk)
  .value("VDIVPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VDIVPHZ128rmbkz)
  .value("VDIVPHZ128rmk", LIEF::assembly::x86::OPCODE::VDIVPHZ128rmk)
  .value("VDIVPHZ128rmkz", LIEF::assembly::x86::OPCODE::VDIVPHZ128rmkz)
  .value("VDIVPHZ128rr", LIEF::assembly::x86::OPCODE::VDIVPHZ128rr)
  .value("VDIVPHZ128rrk", LIEF::assembly::x86::OPCODE::VDIVPHZ128rrk)
  .value("VDIVPHZ128rrkz", LIEF::assembly::x86::OPCODE::VDIVPHZ128rrkz)
  .value("VDIVPHZ256rm", LIEF::assembly::x86::OPCODE::VDIVPHZ256rm)
  .value("VDIVPHZ256rmb", LIEF::assembly::x86::OPCODE::VDIVPHZ256rmb)
  .value("VDIVPHZ256rmbk", LIEF::assembly::x86::OPCODE::VDIVPHZ256rmbk)
  .value("VDIVPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VDIVPHZ256rmbkz)
  .value("VDIVPHZ256rmk", LIEF::assembly::x86::OPCODE::VDIVPHZ256rmk)
  .value("VDIVPHZ256rmkz", LIEF::assembly::x86::OPCODE::VDIVPHZ256rmkz)
  .value("VDIVPHZ256rr", LIEF::assembly::x86::OPCODE::VDIVPHZ256rr)
  .value("VDIVPHZ256rrk", LIEF::assembly::x86::OPCODE::VDIVPHZ256rrk)
  .value("VDIVPHZ256rrkz", LIEF::assembly::x86::OPCODE::VDIVPHZ256rrkz)
  .value("VDIVPHZrm", LIEF::assembly::x86::OPCODE::VDIVPHZrm)
  .value("VDIVPHZrmb", LIEF::assembly::x86::OPCODE::VDIVPHZrmb)
  .value("VDIVPHZrmbk", LIEF::assembly::x86::OPCODE::VDIVPHZrmbk)
  .value("VDIVPHZrmbkz", LIEF::assembly::x86::OPCODE::VDIVPHZrmbkz)
  .value("VDIVPHZrmk", LIEF::assembly::x86::OPCODE::VDIVPHZrmk)
  .value("VDIVPHZrmkz", LIEF::assembly::x86::OPCODE::VDIVPHZrmkz)
  .value("VDIVPHZrr", LIEF::assembly::x86::OPCODE::VDIVPHZrr)
  .value("VDIVPHZrrb", LIEF::assembly::x86::OPCODE::VDIVPHZrrb)
  .value("VDIVPHZrrbk", LIEF::assembly::x86::OPCODE::VDIVPHZrrbk)
  .value("VDIVPHZrrbkz", LIEF::assembly::x86::OPCODE::VDIVPHZrrbkz)
  .value("VDIVPHZrrk", LIEF::assembly::x86::OPCODE::VDIVPHZrrk)
  .value("VDIVPHZrrkz", LIEF::assembly::x86::OPCODE::VDIVPHZrrkz)
  .value("VDIVPSYrm", LIEF::assembly::x86::OPCODE::VDIVPSYrm)
  .value("VDIVPSYrr", LIEF::assembly::x86::OPCODE::VDIVPSYrr)
  .value("VDIVPSZ128rm", LIEF::assembly::x86::OPCODE::VDIVPSZ128rm)
  .value("VDIVPSZ128rmb", LIEF::assembly::x86::OPCODE::VDIVPSZ128rmb)
  .value("VDIVPSZ128rmbk", LIEF::assembly::x86::OPCODE::VDIVPSZ128rmbk)
  .value("VDIVPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VDIVPSZ128rmbkz)
  .value("VDIVPSZ128rmk", LIEF::assembly::x86::OPCODE::VDIVPSZ128rmk)
  .value("VDIVPSZ128rmkz", LIEF::assembly::x86::OPCODE::VDIVPSZ128rmkz)
  .value("VDIVPSZ128rr", LIEF::assembly::x86::OPCODE::VDIVPSZ128rr)
  .value("VDIVPSZ128rrk", LIEF::assembly::x86::OPCODE::VDIVPSZ128rrk)
  .value("VDIVPSZ128rrkz", LIEF::assembly::x86::OPCODE::VDIVPSZ128rrkz)
  .value("VDIVPSZ256rm", LIEF::assembly::x86::OPCODE::VDIVPSZ256rm)
  .value("VDIVPSZ256rmb", LIEF::assembly::x86::OPCODE::VDIVPSZ256rmb)
  .value("VDIVPSZ256rmbk", LIEF::assembly::x86::OPCODE::VDIVPSZ256rmbk)
  .value("VDIVPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VDIVPSZ256rmbkz)
  .value("VDIVPSZ256rmk", LIEF::assembly::x86::OPCODE::VDIVPSZ256rmk)
  .value("VDIVPSZ256rmkz", LIEF::assembly::x86::OPCODE::VDIVPSZ256rmkz)
  .value("VDIVPSZ256rr", LIEF::assembly::x86::OPCODE::VDIVPSZ256rr)
  .value("VDIVPSZ256rrk", LIEF::assembly::x86::OPCODE::VDIVPSZ256rrk)
  .value("VDIVPSZ256rrkz", LIEF::assembly::x86::OPCODE::VDIVPSZ256rrkz)
  .value("VDIVPSZrm", LIEF::assembly::x86::OPCODE::VDIVPSZrm)
  .value("VDIVPSZrmb", LIEF::assembly::x86::OPCODE::VDIVPSZrmb)
  .value("VDIVPSZrmbk", LIEF::assembly::x86::OPCODE::VDIVPSZrmbk)
  .value("VDIVPSZrmbkz", LIEF::assembly::x86::OPCODE::VDIVPSZrmbkz)
  .value("VDIVPSZrmk", LIEF::assembly::x86::OPCODE::VDIVPSZrmk)
  .value("VDIVPSZrmkz", LIEF::assembly::x86::OPCODE::VDIVPSZrmkz)
  .value("VDIVPSZrr", LIEF::assembly::x86::OPCODE::VDIVPSZrr)
  .value("VDIVPSZrrb", LIEF::assembly::x86::OPCODE::VDIVPSZrrb)
  .value("VDIVPSZrrbk", LIEF::assembly::x86::OPCODE::VDIVPSZrrbk)
  .value("VDIVPSZrrbkz", LIEF::assembly::x86::OPCODE::VDIVPSZrrbkz)
  .value("VDIVPSZrrk", LIEF::assembly::x86::OPCODE::VDIVPSZrrk)
  .value("VDIVPSZrrkz", LIEF::assembly::x86::OPCODE::VDIVPSZrrkz)
  .value("VDIVPSrm", LIEF::assembly::x86::OPCODE::VDIVPSrm)
  .value("VDIVPSrr", LIEF::assembly::x86::OPCODE::VDIVPSrr)
  .value("VDIVSDZrm", LIEF::assembly::x86::OPCODE::VDIVSDZrm)
  .value("VDIVSDZrm_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrm_Int)
  .value("VDIVSDZrmk_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrmk_Int)
  .value("VDIVSDZrmkz_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrmkz_Int)
  .value("VDIVSDZrr", LIEF::assembly::x86::OPCODE::VDIVSDZrr)
  .value("VDIVSDZrr_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrr_Int)
  .value("VDIVSDZrrb_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrrb_Int)
  .value("VDIVSDZrrbk_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrrbk_Int)
  .value("VDIVSDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrrbkz_Int)
  .value("VDIVSDZrrk_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrrk_Int)
  .value("VDIVSDZrrkz_Int", LIEF::assembly::x86::OPCODE::VDIVSDZrrkz_Int)
  .value("VDIVSDrm", LIEF::assembly::x86::OPCODE::VDIVSDrm)
  .value("VDIVSDrm_Int", LIEF::assembly::x86::OPCODE::VDIVSDrm_Int)
  .value("VDIVSDrr", LIEF::assembly::x86::OPCODE::VDIVSDrr)
  .value("VDIVSDrr_Int", LIEF::assembly::x86::OPCODE::VDIVSDrr_Int)
  .value("VDIVSHZrm", LIEF::assembly::x86::OPCODE::VDIVSHZrm)
  .value("VDIVSHZrm_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrm_Int)
  .value("VDIVSHZrmk_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrmk_Int)
  .value("VDIVSHZrmkz_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrmkz_Int)
  .value("VDIVSHZrr", LIEF::assembly::x86::OPCODE::VDIVSHZrr)
  .value("VDIVSHZrr_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrr_Int)
  .value("VDIVSHZrrb_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrrb_Int)
  .value("VDIVSHZrrbk_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrrbk_Int)
  .value("VDIVSHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrrbkz_Int)
  .value("VDIVSHZrrk_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrrk_Int)
  .value("VDIVSHZrrkz_Int", LIEF::assembly::x86::OPCODE::VDIVSHZrrkz_Int)
  .value("VDIVSSZrm", LIEF::assembly::x86::OPCODE::VDIVSSZrm)
  .value("VDIVSSZrm_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrm_Int)
  .value("VDIVSSZrmk_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrmk_Int)
  .value("VDIVSSZrmkz_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrmkz_Int)
  .value("VDIVSSZrr", LIEF::assembly::x86::OPCODE::VDIVSSZrr)
  .value("VDIVSSZrr_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrr_Int)
  .value("VDIVSSZrrb_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrrb_Int)
  .value("VDIVSSZrrbk_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrrbk_Int)
  .value("VDIVSSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrrbkz_Int)
  .value("VDIVSSZrrk_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrrk_Int)
  .value("VDIVSSZrrkz_Int", LIEF::assembly::x86::OPCODE::VDIVSSZrrkz_Int)
  .value("VDIVSSrm", LIEF::assembly::x86::OPCODE::VDIVSSrm)
  .value("VDIVSSrm_Int", LIEF::assembly::x86::OPCODE::VDIVSSrm_Int)
  .value("VDIVSSrr", LIEF::assembly::x86::OPCODE::VDIVSSrr)
  .value("VDIVSSrr_Int", LIEF::assembly::x86::OPCODE::VDIVSSrr_Int)
  .value("VDPBF16PSZ128m", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128m)
  .value("VDPBF16PSZ128mb", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128mb)
  .value("VDPBF16PSZ128mbk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128mbk)
  .value("VDPBF16PSZ128mbkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128mbkz)
  .value("VDPBF16PSZ128mk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128mk)
  .value("VDPBF16PSZ128mkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128mkz)
  .value("VDPBF16PSZ128r", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128r)
  .value("VDPBF16PSZ128rk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128rk)
  .value("VDPBF16PSZ128rkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ128rkz)
  .value("VDPBF16PSZ256m", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256m)
  .value("VDPBF16PSZ256mb", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256mb)
  .value("VDPBF16PSZ256mbk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256mbk)
  .value("VDPBF16PSZ256mbkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256mbkz)
  .value("VDPBF16PSZ256mk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256mk)
  .value("VDPBF16PSZ256mkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256mkz);
  opcodes.value("VDPBF16PSZ256r", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256r)
  .value("VDPBF16PSZ256rk", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256rk)
  .value("VDPBF16PSZ256rkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZ256rkz)
  .value("VDPBF16PSZm", LIEF::assembly::x86::OPCODE::VDPBF16PSZm)
  .value("VDPBF16PSZmb", LIEF::assembly::x86::OPCODE::VDPBF16PSZmb)
  .value("VDPBF16PSZmbk", LIEF::assembly::x86::OPCODE::VDPBF16PSZmbk)
  .value("VDPBF16PSZmbkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZmbkz)
  .value("VDPBF16PSZmk", LIEF::assembly::x86::OPCODE::VDPBF16PSZmk)
  .value("VDPBF16PSZmkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZmkz)
  .value("VDPBF16PSZr", LIEF::assembly::x86::OPCODE::VDPBF16PSZr)
  .value("VDPBF16PSZrk", LIEF::assembly::x86::OPCODE::VDPBF16PSZrk)
  .value("VDPBF16PSZrkz", LIEF::assembly::x86::OPCODE::VDPBF16PSZrkz)
  .value("VDPPDrmi", LIEF::assembly::x86::OPCODE::VDPPDrmi)
  .value("VDPPDrri", LIEF::assembly::x86::OPCODE::VDPPDrri)
  .value("VDPPHPSZ128m", LIEF::assembly::x86::OPCODE::VDPPHPSZ128m)
  .value("VDPPHPSZ128mb", LIEF::assembly::x86::OPCODE::VDPPHPSZ128mb)
  .value("VDPPHPSZ128mbk", LIEF::assembly::x86::OPCODE::VDPPHPSZ128mbk)
  .value("VDPPHPSZ128mbkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ128mbkz)
  .value("VDPPHPSZ128mk", LIEF::assembly::x86::OPCODE::VDPPHPSZ128mk)
  .value("VDPPHPSZ128mkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ128mkz)
  .value("VDPPHPSZ128r", LIEF::assembly::x86::OPCODE::VDPPHPSZ128r)
  .value("VDPPHPSZ128rk", LIEF::assembly::x86::OPCODE::VDPPHPSZ128rk)
  .value("VDPPHPSZ128rkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ128rkz)
  .value("VDPPHPSZ256m", LIEF::assembly::x86::OPCODE::VDPPHPSZ256m)
  .value("VDPPHPSZ256mb", LIEF::assembly::x86::OPCODE::VDPPHPSZ256mb)
  .value("VDPPHPSZ256mbk", LIEF::assembly::x86::OPCODE::VDPPHPSZ256mbk)
  .value("VDPPHPSZ256mbkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ256mbkz)
  .value("VDPPHPSZ256mk", LIEF::assembly::x86::OPCODE::VDPPHPSZ256mk)
  .value("VDPPHPSZ256mkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ256mkz)
  .value("VDPPHPSZ256r", LIEF::assembly::x86::OPCODE::VDPPHPSZ256r)
  .value("VDPPHPSZ256rk", LIEF::assembly::x86::OPCODE::VDPPHPSZ256rk)
  .value("VDPPHPSZ256rkz", LIEF::assembly::x86::OPCODE::VDPPHPSZ256rkz)
  .value("VDPPHPSZm", LIEF::assembly::x86::OPCODE::VDPPHPSZm)
  .value("VDPPHPSZmb", LIEF::assembly::x86::OPCODE::VDPPHPSZmb)
  .value("VDPPHPSZmbk", LIEF::assembly::x86::OPCODE::VDPPHPSZmbk)
  .value("VDPPHPSZmbkz", LIEF::assembly::x86::OPCODE::VDPPHPSZmbkz)
  .value("VDPPHPSZmk", LIEF::assembly::x86::OPCODE::VDPPHPSZmk)
  .value("VDPPHPSZmkz", LIEF::assembly::x86::OPCODE::VDPPHPSZmkz)
  .value("VDPPHPSZr", LIEF::assembly::x86::OPCODE::VDPPHPSZr)
  .value("VDPPHPSZrk", LIEF::assembly::x86::OPCODE::VDPPHPSZrk)
  .value("VDPPHPSZrkz", LIEF::assembly::x86::OPCODE::VDPPHPSZrkz)
  .value("VDPPSYrmi", LIEF::assembly::x86::OPCODE::VDPPSYrmi)
  .value("VDPPSYrri", LIEF::assembly::x86::OPCODE::VDPPSYrri)
  .value("VDPPSrmi", LIEF::assembly::x86::OPCODE::VDPPSrmi)
  .value("VDPPSrri", LIEF::assembly::x86::OPCODE::VDPPSrri)
  .value("VERRm", LIEF::assembly::x86::OPCODE::VERRm)
  .value("VERRr", LIEF::assembly::x86::OPCODE::VERRr)
  .value("VERWm", LIEF::assembly::x86::OPCODE::VERWm)
  .value("VERWr", LIEF::assembly::x86::OPCODE::VERWr)
  .value("VEXP2PDZm", LIEF::assembly::x86::OPCODE::VEXP2PDZm)
  .value("VEXP2PDZmb", LIEF::assembly::x86::OPCODE::VEXP2PDZmb)
  .value("VEXP2PDZmbk", LIEF::assembly::x86::OPCODE::VEXP2PDZmbk)
  .value("VEXP2PDZmbkz", LIEF::assembly::x86::OPCODE::VEXP2PDZmbkz)
  .value("VEXP2PDZmk", LIEF::assembly::x86::OPCODE::VEXP2PDZmk)
  .value("VEXP2PDZmkz", LIEF::assembly::x86::OPCODE::VEXP2PDZmkz)
  .value("VEXP2PDZr", LIEF::assembly::x86::OPCODE::VEXP2PDZr)
  .value("VEXP2PDZrb", LIEF::assembly::x86::OPCODE::VEXP2PDZrb)
  .value("VEXP2PDZrbk", LIEF::assembly::x86::OPCODE::VEXP2PDZrbk)
  .value("VEXP2PDZrbkz", LIEF::assembly::x86::OPCODE::VEXP2PDZrbkz)
  .value("VEXP2PDZrk", LIEF::assembly::x86::OPCODE::VEXP2PDZrk)
  .value("VEXP2PDZrkz", LIEF::assembly::x86::OPCODE::VEXP2PDZrkz)
  .value("VEXP2PSZm", LIEF::assembly::x86::OPCODE::VEXP2PSZm)
  .value("VEXP2PSZmb", LIEF::assembly::x86::OPCODE::VEXP2PSZmb)
  .value("VEXP2PSZmbk", LIEF::assembly::x86::OPCODE::VEXP2PSZmbk)
  .value("VEXP2PSZmbkz", LIEF::assembly::x86::OPCODE::VEXP2PSZmbkz)
  .value("VEXP2PSZmk", LIEF::assembly::x86::OPCODE::VEXP2PSZmk)
  .value("VEXP2PSZmkz", LIEF::assembly::x86::OPCODE::VEXP2PSZmkz)
  .value("VEXP2PSZr", LIEF::assembly::x86::OPCODE::VEXP2PSZr)
  .value("VEXP2PSZrb", LIEF::assembly::x86::OPCODE::VEXP2PSZrb)
  .value("VEXP2PSZrbk", LIEF::assembly::x86::OPCODE::VEXP2PSZrbk)
  .value("VEXP2PSZrbkz", LIEF::assembly::x86::OPCODE::VEXP2PSZrbkz)
  .value("VEXP2PSZrk", LIEF::assembly::x86::OPCODE::VEXP2PSZrk)
  .value("VEXP2PSZrkz", LIEF::assembly::x86::OPCODE::VEXP2PSZrkz)
  .value("VEXPANDPDZ128rm", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rm)
  .value("VEXPANDPDZ128rmk", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rmk)
  .value("VEXPANDPDZ128rmkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rmkz)
  .value("VEXPANDPDZ128rr", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rr)
  .value("VEXPANDPDZ128rrk", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rrk)
  .value("VEXPANDPDZ128rrkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZ128rrkz)
  .value("VEXPANDPDZ256rm", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rm)
  .value("VEXPANDPDZ256rmk", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rmk)
  .value("VEXPANDPDZ256rmkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rmkz)
  .value("VEXPANDPDZ256rr", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rr)
  .value("VEXPANDPDZ256rrk", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rrk)
  .value("VEXPANDPDZ256rrkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZ256rrkz)
  .value("VEXPANDPDZrm", LIEF::assembly::x86::OPCODE::VEXPANDPDZrm)
  .value("VEXPANDPDZrmk", LIEF::assembly::x86::OPCODE::VEXPANDPDZrmk)
  .value("VEXPANDPDZrmkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZrmkz)
  .value("VEXPANDPDZrr", LIEF::assembly::x86::OPCODE::VEXPANDPDZrr)
  .value("VEXPANDPDZrrk", LIEF::assembly::x86::OPCODE::VEXPANDPDZrrk)
  .value("VEXPANDPDZrrkz", LIEF::assembly::x86::OPCODE::VEXPANDPDZrrkz)
  .value("VEXPANDPSZ128rm", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rm)
  .value("VEXPANDPSZ128rmk", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rmk)
  .value("VEXPANDPSZ128rmkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rmkz)
  .value("VEXPANDPSZ128rr", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rr)
  .value("VEXPANDPSZ128rrk", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rrk)
  .value("VEXPANDPSZ128rrkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZ128rrkz)
  .value("VEXPANDPSZ256rm", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rm)
  .value("VEXPANDPSZ256rmk", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rmk)
  .value("VEXPANDPSZ256rmkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rmkz)
  .value("VEXPANDPSZ256rr", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rr)
  .value("VEXPANDPSZ256rrk", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rrk)
  .value("VEXPANDPSZ256rrkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZ256rrkz)
  .value("VEXPANDPSZrm", LIEF::assembly::x86::OPCODE::VEXPANDPSZrm)
  .value("VEXPANDPSZrmk", LIEF::assembly::x86::OPCODE::VEXPANDPSZrmk)
  .value("VEXPANDPSZrmkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZrmkz)
  .value("VEXPANDPSZrr", LIEF::assembly::x86::OPCODE::VEXPANDPSZrr)
  .value("VEXPANDPSZrrk", LIEF::assembly::x86::OPCODE::VEXPANDPSZrrk)
  .value("VEXPANDPSZrrkz", LIEF::assembly::x86::OPCODE::VEXPANDPSZrrkz)
  .value("VEXTRACTF128mri", LIEF::assembly::x86::OPCODE::VEXTRACTF128mri)
  .value("VEXTRACTF128rri", LIEF::assembly::x86::OPCODE::VEXTRACTF128rri)
  .value("VEXTRACTF32X4Z256mri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Z256mri)
  .value("VEXTRACTF32X4Z256mrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Z256mrik)
  .value("VEXTRACTF32X4Z256rri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Z256rri)
  .value("VEXTRACTF32X4Z256rrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Z256rrik)
  .value("VEXTRACTF32X4Z256rrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Z256rrikz)
  .value("VEXTRACTF32X4Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Zmri)
  .value("VEXTRACTF32X4Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Zmrik)
  .value("VEXTRACTF32X4Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Zrri)
  .value("VEXTRACTF32X4Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Zrrik)
  .value("VEXTRACTF32X4Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF32X4Zrrikz)
  .value("VEXTRACTF32X8Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X8Zmri)
  .value("VEXTRACTF32X8Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X8Zmrik)
  .value("VEXTRACTF32X8Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTF32X8Zrri)
  .value("VEXTRACTF32X8Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTF32X8Zrrik)
  .value("VEXTRACTF32X8Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF32X8Zrrikz)
  .value("VEXTRACTF64X2Z256mri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Z256mri)
  .value("VEXTRACTF64X2Z256mrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Z256mrik)
  .value("VEXTRACTF64X2Z256rri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Z256rri)
  .value("VEXTRACTF64X2Z256rrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Z256rrik)
  .value("VEXTRACTF64X2Z256rrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Z256rrikz)
  .value("VEXTRACTF64X2Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Zmri)
  .value("VEXTRACTF64X2Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Zmrik)
  .value("VEXTRACTF64X2Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Zrri)
  .value("VEXTRACTF64X2Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Zrrik)
  .value("VEXTRACTF64X2Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF64X2Zrrikz)
  .value("VEXTRACTF64X4Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X4Zmri)
  .value("VEXTRACTF64X4Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X4Zmrik)
  .value("VEXTRACTF64X4Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTF64X4Zrri)
  .value("VEXTRACTF64X4Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTF64X4Zrrik)
  .value("VEXTRACTF64X4Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTF64X4Zrrikz)
  .value("VEXTRACTI128mri", LIEF::assembly::x86::OPCODE::VEXTRACTI128mri)
  .value("VEXTRACTI128rri", LIEF::assembly::x86::OPCODE::VEXTRACTI128rri)
  .value("VEXTRACTI32X4Z256mri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Z256mri)
  .value("VEXTRACTI32X4Z256mrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Z256mrik)
  .value("VEXTRACTI32X4Z256rri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Z256rri)
  .value("VEXTRACTI32X4Z256rrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Z256rrik)
  .value("VEXTRACTI32X4Z256rrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Z256rrikz)
  .value("VEXTRACTI32X4Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Zmri)
  .value("VEXTRACTI32X4Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Zmrik)
  .value("VEXTRACTI32X4Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Zrri)
  .value("VEXTRACTI32X4Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Zrrik)
  .value("VEXTRACTI32X4Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI32X4Zrrikz)
  .value("VEXTRACTI32X8Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X8Zmri)
  .value("VEXTRACTI32X8Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X8Zmrik)
  .value("VEXTRACTI32X8Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTI32X8Zrri)
  .value("VEXTRACTI32X8Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTI32X8Zrrik)
  .value("VEXTRACTI32X8Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI32X8Zrrikz)
  .value("VEXTRACTI64X2Z256mri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Z256mri)
  .value("VEXTRACTI64X2Z256mrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Z256mrik)
  .value("VEXTRACTI64X2Z256rri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Z256rri)
  .value("VEXTRACTI64X2Z256rrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Z256rrik)
  .value("VEXTRACTI64X2Z256rrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Z256rrikz)
  .value("VEXTRACTI64X2Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Zmri)
  .value("VEXTRACTI64X2Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Zmrik)
  .value("VEXTRACTI64X2Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Zrri)
  .value("VEXTRACTI64X2Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Zrrik)
  .value("VEXTRACTI64X2Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI64X2Zrrikz)
  .value("VEXTRACTI64X4Zmri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X4Zmri)
  .value("VEXTRACTI64X4Zmrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X4Zmrik)
  .value("VEXTRACTI64X4Zrri", LIEF::assembly::x86::OPCODE::VEXTRACTI64X4Zrri)
  .value("VEXTRACTI64X4Zrrik", LIEF::assembly::x86::OPCODE::VEXTRACTI64X4Zrrik)
  .value("VEXTRACTI64X4Zrrikz", LIEF::assembly::x86::OPCODE::VEXTRACTI64X4Zrrikz)
  .value("VEXTRACTPSZmri", LIEF::assembly::x86::OPCODE::VEXTRACTPSZmri)
  .value("VEXTRACTPSZrri", LIEF::assembly::x86::OPCODE::VEXTRACTPSZrri)
  .value("VEXTRACTPSmri", LIEF::assembly::x86::OPCODE::VEXTRACTPSmri)
  .value("VEXTRACTPSrri", LIEF::assembly::x86::OPCODE::VEXTRACTPSrri)
  .value("VFCMADDCPHZ128m", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128m)
  .value("VFCMADDCPHZ128mb", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128mb)
  .value("VFCMADDCPHZ128mbk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128mbk)
  .value("VFCMADDCPHZ128mbkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128mbkz)
  .value("VFCMADDCPHZ128mk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128mk)
  .value("VFCMADDCPHZ128mkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128mkz)
  .value("VFCMADDCPHZ128r", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128r)
  .value("VFCMADDCPHZ128rk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128rk)
  .value("VFCMADDCPHZ128rkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ128rkz)
  .value("VFCMADDCPHZ256m", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256m)
  .value("VFCMADDCPHZ256mb", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256mb)
  .value("VFCMADDCPHZ256mbk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256mbk)
  .value("VFCMADDCPHZ256mbkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256mbkz)
  .value("VFCMADDCPHZ256mk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256mk)
  .value("VFCMADDCPHZ256mkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256mkz)
  .value("VFCMADDCPHZ256r", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256r)
  .value("VFCMADDCPHZ256rk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256rk)
  .value("VFCMADDCPHZ256rkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZ256rkz)
  .value("VFCMADDCPHZm", LIEF::assembly::x86::OPCODE::VFCMADDCPHZm)
  .value("VFCMADDCPHZmb", LIEF::assembly::x86::OPCODE::VFCMADDCPHZmb)
  .value("VFCMADDCPHZmbk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZmbk)
  .value("VFCMADDCPHZmbkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZmbkz)
  .value("VFCMADDCPHZmk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZmk)
  .value("VFCMADDCPHZmkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZmkz)
  .value("VFCMADDCPHZr", LIEF::assembly::x86::OPCODE::VFCMADDCPHZr)
  .value("VFCMADDCPHZrb", LIEF::assembly::x86::OPCODE::VFCMADDCPHZrb)
  .value("VFCMADDCPHZrbk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZrbk)
  .value("VFCMADDCPHZrbkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZrbkz)
  .value("VFCMADDCPHZrk", LIEF::assembly::x86::OPCODE::VFCMADDCPHZrk)
  .value("VFCMADDCPHZrkz", LIEF::assembly::x86::OPCODE::VFCMADDCPHZrkz)
  .value("VFCMADDCSHZm", LIEF::assembly::x86::OPCODE::VFCMADDCSHZm)
  .value("VFCMADDCSHZmk", LIEF::assembly::x86::OPCODE::VFCMADDCSHZmk)
  .value("VFCMADDCSHZmkz", LIEF::assembly::x86::OPCODE::VFCMADDCSHZmkz)
  .value("VFCMADDCSHZr", LIEF::assembly::x86::OPCODE::VFCMADDCSHZr)
  .value("VFCMADDCSHZrb", LIEF::assembly::x86::OPCODE::VFCMADDCSHZrb)
  .value("VFCMADDCSHZrbk", LIEF::assembly::x86::OPCODE::VFCMADDCSHZrbk)
  .value("VFCMADDCSHZrbkz", LIEF::assembly::x86::OPCODE::VFCMADDCSHZrbkz)
  .value("VFCMADDCSHZrk", LIEF::assembly::x86::OPCODE::VFCMADDCSHZrk)
  .value("VFCMADDCSHZrkz", LIEF::assembly::x86::OPCODE::VFCMADDCSHZrkz)
  .value("VFCMULCPHZ128rm", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rm)
  .value("VFCMULCPHZ128rmb", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rmb)
  .value("VFCMULCPHZ128rmbk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rmbk)
  .value("VFCMULCPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rmbkz)
  .value("VFCMULCPHZ128rmk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rmk)
  .value("VFCMULCPHZ128rmkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rmkz)
  .value("VFCMULCPHZ128rr", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rr)
  .value("VFCMULCPHZ128rrk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rrk)
  .value("VFCMULCPHZ128rrkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ128rrkz)
  .value("VFCMULCPHZ256rm", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rm)
  .value("VFCMULCPHZ256rmb", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rmb)
  .value("VFCMULCPHZ256rmbk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rmbk)
  .value("VFCMULCPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rmbkz)
  .value("VFCMULCPHZ256rmk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rmk)
  .value("VFCMULCPHZ256rmkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rmkz)
  .value("VFCMULCPHZ256rr", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rr)
  .value("VFCMULCPHZ256rrk", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rrk)
  .value("VFCMULCPHZ256rrkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZ256rrkz)
  .value("VFCMULCPHZrm", LIEF::assembly::x86::OPCODE::VFCMULCPHZrm)
  .value("VFCMULCPHZrmb", LIEF::assembly::x86::OPCODE::VFCMULCPHZrmb)
  .value("VFCMULCPHZrmbk", LIEF::assembly::x86::OPCODE::VFCMULCPHZrmbk)
  .value("VFCMULCPHZrmbkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZrmbkz)
  .value("VFCMULCPHZrmk", LIEF::assembly::x86::OPCODE::VFCMULCPHZrmk)
  .value("VFCMULCPHZrmkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZrmkz)
  .value("VFCMULCPHZrr", LIEF::assembly::x86::OPCODE::VFCMULCPHZrr)
  .value("VFCMULCPHZrrb", LIEF::assembly::x86::OPCODE::VFCMULCPHZrrb)
  .value("VFCMULCPHZrrbk", LIEF::assembly::x86::OPCODE::VFCMULCPHZrrbk)
  .value("VFCMULCPHZrrbkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZrrbkz)
  .value("VFCMULCPHZrrk", LIEF::assembly::x86::OPCODE::VFCMULCPHZrrk)
  .value("VFCMULCPHZrrkz", LIEF::assembly::x86::OPCODE::VFCMULCPHZrrkz)
  .value("VFCMULCSHZrm", LIEF::assembly::x86::OPCODE::VFCMULCSHZrm)
  .value("VFCMULCSHZrmk", LIEF::assembly::x86::OPCODE::VFCMULCSHZrmk)
  .value("VFCMULCSHZrmkz", LIEF::assembly::x86::OPCODE::VFCMULCSHZrmkz)
  .value("VFCMULCSHZrr", LIEF::assembly::x86::OPCODE::VFCMULCSHZrr)
  .value("VFCMULCSHZrrb", LIEF::assembly::x86::OPCODE::VFCMULCSHZrrb)
  .value("VFCMULCSHZrrbk", LIEF::assembly::x86::OPCODE::VFCMULCSHZrrbk)
  .value("VFCMULCSHZrrbkz", LIEF::assembly::x86::OPCODE::VFCMULCSHZrrbkz)
  .value("VFCMULCSHZrrk", LIEF::assembly::x86::OPCODE::VFCMULCSHZrrk)
  .value("VFCMULCSHZrrkz", LIEF::assembly::x86::OPCODE::VFCMULCSHZrrkz)
  .value("VFIXUPIMMPDZ128rmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmbi)
  .value("VFIXUPIMMPDZ128rmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmbik)
  .value("VFIXUPIMMPDZ128rmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmbikz)
  .value("VFIXUPIMMPDZ128rmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmi)
  .value("VFIXUPIMMPDZ128rmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmik)
  .value("VFIXUPIMMPDZ128rmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rmikz)
  .value("VFIXUPIMMPDZ128rri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rri)
  .value("VFIXUPIMMPDZ128rrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rrik)
  .value("VFIXUPIMMPDZ128rrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ128rrikz)
  .value("VFIXUPIMMPDZ256rmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmbi)
  .value("VFIXUPIMMPDZ256rmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmbik)
  .value("VFIXUPIMMPDZ256rmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmbikz)
  .value("VFIXUPIMMPDZ256rmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmi)
  .value("VFIXUPIMMPDZ256rmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmik)
  .value("VFIXUPIMMPDZ256rmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rmikz)
  .value("VFIXUPIMMPDZ256rri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rri)
  .value("VFIXUPIMMPDZ256rrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rrik)
  .value("VFIXUPIMMPDZ256rrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZ256rrikz)
  .value("VFIXUPIMMPDZrmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmbi)
  .value("VFIXUPIMMPDZrmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmbik)
  .value("VFIXUPIMMPDZrmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmbikz)
  .value("VFIXUPIMMPDZrmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmi)
  .value("VFIXUPIMMPDZrmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmik)
  .value("VFIXUPIMMPDZrmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrmikz)
  .value("VFIXUPIMMPDZrri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrri)
  .value("VFIXUPIMMPDZrrib", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrrib)
  .value("VFIXUPIMMPDZrribk", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrribk)
  .value("VFIXUPIMMPDZrribkz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrribkz)
  .value("VFIXUPIMMPDZrrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrrik)
  .value("VFIXUPIMMPDZrrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPDZrrikz)
  .value("VFIXUPIMMPSZ128rmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmbi)
  .value("VFIXUPIMMPSZ128rmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmbik)
  .value("VFIXUPIMMPSZ128rmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmbikz)
  .value("VFIXUPIMMPSZ128rmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmi)
  .value("VFIXUPIMMPSZ128rmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmik)
  .value("VFIXUPIMMPSZ128rmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rmikz)
  .value("VFIXUPIMMPSZ128rri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rri)
  .value("VFIXUPIMMPSZ128rrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rrik)
  .value("VFIXUPIMMPSZ128rrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ128rrikz)
  .value("VFIXUPIMMPSZ256rmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmbi)
  .value("VFIXUPIMMPSZ256rmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmbik)
  .value("VFIXUPIMMPSZ256rmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmbikz)
  .value("VFIXUPIMMPSZ256rmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmi)
  .value("VFIXUPIMMPSZ256rmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmik)
  .value("VFIXUPIMMPSZ256rmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rmikz);
  opcodes.value("VFIXUPIMMPSZ256rri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rri)
  .value("VFIXUPIMMPSZ256rrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rrik)
  .value("VFIXUPIMMPSZ256rrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZ256rrikz)
  .value("VFIXUPIMMPSZrmbi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmbi)
  .value("VFIXUPIMMPSZrmbik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmbik)
  .value("VFIXUPIMMPSZrmbikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmbikz)
  .value("VFIXUPIMMPSZrmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmi)
  .value("VFIXUPIMMPSZrmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmik)
  .value("VFIXUPIMMPSZrmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrmikz)
  .value("VFIXUPIMMPSZrri", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrri)
  .value("VFIXUPIMMPSZrrib", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrrib)
  .value("VFIXUPIMMPSZrribk", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrribk)
  .value("VFIXUPIMMPSZrribkz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrribkz)
  .value("VFIXUPIMMPSZrrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrrik)
  .value("VFIXUPIMMPSZrrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMPSZrrikz)
  .value("VFIXUPIMMSDZrmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrmi)
  .value("VFIXUPIMMSDZrmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrmik)
  .value("VFIXUPIMMSDZrmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrmikz)
  .value("VFIXUPIMMSDZrri", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrri)
  .value("VFIXUPIMMSDZrrib", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrrib)
  .value("VFIXUPIMMSDZrribk", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrribk)
  .value("VFIXUPIMMSDZrribkz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrribkz)
  .value("VFIXUPIMMSDZrrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrrik)
  .value("VFIXUPIMMSDZrrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSDZrrikz)
  .value("VFIXUPIMMSSZrmi", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrmi)
  .value("VFIXUPIMMSSZrmik", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrmik)
  .value("VFIXUPIMMSSZrmikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrmikz)
  .value("VFIXUPIMMSSZrri", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrri)
  .value("VFIXUPIMMSSZrrib", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrrib)
  .value("VFIXUPIMMSSZrribk", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrribk)
  .value("VFIXUPIMMSSZrribkz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrribkz)
  .value("VFIXUPIMMSSZrrik", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrrik)
  .value("VFIXUPIMMSSZrrikz", LIEF::assembly::x86::OPCODE::VFIXUPIMMSSZrrikz)
  .value("VFMADD132BF16Z128m", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128m)
  .value("VFMADD132BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128mb)
  .value("VFMADD132BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128mbk)
  .value("VFMADD132BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128mbkz)
  .value("VFMADD132BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128mk)
  .value("VFMADD132BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128mkz)
  .value("VFMADD132BF16Z128r", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128r)
  .value("VFMADD132BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128rk)
  .value("VFMADD132BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z128rkz)
  .value("VFMADD132BF16Z256m", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256m)
  .value("VFMADD132BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256mb)
  .value("VFMADD132BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256mbk)
  .value("VFMADD132BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256mbkz)
  .value("VFMADD132BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256mk)
  .value("VFMADD132BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256mkz)
  .value("VFMADD132BF16Z256r", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256r)
  .value("VFMADD132BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256rk)
  .value("VFMADD132BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Z256rkz)
  .value("VFMADD132BF16Zm", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zm)
  .value("VFMADD132BF16Zmb", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zmb)
  .value("VFMADD132BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zmbk)
  .value("VFMADD132BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zmbkz)
  .value("VFMADD132BF16Zmk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zmk)
  .value("VFMADD132BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zmkz)
  .value("VFMADD132BF16Zr", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zr)
  .value("VFMADD132BF16Zrk", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zrk)
  .value("VFMADD132BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMADD132BF16Zrkz)
  .value("VFMADD132PDYm", LIEF::assembly::x86::OPCODE::VFMADD132PDYm)
  .value("VFMADD132PDYr", LIEF::assembly::x86::OPCODE::VFMADD132PDYr)
  .value("VFMADD132PDZ128m", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128m)
  .value("VFMADD132PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128mb)
  .value("VFMADD132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128mbk)
  .value("VFMADD132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128mbkz)
  .value("VFMADD132PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128mk)
  .value("VFMADD132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128mkz)
  .value("VFMADD132PDZ128r", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128r)
  .value("VFMADD132PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128rk)
  .value("VFMADD132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ128rkz)
  .value("VFMADD132PDZ256m", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256m)
  .value("VFMADD132PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256mb)
  .value("VFMADD132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256mbk)
  .value("VFMADD132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256mbkz)
  .value("VFMADD132PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256mk)
  .value("VFMADD132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256mkz)
  .value("VFMADD132PDZ256r", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256r)
  .value("VFMADD132PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256rk)
  .value("VFMADD132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZ256rkz)
  .value("VFMADD132PDZm", LIEF::assembly::x86::OPCODE::VFMADD132PDZm)
  .value("VFMADD132PDZmb", LIEF::assembly::x86::OPCODE::VFMADD132PDZmb)
  .value("VFMADD132PDZmbk", LIEF::assembly::x86::OPCODE::VFMADD132PDZmbk)
  .value("VFMADD132PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZmbkz)
  .value("VFMADD132PDZmk", LIEF::assembly::x86::OPCODE::VFMADD132PDZmk)
  .value("VFMADD132PDZmkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZmkz)
  .value("VFMADD132PDZr", LIEF::assembly::x86::OPCODE::VFMADD132PDZr)
  .value("VFMADD132PDZrb", LIEF::assembly::x86::OPCODE::VFMADD132PDZrb)
  .value("VFMADD132PDZrbk", LIEF::assembly::x86::OPCODE::VFMADD132PDZrbk)
  .value("VFMADD132PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZrbkz)
  .value("VFMADD132PDZrk", LIEF::assembly::x86::OPCODE::VFMADD132PDZrk)
  .value("VFMADD132PDZrkz", LIEF::assembly::x86::OPCODE::VFMADD132PDZrkz)
  .value("VFMADD132PDm", LIEF::assembly::x86::OPCODE::VFMADD132PDm)
  .value("VFMADD132PDr", LIEF::assembly::x86::OPCODE::VFMADD132PDr)
  .value("VFMADD132PHZ128m", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128m)
  .value("VFMADD132PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128mb)
  .value("VFMADD132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128mbk)
  .value("VFMADD132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128mbkz)
  .value("VFMADD132PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128mk)
  .value("VFMADD132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128mkz)
  .value("VFMADD132PHZ128r", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128r)
  .value("VFMADD132PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128rk)
  .value("VFMADD132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ128rkz)
  .value("VFMADD132PHZ256m", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256m)
  .value("VFMADD132PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256mb)
  .value("VFMADD132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256mbk)
  .value("VFMADD132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256mbkz)
  .value("VFMADD132PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256mk)
  .value("VFMADD132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256mkz)
  .value("VFMADD132PHZ256r", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256r)
  .value("VFMADD132PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256rk)
  .value("VFMADD132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZ256rkz)
  .value("VFMADD132PHZm", LIEF::assembly::x86::OPCODE::VFMADD132PHZm)
  .value("VFMADD132PHZmb", LIEF::assembly::x86::OPCODE::VFMADD132PHZmb)
  .value("VFMADD132PHZmbk", LIEF::assembly::x86::OPCODE::VFMADD132PHZmbk)
  .value("VFMADD132PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZmbkz)
  .value("VFMADD132PHZmk", LIEF::assembly::x86::OPCODE::VFMADD132PHZmk)
  .value("VFMADD132PHZmkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZmkz)
  .value("VFMADD132PHZr", LIEF::assembly::x86::OPCODE::VFMADD132PHZr)
  .value("VFMADD132PHZrb", LIEF::assembly::x86::OPCODE::VFMADD132PHZrb)
  .value("VFMADD132PHZrbk", LIEF::assembly::x86::OPCODE::VFMADD132PHZrbk)
  .value("VFMADD132PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZrbkz)
  .value("VFMADD132PHZrk", LIEF::assembly::x86::OPCODE::VFMADD132PHZrk)
  .value("VFMADD132PHZrkz", LIEF::assembly::x86::OPCODE::VFMADD132PHZrkz)
  .value("VFMADD132PSYm", LIEF::assembly::x86::OPCODE::VFMADD132PSYm)
  .value("VFMADD132PSYr", LIEF::assembly::x86::OPCODE::VFMADD132PSYr)
  .value("VFMADD132PSZ128m", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128m)
  .value("VFMADD132PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128mb)
  .value("VFMADD132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128mbk)
  .value("VFMADD132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128mbkz)
  .value("VFMADD132PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128mk)
  .value("VFMADD132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128mkz)
  .value("VFMADD132PSZ128r", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128r)
  .value("VFMADD132PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128rk)
  .value("VFMADD132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ128rkz)
  .value("VFMADD132PSZ256m", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256m)
  .value("VFMADD132PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256mb)
  .value("VFMADD132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256mbk)
  .value("VFMADD132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256mbkz)
  .value("VFMADD132PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256mk)
  .value("VFMADD132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256mkz)
  .value("VFMADD132PSZ256r", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256r)
  .value("VFMADD132PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256rk)
  .value("VFMADD132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZ256rkz)
  .value("VFMADD132PSZm", LIEF::assembly::x86::OPCODE::VFMADD132PSZm)
  .value("VFMADD132PSZmb", LIEF::assembly::x86::OPCODE::VFMADD132PSZmb)
  .value("VFMADD132PSZmbk", LIEF::assembly::x86::OPCODE::VFMADD132PSZmbk)
  .value("VFMADD132PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZmbkz)
  .value("VFMADD132PSZmk", LIEF::assembly::x86::OPCODE::VFMADD132PSZmk)
  .value("VFMADD132PSZmkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZmkz)
  .value("VFMADD132PSZr", LIEF::assembly::x86::OPCODE::VFMADD132PSZr)
  .value("VFMADD132PSZrb", LIEF::assembly::x86::OPCODE::VFMADD132PSZrb)
  .value("VFMADD132PSZrbk", LIEF::assembly::x86::OPCODE::VFMADD132PSZrbk)
  .value("VFMADD132PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZrbkz)
  .value("VFMADD132PSZrk", LIEF::assembly::x86::OPCODE::VFMADD132PSZrk)
  .value("VFMADD132PSZrkz", LIEF::assembly::x86::OPCODE::VFMADD132PSZrkz)
  .value("VFMADD132PSm", LIEF::assembly::x86::OPCODE::VFMADD132PSm)
  .value("VFMADD132PSr", LIEF::assembly::x86::OPCODE::VFMADD132PSr)
  .value("VFMADD132SDZm", LIEF::assembly::x86::OPCODE::VFMADD132SDZm)
  .value("VFMADD132SDZm_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZm_Int)
  .value("VFMADD132SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZmk_Int)
  .value("VFMADD132SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZmkz_Int)
  .value("VFMADD132SDZr", LIEF::assembly::x86::OPCODE::VFMADD132SDZr)
  .value("VFMADD132SDZr_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZr_Int)
  .value("VFMADD132SDZrb", LIEF::assembly::x86::OPCODE::VFMADD132SDZrb)
  .value("VFMADD132SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZrb_Int)
  .value("VFMADD132SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZrbk_Int)
  .value("VFMADD132SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZrbkz_Int)
  .value("VFMADD132SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZrk_Int)
  .value("VFMADD132SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDZrkz_Int)
  .value("VFMADD132SDm", LIEF::assembly::x86::OPCODE::VFMADD132SDm)
  .value("VFMADD132SDm_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDm_Int)
  .value("VFMADD132SDr", LIEF::assembly::x86::OPCODE::VFMADD132SDr)
  .value("VFMADD132SDr_Int", LIEF::assembly::x86::OPCODE::VFMADD132SDr_Int)
  .value("VFMADD132SHZm", LIEF::assembly::x86::OPCODE::VFMADD132SHZm)
  .value("VFMADD132SHZm_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZm_Int)
  .value("VFMADD132SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZmk_Int)
  .value("VFMADD132SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZmkz_Int)
  .value("VFMADD132SHZr", LIEF::assembly::x86::OPCODE::VFMADD132SHZr)
  .value("VFMADD132SHZr_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZr_Int)
  .value("VFMADD132SHZrb", LIEF::assembly::x86::OPCODE::VFMADD132SHZrb)
  .value("VFMADD132SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZrb_Int)
  .value("VFMADD132SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZrbk_Int)
  .value("VFMADD132SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZrbkz_Int)
  .value("VFMADD132SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZrk_Int)
  .value("VFMADD132SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SHZrkz_Int)
  .value("VFMADD132SSZm", LIEF::assembly::x86::OPCODE::VFMADD132SSZm)
  .value("VFMADD132SSZm_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZm_Int)
  .value("VFMADD132SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZmk_Int)
  .value("VFMADD132SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZmkz_Int)
  .value("VFMADD132SSZr", LIEF::assembly::x86::OPCODE::VFMADD132SSZr)
  .value("VFMADD132SSZr_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZr_Int)
  .value("VFMADD132SSZrb", LIEF::assembly::x86::OPCODE::VFMADD132SSZrb)
  .value("VFMADD132SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZrb_Int)
  .value("VFMADD132SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZrbk_Int)
  .value("VFMADD132SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZrbkz_Int)
  .value("VFMADD132SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZrk_Int)
  .value("VFMADD132SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSZrkz_Int)
  .value("VFMADD132SSm", LIEF::assembly::x86::OPCODE::VFMADD132SSm)
  .value("VFMADD132SSm_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSm_Int)
  .value("VFMADD132SSr", LIEF::assembly::x86::OPCODE::VFMADD132SSr)
  .value("VFMADD132SSr_Int", LIEF::assembly::x86::OPCODE::VFMADD132SSr_Int)
  .value("VFMADD213BF16Z128m", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128m)
  .value("VFMADD213BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128mb)
  .value("VFMADD213BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128mbk)
  .value("VFMADD213BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128mbkz)
  .value("VFMADD213BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128mk)
  .value("VFMADD213BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128mkz)
  .value("VFMADD213BF16Z128r", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128r)
  .value("VFMADD213BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128rk)
  .value("VFMADD213BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z128rkz)
  .value("VFMADD213BF16Z256m", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256m)
  .value("VFMADD213BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256mb)
  .value("VFMADD213BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256mbk)
  .value("VFMADD213BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256mbkz)
  .value("VFMADD213BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256mk)
  .value("VFMADD213BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256mkz)
  .value("VFMADD213BF16Z256r", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256r)
  .value("VFMADD213BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256rk)
  .value("VFMADD213BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Z256rkz)
  .value("VFMADD213BF16Zm", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zm)
  .value("VFMADD213BF16Zmb", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zmb)
  .value("VFMADD213BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zmbk)
  .value("VFMADD213BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zmbkz)
  .value("VFMADD213BF16Zmk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zmk)
  .value("VFMADD213BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zmkz)
  .value("VFMADD213BF16Zr", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zr)
  .value("VFMADD213BF16Zrk", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zrk)
  .value("VFMADD213BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMADD213BF16Zrkz)
  .value("VFMADD213PDYm", LIEF::assembly::x86::OPCODE::VFMADD213PDYm)
  .value("VFMADD213PDYr", LIEF::assembly::x86::OPCODE::VFMADD213PDYr)
  .value("VFMADD213PDZ128m", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128m)
  .value("VFMADD213PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128mb)
  .value("VFMADD213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128mbk)
  .value("VFMADD213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128mbkz)
  .value("VFMADD213PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128mk)
  .value("VFMADD213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128mkz)
  .value("VFMADD213PDZ128r", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128r)
  .value("VFMADD213PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128rk)
  .value("VFMADD213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ128rkz)
  .value("VFMADD213PDZ256m", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256m)
  .value("VFMADD213PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256mb)
  .value("VFMADD213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256mbk)
  .value("VFMADD213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256mbkz)
  .value("VFMADD213PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256mk)
  .value("VFMADD213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256mkz)
  .value("VFMADD213PDZ256r", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256r)
  .value("VFMADD213PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256rk)
  .value("VFMADD213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZ256rkz)
  .value("VFMADD213PDZm", LIEF::assembly::x86::OPCODE::VFMADD213PDZm)
  .value("VFMADD213PDZmb", LIEF::assembly::x86::OPCODE::VFMADD213PDZmb)
  .value("VFMADD213PDZmbk", LIEF::assembly::x86::OPCODE::VFMADD213PDZmbk)
  .value("VFMADD213PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZmbkz)
  .value("VFMADD213PDZmk", LIEF::assembly::x86::OPCODE::VFMADD213PDZmk)
  .value("VFMADD213PDZmkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZmkz)
  .value("VFMADD213PDZr", LIEF::assembly::x86::OPCODE::VFMADD213PDZr)
  .value("VFMADD213PDZrb", LIEF::assembly::x86::OPCODE::VFMADD213PDZrb)
  .value("VFMADD213PDZrbk", LIEF::assembly::x86::OPCODE::VFMADD213PDZrbk)
  .value("VFMADD213PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZrbkz)
  .value("VFMADD213PDZrk", LIEF::assembly::x86::OPCODE::VFMADD213PDZrk)
  .value("VFMADD213PDZrkz", LIEF::assembly::x86::OPCODE::VFMADD213PDZrkz)
  .value("VFMADD213PDm", LIEF::assembly::x86::OPCODE::VFMADD213PDm)
  .value("VFMADD213PDr", LIEF::assembly::x86::OPCODE::VFMADD213PDr)
  .value("VFMADD213PHZ128m", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128m)
  .value("VFMADD213PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128mb)
  .value("VFMADD213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128mbk)
  .value("VFMADD213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128mbkz)
  .value("VFMADD213PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128mk)
  .value("VFMADD213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128mkz)
  .value("VFMADD213PHZ128r", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128r)
  .value("VFMADD213PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128rk)
  .value("VFMADD213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ128rkz)
  .value("VFMADD213PHZ256m", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256m)
  .value("VFMADD213PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256mb)
  .value("VFMADD213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256mbk)
  .value("VFMADD213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256mbkz)
  .value("VFMADD213PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256mk)
  .value("VFMADD213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256mkz)
  .value("VFMADD213PHZ256r", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256r)
  .value("VFMADD213PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256rk)
  .value("VFMADD213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZ256rkz)
  .value("VFMADD213PHZm", LIEF::assembly::x86::OPCODE::VFMADD213PHZm)
  .value("VFMADD213PHZmb", LIEF::assembly::x86::OPCODE::VFMADD213PHZmb)
  .value("VFMADD213PHZmbk", LIEF::assembly::x86::OPCODE::VFMADD213PHZmbk)
  .value("VFMADD213PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZmbkz)
  .value("VFMADD213PHZmk", LIEF::assembly::x86::OPCODE::VFMADD213PHZmk)
  .value("VFMADD213PHZmkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZmkz)
  .value("VFMADD213PHZr", LIEF::assembly::x86::OPCODE::VFMADD213PHZr)
  .value("VFMADD213PHZrb", LIEF::assembly::x86::OPCODE::VFMADD213PHZrb)
  .value("VFMADD213PHZrbk", LIEF::assembly::x86::OPCODE::VFMADD213PHZrbk)
  .value("VFMADD213PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZrbkz)
  .value("VFMADD213PHZrk", LIEF::assembly::x86::OPCODE::VFMADD213PHZrk)
  .value("VFMADD213PHZrkz", LIEF::assembly::x86::OPCODE::VFMADD213PHZrkz)
  .value("VFMADD213PSYm", LIEF::assembly::x86::OPCODE::VFMADD213PSYm)
  .value("VFMADD213PSYr", LIEF::assembly::x86::OPCODE::VFMADD213PSYr)
  .value("VFMADD213PSZ128m", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128m)
  .value("VFMADD213PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128mb)
  .value("VFMADD213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128mbk)
  .value("VFMADD213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128mbkz)
  .value("VFMADD213PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128mk);
  opcodes.value("VFMADD213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128mkz)
  .value("VFMADD213PSZ128r", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128r)
  .value("VFMADD213PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128rk)
  .value("VFMADD213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ128rkz)
  .value("VFMADD213PSZ256m", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256m)
  .value("VFMADD213PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256mb)
  .value("VFMADD213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256mbk)
  .value("VFMADD213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256mbkz)
  .value("VFMADD213PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256mk)
  .value("VFMADD213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256mkz)
  .value("VFMADD213PSZ256r", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256r)
  .value("VFMADD213PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256rk)
  .value("VFMADD213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZ256rkz)
  .value("VFMADD213PSZm", LIEF::assembly::x86::OPCODE::VFMADD213PSZm)
  .value("VFMADD213PSZmb", LIEF::assembly::x86::OPCODE::VFMADD213PSZmb)
  .value("VFMADD213PSZmbk", LIEF::assembly::x86::OPCODE::VFMADD213PSZmbk)
  .value("VFMADD213PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZmbkz)
  .value("VFMADD213PSZmk", LIEF::assembly::x86::OPCODE::VFMADD213PSZmk)
  .value("VFMADD213PSZmkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZmkz)
  .value("VFMADD213PSZr", LIEF::assembly::x86::OPCODE::VFMADD213PSZr)
  .value("VFMADD213PSZrb", LIEF::assembly::x86::OPCODE::VFMADD213PSZrb)
  .value("VFMADD213PSZrbk", LIEF::assembly::x86::OPCODE::VFMADD213PSZrbk)
  .value("VFMADD213PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZrbkz)
  .value("VFMADD213PSZrk", LIEF::assembly::x86::OPCODE::VFMADD213PSZrk)
  .value("VFMADD213PSZrkz", LIEF::assembly::x86::OPCODE::VFMADD213PSZrkz)
  .value("VFMADD213PSm", LIEF::assembly::x86::OPCODE::VFMADD213PSm)
  .value("VFMADD213PSr", LIEF::assembly::x86::OPCODE::VFMADD213PSr)
  .value("VFMADD213SDZm", LIEF::assembly::x86::OPCODE::VFMADD213SDZm)
  .value("VFMADD213SDZm_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZm_Int)
  .value("VFMADD213SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZmk_Int)
  .value("VFMADD213SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZmkz_Int)
  .value("VFMADD213SDZr", LIEF::assembly::x86::OPCODE::VFMADD213SDZr)
  .value("VFMADD213SDZr_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZr_Int)
  .value("VFMADD213SDZrb", LIEF::assembly::x86::OPCODE::VFMADD213SDZrb)
  .value("VFMADD213SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZrb_Int)
  .value("VFMADD213SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZrbk_Int)
  .value("VFMADD213SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZrbkz_Int)
  .value("VFMADD213SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZrk_Int)
  .value("VFMADD213SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDZrkz_Int)
  .value("VFMADD213SDm", LIEF::assembly::x86::OPCODE::VFMADD213SDm)
  .value("VFMADD213SDm_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDm_Int)
  .value("VFMADD213SDr", LIEF::assembly::x86::OPCODE::VFMADD213SDr)
  .value("VFMADD213SDr_Int", LIEF::assembly::x86::OPCODE::VFMADD213SDr_Int)
  .value("VFMADD213SHZm", LIEF::assembly::x86::OPCODE::VFMADD213SHZm)
  .value("VFMADD213SHZm_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZm_Int)
  .value("VFMADD213SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZmk_Int)
  .value("VFMADD213SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZmkz_Int)
  .value("VFMADD213SHZr", LIEF::assembly::x86::OPCODE::VFMADD213SHZr)
  .value("VFMADD213SHZr_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZr_Int)
  .value("VFMADD213SHZrb", LIEF::assembly::x86::OPCODE::VFMADD213SHZrb)
  .value("VFMADD213SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZrb_Int)
  .value("VFMADD213SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZrbk_Int)
  .value("VFMADD213SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZrbkz_Int)
  .value("VFMADD213SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZrk_Int)
  .value("VFMADD213SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SHZrkz_Int)
  .value("VFMADD213SSZm", LIEF::assembly::x86::OPCODE::VFMADD213SSZm)
  .value("VFMADD213SSZm_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZm_Int)
  .value("VFMADD213SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZmk_Int)
  .value("VFMADD213SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZmkz_Int)
  .value("VFMADD213SSZr", LIEF::assembly::x86::OPCODE::VFMADD213SSZr)
  .value("VFMADD213SSZr_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZr_Int)
  .value("VFMADD213SSZrb", LIEF::assembly::x86::OPCODE::VFMADD213SSZrb)
  .value("VFMADD213SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZrb_Int)
  .value("VFMADD213SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZrbk_Int)
  .value("VFMADD213SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZrbkz_Int)
  .value("VFMADD213SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZrk_Int)
  .value("VFMADD213SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSZrkz_Int)
  .value("VFMADD213SSm", LIEF::assembly::x86::OPCODE::VFMADD213SSm)
  .value("VFMADD213SSm_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSm_Int)
  .value("VFMADD213SSr", LIEF::assembly::x86::OPCODE::VFMADD213SSr)
  .value("VFMADD213SSr_Int", LIEF::assembly::x86::OPCODE::VFMADD213SSr_Int)
  .value("VFMADD231BF16Z128m", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128m)
  .value("VFMADD231BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128mb)
  .value("VFMADD231BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128mbk)
  .value("VFMADD231BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128mbkz)
  .value("VFMADD231BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128mk)
  .value("VFMADD231BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128mkz)
  .value("VFMADD231BF16Z128r", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128r)
  .value("VFMADD231BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128rk)
  .value("VFMADD231BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z128rkz)
  .value("VFMADD231BF16Z256m", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256m)
  .value("VFMADD231BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256mb)
  .value("VFMADD231BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256mbk)
  .value("VFMADD231BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256mbkz)
  .value("VFMADD231BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256mk)
  .value("VFMADD231BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256mkz)
  .value("VFMADD231BF16Z256r", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256r)
  .value("VFMADD231BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256rk)
  .value("VFMADD231BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Z256rkz)
  .value("VFMADD231BF16Zm", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zm)
  .value("VFMADD231BF16Zmb", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zmb)
  .value("VFMADD231BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zmbk)
  .value("VFMADD231BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zmbkz)
  .value("VFMADD231BF16Zmk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zmk)
  .value("VFMADD231BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zmkz)
  .value("VFMADD231BF16Zr", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zr)
  .value("VFMADD231BF16Zrk", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zrk)
  .value("VFMADD231BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMADD231BF16Zrkz)
  .value("VFMADD231PDYm", LIEF::assembly::x86::OPCODE::VFMADD231PDYm)
  .value("VFMADD231PDYr", LIEF::assembly::x86::OPCODE::VFMADD231PDYr)
  .value("VFMADD231PDZ128m", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128m)
  .value("VFMADD231PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128mb)
  .value("VFMADD231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128mbk)
  .value("VFMADD231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128mbkz)
  .value("VFMADD231PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128mk)
  .value("VFMADD231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128mkz)
  .value("VFMADD231PDZ128r", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128r)
  .value("VFMADD231PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128rk)
  .value("VFMADD231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ128rkz)
  .value("VFMADD231PDZ256m", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256m)
  .value("VFMADD231PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256mb)
  .value("VFMADD231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256mbk)
  .value("VFMADD231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256mbkz)
  .value("VFMADD231PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256mk)
  .value("VFMADD231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256mkz)
  .value("VFMADD231PDZ256r", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256r)
  .value("VFMADD231PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256rk)
  .value("VFMADD231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZ256rkz)
  .value("VFMADD231PDZm", LIEF::assembly::x86::OPCODE::VFMADD231PDZm)
  .value("VFMADD231PDZmb", LIEF::assembly::x86::OPCODE::VFMADD231PDZmb)
  .value("VFMADD231PDZmbk", LIEF::assembly::x86::OPCODE::VFMADD231PDZmbk)
  .value("VFMADD231PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZmbkz)
  .value("VFMADD231PDZmk", LIEF::assembly::x86::OPCODE::VFMADD231PDZmk)
  .value("VFMADD231PDZmkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZmkz)
  .value("VFMADD231PDZr", LIEF::assembly::x86::OPCODE::VFMADD231PDZr)
  .value("VFMADD231PDZrb", LIEF::assembly::x86::OPCODE::VFMADD231PDZrb)
  .value("VFMADD231PDZrbk", LIEF::assembly::x86::OPCODE::VFMADD231PDZrbk)
  .value("VFMADD231PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZrbkz)
  .value("VFMADD231PDZrk", LIEF::assembly::x86::OPCODE::VFMADD231PDZrk)
  .value("VFMADD231PDZrkz", LIEF::assembly::x86::OPCODE::VFMADD231PDZrkz)
  .value("VFMADD231PDm", LIEF::assembly::x86::OPCODE::VFMADD231PDm)
  .value("VFMADD231PDr", LIEF::assembly::x86::OPCODE::VFMADD231PDr)
  .value("VFMADD231PHZ128m", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128m)
  .value("VFMADD231PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128mb)
  .value("VFMADD231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128mbk)
  .value("VFMADD231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128mbkz)
  .value("VFMADD231PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128mk)
  .value("VFMADD231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128mkz)
  .value("VFMADD231PHZ128r", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128r)
  .value("VFMADD231PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128rk)
  .value("VFMADD231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ128rkz)
  .value("VFMADD231PHZ256m", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256m)
  .value("VFMADD231PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256mb)
  .value("VFMADD231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256mbk)
  .value("VFMADD231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256mbkz)
  .value("VFMADD231PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256mk)
  .value("VFMADD231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256mkz)
  .value("VFMADD231PHZ256r", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256r)
  .value("VFMADD231PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256rk)
  .value("VFMADD231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZ256rkz)
  .value("VFMADD231PHZm", LIEF::assembly::x86::OPCODE::VFMADD231PHZm)
  .value("VFMADD231PHZmb", LIEF::assembly::x86::OPCODE::VFMADD231PHZmb)
  .value("VFMADD231PHZmbk", LIEF::assembly::x86::OPCODE::VFMADD231PHZmbk)
  .value("VFMADD231PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZmbkz)
  .value("VFMADD231PHZmk", LIEF::assembly::x86::OPCODE::VFMADD231PHZmk)
  .value("VFMADD231PHZmkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZmkz)
  .value("VFMADD231PHZr", LIEF::assembly::x86::OPCODE::VFMADD231PHZr)
  .value("VFMADD231PHZrb", LIEF::assembly::x86::OPCODE::VFMADD231PHZrb)
  .value("VFMADD231PHZrbk", LIEF::assembly::x86::OPCODE::VFMADD231PHZrbk)
  .value("VFMADD231PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZrbkz)
  .value("VFMADD231PHZrk", LIEF::assembly::x86::OPCODE::VFMADD231PHZrk)
  .value("VFMADD231PHZrkz", LIEF::assembly::x86::OPCODE::VFMADD231PHZrkz)
  .value("VFMADD231PSYm", LIEF::assembly::x86::OPCODE::VFMADD231PSYm)
  .value("VFMADD231PSYr", LIEF::assembly::x86::OPCODE::VFMADD231PSYr)
  .value("VFMADD231PSZ128m", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128m)
  .value("VFMADD231PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128mb)
  .value("VFMADD231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128mbk)
  .value("VFMADD231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128mbkz)
  .value("VFMADD231PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128mk)
  .value("VFMADD231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128mkz)
  .value("VFMADD231PSZ128r", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128r)
  .value("VFMADD231PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128rk)
  .value("VFMADD231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ128rkz)
  .value("VFMADD231PSZ256m", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256m)
  .value("VFMADD231PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256mb)
  .value("VFMADD231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256mbk)
  .value("VFMADD231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256mbkz)
  .value("VFMADD231PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256mk)
  .value("VFMADD231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256mkz)
  .value("VFMADD231PSZ256r", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256r)
  .value("VFMADD231PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256rk)
  .value("VFMADD231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZ256rkz)
  .value("VFMADD231PSZm", LIEF::assembly::x86::OPCODE::VFMADD231PSZm)
  .value("VFMADD231PSZmb", LIEF::assembly::x86::OPCODE::VFMADD231PSZmb)
  .value("VFMADD231PSZmbk", LIEF::assembly::x86::OPCODE::VFMADD231PSZmbk)
  .value("VFMADD231PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZmbkz)
  .value("VFMADD231PSZmk", LIEF::assembly::x86::OPCODE::VFMADD231PSZmk)
  .value("VFMADD231PSZmkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZmkz)
  .value("VFMADD231PSZr", LIEF::assembly::x86::OPCODE::VFMADD231PSZr)
  .value("VFMADD231PSZrb", LIEF::assembly::x86::OPCODE::VFMADD231PSZrb)
  .value("VFMADD231PSZrbk", LIEF::assembly::x86::OPCODE::VFMADD231PSZrbk)
  .value("VFMADD231PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZrbkz)
  .value("VFMADD231PSZrk", LIEF::assembly::x86::OPCODE::VFMADD231PSZrk)
  .value("VFMADD231PSZrkz", LIEF::assembly::x86::OPCODE::VFMADD231PSZrkz)
  .value("VFMADD231PSm", LIEF::assembly::x86::OPCODE::VFMADD231PSm)
  .value("VFMADD231PSr", LIEF::assembly::x86::OPCODE::VFMADD231PSr)
  .value("VFMADD231SDZm", LIEF::assembly::x86::OPCODE::VFMADD231SDZm)
  .value("VFMADD231SDZm_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZm_Int)
  .value("VFMADD231SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZmk_Int)
  .value("VFMADD231SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZmkz_Int)
  .value("VFMADD231SDZr", LIEF::assembly::x86::OPCODE::VFMADD231SDZr)
  .value("VFMADD231SDZr_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZr_Int)
  .value("VFMADD231SDZrb", LIEF::assembly::x86::OPCODE::VFMADD231SDZrb)
  .value("VFMADD231SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZrb_Int)
  .value("VFMADD231SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZrbk_Int)
  .value("VFMADD231SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZrbkz_Int)
  .value("VFMADD231SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZrk_Int)
  .value("VFMADD231SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDZrkz_Int)
  .value("VFMADD231SDm", LIEF::assembly::x86::OPCODE::VFMADD231SDm)
  .value("VFMADD231SDm_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDm_Int)
  .value("VFMADD231SDr", LIEF::assembly::x86::OPCODE::VFMADD231SDr)
  .value("VFMADD231SDr_Int", LIEF::assembly::x86::OPCODE::VFMADD231SDr_Int)
  .value("VFMADD231SHZm", LIEF::assembly::x86::OPCODE::VFMADD231SHZm)
  .value("VFMADD231SHZm_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZm_Int)
  .value("VFMADD231SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZmk_Int)
  .value("VFMADD231SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZmkz_Int)
  .value("VFMADD231SHZr", LIEF::assembly::x86::OPCODE::VFMADD231SHZr)
  .value("VFMADD231SHZr_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZr_Int)
  .value("VFMADD231SHZrb", LIEF::assembly::x86::OPCODE::VFMADD231SHZrb)
  .value("VFMADD231SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZrb_Int)
  .value("VFMADD231SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZrbk_Int)
  .value("VFMADD231SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZrbkz_Int)
  .value("VFMADD231SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZrk_Int)
  .value("VFMADD231SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SHZrkz_Int)
  .value("VFMADD231SSZm", LIEF::assembly::x86::OPCODE::VFMADD231SSZm)
  .value("VFMADD231SSZm_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZm_Int)
  .value("VFMADD231SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZmk_Int)
  .value("VFMADD231SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZmkz_Int)
  .value("VFMADD231SSZr", LIEF::assembly::x86::OPCODE::VFMADD231SSZr)
  .value("VFMADD231SSZr_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZr_Int)
  .value("VFMADD231SSZrb", LIEF::assembly::x86::OPCODE::VFMADD231SSZrb)
  .value("VFMADD231SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZrb_Int)
  .value("VFMADD231SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZrbk_Int)
  .value("VFMADD231SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZrbkz_Int)
  .value("VFMADD231SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZrk_Int)
  .value("VFMADD231SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSZrkz_Int)
  .value("VFMADD231SSm", LIEF::assembly::x86::OPCODE::VFMADD231SSm)
  .value("VFMADD231SSm_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSm_Int)
  .value("VFMADD231SSr", LIEF::assembly::x86::OPCODE::VFMADD231SSr)
  .value("VFMADD231SSr_Int", LIEF::assembly::x86::OPCODE::VFMADD231SSr_Int)
  .value("VFMADDCPHZ128m", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128m)
  .value("VFMADDCPHZ128mb", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128mb)
  .value("VFMADDCPHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128mbk)
  .value("VFMADDCPHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128mbkz)
  .value("VFMADDCPHZ128mk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128mk)
  .value("VFMADDCPHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128mkz)
  .value("VFMADDCPHZ128r", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128r)
  .value("VFMADDCPHZ128rk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128rk)
  .value("VFMADDCPHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ128rkz)
  .value("VFMADDCPHZ256m", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256m)
  .value("VFMADDCPHZ256mb", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256mb)
  .value("VFMADDCPHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256mbk)
  .value("VFMADDCPHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256mbkz)
  .value("VFMADDCPHZ256mk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256mk)
  .value("VFMADDCPHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256mkz)
  .value("VFMADDCPHZ256r", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256r)
  .value("VFMADDCPHZ256rk", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256rk)
  .value("VFMADDCPHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZ256rkz)
  .value("VFMADDCPHZm", LIEF::assembly::x86::OPCODE::VFMADDCPHZm)
  .value("VFMADDCPHZmb", LIEF::assembly::x86::OPCODE::VFMADDCPHZmb)
  .value("VFMADDCPHZmbk", LIEF::assembly::x86::OPCODE::VFMADDCPHZmbk)
  .value("VFMADDCPHZmbkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZmbkz)
  .value("VFMADDCPHZmk", LIEF::assembly::x86::OPCODE::VFMADDCPHZmk)
  .value("VFMADDCPHZmkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZmkz)
  .value("VFMADDCPHZr", LIEF::assembly::x86::OPCODE::VFMADDCPHZr)
  .value("VFMADDCPHZrb", LIEF::assembly::x86::OPCODE::VFMADDCPHZrb)
  .value("VFMADDCPHZrbk", LIEF::assembly::x86::OPCODE::VFMADDCPHZrbk)
  .value("VFMADDCPHZrbkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZrbkz)
  .value("VFMADDCPHZrk", LIEF::assembly::x86::OPCODE::VFMADDCPHZrk)
  .value("VFMADDCPHZrkz", LIEF::assembly::x86::OPCODE::VFMADDCPHZrkz)
  .value("VFMADDCSHZm", LIEF::assembly::x86::OPCODE::VFMADDCSHZm)
  .value("VFMADDCSHZmk", LIEF::assembly::x86::OPCODE::VFMADDCSHZmk)
  .value("VFMADDCSHZmkz", LIEF::assembly::x86::OPCODE::VFMADDCSHZmkz)
  .value("VFMADDCSHZr", LIEF::assembly::x86::OPCODE::VFMADDCSHZr)
  .value("VFMADDCSHZrb", LIEF::assembly::x86::OPCODE::VFMADDCSHZrb)
  .value("VFMADDCSHZrbk", LIEF::assembly::x86::OPCODE::VFMADDCSHZrbk)
  .value("VFMADDCSHZrbkz", LIEF::assembly::x86::OPCODE::VFMADDCSHZrbkz)
  .value("VFMADDCSHZrk", LIEF::assembly::x86::OPCODE::VFMADDCSHZrk)
  .value("VFMADDCSHZrkz", LIEF::assembly::x86::OPCODE::VFMADDCSHZrkz)
  .value("VFMADDPD4Ymr", LIEF::assembly::x86::OPCODE::VFMADDPD4Ymr)
  .value("VFMADDPD4Yrm", LIEF::assembly::x86::OPCODE::VFMADDPD4Yrm)
  .value("VFMADDPD4Yrr", LIEF::assembly::x86::OPCODE::VFMADDPD4Yrr)
  .value("VFMADDPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMADDPD4Yrr_REV)
  .value("VFMADDPD4mr", LIEF::assembly::x86::OPCODE::VFMADDPD4mr)
  .value("VFMADDPD4rm", LIEF::assembly::x86::OPCODE::VFMADDPD4rm)
  .value("VFMADDPD4rr", LIEF::assembly::x86::OPCODE::VFMADDPD4rr)
  .value("VFMADDPD4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDPD4rr_REV)
  .value("VFMADDPS4Ymr", LIEF::assembly::x86::OPCODE::VFMADDPS4Ymr)
  .value("VFMADDPS4Yrm", LIEF::assembly::x86::OPCODE::VFMADDPS4Yrm)
  .value("VFMADDPS4Yrr", LIEF::assembly::x86::OPCODE::VFMADDPS4Yrr)
  .value("VFMADDPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMADDPS4Yrr_REV)
  .value("VFMADDPS4mr", LIEF::assembly::x86::OPCODE::VFMADDPS4mr)
  .value("VFMADDPS4rm", LIEF::assembly::x86::OPCODE::VFMADDPS4rm)
  .value("VFMADDPS4rr", LIEF::assembly::x86::OPCODE::VFMADDPS4rr)
  .value("VFMADDPS4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDPS4rr_REV)
  .value("VFMADDSD4mr", LIEF::assembly::x86::OPCODE::VFMADDSD4mr)
  .value("VFMADDSD4mr_Int", LIEF::assembly::x86::OPCODE::VFMADDSD4mr_Int)
  .value("VFMADDSD4rm", LIEF::assembly::x86::OPCODE::VFMADDSD4rm)
  .value("VFMADDSD4rm_Int", LIEF::assembly::x86::OPCODE::VFMADDSD4rm_Int)
  .value("VFMADDSD4rr", LIEF::assembly::x86::OPCODE::VFMADDSD4rr);
  opcodes.value("VFMADDSD4rr_Int", LIEF::assembly::x86::OPCODE::VFMADDSD4rr_Int)
  .value("VFMADDSD4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFMADDSD4rr_Int_REV)
  .value("VFMADDSD4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDSD4rr_REV)
  .value("VFMADDSS4mr", LIEF::assembly::x86::OPCODE::VFMADDSS4mr)
  .value("VFMADDSS4mr_Int", LIEF::assembly::x86::OPCODE::VFMADDSS4mr_Int)
  .value("VFMADDSS4rm", LIEF::assembly::x86::OPCODE::VFMADDSS4rm)
  .value("VFMADDSS4rm_Int", LIEF::assembly::x86::OPCODE::VFMADDSS4rm_Int)
  .value("VFMADDSS4rr", LIEF::assembly::x86::OPCODE::VFMADDSS4rr)
  .value("VFMADDSS4rr_Int", LIEF::assembly::x86::OPCODE::VFMADDSS4rr_Int)
  .value("VFMADDSS4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFMADDSS4rr_Int_REV)
  .value("VFMADDSS4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDSS4rr_REV)
  .value("VFMADDSUB132PDYm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDYm)
  .value("VFMADDSUB132PDYr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDYr)
  .value("VFMADDSUB132PDZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128m)
  .value("VFMADDSUB132PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128mb)
  .value("VFMADDSUB132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128mbk)
  .value("VFMADDSUB132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128mbkz)
  .value("VFMADDSUB132PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128mk)
  .value("VFMADDSUB132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128mkz)
  .value("VFMADDSUB132PDZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128r)
  .value("VFMADDSUB132PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128rk)
  .value("VFMADDSUB132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ128rkz)
  .value("VFMADDSUB132PDZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256m)
  .value("VFMADDSUB132PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256mb)
  .value("VFMADDSUB132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256mbk)
  .value("VFMADDSUB132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256mbkz)
  .value("VFMADDSUB132PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256mk)
  .value("VFMADDSUB132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256mkz)
  .value("VFMADDSUB132PDZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256r)
  .value("VFMADDSUB132PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256rk)
  .value("VFMADDSUB132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZ256rkz)
  .value("VFMADDSUB132PDZm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZm)
  .value("VFMADDSUB132PDZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZmb)
  .value("VFMADDSUB132PDZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZmbk)
  .value("VFMADDSUB132PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZmbkz)
  .value("VFMADDSUB132PDZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZmk)
  .value("VFMADDSUB132PDZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZmkz)
  .value("VFMADDSUB132PDZr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZr)
  .value("VFMADDSUB132PDZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZrb)
  .value("VFMADDSUB132PDZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZrbk)
  .value("VFMADDSUB132PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZrbkz)
  .value("VFMADDSUB132PDZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZrk)
  .value("VFMADDSUB132PDZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDZrkz)
  .value("VFMADDSUB132PDm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDm)
  .value("VFMADDSUB132PDr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PDr)
  .value("VFMADDSUB132PHZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128m)
  .value("VFMADDSUB132PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128mb)
  .value("VFMADDSUB132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128mbk)
  .value("VFMADDSUB132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128mbkz)
  .value("VFMADDSUB132PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128mk)
  .value("VFMADDSUB132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128mkz)
  .value("VFMADDSUB132PHZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128r)
  .value("VFMADDSUB132PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128rk)
  .value("VFMADDSUB132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ128rkz)
  .value("VFMADDSUB132PHZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256m)
  .value("VFMADDSUB132PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256mb)
  .value("VFMADDSUB132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256mbk)
  .value("VFMADDSUB132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256mbkz)
  .value("VFMADDSUB132PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256mk)
  .value("VFMADDSUB132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256mkz)
  .value("VFMADDSUB132PHZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256r)
  .value("VFMADDSUB132PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256rk)
  .value("VFMADDSUB132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZ256rkz)
  .value("VFMADDSUB132PHZm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZm)
  .value("VFMADDSUB132PHZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZmb)
  .value("VFMADDSUB132PHZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZmbk)
  .value("VFMADDSUB132PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZmbkz)
  .value("VFMADDSUB132PHZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZmk)
  .value("VFMADDSUB132PHZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZmkz)
  .value("VFMADDSUB132PHZr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZr)
  .value("VFMADDSUB132PHZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZrb)
  .value("VFMADDSUB132PHZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZrbk)
  .value("VFMADDSUB132PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZrbkz)
  .value("VFMADDSUB132PHZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZrk)
  .value("VFMADDSUB132PHZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PHZrkz)
  .value("VFMADDSUB132PSYm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSYm)
  .value("VFMADDSUB132PSYr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSYr)
  .value("VFMADDSUB132PSZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128m)
  .value("VFMADDSUB132PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128mb)
  .value("VFMADDSUB132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128mbk)
  .value("VFMADDSUB132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128mbkz)
  .value("VFMADDSUB132PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128mk)
  .value("VFMADDSUB132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128mkz)
  .value("VFMADDSUB132PSZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128r)
  .value("VFMADDSUB132PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128rk)
  .value("VFMADDSUB132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ128rkz)
  .value("VFMADDSUB132PSZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256m)
  .value("VFMADDSUB132PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256mb)
  .value("VFMADDSUB132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256mbk)
  .value("VFMADDSUB132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256mbkz)
  .value("VFMADDSUB132PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256mk)
  .value("VFMADDSUB132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256mkz)
  .value("VFMADDSUB132PSZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256r)
  .value("VFMADDSUB132PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256rk)
  .value("VFMADDSUB132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZ256rkz)
  .value("VFMADDSUB132PSZm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZm)
  .value("VFMADDSUB132PSZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZmb)
  .value("VFMADDSUB132PSZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZmbk)
  .value("VFMADDSUB132PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZmbkz)
  .value("VFMADDSUB132PSZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZmk)
  .value("VFMADDSUB132PSZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZmkz)
  .value("VFMADDSUB132PSZr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZr)
  .value("VFMADDSUB132PSZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZrb)
  .value("VFMADDSUB132PSZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZrbk)
  .value("VFMADDSUB132PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZrbkz)
  .value("VFMADDSUB132PSZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZrk)
  .value("VFMADDSUB132PSZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSZrkz)
  .value("VFMADDSUB132PSm", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSm)
  .value("VFMADDSUB132PSr", LIEF::assembly::x86::OPCODE::VFMADDSUB132PSr)
  .value("VFMADDSUB213PDYm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDYm)
  .value("VFMADDSUB213PDYr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDYr)
  .value("VFMADDSUB213PDZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128m)
  .value("VFMADDSUB213PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128mb)
  .value("VFMADDSUB213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128mbk)
  .value("VFMADDSUB213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128mbkz)
  .value("VFMADDSUB213PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128mk)
  .value("VFMADDSUB213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128mkz)
  .value("VFMADDSUB213PDZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128r)
  .value("VFMADDSUB213PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128rk)
  .value("VFMADDSUB213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ128rkz)
  .value("VFMADDSUB213PDZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256m)
  .value("VFMADDSUB213PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256mb)
  .value("VFMADDSUB213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256mbk)
  .value("VFMADDSUB213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256mbkz)
  .value("VFMADDSUB213PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256mk)
  .value("VFMADDSUB213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256mkz)
  .value("VFMADDSUB213PDZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256r)
  .value("VFMADDSUB213PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256rk)
  .value("VFMADDSUB213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZ256rkz)
  .value("VFMADDSUB213PDZm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZm)
  .value("VFMADDSUB213PDZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZmb)
  .value("VFMADDSUB213PDZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZmbk)
  .value("VFMADDSUB213PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZmbkz)
  .value("VFMADDSUB213PDZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZmk)
  .value("VFMADDSUB213PDZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZmkz)
  .value("VFMADDSUB213PDZr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZr)
  .value("VFMADDSUB213PDZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZrb)
  .value("VFMADDSUB213PDZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZrbk)
  .value("VFMADDSUB213PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZrbkz)
  .value("VFMADDSUB213PDZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZrk)
  .value("VFMADDSUB213PDZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDZrkz)
  .value("VFMADDSUB213PDm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDm)
  .value("VFMADDSUB213PDr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PDr)
  .value("VFMADDSUB213PHZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128m)
  .value("VFMADDSUB213PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128mb)
  .value("VFMADDSUB213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128mbk)
  .value("VFMADDSUB213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128mbkz)
  .value("VFMADDSUB213PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128mk)
  .value("VFMADDSUB213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128mkz)
  .value("VFMADDSUB213PHZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128r)
  .value("VFMADDSUB213PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128rk)
  .value("VFMADDSUB213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ128rkz)
  .value("VFMADDSUB213PHZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256m)
  .value("VFMADDSUB213PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256mb)
  .value("VFMADDSUB213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256mbk)
  .value("VFMADDSUB213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256mbkz)
  .value("VFMADDSUB213PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256mk)
  .value("VFMADDSUB213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256mkz)
  .value("VFMADDSUB213PHZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256r)
  .value("VFMADDSUB213PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256rk)
  .value("VFMADDSUB213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZ256rkz)
  .value("VFMADDSUB213PHZm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZm)
  .value("VFMADDSUB213PHZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZmb)
  .value("VFMADDSUB213PHZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZmbk)
  .value("VFMADDSUB213PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZmbkz)
  .value("VFMADDSUB213PHZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZmk)
  .value("VFMADDSUB213PHZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZmkz)
  .value("VFMADDSUB213PHZr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZr)
  .value("VFMADDSUB213PHZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZrb)
  .value("VFMADDSUB213PHZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZrbk)
  .value("VFMADDSUB213PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZrbkz)
  .value("VFMADDSUB213PHZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZrk)
  .value("VFMADDSUB213PHZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PHZrkz)
  .value("VFMADDSUB213PSYm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSYm)
  .value("VFMADDSUB213PSYr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSYr)
  .value("VFMADDSUB213PSZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128m)
  .value("VFMADDSUB213PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128mb)
  .value("VFMADDSUB213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128mbk)
  .value("VFMADDSUB213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128mbkz)
  .value("VFMADDSUB213PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128mk)
  .value("VFMADDSUB213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128mkz)
  .value("VFMADDSUB213PSZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128r)
  .value("VFMADDSUB213PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128rk)
  .value("VFMADDSUB213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ128rkz)
  .value("VFMADDSUB213PSZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256m)
  .value("VFMADDSUB213PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256mb)
  .value("VFMADDSUB213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256mbk)
  .value("VFMADDSUB213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256mbkz)
  .value("VFMADDSUB213PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256mk)
  .value("VFMADDSUB213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256mkz)
  .value("VFMADDSUB213PSZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256r)
  .value("VFMADDSUB213PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256rk)
  .value("VFMADDSUB213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZ256rkz)
  .value("VFMADDSUB213PSZm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZm)
  .value("VFMADDSUB213PSZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZmb)
  .value("VFMADDSUB213PSZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZmbk)
  .value("VFMADDSUB213PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZmbkz)
  .value("VFMADDSUB213PSZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZmk)
  .value("VFMADDSUB213PSZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZmkz)
  .value("VFMADDSUB213PSZr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZr)
  .value("VFMADDSUB213PSZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZrb)
  .value("VFMADDSUB213PSZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZrbk)
  .value("VFMADDSUB213PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZrbkz)
  .value("VFMADDSUB213PSZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZrk)
  .value("VFMADDSUB213PSZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSZrkz)
  .value("VFMADDSUB213PSm", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSm)
  .value("VFMADDSUB213PSr", LIEF::assembly::x86::OPCODE::VFMADDSUB213PSr)
  .value("VFMADDSUB231PDYm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDYm)
  .value("VFMADDSUB231PDYr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDYr)
  .value("VFMADDSUB231PDZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128m)
  .value("VFMADDSUB231PDZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128mb)
  .value("VFMADDSUB231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128mbk)
  .value("VFMADDSUB231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128mbkz)
  .value("VFMADDSUB231PDZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128mk)
  .value("VFMADDSUB231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128mkz)
  .value("VFMADDSUB231PDZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128r)
  .value("VFMADDSUB231PDZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128rk)
  .value("VFMADDSUB231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ128rkz)
  .value("VFMADDSUB231PDZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256m)
  .value("VFMADDSUB231PDZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256mb)
  .value("VFMADDSUB231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256mbk)
  .value("VFMADDSUB231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256mbkz)
  .value("VFMADDSUB231PDZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256mk)
  .value("VFMADDSUB231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256mkz)
  .value("VFMADDSUB231PDZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256r)
  .value("VFMADDSUB231PDZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256rk)
  .value("VFMADDSUB231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZ256rkz)
  .value("VFMADDSUB231PDZm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZm)
  .value("VFMADDSUB231PDZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZmb)
  .value("VFMADDSUB231PDZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZmbk)
  .value("VFMADDSUB231PDZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZmbkz)
  .value("VFMADDSUB231PDZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZmk)
  .value("VFMADDSUB231PDZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZmkz)
  .value("VFMADDSUB231PDZr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZr)
  .value("VFMADDSUB231PDZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZrb)
  .value("VFMADDSUB231PDZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZrbk)
  .value("VFMADDSUB231PDZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZrbkz)
  .value("VFMADDSUB231PDZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZrk)
  .value("VFMADDSUB231PDZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDZrkz)
  .value("VFMADDSUB231PDm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDm)
  .value("VFMADDSUB231PDr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PDr)
  .value("VFMADDSUB231PHZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128m)
  .value("VFMADDSUB231PHZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128mb)
  .value("VFMADDSUB231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128mbk)
  .value("VFMADDSUB231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128mbkz)
  .value("VFMADDSUB231PHZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128mk)
  .value("VFMADDSUB231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128mkz)
  .value("VFMADDSUB231PHZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128r)
  .value("VFMADDSUB231PHZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128rk)
  .value("VFMADDSUB231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ128rkz)
  .value("VFMADDSUB231PHZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256m)
  .value("VFMADDSUB231PHZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256mb)
  .value("VFMADDSUB231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256mbk)
  .value("VFMADDSUB231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256mbkz)
  .value("VFMADDSUB231PHZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256mk)
  .value("VFMADDSUB231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256mkz)
  .value("VFMADDSUB231PHZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256r)
  .value("VFMADDSUB231PHZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256rk)
  .value("VFMADDSUB231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZ256rkz)
  .value("VFMADDSUB231PHZm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZm)
  .value("VFMADDSUB231PHZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZmb)
  .value("VFMADDSUB231PHZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZmbk)
  .value("VFMADDSUB231PHZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZmbkz)
  .value("VFMADDSUB231PHZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZmk)
  .value("VFMADDSUB231PHZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZmkz)
  .value("VFMADDSUB231PHZr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZr)
  .value("VFMADDSUB231PHZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZrb)
  .value("VFMADDSUB231PHZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZrbk)
  .value("VFMADDSUB231PHZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZrbkz)
  .value("VFMADDSUB231PHZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZrk)
  .value("VFMADDSUB231PHZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PHZrkz)
  .value("VFMADDSUB231PSYm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSYm)
  .value("VFMADDSUB231PSYr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSYr)
  .value("VFMADDSUB231PSZ128m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128m)
  .value("VFMADDSUB231PSZ128mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128mb)
  .value("VFMADDSUB231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128mbk)
  .value("VFMADDSUB231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128mbkz)
  .value("VFMADDSUB231PSZ128mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128mk)
  .value("VFMADDSUB231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128mkz)
  .value("VFMADDSUB231PSZ128r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128r)
  .value("VFMADDSUB231PSZ128rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128rk)
  .value("VFMADDSUB231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ128rkz)
  .value("VFMADDSUB231PSZ256m", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256m)
  .value("VFMADDSUB231PSZ256mb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256mb)
  .value("VFMADDSUB231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256mbk)
  .value("VFMADDSUB231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256mbkz)
  .value("VFMADDSUB231PSZ256mk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256mk)
  .value("VFMADDSUB231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256mkz)
  .value("VFMADDSUB231PSZ256r", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256r)
  .value("VFMADDSUB231PSZ256rk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256rk)
  .value("VFMADDSUB231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZ256rkz)
  .value("VFMADDSUB231PSZm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZm)
  .value("VFMADDSUB231PSZmb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZmb)
  .value("VFMADDSUB231PSZmbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZmbk)
  .value("VFMADDSUB231PSZmbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZmbkz)
  .value("VFMADDSUB231PSZmk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZmk)
  .value("VFMADDSUB231PSZmkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZmkz)
  .value("VFMADDSUB231PSZr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZr)
  .value("VFMADDSUB231PSZrb", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZrb)
  .value("VFMADDSUB231PSZrbk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZrbk);
  opcodes.value("VFMADDSUB231PSZrbkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZrbkz)
  .value("VFMADDSUB231PSZrk", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZrk)
  .value("VFMADDSUB231PSZrkz", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSZrkz)
  .value("VFMADDSUB231PSm", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSm)
  .value("VFMADDSUB231PSr", LIEF::assembly::x86::OPCODE::VFMADDSUB231PSr)
  .value("VFMADDSUBPD4Ymr", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4Ymr)
  .value("VFMADDSUBPD4Yrm", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4Yrm)
  .value("VFMADDSUBPD4Yrr", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4Yrr)
  .value("VFMADDSUBPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4Yrr_REV)
  .value("VFMADDSUBPD4mr", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4mr)
  .value("VFMADDSUBPD4rm", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4rm)
  .value("VFMADDSUBPD4rr", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4rr)
  .value("VFMADDSUBPD4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDSUBPD4rr_REV)
  .value("VFMADDSUBPS4Ymr", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4Ymr)
  .value("VFMADDSUBPS4Yrm", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4Yrm)
  .value("VFMADDSUBPS4Yrr", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4Yrr)
  .value("VFMADDSUBPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4Yrr_REV)
  .value("VFMADDSUBPS4mr", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4mr)
  .value("VFMADDSUBPS4rm", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4rm)
  .value("VFMADDSUBPS4rr", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4rr)
  .value("VFMADDSUBPS4rr_REV", LIEF::assembly::x86::OPCODE::VFMADDSUBPS4rr_REV)
  .value("VFMSUB132BF16Z128m", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128m)
  .value("VFMSUB132BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128mb)
  .value("VFMSUB132BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128mbk)
  .value("VFMSUB132BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128mbkz)
  .value("VFMSUB132BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128mk)
  .value("VFMSUB132BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128mkz)
  .value("VFMSUB132BF16Z128r", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128r)
  .value("VFMSUB132BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128rk)
  .value("VFMSUB132BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z128rkz)
  .value("VFMSUB132BF16Z256m", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256m)
  .value("VFMSUB132BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256mb)
  .value("VFMSUB132BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256mbk)
  .value("VFMSUB132BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256mbkz)
  .value("VFMSUB132BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256mk)
  .value("VFMSUB132BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256mkz)
  .value("VFMSUB132BF16Z256r", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256r)
  .value("VFMSUB132BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256rk)
  .value("VFMSUB132BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Z256rkz)
  .value("VFMSUB132BF16Zm", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zm)
  .value("VFMSUB132BF16Zmb", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zmb)
  .value("VFMSUB132BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zmbk)
  .value("VFMSUB132BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zmbkz)
  .value("VFMSUB132BF16Zmk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zmk)
  .value("VFMSUB132BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zmkz)
  .value("VFMSUB132BF16Zr", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zr)
  .value("VFMSUB132BF16Zrk", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zrk)
  .value("VFMSUB132BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMSUB132BF16Zrkz)
  .value("VFMSUB132PDYm", LIEF::assembly::x86::OPCODE::VFMSUB132PDYm)
  .value("VFMSUB132PDYr", LIEF::assembly::x86::OPCODE::VFMSUB132PDYr)
  .value("VFMSUB132PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128m)
  .value("VFMSUB132PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128mb)
  .value("VFMSUB132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128mbk)
  .value("VFMSUB132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128mbkz)
  .value("VFMSUB132PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128mk)
  .value("VFMSUB132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128mkz)
  .value("VFMSUB132PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128r)
  .value("VFMSUB132PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128rk)
  .value("VFMSUB132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ128rkz)
  .value("VFMSUB132PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256m)
  .value("VFMSUB132PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256mb)
  .value("VFMSUB132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256mbk)
  .value("VFMSUB132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256mbkz)
  .value("VFMSUB132PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256mk)
  .value("VFMSUB132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256mkz)
  .value("VFMSUB132PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256r)
  .value("VFMSUB132PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256rk)
  .value("VFMSUB132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZ256rkz)
  .value("VFMSUB132PDZm", LIEF::assembly::x86::OPCODE::VFMSUB132PDZm)
  .value("VFMSUB132PDZmb", LIEF::assembly::x86::OPCODE::VFMSUB132PDZmb)
  .value("VFMSUB132PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZmbk)
  .value("VFMSUB132PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZmbkz)
  .value("VFMSUB132PDZmk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZmk)
  .value("VFMSUB132PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZmkz)
  .value("VFMSUB132PDZr", LIEF::assembly::x86::OPCODE::VFMSUB132PDZr)
  .value("VFMSUB132PDZrb", LIEF::assembly::x86::OPCODE::VFMSUB132PDZrb)
  .value("VFMSUB132PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZrbk)
  .value("VFMSUB132PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZrbkz)
  .value("VFMSUB132PDZrk", LIEF::assembly::x86::OPCODE::VFMSUB132PDZrk)
  .value("VFMSUB132PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUB132PDZrkz)
  .value("VFMSUB132PDm", LIEF::assembly::x86::OPCODE::VFMSUB132PDm)
  .value("VFMSUB132PDr", LIEF::assembly::x86::OPCODE::VFMSUB132PDr)
  .value("VFMSUB132PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128m)
  .value("VFMSUB132PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128mb)
  .value("VFMSUB132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128mbk)
  .value("VFMSUB132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128mbkz)
  .value("VFMSUB132PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128mk)
  .value("VFMSUB132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128mkz)
  .value("VFMSUB132PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128r)
  .value("VFMSUB132PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128rk)
  .value("VFMSUB132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ128rkz)
  .value("VFMSUB132PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256m)
  .value("VFMSUB132PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256mb)
  .value("VFMSUB132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256mbk)
  .value("VFMSUB132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256mbkz)
  .value("VFMSUB132PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256mk)
  .value("VFMSUB132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256mkz)
  .value("VFMSUB132PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256r)
  .value("VFMSUB132PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256rk)
  .value("VFMSUB132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZ256rkz)
  .value("VFMSUB132PHZm", LIEF::assembly::x86::OPCODE::VFMSUB132PHZm)
  .value("VFMSUB132PHZmb", LIEF::assembly::x86::OPCODE::VFMSUB132PHZmb)
  .value("VFMSUB132PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZmbk)
  .value("VFMSUB132PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZmbkz)
  .value("VFMSUB132PHZmk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZmk)
  .value("VFMSUB132PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZmkz)
  .value("VFMSUB132PHZr", LIEF::assembly::x86::OPCODE::VFMSUB132PHZr)
  .value("VFMSUB132PHZrb", LIEF::assembly::x86::OPCODE::VFMSUB132PHZrb)
  .value("VFMSUB132PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZrbk)
  .value("VFMSUB132PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZrbkz)
  .value("VFMSUB132PHZrk", LIEF::assembly::x86::OPCODE::VFMSUB132PHZrk)
  .value("VFMSUB132PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUB132PHZrkz)
  .value("VFMSUB132PSYm", LIEF::assembly::x86::OPCODE::VFMSUB132PSYm)
  .value("VFMSUB132PSYr", LIEF::assembly::x86::OPCODE::VFMSUB132PSYr)
  .value("VFMSUB132PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128m)
  .value("VFMSUB132PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128mb)
  .value("VFMSUB132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128mbk)
  .value("VFMSUB132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128mbkz)
  .value("VFMSUB132PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128mk)
  .value("VFMSUB132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128mkz)
  .value("VFMSUB132PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128r)
  .value("VFMSUB132PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128rk)
  .value("VFMSUB132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ128rkz)
  .value("VFMSUB132PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256m)
  .value("VFMSUB132PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256mb)
  .value("VFMSUB132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256mbk)
  .value("VFMSUB132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256mbkz)
  .value("VFMSUB132PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256mk)
  .value("VFMSUB132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256mkz)
  .value("VFMSUB132PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256r)
  .value("VFMSUB132PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256rk)
  .value("VFMSUB132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZ256rkz)
  .value("VFMSUB132PSZm", LIEF::assembly::x86::OPCODE::VFMSUB132PSZm)
  .value("VFMSUB132PSZmb", LIEF::assembly::x86::OPCODE::VFMSUB132PSZmb)
  .value("VFMSUB132PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZmbk)
  .value("VFMSUB132PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZmbkz)
  .value("VFMSUB132PSZmk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZmk)
  .value("VFMSUB132PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZmkz)
  .value("VFMSUB132PSZr", LIEF::assembly::x86::OPCODE::VFMSUB132PSZr)
  .value("VFMSUB132PSZrb", LIEF::assembly::x86::OPCODE::VFMSUB132PSZrb)
  .value("VFMSUB132PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZrbk)
  .value("VFMSUB132PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZrbkz)
  .value("VFMSUB132PSZrk", LIEF::assembly::x86::OPCODE::VFMSUB132PSZrk)
  .value("VFMSUB132PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUB132PSZrkz)
  .value("VFMSUB132PSm", LIEF::assembly::x86::OPCODE::VFMSUB132PSm)
  .value("VFMSUB132PSr", LIEF::assembly::x86::OPCODE::VFMSUB132PSr)
  .value("VFMSUB132SDZm", LIEF::assembly::x86::OPCODE::VFMSUB132SDZm)
  .value("VFMSUB132SDZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZm_Int)
  .value("VFMSUB132SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZmk_Int)
  .value("VFMSUB132SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZmkz_Int)
  .value("VFMSUB132SDZr", LIEF::assembly::x86::OPCODE::VFMSUB132SDZr)
  .value("VFMSUB132SDZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZr_Int)
  .value("VFMSUB132SDZrb", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrb)
  .value("VFMSUB132SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrb_Int)
  .value("VFMSUB132SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrbk_Int)
  .value("VFMSUB132SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrbkz_Int)
  .value("VFMSUB132SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrk_Int)
  .value("VFMSUB132SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDZrkz_Int)
  .value("VFMSUB132SDm", LIEF::assembly::x86::OPCODE::VFMSUB132SDm)
  .value("VFMSUB132SDm_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDm_Int)
  .value("VFMSUB132SDr", LIEF::assembly::x86::OPCODE::VFMSUB132SDr)
  .value("VFMSUB132SDr_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SDr_Int)
  .value("VFMSUB132SHZm", LIEF::assembly::x86::OPCODE::VFMSUB132SHZm)
  .value("VFMSUB132SHZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZm_Int)
  .value("VFMSUB132SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZmk_Int)
  .value("VFMSUB132SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZmkz_Int)
  .value("VFMSUB132SHZr", LIEF::assembly::x86::OPCODE::VFMSUB132SHZr)
  .value("VFMSUB132SHZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZr_Int)
  .value("VFMSUB132SHZrb", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrb)
  .value("VFMSUB132SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrb_Int)
  .value("VFMSUB132SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrbk_Int)
  .value("VFMSUB132SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrbkz_Int)
  .value("VFMSUB132SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrk_Int)
  .value("VFMSUB132SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SHZrkz_Int)
  .value("VFMSUB132SSZm", LIEF::assembly::x86::OPCODE::VFMSUB132SSZm)
  .value("VFMSUB132SSZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZm_Int)
  .value("VFMSUB132SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZmk_Int)
  .value("VFMSUB132SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZmkz_Int)
  .value("VFMSUB132SSZr", LIEF::assembly::x86::OPCODE::VFMSUB132SSZr)
  .value("VFMSUB132SSZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZr_Int)
  .value("VFMSUB132SSZrb", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrb)
  .value("VFMSUB132SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrb_Int)
  .value("VFMSUB132SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrbk_Int)
  .value("VFMSUB132SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrbkz_Int)
  .value("VFMSUB132SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrk_Int)
  .value("VFMSUB132SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSZrkz_Int)
  .value("VFMSUB132SSm", LIEF::assembly::x86::OPCODE::VFMSUB132SSm)
  .value("VFMSUB132SSm_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSm_Int)
  .value("VFMSUB132SSr", LIEF::assembly::x86::OPCODE::VFMSUB132SSr)
  .value("VFMSUB132SSr_Int", LIEF::assembly::x86::OPCODE::VFMSUB132SSr_Int)
  .value("VFMSUB213BF16Z128m", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128m)
  .value("VFMSUB213BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128mb)
  .value("VFMSUB213BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128mbk)
  .value("VFMSUB213BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128mbkz)
  .value("VFMSUB213BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128mk)
  .value("VFMSUB213BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128mkz)
  .value("VFMSUB213BF16Z128r", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128r)
  .value("VFMSUB213BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128rk)
  .value("VFMSUB213BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z128rkz)
  .value("VFMSUB213BF16Z256m", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256m)
  .value("VFMSUB213BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256mb)
  .value("VFMSUB213BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256mbk)
  .value("VFMSUB213BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256mbkz)
  .value("VFMSUB213BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256mk)
  .value("VFMSUB213BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256mkz)
  .value("VFMSUB213BF16Z256r", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256r)
  .value("VFMSUB213BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256rk)
  .value("VFMSUB213BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Z256rkz)
  .value("VFMSUB213BF16Zm", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zm)
  .value("VFMSUB213BF16Zmb", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zmb)
  .value("VFMSUB213BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zmbk)
  .value("VFMSUB213BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zmbkz)
  .value("VFMSUB213BF16Zmk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zmk)
  .value("VFMSUB213BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zmkz)
  .value("VFMSUB213BF16Zr", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zr)
  .value("VFMSUB213BF16Zrk", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zrk)
  .value("VFMSUB213BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMSUB213BF16Zrkz)
  .value("VFMSUB213PDYm", LIEF::assembly::x86::OPCODE::VFMSUB213PDYm)
  .value("VFMSUB213PDYr", LIEF::assembly::x86::OPCODE::VFMSUB213PDYr)
  .value("VFMSUB213PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128m)
  .value("VFMSUB213PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128mb)
  .value("VFMSUB213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128mbk)
  .value("VFMSUB213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128mbkz)
  .value("VFMSUB213PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128mk)
  .value("VFMSUB213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128mkz)
  .value("VFMSUB213PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128r)
  .value("VFMSUB213PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128rk)
  .value("VFMSUB213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ128rkz)
  .value("VFMSUB213PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256m)
  .value("VFMSUB213PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256mb)
  .value("VFMSUB213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256mbk)
  .value("VFMSUB213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256mbkz)
  .value("VFMSUB213PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256mk)
  .value("VFMSUB213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256mkz)
  .value("VFMSUB213PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256r)
  .value("VFMSUB213PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256rk)
  .value("VFMSUB213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZ256rkz)
  .value("VFMSUB213PDZm", LIEF::assembly::x86::OPCODE::VFMSUB213PDZm)
  .value("VFMSUB213PDZmb", LIEF::assembly::x86::OPCODE::VFMSUB213PDZmb)
  .value("VFMSUB213PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZmbk)
  .value("VFMSUB213PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZmbkz)
  .value("VFMSUB213PDZmk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZmk)
  .value("VFMSUB213PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZmkz)
  .value("VFMSUB213PDZr", LIEF::assembly::x86::OPCODE::VFMSUB213PDZr)
  .value("VFMSUB213PDZrb", LIEF::assembly::x86::OPCODE::VFMSUB213PDZrb)
  .value("VFMSUB213PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZrbk)
  .value("VFMSUB213PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZrbkz)
  .value("VFMSUB213PDZrk", LIEF::assembly::x86::OPCODE::VFMSUB213PDZrk)
  .value("VFMSUB213PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUB213PDZrkz)
  .value("VFMSUB213PDm", LIEF::assembly::x86::OPCODE::VFMSUB213PDm)
  .value("VFMSUB213PDr", LIEF::assembly::x86::OPCODE::VFMSUB213PDr)
  .value("VFMSUB213PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128m)
  .value("VFMSUB213PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128mb)
  .value("VFMSUB213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128mbk)
  .value("VFMSUB213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128mbkz)
  .value("VFMSUB213PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128mk)
  .value("VFMSUB213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128mkz)
  .value("VFMSUB213PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128r)
  .value("VFMSUB213PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128rk)
  .value("VFMSUB213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ128rkz)
  .value("VFMSUB213PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256m)
  .value("VFMSUB213PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256mb)
  .value("VFMSUB213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256mbk)
  .value("VFMSUB213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256mbkz)
  .value("VFMSUB213PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256mk)
  .value("VFMSUB213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256mkz)
  .value("VFMSUB213PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256r)
  .value("VFMSUB213PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256rk)
  .value("VFMSUB213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZ256rkz)
  .value("VFMSUB213PHZm", LIEF::assembly::x86::OPCODE::VFMSUB213PHZm)
  .value("VFMSUB213PHZmb", LIEF::assembly::x86::OPCODE::VFMSUB213PHZmb)
  .value("VFMSUB213PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZmbk)
  .value("VFMSUB213PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZmbkz)
  .value("VFMSUB213PHZmk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZmk)
  .value("VFMSUB213PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZmkz)
  .value("VFMSUB213PHZr", LIEF::assembly::x86::OPCODE::VFMSUB213PHZr)
  .value("VFMSUB213PHZrb", LIEF::assembly::x86::OPCODE::VFMSUB213PHZrb)
  .value("VFMSUB213PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZrbk)
  .value("VFMSUB213PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZrbkz)
  .value("VFMSUB213PHZrk", LIEF::assembly::x86::OPCODE::VFMSUB213PHZrk)
  .value("VFMSUB213PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUB213PHZrkz)
  .value("VFMSUB213PSYm", LIEF::assembly::x86::OPCODE::VFMSUB213PSYm)
  .value("VFMSUB213PSYr", LIEF::assembly::x86::OPCODE::VFMSUB213PSYr)
  .value("VFMSUB213PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128m)
  .value("VFMSUB213PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128mb)
  .value("VFMSUB213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128mbk)
  .value("VFMSUB213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128mbkz)
  .value("VFMSUB213PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128mk)
  .value("VFMSUB213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128mkz)
  .value("VFMSUB213PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128r)
  .value("VFMSUB213PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128rk)
  .value("VFMSUB213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ128rkz)
  .value("VFMSUB213PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256m)
  .value("VFMSUB213PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256mb)
  .value("VFMSUB213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256mbk)
  .value("VFMSUB213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256mbkz)
  .value("VFMSUB213PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256mk)
  .value("VFMSUB213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256mkz)
  .value("VFMSUB213PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256r)
  .value("VFMSUB213PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256rk);
  opcodes.value("VFMSUB213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZ256rkz)
  .value("VFMSUB213PSZm", LIEF::assembly::x86::OPCODE::VFMSUB213PSZm)
  .value("VFMSUB213PSZmb", LIEF::assembly::x86::OPCODE::VFMSUB213PSZmb)
  .value("VFMSUB213PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZmbk)
  .value("VFMSUB213PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZmbkz)
  .value("VFMSUB213PSZmk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZmk)
  .value("VFMSUB213PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZmkz)
  .value("VFMSUB213PSZr", LIEF::assembly::x86::OPCODE::VFMSUB213PSZr)
  .value("VFMSUB213PSZrb", LIEF::assembly::x86::OPCODE::VFMSUB213PSZrb)
  .value("VFMSUB213PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZrbk)
  .value("VFMSUB213PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZrbkz)
  .value("VFMSUB213PSZrk", LIEF::assembly::x86::OPCODE::VFMSUB213PSZrk)
  .value("VFMSUB213PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUB213PSZrkz)
  .value("VFMSUB213PSm", LIEF::assembly::x86::OPCODE::VFMSUB213PSm)
  .value("VFMSUB213PSr", LIEF::assembly::x86::OPCODE::VFMSUB213PSr)
  .value("VFMSUB213SDZm", LIEF::assembly::x86::OPCODE::VFMSUB213SDZm)
  .value("VFMSUB213SDZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZm_Int)
  .value("VFMSUB213SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZmk_Int)
  .value("VFMSUB213SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZmkz_Int)
  .value("VFMSUB213SDZr", LIEF::assembly::x86::OPCODE::VFMSUB213SDZr)
  .value("VFMSUB213SDZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZr_Int)
  .value("VFMSUB213SDZrb", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrb)
  .value("VFMSUB213SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrb_Int)
  .value("VFMSUB213SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrbk_Int)
  .value("VFMSUB213SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrbkz_Int)
  .value("VFMSUB213SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrk_Int)
  .value("VFMSUB213SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDZrkz_Int)
  .value("VFMSUB213SDm", LIEF::assembly::x86::OPCODE::VFMSUB213SDm)
  .value("VFMSUB213SDm_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDm_Int)
  .value("VFMSUB213SDr", LIEF::assembly::x86::OPCODE::VFMSUB213SDr)
  .value("VFMSUB213SDr_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SDr_Int)
  .value("VFMSUB213SHZm", LIEF::assembly::x86::OPCODE::VFMSUB213SHZm)
  .value("VFMSUB213SHZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZm_Int)
  .value("VFMSUB213SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZmk_Int)
  .value("VFMSUB213SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZmkz_Int)
  .value("VFMSUB213SHZr", LIEF::assembly::x86::OPCODE::VFMSUB213SHZr)
  .value("VFMSUB213SHZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZr_Int)
  .value("VFMSUB213SHZrb", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrb)
  .value("VFMSUB213SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrb_Int)
  .value("VFMSUB213SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrbk_Int)
  .value("VFMSUB213SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrbkz_Int)
  .value("VFMSUB213SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrk_Int)
  .value("VFMSUB213SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SHZrkz_Int)
  .value("VFMSUB213SSZm", LIEF::assembly::x86::OPCODE::VFMSUB213SSZm)
  .value("VFMSUB213SSZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZm_Int)
  .value("VFMSUB213SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZmk_Int)
  .value("VFMSUB213SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZmkz_Int)
  .value("VFMSUB213SSZr", LIEF::assembly::x86::OPCODE::VFMSUB213SSZr)
  .value("VFMSUB213SSZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZr_Int)
  .value("VFMSUB213SSZrb", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrb)
  .value("VFMSUB213SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrb_Int)
  .value("VFMSUB213SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrbk_Int)
  .value("VFMSUB213SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrbkz_Int)
  .value("VFMSUB213SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrk_Int)
  .value("VFMSUB213SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSZrkz_Int)
  .value("VFMSUB213SSm", LIEF::assembly::x86::OPCODE::VFMSUB213SSm)
  .value("VFMSUB213SSm_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSm_Int)
  .value("VFMSUB213SSr", LIEF::assembly::x86::OPCODE::VFMSUB213SSr)
  .value("VFMSUB213SSr_Int", LIEF::assembly::x86::OPCODE::VFMSUB213SSr_Int)
  .value("VFMSUB231BF16Z128m", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128m)
  .value("VFMSUB231BF16Z128mb", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128mb)
  .value("VFMSUB231BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128mbk)
  .value("VFMSUB231BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128mbkz)
  .value("VFMSUB231BF16Z128mk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128mk)
  .value("VFMSUB231BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128mkz)
  .value("VFMSUB231BF16Z128r", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128r)
  .value("VFMSUB231BF16Z128rk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128rk)
  .value("VFMSUB231BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z128rkz)
  .value("VFMSUB231BF16Z256m", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256m)
  .value("VFMSUB231BF16Z256mb", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256mb)
  .value("VFMSUB231BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256mbk)
  .value("VFMSUB231BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256mbkz)
  .value("VFMSUB231BF16Z256mk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256mk)
  .value("VFMSUB231BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256mkz)
  .value("VFMSUB231BF16Z256r", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256r)
  .value("VFMSUB231BF16Z256rk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256rk)
  .value("VFMSUB231BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Z256rkz)
  .value("VFMSUB231BF16Zm", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zm)
  .value("VFMSUB231BF16Zmb", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zmb)
  .value("VFMSUB231BF16Zmbk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zmbk)
  .value("VFMSUB231BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zmbkz)
  .value("VFMSUB231BF16Zmk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zmk)
  .value("VFMSUB231BF16Zmkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zmkz)
  .value("VFMSUB231BF16Zr", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zr)
  .value("VFMSUB231BF16Zrk", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zrk)
  .value("VFMSUB231BF16Zrkz", LIEF::assembly::x86::OPCODE::VFMSUB231BF16Zrkz)
  .value("VFMSUB231PDYm", LIEF::assembly::x86::OPCODE::VFMSUB231PDYm)
  .value("VFMSUB231PDYr", LIEF::assembly::x86::OPCODE::VFMSUB231PDYr)
  .value("VFMSUB231PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128m)
  .value("VFMSUB231PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128mb)
  .value("VFMSUB231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128mbk)
  .value("VFMSUB231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128mbkz)
  .value("VFMSUB231PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128mk)
  .value("VFMSUB231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128mkz)
  .value("VFMSUB231PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128r)
  .value("VFMSUB231PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128rk)
  .value("VFMSUB231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ128rkz)
  .value("VFMSUB231PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256m)
  .value("VFMSUB231PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256mb)
  .value("VFMSUB231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256mbk)
  .value("VFMSUB231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256mbkz)
  .value("VFMSUB231PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256mk)
  .value("VFMSUB231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256mkz)
  .value("VFMSUB231PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256r)
  .value("VFMSUB231PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256rk)
  .value("VFMSUB231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZ256rkz)
  .value("VFMSUB231PDZm", LIEF::assembly::x86::OPCODE::VFMSUB231PDZm)
  .value("VFMSUB231PDZmb", LIEF::assembly::x86::OPCODE::VFMSUB231PDZmb)
  .value("VFMSUB231PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZmbk)
  .value("VFMSUB231PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZmbkz)
  .value("VFMSUB231PDZmk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZmk)
  .value("VFMSUB231PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZmkz)
  .value("VFMSUB231PDZr", LIEF::assembly::x86::OPCODE::VFMSUB231PDZr)
  .value("VFMSUB231PDZrb", LIEF::assembly::x86::OPCODE::VFMSUB231PDZrb)
  .value("VFMSUB231PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZrbk)
  .value("VFMSUB231PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZrbkz)
  .value("VFMSUB231PDZrk", LIEF::assembly::x86::OPCODE::VFMSUB231PDZrk)
  .value("VFMSUB231PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUB231PDZrkz)
  .value("VFMSUB231PDm", LIEF::assembly::x86::OPCODE::VFMSUB231PDm)
  .value("VFMSUB231PDr", LIEF::assembly::x86::OPCODE::VFMSUB231PDr)
  .value("VFMSUB231PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128m)
  .value("VFMSUB231PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128mb)
  .value("VFMSUB231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128mbk)
  .value("VFMSUB231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128mbkz)
  .value("VFMSUB231PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128mk)
  .value("VFMSUB231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128mkz)
  .value("VFMSUB231PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128r)
  .value("VFMSUB231PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128rk)
  .value("VFMSUB231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ128rkz)
  .value("VFMSUB231PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256m)
  .value("VFMSUB231PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256mb)
  .value("VFMSUB231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256mbk)
  .value("VFMSUB231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256mbkz)
  .value("VFMSUB231PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256mk)
  .value("VFMSUB231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256mkz)
  .value("VFMSUB231PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256r)
  .value("VFMSUB231PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256rk)
  .value("VFMSUB231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZ256rkz)
  .value("VFMSUB231PHZm", LIEF::assembly::x86::OPCODE::VFMSUB231PHZm)
  .value("VFMSUB231PHZmb", LIEF::assembly::x86::OPCODE::VFMSUB231PHZmb)
  .value("VFMSUB231PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZmbk)
  .value("VFMSUB231PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZmbkz)
  .value("VFMSUB231PHZmk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZmk)
  .value("VFMSUB231PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZmkz)
  .value("VFMSUB231PHZr", LIEF::assembly::x86::OPCODE::VFMSUB231PHZr)
  .value("VFMSUB231PHZrb", LIEF::assembly::x86::OPCODE::VFMSUB231PHZrb)
  .value("VFMSUB231PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZrbk)
  .value("VFMSUB231PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZrbkz)
  .value("VFMSUB231PHZrk", LIEF::assembly::x86::OPCODE::VFMSUB231PHZrk)
  .value("VFMSUB231PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUB231PHZrkz)
  .value("VFMSUB231PSYm", LIEF::assembly::x86::OPCODE::VFMSUB231PSYm)
  .value("VFMSUB231PSYr", LIEF::assembly::x86::OPCODE::VFMSUB231PSYr)
  .value("VFMSUB231PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128m)
  .value("VFMSUB231PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128mb)
  .value("VFMSUB231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128mbk)
  .value("VFMSUB231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128mbkz)
  .value("VFMSUB231PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128mk)
  .value("VFMSUB231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128mkz)
  .value("VFMSUB231PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128r)
  .value("VFMSUB231PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128rk)
  .value("VFMSUB231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ128rkz)
  .value("VFMSUB231PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256m)
  .value("VFMSUB231PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256mb)
  .value("VFMSUB231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256mbk)
  .value("VFMSUB231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256mbkz)
  .value("VFMSUB231PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256mk)
  .value("VFMSUB231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256mkz)
  .value("VFMSUB231PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256r)
  .value("VFMSUB231PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256rk)
  .value("VFMSUB231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZ256rkz)
  .value("VFMSUB231PSZm", LIEF::assembly::x86::OPCODE::VFMSUB231PSZm)
  .value("VFMSUB231PSZmb", LIEF::assembly::x86::OPCODE::VFMSUB231PSZmb)
  .value("VFMSUB231PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZmbk)
  .value("VFMSUB231PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZmbkz)
  .value("VFMSUB231PSZmk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZmk)
  .value("VFMSUB231PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZmkz)
  .value("VFMSUB231PSZr", LIEF::assembly::x86::OPCODE::VFMSUB231PSZr)
  .value("VFMSUB231PSZrb", LIEF::assembly::x86::OPCODE::VFMSUB231PSZrb)
  .value("VFMSUB231PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZrbk)
  .value("VFMSUB231PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZrbkz)
  .value("VFMSUB231PSZrk", LIEF::assembly::x86::OPCODE::VFMSUB231PSZrk)
  .value("VFMSUB231PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUB231PSZrkz)
  .value("VFMSUB231PSm", LIEF::assembly::x86::OPCODE::VFMSUB231PSm)
  .value("VFMSUB231PSr", LIEF::assembly::x86::OPCODE::VFMSUB231PSr)
  .value("VFMSUB231SDZm", LIEF::assembly::x86::OPCODE::VFMSUB231SDZm)
  .value("VFMSUB231SDZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZm_Int)
  .value("VFMSUB231SDZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZmk_Int)
  .value("VFMSUB231SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZmkz_Int)
  .value("VFMSUB231SDZr", LIEF::assembly::x86::OPCODE::VFMSUB231SDZr)
  .value("VFMSUB231SDZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZr_Int)
  .value("VFMSUB231SDZrb", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrb)
  .value("VFMSUB231SDZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrb_Int)
  .value("VFMSUB231SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrbk_Int)
  .value("VFMSUB231SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrbkz_Int)
  .value("VFMSUB231SDZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrk_Int)
  .value("VFMSUB231SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDZrkz_Int)
  .value("VFMSUB231SDm", LIEF::assembly::x86::OPCODE::VFMSUB231SDm)
  .value("VFMSUB231SDm_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDm_Int)
  .value("VFMSUB231SDr", LIEF::assembly::x86::OPCODE::VFMSUB231SDr)
  .value("VFMSUB231SDr_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SDr_Int)
  .value("VFMSUB231SHZm", LIEF::assembly::x86::OPCODE::VFMSUB231SHZm)
  .value("VFMSUB231SHZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZm_Int)
  .value("VFMSUB231SHZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZmk_Int)
  .value("VFMSUB231SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZmkz_Int)
  .value("VFMSUB231SHZr", LIEF::assembly::x86::OPCODE::VFMSUB231SHZr)
  .value("VFMSUB231SHZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZr_Int)
  .value("VFMSUB231SHZrb", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrb)
  .value("VFMSUB231SHZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrb_Int)
  .value("VFMSUB231SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrbk_Int)
  .value("VFMSUB231SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrbkz_Int)
  .value("VFMSUB231SHZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrk_Int)
  .value("VFMSUB231SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SHZrkz_Int)
  .value("VFMSUB231SSZm", LIEF::assembly::x86::OPCODE::VFMSUB231SSZm)
  .value("VFMSUB231SSZm_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZm_Int)
  .value("VFMSUB231SSZmk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZmk_Int)
  .value("VFMSUB231SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZmkz_Int)
  .value("VFMSUB231SSZr", LIEF::assembly::x86::OPCODE::VFMSUB231SSZr)
  .value("VFMSUB231SSZr_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZr_Int)
  .value("VFMSUB231SSZrb", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrb)
  .value("VFMSUB231SSZrb_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrb_Int)
  .value("VFMSUB231SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrbk_Int)
  .value("VFMSUB231SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrbkz_Int)
  .value("VFMSUB231SSZrk_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrk_Int)
  .value("VFMSUB231SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSZrkz_Int)
  .value("VFMSUB231SSm", LIEF::assembly::x86::OPCODE::VFMSUB231SSm)
  .value("VFMSUB231SSm_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSm_Int)
  .value("VFMSUB231SSr", LIEF::assembly::x86::OPCODE::VFMSUB231SSr)
  .value("VFMSUB231SSr_Int", LIEF::assembly::x86::OPCODE::VFMSUB231SSr_Int)
  .value("VFMSUBADD132PDYm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDYm)
  .value("VFMSUBADD132PDYr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDYr)
  .value("VFMSUBADD132PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128m)
  .value("VFMSUBADD132PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128mb)
  .value("VFMSUBADD132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128mbk)
  .value("VFMSUBADD132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128mbkz)
  .value("VFMSUBADD132PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128mk)
  .value("VFMSUBADD132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128mkz)
  .value("VFMSUBADD132PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128r)
  .value("VFMSUBADD132PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128rk)
  .value("VFMSUBADD132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ128rkz)
  .value("VFMSUBADD132PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256m)
  .value("VFMSUBADD132PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256mb)
  .value("VFMSUBADD132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256mbk)
  .value("VFMSUBADD132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256mbkz)
  .value("VFMSUBADD132PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256mk)
  .value("VFMSUBADD132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256mkz)
  .value("VFMSUBADD132PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256r)
  .value("VFMSUBADD132PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256rk)
  .value("VFMSUBADD132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZ256rkz)
  .value("VFMSUBADD132PDZm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZm)
  .value("VFMSUBADD132PDZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZmb)
  .value("VFMSUBADD132PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZmbk)
  .value("VFMSUBADD132PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZmbkz)
  .value("VFMSUBADD132PDZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZmk)
  .value("VFMSUBADD132PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZmkz)
  .value("VFMSUBADD132PDZr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZr)
  .value("VFMSUBADD132PDZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZrb)
  .value("VFMSUBADD132PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZrbk)
  .value("VFMSUBADD132PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZrbkz)
  .value("VFMSUBADD132PDZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZrk)
  .value("VFMSUBADD132PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDZrkz)
  .value("VFMSUBADD132PDm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDm)
  .value("VFMSUBADD132PDr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PDr)
  .value("VFMSUBADD132PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128m)
  .value("VFMSUBADD132PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128mb)
  .value("VFMSUBADD132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128mbk)
  .value("VFMSUBADD132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128mbkz)
  .value("VFMSUBADD132PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128mk)
  .value("VFMSUBADD132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128mkz)
  .value("VFMSUBADD132PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128r)
  .value("VFMSUBADD132PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128rk)
  .value("VFMSUBADD132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ128rkz)
  .value("VFMSUBADD132PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256m)
  .value("VFMSUBADD132PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256mb)
  .value("VFMSUBADD132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256mbk)
  .value("VFMSUBADD132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256mbkz)
  .value("VFMSUBADD132PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256mk)
  .value("VFMSUBADD132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256mkz)
  .value("VFMSUBADD132PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256r)
  .value("VFMSUBADD132PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256rk)
  .value("VFMSUBADD132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZ256rkz)
  .value("VFMSUBADD132PHZm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZm)
  .value("VFMSUBADD132PHZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZmb)
  .value("VFMSUBADD132PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZmbk)
  .value("VFMSUBADD132PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZmbkz)
  .value("VFMSUBADD132PHZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZmk)
  .value("VFMSUBADD132PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZmkz)
  .value("VFMSUBADD132PHZr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZr)
  .value("VFMSUBADD132PHZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZrb)
  .value("VFMSUBADD132PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZrbk)
  .value("VFMSUBADD132PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZrbkz)
  .value("VFMSUBADD132PHZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZrk)
  .value("VFMSUBADD132PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PHZrkz)
  .value("VFMSUBADD132PSYm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSYm)
  .value("VFMSUBADD132PSYr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSYr)
  .value("VFMSUBADD132PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128m)
  .value("VFMSUBADD132PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128mb)
  .value("VFMSUBADD132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128mbk)
  .value("VFMSUBADD132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128mbkz)
  .value("VFMSUBADD132PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128mk)
  .value("VFMSUBADD132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128mkz);
  opcodes.value("VFMSUBADD132PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128r)
  .value("VFMSUBADD132PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128rk)
  .value("VFMSUBADD132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ128rkz)
  .value("VFMSUBADD132PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256m)
  .value("VFMSUBADD132PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256mb)
  .value("VFMSUBADD132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256mbk)
  .value("VFMSUBADD132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256mbkz)
  .value("VFMSUBADD132PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256mk)
  .value("VFMSUBADD132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256mkz)
  .value("VFMSUBADD132PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256r)
  .value("VFMSUBADD132PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256rk)
  .value("VFMSUBADD132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZ256rkz)
  .value("VFMSUBADD132PSZm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZm)
  .value("VFMSUBADD132PSZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZmb)
  .value("VFMSUBADD132PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZmbk)
  .value("VFMSUBADD132PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZmbkz)
  .value("VFMSUBADD132PSZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZmk)
  .value("VFMSUBADD132PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZmkz)
  .value("VFMSUBADD132PSZr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZr)
  .value("VFMSUBADD132PSZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZrb)
  .value("VFMSUBADD132PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZrbk)
  .value("VFMSUBADD132PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZrbkz)
  .value("VFMSUBADD132PSZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZrk)
  .value("VFMSUBADD132PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSZrkz)
  .value("VFMSUBADD132PSm", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSm)
  .value("VFMSUBADD132PSr", LIEF::assembly::x86::OPCODE::VFMSUBADD132PSr)
  .value("VFMSUBADD213PDYm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDYm)
  .value("VFMSUBADD213PDYr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDYr)
  .value("VFMSUBADD213PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128m)
  .value("VFMSUBADD213PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128mb)
  .value("VFMSUBADD213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128mbk)
  .value("VFMSUBADD213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128mbkz)
  .value("VFMSUBADD213PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128mk)
  .value("VFMSUBADD213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128mkz)
  .value("VFMSUBADD213PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128r)
  .value("VFMSUBADD213PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128rk)
  .value("VFMSUBADD213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ128rkz)
  .value("VFMSUBADD213PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256m)
  .value("VFMSUBADD213PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256mb)
  .value("VFMSUBADD213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256mbk)
  .value("VFMSUBADD213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256mbkz)
  .value("VFMSUBADD213PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256mk)
  .value("VFMSUBADD213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256mkz)
  .value("VFMSUBADD213PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256r)
  .value("VFMSUBADD213PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256rk)
  .value("VFMSUBADD213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZ256rkz)
  .value("VFMSUBADD213PDZm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZm)
  .value("VFMSUBADD213PDZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZmb)
  .value("VFMSUBADD213PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZmbk)
  .value("VFMSUBADD213PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZmbkz)
  .value("VFMSUBADD213PDZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZmk)
  .value("VFMSUBADD213PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZmkz)
  .value("VFMSUBADD213PDZr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZr)
  .value("VFMSUBADD213PDZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZrb)
  .value("VFMSUBADD213PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZrbk)
  .value("VFMSUBADD213PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZrbkz)
  .value("VFMSUBADD213PDZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZrk)
  .value("VFMSUBADD213PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDZrkz)
  .value("VFMSUBADD213PDm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDm)
  .value("VFMSUBADD213PDr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PDr)
  .value("VFMSUBADD213PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128m)
  .value("VFMSUBADD213PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128mb)
  .value("VFMSUBADD213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128mbk)
  .value("VFMSUBADD213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128mbkz)
  .value("VFMSUBADD213PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128mk)
  .value("VFMSUBADD213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128mkz)
  .value("VFMSUBADD213PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128r)
  .value("VFMSUBADD213PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128rk)
  .value("VFMSUBADD213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ128rkz)
  .value("VFMSUBADD213PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256m)
  .value("VFMSUBADD213PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256mb)
  .value("VFMSUBADD213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256mbk)
  .value("VFMSUBADD213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256mbkz)
  .value("VFMSUBADD213PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256mk)
  .value("VFMSUBADD213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256mkz)
  .value("VFMSUBADD213PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256r)
  .value("VFMSUBADD213PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256rk)
  .value("VFMSUBADD213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZ256rkz)
  .value("VFMSUBADD213PHZm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZm)
  .value("VFMSUBADD213PHZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZmb)
  .value("VFMSUBADD213PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZmbk)
  .value("VFMSUBADD213PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZmbkz)
  .value("VFMSUBADD213PHZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZmk)
  .value("VFMSUBADD213PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZmkz)
  .value("VFMSUBADD213PHZr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZr)
  .value("VFMSUBADD213PHZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZrb)
  .value("VFMSUBADD213PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZrbk)
  .value("VFMSUBADD213PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZrbkz)
  .value("VFMSUBADD213PHZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZrk)
  .value("VFMSUBADD213PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PHZrkz)
  .value("VFMSUBADD213PSYm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSYm)
  .value("VFMSUBADD213PSYr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSYr)
  .value("VFMSUBADD213PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128m)
  .value("VFMSUBADD213PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128mb)
  .value("VFMSUBADD213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128mbk)
  .value("VFMSUBADD213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128mbkz)
  .value("VFMSUBADD213PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128mk)
  .value("VFMSUBADD213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128mkz)
  .value("VFMSUBADD213PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128r)
  .value("VFMSUBADD213PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128rk)
  .value("VFMSUBADD213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ128rkz)
  .value("VFMSUBADD213PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256m)
  .value("VFMSUBADD213PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256mb)
  .value("VFMSUBADD213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256mbk)
  .value("VFMSUBADD213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256mbkz)
  .value("VFMSUBADD213PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256mk)
  .value("VFMSUBADD213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256mkz)
  .value("VFMSUBADD213PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256r)
  .value("VFMSUBADD213PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256rk)
  .value("VFMSUBADD213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZ256rkz)
  .value("VFMSUBADD213PSZm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZm)
  .value("VFMSUBADD213PSZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZmb)
  .value("VFMSUBADD213PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZmbk)
  .value("VFMSUBADD213PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZmbkz)
  .value("VFMSUBADD213PSZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZmk)
  .value("VFMSUBADD213PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZmkz)
  .value("VFMSUBADD213PSZr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZr)
  .value("VFMSUBADD213PSZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZrb)
  .value("VFMSUBADD213PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZrbk)
  .value("VFMSUBADD213PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZrbkz)
  .value("VFMSUBADD213PSZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZrk)
  .value("VFMSUBADD213PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSZrkz)
  .value("VFMSUBADD213PSm", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSm)
  .value("VFMSUBADD213PSr", LIEF::assembly::x86::OPCODE::VFMSUBADD213PSr)
  .value("VFMSUBADD231PDYm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDYm)
  .value("VFMSUBADD231PDYr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDYr)
  .value("VFMSUBADD231PDZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128m)
  .value("VFMSUBADD231PDZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128mb)
  .value("VFMSUBADD231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128mbk)
  .value("VFMSUBADD231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128mbkz)
  .value("VFMSUBADD231PDZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128mk)
  .value("VFMSUBADD231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128mkz)
  .value("VFMSUBADD231PDZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128r)
  .value("VFMSUBADD231PDZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128rk)
  .value("VFMSUBADD231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ128rkz)
  .value("VFMSUBADD231PDZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256m)
  .value("VFMSUBADD231PDZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256mb)
  .value("VFMSUBADD231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256mbk)
  .value("VFMSUBADD231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256mbkz)
  .value("VFMSUBADD231PDZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256mk)
  .value("VFMSUBADD231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256mkz)
  .value("VFMSUBADD231PDZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256r)
  .value("VFMSUBADD231PDZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256rk)
  .value("VFMSUBADD231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZ256rkz)
  .value("VFMSUBADD231PDZm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZm)
  .value("VFMSUBADD231PDZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZmb)
  .value("VFMSUBADD231PDZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZmbk)
  .value("VFMSUBADD231PDZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZmbkz)
  .value("VFMSUBADD231PDZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZmk)
  .value("VFMSUBADD231PDZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZmkz)
  .value("VFMSUBADD231PDZr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZr)
  .value("VFMSUBADD231PDZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZrb)
  .value("VFMSUBADD231PDZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZrbk)
  .value("VFMSUBADD231PDZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZrbkz)
  .value("VFMSUBADD231PDZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZrk)
  .value("VFMSUBADD231PDZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDZrkz)
  .value("VFMSUBADD231PDm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDm)
  .value("VFMSUBADD231PDr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PDr)
  .value("VFMSUBADD231PHZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128m)
  .value("VFMSUBADD231PHZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128mb)
  .value("VFMSUBADD231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128mbk)
  .value("VFMSUBADD231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128mbkz)
  .value("VFMSUBADD231PHZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128mk)
  .value("VFMSUBADD231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128mkz)
  .value("VFMSUBADD231PHZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128r)
  .value("VFMSUBADD231PHZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128rk)
  .value("VFMSUBADD231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ128rkz)
  .value("VFMSUBADD231PHZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256m)
  .value("VFMSUBADD231PHZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256mb)
  .value("VFMSUBADD231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256mbk)
  .value("VFMSUBADD231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256mbkz)
  .value("VFMSUBADD231PHZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256mk)
  .value("VFMSUBADD231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256mkz)
  .value("VFMSUBADD231PHZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256r)
  .value("VFMSUBADD231PHZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256rk)
  .value("VFMSUBADD231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZ256rkz)
  .value("VFMSUBADD231PHZm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZm)
  .value("VFMSUBADD231PHZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZmb)
  .value("VFMSUBADD231PHZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZmbk)
  .value("VFMSUBADD231PHZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZmbkz)
  .value("VFMSUBADD231PHZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZmk)
  .value("VFMSUBADD231PHZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZmkz)
  .value("VFMSUBADD231PHZr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZr)
  .value("VFMSUBADD231PHZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZrb)
  .value("VFMSUBADD231PHZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZrbk)
  .value("VFMSUBADD231PHZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZrbkz)
  .value("VFMSUBADD231PHZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZrk)
  .value("VFMSUBADD231PHZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PHZrkz)
  .value("VFMSUBADD231PSYm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSYm)
  .value("VFMSUBADD231PSYr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSYr)
  .value("VFMSUBADD231PSZ128m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128m)
  .value("VFMSUBADD231PSZ128mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128mb)
  .value("VFMSUBADD231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128mbk)
  .value("VFMSUBADD231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128mbkz)
  .value("VFMSUBADD231PSZ128mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128mk)
  .value("VFMSUBADD231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128mkz)
  .value("VFMSUBADD231PSZ128r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128r)
  .value("VFMSUBADD231PSZ128rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128rk)
  .value("VFMSUBADD231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ128rkz)
  .value("VFMSUBADD231PSZ256m", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256m)
  .value("VFMSUBADD231PSZ256mb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256mb)
  .value("VFMSUBADD231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256mbk)
  .value("VFMSUBADD231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256mbkz)
  .value("VFMSUBADD231PSZ256mk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256mk)
  .value("VFMSUBADD231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256mkz)
  .value("VFMSUBADD231PSZ256r", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256r)
  .value("VFMSUBADD231PSZ256rk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256rk)
  .value("VFMSUBADD231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZ256rkz)
  .value("VFMSUBADD231PSZm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZm)
  .value("VFMSUBADD231PSZmb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZmb)
  .value("VFMSUBADD231PSZmbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZmbk)
  .value("VFMSUBADD231PSZmbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZmbkz)
  .value("VFMSUBADD231PSZmk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZmk)
  .value("VFMSUBADD231PSZmkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZmkz)
  .value("VFMSUBADD231PSZr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZr)
  .value("VFMSUBADD231PSZrb", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZrb)
  .value("VFMSUBADD231PSZrbk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZrbk)
  .value("VFMSUBADD231PSZrbkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZrbkz)
  .value("VFMSUBADD231PSZrk", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZrk)
  .value("VFMSUBADD231PSZrkz", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSZrkz)
  .value("VFMSUBADD231PSm", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSm)
  .value("VFMSUBADD231PSr", LIEF::assembly::x86::OPCODE::VFMSUBADD231PSr)
  .value("VFMSUBADDPD4Ymr", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4Ymr)
  .value("VFMSUBADDPD4Yrm", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4Yrm)
  .value("VFMSUBADDPD4Yrr", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4Yrr)
  .value("VFMSUBADDPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4Yrr_REV)
  .value("VFMSUBADDPD4mr", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4mr)
  .value("VFMSUBADDPD4rm", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4rm)
  .value("VFMSUBADDPD4rr", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4rr)
  .value("VFMSUBADDPD4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBADDPD4rr_REV)
  .value("VFMSUBADDPS4Ymr", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4Ymr)
  .value("VFMSUBADDPS4Yrm", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4Yrm)
  .value("VFMSUBADDPS4Yrr", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4Yrr)
  .value("VFMSUBADDPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4Yrr_REV)
  .value("VFMSUBADDPS4mr", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4mr)
  .value("VFMSUBADDPS4rm", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4rm)
  .value("VFMSUBADDPS4rr", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4rr)
  .value("VFMSUBADDPS4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBADDPS4rr_REV)
  .value("VFMSUBPD4Ymr", LIEF::assembly::x86::OPCODE::VFMSUBPD4Ymr)
  .value("VFMSUBPD4Yrm", LIEF::assembly::x86::OPCODE::VFMSUBPD4Yrm)
  .value("VFMSUBPD4Yrr", LIEF::assembly::x86::OPCODE::VFMSUBPD4Yrr)
  .value("VFMSUBPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMSUBPD4Yrr_REV)
  .value("VFMSUBPD4mr", LIEF::assembly::x86::OPCODE::VFMSUBPD4mr)
  .value("VFMSUBPD4rm", LIEF::assembly::x86::OPCODE::VFMSUBPD4rm)
  .value("VFMSUBPD4rr", LIEF::assembly::x86::OPCODE::VFMSUBPD4rr)
  .value("VFMSUBPD4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBPD4rr_REV)
  .value("VFMSUBPS4Ymr", LIEF::assembly::x86::OPCODE::VFMSUBPS4Ymr)
  .value("VFMSUBPS4Yrm", LIEF::assembly::x86::OPCODE::VFMSUBPS4Yrm)
  .value("VFMSUBPS4Yrr", LIEF::assembly::x86::OPCODE::VFMSUBPS4Yrr)
  .value("VFMSUBPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFMSUBPS4Yrr_REV)
  .value("VFMSUBPS4mr", LIEF::assembly::x86::OPCODE::VFMSUBPS4mr)
  .value("VFMSUBPS4rm", LIEF::assembly::x86::OPCODE::VFMSUBPS4rm)
  .value("VFMSUBPS4rr", LIEF::assembly::x86::OPCODE::VFMSUBPS4rr)
  .value("VFMSUBPS4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBPS4rr_REV)
  .value("VFMSUBSD4mr", LIEF::assembly::x86::OPCODE::VFMSUBSD4mr)
  .value("VFMSUBSD4mr_Int", LIEF::assembly::x86::OPCODE::VFMSUBSD4mr_Int)
  .value("VFMSUBSD4rm", LIEF::assembly::x86::OPCODE::VFMSUBSD4rm)
  .value("VFMSUBSD4rm_Int", LIEF::assembly::x86::OPCODE::VFMSUBSD4rm_Int)
  .value("VFMSUBSD4rr", LIEF::assembly::x86::OPCODE::VFMSUBSD4rr)
  .value("VFMSUBSD4rr_Int", LIEF::assembly::x86::OPCODE::VFMSUBSD4rr_Int)
  .value("VFMSUBSD4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFMSUBSD4rr_Int_REV)
  .value("VFMSUBSD4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBSD4rr_REV)
  .value("VFMSUBSS4mr", LIEF::assembly::x86::OPCODE::VFMSUBSS4mr)
  .value("VFMSUBSS4mr_Int", LIEF::assembly::x86::OPCODE::VFMSUBSS4mr_Int)
  .value("VFMSUBSS4rm", LIEF::assembly::x86::OPCODE::VFMSUBSS4rm)
  .value("VFMSUBSS4rm_Int", LIEF::assembly::x86::OPCODE::VFMSUBSS4rm_Int)
  .value("VFMSUBSS4rr", LIEF::assembly::x86::OPCODE::VFMSUBSS4rr)
  .value("VFMSUBSS4rr_Int", LIEF::assembly::x86::OPCODE::VFMSUBSS4rr_Int)
  .value("VFMSUBSS4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFMSUBSS4rr_Int_REV)
  .value("VFMSUBSS4rr_REV", LIEF::assembly::x86::OPCODE::VFMSUBSS4rr_REV)
  .value("VFMULCPHZ128rm", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rm)
  .value("VFMULCPHZ128rmb", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rmb)
  .value("VFMULCPHZ128rmbk", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rmbk)
  .value("VFMULCPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rmbkz)
  .value("VFMULCPHZ128rmk", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rmk)
  .value("VFMULCPHZ128rmkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rmkz)
  .value("VFMULCPHZ128rr", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rr)
  .value("VFMULCPHZ128rrk", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rrk)
  .value("VFMULCPHZ128rrkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ128rrkz)
  .value("VFMULCPHZ256rm", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rm)
  .value("VFMULCPHZ256rmb", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rmb)
  .value("VFMULCPHZ256rmbk", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rmbk)
  .value("VFMULCPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rmbkz)
  .value("VFMULCPHZ256rmk", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rmk)
  .value("VFMULCPHZ256rmkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rmkz)
  .value("VFMULCPHZ256rr", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rr)
  .value("VFMULCPHZ256rrk", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rrk)
  .value("VFMULCPHZ256rrkz", LIEF::assembly::x86::OPCODE::VFMULCPHZ256rrkz)
  .value("VFMULCPHZrm", LIEF::assembly::x86::OPCODE::VFMULCPHZrm)
  .value("VFMULCPHZrmb", LIEF::assembly::x86::OPCODE::VFMULCPHZrmb)
  .value("VFMULCPHZrmbk", LIEF::assembly::x86::OPCODE::VFMULCPHZrmbk)
  .value("VFMULCPHZrmbkz", LIEF::assembly::x86::OPCODE::VFMULCPHZrmbkz)
  .value("VFMULCPHZrmk", LIEF::assembly::x86::OPCODE::VFMULCPHZrmk)
  .value("VFMULCPHZrmkz", LIEF::assembly::x86::OPCODE::VFMULCPHZrmkz)
  .value("VFMULCPHZrr", LIEF::assembly::x86::OPCODE::VFMULCPHZrr)
  .value("VFMULCPHZrrb", LIEF::assembly::x86::OPCODE::VFMULCPHZrrb)
  .value("VFMULCPHZrrbk", LIEF::assembly::x86::OPCODE::VFMULCPHZrrbk)
  .value("VFMULCPHZrrbkz", LIEF::assembly::x86::OPCODE::VFMULCPHZrrbkz)
  .value("VFMULCPHZrrk", LIEF::assembly::x86::OPCODE::VFMULCPHZrrk)
  .value("VFMULCPHZrrkz", LIEF::assembly::x86::OPCODE::VFMULCPHZrrkz);
  opcodes.value("VFMULCSHZrm", LIEF::assembly::x86::OPCODE::VFMULCSHZrm)
  .value("VFMULCSHZrmk", LIEF::assembly::x86::OPCODE::VFMULCSHZrmk)
  .value("VFMULCSHZrmkz", LIEF::assembly::x86::OPCODE::VFMULCSHZrmkz)
  .value("VFMULCSHZrr", LIEF::assembly::x86::OPCODE::VFMULCSHZrr)
  .value("VFMULCSHZrrb", LIEF::assembly::x86::OPCODE::VFMULCSHZrrb)
  .value("VFMULCSHZrrbk", LIEF::assembly::x86::OPCODE::VFMULCSHZrrbk)
  .value("VFMULCSHZrrbkz", LIEF::assembly::x86::OPCODE::VFMULCSHZrrbkz)
  .value("VFMULCSHZrrk", LIEF::assembly::x86::OPCODE::VFMULCSHZrrk)
  .value("VFMULCSHZrrkz", LIEF::assembly::x86::OPCODE::VFMULCSHZrrkz)
  .value("VFNMADD132BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128m)
  .value("VFNMADD132BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128mb)
  .value("VFNMADD132BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128mbk)
  .value("VFNMADD132BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128mbkz)
  .value("VFNMADD132BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128mk)
  .value("VFNMADD132BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128mkz)
  .value("VFNMADD132BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128r)
  .value("VFNMADD132BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128rk)
  .value("VFNMADD132BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z128rkz)
  .value("VFNMADD132BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256m)
  .value("VFNMADD132BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256mb)
  .value("VFNMADD132BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256mbk)
  .value("VFNMADD132BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256mbkz)
  .value("VFNMADD132BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256mk)
  .value("VFNMADD132BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256mkz)
  .value("VFNMADD132BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256r)
  .value("VFNMADD132BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256rk)
  .value("VFNMADD132BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Z256rkz)
  .value("VFNMADD132BF16Zm", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zm)
  .value("VFNMADD132BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zmb)
  .value("VFNMADD132BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zmbk)
  .value("VFNMADD132BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zmbkz)
  .value("VFNMADD132BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zmk)
  .value("VFNMADD132BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zmkz)
  .value("VFNMADD132BF16Zr", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zr)
  .value("VFNMADD132BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zrk)
  .value("VFNMADD132BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMADD132BF16Zrkz)
  .value("VFNMADD132PDYm", LIEF::assembly::x86::OPCODE::VFNMADD132PDYm)
  .value("VFNMADD132PDYr", LIEF::assembly::x86::OPCODE::VFNMADD132PDYr)
  .value("VFNMADD132PDZ128m", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128m)
  .value("VFNMADD132PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128mb)
  .value("VFNMADD132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128mbk)
  .value("VFNMADD132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128mbkz)
  .value("VFNMADD132PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128mk)
  .value("VFNMADD132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128mkz)
  .value("VFNMADD132PDZ128r", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128r)
  .value("VFNMADD132PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128rk)
  .value("VFNMADD132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ128rkz)
  .value("VFNMADD132PDZ256m", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256m)
  .value("VFNMADD132PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256mb)
  .value("VFNMADD132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256mbk)
  .value("VFNMADD132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256mbkz)
  .value("VFNMADD132PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256mk)
  .value("VFNMADD132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256mkz)
  .value("VFNMADD132PDZ256r", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256r)
  .value("VFNMADD132PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256rk)
  .value("VFNMADD132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZ256rkz)
  .value("VFNMADD132PDZm", LIEF::assembly::x86::OPCODE::VFNMADD132PDZm)
  .value("VFNMADD132PDZmb", LIEF::assembly::x86::OPCODE::VFNMADD132PDZmb)
  .value("VFNMADD132PDZmbk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZmbk)
  .value("VFNMADD132PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZmbkz)
  .value("VFNMADD132PDZmk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZmk)
  .value("VFNMADD132PDZmkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZmkz)
  .value("VFNMADD132PDZr", LIEF::assembly::x86::OPCODE::VFNMADD132PDZr)
  .value("VFNMADD132PDZrb", LIEF::assembly::x86::OPCODE::VFNMADD132PDZrb)
  .value("VFNMADD132PDZrbk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZrbk)
  .value("VFNMADD132PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZrbkz)
  .value("VFNMADD132PDZrk", LIEF::assembly::x86::OPCODE::VFNMADD132PDZrk)
  .value("VFNMADD132PDZrkz", LIEF::assembly::x86::OPCODE::VFNMADD132PDZrkz)
  .value("VFNMADD132PDm", LIEF::assembly::x86::OPCODE::VFNMADD132PDm)
  .value("VFNMADD132PDr", LIEF::assembly::x86::OPCODE::VFNMADD132PDr)
  .value("VFNMADD132PHZ128m", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128m)
  .value("VFNMADD132PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128mb)
  .value("VFNMADD132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128mbk)
  .value("VFNMADD132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128mbkz)
  .value("VFNMADD132PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128mk)
  .value("VFNMADD132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128mkz)
  .value("VFNMADD132PHZ128r", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128r)
  .value("VFNMADD132PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128rk)
  .value("VFNMADD132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ128rkz)
  .value("VFNMADD132PHZ256m", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256m)
  .value("VFNMADD132PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256mb)
  .value("VFNMADD132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256mbk)
  .value("VFNMADD132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256mbkz)
  .value("VFNMADD132PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256mk)
  .value("VFNMADD132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256mkz)
  .value("VFNMADD132PHZ256r", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256r)
  .value("VFNMADD132PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256rk)
  .value("VFNMADD132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZ256rkz)
  .value("VFNMADD132PHZm", LIEF::assembly::x86::OPCODE::VFNMADD132PHZm)
  .value("VFNMADD132PHZmb", LIEF::assembly::x86::OPCODE::VFNMADD132PHZmb)
  .value("VFNMADD132PHZmbk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZmbk)
  .value("VFNMADD132PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZmbkz)
  .value("VFNMADD132PHZmk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZmk)
  .value("VFNMADD132PHZmkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZmkz)
  .value("VFNMADD132PHZr", LIEF::assembly::x86::OPCODE::VFNMADD132PHZr)
  .value("VFNMADD132PHZrb", LIEF::assembly::x86::OPCODE::VFNMADD132PHZrb)
  .value("VFNMADD132PHZrbk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZrbk)
  .value("VFNMADD132PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZrbkz)
  .value("VFNMADD132PHZrk", LIEF::assembly::x86::OPCODE::VFNMADD132PHZrk)
  .value("VFNMADD132PHZrkz", LIEF::assembly::x86::OPCODE::VFNMADD132PHZrkz)
  .value("VFNMADD132PSYm", LIEF::assembly::x86::OPCODE::VFNMADD132PSYm)
  .value("VFNMADD132PSYr", LIEF::assembly::x86::OPCODE::VFNMADD132PSYr)
  .value("VFNMADD132PSZ128m", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128m)
  .value("VFNMADD132PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128mb)
  .value("VFNMADD132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128mbk)
  .value("VFNMADD132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128mbkz)
  .value("VFNMADD132PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128mk)
  .value("VFNMADD132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128mkz)
  .value("VFNMADD132PSZ128r", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128r)
  .value("VFNMADD132PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128rk)
  .value("VFNMADD132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ128rkz)
  .value("VFNMADD132PSZ256m", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256m)
  .value("VFNMADD132PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256mb)
  .value("VFNMADD132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256mbk)
  .value("VFNMADD132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256mbkz)
  .value("VFNMADD132PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256mk)
  .value("VFNMADD132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256mkz)
  .value("VFNMADD132PSZ256r", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256r)
  .value("VFNMADD132PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256rk)
  .value("VFNMADD132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZ256rkz)
  .value("VFNMADD132PSZm", LIEF::assembly::x86::OPCODE::VFNMADD132PSZm)
  .value("VFNMADD132PSZmb", LIEF::assembly::x86::OPCODE::VFNMADD132PSZmb)
  .value("VFNMADD132PSZmbk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZmbk)
  .value("VFNMADD132PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZmbkz)
  .value("VFNMADD132PSZmk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZmk)
  .value("VFNMADD132PSZmkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZmkz)
  .value("VFNMADD132PSZr", LIEF::assembly::x86::OPCODE::VFNMADD132PSZr)
  .value("VFNMADD132PSZrb", LIEF::assembly::x86::OPCODE::VFNMADD132PSZrb)
  .value("VFNMADD132PSZrbk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZrbk)
  .value("VFNMADD132PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZrbkz)
  .value("VFNMADD132PSZrk", LIEF::assembly::x86::OPCODE::VFNMADD132PSZrk)
  .value("VFNMADD132PSZrkz", LIEF::assembly::x86::OPCODE::VFNMADD132PSZrkz)
  .value("VFNMADD132PSm", LIEF::assembly::x86::OPCODE::VFNMADD132PSm)
  .value("VFNMADD132PSr", LIEF::assembly::x86::OPCODE::VFNMADD132PSr)
  .value("VFNMADD132SDZm", LIEF::assembly::x86::OPCODE::VFNMADD132SDZm)
  .value("VFNMADD132SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZm_Int)
  .value("VFNMADD132SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZmk_Int)
  .value("VFNMADD132SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZmkz_Int)
  .value("VFNMADD132SDZr", LIEF::assembly::x86::OPCODE::VFNMADD132SDZr)
  .value("VFNMADD132SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZr_Int)
  .value("VFNMADD132SDZrb", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrb)
  .value("VFNMADD132SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrb_Int)
  .value("VFNMADD132SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrbk_Int)
  .value("VFNMADD132SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrbkz_Int)
  .value("VFNMADD132SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrk_Int)
  .value("VFNMADD132SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDZrkz_Int)
  .value("VFNMADD132SDm", LIEF::assembly::x86::OPCODE::VFNMADD132SDm)
  .value("VFNMADD132SDm_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDm_Int)
  .value("VFNMADD132SDr", LIEF::assembly::x86::OPCODE::VFNMADD132SDr)
  .value("VFNMADD132SDr_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SDr_Int)
  .value("VFNMADD132SHZm", LIEF::assembly::x86::OPCODE::VFNMADD132SHZm)
  .value("VFNMADD132SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZm_Int)
  .value("VFNMADD132SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZmk_Int)
  .value("VFNMADD132SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZmkz_Int)
  .value("VFNMADD132SHZr", LIEF::assembly::x86::OPCODE::VFNMADD132SHZr)
  .value("VFNMADD132SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZr_Int)
  .value("VFNMADD132SHZrb", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrb)
  .value("VFNMADD132SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrb_Int)
  .value("VFNMADD132SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrbk_Int)
  .value("VFNMADD132SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrbkz_Int)
  .value("VFNMADD132SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrk_Int)
  .value("VFNMADD132SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SHZrkz_Int)
  .value("VFNMADD132SSZm", LIEF::assembly::x86::OPCODE::VFNMADD132SSZm)
  .value("VFNMADD132SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZm_Int)
  .value("VFNMADD132SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZmk_Int)
  .value("VFNMADD132SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZmkz_Int)
  .value("VFNMADD132SSZr", LIEF::assembly::x86::OPCODE::VFNMADD132SSZr)
  .value("VFNMADD132SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZr_Int)
  .value("VFNMADD132SSZrb", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrb)
  .value("VFNMADD132SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrb_Int)
  .value("VFNMADD132SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrbk_Int)
  .value("VFNMADD132SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrbkz_Int)
  .value("VFNMADD132SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrk_Int)
  .value("VFNMADD132SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSZrkz_Int)
  .value("VFNMADD132SSm", LIEF::assembly::x86::OPCODE::VFNMADD132SSm)
  .value("VFNMADD132SSm_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSm_Int)
  .value("VFNMADD132SSr", LIEF::assembly::x86::OPCODE::VFNMADD132SSr)
  .value("VFNMADD132SSr_Int", LIEF::assembly::x86::OPCODE::VFNMADD132SSr_Int)
  .value("VFNMADD213BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128m)
  .value("VFNMADD213BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128mb)
  .value("VFNMADD213BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128mbk)
  .value("VFNMADD213BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128mbkz)
  .value("VFNMADD213BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128mk)
  .value("VFNMADD213BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128mkz)
  .value("VFNMADD213BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128r)
  .value("VFNMADD213BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128rk)
  .value("VFNMADD213BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z128rkz)
  .value("VFNMADD213BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256m)
  .value("VFNMADD213BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256mb)
  .value("VFNMADD213BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256mbk)
  .value("VFNMADD213BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256mbkz)
  .value("VFNMADD213BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256mk)
  .value("VFNMADD213BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256mkz)
  .value("VFNMADD213BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256r)
  .value("VFNMADD213BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256rk)
  .value("VFNMADD213BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Z256rkz)
  .value("VFNMADD213BF16Zm", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zm)
  .value("VFNMADD213BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zmb)
  .value("VFNMADD213BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zmbk)
  .value("VFNMADD213BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zmbkz)
  .value("VFNMADD213BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zmk)
  .value("VFNMADD213BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zmkz)
  .value("VFNMADD213BF16Zr", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zr)
  .value("VFNMADD213BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zrk)
  .value("VFNMADD213BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMADD213BF16Zrkz)
  .value("VFNMADD213PDYm", LIEF::assembly::x86::OPCODE::VFNMADD213PDYm)
  .value("VFNMADD213PDYr", LIEF::assembly::x86::OPCODE::VFNMADD213PDYr)
  .value("VFNMADD213PDZ128m", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128m)
  .value("VFNMADD213PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128mb)
  .value("VFNMADD213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128mbk)
  .value("VFNMADD213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128mbkz)
  .value("VFNMADD213PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128mk)
  .value("VFNMADD213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128mkz)
  .value("VFNMADD213PDZ128r", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128r)
  .value("VFNMADD213PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128rk)
  .value("VFNMADD213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ128rkz)
  .value("VFNMADD213PDZ256m", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256m)
  .value("VFNMADD213PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256mb)
  .value("VFNMADD213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256mbk)
  .value("VFNMADD213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256mbkz)
  .value("VFNMADD213PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256mk)
  .value("VFNMADD213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256mkz)
  .value("VFNMADD213PDZ256r", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256r)
  .value("VFNMADD213PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256rk)
  .value("VFNMADD213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZ256rkz)
  .value("VFNMADD213PDZm", LIEF::assembly::x86::OPCODE::VFNMADD213PDZm)
  .value("VFNMADD213PDZmb", LIEF::assembly::x86::OPCODE::VFNMADD213PDZmb)
  .value("VFNMADD213PDZmbk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZmbk)
  .value("VFNMADD213PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZmbkz)
  .value("VFNMADD213PDZmk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZmk)
  .value("VFNMADD213PDZmkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZmkz)
  .value("VFNMADD213PDZr", LIEF::assembly::x86::OPCODE::VFNMADD213PDZr)
  .value("VFNMADD213PDZrb", LIEF::assembly::x86::OPCODE::VFNMADD213PDZrb)
  .value("VFNMADD213PDZrbk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZrbk)
  .value("VFNMADD213PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZrbkz)
  .value("VFNMADD213PDZrk", LIEF::assembly::x86::OPCODE::VFNMADD213PDZrk)
  .value("VFNMADD213PDZrkz", LIEF::assembly::x86::OPCODE::VFNMADD213PDZrkz)
  .value("VFNMADD213PDm", LIEF::assembly::x86::OPCODE::VFNMADD213PDm)
  .value("VFNMADD213PDr", LIEF::assembly::x86::OPCODE::VFNMADD213PDr)
  .value("VFNMADD213PHZ128m", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128m)
  .value("VFNMADD213PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128mb)
  .value("VFNMADD213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128mbk)
  .value("VFNMADD213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128mbkz)
  .value("VFNMADD213PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128mk)
  .value("VFNMADD213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128mkz)
  .value("VFNMADD213PHZ128r", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128r)
  .value("VFNMADD213PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128rk)
  .value("VFNMADD213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ128rkz)
  .value("VFNMADD213PHZ256m", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256m)
  .value("VFNMADD213PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256mb)
  .value("VFNMADD213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256mbk)
  .value("VFNMADD213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256mbkz)
  .value("VFNMADD213PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256mk)
  .value("VFNMADD213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256mkz)
  .value("VFNMADD213PHZ256r", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256r)
  .value("VFNMADD213PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256rk)
  .value("VFNMADD213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZ256rkz)
  .value("VFNMADD213PHZm", LIEF::assembly::x86::OPCODE::VFNMADD213PHZm)
  .value("VFNMADD213PHZmb", LIEF::assembly::x86::OPCODE::VFNMADD213PHZmb)
  .value("VFNMADD213PHZmbk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZmbk)
  .value("VFNMADD213PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZmbkz)
  .value("VFNMADD213PHZmk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZmk)
  .value("VFNMADD213PHZmkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZmkz)
  .value("VFNMADD213PHZr", LIEF::assembly::x86::OPCODE::VFNMADD213PHZr)
  .value("VFNMADD213PHZrb", LIEF::assembly::x86::OPCODE::VFNMADD213PHZrb)
  .value("VFNMADD213PHZrbk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZrbk)
  .value("VFNMADD213PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZrbkz)
  .value("VFNMADD213PHZrk", LIEF::assembly::x86::OPCODE::VFNMADD213PHZrk)
  .value("VFNMADD213PHZrkz", LIEF::assembly::x86::OPCODE::VFNMADD213PHZrkz)
  .value("VFNMADD213PSYm", LIEF::assembly::x86::OPCODE::VFNMADD213PSYm)
  .value("VFNMADD213PSYr", LIEF::assembly::x86::OPCODE::VFNMADD213PSYr)
  .value("VFNMADD213PSZ128m", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128m)
  .value("VFNMADD213PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128mb)
  .value("VFNMADD213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128mbk)
  .value("VFNMADD213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128mbkz)
  .value("VFNMADD213PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128mk)
  .value("VFNMADD213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128mkz)
  .value("VFNMADD213PSZ128r", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128r)
  .value("VFNMADD213PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128rk)
  .value("VFNMADD213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ128rkz)
  .value("VFNMADD213PSZ256m", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256m)
  .value("VFNMADD213PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256mb)
  .value("VFNMADD213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256mbk)
  .value("VFNMADD213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256mbkz)
  .value("VFNMADD213PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256mk)
  .value("VFNMADD213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256mkz)
  .value("VFNMADD213PSZ256r", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256r)
  .value("VFNMADD213PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256rk)
  .value("VFNMADD213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZ256rkz)
  .value("VFNMADD213PSZm", LIEF::assembly::x86::OPCODE::VFNMADD213PSZm)
  .value("VFNMADD213PSZmb", LIEF::assembly::x86::OPCODE::VFNMADD213PSZmb)
  .value("VFNMADD213PSZmbk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZmbk)
  .value("VFNMADD213PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZmbkz)
  .value("VFNMADD213PSZmk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZmk)
  .value("VFNMADD213PSZmkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZmkz)
  .value("VFNMADD213PSZr", LIEF::assembly::x86::OPCODE::VFNMADD213PSZr)
  .value("VFNMADD213PSZrb", LIEF::assembly::x86::OPCODE::VFNMADD213PSZrb)
  .value("VFNMADD213PSZrbk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZrbk)
  .value("VFNMADD213PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZrbkz)
  .value("VFNMADD213PSZrk", LIEF::assembly::x86::OPCODE::VFNMADD213PSZrk);
  opcodes.value("VFNMADD213PSZrkz", LIEF::assembly::x86::OPCODE::VFNMADD213PSZrkz)
  .value("VFNMADD213PSm", LIEF::assembly::x86::OPCODE::VFNMADD213PSm)
  .value("VFNMADD213PSr", LIEF::assembly::x86::OPCODE::VFNMADD213PSr)
  .value("VFNMADD213SDZm", LIEF::assembly::x86::OPCODE::VFNMADD213SDZm)
  .value("VFNMADD213SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZm_Int)
  .value("VFNMADD213SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZmk_Int)
  .value("VFNMADD213SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZmkz_Int)
  .value("VFNMADD213SDZr", LIEF::assembly::x86::OPCODE::VFNMADD213SDZr)
  .value("VFNMADD213SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZr_Int)
  .value("VFNMADD213SDZrb", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrb)
  .value("VFNMADD213SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrb_Int)
  .value("VFNMADD213SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrbk_Int)
  .value("VFNMADD213SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrbkz_Int)
  .value("VFNMADD213SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrk_Int)
  .value("VFNMADD213SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDZrkz_Int)
  .value("VFNMADD213SDm", LIEF::assembly::x86::OPCODE::VFNMADD213SDm)
  .value("VFNMADD213SDm_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDm_Int)
  .value("VFNMADD213SDr", LIEF::assembly::x86::OPCODE::VFNMADD213SDr)
  .value("VFNMADD213SDr_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SDr_Int)
  .value("VFNMADD213SHZm", LIEF::assembly::x86::OPCODE::VFNMADD213SHZm)
  .value("VFNMADD213SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZm_Int)
  .value("VFNMADD213SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZmk_Int)
  .value("VFNMADD213SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZmkz_Int)
  .value("VFNMADD213SHZr", LIEF::assembly::x86::OPCODE::VFNMADD213SHZr)
  .value("VFNMADD213SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZr_Int)
  .value("VFNMADD213SHZrb", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrb)
  .value("VFNMADD213SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrb_Int)
  .value("VFNMADD213SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrbk_Int)
  .value("VFNMADD213SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrbkz_Int)
  .value("VFNMADD213SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrk_Int)
  .value("VFNMADD213SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SHZrkz_Int)
  .value("VFNMADD213SSZm", LIEF::assembly::x86::OPCODE::VFNMADD213SSZm)
  .value("VFNMADD213SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZm_Int)
  .value("VFNMADD213SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZmk_Int)
  .value("VFNMADD213SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZmkz_Int)
  .value("VFNMADD213SSZr", LIEF::assembly::x86::OPCODE::VFNMADD213SSZr)
  .value("VFNMADD213SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZr_Int)
  .value("VFNMADD213SSZrb", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrb)
  .value("VFNMADD213SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrb_Int)
  .value("VFNMADD213SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrbk_Int)
  .value("VFNMADD213SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrbkz_Int)
  .value("VFNMADD213SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrk_Int)
  .value("VFNMADD213SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSZrkz_Int)
  .value("VFNMADD213SSm", LIEF::assembly::x86::OPCODE::VFNMADD213SSm)
  .value("VFNMADD213SSm_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSm_Int)
  .value("VFNMADD213SSr", LIEF::assembly::x86::OPCODE::VFNMADD213SSr)
  .value("VFNMADD213SSr_Int", LIEF::assembly::x86::OPCODE::VFNMADD213SSr_Int)
  .value("VFNMADD231BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128m)
  .value("VFNMADD231BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128mb)
  .value("VFNMADD231BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128mbk)
  .value("VFNMADD231BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128mbkz)
  .value("VFNMADD231BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128mk)
  .value("VFNMADD231BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128mkz)
  .value("VFNMADD231BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128r)
  .value("VFNMADD231BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128rk)
  .value("VFNMADD231BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z128rkz)
  .value("VFNMADD231BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256m)
  .value("VFNMADD231BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256mb)
  .value("VFNMADD231BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256mbk)
  .value("VFNMADD231BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256mbkz)
  .value("VFNMADD231BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256mk)
  .value("VFNMADD231BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256mkz)
  .value("VFNMADD231BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256r)
  .value("VFNMADD231BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256rk)
  .value("VFNMADD231BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Z256rkz)
  .value("VFNMADD231BF16Zm", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zm)
  .value("VFNMADD231BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zmb)
  .value("VFNMADD231BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zmbk)
  .value("VFNMADD231BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zmbkz)
  .value("VFNMADD231BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zmk)
  .value("VFNMADD231BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zmkz)
  .value("VFNMADD231BF16Zr", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zr)
  .value("VFNMADD231BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zrk)
  .value("VFNMADD231BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMADD231BF16Zrkz)
  .value("VFNMADD231PDYm", LIEF::assembly::x86::OPCODE::VFNMADD231PDYm)
  .value("VFNMADD231PDYr", LIEF::assembly::x86::OPCODE::VFNMADD231PDYr)
  .value("VFNMADD231PDZ128m", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128m)
  .value("VFNMADD231PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128mb)
  .value("VFNMADD231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128mbk)
  .value("VFNMADD231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128mbkz)
  .value("VFNMADD231PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128mk)
  .value("VFNMADD231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128mkz)
  .value("VFNMADD231PDZ128r", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128r)
  .value("VFNMADD231PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128rk)
  .value("VFNMADD231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ128rkz)
  .value("VFNMADD231PDZ256m", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256m)
  .value("VFNMADD231PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256mb)
  .value("VFNMADD231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256mbk)
  .value("VFNMADD231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256mbkz)
  .value("VFNMADD231PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256mk)
  .value("VFNMADD231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256mkz)
  .value("VFNMADD231PDZ256r", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256r)
  .value("VFNMADD231PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256rk)
  .value("VFNMADD231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZ256rkz)
  .value("VFNMADD231PDZm", LIEF::assembly::x86::OPCODE::VFNMADD231PDZm)
  .value("VFNMADD231PDZmb", LIEF::assembly::x86::OPCODE::VFNMADD231PDZmb)
  .value("VFNMADD231PDZmbk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZmbk)
  .value("VFNMADD231PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZmbkz)
  .value("VFNMADD231PDZmk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZmk)
  .value("VFNMADD231PDZmkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZmkz)
  .value("VFNMADD231PDZr", LIEF::assembly::x86::OPCODE::VFNMADD231PDZr)
  .value("VFNMADD231PDZrb", LIEF::assembly::x86::OPCODE::VFNMADD231PDZrb)
  .value("VFNMADD231PDZrbk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZrbk)
  .value("VFNMADD231PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZrbkz)
  .value("VFNMADD231PDZrk", LIEF::assembly::x86::OPCODE::VFNMADD231PDZrk)
  .value("VFNMADD231PDZrkz", LIEF::assembly::x86::OPCODE::VFNMADD231PDZrkz)
  .value("VFNMADD231PDm", LIEF::assembly::x86::OPCODE::VFNMADD231PDm)
  .value("VFNMADD231PDr", LIEF::assembly::x86::OPCODE::VFNMADD231PDr)
  .value("VFNMADD231PHZ128m", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128m)
  .value("VFNMADD231PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128mb)
  .value("VFNMADD231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128mbk)
  .value("VFNMADD231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128mbkz)
  .value("VFNMADD231PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128mk)
  .value("VFNMADD231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128mkz)
  .value("VFNMADD231PHZ128r", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128r)
  .value("VFNMADD231PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128rk)
  .value("VFNMADD231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ128rkz)
  .value("VFNMADD231PHZ256m", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256m)
  .value("VFNMADD231PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256mb)
  .value("VFNMADD231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256mbk)
  .value("VFNMADD231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256mbkz)
  .value("VFNMADD231PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256mk)
  .value("VFNMADD231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256mkz)
  .value("VFNMADD231PHZ256r", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256r)
  .value("VFNMADD231PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256rk)
  .value("VFNMADD231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZ256rkz)
  .value("VFNMADD231PHZm", LIEF::assembly::x86::OPCODE::VFNMADD231PHZm)
  .value("VFNMADD231PHZmb", LIEF::assembly::x86::OPCODE::VFNMADD231PHZmb)
  .value("VFNMADD231PHZmbk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZmbk)
  .value("VFNMADD231PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZmbkz)
  .value("VFNMADD231PHZmk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZmk)
  .value("VFNMADD231PHZmkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZmkz)
  .value("VFNMADD231PHZr", LIEF::assembly::x86::OPCODE::VFNMADD231PHZr)
  .value("VFNMADD231PHZrb", LIEF::assembly::x86::OPCODE::VFNMADD231PHZrb)
  .value("VFNMADD231PHZrbk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZrbk)
  .value("VFNMADD231PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZrbkz)
  .value("VFNMADD231PHZrk", LIEF::assembly::x86::OPCODE::VFNMADD231PHZrk)
  .value("VFNMADD231PHZrkz", LIEF::assembly::x86::OPCODE::VFNMADD231PHZrkz)
  .value("VFNMADD231PSYm", LIEF::assembly::x86::OPCODE::VFNMADD231PSYm)
  .value("VFNMADD231PSYr", LIEF::assembly::x86::OPCODE::VFNMADD231PSYr)
  .value("VFNMADD231PSZ128m", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128m)
  .value("VFNMADD231PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128mb)
  .value("VFNMADD231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128mbk)
  .value("VFNMADD231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128mbkz)
  .value("VFNMADD231PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128mk)
  .value("VFNMADD231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128mkz)
  .value("VFNMADD231PSZ128r", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128r)
  .value("VFNMADD231PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128rk)
  .value("VFNMADD231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ128rkz)
  .value("VFNMADD231PSZ256m", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256m)
  .value("VFNMADD231PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256mb)
  .value("VFNMADD231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256mbk)
  .value("VFNMADD231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256mbkz)
  .value("VFNMADD231PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256mk)
  .value("VFNMADD231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256mkz)
  .value("VFNMADD231PSZ256r", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256r)
  .value("VFNMADD231PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256rk)
  .value("VFNMADD231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZ256rkz)
  .value("VFNMADD231PSZm", LIEF::assembly::x86::OPCODE::VFNMADD231PSZm)
  .value("VFNMADD231PSZmb", LIEF::assembly::x86::OPCODE::VFNMADD231PSZmb)
  .value("VFNMADD231PSZmbk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZmbk)
  .value("VFNMADD231PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZmbkz)
  .value("VFNMADD231PSZmk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZmk)
  .value("VFNMADD231PSZmkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZmkz)
  .value("VFNMADD231PSZr", LIEF::assembly::x86::OPCODE::VFNMADD231PSZr)
  .value("VFNMADD231PSZrb", LIEF::assembly::x86::OPCODE::VFNMADD231PSZrb)
  .value("VFNMADD231PSZrbk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZrbk)
  .value("VFNMADD231PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZrbkz)
  .value("VFNMADD231PSZrk", LIEF::assembly::x86::OPCODE::VFNMADD231PSZrk)
  .value("VFNMADD231PSZrkz", LIEF::assembly::x86::OPCODE::VFNMADD231PSZrkz)
  .value("VFNMADD231PSm", LIEF::assembly::x86::OPCODE::VFNMADD231PSm)
  .value("VFNMADD231PSr", LIEF::assembly::x86::OPCODE::VFNMADD231PSr)
  .value("VFNMADD231SDZm", LIEF::assembly::x86::OPCODE::VFNMADD231SDZm)
  .value("VFNMADD231SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZm_Int)
  .value("VFNMADD231SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZmk_Int)
  .value("VFNMADD231SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZmkz_Int)
  .value("VFNMADD231SDZr", LIEF::assembly::x86::OPCODE::VFNMADD231SDZr)
  .value("VFNMADD231SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZr_Int)
  .value("VFNMADD231SDZrb", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrb)
  .value("VFNMADD231SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrb_Int)
  .value("VFNMADD231SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrbk_Int)
  .value("VFNMADD231SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrbkz_Int)
  .value("VFNMADD231SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrk_Int)
  .value("VFNMADD231SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDZrkz_Int)
  .value("VFNMADD231SDm", LIEF::assembly::x86::OPCODE::VFNMADD231SDm)
  .value("VFNMADD231SDm_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDm_Int)
  .value("VFNMADD231SDr", LIEF::assembly::x86::OPCODE::VFNMADD231SDr)
  .value("VFNMADD231SDr_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SDr_Int)
  .value("VFNMADD231SHZm", LIEF::assembly::x86::OPCODE::VFNMADD231SHZm)
  .value("VFNMADD231SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZm_Int)
  .value("VFNMADD231SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZmk_Int)
  .value("VFNMADD231SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZmkz_Int)
  .value("VFNMADD231SHZr", LIEF::assembly::x86::OPCODE::VFNMADD231SHZr)
  .value("VFNMADD231SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZr_Int)
  .value("VFNMADD231SHZrb", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrb)
  .value("VFNMADD231SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrb_Int)
  .value("VFNMADD231SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrbk_Int)
  .value("VFNMADD231SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrbkz_Int)
  .value("VFNMADD231SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrk_Int)
  .value("VFNMADD231SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SHZrkz_Int)
  .value("VFNMADD231SSZm", LIEF::assembly::x86::OPCODE::VFNMADD231SSZm)
  .value("VFNMADD231SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZm_Int)
  .value("VFNMADD231SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZmk_Int)
  .value("VFNMADD231SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZmkz_Int)
  .value("VFNMADD231SSZr", LIEF::assembly::x86::OPCODE::VFNMADD231SSZr)
  .value("VFNMADD231SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZr_Int)
  .value("VFNMADD231SSZrb", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrb)
  .value("VFNMADD231SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrb_Int)
  .value("VFNMADD231SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrbk_Int)
  .value("VFNMADD231SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrbkz_Int)
  .value("VFNMADD231SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrk_Int)
  .value("VFNMADD231SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSZrkz_Int)
  .value("VFNMADD231SSm", LIEF::assembly::x86::OPCODE::VFNMADD231SSm)
  .value("VFNMADD231SSm_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSm_Int)
  .value("VFNMADD231SSr", LIEF::assembly::x86::OPCODE::VFNMADD231SSr)
  .value("VFNMADD231SSr_Int", LIEF::assembly::x86::OPCODE::VFNMADD231SSr_Int)
  .value("VFNMADDPD4Ymr", LIEF::assembly::x86::OPCODE::VFNMADDPD4Ymr)
  .value("VFNMADDPD4Yrm", LIEF::assembly::x86::OPCODE::VFNMADDPD4Yrm)
  .value("VFNMADDPD4Yrr", LIEF::assembly::x86::OPCODE::VFNMADDPD4Yrr)
  .value("VFNMADDPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFNMADDPD4Yrr_REV)
  .value("VFNMADDPD4mr", LIEF::assembly::x86::OPCODE::VFNMADDPD4mr)
  .value("VFNMADDPD4rm", LIEF::assembly::x86::OPCODE::VFNMADDPD4rm)
  .value("VFNMADDPD4rr", LIEF::assembly::x86::OPCODE::VFNMADDPD4rr)
  .value("VFNMADDPD4rr_REV", LIEF::assembly::x86::OPCODE::VFNMADDPD4rr_REV)
  .value("VFNMADDPS4Ymr", LIEF::assembly::x86::OPCODE::VFNMADDPS4Ymr)
  .value("VFNMADDPS4Yrm", LIEF::assembly::x86::OPCODE::VFNMADDPS4Yrm)
  .value("VFNMADDPS4Yrr", LIEF::assembly::x86::OPCODE::VFNMADDPS4Yrr)
  .value("VFNMADDPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFNMADDPS4Yrr_REV)
  .value("VFNMADDPS4mr", LIEF::assembly::x86::OPCODE::VFNMADDPS4mr)
  .value("VFNMADDPS4rm", LIEF::assembly::x86::OPCODE::VFNMADDPS4rm)
  .value("VFNMADDPS4rr", LIEF::assembly::x86::OPCODE::VFNMADDPS4rr)
  .value("VFNMADDPS4rr_REV", LIEF::assembly::x86::OPCODE::VFNMADDPS4rr_REV)
  .value("VFNMADDSD4mr", LIEF::assembly::x86::OPCODE::VFNMADDSD4mr)
  .value("VFNMADDSD4mr_Int", LIEF::assembly::x86::OPCODE::VFNMADDSD4mr_Int)
  .value("VFNMADDSD4rm", LIEF::assembly::x86::OPCODE::VFNMADDSD4rm)
  .value("VFNMADDSD4rm_Int", LIEF::assembly::x86::OPCODE::VFNMADDSD4rm_Int)
  .value("VFNMADDSD4rr", LIEF::assembly::x86::OPCODE::VFNMADDSD4rr)
  .value("VFNMADDSD4rr_Int", LIEF::assembly::x86::OPCODE::VFNMADDSD4rr_Int)
  .value("VFNMADDSD4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFNMADDSD4rr_Int_REV)
  .value("VFNMADDSD4rr_REV", LIEF::assembly::x86::OPCODE::VFNMADDSD4rr_REV)
  .value("VFNMADDSS4mr", LIEF::assembly::x86::OPCODE::VFNMADDSS4mr)
  .value("VFNMADDSS4mr_Int", LIEF::assembly::x86::OPCODE::VFNMADDSS4mr_Int)
  .value("VFNMADDSS4rm", LIEF::assembly::x86::OPCODE::VFNMADDSS4rm)
  .value("VFNMADDSS4rm_Int", LIEF::assembly::x86::OPCODE::VFNMADDSS4rm_Int)
  .value("VFNMADDSS4rr", LIEF::assembly::x86::OPCODE::VFNMADDSS4rr)
  .value("VFNMADDSS4rr_Int", LIEF::assembly::x86::OPCODE::VFNMADDSS4rr_Int)
  .value("VFNMADDSS4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFNMADDSS4rr_Int_REV)
  .value("VFNMADDSS4rr_REV", LIEF::assembly::x86::OPCODE::VFNMADDSS4rr_REV)
  .value("VFNMSUB132BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128m)
  .value("VFNMSUB132BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128mb)
  .value("VFNMSUB132BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128mbk)
  .value("VFNMSUB132BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128mbkz)
  .value("VFNMSUB132BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128mk)
  .value("VFNMSUB132BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128mkz)
  .value("VFNMSUB132BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128r)
  .value("VFNMSUB132BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128rk)
  .value("VFNMSUB132BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z128rkz)
  .value("VFNMSUB132BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256m)
  .value("VFNMSUB132BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256mb)
  .value("VFNMSUB132BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256mbk)
  .value("VFNMSUB132BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256mbkz)
  .value("VFNMSUB132BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256mk)
  .value("VFNMSUB132BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256mkz)
  .value("VFNMSUB132BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256r)
  .value("VFNMSUB132BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256rk)
  .value("VFNMSUB132BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Z256rkz)
  .value("VFNMSUB132BF16Zm", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zm)
  .value("VFNMSUB132BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zmb)
  .value("VFNMSUB132BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zmbk)
  .value("VFNMSUB132BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zmbkz)
  .value("VFNMSUB132BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zmk)
  .value("VFNMSUB132BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zmkz)
  .value("VFNMSUB132BF16Zr", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zr)
  .value("VFNMSUB132BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zrk)
  .value("VFNMSUB132BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMSUB132BF16Zrkz)
  .value("VFNMSUB132PDYm", LIEF::assembly::x86::OPCODE::VFNMSUB132PDYm)
  .value("VFNMSUB132PDYr", LIEF::assembly::x86::OPCODE::VFNMSUB132PDYr)
  .value("VFNMSUB132PDZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128m)
  .value("VFNMSUB132PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128mb)
  .value("VFNMSUB132PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128mbk)
  .value("VFNMSUB132PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128mbkz)
  .value("VFNMSUB132PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128mk)
  .value("VFNMSUB132PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128mkz)
  .value("VFNMSUB132PDZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128r)
  .value("VFNMSUB132PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128rk)
  .value("VFNMSUB132PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ128rkz)
  .value("VFNMSUB132PDZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256m)
  .value("VFNMSUB132PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256mb)
  .value("VFNMSUB132PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256mbk)
  .value("VFNMSUB132PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256mbkz)
  .value("VFNMSUB132PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256mk)
  .value("VFNMSUB132PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256mkz)
  .value("VFNMSUB132PDZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256r)
  .value("VFNMSUB132PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256rk)
  .value("VFNMSUB132PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZ256rkz)
  .value("VFNMSUB132PDZm", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZm)
  .value("VFNMSUB132PDZmb", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZmb)
  .value("VFNMSUB132PDZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZmbk)
  .value("VFNMSUB132PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZmbkz)
  .value("VFNMSUB132PDZmk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZmk);
  opcodes.value("VFNMSUB132PDZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZmkz)
  .value("VFNMSUB132PDZr", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZr)
  .value("VFNMSUB132PDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZrb)
  .value("VFNMSUB132PDZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZrbk)
  .value("VFNMSUB132PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZrbkz)
  .value("VFNMSUB132PDZrk", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZrk)
  .value("VFNMSUB132PDZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PDZrkz)
  .value("VFNMSUB132PDm", LIEF::assembly::x86::OPCODE::VFNMSUB132PDm)
  .value("VFNMSUB132PDr", LIEF::assembly::x86::OPCODE::VFNMSUB132PDr)
  .value("VFNMSUB132PHZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128m)
  .value("VFNMSUB132PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128mb)
  .value("VFNMSUB132PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128mbk)
  .value("VFNMSUB132PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128mbkz)
  .value("VFNMSUB132PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128mk)
  .value("VFNMSUB132PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128mkz)
  .value("VFNMSUB132PHZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128r)
  .value("VFNMSUB132PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128rk)
  .value("VFNMSUB132PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ128rkz)
  .value("VFNMSUB132PHZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256m)
  .value("VFNMSUB132PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256mb)
  .value("VFNMSUB132PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256mbk)
  .value("VFNMSUB132PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256mbkz)
  .value("VFNMSUB132PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256mk)
  .value("VFNMSUB132PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256mkz)
  .value("VFNMSUB132PHZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256r)
  .value("VFNMSUB132PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256rk)
  .value("VFNMSUB132PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZ256rkz)
  .value("VFNMSUB132PHZm", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZm)
  .value("VFNMSUB132PHZmb", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZmb)
  .value("VFNMSUB132PHZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZmbk)
  .value("VFNMSUB132PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZmbkz)
  .value("VFNMSUB132PHZmk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZmk)
  .value("VFNMSUB132PHZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZmkz)
  .value("VFNMSUB132PHZr", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZr)
  .value("VFNMSUB132PHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZrb)
  .value("VFNMSUB132PHZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZrbk)
  .value("VFNMSUB132PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZrbkz)
  .value("VFNMSUB132PHZrk", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZrk)
  .value("VFNMSUB132PHZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PHZrkz)
  .value("VFNMSUB132PSYm", LIEF::assembly::x86::OPCODE::VFNMSUB132PSYm)
  .value("VFNMSUB132PSYr", LIEF::assembly::x86::OPCODE::VFNMSUB132PSYr)
  .value("VFNMSUB132PSZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128m)
  .value("VFNMSUB132PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128mb)
  .value("VFNMSUB132PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128mbk)
  .value("VFNMSUB132PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128mbkz)
  .value("VFNMSUB132PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128mk)
  .value("VFNMSUB132PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128mkz)
  .value("VFNMSUB132PSZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128r)
  .value("VFNMSUB132PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128rk)
  .value("VFNMSUB132PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ128rkz)
  .value("VFNMSUB132PSZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256m)
  .value("VFNMSUB132PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256mb)
  .value("VFNMSUB132PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256mbk)
  .value("VFNMSUB132PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256mbkz)
  .value("VFNMSUB132PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256mk)
  .value("VFNMSUB132PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256mkz)
  .value("VFNMSUB132PSZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256r)
  .value("VFNMSUB132PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256rk)
  .value("VFNMSUB132PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZ256rkz)
  .value("VFNMSUB132PSZm", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZm)
  .value("VFNMSUB132PSZmb", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZmb)
  .value("VFNMSUB132PSZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZmbk)
  .value("VFNMSUB132PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZmbkz)
  .value("VFNMSUB132PSZmk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZmk)
  .value("VFNMSUB132PSZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZmkz)
  .value("VFNMSUB132PSZr", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZr)
  .value("VFNMSUB132PSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZrb)
  .value("VFNMSUB132PSZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZrbk)
  .value("VFNMSUB132PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZrbkz)
  .value("VFNMSUB132PSZrk", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZrk)
  .value("VFNMSUB132PSZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB132PSZrkz)
  .value("VFNMSUB132PSm", LIEF::assembly::x86::OPCODE::VFNMSUB132PSm)
  .value("VFNMSUB132PSr", LIEF::assembly::x86::OPCODE::VFNMSUB132PSr)
  .value("VFNMSUB132SDZm", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZm)
  .value("VFNMSUB132SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZm_Int)
  .value("VFNMSUB132SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZmk_Int)
  .value("VFNMSUB132SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZmkz_Int)
  .value("VFNMSUB132SDZr", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZr)
  .value("VFNMSUB132SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZr_Int)
  .value("VFNMSUB132SDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrb)
  .value("VFNMSUB132SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrb_Int)
  .value("VFNMSUB132SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrbk_Int)
  .value("VFNMSUB132SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrbkz_Int)
  .value("VFNMSUB132SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrk_Int)
  .value("VFNMSUB132SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDZrkz_Int)
  .value("VFNMSUB132SDm", LIEF::assembly::x86::OPCODE::VFNMSUB132SDm)
  .value("VFNMSUB132SDm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDm_Int)
  .value("VFNMSUB132SDr", LIEF::assembly::x86::OPCODE::VFNMSUB132SDr)
  .value("VFNMSUB132SDr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SDr_Int)
  .value("VFNMSUB132SHZm", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZm)
  .value("VFNMSUB132SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZm_Int)
  .value("VFNMSUB132SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZmk_Int)
  .value("VFNMSUB132SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZmkz_Int)
  .value("VFNMSUB132SHZr", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZr)
  .value("VFNMSUB132SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZr_Int)
  .value("VFNMSUB132SHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrb)
  .value("VFNMSUB132SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrb_Int)
  .value("VFNMSUB132SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrbk_Int)
  .value("VFNMSUB132SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrbkz_Int)
  .value("VFNMSUB132SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrk_Int)
  .value("VFNMSUB132SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SHZrkz_Int)
  .value("VFNMSUB132SSZm", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZm)
  .value("VFNMSUB132SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZm_Int)
  .value("VFNMSUB132SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZmk_Int)
  .value("VFNMSUB132SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZmkz_Int)
  .value("VFNMSUB132SSZr", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZr)
  .value("VFNMSUB132SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZr_Int)
  .value("VFNMSUB132SSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrb)
  .value("VFNMSUB132SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrb_Int)
  .value("VFNMSUB132SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrbk_Int)
  .value("VFNMSUB132SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrbkz_Int)
  .value("VFNMSUB132SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrk_Int)
  .value("VFNMSUB132SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSZrkz_Int)
  .value("VFNMSUB132SSm", LIEF::assembly::x86::OPCODE::VFNMSUB132SSm)
  .value("VFNMSUB132SSm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSm_Int)
  .value("VFNMSUB132SSr", LIEF::assembly::x86::OPCODE::VFNMSUB132SSr)
  .value("VFNMSUB132SSr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB132SSr_Int)
  .value("VFNMSUB213BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128m)
  .value("VFNMSUB213BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128mb)
  .value("VFNMSUB213BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128mbk)
  .value("VFNMSUB213BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128mbkz)
  .value("VFNMSUB213BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128mk)
  .value("VFNMSUB213BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128mkz)
  .value("VFNMSUB213BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128r)
  .value("VFNMSUB213BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128rk)
  .value("VFNMSUB213BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z128rkz)
  .value("VFNMSUB213BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256m)
  .value("VFNMSUB213BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256mb)
  .value("VFNMSUB213BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256mbk)
  .value("VFNMSUB213BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256mbkz)
  .value("VFNMSUB213BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256mk)
  .value("VFNMSUB213BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256mkz)
  .value("VFNMSUB213BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256r)
  .value("VFNMSUB213BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256rk)
  .value("VFNMSUB213BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Z256rkz)
  .value("VFNMSUB213BF16Zm", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zm)
  .value("VFNMSUB213BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zmb)
  .value("VFNMSUB213BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zmbk)
  .value("VFNMSUB213BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zmbkz)
  .value("VFNMSUB213BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zmk)
  .value("VFNMSUB213BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zmkz)
  .value("VFNMSUB213BF16Zr", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zr)
  .value("VFNMSUB213BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zrk)
  .value("VFNMSUB213BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMSUB213BF16Zrkz)
  .value("VFNMSUB213PDYm", LIEF::assembly::x86::OPCODE::VFNMSUB213PDYm)
  .value("VFNMSUB213PDYr", LIEF::assembly::x86::OPCODE::VFNMSUB213PDYr)
  .value("VFNMSUB213PDZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128m)
  .value("VFNMSUB213PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128mb)
  .value("VFNMSUB213PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128mbk)
  .value("VFNMSUB213PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128mbkz)
  .value("VFNMSUB213PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128mk)
  .value("VFNMSUB213PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128mkz)
  .value("VFNMSUB213PDZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128r)
  .value("VFNMSUB213PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128rk)
  .value("VFNMSUB213PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ128rkz)
  .value("VFNMSUB213PDZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256m)
  .value("VFNMSUB213PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256mb)
  .value("VFNMSUB213PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256mbk)
  .value("VFNMSUB213PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256mbkz)
  .value("VFNMSUB213PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256mk)
  .value("VFNMSUB213PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256mkz)
  .value("VFNMSUB213PDZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256r)
  .value("VFNMSUB213PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256rk)
  .value("VFNMSUB213PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZ256rkz)
  .value("VFNMSUB213PDZm", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZm)
  .value("VFNMSUB213PDZmb", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZmb)
  .value("VFNMSUB213PDZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZmbk)
  .value("VFNMSUB213PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZmbkz)
  .value("VFNMSUB213PDZmk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZmk)
  .value("VFNMSUB213PDZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZmkz)
  .value("VFNMSUB213PDZr", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZr)
  .value("VFNMSUB213PDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZrb)
  .value("VFNMSUB213PDZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZrbk)
  .value("VFNMSUB213PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZrbkz)
  .value("VFNMSUB213PDZrk", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZrk)
  .value("VFNMSUB213PDZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PDZrkz)
  .value("VFNMSUB213PDm", LIEF::assembly::x86::OPCODE::VFNMSUB213PDm)
  .value("VFNMSUB213PDr", LIEF::assembly::x86::OPCODE::VFNMSUB213PDr)
  .value("VFNMSUB213PHZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128m)
  .value("VFNMSUB213PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128mb)
  .value("VFNMSUB213PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128mbk)
  .value("VFNMSUB213PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128mbkz)
  .value("VFNMSUB213PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128mk)
  .value("VFNMSUB213PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128mkz)
  .value("VFNMSUB213PHZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128r)
  .value("VFNMSUB213PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128rk)
  .value("VFNMSUB213PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ128rkz)
  .value("VFNMSUB213PHZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256m)
  .value("VFNMSUB213PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256mb)
  .value("VFNMSUB213PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256mbk)
  .value("VFNMSUB213PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256mbkz)
  .value("VFNMSUB213PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256mk)
  .value("VFNMSUB213PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256mkz)
  .value("VFNMSUB213PHZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256r)
  .value("VFNMSUB213PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256rk)
  .value("VFNMSUB213PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZ256rkz)
  .value("VFNMSUB213PHZm", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZm)
  .value("VFNMSUB213PHZmb", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZmb)
  .value("VFNMSUB213PHZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZmbk)
  .value("VFNMSUB213PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZmbkz)
  .value("VFNMSUB213PHZmk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZmk)
  .value("VFNMSUB213PHZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZmkz)
  .value("VFNMSUB213PHZr", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZr)
  .value("VFNMSUB213PHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZrb)
  .value("VFNMSUB213PHZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZrbk)
  .value("VFNMSUB213PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZrbkz)
  .value("VFNMSUB213PHZrk", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZrk)
  .value("VFNMSUB213PHZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PHZrkz)
  .value("VFNMSUB213PSYm", LIEF::assembly::x86::OPCODE::VFNMSUB213PSYm)
  .value("VFNMSUB213PSYr", LIEF::assembly::x86::OPCODE::VFNMSUB213PSYr)
  .value("VFNMSUB213PSZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128m)
  .value("VFNMSUB213PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128mb)
  .value("VFNMSUB213PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128mbk)
  .value("VFNMSUB213PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128mbkz)
  .value("VFNMSUB213PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128mk)
  .value("VFNMSUB213PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128mkz)
  .value("VFNMSUB213PSZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128r)
  .value("VFNMSUB213PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128rk)
  .value("VFNMSUB213PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ128rkz)
  .value("VFNMSUB213PSZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256m)
  .value("VFNMSUB213PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256mb)
  .value("VFNMSUB213PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256mbk)
  .value("VFNMSUB213PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256mbkz)
  .value("VFNMSUB213PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256mk)
  .value("VFNMSUB213PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256mkz)
  .value("VFNMSUB213PSZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256r)
  .value("VFNMSUB213PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256rk)
  .value("VFNMSUB213PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZ256rkz)
  .value("VFNMSUB213PSZm", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZm)
  .value("VFNMSUB213PSZmb", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZmb)
  .value("VFNMSUB213PSZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZmbk)
  .value("VFNMSUB213PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZmbkz)
  .value("VFNMSUB213PSZmk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZmk)
  .value("VFNMSUB213PSZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZmkz)
  .value("VFNMSUB213PSZr", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZr)
  .value("VFNMSUB213PSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZrb)
  .value("VFNMSUB213PSZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZrbk)
  .value("VFNMSUB213PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZrbkz)
  .value("VFNMSUB213PSZrk", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZrk)
  .value("VFNMSUB213PSZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB213PSZrkz)
  .value("VFNMSUB213PSm", LIEF::assembly::x86::OPCODE::VFNMSUB213PSm)
  .value("VFNMSUB213PSr", LIEF::assembly::x86::OPCODE::VFNMSUB213PSr)
  .value("VFNMSUB213SDZm", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZm)
  .value("VFNMSUB213SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZm_Int)
  .value("VFNMSUB213SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZmk_Int)
  .value("VFNMSUB213SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZmkz_Int)
  .value("VFNMSUB213SDZr", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZr)
  .value("VFNMSUB213SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZr_Int)
  .value("VFNMSUB213SDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrb)
  .value("VFNMSUB213SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrb_Int)
  .value("VFNMSUB213SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrbk_Int)
  .value("VFNMSUB213SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrbkz_Int)
  .value("VFNMSUB213SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrk_Int)
  .value("VFNMSUB213SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDZrkz_Int)
  .value("VFNMSUB213SDm", LIEF::assembly::x86::OPCODE::VFNMSUB213SDm)
  .value("VFNMSUB213SDm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDm_Int)
  .value("VFNMSUB213SDr", LIEF::assembly::x86::OPCODE::VFNMSUB213SDr)
  .value("VFNMSUB213SDr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SDr_Int)
  .value("VFNMSUB213SHZm", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZm)
  .value("VFNMSUB213SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZm_Int)
  .value("VFNMSUB213SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZmk_Int)
  .value("VFNMSUB213SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZmkz_Int)
  .value("VFNMSUB213SHZr", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZr)
  .value("VFNMSUB213SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZr_Int)
  .value("VFNMSUB213SHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrb)
  .value("VFNMSUB213SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrb_Int)
  .value("VFNMSUB213SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrbk_Int)
  .value("VFNMSUB213SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrbkz_Int)
  .value("VFNMSUB213SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrk_Int)
  .value("VFNMSUB213SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SHZrkz_Int)
  .value("VFNMSUB213SSZm", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZm)
  .value("VFNMSUB213SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZm_Int)
  .value("VFNMSUB213SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZmk_Int)
  .value("VFNMSUB213SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZmkz_Int)
  .value("VFNMSUB213SSZr", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZr)
  .value("VFNMSUB213SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZr_Int)
  .value("VFNMSUB213SSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrb)
  .value("VFNMSUB213SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrb_Int)
  .value("VFNMSUB213SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrbk_Int)
  .value("VFNMSUB213SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrbkz_Int)
  .value("VFNMSUB213SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrk_Int)
  .value("VFNMSUB213SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSZrkz_Int)
  .value("VFNMSUB213SSm", LIEF::assembly::x86::OPCODE::VFNMSUB213SSm)
  .value("VFNMSUB213SSm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSm_Int)
  .value("VFNMSUB213SSr", LIEF::assembly::x86::OPCODE::VFNMSUB213SSr)
  .value("VFNMSUB213SSr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB213SSr_Int)
  .value("VFNMSUB231BF16Z128m", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128m)
  .value("VFNMSUB231BF16Z128mb", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128mb)
  .value("VFNMSUB231BF16Z128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128mbk)
  .value("VFNMSUB231BF16Z128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128mbkz)
  .value("VFNMSUB231BF16Z128mk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128mk)
  .value("VFNMSUB231BF16Z128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128mkz)
  .value("VFNMSUB231BF16Z128r", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128r)
  .value("VFNMSUB231BF16Z128rk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128rk)
  .value("VFNMSUB231BF16Z128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z128rkz)
  .value("VFNMSUB231BF16Z256m", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256m)
  .value("VFNMSUB231BF16Z256mb", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256mb)
  .value("VFNMSUB231BF16Z256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256mbk)
  .value("VFNMSUB231BF16Z256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256mbkz)
  .value("VFNMSUB231BF16Z256mk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256mk);
  opcodes.value("VFNMSUB231BF16Z256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256mkz)
  .value("VFNMSUB231BF16Z256r", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256r)
  .value("VFNMSUB231BF16Z256rk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256rk)
  .value("VFNMSUB231BF16Z256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Z256rkz)
  .value("VFNMSUB231BF16Zm", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zm)
  .value("VFNMSUB231BF16Zmb", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zmb)
  .value("VFNMSUB231BF16Zmbk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zmbk)
  .value("VFNMSUB231BF16Zmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zmbkz)
  .value("VFNMSUB231BF16Zmk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zmk)
  .value("VFNMSUB231BF16Zmkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zmkz)
  .value("VFNMSUB231BF16Zr", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zr)
  .value("VFNMSUB231BF16Zrk", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zrk)
  .value("VFNMSUB231BF16Zrkz", LIEF::assembly::x86::OPCODE::VFNMSUB231BF16Zrkz)
  .value("VFNMSUB231PDYm", LIEF::assembly::x86::OPCODE::VFNMSUB231PDYm)
  .value("VFNMSUB231PDYr", LIEF::assembly::x86::OPCODE::VFNMSUB231PDYr)
  .value("VFNMSUB231PDZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128m)
  .value("VFNMSUB231PDZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128mb)
  .value("VFNMSUB231PDZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128mbk)
  .value("VFNMSUB231PDZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128mbkz)
  .value("VFNMSUB231PDZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128mk)
  .value("VFNMSUB231PDZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128mkz)
  .value("VFNMSUB231PDZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128r)
  .value("VFNMSUB231PDZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128rk)
  .value("VFNMSUB231PDZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ128rkz)
  .value("VFNMSUB231PDZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256m)
  .value("VFNMSUB231PDZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256mb)
  .value("VFNMSUB231PDZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256mbk)
  .value("VFNMSUB231PDZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256mbkz)
  .value("VFNMSUB231PDZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256mk)
  .value("VFNMSUB231PDZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256mkz)
  .value("VFNMSUB231PDZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256r)
  .value("VFNMSUB231PDZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256rk)
  .value("VFNMSUB231PDZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZ256rkz)
  .value("VFNMSUB231PDZm", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZm)
  .value("VFNMSUB231PDZmb", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZmb)
  .value("VFNMSUB231PDZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZmbk)
  .value("VFNMSUB231PDZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZmbkz)
  .value("VFNMSUB231PDZmk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZmk)
  .value("VFNMSUB231PDZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZmkz)
  .value("VFNMSUB231PDZr", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZr)
  .value("VFNMSUB231PDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZrb)
  .value("VFNMSUB231PDZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZrbk)
  .value("VFNMSUB231PDZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZrbkz)
  .value("VFNMSUB231PDZrk", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZrk)
  .value("VFNMSUB231PDZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PDZrkz)
  .value("VFNMSUB231PDm", LIEF::assembly::x86::OPCODE::VFNMSUB231PDm)
  .value("VFNMSUB231PDr", LIEF::assembly::x86::OPCODE::VFNMSUB231PDr)
  .value("VFNMSUB231PHZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128m)
  .value("VFNMSUB231PHZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128mb)
  .value("VFNMSUB231PHZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128mbk)
  .value("VFNMSUB231PHZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128mbkz)
  .value("VFNMSUB231PHZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128mk)
  .value("VFNMSUB231PHZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128mkz)
  .value("VFNMSUB231PHZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128r)
  .value("VFNMSUB231PHZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128rk)
  .value("VFNMSUB231PHZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ128rkz)
  .value("VFNMSUB231PHZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256m)
  .value("VFNMSUB231PHZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256mb)
  .value("VFNMSUB231PHZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256mbk)
  .value("VFNMSUB231PHZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256mbkz)
  .value("VFNMSUB231PHZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256mk)
  .value("VFNMSUB231PHZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256mkz)
  .value("VFNMSUB231PHZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256r)
  .value("VFNMSUB231PHZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256rk)
  .value("VFNMSUB231PHZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZ256rkz)
  .value("VFNMSUB231PHZm", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZm)
  .value("VFNMSUB231PHZmb", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZmb)
  .value("VFNMSUB231PHZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZmbk)
  .value("VFNMSUB231PHZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZmbkz)
  .value("VFNMSUB231PHZmk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZmk)
  .value("VFNMSUB231PHZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZmkz)
  .value("VFNMSUB231PHZr", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZr)
  .value("VFNMSUB231PHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZrb)
  .value("VFNMSUB231PHZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZrbk)
  .value("VFNMSUB231PHZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZrbkz)
  .value("VFNMSUB231PHZrk", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZrk)
  .value("VFNMSUB231PHZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PHZrkz)
  .value("VFNMSUB231PSYm", LIEF::assembly::x86::OPCODE::VFNMSUB231PSYm)
  .value("VFNMSUB231PSYr", LIEF::assembly::x86::OPCODE::VFNMSUB231PSYr)
  .value("VFNMSUB231PSZ128m", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128m)
  .value("VFNMSUB231PSZ128mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128mb)
  .value("VFNMSUB231PSZ128mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128mbk)
  .value("VFNMSUB231PSZ128mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128mbkz)
  .value("VFNMSUB231PSZ128mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128mk)
  .value("VFNMSUB231PSZ128mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128mkz)
  .value("VFNMSUB231PSZ128r", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128r)
  .value("VFNMSUB231PSZ128rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128rk)
  .value("VFNMSUB231PSZ128rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ128rkz)
  .value("VFNMSUB231PSZ256m", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256m)
  .value("VFNMSUB231PSZ256mb", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256mb)
  .value("VFNMSUB231PSZ256mbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256mbk)
  .value("VFNMSUB231PSZ256mbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256mbkz)
  .value("VFNMSUB231PSZ256mk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256mk)
  .value("VFNMSUB231PSZ256mkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256mkz)
  .value("VFNMSUB231PSZ256r", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256r)
  .value("VFNMSUB231PSZ256rk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256rk)
  .value("VFNMSUB231PSZ256rkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZ256rkz)
  .value("VFNMSUB231PSZm", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZm)
  .value("VFNMSUB231PSZmb", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZmb)
  .value("VFNMSUB231PSZmbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZmbk)
  .value("VFNMSUB231PSZmbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZmbkz)
  .value("VFNMSUB231PSZmk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZmk)
  .value("VFNMSUB231PSZmkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZmkz)
  .value("VFNMSUB231PSZr", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZr)
  .value("VFNMSUB231PSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZrb)
  .value("VFNMSUB231PSZrbk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZrbk)
  .value("VFNMSUB231PSZrbkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZrbkz)
  .value("VFNMSUB231PSZrk", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZrk)
  .value("VFNMSUB231PSZrkz", LIEF::assembly::x86::OPCODE::VFNMSUB231PSZrkz)
  .value("VFNMSUB231PSm", LIEF::assembly::x86::OPCODE::VFNMSUB231PSm)
  .value("VFNMSUB231PSr", LIEF::assembly::x86::OPCODE::VFNMSUB231PSr)
  .value("VFNMSUB231SDZm", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZm)
  .value("VFNMSUB231SDZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZm_Int)
  .value("VFNMSUB231SDZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZmk_Int)
  .value("VFNMSUB231SDZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZmkz_Int)
  .value("VFNMSUB231SDZr", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZr)
  .value("VFNMSUB231SDZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZr_Int)
  .value("VFNMSUB231SDZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrb)
  .value("VFNMSUB231SDZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrb_Int)
  .value("VFNMSUB231SDZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrbk_Int)
  .value("VFNMSUB231SDZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrbkz_Int)
  .value("VFNMSUB231SDZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrk_Int)
  .value("VFNMSUB231SDZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDZrkz_Int)
  .value("VFNMSUB231SDm", LIEF::assembly::x86::OPCODE::VFNMSUB231SDm)
  .value("VFNMSUB231SDm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDm_Int)
  .value("VFNMSUB231SDr", LIEF::assembly::x86::OPCODE::VFNMSUB231SDr)
  .value("VFNMSUB231SDr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SDr_Int)
  .value("VFNMSUB231SHZm", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZm)
  .value("VFNMSUB231SHZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZm_Int)
  .value("VFNMSUB231SHZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZmk_Int)
  .value("VFNMSUB231SHZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZmkz_Int)
  .value("VFNMSUB231SHZr", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZr)
  .value("VFNMSUB231SHZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZr_Int)
  .value("VFNMSUB231SHZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrb)
  .value("VFNMSUB231SHZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrb_Int)
  .value("VFNMSUB231SHZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrbk_Int)
  .value("VFNMSUB231SHZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrbkz_Int)
  .value("VFNMSUB231SHZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrk_Int)
  .value("VFNMSUB231SHZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SHZrkz_Int)
  .value("VFNMSUB231SSZm", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZm)
  .value("VFNMSUB231SSZm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZm_Int)
  .value("VFNMSUB231SSZmk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZmk_Int)
  .value("VFNMSUB231SSZmkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZmkz_Int)
  .value("VFNMSUB231SSZr", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZr)
  .value("VFNMSUB231SSZr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZr_Int)
  .value("VFNMSUB231SSZrb", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrb)
  .value("VFNMSUB231SSZrb_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrb_Int)
  .value("VFNMSUB231SSZrbk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrbk_Int)
  .value("VFNMSUB231SSZrbkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrbkz_Int)
  .value("VFNMSUB231SSZrk_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrk_Int)
  .value("VFNMSUB231SSZrkz_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSZrkz_Int)
  .value("VFNMSUB231SSm", LIEF::assembly::x86::OPCODE::VFNMSUB231SSm)
  .value("VFNMSUB231SSm_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSm_Int)
  .value("VFNMSUB231SSr", LIEF::assembly::x86::OPCODE::VFNMSUB231SSr)
  .value("VFNMSUB231SSr_Int", LIEF::assembly::x86::OPCODE::VFNMSUB231SSr_Int)
  .value("VFNMSUBPD4Ymr", LIEF::assembly::x86::OPCODE::VFNMSUBPD4Ymr)
  .value("VFNMSUBPD4Yrm", LIEF::assembly::x86::OPCODE::VFNMSUBPD4Yrm)
  .value("VFNMSUBPD4Yrr", LIEF::assembly::x86::OPCODE::VFNMSUBPD4Yrr)
  .value("VFNMSUBPD4Yrr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBPD4Yrr_REV)
  .value("VFNMSUBPD4mr", LIEF::assembly::x86::OPCODE::VFNMSUBPD4mr)
  .value("VFNMSUBPD4rm", LIEF::assembly::x86::OPCODE::VFNMSUBPD4rm)
  .value("VFNMSUBPD4rr", LIEF::assembly::x86::OPCODE::VFNMSUBPD4rr)
  .value("VFNMSUBPD4rr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBPD4rr_REV)
  .value("VFNMSUBPS4Ymr", LIEF::assembly::x86::OPCODE::VFNMSUBPS4Ymr)
  .value("VFNMSUBPS4Yrm", LIEF::assembly::x86::OPCODE::VFNMSUBPS4Yrm)
  .value("VFNMSUBPS4Yrr", LIEF::assembly::x86::OPCODE::VFNMSUBPS4Yrr)
  .value("VFNMSUBPS4Yrr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBPS4Yrr_REV)
  .value("VFNMSUBPS4mr", LIEF::assembly::x86::OPCODE::VFNMSUBPS4mr)
  .value("VFNMSUBPS4rm", LIEF::assembly::x86::OPCODE::VFNMSUBPS4rm)
  .value("VFNMSUBPS4rr", LIEF::assembly::x86::OPCODE::VFNMSUBPS4rr)
  .value("VFNMSUBPS4rr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBPS4rr_REV)
  .value("VFNMSUBSD4mr", LIEF::assembly::x86::OPCODE::VFNMSUBSD4mr)
  .value("VFNMSUBSD4mr_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSD4mr_Int)
  .value("VFNMSUBSD4rm", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rm)
  .value("VFNMSUBSD4rm_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rm_Int)
  .value("VFNMSUBSD4rr", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rr)
  .value("VFNMSUBSD4rr_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rr_Int)
  .value("VFNMSUBSD4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rr_Int_REV)
  .value("VFNMSUBSD4rr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBSD4rr_REV)
  .value("VFNMSUBSS4mr", LIEF::assembly::x86::OPCODE::VFNMSUBSS4mr)
  .value("VFNMSUBSS4mr_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSS4mr_Int)
  .value("VFNMSUBSS4rm", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rm)
  .value("VFNMSUBSS4rm_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rm_Int)
  .value("VFNMSUBSS4rr", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rr)
  .value("VFNMSUBSS4rr_Int", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rr_Int)
  .value("VFNMSUBSS4rr_Int_REV", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rr_Int_REV)
  .value("VFNMSUBSS4rr_REV", LIEF::assembly::x86::OPCODE::VFNMSUBSS4rr_REV)
  .value("VFPCLASSBF16Z128mbi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128mbi)
  .value("VFPCLASSBF16Z128mbik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128mbik)
  .value("VFPCLASSBF16Z128mi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128mi)
  .value("VFPCLASSBF16Z128mik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128mik)
  .value("VFPCLASSBF16Z128ri", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128ri)
  .value("VFPCLASSBF16Z128rik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z128rik)
  .value("VFPCLASSBF16Z256mbi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256mbi)
  .value("VFPCLASSBF16Z256mbik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256mbik)
  .value("VFPCLASSBF16Z256mi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256mi)
  .value("VFPCLASSBF16Z256mik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256mik)
  .value("VFPCLASSBF16Z256ri", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256ri)
  .value("VFPCLASSBF16Z256rik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Z256rik)
  .value("VFPCLASSBF16Zmbi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zmbi)
  .value("VFPCLASSBF16Zmbik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zmbik)
  .value("VFPCLASSBF16Zmi", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zmi)
  .value("VFPCLASSBF16Zmik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zmik)
  .value("VFPCLASSBF16Zri", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zri)
  .value("VFPCLASSBF16Zrik", LIEF::assembly::x86::OPCODE::VFPCLASSBF16Zrik)
  .value("VFPCLASSPDZ128mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128mbi)
  .value("VFPCLASSPDZ128mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128mbik)
  .value("VFPCLASSPDZ128mi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128mi)
  .value("VFPCLASSPDZ128mik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128mik)
  .value("VFPCLASSPDZ128ri", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128ri)
  .value("VFPCLASSPDZ128rik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ128rik)
  .value("VFPCLASSPDZ256mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256mbi)
  .value("VFPCLASSPDZ256mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256mbik)
  .value("VFPCLASSPDZ256mi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256mi)
  .value("VFPCLASSPDZ256mik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256mik)
  .value("VFPCLASSPDZ256ri", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256ri)
  .value("VFPCLASSPDZ256rik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZ256rik)
  .value("VFPCLASSPDZmbi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZmbi)
  .value("VFPCLASSPDZmbik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZmbik)
  .value("VFPCLASSPDZmi", LIEF::assembly::x86::OPCODE::VFPCLASSPDZmi)
  .value("VFPCLASSPDZmik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZmik)
  .value("VFPCLASSPDZri", LIEF::assembly::x86::OPCODE::VFPCLASSPDZri)
  .value("VFPCLASSPDZrik", LIEF::assembly::x86::OPCODE::VFPCLASSPDZrik)
  .value("VFPCLASSPHZ128mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128mbi)
  .value("VFPCLASSPHZ128mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128mbik)
  .value("VFPCLASSPHZ128mi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128mi)
  .value("VFPCLASSPHZ128mik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128mik)
  .value("VFPCLASSPHZ128ri", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128ri)
  .value("VFPCLASSPHZ128rik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ128rik)
  .value("VFPCLASSPHZ256mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256mbi)
  .value("VFPCLASSPHZ256mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256mbik)
  .value("VFPCLASSPHZ256mi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256mi)
  .value("VFPCLASSPHZ256mik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256mik)
  .value("VFPCLASSPHZ256ri", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256ri)
  .value("VFPCLASSPHZ256rik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZ256rik)
  .value("VFPCLASSPHZmbi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZmbi)
  .value("VFPCLASSPHZmbik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZmbik)
  .value("VFPCLASSPHZmi", LIEF::assembly::x86::OPCODE::VFPCLASSPHZmi)
  .value("VFPCLASSPHZmik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZmik)
  .value("VFPCLASSPHZri", LIEF::assembly::x86::OPCODE::VFPCLASSPHZri)
  .value("VFPCLASSPHZrik", LIEF::assembly::x86::OPCODE::VFPCLASSPHZrik)
  .value("VFPCLASSPSZ128mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128mbi)
  .value("VFPCLASSPSZ128mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128mbik)
  .value("VFPCLASSPSZ128mi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128mi)
  .value("VFPCLASSPSZ128mik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128mik)
  .value("VFPCLASSPSZ128ri", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128ri)
  .value("VFPCLASSPSZ128rik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ128rik)
  .value("VFPCLASSPSZ256mbi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256mbi)
  .value("VFPCLASSPSZ256mbik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256mbik)
  .value("VFPCLASSPSZ256mi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256mi)
  .value("VFPCLASSPSZ256mik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256mik)
  .value("VFPCLASSPSZ256ri", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256ri)
  .value("VFPCLASSPSZ256rik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZ256rik)
  .value("VFPCLASSPSZmbi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZmbi)
  .value("VFPCLASSPSZmbik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZmbik)
  .value("VFPCLASSPSZmi", LIEF::assembly::x86::OPCODE::VFPCLASSPSZmi)
  .value("VFPCLASSPSZmik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZmik)
  .value("VFPCLASSPSZri", LIEF::assembly::x86::OPCODE::VFPCLASSPSZri)
  .value("VFPCLASSPSZrik", LIEF::assembly::x86::OPCODE::VFPCLASSPSZrik)
  .value("VFPCLASSSDZmi", LIEF::assembly::x86::OPCODE::VFPCLASSSDZmi)
  .value("VFPCLASSSDZmik", LIEF::assembly::x86::OPCODE::VFPCLASSSDZmik)
  .value("VFPCLASSSDZri", LIEF::assembly::x86::OPCODE::VFPCLASSSDZri)
  .value("VFPCLASSSDZrik", LIEF::assembly::x86::OPCODE::VFPCLASSSDZrik)
  .value("VFPCLASSSHZmi", LIEF::assembly::x86::OPCODE::VFPCLASSSHZmi)
  .value("VFPCLASSSHZmik", LIEF::assembly::x86::OPCODE::VFPCLASSSHZmik)
  .value("VFPCLASSSHZri", LIEF::assembly::x86::OPCODE::VFPCLASSSHZri)
  .value("VFPCLASSSHZrik", LIEF::assembly::x86::OPCODE::VFPCLASSSHZrik)
  .value("VFPCLASSSSZmi", LIEF::assembly::x86::OPCODE::VFPCLASSSSZmi)
  .value("VFPCLASSSSZmik", LIEF::assembly::x86::OPCODE::VFPCLASSSSZmik)
  .value("VFPCLASSSSZri", LIEF::assembly::x86::OPCODE::VFPCLASSSSZri)
  .value("VFPCLASSSSZrik", LIEF::assembly::x86::OPCODE::VFPCLASSSSZrik)
  .value("VFRCZPDYrm", LIEF::assembly::x86::OPCODE::VFRCZPDYrm)
  .value("VFRCZPDYrr", LIEF::assembly::x86::OPCODE::VFRCZPDYrr)
  .value("VFRCZPDrm", LIEF::assembly::x86::OPCODE::VFRCZPDrm)
  .value("VFRCZPDrr", LIEF::assembly::x86::OPCODE::VFRCZPDrr)
  .value("VFRCZPSYrm", LIEF::assembly::x86::OPCODE::VFRCZPSYrm)
  .value("VFRCZPSYrr", LIEF::assembly::x86::OPCODE::VFRCZPSYrr)
  .value("VFRCZPSrm", LIEF::assembly::x86::OPCODE::VFRCZPSrm)
  .value("VFRCZPSrr", LIEF::assembly::x86::OPCODE::VFRCZPSrr)
  .value("VFRCZSDrm", LIEF::assembly::x86::OPCODE::VFRCZSDrm)
  .value("VFRCZSDrr", LIEF::assembly::x86::OPCODE::VFRCZSDrr)
  .value("VFRCZSSrm", LIEF::assembly::x86::OPCODE::VFRCZSSrm)
  .value("VFRCZSSrr", LIEF::assembly::x86::OPCODE::VFRCZSSrr)
  .value("VGATHERDPDYrm", LIEF::assembly::x86::OPCODE::VGATHERDPDYrm)
  .value("VGATHERDPDZ128rm", LIEF::assembly::x86::OPCODE::VGATHERDPDZ128rm)
  .value("VGATHERDPDZ256rm", LIEF::assembly::x86::OPCODE::VGATHERDPDZ256rm)
  .value("VGATHERDPDZrm", LIEF::assembly::x86::OPCODE::VGATHERDPDZrm)
  .value("VGATHERDPDrm", LIEF::assembly::x86::OPCODE::VGATHERDPDrm)
  .value("VGATHERDPSYrm", LIEF::assembly::x86::OPCODE::VGATHERDPSYrm)
  .value("VGATHERDPSZ128rm", LIEF::assembly::x86::OPCODE::VGATHERDPSZ128rm)
  .value("VGATHERDPSZ256rm", LIEF::assembly::x86::OPCODE::VGATHERDPSZ256rm)
  .value("VGATHERDPSZrm", LIEF::assembly::x86::OPCODE::VGATHERDPSZrm)
  .value("VGATHERDPSrm", LIEF::assembly::x86::OPCODE::VGATHERDPSrm)
  .value("VGATHERPF0DPDm", LIEF::assembly::x86::OPCODE::VGATHERPF0DPDm)
  .value("VGATHERPF0DPSm", LIEF::assembly::x86::OPCODE::VGATHERPF0DPSm)
  .value("VGATHERPF0QPDm", LIEF::assembly::x86::OPCODE::VGATHERPF0QPDm)
  .value("VGATHERPF0QPSm", LIEF::assembly::x86::OPCODE::VGATHERPF0QPSm)
  .value("VGATHERPF1DPDm", LIEF::assembly::x86::OPCODE::VGATHERPF1DPDm)
  .value("VGATHERPF1DPSm", LIEF::assembly::x86::OPCODE::VGATHERPF1DPSm)
  .value("VGATHERPF1QPDm", LIEF::assembly::x86::OPCODE::VGATHERPF1QPDm);
  opcodes.value("VGATHERPF1QPSm", LIEF::assembly::x86::OPCODE::VGATHERPF1QPSm)
  .value("VGATHERQPDYrm", LIEF::assembly::x86::OPCODE::VGATHERQPDYrm)
  .value("VGATHERQPDZ128rm", LIEF::assembly::x86::OPCODE::VGATHERQPDZ128rm)
  .value("VGATHERQPDZ256rm", LIEF::assembly::x86::OPCODE::VGATHERQPDZ256rm)
  .value("VGATHERQPDZrm", LIEF::assembly::x86::OPCODE::VGATHERQPDZrm)
  .value("VGATHERQPDrm", LIEF::assembly::x86::OPCODE::VGATHERQPDrm)
  .value("VGATHERQPSYrm", LIEF::assembly::x86::OPCODE::VGATHERQPSYrm)
  .value("VGATHERQPSZ128rm", LIEF::assembly::x86::OPCODE::VGATHERQPSZ128rm)
  .value("VGATHERQPSZ256rm", LIEF::assembly::x86::OPCODE::VGATHERQPSZ256rm)
  .value("VGATHERQPSZrm", LIEF::assembly::x86::OPCODE::VGATHERQPSZrm)
  .value("VGATHERQPSrm", LIEF::assembly::x86::OPCODE::VGATHERQPSrm)
  .value("VGETEXPBF16Z128m", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128m)
  .value("VGETEXPBF16Z128mb", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128mb)
  .value("VGETEXPBF16Z128mbk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128mbk)
  .value("VGETEXPBF16Z128mbkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128mbkz)
  .value("VGETEXPBF16Z128mk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128mk)
  .value("VGETEXPBF16Z128mkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128mkz)
  .value("VGETEXPBF16Z128r", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128r)
  .value("VGETEXPBF16Z128rk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128rk)
  .value("VGETEXPBF16Z128rkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z128rkz)
  .value("VGETEXPBF16Z256m", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256m)
  .value("VGETEXPBF16Z256mb", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256mb)
  .value("VGETEXPBF16Z256mbk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256mbk)
  .value("VGETEXPBF16Z256mbkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256mbkz)
  .value("VGETEXPBF16Z256mk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256mk)
  .value("VGETEXPBF16Z256mkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256mkz)
  .value("VGETEXPBF16Z256r", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256r)
  .value("VGETEXPBF16Z256rk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256rk)
  .value("VGETEXPBF16Z256rkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Z256rkz)
  .value("VGETEXPBF16Zm", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zm)
  .value("VGETEXPBF16Zmb", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zmb)
  .value("VGETEXPBF16Zmbk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zmbk)
  .value("VGETEXPBF16Zmbkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zmbkz)
  .value("VGETEXPBF16Zmk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zmk)
  .value("VGETEXPBF16Zmkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zmkz)
  .value("VGETEXPBF16Zr", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zr)
  .value("VGETEXPBF16Zrk", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zrk)
  .value("VGETEXPBF16Zrkz", LIEF::assembly::x86::OPCODE::VGETEXPBF16Zrkz)
  .value("VGETEXPPDZ128m", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128m)
  .value("VGETEXPPDZ128mb", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128mb)
  .value("VGETEXPPDZ128mbk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128mbk)
  .value("VGETEXPPDZ128mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128mbkz)
  .value("VGETEXPPDZ128mk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128mk)
  .value("VGETEXPPDZ128mkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128mkz)
  .value("VGETEXPPDZ128r", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128r)
  .value("VGETEXPPDZ128rk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128rk)
  .value("VGETEXPPDZ128rkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ128rkz)
  .value("VGETEXPPDZ256m", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256m)
  .value("VGETEXPPDZ256mb", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256mb)
  .value("VGETEXPPDZ256mbk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256mbk)
  .value("VGETEXPPDZ256mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256mbkz)
  .value("VGETEXPPDZ256mk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256mk)
  .value("VGETEXPPDZ256mkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256mkz)
  .value("VGETEXPPDZ256r", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256r)
  .value("VGETEXPPDZ256rk", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256rk)
  .value("VGETEXPPDZ256rkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZ256rkz)
  .value("VGETEXPPDZm", LIEF::assembly::x86::OPCODE::VGETEXPPDZm)
  .value("VGETEXPPDZmb", LIEF::assembly::x86::OPCODE::VGETEXPPDZmb)
  .value("VGETEXPPDZmbk", LIEF::assembly::x86::OPCODE::VGETEXPPDZmbk)
  .value("VGETEXPPDZmbkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZmbkz)
  .value("VGETEXPPDZmk", LIEF::assembly::x86::OPCODE::VGETEXPPDZmk)
  .value("VGETEXPPDZmkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZmkz)
  .value("VGETEXPPDZr", LIEF::assembly::x86::OPCODE::VGETEXPPDZr)
  .value("VGETEXPPDZrb", LIEF::assembly::x86::OPCODE::VGETEXPPDZrb)
  .value("VGETEXPPDZrbk", LIEF::assembly::x86::OPCODE::VGETEXPPDZrbk)
  .value("VGETEXPPDZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZrbkz)
  .value("VGETEXPPDZrk", LIEF::assembly::x86::OPCODE::VGETEXPPDZrk)
  .value("VGETEXPPDZrkz", LIEF::assembly::x86::OPCODE::VGETEXPPDZrkz)
  .value("VGETEXPPHZ128m", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128m)
  .value("VGETEXPPHZ128mb", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128mb)
  .value("VGETEXPPHZ128mbk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128mbk)
  .value("VGETEXPPHZ128mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128mbkz)
  .value("VGETEXPPHZ128mk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128mk)
  .value("VGETEXPPHZ128mkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128mkz)
  .value("VGETEXPPHZ128r", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128r)
  .value("VGETEXPPHZ128rk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128rk)
  .value("VGETEXPPHZ128rkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ128rkz)
  .value("VGETEXPPHZ256m", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256m)
  .value("VGETEXPPHZ256mb", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256mb)
  .value("VGETEXPPHZ256mbk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256mbk)
  .value("VGETEXPPHZ256mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256mbkz)
  .value("VGETEXPPHZ256mk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256mk)
  .value("VGETEXPPHZ256mkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256mkz)
  .value("VGETEXPPHZ256r", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256r)
  .value("VGETEXPPHZ256rk", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256rk)
  .value("VGETEXPPHZ256rkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZ256rkz)
  .value("VGETEXPPHZm", LIEF::assembly::x86::OPCODE::VGETEXPPHZm)
  .value("VGETEXPPHZmb", LIEF::assembly::x86::OPCODE::VGETEXPPHZmb)
  .value("VGETEXPPHZmbk", LIEF::assembly::x86::OPCODE::VGETEXPPHZmbk)
  .value("VGETEXPPHZmbkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZmbkz)
  .value("VGETEXPPHZmk", LIEF::assembly::x86::OPCODE::VGETEXPPHZmk)
  .value("VGETEXPPHZmkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZmkz)
  .value("VGETEXPPHZr", LIEF::assembly::x86::OPCODE::VGETEXPPHZr)
  .value("VGETEXPPHZrb", LIEF::assembly::x86::OPCODE::VGETEXPPHZrb)
  .value("VGETEXPPHZrbk", LIEF::assembly::x86::OPCODE::VGETEXPPHZrbk)
  .value("VGETEXPPHZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZrbkz)
  .value("VGETEXPPHZrk", LIEF::assembly::x86::OPCODE::VGETEXPPHZrk)
  .value("VGETEXPPHZrkz", LIEF::assembly::x86::OPCODE::VGETEXPPHZrkz)
  .value("VGETEXPPSZ128m", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128m)
  .value("VGETEXPPSZ128mb", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128mb)
  .value("VGETEXPPSZ128mbk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128mbk)
  .value("VGETEXPPSZ128mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128mbkz)
  .value("VGETEXPPSZ128mk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128mk)
  .value("VGETEXPPSZ128mkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128mkz)
  .value("VGETEXPPSZ128r", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128r)
  .value("VGETEXPPSZ128rk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128rk)
  .value("VGETEXPPSZ128rkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ128rkz)
  .value("VGETEXPPSZ256m", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256m)
  .value("VGETEXPPSZ256mb", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256mb)
  .value("VGETEXPPSZ256mbk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256mbk)
  .value("VGETEXPPSZ256mbkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256mbkz)
  .value("VGETEXPPSZ256mk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256mk)
  .value("VGETEXPPSZ256mkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256mkz)
  .value("VGETEXPPSZ256r", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256r)
  .value("VGETEXPPSZ256rk", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256rk)
  .value("VGETEXPPSZ256rkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZ256rkz)
  .value("VGETEXPPSZm", LIEF::assembly::x86::OPCODE::VGETEXPPSZm)
  .value("VGETEXPPSZmb", LIEF::assembly::x86::OPCODE::VGETEXPPSZmb)
  .value("VGETEXPPSZmbk", LIEF::assembly::x86::OPCODE::VGETEXPPSZmbk)
  .value("VGETEXPPSZmbkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZmbkz)
  .value("VGETEXPPSZmk", LIEF::assembly::x86::OPCODE::VGETEXPPSZmk)
  .value("VGETEXPPSZmkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZmkz)
  .value("VGETEXPPSZr", LIEF::assembly::x86::OPCODE::VGETEXPPSZr)
  .value("VGETEXPPSZrb", LIEF::assembly::x86::OPCODE::VGETEXPPSZrb)
  .value("VGETEXPPSZrbk", LIEF::assembly::x86::OPCODE::VGETEXPPSZrbk)
  .value("VGETEXPPSZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZrbkz)
  .value("VGETEXPPSZrk", LIEF::assembly::x86::OPCODE::VGETEXPPSZrk)
  .value("VGETEXPPSZrkz", LIEF::assembly::x86::OPCODE::VGETEXPPSZrkz)
  .value("VGETEXPSDZm", LIEF::assembly::x86::OPCODE::VGETEXPSDZm)
  .value("VGETEXPSDZmk", LIEF::assembly::x86::OPCODE::VGETEXPSDZmk)
  .value("VGETEXPSDZmkz", LIEF::assembly::x86::OPCODE::VGETEXPSDZmkz)
  .value("VGETEXPSDZr", LIEF::assembly::x86::OPCODE::VGETEXPSDZr)
  .value("VGETEXPSDZrb", LIEF::assembly::x86::OPCODE::VGETEXPSDZrb)
  .value("VGETEXPSDZrbk", LIEF::assembly::x86::OPCODE::VGETEXPSDZrbk)
  .value("VGETEXPSDZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPSDZrbkz)
  .value("VGETEXPSDZrk", LIEF::assembly::x86::OPCODE::VGETEXPSDZrk)
  .value("VGETEXPSDZrkz", LIEF::assembly::x86::OPCODE::VGETEXPSDZrkz)
  .value("VGETEXPSHZm", LIEF::assembly::x86::OPCODE::VGETEXPSHZm)
  .value("VGETEXPSHZmk", LIEF::assembly::x86::OPCODE::VGETEXPSHZmk)
  .value("VGETEXPSHZmkz", LIEF::assembly::x86::OPCODE::VGETEXPSHZmkz)
  .value("VGETEXPSHZr", LIEF::assembly::x86::OPCODE::VGETEXPSHZr)
  .value("VGETEXPSHZrb", LIEF::assembly::x86::OPCODE::VGETEXPSHZrb)
  .value("VGETEXPSHZrbk", LIEF::assembly::x86::OPCODE::VGETEXPSHZrbk)
  .value("VGETEXPSHZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPSHZrbkz)
  .value("VGETEXPSHZrk", LIEF::assembly::x86::OPCODE::VGETEXPSHZrk)
  .value("VGETEXPSHZrkz", LIEF::assembly::x86::OPCODE::VGETEXPSHZrkz)
  .value("VGETEXPSSZm", LIEF::assembly::x86::OPCODE::VGETEXPSSZm)
  .value("VGETEXPSSZmk", LIEF::assembly::x86::OPCODE::VGETEXPSSZmk)
  .value("VGETEXPSSZmkz", LIEF::assembly::x86::OPCODE::VGETEXPSSZmkz)
  .value("VGETEXPSSZr", LIEF::assembly::x86::OPCODE::VGETEXPSSZr)
  .value("VGETEXPSSZrb", LIEF::assembly::x86::OPCODE::VGETEXPSSZrb)
  .value("VGETEXPSSZrbk", LIEF::assembly::x86::OPCODE::VGETEXPSSZrbk)
  .value("VGETEXPSSZrbkz", LIEF::assembly::x86::OPCODE::VGETEXPSSZrbkz)
  .value("VGETEXPSSZrk", LIEF::assembly::x86::OPCODE::VGETEXPSSZrk)
  .value("VGETEXPSSZrkz", LIEF::assembly::x86::OPCODE::VGETEXPSSZrkz)
  .value("VGETMANTBF16Z128rmbi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmbi)
  .value("VGETMANTBF16Z128rmbik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmbik)
  .value("VGETMANTBF16Z128rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmbikz)
  .value("VGETMANTBF16Z128rmi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmi)
  .value("VGETMANTBF16Z128rmik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmik)
  .value("VGETMANTBF16Z128rmikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rmikz)
  .value("VGETMANTBF16Z128rri", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rri)
  .value("VGETMANTBF16Z128rrik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rrik)
  .value("VGETMANTBF16Z128rrikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z128rrikz)
  .value("VGETMANTBF16Z256rmbi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmbi)
  .value("VGETMANTBF16Z256rmbik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmbik)
  .value("VGETMANTBF16Z256rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmbikz)
  .value("VGETMANTBF16Z256rmi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmi)
  .value("VGETMANTBF16Z256rmik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmik)
  .value("VGETMANTBF16Z256rmikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rmikz)
  .value("VGETMANTBF16Z256rri", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rri)
  .value("VGETMANTBF16Z256rrik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rrik)
  .value("VGETMANTBF16Z256rrikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Z256rrikz)
  .value("VGETMANTBF16Zrmbi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmbi)
  .value("VGETMANTBF16Zrmbik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmbik)
  .value("VGETMANTBF16Zrmbikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmbikz)
  .value("VGETMANTBF16Zrmi", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmi)
  .value("VGETMANTBF16Zrmik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmik)
  .value("VGETMANTBF16Zrmikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrmikz)
  .value("VGETMANTBF16Zrri", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrri)
  .value("VGETMANTBF16Zrrik", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrrik)
  .value("VGETMANTBF16Zrrikz", LIEF::assembly::x86::OPCODE::VGETMANTBF16Zrrikz)
  .value("VGETMANTPDZ128rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmbi)
  .value("VGETMANTPDZ128rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmbik)
  .value("VGETMANTPDZ128rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmbikz)
  .value("VGETMANTPDZ128rmi", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmi)
  .value("VGETMANTPDZ128rmik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmik)
  .value("VGETMANTPDZ128rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rmikz)
  .value("VGETMANTPDZ128rri", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rri)
  .value("VGETMANTPDZ128rrik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rrik)
  .value("VGETMANTPDZ128rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ128rrikz)
  .value("VGETMANTPDZ256rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmbi)
  .value("VGETMANTPDZ256rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmbik)
  .value("VGETMANTPDZ256rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmbikz)
  .value("VGETMANTPDZ256rmi", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmi)
  .value("VGETMANTPDZ256rmik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmik)
  .value("VGETMANTPDZ256rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rmikz)
  .value("VGETMANTPDZ256rri", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rri)
  .value("VGETMANTPDZ256rrik", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rrik)
  .value("VGETMANTPDZ256rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZ256rrikz)
  .value("VGETMANTPDZrmbi", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmbi)
  .value("VGETMANTPDZrmbik", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmbik)
  .value("VGETMANTPDZrmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmbikz)
  .value("VGETMANTPDZrmi", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmi)
  .value("VGETMANTPDZrmik", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmik)
  .value("VGETMANTPDZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZrmikz)
  .value("VGETMANTPDZrri", LIEF::assembly::x86::OPCODE::VGETMANTPDZrri)
  .value("VGETMANTPDZrrib", LIEF::assembly::x86::OPCODE::VGETMANTPDZrrib)
  .value("VGETMANTPDZrribk", LIEF::assembly::x86::OPCODE::VGETMANTPDZrribk)
  .value("VGETMANTPDZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTPDZrribkz)
  .value("VGETMANTPDZrrik", LIEF::assembly::x86::OPCODE::VGETMANTPDZrrik)
  .value("VGETMANTPDZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTPDZrrikz)
  .value("VGETMANTPHZ128rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmbi)
  .value("VGETMANTPHZ128rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmbik)
  .value("VGETMANTPHZ128rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmbikz)
  .value("VGETMANTPHZ128rmi", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmi)
  .value("VGETMANTPHZ128rmik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmik)
  .value("VGETMANTPHZ128rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rmikz)
  .value("VGETMANTPHZ128rri", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rri)
  .value("VGETMANTPHZ128rrik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rrik)
  .value("VGETMANTPHZ128rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ128rrikz)
  .value("VGETMANTPHZ256rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmbi)
  .value("VGETMANTPHZ256rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmbik)
  .value("VGETMANTPHZ256rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmbikz)
  .value("VGETMANTPHZ256rmi", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmi)
  .value("VGETMANTPHZ256rmik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmik)
  .value("VGETMANTPHZ256rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rmikz)
  .value("VGETMANTPHZ256rri", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rri)
  .value("VGETMANTPHZ256rrik", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rrik)
  .value("VGETMANTPHZ256rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZ256rrikz)
  .value("VGETMANTPHZrmbi", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmbi)
  .value("VGETMANTPHZrmbik", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmbik)
  .value("VGETMANTPHZrmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmbikz)
  .value("VGETMANTPHZrmi", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmi)
  .value("VGETMANTPHZrmik", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmik)
  .value("VGETMANTPHZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZrmikz)
  .value("VGETMANTPHZrri", LIEF::assembly::x86::OPCODE::VGETMANTPHZrri)
  .value("VGETMANTPHZrrib", LIEF::assembly::x86::OPCODE::VGETMANTPHZrrib)
  .value("VGETMANTPHZrribk", LIEF::assembly::x86::OPCODE::VGETMANTPHZrribk)
  .value("VGETMANTPHZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTPHZrribkz)
  .value("VGETMANTPHZrrik", LIEF::assembly::x86::OPCODE::VGETMANTPHZrrik)
  .value("VGETMANTPHZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTPHZrrikz)
  .value("VGETMANTPSZ128rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmbi)
  .value("VGETMANTPSZ128rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmbik)
  .value("VGETMANTPSZ128rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmbikz)
  .value("VGETMANTPSZ128rmi", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmi)
  .value("VGETMANTPSZ128rmik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmik)
  .value("VGETMANTPSZ128rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rmikz)
  .value("VGETMANTPSZ128rri", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rri)
  .value("VGETMANTPSZ128rrik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rrik)
  .value("VGETMANTPSZ128rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ128rrikz)
  .value("VGETMANTPSZ256rmbi", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmbi)
  .value("VGETMANTPSZ256rmbik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmbik)
  .value("VGETMANTPSZ256rmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmbikz)
  .value("VGETMANTPSZ256rmi", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmi)
  .value("VGETMANTPSZ256rmik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmik)
  .value("VGETMANTPSZ256rmikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rmikz)
  .value("VGETMANTPSZ256rri", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rri)
  .value("VGETMANTPSZ256rrik", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rrik)
  .value("VGETMANTPSZ256rrikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZ256rrikz)
  .value("VGETMANTPSZrmbi", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmbi)
  .value("VGETMANTPSZrmbik", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmbik)
  .value("VGETMANTPSZrmbikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmbikz)
  .value("VGETMANTPSZrmi", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmi)
  .value("VGETMANTPSZrmik", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmik)
  .value("VGETMANTPSZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZrmikz)
  .value("VGETMANTPSZrri", LIEF::assembly::x86::OPCODE::VGETMANTPSZrri)
  .value("VGETMANTPSZrrib", LIEF::assembly::x86::OPCODE::VGETMANTPSZrrib)
  .value("VGETMANTPSZrribk", LIEF::assembly::x86::OPCODE::VGETMANTPSZrribk)
  .value("VGETMANTPSZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTPSZrribkz)
  .value("VGETMANTPSZrrik", LIEF::assembly::x86::OPCODE::VGETMANTPSZrrik)
  .value("VGETMANTPSZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTPSZrrikz)
  .value("VGETMANTSDZrmi", LIEF::assembly::x86::OPCODE::VGETMANTSDZrmi)
  .value("VGETMANTSDZrmik", LIEF::assembly::x86::OPCODE::VGETMANTSDZrmik)
  .value("VGETMANTSDZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTSDZrmikz)
  .value("VGETMANTSDZrri", LIEF::assembly::x86::OPCODE::VGETMANTSDZrri)
  .value("VGETMANTSDZrrib", LIEF::assembly::x86::OPCODE::VGETMANTSDZrrib)
  .value("VGETMANTSDZrribk", LIEF::assembly::x86::OPCODE::VGETMANTSDZrribk)
  .value("VGETMANTSDZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTSDZrribkz)
  .value("VGETMANTSDZrrik", LIEF::assembly::x86::OPCODE::VGETMANTSDZrrik)
  .value("VGETMANTSDZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTSDZrrikz)
  .value("VGETMANTSHZrmi", LIEF::assembly::x86::OPCODE::VGETMANTSHZrmi)
  .value("VGETMANTSHZrmik", LIEF::assembly::x86::OPCODE::VGETMANTSHZrmik)
  .value("VGETMANTSHZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTSHZrmikz)
  .value("VGETMANTSHZrri", LIEF::assembly::x86::OPCODE::VGETMANTSHZrri)
  .value("VGETMANTSHZrrib", LIEF::assembly::x86::OPCODE::VGETMANTSHZrrib)
  .value("VGETMANTSHZrribk", LIEF::assembly::x86::OPCODE::VGETMANTSHZrribk)
  .value("VGETMANTSHZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTSHZrribkz)
  .value("VGETMANTSHZrrik", LIEF::assembly::x86::OPCODE::VGETMANTSHZrrik)
  .value("VGETMANTSHZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTSHZrrikz)
  .value("VGETMANTSSZrmi", LIEF::assembly::x86::OPCODE::VGETMANTSSZrmi)
  .value("VGETMANTSSZrmik", LIEF::assembly::x86::OPCODE::VGETMANTSSZrmik)
  .value("VGETMANTSSZrmikz", LIEF::assembly::x86::OPCODE::VGETMANTSSZrmikz)
  .value("VGETMANTSSZrri", LIEF::assembly::x86::OPCODE::VGETMANTSSZrri)
  .value("VGETMANTSSZrrib", LIEF::assembly::x86::OPCODE::VGETMANTSSZrrib)
  .value("VGETMANTSSZrribk", LIEF::assembly::x86::OPCODE::VGETMANTSSZrribk)
  .value("VGETMANTSSZrribkz", LIEF::assembly::x86::OPCODE::VGETMANTSSZrribkz)
  .value("VGETMANTSSZrrik", LIEF::assembly::x86::OPCODE::VGETMANTSSZrrik)
  .value("VGETMANTSSZrrikz", LIEF::assembly::x86::OPCODE::VGETMANTSSZrrikz)
  .value("VGF2P8AFFINEINVQBYrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBYrmi);
  opcodes.value("VGF2P8AFFINEINVQBYrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBYrri)
  .value("VGF2P8AFFINEINVQBZ128rmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmbi)
  .value("VGF2P8AFFINEINVQBZ128rmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmbik)
  .value("VGF2P8AFFINEINVQBZ128rmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmbikz)
  .value("VGF2P8AFFINEINVQBZ128rmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmi)
  .value("VGF2P8AFFINEINVQBZ128rmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmik)
  .value("VGF2P8AFFINEINVQBZ128rmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rmikz)
  .value("VGF2P8AFFINEINVQBZ128rri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rri)
  .value("VGF2P8AFFINEINVQBZ128rrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rrik)
  .value("VGF2P8AFFINEINVQBZ128rrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ128rrikz)
  .value("VGF2P8AFFINEINVQBZ256rmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmbi)
  .value("VGF2P8AFFINEINVQBZ256rmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmbik)
  .value("VGF2P8AFFINEINVQBZ256rmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmbikz)
  .value("VGF2P8AFFINEINVQBZ256rmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmi)
  .value("VGF2P8AFFINEINVQBZ256rmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmik)
  .value("VGF2P8AFFINEINVQBZ256rmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rmikz)
  .value("VGF2P8AFFINEINVQBZ256rri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rri)
  .value("VGF2P8AFFINEINVQBZ256rrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rrik)
  .value("VGF2P8AFFINEINVQBZ256rrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZ256rrikz)
  .value("VGF2P8AFFINEINVQBZrmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmbi)
  .value("VGF2P8AFFINEINVQBZrmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmbik)
  .value("VGF2P8AFFINEINVQBZrmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmbikz)
  .value("VGF2P8AFFINEINVQBZrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmi)
  .value("VGF2P8AFFINEINVQBZrmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmik)
  .value("VGF2P8AFFINEINVQBZrmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrmikz)
  .value("VGF2P8AFFINEINVQBZrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrri)
  .value("VGF2P8AFFINEINVQBZrrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrrik)
  .value("VGF2P8AFFINEINVQBZrrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBZrrikz)
  .value("VGF2P8AFFINEINVQBrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBrmi)
  .value("VGF2P8AFFINEINVQBrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEINVQBrri)
  .value("VGF2P8AFFINEQBYrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBYrmi)
  .value("VGF2P8AFFINEQBYrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBYrri)
  .value("VGF2P8AFFINEQBZ128rmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmbi)
  .value("VGF2P8AFFINEQBZ128rmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmbik)
  .value("VGF2P8AFFINEQBZ128rmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmbikz)
  .value("VGF2P8AFFINEQBZ128rmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmi)
  .value("VGF2P8AFFINEQBZ128rmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmik)
  .value("VGF2P8AFFINEQBZ128rmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rmikz)
  .value("VGF2P8AFFINEQBZ128rri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rri)
  .value("VGF2P8AFFINEQBZ128rrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rrik)
  .value("VGF2P8AFFINEQBZ128rrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ128rrikz)
  .value("VGF2P8AFFINEQBZ256rmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmbi)
  .value("VGF2P8AFFINEQBZ256rmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmbik)
  .value("VGF2P8AFFINEQBZ256rmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmbikz)
  .value("VGF2P8AFFINEQBZ256rmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmi)
  .value("VGF2P8AFFINEQBZ256rmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmik)
  .value("VGF2P8AFFINEQBZ256rmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rmikz)
  .value("VGF2P8AFFINEQBZ256rri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rri)
  .value("VGF2P8AFFINEQBZ256rrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rrik)
  .value("VGF2P8AFFINEQBZ256rrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZ256rrikz)
  .value("VGF2P8AFFINEQBZrmbi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmbi)
  .value("VGF2P8AFFINEQBZrmbik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmbik)
  .value("VGF2P8AFFINEQBZrmbikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmbikz)
  .value("VGF2P8AFFINEQBZrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmi)
  .value("VGF2P8AFFINEQBZrmik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmik)
  .value("VGF2P8AFFINEQBZrmikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrmikz)
  .value("VGF2P8AFFINEQBZrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrri)
  .value("VGF2P8AFFINEQBZrrik", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrrik)
  .value("VGF2P8AFFINEQBZrrikz", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBZrrikz)
  .value("VGF2P8AFFINEQBrmi", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBrmi)
  .value("VGF2P8AFFINEQBrri", LIEF::assembly::x86::OPCODE::VGF2P8AFFINEQBrri)
  .value("VGF2P8MULBYrm", LIEF::assembly::x86::OPCODE::VGF2P8MULBYrm)
  .value("VGF2P8MULBYrr", LIEF::assembly::x86::OPCODE::VGF2P8MULBYrr)
  .value("VGF2P8MULBZ128rm", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rm)
  .value("VGF2P8MULBZ128rmk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rmk)
  .value("VGF2P8MULBZ128rmkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rmkz)
  .value("VGF2P8MULBZ128rr", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rr)
  .value("VGF2P8MULBZ128rrk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rrk)
  .value("VGF2P8MULBZ128rrkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ128rrkz)
  .value("VGF2P8MULBZ256rm", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rm)
  .value("VGF2P8MULBZ256rmk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rmk)
  .value("VGF2P8MULBZ256rmkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rmkz)
  .value("VGF2P8MULBZ256rr", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rr)
  .value("VGF2P8MULBZ256rrk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rrk)
  .value("VGF2P8MULBZ256rrkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZ256rrkz)
  .value("VGF2P8MULBZrm", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrm)
  .value("VGF2P8MULBZrmk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrmk)
  .value("VGF2P8MULBZrmkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrmkz)
  .value("VGF2P8MULBZrr", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrr)
  .value("VGF2P8MULBZrrk", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrrk)
  .value("VGF2P8MULBZrrkz", LIEF::assembly::x86::OPCODE::VGF2P8MULBZrrkz)
  .value("VGF2P8MULBrm", LIEF::assembly::x86::OPCODE::VGF2P8MULBrm)
  .value("VGF2P8MULBrr", LIEF::assembly::x86::OPCODE::VGF2P8MULBrr)
  .value("VHADDPDYrm", LIEF::assembly::x86::OPCODE::VHADDPDYrm)
  .value("VHADDPDYrr", LIEF::assembly::x86::OPCODE::VHADDPDYrr)
  .value("VHADDPDrm", LIEF::assembly::x86::OPCODE::VHADDPDrm)
  .value("VHADDPDrr", LIEF::assembly::x86::OPCODE::VHADDPDrr)
  .value("VHADDPSYrm", LIEF::assembly::x86::OPCODE::VHADDPSYrm)
  .value("VHADDPSYrr", LIEF::assembly::x86::OPCODE::VHADDPSYrr)
  .value("VHADDPSrm", LIEF::assembly::x86::OPCODE::VHADDPSrm)
  .value("VHADDPSrr", LIEF::assembly::x86::OPCODE::VHADDPSrr)
  .value("VHSUBPDYrm", LIEF::assembly::x86::OPCODE::VHSUBPDYrm)
  .value("VHSUBPDYrr", LIEF::assembly::x86::OPCODE::VHSUBPDYrr)
  .value("VHSUBPDrm", LIEF::assembly::x86::OPCODE::VHSUBPDrm)
  .value("VHSUBPDrr", LIEF::assembly::x86::OPCODE::VHSUBPDrr)
  .value("VHSUBPSYrm", LIEF::assembly::x86::OPCODE::VHSUBPSYrm)
  .value("VHSUBPSYrr", LIEF::assembly::x86::OPCODE::VHSUBPSYrr)
  .value("VHSUBPSrm", LIEF::assembly::x86::OPCODE::VHSUBPSrm)
  .value("VHSUBPSrr", LIEF::assembly::x86::OPCODE::VHSUBPSrr)
  .value("VINSERTF128rmi", LIEF::assembly::x86::OPCODE::VINSERTF128rmi)
  .value("VINSERTF128rri", LIEF::assembly::x86::OPCODE::VINSERTF128rri)
  .value("VINSERTF32X4Z256rmi", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rmi)
  .value("VINSERTF32X4Z256rmik", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rmik)
  .value("VINSERTF32X4Z256rmikz", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rmikz)
  .value("VINSERTF32X4Z256rri", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rri)
  .value("VINSERTF32X4Z256rrik", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rrik)
  .value("VINSERTF32X4Z256rrikz", LIEF::assembly::x86::OPCODE::VINSERTF32X4Z256rrikz)
  .value("VINSERTF32X4Zrmi", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrmi)
  .value("VINSERTF32X4Zrmik", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrmik)
  .value("VINSERTF32X4Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrmikz)
  .value("VINSERTF32X4Zrri", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrri)
  .value("VINSERTF32X4Zrrik", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrrik)
  .value("VINSERTF32X4Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTF32X4Zrrikz)
  .value("VINSERTF32X8Zrmi", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrmi)
  .value("VINSERTF32X8Zrmik", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrmik)
  .value("VINSERTF32X8Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrmikz)
  .value("VINSERTF32X8Zrri", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrri)
  .value("VINSERTF32X8Zrrik", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrrik)
  .value("VINSERTF32X8Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTF32X8Zrrikz)
  .value("VINSERTF64X2Z256rmi", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rmi)
  .value("VINSERTF64X2Z256rmik", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rmik)
  .value("VINSERTF64X2Z256rmikz", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rmikz)
  .value("VINSERTF64X2Z256rri", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rri)
  .value("VINSERTF64X2Z256rrik", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rrik)
  .value("VINSERTF64X2Z256rrikz", LIEF::assembly::x86::OPCODE::VINSERTF64X2Z256rrikz)
  .value("VINSERTF64X2Zrmi", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrmi)
  .value("VINSERTF64X2Zrmik", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrmik)
  .value("VINSERTF64X2Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrmikz)
  .value("VINSERTF64X2Zrri", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrri)
  .value("VINSERTF64X2Zrrik", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrrik)
  .value("VINSERTF64X2Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTF64X2Zrrikz)
  .value("VINSERTF64X4Zrmi", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrmi)
  .value("VINSERTF64X4Zrmik", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrmik)
  .value("VINSERTF64X4Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrmikz)
  .value("VINSERTF64X4Zrri", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrri)
  .value("VINSERTF64X4Zrrik", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrrik)
  .value("VINSERTF64X4Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTF64X4Zrrikz)
  .value("VINSERTI128rmi", LIEF::assembly::x86::OPCODE::VINSERTI128rmi)
  .value("VINSERTI128rri", LIEF::assembly::x86::OPCODE::VINSERTI128rri)
  .value("VINSERTI32X4Z256rmi", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rmi)
  .value("VINSERTI32X4Z256rmik", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rmik)
  .value("VINSERTI32X4Z256rmikz", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rmikz)
  .value("VINSERTI32X4Z256rri", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rri)
  .value("VINSERTI32X4Z256rrik", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rrik)
  .value("VINSERTI32X4Z256rrikz", LIEF::assembly::x86::OPCODE::VINSERTI32X4Z256rrikz)
  .value("VINSERTI32X4Zrmi", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrmi)
  .value("VINSERTI32X4Zrmik", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrmik)
  .value("VINSERTI32X4Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrmikz)
  .value("VINSERTI32X4Zrri", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrri)
  .value("VINSERTI32X4Zrrik", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrrik)
  .value("VINSERTI32X4Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTI32X4Zrrikz)
  .value("VINSERTI32X8Zrmi", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrmi)
  .value("VINSERTI32X8Zrmik", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrmik)
  .value("VINSERTI32X8Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrmikz)
  .value("VINSERTI32X8Zrri", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrri)
  .value("VINSERTI32X8Zrrik", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrrik)
  .value("VINSERTI32X8Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTI32X8Zrrikz)
  .value("VINSERTI64X2Z256rmi", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rmi)
  .value("VINSERTI64X2Z256rmik", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rmik)
  .value("VINSERTI64X2Z256rmikz", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rmikz)
  .value("VINSERTI64X2Z256rri", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rri)
  .value("VINSERTI64X2Z256rrik", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rrik)
  .value("VINSERTI64X2Z256rrikz", LIEF::assembly::x86::OPCODE::VINSERTI64X2Z256rrikz)
  .value("VINSERTI64X2Zrmi", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrmi)
  .value("VINSERTI64X2Zrmik", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrmik)
  .value("VINSERTI64X2Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrmikz)
  .value("VINSERTI64X2Zrri", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrri)
  .value("VINSERTI64X2Zrrik", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrrik)
  .value("VINSERTI64X2Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTI64X2Zrrikz)
  .value("VINSERTI64X4Zrmi", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrmi)
  .value("VINSERTI64X4Zrmik", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrmik)
  .value("VINSERTI64X4Zrmikz", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrmikz)
  .value("VINSERTI64X4Zrri", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrri)
  .value("VINSERTI64X4Zrrik", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrrik)
  .value("VINSERTI64X4Zrrikz", LIEF::assembly::x86::OPCODE::VINSERTI64X4Zrrikz)
  .value("VINSERTPSZrmi", LIEF::assembly::x86::OPCODE::VINSERTPSZrmi)
  .value("VINSERTPSZrri", LIEF::assembly::x86::OPCODE::VINSERTPSZrri)
  .value("VINSERTPSrmi", LIEF::assembly::x86::OPCODE::VINSERTPSrmi)
  .value("VINSERTPSrri", LIEF::assembly::x86::OPCODE::VINSERTPSrri)
  .value("VLDDQUYrm", LIEF::assembly::x86::OPCODE::VLDDQUYrm)
  .value("VLDDQUrm", LIEF::assembly::x86::OPCODE::VLDDQUrm)
  .value("VLDMXCSR", LIEF::assembly::x86::OPCODE::VLDMXCSR)
  .value("VMASKMOVDQU", LIEF::assembly::x86::OPCODE::VMASKMOVDQU)
  .value("VMASKMOVDQU64", LIEF::assembly::x86::OPCODE::VMASKMOVDQU64)
  .value("VMASKMOVPDYmr", LIEF::assembly::x86::OPCODE::VMASKMOVPDYmr)
  .value("VMASKMOVPDYrm", LIEF::assembly::x86::OPCODE::VMASKMOVPDYrm)
  .value("VMASKMOVPDmr", LIEF::assembly::x86::OPCODE::VMASKMOVPDmr)
  .value("VMASKMOVPDrm", LIEF::assembly::x86::OPCODE::VMASKMOVPDrm)
  .value("VMASKMOVPSYmr", LIEF::assembly::x86::OPCODE::VMASKMOVPSYmr)
  .value("VMASKMOVPSYrm", LIEF::assembly::x86::OPCODE::VMASKMOVPSYrm)
  .value("VMASKMOVPSmr", LIEF::assembly::x86::OPCODE::VMASKMOVPSmr)
  .value("VMASKMOVPSrm", LIEF::assembly::x86::OPCODE::VMASKMOVPSrm)
  .value("VMAXBF16Z128rm", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rm)
  .value("VMAXBF16Z128rmb", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rmb)
  .value("VMAXBF16Z128rmbk", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rmbk)
  .value("VMAXBF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rmbkz)
  .value("VMAXBF16Z128rmk", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rmk)
  .value("VMAXBF16Z128rmkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rmkz)
  .value("VMAXBF16Z128rr", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rr)
  .value("VMAXBF16Z128rrk", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rrk)
  .value("VMAXBF16Z128rrkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z128rrkz)
  .value("VMAXBF16Z256rm", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rm)
  .value("VMAXBF16Z256rmb", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rmb)
  .value("VMAXBF16Z256rmbk", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rmbk)
  .value("VMAXBF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rmbkz)
  .value("VMAXBF16Z256rmk", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rmk)
  .value("VMAXBF16Z256rmkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rmkz)
  .value("VMAXBF16Z256rr", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rr)
  .value("VMAXBF16Z256rrk", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rrk)
  .value("VMAXBF16Z256rrkz", LIEF::assembly::x86::OPCODE::VMAXBF16Z256rrkz)
  .value("VMAXBF16Zrm", LIEF::assembly::x86::OPCODE::VMAXBF16Zrm)
  .value("VMAXBF16Zrmb", LIEF::assembly::x86::OPCODE::VMAXBF16Zrmb)
  .value("VMAXBF16Zrmbk", LIEF::assembly::x86::OPCODE::VMAXBF16Zrmbk)
  .value("VMAXBF16Zrmbkz", LIEF::assembly::x86::OPCODE::VMAXBF16Zrmbkz)
  .value("VMAXBF16Zrmk", LIEF::assembly::x86::OPCODE::VMAXBF16Zrmk)
  .value("VMAXBF16Zrmkz", LIEF::assembly::x86::OPCODE::VMAXBF16Zrmkz)
  .value("VMAXBF16Zrr", LIEF::assembly::x86::OPCODE::VMAXBF16Zrr)
  .value("VMAXBF16Zrrk", LIEF::assembly::x86::OPCODE::VMAXBF16Zrrk)
  .value("VMAXBF16Zrrkz", LIEF::assembly::x86::OPCODE::VMAXBF16Zrrkz)
  .value("VMAXCPDYrm", LIEF::assembly::x86::OPCODE::VMAXCPDYrm)
  .value("VMAXCPDYrr", LIEF::assembly::x86::OPCODE::VMAXCPDYrr)
  .value("VMAXCPDZ128rm", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rm)
  .value("VMAXCPDZ128rmb", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rmb)
  .value("VMAXCPDZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rmbk)
  .value("VMAXCPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rmbkz)
  .value("VMAXCPDZ128rmk", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rmk)
  .value("VMAXCPDZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rmkz)
  .value("VMAXCPDZ128rr", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rr)
  .value("VMAXCPDZ128rrk", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rrk)
  .value("VMAXCPDZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ128rrkz)
  .value("VMAXCPDZ256rm", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rm)
  .value("VMAXCPDZ256rmb", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rmb)
  .value("VMAXCPDZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rmbk)
  .value("VMAXCPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rmbkz)
  .value("VMAXCPDZ256rmk", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rmk)
  .value("VMAXCPDZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rmkz)
  .value("VMAXCPDZ256rr", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rr)
  .value("VMAXCPDZ256rrk", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rrk)
  .value("VMAXCPDZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXCPDZ256rrkz)
  .value("VMAXCPDZrm", LIEF::assembly::x86::OPCODE::VMAXCPDZrm)
  .value("VMAXCPDZrmb", LIEF::assembly::x86::OPCODE::VMAXCPDZrmb)
  .value("VMAXCPDZrmbk", LIEF::assembly::x86::OPCODE::VMAXCPDZrmbk)
  .value("VMAXCPDZrmbkz", LIEF::assembly::x86::OPCODE::VMAXCPDZrmbkz)
  .value("VMAXCPDZrmk", LIEF::assembly::x86::OPCODE::VMAXCPDZrmk)
  .value("VMAXCPDZrmkz", LIEF::assembly::x86::OPCODE::VMAXCPDZrmkz)
  .value("VMAXCPDZrr", LIEF::assembly::x86::OPCODE::VMAXCPDZrr)
  .value("VMAXCPDZrrk", LIEF::assembly::x86::OPCODE::VMAXCPDZrrk)
  .value("VMAXCPDZrrkz", LIEF::assembly::x86::OPCODE::VMAXCPDZrrkz)
  .value("VMAXCPDrm", LIEF::assembly::x86::OPCODE::VMAXCPDrm)
  .value("VMAXCPDrr", LIEF::assembly::x86::OPCODE::VMAXCPDrr)
  .value("VMAXCPHZ128rm", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rm)
  .value("VMAXCPHZ128rmb", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rmb)
  .value("VMAXCPHZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rmbk)
  .value("VMAXCPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rmbkz)
  .value("VMAXCPHZ128rmk", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rmk)
  .value("VMAXCPHZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rmkz)
  .value("VMAXCPHZ128rr", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rr)
  .value("VMAXCPHZ128rrk", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rrk)
  .value("VMAXCPHZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ128rrkz)
  .value("VMAXCPHZ256rm", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rm)
  .value("VMAXCPHZ256rmb", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rmb)
  .value("VMAXCPHZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rmbk)
  .value("VMAXCPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rmbkz)
  .value("VMAXCPHZ256rmk", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rmk)
  .value("VMAXCPHZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rmkz)
  .value("VMAXCPHZ256rr", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rr)
  .value("VMAXCPHZ256rrk", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rrk)
  .value("VMAXCPHZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXCPHZ256rrkz)
  .value("VMAXCPHZrm", LIEF::assembly::x86::OPCODE::VMAXCPHZrm)
  .value("VMAXCPHZrmb", LIEF::assembly::x86::OPCODE::VMAXCPHZrmb)
  .value("VMAXCPHZrmbk", LIEF::assembly::x86::OPCODE::VMAXCPHZrmbk)
  .value("VMAXCPHZrmbkz", LIEF::assembly::x86::OPCODE::VMAXCPHZrmbkz)
  .value("VMAXCPHZrmk", LIEF::assembly::x86::OPCODE::VMAXCPHZrmk)
  .value("VMAXCPHZrmkz", LIEF::assembly::x86::OPCODE::VMAXCPHZrmkz)
  .value("VMAXCPHZrr", LIEF::assembly::x86::OPCODE::VMAXCPHZrr)
  .value("VMAXCPHZrrk", LIEF::assembly::x86::OPCODE::VMAXCPHZrrk)
  .value("VMAXCPHZrrkz", LIEF::assembly::x86::OPCODE::VMAXCPHZrrkz)
  .value("VMAXCPSYrm", LIEF::assembly::x86::OPCODE::VMAXCPSYrm)
  .value("VMAXCPSYrr", LIEF::assembly::x86::OPCODE::VMAXCPSYrr)
  .value("VMAXCPSZ128rm", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rm)
  .value("VMAXCPSZ128rmb", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rmb)
  .value("VMAXCPSZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rmbk)
  .value("VMAXCPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rmbkz)
  .value("VMAXCPSZ128rmk", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rmk)
  .value("VMAXCPSZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rmkz)
  .value("VMAXCPSZ128rr", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rr)
  .value("VMAXCPSZ128rrk", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rrk)
  .value("VMAXCPSZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ128rrkz)
  .value("VMAXCPSZ256rm", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rm)
  .value("VMAXCPSZ256rmb", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rmb)
  .value("VMAXCPSZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rmbk)
  .value("VMAXCPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rmbkz)
  .value("VMAXCPSZ256rmk", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rmk)
  .value("VMAXCPSZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rmkz)
  .value("VMAXCPSZ256rr", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rr)
  .value("VMAXCPSZ256rrk", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rrk)
  .value("VMAXCPSZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXCPSZ256rrkz)
  .value("VMAXCPSZrm", LIEF::assembly::x86::OPCODE::VMAXCPSZrm)
  .value("VMAXCPSZrmb", LIEF::assembly::x86::OPCODE::VMAXCPSZrmb)
  .value("VMAXCPSZrmbk", LIEF::assembly::x86::OPCODE::VMAXCPSZrmbk);
  opcodes.value("VMAXCPSZrmbkz", LIEF::assembly::x86::OPCODE::VMAXCPSZrmbkz)
  .value("VMAXCPSZrmk", LIEF::assembly::x86::OPCODE::VMAXCPSZrmk)
  .value("VMAXCPSZrmkz", LIEF::assembly::x86::OPCODE::VMAXCPSZrmkz)
  .value("VMAXCPSZrr", LIEF::assembly::x86::OPCODE::VMAXCPSZrr)
  .value("VMAXCPSZrrk", LIEF::assembly::x86::OPCODE::VMAXCPSZrrk)
  .value("VMAXCPSZrrkz", LIEF::assembly::x86::OPCODE::VMAXCPSZrrkz)
  .value("VMAXCPSrm", LIEF::assembly::x86::OPCODE::VMAXCPSrm)
  .value("VMAXCPSrr", LIEF::assembly::x86::OPCODE::VMAXCPSrr)
  .value("VMAXCSDZrm", LIEF::assembly::x86::OPCODE::VMAXCSDZrm)
  .value("VMAXCSDZrr", LIEF::assembly::x86::OPCODE::VMAXCSDZrr)
  .value("VMAXCSDrm", LIEF::assembly::x86::OPCODE::VMAXCSDrm)
  .value("VMAXCSDrr", LIEF::assembly::x86::OPCODE::VMAXCSDrr)
  .value("VMAXCSHZrm", LIEF::assembly::x86::OPCODE::VMAXCSHZrm)
  .value("VMAXCSHZrr", LIEF::assembly::x86::OPCODE::VMAXCSHZrr)
  .value("VMAXCSSZrm", LIEF::assembly::x86::OPCODE::VMAXCSSZrm)
  .value("VMAXCSSZrr", LIEF::assembly::x86::OPCODE::VMAXCSSZrr)
  .value("VMAXCSSrm", LIEF::assembly::x86::OPCODE::VMAXCSSrm)
  .value("VMAXCSSrr", LIEF::assembly::x86::OPCODE::VMAXCSSrr)
  .value("VMAXPDYrm", LIEF::assembly::x86::OPCODE::VMAXPDYrm)
  .value("VMAXPDYrr", LIEF::assembly::x86::OPCODE::VMAXPDYrr)
  .value("VMAXPDZ128rm", LIEF::assembly::x86::OPCODE::VMAXPDZ128rm)
  .value("VMAXPDZ128rmb", LIEF::assembly::x86::OPCODE::VMAXPDZ128rmb)
  .value("VMAXPDZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXPDZ128rmbk)
  .value("VMAXPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXPDZ128rmbkz)
  .value("VMAXPDZ128rmk", LIEF::assembly::x86::OPCODE::VMAXPDZ128rmk)
  .value("VMAXPDZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXPDZ128rmkz)
  .value("VMAXPDZ128rr", LIEF::assembly::x86::OPCODE::VMAXPDZ128rr)
  .value("VMAXPDZ128rrk", LIEF::assembly::x86::OPCODE::VMAXPDZ128rrk)
  .value("VMAXPDZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXPDZ128rrkz)
  .value("VMAXPDZ256rm", LIEF::assembly::x86::OPCODE::VMAXPDZ256rm)
  .value("VMAXPDZ256rmb", LIEF::assembly::x86::OPCODE::VMAXPDZ256rmb)
  .value("VMAXPDZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXPDZ256rmbk)
  .value("VMAXPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXPDZ256rmbkz)
  .value("VMAXPDZ256rmk", LIEF::assembly::x86::OPCODE::VMAXPDZ256rmk)
  .value("VMAXPDZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXPDZ256rmkz)
  .value("VMAXPDZ256rr", LIEF::assembly::x86::OPCODE::VMAXPDZ256rr)
  .value("VMAXPDZ256rrk", LIEF::assembly::x86::OPCODE::VMAXPDZ256rrk)
  .value("VMAXPDZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXPDZ256rrkz)
  .value("VMAXPDZrm", LIEF::assembly::x86::OPCODE::VMAXPDZrm)
  .value("VMAXPDZrmb", LIEF::assembly::x86::OPCODE::VMAXPDZrmb)
  .value("VMAXPDZrmbk", LIEF::assembly::x86::OPCODE::VMAXPDZrmbk)
  .value("VMAXPDZrmbkz", LIEF::assembly::x86::OPCODE::VMAXPDZrmbkz)
  .value("VMAXPDZrmk", LIEF::assembly::x86::OPCODE::VMAXPDZrmk)
  .value("VMAXPDZrmkz", LIEF::assembly::x86::OPCODE::VMAXPDZrmkz)
  .value("VMAXPDZrr", LIEF::assembly::x86::OPCODE::VMAXPDZrr)
  .value("VMAXPDZrrb", LIEF::assembly::x86::OPCODE::VMAXPDZrrb)
  .value("VMAXPDZrrbk", LIEF::assembly::x86::OPCODE::VMAXPDZrrbk)
  .value("VMAXPDZrrbkz", LIEF::assembly::x86::OPCODE::VMAXPDZrrbkz)
  .value("VMAXPDZrrk", LIEF::assembly::x86::OPCODE::VMAXPDZrrk)
  .value("VMAXPDZrrkz", LIEF::assembly::x86::OPCODE::VMAXPDZrrkz)
  .value("VMAXPDrm", LIEF::assembly::x86::OPCODE::VMAXPDrm)
  .value("VMAXPDrr", LIEF::assembly::x86::OPCODE::VMAXPDrr)
  .value("VMAXPHZ128rm", LIEF::assembly::x86::OPCODE::VMAXPHZ128rm)
  .value("VMAXPHZ128rmb", LIEF::assembly::x86::OPCODE::VMAXPHZ128rmb)
  .value("VMAXPHZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXPHZ128rmbk)
  .value("VMAXPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXPHZ128rmbkz)
  .value("VMAXPHZ128rmk", LIEF::assembly::x86::OPCODE::VMAXPHZ128rmk)
  .value("VMAXPHZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXPHZ128rmkz)
  .value("VMAXPHZ128rr", LIEF::assembly::x86::OPCODE::VMAXPHZ128rr)
  .value("VMAXPHZ128rrk", LIEF::assembly::x86::OPCODE::VMAXPHZ128rrk)
  .value("VMAXPHZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXPHZ128rrkz)
  .value("VMAXPHZ256rm", LIEF::assembly::x86::OPCODE::VMAXPHZ256rm)
  .value("VMAXPHZ256rmb", LIEF::assembly::x86::OPCODE::VMAXPHZ256rmb)
  .value("VMAXPHZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXPHZ256rmbk)
  .value("VMAXPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXPHZ256rmbkz)
  .value("VMAXPHZ256rmk", LIEF::assembly::x86::OPCODE::VMAXPHZ256rmk)
  .value("VMAXPHZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXPHZ256rmkz)
  .value("VMAXPHZ256rr", LIEF::assembly::x86::OPCODE::VMAXPHZ256rr)
  .value("VMAXPHZ256rrk", LIEF::assembly::x86::OPCODE::VMAXPHZ256rrk)
  .value("VMAXPHZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXPHZ256rrkz)
  .value("VMAXPHZrm", LIEF::assembly::x86::OPCODE::VMAXPHZrm)
  .value("VMAXPHZrmb", LIEF::assembly::x86::OPCODE::VMAXPHZrmb)
  .value("VMAXPHZrmbk", LIEF::assembly::x86::OPCODE::VMAXPHZrmbk)
  .value("VMAXPHZrmbkz", LIEF::assembly::x86::OPCODE::VMAXPHZrmbkz)
  .value("VMAXPHZrmk", LIEF::assembly::x86::OPCODE::VMAXPHZrmk)
  .value("VMAXPHZrmkz", LIEF::assembly::x86::OPCODE::VMAXPHZrmkz)
  .value("VMAXPHZrr", LIEF::assembly::x86::OPCODE::VMAXPHZrr)
  .value("VMAXPHZrrb", LIEF::assembly::x86::OPCODE::VMAXPHZrrb)
  .value("VMAXPHZrrbk", LIEF::assembly::x86::OPCODE::VMAXPHZrrbk)
  .value("VMAXPHZrrbkz", LIEF::assembly::x86::OPCODE::VMAXPHZrrbkz)
  .value("VMAXPHZrrk", LIEF::assembly::x86::OPCODE::VMAXPHZrrk)
  .value("VMAXPHZrrkz", LIEF::assembly::x86::OPCODE::VMAXPHZrrkz)
  .value("VMAXPSYrm", LIEF::assembly::x86::OPCODE::VMAXPSYrm)
  .value("VMAXPSYrr", LIEF::assembly::x86::OPCODE::VMAXPSYrr)
  .value("VMAXPSZ128rm", LIEF::assembly::x86::OPCODE::VMAXPSZ128rm)
  .value("VMAXPSZ128rmb", LIEF::assembly::x86::OPCODE::VMAXPSZ128rmb)
  .value("VMAXPSZ128rmbk", LIEF::assembly::x86::OPCODE::VMAXPSZ128rmbk)
  .value("VMAXPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VMAXPSZ128rmbkz)
  .value("VMAXPSZ128rmk", LIEF::assembly::x86::OPCODE::VMAXPSZ128rmk)
  .value("VMAXPSZ128rmkz", LIEF::assembly::x86::OPCODE::VMAXPSZ128rmkz)
  .value("VMAXPSZ128rr", LIEF::assembly::x86::OPCODE::VMAXPSZ128rr)
  .value("VMAXPSZ128rrk", LIEF::assembly::x86::OPCODE::VMAXPSZ128rrk)
  .value("VMAXPSZ128rrkz", LIEF::assembly::x86::OPCODE::VMAXPSZ128rrkz)
  .value("VMAXPSZ256rm", LIEF::assembly::x86::OPCODE::VMAXPSZ256rm)
  .value("VMAXPSZ256rmb", LIEF::assembly::x86::OPCODE::VMAXPSZ256rmb)
  .value("VMAXPSZ256rmbk", LIEF::assembly::x86::OPCODE::VMAXPSZ256rmbk)
  .value("VMAXPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VMAXPSZ256rmbkz)
  .value("VMAXPSZ256rmk", LIEF::assembly::x86::OPCODE::VMAXPSZ256rmk)
  .value("VMAXPSZ256rmkz", LIEF::assembly::x86::OPCODE::VMAXPSZ256rmkz)
  .value("VMAXPSZ256rr", LIEF::assembly::x86::OPCODE::VMAXPSZ256rr)
  .value("VMAXPSZ256rrk", LIEF::assembly::x86::OPCODE::VMAXPSZ256rrk)
  .value("VMAXPSZ256rrkz", LIEF::assembly::x86::OPCODE::VMAXPSZ256rrkz)
  .value("VMAXPSZrm", LIEF::assembly::x86::OPCODE::VMAXPSZrm)
  .value("VMAXPSZrmb", LIEF::assembly::x86::OPCODE::VMAXPSZrmb)
  .value("VMAXPSZrmbk", LIEF::assembly::x86::OPCODE::VMAXPSZrmbk)
  .value("VMAXPSZrmbkz", LIEF::assembly::x86::OPCODE::VMAXPSZrmbkz)
  .value("VMAXPSZrmk", LIEF::assembly::x86::OPCODE::VMAXPSZrmk)
  .value("VMAXPSZrmkz", LIEF::assembly::x86::OPCODE::VMAXPSZrmkz)
  .value("VMAXPSZrr", LIEF::assembly::x86::OPCODE::VMAXPSZrr)
  .value("VMAXPSZrrb", LIEF::assembly::x86::OPCODE::VMAXPSZrrb)
  .value("VMAXPSZrrbk", LIEF::assembly::x86::OPCODE::VMAXPSZrrbk)
  .value("VMAXPSZrrbkz", LIEF::assembly::x86::OPCODE::VMAXPSZrrbkz)
  .value("VMAXPSZrrk", LIEF::assembly::x86::OPCODE::VMAXPSZrrk)
  .value("VMAXPSZrrkz", LIEF::assembly::x86::OPCODE::VMAXPSZrrkz)
  .value("VMAXPSrm", LIEF::assembly::x86::OPCODE::VMAXPSrm)
  .value("VMAXPSrr", LIEF::assembly::x86::OPCODE::VMAXPSrr)
  .value("VMAXSDZrm", LIEF::assembly::x86::OPCODE::VMAXSDZrm)
  .value("VMAXSDZrm_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrm_Int)
  .value("VMAXSDZrmk_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrmk_Int)
  .value("VMAXSDZrmkz_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrmkz_Int)
  .value("VMAXSDZrr", LIEF::assembly::x86::OPCODE::VMAXSDZrr)
  .value("VMAXSDZrr_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrr_Int)
  .value("VMAXSDZrrb_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrrb_Int)
  .value("VMAXSDZrrbk_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrrbk_Int)
  .value("VMAXSDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrrbkz_Int)
  .value("VMAXSDZrrk_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrrk_Int)
  .value("VMAXSDZrrkz_Int", LIEF::assembly::x86::OPCODE::VMAXSDZrrkz_Int)
  .value("VMAXSDrm", LIEF::assembly::x86::OPCODE::VMAXSDrm)
  .value("VMAXSDrm_Int", LIEF::assembly::x86::OPCODE::VMAXSDrm_Int)
  .value("VMAXSDrr", LIEF::assembly::x86::OPCODE::VMAXSDrr)
  .value("VMAXSDrr_Int", LIEF::assembly::x86::OPCODE::VMAXSDrr_Int)
  .value("VMAXSHZrm", LIEF::assembly::x86::OPCODE::VMAXSHZrm)
  .value("VMAXSHZrm_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrm_Int)
  .value("VMAXSHZrmk_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrmk_Int)
  .value("VMAXSHZrmkz_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrmkz_Int)
  .value("VMAXSHZrr", LIEF::assembly::x86::OPCODE::VMAXSHZrr)
  .value("VMAXSHZrr_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrr_Int)
  .value("VMAXSHZrrb_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrrb_Int)
  .value("VMAXSHZrrbk_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrrbk_Int)
  .value("VMAXSHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrrbkz_Int)
  .value("VMAXSHZrrk_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrrk_Int)
  .value("VMAXSHZrrkz_Int", LIEF::assembly::x86::OPCODE::VMAXSHZrrkz_Int)
  .value("VMAXSSZrm", LIEF::assembly::x86::OPCODE::VMAXSSZrm)
  .value("VMAXSSZrm_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrm_Int)
  .value("VMAXSSZrmk_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrmk_Int)
  .value("VMAXSSZrmkz_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrmkz_Int)
  .value("VMAXSSZrr", LIEF::assembly::x86::OPCODE::VMAXSSZrr)
  .value("VMAXSSZrr_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrr_Int)
  .value("VMAXSSZrrb_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrrb_Int)
  .value("VMAXSSZrrbk_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrrbk_Int)
  .value("VMAXSSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrrbkz_Int)
  .value("VMAXSSZrrk_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrrk_Int)
  .value("VMAXSSZrrkz_Int", LIEF::assembly::x86::OPCODE::VMAXSSZrrkz_Int)
  .value("VMAXSSrm", LIEF::assembly::x86::OPCODE::VMAXSSrm)
  .value("VMAXSSrm_Int", LIEF::assembly::x86::OPCODE::VMAXSSrm_Int)
  .value("VMAXSSrr", LIEF::assembly::x86::OPCODE::VMAXSSrr)
  .value("VMAXSSrr_Int", LIEF::assembly::x86::OPCODE::VMAXSSrr_Int)
  .value("VMCALL", LIEF::assembly::x86::OPCODE::VMCALL)
  .value("VMCLEARm", LIEF::assembly::x86::OPCODE::VMCLEARm)
  .value("VMFUNC", LIEF::assembly::x86::OPCODE::VMFUNC)
  .value("VMINBF16Z128rm", LIEF::assembly::x86::OPCODE::VMINBF16Z128rm)
  .value("VMINBF16Z128rmb", LIEF::assembly::x86::OPCODE::VMINBF16Z128rmb)
  .value("VMINBF16Z128rmbk", LIEF::assembly::x86::OPCODE::VMINBF16Z128rmbk)
  .value("VMINBF16Z128rmbkz", LIEF::assembly::x86::OPCODE::VMINBF16Z128rmbkz)
  .value("VMINBF16Z128rmk", LIEF::assembly::x86::OPCODE::VMINBF16Z128rmk)
  .value("VMINBF16Z128rmkz", LIEF::assembly::x86::OPCODE::VMINBF16Z128rmkz)
  .value("VMINBF16Z128rr", LIEF::assembly::x86::OPCODE::VMINBF16Z128rr)
  .value("VMINBF16Z128rrk", LIEF::assembly::x86::OPCODE::VMINBF16Z128rrk)
  .value("VMINBF16Z128rrkz", LIEF::assembly::x86::OPCODE::VMINBF16Z128rrkz)
  .value("VMINBF16Z256rm", LIEF::assembly::x86::OPCODE::VMINBF16Z256rm)
  .value("VMINBF16Z256rmb", LIEF::assembly::x86::OPCODE::VMINBF16Z256rmb)
  .value("VMINBF16Z256rmbk", LIEF::assembly::x86::OPCODE::VMINBF16Z256rmbk)
  .value("VMINBF16Z256rmbkz", LIEF::assembly::x86::OPCODE::VMINBF16Z256rmbkz)
  .value("VMINBF16Z256rmk", LIEF::assembly::x86::OPCODE::VMINBF16Z256rmk)
  .value("VMINBF16Z256rmkz", LIEF::assembly::x86::OPCODE::VMINBF16Z256rmkz)
  .value("VMINBF16Z256rr", LIEF::assembly::x86::OPCODE::VMINBF16Z256rr)
  .value("VMINBF16Z256rrk", LIEF::assembly::x86::OPCODE::VMINBF16Z256rrk)
  .value("VMINBF16Z256rrkz", LIEF::assembly::x86::OPCODE::VMINBF16Z256rrkz)
  .value("VMINBF16Zrm", LIEF::assembly::x86::OPCODE::VMINBF16Zrm)
  .value("VMINBF16Zrmb", LIEF::assembly::x86::OPCODE::VMINBF16Zrmb)
  .value("VMINBF16Zrmbk", LIEF::assembly::x86::OPCODE::VMINBF16Zrmbk)
  .value("VMINBF16Zrmbkz", LIEF::assembly::x86::OPCODE::VMINBF16Zrmbkz)
  .value("VMINBF16Zrmk", LIEF::assembly::x86::OPCODE::VMINBF16Zrmk)
  .value("VMINBF16Zrmkz", LIEF::assembly::x86::OPCODE::VMINBF16Zrmkz)
  .value("VMINBF16Zrr", LIEF::assembly::x86::OPCODE::VMINBF16Zrr)
  .value("VMINBF16Zrrk", LIEF::assembly::x86::OPCODE::VMINBF16Zrrk)
  .value("VMINBF16Zrrkz", LIEF::assembly::x86::OPCODE::VMINBF16Zrrkz)
  .value("VMINCPDYrm", LIEF::assembly::x86::OPCODE::VMINCPDYrm)
  .value("VMINCPDYrr", LIEF::assembly::x86::OPCODE::VMINCPDYrr)
  .value("VMINCPDZ128rm", LIEF::assembly::x86::OPCODE::VMINCPDZ128rm)
  .value("VMINCPDZ128rmb", LIEF::assembly::x86::OPCODE::VMINCPDZ128rmb)
  .value("VMINCPDZ128rmbk", LIEF::assembly::x86::OPCODE::VMINCPDZ128rmbk)
  .value("VMINCPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINCPDZ128rmbkz)
  .value("VMINCPDZ128rmk", LIEF::assembly::x86::OPCODE::VMINCPDZ128rmk)
  .value("VMINCPDZ128rmkz", LIEF::assembly::x86::OPCODE::VMINCPDZ128rmkz)
  .value("VMINCPDZ128rr", LIEF::assembly::x86::OPCODE::VMINCPDZ128rr)
  .value("VMINCPDZ128rrk", LIEF::assembly::x86::OPCODE::VMINCPDZ128rrk)
  .value("VMINCPDZ128rrkz", LIEF::assembly::x86::OPCODE::VMINCPDZ128rrkz)
  .value("VMINCPDZ256rm", LIEF::assembly::x86::OPCODE::VMINCPDZ256rm)
  .value("VMINCPDZ256rmb", LIEF::assembly::x86::OPCODE::VMINCPDZ256rmb)
  .value("VMINCPDZ256rmbk", LIEF::assembly::x86::OPCODE::VMINCPDZ256rmbk)
  .value("VMINCPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINCPDZ256rmbkz)
  .value("VMINCPDZ256rmk", LIEF::assembly::x86::OPCODE::VMINCPDZ256rmk)
  .value("VMINCPDZ256rmkz", LIEF::assembly::x86::OPCODE::VMINCPDZ256rmkz)
  .value("VMINCPDZ256rr", LIEF::assembly::x86::OPCODE::VMINCPDZ256rr)
  .value("VMINCPDZ256rrk", LIEF::assembly::x86::OPCODE::VMINCPDZ256rrk)
  .value("VMINCPDZ256rrkz", LIEF::assembly::x86::OPCODE::VMINCPDZ256rrkz)
  .value("VMINCPDZrm", LIEF::assembly::x86::OPCODE::VMINCPDZrm)
  .value("VMINCPDZrmb", LIEF::assembly::x86::OPCODE::VMINCPDZrmb)
  .value("VMINCPDZrmbk", LIEF::assembly::x86::OPCODE::VMINCPDZrmbk)
  .value("VMINCPDZrmbkz", LIEF::assembly::x86::OPCODE::VMINCPDZrmbkz)
  .value("VMINCPDZrmk", LIEF::assembly::x86::OPCODE::VMINCPDZrmk)
  .value("VMINCPDZrmkz", LIEF::assembly::x86::OPCODE::VMINCPDZrmkz)
  .value("VMINCPDZrr", LIEF::assembly::x86::OPCODE::VMINCPDZrr)
  .value("VMINCPDZrrk", LIEF::assembly::x86::OPCODE::VMINCPDZrrk)
  .value("VMINCPDZrrkz", LIEF::assembly::x86::OPCODE::VMINCPDZrrkz)
  .value("VMINCPDrm", LIEF::assembly::x86::OPCODE::VMINCPDrm)
  .value("VMINCPDrr", LIEF::assembly::x86::OPCODE::VMINCPDrr)
  .value("VMINCPHZ128rm", LIEF::assembly::x86::OPCODE::VMINCPHZ128rm)
  .value("VMINCPHZ128rmb", LIEF::assembly::x86::OPCODE::VMINCPHZ128rmb)
  .value("VMINCPHZ128rmbk", LIEF::assembly::x86::OPCODE::VMINCPHZ128rmbk)
  .value("VMINCPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINCPHZ128rmbkz)
  .value("VMINCPHZ128rmk", LIEF::assembly::x86::OPCODE::VMINCPHZ128rmk)
  .value("VMINCPHZ128rmkz", LIEF::assembly::x86::OPCODE::VMINCPHZ128rmkz)
  .value("VMINCPHZ128rr", LIEF::assembly::x86::OPCODE::VMINCPHZ128rr)
  .value("VMINCPHZ128rrk", LIEF::assembly::x86::OPCODE::VMINCPHZ128rrk)
  .value("VMINCPHZ128rrkz", LIEF::assembly::x86::OPCODE::VMINCPHZ128rrkz)
  .value("VMINCPHZ256rm", LIEF::assembly::x86::OPCODE::VMINCPHZ256rm)
  .value("VMINCPHZ256rmb", LIEF::assembly::x86::OPCODE::VMINCPHZ256rmb)
  .value("VMINCPHZ256rmbk", LIEF::assembly::x86::OPCODE::VMINCPHZ256rmbk)
  .value("VMINCPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINCPHZ256rmbkz)
  .value("VMINCPHZ256rmk", LIEF::assembly::x86::OPCODE::VMINCPHZ256rmk)
  .value("VMINCPHZ256rmkz", LIEF::assembly::x86::OPCODE::VMINCPHZ256rmkz)
  .value("VMINCPHZ256rr", LIEF::assembly::x86::OPCODE::VMINCPHZ256rr)
  .value("VMINCPHZ256rrk", LIEF::assembly::x86::OPCODE::VMINCPHZ256rrk)
  .value("VMINCPHZ256rrkz", LIEF::assembly::x86::OPCODE::VMINCPHZ256rrkz)
  .value("VMINCPHZrm", LIEF::assembly::x86::OPCODE::VMINCPHZrm)
  .value("VMINCPHZrmb", LIEF::assembly::x86::OPCODE::VMINCPHZrmb)
  .value("VMINCPHZrmbk", LIEF::assembly::x86::OPCODE::VMINCPHZrmbk)
  .value("VMINCPHZrmbkz", LIEF::assembly::x86::OPCODE::VMINCPHZrmbkz)
  .value("VMINCPHZrmk", LIEF::assembly::x86::OPCODE::VMINCPHZrmk)
  .value("VMINCPHZrmkz", LIEF::assembly::x86::OPCODE::VMINCPHZrmkz)
  .value("VMINCPHZrr", LIEF::assembly::x86::OPCODE::VMINCPHZrr)
  .value("VMINCPHZrrk", LIEF::assembly::x86::OPCODE::VMINCPHZrrk)
  .value("VMINCPHZrrkz", LIEF::assembly::x86::OPCODE::VMINCPHZrrkz)
  .value("VMINCPSYrm", LIEF::assembly::x86::OPCODE::VMINCPSYrm)
  .value("VMINCPSYrr", LIEF::assembly::x86::OPCODE::VMINCPSYrr)
  .value("VMINCPSZ128rm", LIEF::assembly::x86::OPCODE::VMINCPSZ128rm)
  .value("VMINCPSZ128rmb", LIEF::assembly::x86::OPCODE::VMINCPSZ128rmb)
  .value("VMINCPSZ128rmbk", LIEF::assembly::x86::OPCODE::VMINCPSZ128rmbk)
  .value("VMINCPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINCPSZ128rmbkz)
  .value("VMINCPSZ128rmk", LIEF::assembly::x86::OPCODE::VMINCPSZ128rmk)
  .value("VMINCPSZ128rmkz", LIEF::assembly::x86::OPCODE::VMINCPSZ128rmkz)
  .value("VMINCPSZ128rr", LIEF::assembly::x86::OPCODE::VMINCPSZ128rr)
  .value("VMINCPSZ128rrk", LIEF::assembly::x86::OPCODE::VMINCPSZ128rrk)
  .value("VMINCPSZ128rrkz", LIEF::assembly::x86::OPCODE::VMINCPSZ128rrkz)
  .value("VMINCPSZ256rm", LIEF::assembly::x86::OPCODE::VMINCPSZ256rm)
  .value("VMINCPSZ256rmb", LIEF::assembly::x86::OPCODE::VMINCPSZ256rmb)
  .value("VMINCPSZ256rmbk", LIEF::assembly::x86::OPCODE::VMINCPSZ256rmbk)
  .value("VMINCPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINCPSZ256rmbkz)
  .value("VMINCPSZ256rmk", LIEF::assembly::x86::OPCODE::VMINCPSZ256rmk)
  .value("VMINCPSZ256rmkz", LIEF::assembly::x86::OPCODE::VMINCPSZ256rmkz)
  .value("VMINCPSZ256rr", LIEF::assembly::x86::OPCODE::VMINCPSZ256rr)
  .value("VMINCPSZ256rrk", LIEF::assembly::x86::OPCODE::VMINCPSZ256rrk)
  .value("VMINCPSZ256rrkz", LIEF::assembly::x86::OPCODE::VMINCPSZ256rrkz)
  .value("VMINCPSZrm", LIEF::assembly::x86::OPCODE::VMINCPSZrm)
  .value("VMINCPSZrmb", LIEF::assembly::x86::OPCODE::VMINCPSZrmb)
  .value("VMINCPSZrmbk", LIEF::assembly::x86::OPCODE::VMINCPSZrmbk)
  .value("VMINCPSZrmbkz", LIEF::assembly::x86::OPCODE::VMINCPSZrmbkz)
  .value("VMINCPSZrmk", LIEF::assembly::x86::OPCODE::VMINCPSZrmk)
  .value("VMINCPSZrmkz", LIEF::assembly::x86::OPCODE::VMINCPSZrmkz)
  .value("VMINCPSZrr", LIEF::assembly::x86::OPCODE::VMINCPSZrr)
  .value("VMINCPSZrrk", LIEF::assembly::x86::OPCODE::VMINCPSZrrk)
  .value("VMINCPSZrrkz", LIEF::assembly::x86::OPCODE::VMINCPSZrrkz)
  .value("VMINCPSrm", LIEF::assembly::x86::OPCODE::VMINCPSrm)
  .value("VMINCPSrr", LIEF::assembly::x86::OPCODE::VMINCPSrr)
  .value("VMINCSDZrm", LIEF::assembly::x86::OPCODE::VMINCSDZrm)
  .value("VMINCSDZrr", LIEF::assembly::x86::OPCODE::VMINCSDZrr)
  .value("VMINCSDrm", LIEF::assembly::x86::OPCODE::VMINCSDrm)
  .value("VMINCSDrr", LIEF::assembly::x86::OPCODE::VMINCSDrr)
  .value("VMINCSHZrm", LIEF::assembly::x86::OPCODE::VMINCSHZrm)
  .value("VMINCSHZrr", LIEF::assembly::x86::OPCODE::VMINCSHZrr)
  .value("VMINCSSZrm", LIEF::assembly::x86::OPCODE::VMINCSSZrm)
  .value("VMINCSSZrr", LIEF::assembly::x86::OPCODE::VMINCSSZrr)
  .value("VMINCSSrm", LIEF::assembly::x86::OPCODE::VMINCSSrm)
  .value("VMINCSSrr", LIEF::assembly::x86::OPCODE::VMINCSSrr)
  .value("VMINMAXBF16Z128rmbi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmbi)
  .value("VMINMAXBF16Z128rmbik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmbik)
  .value("VMINMAXBF16Z128rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmbikz)
  .value("VMINMAXBF16Z128rmi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmi)
  .value("VMINMAXBF16Z128rmik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmik)
  .value("VMINMAXBF16Z128rmikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rmikz)
  .value("VMINMAXBF16Z128rri", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rri)
  .value("VMINMAXBF16Z128rrik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rrik)
  .value("VMINMAXBF16Z128rrikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z128rrikz)
  .value("VMINMAXBF16Z256rmbi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmbi)
  .value("VMINMAXBF16Z256rmbik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmbik)
  .value("VMINMAXBF16Z256rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmbikz)
  .value("VMINMAXBF16Z256rmi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmi)
  .value("VMINMAXBF16Z256rmik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmik);
  opcodes.value("VMINMAXBF16Z256rmikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rmikz)
  .value("VMINMAXBF16Z256rri", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rri)
  .value("VMINMAXBF16Z256rrik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rrik)
  .value("VMINMAXBF16Z256rrikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Z256rrikz)
  .value("VMINMAXBF16Zrmbi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmbi)
  .value("VMINMAXBF16Zrmbik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmbik)
  .value("VMINMAXBF16Zrmbikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmbikz)
  .value("VMINMAXBF16Zrmi", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmi)
  .value("VMINMAXBF16Zrmik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmik)
  .value("VMINMAXBF16Zrmikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrmikz)
  .value("VMINMAXBF16Zrri", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrri)
  .value("VMINMAXBF16Zrrik", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrrik)
  .value("VMINMAXBF16Zrrikz", LIEF::assembly::x86::OPCODE::VMINMAXBF16Zrrikz)
  .value("VMINMAXPDZ128rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmbi)
  .value("VMINMAXPDZ128rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmbik)
  .value("VMINMAXPDZ128rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmbikz)
  .value("VMINMAXPDZ128rmi", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmi)
  .value("VMINMAXPDZ128rmik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmik)
  .value("VMINMAXPDZ128rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rmikz)
  .value("VMINMAXPDZ128rri", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rri)
  .value("VMINMAXPDZ128rrik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rrik)
  .value("VMINMAXPDZ128rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ128rrikz)
  .value("VMINMAXPDZ256rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmbi)
  .value("VMINMAXPDZ256rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmbik)
  .value("VMINMAXPDZ256rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmbikz)
  .value("VMINMAXPDZ256rmi", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmi)
  .value("VMINMAXPDZ256rmik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmik)
  .value("VMINMAXPDZ256rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rmikz)
  .value("VMINMAXPDZ256rri", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rri)
  .value("VMINMAXPDZ256rrik", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rrik)
  .value("VMINMAXPDZ256rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZ256rrikz)
  .value("VMINMAXPDZrmbi", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmbi)
  .value("VMINMAXPDZrmbik", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmbik)
  .value("VMINMAXPDZrmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmbikz)
  .value("VMINMAXPDZrmi", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmi)
  .value("VMINMAXPDZrmik", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmik)
  .value("VMINMAXPDZrmikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZrmikz)
  .value("VMINMAXPDZrri", LIEF::assembly::x86::OPCODE::VMINMAXPDZrri)
  .value("VMINMAXPDZrrib", LIEF::assembly::x86::OPCODE::VMINMAXPDZrrib)
  .value("VMINMAXPDZrribk", LIEF::assembly::x86::OPCODE::VMINMAXPDZrribk)
  .value("VMINMAXPDZrribkz", LIEF::assembly::x86::OPCODE::VMINMAXPDZrribkz)
  .value("VMINMAXPDZrrik", LIEF::assembly::x86::OPCODE::VMINMAXPDZrrik)
  .value("VMINMAXPDZrrikz", LIEF::assembly::x86::OPCODE::VMINMAXPDZrrikz)
  .value("VMINMAXPHZ128rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmbi)
  .value("VMINMAXPHZ128rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmbik)
  .value("VMINMAXPHZ128rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmbikz)
  .value("VMINMAXPHZ128rmi", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmi)
  .value("VMINMAXPHZ128rmik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmik)
  .value("VMINMAXPHZ128rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rmikz)
  .value("VMINMAXPHZ128rri", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rri)
  .value("VMINMAXPHZ128rrik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rrik)
  .value("VMINMAXPHZ128rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ128rrikz)
  .value("VMINMAXPHZ256rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmbi)
  .value("VMINMAXPHZ256rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmbik)
  .value("VMINMAXPHZ256rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmbikz)
  .value("VMINMAXPHZ256rmi", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmi)
  .value("VMINMAXPHZ256rmik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmik)
  .value("VMINMAXPHZ256rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rmikz)
  .value("VMINMAXPHZ256rri", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rri)
  .value("VMINMAXPHZ256rrik", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rrik)
  .value("VMINMAXPHZ256rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZ256rrikz)
  .value("VMINMAXPHZrmbi", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmbi)
  .value("VMINMAXPHZrmbik", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmbik)
  .value("VMINMAXPHZrmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmbikz)
  .value("VMINMAXPHZrmi", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmi)
  .value("VMINMAXPHZrmik", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmik)
  .value("VMINMAXPHZrmikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZrmikz)
  .value("VMINMAXPHZrri", LIEF::assembly::x86::OPCODE::VMINMAXPHZrri)
  .value("VMINMAXPHZrrib", LIEF::assembly::x86::OPCODE::VMINMAXPHZrrib)
  .value("VMINMAXPHZrribk", LIEF::assembly::x86::OPCODE::VMINMAXPHZrribk)
  .value("VMINMAXPHZrribkz", LIEF::assembly::x86::OPCODE::VMINMAXPHZrribkz)
  .value("VMINMAXPHZrrik", LIEF::assembly::x86::OPCODE::VMINMAXPHZrrik)
  .value("VMINMAXPHZrrikz", LIEF::assembly::x86::OPCODE::VMINMAXPHZrrikz)
  .value("VMINMAXPSZ128rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmbi)
  .value("VMINMAXPSZ128rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmbik)
  .value("VMINMAXPSZ128rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmbikz)
  .value("VMINMAXPSZ128rmi", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmi)
  .value("VMINMAXPSZ128rmik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmik)
  .value("VMINMAXPSZ128rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rmikz)
  .value("VMINMAXPSZ128rri", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rri)
  .value("VMINMAXPSZ128rrik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rrik)
  .value("VMINMAXPSZ128rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ128rrikz)
  .value("VMINMAXPSZ256rmbi", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmbi)
  .value("VMINMAXPSZ256rmbik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmbik)
  .value("VMINMAXPSZ256rmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmbikz)
  .value("VMINMAXPSZ256rmi", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmi)
  .value("VMINMAXPSZ256rmik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmik)
  .value("VMINMAXPSZ256rmikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rmikz)
  .value("VMINMAXPSZ256rri", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rri)
  .value("VMINMAXPSZ256rrik", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rrik)
  .value("VMINMAXPSZ256rrikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZ256rrikz)
  .value("VMINMAXPSZrmbi", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmbi)
  .value("VMINMAXPSZrmbik", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmbik)
  .value("VMINMAXPSZrmbikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmbikz)
  .value("VMINMAXPSZrmi", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmi)
  .value("VMINMAXPSZrmik", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmik)
  .value("VMINMAXPSZrmikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZrmikz)
  .value("VMINMAXPSZrri", LIEF::assembly::x86::OPCODE::VMINMAXPSZrri)
  .value("VMINMAXPSZrrib", LIEF::assembly::x86::OPCODE::VMINMAXPSZrrib)
  .value("VMINMAXPSZrribk", LIEF::assembly::x86::OPCODE::VMINMAXPSZrribk)
  .value("VMINMAXPSZrribkz", LIEF::assembly::x86::OPCODE::VMINMAXPSZrribkz)
  .value("VMINMAXPSZrrik", LIEF::assembly::x86::OPCODE::VMINMAXPSZrrik)
  .value("VMINMAXPSZrrikz", LIEF::assembly::x86::OPCODE::VMINMAXPSZrrikz)
  .value("VMINMAXSDrmi", LIEF::assembly::x86::OPCODE::VMINMAXSDrmi)
  .value("VMINMAXSDrmi_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrmi_Int)
  .value("VMINMAXSDrmik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrmik_Int)
  .value("VMINMAXSDrmikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrmikz_Int)
  .value("VMINMAXSDrri", LIEF::assembly::x86::OPCODE::VMINMAXSDrri)
  .value("VMINMAXSDrri_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrri_Int)
  .value("VMINMAXSDrrib_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrrib_Int)
  .value("VMINMAXSDrribk_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrribk_Int)
  .value("VMINMAXSDrribkz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrribkz_Int)
  .value("VMINMAXSDrrik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrrik_Int)
  .value("VMINMAXSDrrikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSDrrikz_Int)
  .value("VMINMAXSHrmi", LIEF::assembly::x86::OPCODE::VMINMAXSHrmi)
  .value("VMINMAXSHrmi_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrmi_Int)
  .value("VMINMAXSHrmik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrmik_Int)
  .value("VMINMAXSHrmikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrmikz_Int)
  .value("VMINMAXSHrri", LIEF::assembly::x86::OPCODE::VMINMAXSHrri)
  .value("VMINMAXSHrri_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrri_Int)
  .value("VMINMAXSHrrib_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrrib_Int)
  .value("VMINMAXSHrribk_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrribk_Int)
  .value("VMINMAXSHrribkz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrribkz_Int)
  .value("VMINMAXSHrrik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrrik_Int)
  .value("VMINMAXSHrrikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSHrrikz_Int)
  .value("VMINMAXSSrmi", LIEF::assembly::x86::OPCODE::VMINMAXSSrmi)
  .value("VMINMAXSSrmi_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrmi_Int)
  .value("VMINMAXSSrmik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrmik_Int)
  .value("VMINMAXSSrmikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrmikz_Int)
  .value("VMINMAXSSrri", LIEF::assembly::x86::OPCODE::VMINMAXSSrri)
  .value("VMINMAXSSrri_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrri_Int)
  .value("VMINMAXSSrrib_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrrib_Int)
  .value("VMINMAXSSrribk_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrribk_Int)
  .value("VMINMAXSSrribkz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrribkz_Int)
  .value("VMINMAXSSrrik_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrrik_Int)
  .value("VMINMAXSSrrikz_Int", LIEF::assembly::x86::OPCODE::VMINMAXSSrrikz_Int)
  .value("VMINPDYrm", LIEF::assembly::x86::OPCODE::VMINPDYrm)
  .value("VMINPDYrr", LIEF::assembly::x86::OPCODE::VMINPDYrr)
  .value("VMINPDZ128rm", LIEF::assembly::x86::OPCODE::VMINPDZ128rm)
  .value("VMINPDZ128rmb", LIEF::assembly::x86::OPCODE::VMINPDZ128rmb)
  .value("VMINPDZ128rmbk", LIEF::assembly::x86::OPCODE::VMINPDZ128rmbk)
  .value("VMINPDZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINPDZ128rmbkz)
  .value("VMINPDZ128rmk", LIEF::assembly::x86::OPCODE::VMINPDZ128rmk)
  .value("VMINPDZ128rmkz", LIEF::assembly::x86::OPCODE::VMINPDZ128rmkz)
  .value("VMINPDZ128rr", LIEF::assembly::x86::OPCODE::VMINPDZ128rr)
  .value("VMINPDZ128rrk", LIEF::assembly::x86::OPCODE::VMINPDZ128rrk)
  .value("VMINPDZ128rrkz", LIEF::assembly::x86::OPCODE::VMINPDZ128rrkz)
  .value("VMINPDZ256rm", LIEF::assembly::x86::OPCODE::VMINPDZ256rm)
  .value("VMINPDZ256rmb", LIEF::assembly::x86::OPCODE::VMINPDZ256rmb)
  .value("VMINPDZ256rmbk", LIEF::assembly::x86::OPCODE::VMINPDZ256rmbk)
  .value("VMINPDZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINPDZ256rmbkz)
  .value("VMINPDZ256rmk", LIEF::assembly::x86::OPCODE::VMINPDZ256rmk)
  .value("VMINPDZ256rmkz", LIEF::assembly::x86::OPCODE::VMINPDZ256rmkz)
  .value("VMINPDZ256rr", LIEF::assembly::x86::OPCODE::VMINPDZ256rr)
  .value("VMINPDZ256rrk", LIEF::assembly::x86::OPCODE::VMINPDZ256rrk)
  .value("VMINPDZ256rrkz", LIEF::assembly::x86::OPCODE::VMINPDZ256rrkz)
  .value("VMINPDZrm", LIEF::assembly::x86::OPCODE::VMINPDZrm)
  .value("VMINPDZrmb", LIEF::assembly::x86::OPCODE::VMINPDZrmb)
  .value("VMINPDZrmbk", LIEF::assembly::x86::OPCODE::VMINPDZrmbk)
  .value("VMINPDZrmbkz", LIEF::assembly::x86::OPCODE::VMINPDZrmbkz)
  .value("VMINPDZrmk", LIEF::assembly::x86::OPCODE::VMINPDZrmk)
  .value("VMINPDZrmkz", LIEF::assembly::x86::OPCODE::VMINPDZrmkz)
  .value("VMINPDZrr", LIEF::assembly::x86::OPCODE::VMINPDZrr)
  .value("VMINPDZrrb", LIEF::assembly::x86::OPCODE::VMINPDZrrb)
  .value("VMINPDZrrbk", LIEF::assembly::x86::OPCODE::VMINPDZrrbk)
  .value("VMINPDZrrbkz", LIEF::assembly::x86::OPCODE::VMINPDZrrbkz)
  .value("VMINPDZrrk", LIEF::assembly::x86::OPCODE::VMINPDZrrk)
  .value("VMINPDZrrkz", LIEF::assembly::x86::OPCODE::VMINPDZrrkz)
  .value("VMINPDrm", LIEF::assembly::x86::OPCODE::VMINPDrm)
  .value("VMINPDrr", LIEF::assembly::x86::OPCODE::VMINPDrr)
  .value("VMINPHZ128rm", LIEF::assembly::x86::OPCODE::VMINPHZ128rm)
  .value("VMINPHZ128rmb", LIEF::assembly::x86::OPCODE::VMINPHZ128rmb)
  .value("VMINPHZ128rmbk", LIEF::assembly::x86::OPCODE::VMINPHZ128rmbk)
  .value("VMINPHZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINPHZ128rmbkz)
  .value("VMINPHZ128rmk", LIEF::assembly::x86::OPCODE::VMINPHZ128rmk)
  .value("VMINPHZ128rmkz", LIEF::assembly::x86::OPCODE::VMINPHZ128rmkz)
  .value("VMINPHZ128rr", LIEF::assembly::x86::OPCODE::VMINPHZ128rr)
  .value("VMINPHZ128rrk", LIEF::assembly::x86::OPCODE::VMINPHZ128rrk)
  .value("VMINPHZ128rrkz", LIEF::assembly::x86::OPCODE::VMINPHZ128rrkz)
  .value("VMINPHZ256rm", LIEF::assembly::x86::OPCODE::VMINPHZ256rm)
  .value("VMINPHZ256rmb", LIEF::assembly::x86::OPCODE::VMINPHZ256rmb)
  .value("VMINPHZ256rmbk", LIEF::assembly::x86::OPCODE::VMINPHZ256rmbk)
  .value("VMINPHZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINPHZ256rmbkz)
  .value("VMINPHZ256rmk", LIEF::assembly::x86::OPCODE::VMINPHZ256rmk)
  .value("VMINPHZ256rmkz", LIEF::assembly::x86::OPCODE::VMINPHZ256rmkz)
  .value("VMINPHZ256rr", LIEF::assembly::x86::OPCODE::VMINPHZ256rr)
  .value("VMINPHZ256rrk", LIEF::assembly::x86::OPCODE::VMINPHZ256rrk)
  .value("VMINPHZ256rrkz", LIEF::assembly::x86::OPCODE::VMINPHZ256rrkz)
  .value("VMINPHZrm", LIEF::assembly::x86::OPCODE::VMINPHZrm)
  .value("VMINPHZrmb", LIEF::assembly::x86::OPCODE::VMINPHZrmb)
  .value("VMINPHZrmbk", LIEF::assembly::x86::OPCODE::VMINPHZrmbk)
  .value("VMINPHZrmbkz", LIEF::assembly::x86::OPCODE::VMINPHZrmbkz)
  .value("VMINPHZrmk", LIEF::assembly::x86::OPCODE::VMINPHZrmk)
  .value("VMINPHZrmkz", LIEF::assembly::x86::OPCODE::VMINPHZrmkz)
  .value("VMINPHZrr", LIEF::assembly::x86::OPCODE::VMINPHZrr)
  .value("VMINPHZrrb", LIEF::assembly::x86::OPCODE::VMINPHZrrb)
  .value("VMINPHZrrbk", LIEF::assembly::x86::OPCODE::VMINPHZrrbk)
  .value("VMINPHZrrbkz", LIEF::assembly::x86::OPCODE::VMINPHZrrbkz)
  .value("VMINPHZrrk", LIEF::assembly::x86::OPCODE::VMINPHZrrk)
  .value("VMINPHZrrkz", LIEF::assembly::x86::OPCODE::VMINPHZrrkz)
  .value("VMINPSYrm", LIEF::assembly::x86::OPCODE::VMINPSYrm)
  .value("VMINPSYrr", LIEF::assembly::x86::OPCODE::VMINPSYrr)
  .value("VMINPSZ128rm", LIEF::assembly::x86::OPCODE::VMINPSZ128rm)
  .value("VMINPSZ128rmb", LIEF::assembly::x86::OPCODE::VMINPSZ128rmb)
  .value("VMINPSZ128rmbk", LIEF::assembly::x86::OPCODE::VMINPSZ128rmbk)
  .value("VMINPSZ128rmbkz", LIEF::assembly::x86::OPCODE::VMINPSZ128rmbkz)
  .value("VMINPSZ128rmk", LIEF::assembly::x86::OPCODE::VMINPSZ128rmk)
  .value("VMINPSZ128rmkz", LIEF::assembly::x86::OPCODE::VMINPSZ128rmkz)
  .value("VMINPSZ128rr", LIEF::assembly::x86::OPCODE::VMINPSZ128rr)
  .value("VMINPSZ128rrk", LIEF::assembly::x86::OPCODE::VMINPSZ128rrk)
  .value("VMINPSZ128rrkz", LIEF::assembly::x86::OPCODE::VMINPSZ128rrkz)
  .value("VMINPSZ256rm", LIEF::assembly::x86::OPCODE::VMINPSZ256rm)
  .value("VMINPSZ256rmb", LIEF::assembly::x86::OPCODE::VMINPSZ256rmb)
  .value("VMINPSZ256rmbk", LIEF::assembly::x86::OPCODE::VMINPSZ256rmbk)
  .value("VMINPSZ256rmbkz", LIEF::assembly::x86::OPCODE::VMINPSZ256rmbkz)
  .value("VMINPSZ256rmk", LIEF::assembly::x86::OPCODE::VMINPSZ256rmk)
  .value("VMINPSZ256rmkz", LIEF::assembly::x86::OPCODE::VMINPSZ256rmkz)
  .value("VMINPSZ256rr", LIEF::assembly::x86::OPCODE::VMINPSZ256rr)
  .value("VMINPSZ256rrk", LIEF::assembly::x86::OPCODE::VMINPSZ256rrk)
  .value("VMINPSZ256rrkz", LIEF::assembly::x86::OPCODE::VMINPSZ256rrkz)
  .value("VMINPSZrm", LIEF::assembly::x86::OPCODE::VMINPSZrm)
  .value("VMINPSZrmb", LIEF::assembly::x86::OPCODE::VMINPSZrmb)
  .value("VMINPSZrmbk", LIEF::assembly::x86::OPCODE::VMINPSZrmbk)
  .value("VMINPSZrmbkz", LIEF::assembly::x86::OPCODE::VMINPSZrmbkz)
  .value("VMINPSZrmk", LIEF::assembly::x86::OPCODE::VMINPSZrmk)
  .value("VMINPSZrmkz", LIEF::assembly::x86::OPCODE::VMINPSZrmkz)
  .value("VMINPSZrr", LIEF::assembly::x86::OPCODE::VMINPSZrr)
  .value("VMINPSZrrb", LIEF::assembly::x86::OPCODE::VMINPSZrrb)
  .value("VMINPSZrrbk", LIEF::assembly::x86::OPCODE::VMINPSZrrbk)
  .value("VMINPSZrrbkz", LIEF::assembly::x86::OPCODE::VMINPSZrrbkz)
  .value("VMINPSZrrk", LIEF::assembly::x86::OPCODE::VMINPSZrrk)
  .value("VMINPSZrrkz", LIEF::assembly::x86::OPCODE::VMINPSZrrkz)
  .value("VMINPSrm", LIEF::assembly::x86::OPCODE::VMINPSrm)
  .value("VMINPSrr", LIEF::assembly::x86::OPCODE::VMINPSrr)
  .value("VMINSDZrm", LIEF::assembly::x86::OPCODE::VMINSDZrm)
  .value("VMINSDZrm_Int", LIEF::assembly::x86::OPCODE::VMINSDZrm_Int)
  .value("VMINSDZrmk_Int", LIEF::assembly::x86::OPCODE::VMINSDZrmk_Int)
  .value("VMINSDZrmkz_Int", LIEF::assembly::x86::OPCODE::VMINSDZrmkz_Int)
  .value("VMINSDZrr", LIEF::assembly::x86::OPCODE::VMINSDZrr)
  .value("VMINSDZrr_Int", LIEF::assembly::x86::OPCODE::VMINSDZrr_Int)
  .value("VMINSDZrrb_Int", LIEF::assembly::x86::OPCODE::VMINSDZrrb_Int)
  .value("VMINSDZrrbk_Int", LIEF::assembly::x86::OPCODE::VMINSDZrrbk_Int)
  .value("VMINSDZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMINSDZrrbkz_Int)
  .value("VMINSDZrrk_Int", LIEF::assembly::x86::OPCODE::VMINSDZrrk_Int)
  .value("VMINSDZrrkz_Int", LIEF::assembly::x86::OPCODE::VMINSDZrrkz_Int)
  .value("VMINSDrm", LIEF::assembly::x86::OPCODE::VMINSDrm)
  .value("VMINSDrm_Int", LIEF::assembly::x86::OPCODE::VMINSDrm_Int)
  .value("VMINSDrr", LIEF::assembly::x86::OPCODE::VMINSDrr)
  .value("VMINSDrr_Int", LIEF::assembly::x86::OPCODE::VMINSDrr_Int)
  .value("VMINSHZrm", LIEF::assembly::x86::OPCODE::VMINSHZrm)
  .value("VMINSHZrm_Int", LIEF::assembly::x86::OPCODE::VMINSHZrm_Int)
  .value("VMINSHZrmk_Int", LIEF::assembly::x86::OPCODE::VMINSHZrmk_Int)
  .value("VMINSHZrmkz_Int", LIEF::assembly::x86::OPCODE::VMINSHZrmkz_Int)
  .value("VMINSHZrr", LIEF::assembly::x86::OPCODE::VMINSHZrr)
  .value("VMINSHZrr_Int", LIEF::assembly::x86::OPCODE::VMINSHZrr_Int)
  .value("VMINSHZrrb_Int", LIEF::assembly::x86::OPCODE::VMINSHZrrb_Int)
  .value("VMINSHZrrbk_Int", LIEF::assembly::x86::OPCODE::VMINSHZrrbk_Int)
  .value("VMINSHZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMINSHZrrbkz_Int)
  .value("VMINSHZrrk_Int", LIEF::assembly::x86::OPCODE::VMINSHZrrk_Int)
  .value("VMINSHZrrkz_Int", LIEF::assembly::x86::OPCODE::VMINSHZrrkz_Int)
  .value("VMINSSZrm", LIEF::assembly::x86::OPCODE::VMINSSZrm)
  .value("VMINSSZrm_Int", LIEF::assembly::x86::OPCODE::VMINSSZrm_Int)
  .value("VMINSSZrmk_Int", LIEF::assembly::x86::OPCODE::VMINSSZrmk_Int)
  .value("VMINSSZrmkz_Int", LIEF::assembly::x86::OPCODE::VMINSSZrmkz_Int)
  .value("VMINSSZrr", LIEF::assembly::x86::OPCODE::VMINSSZrr)
  .value("VMINSSZrr_Int", LIEF::assembly::x86::OPCODE::VMINSSZrr_Int)
  .value("VMINSSZrrb_Int", LIEF::assembly::x86::OPCODE::VMINSSZrrb_Int)
  .value("VMINSSZrrbk_Int", LIEF::assembly::x86::OPCODE::VMINSSZrrbk_Int)
  .value("VMINSSZrrbkz_Int", LIEF::assembly::x86::OPCODE::VMINSSZrrbkz_Int)
  .value("VMINSSZrrk_Int", LIEF::assembly::x86::OPCODE::VMINSSZrrk_Int)
  .value("VMINSSZrrkz_Int", LIEF::assembly::x86::OPCODE::VMINSSZrrkz_Int)
  .value("VMINSSrm", LIEF::assembly::x86::OPCODE::VMINSSrm)
  .value("VMINSSrm_Int", LIEF::assembly::x86::OPCODE::VMINSSrm_Int)
  .value("VMINSSrr", LIEF::assembly::x86::OPCODE::VMINSSrr)
  .value("VMINSSrr_Int", LIEF::assembly::x86::OPCODE::VMINSSrr_Int)
  .value("VMLAUNCH", LIEF::assembly::x86::OPCODE::VMLAUNCH)
  .value("VMLOAD32", LIEF::assembly::x86::OPCODE::VMLOAD32)
  .value("VMLOAD64", LIEF::assembly::x86::OPCODE::VMLOAD64)
  .value("VMMCALL", LIEF::assembly::x86::OPCODE::VMMCALL)
  .value("VMOV64toPQIZrm", LIEF::assembly::x86::OPCODE::VMOV64toPQIZrm)
  .value("VMOV64toPQIZrr", LIEF::assembly::x86::OPCODE::VMOV64toPQIZrr)
  .value("VMOV64toPQIrm", LIEF::assembly::x86::OPCODE::VMOV64toPQIrm)
  .value("VMOV64toPQIrr", LIEF::assembly::x86::OPCODE::VMOV64toPQIrr)
  .value("VMOV64toSDZrr", LIEF::assembly::x86::OPCODE::VMOV64toSDZrr)
  .value("VMOV64toSDrr", LIEF::assembly::x86::OPCODE::VMOV64toSDrr)
  .value("VMOVAPDYmr", LIEF::assembly::x86::OPCODE::VMOVAPDYmr)
  .value("VMOVAPDYrm", LIEF::assembly::x86::OPCODE::VMOVAPDYrm)
  .value("VMOVAPDYrr", LIEF::assembly::x86::OPCODE::VMOVAPDYrr)
  .value("VMOVAPDYrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPDYrr_REV)
  .value("VMOVAPDZ128mr", LIEF::assembly::x86::OPCODE::VMOVAPDZ128mr)
  .value("VMOVAPDZ128mrk", LIEF::assembly::x86::OPCODE::VMOVAPDZ128mrk)
  .value("VMOVAPDZ128rm", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rm)
  .value("VMOVAPDZ128rmk", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rmk)
  .value("VMOVAPDZ128rmkz", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rmkz)
  .value("VMOVAPDZ128rr", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rr)
  .value("VMOVAPDZ128rr_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rr_REV)
  .value("VMOVAPDZ128rrk", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rrk)
  .value("VMOVAPDZ128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rrk_REV)
  .value("VMOVAPDZ128rrkz", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rrkz)
  .value("VMOVAPDZ128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ128rrkz_REV);
  opcodes.value("VMOVAPDZ256mr", LIEF::assembly::x86::OPCODE::VMOVAPDZ256mr)
  .value("VMOVAPDZ256mrk", LIEF::assembly::x86::OPCODE::VMOVAPDZ256mrk)
  .value("VMOVAPDZ256rm", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rm)
  .value("VMOVAPDZ256rmk", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rmk)
  .value("VMOVAPDZ256rmkz", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rmkz)
  .value("VMOVAPDZ256rr", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rr)
  .value("VMOVAPDZ256rr_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rr_REV)
  .value("VMOVAPDZ256rrk", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rrk)
  .value("VMOVAPDZ256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rrk_REV)
  .value("VMOVAPDZ256rrkz", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rrkz)
  .value("VMOVAPDZ256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZ256rrkz_REV)
  .value("VMOVAPDZmr", LIEF::assembly::x86::OPCODE::VMOVAPDZmr)
  .value("VMOVAPDZmrk", LIEF::assembly::x86::OPCODE::VMOVAPDZmrk)
  .value("VMOVAPDZrm", LIEF::assembly::x86::OPCODE::VMOVAPDZrm)
  .value("VMOVAPDZrmk", LIEF::assembly::x86::OPCODE::VMOVAPDZrmk)
  .value("VMOVAPDZrmkz", LIEF::assembly::x86::OPCODE::VMOVAPDZrmkz)
  .value("VMOVAPDZrr", LIEF::assembly::x86::OPCODE::VMOVAPDZrr)
  .value("VMOVAPDZrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZrr_REV)
  .value("VMOVAPDZrrk", LIEF::assembly::x86::OPCODE::VMOVAPDZrrk)
  .value("VMOVAPDZrrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZrrk_REV)
  .value("VMOVAPDZrrkz", LIEF::assembly::x86::OPCODE::VMOVAPDZrrkz)
  .value("VMOVAPDZrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPDZrrkz_REV)
  .value("VMOVAPDmr", LIEF::assembly::x86::OPCODE::VMOVAPDmr)
  .value("VMOVAPDrm", LIEF::assembly::x86::OPCODE::VMOVAPDrm)
  .value("VMOVAPDrr", LIEF::assembly::x86::OPCODE::VMOVAPDrr)
  .value("VMOVAPDrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPDrr_REV)
  .value("VMOVAPSYmr", LIEF::assembly::x86::OPCODE::VMOVAPSYmr)
  .value("VMOVAPSYrm", LIEF::assembly::x86::OPCODE::VMOVAPSYrm)
  .value("VMOVAPSYrr", LIEF::assembly::x86::OPCODE::VMOVAPSYrr)
  .value("VMOVAPSYrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPSYrr_REV)
  .value("VMOVAPSZ128mr", LIEF::assembly::x86::OPCODE::VMOVAPSZ128mr)
  .value("VMOVAPSZ128mrk", LIEF::assembly::x86::OPCODE::VMOVAPSZ128mrk)
  .value("VMOVAPSZ128rm", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rm)
  .value("VMOVAPSZ128rmk", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rmk)
  .value("VMOVAPSZ128rmkz", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rmkz)
  .value("VMOVAPSZ128rr", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rr)
  .value("VMOVAPSZ128rr_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rr_REV)
  .value("VMOVAPSZ128rrk", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rrk)
  .value("VMOVAPSZ128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rrk_REV)
  .value("VMOVAPSZ128rrkz", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rrkz)
  .value("VMOVAPSZ128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ128rrkz_REV)
  .value("VMOVAPSZ256mr", LIEF::assembly::x86::OPCODE::VMOVAPSZ256mr)
  .value("VMOVAPSZ256mrk", LIEF::assembly::x86::OPCODE::VMOVAPSZ256mrk)
  .value("VMOVAPSZ256rm", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rm)
  .value("VMOVAPSZ256rmk", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rmk)
  .value("VMOVAPSZ256rmkz", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rmkz)
  .value("VMOVAPSZ256rr", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rr)
  .value("VMOVAPSZ256rr_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rr_REV)
  .value("VMOVAPSZ256rrk", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rrk)
  .value("VMOVAPSZ256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rrk_REV)
  .value("VMOVAPSZ256rrkz", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rrkz)
  .value("VMOVAPSZ256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZ256rrkz_REV)
  .value("VMOVAPSZmr", LIEF::assembly::x86::OPCODE::VMOVAPSZmr)
  .value("VMOVAPSZmrk", LIEF::assembly::x86::OPCODE::VMOVAPSZmrk)
  .value("VMOVAPSZrm", LIEF::assembly::x86::OPCODE::VMOVAPSZrm)
  .value("VMOVAPSZrmk", LIEF::assembly::x86::OPCODE::VMOVAPSZrmk)
  .value("VMOVAPSZrmkz", LIEF::assembly::x86::OPCODE::VMOVAPSZrmkz)
  .value("VMOVAPSZrr", LIEF::assembly::x86::OPCODE::VMOVAPSZrr)
  .value("VMOVAPSZrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZrr_REV)
  .value("VMOVAPSZrrk", LIEF::assembly::x86::OPCODE::VMOVAPSZrrk)
  .value("VMOVAPSZrrk_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZrrk_REV)
  .value("VMOVAPSZrrkz", LIEF::assembly::x86::OPCODE::VMOVAPSZrrkz)
  .value("VMOVAPSZrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVAPSZrrkz_REV)
  .value("VMOVAPSmr", LIEF::assembly::x86::OPCODE::VMOVAPSmr)
  .value("VMOVAPSrm", LIEF::assembly::x86::OPCODE::VMOVAPSrm)
  .value("VMOVAPSrr", LIEF::assembly::x86::OPCODE::VMOVAPSrr)
  .value("VMOVAPSrr_REV", LIEF::assembly::x86::OPCODE::VMOVAPSrr_REV)
  .value("VMOVDDUPYrm", LIEF::assembly::x86::OPCODE::VMOVDDUPYrm)
  .value("VMOVDDUPYrr", LIEF::assembly::x86::OPCODE::VMOVDDUPYrr)
  .value("VMOVDDUPZ128rm", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rm)
  .value("VMOVDDUPZ128rmk", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rmk)
  .value("VMOVDDUPZ128rmkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rmkz)
  .value("VMOVDDUPZ128rr", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rr)
  .value("VMOVDDUPZ128rrk", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rrk)
  .value("VMOVDDUPZ128rrkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZ128rrkz)
  .value("VMOVDDUPZ256rm", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rm)
  .value("VMOVDDUPZ256rmk", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rmk)
  .value("VMOVDDUPZ256rmkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rmkz)
  .value("VMOVDDUPZ256rr", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rr)
  .value("VMOVDDUPZ256rrk", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rrk)
  .value("VMOVDDUPZ256rrkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZ256rrkz)
  .value("VMOVDDUPZrm", LIEF::assembly::x86::OPCODE::VMOVDDUPZrm)
  .value("VMOVDDUPZrmk", LIEF::assembly::x86::OPCODE::VMOVDDUPZrmk)
  .value("VMOVDDUPZrmkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZrmkz)
  .value("VMOVDDUPZrr", LIEF::assembly::x86::OPCODE::VMOVDDUPZrr)
  .value("VMOVDDUPZrrk", LIEF::assembly::x86::OPCODE::VMOVDDUPZrrk)
  .value("VMOVDDUPZrrkz", LIEF::assembly::x86::OPCODE::VMOVDDUPZrrkz)
  .value("VMOVDDUPrm", LIEF::assembly::x86::OPCODE::VMOVDDUPrm)
  .value("VMOVDDUPrr", LIEF::assembly::x86::OPCODE::VMOVDDUPrr)
  .value("VMOVDI2PDIZrm", LIEF::assembly::x86::OPCODE::VMOVDI2PDIZrm)
  .value("VMOVDI2PDIZrr", LIEF::assembly::x86::OPCODE::VMOVDI2PDIZrr)
  .value("VMOVDI2PDIrm", LIEF::assembly::x86::OPCODE::VMOVDI2PDIrm)
  .value("VMOVDI2PDIrr", LIEF::assembly::x86::OPCODE::VMOVDI2PDIrr)
  .value("VMOVDI2SSZrr", LIEF::assembly::x86::OPCODE::VMOVDI2SSZrr)
  .value("VMOVDI2SSrr", LIEF::assembly::x86::OPCODE::VMOVDI2SSrr)
  .value("VMOVDQA32Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128mr)
  .value("VMOVDQA32Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128mrk)
  .value("VMOVDQA32Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rm)
  .value("VMOVDQA32Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rmk)
  .value("VMOVDQA32Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rmkz)
  .value("VMOVDQA32Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rr)
  .value("VMOVDQA32Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rr_REV)
  .value("VMOVDQA32Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rrk)
  .value("VMOVDQA32Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rrk_REV)
  .value("VMOVDQA32Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rrkz)
  .value("VMOVDQA32Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z128rrkz_REV)
  .value("VMOVDQA32Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256mr)
  .value("VMOVDQA32Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256mrk)
  .value("VMOVDQA32Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rm)
  .value("VMOVDQA32Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rmk)
  .value("VMOVDQA32Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rmkz)
  .value("VMOVDQA32Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rr)
  .value("VMOVDQA32Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rr_REV)
  .value("VMOVDQA32Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rrk)
  .value("VMOVDQA32Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rrk_REV)
  .value("VMOVDQA32Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rrkz)
  .value("VMOVDQA32Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Z256rrkz_REV)
  .value("VMOVDQA32Zmr", LIEF::assembly::x86::OPCODE::VMOVDQA32Zmr)
  .value("VMOVDQA32Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Zmrk)
  .value("VMOVDQA32Zrm", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrm)
  .value("VMOVDQA32Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrmk)
  .value("VMOVDQA32Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrmkz)
  .value("VMOVDQA32Zrr", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrr)
  .value("VMOVDQA32Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrr_REV)
  .value("VMOVDQA32Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrrk)
  .value("VMOVDQA32Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrrk_REV)
  .value("VMOVDQA32Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrrkz)
  .value("VMOVDQA32Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA32Zrrkz_REV)
  .value("VMOVDQA64Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128mr)
  .value("VMOVDQA64Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128mrk)
  .value("VMOVDQA64Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rm)
  .value("VMOVDQA64Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rmk)
  .value("VMOVDQA64Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rmkz)
  .value("VMOVDQA64Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rr)
  .value("VMOVDQA64Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rr_REV)
  .value("VMOVDQA64Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rrk)
  .value("VMOVDQA64Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rrk_REV)
  .value("VMOVDQA64Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rrkz)
  .value("VMOVDQA64Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z128rrkz_REV)
  .value("VMOVDQA64Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256mr)
  .value("VMOVDQA64Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256mrk)
  .value("VMOVDQA64Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rm)
  .value("VMOVDQA64Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rmk)
  .value("VMOVDQA64Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rmkz)
  .value("VMOVDQA64Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rr)
  .value("VMOVDQA64Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rr_REV)
  .value("VMOVDQA64Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rrk)
  .value("VMOVDQA64Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rrk_REV)
  .value("VMOVDQA64Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rrkz)
  .value("VMOVDQA64Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Z256rrkz_REV)
  .value("VMOVDQA64Zmr", LIEF::assembly::x86::OPCODE::VMOVDQA64Zmr)
  .value("VMOVDQA64Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Zmrk)
  .value("VMOVDQA64Zrm", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrm)
  .value("VMOVDQA64Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrmk)
  .value("VMOVDQA64Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrmkz)
  .value("VMOVDQA64Zrr", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrr)
  .value("VMOVDQA64Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrr_REV)
  .value("VMOVDQA64Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrrk)
  .value("VMOVDQA64Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrrk_REV)
  .value("VMOVDQA64Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrrkz)
  .value("VMOVDQA64Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQA64Zrrkz_REV)
  .value("VMOVDQAYmr", LIEF::assembly::x86::OPCODE::VMOVDQAYmr)
  .value("VMOVDQAYrm", LIEF::assembly::x86::OPCODE::VMOVDQAYrm)
  .value("VMOVDQAYrr", LIEF::assembly::x86::OPCODE::VMOVDQAYrr)
  .value("VMOVDQAYrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQAYrr_REV)
  .value("VMOVDQAmr", LIEF::assembly::x86::OPCODE::VMOVDQAmr)
  .value("VMOVDQArm", LIEF::assembly::x86::OPCODE::VMOVDQArm)
  .value("VMOVDQArr", LIEF::assembly::x86::OPCODE::VMOVDQArr)
  .value("VMOVDQArr_REV", LIEF::assembly::x86::OPCODE::VMOVDQArr_REV)
  .value("VMOVDQU16Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128mr)
  .value("VMOVDQU16Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128mrk)
  .value("VMOVDQU16Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rm)
  .value("VMOVDQU16Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rmk)
  .value("VMOVDQU16Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rmkz)
  .value("VMOVDQU16Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rr)
  .value("VMOVDQU16Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rr_REV)
  .value("VMOVDQU16Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rrk)
  .value("VMOVDQU16Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rrk_REV)
  .value("VMOVDQU16Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rrkz)
  .value("VMOVDQU16Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z128rrkz_REV)
  .value("VMOVDQU16Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256mr)
  .value("VMOVDQU16Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256mrk)
  .value("VMOVDQU16Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rm)
  .value("VMOVDQU16Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rmk)
  .value("VMOVDQU16Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rmkz)
  .value("VMOVDQU16Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rr)
  .value("VMOVDQU16Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rr_REV)
  .value("VMOVDQU16Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rrk)
  .value("VMOVDQU16Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rrk_REV)
  .value("VMOVDQU16Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rrkz)
  .value("VMOVDQU16Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Z256rrkz_REV)
  .value("VMOVDQU16Zmr", LIEF::assembly::x86::OPCODE::VMOVDQU16Zmr)
  .value("VMOVDQU16Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Zmrk)
  .value("VMOVDQU16Zrm", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrm)
  .value("VMOVDQU16Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrmk)
  .value("VMOVDQU16Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrmkz)
  .value("VMOVDQU16Zrr", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrr)
  .value("VMOVDQU16Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrr_REV)
  .value("VMOVDQU16Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrrk)
  .value("VMOVDQU16Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrrk_REV)
  .value("VMOVDQU16Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrrkz)
  .value("VMOVDQU16Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU16Zrrkz_REV)
  .value("VMOVDQU32Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128mr)
  .value("VMOVDQU32Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128mrk)
  .value("VMOVDQU32Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rm)
  .value("VMOVDQU32Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rmk)
  .value("VMOVDQU32Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rmkz)
  .value("VMOVDQU32Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rr)
  .value("VMOVDQU32Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rr_REV)
  .value("VMOVDQU32Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rrk)
  .value("VMOVDQU32Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rrk_REV)
  .value("VMOVDQU32Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rrkz)
  .value("VMOVDQU32Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z128rrkz_REV)
  .value("VMOVDQU32Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256mr)
  .value("VMOVDQU32Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256mrk)
  .value("VMOVDQU32Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rm)
  .value("VMOVDQU32Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rmk)
  .value("VMOVDQU32Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rmkz)
  .value("VMOVDQU32Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rr)
  .value("VMOVDQU32Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rr_REV)
  .value("VMOVDQU32Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rrk)
  .value("VMOVDQU32Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rrk_REV)
  .value("VMOVDQU32Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rrkz)
  .value("VMOVDQU32Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Z256rrkz_REV)
  .value("VMOVDQU32Zmr", LIEF::assembly::x86::OPCODE::VMOVDQU32Zmr)
  .value("VMOVDQU32Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Zmrk)
  .value("VMOVDQU32Zrm", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrm)
  .value("VMOVDQU32Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrmk)
  .value("VMOVDQU32Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrmkz)
  .value("VMOVDQU32Zrr", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrr)
  .value("VMOVDQU32Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrr_REV)
  .value("VMOVDQU32Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrrk)
  .value("VMOVDQU32Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrrk_REV)
  .value("VMOVDQU32Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrrkz)
  .value("VMOVDQU32Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU32Zrrkz_REV)
  .value("VMOVDQU64Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128mr)
  .value("VMOVDQU64Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128mrk)
  .value("VMOVDQU64Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rm)
  .value("VMOVDQU64Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rmk)
  .value("VMOVDQU64Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rmkz)
  .value("VMOVDQU64Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rr)
  .value("VMOVDQU64Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rr_REV)
  .value("VMOVDQU64Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rrk)
  .value("VMOVDQU64Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rrk_REV)
  .value("VMOVDQU64Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rrkz)
  .value("VMOVDQU64Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z128rrkz_REV)
  .value("VMOVDQU64Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256mr)
  .value("VMOVDQU64Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256mrk)
  .value("VMOVDQU64Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rm)
  .value("VMOVDQU64Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rmk)
  .value("VMOVDQU64Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rmkz)
  .value("VMOVDQU64Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rr)
  .value("VMOVDQU64Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rr_REV)
  .value("VMOVDQU64Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rrk)
  .value("VMOVDQU64Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rrk_REV)
  .value("VMOVDQU64Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rrkz)
  .value("VMOVDQU64Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Z256rrkz_REV)
  .value("VMOVDQU64Zmr", LIEF::assembly::x86::OPCODE::VMOVDQU64Zmr)
  .value("VMOVDQU64Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Zmrk)
  .value("VMOVDQU64Zrm", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrm)
  .value("VMOVDQU64Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrmk)
  .value("VMOVDQU64Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrmkz)
  .value("VMOVDQU64Zrr", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrr)
  .value("VMOVDQU64Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrr_REV)
  .value("VMOVDQU64Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrrk)
  .value("VMOVDQU64Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrrk_REV)
  .value("VMOVDQU64Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrrkz)
  .value("VMOVDQU64Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU64Zrrkz_REV)
  .value("VMOVDQU8Z128mr", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128mr)
  .value("VMOVDQU8Z128mrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128mrk)
  .value("VMOVDQU8Z128rm", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rm)
  .value("VMOVDQU8Z128rmk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rmk)
  .value("VMOVDQU8Z128rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rmkz)
  .value("VMOVDQU8Z128rr", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rr)
  .value("VMOVDQU8Z128rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rr_REV)
  .value("VMOVDQU8Z128rrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rrk)
  .value("VMOVDQU8Z128rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rrk_REV)
  .value("VMOVDQU8Z128rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rrkz)
  .value("VMOVDQU8Z128rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z128rrkz_REV)
  .value("VMOVDQU8Z256mr", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256mr)
  .value("VMOVDQU8Z256mrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256mrk)
  .value("VMOVDQU8Z256rm", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rm)
  .value("VMOVDQU8Z256rmk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rmk)
  .value("VMOVDQU8Z256rmkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rmkz)
  .value("VMOVDQU8Z256rr", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rr)
  .value("VMOVDQU8Z256rr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rr_REV)
  .value("VMOVDQU8Z256rrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rrk)
  .value("VMOVDQU8Z256rrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rrk_REV)
  .value("VMOVDQU8Z256rrkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rrkz)
  .value("VMOVDQU8Z256rrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Z256rrkz_REV)
  .value("VMOVDQU8Zmr", LIEF::assembly::x86::OPCODE::VMOVDQU8Zmr)
  .value("VMOVDQU8Zmrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Zmrk)
  .value("VMOVDQU8Zrm", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrm)
  .value("VMOVDQU8Zrmk", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrmk)
  .value("VMOVDQU8Zrmkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrmkz)
  .value("VMOVDQU8Zrr", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrr)
  .value("VMOVDQU8Zrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrr_REV)
  .value("VMOVDQU8Zrrk", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrrk)
  .value("VMOVDQU8Zrrk_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrrk_REV)
  .value("VMOVDQU8Zrrkz", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrrkz);
  opcodes.value("VMOVDQU8Zrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVDQU8Zrrkz_REV)
  .value("VMOVDQUYmr", LIEF::assembly::x86::OPCODE::VMOVDQUYmr)
  .value("VMOVDQUYrm", LIEF::assembly::x86::OPCODE::VMOVDQUYrm)
  .value("VMOVDQUYrr", LIEF::assembly::x86::OPCODE::VMOVDQUYrr)
  .value("VMOVDQUYrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQUYrr_REV)
  .value("VMOVDQUmr", LIEF::assembly::x86::OPCODE::VMOVDQUmr)
  .value("VMOVDQUrm", LIEF::assembly::x86::OPCODE::VMOVDQUrm)
  .value("VMOVDQUrr", LIEF::assembly::x86::OPCODE::VMOVDQUrr)
  .value("VMOVDQUrr_REV", LIEF::assembly::x86::OPCODE::VMOVDQUrr_REV)
  .value("VMOVHLPSZrr", LIEF::assembly::x86::OPCODE::VMOVHLPSZrr)
  .value("VMOVHLPSrr", LIEF::assembly::x86::OPCODE::VMOVHLPSrr)
  .value("VMOVHPDZ128mr", LIEF::assembly::x86::OPCODE::VMOVHPDZ128mr)
  .value("VMOVHPDZ128rm", LIEF::assembly::x86::OPCODE::VMOVHPDZ128rm)
  .value("VMOVHPDmr", LIEF::assembly::x86::OPCODE::VMOVHPDmr)
  .value("VMOVHPDrm", LIEF::assembly::x86::OPCODE::VMOVHPDrm)
  .value("VMOVHPSZ128mr", LIEF::assembly::x86::OPCODE::VMOVHPSZ128mr)
  .value("VMOVHPSZ128rm", LIEF::assembly::x86::OPCODE::VMOVHPSZ128rm)
  .value("VMOVHPSmr", LIEF::assembly::x86::OPCODE::VMOVHPSmr)
  .value("VMOVHPSrm", LIEF::assembly::x86::OPCODE::VMOVHPSrm)
  .value("VMOVLHPSZrr", LIEF::assembly::x86::OPCODE::VMOVLHPSZrr)
  .value("VMOVLHPSrr", LIEF::assembly::x86::OPCODE::VMOVLHPSrr)
  .value("VMOVLPDZ128mr", LIEF::assembly::x86::OPCODE::VMOVLPDZ128mr)
  .value("VMOVLPDZ128rm", LIEF::assembly::x86::OPCODE::VMOVLPDZ128rm)
  .value("VMOVLPDmr", LIEF::assembly::x86::OPCODE::VMOVLPDmr)
  .value("VMOVLPDrm", LIEF::assembly::x86::OPCODE::VMOVLPDrm)
  .value("VMOVLPSZ128mr", LIEF::assembly::x86::OPCODE::VMOVLPSZ128mr)
  .value("VMOVLPSZ128rm", LIEF::assembly::x86::OPCODE::VMOVLPSZ128rm)
  .value("VMOVLPSmr", LIEF::assembly::x86::OPCODE::VMOVLPSmr)
  .value("VMOVLPSrm", LIEF::assembly::x86::OPCODE::VMOVLPSrm)
  .value("VMOVMSKPDYrr", LIEF::assembly::x86::OPCODE::VMOVMSKPDYrr)
  .value("VMOVMSKPDrr", LIEF::assembly::x86::OPCODE::VMOVMSKPDrr)
  .value("VMOVMSKPSYrr", LIEF::assembly::x86::OPCODE::VMOVMSKPSYrr)
  .value("VMOVMSKPSrr", LIEF::assembly::x86::OPCODE::VMOVMSKPSrr)
  .value("VMOVNTDQAYrm", LIEF::assembly::x86::OPCODE::VMOVNTDQAYrm)
  .value("VMOVNTDQAZ128rm", LIEF::assembly::x86::OPCODE::VMOVNTDQAZ128rm)
  .value("VMOVNTDQAZ256rm", LIEF::assembly::x86::OPCODE::VMOVNTDQAZ256rm)
  .value("VMOVNTDQAZrm", LIEF::assembly::x86::OPCODE::VMOVNTDQAZrm)
  .value("VMOVNTDQArm", LIEF::assembly::x86::OPCODE::VMOVNTDQArm)
  .value("VMOVNTDQYmr", LIEF::assembly::x86::OPCODE::VMOVNTDQYmr)
  .value("VMOVNTDQZ128mr", LIEF::assembly::x86::OPCODE::VMOVNTDQZ128mr)
  .value("VMOVNTDQZ256mr", LIEF::assembly::x86::OPCODE::VMOVNTDQZ256mr)
  .value("VMOVNTDQZmr", LIEF::assembly::x86::OPCODE::VMOVNTDQZmr)
  .value("VMOVNTDQmr", LIEF::assembly::x86::OPCODE::VMOVNTDQmr)
  .value("VMOVNTPDYmr", LIEF::assembly::x86::OPCODE::VMOVNTPDYmr)
  .value("VMOVNTPDZ128mr", LIEF::assembly::x86::OPCODE::VMOVNTPDZ128mr)
  .value("VMOVNTPDZ256mr", LIEF::assembly::x86::OPCODE::VMOVNTPDZ256mr)
  .value("VMOVNTPDZmr", LIEF::assembly::x86::OPCODE::VMOVNTPDZmr)
  .value("VMOVNTPDmr", LIEF::assembly::x86::OPCODE::VMOVNTPDmr)
  .value("VMOVNTPSYmr", LIEF::assembly::x86::OPCODE::VMOVNTPSYmr)
  .value("VMOVNTPSZ128mr", LIEF::assembly::x86::OPCODE::VMOVNTPSZ128mr)
  .value("VMOVNTPSZ256mr", LIEF::assembly::x86::OPCODE::VMOVNTPSZ256mr)
  .value("VMOVNTPSZmr", LIEF::assembly::x86::OPCODE::VMOVNTPSZmr)
  .value("VMOVNTPSmr", LIEF::assembly::x86::OPCODE::VMOVNTPSmr)
  .value("VMOVPDI2DIZmr", LIEF::assembly::x86::OPCODE::VMOVPDI2DIZmr)
  .value("VMOVPDI2DIZrr", LIEF::assembly::x86::OPCODE::VMOVPDI2DIZrr)
  .value("VMOVPDI2DImr", LIEF::assembly::x86::OPCODE::VMOVPDI2DImr)
  .value("VMOVPDI2DIrr", LIEF::assembly::x86::OPCODE::VMOVPDI2DIrr)
  .value("VMOVPQI2QIZmr", LIEF::assembly::x86::OPCODE::VMOVPQI2QIZmr)
  .value("VMOVPQI2QIZrr", LIEF::assembly::x86::OPCODE::VMOVPQI2QIZrr)
  .value("VMOVPQI2QImr", LIEF::assembly::x86::OPCODE::VMOVPQI2QImr)
  .value("VMOVPQI2QIrr", LIEF::assembly::x86::OPCODE::VMOVPQI2QIrr)
  .value("VMOVPQIto64Zmr", LIEF::assembly::x86::OPCODE::VMOVPQIto64Zmr)
  .value("VMOVPQIto64Zrr", LIEF::assembly::x86::OPCODE::VMOVPQIto64Zrr)
  .value("VMOVPQIto64mr", LIEF::assembly::x86::OPCODE::VMOVPQIto64mr)
  .value("VMOVPQIto64rr", LIEF::assembly::x86::OPCODE::VMOVPQIto64rr)
  .value("VMOVQI2PQIZrm", LIEF::assembly::x86::OPCODE::VMOVQI2PQIZrm)
  .value("VMOVQI2PQIrm", LIEF::assembly::x86::OPCODE::VMOVQI2PQIrm)
  .value("VMOVRSBZ128m", LIEF::assembly::x86::OPCODE::VMOVRSBZ128m)
  .value("VMOVRSBZ128mk", LIEF::assembly::x86::OPCODE::VMOVRSBZ128mk)
  .value("VMOVRSBZ128mkz", LIEF::assembly::x86::OPCODE::VMOVRSBZ128mkz)
  .value("VMOVRSBZ256m", LIEF::assembly::x86::OPCODE::VMOVRSBZ256m)
  .value("VMOVRSBZ256mk", LIEF::assembly::x86::OPCODE::VMOVRSBZ256mk)
  .value("VMOVRSBZ256mkz", LIEF::assembly::x86::OPCODE::VMOVRSBZ256mkz)
  .value("VMOVRSBZm", LIEF::assembly::x86::OPCODE::VMOVRSBZm)
  .value("VMOVRSBZmk", LIEF::assembly::x86::OPCODE::VMOVRSBZmk)
  .value("VMOVRSBZmkz", LIEF::assembly::x86::OPCODE::VMOVRSBZmkz)
  .value("VMOVRSDZ128m", LIEF::assembly::x86::OPCODE::VMOVRSDZ128m)
  .value("VMOVRSDZ128mk", LIEF::assembly::x86::OPCODE::VMOVRSDZ128mk)
  .value("VMOVRSDZ128mkz", LIEF::assembly::x86::OPCODE::VMOVRSDZ128mkz)
  .value("VMOVRSDZ256m", LIEF::assembly::x86::OPCODE::VMOVRSDZ256m)
  .value("VMOVRSDZ256mk", LIEF::assembly::x86::OPCODE::VMOVRSDZ256mk)
  .value("VMOVRSDZ256mkz", LIEF::assembly::x86::OPCODE::VMOVRSDZ256mkz)
  .value("VMOVRSDZm", LIEF::assembly::x86::OPCODE::VMOVRSDZm)
  .value("VMOVRSDZmk", LIEF::assembly::x86::OPCODE::VMOVRSDZmk)
  .value("VMOVRSDZmkz", LIEF::assembly::x86::OPCODE::VMOVRSDZmkz)
  .value("VMOVRSQZ128m", LIEF::assembly::x86::OPCODE::VMOVRSQZ128m)
  .value("VMOVRSQZ128mk", LIEF::assembly::x86::OPCODE::VMOVRSQZ128mk)
  .value("VMOVRSQZ128mkz", LIEF::assembly::x86::OPCODE::VMOVRSQZ128mkz)
  .value("VMOVRSQZ256m", LIEF::assembly::x86::OPCODE::VMOVRSQZ256m)
  .value("VMOVRSQZ256mk", LIEF::assembly::x86::OPCODE::VMOVRSQZ256mk)
  .value("VMOVRSQZ256mkz", LIEF::assembly::x86::OPCODE::VMOVRSQZ256mkz)
  .value("VMOVRSQZm", LIEF::assembly::x86::OPCODE::VMOVRSQZm)
  .value("VMOVRSQZmk", LIEF::assembly::x86::OPCODE::VMOVRSQZmk)
  .value("VMOVRSQZmkz", LIEF::assembly::x86::OPCODE::VMOVRSQZmkz)
  .value("VMOVRSWZ128m", LIEF::assembly::x86::OPCODE::VMOVRSWZ128m)
  .value("VMOVRSWZ128mk", LIEF::assembly::x86::OPCODE::VMOVRSWZ128mk)
  .value("VMOVRSWZ128mkz", LIEF::assembly::x86::OPCODE::VMOVRSWZ128mkz)
  .value("VMOVRSWZ256m", LIEF::assembly::x86::OPCODE::VMOVRSWZ256m)
  .value("VMOVRSWZ256mk", LIEF::assembly::x86::OPCODE::VMOVRSWZ256mk)
  .value("VMOVRSWZ256mkz", LIEF::assembly::x86::OPCODE::VMOVRSWZ256mkz)
  .value("VMOVRSWZm", LIEF::assembly::x86::OPCODE::VMOVRSWZm)
  .value("VMOVRSWZmk", LIEF::assembly::x86::OPCODE::VMOVRSWZmk)
  .value("VMOVRSWZmkz", LIEF::assembly::x86::OPCODE::VMOVRSWZmkz)
  .value("VMOVSDZmr", LIEF::assembly::x86::OPCODE::VMOVSDZmr)
  .value("VMOVSDZmrk", LIEF::assembly::x86::OPCODE::VMOVSDZmrk)
  .value("VMOVSDZrm", LIEF::assembly::x86::OPCODE::VMOVSDZrm)
  .value("VMOVSDZrm_alt", LIEF::assembly::x86::OPCODE::VMOVSDZrm_alt)
  .value("VMOVSDZrmk", LIEF::assembly::x86::OPCODE::VMOVSDZrmk)
  .value("VMOVSDZrmkz", LIEF::assembly::x86::OPCODE::VMOVSDZrmkz)
  .value("VMOVSDZrr", LIEF::assembly::x86::OPCODE::VMOVSDZrr)
  .value("VMOVSDZrr_REV", LIEF::assembly::x86::OPCODE::VMOVSDZrr_REV)
  .value("VMOVSDZrrk", LIEF::assembly::x86::OPCODE::VMOVSDZrrk)
  .value("VMOVSDZrrk_REV", LIEF::assembly::x86::OPCODE::VMOVSDZrrk_REV)
  .value("VMOVSDZrrkz", LIEF::assembly::x86::OPCODE::VMOVSDZrrkz)
  .value("VMOVSDZrrkz_REV", LIEF::assembly::x86::OPCODE::VMOVSDZrrkz_REV)
  .value("VMOVSDmr", LIEF::assembly::x86::OPCODE::VMOVSDmr)
  .value("VMOVSDrm", LIEF::assembly::x86::OPCODE::VMOVSDrm)
  .value("VMOVSDrm_alt", LIEF::assembly::x86::OPCODE::VMOVSDrm_alt)
  .value("VMOVSDrr", LIEF::assembly::x86::OPCODE::VMOVSDrr)
  .value("VMOVSDrr_REV", LIEF::assembly::x86::OPCODE::VMOVSDrr_REV)
  .value("VMOVSDto64Zrr", LIEF::assembly::x86::OPCODE::VMOVSDto64Zrr)
  .value("VMOVSDto64rr", LIEF::assembly::x86::OPCODE::VMOVSDto64rr)
  .value("VMOVSH2Wrr", LIEF::assembly::x86::OPCODE::VMOVSH2Wrr)
  .value("VMOVSHDUPYrm", LIEF::assembly::x86::OPCODE::VMOVSHDUPYrm)
  .value("VMOVSHDUPYrr", LIEF::assembly::x86::OPCODE::VMOVSHDUPYrr)
  .value("VMOVSHDUPZ128rm", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rm)
  .value("VMOVSHDUPZ128rmk", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rmk)
  .value("VMOVSHDUPZ128rmkz", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rmkz)
  .value("VMOVSHDUPZ128rr", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rr)
  .value("VMOVSHDUPZ128rrk", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rrk)
  .value("VMOVSHDUPZ128rrkz", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ128rrkz)
  .value("VMOVSHDUPZ256rm", LIEF::assembly::x86::OPCODE::VMOVSHDUPZ256rm)
  .value("VMOVSHDUPZ256rmk", L