## ALSA support ##
find_package(ALSA)
check_include_file_cxx("sys/eventfd.h" LIBREMIDI_HAS_EVENTFD)
check_include_file_cxx("sys/timerfd.h" LIBREMIDI_HAS_TIMERFD)

if(ALSA_FOUND AND LIBREMIDI_HAS_EVENTFD AND LIBREMIDI_HAS_TIMERFD)
  set(LIBREMIDI_HAS_ALSA 1)

  message(STATUS "libremidi: using ALSA")

  set(CMAKE_REQUIRED_INCLUDES "${ALSA_INCLUDE_DIR}")
  set(CMAKE_REQUIRED_LIBRARIES "asound")
  check_symbol_exists("snd_rawmidi_tread" "alsa/asoundlib.h" LIBREMIDI_HAS_ALSA_RAWMIDI)
  check_symbol_exists("snd_ump_open" "alsa/asoundlib.h" LIBREMIDI_HAS_ALSA_UMP)
  unset(CMAKE_REQUIRED_INCLUDES)
  unset(CMAKE_REQUIRED_LIBRARIES)

  message(STATUS "libremidi: ALSA RawMIDI: ${LIBREMIDI_HAS_ALSA_RAWMIDI}")
  message(STATUS "libremidi: ALSA UMP: ${LIBREMIDI_HAS_ALSA_UMP}")
  target_compile_definitions(libremidi ${_public} LIBREMIDI_ALSA)
  target_include_directories(libremidi SYSTEM ${_public} "${ALSA_INCLUDE_DIR}")
  target_link_libraries(libremidi ${_public} "${CMAKE_DL_LIBS}")

  if(NOT LIBREMIDI_NO_UDEV)
    find_path(UDEV_INCLUDE_DIR libudev.h)
    message(STATUS "libremidi: udev support")
    if(UDEV_INCLUDE_DIR)
      target_compile_definitions(libremidi ${_public} LIBREMIDI_HAS_UDEV)
      target_include_directories(libremidi SYSTEM ${_public} "${UDEV_INCLUDE_DIR}")
    endif()
  endif()
else()
  if (NOT ALSA_FOUND)
    message(STATUS "libremidi: ALSA not found")
  endif()
  if (NOT LIBREMIDI_HAS_EVENTFD)
    message(STATUS "libremidi:sys/eventfd.h not found")
  endif()
  if (NOT LIBREMIDI_HAS_TIMERFD)
    message(STATUS "libremidi:sys/timerfd.h not found")
  endif()
  message(STATUS "libremidi: not using ALSA because some of these isn't found: ALSA, sys/eventfd.h, sys/timerfd.h")
endif()
