Minutes from 52nd OpenVDB TSC meeting, June 18th, 2020, (GMT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: JT Nelson (Blender), Brecht Van Lommel,
Larry Gritz, Andre Pradhana (DW), Bruce Chernia (Intel).

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) JE Malloc Issues
4) Boost
5) AX
6) Fast Sweeping
7) Next meeting


1) Quorum was confirmed.

2) Secretary was Jeff Lait

3) JE Malloc Issues

JE Malloc 5 has an issue that loading dynamically can fail.  Latest Ubuntu has
an issue with this.  Generating hard to trace memory problems from an
application that brings in OpenVDB, and OpenVDB's default build links in
jemalloc.  So should jemalloc be included in openvdb at all?  This should be
the top level application.  So we should change the default to None.  The
concern is that people will not know to use jemalloc, so end up with slow
performance.  Maybe a way to check?  Print out if it is missing with an env
variable?  Having OpenVDB override the allocator makes it hard to even test
different allocators.

We can make a CMake target that also includes jemalloc.
The VDB applications should be using jemalloc.  Unanimous consent on setting
the default to None.

4) Boost

Most of the easy boost dependencies are removed.  So the hard ones are for the
rest of the TSC to fix.

Interprocess Module: Tricky

UUID: Ken believes this should be replaced with a hash, as it is just to find quickly same grids.  Current UUID approach is too conservative so doesn't help find identical grids.  The concern is that computing the hash would be significant.  However we have to traverse the grid anyways to save; so a hash may just be CPU cost.  Can be used for delayed loading.

Conversion Traits: To select numeric types of higher precision.  Used primarily for selecting container sizes.  Boost can handle nested container types.  This is likely solveable.

PRs exist for replacing MPL.  boost::string replacments.  And replace boost::any with the existing MetaMap.

Most PRs have merit, but string is a re-invention problem.

We need to decide if we are trying to avoid future boost, and being willing to do extra work to get rid of existing boost requirements.

Motion: We will not introduce more boost
- unanimous

Motion: We will remove boost, possibly rewriting code, or making it optional.  But not by adding more dependencies.
- unanimous

Dan will look at Half being optional and inteprocess optional.
Nick will look at conversion types/traits.

5) AX

New feature branch.  Will address Dan's feedback.  Question is if we should switch to a submodule implementation.  Lot of changes are being pushed up.  Be hard to keep syncing to the feature branch.

We are not sure of legality of submodules.

Instead try to get the feature_ax branch sent in, then replace the working branch at DNeg with a new version forked from the ASWF.

Still on target for Siggraph.

6) Fast Sweeping

New Draft PR for evaluation.  Need feedback on the API.

No significant changes from a week ago.

Still wish for more performance.  Sorting is a bottleneck. 

7) Next Meeting

June 25th, 2020. 2pm-3pm EDT (GMT-4).
