; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=infer-alignment -S | FileCheck %s

; InferAlignment should be able to prove vector alignment in the
; presence of a few mild address computation tricks.

; ------------------------------------------------------------------------------
; alloca
; ------------------------------------------------------------------------------

define void @alloca(<2 x i64> %y) {
; CHECK-LABEL: define void @alloca
; CHECK-SAME: (<2 x i64> [[Y:%.*]]) {
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca <2 x i64>, align 16
; CHECK-NEXT:    [[LOAD:%.*]] = load <2 x i64>, ptr [[ALLOCA]], align 16
; CHECK-NEXT:    store <2 x i64> [[Y]], ptr [[ALLOCA]], align 16
; CHECK-NEXT:    ret void
;
  %alloca = alloca <2 x i64>
  %load = load <2 x i64>, ptr %alloca, align 1
  store <2 x i64> %y, ptr %alloca, align 1
  ret void
}

; ------------------------------------------------------------------------------
; global
; ------------------------------------------------------------------------------

@x.vector = external global <2 x i64>, align 16

define void @global(<2 x i64> %y) {
; CHECK-LABEL: define void @global
; CHECK-SAME: (<2 x i64> [[Y:%.*]]) {
; CHECK-NEXT:    [[LOAD:%.*]] = load <2 x i64>, ptr @x.vector, align 16
; CHECK-NEXT:    store <2 x i64> [[Y]], ptr @x.vector, align 16
; CHECK-NEXT:    ret void
;
  %load = load <2 x i64>, ptr @x.vector, align 1
  store <2 x i64> %y, ptr @x.vector, align 1
  ret void
}

; ------------------------------------------------------------------------------
; getelementptr
; ------------------------------------------------------------------------------

@vector = external global <2 x i64>, align 16
@vector.arr = external global [13 x <2 x i64>], align 16

; ------------------------------------------------------------------------------
; 1d access
; ------------------------------------------------------------------------------

define void @vector_singular(i32 %i, <2 x i64> %y) {
; CHECK-LABEL: define void @vector_singular
; CHECK-SAME: (i32 [[I:%.*]], <2 x i64> [[Y:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr <2 x i64>, ptr @vector, i32 [[I]]
; CHECK-NEXT:    [[LOAD:%.*]] = load <2 x i64>, ptr [[GEP]], align 16
; CHECK-NEXT:    store <2 x i64> [[Y]], ptr [[GEP]], align 16
; CHECK-NEXT:    ret void
;
  %gep = getelementptr <2 x i64>, ptr @vector, i32 %i
  %load = load <2 x i64>, ptr %gep, align 1
  store <2 x i64> %y, ptr %gep, align 1
  ret void
}

; ------------------------------------------------------------------------------
; 2d access
; ------------------------------------------------------------------------------

define void @vector_array(i32 %i, i32 %j, <2 x i64> %y) {
; CHECK-LABEL: define void @vector_array
; CHECK-SAME: (i32 [[I:%.*]], i32 [[J:%.*]], <2 x i64> [[Y:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr [13 x <2 x i64>], ptr @vector.arr, i32 [[I]], i32 [[J]]
; CHECK-NEXT:    [[LOAD:%.*]] = load <2 x i64>, ptr [[GEP]], align 16
; CHECK-NEXT:    store <2 x i64> [[Y]], ptr [[GEP]], align 16
; CHECK-NEXT:    ret void
;
  %gep = getelementptr [13 x <2 x i64>], ptr @vector.arr, i32 %i, i32 %j
  %load = load <2 x i64>, ptr %gep, align 1
  store <2 x i64> %y, ptr %gep, align 1
  ret void
}

; ------------------------------------------------------------------------------
; non-vector array type
; ------------------------------------------------------------------------------

; When we see a unaligned load or store from an insufficiently aligned global or
; alloca, increase the alignment, turning it into an aligned load or store.
@x.array = internal global [4 x i32] zeroinitializer

define void @nonvector_array() {
; CHECK-LABEL: define void @nonvector_array() {
; CHECK-NEXT:    [[LOAD_0:%.*]] = load <16 x i8>, ptr @x.array, align 16
; CHECK-NEXT:    store <16 x i8> zeroinitializer, ptr @x.array, align 16
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr [4 x i32], ptr @x.array, i16 0, i16 2
; CHECK-NEXT:    [[LOAD_1:%.*]] = load <16 x i8>, ptr [[GEP]], align 8
; CHECK-NEXT:    store <16 x i8> zeroinitializer, ptr [[GEP]], align 8
; CHECK-NEXT:    ret void
;
  %load.0 = load <16 x i8>, ptr @x.array, align 1
  store <16 x i8> zeroinitializer, ptr @x.array, align 1

  %gep = getelementptr [4 x i32], ptr @x.array, i16 0, i16 2
  %load.1 = load <16 x i8>, ptr %gep, align 1
  store <16 x i8> zeroinitializer, ptr %gep, align 1

  ret void
}
