; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

;; Test sext/zext/trunc

define i8 @sext_i1_to_i8(i1 %a) {
; LA32R-LABEL: sext_i1_to_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    sub.w $a0, $zero, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i1_to_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    sub.w $a0, $zero, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i1_to_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    sub.d $a0, $zero, $a0
; LA64-NEXT:    ret
  %1 = sext i1 %a to i8
  ret i8 %1
}

define i16 @sext_i1_to_i16(i1 %a) {
; LA32R-LABEL: sext_i1_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    sub.w $a0, $zero, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i1_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    sub.w $a0, $zero, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i1_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    sub.d $a0, $zero, $a0
; LA64-NEXT:    ret
  %1 = sext i1 %a to i16
  ret i16 %1
}

define i32 @sext_i1_to_i32(i1 %a) {
; LA32R-LABEL: sext_i1_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    sub.w $a0, $zero, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i1_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    sub.w $a0, $zero, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i1_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    sub.d $a0, $zero, $a0
; LA64-NEXT:    ret
  %1 = sext i1 %a to i32
  ret i32 %1
}

define i64 @sext_i1_to_i64(i1 %a) {
; LA32R-LABEL: sext_i1_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    sub.w $a0, $zero, $a0
; LA32R-NEXT:    move $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i1_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    sub.w $a0, $zero, $a0
; LA32S-NEXT:    move $a1, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i1_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    sub.d $a0, $zero, $a0
; LA64-NEXT:    ret
  %1 = sext i1 %a to i64
  ret i64 %1
}

define i16 @sext_i8_to_i16(i8 %a) {
; LA32R-LABEL: sext_i8_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a0, $a0, 24
; LA32R-NEXT:    srai.w $a0, $a0, 24
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i8_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ext.w.b $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i8_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    ret
  %1 = sext i8 %a to i16
  ret i16 %1
}

define i32 @sext_i8_to_i32(i8 %a) {
; LA32R-LABEL: sext_i8_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a0, $a0, 24
; LA32R-NEXT:    srai.w $a0, $a0, 24
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i8_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ext.w.b $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i8_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    ret
  %1 = sext i8 %a to i32
  ret i32 %1
}

define i64 @sext_i8_to_i64(i8 %a) {
; LA32R-LABEL: sext_i8_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 24
; LA32R-NEXT:    srai.w $a0, $a1, 24
; LA32R-NEXT:    srai.w $a1, $a1, 31
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i8_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ext.w.b $a0, $a0
; LA32S-NEXT:    srai.w $a1, $a0, 31
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i8_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    ret
  %1 = sext i8 %a to i64
  ret i64 %1
}

define i32 @sext_i16_to_i32(i16 %a) {
; LA32R-LABEL: sext_i16_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a0, $a0, 16
; LA32R-NEXT:    srai.w $a0, $a0, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i16_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ext.w.h $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i16_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    ret
  %1 = sext i16 %a to i32
  ret i32 %1
}

define i64 @sext_i16_to_i64(i16 %a) {
; LA32R-LABEL: sext_i16_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 16
; LA32R-NEXT:    srai.w $a0, $a1, 16
; LA32R-NEXT:    srai.w $a1, $a1, 31
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i16_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ext.w.h $a0, $a0
; LA32S-NEXT:    srai.w $a1, $a0, 31
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i16_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    ret
  %1 = sext i16 %a to i64
  ret i64 %1
}

define i64 @sext_i32_to_i64(i32 %a) {
; LA32R-LABEL: sext_i32_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srai.w $a1, $a0, 31
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sext_i32_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srai.w $a1, $a0, 31
; LA32S-NEXT:    ret
;
; LA64-LABEL: sext_i32_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    ret
  %1 = sext i32 %a to i64
  ret i64 %1
}

define i8 @zext_i1_to_i8(i1 %a) {
; LA32R-LABEL: zext_i1_to_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i1_to_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i1_to_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    ret
  %1 = zext i1 %a to i8
  ret i8 %1
}

define i16 @zext_i1_to_i16(i1 %a) {
; LA32R-LABEL: zext_i1_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i1_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i1_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    ret
  %1 = zext i1 %a to i16
  ret i16 %1
}

define i32 @zext_i1_to_i32(i1 %a) {
; LA32R-LABEL: zext_i1_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i1_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i1_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    ret
  %1 = zext i1 %a to i32
  ret i32 %1
}

define i64 @zext_i1_to_i64(i1 %a) {
; LA32R-LABEL: zext_i1_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i1_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i1_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    ret
  %1 = zext i1 %a to i64
  ret i64 %1
}

define i16 @zext_i8_to_i16(i8 %a) {
; LA32R-LABEL: zext_i8_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 255
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i8_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i8_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    ret
  %1 = zext i8 %a to i16
  ret i16 %1
}

define i32 @zext_i8_to_i32(i8 %a) {
; LA32R-LABEL: zext_i8_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 255
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i8_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i8_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    ret
  %1 = zext i8 %a to i32
  ret i32 %1
}

define i64 @zext_i8_to_i64(i8 %a) {
; LA32R-LABEL: zext_i8_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 255
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i8_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i8_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    ret
  %1 = zext i8 %a to i64
  ret i64 %1
}

define i32 @zext_i16_to_i32(i16 %a) {
; LA32R-LABEL: zext_i16_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a1, 15
; LA32R-NEXT:    ori $a1, $a1, 4095
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i16_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i16_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    ret
  %1 = zext i16 %a to i32
  ret i32 %1
}

define i64 @zext_i16_to_i64(i16 %a) {
; LA32R-LABEL: zext_i16_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a1, 15
; LA32R-NEXT:    ori $a1, $a1, 4095
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i16_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i16_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    ret
  %1 = zext i16 %a to i64
  ret i64 %1
}

define i64 @zext_i32_to_i64(i32 %a) {
; LA32R-LABEL: zext_i32_to_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: zext_i32_to_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: zext_i32_to_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 31, 0
; LA64-NEXT:    ret
  %1 = zext i32 %a to i64
  ret i64 %1
}

define i1 @trunc_i8_to_i1(i8 %a) {
; LA32R-LABEL: trunc_i8_to_i1:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i8_to_i1:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i8_to_i1:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i8 %a to i1
  ret i1 %1
}

define i1 @trunc_i16_to_i1(i16 %a) {
; LA32R-LABEL: trunc_i16_to_i1:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i16_to_i1:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i16_to_i1:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i16 %a to i1
  ret i1 %1
}

define i1 @trunc_i32_to_i1(i32 %a) {
; LA32R-LABEL: trunc_i32_to_i1:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i32_to_i1:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i32_to_i1:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i32 %a to i1
  ret i1 %1
}

define i1 @trunc_i64_to_i1(i64 %a) {
; LA32R-LABEL: trunc_i64_to_i1:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i64_to_i1:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i64_to_i1:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i64 %a to i1
  ret i1 %1
}

define i8 @trunc_i16_to_i8(i16 %a) {
; LA32R-LABEL: trunc_i16_to_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i16_to_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i16_to_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i16 %a to i8
  ret i8 %1
}

define i8 @trunc_i32_to_i8(i32 %a) {
; LA32R-LABEL: trunc_i32_to_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i32_to_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i32_to_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i32 %a to i8
  ret i8 %1
}

define i8 @trunc_i64_to_i8(i64 %a) {
; LA32R-LABEL: trunc_i64_to_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i64_to_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i64_to_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i64 %a to i8
  ret i8 %1
}

define i16 @trunc_i32_to_i16(i32 %a) {
; LA32R-LABEL: trunc_i32_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i32_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i32_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i32 %a to i16
  ret i16 %1
}

define i16 @trunc_i64_to_i16(i64 %a) {
; LA32R-LABEL: trunc_i64_to_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i64_to_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i64_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i64 %a to i16
  ret i16 %1
}

define i32 @trunc_i64_to_i32(i64 %a) {
; LA32R-LABEL: trunc_i64_to_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ret
;
; LA32S-LABEL: trunc_i64_to_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ret
;
; LA64-LABEL: trunc_i64_to_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ret
  %1 = trunc i64 %a to i32
  ret i32 %1
}
