; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lsx,-frecipe < %s | FileCheck %s --check-prefix=FAULT
; RUN: llc --mtriple=loongarch64 --mattr=+lsx,+frecipe < %s | FileCheck %s

;; 1.0 / (fsqrt vec)
define void @one_div_sqrt_v4f32(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_div_sqrt_v4f32:
; FAULT:       # %bb.0: # %entry
; FAULT-NEXT:    vld $vr0, $a1, 0
; FAULT-NEXT:    vfrsqrt.s $vr0, $vr0
; FAULT-NEXT:    vst $vr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL one_div_sqrt_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld	$vr0, $a1, 0
; CHECK-NEXT:    vfrsqrte.s	$vr1, $vr0
; CHECK-NEXT:    vfmul.s	$vr1, $vr0, $vr1
; CHECK-NEXT:    vfmul.s	$vr0, $vr0, $vr1
; CHECK-NEXT:    lu12i.w	$a1, -261120
; CHECK-NEXT:    vreplgr2vr.w	$vr2, $a1
; CHECK-NEXT:    vfmadd.s	$vr0, $vr0, $vr1, $vr2
; CHECK-NEXT:    lu12i.w	$a1, -266240
; CHECK-NEXT:    vreplgr2vr.w	$vr2, $a1
; CHECK-NEXT:    vfmul.s	$vr1, $vr1, $vr2
; CHECK-NEXT:    vfmul.s	$vr0, $vr1, $vr0
; CHECK-NEXT:    vst	$vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x float>, ptr %a0, align 16
  %sqrt = call fast <4 x float> @llvm.sqrt.v4f32 (<4 x float> %v0)
  %div = fdiv fast <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>, %sqrt
  store <4 x float> %div, ptr %res, align 16
  ret void
}

define void @one_div_sqrt_v2f64(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_div_sqrt_v2f64:
; FAULT:       # %bb.0: # %entry
; FAULT-NEXT:    vld $vr0, $a1, 0
; FAULT-NEXT:    vfrsqrt.d $vr0, $vr0
; FAULT-NEXT:    vst $vr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL one_div_sqrt_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld	$vr0, $a1, 0
; CHECK-NEXT:    vfrsqrte.d	$vr1, $vr0
; CHECK-NEXT:    vfmul.d	$vr1, $vr0, $vr1
; CHECK-NEXT:    vfmul.d	$vr2, $vr0, $vr1
; CHECK-NEXT:    ori	$a1, $zero, 0
; CHECK-NEXT:    lu32i.d	$a1, -524288
; CHECK-NEXT:    lu52i.d	$a1, $a1, -1024
; CHECK-NEXT:    vreplgr2vr.d	$vr3, $a1
; CHECK-NEXT:    vfmadd.d	$vr2, $vr2, $vr1, $vr3
; CHECK-NEXT:    lu52i.d	$a1, $zero, -1026
; CHECK-NEXT:    vreplgr2vr.d	$vr4, $a1
; CHECK-NEXT:    vfmul.d	$vr1, $vr1, $vr4
; CHECK-NEXT:    vfmul.d	$vr1, $vr1, $vr2
; CHECK-NEXT:    vfmul.d	$vr0, $vr0, $vr1
; CHECK-NEXT:    vfmadd.d	$vr0, $vr0, $vr1, $vr3
; CHECK-NEXT:    vfmul.d	$vr1, $vr1, $vr4
; CHECK-NEXT:    vfmul.d	$vr0, $vr1, $vr0
; CHECK-NEXT:    vst	$vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0, align 16
  %sqrt = call fast <2 x double> @llvm.sqrt.v2f64 (<2 x double> %v0)
  %div = fdiv fast <2 x double> <double 1.0, double 1.0>, %sqrt
  store <2 x double> %div, ptr %res, align 16
  ret void
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
