; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32, -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132 %s
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132-DPP %s

declare float @div.float.value()
declare float @div.double.value()

define amdgpu_kernel void @global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB0_2
; GFX7LESS-NEXT:  .LBB0_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB0_2
; GFX9-NEXT:  .LBB0_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB0_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB0_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX7LESS-DPP-NEXT:  .LBB0_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX9-DPP-NEXT:  .LBB0_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-DPP-NEXT:  .LBB0_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-DPP-NEXT:  .LBB0_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-DPP-NEXT:  .LBB0_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-DPP-NEXT:  .LBB0_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float 4.0 syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_uni_address_div_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7LESS-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    v_mul_f32_e64 v2, 1.0, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB1_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7LESS-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB1_4
; GFX7LESS-NEXT:  .LBB1_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX9-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e64 v2, s4, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB1_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB1_4
; GFX9-NEXT:  .LBB1_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1064-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1064-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB1_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB1_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB1_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB1_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB1_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB1_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB1_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 1.0, v0
; GFX7LESS-DPP-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB1_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_max_f32_e64 v6, s4, s4
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB1_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v0, v6
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB1_2
; GFX9-DPP-NEXT:  .LBB1_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 0
; GFX1064-DPP-NEXT:    v_max_f32_e64 v3, s2, s2
; GFX1064-DPP-NEXT:    v_max_f32_e64 v4, s3, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1064-DPP-NEXT:  .LBB1_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1032-DPP-NEXT:  .LBB1_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB1_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_div_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v1, v1, v1
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB1_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float %divValue syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB2_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB2_2
; GFX7LESS-NEXT:  .LBB2_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB2_2
; GFX9-NEXT:  .LBB2_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB2_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB2_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB2_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB2_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB2_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB2_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX7LESS-DPP-NEXT:  .LBB2_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX9-DPP-NEXT:  .LBB2_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-DPP-NEXT:  .LBB2_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-DPP-NEXT:  .LBB2_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-DPP-NEXT:  .LBB2_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_one_as_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-DPP-NEXT:  .LBB2_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float 4.0 syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1
  ret void
}


define amdgpu_kernel void @global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7LESS-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    v_mul_f32_e64 v2, 1.0, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB3_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB3_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7LESS-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB3_4
; GFX7LESS-NEXT:  .LBB3_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX9-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e64 v2, s4, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB3_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1064-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1064-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB3_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB3_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB3_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB3_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB3_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB3_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB3_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB3_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 1.0, v0
; GFX7LESS-DPP-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB3_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_max_f32_e64 v6, s4, s4
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB3_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v0, v6
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB3_2
; GFX9-DPP-NEXT:  .LBB3_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 0
; GFX1064-DPP-NEXT:    v_max_f32_e64 v3, s2, s2
; GFX1064-DPP-NEXT:    v_max_f32_e64 v4, s3, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1064-DPP-NEXT:  .LBB3_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1032-DPP-NEXT:  .LBB3_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB3_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_div_value_one_as_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v1, v1, v1
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB3_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float %divValue syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1
  ret void
}


define amdgpu_kernel void @global_atomic_fmax_uni_address_uni_value_default_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB4_2
; GFX7LESS-NEXT:  .LBB4_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB4_2
; GFX9-NEXT:  .LBB4_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB4_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB4_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB4_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB4_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX7LESS-DPP-NEXT:  .LBB4_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX9-DPP-NEXT:  .LBB4_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-DPP-NEXT:  .LBB4_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-DPP-NEXT:  .LBB4_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-DPP-NEXT:  .LBB4_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_default_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-DPP-NEXT:  .LBB4_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float 4.0 monotonic, align 4, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_uni_address_div_value_default_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7LESS-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    v_mul_f32_e64 v2, 1.0, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB5_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB5_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7LESS-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB5_4
; GFX7LESS-NEXT:  .LBB5_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX9-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e64 v2, s4, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v1, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB5_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB5_4
; GFX9-NEXT:  .LBB5_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1064-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1064-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB5_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB5_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1032-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB5_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB5_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f32_e64 v2, s3, s3
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB5_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB5_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f32_e64 v2, s2, s2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB5_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB5_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 1.0, v0
; GFX7LESS-DPP-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX9-DPP-NEXT:    v_max_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB5_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_max_f32_e64 v6, s4, s4
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB5_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v0, v6
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB5_2
; GFX9-DPP-NEXT:  .LBB5_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 0
; GFX1064-DPP-NEXT:    v_max_f32_e64 v3, s2, s2
; GFX1064-DPP-NEXT:    v_max_f32_e64 v4, s3, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1064-DPP-NEXT:  .LBB5_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x7fc00000, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX1032-DPP-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v1, v0, s[0:1]
; GFX1032-DPP-NEXT:  .LBB5_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB5_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_div_value_default_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x7fc00000, v0, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v1, v1, v1
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_dual_max_f32 v2, v3, v3 :: v_dual_mov_b32 v3, 0x7fc00000
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX1132-DPP-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB5_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float %divValue monotonic, align 4, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB6_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB6_2
; GFX7LESS-NEXT:  .LBB6_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB6_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_2
; GFX9-NEXT:  .LBB6_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB6_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-NEXT:  .LBB6_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB6_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-NEXT:  .LBB6_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB6_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1164-NEXT:  .LBB6_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB6_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1132-NEXT:  .LBB6_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX7LESS-DPP-NEXT:  .LBB6_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX9-DPP-NEXT:  .LBB6_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB6_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB6_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1164-DPP-NEXT:  .LBB6_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1132-DPP-NEXT:  .LBB6_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double 4.0 syncscope("agent") monotonic, align 8, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX7LESS-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB7_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB7_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX7LESS-NEXT:  .LBB7_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB7_4
; GFX7LESS-NEXT:  .LBB7_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX9-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX9-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB7_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB7_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB7_4
; GFX9-NEXT:  .LBB7_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1064-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB7_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1064-NEXT:  .LBB7_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1032-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB7_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1032-NEXT:  .LBB7_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1164-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB7_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB7_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB7_4
; GFX1164-NEXT:  .LBB7_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB7_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1132-NEXT:    s_cbranch_scc1 .LBB7_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB7_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX1132-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB7_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB7_4
; GFX1132-NEXT:  .LBB7_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[2:3], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_max_f64 v[4:5], v[0:1], v[0:1]
; GFX7LESS-DPP-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB7_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[1:2], s[0:1], s[0:1]
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[11:12], v[11:12]
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[9:10], v[1:2]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX9-DPP-NEXT:  .LBB7_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], s[4:5], s[4:5]
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], s[2:3], s[2:3]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB7_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB7_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB7_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1164-DPP-NEXT:  .LBB7_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, 0x7ff80000 :: v_dual_mov_b32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1132-DPP-NEXT:  .LBB7_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.double.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double %divValue syncscope("agent") monotonic, align 8, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB8_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB8_2
; GFX7LESS-NEXT:  .LBB8_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB8_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB8_2
; GFX9-NEXT:  .LBB8_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB8_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-NEXT:  .LBB8_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB8_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-NEXT:  .LBB8_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB8_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1164-NEXT:  .LBB8_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB8_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1132-NEXT:  .LBB8_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX7LESS-DPP-NEXT:  .LBB8_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX9-DPP-NEXT:  .LBB8_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB8_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB8_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1164-DPP-NEXT:  .LBB8_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_one_as_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1132-DPP-NEXT:  .LBB8_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double 4.0 syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX7LESS-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB9_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB9_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX7LESS-NEXT:  .LBB9_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB9_4
; GFX7LESS-NEXT:  .LBB9_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX9-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX9-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB9_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB9_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB9_4
; GFX9-NEXT:  .LBB9_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1064-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB9_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1064-NEXT:  .LBB9_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1032-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB9_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1032-NEXT:  .LBB9_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1164-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB9_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB9_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB9_4
; GFX1164-NEXT:  .LBB9_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB9_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1132-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB9_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX1132-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB9_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB9_4
; GFX1132-NEXT:  .LBB9_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[2:3], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_max_f64 v[4:5], v[0:1], v[0:1]
; GFX7LESS-DPP-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB9_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[1:2], s[0:1], s[0:1]
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[11:12], v[11:12]
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[9:10], v[1:2]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX9-DPP-NEXT:  .LBB9_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], s[4:5], s[4:5]
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], s[2:3], s[2:3]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB9_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB9_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB9_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB9_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1164-DPP-NEXT:  .LBB9_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_one_as_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, 0x7ff80000 :: v_dual_mov_b32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1132-DPP-NEXT:  .LBB9_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.double.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double %divValue syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB10_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB10_2
; GFX7LESS-NEXT:  .LBB10_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB10_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB10_2
; GFX9-NEXT:  .LBB10_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-NEXT:  .LBB10_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-NEXT:  .LBB10_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB10_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1164-NEXT:  .LBB10_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB10_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1132-NEXT:  .LBB10_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s7
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[4:7], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v5
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX7LESS-DPP-NEXT:  .LBB10_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX9-DPP-NEXT:  .LBB10_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB10_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0x40100000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB10_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1164-DPP-NEXT:  .LBB10_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_uni_value_default_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], 4.0
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1132-DPP-NEXT:  .LBB10_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double 4.0 monotonic, align 8, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX7LESS-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB11_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB11_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX7LESS-NEXT:  .LBB11_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB11_4
; GFX7LESS-NEXT:  .LBB11_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX9-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX9-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB11_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB11_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1064-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB11_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1064-NEXT:  .LBB11_4:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1032-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB11_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax_x2 v0, v[2:3], s[0:1]
; GFX1032-NEXT:  .LBB11_4:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1164-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB11_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB11_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB11_4
; GFX1164-NEXT:  .LBB11_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_max_f64 v[4:5], s[2:3], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    v_max_f64 v[4:5], v[2:3], v[4:5]
; GFX1132-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB11_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX1132-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB11_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB11_4
; GFX1132-NEXT:  .LBB11_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[2:3], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:    v_max_f64 v[4:5], v[0:1], v[0:1]
; GFX7LESS-DPP-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[2:3], v[2:3]
; GFX7LESS-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB11_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[7:8], v[7:8], v[7:8]
; GFX9-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX9-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f64 v[1:2], s[0:1], s[0:1]
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[11:12], v[11:12]
; GFX9-DPP-NEXT:    v_max_f64 v[9:10], v[9:10], v[1:2]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX9-DPP-NEXT:  .LBB11_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], s[4:5], s[4:5]
; GFX1064-DPP-NEXT:    v_max_f64 v[5:6], s[2:3], s[2:3]
; GFX1064-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1064-DPP-NEXT:  .LBB11_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x7ff80000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[3:4]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0x7ff80000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_max_f64 v[5:6], v[5:6], v[5:6]
; GFX1032-DPP-NEXT:    v_max_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax_x2 v2, v[0:1], s[0:1]
; GFX1032-DPP-NEXT:  .LBB11_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 0x7ff80000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1164-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1164-DPP-NEXT:  .LBB11_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_double_uni_address_div_value_default_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, 0x7ff80000 :: v_dual_mov_b32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x7ff80000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 0x7ff80000 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX1132-DPP-NEXT:    v_max_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[8:9], v[8:9]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_max_f64 v[6:7], v[6:7], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1132-DPP-NEXT:  .LBB11_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.double.value()
  %result = atomicrmw fmax ptr addrspace(1) %ptr, double %divValue monotonic, align 8, !amdgpu.no.fine.grained.memory !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr addrspace(1) %ptr) {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB12_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB12_2
; GFX7LESS-NEXT:  .LBB12_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB12_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB12_2
; GFX9-NEXT:  .LBB12_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB12_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB12_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB12_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB12_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB12_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB12_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX7LESS-DPP-NEXT:  .LBB12_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX9-DPP-NEXT:  .LBB12_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB12_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-DPP-NEXT:  .LBB12_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB12_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-DPP-NEXT:  .LBB12_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-DPP-NEXT:  .LBB12_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-DPP-NEXT:  .LBB12_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float 4.0  monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.no.remote.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr addrspace(1) %ptr) {
; GFX7LESS-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB13_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB13_2
; GFX7LESS-NEXT:  .LBB13_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB13_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB13_2
; GFX9-NEXT:  .LBB13_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB13_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-NEXT:  .LBB13_2:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB13_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-NEXT:  .LBB13_2:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB13_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB13_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB13_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB13_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v0, 1.0, v1
; GFX7LESS-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX7LESS-DPP-NEXT:  .LBB13_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, v1, v1
; GFX9-DPP-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX9-DPP-NEXT:  .LBB13_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB13_2
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1064-DPP-NEXT:  .LBB13_2:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB13_2
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_atomic_fmax v0, v1, s[0:1]
; GFX1032-DPP-NEXT:  .LBB13_2:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB13_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1164-DPP-NEXT:  .LBB13_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fmax_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB13_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_max_f32 v0, v1, s[0:1]
; GFX1132-DPP-NEXT:  .LBB13_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fmax ptr addrspace(1) %ptr, float 4.0  monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.no.remote.memory !1
  ret void
}

attributes #0 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" }

!1 = !{}

