#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <pybind11/functional.h>

#include "icsneo/communication/network.h"

namespace icsneo {

void init_network(pybind11::module_& m) {
	pybind11::class_<Network> network(m, "Network");

	pybind11::enum_<Network::NetID>(network, "NetID")
		.value("Device", Network::NetID::Device)
		.value("DWCAN_01", Network::NetID::DWCAN_01)
		.value("DWCAN_08", Network::NetID::DWCAN_08)
		.value("SWCAN_01", Network::NetID::SWCAN_01)
		.value("LSFTCAN_01", Network::NetID::LSFTCAN_01)
		.value("FordSCP", Network::NetID::FordSCP)
		.value("J1708", Network::NetID::J1708)
		.value("Aux", Network::NetID::Aux)
		.value("J1850VPW", Network::NetID::J1850VPW)
		.value("ISO9141_01", Network::NetID::ISO9141_01)
		.value("DiskData", Network::NetID::DiskData)
		.value("Main51", Network::NetID::Main51)
		.value("RED", Network::NetID::RED)
		.value("SCI", Network::NetID::SCI)
		.value("ISO9141_02", Network::NetID::ISO9141_02)
		.value("ISO14230", Network::NetID::ISO14230)
		.value("LIN_01", Network::NetID::LIN_01)
		.value("AE_01", Network::NetID::AE_01)
		.value("AE_02", Network::NetID::AE_02)
		.value("AE_03", Network::NetID::AE_03)
		.value("RED_EXT_MEMORYREAD", Network::NetID::RED_EXT_MEMORYREAD)
		.value("RED_INT_MEMORYREAD", Network::NetID::RED_INT_MEMORYREAD)
		.value("RED_DFLASH_READ", Network::NetID::RED_DFLASH_READ)
		.value("NeoMemorySDRead", Network::NetID::NeoMemorySDRead)
		.value("CAN_ERRBITS", Network::NetID::CAN_ERRBITS)
		.value("NeoMemoryWriteDone", Network::NetID::NeoMemoryWriteDone)
		.value("RED_WAVE_CAN1_LOGICAL", Network::NetID::RED_WAVE_CAN1_LOGICAL)
		.value("RED_WAVE_CAN2_LOGICAL", Network::NetID::RED_WAVE_CAN2_LOGICAL)
		.value("RED_WAVE_LIN1_LOGICAL", Network::NetID::RED_WAVE_LIN1_LOGICAL)
		.value("RED_WAVE_LIN2_LOGICAL", Network::NetID::RED_WAVE_LIN2_LOGICAL)
		.value("RED_WAVE_LIN1_ANALOG", Network::NetID::RED_WAVE_LIN1_ANALOG)
		.value("RED_WAVE_LIN2_ANALOG", Network::NetID::RED_WAVE_LIN2_ANALOG)
		.value("RED_WAVE_MISC_ANALOG", Network::NetID::RED_WAVE_MISC_ANALOG)
		.value("RED_WAVE_MISCDIO2_LOGICAL", Network::NetID::RED_WAVE_MISCDIO2_LOGICAL)
		.value("RED_NETWORK_COM_ENABLE_EX", Network::NetID::RED_NETWORK_COM_ENABLE_EX)
		.value("RED_NEOVI_NETWORK", Network::NetID::RED_NEOVI_NETWORK)
		.value("RED_READ_BAUD_SETTINGS", Network::NetID::RED_READ_BAUD_SETTINGS)
		.value("RED_OLDFORMAT", Network::NetID::RED_OLDFORMAT)
		.value("RED_SCOPE_CAPTURE", Network::NetID::RED_SCOPE_CAPTURE)
		.value("RED_HARDWARE_EXCEP", Network::NetID::RED_HARDWARE_EXCEP)
		.value("RED_GET_RTC", Network::NetID::RED_GET_RTC)
		.value("ISO9141_03", Network::NetID::ISO9141_03)
		.value("DWCAN_02", Network::NetID::DWCAN_02)
		.value("DWCAN_03", Network::NetID::DWCAN_03)
		.value("AE_04", Network::NetID::AE_04)
		.value("AE_05", Network::NetID::AE_05)
		.value("ISO9141_04", Network::NetID::ISO9141_04)
		.value("LIN_02", Network::NetID::LIN_02)
		.value("LIN_03", Network::NetID::LIN_03)
		.value("LIN_04", Network::NetID::LIN_04)
		.value("RED_App_Error", Network::NetID::RED_App_Error)
		.value("CGI", Network::NetID::CGI)
		.value("Reset_Status", Network::NetID::Reset_Status)
		.value("FB_Status", Network::NetID::FB_Status)
		.value("App_Signal_Status", Network::NetID::App_Signal_Status)
		.value("Read_Datalink_Cm_Tx_Msg", Network::NetID::Read_Datalink_Cm_Tx_Msg)
		.value("Read_Datalink_Cm_Rx_Msg", Network::NetID::Read_Datalink_Cm_Rx_Msg)
		.value("Logging_Overflow", Network::NetID::Logging_Overflow)
		.value("ReadSettings", Network::NetID::ReadSettings)
		.value("DWCAN_04", Network::NetID::DWCAN_04)
		.value("DWCAN_05", Network::NetID::DWCAN_05)
		.value("RS232", Network::NetID::RS232)
		.value("UART_01", Network::NetID::UART_01)
		.value("UART_02", Network::NetID::UART_02)
		.value("UART_03", Network::NetID::UART_03)
		.value("UART_04", Network::NetID::UART_04)
		.value("SWCAN_02", Network::NetID::SWCAN_02)
		.value("ETHERNET_DAQ", Network::NetID::ETHERNET_DAQ)
		.value("Data_To_Host", Network::NetID::Data_To_Host)
		.value("TextAPI_To_Host", Network::NetID::TextAPI_To_Host)
		.value("SPI_01", Network::NetID::SPI_01)
		.value("AE_06", Network::NetID::AE_06)
		.value("Red_VBat", Network::NetID::Red_VBat)
		.value("AE_07", Network::NetID::AE_07)
		.value("AE_08", Network::NetID::AE_08)
		.value("AE_09", Network::NetID::AE_09)
		.value("AE_10", Network::NetID::AE_10)
		.value("AE_11", Network::NetID::AE_11)
		.value("FLEXRAY_01A", Network::NetID::FLEXRAY_01A)
		.value("FLEXRAY_01B", Network::NetID::FLEXRAY_01B)
		.value("FLEXRAY_02A", Network::NetID::FLEXRAY_02A)
		.value("FLEXRAY_02B", Network::NetID::FLEXRAY_02B)
		.value("LIN_05", Network::NetID::LIN_05)
		.value("FLEXRAY_01", Network::NetID::FLEXRAY_01)
		.value("FLEXRAY_02", Network::NetID::FLEXRAY_02)
		.value("AE_12", Network::NetID::AE_12)
		.value("I2C_01", Network::NetID::I2C_01)
		.value("MOST_25", Network::NetID::MOST_25)
		.value("MOST_50", Network::NetID::MOST_50)
		.value("MOST_150", Network::NetID::MOST_150)
		.value("ETHERNET_01", Network::NetID::ETHERNET_01)
		.value("GMFSA", Network::NetID::GMFSA)
		.value("TCP", Network::NetID::TCP)
		.value("DWCAN_06", Network::NetID::DWCAN_06)
		.value("DWCAN_07", Network::NetID::DWCAN_07)
		.value("LIN_06", Network::NetID::LIN_06)
		.value("LSFTCAN_02", Network::NetID::LSFTCAN_02)
		.value("LogicalDiskInfo", Network::NetID::LogicalDiskInfo)
		.value("WiVICommand", Network::NetID::WiVICommand)
		.value("ScriptStatus", Network::NetID::ScriptStatus)
		.value("EthPHYControl", Network::NetID::EthPHYControl)
		.value("ExtendedCommand", Network::NetID::ExtendedCommand)
		.value("ExtendedData", Network::NetID::ExtendedData)
		.value("FlexRayControl", Network::NetID::FlexRayControl)
		.value("CoreMiniPreLoad", Network::NetID::CoreMiniPreLoad)
		.value("HW_COM_Latency_Test", Network::NetID::HW_COM_Latency_Test)
		.value("DeviceStatus", Network::NetID::DeviceStatus)
		.value("UDP", Network::NetID::UDP)
		.value("ForwardedMessage", Network::NetID::ForwardedMessage)
		.value("I2C_02", Network::NetID::I2C_02)
		.value("I2C_03", Network::NetID::I2C_03)
		.value("I2C_04", Network::NetID::I2C_04)
		.value("ETHERNET_02", Network::NetID::ETHERNET_02)
		.value("ETHERNET_TX_WRAP", Network::NetID::ETHERNET_TX_WRAP)
		.value("A2B_01", Network::NetID::A2B_01)
		.value("A2B_02", Network::NetID::A2B_02)
		.value("ETHERNET_03", Network::NetID::ETHERNET_03)
		.value("WBMS_01", Network::NetID::WBMS_01)
		.value("DWCAN_09", Network::NetID::DWCAN_09)
		.value("DWCAN_10", Network::NetID::DWCAN_10)
		.value("DWCAN_11", Network::NetID::DWCAN_11)
		.value("DWCAN_12", Network::NetID::DWCAN_12)
		.value("DWCAN_13", Network::NetID::DWCAN_13)
		.value("DWCAN_14", Network::NetID::DWCAN_14)
		.value("DWCAN_15", Network::NetID::DWCAN_15)
		.value("DWCAN_16", Network::NetID::DWCAN_16)
		.value("LIN_07", Network::NetID::LIN_07)
		.value("LIN_08", Network::NetID::LIN_08)
		.value("SPI_02", Network::NetID::SPI_02)
		.value("MDIO_01", Network::NetID::MDIO_01)
		.value("MDIO_02", Network::NetID::MDIO_02)
		.value("MDIO_03", Network::NetID::MDIO_03)
		.value("MDIO_04", Network::NetID::MDIO_04)
		.value("MDIO_05", Network::NetID::MDIO_05)
		.value("MDIO_06", Network::NetID::MDIO_06)
		.value("MDIO_07", Network::NetID::MDIO_07)
		.value("MDIO_08", Network::NetID::MDIO_08)
		.value("AE_13", Network::NetID::AE_13)
		.value("AE_14", Network::NetID::AE_14)
		.value("AE_15", Network::NetID::AE_15)
		.value("AE_16", Network::NetID::AE_16)
		.value("SPI_03", Network::NetID::SPI_03)
		.value("SPI_04", Network::NetID::SPI_04)
		.value("SPI_05", Network::NetID::SPI_05)
		.value("SPI_06", Network::NetID::SPI_06)
		.value("SPI_07", Network::NetID::SPI_07)
		.value("SPI_08", Network::NetID::SPI_08)
		.value("LIN_09", Network::NetID::LIN_09)
		.value("LIN_10", Network::NetID::LIN_10)
		.value("LIN_11", Network::NetID::LIN_11)
		.value("LIN_12", Network::NetID::LIN_12)
		.value("LIN_13", Network::NetID::LIN_13)
		.value("LIN_14", Network::NetID::LIN_14)
		.value("LIN_15", Network::NetID::LIN_15)
		.value("LIN_16", Network::NetID::LIN_16)
		.value("Any", Network::NetID::Any)
		.value("Invalid", Network::NetID::Invalid);
	
	pybind11::enum_<Network::Type>(network, "Type")
		.value("Invalid", Network::Type::Invalid)
		.value("Internal", Network::Type::Internal)
		.value("CAN", Network::Type::CAN)
		.value("LIN", Network::Type::LIN)
		.value("FlexRay", Network::Type::FlexRay)
		.value("MOST", Network::Type::MOST)
		.value("Ethernet", Network::Type::Ethernet)
		.value("LSFTCAN", Network::Type::LSFTCAN)
		.value("SWCAN", Network::Type::SWCAN)
		.value("ISO9141", Network::Type::ISO9141)
		.value("I2C_01", Network::Type::I2C)
		.value("A2B", Network::Type::A2B)
		.value("SPI", Network::Type::SPI)
		.value("MDIO", Network::Type::MDIO)
		.value("Any", Network::Type::Any)
		.value("Other", Network::Type::Other);

    network
		.def(pybind11::init<Network::NetID>())
		.def("__repr__", [](Network& self) { return Network::GetNetIDString(self.getNetID()); })
		.def_static("get_net_id_string", &Network::GetNetIDString, pybind11::arg("netid"), pybind11::arg("expand") = true)
		.def("get_net_id", &Network::getNetID)
		.def("get_type", &Network::getType);
}

} // namespace icsneo 

