;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --closed-world --preserve-type-order \
;; RUN:     --type-merging --remove-unused-types -S -o - | filecheck %s

;; $A1 and $A2 can be merged, and $B1/$B2, as they have identical continuation
;; fields. But $A*/B* cannot be merged, as the continuations differ.

(module
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $f (func))
  (type $f (func))
  ;; CHECK:       (type $k (cont $f))
  (type $k (cont $f))

  ;; CHECK:       (type $f-i32 (func (result i32)))
  (type $f-i32 (func (result i32)))
  ;; CHECK:       (type $k-i32 (cont $f-i32))
  (type $k-i32 (cont $f-i32))

  (rec
    ;; CHECK:       (type $A1 (struct (field (ref $k))))
    (type $A1 (struct (ref $k)))
    (type $A2 (struct (ref $k)))
    ;; CHECK:       (type $B1 (struct (field (ref $k-i32))))
    (type $B1 (struct (ref $k-i32)))
    (type $B2 (struct (ref $k-i32)))
  )

  ;; CHECK:      (func $test (type $f)
  ;; CHECK-NEXT:  (local $k (ref $k))
  ;; CHECK-NEXT:  (local $k-i32 (ref $k-i32))
  ;; CHECK-NEXT:  (local $a1 (ref $A1))
  ;; CHECK-NEXT:  (local $a2 (ref $A1))
  ;; CHECK-NEXT:  (local $b1 (ref $B1))
  ;; CHECK-NEXT:  (local $b2 (ref $B1))
  ;; CHECK-NEXT: )
  (func $test
    (local $k (ref $k))
    (local $k-i32 (ref $k-i32))
    (local $a1 (ref $A1))
    (local $a2 (ref $A2))
    (local $b1 (ref $B1))
    (local $b2 (ref $B2))
  )
)

