/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// TGUI - Texus' Graphical User Interface
// Copyright (C) 2012-2024 Bruno Van de Velde (vdv_b@tgui.eu)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef TGUI_SCROLLBAR_RENDERER_HPP
#define TGUI_SCROLLBAR_RENDERER_HPP

#include <TGUI/Renderers/WidgetRenderer.hpp>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

TGUI_MODULE_EXPORT namespace tgui
{
    class TGUI_API ScrollbarRenderer : public WidgetRenderer
    {
    public:

        using WidgetRenderer::WidgetRenderer;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the track
        ///
        /// @param color  The new track color
        ///
        /// Note that this color is ignored when the track texture is set.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTrackColor(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the track
        ///
        /// @return Track color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getTrackColor() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the track in hover state (when the mouse is on top of it)
        ///
        /// @param color  The new hover track color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTrackColorHover(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the track in hover state (when the mouse is on top of it)
        ///
        /// @return Hover track color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getTrackColorHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the thumb
        ///
        /// @param color  The new thumb color
        ///
        /// Note that this color is ignored when the thumb texture is set.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setThumbColor(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the thumb
        ///
        /// @return Thumb color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getThumbColor() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the thumb in hover state (when the mouse is on top of it)
        ///
        /// @param color  The new hover thumb color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setThumbColorHover(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the thumb in hover state (when the mouse is on top of it)
        ///
        /// @return Hover thumb color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getThumbColorHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color behind the arrow
        ///
        /// @param color  The new arrow background color
        ///
        /// Note that this color is ignored when the arrow up and down textures are set.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setArrowBackgroundColor(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color behind the arrow
        ///
        /// @return Arrow background color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getArrowBackgroundColor() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color behind the arrow in hover state (when the mouse is on top of it)
        ///
        /// @param color  The new hover arrow background color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setArrowBackgroundColorHover(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color behind the arrow in hover state (when the mouse is on top of it)
        ///
        /// @return Hover arrow background color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getArrowBackgroundColorHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the arrow
        ///
        /// @param color  The new arrow color
        ///
        /// Note that this color is ignored when the arrow up and down textures are set.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setArrowColor(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the arrow
        ///
        /// @return Arrow color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getArrowColor() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the arrow in hover state (when the mouse is on top of it)
        ///
        /// @param color  The new hover arrow color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setArrowColorHover(Color color);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the arrow in hover state (when the mouse is on top of it)
        ///
        /// @return Hover arrow color
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD Color getArrowColorHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the track
        ///
        /// @param texture  The new track texture
        ///
        /// When this texture is set then the track color will be ignored.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureTrack(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the track
        ///
        /// @return Track texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureTrack() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the track that is displayed when the mouse is on top of it
        ///
        /// @param texture  The new hover track texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureTrackHover(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the track that is displayed when the mouse is on top of it
        ///
        /// @return Hover track texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureTrackHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the thumb
        ///
        /// @param texture  The new thumb texture
        ///
        /// When this texture is set then the thumb color will be ignored
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureThumb(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the thumb
        ///
        /// @return Thumb texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureThumb() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the thumb that is displayed when the mouse is on top of it
        ///
        /// @param texture  The new hover thumb texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureThumbHover(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the thumb that is displayed when the mouse is on top of it
        ///
        /// @return Hover thumb texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureThumbHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the up arrow
        ///
        /// @param texture  The new up arrow texture
        ///
        /// When this texture is set then the arrow background color and arrow color will be ignored for the up arrow
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureArrowUp(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the up arrow
        ///
        /// @return Up arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureArrowUp() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the up arrow that is displayed when the mouse is on top of it
        ///
        /// @param texture  The new hover up arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureArrowUpHover(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the up arrow that is displayed when the mouse is on top of it
        ///
        /// @return Hover up arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureArrowUpHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the down arrow
        ///
        /// @param texture  The new down arrow texture
        ///
        /// When this texture is set then the arrow background color and arrow color will be ignored for the down arrow
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureArrowDown(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the down arrow
        ///
        /// @return Down arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureArrowDown() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the down arrow that is displayed when the mouse is on top of it
        ///
        /// @param texture  The new hover down arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureArrowDownHover(const Texture& texture);

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the down arrow that is displayed when the mouse is on top of it
        ///
        /// @return Hover down arrow texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        TGUI_NODISCARD const Texture& getTextureArrowDownHover() const;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    };

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif // TGUI_SCROLLBAR_RENDERER_HPP
